<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $subtitulo ?></h5>
                            <div class="d-flex">
								<?php
								if (in_array("ACOCOB", $permisos)) 
								{
								?>
                                <button class="btn bg-sistema d-flex justify-content-center align-items-center mx-1 color-white" data-bs-target="#mdlRegistrarCondonacionCobranza" data-form="#formRegistrarCondonacionCobranza" id="btnRegistrarCondonacionCobranza" data-toggle="tooltip" data-placement="top" title="Registrar Condonación" aria-label="Registrar Condonación">
									<i class="mdi mdi-plus-circle me-1" style="font-size: 14px;"></i>Nuevo
								</button>
								<?php
								}
								?>
								<button type="button" class="btn bg-filtros color-white px-2 py-1 mx-1 waves-effect waves-light layout-rightside-btn" data-bs-toggle="offcanvas" data-bs-target="#theme-settings-offcanvas" aria-controls="theme-settings-offcanvas">
                                    <i class="mdi mdi-filter" style="font-size: 18px;"></i>
                                </button>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblPreCondonacionesCobranza" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->

<?= $this->section('js'); ?>
<script>
	$(function () {
		/***SERVERSIDE LISTADO DE CONDONACIONES COBRANZAS***/
		assetListVM = {
			dt: null,
			init: function () {
				dt = $('#tblPreCondonacionesCobranza').DataTable({
					"serverSide": true,
					"processing": true,
					"ajax": {
						"url": baseUrl + "/condonaciones-cobranzas-serverside",
						type: 'POST',
						data: function(d) {
						    let rutavista = window.location.href;
						    let arrayrutavista = rutavista.split("/");
						    d.url_vista = arrayrutavista[arrayrutavista.length-1];
						}
					},
					"columns": [
						{"title": "Código", "data": "IDSolicitudCobranza", "class": "text-center", "searchable": true },
						{"title": "Fecha Registro", "data": "FechaRegistro", "class": "text-center", "searchable": true },
						{"title": "Contrato", "data": "NroContrato", "class": "text-center", "searchable": true },
						{"title": "Cartera", "data": "Cartera", "class": "text-center", "searchable": true },
						{"title": "Deuda Vencida", "data": "MontoDeudaVencida", "class": "text-center", "searchable": true },
						{"title": "Importe a Condonar", "data": "ImporteCondonar", "class": "text-center", "searchable": true },
						{"title": "% Descuento", "data": "PorcentajeDescuento", "class": "text-center", "searchable": true },
						{"title": "Mes de Campaña", "data": "MesCampana", "class": "text-center", "searchable": true },
						{"title": "Compromiso de Pago", "data": "CompromisoPago", "class": "text-center", "searchable": true },
						{"title": "Comentarios", "data": "Observacion", "class": "text-center", "searchable": true },
						{"title": "Acciones", "data": "acciones", "class": "text-center", "searchable": false, "orderable": false },
					],
                    "drawCallback": function(settings) {
                        // Re-inicializar tooltips después de que los datos son cargados
                        $('[data-tooltip="tooltip"]').tooltip();
                        $('[data-toggle="tooltip"]').tooltip();
                    },
					"lengthMenu": [[10, 25, 50], [10, 25, 50]],
					responsive: true,
					autoWidth: false,
					"pageLength": 10,
					"paging": true,
					"aaSorting": [[0, 'desc']],
				});
			}
		}

		assetListVM.init();
		/****FIN SERVERSIDE LISTADO DE CONDONACIONES COBRANZAS****/
		
		var sliderInstance;
		var maxAutorizado = 0;
		var valorBase = 0;
        
        $(document).on('click', '#btnRegistrarCondonacionCobranza', function() 
        {
            var modal       = $(this).data('bs-target');
            var formulario  = $(this).data('form');
            
            $('[data-tooltip="tooltip"]').tooltip();
            $('[data-toggle="tooltip"]').tooltip();
            
            $(modal).modal("show");
        });
        
        $(document).on('click', '#btnBuscarContratoCondonacionCobranza', function() 
        {
            var nroContrato = $("#txtNroContrato_rcondcobr").val();
            
            if(nroContrato == '')
            {
                Swal.fire({
                    html: 'Debe ingresar el Nro de Contrato a buscar.',
                    heightAuto: true,
                    showConfirmButton: true
                });
            }
            else
            {
                Swal.fire({
                    html: 'Un momento por favor...',
                    heightAuto: true,
                    showConfirmButton: false
                });
                
                $.post(baseUrl + '/obtener-datos-matriz-condonacion-cobranza', 
                {         
                    nroContrato : nroContrato
                }, 
                function(response) 
                {
                    Swal.close();
                
                    if (response.sesion === 0) 
                    {
                        Swal.fire({
                            title: 'Por favor, vuelva a iniciar sesión.',
                            icon: 'warning',
                            showCancelButton: false,
                            confirmButtonColor: '#282E38',
                            confirmButtonText: 'Confirmar'
                        });
                    } 
                    else if (response.descripcion === 0) 
                    {
                        Swal.fire({
                            title: 'No se encontró la información solicitada',
                            icon: 'warning',
                            showCancelButton: false,
                            confirmButtonColor: '#282E38',
                            confirmButtonText: 'Confirmar'
                        });
                    } 
                    else if (response.error === 1) 
                    {
                        Swal.fire({
                            title: response.msg,
                            icon: 'error',
                            showCancelButton: false,
                            confirmButtonColor: '#282E38',
                            confirmButtonText: 'Confirmar'
                        });
                    }
                    else 
                    {
                        $('#txtClienteCondonacionCobranza_rcondcobr').val(response.cliente);
                        $('#txtNIFCondonacionCobranza_rcondcobr').val(response.nif);
                        $('#txtDeudaVencidaCondonacionCobranza_rcondcobr').val(response.deuda);
                        $('#cboCartera_rcondcobr').val(response.cartera).trigger('change');
                        $('#txtExisteMatriz_rcondcobr').val("EXISTE");
                        $("#txtMaximoPorcentajeCondonarCobranza_rcondcobr").val(response.descuento);
                        
                        maxAutorizado = parseInt(response.descuento) || defaultMaxAutorizado;
                        valorBase = parseFloat(response.deuda) || 0;
                        
                        // Actualizar el texto
                        $maximoSpan.text(maxAutorizado + '%');
                        console.log("maxAutorizado: "+maxAutorizado);
                        // Forzar actualización del resultado con el valor actual del slider
                        var valorActual = parseInt(sliderInstance.get());
                        actualizarResultado(valorActual);
        
                    }
                }, 'json');
            }
        });
        
        $(document).on('keydown', '#txtNroContrato_rcondcobr', function(e) 
        {
            if (e.key === 'Enter') 
            {
                e.preventDefault(); // Evita enviar formulario u otras acciones por defecto
                $('#btnBuscarContratoCondonacionCobranza').trigger('click');
            }
        });
        
		$('#cboCartera_rcondcobr').select2({
            dropdownParent: $('#mdlRegistrarCondonacionCobranza .modal-body')
        });
        
        /****** VALOR SLIDER ******/
        
        var $slider         = $('#slidePorcentajeCondonarCobranza');
        var $inputHidden    = $('#txtPorcentajeCondonarCobranza_rcondcobr');

        var $valorSpan      = $('#valorPorcentajeCondonarCobranza');
        var $minimoSpan     = $('#minimoPorcentajeCondonarCobranza');
        var $maximoSpan     = $('#maximoPorcentajeCondonarCobranza');
        var $topeSpan       = $('#topePorcentajeCondonarCobranza');

        var min = 0;
        var tope = 100; // tope es fijo
        var defaultMaxAutorizado = 30; // mientras llega el AJAX

        maxAutorizado = defaultMaxAutorizado;
        
        // Mostrar valores iniciales
        $minimoSpan.text(min + '%');
        $topeSpan.text(tope + '%');
        $maximoSpan.text(maxAutorizado + '%');
        
        // Crear el slider
        noUiSlider.create($slider[0], {
            start: [0],
            connect: [true, false],
            range: {
                'min': min,
                'max': tope // SIEMPRE es 100
            },
            step: 1,
            tooltips: true,
            format: {
                to: function (value) {
                    return Math.round(value) + '%';
                },
                from: function (value) {
                    return Number(value.replace('%', ''));
                }
            }
        });

        sliderInstance = $slider[0].noUiSlider;
        
        // Función que actualiza el resultado
        function actualizarResultado(valorSlider) 
        {
            let porcentaje = valorSlider / 100;
            let resultado = valorBase * porcentaje;
            resultado = parseFloat(resultado.toFixed(2));
            
            $("#txtImporteCondonarCobranza_rcondcobr").val(resultado);
        }
        
        // Evento de cambio de valor
        sliderInstance.on('update', function (values, handle) {
            var valor = parseInt(values[handle]);
            $valorSpan.text(valor + '%');
            $inputHidden.val(valor);

            // Mostrar rojo si pasa el máximo autorizado
            if (valor > maxAutorizado) 
            {
                $valorSpan.addClass('text-danger fw-bold');
                $("#txtEvaluacionMatriz_rcondcobr").val("FUERA");
            } 
            else 
            {
                $valorSpan.removeClass('text-danger fw-bold');
                $("#txtEvaluacionMatriz_rcondcobr").val("DENTRO");
            }
            
            // Actualizar resultado condonado
            actualizarResultado(valor);
        });
	});
</script>
<?php $this->endSection(); ?>

<!-- Filtros -->

<div class="offcanvas offcanvas-end border-0" tabindex="-1" id="theme-settings-offcanvas" aria-modal="true" role="dialog">
    <div class="d-flex align-items-center bg-filtros bg-gradient p-3 offcanvas-header">
        <h5 class="m-0 me-2 text-white">Filtros</h5>

        <button type="button" class="btn-close btn-close-white ms-auto" id="customizerclose-btn" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body p-0">
        <!--<div data-simplebar="init" class="h-100 simplebar-scrollable-y">-->
        <!--    <div class="simplebar-wrapper" style="margin: 0px;">-->
        <!--        <div class="simplebar-height-auto-observer-wrapper">-->
        <!--            <div class="simplebar-height-auto-observer">-->
                        
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="simplebar-mask">-->
        <!--            <div class="simplebar-offset" style="right: 0px; bottom: 0px;">-->
        <!--                <div class="simplebar-content-wrapper" tabindex="0" role="region" aria-label="scrollable content" style="height: 100%; overflow: hidden scroll;">-->
        <!--                    <div class="simplebar-content" style="padding: 0px;">-->
            <div id="ctnFiltro" class="p-3">
				<div class="card border" style="border-top: 3px #536878 solid!important;">
					<div class="card-header">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h6 class="card-title mb-0">Columnas</h6>
                            </div>
                            <div class="flex-shrink-0">
                                <ul class="list-inline card-toolbar-menu d-flex align-items-center mb-0">
                                    <li class="list-inline-item">
                                        <a class="align-middle minimize-card" data-bs-toggle="collapse" href="#collapseColumnasFiltros" role="button" aria-expanded="true" aria-controls="collapseColumnasFiltros">
                                            <i class="mdi mdi-plus align-middle plus"></i>
                                            <i class="mdi mdi-minus align-middle minus"></i>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
					<div class="card-body collapse show" id="collapseColumnasFiltros" style="">
						cxcvcxxvxcxcv
					</div>
				</div>
				<div class="panel">
                    <div class="panel-heading">
                        <h4>Columnas</h4>
                    </div>
                    <div class="panel-content">
                        <div class="row">
                            adasasads
                        </div>
                    </div>
                </div>
            </div>
        <!--                    </div>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="simplebar-placeholder" style="width: 400px; height: 1978px;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="simplebar-track simplebar-horizontal" style="visibility: hidden;">-->
        <!--        <div class="simplebar-scrollbar" style="width: 0px; display: none;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="simplebar-track simplebar-vertical" style="visibility: visible;">-->
        <!--        <div class="simplebar-scrollbar" style="height: 314px; transform: translate3d(0px, 0px, 0px); display: block;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--</div>-->
    </div>
    <div class="offcanvas-footer border-top p-3 text-center">
        <div class="row">
            <div class="col-4">
                <button type="button" class="btn btn-light w-100" id="btnLimpiar">Limpiar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-danger w-100" id="btnCerrarFiltros" data-bs-dismiss="offcanvas" aria-label="Close">Cerrar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-primary w-100" id="btnBuscarFiltros">Buscar</button>
            </div>
        </div>
    </div>
</div>


<!-- Modal Registrar Condonación Cobranza-->
<div class="modal fade zoomIn" id="mdlRegistrarCondonacionCobranza" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="examplemdlRegistrarCondonacionCobranza" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplemdlRegistrarCondonacionCobranza">Registrar Condonación</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formRegistrarCondonacionCobranza" class="formularioRegistrarCondonacionCobranza formulario" autocomplete="off" action="<?= $baseUrl ?>/registrar-condonacion-cobranza" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
                    <div>
                        <div class="row col-12 m-0 p-0 mb-3 d-flex">
    						<div class="col-xxl-12 col-md-12 col-12 px-3">
    							<div>
    								<label class="form-label" >Fecha Solicitud</label>
    								<input type="text" class="form-control" value="<?= date("d-m-Y") ?>" disabled >
    							</div>
    						</div>
					    </div>
                        <div class="row col-12 m-0 p-0 mb-3 d-flex">
    						<div class="col-xxl-4 col-md-12 col-12 px-3">
    							<div>
    								<label class="form-label" >Nombre Solicitante</label>
    								<input type="text" class="form-control" value="<?= ucwords(mb_strtolower($usuarioSolicitante['Nombres'])) ?>" disabled >
    							</div>
    						</div>
					        <div class="col-xxl-4 col-md-12 col-12 px-3">
    							<div>
    								<label class="form-label">Apellido Solicitante</label>
    								<input type="text" class="form-control" value="<?= ucwords(mb_strtolower($usuarioSolicitante['Apellidos'])) ?>" disabled >
    							</div>
    						</div>
    						<div class="col-xxl-4 col-md-12 col-12 px-3">
    							<div>
    								<label class="form-label" >Matrícula Solicitante</label>
    								<input type="text" class="form-control" style="color: #0000FF" value="<?= $usuarioSolicitante['Matricula'] ?>" disabled >
    							</div>
    						</div>
					    </div>
                        <div class="row col-12 m-0 p-0 mb-3 d-flex">
    						<div class="col-xxl-4 col-md-12 col-12 px-3">
    							<div>
    								<label class="form-label" >Dirección</label>
    								<input type="text" class="form-control" value="<?= ucwords(mb_strtolower($usuarioSolicitante['Direccion'])) ?>" disabled >
    							</div>
    						</div>
					        <div class="col-xxl-4 col-md-12 col-12 px-3">
    							<div>
    								<label class="form-label">Área</label>
    								<input type="text" class="form-control" value="<?= ucwords(mb_strtolower($usuarioSolicitante['Area'])) ?>" disabled >
    							</div>
    						</div>
    						<div class="col-xxl-4 col-md-12 col-12 px-3">
    							<div>
    								<label class="form-label">Subárea</label>
    								<input type="text" class="form-control" value="<?= ucwords(mb_strtolower($usuarioSolicitante['Subarea'])) ?>" disabled >
    							</div>
    						</div>
					    </div>
                        <div class="row col-12 m-0 p-0 mb-3 d-flex">
    						<div class="col-xxl-12 col-md-12 col-12 px-3">
    							<div>
    								<label class="form-label">Cargo</label>
    								<input type="text" class="form-control" value="<?= ucwords(mb_strtolower($usuarioSolicitante['Cargo'])) ?>" disabled >
    							</div>
    						</div>
					    </div>
					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
    						<div class="col-xxl-12 col-md-12 col-12 px-3">
    							<div>
    								<label class="form-label" >Nro Contrato</label>
    								<div class="input-group">
                                        <input type="text" id="txtNroContrato_rcondcobr" name="txtNroContrato_rcondcobr" class="form-control" value="">
                                        <button class="btn bg-info color-white px-2 py-1" id="btnBuscarContratoCondonacionCobranza" type="button" data-tooltip="tooltip" title="Buscar Contrato">
                                            <span class="mdi mdi-magnify" style="font-size: 18px;"></span>
                                        </button>
                                    </div>
    							</div>
    						</div>
					    </div>
                        <div class="row col-12 m-0 p-0 mb-3 d-flex">
    						<div class="col-xxl-4 col-md-12 col-12 px-3">
    							<div>
    								<label class="form-label" >Cliente</label>
    								<input type="text" class="form-control bloqueo-manual" id="txtClienteCondonacionCobranza_rcondcobr" name="txtClienteCondonacionCobranza_rcondcobr" value="" placeholder="Cliente">
    							</div>
    						</div>
					        <div class="col-xxl-4 col-md-12 col-12 px-3">
    							<div>
    								<label class="form-label">NIF</label>
    								<input type="text" class="form-control bloqueo-manual" id="txtNIFCondonacionCobranza_rcondcobr" name="txtNIFCondonacionCobranza_rcondcobr" value="" placeholder="Documento de identidad">
    							</div>
    						</div>
    						<div class="col-xxl-4 col-md-12 col-12 px-3">
    						    <div>
        							<label class="form-label">Deuda Vencida</label>
                                    <div class="input-group">
                                        <span class="input-group-text">S/.</span>
                                        <input type="text" class="form-control bloqueo-manual" aria-label="Deuda Vencida" id="txtDeudaVencidaCondonacionCobranza_rcondcobr" name="txtDeudaVencidaCondonacionCobranza_rcondcobr" placeholder="Deuda Vencida">
                                    </div>
                                </div>
                            </div>
					    </div>
					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
					        <div class="col-xxl-4 col-md-12 col-12 px-3">
					            <div>
					                <label for="cboCartera_rcondcobr" class="form-label">Cartera</label>
					                <select class="form-select" aria-label="Cartera" id="cboCartera_rcondcobr" name="cboCartera_rcondcobr" data-modal="#mdlRegistrarCondonacionCobranza">
					                    <option value="" selected="">Seleccione una opción</option>
					                    <option value="PREXCAN4">PREXCAN4</option>
					                    <option value="PREXCAN5">PREXCAN5</option>
					                    <option value="PREXCAN6">PREXCAN6</option>
					                    <option value="PREXCAN7">PREXCAN7</option>
					                    <option value="No activo">No activo</option>
					                </select>
					            </div>
					        </div>
    						<div class="col-xxl-4 col-md-12 col-12 px-3">
    						    <div>
        							<label class="form-label" for="dtMesCampana_rcondcobr">Mes Campaña</label>
                                    <input type="month" class="form-control" aria-label="Mes de Campaña" id="dtMesCampana_rcondcobr" name="dtMesCampana_rcondcobr" placeholder="Mes de Campaña">
                                </div>
                            </div>
    						<div class="col-xxl-4 col-md-12 col-12 px-3">
    						    <div>
        							<label class="form-label" for="dtCompromisoPago_rcondcobr">Fecha de Compromiso de Pago</label>
                                    <div class="input-group">
                                        <span class="input-group-text">S/.</span>
                                        <input type="date" class="form-control" aria-label="Mes de Campaña" id="dtCompromisoPago_rcondcobr" name="dtCompromisoPago_rcondcobr" placeholder="Fecha de Compromiso de Pago">
                                    </div>
                                </div>
                            </div>
					    </div>
					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
					        <div class="col-xxl-8 col-md-12 col-12 px-3">
    						    <!-- Slider-->
                                <div id="ctnSlidePorcentajeCondonar">
                                    <div class="row">
                                        <div class="col-lg-12 my-2">
                                            <h5 class="fs-14">Porcentaje a Condonar</h5>
                                        </div>
                                        <div class="col-lg-12">
                                            <div id="slidePorcentajeCondonarCobranza"></div>
                                            <div class="d-flex justify-content-between align-items-center mt-2">
                                                <div>
                                                    <strong>Min:</strong> <span id="minimoPorcentajeCondonarCobranza"></span>
                                                </div>
                                                <div>
                                                    <strong>Valor:</strong> <span id="valorPorcentajeCondonarCobranza"></span>
                                                </div>
                                                <div>
                                                    <strong>Máx:</strong> <span id="maximoPorcentajeCondonarCobranza"></span>
                                                </div>
                                                <div>
                                                    <strong>Tope:</strong> <span id="topePorcentajeCondonarCobranza"></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <input type="hidden" id="txtPorcentajeCondonarCobranza_rcondcobr" name="txtPorcentajeCondonarCobranza_rcondcobr">
                                    <input type="hidden" id="txtMaximoPorcentajeCondonarCobranza_rcondcobr" name="txtMaximoPorcentajeCondonarCobranza_rcondcobr">
                                </div>
                            </div>
    						<div class="col-xxl-4 col-md-12 col-12 px-3">
    						    <div>
        							<label class="form-label" >Importe a Condonar</label>
                                    <div class="input-group">
                                        <span class="input-group-text">S/.</span>
                                        <input type="number" class="form-control bloqueo-manual" step="0.01" aria-label="Importe a Condonar" id="txtImporteCondonarCobranza_rcondcobr" name="txtImporteCondonarCobranza_rcondcobr" placeholder="Importe a Condonar">
                                        <input type="hidden" id="txtExisteMatriz_rcondcobr" name="txtExisteMatriz_rcondcobr">
                                        <input type="hidden" id="txtEvaluacionMatriz_rcondcobr" name="txtEvaluacionMatriz_rcondcobr">
                                    </div>
                                </div>
                            </div>
					    </div>
					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
    						<div>
								<label for="txtObservaciones_rcond" class="form-label">Observaciones</label>
								<textarea class="form-control validarNextTab" id="txtObservaciones_rcond" name="txtObservaciones_rcond" rows="4"></textarea>
							</div>
					    </div>
                    </div>
				</div>
    			<div class="modal-footer justify-content-end">
    				<button type="button" class="btn bg-danger d-flex justify-content-center align-items-center color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
    				<button type="submit" class="btn bg-success d-flex justify-content-center align-items-center color-white"><i class="mdi mdi-content-save mx-1" style="font-size: 14px;"></i> Guardar</button>
    			</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>