<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<?php
if($condonacion['Estado'] == "APRO")
{
    $bgEstado       = "bg-success";
    $textEstado     = "APROBADO";
    $colorEstado    = "color-white";
}
else if($condonacion['Estado'] == "CANC")
{
    $bgEstado       = "bg-dark";
    $textEstado    = "CANCELADO";
    $colorEstado    = "color-white";
}
else if($condonacion['Estado'] == "RECH")
{
    $bgEstado       = "bg-danger";
    $textEstado    = "RECHAZADO";
    $colorEstado    = "color-white";
}
else 
{
    $bgEstado       = "bg-gris-claro";
    $textEstado    = "PENDIENTE";
    $colorEstado    = "color-black";
}

?>
<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <div class="card mt-n4 mx-n4">
                        <div class="<?= $bgEstado ?> <?= $colorEstado ?>">
                            <div class="card-body pb-0 px-4">
                                <div class="row mb-3">
                                    <div class="col-md">
                                        <div class="row align-items-center g-3">
                                            <div class="col-md-auto">
                                                <div class="avatar-md">
                                                    <div class="avatar-title bg-white rounded-circle">
                                                        <img src="<?= $baseUrl ?>/<?= $basePublic ?>/images/favicon.ico" alt="" class="avatar-xs">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md">
                                                <div>
                                                    <h4 class="<?= $colorEstado ?> fw-bold">#<?= $condonacion['IDSolicitudCobranza'] ?> - <?= ucwords(mb_strtolower($condonacion['Cliente']))." | ".$condonacion['Cartera'] ?></h4>
                                                    <div class="hstack gap-3 flex-wrap">
                                                        <div><i class="mdi mdi-account align-bottom me-1"></i><?= ucwords(mb_strtolower($condonacion['NombresSolicitante'].' '.$condonacion['ApellidosSolicitante'])) ?></div>
                                                        <div class="vr"></div>
                                                        <div>Fecha de Creación: <span class="fw-medium"><?= date("d-m-Y H:i:s", strtotime($condonacion['FechaCrea'])) ?></span></div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-auto mt-md-0 mt-4 d-flex justify-content-end align-items-center">
                                                <div class="hstack gap-1 flex-wrap">
                                                    <?php
                                                    if(!in_array($condonacion['Estado'], array("APRO", "CANC")))
                                                    {
                                                    ?>
                                                    <button type="button" class="btn bg-dark px-2 py-1" onclick="cambiarEstadoCondonacionCobranza('CANC', '<?= $condonacion['IDSolicitudCobranza'] ?>')" data-tooltip="tooltip" title="Cancelar solicitud de condonación">
                                                        <i class="mdi mdi-cancel" style="font-size: 24px; color: #FFF"></i>
                                                    </button>
                                                    <?php
                                                    }
                                                    ?>
                                                    <a href="<?= $baseUrl.'/'.$previo ?>" class="btn btn-danger px-2 py-1" data-tooltip="tooltip" title="Volver">
                                                        <i class="mdi mdi-arrow-left-circle" style="font-size: 24px; color: #FFF"></i>
                                                    </a>
                                                </div>
                                            </div>
 
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- end card body -->
                        </div>
                    </div>
                    <!-- end card -->
                </div>
                <!-- end col -->
            </div>
            <!-- end row -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="tab-content text-muted">
                            <div class="row">
                                <div class="col-xl-8 col-lg-6">
                                    <div class="card">
                                        <div class="card-header align-items-center d-flex">
                                            <h4 class="card-title mb-0 flex-grow-1">Observación</h4>
                                            <div class="flex-shrink-0">
                                                
                                            </div>
                                        </div><!-- end card header -->

                                        <div class="card-body">
                                            <div class="text-muted">
                                                <p><?= $condonacion['Observacion'] ?></p>
                                            </div>
                                        </div>
                                        <!-- end card body -->
                                    </div>
                                    <!-- end card -->
                                    
                                    <?php
                                    if(!empty($aprobadores))
                                    {
                                    ?>
                                    <div class="card">
                                        <div class="card-header align-items-center d-flex border-bottom-dashed">
                                            <h4 class="card-title mb-0 flex-grow-1">Aprobadores</h4>
                                            <div class="flex-shrink-0">
                                                <button type="button" class="btn bg-sistema px-2 py-1" data-tooltip="tooltip" title="Actualizar Aprobadores" onclick="return mostrarAprobadoresGeneral('<?= $condonacion['IDSolicitudCobranza'] ?>')">
                                                    <i class="mdi mdi-refresh" style="font-size: 18px; color: #FFF"></i>
                                                </button>
                                            </div>
                                        </div>

                                        <div class="card-body">
                                            <div class="vstack gap-3" id="ctnAprobadoresGeneral">
                                                
                                            </div>
                                        </div>
                                        <!-- end card body -->
                                    </div>
                                    <!-- end card -->
                                    <?php
                                    }
                                    ?>
                                    
                                    <div class="card">
                                        <div class="card-header align-items-center d-flex">
                                            <h4 class="card-title mb-0 flex-grow-1">Comentarios de Condonación</h4>
                                            <div class="flex-shrink-0">
                                                <button type="button" class="btn bg-sistema px-2 py-1" data-tooltip="tooltip" title="Actualizar Comentarios de Condonación" onclick="return mostrarComentariosCondonacionCobranza('<?= $condonacion['IDSolicitudCobranza'] ?>')">
                                                    <i class="mdi mdi-refresh" style="font-size: 18px; color: #FFF"></i>
                                                </button>
                                            </div>
                                        </div><!-- end card header -->

                                        <div class="card-body">
                                            <div class="col-12" data-simplebar id="ctnComentariosGeneralCondonacionCobranza" style="height: 300px;">
                                            </div>
                                            <hr>
                                            <div class="col-12 p-3 m-0">
                                                <form class="formularioRegistrarComentarioCondonacionCobranza comentario m-0" autocomplete="off" action="<?= $baseUrl ?>/registrar-comentario-condonacion-cobranza" method="POST" data-contenedor="ctnComentariosGeneralCondonacionCobranza" >
                                			        <div class="row col-12 m-0 p-0 d-flex">
                                			            <div class="panel m-0">
                                                            <div class="panel-heading">
                                                                <h4>Registrar Comentario</h4>
                                                            </div>
                                                            <div class="panel-content">
                                                                <div class="row">
                                                                    <div class="col-10">
                                                                        <input type="hidden" id="txtIDSolicitud_rcomcondcobr" name="txtIDSolicitud_rcomcondcobr" value="<?= $condonacion['IDSolicitudCobranza'] ?>">
                                            							<textarea class="form-control" id="txtComentarios_rcomcondcobr" name="txtComentarios_rcomcondcobr" rows="4" placeholder="Comentarios...."></textarea>
                                            						</div>
                                            						<div class="col-2 d-flex justify-content-center align-items-center">
                                            						    <button type="submit" class="btn bg-sistema color-white p-2 px-3 mx-1">
                                                                            <i class="mdi mdi-content-save" style="font-size: 22px;"></i>
                                                                        </button>
                                            						</div>
                                                                </div>
                                                            </div>
                                                        </div>
                                				    </div>
                                			    </form>
                                			</div>
                                        </div>
                                        <!-- end card body -->
                                    </div>
                                    <!-- end card -->
                                </div>
                                <!-- ene col -->
                                <div class="col-xl-4 col-lg-6">
                                    <div class="card">
                                        <div class="card-header">
                                            <h5 class="card-title mb-0">Información de Condonación</h5>
                                        </div>
                                        <div class="card-body">
                                            <div class="table-responsive table-card">
                                                <table class="table table-borderless align-middle mb-0">
                                                    <tbody>
                                                        <tr>
                                                            <td class="fw-medium">Solicitud</td>
                                                            <td>#<?= $condonacion['IDSolicitudCobranza'] ?></td>
                                                        </tr>
                                                        <tr class="bg-sistema-50 color-white">
                                                            <td class="fw-medium">Nro Contrato</td>
                                                            <td id="t-client"><?= $condonacion['NroContrato'] ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Cliente</td>
                                                            <td><?= $condonacion['Cliente'] ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">NIF</td>
                                                            <td><?= $condonacion['NIF'] ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Cartera</td>
                                                            <td id="t-client"><?= $condonacion['Cartera'] ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">% Descuento</td>
                                                            <td id="t-client"><?= number_format(round(($condonacion['Descuento']*100), 2), 2, '.', '') ?>%</td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Deuda Vencida</td>
                                                            <td id="t-client">S/ <?= $condonacion['DeudaVencida'] ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Importe a Condonar</td>
                                                            <td id="t-client">S/ <?= $condonacion['ImporteTotalCondonar'] ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Mes Campaña</td>
                                                            <td id="t-client"><?= $condonacion['MesCampana'] ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Fecha de compromiso de Pago</td>
                                                            <td id="c-date"><?= date("d-m-Y", strtotime($condonacion['FechaCompromisoPago'])) ?></td>
                                                        </tr>
                                                        <tr class="<?= $bgEstado ?> color-white">
                                                            <td class="fw-medium">Estado</td>
                                                            <td><?= $textEstado ?></td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                        <!--end card-body-->
                                    </div>
                                    <div class="card">
                                        <div class="card-header">
                                            <h5 class="card-title mb-0">Información de Solicitante</h5>
                                        </div>
                                        <div class="card-body">
                                            <div class="table-responsive table-card">
                                                <table class="table table-borderless align-middle mb-0">
                                                    <tbody>
                                                        <tr>
                                                            <td class="fw-medium">Usuario Solicitante</td>
                                                            <td id="t-client"><?= $condonacion['MatriculaSolicitante'].' | '.ucwords(mb_strtolower($condonacion['NombresSolicitante'].' '.$condonacion['ApellidosSolicitante'])) ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Dirección Solicitante</td>
                                                            <td id="t-client"><?= $condonacion['DireccionSolicitante'] ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Área Solicitante</td>
                                                            <td id="t-client"><?= $condonacion['AreaSolicitante'] ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Subárea Solicitante</td>
                                                            <td id="t-client"><?= $condonacion['SubareaSolicitante'] ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Delegación Solicitante</td>
                                                            <td id="t-client"><?= $condonacion['DelegacionSolicitante'] ?> | <?= $condonacion['CCSolicitante'] ?> - <?= $condonacion['LNSolicitante'] ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Cargo Solicitante</td>
                                                            <td id="t-client"><?= $condonacion['CargoSolicitante'] ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="fw-medium">Fecha de creación</td>
                                                            <td id="c-date"><?= date("d-m-Y H:i:s", strtotime($condonacion['FechaCrea'])) ?></td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                        <!--end card-body-->
                                    </div>
                                    <!-- end card -->

                                </div>
                                <!-- end col -->
                            </div>
                            <!-- end row -->
                    </div>
                </div>
                <!-- end col -->
            </div>
            <!-- end row -->
        </div>
        <!-- container-fluid -->
		<span class="respuesta_global"></span>
    </div>
    <!-- End Page-content -->

    <footer class="footer">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-6">
                    <script>document.write(new Date().getFullYear())</script> © Verisure Peru.
                </div>
                <div class="col-sm-6">
                    <div class="text-sm-end d-none d-sm-block">Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
                    </div>
                </div>
            </div>
        </div>
    </footer>
</div>
<!-- end main content-->

<?= $this->section('js'); ?>
<script>
    $(function () 
    {
        // $('#tblFacturasPendientesAprobarCondonacion').DataTable();
        // mostrarAprobadoresGeneral('<?= $condonacion['IDSolicitudCobranza'] ?>');
        mostrarComentariosCondonacionCobranza('<?= $condonacion['IDSolicitudCobranza'] ?>');
    });

    $(document).on('submit', '.formularioRegistrarComentarioCondonacionCobranza', function() 
    {
        var formulario = $(this);
        var metodoEnvio = formulario.attr('method');
        var contenedor = $(this).data("contenedor");
        
        $.ajax({        
            url: formulario.attr('action'),
            type: metodoEnvio,
            data: formulario.serialize(),
            data: new FormData(this),
            contentType: false,
            cache: false,
            processData: false,
            dataType: 'json',
            beforeSend: function() 
            {
                Swal.fire({
                    html: 'Un momento por favor...',
                    heightAuto: true,
                    showConfirmButton: false
                });
            },
            success: function(response) 
            {
                Swal.close();
                        
                $('.respuesta_global').html(response.mensaje);
                
                if(response.result == 1)
                {
                    mostrarComentariosCondonacionCobranza(formulario.find('#txtIDSolicitud_rcomcondcobr').val());
                    // $("#txtComentariosFactura_rcomaprcond").val("");
                    formulario.find('textarea').val('');
                }
            }, 
            error: function(jqXHR, textStatus, errorThrown)
            {
                Swal.close();
                
                Swal.fire({
                    title: 'Ha ocurrido un error interno',
                    text: errorThrown,
                    icon: 'error',
                    showCancelButton: false,
                    confirmButtonColor: '#E4002B',
                    confirmButtonText: 'Confirmar'
                });
            }
        });
        
        return false;
    });

    function mostrarComentariosCondonacionCobranza(idSolicitud)
    {
        var parametros = {
            "idSolicitud"  : idSolicitud
    	};
        
        $.ajax({        
            url: baseUrl + '/comentarios-condonacion-cobranza',
            type: 'POST',
            data: parametros,
            beforeSend: function() 
            {
                $('#ctnComentariosGeneralCondonacionCobranza').html('<div class="d-flex justify-content-center align-items-center"><div class="spinner-border text-primary" role="status" style="width: 3rem; height: 3rem;"><span class="visually-hidden">Loading...</span></div></div>');
            },
            success: function(response) {
                Swal.close();
                
                let cont = $('#ctnComentariosGeneralCondonacionCobranza');
                
                cont.empty();
                cont.html(response);
                
                if (cont[0].SimpleBar) {
                    cont[0].SimpleBar.recalculate();
                } else {
                    new SimpleBar(cont[0]);
                }
            }, 
            error: function(jqXHR, textStatus, errorThrown){
                Swal.close();
                
                Swal.fire({
                    title: 'Ha ocurrido un error interno',
                    text: errorThrown,
                    icon: 'error',
                    showCancelButton: false,
                    confirmButtonColor: '#E4002B',
                    confirmButtonText: 'Confirmar'
                });
            }
        });
    }
    
    function cambiarEstadoCondonacionCobranza(estado, idSolicitudCobranza)
    {
        let titulo = (estado == "CANC" ? "Cancelar solicitud de condonación" : ( estado == "APRO" ? "Aprobar solicitud de condonación" : "Rechazar solicitud de condonación" ) );
        let textEstado = (estado == "CANC" ? "CANCELAR" : (estado == "APRO" ? "APROBAR" : "RECHAZAR"));
        
        Swal.fire({
            title: titulo,
            text: "¿Desea "+textEstado+" la solicitud de condonación?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#008F39',
            cancelButtonColor: '#f35d5d',
            confirmButtonText: 'Confirmar',
            cancelButtonText: 'Cancelar',
            input: 'textarea',
            inputAttributes: {
                autocapitalize: 'on'
            },
            inputValidator: obs => {
                // // Si el valor es válido, debes regresar undefined. Si no, una cadena
                if (!obs) {
                    return "Por favor escribe el motivo";
                } else {
                    return undefined;
                }
            }
        }).then((result) => {
            if (result.isConfirmed) {
    
                var motivo = result.value;
                
                var parametros = {
                    "motivoEstado"          : motivo,
                    "idSolicitudCobranza"   : idSolicitudCobranza,
                    "estado"                : estado
        		};
        		
                $.ajax({        
                    url: baseUrl + '/cambiar-estado-condonacion-cobranza',
                    type: "POST",
                    data: parametros,
                    dataType: 'json',
                    beforeSend: function() 
                    {
                        Swal.fire({
                            html: 'Un momento por favor...',
                            heightAuto: true,
                            showConfirmButton: false
                        });
                    },
                    success: function(response) 
                    {
                        Swal.close();
                        
                        $('.respuesta_global').html(response.mensaje);
                        
                    }, 
                    error: function(jqXHR, textStatus, errorThrown)
                    {
                        Swal.close();
                
                        Swal.fire({
                            title: 'Ha ocurrido un error interno',
                            text: errorThrown,
                            icon: 'error',
                            showCancelButton: false,
                            confirmButtonColor: '#E4002B',
                            confirmButtonText: 'Confirmar'
                        });
                    }
                });
            }
        });
        
    }

</script>
<?php $this->endSection(); ?>

<!-- Modal Información Factura Condonación -->
<div class="modal fade zoomIn" id="mdlFacturaCondonacion" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="examplemdlFacturaCondonacion">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplemdlFacturaCondonacion">Información de Factura</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formFacturaCondonacion" class="formularioFacturaCondonacion" autocomplete="off" action="" data-condonacion="<?= $condonacion['IDSolicitudCobranza'] ?>" data-modal="#mdlFacturaCondonacion" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
				    <div class="row col-12 m-0 p-0 mb-3 d-flex">
						<div class="col-xxl-12 col-md-12 col-12 px-3 mb-3 ">
							<div>
								<label for="txtNroContrato_ifcond" class="form-label">Nro Contrato</label>
								<input type="text" class="form-control" id="txtNroContrato_ifcond" disabled>
							</div>
						</div>
						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
							<div>
								<label for="txtFacturaInterna_ifcond" class="form-label">Factura Interna</label>
								<input type="text" class="form-control" id="txtFacturaInterna_ifcond" disabled>
							</div>
						</div>
						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
							<div>
								<label for="txtFacturaExterna_ifcond" class="form-label">Factura Externa</label>
								<input type="text" class="form-control" id="txtFacturaExterna_ifcond" disabled>
							</div>
						</div>
						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
						    <div>
								<label for="txtTipoFactura_ifcond" class="form-label">Tipo de Factura</label>
								<select class="form-select" aria-label="Tipo de Factura" id="txtTipoFactura_ifcond" data-modal="#mdlFacturaCondonacion" disabled>
									<option value="" selected="">Seleccione una opción</option>
									<option value="ND">ND</option>
									<option value="O">O</option>
									<option value="C">C</option>
									<option value="OT">OT</option>
									<option value="OI">OI</option>
								</select>
							</div>
						</div>
						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
						    <div>
								<label for="txtSegmento_ifcond" class="form-label">Segmento</label>
								<select class="form-select" aria-label="Segmento" id="txtSegmento_ifcond" data-modal="#mdlFacturaCondonacion" disabled>
									<option value="" selected="">Seleccione una opción</option>
									<option value="HBFEPE">HBFEPE</option>
									<option value="HBFDPE">HBFDPE</option>
								</select>
							</div>
						</div>
						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
						    <div>
    							<label for="txtDeudaTotal_ifcond" class="form-label">Deuda Total Factura</label>
                                <div class="input-group">
                                    <span class="input-group-text">S/.</span>
                                    <input type="text" step="0.01" class="form-control evaluar-moneda-decimal" aria-label="Deuda Total" id="txtDeudaTotal_ifcond" placeholder="Deuda Total" pattern="^\d+(\.\d+)?$"  title="Solo números y un punto decimal" disabled>
                                </div>
                            </div>
                        </div>
						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
						    <div>
    							<label for="txtImporte_ifcond" class="form-label">Importe Condonar</label>
                                <div class="input-group">
                                    <span class="input-group-text">S/.</span>
                                    <input type="text" step="0.01" class="form-control evaluar-moneda-decimal" aria-label="Importe" id="txtImporte_ifcond" name="txtImporte_ifcond" placeholder="Importe" pattern="^\d+(\.\d+)?$"  title="Solo números y un punto decimal">
                                </div>
                            </div>
                        </div>
				    </div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-center align-items-center color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" id="btnEjecutarFacturaCondonacion" class="btn bg-success d-flex justify-content-center align-items-center color-white"><i class="mdi mdi-import mx-1" style="font-size: 14px;"></i>Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Comentarios Aprobación Factura Condonación -->
<div class="modal fade zoomIn" id="mdlComentariosAprobacionCondonacion" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="examplemdlComentariosAprobacionCondonacion">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplemdlComentariosAprobacionCondonacion">Comentarios de Aprobador</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
			    <form id="formRegistrarComentarioAprobacionCondonacion" class="formularioRegistrarComentarioAprobacionCondonacion comentario" autocomplete="off" action="<?= $baseUrl ?>/registrar-comentario-aprobador-condonacion" method="POST" data-contenedor="ctnComentariosAprobacionFactura">
			        <div class="row col-12 m-0 p-0 d-flex">
			            <div class="panel">
                            <div class="panel-heading">
                                <h4>Registrar Comentario</h4>
                            </div>
                            <div class="panel-content">
                                <div class="row">
                                    <div class="col-10">
                                        <input type="hidden" id="txtIDCondonacion_rcomaprcond" name="txtIDCondonacion_rcomaprcond" value="<?= $condonacion['IDSolicitudCobranza'] ?>">
                                        <input type="hidden" id="txtIDFacturaCondonacion_rcomaprcond" name="txtIDFacturaCondonacion_rcomaprcond" value="">
                                        <input type="hidden" id="txtIDAprobacionCondonacion_rcomaprcond" name="txtIDAprobacionCondonacion_rcomaprcond" value="">
            							<textarea class="form-control" id="txtComentariosFactura_rcomaprcond" name="txtComentariosFactura_rcomaprcond" rows="4" placeholder="Comentarios...."></textarea>
            						</div>
            						<div class="col-2 d-flex justify-content-center align-items-center">
            						    <button type="submit" class="btn bg-sistema color-white p-2 px-3 mx-1">
                                            <i class="mdi mdi-content-save" style="font-size: 22px;"></i>
                                        </button>
            						</div>
                                </div>
                            </div>
                        </div>
				    </div>
			    </form>
			    <hr>
			    <div class="col-12 " id="ctnComentariosAprobacionFactura">
			        
			    </div>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn bg-danger d-flex justify-content-center align-items-center color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
			</div>
		</div>
	</div>
</div>

<!-- Modal Comentarios Factura Condonación -->
<div class="modal fade zoomIn" id="mdlComentariosFacturaCondonacion" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="examplemdlComentariosFacturaCondonacion">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplemdlComentariosFacturaCondonacion">Comentarios en Factura</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
			    <form id="formRegistrarComentarioFacturaCondonacion" class="formularioRegistrarComentarioFacturaCondonacion comentario" autocomplete="off" action="<?= $baseUrl ?>/registrar-comentario-factura-condonacion" method="POST">
			        <div class="row col-12 m-0 p-0 d-flex">
			            <div class="panel">
                            <div class="panel-heading">
                                <h4>Registrar Comentario</h4>
                            </div>
                            <div class="panel-content">
                                <div class="row">
                                    <div class="col-10">
                                        <input type="hidden" id="txtIDCondonacion_rcomfaccond" name="txtIDCondonacion_rcomfaccond" value="<?= $condonacion['IDSolicitudCobranza'] ?>">
                                        <input type="hidden" id="txtIDFacturaCondonacion_rcomfaccond" name="txtIDFacturaCondonacion_rcomfaccond" value="">
            							<textarea class="form-control" id="txtComentariosFactura_rcomfaccond" name="txtComentariosFactura_rcomfaccond" rows="4" placeholder="Comentarios...."></textarea>
            						</div>
            						<div class="col-2 d-flex justify-content-center align-items-center">
            						    <button type="submit" class="btn bg-sistema color-white p-2 px-3 mx-1">
                                            <i class="mdi mdi-content-save" style="font-size: 22px;"></i>
                                        </button>
            						</div>
                                </div>
                            </div>
                        </div>
				    </div>
			    </form>
			    <hr>
			    <div class="col-12 " id="ctnComentariosFactura">
			        
			        
			    </div>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn bg-danger d-flex justify-content-center align-items-center color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
			</div>
		</div>
	</div>
</div>

<!-- Modal Facturas Usuario Aprobador Condonación -->
<div class="modal fade zoomIn" id="mdlFacturasAprobador" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="examplemdlFacturasAprobador">
	<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplemdlFacturasAprobador">Listado de Facturas por Aprobador</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body p-0" id="ctnListadoFacturasAprobador" style="overflow: hidden;">
			    
			</div>
		</div>
	</div>
</div>

<!-- Modal Cambiar Aprobador Factura Condonación -->
<div class="modal fade zoomIn" id="mdlCambiarAprobadorFacturaCondonacion" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="examplemdlCambiarAprobadorFacturaCondonacion">
	<div class="modal-dialog modal-dialog-centered modal-xl" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplemdlCambiarAprobadorFacturaCondonacion">Cambiar Aprobador</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formCambiarAprobadorFacturaCondonacion" class="formulario" autocomplete="off" action="<?= $baseUrl ?>/actualizar-aprobador-factura-condonacion" method="POST" accept-charset="utf-8">
			    <div class="modal-body">
			        <span class="respuesta"></span>
			        <input type="hidden" id="txtIDAprobacion_cafc" name="txtIDAprobacion_cafc">
    			    <h3 class="mb-3">Factura</h3>
    			    <div class="row m-0 mb-3">
    					<div class="col-12 col-lg-6">
    						<div class="form-group">
    							<label for="concepto_roc">Factura Interna</label>
    							<input type="text" class="form-control" id="txtFacturaInterna_cafc" placeholder="Concepto" disabled>
    						</div>
    					</div>
    					<div class="col-12 col-lg-6">
    						<div class="form-group">
    							<label for="proveedor_roc">Factura Externa</label>
    							<input type="text" class="form-control" id="txtFacturaExterna_cafc" placeholder="Proveedor" disabled>
    						</div>
    					</div>
    				</div>
    				<hr>
    				<h3 class="mb-3">Aprobador</h3>
    			    <div class="row m-0 mb-3">
    					<div class="col-12 col-lg-6">
    						<label>Aprobador actual</label>
							<select class="form-select" id="cboAprobadorActual_cafc" data-modal="mdlCambiarAprobadorFacturaCondonacion" disabled>
							</select>
    					</div>
    					<div class="col-12 col-lg-6">
    						<label for="cboNuevoAprobador_cafc">Nuevo Aprobador</label>
							<select class="form-select" id="cboNuevoAprobador_cafc" name="cboNuevoAprobador_cafc" data-modal="mdlCambiarAprobadorFacturaCondonacion">
							</select>
    					</div>
    				</div>
    			</div>
    			<div class="modal-footer justify-content-end">
    				<button type="button" class="btn bg-danger d-flex justify-content-center align-items-center color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
    				<button type="submit" class="btn bg-success d-flex justify-content-center align-items-center color-white"><i class="mdi mdi-content-save mx-1" style="font-size: 14px;"></i> Guardar</button>
    			</div>
    		</form>
		</div>
	</div>
</div>

<?php $this->endSection(); ?>