<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<ul class="nav nav-tabs nav-justified nav-border-top nav-border-top-success mb-3 bg-white" role="tablist">
                <li class="nav-item" role="presentation">
                    <a class="nav-link active" data-bs-toggle="tab" href="#nav-peticiones-pendientes" role="tab" aria-selected="true">
                        <i class="ri-home-5-line align-middle me-1"></i> Peticiones Pendientes
                    </a>
                </li>
                <li class="nav-item" role="presentation" id="navPeticionesHistorico">
                    <a class="nav-link" data-bs-toggle="tab" href="#nav-peticiones-historico" role="tab" aria-selected="false" tabindex="-1">
                        <i class="ri-user-line me-1 align-middle"></i> Histórico de Peticiones
                    </a>
                </li>
            </ul>
            <div class="tab-content text-muted" style="background-color: transparent;">
                <div class="tab-pane active show" id="nav-peticiones-pendientes" role="tabpanel" style="background-color: transparent!important">
                    <div class="row">
                        <div class="col-xxl-3 col-sm-6">
                            <div class="card card-animate">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <p class="fw-medium text-muted mb-0">Total de peticiones</p>
                                            <h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target="<?= $cantidadesGenerales['Totales'] ?>"><?= $cantidadesGenerales['Totales'] ?></span></h2>
                                            <!--<h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target="547">547</span>k</h2>-->
                                            <!--<p class="mb-0 text-muted"><span class="badge bg-light text-success mb-0"> <i class="ri-arrow-up-line align-middle"></i> 17.32 % </span> vs. previous month</p>-->
                                        </div>
                                        <div>
                                            <div class="avatar-sm flex-shrink-0">
                                                <span class="avatar-title bg-sistema-25 rounded-circle fs-4">
                                                    <i class="mdi mdi-ticket-account" style="font-size: 28px;"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div><!-- end card body -->
                            </div> <!-- end card-->
                        </div>
                        <!--end col-->
                        <div class="col-xxl-3 col-sm-6">
                            <div class="card card-animate">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <p class="fw-medium text-muted mb-0">Peticiones del mes</p>
                                            <h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target="<?= $cantidadesGenerales['Mes'] ?>"><?= $cantidadesGenerales['Mes'] ?></span></h2>
                                            <!--<h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target="124">124</span>k</h2>-->
                                            <!--<p class="mb-0 text-muted"><span class="badge bg-light text-danger mb-0"> <i class="ri-arrow-down-line align-middle"></i> 0.96 % </span> vs. previous month</p>-->
                                        </div>
                                        <div>
                                            <div class="avatar-sm flex-shrink-0">
                                                <span class="avatar-title bg-sistema-25 rounded-circle fs-4">
                                                    <i class="mdi mdi-calendar-month-outline" style="font-size: 28px;"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div><!-- end card body -->
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-xxl-3 col-sm-6">
                            <div class="card card-animate">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <p class="fw-medium text-muted mb-0">Peticiones pendientes</p>
                                            <h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target="<?= $cantidadesGenerales['Pendientes'] ?>"><?= $cantidadesGenerales['Pendientes'] ?></span></h2>
                                            <!--<h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target="107">107</span>K</h2>-->
                                            <!--<p class="mb-0 text-muted"><span class="badge bg-light text-danger mb-0"> <i class="ri-arrow-down-line align-middle"></i> 3.87 % </span> vs. previous month</p>-->
                                        </div>
                                        <div>
                                            <div class="avatar-sm flex-shrink-0">
                                                <span class="avatar-title bg-sistema-25 rounded-circle fs-4">
                                                    <i class="mdi mdi-timer-sand" style="font-size: 28px;"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div><!-- end card body -->
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-xxl-3 col-sm-6">
                            <div class="card card-animate">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <p class="fw-medium text-muted mb-0">Peticiones sin iniciar</p>
                                            <h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target="<?= $cantidadesGenerales['NoIniciados'] ?>"><?= $cantidadesGenerales['NoIniciados'] ?></span></h2>
                                            <!--<h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target="15.95">15.95</span>%</h2>-->
                                            <!--<p class="mb-0 text-muted"><span class="badge bg-light text-success mb-0"> <i class="ri-arrow-up-line align-middle"></i> 1.09 % </span> vs. previous month</p>-->
                                        </div>
                                        <div>
                                            <div class="avatar-sm flex-shrink-0">
                                                <span class="avatar-title bg-sistema-25 rounded-circle fs-4">
                                                    <i class="mdi mdi-clock-alert-outline" style="font-size: 28px;"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div><!-- end card body -->
                            </div>
                        </div>
                        <!--end col-->
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card" id="ticketsList">
                                <div class="card-header border-0">
                                    <div class="d-flex align-items-center">
                                        <h5 class="card-title mb-0 flex-grow-1">Peticiones</h5>
                                        <div class="flex-shrink-0">
                                            <div class="d-flex flex-wrap gap-2">
                                                <?php
                                                if(in_array("EXREPE", $permisos))
                                                {
                                                ?>
                                                <button type="button" class="btn bg-warning d-flex mx-1 color-white" data-bs-toggle="modal" data-bs-target="#exportarReportePeticiones">
                    								<i class="mdi mdi-download me-1" style="font-size: 14px;"></i> Exportar Back Office
                    							</button>
                                                <?php    
                                                }
                                                
                								if (in_array("ADDPET", $permisos)) 
                								{
                								?>
                                                <button class="btn btn-danger add-btn" data-bs-toggle="modal" data-bs-target="#registrarPeticion" id="btnNuevaPeticion"><i class="ri-add-line align-bottom me-1"></i> Petición</button>
                                                <!--<button type="button" class="btn btn-primary" > <i class="ri-equalizer-fill me-1 align-bottom"></i>-->
                                                <!--    Filters-->
                                                <!--</button>-->
                                                <?php    
                								}
                								?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--end card-body-->
                                <div class="card-body">
                                    <div class="mb-4 table-responsive">
                                        <table class="table table-bordered dt-responsive nowrap table-striped align-middle" id="tblPeticiones" width="100%">
                                            <thead>
                                                <tr>
                                                    <th class="sort desc">Nro Petición</th>
                                                    <th class="sort">Asociado</th>
                                                    <th class="sort">Fecha de Creación</th>
                                                    <th class="sort">Fecha Último Cambio</th>
                                                    <th class="sort">Delegación Solicitante</th>
                                                    <th class="sort">Perfil Solicitante</th>
                                                    <th class="sort">Requerimiento</th>
                                                    <th class="sort">Motivo</th>
                                                    <th class="sort">Usuario Último Cambio</th>
                                                    <th class="sort">Grupo Encargado</th>
                                                    <th class="sort">Estado</th>
                                                    <th class="sort">Acción</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                foreach($listadoPeticiones as $items)
                                                {
                                                ?>
                                                <tr>
                                                    <td class="text-center align-middle"><?= $items['NotificacionesNoVistas'] > 0 ? "<span class='mdi mdi-exclamation-thick mr-2' style='font-size: 18px; color: red;'></span>" : "" ?><?= $items['IDPeticion'] ?></td>
                                                    <td class="text-center align-middle"><?= $items['NroProspecto'] != "" && $items['NroProspecto'] != NULL ? $items['NroProspecto'] : $items['NroContrato'] ?></td>
                                                    <td class="text-center align-middle"><?= date("d-m-Y", strtotime($items['FechaCrea'])) ?><br><?= date("H:i:s", strtotime($items['FechaCrea'])) ?><br></td>
                                                    <td class="text-center align-middle"><?= date("d-m-Y", strtotime($items['FechaEstado'])) ?><br><?= date("H:i:s", strtotime($items['FechaEstado'])) ?></td>
                                                    <td class="text-center align-middle"><?= $items['DelegacionSolicitante'] ?></td>
                                                    <td class="text-center align-middle"><?= $items['PerfilSolicitante'] ?></td>
                                                    <td class="text-center align-middle"><?= $items['Requerimiento'] ?></td>
                                                    <td class="text-center align-middle"><?= $items['Motivo'] ?></td>
                                                    <td class="text-center align-middle"><?= $items['NombreUsuarioEstado'] ?></td>
                                                    <td class="text-center align-middle"><?= $items['GrupoTrabajo'] ?></td>
                                                    <td class="text-center align-middle">
                                                        <span class="badge <?= $estadosPeticion[$items['Estado']]['FONDO'] ?> border-0">
            												<?= $estadosPeticion[$items['Estado']]['PASADO'] ?>
            											</span>
                                                    </td>
                                                    <td class="text-center align-middle">
                                                        <span class="badge bg-sistema border-0 p-2">
                                                            <a href="<?= $baseUrl ?>/detalle-peticion/<?= $items['IDPeticion'] ?>" class="color-white">
            													<i class="ri-eye-fill align-bottom" style="font-size: 18px;"></i>
            												</a>
            											</span>
                                                    </td>
                                                </tr>
                                                <?php
                                                }
                                                ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <!--end card-body-->
                            </div>
                            <!--end card-->
                        </div>
                        <!--end col-->
                    </div>
                </div>
                <div class="tab-pane" id="nav-peticiones-historico" role="tabpanel" style="background-color: transparent;">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card" id="ticketsList">
                                <div class="card-header border-0">
                                    <div class="d-flex align-items-center">
                                        <h5 class="card-title mb-0 flex-grow-1">Histórico de Peticiones</h5>
                                        <div class="flex-shrink-0">
                                            <div class="d-flex flex-wrap gap-2">
                                                <!--<button type="button" class="btn btn-primary" > <i class="ri-equalizer-fill me-1 align-bottom"></i>-->
                                                <!--    Filters-->
                                                <!--</button>-->
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--end card-body-->
                                <div class="card-body">
                                    <div class="mb-4">
                                        <table class="table table-bordered dt-responsive nowrap table-striped align-middle" id="tblHistoricoPeticiones">
                                            
                                        </table>
                                    </div>
                                </div>
                                <!--end card-body-->
                            </div>
                            <!--end card-->
                        </div>
                        <!--end col-->
                    </div>
                </div>
            </div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
    <footer class="footer">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-6">
                    <script>document.write(new Date().getFullYear())</script> © Verisure Peru.
                </div>
                <div class="col-sm-6">
                    <div class="text-sm-end d-none d-sm-block">Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
                    </div>
                </div>
            </div>
        </div>
    </footer>
</div>
<!-- end main content-->
<!-- Modal Registrar Petición -->
<div class="modal fade zoomIn" id="registrarPeticion" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleRegistrarPeticion" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema d-flex justify-content-start align-items-center p-3">
				<h5 class="modal-title color-white" id="exampleRegistrarPeticion">Registrar Petición</h5>
                <button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close" id="close-modal"></button>
			</div>
			<form id="formRegistrarPeticion" class="formularioRegistrarPeticion" autocomplete="off" action="<?= $baseUrl ?>/grabar-peticion" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
				    <input type="hidden" id="txtFormularioRegistrarPeticion" name="txtFormularioRegistrarPeticion" value="formRegistrarPeticion">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 px-3 mb-3">
							<div>
								<label for="txtGruposTrabajoPeticion_i" class="form-label">Grupo Destino</label>
								<select class="form-select" aria-label="Destino" id="txtGruposTrabajoPeticion_i" name="txtGruposTrabajoPeticion_i">
								    <option value="">Seleccione una opción</option>
									<?php foreach($listadoGruposTrabajos as $items){?>
                                    <option value="<?= $items['IDGrupoTrabajo']?>"><?= $items['GrupoTrabajo']?></option>
									<?php }?>
								</select>
							</div>
						</div>					    
						<div class="col-xxl-8 col-md-12 col-12 px-3 mb-3">
							<div>
								<label for="txtPeticion_i" class="form-label color-sistema">Petición</label>
								<input type="text" class="form-control color-sistema border-color-sistema" id="txtPeticion_i" name="txtPeticion_i">
							</div>
						</div>
						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3">
							<div class="d-none txtNroProspectoPeticion">
								<label for="txtNroProspectoPeticion_i" class="form-label">Nro Prospecto</label>
								<input type="number" class="form-control" id="txtNroProspectoPeticion_i" name="txtNroProspectoPeticion_i">
							</div>
							<div class="d-none txtNroContratoPeticion">
								<label for="txtNroContratoPeticion_i" class="form-label">Nro Contrato</label>
								<input type="number" class="form-control" id="txtNroContratoPeticion_i" name="txtNroContratoPeticion_i">
							</div>
							<div class="d-none grupoCompras">
								<label for="txtPresupuestoAsignado_i" class="form-label">Presupuesto asignado</label>
								<input type="text" class="form-control" id="txtPresupuestoAsignado_i" name="txtPresupuestoAsignado_i" onkeypress="return validarNumerosDecimales(event, this);"> 
							</div>
						</div>
				        <div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 d-none grupoCompras">
						    <div>
								<label for="txtMarcaModelo_i" class="form-label">Marca / Modelo</label>
								<input type="text" class="form-control" id="txtMarcaModelo_i" name="txtMarcaModelo_i">
							</div>
						</div>
				        <div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 d-none grupoCompras">
						    <div>
								<label for="txtCantidad_i" class="form-label">Cantidad</label>
								<input type="text" class="form-control" id="txtCantidad_i" name="txtCantidad_i" onkeypress="return validarNumerosEnteros(event, this);">
							</div>
						</div>
						
				        <div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 d-none grupoCompras">
						    <div>
								<label for="cboMoneda" class="form-label">Moneda</label>
                                <select class="form-select moneda-Tipo" name="cboMoneda" id="cboMoneda">
                                                        
                                </select>
							</div>
						</div>					
				        <div class="col-xxl-4 col-md-12 col-12 px-3 mb-3">
						    <div>
								<label for="txtTipoRequerimiento_i" class="form-label">Tipo Requerimiento</label>
								<select class="form-select" aria-label="Subárea Reserva" id="txtTipoRequerimiento_i" name="txtTipoRequerimiento_i">
									<option selected="" value="">Seleccione una opción</option>
								</select>
							</div>
						</div>
				        <div class="col-xxl-4 col-md-12 col-12 px-3 mb-3">
						    <div>
								<label for="txtRequerimiento_i" class="form-label">Requerimiento</label>
								<select class="form-select" aria-label="Requerimiento" id="txtRequerimiento_i" name="txtRequerimiento_i">
									<option selected="" value="">Seleccione una opción</option>
								</select>
								<input type="hidden" id="txtRequerimientoTextPeticion" name="txtRequerimientoTextPeticion">
							</div>
						</div>
				        <div class="col-xxl-4 col-md-12 col-12 px-3 mb-3">
						    <div>
								<label for="txtMotivoRequerimiento_i" class="form-label">Motivo del Requerimiento</label>
								<select class="form-select" aria-label="Motivo del Requerimiento" id="txtMotivoRequerimiento_i" name="txtMotivoRequerimiento_i">
									<option selected="" value="">Seleccione una opción</option>
								</select>
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtDetallePeticion_i" class="form-label">Detalle</label>
								<textarea class="form-control" id="txtDetallePeticion_i" name="txtDetallePeticion_i" rows="4"></textarea>
							</div>
						</div>
						<!--<div class="col-xxl-12 col-md-12 col-12 mb-3">-->
    		<!--				<div>-->
      <!--  						<label for="fileAdjuntoPeticion_i" class="form-label">Seleccione Adjunto:</label>-->
      <!--  						<input class="form-control" type="file" id="fileAdjuntoPeticion_i" name="fileAdjuntoPeticion_i">-->
      <!--  					</div>-->
						<!--</div>-->

						<div class="col-xxl-12 col-md-12 col-12 px-3 mb-3">
							<div>
								<label for="txtLinkPeticion_i" class="form-label">Link Asociado:</label>
								<input type="text" class="form-control" id="txtLinkPeticion_i" name="txtLinkPeticion_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 bg-sistema color-white p-2 mb-3 d-flex justify-content-between align-items-center" style="border-radius: 10px;">
						    Archivos adjuntos
						    <button type="button" class="btn bg-success px-2 py-1" onclick="return agregarAdjunto('ctnAdjuntosPeticiones');" data-tooltip="tooltip" aria-label="Agregar Adjunto">
                                <i class="mdi mdi-plus" style="font-size: 24px; color: #FFF"></i>
                            </button>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 m-0 p-0" id="ctnAdjuntosPeticiones">
						    
						</div>
				  <!--      <div class="col-xxl-4 col-md-12 col-12 px-3 mb-3">-->
						<!--    <div>-->
						<!--		<label for="txtDireccionPeticion_i" class="form-label">Dirección Destino</label>-->
						<!--		<select class="form-select" aria-label="Dirección Destino" id="txtDireccionPeticion_i" name="txtDireccionPeticion_i" style="pointer-events: none; background:#AAA; color:#F5F5F5;">-->
						<!--			<option selected="" value="">Seleccione una opción</option>-->
						<!--		</select>-->
						<!--	</div>-->
						<!--</div>-->
				  <!--      <div class="col-xxl-4 col-md-12 col-12 px-3 mb-3">-->
						<!--    <div>-->
						<!--		<label for="txtAreaPeticion_i" class="form-label">Área Destino</label>-->
						<!--		<select class="form-select" aria-label="Área Destino" id="txtAreaPeticion_i" name="txtAreaPeticion_i" style="pointer-events: none; background:#AAA; color:#F5F5F5;">-->
						<!--			<option selected="" value="">Seleccione una opción</option>-->
						<!--		</select>-->
						<!--	</div>-->
						<!--</div>-->
				  <!--      <div class="col-xxl-4 col-md-12 col-12 px-3 mb-3">-->
						<!--    <div>-->
						<!--		<label for="txtSubareaPeticion_i" class="form-label">Subárea Destino</label>-->
						<!--		<select class="form-select" aria-label="Subárea Destino" id="txtSubareaPeticion_i" name="txtSubareaPeticion_i" style="pointer-events: none; background:#AAA; color:#F5F5F5;">-->
						<!--			<option selected="" value="">Seleccione una opción</option>-->
						<!--		</select>-->
						<!--	</div>-->
						<!--</div>-->
					 <!--   <div class="col-xxl-12 col-md-12 col-12 px-3 mb-3">-->
						<!--	<div>-->
						<!--		<label for="txtDelegacionPeticion_i" class="form-label">CC - LN | Delegacion</label>-->
						<!--		<select class="form-select" aria-label="CC-LN" id="txtDelegacionPeticion_i" name="txtDelegacionPeticion_i">-->
						<!--			<option value="">Seleccione una opción</option>-->
									
						<!--		</select>-->
						<!--	</div>-->
						<!--</div>-->
					 <!--   <div class="col-xxl-12 col-md-12 col-12 px-3" id="ctnCorreosDelegacion">-->
					        
						<!--</div>-->
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Registrar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Exportar Peticiones -->
<div class="modal fade zoomIn" id="exportarReportePeticiones" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleexportarReportePeticiones" aria-hidden="true">
    <div class="modal-dialog modal-md modal-dialog-centered" role="document">
        <div class="modal-content" style="border: none;">
            <div class="modal-header bg-sistema p-3">
                <h4 class="modal-title color-white">Exportar Reporte de Peticiones</h4>
                <button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close">
                </button>
            </div>
            <div class="modal-body">
                <span class="respuesta"></span>
                <div class="row col-12 m-0 p-0">
                    <div class="form-group col-6">
                        <label for="txtFechaInicio_rp">Fecha Inicio</label>
                        <input type="date" class="form-control" id="txtFechaInicio_rp" name="txtFechaInicio_rp" value="<?= date("Y-m-d") ?>">
                        
                    </div>
                    <div class="form-group col-6">
                        <label for="txtFechaFin_rp">Fecha Fin</label>
                        <input type="date" class="form-control" id="txtFechaFin_rp" name="txtFechaFin_rp" value="<?= date("Y-m-d", strtotime('+ 1 days')) ?>">
                    </div>
                    <!-- <a href="#" role="button" class="btn btn-success btn-xs p-2">
						<i class="fas fa-file-excel mr-1"></i>Exportar
					</a> -->
                </div>
            </div>
			<div class="modal-footer">
				<button type="button" class="btn bg-danger d-flex justify-content-end align-items-center color-white" data-bs-dismiss="modal"><span class="mdi mdi-close-thick me-2" style="font-size: 14px;"></span>Cerrar</button>
				<button type="button" id="btnExportarReportePeticiones" class="btn bg-success d-flex justify-content-end align-items-center color-white"><i class="mdi mdi-download me-2 color-white" style="font-size: 14px;"></i>Descargar</button>
			</div>
        </div>
    </div>
</div>

<?php $this->endSection(); ?>