<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $subtitulo ?></h5>
                            <div class="d-flex">
                                <?php
                                if(in_array("CSVITE", $permisos))
                                {
                                ?>
                                <button class="btn bg-info d-flex justify-content-center align-items-center mx-1 color-white" data-bs-toggle="modal" data-bs-target="#importarFicheroItem" id="btnImportarFicheroItem">
									<i class="mdi mdi-file-upload me-1" style="font-size: 14px;"></i>Importar
								</button>
								<?php
                                }
								?>
                                <button type="button" class="btn bg-filtros color-white px-2 py-1 mx-1 waves-effect waves-light layout-rightside-btn" data-bs-toggle="offcanvas" data-bs-target="#theme-settings-offcanvas" aria-controls="theme-settings-offcanvas">
                                    <i class="mdi mdi-filter" style="font-size: 18px;"></i>
                                </button>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblFicheroItem" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<?= $this->section('js'); ?>
<script>
	$(document).ready(function() {
	    /***SERVERSIDE LISTADO DE FICHERO AGING ***/
		assetListVM = {
			dt: null,
			params: {},  // Para almacenar parámetros adicionales de filtro
			init: function () {
				this.dt = $('#tblFicheroItem').DataTable({
					"serverSide": true,
					"processing": true,
					"ajax": {
						"url": baseUrl + "/fichero-item-serverside",
						type: 'POST',
						data: function(d) {
						    let rutavista = window.location.href;
						    let arrayrutavista = rutavista.split("/");
						    d.url_vista = arrayrutavista[arrayrutavista.length-1];
						    
						    // Agregar los parámetros adicionales de filtro a la solicitud
                            $.each(assetListVM.params, function(key, value) {
                                d[key] = value;
                            });
						}
					},
					"columns": [
						{"title": "Documento Cliente", "data": "NroDocumentoCliente", "class": "text-center", "searchable": true },
						{"title": "Cliente", "data": "NombreCliente", "class": "text-center", "searchable": true },
						{"title": "Segmento", "data": "Segmento", "class": "text-center", "searchable": true },
						{"title": "Tipo Factura", "data": "TipoFactura", "class": "text-center", "searchable": true },
						{"title": "Factura Interna", "data": "FacturaInterna", "class": "text-center", "searchable": true },
						{"title": "Factura Externa", "data": "FacturaExterna", "class": "text-center", "searchable": true },
						{"title": "Nro Contrato", "data": "NroContrato", "class": "text-center", "searchable": true },
						{"title": "Importe Facturado", "data": "ImporteFacturado", "class": "text-center", "searchable": true },
						{"title": "Fecha Emisión", "data": "FechaEmision", "class": "text-center", "searchable": true },
						{"title": "Fecha Vencimiento", "data": "FechaVencimiento", "class": "text-center", "searchable": true }
					],
                    "drawCallback": function(settings) {
                        // Re-inicializar tooltips después de que los datos son cargados
                        $('[data-tooltip="tooltip"]').tooltip();
                        $('[data-toggle="tooltip"]').tooltip();
                    },
					"lengthMenu": [[10, 25, 50], [10, 25, 50]],
					responsive: true,
					autoWidth: false,
                    "pageLength": 10,
                    "paging": true,
                    columnDefs: [
                        { responsivePriority: 1, targets: 0 },
                        { responsivePriority: 1, targets: 1 },
                        { responsivePriority: 1, targets: 2 },
                        { responsivePriority: 6, targets: 3 },
                        { responsivePriority: 6, targets: 4 },
                        { responsivePriority: 10, targets: 5 },
                        { responsivePriority: 10, targets: 6 },
                        { responsivePriority: 6, targets: 7 },
                        { responsivePriority: 1, targets: 8 }
                    ],
					"aaSorting": [[0, 'desc']],
				});
			},
			// Método para aplicar filtros adicionales
            applyFilters: function(filters) {
                this.params = filters;  // Actualiza los parámetros de filtro
                
                if (this.dt) {
                    this.dt.clear();  // Limpia los datos previos
                    this.dt.destroy();  // Destruye la instancia actual de DataTable
                }
            
                // Reinicia DataTable con los nuevos filtros
                this.init();
            }
		}

// 		assetListVM.init();
		/****FIN SERVERSIDE LISTADO DE FICHERO AGING ****/
		
        // Disparar el submit del formulario al cargar la página
        $('.filtro').trigger('submit');
        
        pondImportarCSVAging = FilePond.create(
            document.querySelector("#fileCSVItem"), {
                labelIdle: 'Arrastre y suelte el archivo a subir o <span class="filepond--label-action">explore</span>',
                allowMultiple: false,
                instantUpload: false,
                allowProcess: false,
                acceptedFileTypes: ['text/csv'],
                storeAsFile: true, // necesario para enviar archivo en FormData
                onaddfile: (error, fileItem) => {
                    if (error) {
                        console.error('Error al añadir archivo:', error);
                        return;
                    }
                
                    const allowedExtensions = /(\.csv)$/i;
                    const fileName = fileItem.file?.name;
                
                    if (!fileName || !allowedExtensions.exec(fileName)) {
                        Swal.fire({
                            text: "El formato del archivo debe ser CSV.",
                            icon: 'warning',
                            showCancelButton: false,
                            confirmButtonColor: '#282e38',
                            confirmButtonText: 'OK'
                        });
                        pondImportarCSVFacturasCondonacion.removeFile(fileItem.id);
                        return false;
                    }
                
                    return true;
                }
            }
        );
	});
	
    $("#formSubirCSVLinea").on("submit", function(e) {
        e.preventDefault();
    
        const form = $(this)[0];
        const formData = new FormData(form);
    
        $.ajax({
            url: $(form).attr("action"),
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            dataType: "html",
            beforeSend: function () {
                // puedes agregar un loader
            },
            success: function (response) {
                $(".respuesta").html(response);
            },
            error: function () {
                Swal.fire("Error", "No se pudo importar el archivo.", "error");
            }
        });
    });
    
</script>
<?php $this->endSection(); ?>

<!-- Filtros -->
<form class="filtro" autocomplete="off" action="" method="POST" accept-charset="utf-8">
    <div class="offcanvas offcanvas-end border-0" tabindex="-1" id="theme-settings-offcanvas" aria-modal="true" role="dialog">
        <div class="d-flex align-items-center bg-filtros bg-gradient p-3 offcanvas-header">
            <h5 class="m-0 me-2 text-white">Filtros</h5>
    
            <button type="button" class="btn-close btn-close-white ms-auto" id="customizerclose-btn" data-bs-dismiss="offcanvas" aria-label="Close"></button>
        </div>
        <div class="offcanvas-body p-0">
            <!--<div data-simplebar="init" class="h-100 simplebar-scrollable-y">-->
            <!--    <div class="simplebar-wrapper" style="margin: 0px;">-->
            <!--        <div class="simplebar-height-auto-observer-wrapper">-->
            <!--            <div class="simplebar-height-auto-observer">-->
                            
            <!--            </div>-->
            <!--        </div>-->
            <!--        <div class="simplebar-mask">-->
            <!--            <div class="simplebar-offset" style="right: 0px; bottom: 0px;">-->
            <!--                <div class="simplebar-content-wrapper" tabindex="0" role="region" aria-label="scrollable content" style="height: 100%; overflow: hidden scroll;">-->
            <!--                    <div class="simplebar-content" style="padding: 0px;">-->
                <div id="ctnFiltro" class="p-3">
    				<div class="panel">
                        <div class="panel-heading">
                            <h4>Búsqueda</h4>
                        </div>
                        <div class="panel-content">
                            <div class="row">
                                <div class="col-xxl-12 col-md-6 col-12 mb-3">
                					<label for="MesDescuento" class="form-label">Mes</label>
                					<select class="form-select" aria-label="Mes" id="MesDescuento" name="MesDescuento">
                						<option value="01" <?= date("m") == '01' ? 'selected' : '' ?> >ENERO</option>
                						<option value="02" <?= date("m") == '02' ? 'selected' : '' ?> >FEBRERO</option>
                						<option value="03" <?= date("m") == '03' ? 'selected' : '' ?> >MARZO</option>
                						<option value="04" <?= date("m") == '04' ? 'selected' : '' ?> >ABRIL</option>
                						<option value="05" <?= date("m") == '05' ? 'selected' : '' ?> >MAYO</option>
                						<option value="06" <?= date("m") == '06' ? 'selected' : '' ?> >JUNIO</option>
                						<option value="07" <?= date("m") == '07' ? 'selected' : '' ?> >JULIO</option>
                						<option value="08" <?= date("m") == '08' ? 'selected' : '' ?> >AGOSTO</option>
                						<option value="09" <?= date("m") == '09' ? 'selected' : '' ?> >SETIEMBRE</option>
                						<option value="10" <?= date("m") == '10' ? 'selected' : '' ?> >OCTUBRE</option>
                						<option value="11" <?= date("m") == '11' ? 'selected' : '' ?> >NOVIEMBRE</option>
                						<option value="12" <?= date("m") == '12' ? 'selected' : '' ?> >DICIEMBRE</option>
                					</select>
                				</div>
                				<div class="col-xxl-12 col-md-6 col-12 mb-3">
                					<label for="AnioDescuento" class="form-label">Año</label>
                					<select class="form-select" aria-label="Año" id="AnioDescuento" name="AnioDescuento">
                					    <?php
                					    $anioInicial = "2024";
                					    $anioActual = date("Y");
                					    for($i = $anioInicial; $i <= ($anioActual + 2); $i++)
                					    {
                					    ?>
                					    <option value="<?= $i ?>" <?= $i == $anioActual ? 'selected' : '' ?> ><?= $i ?></option>
                					    <?php
                					    }
                					    ?>
                					</select>
                				</div>
                            </div>
                        </div>
                    </div>
                </div>
            <!--                    </div>-->
            <!--                </div>-->
            <!--            </div>-->
            <!--        </div>-->
            <!--        <div class="simplebar-placeholder" style="width: 400px; height: 1978px;">-->
                        
            <!--        </div>-->
            <!--    </div>-->
            <!--    <div class="simplebar-track simplebar-horizontal" style="visibility: hidden;">-->
            <!--        <div class="simplebar-scrollbar" style="width: 0px; display: none;">-->
                        
            <!--        </div>-->
            <!--    </div>-->
            <!--    <div class="simplebar-track simplebar-vertical" style="visibility: visible;">-->
            <!--        <div class="simplebar-scrollbar" style="height: 314px; transform: translate3d(0px, 0px, 0px); display: block;">-->
                        
            <!--        </div>-->
            <!--    </div>-->
            <!--</div>-->
        </div>
        <div class="offcanvas-footer border-top p-3 text-center">
            <div class="row">
                <div class="col-4">
                    <button type="button" class="btn btn-light w-100" id="btnLimpiar">Limpiar</button>
                </div>
                <div class="col-4">
                    <button type="button" class="btn btn-danger w-100" id="btnCerrarFiltros" data-bs-dismiss="offcanvas" aria-label="Close">Cerrar</button>
                </div>
                <div class="col-4">
                    <button type="submit" class="btn btn-primary w-100" id="btnBuscarFiltros">Buscar</button>
                </div>
            </div>
        </div>
    </div>
</form>

<?php
if(in_array("CSVITE", $permisos))
{
?>
<!-- Modal Importar CSV Fichero Aging -->
<div class="modal fade zoomIn" id="importarFicheroItem" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleimportarFicheroItem" aria-hidden="true">
	<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleimportarFicheroItem">importar CSV Fichero Item</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formularioImportarCSVFicheroItem" id="formSubirCSVLinea" autocomplete="off" action="<?= $baseUrl ?>/subir-csv-fichero-item" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="col-12 mb-3">
						<h4>Consideraciones:</h4>
						<ul>
						    <li style="color: blue;">El campo "ANTIGUEDAD" debe ser filtrado y deben quitarse campos vacíos y [NO VENCIDO].</li>
						    <li style="color: blue;">El campo "BALANCEREGULARIZADO" debe ser mayor a 0.</li>
						    <li style="color: blue;">El CSV a subir solo debe contener las filas <br> [CONTRATO, NIF, PLG, NOMBRE, FACTURA, FACTURAEXT, IMPORTEFACT, TIPOFACT, FECHAFACT, FECHACARGOFACT] <br> en ese orden.</li>
						</ul>
					</div>
					<hr>
    				<h4 class="mb-3">Importar archivo:</h4>
					<div class="col-12 mb-0 d-flex justify-content-center">
					    <div class="col-7 m-0 p-0">
					        <input type="file" id="fileCSVItem" class="filepond" name="fileCSVItem" data-max-file-size="100MB" data-max-files="1" />
					    </div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-center align-items-center color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" class="btn bg-success d-flex justify-content-center align-items-center color-white"><i class="mdi mdi-import mx-1" style="font-size: 14px;"></i>Importar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<?php
}
?>

<?php $this->endSection(); ?>