<?php namespace App\Models;

use CodeIgniter\Model;

class UsuarioGruposCarteraClienteModel extends Model {
    protected $table = 'usuario_gruposcarteracliente';
    protected $primaryKey = 'IdUsuario';
    protected $allowedFields = ['IdUsuario', 'IDGrupoCarteraCliente', 'JefeCartera', 'UsuarioRegistra', 'FechaRegistra'];
    protected $useAutoIncrement = false;
    protected $useSoftDeletes = false;
    
    public function listarUsuariosGrupoCarteraCliente($array)
    {
        $builder = $this->db->table('vista_usuarios_grupocarteracliente');
        
        if(isset($array['idusuario']) && $array['idusuario'] != '' && $array['idusuario'] != null)
        {
            $builder->where('IdUsuario', $array['idusuario']);
        }
        
        if(isset($array['idgrupocarteracliente']) && $array['idgrupocarteracliente'] != '' && $array['idgrupocarteracliente'] != null)
        {
            $builder->where('IDGrupoCarteraCliente', $array['idgrupocarteracliente']);
        }
        
        if(isset($array['like']) && $array['like'] != '' && $array['like'] != null)
        {
            $builder->where("(Matricula LIKE '%".$array['like']."%' OR 
            Nombres LIKE '%".$array['like']."%' OR
            Apellidos LIKE '%".$array['like']."%' OR 
            Usuario LIKE '%".$array['like']."%' OR 
            NombreCompleto LIKE '%".$array['like']."%' OR 
            NumeroDoc LIKE '%".$array['like']."%')");
        }
        
        // $sql = $builder->getCompiledSelect(); 
        // log_message('error', 'SQL generado: ' . $sql); // 
        // $datos = $this->db->query($sql)->getResultArray();
        
        // return $datos;
        
        $sql = $builder->getCompiledSelect(); 
        log_message('error', 'SQL generado: ' . $sql); 
        
        $query = $this->db->query($sql);
        if (!$query) {
            $dbError = $this->db->error();
            log_message('error', 'Error en consulta SQL: ' . $dbError['message']);
            return [];
        }

        
        return $query->getResultArray();

    }
    
    public function obtenerCarterasPorUsuario($idUsuario)
    {
        $this->select('gruposcarteracliente.IDGrupoCarteraCliente, gruposcarteracliente.CarteraCliente, gruposcarteracliente.Observacion');
        $this->join('gruposcarteracliente', 'gruposcarteracliente.IDGrupoCarteraCliente = usuario_gruposcarteracliente.IDGrupoCarteraCliente');
        $this->where('usuario_gruposcarteracliente.IdUsuario', $idUsuario);
        $this->where('gruposcarteracliente.Estado', 'A');
        $datos = $this->findAll();
        return $datos;
    }
//      public function obtenerCarterasPorUsuario($idUsuario)
//     {
//         $this->select('gruposcarteracliente.IDGrupoCarteraCliente, gruposcarteracliente.CarteraCliente, gruposcarteracliente.Observacion, ofertanomenclatura_gruposcarteracliente.IDOfertaNomenclatura');
//         $this->join('gruposcarteracliente', 'gruposcarteracliente.IDGrupoCarteraCliente = usuario_gruposcarteracliente.IDGrupoCarteraCliente');
//         $this->join('ofertanomenclatura_gruposcarteracliente', 'ofertanomenclatura_gruposcarteracliente.IDGrupoCarteraCliente = gruposcarteracliente.IDGrupoCarteraCliente', 'left');
//         $this->where('usuario_gruposcarteracliente.IdUsuario', $idUsuario);
//         $this->where('gruposcarteracliente.Estado', 'A');
//         $datos = $this->findAll();
//         return $datos;
//     }
}
