<?php
namespace App\Models;
use CodeIgniter\Model;

class OfertasModel extends Model
{
    protected $table        = 'ofertas';
    protected $primaryKey   = 'IDOfertas';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDMotivo', 'IDOfertaNomenclatura', 'IDGrupoCarteraCliente', 'Observacion', 'Matriz', 'NumeroContrato', 'TipoDescuento', 'Descuento', 'ValorDescuento', 'TiempoOferta', 'MesesTiempoOferta', 'FechaInicio', 'TipoOferta', 'Impacto', 'Fecha_fin', 'CuotaMonitoreo', 'PermanenciaCliente', 'CodigoInfoPoint', 'IDPeticion', 'EstadoFacturacion', 'ObservacionFacturacion', 'UsuarioCrea', 'IDDireccionCrea', 'IDAreaCrea', 'IDSubareaCrea', 'IDDelegacionCrea', 'IDCargoCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listaGeneralOfertas($get, $adicionales)
    {
    // Inicializar el query builder con la vista
        $builder = $this->db->table('vista_general_ofertas');
    
        // Definimos las columnas de referencia para búsqueda y ordenamiento
        $fields = [
            0 => 'IDOfertas',
            1 => 'FechaCrea',
            3 => 'MatriculaCreador',
            4 => 'DireccionSolicitanteCreador',
            5 => 'AreaSolicitanteCreador',
            6 => 'SubareaSolicitanteCreador',
            7 => 'Observacion',
            8 => 'TipoRequerimiento',
            9 => 'Requerimiento',
            10 => 'MotivoRequerimiento',
            11 => 'Estado'
        ];
    
        // Obtener total de registros
        $builderTotal = $this->db->table('vista_general_ofertas');
        $builderTotal->select("COUNT(*) AS total");
        $totalRecords = $builderTotal->get()->getRow()->total;
    
        // Aplicar filtros si hay búsqueda
        if (!empty($get['search']['value'])) {
            $builder->groupStart();
            foreach ($get['columns'] as $k => $column) {
                if ($k == 2) {
                    $builder->orLike("CONCAT(NombresCreador, ' ', ApellidosCreador)", $get['search']['value']);
                } elseif (array_key_exists($k, $fields)) {
                    $builder->orLike($fields[$k], $get['search']['value']);
                }
            }
            $builder->groupEnd();
        }
    
        // Clonar el builder para contar registros filtrados
        $builderFiltered = clone $builder;
        $builderFiltered->select("COUNT(*) AS filtered");
        $filteredQuery = $builderFiltered->get();
        $filteredRecords = $filteredQuery ? $filteredQuery->getRow()->filtered : $totalRecords;
    
        // Seleccionar los campos que se mostrarán
        $builder->select('
            IDOfertas,
            FechaCrea,
            NombresCreador,
            ApellidosCreador,
            MatriculaCreador,
            DireccionSolicitanteCreador,
            AreaSolicitanteCreador,
            SubareaSolicitanteCreador,
            Observacion,
            TipoRequerimiento,
            Requerimiento,
            MotivoRequerimiento,
            EstadoAprobacion,
            Estado
        ');
    
        // Ordenar resultados
        foreach ($get['order'] as $order) {
            $col = $order['column'];
            $dir = $order['dir'];
            if ($col == 2) {
                $builder->orderBy("CONCAT(NombresCreador, ' ', ApellidosCreador)", $dir);
            } elseif (array_key_exists($col, $fields)) {
                $builder->orderBy($fields[$col], $dir);
            }
        }
    
        // Limitar resultados
        $builder->limit($get['length'], $get['start']);
    
        // Obtener resultados finales
        $result = $builder->get()->getResultArray();
    
        // Retornar datos
        return [
            'draw' => $get['draw'],
            'recordsTotal' => $totalRecords,
            'recordsFiltered' => $filteredRecords,
            'data' => $result
        ];
    }

    
    public function obtenerOferta($array)
    {
        $builder = $this->db->table('vista_general_ofertas');
        
        if(!empty($array))
        {
            if(isset($array['IDOfertas']) && $array['IDOfertas'] != '' && $array['IDOfertas'] != null)
            {
                $builder->where('IDOfertas', $array['IDOfertas']);
            }
        }
        
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getRowArray();
        
        return $datos;
    }
    
    public function obtenerNuevasOferta($array)
    {
        $builder = $this->db->table('vista_general_ofertas');
        
        if (!empty($array)) {
            if (isset($array['IDOfertas']) && $array['IDOfertas'] !== '' && $array['IDOfertas'] !== null) {
                $builder->where('IDOfertas', $array['IDOfertas']);
            }
            if (isset($array['TipoOferta']) && $array['TipoOferta'] !== '' && $array['TipoOferta'] !== null) {
                $builder->where('TipoOferta', $array['TipoOferta']);
            }
        }
        $builder->groupStart()
                 ->where("EstadoFacturacion !=", 'APRO')
                 ->orWhere("EstadoFacturacion IS NULL")
             ->groupEnd();
        $sql = $builder->getCompiledSelect(); // útil para debug
        // log_message('debug', 'SQL generado: ' . $sql); // Opcional: para ver la query en logs
    
        $datos = $this->db->query($sql)->getResultArray(); //  Cambiado aquí
    
        return $datos;
    }

    
    public function listaGeneralNuevasOfertas($get, $adicionales)
    {
        $whereNuevasOfertas = [
            'TipoOferta' => 'nuevaOferta',
        ];
        
        // Inicializar builder principal y el de conteo total
        $builder = $this->db->table('vista_general_ofertas');
        $builderTotal = $this->db->table('vista_general_ofertas');
    
        $fields = [
            0 => 'IDOfertas',
            1 => 'FechaCrea',
            2 => 'AreaSolicitanteCreador',
            3 => 'SubareaSolicitanteCreador',
            4 => 'NombresCreador',
            5 => 'NumeroContrato', 
            6 => 'Requerimiento',
            7 => 'MotivoRequerimiento',
            8 => 'Estado'
        ];
    
        // Total general
        $builderTotal->select("COUNT(*) AS total")
             ->where($whereNuevasOfertas)
             ->groupStart()
                 ->where("EstadoFacturacion !=", 'APRO')
                 ->orWhere("EstadoFacturacion IS NULL")
             ->groupEnd();

    
        $totalRecords = $builderTotal->get()->getRow()->total;

        // Armamos el query con filtros
        $builder->select('
            IDOfertas,
            FechaCrea,
            AreaSolicitanteCreador,
            SubareaSolicitanteCreador,
            NombresCreador,
            ApellidosCreador,
            NumeroContrato,
            Requerimiento,
            MotivoRequerimiento,
            Observacion,
            Estado
        ');
    
        // Condición principal
        $builder->where($whereNuevasOfertas)
                ->groupStart()
                 ->where("EstadoFacturacion !=", 'APRO')
                 ->orWhere("EstadoFacturacion IS NULL")
             ->groupEnd();
    
        // Si hay búsqueda
        if (!empty($get['search']['value'])) {
            $builder->groupStart();
            foreach ($get['columns'] as $k => $column) {
                if ($k == 4) {
                    $builder->orLike("CONCAT(NombresCreador, ' ', ApellidosCreador)", $get['search']['value']);
                } elseif (array_key_exists($k, $fields)) {
                    $builder->orLike($fields[$k], $get['search']['value']);
                }
            }
            $builder->groupEnd();
        }
    
        // Clonamos después de todo lo anterior
        $builderFiltered = clone $builder;
        $builderFiltered->select("COUNT(*) AS filtered");
        $filteredRecords = $builderFiltered->get()->getRow()->filtered;
    
        // Ordenamiento
        foreach ($get['order'] as $order) {
            $col = $order['column'];
            $dir = $order['dir'];
            if ($col == 4) {
                $builder->orderBy("CONCAT(NombresCreador, ' ', ApellidosCreador)", $dir);
            } elseif (array_key_exists($col, $fields)) {
                $builder->orderBy($fields[$col], $dir);
            }
        }
    
        // Paginación
        $builder->limit($get['length'], $get['start']);
    
        $result = $builder->get()->getResultArray();
    
        return [
            "draw" => intval($get['draw']),
            "recordsTotal" => $totalRecords,
            "recordsFiltered" => $filteredRecords,
            "data" => $result
        ];
    }

}