<?php
namespace App\Models;
use CodeIgniter\Model;

class OfertasAprobacionModel extends Model
{
    protected $table        = 'ofertas_aprobacion';
    protected $primaryKey   = 'IDAprobacion';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDAprobacion', 'IDOfertas', 'IDUsuarioAprobacion', 'IDDireccionAprobacion', 'IDAreaAprobacion', 'IDSubareaAprobacion', 'IDDelegacionAprobacion', 'IDCargoAprobacion', 'Observacion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listarAprobadoresFacturaCondonacion($array)
    {
        $builder = $this->db->table('vista_aprobadores_facturas_condonaciones');
        
        if(!empty($array))
        {
            if(isset($array['arrayIDFactura']) && $array['arrayIDFactura'] != '' && $array['arrayIDFactura'] != null)
            {
                $builder->whereIn('IDFactura', $array['arrayIDFactura']);
            }
            
            if(isset($array['IDCondonacion']) && $array['IDCondonacion'] != '' && $array['IDCondonacion'] != null)
            {
                $builder->where('IDCondonacion', $array['IDCondonacion']);
            }
            
            if(isset($array['Estado']) && $array['Estado'] != '' && $array['Estado'] != null)
            {
                $builder->where('EstadoSolicitudAprobacion', $array['Estado']);
            }
            
            if(isset($array['Aprobador']) && $array['Aprobador'] != '' && $array['Aprobador'] != null)
            {
                $builder->where('IDUsuarioAprobacion', $array['Aprobador']);
            }
            
            if(isset($array['IDAprobacion']) && $array['IDAprobacion'] != '' && $array['IDAprobacion'] != null)
            {
                $builder->where('IDAprobacion', $array['IDAprobacion']);
            }
        }
        
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getResultArray();
        
        return $datos;
    }
    
    public function obtenerrAprobadorFacturaCondonacion($array)
    {
        $builder = $this->db->table('vista_aprobadores_facturas_condonaciones');
        
        if(!empty($array))
        {
            if(isset($array['IDCondonacion']) && $array['IDCondonacion'] != '' && $array['IDCondonacion'] != null)
            {
                $builder->where('IDCondonacion', $array['IDCondonacion']);
            }
            
            if(isset($array['Estado']) && $array['Estado'] != '' && $array['Estado'] != null)
            {
                $builder->where('EstadoSolicitudAprobacion', $array['Estado']);
            }
            
            if(isset($array['Aprobador']) && $array['Aprobador'] != '' && $array['Aprobador'] != null)
            {
                $builder->where('IDUsuarioAprobacion', $array['Aprobador']);
            }
            
            if(isset($array['IDAprobacion']) && $array['IDAprobacion'] != '' && $array['IDAprobacion'] != null)
            {
                $builder->where('IDAprobacion', $array['IDAprobacion']);
            }
        }
        
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getRowArray();
        
        return $datos;
    }
    
    
    public function cantidadFacturasEstadoAprobador($array)
    {
        $builder = $this->db->table('vista_aprobadores_facturas_condonaciones');
        
        $builder->select('IDUsuarioAprobacion,
            Nombres,
            Apellidos,
            SUM(CASE WHEN EstadoSolicitudAprobacion = "PEND" THEN 1 ELSE 0 END) AS "PEND",
            SUM(CASE WHEN EstadoSolicitudAprobacion = "APRO" THEN 1 ELSE 0 END) AS "APRO",
            SUM(CASE WHEN EstadoSolicitudAprobacion = "RECH" THEN 1 ELSE 0 END) AS "RECH",
            SUM(CASE WHEN EstadoSolicitudAprobacion = "CANC" THEN 1 ELSE 0 END) AS "CANC"');
            
        if(!empty($array))
        {
            if(isset($array['IDCondonacion']) && $array['IDCondonacion'] != '' && $array['IDCondonacion'] != null)
            {
                $builder->where('IDCondonacion', $array['IDCondonacion']);
            }
        }
        
        $builder->groupBy('IDUsuarioAprobacion');
        
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getResultArray();
        
        return $datos;
    }
}