<?php
namespace App\Models;
use CodeIgniter\Model;

class OfertaNomenclaturaModel extends Model
{
    protected $table        = 'oferta_nomenclatura';
    protected $primaryKey   = 'IDOfertaNomenclatura';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDOfertaNomenclatura', 'Revntype', 'DescripcionSBN', 'Tipo', 'Duracion', 'IDDireccionCrea', 'IDAreaCrea', 'IDSubareaCrea', 'Impacto', 'Tiempo', 'RangoPorcentaje', 'Motivo', 'Cuenta', 'DescripcionNavision', 'FechaCrea'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function itemOfertaGrupoCarteraClienteAsociado($idGrupoCarteraCliente, $idUsuario)
    { 
        $where = array(
			'ofertanomenclatura_gruposcarteracliente.IDGrupoCarteraCliente' => $idGrupoCarteraCliente
		);
			    
        $this->select('oferta_nomenclatura.IDOfertaNomenclatura, oferta_nomenclatura.Revntype, oferta_nomenclatura.DescripcionSBN, oferta_nomenclatura.Duracion, oferta_nomenclatura.FechaCrea, oferta_nomenclatura.Cuenta, oferta_nomenclatura.DescripcionNavision,ofertanomenclatura_gruposcarteracliente.IDGrupoCarteraCliente');
        $this->join('ofertanomenclatura_gruposcarteracliente', 'ofertanomenclatura_gruposcarteracliente.IDOfertaNomenclatura = oferta_nomenclatura.IDOfertaNomenclatura');
        $this->where($where);
        
        $datos = $this->findAll(); // Ejecuta la consulta y obtiene los resultados
        return $datos; // Retorna los datos únicos
    }
}