<?php
namespace App\Models;
use CodeIgniter\Model;

class OfertaBitacoraModel extends Model
{
    protected $table        = 'ofertas_bitacora';
    protected $primaryKey   = 'IDBitacoraOferta';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDBitacoraOferta', 'IDOfertas', 'Accion', 'ValorBitacora', 'Comentario', 'UsuarioRegistra', 'FechaRegistra', 'Localhost', 'Estado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listarBitacoraOferta($array)
    {
        $builder = $this->db->table('vista_oferta_bitacora');
        
        if(!empty($array))
        {
            if(isset($array['IDOfertas']) && $array['IDOfertas'] != '' && $array['IDOfertas'] != null)
            {
                $builder->where('IDOfertas', $array['IDOfertas']);
                
                // if(isset($array['exCondonacion']) && $array['exCondonacion'] == 'Y')
                // {
                //     $builder->where('IDAprobacion IS NULL');
                //     $builder->where('IDFacturaCondonacion IS NULL');
                // }
            }
            
            // if(isset($array['idAprobacion']) && $array['idAprobacion'] != '' && $array['idAprobacion'] != null)
            // {
            //     $builder->where('IDAprobacion', $array['idAprobacion']);
            // }
            
            // if(isset($array['idFactura']) && $array['idFactura'] != '' && $array['idFactura'] != null)
            // {
            //     $builder->where('IDFacturaCondonacion', $array['idFactura']);
            // }
            
        }
        
        $builder->orderBy('FechaRegistra', 'DESC');
        
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getResultArray();
        
        return $datos;
    }
    
}