<?php
namespace App\Models;
use CodeIgniter\Model;

class CondonacionesModel extends Model
{
    protected $table        = 'condonaciones';
    protected $primaryKey   = 'IDCondonacion';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDMotivo', 'Observacion', 'IDPeticion', 'UsuarioCrea', 'IDDireccionCrea', 'IDAreaCrea', 'IDSubareaCrea', 'IDDelegacionCrea', 'IDCargoCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listaGeneralCondonaciones($get, $adicionales)
    {
        /*
        * ----------------------------
        * SETEAMOS VISTA A UTILIZAR
        * ----------------------------
        */
    
        $builder = $this->db->table('vista_general_condonaciones');
        
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
    
        // $this->globales = new Globales();
        
        $fields = array(
            0 => 'IDCondonacion', 
            1 => 'FechaCrea', 
            3 => 'Matricula', 
            4 => 'DireccionSolicitante', 
            5 => 'AreaSolicitante', 
            6 => 'SubareaSolicitante', 
            7 => 'Observacion', 
            8 => 'TipoRequerimiento',
            9 => 'Requerimiento',
            10 => 'MotivoRequerimiento',
            11 => 'Estado');
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS (NUEVO)
        * ----------------------------
        */
        
        $builder->select("COUNT(*) AS total");
        $totalQuery = $builder->get();
        $totalRecords = $totalQuery->getRow()->total;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $builder->select('IDCondonacion,
            FechaCrea,
            Nombres,
            Apellidos,
            Matricula,
            DireccionSolicitante,
            AreaSolicitante,
            SubareaSolicitante,
            Observacion,
            TipoRequerimiento,
            Requerimiento,
            MotivoRequerimiento,
            Estado');
            
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $builder->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if($k == 2)
                {
                    $builder->orLike("CONCAT(Nombres, ' ', Apellidos)", $get['search']['value']);
                }
                else 
                {
                    if(array_key_exists($k, $fields))
                    {
                        $builder->orLike($fields[$k], $get['search']['value']);
                    }
                }
            }
            
            $builder->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS FILTRADOS (NUEVO)
        * ----------------------------
        */
        
        $builder->select("COUNT(*) AS filtered");
        $filteredQuery = $builder->get();
        if ($filteredQuery === false) {
            // echo $this->getLastQuery();
            // return [];
            $filteredRecords = $totalRecords;
        }
        $filteredRecords = $filteredQuery->getRow()->filtered;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY (NUEVAMENTE PARA ENVIAR LA DATA)
        * ----------------------------
        */
        
        $builder->select('IDCondonacion,
            FechaCrea,
            Nombres,
            Apellidos,
            Matricula,
            DireccionSolicitante,
            AreaSolicitante,
            SubareaSolicitante,
            Observacion,
            TipoRequerimiento,
            Requerimiento,
            MotivoRequerimiento,
            Estado');
            
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $builder->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if($k == 2)
                {
                    $builder->orLike("CONCAT(Nombres, ' ', Apellidos)", $get['search']['value']);
                }
                else 
                {
                    if(array_key_exists($k, $fields))
                    {
                        $builder->orLike($fields[$k], $get['search']['value']);
                    }
                }
            }
            
            $builder->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) 
        {
            if($order['column'] == 2)
            {
                $this->orderBy("CONCAT(Nombres, ' ', Apellidos)", $order['dir']);
            }
            else
            {
                if(array_key_exists($order['column'], $fields))
                {
                    $field = $fields[$order['column']];
                    
                    // Para las otras columnas, aplica el orden normal
                    $builder->orderBy($field, $order['dir']);
                }
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        
        $builder->limit($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA Y DEVOLVER VALORES
        * ----------------------------
        */
        
        /* Despues de Codeiginiter 4.5.4*/
        $result = $builder->get()->getResultArray();
        
        /*
        * ----------------------------
        * DEVOLVER RESULTADOS Y LOS DATOS DE PAGINACIÓN
        * ----------------------------
        */
        
        return [
            'draw'              => $get['draw'], // Número de la petición para sincronizar
            'recordsTotal'      => $totalRecords, // Total de registros sin filtrar
            'recordsFiltered'   => $filteredRecords, // Total de registros después de aplicar filtros
            'data'              => $result // Los datos actuales para mostrar
        ];
    }
    
    public function obtenerCondonacion($array)
    {
        $builder = $this->db->table('vista_general_condonaciones');
        
        if(!empty($array))
        {
            if(isset($array['IDCondonacion']) && $array['IDCondonacion'] != '' && $array['IDCondonacion'] != null)
            {
                $builder->where('IDCondonacion', $array['IDCondonacion']);
            }
            
            if(isset($array['IDPeticion']) && $array['IDPeticion'] != '' && $array['IDPeticion'] != null)
            {
                $builder->where('IDPeticion', $array['IDPeticion']);
            }
        }
        
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getRowArray();
        
        return $datos;
    }
}