<?php
namespace App\Models;
use CodeIgniter\Model;

class CondonacionesFacturasModel extends Model
{
    protected $table        = 'condonaciones_facturas';
    protected $primaryKey   = 'IDFacturaCondonacion';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDCondonacion', 'NroContrato', 'FacturaInterna', 'FacturaExterna', 'Segmento', 'DeudaTotal', 'ImporteCondonar', 'TipoFactura', 'StatusFactura', 'ObservacionStatus', 'UsuarioStatus', 'FechaStatus', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listaGeneralFacturasCondonacion($get, $adicionales)
    {
        /*
        * ----------------------------
        * SETEAMOS VISTA A UTILIZAR
        * ----------------------------
        */
    
        $builder = $this->db->table('vista_facturas_condonaciones');
        
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
    
        // $this->globales = new Globales();
        
        $fields = array(
            0 => 'IDCondonacion', 
            1 => 'FechaCrea', 
            2 => 'Area', 
            4 => 'NroContrato', 
            5 => 'Segmento', 
            6 => 'FacturaInterna', 
            7 => 'FacturaExterna', 
            8 => 'ImporteCondonar',
            9 => 'TipoFactura',
            10 => 'Requerimiento',
            11 => 'Motivo',
            12 => 'Observacion',
            13 => 'Estado');
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS (NUEVO)
        * ----------------------------
        */
        
        $builder->select("COUNT(*) AS total");
        $totalQuery = $builder->get();
        $totalRecords = $totalQuery->getRow()->total;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $builder->select('IDCondonacion,
            FechaCrea,
            Area,
            Nombres,
            Apellidos,
            NroContrato,
            Segmento,
            FacturaInterna,
            FacturaExterna,
            ImporteCondonar,
            TipoFactura,
            Requerimiento,
            Motivo,
            Observacion,
            Estado');
            
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $builder->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if($k == 3)
                {
                    $builder->orLike("CONCAT(Nombres, ' ', Apellidos)", $get['search']['value']);
                }
                else 
                {
                    if(array_key_exists($k, $fields))
                    {
                        $builder->orLike($fields[$k], $get['search']['value']);
                    }
                }
            }
            
            $builder->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS FILTRADOS (NUEVO)
        * ----------------------------
        */
        
        $builder->select("COUNT(*) AS filtered");
        $filteredQuery = $builder->get();
        if ($filteredQuery === false) {
            // echo $this->getLastQuery();
            // return [];
            $filteredRecords = $totalRecords;
        }
        $filteredRecords = $filteredQuery->getRow()->filtered;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY (NUEVAMENTE PARA ENVIAR LA DATA)
        * ----------------------------
        */
        
        $builder->select('IDCondonacion,
            FechaCrea,
            Area,
            Nombres,
            Apellidos,
            NroContrato,
            Segmento,
            FacturaInterna,
            FacturaExterna,
            ImporteCondonar,
            TipoFactura,
            Requerimiento,
            Motivo,
            Observacion,
            Estado');
            
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $builder->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if($k == 3)
                {
                    $builder->orLike("CONCAT(Nombres, ' ', Apellidos)", $get['search']['value']);
                }
                else 
                {
                    if(array_key_exists($k, $fields))
                    {
                        $builder->orLike($fields[$k], $get['search']['value']);
                    }
                }
            }
            
            $builder->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) 
        {
            if($order['column'] == 3)
            {
                $this->orderBy("CONCAT(Nombres, ' ', Apellidos)", $order['dir']);
            }
            else
            {
                if(array_key_exists($order['column'], $fields))
                {
                    $field = $fields[$order['column']];
                    
                    // Para las otras columnas, aplica el orden normal
                    $builder->orderBy($field, $order['dir']);
                }
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        
        $builder->limit($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA Y DEVOLVER VALORES
        * ----------------------------
        */
        
        /* Despues de Codeiginiter 4.5.4*/
        $result = $builder->get()->getResultArray();
        
        /*
        * ----------------------------
        * DEVOLVER RESULTADOS Y LOS DATOS DE PAGINACIÓN
        * ----------------------------
        */
        
        return [
            'draw'              => $get['draw'], // Número de la petición para sincronizar
            'recordsTotal'      => $totalRecords, // Total de registros sin filtrar
            'recordsFiltered'   => $filteredRecords, // Total de registros después de aplicar filtros
            'data'              => $result // Los datos actuales para mostrar
        ];
    }
    
    // public function listarFacturasCondonacion($array)
    // {
    //     $this->select('condonaciones_facturas.IDFacturaCondonacion,
    //         condonaciones_facturas.IDCondonacion,
    //         condonaciones_facturas.NroContrato,
    //         condonaciones_facturas.FacturaInterna,
    //         condonaciones_facturas.FacturaExterna,
    //         condonaciones_facturas.Segmento,
    //         condonaciones_facturas.DeudaTotal,
    //         condonaciones_facturas.ImporteCondonar,
    //         condonaciones_facturas.TipoFactura,
    //         condonaciones.Observacion,
    //         peticiones.FechaCrea AS "FechaPeticion"');
    //     $this->join('condonaciones', 'condonaciones_facturas.IDCondonacion = condonaciones.IDCondonacion', 'left');
    //     $this->join('peticiones', 'condonaciones.IDPeticion = peticiones.IDPeticion', 'left');
        
        // if(!empty($array))
        // {
        //     if(isset($array['IDCondonacion']) && $array['IDCondonacion'] != '' && $array['IDCondonacion'] != null)
        //     {
        //         $this->where('condonaciones_facturas.IDCondonacion', $array['IDCondonacion']);
        //     }
            
        //     if(isset($array['Estado']) && $array['Estado'] != '' && $array['Estado'] != null)
        //     {
        //         $this->where('condonaciones_facturas.Estado', $array['Estado']);
        //     }
        // }
        
    //     $datos = $this->findAll();
    //     return $datos;
    // }
    
    public function listarFacturasCondonacion($array)
    {
        $builder = $this->db->table('vista_peticiones_facturas_condonacion');
        
        if(!empty($array))
        {
            if(isset($array['IDCondonacion']) && $array['IDCondonacion'] != '' && $array['IDCondonacion'] != null)
            {
                $builder->where('IDCondonacion', $array['IDCondonacion']);
            }
            
            if(isset($array['Estado']) && $array['Estado'] != '' && $array['Estado'] != null)
            {
                $builder->where('EstadoFacturaCondonacion', $array['Estado']);
            }
        }
        
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getResultArray();
        
        return $datos;
    }
    
    
    public function listadoAcumuladosFacturaCondonacion($array)
    {
        if(isset($array['GroupBy']) && !empty($array['GroupBy']))
        {
            if($array['GroupBy'] == "Contrato")
            {
                $this->select('condonaciones_facturas.IDCondonacion,
                    condonaciones_facturas.NroContrato AS "Columna_Agrupada",
                    SUM(condonaciones_facturas.DeudaTotal) AS "Acumulado_DeudaTotal",
                    SUM(condonaciones_facturas.ImporteCondonar) AS "Acumulado_ImporteCondonar"');
            }
            else if($array['GroupBy'] == "TipoFactura")
            {
                $this->select('condonaciones_facturas.IDCondonacion,
                    condonaciones_facturas.TipoFactura AS "Columna_Agrupada",
                    SUM(condonaciones_facturas.DeudaTotal) AS "Acumulado_DeudaTotal",
                    SUM(condonaciones_facturas.ImporteCondonar) AS "Acumulado_ImporteCondonar"');
            }
            else if($array['GroupBy'] == "Segmento")
            {
                $this->select('condonaciones_facturas.IDCondonacion,
                    condonaciones_facturas.Segmento AS "Columna_Agrupada",
                    SUM(condonaciones_facturas.DeudaTotal) AS "Acumulado_DeudaTotal",
                    SUM(condonaciones_facturas.ImporteCondonar) AS "Acumulado_ImporteCondonar"');
            }
            else
            {
                $this->select('condonaciones_facturas.IDCondonacion,
                    SUM(condonaciones_facturas.DeudaTotal) AS "Acumulado_DeudaTotal",
                    SUM(condonaciones_facturas.ImporteCondonar) AS "Acumulado_ImporteCondonar"');
            }
        }
        else
        {
            $this->select('condonaciones_facturas.IDCondonacion,
                SUM(condonaciones_facturas.DeudaTotal) AS "Acumulado_DeudaTotal",
                SUM(condonaciones_facturas.ImporteCondonar) AS "Acumulado_ImporteCondonar"');
        }
        
        
        if(!empty($array))
        {
            if(isset($array['IDCondonacion']) && !empty($array['IDCondonacion']))
            {
                $this->where('condonaciones_facturas.IDCondonacion', $array['IDCondonacion']);
            }
            
            if(isset($array['arrayNoEstados']) && !empty($array['arrayNoEstados']))
            {
                $this->whereNotIn('condonaciones_facturas.Estado', $array['arrayNoEstados']);
            }
        }
        
        
        if(isset($array['GroupBy']) && !empty($array['GroupBy']))
        {
            if($array['GroupBy'] == "Contrato")
            {
                $this->groupBy(array('IDCondonacion', 'NroContrato'));
            }
            else if($array['GroupBy'] == "TipoFactura")
            {
                $this->groupBy(array('IDCondonacion', 'TipoFactura'));
            }
            else if($array['GroupBy'] == "Segmento")
            {
                $this->groupBy(array('IDCondonacion', 'Segmento'));
            }
            else
            {
                $this->groupBy('IDCondonacion');
            }
        }
        else
        {
            $this->groupBy('IDCondonacion');
        }
        
        // $this->get();
        // return $this->getLastQuery();
        
        if(isset($array["return"]) && $array['return'] == 'row')
        {
            $datos = $this->first();
        }
        else
        {
            $datos = $this->findAll();
        }
        
        
        return $datos;
    }
    
}