<?php
namespace App\Models;
use CodeIgniter\Model;

class CondonacionesCobranzaBitacoraModel extends Model
{
    protected $table        = 'condonaciones_cobranzas_bitacora';
    protected $primaryKey   = 'IDBitacoraCobranza';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDSolicitudCobranza', 'Accion', 'ValorBitacora', 'Comentario', 'Link', 'UsuarioRegistra', 'FechaRegistra', 'Localhost', 'Estado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listarBitacoraCondonacionCobranza($array)
    {
        $builder = $this->db->table('vista_condonaciones_cobranza_bitacora');
        
        if(!empty($array))
        {
            if(isset($array['IDSolicitudCobranza']) && $array['IDSolicitudCobranza'] != '' && $array['IDSolicitudCobranza'] != null)
            {
                $builder->where('IDSolicitudCobranza', $array['IDSolicitudCobranza']);
            }
        }
        
        $builder->orderBy('FechaRegistra', 'DESC');
        
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getResultArray();
        
        return $datos;
    }
    
}