<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;

class Ofertas extends BaseController
{
	public function __construct(){
	    
	    $this->db = \Config\Database::connect();
	    
	    $this->peticiones                       = new \App\Models\PeticionesModel();
	    $this->peticionesComentarios            = new \App\Models\PeticionesComentariosModel();
	    
		$this->usuarios         = new \App\Models\UsuarioModel();
		$this->estructuraSubareas   = new \App\Models\EstructuraSubareaModel();
		
		$this->usuarioGruposCarteraCliente = new \App\Models\UsuarioGruposCarteraClienteModel();
		$this->itemOfertaGrupoCarteraCliente = new \App\Models\ItemOfertaGrupoCarteraClienteModel();
		$this->ofertas = new \App\Models\OfertasModel();
		$this->ofertasAprobacion = new \App\Models\OfertasAprobacionModel();
		$this->ofertasNomenclatura = new \App\Models\OfertaNomenclaturaModel();
		$this->grupoCarteraCliente = new \App\Models\GruposCarteraClienteModel();
		
	    $this->ofertaBitacora = new \App\Models\OfertaBitacoraModel();
	}

	/***************************************************************************/
	
    /********************************* OFERTAS *********************************/
    public function listarOfertas()
    {
        if(isset($this->items['id']))
        {
        
            if($this->items['idPerfil'] == 11)
            {
                $data = array (
    				'session'                   => 'on',
    				'titulo'                    => 'Gestión de Nuevas Ofertas | Verisure',
    				'breadcrumb'                => $this->items['modulo'],
    				'breadcrumb_alias'          => 'Ofertas',
    				'elementoSeleccionadoModulo'=> "Listado de Nuevas Ofertas",
    				'subtitulo'                 => 'Ofertas'
    			);
    			
    			$data = array_merge($data, $this->items);
    			
    			return view('procesos/Ofertas/gestion_ofertas_masivas',$data);			
            }
            else
            {
                $idUsuario = $this->items['id'];
                // $idUsuario = 5618;
                $solicitante = $this->usuarios->buscarUsuario($this->items['id']);
                $datosGrupoCarteraCliente = $this->usuarioGruposCarteraCliente->obtenerCarterasPorUsuario($idUsuario);
                
    			$data = array (
    				'session'                   => 'on',
    				'titulo'                    => 'Ofertas | Verisure',
    				'breadcrumb'                => $this->items['modulo'],
    				'breadcrumb_alias'          => 'Ofertas',
    				'elementoSeleccionadoModulo'=> "Listado de Ofertas",
    				'subtitulo'                 => 'Ofertas',
    				'usuarioSolicitante'        => $solicitante,
    				'datosGrupoCarteraCliente'  => $datosGrupoCarteraCliente
    			);
    			
    			$data = array_merge($data, $this->items);
    			
    			return view('procesos/Ofertas/listar_ofertas',$data);			
            }    
        
		} 
		else 
		{
			return view('errors/500');
		}
    }    
	/**************************************************************************/
	
	public function analizarDatosMatrizOferta()
    {
        if(isset($this->items['id']))
        {
    
    		/*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idUsuario = $this->items['id'];
            // $idUsuario = 5618;
    		$area = $this->request->getPost('area');
            $matricula = $this->request->getPost('matricula');
            $requerimiento = $this->request->getPost('requerimiento');
            $motivo = $this->request->getPost('motivo'); 
    
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($area, 'required|trim|minlength[1]|maxlength[11]', 'Area');
    		$error .= $this->complementos->validaCampo($matricula, 'required|trim|minlength[1]|maxlength[6]', 'Matricula');
    		$error .= $this->complementos->validaCampo($requerimiento, 'required|trim|minlength[1]|maxlength[11]', 'Requerimiento');
    		$error .= $this->complementos->validaCampo($motivo, 'required|trim|minlength[1]|maxlength[11]', 'Motivo');
    
    		if ($error != '') {
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$datosGrupoCarteraCliente = $this->usuarioGruposCarteraCliente->obtenerCarterasPorUsuario($idUsuario);
    		if (empty($datosGrupoCarteraCliente)) {
                echo $this->alertas->alertaError("El usuario no pertenece a una carteras asociadas.");
                exit;
            } else {
                if($area == ''){
                    
                }
            }



    // 		if(!empty($datosGrupoCarteraCliente)){
    // 			$resultado = array(
    // 				'idgrupotrabajo'    => (string) $idGrupoCarteraCliente,
    // 				'grupotrabajo'      => (string) $datosGrupoCarteraCliente['CarteraCliente'],
    // 				'observacion'       => (string) $datosGrupoCarteraCliente['Observacion']
    // 			);
    // 		} else {
    // 			$resultado = array(
    // 				'descripcion' => 0
    // 			);
    // 		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado);		
        
		} 
		else 
		{
			return view('errors/500');
		}
    } 
    
    public function listadoItemOferta()
    {
        if(isset($this->items['id']))
        {
            $grupoTipoCartera = $this->request->getPost("grupoTipoCartera"); 
            $tiempoOferta = $this->request->getPost("tiempoOferta");
        
            /*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($grupoTipoCartera, 'required|trim|minlength[1]|maxlength[11]', 'Tipo Cartera ');
    		$error .= $this->complementos->validaCampo($tiempoOferta, 'required|trim|minlength[1]|maxlength[20]', 'Tiempo de Oferta');
    
    		if ($error != '') {
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    		
            
            if($grupoTipoCartera != '' && $grupoTipoCartera != null && $grupoTipoCartera != "undefined")
            {
                
                $listado = $this->itemOfertaGrupoCarteraCliente->obtenerItemsOferta($grupoTipoCartera,$tiempoOferta);
            }
            else
            {
                $listado =array();
            }
            
            $elementos=array();
    
    		if (!empty($listado)) {
                foreach ($listado as $items) {
                    $elementos[] = array(
    					'id' => (int) $items['IDOfertaNomenclatura'],
                        'text' => (string) $items['Revntype'] . ' | ' . (string) $items['DescripcionSBN']
                    );
                }
    
                $resultado = array(
    				'listadoItemOferta' => json_encode($elementos)
    			);
            } else {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
        } 
        else 
        {
    		$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
    }
    
    public function validarContrato()
    {
        if (!isset($this->items['id'])) {
            return view('errors/500');
        }
    
        $nroContrato = $this->request->getPost("nroContrato"); 
        $itemOferta = $this->request->getPost("itemOferta"); 
        $grupoTipoCartera = $this->request->getPost("grupoTipoCartera");  
        $tiempoOferta = $this->request->getPost("tiempoOferta"); 
        $subArea = 'Atencion al Cliente';
    
        // Validaciones básicas
        $error = '';
        $error .= $this->complementos->validaCampo($nroContrato, 'required|trim|numeric|minlength[1]|maxlength[11]', 'Número Contrato');
        $error .= $this->complementos->validaCampo($itemOferta, 'required|trim|numeric|minlength[1]|maxlength[11]', 'Item Oferta');
        $error .= $this->complementos->validaCampo($grupoTipoCartera, 'required|trim|minlength[1]|maxlength[11]', 'Tipo Cartera');
        $error .= $this->complementos->validaCampo($tiempoOferta, 'required|trim|minlength[1]|maxlength[20]', 'Tiempo de Oferta');
    
        if ($error !== '') {
            echo $this->alertas->alertaError(sprintf($this->mensajeError->msg201, $error));
            exit;
        }
    
        // Datos simulados o provenientes de otra lógica
        $aprobacionSegundaCapa = 'SI';
        $descuentoVigente = 'NO';
        $deudaVigente = 'NO';
        $cuotaMonitoreo = 160;
        $permanenciaCliente = 37;
        
        $whereGrupoCartera = array(
			    'IDGrupoCarteraCliente'  => $grupoTipoCartera
			);
        $grupoCartera = $this->grupoCarteraCliente->select('CarteraCliente')->where($whereGrupoCartera)->first();
       
        if ($grupoCartera == '') {
			$message = sprintf($this->mensajeError->msg201, 'Usuario no pertenece a Grupo Cartera');
			echo $this->alertas->alertaError($message);
			exit;
		}
		
        $nombreCartera = $grupoCartera['CarteraCliente'];
        
        $response = [
            'status' => 'ok',
            'tipoDescuento' => '',
            'valorDescuento' => [],
            'cantidadMeses' => [],
            'cuotaMonitoreo' => $cuotaMonitoreo,
            'permanenciaCliente' => $permanenciaCliente,
            'deudaVigente' => $deudaVigente,
            'descuentoVigente' => $descuentoVigente
        ];
    
        switch ($grupoTipoCartera) { // cambias por $nombreCartera ya que la validacion sera por el tipo cartera
            // case 'ATENCION AL CLIENTE':
            case 8:
                if ($descuentoVigente === 'SI' || $deudaVigente === 'SI') {
                    echo $this->alertas->alertaError('El cliente no puede recibir una oferta porque tiene un descuento o deuda vigente.');
                    exit;
                }
                $response['min'] = 0;
                $response['max'] = 15;
                $response['tipoDescuento'] = 'porcentaje';
    
                if ($tiempoOferta === 'Permanente') {
                    $response['valorDescuento'] = [5, 10];
                    $response['cantidadMeses'] = [-1];
                } else {
                    $response['valorDescuento'] = [30, 40, 50];
                    $response['cantidadMeses'] = [3, 6, 9, 12];
                }
                break;
            case 9:
            case 10:
                if ($descuentoVigente === 'SI' || $deudaVigente === 'SI') {
                    echo $this->alertas->alertaError('El cliente no puede recibir una oferta porque tiene un descuento o deuda vigente.');
                    exit;
                }
                $response['min'] = 0;
                $response['max'] = 100;
                $response['tipoDescuento'] = 'porcentaje';
    
                if ($tiempoOferta === 'Permanente') {
                    $response['valorDescuento'] = [5, 10];
                    $response['cantidadMeses'] = [-1];
                } else {
                    $response['valorDescuento'] = [30, 40, 50];
                    $response['cantidadMeses'] = [3, 6, 9, 12];
                }
                break;
    
            // case 'RETENCION':
            // case 'Portfolio':
            case 1:
            case 3:
            case 4:
            case 6:
                if ($cuotaMonitoreo < 100) {
                    echo $this->alertas->alertaError('Cuota fuera de rango (Matriz).');
                    exit;
                }
                
                $response['min'] = 10;
                $response['max'] = 120;
                $response['tipoDescuento'] = 'soles';
                $permanenciaAlta = ($permanenciaCliente >= 34 && $permanenciaCliente <= 38); // La opción de Reactiva solo se da a los clientes que cumplan esta condición
    
                if ($permanenciaAlta) {
    
                    if ($tiempoOferta === 'Temporal') {
                        $response['valorDescuento'] = $this->getValorDescuentoTemporalPortfolio34a38($cuotaMonitoreo);
                        $response['cantidadMeses'] = [6, 9];
                    } else {
                        $response['valorDescuento'] = $this->getValorDescuentoPermanentePortfolio34a38($cuotaMonitoreo);
                        $response['cantidadMeses'] = [-1];
                    }
    
                } else {
                    if ($tiempoOferta === 'Temporal') {
                        $response['cantidadMeses'] = [6, 9];
                        $response['valorDescuento'] = $this->getValorDescuentoTemporalPortfolio($cuotaMonitoreo);
                    } else {
                        $response['cantidadMeses'] = [-1];
                        $response['valorDescuento'] = $this->getValorDescuentoPermanentePortfolio($cuotaMonitoreo);
                    }
                }
                break;
                
            // case 'Portfolio Telecierre':
            case 5:
                if ($cuotaMonitoreo < 100) {
                    echo $this->alertas->alertaError('Cuota fuera de rango (Matriz).');
                    exit;
                }
                
                $response['min'] = 10;
                $response['max'] = 120;
                $response['tipoDescuento'] = 'soles';
                $permanenciaAlta = ($permanenciaCliente >= 34 && $permanenciaCliente <= 38); // La opción de Reactiva solo se da a los clientes que cumplan esta condición
                
                if ($permanenciaAlta) { 
                    
                    if ($tiempoOferta === 'Temporal') { 
                        $response['valorDescuento'] = $this->getValorDescuentoTemporalPortfolioTelecierre34a38($cuotaMonitoreo);
                    
                        $response['cantidadMeses'] = [6, 9, 12];
                    } else {
                        $response['valorDescuento'] = $this->getValorDescuentoPermanentePortfolioTelecierre34a38($cuotaMonitoreo);
                        $response['cantidadMeses'] = [-1];
                    }
    
                } else { 
                    if ($tiempoOferta === 'Temporal') {
                        $response['cantidadMeses'] = [6, 9, 12];
                        $response['valorDescuento'] = $this->getValorDescuentoTemporalPortfolioTelecierre($cuotaMonitoreo);
                    } else {
                        $response['cantidadMeses'] = [-1];
                        $response['valorDescuento'] = $this->getValorDescuentoPermanentePortfolioTelecierre($cuotaMonitoreo);
                    }
                }
                break;
                
            // case 'GESTION CFLS':
            case 2:
                
                $response['min'] = 0;
                $response['max'] = 100;
                if ($tiempoOferta === 'Temporal') {
                    $response['tipoDescuento'] = 'porcentaje';
                    $response['valorDescuento'] = [15, 20, 30];
                    $response['cantidadMeses'] = [3, 6];
                }
                break;
                
            // case 'PRE RETENCION': 
            case 7: 
                
                if ($cuotaMonitoreo < 100) {
                    echo $this->alertas->alertaError('Cuota fuera de rango (Matriz).');
                    exit;
                }
                
                $response['min'] = 0;
                $response['max'] = 100;
                $response['tipoDescuento'] = 'soles';
                
                if ($tiempoOferta === 'Temporal') {
                    $response['valorDescuento'] = $this->getValorDescuentoTemporal($cuotaMonitoreo);
                    $response['cantidadMeses'] = [6, 9];
                }else{
                    $response['cantidadMeses'] = [-1];
                    $response['valorDescuento'] = $this->getValorDescuentoPermanente($cuotaMonitoreo);
                }
        }
    
        return $this->response->setJSON($response);
    }
    
    public function registrarOferta()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        $error = '';
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        //Información de Condonación
        
        $motivoRequerimiento = $this->request->getPost('txtMotivoRequerimiento_rcond');
        $itemOferta          = $this->request->getPost("txtItemOferta_rcond");
        $grupoTipoCartera    = $this->request->getPost("txtTipoCartera_rcond"); 
        $matrizPost          = $this->request->getPost("txtMatriz_rcond");
        $matriz = !empty($matrizPost)  ? "Fuera" : "Dentro";
        $observaciones       = $this->request->getPost('txtObservaciones_rcond');
        $NumeroContrato      = $this->request->getPost('txtNroContrato_rcond'); 
        $TipoDescuento       = $this->request->getPost('txtTipoDescuento_rcond');
        $Descuento           = $this->request->getPost('input-middle-value'); 
        $ValorDescuento      = $this->request->getPost('valorDescuento'); 
        $TiempoOferta        = $this->request->getPost('txtTiempoOferta_rcond');
        $MesesTiempoOferta   = $this->request->getPost('selectCantidadMeses'); 
        $FechaInicio         = $this->request->getPost('fechaInicio');
        $TipoOferta          = $this->request->getPost('txtTipoOferta_rcond'); 
        // $Impacto             = $this->request->getPost('txtImpacto_rcond'); // Data va en duro
        $Fecha_fin           = '2025-09-17'; // posiblemente este campo se ira de la tabla ofertas
        // $Comentarios         = $this->request->getPost('txtObservacionesOfertas_rcond'); // este campo se ira
        $CuotaMonitoreo      = $this->request->getPost('cuotaMonitoreo');
        $permanenciaCliente  = $this->request->getPost('permanenciaCliente');
        $codigoInfoPoint     = $this->request->getPost('txtCodigoInfoPoint_rcond');
        
        $estadoAprobador = $matriz == 'Dentro'?'APRO':'PEND';


        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($motivoRequerimiento, 'required|trim|numeric|minlength[1]|maxlength[11]', 'Motivo Requerimiento');
        $error .= $this->complementos->validaCampo($observaciones, 'required|trim|minlength[1]|maxlength[50]', 'Observaciones');
        $error .= $this->complementos->validaCampo($NumeroContrato, 'required|trim|numeric|minlength[1]|maxlength[18]', 'Número Contrato');
        $error .= $this->complementos->validaCampo($TipoDescuento, 'required|trim|minlength[5]|maxlength[15]', 'Tipo Descuento');
        $error .= $this->complementos->validaCampo($Descuento, 'required|trim|numeric|minlength[1]|maxlength[3]', 'Descuento');
        $error .= $this->complementos->validaCampo($ValorDescuento, 'required|trim|minlength[1]|maxlength[14]', 'Valor Descuento');
        $error .= $this->complementos->validaCampo($TiempoOferta, 'required|trim|minlength[8]|maxlength[10]', 'Tiempo Oferta');
        $error .= $this->complementos->validaCampo($MesesTiempoOferta, 'required|trim|minlength[1]|maxlength[10]', 'Meses Tiempo oferta');
        $error .= $this->complementos->validaCampo($FechaInicio, 'required|trim|minlength[1]|maxlength[10]', 'Fecha inicio');
        $error .= $this->complementos->validaCampo($TipoOferta, 'required|trim|minlength[1]|maxlength[20]', 'Tipo Oferta');
        // $error .= $this->complementos->validaCampo($Impacto, 'required|trim|minlength[1]|maxlength[50]', 'Impacto');
        $error .= $this->complementos->validaCampo($Fecha_fin, 'required|trim|minlength[1]|maxlength[10]', 'Fecha Fin');
        // $error .= $this->complementos->validaCampo($Comentarios, 'required|trim|minlength[1]|maxlength[250]', 'Comentarios');
        $error .= $this->complementos->validaCampo($CuotaMonitoreo, 'required|trim|minlength[1]|maxlength[6]', 'Cuota Monitoreo');
        $error .= $this->complementos->validaCampo($permanenciaCliente, 'required|trim|minlength[1]|maxlength[5]', 'Permanencia Cliente');
        $error .= $this->complementos->validaCampo($codigoInfoPoint, 'required|trim|minlength[1]|maxlength[20]', 'Código InfoPoint');
        $error .= $this->complementos->validaCampo($itemOferta, 'required|trim|numeric|minlength[1]|maxlength[11]', 'Item');
        $error .= $this->complementos->validaCampo($grupoTipoCartera, 'required|trim|numeric|minlength[1]|maxlength[11]', 'Grupo Cartera');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        
        /*
        * ----------------------------
        * INICIAR TRANSACCIÓN PARA EJECUTAR PROCESOS DE BASE DE DATOS
        * ----------------------------
        */
        //ARMADO DE VALORES DE OFERTA
        $data = array (
            'IDMotivo'              => $motivoRequerimiento,
            'IDOfertaNomenclatura'  => $itemOferta,
            'IDGrupoCarteraCliente' => $grupoTipoCartera,
            'Matriz'                => $matriz,
            'Observacion'           => $observaciones,
            'NumeroContrato'        => $NumeroContrato,
            'TipoDescuento'         => $TipoDescuento,
            'Descuento'             => $Descuento,
            'ValorDescuento'        => $ValorDescuento,
            'TiempoOferta'          => $TiempoOferta,
            'MesesTiempoOferta'     => $MesesTiempoOferta,
            'FechaInicio'           => $FechaInicio,
            'TipoOferta'            => $TipoOferta,
            'Impacto'               => 'Cuota de Monitoreo',
            'Fecha_fin'             => $Fecha_fin,
            // 'Comentarios'         => $Comentarios,
            'CuotaMonitoreo'        => $CuotaMonitoreo,
            'PermanenciaCliente'    => $permanenciaCliente,
            'CodigoInfoPoint'       => $codigoInfoPoint,
            'UsuarioCrea'           => $this->items['id'],
            'IDDireccionCrea'       => $this->items['dpto'],
            'IDAreaCrea'            => $this->items['idArea'],
            'IDSubareaCrea'         => $this->items['idSubarea'],
            'IDDelegacionCrea'      => $this->items['idDelegacionLog'],
            'IDCargoCrea'           => $this->items['idCargoLog'],
            'FechaCrea'             => $fechaActual,    
            'Localhost'             => $this->request->getIPAddress(),
            'UsuarioEstado'         => $this->items['id'],
            'FechaEstado'           => $fechaActual,    
            'MotivoEstado'          => $observaciones == '' ? "Solicitud de Oferta" : $observaciones,    
            'Estado'                => $estadoAprobador
        );
        
        //INSERCIÓN DE OFERTAS
        $lastIdOferta = $this->ofertas->insert($data, TRUE);
        
        if($lastIdOferta !== FALSE){
            
            // $estadoAprobador = $matriz == 'Dentro'?'APRO':'PEND';

                if($matriz === 'Dentro'){ // Si esta APRO significa que debe notificarse a peticion - facturacion
                    
                    if($TipoOferta === "remplazoOferta"){ // si es remplazo oferta deberia ir para peticiones a gestionarse uno a uno sino irse a la gestion masiva
                        /*
                        * ----------------------------
                        * ARMAR INFORMACIÓN DE PETICIÓN
                        * ----------------------------
                        */
                        
                        $arrayPeticionOferta = array(
                            'Peticion'              => 'Solicitud de Oferta #'.$lastIdOferta,
                            'IDMotivo'              => $motivoRequerimiento,
                            'Detalle'               => $observaciones,
                            'IDGrupoTrabajoDestino' => 6, //Facturacion
                            'UsuarioCrea'           => $this->items['id'],
                            'FechaCrea'             => $fechaActual,
                            'IDSubareaCrea'         => $this->items['idSubarea'], 
                            'IDAreaCrea'            => $this->items['idArea'], 
                            'IDDireccionCrea'       => $this->items['dpto'], 
                            'IDPerfilCrea'          => $this->items['idPerfil'],
                            'IDDelegacionCrea'      => $this->items['idDelegacionLog'],
                            'IDCargoCrea'           => $this->items['idCargoLog'],
                            'Estado'                => "CREA", 
                            'UsuarioEstado'         => $this->items['id'],
                            'IDDireccionEstado'     => $this->items['dpto'], 
                            'IDAreaEstado'          => $this->items['idArea'], 
                            'IDSubareaEstado'       => $this->items['idSubarea'], 
                            'IDDelegacionEstado'    => $this->items['idDelegacionLog'],
                            'IDPerfilEstado'        => $this->items['idPerfil'],
                            'IDCargoEstado'         => $this->items['idCargoLog'],
                            'FechaEstado'           => $fechaActual,
                            'MotivoEstado'          => 'Solicitud de Oferta #'.$lastIdOferta,
                            'Localhost'             => $this->request->getIPAddress(),
                            'NroContrato'           => $NumeroContrato
                        );
                        
                        /*
                        * ----------------------------
                        * ENVIAR INFORMACIÓN A REGISTRAR PETICIÓN Y OBTENER EL ID DE PETICIÓN 
                        * ----------------------------
                        */
                        
                        $idPeticion = $this->peticiones->insert($arrayPeticionOferta, TRUE);
                        
                        if($idPeticion === FALSE)
                		{
                		    
                            /*
                            * ----------------------------
                            * INSERCIÓN DE NOTIFICACIÓN
                            * ----------------------------
                            */
                            
                            $nuevaNotificacion = array (
                                'tabla'             => 'peticiones', 
                                'idreferencia'      => $idPeticion,
                                'mensaje'           => "Se ha <span class='color-crea'>CREADO</span> una nueva petición.", 
                                'url'               => "detalle-peticion/".$idPeticion, 
                                'usuariodestino'    => null, 
                                'gtdestino'         => 6, 
                                'perfildestino'     => null,
                                'usuarioregistra'   => $this->items['id'],
                                'fecharegistra'     => $fechaActual
                            );
                            
                            $this->insertarNotificacion($nuevaNotificacion);
                            
                		    
                		    $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar la petición. Inténtelo luego.</li>");
                            
                            $resultado = array(
                				'result'    => (string) 0,
                				'mensaje'  => (string) $this->alertas->alertaError($message)
                			);
                			
                			echo json_encode($resultado);
                			
                			EXIT;
                		}else{
                		  /*
                            * ----------------------------
                            * ARMADO DE UPDATE
                            * ----------------------------
                            */
                    
                            $data = array (
                                'IDPeticion'   => $idPeticion
                            );
                    
                            $lastIdPeticionOferta = $this->ofertas->update([$lastIdOferta], $data);
                		}
                    }
                    
                    /*
                    * ----------------------------
            		 ACCIONES
                    * ----------------------------
            		*/
            		$correoCopia = array();
                    $correoDestino = array();
                    // $correoDestino[] = 'incidenciasfact@verisure.pe'; // descomentar
                    $correoDestino[] = 'placido.curi@verisure.pe'; // Eliminar despues de Descomentar la linea anterior
                    $correoCopia[] = $this->items['correoElectronico'];
            		
                    $arrayCuerpo = array(
                        "TITULO" => "SOLICITUD DE Oferta #".$lastIdOferta,
                        "BASE_URL"  => base_url(),
                        'basePublic'    => $this->items['basePublic'],
                        'baseDinamic'   => $this->items['baseDinamic'],
                        "MODULO" => "OFERTAS",
                        "USUARIO" => ucwords(mb_strtolower($this->items['nombres'].' '.$this->items['apellidos'])),
                        "MENSAJE" => "Solicitud de Oferta. Ingresa al sistema Petitracking para poder gestionarlo.",
                        "URL_MODULO" => base_url()."/detalle-Oferta/".$lastIdOferta
                    );
                
                    $cuerpo = $this->plantillasCorreo->avisoPetitracking($arrayCuerpo);
                    
                	/*
                    * ----------------------------
                    * PREPARACIÓN DE PARAMETROS PARA EL CORREO
                    * ----------------------------
                	*/
                	
                	
                	
                    $asunto="APROBACIÓN DE OFERTA - SOLICITUD DE OFERTA #".$lastIdOferta;
                    
                    $configCorreo = array(
                        "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
                        "CORREO_ORIGEN" => $this->items['correoElectronico'],
                        "CORREOS_DESTINOS" => $correoDestino,
                        "CORREOS_COPIA" => $correoCopia,
                        "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe", "placido.curilopez@verisure.pe"),
                        "ASUNTO" => $asunto,
                        "MENSAJE" => $cuerpo
                    );
                
                    $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);
                    
                }else{
                    
                    //OBTENER INFORMACIÓN DE RESPONSABLES DE DIRECCIÓN/ÁREA PARA LOS APROBADORES DE FACTURAS
                    $informacionSubarea     = $this->estructuraSubareas->obtenerSubarea($this->items['idSubarea']);

                    $responsableArea                = $this->usuarios->buscarUsuario($informacionSubarea['Responsable_Area']);
                    
                    //ARMADO DE VALORES PARA TABLA DE APROBADOR
                    $dataAprobador = array (
                        'IDOfertas'                 => $lastIdOferta,
                        'UsuarioCrea'               => $this->items['id'],
                        'FechaCrea'                 => $fechaActual,    
                        'Localhost'                 => $this->request->getIPAddress(),
                        'UsuarioEstado'             => $this->items['id'],
                        'FechaEstado'               => $fechaActual,    
                        'MotivoEstado'              => "Solicitud de aprobación.",    
                        'Estado'                    => 'PEND'
                    );
                    
                    $dataAprobador['IDDireccionAprobacion']     = $responsableArea['IDDireccion'];
            
                    //INSERCIÓN DE APROBADORES DE LA SOLICITUD OFERTA
                    $lastIdAprobador = $this->ofertasAprobacion->insert($dataAprobador, TRUE);
                    
                                        
                    /*
                    * ----------------------------
            		 ACCIONES
                    * ----------------------------
            		*/
            		$correoCopia = array();
                    $correoDestino = array();
                    
                    $correoCopia[] = $this->items['correoElectronico'];
                    
                    // if($matriz === "Fuera"){
                        
                        $arrayUsuarioCarteracliente = array(
                            'IDGrupoCarteraCliente'  => $grupoTipoCartera,
                            'JefeCartera' => 'Y'
                            
                        );
                        
                        $idsUsuriosGrupoCartera = $this->usuarioGruposCarteraCliente->select('IdUsuario')
                                                                ->where($arrayUsuarioCarteracliente)
                                                                ->findAll();
                                                                
                        $idsUsuarios = [];
                        foreach ($idsUsuriosGrupoCartera as $usuarioGrupo) {
                            $idsUsuarios[] = $usuarioGrupo['IdUsuario'];
                        }
                    
                        $correosJefes = $this->usuarios->obtenerCorreosPorIds($idsUsuarios);
                    
                        // Combinamos los correos obtenidos con el array original
                        $correoCopia = array_merge($correoCopia, $correosJefes);
                    // }
            		
                    $arrayCuerpo = array(
                        "TITULO" => "SOLICITUD DE Oferta #".$lastIdOferta,
                        "BASE_URL"  => base_url(),
                        'basePublic'    => $this->items['basePublic'],
                        'baseDinamic'   => $this->items['baseDinamic'],
                        "MODULO" => "OFERTAS",
                        "USUARIO" => ucwords(mb_strtolower($this->items['nombres'].' '.$this->items['apellidos'])),
                        "MENSAJE" => "Solicitud de Oferta. Ingresa al sistema Petitracking para poder gestionarlo.",
                        "URL_MODULO" => base_url()."/detalle-Oferta/".$lastIdOferta
                    );
                
                    $cuerpo = $this->plantillasCorreo->avisoPetitracking($arrayCuerpo);
                    
                	/*
                    * ----------------------------
                    * PREPARACIÓN DE PARAMETROS PARA EL CORREO
                    * ----------------------------
                	*/
                	
                	
                	
                    $asunto="APROBACIÓN DE OFERTA - SOLICITUD DE OFERTA #".$lastIdOferta;
                    
                    $configCorreo = array(
                        "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
                        "CORREO_ORIGEN" => $this->items['correoElectronico'],
                        "CORREOS_DESTINOS" => $correoDestino,
                        "CORREOS_COPIA" => $correoCopia,
                        "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe", "placido.curilopez@verisure.pe"),
                        "ASUNTO" => $asunto,
                        "MENSAJE" => $cuerpo
                    );
                
                    $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);
                    
                }
            
    		    /***************************/
    		    
    			$message = sprintf($this->mensajeError->msg502, $lastIdOferta);
    			echo $this->alertas->alertaExito($message);
    			echo $this->alertas->refrescar(1);
    			EXIT;
        }else{
            $message = sprintf($this->mensajeError->msg201, 'Error al registrar Oferta');
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
    }
    
    public function ofertasServerside()
    {
        if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id']
            );
            
            /* LISTAR CONDONACIONES */
            $dataServerside = $this->ofertas->listaGeneralOfertas($this->request->getPost(), $adicionales);
            // var_dump($dataServerside); exit;
            foreach($dataServerside["data"] as $key=>$value)
            {
    // 			if(in_array("ESTCAR", $this->items['permisos']))
    // 			{
    //     			$dataServerside["data"][$key]['EstadoCargo'] = '<button class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0 cambiar-estado-cargo" data-estado="'.$value['Estado'].'" data-id="'.$value['IDCargo'].'">'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</button>';
    // 			}
    // 			else
    // 			{
    // 			    $dataServerside["data"][$key]['EstadoCargo'] = '<span class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0" >'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</span>';
    // 			}
    			
    // 			$dataServerside["data"][$key]['EstadoCondonacion'] = "";
    			
                $dataServerside["data"][$key]['FechaRegistro'] = date("d-m-Y", strtotime($value['FechaCrea'])).'<br>'.date("H:m:s", strtotime($value['FechaCrea']));
                $dataServerside["data"][$key]['NombreGestor'] = ucwords(mb_strtolower($value['NombresCreador'].' '.$value['ApellidosCreador']));
                // $dataServerside["data"][$key]['Importe'] = "S/ ";
                // $dataServerside["data"][$key]['EstadoOferta'] = (empty($value['EstadoAprobacion']) || is_null($value['EstadoAprobacion']))? $value['Estado'] : '';
                
                $acciones = '';
                
                $acciones .= "<a href='".$this->items['baseUrl']."/detalle-Oferta/".$value['IDOfertas']."' target='_blank' class='badge bg-sistema border-0 p-2 mx-1' data-tooltip='tooltip' data-toggle='tooltip' data-placement='top' title='Ver Ofertas' aria-label='Ver Ofertas'>
                    <i class='mdi mdi-currency-usd align-bottom' style='font-size: 20px; color: #FFF;'></i>
                </a>";
    //             $acciones .= '<button class="badge bg-info border-0 p-2 mx-1 datos-cargo" data-bs-target="#informacionCargo" data-form="#formInformacionCargo" data-id="'.$value['IDCargo'].'" data-accion="ver" id="ver-cargo" data-tooltip="tooltip" title="Ver Cargo">
    // 				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
    // 			</button>';
    			
    // 			if(in_array("UPDCAR", $this->items['permisos']))
    // 			{
    // 			$acciones .= '<button class="badge bg-warning border-0 p-2 mx-1 datos-cargo" data-bs-target="#informacionCargo" data-form="#formInformacionCargo" data-id="'.$value['IDCargo'].'" data-accion="editar" id="editar-cargo" data-tooltip="tooltip" title="Editar Cargo">
    // 				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
    // 			</button>';
    // 			}
    			
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
     
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    }
    
    public function detalleOferta($idOferta)
    {
        if(isset($this->items['id']))
        {
            $estadosFactura = ['APRO', 'RECH', 'CANC', 'PEND'];
            
			// ACCIONES
			$whereOferta = array(
			    'IDOfertas'  => $idOferta
			);
			
            $oferta = $this->ofertas->obtenerOferta($whereOferta); 
          
            $whereGrupoCartera = array(
			    'IDGrupoCarteraCliente'  => $oferta['IDGrupoCarteraCliente']
			);
            $grupoCartera = $this->grupoCarteraCliente->select('CarteraCliente')->where($whereGrupoCartera)->first();
            $nombreCartera = $grupoCartera['CarteraCliente'];
            
            $whereOfertaNomenclatura = array(
			    'IDOfertaNomenclatura'  => $oferta['IDOfertaNomenclatura']
			);
            
            $itemOferta = $this->ofertasNomenclatura->select('Revntype')->where($whereOfertaNomenclatura)->first();
            $nombreItem = $itemOferta['Revntype'];
            
            // $estado = (empty($oferta['EstadoAprobacion']) || is_null($oferta['EstadoAprobacion']) )?  $oferta['Estado']:'' ;
            $estado = $oferta['Estado'];
            // var_dump($oferta['EstadoAprobacion']);exit;
            $estilos = [
                'APRO' => 'success',
                'RECH' => 'dark',
                'CANC' => 'danger',
                'PEND' => 'warning'
            ];
            
            $nombreEstado = [
                'APRO' => 'APROBADO',
                'RECH' => 'RECHAZADO',
                'CANC' => 'CANCELADO',
                'PEND' => 'PENDIENTE'
            ];
            
            $etiqueta= $nombreEstado[$estado];
            
            $claseEstilo = isset($estilos[$estado]) ? $estilos[$estado] : 'secondary'; // default 'secondary' por si viene un valor inesperado
            $dnone = $claseEstilo == 'secondary' ? 'd-none' : '';

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Detalle Oferta | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Detalle Oferta | '.$idOferta,
                'previo'                => 'listar-ofertas',
                'oferta'                => $oferta,
                'idOferta'              => $idOferta,
                'claseEstilo'           => $claseEstilo,
                'dnone'                 => $dnone,
                'nombreCartera'         => $nombreCartera,
                'nombreItem'            => $nombreItem,
                'etiqueta'              => $etiqueta
                // 'listadoFacturas'       => $facturas,
                // 'listadoAdjuntos'       => $adjuntos,
                // 'cantidadEstadoFactura' => $cantidadEstadoFactura,
                // 'aprobadoresFactura'    => $aprobadores
			);
			
			$data = array_merge($data, $this->items);
			return view('procesos/Ofertas/ver_detalle_oferta',$data);
		} 
		else 
		{
			return view('errors/500');
		}
    }
    
    public function mostrarAprobadorGeneral()
    { 
        $html = '';
        
        if(isset($this->items['id']))
        {
            /*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
            */
    
            $msjError   = TRUE;
            
            $idOferta  = $this->request->getPost('idOferta');
            
            $arrayOferta = array(
                'IDOfertas'  => $idOferta
            );
            
            
            $oferta = $this->ofertas->obtenerOferta($arrayOferta);
            
            
            if(!empty($oferta))
            { 
                    
                if($oferta['Matriz']=='Dentro'){
                    
                    $html .= '<div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <h5 class="fs-13 mb-0">'.ucwords(mb_strtolower($oferta['Observacion'])).'</h5>
                        </div>
                    </div>';
                    
                }else{
                    $dnone = ($oferta['Estado'] === "PEND") ? "" : "d-none";
                    
                    // Obtener todos los aprobadores jefes de cartera del grupo
                    $dataGrupoCartera = $this->usuarioGruposCarteraCliente
                        ->where([
                            'IDGrupoCarteraCliente' => $oferta['IDGrupoCarteraCliente'],
                            'JefeCartera' => 'Y'
                        ])->findAll();
                        
                    $idsUsuariosJefes = array_column($dataGrupoCartera, 'IdUsuario');
                    
                    $nombresJefes = $this->usuarios->obtenerCorreosPorIds($idsUsuariosJefes);
                    
                    foreach ($nombresJefes as $aprobadorGrupo) {    
                    
                        $html .= '<div class="d-flex align-items-center mb-2">
                            <div class="avatar-xs flex-shrink-0 me-3">
                                <div class="avatar-xs rounded">
                                    <div class="avatar-title border bg-light text-primary rounded-circle text-uppercase fs-15">
                                        <span class="mdi mdi-account"></span>
                                    </div>
                                </div>
                            </div>
                            <div class="flex-grow-1">
                                <h5 class="fs-13 mb-0">' . ucwords(mb_strtolower($aprobadorGrupo['Nombres'] . ' ' . $aprobadorGrupo['Apellidos'])) . '</h5>
                            </div>
                        </div>';

                    }
                            
                    // Mostrar los botones solo si el usuario actual tiene permisos y es jefe
                    if (in_array("EDIEST", $this->items['permisos']) && in_array($this->items['id'], $idsUsuariosJefes) && $oferta['Estado'] === "PEND") {
                        $html .= '
                        <div class="d-flex justify-content-end gap-2 mt-2">
                            <div class="cambio-estado-oferta " data-form="#formFacturasAprobador" data-estado="RECH" data-tipo="rechazado" data-oferta="' . $idOferta . '" data-usuario="' . $this->items['id'] . '">
                                <div class="avatar-sm">
                                    <div class="avatar-title border bg-danger border-danger border-opacity-25 rounded-2 fs-14">
                                        <i class="mdi mdi-close-circle align-bottom" style="font-size: 24px; color: #FFF;"></i>
                                    </div>
                                    <p class="mb-0 text-muted text-truncate" style="font-size: 10px; max-width: 100px;">Rechazado</p>
                                </div>
                            </div>
                            <div class="cambio-estado-oferta" data-form="#formFacturasAprobador" data-estado="APRO" data-tipo="aprobado" data-oferta="' . $idOferta . '" data-usuario="' . $this->items['id'] . '">
                                <div class="avatar-sm">
                                    <div class="avatar-title border bg-success border-success border-opacity-25 rounded-2 fs-14">
                                        <i class="mdi mdi-check-circle align-bottom" style="font-size: 24px; color: #FFF;"></i>
                                    </div>
                                    <p class="mb-0 text-muted text-truncate" style="font-size: 10px; max-width: 100px;">Aprobado</p>
                                </div>
                            </div>
                        </div>';
                    }else{
                        $html .= '<div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h5 class="fs-13 mb-0"> Motivo '.ucwords(mb_strtolower($oferta['MotivoEstadoAprobacion'])).'</h5>
                            </div>
                        </div>';
                        
                        $html.= '</div>';
                    }
                }
               
                
            }
            else
            {
                $html = '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
    	            <div class="col-xxl-10 col-md-12 col-12 ">
            	        <div class="alert alert-warning alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                            <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>ERROR AL MOSTRAR INFORMACION</strong> - NO HAY OFERTA.
                        </div>
                    </div>
            	</div>';
            }
        }
        else 
		{
            $html = '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
	            <div class="col-xxl-10 col-md-12 col-12 ">
        	        <div class="alert alert-danger alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN SESIÓN</strong> - No hay sesión iniciada. Inicie sesión nuevamente.
                    </div>
                </div>
        	</div>';
		}
		
		echo $html;
    }
    
    public function cambiarEstadoOferta()
    { 
        $fechaActual = date("Y-m-d H:i:s");
        $fechaActualAdd = date("Y-m-d H:i:s", strtotime($fechaActual)+1);
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError               = TRUE;
        
        $estado                 = $this->request->getPost('estado'); 
        $motivo                 = $this->request->getPost('motivo'); 
        $idOferta               = $this->request->getPost('idOferta');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[4]|maxlength[4]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'motivo');
        $error .= $this->complementos->validaCampo($idOferta, 'required|trim|numeric|minlength[1]|maxlength[11]', 'Id Oferta');
        
        if ($error != '') 
        {
            $message = sprintf($this->mensajeError->msg201, $error);
            $mensaje = $this->alertas->alertaError($message);
            
            $resultado = array(
    			'result'    => (string) 0,
    			'mensaje'   => (string) $mensaje
    		);
    		
    		echo json_encode($resultado); 
    		
            EXIT;
        }
        

        /*
        * ----------------------------
        * ARMADO DE CRUD
        * ----------------------------
        */
        
        $dataOfertaAprobacion = array (
            'UsuarioModifica'       => $this->items['id'],
            'Estado'                => $estado, 
            'UsuarioEstado'         => $this->items['id'],
            'Localhost'             => $this->request->getIPAddress(),
            'FechaModifica'     => $fechaActual,
            'FechaEstado'     => $fechaActual,
            'MotivoEstado'     => $motivo,
            'IDUsuarioAprobacion'     => $this->items['id'],
            'IDAreaAprobacion'        => $this->items['idArea'],
            'IDSubareaAprobacion'     => $this->items['idSubarea'],
            'IDDelegacionAprobacion'  => $this->items['idDelegacionLog'],
            'IDCargoAprobacion'       => $this->items['idCargoLog']
        );
        
        $idUsuarioAprobador = $this->items['id'];

        
        /*
        * ----------------------------
        * EJECUTAR CRUD 
        * ----------------------------
        */
        
        //EJECUTAR CAMBIOS FACTURA CONDONACION
        
        $whereOferta = array(
            		    'IDOfertas'  => $idOferta
            		);
            		
        $oferta = $this->ofertas->obtenerOferta($whereOferta);
        
        $lastIDOfertaAprobacion = $this->ofertasAprobacion->update([$oferta['IDAprobacion']], $dataOfertaAprobacion); 
        
        if($lastIDOfertaAprobacion !== FALSE)
        {
            /*
            * ----------------------------
            * ACTUALIZAR OFERTA
            * ----------------------------
            */
            
            $dataOferta = array (
                'UsuarioModifica'           => $this->items['id'],
                'EstadoFacturacion'         => NULL, 
                'ObservacionFacturacion'    => NULL,
                'Estado'                    => $estado,
                'FechaModifica'             => $fechaActual,
                'UsuarioModifica'           => $this->items['id'],
                'FechaEstado'               => $fechaActual,
                'MotivoEstado'              => 'Actualización de Solicitud de Oferta #'.$idOferta,
                'Localhost'                 => $this->request->getIPAddress()
            );
            
             //EJECUTAR CAMBIOS OFERTAS
            
            $lastIDOferta = $this->ofertas->update([$idOferta], $dataOferta);
            
            /*
            * ----------------------------
            * INSERTAR COMENTARIO
            * ----------------------------
            */
    
            $data = array (
                'IDOfertas'         => $idOferta,
                'Accion'                => "COMENDECIEST",
                'ValorBitacora'         => $estado,
                'Comentario'            => $motivo,
                'UsuarioRegistra'       => $this->items['id'],
                'FechaRegistra'         => $fechaActual,    
                'Localhost'             => $this->request->getIPAddress(),
                'Estado'                => 'A'
            );

    	    $lastId = $this->ofertaBitacora->insert($data, TRUE);
            
            if($lastId !== FALSE)
            {
        
        		/*
                * ----------------------------
                * PREPARACIÓN DE CUERPO DE CORREO
                * ----------------------------
        		*/
        
                if($estado === 'APRO'){ 
                    
            //         $whereOferta = array(
            // 		    'IDOfertas'  => $idOferta
            // 		);
            		
            //         $oferta = $this->ofertas->obtenerOferta($whereOferta); 
                    
                    if($oferta['TipoOferta'] === "remplazoOferta"){ // peticion
                        
                    
                        if(empty($oferta['IDPeticion'])){
                            
                            /*
                            * ----------------------------
                            * ARMAR INFORMACIÓN DE PETICIÓN
                            * ----------------------------
                            */
                            
                            $arrayPeticionOferta = array(
                                'Peticion'              => 'Solicitud de Oferta #'.$idOferta,
                                'IDMotivo'              => $oferta['IDMotivo'],
                                'Detalle'               => $oferta['Observacion'],
                                'IDGrupoTrabajoDestino' => 6, //Facturacion
                                'UsuarioCrea'           => $this->items['id'],
                                'FechaCrea'             => $fechaActual,
                                'IDSubareaCrea'         => $this->items['idSubarea'], 
                                'IDAreaCrea'            => $this->items['idArea'], 
                                'IDDireccionCrea'       => $this->items['dpto'], 
                                'IDPerfilCrea'          => $this->items['idPerfil'],
                                'IDDelegacionCrea'      => $this->items['idDelegacionLog'],
                                'IDCargoCrea'           => $this->items['idCargoLog'],
                                'Estado'                => "CREA", 
                                'UsuarioEstado'         => $this->items['id'],
                                'IDDireccionEstado'     => $this->items['dpto'], 
                                'IDAreaEstado'          => $this->items['idArea'], 
                                'IDSubareaEstado'       => $this->items['idSubarea'], 
                                'IDDelegacionEstado'    => $this->items['idDelegacionLog'],
                                'IDPerfilEstado'        => $this->items['idPerfil'],
                                'IDCargoEstado'         => $this->items['idCargoLog'],
                                'FechaEstado'           => $fechaActual,
                                'MotivoEstado'          => 'Solicitud de Oferta #'.$idOferta,
                                'Localhost'             => $this->request->getIPAddress(),
                                'NroContrato'           => $oferta['NumeroContrato']
                            );
                            
                            /*
                            * ----------------------------
                            * ENVIAR INFORMACIÓN A REGISTRAR PETICIÓN Y OBTENER EL ID DE PETICIÓN 
                            * ----------------------------
                            */
                            
                            $idPeticion = $this->peticiones->insert($arrayPeticionOferta, TRUE);
                            
                            if($idPeticion === FALSE)
                    		{
                    		    $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar la petición. Inténtelo luego.</li>");
                                
                                $resultado = array(
                    				'result'    => (string) 0,
                    				'mensaje'  => (string) $this->alertas->alertaError($message)
                    			);
                    			
                    			echo json_encode($resultado);
                    			
                    			EXIT;
                    		}
                         
                    		    		
                            /*
                            * ----------------------------
                            * INSERCIÓN DE NOTIFICACIÓN
                            * ----------------------------
                            */
                            
                            $nuevaNotificacion = array (
                                'tabla'             => 'peticiones', 
                                'idreferencia'      => $idPeticion,
                                'mensaje'           => "Se ha <span class='color-crea'>CREADO</span> una nueva petición.", 
                                'url'               => "detalle-peticion/".$idPeticion, 
                                'usuariodestino'    => null, 
                                'gtdestino'         => 6, 
                                'perfildestino'     => null,
                                'usuarioregistra'   => $this->items['id'],
                                'fecharegistra'     => $fechaActual
                            );
                            
                            $this->insertarNotificacion($nuevaNotificacion);
                    		    
                            /*
                            * ----------------------------
                            * ACTUALIZAR CONDONACIÓN CON EL ID PETICIÓN
                            * ----------------------------
                            */
                            
                            $arrayUpdateOferta = array(
                                'IDPeticion'        => $idPeticion,
                                'UsuarioModifica'   => $this->items['id'],
                                'FechaModifica'     => $fechaActual,
                                'Localhost'         => $this->request->getIPAddress()
                            );
                            
                            $this->ofertas->update([$idOferta], $arrayUpdateOferta); // cambias a oferta
                    		
                        }
                    }
                    
                    /*
                    * ----------------------------
            		 ACCIONES
                    * ----------------------------
            		*/
            		$correoCopia = array();
                    $correoDestino = array();
                    $correoDestino[] = $oferta['CorreoCreador'];
                    $correoCopia[] = $oferta['CorreoAprobador'];
            		
                    $arrayCuerpo = array(
                        "TITULO" => "SOLICITUD DE Oferta #".$idOferta,
                        "BASE_URL"  => base_url(),
                        'basePublic'    => $this->items['basePublic'],
                        'baseDinamic'   => $this->items['baseDinamic'],
                        "MODULO" => "OFERTAS",
                        "USUARIO" => ucwords(mb_strtolower($oferta['NombresCreador'].' '.$oferta['ApellidosCreador'])),
                        "MENSAJE" => "Solicitud de Oferta Aprobada. Ingresa al sistema Petitracking para poder gestionarlo.",
                        "URL_MODULO" => base_url()."/detalle-Oferta/".$idOferta
                    );
                
                    $cuerpo = $this->plantillasCorreo->avisoPetitracking($arrayCuerpo);
                    
                	/*
                    * ----------------------------
                    * PREPARACIÓN DE PARAMETROS PARA EL CORREO
                    * ----------------------------
                	*/
                	
                // 	$correoCopia[] = 'incidenciasfact@verisure.pe'; //Descomentar
                	
                    $asunto="APROBACIÓN DE OFERTA - SOLICITUD DE OFERTA #".$idOferta;
                    
                    $configCorreo = array(
                        "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
                        "CORREO_ORIGEN" => $this->items['correoElectronico'],
                        "CORREOS_DESTINOS" => $correoDestino,
                        "CORREOS_COPIA" => $correoCopia,
                        "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe", "placido.curilopez@verisure.pe"),
                        "ASUNTO" => $asunto,
                        "MENSAJE" => $cuerpo
                    );
                
                    $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);
                    
                }
            
                $message = sprintf($this->mensajeError->msg201, "Se registró el cambio exitosamente.");
                $mensaje = $this->alertas->alertaExito($message);
                
                $resultado = array(
        			'result'    => (string) 1,
        			'mensaje'   => (string) $mensaje,
        			'reload'    => true
        		);
            }
            else
            {
                $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el cambio solicitado. Inténtelo luego.");
                $mensaje = $this->alertas->alertaError($message);
                
                $resultado = array(
        			'result'    => (string) 0,
        			'mensaje'   => (string) $mensaje
        		);
            }
    		
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el cambio solicitado. Inténtelo luego.");
            $mensaje = $this->alertas->alertaError($message);
            
            $resultado = array(
    			'result'    => (string) 0,
    			'mensaje'   => (string) $mensaje
    		);
        }
        
        echo json_encode($resultado);
        EXIT;      
    }
    
    public function actualizarDetalleOferta()
    {
        if (!$this->request->isAJAX()) {
            return $this->response->setJSON(['result' => 0, 'mensaje' => 'Petición no válida']);
        }
        
        $fechaActual = date("Y-m-d H:i:s");
    
        $idOferta = $this->request->getPost('idOferta'); 
        $valorDescuento = $this->request->getPost('valorDescuento'); 
        $valorDescuentoCalculado = $this->request->getPost('valorDescuentoCalculado'); 
        $cantidadMeses = $this->request->getPost('cantidadMeses'); 
        $tiempoOferta = $this->request->getPost('tiempoOferta'); 
        $itemOferta = $this->request->getPost('itemOferta'); 
        $fechainicio = $this->request->getPost('fechainicio'); 
        $tipoOferta = $this->request->getPost('tipoOferta'); 
        $matrizPost = $this->request->getPost('matriz'); 
        $matriz = !empty($matrizPost)  ? "Fuera" : "Dentro"; 

        if (empty($idOferta) || $valorDescuento === '' || empty($cantidadMeses)) {
            return $this->response->setJSON(['result' => 0, 'mensaje' => 'Datos incompletos.']);
        }
    
        // Aquí podrías validar o sanitizar los datos...
    
        $data = [
            'Matriz'    => $matriz,
            'Descuento' => $valorDescuento,
            'ValorDescuento' => $valorDescuentoCalculado,
            'MesesTiempoOferta' => $cantidadMeses,
            'TiempoOferta' => $tiempoOferta,
            'IDOfertaNomenclatura' => $itemOferta,
            'FechaInicio' => $fechainicio,
            'TipoOferta' => $tipoOferta,
            'UsuarioModifica'       => $this->items['id'],
            'Localhost'             => $this->request->getIPAddress(),
            'FechaModifica'         => $fechaActual
        ];
        
        if($matriz === 'Dentro'){
            $data['Estado'] = 'APRO';
            $data['UsuarioEstado'] = $this->items['id'];
            $data['FechaEstado']    = $fechaActual;
            $data['MotivoEstado']   = "Oferta Cambiado por actualizacion de oferta.";
        }else{
            $data['Estado'] = 'PEND';
            $data['UsuarioEstado'] = $this->items['id'];
            $data['FechaEstado']    = $fechaActual;
            $data['MotivoEstado']   = "Oferta Cambiado por actualizacion de oferta.";
        }

        $actualizado = $this->ofertas->update($idOferta, $data);
    
        if ($actualizado) {
            if($matriz === 'Fuera'){
                $dataOfertaAprobacion = [
                    'Estado' => 'PEND'
                ];
                
                $ofertaAprobacionExiste = $this->ofertasAprobacion->where('IDOfertas',$idOferta)->first();
                
                if(!empty($ofertaAprobacionExiste)){
                    $lastIDOfertaAprobacion = $this->ofertasAprobacion->update($idOferta, $dataOfertaAprobacion);
                }else{
                    
                    //OBTENER INFORMACIÓN DE RESPONSABLES DE DIRECCIÓN/ÁREA PARA LOS APROBADORES DE FACTURAS
                    $informacionSubarea = $this->estructuraSubareas->obtenerSubarea($this->items['idSubarea']);

                    $responsableArea = $this->usuarios->buscarUsuario($informacionSubarea['Responsable_Area']);
                    
                    //ARMADO DE VALORES PARA TABLA DE APROBADOR
                    $dataAprobador = array (
                        'IDOfertas'                 => $lastIdOferta,
                        'UsuarioCrea'               => $this->items['id'],
                        'FechaCrea'                 => $fechaActual,    
                        'Localhost'                 => $this->request->getIPAddress(),
                        'UsuarioEstado'             => $this->items['id'],
                        'FechaEstado'               => $fechaActual,    
                        'MotivoEstado'              => "Solicitud de aprobación.",    
                        'Estado'                    => 'PEND'
                    );
                    
                    $dataAprobador['IDDireccionAprobacion']     = $responsableArea['IDDireccion'];
            
                    //INSERCIÓN DE APROBADORES DE LA SOLICITUD OFERTA
                    $lastIdAprobador = $this->ofertasAprobacion->insert($dataAprobador, TRUE);
                }
                
                // hacer una validacion de existencia y dependiendo de ello se actualiza o hacer un insert
            }else{ // eliminar si existe

                $lastIDOfertaAprobacion = $this->ofertasAprobacion->where('IDOfertas',$idOferta)->delete();
            }
        
            /*
            * ----------------------------
            * INSERTAR COMENTARIO
            * ----------------------------
            */
            $comentario = 'Actualizacion de Valor Descuento, Cantidad de meses.';
            $data = array (
                'IDOfertas'         => $idOferta,
                'Accion'                => "MODOFE",
                'ValorBitacora'         => "MODOFE",
                'Comentario'            => $comentario,
                'UsuarioRegistra'       => $this->items['id'],
                'FechaRegistra'         => $fechaActual,    
                'Localhost'             => $this->request->getIPAddress(),
                'Estado'                => 'A'
            );
    
    	    $lastId = $this->ofertaBitacora->insert($data, TRUE);

            return $this->response->setJSON(['result' => 1, 'mensaje' => 'Oferta actualizada correctamente.','reload' => true]);
        } else {
            return $this->response->setJSON(['result' => 0, 'mensaje' => 'No se pudo actualizar la oferta.']);
        }
    }
    
    public function registrarComentarioOferta()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        $error = '';
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        //Información de Condonación
        
        $comentario             = $this->request->getPost('txtComentariosOferta_rcomcond');
        $idOferta          = $this->request->getPost('txtIDOferta_rcomcond');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error .= $this->complementos->validaCampo($idOferta, 'required|trim|numeric', 'ID Oferta');
        $error .= $this->complementos->validaCampo($comentario, 'required|trim', 'Comentario');
        
        if ($error != '') 
        {
            $message = sprintf($this->mensajeError->msg201, $error);
            $mensaje = $this->alertas->alertaError($message);
            
            $resultado = array(
    			'result'    => (string) 0,
    			'mensaje'   => (string) $mensaje
    		);
    		
    		echo json_encode($resultado);
    		
            EXIT;
        }
        
        /*
        * ----------------------------
        * INSERTAR COMENTARIO
        * ----------------------------
        */

        $data = array (
            'IDOfertas'             => $idOferta,
            'Accion'                => "COMENOFER",
            'ValorBitacora'         => "COME",
            'Comentario'            => $comentario,
            'UsuarioRegistra'       => $this->items['id'],
            'FechaRegistra'         => $fechaActual,    
            'Localhost'             => $this->request->getIPAddress(),
            'Estado'                => 'A'
        );

        $lastId = $this->ofertaBitacora->insert($data, TRUE);

		if($lastId !== FALSE)
		{
		    $message = sprintf($this->mensajeError->msg201, "Se registró el comentario exitosamente.");
            $mensaje = $this->alertas->alertaExito($message);
            
            $resultado = array(
    			'result'    => (string) 1,
    			'mensaje'   => (string) $mensaje
    		);
		}
        else
        {
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el comentario. Inténtelo luego.");
            $mensaje = $this->alertas->alertaError($message);
            
            $resultado = array(
    			'result'    => (string) 0,
    			'mensaje'   => (string) $mensaje
    		);
        }
        
        echo json_encode($resultado);
        EXIT;
    }
    
    public function comentariosOferta()
    {
        $html = '';
        
        if(isset($this->items['id']))
        {
            /*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
            */
    
            $msjError       = TRUE;
            $idOferta  = $this->request->getPost('idOferta');
            
            $arrayTitulos = array(
                "MODOFE"   => "Actualización de Oferta",
                "COMENDECIEST" => "Comentario de Decisión de Cambio de Estado Oferta",
                "COMENOFER" => "Comentario de Solicitud"
            );
            
            $arrayIconos = array(
                "APRO"  => '<span class="badge bg-success border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Aprobado"><i class="mdi mdi-check-circle align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "RECH"  => '<span class="badge bg-danger border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Rechazado"><i class="mdi mdi-close-circle align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "PEND"  => '<span class="badge bg-gris-claro border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Pendiente"><i class="mdi mdi-timer-sand align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "CANC"  => '<span class="badge bg-dark border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Cancelado"><i class="mdi mdi-cancel align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "COME"  => '<span class="badge bg-come border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Comentario"><i class="mdi mdi-comment align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "MODOFE"  => '<span class="badge bg-orange border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Comentario"><i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i></span>'
            );
            
            
            /*
            * ----------------------------
            * CONSULTAS SQL
            * ----------------------------
            */
            
            $arrayOferta = array(
                'IDOfertas' => $idOferta
                // 'exCondonacion' => "Y" // exclusivoCondonacion: cuando solo quiero bitacora exclusivo de condonaciones, sin facturas ni aprobadores (estos ultimos null)
            );
    
            $bitacora   = $this->ofertaBitacora->listarBitacoraOferta($arrayOferta);
            
            /*
            * ----------------------------
            * ARMAR HTML
            * ----------------------------
            */
            
            $fechaActual = '';
            
            if(!empty($bitacora))
            {
                foreach ($bitacora as $index => $evento)
                {
                    // $facturaInterna = !empty($evento['FacturaInterna']) ? '<span class="badge bg-info text-white me-1">'.$evento['FacturaInterna'].'</span>' : '';
                    // $facturaExterna = !empty($evento['FacturaExterna']) ? '<span class="badge bg-secondary text-white me-1">'.$evento['FacturaExterna'].'</span>' : '';
                    
                    // Título acción
                    $tituloAccion = '<span class="badge bg-primary-subtle text-primary fw-semibold ms-auto">'.$arrayTitulos[$evento['Accion']].'</span>';

                    $html .= '<div class="d-flex mb-4 p-3 border rounded" style="background-color: #ffffff; box-shadow: 4px 4px #8A8C8E;">
                        <div class="flex-shrink-0 me-3 d-flex justify-content-center align-items-center">
                            <h5>'.(isset($arrayIconos[$evento['ValorBitacora']]) || isset($arrayIconos[$evento['Accion']]) ? (isset($arrayIconos[$evento['ValorBitacora']]) ? $arrayIconos[$evento['ValorBitacora']] : $arrayIconos[$evento['Accion']] ) : '<span class="badge bg-warning border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Registro de Actividad"><i class="mdi mdi-star align-bottom" style="font-size: 20px; color: #FFF;"></i></span>' ).'</h5>
                        </div>
                        <div class="flex-grow-1">
                            <div class="d-flex justify-content-between align-items-center mb-1">
                                <h6 class="mb-0">'.ucwords(mb_strtolower($evento['Nombres'].' '.$evento['Apellidos'])).'</h6>
                                <small class="text-muted">'.date('d M Y', strtotime($evento['Fecha'])).' - '.$evento['Hora'].'</small>
                            </div>
                            <p class="text-muted my-2">'.$evento['Comentario'].'</p>
                            <div class="d-flex align-items-center justify-content-between">
                                
                                '.$tituloAccion.'
                            </div>
                        </div>
                    </div>';
                }
            }
            else
            {
                $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 justify-content-center align-items-center" style="border-radius: 10px;">
                    <div class="col-xxl-10 col-md-12 col-12 ">
                        <div class="alert alert-dark alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                            <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>NO SE ENCONTRÓ COMENTARIOS DE SOLICITUD</strong>
                        </div>
                    </div>
                </div>';
            }
        }
        else 
		{
            $html = '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
	            <div class="col-xxl-10 col-md-12 col-12 ">
        	        <div class="alert alert-danger alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN SESIÓN</strong> - No hay sesión iniciada. Inicie sesión nuevamente.
                    </div>
                </div>
        	</div>';
		}
		
		echo $html;
    }
        
    public function recargarBitacoraOferta()
    {
        
        $html = '';
        
        if(isset($this->items['id']))
        {
            /*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
            */
    
            $msjError       = TRUE;
            $idOferta  = $this->request->getPost('idOferta');
            
            $arrayTitulos = array(
                "MODOFE"   => "Actualización de Oferta",
                "COMENDECIEST" => "Comentario de Decisión de Cambio de Estado Oferta",
                "COMENOFER" => "Comentario de Solicitud"
            );
            
            $arrayIconos = array(
                "APRO"  => '<span class="badge bg-success border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Aprobado"><i class="mdi mdi-check-circle align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "RECH"  => '<span class="badge bg-danger border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Rechazado"><i class="mdi mdi-close-circle align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "PEND"  => '<span class="badge bg-gris-claro border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Pendiente"><i class="mdi mdi-timer-sand align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "CANC"  => '<span class="badge bg-dark border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Cancelado"><i class="mdi mdi-cancel align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "COME"  => '<span class="badge bg-come border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Comentario"><i class="mdi mdi-comment align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "MODOFE"  => '<span class="badge bg-orange border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Comentario"><i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i></span>'
            );
            
            /*
            * ----------------------------
            * CONSULTAS SQL
            * ----------------------------
            */
            
            $arrayCondonacion = array(
                'IDOfertas'  => $idOferta
            );
    
            $bitacora   = $this->ofertaBitacora->listarBitacoraOferta($arrayCondonacion);
            
            /*
            * ----------------------------
            * ARMAR HTML
            * ----------------------------
            */
            
            $fechaActual = '';
            
            if(!empty($bitacora))
            {
                $html .= '<div class="timeline-2 p-3" style="background-color: white;">';
                    
                    foreach ($bitacora as $index => $evento)
                    {
                        $esNuevaFecha = $fechaActual !== $evento['Fecha'];
                        if ($esNuevaFecha) 
                        {
                            // Cierra contenedor anterior si hay uno abierto
                            if ($fechaActual !== '') 
                            {
                                $html .= '</div>'; // cierre de .timeline-continue
                            }
                
                            // Actualiza la fecha actual
                            $fechaActual = $evento['Fecha'];
                            
                             $html .= '<div class="timeline-year">
                                <p style="box-shadow: 4px 4px #8A8C8E;">'.date('d M Y', strtotime($evento['Fecha'])).'</p>
                            </div>
                            <div class="timeline-continue">';
                        }
                        
                        $html .= '<div class="row timeline-right">
                            <div class="col-12">
                                <p class="timeline-date">'.$evento['Hora'].'</p>
                            </div>
                            <div class="col-12">
                                <div class="timeline-box" style="box-shadow: 4px 4px #8A8C8E;">
                                    <div class="timeline-text">
                                        <h5>'.(isset($arrayIconos[$evento['ValorBitacora']]) || isset($arrayIconos[$evento['Accion']]) ? (isset($arrayIconos[$evento['ValorBitacora']]) ? $arrayIconos[$evento['ValorBitacora']] : $arrayIconos[$evento['Accion']] ) : '<span class="badge bg-warning border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Registro de Actividad"><i class="mdi mdi-star align-bottom" style="font-size: 20px; color: #FFF;"></i></span>' ).' '.$arrayTitulos[$evento['Accion']].' 
                                            <div class="badge text-secondary">'.$evento['IDOfertas'].'</div>
                                            <i class="mdi mdi-slash-forward text-primary me-1 align-bottom"></i><div class="badge text-secondary">'.$evento['IDOfertas'].'</div>
                                        </h5>
                                        <p class="text-muted my-2">'.$evento['Comentario'].'</p>
                                        <small class="text-muted">Registrado por: '.ucwords(mb_strtolower($evento['Nombres'].' '.$evento['Apellidos'])).'</small>
                                    </div>
                                </div>
                            </div>
                        </div>';
                        
                        // Si es el último evento, cerramos .timeline-continue
                        if ($index === array_key_last($bitacora)) 
                        {
                            $html .= '</div>'; // cierre de .timeline-continue
                        }
                    }
                    
                $html .= '</div>';
            }
            else
            {
                $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 justify-content-center align-items-center" style="border-radius: 10px;">
                    <div class="col-xxl-10 col-md-12 col-12 ">
                        <div class="alert alert-dark alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                            <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>NO SE ENCONTRÓ REGISTRO DE BITÁCORA</strong> - Aún no hay movimientos en la condonación.
                        </div>
                    </div>
                </div>';
            }
        }
        else
		{
            $html = '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
	            <div class="col-xxl-10 col-md-12 col-12 ">
        	        <div class="alert alert-danger alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN SESIÓN</strong> - No hay sesión iniciada. Inicie sesión nuevamente.
                    </div>
                </div>
        	</div>';
		}
		
		echo $html;
    }
    
    public function enviarAlertaGestor()
    {
        if(isset($this->items['id']))
        {
            $fechaActual = date("Y-m-d H:i:s");
    
            $idOferta  = $this->request->getPost('idOferta');
            $motivo      = $this->request->getPost('motivo');
            
            $mensajeMotivo = $motivo != '' ? '</br>El Area de Facturación te ha dejado el siguiente mensaje: '.$motivo .'</br>' : '';
            
            // $aprobador       = $this->usuarios->buscarUsuario($idUsuario);
            
            $arrayOferta = array(
                'IDOfertas'  => $idOferta
            );
            
            $oferta = $this->ofertas->obtenerOferta($arrayOferta);
            
            $correoCopia = array();
            $correoDestino = array();
            
            $correoCopia[] = $this->items['correoElectronico'];
            $correoDestino[] = $oferta['CorreoCreador'];

    		/*
            * ----------------------------
            * PREPARACIÓN DE CUERPO DE CORREO
            * ----------------------------
    		*/
    
            $arrayCuerpo = array(
                "TITULO" => "SOLICITUD DE OFERTA #".$idOferta,
                "BASE_URL"  => base_url(),
                'basePublic'    => $this->items['basePublic'],
                'baseDinamic'   => $this->items['baseDinamic'],
                "MODULO" => "OFERTAS",
                "USUARIO" => ucwords(mb_strtolower($oferta['NombresCreador'].' '.$oferta['ApellidosCreador'])),
                "MENSAJE" => "La solicitud aun de oferta aun esta pendiente por gestionar.".($mensajeMotivo)." Ingresa al sistema Petitracking para poder gestionarlo.",
                "URL_MODULO" => base_url()."/detalle-Oferta/".$idOferta
            );
    
            $cuerpo = $this->plantillasCorreo->avisoPetitracking($arrayCuerpo);
            
    		/*
            * ----------------------------
            * PREPARACIÓN DE PARAMETROS PARA EL CORREO
            * ----------------------------
    		*/
    		
    // 		$correoCopia[] = 'incidenciasfact@verisure.pe'; // Descomentar
    		
            $asunto="OFERTA PENDIENTE - SOLICITUD DE OFERTA #".$idOferta;
            
            $configCorreo = array(
                "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
                "CORREO_ORIGEN" => $this->items['correoElectronico'],
                "CORREOS_DESTINOS" => $correoDestino,
                "CORREOS_COPIA" => $correoCopia,
                "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe", "placido.curilopez@verisure.pe"),
                "ASUNTO" => $asunto,
                "MENSAJE" => $cuerpo
            );
    
            $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);
    
            // $dataCorreo = array(
            //     "IDAsignacion"  => $idAsignacion,
            //     "Response"      => $estadoCorreo['RESPUESTA'],
            //     "Error"         => $estadoCorreo['ERROR'],
            //     'UsuarioCrea'   => $this->items['id'],
            //     'FechaCrea'     => $fechaActual,    
            //     'Localhost'     => $this->request->getIPAddress()
            // );
    
            // $this->correoStatusAsignacion->insert($dataCorreo, TRUE);
    
            if($estadoCorreo['ERROR'] != '')
            {
                $message = sprintf($this->mensajeError->msg201, "No se pudo enviar el correo. Inténtelo luego.[INSERT]");
    			echo $this->alertas->alertaError($message);
            }
            else
            {
                $comentario = "Se envio el mensaje al gestor con el siguiente motivo: ". $mensajeMotivo;
                $linkComentario="";
                
                $dataComentario = array (
                    'IDPeticion'            => $oferta['IDPeticion'], 
                    'Comentario'            => $comentario,
                    'Link'                  => $linkComentario, 
                    'UsuarioCrea'           => $this->items['id'],
                    'FechaCrea'             => $fechaActual,
                    'IDSubareaCrea'         => $this->items['idSubarea'], 
                    'IDAreaCrea'            => $this->items['idArea'], 
                    'IDDireccionCrea'       => $this->items['dpto'], 
                    'IDPerfilCrea'          => $this->items['idPerfil'],
                    'IDDelegacionCrea'      => $this->items['idDelegacionLog'],
                    'IDCargoCrea'           => $this->items['idCargoLog'],
                    'Estado'                => "A", 
                    'UsuarioEstado'         => $this->items['id'],
                    'FechaEstado'           => $fechaActual,
                    'MotivoEstado'          => $comentario,
                    'Localhost'             => $this->request->getIPAddress()
                );
                
                $lastId = $this->peticionesComentarios->insert($dataComentario, TRUE);
                
                $data = array (
                    'IDOfertas'             => $idOferta,
                    'Accion'                => "COMENOFER",
                    'ValorBitacora'         => "COME",
                    'Comentario'            => $comentario,
                    'UsuarioRegistra'       => $this->items['id'],
                    'FechaRegistra'         => $fechaActual,    
                    'Localhost'             => $this->request->getIPAddress(),
                    'Estado'                => 'A'
                );
        
                $lastId = $this->ofertaBitacora->insert($data, TRUE);
                
        		if($lastId !== FALSE)
        		{
        		    /*
                    * ----------------------------
                    * INSERCIÓN DE NOTIFICACIÓN
                    * ----------------------------
                    */
                    // $gruposTrabajoHabilitados = $this->gruposTrabajoUsuario->where("IdUsuario", $this->items['id'])->findAll();
                    $infPeticion = $this->peticiones->where("IDPeticion", $oferta['IDPeticion'])->first();
                    
        		    $nuevaNotificacion = array (
                        'tabla'             => 'peticiones', 
                        'idreferencia'      => $oferta['IDPeticion'],
                        'mensaje'           => "Se ha <span class='color-come'>COMENTADO</span> la petición #".$oferta['IDPeticion'].".", 
                        'url'               => "detalle-peticion/".$oferta['IDPeticion'], 
                        'usuarioregistra'   => $this->items['id'],
                        'fecharegistra'     => $fechaActual
                    );
                    

                    $nuevaNotificacion['usuariodestino'] = $oferta['UsuarioCrea'];
                    $nuevaNotificacion['gtdestino'] = null;
                    $nuevaNotificacion['perfildestino'] = null;
            
                    
        		    $this->insertarNotificacion($nuevaNotificacion);

        		} 
                
                $message = sprintf($this->mensajeError->msg201, "Se envió el correo correctamente.");
                echo $this->alertas->alertaExito($message);
            }
        }
        else 
		{
            $message = sprintf($this->mensajeError->msg201, "No se encontró sesión iniciada. Por favor, inicie sesión nuevamente.");
            echo $this->alertas->alertaError($message);
		}
    }
    
    public function gestionNuevasOfertasServerside()
    {
        if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id']
            );
            
            /* LISTAR CONDONACIONES */
            $dataServerside = $this->ofertas->listaGeneralNuevasOfertas($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
    // 			if(in_array("ESTCAR", $this->items['permisos']))
    // 			{
    //     			$dataServerside["data"][$key]['EstadoCargo'] = '<button class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0 cambiar-estado-cargo" data-estado="'.$value['Estado'].'" data-id="'.$value['IDCargo'].'">'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</button>';
    // 			}
    // 			else
    // 			{
    // 			    $dataServerside["data"][$key]['EstadoCargo'] = '<span class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0" >'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</span>';
    // 			}
    			
    // 			$dataServerside["data"][$key]['EstadoCondonacion'] = "";
    			
                $dataServerside["data"][$key]['FechaRegistro'] = date("d-m-Y", strtotime($value['FechaCrea'])).'<br>'.date("H:m:s", strtotime($value['FechaCrea']));
                $dataServerside["data"][$key]['NombreGestor'] = ucwords(mb_strtolower($value['NombresCreador'].' '.$value['ApellidosCreador']));
                // $dataServerside["data"][$key]['Importe'] = "S/ ";
                
                $acciones = '';
                
                $acciones .= "<a href='".$this->items['baseUrl']."/detalle-Oferta/".$value['IDOfertas']."' target='_blank' class='badge bg-sistema border-0 p-2 mx-1' data-tooltip='tooltip' data-toggle='tooltip' data-placement='top' title='Ver Ofertas' aria-label='Ver Ofertas'>
                    <i class='mdi mdi-currency-usd align-bottom' style='font-size: 20px; color: #FFF;'></i>
                </a>";
    //             $acciones .= '<button class="badge bg-info border-0 p-2 mx-1 datos-cargo" data-bs-target="#informacionCargo" data-form="#formInformacionCargo" data-id="'.$value['IDCargo'].'" data-accion="ver" id="ver-cargo" data-tooltip="tooltip" title="Ver Cargo">
    // 				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
    // 			</button>';
    			
    // 			if(in_array("UPDCAR", $this->items['permisos']))
    // 			{
    // 			$acciones .= '<button class="badge bg-warning border-0 p-2 mx-1 datos-cargo" data-bs-target="#informacionCargo" data-form="#formInformacionCargo" data-id="'.$value['IDCargo'].'" data-accion="editar" id="editar-cargo" data-tooltip="tooltip" title="Editar Cargo">
    // 				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
    // 			</button>';
    // 			}
    			
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
     
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    }
    
	public function exportarNuevasOfertasFacturacion()
	{
	   $fechaActual = date("Y-m-d H:i:s");

	   $arrayOferta = array(
                'TipoOferta'  => 'nuevaOferta'
            );
	   
	   $listado = $this->ofertas->obtenerNuevasOferta($arrayOferta);

        $filename = "ReporteNuevasOfertas_".$fechaActual.".xlsx";
        $writer = WriterEntityFactory::createXLSXWriter();
        $writer->setShouldUseInlineStrings(true); // default (and recommended) value
        $writer->openToBrowser($filename);
        
        $cells = [
            WriterEntityFactory::createCell("ID OFERTA"),
            WriterEntityFactory::createCell("FECHA CREACIÓN"),
            WriterEntityFactory::createCell("DELEGACIÓN"),
            WriterEntityFactory::createCell("AREA"),
            WriterEntityFactory::createCell("SUB AREA"),
            WriterEntityFactory::createCell("NÚMERO CONTRATO"),
            WriterEntityFactory::createCell("MATRÍCULA RESP."),
            WriterEntityFactory::createCell("NOMBRES RESP."),
            WriterEntityFactory::createCell("CUOTA MONITOREO"),
            WriterEntityFactory::createCell("REQUERIMIENTO"),
            WriterEntityFactory::createCell("MOTIVO"),
            WriterEntityFactory::createCell("ESTADO"),
            WriterEntityFactory::createCell("MATRÍCULA APROB."),
            WriterEntityFactory::createCell("NOMBRES APROB."),
            WriterEntityFactory::createCell("ESTADO FACTURACIÓN"),
            WriterEntityFactory::createCell("OBSERVACIÓN FACTURACION")
        ];
        
        /** add a row at a time */
        $singleRow = WriterEntityFactory::createRow($cells);
        $writer->addRow($singleRow);
        
        /***************/
        $nombreAprobador = '';
        $matriculaAprobador = '';
        /***************/
        
        foreach ($listado as $key => $item) {
            $creacion = date("Y-m-d H:i:s", strtotime($item['FechaCrea']));
            $nombreCreador = $item['NombresCreador'] . ' ' . $item['ApellidosCreador'];
        
            if ($item['Matriz'] == 'Fuera') {
                $matriculaAprobador = $item['MatriculaAprobador'];
                $nombreAprobador = $item['NombresAprobador'] . ' ' . $item['ApellidosAprobador'];
            } else {
                $nombreAprobador = 'SIN APROBADOR';
                $matriculaAprobador = 'SIN APROBADOR';
            }
        
            //  Conversión
            $idOferta = (int) $item['IDOfertas'];
            $numeroContrato = (int) $item['NumeroContrato'];
            $cuotaMonitoreo = number_format((float) $item['CuotaMonitoreo'], 3, '.', '');
        
            $cells = [
                WriterEntityFactory::createCell($idOferta),
                WriterEntityFactory::createCell($creacion),
                WriterEntityFactory::createCell($item['DelegacionSolicitanteCreador']),
                WriterEntityFactory::createCell($item['AreaSolicitanteCreador']),
                WriterEntityFactory::createCell($item['SubareaSolicitanteCreador']),
                WriterEntityFactory::createCell($numeroContrato),
                WriterEntityFactory::createCell($matriculaAprobador),
                WriterEntityFactory::createCell($nombreAprobador),
                WriterEntityFactory::createCell((float) $cuotaMonitoreo),
                WriterEntityFactory::createCell($item['Requerimiento']),
                WriterEntityFactory::createCell($item['MotivoRequerimiento']),
                WriterEntityFactory::createCell($item['Estado']),
                WriterEntityFactory::createCell($item['MatriculaCreador']),
                WriterEntityFactory::createCell($nombreCreador),
                WriterEntityFactory::createCell(''),
                WriterEntityFactory::createCell('')
            ];
        
            $singleRow = WriterEntityFactory::createRow($cells);
            $writer->addRow($singleRow);
        }
        
        $writer->close();
	}
	
    public function importarStatusNuevasOfertas() 
    {
        $fechaActual = date("Y-m-d H:i:s");
   
        $csv = $this->request->getFile("fileCSVNuevasOfertasImportar");
        
        if (!$csv->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $csv->getErrorString().'-'.$csv->getError());
            echo $this->alertas->alertaError($message);
            exit;
        }
    
        $validationRule = [
            'fileCSVNuevasOfertasImportar' => [
                'mime_in[fileCSVNuevasOfertasImportar,text/csv,text/plain]',
                'ext_in[fileCSVNuevasOfertasImportar,csv,xlsx]'
            ],
        ];
    
        if (!$this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
            echo $this->alertas->alertaError($message);
            exit;
        }
    
        $separadorCSV = $this->complementos->validarSeparadorCSV($csv->getTempName(), 16);
    
        if (!$separadorCSV) {
            $message = sprintf($this->mensajeError->msg201, "Separador CSV inválido. Use coma (,) o punto y coma (;) y elimine columnas vacías.");
            echo $this->alertas->alertaError($message);
            exit;
        }

        $fila = 0;
        $filasError = [];
        $arrayUpdate = [];
        $ejecutarUpdate = true;
    
        $handle = fopen($csv, "r");
    
        while (($data = fgetcsv($handle, 0, $separadorCSV)) !== FALSE) {
            $fila++;
            if($fila > 1) {
                $data = array_map("utf8_encode", $data);
    
                $idOferta        = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $estadoFact      = trim($data[14]," \t\n\r\0\x0B\xc2\xa0");
                $observacionFact = trim($data[15]," \t\n\r\0\x0B\xc2\xa0");
    
                if ($idOferta == '') {
                    $filasError[$fila]['ID OFERTA'] = "El ID de la oferta no puede estar vacío.";
                    $ejecutarUpdate = false;
                }
    
                if ($estadoFact == '') {
                    $filasError[$fila]['ESTADO FACTURACIÓN'] = "El estado de facturación es obligatorio.";
                    $ejecutarUpdate = false;
                }
    
                if ($ejecutarUpdate) {
                    $arrayUpdate[] = [
                        'IDOfertas'             => $idOferta,
                        'EstadoFacturacion'     => $estadoFact,
                        'ObservacionFacturacion'=> $observacionFact,
                        'UsuarioModifica'       => $this->items['id'],
                        'FechaModifica'         => $fechaActual,
                        'Localhost'             => $this->request->getIPAddress()
                    ];
                }
            }
        }
    
        fclose($handle);
    
        if (!$ejecutarUpdate) {
            $file = $this->items['basePublic'].'/error.txt';
            if (file_exists($file)) {
                unlink($file);
            }
    
            $txt = fopen($file, 'a') or die ('Problemas al crear el archivo');
            foreach ($filasError as $key => $value) {
                fwrite($txt, "FILA: ".$key."\n");
                foreach ($value as $campo => $error) {
                    fwrite($txt, $campo.": ".$error."\n");
                }
            }
            fclose($txt);
    
            $message = sprintf($this->mensajeError->msg201, "Errores encontrados en el archivo.");
            echo $this->alertas->alertaError($message);
            echo $this->alertas->descargaArchivoTXT("error.txt");
            exit;
        }
    
        // IMPORTANTE: Asegúrate de que 'ofertas' es el modelo correcto y que los campos existan.
        $update = $this->ofertas->updateBatch($arrayUpdate, 'IDOfertas');
    
        if ($update !== FALSE) {
            $message = sprintf($this->mensajeError->msg201, "Ofertas actualizadas correctamente.");
            echo $this->alertas->alertaExito($message);
            echo $this->alertas->refrescar(1);
        } else {
            $message = sprintf($this->mensajeError->msg201, "Error al actualizar las ofertas.");
            echo $this->alertas->alertaError($message);
            exit;
        }
    }

    
    
    /****************************** FUNCIONES ******************************/
    
    private function getValorDescuentoTemporal($cuota)
    {
        if ($cuota >= 100 && $cuota <= 149) return [20, 30];
        if ($cuota >= 150 && $cuota <= 199) return [40, 50];
        return [50, 60];
    }
    
    private function getValorDescuentoAlta($cuota)
    {
        if ($cuota >= 100 && $cuota <= 149) return [60];
        if ($cuota >= 150 && $cuota <= 199) return [80];
        return [100];
    }
    
    private function getValorDescuentoPermanente($cuota)
    {
        if ($cuota >= 100 && $cuota <= 149) return [20, 30];
        if ($cuota >= 150 && $cuota <= 199) return [30, 40];
        return [40, 50];
    }
 /*******************************************************************/   
    private function getValorDescuentoTemporalPortfolio($cuota) //queda PortFolio
    {

        if ($cuota >= 100 && $cuota <= 149) return [20, 40];
        if ($cuota >= 150 && $cuota <= 199) return [30, 50];
        return [40, 60];
    }

    private function getValorDescuentoPermanentePortfolio($cuota) //queda PortFolio
    {
        if ($cuota >= 100 && $cuota <= 149) return [10, 30];
        if ($cuota >= 150 && $cuota <= 199) return [20, 40];
        return [30, 50];
    }
  
    private function getValorDescuentoTemporalPortfolio34a38($cuota) //queda PortFolio
    {
        if ($cuota >= 100 && $cuota <= 149) return [20, 50];
        if ($cuota >= 150 && $cuota <= 199) return [30, 60];
        return [40, 70];
    }

    private function getValorDescuentoPermanentePortfolio34a38($cuota) //queda PortFolio
    {
        if ($cuota >= 100 && $cuota <= 149) return [10, 40];
        if ($cuota >= 150 && $cuota <= 199) return [20, 50];
        return [30, 60];
    } 
 /*******************************************************************/       
    private function getValorDescuentoTemporalPortfolioTelecierre34a38($cuota) // queda Portfolio Telecierre
    {
        if ($cuota >= 100 && $cuota <= 149) return [40, 70];
        if ($cuota >= 150 && $cuota <= 199) return [60, 90];
        return [70, 100];
    }

    private function getValorDescuentoPermanentePortfolioTelecierre34a38($cuota) // queda PortFolio Telecierre
    {
        if ($cuota >= 100 && $cuota <= 149) return [30, 50];
        if ($cuota >= 150 && $cuota <= 199) return [50, 70];
        return [60, 80];
    }
    
    private function getValorDescuentoTemporalPortfolioTelecierre($cuota) // PortFolio Telecierre
    {
        if ($cuota >= 100 && $cuota <= 149) return [40, 60];
        if ($cuota >= 150 && $cuota <= 199) return [60, 80];
        return [70, 90];
    }

    private function getValorDescuentoPermanentePortfolioTelecierre($cuota) // queda PortFolio Telecierre
    {
        if ($cuota >= 100 && $cuota <= 149) return [30, 50];
        if ($cuota >= 150 && $cuota <= 199) return [50, 70];
        return [60, 80];
    } 
    
    /****************************** DISPOSITIVOS ******************************/
    

	/**************************************************************************/
	
    /******************************* OPERADORES *******************************/
    
	/**************************************************************************/
	
    /********************************* PLANES *********************************/
    
	/**************************************************************************/
	
    /******************************* CATEGORÍAS *******************************/
    
	/**************************************************************************/
	
    /*************************** CATEGORÍAS - TIPOS ***************************/
    
	/**************************************************************************/
	
    /********************* CATEGORÍAS - TIPOS - SUBTIPOS **********************/
    
	/**************************************************************************/
	
    /***************************** ELEMENTOS DEMO *****************************/
    
	/**************************************************************************/
	
    /******************* CUENTAS CONTABLES - SUBCATEGORÍAS ********************/
    
	/**************************************************************************/
	
    /************************** PROVEEDORES ***********************************/
    
	/**************************************************************************/
	
    /********************* MODALIDAD DE PAGO - PROVEEDOR **********************/
    
	/**************************************************************************/
	
}