<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;

class Ficheros extends BaseController
{
	public function __construct(){
	    
		$this->usuarios = new \App\Models\UsuarioModel();
		$this->aging    = new \App\Models\FicheroAgingModel();
		$this->item    = new \App\Models\FicheroItemModel();
	}

    /********************************* AGING *********************************/
    
    public function listarFicheroAging()
    {
        if(isset($this->items['id']))
        {
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Fichero Aging | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Fichero aging',
				'elementoSeleccionadoModulo'=> "Fichero Aging",
				'subtitulo'                 => 'Fichero Aging'
			);
			
			$data = array_merge($data, $this->items);
			
			return view('ficheros/Aging/listar_fichero_aging',$data);
            
		} 
		else 
		{
			return view('errors/500');
		}
    }
    
    public function ficheroAgingServerside()
    {
        if (isset($this->items['id'])) 
    	{
            $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id']
            );
            
    	    $dataServerside =  $this->aging->listaGeneralFicheroAging($this->request->getPost(), $adicionales);
    	   
    	    foreach($dataServerside["data"] as $key=>$value)
            {
                // $dataServerside["data"][$key]['MontoDescuentoTotal']    = 'S/ '.$value['TotalTrabajador'];
                // $dataServerside["data"][$key]['MontoCobrado']           = (($value['MontoCobro'] != '' && $value['MontoCobro'] != null) || $value['MontoCobro'] === "0.00"  ? "S/ ".$value['MontoCobro'] : '<span class="badge bg-light border-0 text-dark">Sin información</span>');
                // $dataServerside["data"][$key]['FechaCobrado']           = ($value['FechaCobro'] != '' && $value['FechaCobro'] != null ? date("d-m-Y", strtotime($value['FechaCobro'])) : '<span class="badge bg-light border-0 text-dark">Sin información</span>');
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	} 
    	else 
    	{
            $resultado = array(
				'descripcion' => 0,
			);
			echo json_encode($resultado, JSON_NUMERIC_CHECK);
        }
    }
    
	/**************************************************************************/
	
    /****************************** ITEM ******************************/
        /********************************* AGING *********************************/
    
    public function listarFicheroItem()
    {
        if(isset($this->items['id']))
        {
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Fichero Item | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Fichero item',
				'elementoSeleccionadoModulo'=> "Fichero Item",
				'subtitulo'                 => 'Fichero Item'
			);
			
			$data = array_merge($data, $this->items);
			
			return view('ficheros/Item/listar_fichero_item',$data);
            
		} 
		else 
		{
			return view('errors/500');
		}
    }
        
    public function subirCsvFicheroItem()
    {
        $fechaActual = date("Y-m-d H:i:s");
        $csv = $this->request->getFile("fileCSVItem");
    
        if (!$csv->isValid()) {
            echo $this->alertas->alertaError("Archivo inválido: " . $csv->getErrorString());
            exit;
        }
    
        $validationRule = [
            'fileCSVItem' => [
                'mime_in[fileCSVItem,text/csv,text/plain]',
                'ext_in[fileCSVItem,csv]',
            ],
        ];
    
        if (!$this->validate($validationRule)) {
            echo $this->alertas->alertaError("Archivo inválido: " . implode(", ", $this->validator->getErrors()));
            exit;
        }
    
        $separadorCSV = $this->complementos->validarSeparadorCSV($csv->getTempName(), 11);
        if (!$separadorCSV) {
            echo $this->alertas->alertaError("Separador CSV inválido. Use coma (,) o punto y coma (;).");
            exit;
        }
    
        $fila = 0;
        $filasError = [];
        $arrayInsert = [];
        $usuario = $this->items['id'];
        $ip = $this->request->getIPAddress();
    
        $handle = fopen($csv->getTempName(), "r");
        $headers = fgetcsv($handle, 0, $separadorCSV); // Leer cabeceras
    
        // $camposEsperados = [
        //     'NroContrato', 'FechaInstalacion', 'EstatusMonitoringBilling', 'CuotaSinIgv', 'CuotaConIgv',
        //     'OfertaVigente_Fecha', 'OfertaVigenteImporte', 'OfertaPermanenteCantidad', 'OfertaPermanenteImporte',
        //     'DeudaVigenteCantidad', 'DeudaVigenteImporte'
        // ];
    
        // // Validar cabeceras
        // if ($headers !== $camposEsperados) {
        //     echo $this->alertas->alertaError("Las cabeceras del archivo CSV no coinciden con el formato esperado.");
        //     exit;
        // }
    $ejecutarUpdate='';
        while (($data = fgetcsv($handle, 0, $separadorCSV)) !== FALSE) {
            $fila++;
            $data = array_map("utf8_encode", $data);
        
            // Limpiar y asignar
            $nroContrato                = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
            $fechaInstalacion           = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
            $estatusMonitoring          = trim($data[2]," \t\n\r\0\x0B\xc2\xa0");
            $cuotaSinIgv                = trim($data[3]," \t\n\r\0\x0B\xc2\xa0");
            $cuotaConIgv                = trim($data[4]," \t\n\r\0\x0B\xc2\xa0");
            $ofertaVigenteFecha         = trim($data[5]," \t\n\r\0\x0B\xc2\xa0");
            $ofertaVigenteImporte       = trim($data[6]," \t\n\r\0\x0B\xc2\xa0");
            $ofertaPermanenteCantidad   = trim($data[7]," \t\n\r\0\x0B\xc2\xa0");
            $ofertaPermanenteImporte    = trim($data[8]," \t\n\r\0\x0B\xc2\xa0");
            $deudaVigenteCantidad       = trim($data[9]," \t\n\r\0\x0B\xc2\xa0");
            $deudaVigenteImporte        = trim($data[10]," \t\n\r\0\x0B\xc2\xa0");
        
            // Validaciones
            if (empty($nroContrato)) {
                $filasError[$fila]['NroContrato'] = "El número de contrato no puede estar vacío.";
                $ejecutarUpdate = false;
            }
        
            if (empty($fechaInstalacion) || !strtotime($fechaInstalacion)) {
                $filasError[$fila]['FechaInstalacion'] = "La fecha de instalación es inválida o vacía.";
                $ejecutarUpdate = false;
            }
        
            if (!is_numeric($cuotaSinIgv)) {
                $filasError[$fila]['CuotaSinIgv'] = "Debe ser un valor numérico.";
                $ejecutarUpdate = false;
            }
        
            if (!is_numeric($cuotaConIgv)) {
                $filasError[$fila]['CuotaConIgv'] = "Debe ser un valor numérico.";
                $ejecutarUpdate = false;
            }
        
            if (!empty($ofertaVigenteFecha) && !strtotime($ofertaVigenteFecha)) {
                $filasError[$fila]['OfertaVigente_Fecha'] = "La fecha es inválida.";
                $ejecutarUpdate = false;
            }
        
            if (!empty($ofertaVigenteImporte) && !is_numeric($ofertaVigenteImporte)) {
                $filasError[$fila]['OfertaVigenteImporte'] = "Debe ser numérico.";
                $ejecutarUpdate = false;
            }
        
            if (!empty($ofertaPermanenteCantidad) && !is_numeric($ofertaPermanenteCantidad)) {
                $filasError[$fila]['OfertaPermanenteCantidad'] = "Debe ser un entero.";
                $ejecutarUpdate = false;
            }
        
            if (!empty($ofertaPermanenteImporte) && !is_numeric($ofertaPermanenteImporte)) {
                $filasError[$fila]['OfertaPermanenteImporte'] = "Debe ser numérico.";
                $ejecutarUpdate = false;
            }
        
            if (!empty($deudaVigenteCantidad) && !is_numeric($deudaVigenteCantidad)) {
                $filasError[$fila]['DeudaVigenteCantidad'] = "Debe ser un entero.";
                $ejecutarUpdate = false;
            }
        
            if (!empty($deudaVigenteImporte) && !is_numeric($deudaVigenteImporte)) {
                $filasError[$fila]['DeudaVigenteImporte'] = "Debe ser numérico.";
                $ejecutarUpdate = false;
            }
        
            // Solo agregar si no hay errores
            if ($ejecutarUpdate !== false) {
                $arrayInsert[] = [
                    'NroContrato'                => $nroContrato,
                    'FechaInstalacion'          => date('Y-m-d', strtotime($fechaInstalacion)),
                    'EstatusMonitoringBilling'  => $estatusMonitoring,
                    'CuotaSinIgv'               => floatval($cuotaSinIgv),
                    'CuotaConIgv'               => floatval($cuotaConIgv),
                    'OfertaVigente_Fecha'       => !empty($ofertaVigenteFecha) ? date('Y-m-d', strtotime($ofertaVigenteFecha)) : null,
                    'OfertaVigenteImporte'      => floatval($ofertaVigenteImporte),
                    'OfertaPermanenteCantidad'  => intval($ofertaPermanenteCantidad),
                    'OfertaPermanenteImporte'   => floatval($ofertaPermanenteImporte),
                    'DeudaVigenteCantidad'      => intval($deudaVigenteCantidad),
                    'DeudaVigenteImporte'       => floatval($deudaVigenteImporte),
        
                    // Auditoría
                    'UsuarioCrea'    => $this->items['id'],
                    'FechaCrea'      => $fechaActual,
                    'Estado'         => 'CREA',
                    'UsuarioEstado'  => $this->items['id'],
                    'FechaEstado'    => $fechaActual,
                    'Localhost'      => $this->request->getIPAddress()
                ];
            }
        }

        fclose($handle);
    
        // Manejo de errores
        if (!empty($filasError)) {
            $file = $this->items['basePublic'].'/error.txt';
            file_put_contents($file, "");
            foreach ($filasError as $fila => $error) {
                file_put_contents($file, "FILA {$fila}: {$error}\n", FILE_APPEND);
            }
    
            echo $this->alertas->alertaError("Errores encontrados al procesar el archivo.");
            echo $this->alertas->descargaArchivoTXT("error.txt");
            exit;
        }
    
        // Inserción masiva
        $insert = $this->item->insertBatch($arrayInsert);
    
        if ($insert !== false) {
            echo $this->alertas->alertaExito("Fichero Item importado correctamente.");
            echo $this->alertas->refrescar(1);
        } else {
            echo $this->alertas->alertaError("No se pudo importar el archivo.");
        }
    }

    
    public function ficheroItemServerside()
    {
        if (isset($this->items['id'])) 
    	{
            $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id']
            );
            
    	    $dataServerside =  $this->item->listaGeneralFicheroItem($this->request->getPost(), $adicionales);
    	    var_dump($dataServerside); exit;
    	   
    	    foreach($dataServerside["data"] as $key=>$value)
            {
                // $dataServerside["data"][$key]['MontoDescuentoTotal']    = 'S/ '.$value['TotalTrabajador'];
                // $dataServerside["data"][$key]['MontoCobrado']           = (($value['MontoCobro'] != '' && $value['MontoCobro'] != null) || $value['MontoCobro'] === "0.00"  ? "S/ ".$value['MontoCobro'] : '<span class="badge bg-light border-0 text-dark">Sin información</span>');
                // $dataServerside["data"][$key]['FechaCobrado']           = ($value['FechaCobro'] != '' && $value['FechaCobro'] != null ? date("d-m-Y", strtotime($value['FechaCobro'])) : '<span class="badge bg-light border-0 text-dark">Sin información</span>');
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	} 
    	else 
    	{
            $resultado = array(
				'descripcion' => 0,
			);
			echo json_encode($resultado, JSON_NUMERIC_CHECK);
        }
    }

	/**************************************************************************/
	
    /******************************* OPERADORES *******************************/
    
	/**************************************************************************/
	
    /********************************* PLANES *********************************/
    
	/**************************************************************************/
	
    /******************************* CATEGORÍAS *******************************/
    
	/**************************************************************************/
	
    /*************************** CATEGORÍAS - TIPOS ***************************/
    
	/**************************************************************************/
	
    /********************* CATEGORÍAS - TIPOS - SUBTIPOS **********************/
    
	/**************************************************************************/
	
    /***************************** ELEMENTOS DEMO *****************************/
    
	/**************************************************************************/
	
    /******************* CUENTAS CONTABLES - SUBCATEGORÍAS ********************/
    
	/**************************************************************************/
	
    /************************** PROVEEDORES ***********************************/
    
	/**************************************************************************/
	
    /********************* MODALIDAD DE PAGO - PROVEEDOR **********************/
    
	/**************************************************************************/
	
}