<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

class Configuracion extends BaseController
{
	public function __construct()
	{
	    $this->db = \Config\Database::connect();
	    
 		$this->requerimientos = new \App\Models\RequerimientosModel();
 		$this->requerimientosPerfil = new \App\Models\RequerimientosPerfilModel();
		$this->requerimientosGruposTrabajo = new \App\Models\RequerimientosGruposTrabajoModel();
		$this->requerimientosMotivo = new \App\Models\RequerimientosMotivoModel();
		
		$this->grupostrabajo = new \App\Models\GruposTrabajoModel();
		
		$this->formatosAprobacion   = new \App\Models\FormatosAprobacionModel();
		$this->matrizCondonacionCobranza    = new \App\Models\MatrizCondonacionCobranzaModel();
		
		$this->usuarioGruposTrabajo = new \App\Models\UsuarioGruposTrabajoModel();
		
		
	    $this->peticiones = new \App\Models\PeticionesModel();
//         $this->usuarioPerfil = new \App\Models\UsuarioPerfilModel();
//         $this->usuarioPermisos = new \App\Models\UsuarioPermisosModel();
//         $this->usuarioRutas = new \App\Models\UsuarioRutasModel();
	}

	public function listarRequerimientos()
	{
    	if(isset($this->items['id'])){

			/* ACCIONES */
			$listadoRequerimientos = $this->requerimientos->findAll();
			
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Requerimientos | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Requerimientos',
				'listadoRequerimientos' => $listadoRequerimientos
			);
			$data = array_merge($data, $this->items);
			return view('configuracion/listar_requerimientos',$data);			
		} else {
			return view('errors/500');
		}	
	}

	public function registrarRequerimiento()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $requerimiento  = ucwords(mb_strtolower($this->request->getPost('txtRequerimiento_ireq')));
        $tipo           = $this->request->getPost('txtTipoRequerimiento_ireq');
        $observacion    = $this->request->getPost('txtObservacionRequerimiento_ireq');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($requerimiento, 'required|trim|minlength[1]|maxlength[50]', 'Requerimiento');
        $error .= $this->complementos->validaCampo($tipo, 'required|trim|minlength[1]|maxlength[10]', 'Tipo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereExistencia = array(
            "Requerimiento" => $requerimiento,
	        "Tipo"          => $tipo
        );
        
		$requerimientoExistente = $this->requerimientos->where($whereExistencia)->findAll();
        
        if(count($requerimientoExistente)>0)
        {
            $msgExistencia .= "<li>El requerimiento ya fue registrado bajo el tipo seleccionado. [CAMPO] <small>REQUERIMIENTO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'Requerimiento' => $requerimiento,
            'Tipo'          => $tipo,
            'Observacion'   => $observacion,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress(),
            'UsuarioEstado' => $this->items['id'],
            'FechaEstado'   => $fechaActual,    
            'MotivoEstado'  => "Creación de requerimiento.",    
            'Estado'        => 'A'
        );

        $lastId = $this->requerimientos->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $requerimiento);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
	public function obtenerDatosRequerimiento()
	{
		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idRequerimiento = $this->request->getPost('idRequerimiento');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idRequerimiento, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosRequerimiento = $this->requerimientos->where('IDRequerimiento', $idRequerimiento)->first();

		if(!empty($datosRequerimiento)){
			$resultado = array(
				'idrequerimiento'   => (string) $idRequerimiento,
				'requerimiento'     => (string) $datosRequerimiento['Requerimiento'],
				'tipo'              => (string) $datosRequerimiento['Tipo'],
				'observacion'       => (string) $datosRequerimiento['Observacion']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}
	
	public function modificarRequerimiento($idRequerimiento)
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $requerimiento  = ucwords(mb_strtolower($this->request->getPost('txtRequerimiento_ireq'))) ;
        $tipo           = $this->request->getPost('txtTipoRequerimiento_ireq');
        $observacion    = $this->request->getPost('txtObservacionRequerimiento_ireq');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($requerimiento, 'required|trim|minlength[1]|maxlength[50]', 'Requerimiento');
        $error .= $this->complementos->validaCampo($tipo, 'required|trim|minlength[1]|maxlength[10]', 'Tipo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'Requerimiento'     => $requerimiento,
            'Tipo'              => $tipo,
            'Observacion'       => $observacion,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->requerimientos->update([$idRequerimiento], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $requerimiento);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
	}
	
    public function modificarEstadoRequerimiento()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idRequerimiento = $this->request->getPost('idRequerimiento');
        $estado = $this->request->getPost('estado');
        $motivo = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idRequerimiento, 'required|trim|numeric', 'ID Requerimiento');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        $lastId = $this->requerimientos->update([$idRequerimiento], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idRequerimiento);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
//     public function listadoRequerimientos()
//     {
//         $tipoRequerimiento = $this->request->getPost("tipoRequerimiento");
        
//         if($tipoRequerimiento != '' && $tipoRequerimiento != null && $tipoRequerimiento != "undefined")
//         {
//             $listado = $this->requerimientos->where("Tipo", $tipoRequerimiento)->findAll();
//         }
//         else
//         {
//             $listado = $this->requerimientos->findAll();
//         }
        
//         $elementos=array();

// 		if (!empty($listado)) {
//             foreach ($listado as $items) {
//                 $elementos[] = array(
// 					'id' => (string) $items['IDRequerimiento'],
//                     'text' => (string) $items['Requerimiento']
//                 );
//             }

//             $resultado = array(
// 				'listadoRequerimientos' => json_encode($elementos)
// 			);
//         } else {
// 			$resultado = array(
// 				'descripcion' => 0,
// 			);
// 		}

//         /*
//          * ----------------------------
//          * DATOS DE AJAX PRE PROCESADOS
//          * ----------------------------
//          */
//         echo json_encode($resultado, JSON_NUMERIC_CHECK);		
//     }

    public function listadoTipoRequerimientos()
    {
        if(isset($this->items['id']))
        {
            $grupoTrabajo = $this->request->getPost("grupoTrabajo");
            
            if($grupoTrabajo != '' && $grupoTrabajo != null && $grupoTrabajo != "undefined")
            {
                $where = array(
                    "grupoTrabajo" => $grupoTrabajo,
                    "estado"    => "A");
                
                $listado = $this->requerimientosGruposTrabajo->listadoTipoRequerimientos($where);
            }
            else
            {
                $listado =array();
            }
            
            $elementos=array();
    
    		if (!empty($listado)) {
                foreach ($listado as $items) {
                    $elementos[] = array(
    					'id' => (string) $items['Tipo'],
                        'text' => (string) $items['Tipo']
                    );
                }
    
                $resultado = array(
    				'listadoTipoRequerimientos' => json_encode($elementos)
    			);
            } else {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
        } 
        else 
        {
    		$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
    }


    public function listadoRequerimientos()
    {
        if(isset($this->items['id']))
        {
            $tipoRequerimiento = $this->request->getPost("tipoRequerimiento");
            $grupoTrabajo = $this->request->getPost("grupoTrabajo"); 
            
            if($tipoRequerimiento != '' && $tipoRequerimiento != null && $tipoRequerimiento != "undefined")
            { 
                $where = array(
                    "perfil"    => $this->items['idPerfil'],
                    "estado"    => "A",
                    "tipo"      => $tipoRequerimiento,
                    "grupoTrabajo" => $grupoTrabajo);
                
                $listado = $this->requerimientos->listadoRequerimientos($where);
            }
            else
            {
                $listado = array();
            }
            
            $elementos=array();
    
    		if (!empty($listado)) {
                foreach ($listado as $items) {
                    $elementos[] = array(
    					'id' => (string) $items['IDRequerimiento'],
                        'text' => (string) $items['Requerimiento']
                    );
                }
    
                $resultado = array(
    				'listadoRequerimientos' => json_encode($elementos)
    			);
            } else {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
        } 
        else 
        {
    		$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
    }
    
	public function listarPerfilesRequerimiento($idRequerimiento)
    {
		if(isset($this->items['id'])){
			/* BUSCAR PERMISOS*/
            
			$listaPerfiles = $this->requerimientosPerfil->listarPerfilesRequerimiento($idRequerimiento);
            $requerimiento = $this->requerimientos->where("IDRequerimiento", $idRequerimiento)->first();
            
			$data = array (
				'session'           => 'on',
				'titulo'            => 'Perfiles Permitidos | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Perfiles Permitidos - '.$requerimiento['Requerimiento'],
                'previo'            => 'listar-requerimientos',
				'listaPerfiles'     => $listaPerfiles,
                'requerimiento'     => $requerimiento,
                'idRequerimiento'   => $idRequerimiento
			);
			$data = array_merge($data, $this->items);
			return view('configuracion/listar_perfiles_requerimiento',$data);			
		} else {
			return view('errors/500');
		}
	}

    public function guardarPerfilesRequerimiento($idRequerimiento)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $perfiles = $this->request->getPost('perfiles') ;
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';

        if(isset($perfiles) && empty($perfiles))
        {
            $error .= "<li>No hay perfiles seleccionados.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        /*
        * ----------------------------
        * LIMPIAR EXISTENCIA PREVIA
        * ----------------------------
        */

        $listadoPerfilesPrev = $this->requerimientosPerfil->where("IDRequerimiento", $idRequerimiento)->findAll();

        if(count($listadoPerfilesPrev) > 0)
        {
            $this->requerimientosPerfil->delete($idRequerimiento);
        }

        /*
        * ----------------------------
        * GENERAR NUEVA DATA
        * ----------------------------
        */

        $dataPerfiles = array();

        foreach($perfiles as $key => $value)
        {
            $dataPerfiles[] = array (
                'IDRequerimiento'   => $idRequerimiento, 
                'IDPerfil'          => $key,
                'UsuarioRegistra'   => $this->items['id'],
                'FechaRegistra'     => $fechaActual
            );
        }
        $lastId = $this->requerimientosPerfil->insertBatch($dataPerfiles, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idRequerimiento);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function listarGruposTrabajoRequerimiento($idRequerimiento)
    {
        if(isset($this->items['id'])){
			/* BUSCAR PERMISOS*/
            
			$listaGruposTrabajo = $this->requerimientosGruposTrabajo->listarGruposTrabajoRequerimiento($idRequerimiento);
            $requerimiento = $this->requerimientos->where("IDRequerimiento", $idRequerimiento)->first();
            
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Grupos de Trabajo autorizados | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Grupos de Trabajo autorizados a gestionar - '.$requerimiento['Requerimiento'],
                'previo'                => 'listar-requerimientos',
				'listaGruposTrabajo'    => $listaGruposTrabajo,
                'requerimiento'         => $requerimiento,
                'idRequerimiento'       => $idRequerimiento
			);
			$data = array_merge($data, $this->items);
			return view('configuracion/listar_grupos_trabajo_requerimiento',$data);			
		} else {
			return view('errors/500');
		}
    }
    
    public function listadoGruposTrabajoRequerimiento()
    {
        $idRequerimiento = $this->request->getPost("idRequerimiento");
        
        if($idRequerimiento == 'TOTAL')
        {
            $listadoGruposTrabajo = $this->grupostrabajo->findAll();
        }
        else
        {
            // $whereGTR = array('IDRequerimiento' => $idRequerimiento);
            $listadoGruposTrabajo = $this->requerimientosGruposTrabajo->listarGruposTrabajoRequerimientoXRequerimiento($idRequerimiento);
        }
        
        $elementos=array();

		if (!empty($listadoGruposTrabajo)) {
            foreach ($listadoGruposTrabajo as $items) {
                $elementos[] = array(
					'id' => (string) $items['IDGrupoTrabajo'],
                    'text' => (string) $items['GrupoTrabajo']
                );
            }

            $resultado = array(
				'listadoGruposTrabajo' => json_encode($elementos)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);
    }
    
    public function guardarGruposTrabajoRequerimiento($idRequerimiento)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $grupostrabajo = $this->request->getPost('grupotrabajo') ;
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';

        if(isset($grupostrabajo) && empty($grupostrabajo))
        {
            $error .= "<li>No hay grupos de trabajo seleccionados.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        /*
        * ----------------------------
        * LIMPIAR EXISTENCIA PREVIA
        * ----------------------------
        */

        $listadoGruposTrabajoPrev = $this->requerimientosGruposTrabajo->where("IDRequerimiento", $idRequerimiento)->findAll();

        if(count($listadoGruposTrabajoPrev) > 0)
        {
            $this->requerimientosGruposTrabajo->delete($idRequerimiento);
        }

        /*
        * ----------------------------
        * GENERAR NUEVA DATA
        * ----------------------------
        */

        $dataGruposTrabajo = array();

        foreach($grupostrabajo as $key => $value)
        {
            $dataGruposTrabajo[] = array (
                'IDRequerimiento'   => $idRequerimiento, 
                'IDGrupoTrabajo'    => $key,
                'UsuarioRegistra'   => $this->items['id'],
                'FechaRegistra'     => $fechaActual
            );
        }
        $lastId = $this->requerimientosGruposTrabajo->insertBatch($dataGruposTrabajo, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idRequerimiento);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function listarMotivosRequerimiento($idRequerimiento)
    {
        if(isset($this->items['id'])){

			/* ACCIONES */
            $requerimiento = $this->requerimientos->where('IDRequerimiento', $idRequerimiento)->first();
			$listaMotivos = $this->requerimientosMotivo->where('IDRequerimiento', $idRequerimiento)->findAll();
			
			$data = array (
				'session'           => 'on',
				'titulo'            => 'Motivos de Requerimiento | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Motivos - '.$requerimiento['Requerimiento'],
                'previo'            => 'listar-requerimientos',
                'requerimiento'     => $requerimiento,
				'listaMotivos'      => $listaMotivos
			);
			$data = array_merge($data, $this->items);
			return view('configuracion/listar_motivos_requerimiento',$data);			
		} else {
			return view('errors/500');
		}
    }
    
    public function registrarMotivoRequerimiento()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError       = TRUE;
        $requerimiento  = $this->request->getPost('txtIDRequerimiento_i');
        $motivo         = ucwords(mb_strtolower($this->request->getPost('txtMotivoRequerimiento_i')));
        $observacion    = $this->request->getPost('txtObservacionMotivoReq_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($requerimiento, 'required|trim|number', 'ID Requerimiento');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim|minlength[1]|maxlength[100]', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereMotivo = array(
            'IDRequerimiento'   => $requerimiento,
            'Motivo'            => $motivo
        );
        
		$motivoExistente = $this->requerimientosMotivo->where($whereMotivo)->findAll();
        
        if(count($motivoExistente)>0)
        {
            $msgExistencia .= "<li>El motivo ya fue registrado. [CAMPO] <small>MOTIVO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'IDRequerimiento'   => $requerimiento,
            'Motivo'            => $motivo,
            'Observacion'       => $observacion,
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'Estado'            => 'A',
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,    
            'MotivoEstado'      => 'Motivo de requerimiento creada.'
        );

        $lastId = $this->requerimientosMotivo->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $motivo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	public function obtenerDatosMotivoRequerimiento() {

		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idMotivo = $this->request->getPost('idMotivo');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idMotivo, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosMotivo = $this->requerimientosMotivo->where('IDMotivo', $idMotivo)->first();

		if(!empty($datosMotivo)){
			$resultado = array(
				'idmotivo'      => (string) $idMotivo,
				'motivo'        => (string) $datosMotivo['Motivo'],
				'observacion'   => (string) $datosMotivo['Observacion']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}
	
    public function modificarMotivoRequerimiento($idMotivo){

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        $msjError       = TRUE;
        $motivo         = ucwords(mb_strtolower($this->request->getPost('txtMotivoRequerimiento_i')));
        $observacion    = $this->request->getPost('txtObservacionMotivoReq_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($motivo, 'required|trim|minlength[1]|maxlength[100]', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */
        
        $data = array (
            'Motivo'            => $motivo,
            'Observacion'       => $observacion,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->requerimientosMotivo->update([$idMotivo], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idMotivo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function modificarEstadoMotivoRequerimiento()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idMotivo = $this->request->getPost('idMotivo');
        $estado = $this->request->getPost('estado');
        $motivo = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idMotivo, 'required|trim|numeric', 'ID Motivo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'Estado'            => $estado,
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,    
            'MotivoEstado'      => $motivo
        );
        
        $lastId = $this->requerimientosMotivo->update([$idMotivo], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idMotivo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function listadoMotivosRequerimiento()
    {
        $idRequerimiento = $this->request->getPost("idRequerimiento");
        
        if($idRequerimiento != '' && $idRequerimiento != null && $idRequerimiento != "undefined")
        {
            $whereMotivos = array(
                "IDRequerimiento"   => $idRequerimiento,
                "Estado"            => "A"
            );
        }
        else
        {
            $whereMotivos = array(
                "IDRequerimiento"   => $idRequerimiento,
                "Estado"            => "A"
            );
        }
        
        $listado = $this->requerimientosMotivo->where($whereMotivos)->findAll();
        
        $elementos=array();

		if (!empty($listado)) {
            foreach ($listado as $items) {
                $elementos[] = array(
					'id' => (string) $items['IDMotivo'],
                    'text' => (string) $items['Motivo'],
                    'adjunto' => (string) $items['RequiereAdjunto']
                );
            }

            $resultado = array(
				'listadoMotivos' => json_encode($elementos)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
    }
        
	public function listarGruposTrabajo()
	{
    	if(isset($this->items['id'])){

			/* ACCIONES */
			$listadoGruposTrabajo = $this->grupostrabajo->findAll();
			
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Grupos de Trabajo | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Grupos de Trabajo',
				'listadoGruposTrabajo'  => $listadoGruposTrabajo
			);
			$data = array_merge($data, $this->items);
			return view('configuracion/listar_grupos_trabajo',$data);			
		} else {
			return view('errors/500');
		}	
	}

	public function registrarGrupoTrabajo()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $grupoTrabajo  = ucwords(mb_strtolower($this->request->getPost('txtGrupoTrabajo_i')));
        $observacion    = $this->request->getPost('txtObservacionGrupoTrabajo_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($grupoTrabajo, 'required|trim|minlength[1]|maxlength[50]', 'Grupo de Trabajo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$gtExistente = $this->grupostrabajo->where("GrupoTrabajo", $grupoTrabajo)->findAll();
        
        if(count($gtExistente)>0)
        {
            $msgExistencia .= "<li>El grupo de trabajo ya fue registrado. [CAMPO] <small>GRUPO DE TRABAJO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'GrupoTrabajo'  => $grupoTrabajo,
            'Observacion'   => $observacion,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress(),
            'UsuarioEstado' => $this->items['id'],
            'FechaEstado'   => $fechaActual,    
            'MotivoEstado'  => "Creación de grupo de trabajo.",    
            'Estado'        => 'A'
        );

        $lastId = $this->grupostrabajo->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $grupoTrabajo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
	public function obtenerDatosGrupoTrabajo()
	{
		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idGrupoTrabajo = $this->request->getPost('idGrupoTrabajo');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idGrupoTrabajo, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosGrupoTrabajo = $this->grupostrabajo->where('IDGrupoTrabajo', $idGrupoTrabajo)->first();

		if(!empty($datosGrupoTrabajo)){
			$resultado = array(
				'idgrupotrabajo'    => (string) $idGrupoTrabajo,
				'grupotrabajo'      => (string) $datosGrupoTrabajo['GrupoTrabajo'],
				'observacion'       => (string) $datosGrupoTrabajo['Observacion']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}
	
	public function modificarGrupoTrabajo($idGrupoTrabajo)
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $grupoTrabajo  = ucwords(mb_strtolower($this->request->getPost('txtGrupoTrabajo_i'))) ;
        $observacion    = $this->request->getPost('txtObservacionGrupoTrabajo_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($grupoTrabajo, 'required|trim|minlength[1]|maxlength[50]', 'Grupo de Trabajo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'GrupoTrabajo'      => $grupoTrabajo,
            'Observacion'       => $observacion,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->grupostrabajo->update([$idGrupoTrabajo], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $grupoTrabajo);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
	}
	
    public function modificarEstadoGrupoTrabajo()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idGrupoTrabajo = $this->request->getPost('idGrupoTrabajo');
        $estado = $this->request->getPost('estado');
        $motivo = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idGrupoTrabajo, 'required|trim|numeric', 'ID Grupo de Trabajo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        $lastId = $this->grupostrabajo->update([$idGrupoTrabajo], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idGrupoTrabajo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function listadoGruposTrabajo()
    {
        // $tipoRequerimiento = $this->request->getPost("tipoRequerimiento");
        
        // if($tipoRequerimiento != '' && $tipoRequerimiento != null && $tipoRequerimiento != "undefined")
        // {
        //     $listado = $this->requerimientos->where("Tipo", $tipoRequerimiento)->findAll();
        // }
        // else
        // {
        //     $listado = $this->requerimientos->findAll();
        // }
        
        $listado = $this->grupostrabajo->findAll();
        
        $elementos=array();

		if (!empty($listado)) {
            foreach ($listado as $items) {
                $elementos[] = array(
					'id' => (string) $items['IDGrupoTrabajo'],
                    'text' => (string) $items['GrupoTrabajo']
                );
            }

            $resultado = array(
				'listadoGruposTrabajo' => json_encode($elementos)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
    }
    
    public function listarUsuariosGrupoTrabajo($idGrupoTrabajo)
    {
        if(isset($this->items['id'])){
			/* BUSCAR ACCIONES */
			$whereUGT = array(
			    "idgrupotrabajo"    => $idGrupoTrabajo
			);
			$grupoTrabajo = $this->grupostrabajo->where("IDGrupoTrabajo", $idGrupoTrabajo)->first();
			$listaUsuarios = $this->usuarioGruposTrabajo->listarUsuariosGrupoTrabajo($whereUGT);
            
			$data = array (
				'session'           => 'on',
				'titulo'            => 'Usuarios - Grupo de Trabajo | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Usuarios asociados - '.$grupoTrabajo['GrupoTrabajo'],
                'previo'            => 'listar-grupos-trabajo',
				'listaUsuarios'     => $listaUsuarios,
                'idGrupoTrabajo'    => $idGrupoTrabajo
			);
			$data = array_merge($data, $this->items);
			return view('configuracion/listar_usuarios_grupo_trabajo',$data);			
		} else {
			return view('errors/500');	
		}
    }
    
    public function asociarUsuarioGrupoTrabajo()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError       = TRUE;
        $idUsuario      = $this->request->getPost('idUsuario');
        $idGrupoTrabajo = $this->request->getPost('idGrupoTrabajo');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idUsuario, 'required|trim|number', 'ID Usuario');
        $error .= $this->complementos->validaCampo($idGrupoTrabajo, 'required|trim|number', 'ID Grupo de Trabajo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereUGT = array(
            'IdUsuario'         => $idUsuario,
            'IDGrupoTrabajo'    => $idGrupoTrabajo
        );
        
		$combinacionExistente = $this->usuarioGruposTrabajo->where($whereUGT)->findAll();
		
        if(count($combinacionExistente)>0)
        {
            $msgExistencia .= "<li>El usuario ya fue agregado al grupo de trabajo. [CAMPO] <small>USUARIO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'IdUsuario'         => $idUsuario, 
            'IDGrupoTrabajo'    => $idGrupoTrabajo,
            'UsuarioRegistra'   => $this->items['id'],
            'FechaRegistra'     => $fechaActual
        );

        $lastId = $this->usuarioGruposTrabajo->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function eliminarUsuarioGrupoTrabajo()
    {
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $idUsuario      = $this->request->getPost('idUsuario');
        $idGrupoTrabajo = $this->request->getPost('idGrupoTrabajo');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idUsuario, 'required|trim|number', 'ID Usuario');
        $error .= $this->complementos->validaCampo($idGrupoTrabajo, 'required|trim|number', 'ID Grupo de Trabajo');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $whereDelete = array (
            'IdUsuario'         => $idUsuario, 
            'IDGrupoTrabajo'    => $idGrupoTrabajo
        );

        $lastId = $this->usuarioGruposTrabajo->where($whereDelete)->delete();

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg504, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

    public function listarUsuariosGrupoTrabajoSelect()
    {
        $elemento = $this->request->getPost('term');
        $infoPeticion = $this->peticiones->where("IDPeticion", $elemento['peticion'])->first();
        $whereUGT = array(
		    "idgrupotrabajo"=> $infoPeticion['IDGrupoTrabajoDestino'],
		    "like"          => $elemento['term']
		);
		
		$listado = $this->usuarioGruposTrabajo->listarUsuariosGrupoTrabajo($whereUGT);
        
        // $listado = $this->usuarioModelo->listadoUsuariosSelect($elemento['term'], '', 'Activo');
        
        $elementos=array();

        foreach ($listado as $items) {
            $elementos[] = array(
                'id' => (string) $items['IdUsuario'],
                'text' => (string) $items['Matricula']." | ".$items['Nombres']." ".$items['Apellidos']
            );
        }

        echo json_encode($elementos);
    }
    
	/**************************************************************************/
	
    /******************** MATRIZ DE CONDONACIONES COBRANZA ********************/
    
    public function matrizCondonacionCobranza()
    {
        if(isset($this->items['id']))
        {
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Matriz de condonación - Cobranza | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Matriz de condonación - Cobranza',
				'elementoSeleccionadoModulo'=> "Matriz de condonación - Cobranza",
				'subtitulo'                 => 'Clientes con condonación aprobada'
			);
			
			$data = array_merge($data, $this->items);
			
			return view('configuracion/matriz_condonacion_cobranza',$data);			
		} 
		else 
		{
			return view('errors/500');
		}
    }
    
    public function matrizCondonacionCobranzaServerside()
    {
        if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id']
            );
            
            /* LISTAR FORMATOS DE APROBACIÓN */
            $dataServerside = $this->matrizCondonacionCobranza->listaGeneralMatrizCondonacionCobranza($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
    			$dataServerside["data"][$key]['PorcentajeDescuento'] = ($value['Descuento']*100).'%';
                
                $dataServerside["data"][$key]['ValorDeudaVencida'] = 'S/ '.$value['DeudaVencida'];
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    }
    
    public function importarCSVMatrizCondonacionCobranza()
    {
        $fechaActual = date("Y-m-d H:i:s");
        $fechaActualAdd = date("Y-m-d H:i:s", strtotime($fechaActual)+1);
        
        /*
        * ----------------------------
        * DECLARAR Y ASIGNAR VARIABLE A ARCHIVO OBTENIDO
        * ----------------------------
        */
        
        $csv = $this->request->getFile("itemsFile");

        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $csv->isValid()) 
        {
            $message = sprintf($this->mensajeError->msg201, $csv->getErrorString().'-'.$csv->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'itemsFile' => [
                'mime_in[itemsFile,text/csv,text/plain]',
                'ext_in[itemsFile,csv]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        /*
        * ----------------------------
        * VALIDAR SEPARADOR CSV
        * ----------------------------
        */
        
        $separadorCSV = $this->complementos->validarSeparadorCSV($csv, 6);
        
        if (!$separadorCSV) {
            $message = sprintf($this->mensajeError->msg201, "No se encontró separador de CSV autorizado. Debe usar coma (,) o punto y coma (;) y eliminar celdas vacías a la derecha de la última columna.");
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y VALIDAR DATOS CORRECTOS
        * ----------------------------
        */
        
        $lineasCSV = array();
        $iccidCSV = array();
        $imeiCSV = array();
        
        //Declaramos variables
        $fila = 0;
        $filasError = array();
        $ejecutarInsert = true;
        //Abrimos el archivo
        $handle = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handle, 0, $separadorCSV)) !== FALSE)
        {
            $fila++;

            if($fila>1)
            {
                $data = array_map("utf8_encode", $data);
                //Asignamos valores de CSV a variables locales
                $contrato       = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $cartera        = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                $nombre         = trim($data[2]," \t\n\r\0\x0B\xc2\xa0");
                $nif            = trim($data[3]," \t\n\r\0\x0B\xc2\xa0");
                $descuento      = trim($data[4]," \t\n\r\0\x0B\xc2\xa0");
                $deudaVencida   = trim($data[5]," \t\n\r\0\x0B\xc2\xa0");
                
                //Validamos Contrato
                if($contrato == null || $contrato == '')
                {
                    $filasError[$fila]['CONTRATO'] = "EL CONTRATO ES OBLIGATORIO.";
                    $ejecutarInsert = false;
                }
                else
                {
                    if(!is_numeric($contrato))
                    {
                        $filasError[$fila]['CONTRATO'] = "EL CONTRATO INGRESADO NO ES UN NÚMERO.";
                        $ejecutarInsert = false;
                    }
                }

                //Validamos cartera
                if($cartera == null || $cartera == '')
                {
                    $filasError[$fila]['CARTERA'] = "LA CARTERA ES OBLIGATORIO.";
                    $ejecutarInsert = false;
                }
                else
                {
                    if(!in_array($cartera, array("PREXCAN4", "PREXCAN5", "PREXCAN6", "PREXCAN7", "No activo")))
                    {
                        $filasError[$fila]['CARTERA'] = "LA CARTERA SOLO ADMITE LOS SIGUIENTES VALORES: [PREXCAN4, PREXCAN5, PREXCAN6, PREXCAN7, No activo]";
                        $ejecutarInsert = false;
                    }
                }
                
                //Validamos Nombre
                if($nombre == null || $nombre == '')
                {
                    $filasError[$fila]['NOMBRE'] = "EL NOMBRE ES OBLIGATORIO.";
                    $ejecutarInsert = false;
                }
                
                //Validamos NIF
                if($nif == '' || $nif == null)
                {
                    $filasError[$fila]['NIF'] = "EL NIF ES OBLIGATORIO.";
                    $ejecutarInsert = false;
                }
                
                //Validamos descuento
                if($descuento == '' || $descuento == null)
                {
                    $filasError[$fila]['DESCUENTO'] = "EL % DESCUENTO ES OBLIGATORIO.";
                    $ejecutarInsert = false;
                }
                else
                {
                    if(!is_numeric($descuento))
                    {
                        $filasError[$fila]['DESCUENTO'] = "EL % DESCUENTO INGRESADO NO ES UN NÚMERO.";
                        $ejecutarInsert = false;
                    }
                    else
                    {
                        if($descuento < 0 && $descuento > 1)
                        {
                            $filasError[$fila]['DESCUENTO'] = "EL % DESCUENTO SOLO ADMITE VALORES ENTRE 0 Y 1.";
                            $ejecutarInsert = false;
                        }
                    }
                }

                
                //Validamos DEUDA VENCIDA
                if($deudaVencida == '' || $deudaVencida == null)
                {
                    $filasError[$fila]['DEUDA VENCIDA'] = "LA DEUDA VENCIDA ES OBLIGATORIA.";
                    $ejecutarInsert = false;
                }
                else
                {
                    if(!is_numeric($deudaVencida))
                    {
                        $filasError[$fila]['DEUDA VENCIDA'] = "LA DEUDA VENCIDA INGRESADA NO ES UN NÚMERO.";
                        $ejecutarInsert = false;
                    }
                    
                }
            }
        }

        fclose($handle);

        if(!$ejecutarInsert)
        {
            $raiz = $this->items['basePublic'].'/';
            $nombre = 'error.txt';
            $file = $this->items['basePublic'].'/error.txt';
            
            if (file_exists($file)) {
                unlink($file);
            }
            
            $txt= fopen($file, 'a') or die ('Problemas al crear el archivo');
            #  Se establecen los datos que va a conterner el archivo
            foreach($filasError as $key=>$value)
            {
                fwrite($txt, "FILA: ".$key."\n");
                foreach($value as $celda=>$error)
                {
                    fwrite($txt, $celda.": ".$error."\n");
                }
            }
            #  Se hace el ciere para no sobre escribir datos 
            fclose($txt);

            $message = sprintf($this->mensajeError->msg201, "Se detectaron diversas inconsistencias.");
            $salida1 = $this->alertas->alertaError($message);
            $salida2 = $this->alertas->descargaArchivoTXT($nombre);
			echo $salida1.$salida2;
			//echo $salida1;
            
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y EJECUTAR INSERTS
        * ----------------------------
        */
            
        //Declaramos variables
        $arrayMatriz = array();
        $filainsert = 0;
        //Abrimos el archivo
        $handleInsert = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handleInsert, 0, $separadorCSV)) !== FALSE)
        {
            $filainsert++;
            
            if($filainsert > 1)
            {
                $data = array_map("utf8_encode", $data);
                //Asignamos valores de CSV a variables locales
                $contrato       = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $cartera        = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                $nombre         = trim($data[2]," \t\n\r\0\x0B\xc2\xa0");
                $nif            = trim($data[3]," \t\n\r\0\x0B\xc2\xa0");
                $descuento      = trim($data[4]," \t\n\r\0\x0B\xc2\xa0");
                $deudaVencida   = trim($data[5]," \t\n\r\0\x0B\xc2\xa0");
                
                //Armar array de Matriz y agregarlo a un array para insertarlo por batch:
                $arrayMatriz[] = array (
                    'NroContrato'       => $contrato, 
                    'NombreCliente'     => $nombre, 
                    'NIF'               => $nif,
                    'Cartera'           => $cartera,
                    'Descuento'         => $descuento,  
                    'DeudaVencida'      => $deudaVencida,
                    'UsuarioRegistra'   => $this->items['id'],
                    'FechaRegistra'     => $fechaActual,    
                    'Localhost'         => $this->request->getIPAddress()
                );

            }
        }

        fclose($handleInsert);
        
        //VALIDAR SI HAY DATOS EN LA MATRIZ CREADA
        if(empty($arrayMatriz))
        {
            $message = sprintf($this->mensajeError->msg201, "<li>No se pudo encontrar registros en el archivo enviado. No se hizo ningún cambio.</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        //REALIZAR LOS INSERT BATCH DENTRO DE UN TRANSACT PARA QUE SE SUBAN TODOS CON ÉXITO
        try 
        {
            //INICIO DE TRANSACCIÓN
            $this->db->transBegin();
            
            //HACEMOS UN TRUNCATE PARA ELIMINAR TODA LA DATA EXISTENTE PREVIAMENTE
            $this->matrizCondonacionCobranza->truncate();
            
            //AGRUPAMOS DE 1000 EN 1000 PARA NO SATURAR LA BASE DE DATOS
            $batchSize = 1000;
            $chunks = array_chunk($arrayMatriz, $batchSize);
            
            //INSERTAMOS BASE DE DATOS EN UN FOREACH DE LOS CHUNKS
            foreach ($chunks as $chunk) 
            {
                $this->matrizCondonacionCobranza->insertBatch($chunk);
            }
            
            //COMPLETAMOS TRANSACT
            $this->db->transComplete();
            
            //VALIDACIÓN DE QUERYS
            if ($this->db->transStatus() === false) 
            {
                // Algo falló en los queries, pero no se lanzó excepción automáticamente
                // Asigna el error en "Throw" para que sea detectado por el catch y dispare el error
                throw new DatabaseException('Error en la transacción');
            }
            
            $message = sprintf($this->mensajeError->msg201, "La Matriz de Condonación fue registrada con éxito");
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        } 
        catch (\Throwable $e) 
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Error en la transacción. No se pudo registrar la solicitud. Inténtelo luego</li><br><li>".$e."</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
        }

    }
	
	public function obtenerDatosMatrizCondonacionCobranza()
	{
	    if (isset($this->items['id'])) 
    	{
            /*
            * ----------------------
            * OBTIENE Y VALIDA DATOS
            * ----------------------
            */
            
    		$nroContrato = $this->request->getPost('nroContrato');
    		
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($nroContrato, 'required|trim', 'Nro Contrato');
    
    		if ($error != '') 
    		{
    			$message = sprintf($this->mensajeError->msg201, $error);
    			
    			$resultado = array(
    				'error' => 1,
    				'msg'   => $message
    			);
    			
    			echo json_encode($resultado, JSON_NUMERIC_CHECK);
    			
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$dataMatriz = $this->matrizCondonacionCobranza->where("NroContrato", $nroContrato)->first();
    
    		if(!empty($dataMatriz))
    		{
    			$resultado = array(
    				'nrocontrato'   => (string) $nroContrato,
    				'cliente'       => (string) $dataMatriz['NombreCliente'],
    				'nif'           => (string) $dataMatriz['NIF'],
    				'cartera'       => (string) $dataMatriz['Cartera'],
    				'descuento'     => (string) ($dataMatriz['Descuento']*100),
    				'deuda'         => (string) $dataMatriz['DeudaVencida']
    			);
    		} 
    		else 
    		{
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}

            /*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
            echo json_encode($resultado, JSON_NUMERIC_CHECK);
    	} 
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado, JSON_NUMERIC_CHECK);
        }
	}
	
	/**************************************************************************/
	
    /************************* FORMATOS DE APROBACIÓN *************************/
    
}