<?php

namespace App\Controllers;

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;

class Condonaciones extends BaseController
{
	public function __construct()
	{
		$this->db = \Config\Database::connect();
		
		$this->usuarios         = new \App\Models\UsuarioModel();
		
		$this->estructuraSubareas   = new \App\Models\EstructuraSubareaModel();
		
		$this->condonaciones                    = new \App\Models\CondonacionesModel();
		$this->condonacionesBitacora            = new \App\Models\CondonacionesBitacoraModel();
		$this->condonacionesAdjuntos            = new \App\Models\CondonacionesAdjuntosModel();
		$this->condonacionesFacturas            = new \App\Models\CondonacionesFacturasModel();
		$this->condonacionesFacturasAprobadores = new \App\Models\CondonacionesFacturasAprobacionModel();
		
		$this->condonacionesCobranzas           = new \App\Models\CondonacionesCobranzasModel();
		$this->condonacionesCobranzasAprobadores= new \App\Models\CondonacionesCobranzasAprobacionModel();
		$this->condonacionesCobranzasBitacora   = new \App\Models\CondonacionesCobranzaBitacoraModel();
		
		$this->correoStatusCondonacion          = new \App\Models\CorreoStatusCondonacionesModel();
		$this->correoStatusCondonacionCobranzas = new \App\Models\CorreoStatusCondonacionesCobranzaModel();
	}

    /****************************** CONDONACIONES *****************************/
    
    public function listarCondonaciones()
    {
        if(isset($this->items['id']))
        {
            $solicitante = $this->usuarios->buscarUsuario($this->items['id']);
            
            if($this->items['idPerfil'] == 12 || $this->items['idPerfil'] == 11)
            {
                $data = array (
    				'session'                   => 'on',
    				'titulo'                    => 'Condonaciones - Cobranzas | Verisure',
    				'breadcrumb'                => $this->items['modulo'],
    				'breadcrumb_alias'          => 'Condonaciones',
    				'elementoSeleccionadoModulo'=> "Listado de Solicitudes",
    				'subtitulo'                 => 'Condonaciones',
    				'usuarioSolicitante'        => $solicitante
    			);
    			
    			$data = array_merge($data, $this->items);
    			
    			return view('procesos/Condonaciones/listar_condonaciones_cobranza',$data);
    			
    // 			return view('procesos/Condonaciones/gestion_facturas_condonacion',$data);			
            }
            else
            {
    			$data = array (
    				'session'                   => 'on',
    				'titulo'                    => 'Condonaciones | Verisure',
    				'breadcrumb'                => $this->items['modulo'],
    				'breadcrumb_alias'          => 'Condonaciones',
    				'elementoSeleccionadoModulo'=> "Listado de Condonaciones",
    				'subtitulo'                 => 'Condonaciones',
    				'usuarioSolicitante'        => $solicitante
    			);
    			
    			$data = array_merge($data, $this->items);
    			
    			return view('procesos/Condonaciones/listar_condonaciones',$data);			
            }
		} 
		else 
		{
			return view('errors/500');
		}
    }
    
    public function condonacionesServerside()
    {
        if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id']
            );
            
            /* LISTAR CONDONACIONES */
            $dataServerside = $this->condonaciones->listaGeneralCondonaciones($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
    // 			if(in_array("ESTCAR", $this->items['permisos']))
    // 			{
    //     			$dataServerside["data"][$key]['EstadoCargo'] = '<button class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0 cambiar-estado-cargo" data-estado="'.$value['Estado'].'" data-id="'.$value['IDCargo'].'">'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</button>';
    // 			}
    // 			else
    // 			{
    // 			    $dataServerside["data"][$key]['EstadoCargo'] = '<span class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0" >'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</span>';
    // 			}
    			
    			$dataServerside["data"][$key]['EstadoCondonacion'] = "";
    			
                $dataServerside["data"][$key]['FechaRegistro'] = date("d-m-Y", strtotime($value['FechaCrea'])).'<br>'.date("H:m:s", strtotime($value['FechaCrea']));
                $dataServerside["data"][$key]['NombreGestor'] = ucwords(mb_strtolower($value['Nombres'].' '.$value['Apellidos']));
                $dataServerside["data"][$key]['Importe'] = "S/ ";
                
                $acciones = '';
                
                $acciones .= "<a href='".$this->items['baseUrl']."/facturas-condonacion/".$value['IDCondonacion']."' target='_blank' class='badge bg-sistema border-0 p-2 mx-1' data-tooltip='tooltip' data-toggle='tooltip' data-placement='top' title='Ver Facturas a Condonar' aria-label='Ver Facturas a Condonar'>
                    <i class='mdi mdi-currency-usd align-bottom' style='font-size: 20px; color: #FFF;'></i>
                </a>";
    //             $acciones .= '<button class="badge bg-info border-0 p-2 mx-1 datos-cargo" data-bs-target="#informacionCargo" data-form="#formInformacionCargo" data-id="'.$value['IDCargo'].'" data-accion="ver" id="ver-cargo" data-tooltip="tooltip" title="Ver Cargo">
    // 				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
    // 			</button>';
    			
    // 			if(in_array("UPDCAR", $this->items['permisos']))
    // 			{
    // 			$acciones .= '<button class="badge bg-warning border-0 p-2 mx-1 datos-cargo" data-bs-target="#informacionCargo" data-form="#formInformacionCargo" data-id="'.$value['IDCargo'].'" data-accion="editar" id="editar-cargo" data-tooltip="tooltip" title="Editar Cargo">
    // 				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
    // 			</button>';
    // 			}
    			
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    }
    
//     public function registrarCondonacion()
//     {
//         $fechaActual = date("Y-m-d H:i:s");
        
//         $error = '';
        
//         // var_dump($this->request->getPost());
//         // var_dump($this->request->getFiles());
//         // exit;
        
//         /*
//         * ----------------------------
//         * DATOS DE AJAX PRE PROCESADOS
//         * ----------------------------
//         */
        
//         //Información de Condonación
        
//         $motivoRequerimiento    = $this->request->getPost('txtMotivoRequerimiento_rcond');
//         $observaciones          = $this->request->getPost('txtObservaciones_rcond');
//         $adjuntoRequerido       = $this->request->getPost('txtAdjuntoRequeridoMotivo');
        
//         $adjuntoMotivo          = $this->request->getFile("itemsAdjunto"); 
        
//         $tabFacturas            = $this->request->getPost('tabFacturas');
        
//         /*
//         * ----------------------------
//         * VALIDACIÓN DE REQUERIMIENTOS
//         * ----------------------------
//         */
        
//         $error .= $this->complementos->validaCampo($motivoRequerimiento, 'required|trim|numeric', 'Motivo del Requerimiento');
        
//         if($adjuntoRequerido == "Y")
//         {
//             if(empty($adjuntoMotivo))
//     	    {
//     	        $error .= "<li>No hay archivo adjunto que justifique la condonación. Por favor, adjuntar lo requerido. [CAMPO] <small>ARCHIVO ADJUNTO</small></li>";
//     	    }
    	    
//     	    if (!($adjuntoMotivo->isValid() && !$adjuntoMotivo->hasMoved())) 
//             {
//                 $error .= "<li>No se encontró archivo adjunto válido para la condonación. [CAMPO] <small>ARCHIVO ADJUNTO</small></li>";
//             }
            
//         }
        
//         if($tabFacturas == "#navFacturasIndividual")
//         {
//             //Información de Facturas de Condonación Individual
            
//             $registrosFactura   = $this->request->getPost('aleatorio');
//             $nroContrato        = $this->request->getPost('nrocontrato');
//             $facturaInterna     = $this->request->getPost('facturainterna');
//             $facturaExterna     = $this->request->getPost('facturaexterna');
//             $segmento           = $this->request->getPost('segmento');
//             $importe            = $this->request->getPost('importe');
//             $deudaTotal         = $this->request->getPost('deudatotal');
//             $tipoFactura        = $this->request->getPost('tipofactura');
            
//             if(empty($registrosFactura))
//             {
//                 $error .= "<li>Debe registrar las facturas a condonar.</li>";
//             }
            
//         }
//         else if($tabFacturas == "#navFacturasMasivo")
//         {
//             $adjuntoFacturas    = $this->request->getFile("itemsFileCSV");
            
//             if(empty($adjuntoFacturas))
//     	    {
//     	        $error .= "<li>No hay plantilla CSV para importar facturas de forma masiva. Por favor, adjuntar la plantilla correspondiente. [CAMPO] <small>PLANTILLA CSV MASIVA</small></li>";
//     	    }
//     	    else
//     	    {
//     	        $validacionCSV = $this->validacionCSVimport($adjuntoFacturas, "itemsFileCSV", "7");
    	        
//     	        if($validacionCSV['error'] != "")
//     	        {
//     	            $error .= "<li>".$validacionCSV['error']."</li>";
//     	        }
//     	    }
//         }
//         else
//         {
//             $error .= "<li>No se encontró una opción válida para subir facturas. Actualice la página e inténtelo nuevamente.</li>";
//         }
        
//         if ($error != '') {
//             $message = sprintf($this->mensajeError->msg201, $error);
//             echo $this->alertas->alertaError($message);
//             EXIT;
//         }
        
//         /*
//         * ----------------------------
//         * VALIDACIÓN DE EXISTENCIA
//         * ----------------------------
//         */

//         $msgExistencia = '';
        
//         if($tabFacturas == "#navFacturasIndividual")
//         {
//             //Información de Facturas de Condonación Individual
//             foreach($registrosFactura as $registro)
//             {
//                 $existenciaFactInt = $this->condonacionesFacturas->where("FacturaInterna", $facturaInterna[$registro])->findAll();
//                 $existenciaFactExt = $this->condonacionesFacturas->where("FacturaExterna", $facturaExterna[$registro])->findAll();
                
//                 if(!empty($existenciaFactInt))
//                 {
//                     $msgExistencia .= "<li>La Factura Interna ".$facturaInterna[$registro]." ya registró una condonación previamente.</li>";
//                 }
                
//                 if(!empty($existenciaFactExt))
//                 {
//                     $msgExistencia .= "<li>La Factura Externa ".$facturaExterna[$registro]." ya registró una condonación previamente.</li>";
//                 }
                
//             }
//         }
//         else if($tabFacturas == "#navFacturasMasivo")
//         {
//             $arrayFactInternas = array();
//             $arrayFactExternas = array();
//             $fila = 0;
            
//             $handle = fopen($adjuntoFacturas, "r");

//             //Recorremos las filas del CSV
//             while (($data = fgetcsv($handle, 0, $validacionCSV['separador'])) !== FALSE)
//             {
//                 $fila++;
    
//                 if($fila>1)
//                 {
//                     $data = array_map("utf8_encode", $data);
//                     //Asignamos valores de CSV a variables locales
                    
//     				$factInterna    = trim($data[1]," \t\n\r\0\x0B\xc2\xa0"); 
//     				$factExterna    = trim($data[2]," \t\n\r\0\x0B\xc2\xa0"); 
    				
//     				$arrayFactInternas[] = $factInterna;
//     				$arrayFactExternas[] = $factExterna;
//                 }
//             } 
    
//             fclose($handle);
        
//             $existenciaFactInt = $this->condonacionesFacturas->whereIn("FacturaInterna", $arrayFactInternas)->findAll();
//             $existenciaFactExt = $this->condonacionesFacturas->whereIn("FacturaExterna", $arrayFactExternas)->findAll();
            
//             if(!empty($existenciaFactInt))
//             {
//                 $msgExistencia .= "<li>La(s) Factura(s) Interna(s) `".(implode("`, `", array_column($existenciaFactInt, 'FacturaInterna')))."` ya fue(ron) registrada(s) previamente en una condonación.</li>";
//             }
            
//             if(!empty($existenciaFactExt))
//             {
//                 $msgExistencia .= "<li>La(s) Factura(s) Externa(s) `".(implode("`, `", array_column($existenciaFactExt, 'FacturaExterna')))."` ya fue(ron) registrada(s) previamente en una condonación.</li>";
//             }
            
//         }
        
//         if($msgExistencia != '')
//         {
//             $message = sprintf($this->mensajeError->msg201, $msgExistencia);
//             echo $this->alertas->alertaPeligro($message);
//             EXIT;
//         }
        
//         /*
//         * ----------------------------
//         * INSERTAR CONDONACIÓN
//         * ----------------------------
//         */

//         $data = array (
//             'IDMotivo'              => $motivoRequerimiento,
//             'Observacion'           => $observaciones,
//             'UsuarioCrea'           => $this->items['id'],
//             'IDDireccionCrea'       => $this->items['dpto'],
//             'IDAreaCrea'            => $this->items['idArea'],
//             'IDSubareaCrea'         => $this->items['idSubarea'],
//             'IDDelegacionCrea'      => $this->items['idDelegacionLog'],
//             'IDCargoCrea'           => $this->items['idCargoLog'],
//             'FechaCrea'             => $fechaActual,    
//             'Localhost'             => $this->request->getIPAddress(),
//             'UsuarioEstado'         => $this->items['id'],
//             'FechaEstado'           => $fechaActual,    
//             'MotivoEstado'          => $observaciones == '' ? "Solicitud de Condonación" : $observaciones,    
//             'Estado'                => 'CREA'
//         );

//         $lastId = $this->condonaciones->insert($data, TRUE);

// 		if($lastId !== FALSE)
// 		{
//             /*
//             * ----------------------------
//             * INSERTAR FACTURAS
//             * ----------------------------
//             */
            
//             // $arrayAprobadores = array();
            
//             // $informacionSubarea     = $this->estructuraSubareas->obtenerSubarea($this->items['idSubarea']);
//             // $informacionFinanzas    = $this->estructuraSubareas->obtenerSubarea(3);
            
//             // $responsableDireccion           = $this->usuarios->buscarUsuario($informacionSubarea['Responsable_Direccion']);
//             // $responsableArea                = $this->usuarios->buscarUsuario($informacionSubarea['Responsable_Area']);
//             // $responsableDireccionFinanzas   = $this->usuarios->buscarUsuario($informacionFinanzas['Responsable_Direccion']);
            
//             if($tabFacturas == "#navFacturasIndividual")
//             {
//                 $dataFacturas = array();
            
//                 foreach($registrosFactura as $registro)
//                 {
//                     $dataFacturas[] = array (
//                         'IDCondonacion'     => $lastId,
//                         'NroContrato'       => $nroContrato[$registro],
//                         'FacturaInterna'    => $facturaInterna[$registro],
//                         'FacturaExterna'    => $facturaExterna[$registro],
//                         'Segmento'          => $segmento[$registro],
//                         'ImporteCondonar'   => $importe[$registro],
//                         'DeudaTotal'        => $deudaTotal[$registro],
//                         'TipoFactura'       => $tipoFactura[$registro],
//                         'UsuarioCrea'       => $this->items['id'],
//                         'FechaCrea'         => $fechaActual,    
//                         'Localhost'         => $this->request->getIPAddress(),
//                         'UsuarioEstado'     => $this->items['id'],
//                         'FechaEstado'       => $fechaActual,    
//                         'MotivoEstado'      => "Registro de factura a condonar.",    
//                         'Estado'            => 'CREA'
//                     );
    
//                 }
                
//                 $lastIdFacturas = $this->condonacionesFacturas->insertBatch($dataFacturas);
                
//                 if($lastIdFacturas === FALSE)
//                 {
//         			$this->condonaciones->where('IDCondonacion', $lastId)->delete();
//                     $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar la solicitud. Inténtelo luego.[REGFACI]</li>");
//                     echo $this->alertas->alertaError($message);
//                     EXIT;
//                 }
//             }
//             else if($tabFacturas == "#navFacturasMasivo")
//             {
//                 $filainsert = 0;
//                 $dataFacturas = array();
                
//                 $handleItems = fopen($adjuntoFacturas, "r"); 

//                 while (($data = fgetcsv($handleItems, 0, $validacionCSV['separador'])) !== FALSE)
//                 { 
//                     $data = array_map("utf8_encode", $data);
                    
//                     $filainsert++;
                    
//                     if($filainsert > 1)
//                     {
//         				$nroContrato    = trim($data[0]," \t\n\r\0\x0B\xc2\xa0"); 
//         				$facturaInterna = trim($data[1]," \t\n\r\0\x0B\xc2\xa0"); 
//         				$facturaExterna = trim($data[2]," \t\n\r\0\x0B\xc2\xa0"); 
//         				$segmento       = trim($data[3]," \t\n\r\0\x0B\xc2\xa0"); 
//         				$importe        = trim($data[4]," \t\n\r\0\x0B\xc2\xa0"); 
//         				$tipoFactura    = trim($data[5]," \t\n\r\0\x0B\xc2\xa0"); 
//         				$mesCampana     = trim($data[6]," \t\n\r\0\x0B\xc2\xa0");
        				
//                         $dataFacturas[] = array(
//                             "IDCondonacion" => $lastId,
//                             "NroContrato"   => $nroContrato,
//                             "FacturaInterna"=> $facturaInterna,
//                             "FacturaExterna"=> $facturaExterna,
//                             "Segmento"      => $segmento,
//                             "ImporteCondonar"   => $importe,
//                             "TipoFactura"   => $tipoFactura,
//                             'DeudaTotal'        => 0,
//                             "UsuarioCrea"   => $this->items['id'],
//                             "FechaCrea"     => $fechaActual,
//                             "Localhost"     => $this->request->getIPAddress(),
//                             "Estado"        => "CREA",
//                             "UsuarioEstado" => $this->items['id'],
//                             "FechaEstado"   => $fechaActual,
//                             "MotivoEstado"  => "Registro de factura para condonar."
//                         );
                        
//         			}
        			
//         		}
        		
//         		fclose($handleItems);
        
//                 $lastIdFacturas = $this->condonacionesFacturas->insertBatch($dataFacturas);
                
//                 if($lastIdFacturas === FALSE)
//                 {
//         			$this->condonaciones->where('IDCondonacion', $lastId)->delete();
//                     $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar la solicitud. Inténtelo luego.[REGFACM]</li>");
//                     echo $this->alertas->alertaError($message);
//                     EXIT;
//                 }
//             }
            
//             /*
//             * ----------------------------
//             * INSERTAR ADJUNTOS SI ES REQUERIDO
//             * ----------------------------
//             */
            
//             if($adjuntoRequerido == "Y")
//             {
//                 if ($adjuntoMotivo->isValid() && ! $adjuntoMotivo->hasMoved()) 
//                 {
//                     if($adjuntoMotivo->getClientExtension() != null)
//                     {
//                         $extAdjunto = strtolower($adjuntoMotivo->getClientExtension());
//                     }
//                     else if($adjuntoMotivo->guessExtension() != null)
//                     {
//                         $extAdjunto = strtolower($adjuntoMotivo->guessExtension());
//                     }
//                     else
//                     {
//                         $extAdjunto = strtolower(pathinfo($adjuntoMotivo->getClientName(), PATHINFO_EXTENSION));
//                     }
        
//                     $nombreAdjunto = pathinfo($adjuntoMotivo->getClientName(), PATHINFO_FILENAME);
                    
//                     /*
//                     * ----------------------------
//                     * GUARDAR ARCHIVO ADJUNTO
//                     * ----------------------------
//                     */
                    
//                     $dataAdjunto = array (
//                         'IDCondonacion'         => $lastId, 
//                         'Nombre'                => $nombreAdjunto,
//                         'Extension'             => $extAdjunto,
//                         'Token'                 => $this->complementos->generar_string_aleatorio(5),
//                         'UsuarioCrea'           => $this->items['id'],
//                         'FechaCrea'             => $fechaActual,
//                         'Localhost'             => $this->request->getIPAddress()
//                     );
                    
//                     $lastIdAdjunto = $this->condonacionesAdjuntos->insert($dataAdjunto, TRUE);
                    
//                     if($lastIdAdjunto !== FALSE)
//                     {
//                         /*
//                         * ----------------------------
//                         * GUARDAR ARCHIVO ADJUNTO
//                         * ----------------------------
//                         */
                        
//                         $ruta = $this->items['basePublic']."/files/Condonaciones/".date("Y", strtotime($fechaActual))."/".date("m", strtotime($fechaActual))."/".$lastId."/Adjuntos/";
                        
//                         if(!file_exists($ruta))
//                         {
//                             @mkdir($ruta, 0777, true);
//                         }
                
//                 		# si exsite la carpeta o se ha creado
//                 		if (file_exists($ruta) || @mkdir($ruta)) 
//                         {
//                             $nuevonombre =  $lastId.'-'.$lastIdAdjunto.'.'.$extAdjunto;
                            
//                             $estadoMove = $adjuntoMotivo->move($ruta, $nuevonombre);
                            
//                             if (!$estadoMove) 
//                             {    
//                                 $this->condonacionesAdjuntos->delete(["IDAdjuntoCondonacion", $lastIdAdjunto]);
//                                 $this->condonacionesFacturas->delete(["IDCondonacion", $lastId]);
//                                 $this->condonaciones->delete(["IDCondonacion", $lastId]);
                                
//                                 $message = sprintf($this->mensajeError->msg201, "<li>No se pudo registrar la solicitud. Inténtelo luego[REGADJ01]</li>");
//                                 echo $this->alertas->alertaError($message);
//                                 EXIT;
//                             }
//                         }
//                         else
//                         {
//                             $this->condonacionesAdjuntos->delete(["IDAdjuntoCondonacion", $lastIdAdjunto]);
//                             $this->condonacionesFacturas->delete(["IDCondonacion", $lastId]);
//                             $this->condonaciones->delete(["IDCondonacion", $lastId]);
                            
//                             $message = sprintf($this->mensajeError->msg201, "<li>No se pudo registrar la solicitud. Inténtelo luego[REGADJ02]</li>");
//                             echo $this->alertas->alertaError($message);
//                             EXIT;
//                         }
//                     }
//                     else
//                     {
//                         $this->condonaciones->delete(["IDCondonacion", $lastId]);
//                         $this->condonacionesFacturas->delete(["IDCondonacion", $lastId]);
                        
//                         $message = sprintf($this->mensajeError->msg201, "<li>No se pudo registrar la solicitud. Inténtelo luego[REGADJ03]</li>");
//                         echo $this->alertas->alertaError($message);
//                         EXIT;
//                     }
//                 }
//             }
            
//             $message = sprintf($this->mensajeError->msg201, "La solicitud fue registrada con éxito");
// 			echo $this->alertas->alertaExito($message);
// 			echo $this->alertas->refrescar(1);
// 		}
//     }
    
    public function registrarCondonacion()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        $error = '';
        
        // var_dump($this->request->getPost());
        // var_dump($this->request->getFiles());
        // exit;
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        //Información de Condonación
        
        $motivoRequerimiento    = $this->request->getPost('txtMotivoRequerimiento_rcond');
        $observaciones          = $this->request->getPost('txtObservaciones_rcond');
        $adjuntoRequerido       = $this->request->getPost('txtAdjuntoRequeridoMotivo');
        
        $adjuntoMotivo          = $this->request->getFile("itemsAdjunto"); 
        
        $tabFacturas            = $this->request->getPost('tabFacturas');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error .= $this->complementos->validaCampo($motivoRequerimiento, 'required|trim|numeric', 'Motivo del Requerimiento');
        
        if($adjuntoRequerido == "Y")
        {
            if(empty($adjuntoMotivo))
    	    {
    	        $error .= "<li>No hay archivo adjunto que justifique la condonación. Por favor, adjuntar lo requerido. [CAMPO] <small>ARCHIVO ADJUNTO</small></li>";
    	    }
    	    
    	    if (!($adjuntoMotivo->isValid() && !$adjuntoMotivo->hasMoved())) 
            {
                $error .= "<li>No se encontró archivo adjunto válido para la condonación. [CAMPO] <small>ARCHIVO ADJUNTO</small></li>";
            }
            
        }
        
        if($tabFacturas == "#navFacturasIndividual")
        {
            //Información de Facturas de Condonación Individual
            
            $registrosFactura   = $this->request->getPost('aleatorio');
            $nroContrato        = $this->request->getPost('nrocontrato');
            $facturaInterna     = $this->request->getPost('facturainterna');
            $facturaExterna     = $this->request->getPost('facturaexterna');
            $segmento           = $this->request->getPost('segmento');
            $importe            = $this->request->getPost('importe');
            $deudaTotal         = $this->request->getPost('deudatotal');
            $tipoFactura        = $this->request->getPost('tipofactura');
            
            if(empty($registrosFactura))
            {
                $error .= "<li>Debe registrar las facturas a condonar.</li>";
            }
            
        }
        else if($tabFacturas == "#navFacturasMasivo")
        {
            $adjuntoFacturas    = $this->request->getFile("itemsFileCSV");
            
            if(empty($adjuntoFacturas))
    	    {
    	        $error .= "<li>No hay plantilla CSV para importar facturas de forma masiva. Por favor, adjuntar la plantilla correspondiente. [CAMPO] <small>PLANTILLA CSV MASIVA</small></li>";
    	    }
    	    else
    	    {
    	        $validacionCSV = $this->validacionCSVimport($adjuntoFacturas, "itemsFileCSV", "7");
    	        
    	        if($validacionCSV['error'] != "")
    	        {
    	            $error .= "<li>".$validacionCSV['error']."</li>";
    	        }
    	    }
        }
        else
        {
            $error .= "<li>No se encontró una opción válida para subir facturas. Actualice la página e inténtelo nuevamente.</li>";
        }
        
        //OBTENER INFORMACIÓN DE RESPONSABLES DE DIRECCIÓN/ÁREA PARA LOS APROBADORES DE FACTURAS
        $informacionSubarea     = $this->estructuraSubareas->obtenerSubarea($this->items['idSubarea']);
        $informacionFinanzas    = $this->estructuraSubareas->obtenerSubarea(3);
            
        if(empty($informacionSubarea) || $informacionSubarea['Responsable_Direccion'] == '' || $informacionSubarea['Responsable_Direccion'] == null)
        {
            $error .= "<li>No hay Director responsable asignado en su dirección. Por favor, contactar con Soporte IT para configurarlo.</li>";
        }
        
        if(empty($informacionSubarea) || $informacionSubarea['Responsable_Area'] == '' || $informacionSubarea['Responsable_Area'] == null)
        {
            $error .= "<li>No hay Gerente responsable asignado en su área. Por favor, contactar con Soporte IT para configurarlo.</li>";
        }
        
        if(empty($informacionFinanzas) || $informacionFinanzas['Responsable_Direccion'] == '' || $informacionFinanzas['Responsable_Direccion'] == null)
        {
            $error .= "<li>No hay Director responsable asignado en la dirección de Finanzas. Por favor, contactar con Soporte IT para configurarlo.</li>";
        }
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        if($tabFacturas == "#navFacturasIndividual")
        {
            //Información de Facturas de Condonación Individual
            foreach($registrosFactura as $registro)
            {
                $existenciaFactInt = $this->condonacionesFacturas->where("FacturaInterna", $facturaInterna[$registro])->findAll();
                $existenciaFactExt = $this->condonacionesFacturas->where("FacturaExterna", $facturaExterna[$registro])->findAll();
                
                if(!empty($existenciaFactInt))
                {
                    $msgExistencia .= "<li>La Factura Interna ".$facturaInterna[$registro]." ya registró una condonación previamente.</li>";
                }
                
                if(!empty($existenciaFactExt))
                {
                    $msgExistencia .= "<li>La Factura Externa ".$facturaExterna[$registro]." ya registró una condonación previamente.</li>";
                }
                
            }
        }
        else if($tabFacturas == "#navFacturasMasivo")
        {
            $arrayFactInternas = array();
            $arrayFactExternas = array();
            $fila = 0;
            
            $handle = fopen($adjuntoFacturas, "r");

            //Recorremos las filas del CSV
            while (($data = fgetcsv($handle, 0, $validacionCSV['separador'])) !== FALSE)
            {
                $fila++;
    
                if($fila>1)
                {
                    $data = array_map("utf8_encode", $data);
                    //Asignamos valores de CSV a variables locales
                    
    				$factInterna    = trim($data[1]," \t\n\r\0\x0B\xc2\xa0"); 
    				$factExterna    = trim($data[2]," \t\n\r\0\x0B\xc2\xa0"); 
    				
    				$arrayFactInternas[] = $factInterna;
    				$arrayFactExternas[] = $factExterna;
                }
            } 
    
            fclose($handle);
        
            $existenciaFactInt = $this->condonacionesFacturas->whereIn("FacturaInterna", $arrayFactInternas)->findAll();
            $existenciaFactExt = $this->condonacionesFacturas->whereIn("FacturaExterna", $arrayFactExternas)->findAll();
            
            if(!empty($existenciaFactInt))
            {
                $msgExistencia .= "<li>La(s) Factura(s) Interna(s) `".(implode("`, `", array_column($existenciaFactInt, 'FacturaInterna')))."` ya fue(ron) registrada(s) previamente en una condonación.</li>";
            }
            
            if(!empty($existenciaFactExt))
            {
                $msgExistencia .= "<li>La(s) Factura(s) Externa(s) `".(implode("`, `", array_column($existenciaFactExt, 'FacturaExterna')))."` ya fue(ron) registrada(s) previamente en una condonación.</li>";
            }
            
        }
        
        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * INICIAR TRANSACCIÓN PARA EJECUTAR PROCESOS DE BASE DE DATOS
        * ----------------------------
        */
        
        try 
        {
            $arrayAprobadores = array();
            
            //INICIO DE TRANSACCIÓN
            $this->db->transBegin();
            
            //ARMADO DE VALORES DE CONDONACIÓN
            $data = array (
                'IDMotivo'              => $motivoRequerimiento,
                'Observacion'           => $observaciones,
                'UsuarioCrea'           => $this->items['id'],
                'IDDireccionCrea'       => $this->items['dpto'],
                'IDAreaCrea'            => $this->items['idArea'],
                'IDSubareaCrea'         => $this->items['idSubarea'],
                'IDDelegacionCrea'      => $this->items['idDelegacionLog'],
                'IDCargoCrea'           => $this->items['idCargoLog'],
                'FechaCrea'             => $fechaActual,    
                'Localhost'             => $this->request->getIPAddress(),
                'UsuarioEstado'         => $this->items['id'],
                'FechaEstado'           => $fechaActual,    
                'MotivoEstado'          => $observaciones == '' ? "Solicitud de Condonación" : $observaciones,    
                'Estado'                => 'CREA'
            );
            
            //INSERCIÓN DE CONDONACIÓN
            $idCondonacion = $this->condonaciones->insert($data, TRUE);
            
            //OBTENER INFORMACIÓN DE RESPONSABLES DE DIRECCIÓN/ÁREA PARA LOS APROBADORES DE FACTURAS
            $informacionSubarea     = $this->estructuraSubareas->obtenerSubarea($this->items['idSubarea']);
            $informacionFinanzas    = $this->estructuraSubareas->obtenerSubarea(3);
            
            // $responsableDireccion           = $this->usuarios->buscarUsuario($informacionSubarea['Responsable_Direccion']);
            // $responsableArea                = $this->usuarios->buscarUsuario($informacionSubarea['Responsable_Area']);
            // $responsableDireccionFinanzas   = $this->usuarios->buscarUsuario($informacionFinanzas['Responsable_Direccion']);
            
            $responsableDireccion           = $this->usuarios->buscarUsuario(1891);
            $responsableArea                = $this->usuarios->buscarUsuario(31);
            $responsableDireccionFinanzas   = $this->usuarios->buscarUsuario(3278);
            //VALIDACIÓN SI ES INSERCIÓN INDIVIDUAL O MASIVO
            if($tabFacturas == "#navFacturasIndividual")
            {
                $dataFacturas = array();
                $dataAprobador = array();
            
                foreach($registrosFactura as $registro)
                {
                    //ARMADO DE VALORES DE FACTURA
                    $dataFacturas = array (
                        'IDCondonacion'     => $idCondonacion,
                        'NroContrato'       => $nroContrato[$registro],
                        'FacturaInterna'    => $facturaInterna[$registro],
                        'FacturaExterna'    => $facturaExterna[$registro],
                        'Segmento'          => $segmento[$registro],
                        'ImporteCondonar'   => $importe[$registro],
                        'DeudaTotal'        => $deudaTotal[$registro],
                        'TipoFactura'       => $tipoFactura[$registro],
                        'UsuarioCrea'       => $this->items['id'],
                        'FechaCrea'         => $fechaActual,    
                        'Localhost'         => $this->request->getIPAddress(),
                        'UsuarioEstado'     => $this->items['id'],
                        'FechaEstado'       => $fechaActual,    
                        'MotivoEstado'      => "Registro de factura a condonar.",    
                        'Estado'            => 'PEND'
                    );
                    
                    //INSERCIÓN DE FACTURAS DE CONDONACIÓN
                    $idFactura = $this->condonacionesFacturas->insert($dataFacturas, TRUE);
                    
                    //ARMADO DE VALORES PARA TABLA DE APROBADOR
                    $dataAprobador = array (
                        'IDFactura'                 => $idFactura,
                        'UsuarioCrea'               => $this->items['id'],
                        'FechaCrea'                 => $fechaActual,    
                        'Localhost'                 => $this->request->getIPAddress(),
                        'UsuarioEstado'             => $this->items['id'],
                        'FechaEstado'               => $fechaActual,    
                        'MotivoEstado'              => "Solicitud de aprobación.",    
                        'Estado'                    => 'PEND'
                    );
                    
                    //DECISIÓN DE APROBADOR
                    if($tipoFactura[$registro] == "ND")
                    {
                        if($importe[$registro] > 7000)
                        {
                            $dataAprobador['IDUsuarioAprobacion']       = $informacionSubarea['Responsable_Direccion'];
                            $dataAprobador['IDDireccionAprobacion']     = $responsableDireccion['IDDireccion'];
                            $dataAprobador['IDAreaAprobacion']          = $responsableDireccion['IDArea'];
                            $dataAprobador['IDSubareaAprobacion']       = $responsableDireccion['IDSubarea'];
                            $dataAprobador['IDDelegacionAprobacion']    = $responsableDireccion['IDDelegacion'];
                            $dataAprobador['IDCargoAprobacion']         = $responsableDireccion['IDCargo'];
                            
                            $arrayAprobadores[] = $informacionSubarea['Responsable_Direccion'];
                        }
                        else
                        {
                            $dataAprobador['IDUsuarioAprobacion']       = $informacionSubarea['Responsable_Area'];
                            $dataAprobador['IDDireccionAprobacion']     = $responsableArea['IDDireccion'];
                            $dataAprobador['IDAreaAprobacion']          = $responsableArea['IDArea'];
                            $dataAprobador['IDSubareaAprobacion']       = $responsableArea['IDSubarea'];
                            $dataAprobador['IDDelegacionAprobacion']    = $responsableArea['IDDelegacion'];
                            $dataAprobador['IDCargoAprobacion']         = $responsableArea['IDCargo'];
                            
                            $arrayAprobadores[] = $informacionSubarea['Responsable_Area'];
                        }
                    }
                    else
                    {
                        if($importe[$registro] == $deudaTotal[$registro])
                        {
                            $dataAprobador['IDUsuarioAprobacion']       = $informacionFinanzas['Responsable_Direccion'];
                            $dataAprobador['IDDireccionAprobacion']     = $responsableDireccionFinanzas['IDDireccion'];
                            $dataAprobador['IDAreaAprobacion']          = $responsableDireccionFinanzas['IDArea'];
                            $dataAprobador['IDSubareaAprobacion']       = $responsableDireccionFinanzas['IDSubarea'];
                            $dataAprobador['IDDelegacionAprobacion']    = $responsableDireccionFinanzas['IDDelegacion'];
                            $dataAprobador['IDCargoAprobacion']         = $responsableDireccionFinanzas['IDCargo'];
                            
                            $arrayAprobadores[] = $informacionFinanzas['Responsable_Direccion'];
                        }
                        else
                        {
                            $dataAprobador['IDUsuarioAprobacion']       = $informacionSubarea['Responsable_Area'];
                            $dataAprobador['IDDireccionAprobacion']     = $responsableArea['IDDireccion'];
                            $dataAprobador['IDAreaAprobacion']          = $responsableArea['IDArea'];
                            $dataAprobador['IDSubareaAprobacion']       = $responsableArea['IDSubarea'];
                            $dataAprobador['IDDelegacionAprobacion']    = $responsableArea['IDDelegacion'];
                            $dataAprobador['IDCargoAprobacion']         = $responsableArea['IDCargo'];
                            
                            $arrayAprobadores[] = $informacionSubarea['Responsable_Area'];
                        }
                    }
                    
                    //INSERCIÓN DE APROBADORES DE FACTURAS DE CONDONACIÓN
                    $idAprobador = $this->condonacionesFacturasAprobadores->insert($dataAprobador, TRUE);
                    
                }
            }
            else if($tabFacturas == "#navFacturasMasivo")
            {
                $filainsert = 0;
                $dataFacturas = array();
                $dataAprobador = array();
                
                $handleItems = fopen($adjuntoFacturas, "r"); 

                while (($data = fgetcsv($handleItems, 0, $validacionCSV['separador'])) !== FALSE)
                { 
                    $data = array_map("utf8_encode", $data);
                    
                    $filainsert++;
                    
                    if($filainsert > 1)
                    {
        				$nroContrato    = trim($data[0]," \t\n\r\0\x0B\xc2\xa0"); 
        				$facturaInterna = trim($data[1]," \t\n\r\0\x0B\xc2\xa0"); 
        				$facturaExterna = trim($data[2]," \t\n\r\0\x0B\xc2\xa0"); 
        				$segmento       = trim($data[3]," \t\n\r\0\x0B\xc2\xa0"); 
        				$importe        = trim($data[4]," \t\n\r\0\x0B\xc2\xa0"); 
        				$tipoFactura    = trim($data[5]," \t\n\r\0\x0B\xc2\xa0"); 
        				$mesCampana     = trim($data[6]," \t\n\r\0\x0B\xc2\xa0");
        				
        				//ARMADO DE VALORES DE FACTURA
                        $dataFacturas = array(
                            "IDCondonacion"     => $idCondonacion,
                            "NroContrato"       => $nroContrato,
                            "FacturaInterna"    => $facturaInterna,
                            "FacturaExterna"    => $facturaExterna,
                            "Segmento"          => $segmento,
                            "ImporteCondonar"   => $importe,
                            "TipoFactura"       => $tipoFactura,
                            'DeudaTotal'        => 0,
                            "UsuarioCrea"       => $this->items['id'],
                            "FechaCrea"         => $fechaActual,
                            "Localhost"         => $this->request->getIPAddress(),
                            "Estado"            => "PEND",
                            "UsuarioEstado"     => $this->items['id'],
                            "FechaEstado"       => $fechaActual,
                            "MotivoEstado"      => "Registro de factura para condonar Masivo."
                        );
                        
                        //INSERCIÓN DE FACTURAS DE CONDONACIÓN
                        $idFactura = $this->condonacionesFacturas->insert($dataFacturas, TRUE);
                        
                        //ARMADO DE VALORES PARA TABLA DE APROBADOR
                        $dataAprobador = array (
                            'IDFactura'                 => $idFactura,
                            'UsuarioCrea'               => $this->items['id'],
                            'FechaCrea'                 => $fechaActual,    
                            'Localhost'                 => $this->request->getIPAddress(),
                            'UsuarioEstado'             => $this->items['id'],
                            'FechaEstado'               => $fechaActual,    
                            'MotivoEstado'              => "Solicitud de aprobación.",    
                            'Estado'                    => 'PEND'
                        );
                        
                        //DECISIÓN DE APROBADOR
                        if($tipoFactura[$registro] == "ND")
                        {
                            if($importe[$registro] > 7000)
                            {
                                $dataAprobador['IDUsuarioAprobacion']       = $informacionSubarea['Responsable_Direccion'];
                                $dataAprobador['IDDireccionAprobacion']     = $responsableDireccion['IDDireccion'];
                                $dataAprobador['IDAreaAprobacion']          = $responsableDireccion['IDArea'];
                                $dataAprobador['IDSubareaAprobacion']       = $responsableDireccion['IDSubarea'];
                                $dataAprobador['IDDelegacionAprobacion']    = $responsableDireccion['IDDelegacion'];
                                $dataAprobador['IDCargoAprobacion']         = $responsableDireccion['IDCargo'];
                                
                                $arrayAprobadores[] = $informacionSubarea['Responsable_Direccion'];
                            }
                            else
                            {
                                $dataAprobador['IDUsuarioAprobacion']       = $informacionSubarea['Responsable_Area'];
                                $dataAprobador['IDDireccionAprobacion']     = $responsableArea['IDDireccion'];
                                $dataAprobador['IDAreaAprobacion']          = $responsableArea['IDArea'];
                                $dataAprobador['IDSubareaAprobacion']       = $responsableArea['IDSubarea'];
                                $dataAprobador['IDDelegacionAprobacion']    = $responsableArea['IDDelegacion'];
                                $dataAprobador['IDCargoAprobacion']         = $responsableArea['IDCargo'];
                                
                                $arrayAprobadores[] = $informacionSubarea['Responsable_Area'];
                            }
                        }
                        else
                        {
                            if($importe[$registro] == $deudaTotal[$registro])
                            {
                                $dataAprobador['IDUsuarioAprobacion']       = $informacionFinanzas['Responsable_Direccion'];
                                $dataAprobador['IDDireccionAprobacion']     = $responsableDireccionFinanzas['IDDireccion'];
                                $dataAprobador['IDAreaAprobacion']          = $responsableDireccionFinanzas['IDArea'];
                                $dataAprobador['IDSubareaAprobacion']       = $responsableDireccionFinanzas['IDSubarea'];
                                $dataAprobador['IDDelegacionAprobacion']    = $responsableDireccionFinanzas['IDDelegacion'];
                                $dataAprobador['IDCargoAprobacion']         = $responsableDireccionFinanzas['IDCargo'];
                                
                                $arrayAprobadores[] = $informacionFinanzas['Responsable_Direccion'];
                            }
                            else
                            {
                                $dataAprobador['IDUsuarioAprobacion']       = $informacionSubarea['Responsable_Area'];
                                $dataAprobador['IDDireccionAprobacion']     = $responsableArea['IDDireccion'];
                                $dataAprobador['IDAreaAprobacion']          = $responsableArea['IDArea'];
                                $dataAprobador['IDSubareaAprobacion']       = $responsableArea['IDSubarea'];
                                $dataAprobador['IDDelegacionAprobacion']    = $responsableArea['IDDelegacion'];
                                $dataAprobador['IDCargoAprobacion']         = $responsableArea['IDCargo'];
                                
                                $arrayAprobadores[] = $informacionSubarea['Responsable_Area'];
                            }
                        }
                        
                        //INSERCIÓN DE APROBADORES DE FACTURAS DE CONDONACIÓN
                        $idAprobador = $this->condonacionesFacturasAprobadores->insert($dataAprobador, TRUE);
                        
        			}
        			
        		}
        		
        		fclose($handleItems);
            }
            
            //INSERTAR ADJUNTOS SI ES REQUERIDO
            if($adjuntoRequerido == "Y")
            {
                if ($adjuntoMotivo->isValid() && ! $adjuntoMotivo->hasMoved()) 
                {
                    //OBTENGO LA EXTENSIÓN DEL ADJUNTO A REGISTRAR
                    if($adjuntoMotivo->getClientExtension() != null)
                    {
                        $extAdjunto = strtolower($adjuntoMotivo->getClientExtension());
                    }
                    else if($adjuntoMotivo->guessExtension() != null)
                    {
                        $extAdjunto = strtolower($adjuntoMotivo->guessExtension());
                    }
                    else
                    {
                        $extAdjunto = strtolower(pathinfo($adjuntoMotivo->getClientName(), PATHINFO_EXTENSION));
                    }
                    
                    //OBTENGO EL NOMBRE DEL ADJUNTO A REGISTRAR
                    $nombreAdjunto = pathinfo($adjuntoMotivo->getClientName(), PATHINFO_FILENAME);
                    
                    //ARMADO DE VALORES DEL ADJUNTO A REGISTRAR
                    $dataAdjunto = array (
                        'IDCondonacion'         => $idCondonacion, 
                        'Nombre'                => $nombreAdjunto,
                        'Extension'             => $extAdjunto,
                        'Token'                 => $this->complementos->generar_string_aleatorio(5),
                        'UsuarioCrea'           => $this->items['id'],
                        'FechaCrea'             => $fechaActual,
                        'Localhost'             => $this->request->getIPAddress()
                    );
                    
                    $lastIdAdjunto = $this->condonacionesAdjuntos->insert($dataAdjunto, TRUE);
                    
                    //ASIGNAMOS LA NUEVA RUTA DONDE SE VA A GUARDAR EL ADJUNTO A REGISTRAR
                    $ruta = $this->items['basePublic']."/files/Condonaciones/".date("Y", strtotime($fechaActual))."/".date("m", strtotime($fechaActual))."/".$idCondonacion."/Adjuntos/";
                    
                    //VALIDAR Y CREAR CARPETA SI NO EXISTE
                    if (!is_dir($ruta)) 
                    {
                        if (!mkdir($ruta, 0777, true)) 
                        {
                            // Si no se puede crear la carpeta, cancelar
                            $this->db->transRollback();
                            
                            $message = sprintf($this->mensajeError->msg201, "<li>No se pudo crear el directorio de almacenamiento. Inténtelo luego[ERRALMC]</li>");
                            echo $this->alertas->alertaError($message);
                            EXIT;
                        }
                    }
                    
                    //ASIGNAR EL NUEVO NOMBRE
                    $nuevonombre =  $idCondonacion.'-'.$lastIdAdjunto.'.'.$extAdjunto;
                    
                    //INTENTAR MOVER EL ARCHIVO
                    try 
                    {
                        $adjuntoMotivo->move($ruta, $nuevonombre);
                    } 
                    catch (\Exception $e) 
                    {
                        $this->db->transRollback();
                        
                        $message = sprintf($this->mensajeError->msg201, "<li>Error al guardar el archivo: ".$e->getMessage().". Inténtelo luego[ERRALMC]</li>");
                        echo $this->alertas->alertaError($message);
                        EXIT;
                    }
                    
                }
            }
            
            //ENVIAR CORREO A LOS APROBADORES
            
            $correoCopia = array();
            
            $arrayAprobadores = array_unique($arrayAprobadores);
            
            if(!empty($arrayAprobadores))
            {
                foreach($arrayAprobadores as $aprobador)
                {
                    $nombreAprobador = $aprobador == $informacionSubarea['Responsable_Direccion'] ? ucwords(mb_strtolower($responsableDireccion['Nombres'].' '.$responsableDireccion['Apellidos'])) : ($aprobador == $informacionSubarea['Responsable_Area'] ? ucwords(mb_strtolower($responsableArea['Nombres'].' '.$responsableArea['Apellidos'])) : ucwords(mb_strtolower($responsableDireccionFinanzas['Nombres'].' '.$responsableDireccionFinanzas['Apellidos'])));
                    $correoAprobador = $aprobador == $informacionSubarea['Responsable_Direccion'] ? $responsableDireccion['Correo'] : ($aprobador == $informacionSubarea['Responsable_Area'] ? $responsableArea['Correo'] : $responsableDireccionFinanzas['Correo']);
                    
            		/*
                    * ----------------------------
                    * PREPARACIÓN DE CUERPO DE CORREO
                    * ----------------------------
            		*/
            
                    $arrayCuerpo = array(
                        "TITULO" => "SOLICITUD DE CONDONACIÓN #".$idCondonacion,
                        "BASE_URL"  => base_url(),
                        'basePublic'    => $this->items['basePublic'],
                        'baseDinamic'   => $this->items['baseDinamic'],
                        "MODULO" => "CONDONACIONES",
                        "USUARIO" => $nombreAprobador,
                        "MENSAJE" => "Se creó la siguiente solicitud donde debes aprobar la condonación de las facturas asociadas. Ingresa al sistema Petitracking para poder gestionarlo.",
                        "URL_MODULO" => base_url()."/facturas-condonacion/".$idCondonacion
                    );
            
                    $cuerpo = $this->plantillasCorreo->avisoPetitracking($arrayCuerpo);
                    
            		/*
                    * ----------------------------
                    * PREPARACIÓN DE PARAMETROS PARA EL CORREO
                    * ----------------------------
            		*/
            		
            		$correoCopia[] = $this->items['correoElectronico'];
            		
                    $asunto="APROBADOR ASIGNADO - SOLICITUD DE CONDONACIÓN #".$idCondonacion;
                    
                    $configCorreo = array(
                        "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
                        "CORREO_ORIGEN" => $this->items['correoElectronico'],
                        "CORREOS_DESTINOS" => array($correoAprobador),
                        "CORREOS_COPIA" => $correoCopia,
                        "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe", "joseenrique.nanquen@verisure.pe"),
                        "ASUNTO" => $asunto,
                        "MENSAJE" => $cuerpo
                    );
            
                    $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);
            
                    $dataCorreo = array(
                        "IDCondonacion" => $idCondonacion,
                        "Momento"       => "CREACION",
                        "Response"      => $estadoCorreo['RESPUESTA'],
                        "Error"         => $estadoCorreo['ERROR'],
                        'UsuarioCrea'   => $this->items['id'],
                        'FechaCrea'     => $fechaActual,    
                        'Localhost'     => $this->request->getIPAddress()
                    );
            
                    $this->correoStatusCondonacion->insert($dataCorreo, TRUE);
                }
            }
            
            //VALIDACIÓN DE QUERYS
            if ($this->db->transStatus() === false) 
            {
                // Algo falló en los queries, pero no se lanzó excepción automáticamente
                // Asigna el error en "Throw" para que sea detectado por el catch y dispare el error
                throw new DatabaseException('Error en la transacción');
            }

            $this->db->transCommit();
            
            $message = sprintf($this->mensajeError->msg201, "La solicitud fue registrada con éxito");
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        } 
        catch (\Throwable $e) 
        {
            $this->db->transRollback();
            
            $message = sprintf($this->mensajeError->msg201, "<li>Error en la transacción. No se pudo registrar la solicitud. Inténtelo luego[ERRTRANS]</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        
        
        
        
        
        
        
        
        
        

		
    }
    
    /*------------ COBRANZAS ----------------*/
    
    public function condonacionesCobranzasServerside()
    {
        if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id']
            );
            
            /* LISTAR CONDONACIONES */
            $dataServerside = $this->condonacionesCobranzas->listaGeneralCondonacionesCobranzas($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
                $dataServerside["data"][$key]['FechaRegistro'] = date("d-m-Y", strtotime($value['FechaCrea'])).'<br>'.date("H:m:s", strtotime($value['FechaCrea']));
                $dataServerside["data"][$key]['MontoDeudaVencida'] = "S/ ".$value['DeudaVencida'];
                $dataServerside["data"][$key]['ImporteCondonar'] = "S/ ".$value['ImporteTotalCondonar'];
                $dataServerside["data"][$key]['PorcentajeDescuento'] = ($value['Descuento']*100)."%";
                $dataServerside["data"][$key]['CompromisoPago'] = date("d-m-Y", strtotime($value['FechaCompromisoPago']));
                
                if($value['Estado'] == "APRO")
                {
                    $bgEstado       = "bg-success";
                    $iconEstado     = "mdi mdi-check-circle";
                    $textTooltip    = "Solicitud Aprobada";
                }
                else if($value['Estado'] == "CANC")
                {
                    $bgEstado       = "bg-dark";
                    $iconEstado     = "mdi mdi-cancel";
                    $textTooltip    = "Solicitud Cancelada";
                }
                else if($value['Estado'] == "RECH")
                {
                    $bgEstado       = "bg-danger";
                    $iconEstado     = "mdi mdi-close-circle";
                    $textTooltip    = "Solicitud Rechazada";
                }
                else 
                {
                    $bgEstado       = "bg-gris-claro";
                    $iconEstado     = "mdi mdi-timer-sand";
                    $textTooltip    = "Solicitud Pendiente";
                }
                
                $acciones = '';
                
                $acciones .= "<a href='".$this->items['baseUrl']."/detalle-condonacion-cobranza/".$value['IDSolicitudCobranza']."' target='_blank' class='badge bg-info border-0 p-2 mx-1' data-tooltip='tooltip' data-toggle='tooltip' data-placement='top' title='Ver Detalle de Condonación' aria-label='Ver Detalle de Condonación'>
                    <i class='mdi mdi-eye align-bottom' style='font-size: 20px; color: #FFF;'></i>
                </a>";
                $acciones .= '<button class="badge '.$bgEstado.' border-0 p-2 mx-1" data-tooltip="tooltip" title="'.$textTooltip.'">
    				<i class="'.$iconEstado.' align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    // 			if(in_array("UPDCAR", $this->items['permisos']))
    // 			{
    // 			$acciones .= '<button class="badge bg-warning border-0 p-2 mx-1 datos-cargo" data-bs-target="#informacionCargo" data-form="#formInformacionCargo" data-id="'.$value['IDCargo'].'" data-accion="editar" id="editar-cargo" data-tooltip="tooltip" title="Editar Cargo">
    // 				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
    // 			</button>';
    // 			}
    			
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    }
    
    public function registrarCondonacionCobranza()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        $error = '';
        
        // var_dump($this->request->getPost());
        // var_dump($this->request->getFiles());
        // exit;
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        //Información de Condonación
        
        $nroContrato        = $this->request->getPost('txtNroContrato_rcondcobr');
        $cliente            = $this->request->getPost('txtClienteCondonacionCobranza_rcondcobr');
        $nif                = $this->request->getPost('txtNIFCondonacionCobranza_rcondcobr');
        $cartera            = $this->request->getPost('cboCartera_rcondcobr');
        $maximoDescuento    = $this->request->getPost('txtMaximoPorcentajeCondonarCobranza_rcondcobr');
        $descuento          = $this->request->getPost('txtPorcentajeCondonarCobranza_rcondcobr');
        $deudaVencida       = $this->request->getPost('txtDeudaVencidaCondonacionCobranza_rcondcobr');
        $importeCondonar    = $this->request->getPost('txtImporteCondonarCobranza_rcondcobr');
        $mesCampana         = $this->request->getPost('dtMesCampana_rcondcobr');
        $compromisoPago     = $this->request->getPost('dtCompromisoPago_rcondcobr');
        $observacion        = $this->request->getPost('txtObservaciones_rcond');
        
        $existeMatriz       = $this->request->getPost('txtExisteMatriz_rcondcobr');
        $evaluacionMatriz   = $this->request->getPost('txtEvaluacionMatriz_rcondcobr');
        
        $estadoRegistro     = "APRO";
        $informacionAprobador   = array();
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error .= $this->complementos->validaCampo($nroContrato, 'required|trim|numeric', 'Nro de Contrato');
        $error .= $this->complementos->validaCampo($cliente, 'required|trim', 'Cliente');
        $error .= $this->complementos->validaCampo($nif, 'required|trim|alphaspecial|minlength[1]|maxlength[15]', 'NIF');
        $error .= $this->complementos->validaCampo($cartera, 'required|trim', 'Cartera');
        $error .= $this->complementos->validaCampo($descuento, 'required|trim|decimal', 'Descuento');
        $error .= $this->complementos->validaCampo($deudaVencida, 'required|trim|decimal', 'Deuda Vencida');
        $error .= $this->complementos->validaCampo($importeCondonar, 'required|trim|decimal', 'Importe a Condonar');
        $error .= $this->complementos->validaCampo($mesCampana, 'required|trim', 'Mes de Campaña');
        $error .= $this->complementos->validaCampo($compromisoPago, 'required|trim|dateDos', 'Fecha de Compromiso de Pago');
        $error .= $this->complementos->validaCampo($observacion, 'trim', 'Observación');
        
        //OBTENER INFORMACIÓN DE RESPONSABLES DE DIRECCIÓN/ÁREA PARA LOS APROBADORES
        
        if($existeMatriz !== "EXISTE" || ($existeMatriz === "EXISTE" && $evaluacionMatriz === "FUERA") )
        {
            $estadoRegistro = "PEND";
            
            if($existeMatriz !== "EXISTE" || ($existeMatriz === "EXISTE" && ($maximoDescuento - $descuento <= 10) ))
            {
                // $informacionAprobador   = $this->estructuraSubareas->obtenerSubarea($this->items['idSubarea']);
                $informacionAprobador   = $this->estructuraSubareas->obtenerSubarea(73);
            }
            else
            {
                $informacionAprobador   = $this->estructuraSubareas->obtenerSubarea(3);
            }
            
            if(empty($informacionAprobador) || $informacionAprobador['Responsable_Direccion'] == '' || $informacionAprobador['Responsable_Direccion'] == null)
            {
                $error .= "<li>No hay responsable asignado en ".$informacionAprobador['Direccion'].". Por favor, contactar con Soporte IT para configurarlo.</li>";
            }
            
            if(empty($informacionAprobador) || $informacionAprobador['Responsable_Area'] == '' || $informacionAprobador['Responsable_Area'] == null)
            {
                $error .= "<li>No hay responsable asignado en ".$informacionAprobador['Area'].". Por favor, contactar con Soporte IT para configurarlo.</li>";
            }
        }
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * INICIAR TRANSACCIÓN PARA EJECUTAR PROCESOS DE BASE DE DATOS
        * ----------------------------
        */
        
        try 
        {
            $mesCampanaTexto = "";
            $fechaCampana = $mesCampana.'-01';
            try 
            {
                $fecha = new \DateTime($fechaCampana);
                $mesCampanaTexto = strtolower($fecha->format('M-Y')); // "oct-2025"
            } 
            catch (\Exception $e) 
            {
                // Manejo de error si el formato es inválido
                $mesCampanaTexto = "";
            }
            
            $descuentoPorcentaje = number_format(round(($descuento/100), 2), 2, '.', '');
            
            //INICIO DE TRANSACCIÓN
            $this->db->transBegin();
            
            //ARMADO DE VALORES DE CONDONACIÓN COBRANZA
            $data = array (
                'NroContrato'           => $nroContrato,
                'Cliente'               => $cliente,
                'NIF'                   => $nif,
                'Cartera'               => $cartera,
                'Descuento'             => $descuentoPorcentaje,
                'DeudaVencida'          => $deudaVencida,
                'ImporteTotalCondonar'  => $importeCondonar,
                'MesCampana'            => $mesCampanaTexto,
                'FechaCompromisoPago'   => $compromisoPago,
                'Observacion'           => $observacion,
                'UsuarioCrea'           => $this->items['id'],
                'IDDireccionCrea'       => $this->items['dpto'],
                'IDAreaCrea'            => $this->items['idArea'],
                'IDSubareaCrea'         => $this->items['idSubarea'],
                'IDDelegacionCrea'      => $this->items['idDelegacionLog'],
                'IDCargoCrea'           => $this->items['idCargoLog'],
                'FechaCrea'             => $fechaActual,    
                'Localhost'             => $this->request->getIPAddress(),
                'UsuarioEstado'         => $this->items['id'],
                'FechaEstado'           => $fechaActual,    
                'MotivoEstado'          => $observacion == '' ? "Solicitud de Condonación Cobranza" : $observacion,    
                'Estado'                => $estadoRegistro
            );
            
            //INSERCIÓN DE CONDONACIÓN
            $idCondonacionCobranza = $this->condonacionesCobranzas->insert($data, TRUE);
            // $idCondonacionCobranza= "9999999999999999999";
            //OBTENER INFORMACIÓN DE RESPONSABLES DE DIRECCIÓN/ÁREA PARA LOS APROBADORES DE LA CONDONACIÓN
            if(!empty($informacionAprobador))
            {
                if($existeMatriz !== "EXISTE" || ($existeMatriz === "EXISTE" && ($maximoDescuento - $descuento <= 10) ))
                {
                    // $idUsuarioAprobacion = $informacionAprobador['Responsable_Area'];
                    $idUsuarioAprobacion = 31;
                }
                else
                {
                    // $idUsuarioAprobacion = $informacionAprobador['Responsable_Direccion'];
                    $idUsuarioAprobacion = 1891;
                }
                
                // $responsableAprobacion           = $this->usuarios->buscarUsuario($idUsuarioAprobacion);
                $responsableAprobacion  = $this->usuarios->buscarUsuario($idUsuarioAprobacion);
                
                //INSERCIÓN DE APROBADOR DE CONDONACIÓN COBRANZA
                $dataAprobador = array (
                    'IDSolicitudCobranza'       => $idCondonacionCobranza,
                    'IDUsuarioAprobacion'       => $idUsuarioAprobacion,
                    'IDDireccionAprobacion'     => $responsableAprobacion['IDDireccion'],
                    'IDAreaAprobacion'          => $responsableAprobacion['IDArea'],
                    'IDSubareaAprobacion'       => $responsableAprobacion['IDSubarea'],
                    'IDDelegacionAprobacion'    => $responsableAprobacion['IDDelegacion'],
                    'IDCargoAprobacion'         => $responsableAprobacion['IDCargo'],
                    'UsuarioCrea'               => $this->items['id'],
                    'FechaCrea'                 => $fechaActual,
                    'Localhost'                 => $this->request->getIPAddress(),
                    'UsuarioEstado'             => $this->items['id'],
                    'FechaEstado'               => $fechaActual,
                    'MotivoEstado'              => "Solicitud de aprobación.",
                    'Estado'                    => 'PEND'
                );
                
                $idAprobador = $this->condonacionesCobranzasAprobadores->insert($dataAprobador, TRUE);
                
                //ENVIAR CORREO A LOS APROBADORES
            
                $nombreAprobador = ucwords(mb_strtolower($responsableAprobacion['Nombres'].' '.$responsableAprobacion['Apellidos']));
                $correoAprobador = $responsableAprobacion['Correo'];
                
        		/*
                * ----------------------------
                * PREPARACIÓN DE CUERPO DE CORREO
                * ----------------------------
        		*/
        
                $arrayCuerpo = array(
                    "TITULO" => "SOLICITUD DE CONDONACIÓN DE COBRANZA #".$idCondonacionCobranza,
                    "BASE_URL"  => base_url(),
                    'basePublic'    => $this->items['basePublic'],
                    'baseDinamic'   => $this->items['baseDinamic'],
                    "MODULO" => "CONDONACIONES",
                    "USUARIO" => $nombreAprobador,
                    "MENSAJE" => "Se creó la siguiente solicitud de cobranza donde debes aprobar el pedido de condonación. Ingresa al sistema Petitracking para poder gestionarlo.",
                    "URL_MODULO" => base_url()."/detalle-condonacion-cobranza/".$idCondonacionCobranza
                );
                
                $cuerpo = $this->plantillasCorreo->avisoPetitracking($arrayCuerpo);
                
        		/*
                * ----------------------------
                * PREPARACIÓN DE PARAMETROS PARA EL CORREO
                * ----------------------------
        		*/
        		
        		$correoCopia[] = $this->items['correoElectronico'];
        		
                $asunto="APROBADOR ASIGNADO - SOLICITUD DE CONDONACIÓN DE COBRANZA #".$idCondonacionCobranza;
                
                $configCorreo = array(
                    "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
                    "CORREO_ORIGEN" => $this->items['correoElectronico'],
                    "CORREOS_DESTINOS" => array($correoAprobador),
                    "CORREOS_COPIA" => $correoCopia,
                    "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe", "joseenrique.nanquen@verisure.pe"),
                    "ASUNTO" => $asunto,
                    "MENSAJE" => $cuerpo
                );
        
                $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);
        
                $dataCorreo = array(
                    "IDSolicitudCobranza" => $idCondonacionCobranza,
                    "Momento"       => "CREACION",
                    "Response"      => $estadoCorreo['RESPUESTA'],
                    "Error"         => $estadoCorreo['ERROR'],
                    'UsuarioCrea'   => $this->items['id'],
                    'FechaCrea'     => $fechaActual,    
                    'Localhost'     => $this->request->getIPAddress()
                );
        
                $this->correoStatusCondonacionCobranzas->insert($dataCorreo, TRUE);
            }
            
            //VALIDACIÓN DE QUERYS
            if ($this->db->transStatus() === false) 
            {
                // Algo falló en los queries, pero no se lanzó excepción automáticamente
                // Asigna el error en "Throw" para que sea detectado por el catch y dispare el error
                throw new DatabaseException('Error en la transacción');
            }

            $this->db->transCommit();
            
            $message = sprintf($this->mensajeError->msg201, "La solicitud fue registrada con éxito");
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        } 
        catch (\Throwable $e) 
        {
            $this->db->transRollback();
            
            $message = sprintf($this->mensajeError->msg201, "<li>Error en la transacción. No se pudo registrar la solicitud. Inténtelo luego[ERRTRANS]</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
    }
    
    public function detalleCondonacionCobranza($idSolicitud)
    {
        if(isset($this->items['id']))
        {
			// ACCIONES
			$whereCondonacion = array(
			    'IDSolicitudCobranza'   => $idSolicitud
			);
			
            $condonacion    = $this->condonacionesCobranzas->obtenerCondonacionCobranza($whereCondonacion);
            $aprobadores    = $this->condonacionesCobranzasAprobadores->listarAprobadoresCondonacionCobranza($whereCondonacion);
            
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Detalle de Solicitud | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Detalle de Solicitud | '.$idSolicitud,
                'previo'                => 'listar-condonaciones',
                'condonacion'           => $condonacion,
                'idSolicitud'           => $idSolicitud,
                'aprobadores'           => $aprobadores
			);
			
			$data = array_merge($data, $this->items);
			
			return view('procesos/Condonaciones/detalle_condonacion_cobranza',$data);
		} 
		else 
		{
			return view('errors/500');
		}
    }
    
    public function registrarComentarioCondonacionCobranza()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        $error = '';
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        //Información de Condonación
        
        $comentario     = $this->request->getPost('txtComentarios_rcomcondcobr');
        $idSolicitud    = $this->request->getPost('txtIDSolicitud_rcomcondcobr');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error .= $this->complementos->validaCampo($idSolicitud, 'required|trim|numeric', 'ID Solicitud');
        $error .= $this->complementos->validaCampo($comentario, 'required|trim', 'Comentario');
        
        if ($error != '') 
        {
            $message = sprintf($this->mensajeError->msg201, $error);
            $mensaje = $this->alertas->alertaError($message);
            
            $resultado = array(
    			'result'    => (string) 0,
    			'mensaje'   => (string) $mensaje
    		);
    		
    		echo json_encode($resultado);
    		
            EXIT;
        }
        
        /*
        * ----------------------------
        * INSERTAR COMENTARIO
        * ----------------------------
        */

        $data = array (
            'IDSolicitudCobranza'   => $idSolicitud,
            'Accion'                => "COMCONDCOBR",
            'ValorBitacora'         => "COME",
            'Comentario'            => $comentario,
            'UsuarioRegistra'       => $this->items['id'],
            'FechaRegistra'         => $fechaActual,    
            'Localhost'             => $this->request->getIPAddress(),
            'Estado'                => 'A'
        );

        $lastId = $this->condonacionesCobranzasBitacora->insert($data, TRUE);

		if($lastId !== FALSE)
		{
		    $message = sprintf($this->mensajeError->msg201, "Se registró el comentario exitosamente.");
            $mensaje = $this->alertas->alertaExito($message);
            
            $resultado = array(
    			'result'    => (string) 1,
    			'mensaje'   => (string) $mensaje
    		);
		}
        else
        {
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el comentario. Inténtelo luego.");
            $mensaje = $this->alertas->alertaError($message);
            
            $resultado = array(
    			'result'    => (string) 0,
    			'mensaje'   => (string) $mensaje
    		);
        }
        
        echo json_encode($resultado);
        EXIT;
    }
    
    public function comentariosCondonacionCobranza()
    {
        $html = '';
        
        if(isset($this->items['id']))
        {
            /*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
            */
    
            $msjError       = TRUE;
            $idSolicitud    = $this->request->getPost('idSolicitud');
            
            $arrayTitulos = array(
                "MODCONDCOB"        => "Actualización de Condonación",
                "DECICONDCOB"       => "Decisión de Aprobación de Condonación",
                "ESTCONDCOB"        => "Cambio de Estado de Condonación",
                "COMDECICONDCOBR"   => "Comentario de Decisión de Aprobación de Condonación",
                "COMCONDCOBR"       => "Comentario de Condonación"
            );
            
            $arrayIconos = array(
                "APRO"  => '<span class="badge bg-success border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Aprobado"><i class="mdi mdi-check-circle align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "RECH"  => '<span class="badge bg-danger border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Rechazado"><i class="mdi mdi-close-circle align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "PEND"  => '<span class="badge bg-gris-claro border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Pendiente"><i class="mdi mdi-timer-sand align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "CANC"  => '<span class="badge bg-dark border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Cancelado"><i class="mdi mdi-cancel align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "COME"  => '<span class="badge bg-come border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Comentario"><i class="mdi mdi-comment align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "MODCONDCOB"  => '<span class="badge bg-orange border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Comentario"><i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i></span>'
            );
            
            
            /*
            * ----------------------------
            * CONSULTAS SQL
            * ----------------------------
            */
            
            $arrayCondonacion = array(
                'IDSolicitudCobranza' => $idSolicitud
            );
    
            $bitacora   = $this->condonacionesCobranzasBitacora->listarBitacoraCondonacionCobranza($arrayCondonacion);
            
            /*
            * ----------------------------
            * ARMAR HTML
            * ----------------------------
            */
            
            $fechaActual = '';
            
            if(!empty($bitacora))
            {
                foreach ($bitacora as $index => $evento)
                {
                    // Título acción
                    $tituloAccion = '<span class="badge bg-primary-subtle text-primary fw-semibold ms-auto">'.$arrayTitulos[$evento['Accion']].'</span>';

                    $html .= '<div class="d-flex mb-4 p-3 border rounded" style="background-color: #ffffff; box-shadow: 4px 4px #8A8C8E;">
                        <div class="flex-shrink-0 me-3 d-flex justify-content-center align-items-center">
                            <h5>'.(isset($arrayIconos[$evento['ValorBitacora']]) || isset($arrayIconos[$evento['Accion']]) ? (isset($arrayIconos[$evento['ValorBitacora']]) ? $arrayIconos[$evento['ValorBitacora']] : $arrayIconos[$evento['Accion']] ) : '<span class="badge bg-warning border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Registro de Actividad"><i class="mdi mdi-star align-bottom" style="font-size: 20px; color: #FFF;"></i></span>' ).'</h5>
                        </div>
                        <div class="flex-grow-1">
                            <div class="d-flex justify-content-between align-items-center mb-1">
                                <h6 class="mb-0">'.ucwords(mb_strtolower($evento['Nombres'].' '.$evento['Apellidos'])).'</h6>
                                <small class="text-muted">'.date('d M Y', strtotime($evento['Fecha'])).' - '.$evento['Hora'].'</small>
                            </div>
                            <p class="text-muted my-2">'.$evento['Comentario'].'</p>
                            <div class="d-flex align-items-center justify-content-between">
                                <div></div>
                                '.$tituloAccion.'
                            </div>
                        </div>
                    </div>';
                }
            }
            else
            {
                $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 justify-content-center align-items-center" style="border-radius: 10px;">
                    <div class="col-xxl-10 col-md-12 col-12 ">
                        <div class="alert alert-dark alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                            <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>NO SE ENCONTRÓ COMENTARIOS DE SOLICITUD</strong>
                        </div>
                    </div>
                </div>';
            }
        }
        else 
		{
            $html = '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
	            <div class="col-xxl-10 col-md-12 col-12 ">
        	        <div class="alert alert-danger alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN SESIÓN</strong> - No hay sesión iniciada. Inicie sesión nuevamente.
                    </div>
                </div>
        	</div>';
		}
		
		echo $html;
    }
    
    public function modificarEstadoCondonacionCobranza()
    {
        $fechaActual = date("Y-m-d H:i:s");
        $fechaActualAdd = date("Y-m-d H:i:s", strtotime($fechaActual)+1);
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError       = TRUE;
        $motivo         = $this->request->getPost('motivoEstado');
        $idSolicitud    = $this->request->getPost('idSolicitudCobranza');
        $estado         = $this->request->getPost('estado');
        
        $idAprobacion   = $this->request->getPost('IDAprobacionCobranza');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idSolicitud, 'required|trim|numeric', 'ID Solicitud');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[4]|maxlength[4]', 'Estado');
        
        if ($error != '') 
        {
            $message = sprintf($this->mensajeError->msg201, $error);
            $mensaje = $this->alertas->alertaError($message);
            
            $resultado = array(
    			'result'    => (string) 0,
    			'mensaje'   => (string) $mensaje
    		);
    		
    		echo json_encode($resultado);
    		
            EXIT;
        }
        
        /*
        * ----------------------------
        * ARMADO DE CRUD
        * ----------------------------
        */
        
        $dataUpdateAprobador    = array();
            
        $dataUpdateAprobador = array(
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,
            'Estado'            => $estado, 
            'FechaEstado'       => $fechaActual,
            'UsuarioEstado'     => $this->items['id'],
            'MotivoEstado'      => $motivo != '' && $motivo != null ? $motivo : "Solicitud de condonación ".($estado == "APRO" ? "aprobada" : ($estado == "CANC" ? "cancelada" : "rechazada")).".",
            'Localhost'         => $this->request->getIPAddress()
        );
        
        if($estado == "CANC")
        {
            $listadoAprobaciones = $this->condonacionesCobranzasAprobadores->select('IDAprobacionCobranza')->where("IDSolicitudCobranza", $idSolicitud)->findAll();
            
            $dataBatch = array();
            
            if(!empty($listadoAprobaciones))
            {
                foreach ($listadoAprobaciones as $aprobacion)
                {
                    
                }
            }
        }
        else
        {
            
            $lastID = $this->condonacionesCobranzasAprobadores->update([$idAprobacion], $dataUpdateAprobador);
        }
        
        if($lastID !== FALSE)
        {
            $message = sprintf($this->mensajeError->msg201, "Se registraron los cambios exitosamente.");
            $mensaje = $this->alertas->alertaExito($message);
            $refrescar = $this->alertas->refrescar(1);
            
            $resultado = array(
    			'result'    => (string) 1,
    			'mensaje'   => (string) $mensaje.$refrescar
    		);
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar los cambios solicitados. Inténtelo luego.");
            $mensaje = $this->alertas->alertaError($message);
            
            $resultado = array(
    			'result'    => (string) 0,
    			'mensaje'   => (string) $mensaje
    		);
        }
        
        echo json_encode($resultado);
        EXIT;
    }
    
    public function exportarPreGestionCondonacionCobranza()
    {
        
	   // $listado = $this->peticiones->exportarReporteBackOffice($arrayFechas);
	    $listado = array();
        $filename = "PreGestion_Condonacion_Cobranza.xlsx";
        $writer = WriterEntityFactory::createXLSXWriter();
        $writer->setShouldUseInlineStrings(true); // default (and recommended) value
        $writer->openToBrowser($filename);
        
        $cells = [
            WriterEntityFactory::createCell("NRO CONTRATO"),
            WriterEntityFactory::createCell("DESCONOCIDO"),
            WriterEntityFactory::createCell("CARTERA"),
            WriterEntityFactory::createCell("FECHA DE SOLICITUD"),
            WriterEntityFactory::createCell("FECHA INICIO"),
            WriterEntityFactory::createCell("OBSERVACIÓN"),
            WriterEntityFactory::createCell("GESTOR"),
            WriterEntityFactory::createCell("MES"),
            WriterEntityFactory::createCell("% DESCUENTO"),
            WriterEntityFactory::createCell("CARTERA"),
            WriterEntityFactory::createCell("DEUDA VENCIDA"),
            WriterEntityFactory::createCell("IMPORTE A CONDONAR")
        ];
        
        /** add a row at a time */
        $singleRow = WriterEntityFactory::createRow($cells);
        $writer->addRow($singleRow);
        
        if(!empty($listado))
        {
            foreach($listado as $key=>$item)
            {
                $creacion = date("Y-m-d", strtotime($item['FECHA_CREACION']));
    			$cells = [
                    WriterEntityFactory::createCell($item['IDPETICION']),
                    WriterEntityFactory::createCell($creacion),
                    WriterEntityFactory::createCell($item['DELEGACION']),
                    WriterEntityFactory::createCell($item['MATRICULA_RESP_DC']),
                    WriterEntityFactory::createCell($item['RESP_DC']),
                    WriterEntityFactory::createCell($item['PROSPECTO']),
                    WriterEntityFactory::createCell($item['MATRICULA_AGENTE']),
                    WriterEntityFactory::createCell($item['AGENTE']),
                    WriterEntityFactory::createCell($item['T1CLIENTE']),
                    WriterEntityFactory::createCell($item['REQUERIMIENTO']),
                    WriterEntityFactory::createCell($item['MOTIVO']),
                    WriterEntityFactory::createCell($item['ESTADO']),
                    WriterEntityFactory::createCell($item['MATRICULA_USUARIO_GESTION']),
                    WriterEntityFactory::createCell($item['USUARIO_GESTION']),
                    WriterEntityFactory::createCell($item['INICIO_GESTION']),
                    WriterEntityFactory::createCell($item['FIN_GESTION']),
                    WriterEntityFactory::createCell($item['TIEMPO_GESTION'])
                ];
                
                /** add a row at a time */
                $singleRow = WriterEntityFactory::createRow($cells);
                $writer->addRow($singleRow);
            }
        }
        
        $writer->close();
    }
    
	/**************************************************************************/
	
    /************************* FACTURAS - CONDONACIÓN *************************/
    
    public function facturasCondonacion($idCondonacion)
    {
        if(isset($this->items['id']))
        {
            $estadosFactura = ['APRO', 'RECH', 'CANC', 'PEND'];
            
			// ACCIONES
			$whereCondonacion = array(
			    'IDCondonacion'  => $idCondonacion
			);
			
            $condonacion    = $this->condonaciones->obtenerCondonacion($whereCondonacion);
            $facturas       = $this->condonacionesFacturas->where('IDCondonacion', $idCondonacion)->findAll();
            $adjuntos       = $this->condonacionesAdjuntos->where('IDCondonacion', $idCondonacion)->findAll();
            $aprobadores    = $this->condonacionesFacturasAprobadores->listarAprobadoresFacturaCondonacion(array("arrayIDFactura" => array_column($facturas, "IDFacturaCondonacion")));
            
            $countEstadoFact= $this->condonacionesFacturas->select('Estado, COUNT(*) as total')->where('IDCondonacion', $idCondonacion)->groupBy('Estado')->findAll();
            
            // Convertir el resultado a un arreglo asociativo: ['APRO' => 3, 'RECH' => 1, ...]
            $conteos = array_column($countEstadoFact, 'total', 'Estado');
            // Rellenar con ceros donde falten
            $cantidadEstadoFactura = array_merge(array_fill_keys($estadosFactura, 0), $conteos);
			
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Facturas a Condonar | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Facturas a Condonar | '.$idCondonacion,
                'previo'                => 'listar-condonaciones',
                'condonacion'           => $condonacion,
                'idCondonacion'         => $idCondonacion,
                'listadoFacturas'       => $facturas,
                'listadoAdjuntos'       => $adjuntos,
                'cantidadEstadoFactura' => $cantidadEstadoFactura,
                'aprobadoresFactura'    => $aprobadores
			);
			
			$data = array_merge($data, $this->items);
			
			return view('procesos/Condonaciones/ver_facturas_condonacion',$data);
		} 
		else 
		{
			return view('errors/500');
		}
    }
    
//     public function facturasPendientesCondonacionUsuario()
//     {
//         if(isset($this->items['id']))
//         {
//             $idCondonacion = $this->request->getPost('idCondonacion');
            
//             // ACCIONES
// 			$whereAprobadores = array(
// 			    'IDCondonacion' => $idCondonacion,
// 			    'Estado'        => "PEND",
// 			    'Aprobador'     => $this->items['id']
// 			);
			
//             $listadoFacturas    = $this->condonacionesFacturasAprobadores->listarAprobadoresFacturaCondonacion($whereAprobadores);
			
// 			$html = '';
			
// 			if(!empty($listadoFacturas))
// 			{
// 			    $html .= '<table id="tblFacturasPendientesAprobarCondonacion" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
//     			    <thead>
//                         <tr>
//                             <th class="">Nro Contrato</th>
//                             <th class="">Factura Interna</th>
//                             <th class="">Factura Externa</th>
//                             <th class="">Segmento</th>
//                             <th class="">Tipo de Factura</th>
//                             <th class="">Deuda Total</th>
//                             <th class="">Importe a Condonar</th>
//                             <th class="">Aprobar | Rechazar</th>
//                             <th class="">Observación</th>
//                         </tr>
//                     </thead>
//                     <tbody>';
//                         foreach($listadoFacturas as $facturas)
//                         {
//                             $html .= '<tr>
//                                 <td class="text-center align-middle">'.$facturas['NroContrato'].'</td>
//                                 <td class="text-center align-middle">'.$facturas['FacturaInterna'].'</td>
//                                 <td class="text-center align-middle">'.$facturas['FacturaExterna'].'</td>
//                                 <td class="text-center align-middle">'.$facturas['Segmento'].'</td>
//                                 <td class="text-center align-middle">'.$facturas['TipoFactura'].'</td>
//                                 <td class="text-center align-middle">S/ '.number_format(round($facturas['DeudaTotal'], 2), 2, '.', '').'</td>
//                                 <td class="text-center align-middle">S/ '.number_format(round($facturas['ImporteCondonar'], 2), 2, '.', '').'</td>
//                                 <td class="text-center align-middle d-flex justify-content-center">
//                                     <center class="content-center" style="position: relative; height: 40px;">
//                                         <input type="radio" id="rdbtnAprobarFacturaCondonacion'.$facturas['IDAprobacion'].'" name="rdbtnEstadoAprobacionFactura['.$facturas['IDAprobacion'].']" class="rdbtnEstadoAprobacionFactura rb-basico rb-aprobar" data-aprobacion="'.$facturas['IDAprobacion'].'" value="APRO" >
//                                         <label for="rdbtnAprobarFacturaCondonacion'.$facturas['IDAprobacion'].'"></label>
//                         			</center>
//                                     <center class="content-center" style="position: relative; height: 40px;">
//                                         <input type="radio" id="rdbtnRechazarFacturaCondonacion'.$facturas['IDAprobacion'].'" name="rdbtnEstadoAprobacionFactura['.$facturas['IDAprobacion'].']" class="rdbtnEstadoAprobacionFactura rb-basico rb-rechazar" data-aprobacion="'.$facturas['IDAprobacion'].'" value="RECH" >
//                                         <label for="rdbtnRechazarFacturaCondonacion'.$facturas['IDAprobacion'].'"></label>
//                         			</center>
//                                 </td>
//                                 <td class="text-center align-middle"><input type="text" name="observacion['.$facturas['IDAprobacion'].']" class="form-control"></td>
//                             </tr>';
//                         }
//                     $html .= '</tbody>
//     			</table>';
    			
// 			}
// 			else
// 			{
// 			     $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
//     	            <div class="col-xxl-10 col-md-12 col-12 ">
//             	        <div class="alert alert-info alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
//                             <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>NO SE ENCONTRÓ FACTURAS</strong> - No hay facturas pendientes para aprobar.
//                         </div>
//                     </div>
//             	</div>';
// 			}
// 			echo $html;
// 		} 
// 		else 
// 		{
// 			echo '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
// 	            <div class="col-xxl-10 col-md-12 col-12 ">
//         	        <div class="alert alert-danger alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
//                         <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN SESIÓN</strong> - No hay sesión iniciada. Inicie sesión nuevamente.
//                     </div>
//                 </div>
//         	</div>';
// 		}
//     }
    public function obtenerDatosFacturaCondonacion()
    {
        if (isset($this->items['id'])) 
    	{
    		/*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idFactura = $this->request->getPost('idFactura');
    
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($idFactura, 'trim', 'ID');
    
    		if ($error != '') {
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$datosFactura = $this->condonacionesFacturas->where('IDFacturaCondonacion', $idFactura)->first();
    
    		if(!empty($datosFactura))
    		{
    			$resultado = array(
    				'idfactura'         => (string) $idFactura,
    				'idcondonacion'     => (string) $datosFactura['IDCondonacion'],
    				'nrocontrato'       => (string) $datosFactura['NroContrato'],
    				'facturainterna'    => (string) $datosFactura['FacturaInterna'],
    				'facturaexterna'    => (string) $datosFactura['FacturaExterna'],
    				'tipofactura'       => (string) $datosFactura['TipoFactura'],
    				'segmento'          => (string) $datosFactura['Segmento'],
    				'deudatotal'        => (string) $datosFactura['DeudaTotal'],
    				'importecondonar'   => (string) $datosFactura['ImporteCondonar']
    			);
    		} 
    		else 
    		{
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado);
    	} 
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }	
    }
    
    public function modificarFacturaCondonacion($idFacturaCondonacion)
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $importeCondonar    = $this->request->getPost('txtImporte_ifcond');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($importeCondonar, 'required|decimal|trim|minnumber[0]', 'Importe Condonar');
        
        if ($error != '') 
        {
            $message = sprintf($this->mensajeError->msg201, $error);
            $mensaje = $this->alertas->alertaError($message);
            
            $resultado = array(
    			'result'    => (string) 0,
    			'mensaje'   => (string) $mensaje
    		);
    		
    		echo json_encode($resultado);
    		
            EXIT;
        }
        
        /*
        * ----------------------------
        * ARMADO DE UPDATE
        * ----------------------------
        */

        $data = array (
            'ImporteCondonar'   => $importeCondonar,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->condonacionesFacturas->update([$idFacturaCondonacion], $data);

		if($lastId !== FALSE)
		{
			$message = sprintf($this->mensajeError->msg503, $idFacturaCondonacion );
			$mensaje = $this->alertas->alertaExito($message);
			
			$resultado = array(
    			'result'    => (string) 1,
    			'mensaje'   => (string) $mensaje
    		);
		}
		else
		{
		    $message = sprintf($this->mensajeError->msg201, "No se pudo actualizar el registro. Inténtelo luego.");
            $mensaje = $this->alertas->alertaError($message);
            
            $resultado = array(
    			'result'    => (string) 0,
    			'mensaje'   => (string) $mensaje
    		);
		}
		
		echo json_encode($resultado);
    }
    
    public function modificarEstadoFacturaCondonacion()
    {
        $fechaActual = date("Y-m-d H:i:s");
        $fechaActualAdd = date("Y-m-d H:i:s", strtotime($fechaActual)+1);
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError               = TRUE;
        $estado                 = $this->request->getPost('txtEstadoFacturaCondonacion');
        $motivo                 = $this->request->getPost('txtObservacionFacturaCondonacion');
        $idFacturaCondonacion   = $this->request->getPost('txtIDFacturaCondonacion');
        $tipoCambio             = $this->request->getPost('txtTipoCambio');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        
        if($tipoCambio == "I")
        {
            $error .= $this->complementos->validaCampo($idFacturaCondonacion, 'required|trim|numeric', 'Factura a Condonar');
            $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[4]|maxlength[4]', 'Estado');
        }
        else
        {
            $error .= 'No hay un tipo de cambio de estado válido. Inténtelo luego.';
        }
        
        if ($error != '') 
        {
            $message = sprintf($this->mensajeError->msg201, $error);
            $mensaje = $this->alertas->alertaError($message);
            
            $resultado = array(
    			'result'    => (string) 0,
    			'mensaje'   => (string) $mensaje
    		);
    		
    		echo json_encode($resultado);
    		
            EXIT;
        }
        
        /*
        * ----------------------------
        * ARMADO DE CRUD
        * ----------------------------
        */
        
        $dataUpdateAprobadores = array();
        
        $dataFacturaCondonacion = array (
            'UsuarioModifica'       => $this->items['id'],
            'Estado'                => $estado, 
            'UsuarioEstado'         => $this->items['id'],
            'Localhost'             => $this->request->getIPAddress()
        );
        
        /*
        * ----------------------------
        * EVALUACIÓN DE ESTADOS
        * ----------------------------
        */
        
        if($estado == 'CANC')
        {
            //DATA COMPLEMENTARIA PARA CANCELAR LA FACTURA A CONDONAR
            $dataFacturaCondonacion['FechaModifica']  = $fechaActual;
            $dataFacturaCondonacion['FechaEstado']    = $fechaActual;
            $dataFacturaCondonacion['MotivoEstado']   = $motivo != '' && $motivo != null ? $motivo : "Condonación de Factura Cancelada.";
            
            //OBTENER APROBACIONES PENDIENTES DE LA FACTURA CANCELADA PARA CANCELAR LAS MISMAS
            
        }
        
        /*
        * ----------------------------
        * EJECUTAR CRUD 
        * ----------------------------
        */
        
        //EJECUTAR CAMBIOS FACTURA CONDONACION
        
        $lastIDFacturaCond = $this->condonacionesFacturas->update([$idFacturaCondonacion], $dataFacturaCondonacion);
        
        if($lastIDFacturaCond !== FALSE)
        {
            $message = sprintf($this->mensajeError->msg201, "Se registró el cambio exitosamente.");
            $mensaje = $this->alertas->alertaExito($message);
            
            $resultado = array(
    			'result'    => (string) 1,
    			'mensaje'   => (string) $mensaje
    		);
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el cambio solicitado. Inténtelo luego.");
            $mensaje = $this->alertas->alertaError($message);
            
            $resultado = array(
    			'result'    => (string) 0,
    			'mensaje'   => (string) $mensaje
    		);
        }
        
        echo json_encode($resultado);
        EXIT;      
    }
    
    public function modificarEstadoAprobacionFacturaCondonacion()
    {
        $fechaActual = date("Y-m-d H:i:s");
        $fechaActualAdd = date("Y-m-d H:i:s", strtotime($fechaActual)+1);
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError               = TRUE;
        $motivo                 = $this->request->getPost('txtObservacionFacturaCondonacion');
        $tipoAprobacion         = $this->request->getPost('txtTipoAprobacion');
        $idCondonacion          = $this->request->getPost('txtIDCondonacion');
        $btnAprobacionMasiva    = $this->request->getPost('rdbtnEstadoAprobacionFactura');
        $observacionRechazo     = $this->request->getPost('observacion');
        
        $idAprobacion           = $this->request->getPost('txtIDAprobacionCondonacion');
        $estadoAprobacion       = $this->request->getPost('txtEstadoAprobacion');
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        
        if($tipoAprobacion == "M")
        {
            if(empty($btnAprobacionMasiva))
            {
                $error .= "No se encontraron facturas para gestionar el cambio de estado. Inténtelo luego.";
            }
        }
        else if($tipoAprobacion == "I")
        {
            $error .= $this->complementos->validaCampo($idCondonacion, 'required|trim|numeric', 'ID Condonacion');
            $error .= $this->complementos->validaCampo($idAprobacion, 'required|trim|numeric', 'ID Aprobador');
            $error .= $this->complementos->validaCampo($estadoAprobacion, 'required|trim|alpha|minlength[4]|maxlength[4]', 'Estado');
        }
        else
        {
            $error .= 'No se encontró tipo de cambio válido a ejecutar. Inténtelo luego.';
        }
        
        if ($error != '') 
        {
            $message = sprintf($this->mensajeError->msg201, $error);
            $mensaje = $this->alertas->alertaError($message);
            
            $resultado = array(
    			'result'    => (string) 0,
    			'mensaje'   => (string) $mensaje
    		);
    		
    		echo json_encode($resultado);
    		
            EXIT;
        }
        
        /*
        * ----------------------------
        * ARMADO DE CRUD
        * ----------------------------
        */
        
        $dataUpdateAprobadores = array();
            
        if($tipoAprobacion == "M")
        {
            foreach($btnAprobacionMasiva as $idAprobacion => $estado)
            {
                $dataUpdateAprobadores[] = array(
                    'IDAprobacion'      => $idAprobacion,
                    'UsuarioModifica'   => $this->items['id'],
                    'FechaModifica'     => $fechaActual,
                    'Estado'            => $estado, 
                    'FechaEstado'       => $fechaActual,
                    'UsuarioEstado'     => $this->items['id'],
                    'MotivoEstado'      => $estado == "RECH" ? $observacionRechazo[$idAprobacion] : $motivo,
                    'Localhost'         => $this->request->getIPAddress()
                );
            }
            
            $lastIDApro = $this->condonacionesFacturasAprobadores->updateBatch($dataUpdateAprobadores, 'IDAprobacion');
        }
        else
        {
            $dataUpdateAprobadores = array(
                'UsuarioModifica'   => $this->items['id'],
                'FechaModifica'     => $fechaActual,
                'Estado'            => $estadoAprobacion, 
                'FechaEstado'       => $fechaActual,
                'UsuarioEstado'     => $this->items['id'],
                'MotivoEstado'      => $motivo != "" ? $motivo : "Reaprobación solicitada.",
                'Localhost'         => $this->request->getIPAddress()
            );
            
            $lastIDApro = $this->condonacionesFacturasAprobadores->update([$idAprobacion], $dataUpdateAprobadores);
        }
            
        if($lastIDApro !== FALSE)
        {
            $message = sprintf($this->mensajeError->msg201, "Se registraron los cambios exitosamente.");
            $mensaje = $this->alertas->alertaExito($message);
            
            $resultado = array(
    			'result'    => (string) 1,
    			'mensaje'   => (string) $mensaje
    		);
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar los cambios solicitados. Inténtelo luego.");
            $mensaje = $this->alertas->alertaError($message);
            
            $resultado = array(
    			'result'    => (string) 0,
    			'mensaje'   => (string) $mensaje
    		);
        }
        
        echo json_encode($resultado);
        EXIT;
    }
    
    
    public function recargarFacturasCondonacion()
    {
        $html = '';
        
        if(isset($this->items['id']))
        {
            $estadosFactura = ['APRO', 'RECH', 'CANC', 'PEND'];
            
            /*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
            */
    
            $msjError       = TRUE;
            $idCondonacion  = $this->request->getPost('idCondonacion');
            
            /*
            * ----------------------------
            * CONSULTAS SQL
            * ----------------------------
            */
    
            $facturas       = $this->condonacionesFacturas->where('IDCondonacion', $idCondonacion)->findAll();
            $countEstadoFact= $this->condonacionesFacturas->select('Estado, COUNT(*) as total')->where('IDCondonacion', $idCondonacion)->groupBy('Estado')->findAll();
            $aprobadores    = $this->condonacionesFacturasAprobadores->listarAprobadoresFacturaCondonacion(array("arrayIDFactura" => array_column($facturas, "IDFacturaCondonacion")));

            // Convertir el resultado a un arreglo asociativo: ['APRO' => 3, 'RECH' => 1, ...]
            $conteos = array_column($countEstadoFact, 'total', 'Estado');
            // Rellenar con ceros donde falten
            $cantidadEstadoFactura = array_merge(array_fill_keys($estadosFactura, 0), $conteos);
			
            /*
            * ----------------------------
            * ARMAR HTML
            * ----------------------------
            */
            
            // Inicializa un arreglo agrupado por estado
            $facturasPorEstado = [
                'APRO' => [],
                'RECH' => [],
                'CANC' => [],
                'PEND' => [],
            ];
            
            $aprobadoresPorFactura = [];
            
            // Agrupa los registros según su estado
            foreach ($facturas as $registro)
            {
                $estado = $registro['Estado'];
                if (array_key_exists($estado, $facturasPorEstado))
                {
                    $facturasPorEstado[$estado][] = $registro;
                }
            }
            
            //Agrupa los registros según su factura
            foreach ($aprobadores as $registro) 
            {
                $idFactura = $registro['IDFactura'];
                $aprobadoresPorFactura[$idFactura][] = $registro;
            }
            
            $html .= '<div class="row row-cols-xxl-4 row-cols-lg-2 row-cols-md-1 row-cols-1">';
            
                $html .= '<div class="col">
                    <div class="card">
                        <a class="card-body bg-dark" data-bs-toggle="collapse" href="#facturasCanceladas" role="button" aria-expanded="true" aria-controls="facturasCanceladas">
                            <h5 class="card-title text-uppercase fw-semibold mb-1 fs-15 text-white">Facturas Canceladas</h5>
                            <p class="text-white mb-0">Total: <span class="fw-medium">'.$cantidadEstadoFactura['CANC'].' Factura(s)</span></p>
                        </a>
                    </div>
                    <!--end card-->
                    <div class="collapse" id="facturasCanceladas" style="">';
                    
                    if(!empty($facturasPorEstado['CANC']))
                    {
                        foreach($facturasPorEstado['CANC'] as $canceladas)
                        {
                            $html .= '<div class="card mb-1">
                                <div class="card-body">
                                    <a class="d-flex align-items-center" data-bs-toggle="collapse" href="#IDFact'.$canceladas['IDFacturaCondonacion'].'" role="button" aria-expanded="false" aria-controls="IDFact'.$canceladas['IDFacturaCondonacion'].'">
                                        <div class="flex-shrink-0">
                                            <div class="avatar-md rounded">
                                                <div class="avatar-title border bg-light text-primary rounded text-uppercase fs-24">'.$canceladas['TipoFactura'].'</div>
                                            </div>
                                        </div>
                                        <div class="flex-grow-1 ms-3">
                                            <p class="text-muted my-1">'.$canceladas['FacturaExterna'].'</p>
                                            <div class="d-flex flex-wrap gap-2 align-items-center my-1">'.$canceladas['FacturaInterna'].'</div>
                                            <div class="d-flex gap-4 my-1 text-muted justify-content-start align-content-center">
                                                <div>
                                                    <div class="badge text-bg-danger">S/ '.number_format(round($canceladas['DeudaTotal'], 2), 2, '.', '').'</div>
                                                </div>
                                                <div>
                                                    <i class="mdi mdi-slash-forward text-primary me-1 align-bottom"></i>
                                                    <div class="badge text-bg-success">S/ '.number_format(round($canceladas['ImporteCondonar'], 2), 2, '.', '').'</div>
                                                </div>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                                <div class="collapse border-top border-top-dashed" id="IDFact'.$canceladas['IDFacturaCondonacion'].'">
                                    <div class="card-body row col-12 d-flex justify-content-center align-items-center p-0 m-0 px-2">';
                                    
                                    $borderStatus = "";
                                    foreach($aprobadoresPorFactura[$canceladas['IDFacturaCondonacion']] as $aprobador)
                                    {
                                        if($aprobador['EstadoSolicitudAprobacion']=="APRO")
                                        {
                                            $borderStatus = "border-success";
                                        }
                                        else if($aprobador['EstadoSolicitudAprobacion']=="RECH")
                                        {
                                            $borderStatus = "border-danger";
                                        }
                                        else if($aprobador['EstadoSolicitudAprobacion']=="PEND")
                                        {
                                            $borderStatus = "border-gris-claro";
                                            // $borderStatus = "border-dark";
                                        }
                                        else if($aprobador['EstadoSolicitudAprobacion']=="CANC")
                                        {
                                            $borderStatus = "border-dark";
                                        }
                                        
                                        $html .= '<div class="card product '.$borderStatus.'" style="border-width: 1px;">
                                            <div class="card-body">
                                                <div class="row gy-3">
                                                    <div class="col-sm-auto">
                                                        <div class="text-lg-end">';
                                                        
                                                        if($aprobador['EstadoSolicitudAprobacion']=="APRO")
                                                        {
                                                            $html .= '<button class="badge bg-success border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Aprobado">
                                                                <i class="mdi mdi-check-circle align-bottom" style="font-size: 20px; color: #FFF;"></i>
                                                            </button>';
                                                        }
                                                        else if($aprobador['EstadoSolicitudAprobacion']=="RECH")
                                                        {
                                                            $html .= '<button class="badge bg-danger border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Rechazado">
                                                                <i class="mdi mdi-close-circle align-bottom" style="font-size: 20px; color: #FFF;"></i>
                                                            </button>';
                                                        }
                                                        else if($aprobador['EstadoSolicitudAprobacion']=="PEND")
                                                        {
                                                            $html .= '<button class="badge bg-gris-claro border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Pendiente">
                                                                <i class="mdi mdi-timer-sand align-bottom" style="font-size: 20px; color: #FFF;"></i>
                                                            </button>';
                                                        }
                                                        else if($aprobador['EstadoSolicitudAprobacion']=="CANC")
                                                        {
                                                            $html .= '<button class="badge bg-dark border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Cancelado">
                                                                <i class="mdi mdi-cancel align-bottom" style="font-size: 20px; color: #FFF;"></i>
                                                            </button>';
                                                        }
                                                        
                                                        $html .= '</div>
                                                    </div>
                                                    <div class="col-sm">
                                                        <h5 class="fs-14 text-truncate">'.ucwords(mb_strtolower($aprobador['Nombres'].' '.$aprobador['Apellidos'])).'</h5>
                                                        <ul class="list-inline text-muted">
                                                            <li class="list-inline-item">'.$aprobador['Cargo'].'</li>
                                                            <li class="list-inline-item">'.$aprobador['Matricula'].'</li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- card body -->
                                            <div class="card-footer">
                                                <div class="row align-items-center gy-3">
                                                    <div class="col-sm">
                                                        <div class="d-flex flex-wrap my-n1">
                                                            <div>
                                                                <a class="d-block text-body p-1 px-2 comentarios-aprobador-factura-condonacion" data-bs-target="#mdlComentariosAprobacionCondonacion" data-aprobacion="'.$aprobador['IDAprobacion'].'" data-factura="'.$aprobador['IDFactura'].'" style="cursor: pointer;">
                                                                    <i class="mdi mdi-message-reply text-muted align-bottom me-1"></i> Comentarios
                                                                </a>
                                                            </div>';
                                                            
                                                            $html .= '<div></div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-auto">
                                                        <div class="d-flex align-items-center gap-2 text-muted">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end card footer -->
                                        </div>';
                                    }
                                    
                                    $html .= '</div>
                                    <div class="card-footer hstack gap-2">
                                        <button class="btn bg-rosa btn-sm w-100 text-white comentarios-factura-condonacion" data-bs-target="#mdlComentariosFacturaCondonacion" data-factura="'.$canceladas['IDFacturaCondonacion'].'"><i class="mdi mdi-message-reply align-bottom me-1"></i> Comentarios</button>
                                    </div>
                                </div>
                            </div>';
                        }
                    }
                    else
                    {
                        $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 justify-content-center align-items-center" style="border-radius: 10px;">
                            <div class="col-xxl-10 col-md-12 col-12 ">
                                <div class="alert alert-dark alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                                    <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>NO SE ENCONTRÓ FACTURAS</strong> - No hay facturas canceladas.
                                </div>
                            </div>
                        </div>';
                    }
                    
                    $html .= '<!--end card-->
                    </div>
                </div>
                <!--end col-->';
                
                
                $html .= '<div class="col">
                    <div class="card">
                        <a class="card-body bg-danger" data-bs-toggle="collapse" href="#facturasRechazadas" role="button" aria-expanded="true" aria-controls="facturasRechazadas">
                            <h5 class="card-title text-uppercase fw-semibold mb-1 fs-15 text-white">Facturas Rechazadas</h5>
                            <p class="text-white mb-0">Total: <span class="fw-medium">'.$cantidadEstadoFactura['RECH'].' Factura(s)</span></p>
                        </a>
                    </div>
                    <!--end card-->
                    <div class="collapse" id="facturasRechazadas" style="">';
                    
                    if(!empty($facturasPorEstado['RECH']))
                    {
                        foreach($facturasPorEstado['RECH'] as $rechazados)
                        {
                            $html .= '<div class="card mb-1">
                                <div class="card-body">
                                    <a class="d-flex align-items-center" data-bs-toggle="collapse" href="#IDFact'.$rechazados['IDFacturaCondonacion'].'" role="button" aria-expanded="false" aria-controls="IDFact'.$rechazados['IDFacturaCondonacion'].'">
                                        <div class="flex-shrink-0">
                                            <div class="avatar-md rounded">
                                                <div class="avatar-title border bg-light text-primary rounded text-uppercase fs-24">'.$rechazados['TipoFactura'].'</div>
                                            </div>
                                        </div>
                                        <div class="flex-grow-1 ms-3">
                                            <p class="text-muted my-1">'.$rechazados['FacturaExterna'].'</p>
                                            <div class="d-flex flex-wrap gap-2 align-items-center my-1">'.$rechazados['FacturaInterna'].'</div>
                                            <div class="d-flex gap-4 my-1 text-muted justify-content-start align-content-center">
                                                <div>
                                                    <div class="badge text-bg-danger">S/ '.number_format(round($rechazados['DeudaTotal'], 2), 2, '.', '').'</div>
                                                </div>
                                                <div>
                                                    <i class="mdi mdi-slash-forward text-primary me-1 align-bottom"></i>
                                                    <div class="badge text-bg-success">S/ '.number_format(round($rechazados['ImporteCondonar'], 2), 2, '.', '').'</div>
                                                </div>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                                <div class="collapse border-top border-top-dashed" id="IDFact'.$rechazados['IDFacturaCondonacion'].'">
                                    <div class="card-body row col-12 d-flex justify-content-center align-items-center p-0 m-0 px-2">';
                                    
                                    $borderStatus = "";
                                    foreach($aprobadoresPorFactura[$rechazados['IDFacturaCondonacion']] as $aprobador)
                                    {
                                        if($aprobador['EstadoSolicitudAprobacion']=="APRO")
                                        {
                                            $borderStatus = "border-success";
                                        }
                                        else if($aprobador['EstadoSolicitudAprobacion']=="RECH")
                                        {
                                            $borderStatus = "border-danger";
                                        }
                                        else if($aprobador['EstadoSolicitudAprobacion']=="PEND")
                                        {
                                            $borderStatus = "border-gris-claro";
                                            // $borderStatus = "border-dark";
                                        }
                                        else if($aprobador['EstadoSolicitudAprobacion']=="CANC")
                                        {
                                            $borderStatus = "border-dark";
                                        }
                                        
                                        $html .= '<div class="card product '.$borderStatus.'" style="border-width: 1px;">
                                            <div class="card-body">
                                                <div class="row gy-3">
                                                    <div class="col-sm-auto">
                                                        <div class="text-lg-end">';
                                                        
                                                        if($aprobador['EstadoSolicitudAprobacion']=="APRO")
                                                        {
                                                            $html .= '<button class="badge bg-success border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Aprobado">
                                                                <i class="mdi mdi-check-circle align-bottom" style="font-size: 20px; color: #FFF;"></i>
                                                            </button>';
                                                        }
                                                        else if($aprobador['EstadoSolicitudAprobacion']=="RECH")
                                                        {
                                                            $html .= '<button class="badge bg-danger border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Rechazado">
                                                                <i class="mdi mdi-close-circle align-bottom" style="font-size: 20px; color: #FFF;"></i>
                                                            </button>';
                                                        }
                                                        else if($aprobador['EstadoSolicitudAprobacion']=="PEND")
                                                        {
                                                            $html .= '<button class="badge bg-gris-claro border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Pendiente">
                                                                <i class="mdi mdi-timer-sand align-bottom" style="font-size: 20px; color: #FFF;"></i>
                                                            </button>';
                                                        }
                                                        else if($aprobador['EstadoSolicitudAprobacion']=="CANC")
                                                        {
                                                            $html .= '<button class="badge bg-dark border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Cancelado">
                                                                <i class="mdi mdi-cancel align-bottom" style="font-size: 20px; color: #FFF;"></i>
                                                            </button>';
                                                        }
                                                        
                                                        $html .= '</div>
                                                    </div>
                                                    <div class="col-sm">
                                                        <h5 class="fs-14 text-truncate">'.ucwords(mb_strtolower($aprobador['Nombres'].' '.$aprobador['Apellidos'])).'</h5>
                                                        <ul class="list-inline text-muted">
                                                            <li class="list-inline-item">'.$aprobador['Cargo'].'</li>
                                                            <li class="list-inline-item">'.$aprobador['Matricula'].'</li>
                                                        </ul>
                                                    </div>
                                                    
                                                </div>
                                            </div>
                                            <!-- card body -->
                                            <div class="card-footer">
                                                <div class="row align-items-center gy-3">
                                                    <div class="col-sm">
                                                        <div class="d-flex flex-wrap my-n1">
                                                            <div>
                                                                <a class="d-block text-body p-1 px-2 comentarios-aprobador-factura-condonacion" data-bs-target="#mdlComentariosAprobacionCondonacion" data-aprobacion="'.$aprobador['IDAprobacion'].'" data-factura="'.$aprobador['IDFactura'].'"  style="cursor: pointer;">
                                                                    <i class="mdi mdi-message-reply text-muted align-bottom me-1"></i> Comentarios
                                                                </a>
                                                            </div>
                                                            <div>
                                                                <a class="d-block text-body p-1 px-2 cambiar-aprobador-factura-condonacion" data-bs-target="#mdlCambiarAprobadorFacturaCondonacion" data-aprobacion="'.$aprobador['IDAprobacion'].'" data-factura="'.$aprobador['IDFactura'].'"  style="cursor: pointer;">
                                                                    <i class="mdi mdi-account-convert text-muted align-bottom me-1"></i> Cambiar
                                                                </a>
                                                            </div>';
                                                            
                                                            if($aprobador['EstadoSolicitudAprobacion']=="RECH")
                                                            {
                                                                $html .= '<div>
                                                                    <a class="d-block text-body p-1 px-2 solicitar-reaprobacion" data-aprobacion="'.$aprobador['IDAprobacion'].'" data-condonacion="'.$idCondonacion.'" style="cursor: pointer"><i class="mdi mdi-inbox-arrow-up text-muted align-bottom me-1"></i> Solicitar reaprobación</a>
                                                                </div>';
                                                            }
                                                            
                                                            $html .= '<div></div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-auto">
                                                        <div class="d-flex align-items-center gap-2 text-muted">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end card footer -->
                                        </div>';
                                    }
                                    
                                    $html .= '</div>
                                    <div class="card-footer hstack gap-2">
                                        <button class="btn bg-warning btn-sm w-100 text-white datos-factura-condonacion" data-bs-target="#mdlFacturaCondonacion" data-form="#formFacturaCondonacion" data-id="'.$rechazados['IDFacturaCondonacion'].'" data-accion="editar" data-toggle="tooltip" data-placement="top" aria-label="Editar Condonación de Factura"><i class="mdi mdi-pencil-outline align-bottom me-1"></i> Editar</button>
                                        <button type="button" class="btn bg-dark btn-sm w-100 text-white cancelar-factura-condonar" data-condonacion="'.$idCondonacion.'" data-id="'.$rechazados['IDFacturaCondonacion'].'" data-interna="'.$rechazados['FacturaInterna'].'" data-externa="'.$rechazados['FacturaExterna'].'" ><i class="mdi mdi-cancel align-bottom me-1"></i> Cancelar</button>
                                        <button class="btn bg-rosa btn-sm w-100 text-white comentarios-factura-condonacion" data-bs-target="#mdlComentariosFacturaCondonacion" data-factura="'.$rechazados['IDFacturaCondonacion'].'"><i class="mdi mdi-message-reply align-bottom me-1"></i> Comentarios</button>
                                    </div>
                                </div>
                            </div>';
                        }
                    }
                    else
                    {
                        $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 justify-content-center align-items-center" style="border-radius: 10px;">
            	            <div class="col-xxl-10 col-md-12 col-12 ">
                    	        <div class="alert alert-danger alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                                    <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>NO SE ENCONTRÓ FACTURAS</strong> - No hay facturas rechazadas.
                                </div>
                            </div>
                    	</div>';
                    }
                    
                    $html .= '<!--end card-->
                    </div>
                </div>
                <!--end col-->';
                
                
                $html .= '<div class="col">
                    <div class="card">
                        <a class="card-body bg-gris-claro" data-bs-toggle="collapse" href="#facturasPendientes" role="button" aria-expanded="true" aria-controls="facturasPendientes">
                            <h5 class="card-title text-uppercase fw-semibold mb-1 fs-15 text-white">Facturas Pendientes</h5>
                            <p class="text-white mb-0">Total: <span class="fw-medium">'.$cantidadEstadoFactura['PEND'].' Factura(s)</span></p>
                        </a>
                    </div>
                    <!--end card-->
                    <div class="collapse show" id="facturasPendientes" style="">';
                    
                    if(!empty($facturasPorEstado['PEND']))
                    {
                        foreach($facturasPorEstado['PEND'] as $pendientes)
                        {
                            $html .= '<div class="card mb-1">
                                <div class="card-body">
                                    <a class="d-flex align-items-center" data-bs-toggle="collapse" href="#IDFact'.$pendientes['IDFacturaCondonacion'].'" role="button" aria-expanded="false" aria-controls="IDFact'.$pendientes['IDFacturaCondonacion'].'">
                                        <div class="flex-shrink-0">
                                            <div class="avatar-md rounded">
                                                <div class="avatar-title border bg-light text-primary rounded text-uppercase fs-24">'.$pendientes['TipoFactura'].'</div>
                                            </div>
                                        </div>
                                        <div class="flex-grow-1 ms-3">
                                            <p class="text-muted my-1">'.$pendientes['FacturaExterna'].'</p>
                                            <div class="d-flex flex-wrap gap-2 align-items-center my-1">'.$pendientes['FacturaInterna'].'</div>
                                            <div class="d-flex gap-4 my-1 text-muted justify-content-start align-content-center">
                                                <div>
                                                    <div class="badge text-bg-danger">S/ '.number_format(round($pendientes['DeudaTotal'], 2), 2, '.', '').'</div>
                                                </div>
                                                <div>
                                                    <i class="mdi mdi-slash-forward text-primary me-1 align-bottom"></i>
                                                    <div class="badge text-bg-success">S/ '.number_format(round($pendientes['ImporteCondonar'], 2), 2, '.', '').'</div>
                                                </div>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                                <div class="collapse border-top border-top-dashed show" id="IDFact'.$pendientes['IDFacturaCondonacion'].'">
                                    <div class="card-body row col-12 d-flex justify-content-center align-items-center p-0 m-0 px-2">';
                                    
                                    $borderStatus = "";
                                    foreach($aprobadoresPorFactura[$pendientes['IDFacturaCondonacion']] as $aprobador)
                                    {
                                        if($aprobador['EstadoSolicitudAprobacion']=="APRO")
                                        {
                                            $borderStatus = "border-success";
                                        }
                                        else if($aprobador['EstadoSolicitudAprobacion']=="RECH")
                                        {
                                            $borderStatus = "border-danger";
                                        }
                                        else if($aprobador['EstadoSolicitudAprobacion']=="PEND")
                                        {
                                            $borderStatus = "border-gris-claro";
                                            // $borderStatus = "border-dark";
                                        }
                                        else if($aprobador['EstadoSolicitudAprobacion']=="CANC")
                                        {
                                            $borderStatus = "border-dark";
                                        }
                                        
                                        $html .= '<div class="card product '.$borderStatus.'" style="border-width: 1px;">
                                            <div class="card-body">
                                                <div class="row gy-3">
                                                    <div class="col-sm-auto">
                                                        <div class="text-lg-end">';
                                                        
                                                        if($aprobador['EstadoSolicitudAprobacion']=="APRO")
                                                        {
                                                            $html .= '<button class="badge bg-success border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Aprobado">
                                                                <i class="mdi mdi-check-circle align-bottom" style="font-size: 20px; color: #FFF;"></i>
                                                            </button>';
                                                        }
                                                        else if($aprobador['EstadoSolicitudAprobacion']=="RECH")
                                                        {
                                                            $html .= '<button class="badge bg-danger border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Rechazado">
                                                                <i class="mdi mdi-close-circle align-bottom" style="font-size: 20px; color: #FFF;"></i>
                                                            </button>';
                                                        }
                                                        else if($aprobador['EstadoSolicitudAprobacion']=="PEND")
                                                        {
                                                            $html .= '<button class="badge bg-gris-claro border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Pendiente">
                                                                <i class="mdi mdi-timer-sand align-bottom" style="font-size: 20px; color: #FFF;"></i>
                                                            </button>';
                                                        }
                                                        else if($aprobador['EstadoSolicitudAprobacion']=="CANC")
                                                        {
                                                            $html .= '<button class="badge bg-dark border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Cancelado">
                                                                <i class="mdi mdi-cancel align-bottom" style="font-size: 20px; color: #FFF;"></i>
                                                            </button>';
                                                        }
                                                        
                                                        $html .= '</div>
                                                    </div>
                                                    <div class="col-sm">
                                                        <h5 class="fs-14 text-truncate">'.ucwords(mb_strtolower($aprobador['Nombres'].' '.$aprobador['Apellidos'])).'</h5>
                                                        <ul class="list-inline text-muted">
                                                            <li class="list-inline-item">'.$aprobador['Cargo'].'</li>
                                                            <li class="list-inline-item">'.$aprobador['Matricula'].'</li>
                                                        </ul>
                                                    </div>
                                                    
                                                </div>
                                            </div>
                                            <!-- card body -->
                                            <div class="card-footer">
                                                <div class="row align-items-center gy-3">
                                                    <div class="col-sm">
                                                        <div class="d-flex flex-wrap my-n1">
                                                            <div>
                                                                <a class="d-block text-body p-1 px-2 comentarios-aprobador-factura-condonacion" data-bs-target="#mdlComentariosAprobacionCondonacion" data-aprobacion="'.$aprobador['IDAprobacion'].'" data-factura="'.$aprobador['IDFactura'].'"  style="cursor: pointer;">
                                                                    <i class="mdi mdi-message-reply text-muted align-bottom me-1"></i> Comentarios
                                                                </a>
                                                            </div>
                                                            <div>
                                                                <a class="d-block text-body p-1 px-2 cambiar-aprobador-factura-condonacion" data-bs-target="#mdlCambiarAprobadorFacturaCondonacion" data-aprobacion="'.$aprobador['IDAprobacion'].'" data-factura="'.$aprobador['IDFactura'].'" data-condonacion="'.$aprobador['IDCondonacion'].'"  style="cursor: pointer;">
                                                                    <i class="mdi mdi-account-convert text-muted align-bottom me-1"></i> Cambiar
                                                                </a>
                                                            </div>';
                                                            
                                                            if($aprobador['EstadoSolicitudAprobacion']=="RECH")
                                                            {
                                                                $html .= '<div>
                                                                    <a class="d-block text-body p-1 px-2 solicitar-reaprobacion" data-aprobacion="'.$aprobador['IDAprobacion'].'" data-condonacion="'.$idCondonacion.'" style="cursor: pointer"><i class="mdi mdi-inbox-arrow-up text-muted align-bottom me-1"></i> Solicitar reaprobación</a>
                                                                </div>';
                                                            }
                                                            
                                                            $html .= '<div></div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-auto">
                                                        <div class="d-flex align-items-center gap-2 text-muted">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end card footer -->
                                        </div>';
                                    }
                                    
                                    $html .= '</div>
                                    <div class="card-footer hstack gap-2">
                                        <button class="btn bg-warning btn-sm w-100 text-white datos-factura-condonacion" data-bs-target="#mdlFacturaCondonacion" data-form="#formFacturaCondonacion" data-id="'.$pendientes['IDFacturaCondonacion'].'" data-accion="editar" data-toggle="tooltip" data-placement="top" aria-label="Editar Condonación de Factura"><i class="mdi mdi-pencil-outline align-bottom me-1"></i> Editar</button>
                                        <button type="button" class="btn bg-dark btn-sm w-100 text-white cancelar-factura-condonar" data-condonacion="'.$idCondonacion.'" data-id="'.$pendientes['IDFacturaCondonacion'].'" data-interna="'.$pendientes['FacturaInterna'].'" data-externa="'.$pendientes['FacturaExterna'].'" ><i class="mdi mdi-cancel align-bottom me-1"></i> Cancelar</button>
                                        <button class="btn bg-rosa btn-sm w-100 text-white comentarios-factura-condonacion" data-bs-target="#mdlComentariosFacturaCondonacion" data-factura="'.$pendientes['IDFacturaCondonacion'].'"><i class="mdi mdi-message-reply align-bottom me-1"></i> Comentarios</button>
                                    </div>
                                </div>
                            </div>';
                        }
                    }
                    else
                    {
                        $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 justify-content-center align-items-center" style="border-radius: 10px;">
                            <div class="col-xxl-10 col-md-12 col-12 ">
                                <div class="alert alert-light alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                                    <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>NO SE ENCONTRÓ FACTURAS</strong> - No hay facturas pendientes.
                                </div>
                            </div>
                        </div>';
                    }
                    
                    $html .= '<!--end card-->
                    </div>
                </div>
                <!--end col-->';
                
                
                $html .= '<div class="col">
                    <div class="card">
                        <a class="card-body bg-success" data-bs-toggle="collapse" href="#facturasAprobadas" role="button" aria-expanded="true" aria-controls="facturasAprobadas">
                            <h5 class="card-title text-uppercase fw-semibold mb-1 fs-15 text-white">Facturas Aprobadas</h5>
                            <p class="text-white mb-0">Total: <span class="fw-medium">'.$cantidadEstadoFactura['APRO'].' Factura(s)</span></p>
                        </a>
                    </div>
                    <!--end card-->
                    <div class="collapse" id="facturasAprobadas" style="">';
                    
                    if(!empty($facturasPorEstado['APRO']))
                    {
                        foreach($facturasPorEstado['APRO'] as $aprobados)
                        {
                            $html .= '<div class="card mb-1">
                                <div class="card-body">
                                    <a class="d-flex align-items-center" data-bs-toggle="collapse" href="#IDFact'.$aprobados['IDFacturaCondonacion'].'" role="button" aria-expanded="false" aria-controls="IDFact'.$aprobados['IDFacturaCondonacion'].'">
                                        <div class="flex-shrink-0">
                                            <div class="avatar-md rounded">
                                                <div class="avatar-title border bg-light text-primary rounded text-uppercase fs-24">'.$aprobados['TipoFactura'].'</div>
                                            </div>
                                        </div>
                                        <div class="flex-grow-1 ms-3">
                                            <p class="text-muted my-1">'.$aprobados['FacturaExterna'].'</p>
                                            <div class="d-flex flex-wrap gap-2 align-items-center my-1">'.$aprobados['FacturaInterna'].'</div>
                                            <div class="d-flex gap-4 my-1 text-muted justify-content-start align-content-center">
                                                <div>
                                                    <div class="badge text-bg-danger">S/ '.number_format(round($aprobados['DeudaTotal'], 2), 2, '.', '').'</div>
                                                </div>
                                                <div>
                                                    <i class="mdi mdi-slash-forward text-primary me-1 align-bottom"></i>
                                                    <div class="badge text-bg-success">S/ '.number_format(round($aprobados['ImporteCondonar'], 2), 2, '.', '').'</div>
                                                </div>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                                <div class="collapse border-top border-top-dashed" id="IDFact'.$aprobados['IDFacturaCondonacion'].'">
                                    <div class="card-body row col-12 d-flex justify-content-center align-items-center p-0 m-0 px-2">';
                                    
                                    $borderStatus = "";
                                    foreach($aprobadoresPorFactura[$aprobados['IDFacturaCondonacion']] as $aprobador)
                                    {
                                        if($aprobador['EstadoSolicitudAprobacion']=="APRO")
                                        {
                                            $borderStatus = "border-success";
                                        }
                                        else if($aprobador['EstadoSolicitudAprobacion']=="RECH")
                                        {
                                            $borderStatus = "border-danger";
                                        }
                                        else if($aprobador['EstadoSolicitudAprobacion']=="PEND")
                                        {
                                            $borderStatus = "border-gris-claro";
                                            // $borderStatus = "border-dark";
                                        }
                                        else if($aprobador['EstadoSolicitudAprobacion']=="CANC")
                                        {
                                            $borderStatus = "border-dark";
                                        }
                                        
                                        $html .= '<div class="card product '.$borderStatus.'" style="border-width: 1px;">
                                            <div class="card-body">
                                                <div class="row gy-3">
                                                    <div class="col-sm-auto">
                                                        <div class="text-lg-end">';
                                                        
                                                        if($aprobador['EstadoSolicitudAprobacion']=="APRO")
                                                        {
                                                            $html .= '<button class="badge bg-success border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Aprobado">
                                                                <i class="mdi mdi-check-circle align-bottom" style="font-size: 20px; color: #FFF;"></i>
                                                            </button>';
                                                        }
                                                        else if($aprobador['EstadoSolicitudAprobacion']=="RECH")
                                                        {
                                                            $html .= '<button class="badge bg-danger border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Rechazado">
                                                                <i class="mdi mdi-close-circle align-bottom" style="font-size: 20px; color: #FFF;"></i>
                                                            </button>';
                                                        }
                                                        else if($aprobador['EstadoSolicitudAprobacion']=="PEND")
                                                        {
                                                            $html .= '<button class="badge bg-gris-claro border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Pendiente">
                                                                <i class="mdi mdi-timer-sand align-bottom" style="font-size: 20px; color: #FFF;"></i>
                                                            </button>';
                                                        }
                                                        else if($aprobador['EstadoSolicitudAprobacion']=="CANC")
                                                        {
                                                            $html .= '<button class="badge bg-dark border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Cancelado">
                                                                <i class="mdi mdi-cancel align-bottom" style="font-size: 20px; color: #FFF;"></i>
                                                            </button>';
                                                        }
                                                        
                                                        $html .= '</div>
                                                    </div>
                                                    <div class="col-sm">
                                                        <h5 class="fs-14 text-truncate">'.ucwords(mb_strtolower($aprobador['Nombres'].' '.$aprobador['Apellidos'])).'</h5>
                                                        <ul class="list-inline text-muted">
                                                            <li class="list-inline-item">'.$aprobador['Cargo'].'</li>
                                                            <li class="list-inline-item">'.$aprobador['Matricula'].'</li>
                                                        </ul>
                                                    </div>
                                                    
                                                </div>
                                            </div>
                                            <!-- card body -->
                                            <div class="card-footer">
                                                <div class="row align-items-center gy-3">
                                                    <div class="col-sm">
                                                        <div class="d-flex flex-wrap my-n1">
                                                            <div>
                                                                <a class="d-block text-body p-1 px-2 comentarios-aprobador-factura-condonacion" data-bs-target="#mdlComentariosAprobacionCondonacion" data-aprobacion="'.$aprobador['IDAprobacion'].'" data-factura="'.$aprobador['IDFactura'].'"  style="cursor: pointer;">
                                                                    <i class="mdi mdi-message-reply text-muted align-bottom me-1"></i> Comentarios
                                                                </a>
                                                            </div>';
                                                            
                                                            if($aprobador['EstadoSolicitudAprobacion']=="RECH")
                                                            {
                                                                $html .= '<div>
                                                                    <a class="d-block text-body p-1 px-2 solicitar-reaprobacion" data-aprobacion="'.$aprobador['IDAprobacion'].'" data-condonacion="'.$idCondonacion.'" style="cursor: pointer"><i class="mdi mdi-inbox-arrow-up text-muted align-bottom me-1"></i> Solicitar reaprobación</a>
                                                                </div>';
                                                            }
                                                            
                                                            $html .= '<div></div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-auto">
                                                        <div class="d-flex align-items-center gap-2 text-muted">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end card footer -->
                                        </div>';
                                    }
                                    
                                    $html .= '</div>
                                    <div class="card-footer hstack gap-2">
                                        <button class="btn bg-rosa btn-sm w-100 text-white comentarios-factura-condonacion" data-bs-target="#mdlComentariosFacturaCondonacion" data-factura="'.$aprobados['IDFacturaCondonacion'].'"><i class="mdi mdi-message-reply align-bottom me-1"></i> Comentarios</button>
                                    </div>
                                </div>
                            </div>';
                        }
                    }
                    else
                    {
                        $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 justify-content-center align-items-center" style="border-radius: 10px;">
                            <div class="col-xxl-10 col-md-12 col-12 ">
                                <div class="alert alert-success alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                                    <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>NO SE ENCONTRÓ FACTURAS</strong> - No hay facturas aprobadas.
                                </div>
                            </div>
                        </div>';
                    }
                    
                    $html .= '<!--end card-->
                    </div>
                </div>
                <!--end col-->
            </div>';
        }
        else 
		{
            $html = '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
	            <div class="col-xxl-10 col-md-12 col-12 ">
        	        <div class="alert alert-danger alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN SESIÓN</strong> - No hay sesión iniciada. Inicie sesión nuevamente.
                    </div>
                </div>
        	</div>';
		}
		
		echo $html;
    }
    
    public function recargarTablaAprobacionesCondonacion()
    {
        $resultado['data'] = array();
            
        if(isset($this->items['id']))
        {
            $idCondonacion = $this->request->getPost('idCondonacion');
            
            // ACCIONES
			$whereAprobadores = array(
			    'IDCondonacion' => $idCondonacion,
			    'Estado'        => "PEND",
			    'Aprobador'     => $this->items['id']
			);
			
            $listadoFacturas    = $this->condonacionesFacturasAprobadores->listarAprobadoresFacturaCondonacion($whereAprobadores);
            
            foreach($listadoFacturas as $key=>$facturas)
            {
                $decision = '<div class="d-flex justify-content-center">
                    <center class="content-center" style="position: relative; height: 40px;">
                        <input type="radio" id="rdbtnAprobarFacturaCondonacion'.$facturas['IDAprobacion'].'" name="rdbtnEstadoAprobacionFactura['.$facturas['IDAprobacion'].']" class="rdbtnEstadoAprobacionFactura rb-basico rb-aprobar" data-aprobacion="'.$facturas['IDAprobacion'].'" value="APRO" >
                        <label for="rdbtnAprobarFacturaCondonacion'.$facturas['IDAprobacion'].'"></label>
        			</center>
                    <center class="content-center" style="position: relative; height: 40px;">
                        <input type="radio" id="rdbtnRechazarFacturaCondonacion'.$facturas['IDAprobacion'].'" name="rdbtnEstadoAprobacionFactura['.$facturas['IDAprobacion'].']" class="rdbtnEstadoAprobacionFactura rb-basico rb-rechazar" data-aprobacion="'.$facturas['IDAprobacion'].'" value="RECH" >
                        <label for="rdbtnRechazarFacturaCondonacion'.$facturas['IDAprobacion'].'"></label>
        			</center>
                </div>';
                
                $observacion = '<input type="text" id="txtObservacionRechazoFacturaCondonar'.$facturas['IDAprobacion'].'" name="observacion['.$facturas['IDAprobacion'].']" class="form-control txtObservacionRechazoFacturaCondonar" disabled>';
                
                $resultado['data'][$key] = array(
                    'nro_contrato'      => (string) $facturas['NroContrato'],
    				'factura_interna'   => (string) $facturas['FacturaInterna'],
    				'factura_externa'   => (string) $facturas['FacturaExterna'],
                    'segmento'          => (string) $facturas['Segmento'],
    				'tipo_factura'      => (string) $facturas['TipoFactura'],
    				'deuda_total'       => (string) 'S/ '.number_format(round($facturas['DeudaTotal'], 2), 2, '.', ''),
    				'importe_condonar'  => (string) 'S/ '.number_format(round($facturas['ImporteCondonar'], 2), 2, '.', ''),
    				'decision'          => (string) $decision,
    				'observacion'       => (string) $observacion
    			);
            }
            
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado, JSON_NUMERIC_CHECK);
        }
        else 
		{
            $resultado['sesion'] = 0;
            
		    echo json_encode($resultado);
		}
    }
    
    public function recargarBitacoraCondonacion()
    {
        
        $html = '';
        
        if(isset($this->items['id']))
        {
            /*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
            */
    
            $msjError       = TRUE;
            $idCondonacion  = $this->request->getPost('idCondonacion');
            
            $arrayTitulos = array(
                "MODFACT"   => "Actualización de Condonación de Factura",
                "DECIFACT"  => "Decisión de Aprobación de Condonación",
                "ESTFACT"   => "Cambio de Estado de Factura",
                "COMENFACT" => "Comentario de Factura",
                "COMENDECIFACT" => "Comentario de Decisión de Aprobación de Condonación",
                "COMENCOND" => "Comentario de Solicitud"
            );
            
            $arrayIconos = array(
                "APRO"  => '<span class="badge bg-success border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Aprobado"><i class="mdi mdi-check-circle align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "RECH"  => '<span class="badge bg-danger border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Rechazado"><i class="mdi mdi-close-circle align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "PEND"  => '<span class="badge bg-gris-claro border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Pendiente"><i class="mdi mdi-timer-sand align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "CANC"  => '<span class="badge bg-dark border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Cancelado"><i class="mdi mdi-cancel align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "COME"  => '<span class="badge bg-come border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Comentario"><i class="mdi mdi-comment align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "MODFACT"  => '<span class="badge bg-orange border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Comentario"><i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i></span>'
            );
            
            /*
            * ----------------------------
            * CONSULTAS SQL
            * ----------------------------
            */
            
            $arrayCondonacion = array(
                'idCondonacion'  => $idCondonacion
            );
    
            $bitacora   = $this->condonacionesBitacora->listarBitacoraCondonacion($arrayCondonacion);
            
            /*
            * ----------------------------
            * ARMAR HTML
            * ----------------------------
            */
            
            $fechaActual = '';
            
            if(!empty($bitacora))
            {
                $html .= '<div class="timeline-2 p-3" style="background-color: white;">';
                    
                    foreach ($bitacora as $index => $evento)
                    {
                        $esNuevaFecha = $fechaActual !== $evento['Fecha'];
                        if ($esNuevaFecha) 
                        {
                            // Cierra contenedor anterior si hay uno abierto
                            if ($fechaActual !== '') 
                            {
                                $html .= '</div>'; // cierre de .timeline-continue
                            }
                
                            // Actualiza la fecha actual
                            $fechaActual = $evento['Fecha'];
                            
                             $html .= '<div class="timeline-year">
                                <p style="box-shadow: 4px 4px #8A8C8E;">'.date('d M Y', strtotime($evento['Fecha'])).'</p>
                            </div>
                            <div class="timeline-continue">';
                        }
                        
                        $html .= '<div class="row timeline-right">
                            <div class="col-12">
                                <p class="timeline-date">'.$evento['Hora'].'</p>
                            </div>
                            <div class="col-12">
                                <div class="timeline-box" style="box-shadow: 4px 4px #8A8C8E;">
                                    <div class="timeline-text">
                                        <h5>'.(isset($arrayIconos[$evento['ValorBitacora']]) || isset($arrayIconos[$evento['Accion']]) ? (isset($arrayIconos[$evento['ValorBitacora']]) ? $arrayIconos[$evento['ValorBitacora']] : $arrayIconos[$evento['Accion']] ) : '<span class="badge bg-warning border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Registro de Actividad"><i class="mdi mdi-star align-bottom" style="font-size: 20px; color: #FFF;"></i></span>' ).' '.$arrayTitulos[$evento['Accion']].' 
                                            <div class="badge text-secondary">'.$evento['FacturaInterna'].'</div>
                                            <i class="mdi mdi-slash-forward text-primary me-1 align-bottom"></i><div class="badge text-secondary">'.$evento['FacturaExterna'].'</div>
                                        </h5>
                                        <p class="text-muted my-2">'.$evento['Comentario'].'</p>
                                        <small class="text-muted">Registrado por: '.ucwords(mb_strtolower($evento['Nombres'].' '.$evento['Apellidos'])).'</small>
                                    </div>
                                </div>
                            </div>
                        </div>';
                        
                        // Si es el último evento, cerramos .timeline-continue
                        if ($index === array_key_last($bitacora)) 
                        {
                            $html .= '</div>'; // cierre de .timeline-continue
                        }
                    }
                    
                $html .= '</div>';
            }
            else
            {
                $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 justify-content-center align-items-center" style="border-radius: 10px;">
                    <div class="col-xxl-10 col-md-12 col-12 ">
                        <div class="alert alert-dark alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                            <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>NO SE ENCONTRÓ REGISTRO DE BITÁCORA</strong> - Aún no hay movimientos en la condonación.
                        </div>
                    </div>
                </div>';
            }
        }
        else
		{
            $html = '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
	            <div class="col-xxl-10 col-md-12 col-12 ">
        	        <div class="alert alert-danger alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN SESIÓN</strong> - No hay sesión iniciada. Inicie sesión nuevamente.
                    </div>
                </div>
        	</div>';
		}
		
		echo $html;
    }
    
    public function comentariosAprobadorFacturaCondonacion()
    {
        $html = '';
        
        if(isset($this->items['id']))
        {
            /*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
            */
    
            $msjError       = TRUE;
            $idAprobacion   = $this->request->getPost('idAprobacion');
            
            $arrayTitulos = array(
                "MODFACT"   => "Actualización de Condonación de Factura",
                "DECIFACT"  => "Decisión de Aprobación de Condonación",
                "ESTFACT"   => "Cambio de Estado de Factura",
                "COMENFACT" => "Comentario de Factura",
                "COMENDECIFACT" => "Comentario de Decisión de Aprobación de Condonación",
                "COMENCOND" => "Comentario de Solicitud"
            );
            
            $arrayIconos = array(
                "APRO"  => '<span class="badge bg-success border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Aprobado"><i class="mdi mdi-check-circle align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "RECH"  => '<span class="badge bg-danger border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Rechazado"><i class="mdi mdi-close-circle align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "PEND"  => '<span class="badge bg-gris-claro border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Pendiente"><i class="mdi mdi-timer-sand align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "CANC"  => '<span class="badge bg-dark border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Cancelado"><i class="mdi mdi-cancel align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "COME"  => '<span class="badge bg-come border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Comentario"><i class="mdi mdi-comment align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "MODFACT"  => '<span class="badge bg-orange border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Comentario"><i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i></span>'
            );
            
            
            /*
            * ----------------------------
            * CONSULTAS SQL
            * ----------------------------
            */
            
            $arrayCondonacion = array(
                'idAprobacion'  => $idAprobacion
            );
    
            $bitacora   = $this->condonacionesBitacora->listarBitacoraCondonacion($arrayCondonacion);
            
            /*
            * ----------------------------
            * ARMAR HTML
            * ----------------------------
            */
            
            $fechaActual = '';
            
            if(!empty($bitacora))
            {
                // $html .= '<div class="timeline-2 p-3" style="background-color: white;">';
                
                // foreach ($bitacora as $index => $evento)
                // {
                //     $esNuevaFecha = $fechaActual !== $evento['Fecha'];
                //     if ($esNuevaFecha) 
                //     {
                //         // Cierra contenedor anterior si hay uno abierto
                //         if ($fechaActual !== '') 
                //         {
                //             $html .= '</div>'; // cierre de .timeline-continue
                //         }
            
                //         // Actualiza la fecha actual
                //         $fechaActual = $evento['Fecha'];
                        
                //          $html .= '<div class="timeline-year">
                //             <p style="box-shadow: 4px 4px #8A8C8E;">'.date('d M Y', strtotime($evento['Fecha'])).'</p>
                //         </div>
                //         <div class="timeline-continue">';
                //     }
                    
                //     $html .= '<div class="row timeline-right">
                //         <div class="col-12">
                //             <p class="timeline-date">'.$evento['Hora'].'</p>
                //         </div>
                //         <div class="col-12">
                //             <div class="timeline-box" style="box-shadow: 4px 4px #8A8C8E;">
                //                 <div class="timeline-text">
                //                     <h5>'.(isset($arrayIconos[$evento['ValorBitacora']]) || isset($arrayIconos[$evento['Accion']]) ? (isset($arrayIconos[$evento['ValorBitacora']]) ? $arrayIconos[$evento['ValorBitacora']] : $arrayIconos[$evento['Accion']] ) : '<span class="badge bg-warning border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Registro de Actividad"><i class="mdi mdi-star align-bottom" style="font-size: 20px; color: #FFF;"></i></span>' ).' '.$arrayTitulos[$evento['Accion']].' 
                //                         <div class="badge text-secondary">'.$evento['FacturaInterna'].'</div>
                //                         <i class="mdi mdi-slash-forward text-primary me-1 align-bottom"></i><div class="badge text-secondary">'.$evento['FacturaExterna'].'</div>
                //                     </h5>
                //                     <p class="text-muted my-2">'.$evento['Comentario'].'</p>
                //                     <small class="text-muted">Registrado por: '.ucwords(mb_strtolower($evento['Nombres'].' '.$evento['Apellidos'])).'</small>
                //                 </div>
                //             </div>
                //         </div>
                //     </div>';
                    
                //     // Si es el último evento, cerramos .timeline-continue
                //     if ($index === array_key_last($bitacora)) 
                //     {
                //         $html .= '</div>'; // cierre de .timeline-continue
                //     }
                // }
                
                // $html .= '</div>';
                
                foreach ($bitacora as $index => $evento)
                {
                    $facturaInterna = !empty($evento['FacturaInterna']) ? '<span class="badge bg-info text-white me-1">'.$evento['FacturaInterna'].'</span>' : '';
                    $facturaExterna = !empty($evento['FacturaExterna']) ? '<span class="badge bg-secondary text-white me-1">'.$evento['FacturaExterna'].'</span>' : '';
                    
                    // Título acción
                    $tituloAccion = '<span class="badge bg-primary-subtle text-primary fw-semibold ms-auto">'.$arrayTitulos[$evento['Accion']].'</span>';

                    $html .= '<div class="d-flex mb-4 p-3 border rounded" style="background-color: #ffffff; box-shadow: 4px 4px #8A8C8E;">
                        <div class="flex-shrink-0 me-3 d-flex justify-content-center align-items-center">
                            <h5>'.(isset($arrayIconos[$evento['ValorBitacora']]) || isset($arrayIconos[$evento['Accion']]) ? (isset($arrayIconos[$evento['ValorBitacora']]) ? $arrayIconos[$evento['ValorBitacora']] : $arrayIconos[$evento['Accion']] ) : '<span class="badge bg-warning border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Registro de Actividad"><i class="mdi mdi-star align-bottom" style="font-size: 20px; color: #FFF;"></i></span>' ).'</h5>
                        </div>
                        <div class="flex-grow-1">
                            <div class="d-flex justify-content-between align-items-center mb-1">
                                <h6 class="mb-0">'.ucwords(mb_strtolower($evento['Nombres'].' '.$evento['Apellidos'])).'</h6>
                                <small class="text-muted">'.date('d M Y', strtotime($evento['Fecha'])).' - '.$evento['Hora'].'</small>
                            </div>
                            <p class="text-muted my-2">'.$evento['Comentario'].'</p>
                            <div class="d-flex align-items-center justify-content-between">
                                <div>'.$facturaInterna.$facturaExterna.'</div>
                                '.$tituloAccion.'
                            </div>
                        </div>
                    </div>';
                }
            }
            else
            {
                $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 justify-content-center align-items-center" style="border-radius: 10px;">
                    <div class="col-xxl-10 col-md-12 col-12 ">
                        <div class="alert alert-dark alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                            <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>NO SE ENCONTRÓ COMENTARIOS DE APROBADOR</strong> - Aún no hay decisión en la aprobación.
                        </div>
                    </div>
                </div>';
            }
        }
        else 
		{
            $html = '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
	            <div class="col-xxl-10 col-md-12 col-12 ">
        	        <div class="alert alert-danger alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN SESIÓN</strong> - No hay sesión iniciada. Inicie sesión nuevamente.
                    </div>
                </div>
        	</div>';
		}
		
		echo $html;
    }
    
    public function comentariosFacturaCondonacion()
    {
        $html = '';
        
        if(isset($this->items['id']))
        {
            /*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
            */
    
            $msjError   = TRUE;
            $idFactura  = $this->request->getPost('idFactura');
            
            $arrayTitulos = array(
                "MODFACT"   => "Actualización de Condonación de Factura",
                "DECIFACT"  => "Decisión de Aprobación de Condonación",
                "ESTFACT"   => "Cambio de Estado de Factura",
                "COMENFACT" => "Comentario de Factura",
                "COMENDECIFACT" => "Comentario de Decisión de Aprobación de Condonación",
                "COMENCOND" => "Comentario de Solicitud"
            );
            
            $arrayIconos = array(
                "APRO"  => '<span class="badge bg-success border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Aprobado"><i class="mdi mdi-check-circle align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "RECH"  => '<span class="badge bg-danger border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Rechazado"><i class="mdi mdi-close-circle align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "PEND"  => '<span class="badge bg-gris-claro border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Pendiente"><i class="mdi mdi-timer-sand align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "CANC"  => '<span class="badge bg-dark border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Cancelado"><i class="mdi mdi-cancel align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "COME"  => '<span class="badge bg-come border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Comentario"><i class="mdi mdi-comment align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "MODFACT"  => '<span class="badge bg-orange border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Comentario"><i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i></span>'
            );
            
            /*
            * ----------------------------
            * CONSULTAS SQL
            * ----------------------------
            */
            
            $arrayCondonacion = array(
                'idFactura'  => $idFactura
            );
    
            $bitacora   = $this->condonacionesBitacora->listarBitacoraCondonacion($arrayCondonacion);
            
            /*
            * ----------------------------
            * ARMAR HTML
            * ----------------------------
            */
            
            $fechaActual = '';
            
            if(!empty($bitacora))
            {
                $html .= '<div class="timeline-2 p-3" style="background-color: white;">';
                
                foreach ($bitacora as $index => $evento)
                {
                    $esNuevaFecha = $fechaActual !== $evento['Fecha'];
                    if ($esNuevaFecha) 
                    {
                        // Cierra contenedor anterior si hay uno abierto
                        if ($fechaActual !== '') 
                        {
                            $html .= '</div>'; // cierre de .timeline-continue
                        }
            
                        // Actualiza la fecha actual
                        $fechaActual = $evento['Fecha'];
                        
                         $html .= '<div class="timeline-year">
                            <p style="box-shadow: 4px 4px #8A8C8E;">'.date('d M Y', strtotime($evento['Fecha'])).'</p>
                        </div>
                        <div class="timeline-continue">';
                    }
                    
                    $html .= '<div class="row timeline-right">
                        <div class="col-12">
                            <p class="timeline-date">'.$evento['Hora'].'</p>
                        </div>
                        <div class="col-12">
                            <div class="timeline-box" style="box-shadow: 4px 4px #8A8C8E;">
                                <div class="timeline-text">
                                    <h5>'.(isset($arrayIconos[$evento['ValorBitacora']]) || isset($arrayIconos[$evento['Accion']]) ? (isset($arrayIconos[$evento['ValorBitacora']]) ? $arrayIconos[$evento['ValorBitacora']] : $arrayIconos[$evento['Accion']] ) : '<span class="badge bg-warning border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Registro de Actividad"><i class="mdi mdi-star align-bottom" style="font-size: 20px; color: #FFF;"></i></span>' ).' '.$arrayTitulos[$evento['Accion']].' 
                                        <div class="badge text-secondary">'.$evento['FacturaInterna'].'</div>
                                        <i class="mdi mdi-slash-forward text-primary me-1 align-bottom"></i><div class="badge text-secondary">'.$evento['FacturaExterna'].'</div>
                                    </h5>
                                    <p class="text-muted my-2">'.$evento['Comentario'].'</p>
                                    <small class="text-muted">Registrado por: '.ucwords(mb_strtolower($evento['Nombres'].' '.$evento['Apellidos'])).'</small>
                                </div>
                            </div>
                        </div>
                    </div>';
                    
                    // Si es el último evento, cerramos .timeline-continue
                    if ($index === array_key_last($bitacora)) 
                    {
                        $html .= '</div>'; // cierre de .timeline-continue
                    }
                }
                
                $html .= '</div>';
            }
            else
            {
                $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 justify-content-center align-items-center" style="border-radius: 10px;">
                    <div class="col-xxl-10 col-md-12 col-12 ">
                        <div class="alert alert-dark alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                            <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>NO SE ENCONTRÓ COMENTARIOS EN LA FACTURA</strong> - Aún no hay registro de cambios para la condonación de la factura.
                        </div>
                    </div>
                </div>';
            }
        }
        else 
		{
            $html = '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
	            <div class="col-xxl-10 col-md-12 col-12 ">
        	        <div class="alert alert-danger alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN SESIÓN</strong> - No hay sesión iniciada. Inicie sesión nuevamente.
                    </div>
                </div>
        	</div>';
		}
		
		echo $html;
    }
    
    public function registrarComentariosFacturaCondonacion()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        $error = '';
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        //Información de Condonación
        
        $comentario             = $this->request->getPost('txtComentariosFactura_rcomfaccond');
        $idCondonacion          = $this->request->getPost('txtIDCondonacion_rcomfaccond');
        $idFacturaCondonacion   = $this->request->getPost('txtIDFacturaCondonacion_rcomfaccond');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error .= $this->complementos->validaCampo($idCondonacion, 'required|trim|numeric', 'ID Condonacion');
        $error .= $this->complementos->validaCampo($idFacturaCondonacion, 'required|trim|numeric', 'ID Factura');
        $error .= $this->complementos->validaCampo($comentario, 'required|trim', 'Comentario');
        
        if ($error != '') 
        {
            $message = sprintf($this->mensajeError->msg201, $error);
            $mensaje = $this->alertas->alertaError($message);
            
            $resultado = array(
    			'result'    => (string) 0,
    			'mensaje'   => (string) $mensaje
    		);
    		
    		echo json_encode($resultado);
    		
            EXIT;
        }
        
        /*
        * ----------------------------
        * INSERTAR COMENTARIO
        * ----------------------------
        */

        $data = array (
            'IDCondonacion'         => $idCondonacion,
            'IDFacturaCondonacion'  => $idFacturaCondonacion,
            'Accion'                => "COMENFACT",
            'ValorBitacora'         => "COME",
            'Comentario'            => $comentario,
            'UsuarioRegistra'       => $this->items['id'],
            'FechaRegistra'         => $fechaActual,    
            'Localhost'             => $this->request->getIPAddress(),
            'Estado'                => 'A'
        );

        $lastId = $this->condonacionesBitacora->insert($data, TRUE);

		if($lastId !== FALSE)
		{
		    $message = sprintf($this->mensajeError->msg201, "Se registró el comentario exitosamente.");
            $mensaje = $this->alertas->alertaExito($message);
            
            $resultado = array(
    			'result'    => (string) 1,
    			'mensaje'   => (string) $mensaje
    		);
		}
        else
        {
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el comentario. Inténtelo luego.");
            $mensaje = $this->alertas->alertaError($message);
            
            $resultado = array(
    			'result'    => (string) 0,
    			'mensaje'   => (string) $mensaje
    		);
        }
        
        echo json_encode($resultado);
        EXIT;
    }
    
    public function registrarComentariosAprobadorCondonacion()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        $error = '';
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        //Información de Condonación
        
        $comentario             = $this->request->getPost('txtComentariosFactura_rcomaprcond');
        $idCondonacion          = $this->request->getPost('txtIDCondonacion_rcomaprcond');
        $idFacturaCondonacion   = $this->request->getPost('txtIDFacturaCondonacion_rcomaprcond');
        $idAprobacion           = $this->request->getPost('txtIDAprobacionCondonacion_rcomaprcond');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error .= $this->complementos->validaCampo($idCondonacion, 'required|trim|numeric', 'ID Condonacion');
        $error .= $this->complementos->validaCampo($idFacturaCondonacion, 'required|trim|numeric', 'ID Factura');
        $error .= $this->complementos->validaCampo($idAprobacion, 'required|trim|numeric', 'ID Aprobación');
        $error .= $this->complementos->validaCampo($comentario, 'required|trim', 'Comentario');
        
        if ($error != '') 
        {
            $message = sprintf($this->mensajeError->msg201, $error);
            $mensaje = $this->alertas->alertaError($message);
            
            $resultado = array(
    			'result'    => (string) 0,
    			'mensaje'   => (string) $mensaje
    		);
    		
    		echo json_encode($resultado);
    		
            EXIT;
        }
        
        /*
        * ----------------------------
        * INSERTAR COMENTARIO
        * ----------------------------
        */

        $data = array (
            'IDCondonacion'         => $idCondonacion,
            'IDFacturaCondonacion'  => $idFacturaCondonacion,
            'IDAprobacion'          => $idAprobacion,
            'Accion'                => "COMENDECIFACT",
            'ValorBitacora'         => "COME",
            'Comentario'            => $comentario,
            'UsuarioRegistra'       => $this->items['id'],
            'FechaRegistra'         => $fechaActual,    
            'Localhost'             => $this->request->getIPAddress(),
            'Estado'                => 'A'
        );

        $lastId = $this->condonacionesBitacora->insert($data, TRUE);

		if($lastId !== FALSE)
		{
		    $message = sprintf($this->mensajeError->msg201, "Se registró el comentario exitosamente.");
            $mensaje = $this->alertas->alertaExito($message);
            
            $resultado = array(
    			'result'    => (string) 1,
    			'mensaje'   => (string) $mensaje
    		);
		}
        else
        {
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el comentario. Inténtelo luego.");
            $mensaje = $this->alertas->alertaError($message);
            
            $resultado = array(
    			'result'    => (string) 0,
    			'mensaje'   => (string) $mensaje
    		);
        }
        
        echo json_encode($resultado);
        EXIT;
    }
    
    public function validarBotonPeticionCondonacion()
    {
        if(isset($this->items['id']))
        {
            $idCondonacion = $this->request->getPost('idCondonacion');
            
			// ACCIONES
			$whereCondonacion = array(
			    'IDCondonacion'  => $idCondonacion
			);
			
            $condonacion    = $this->condonaciones->obtenerCondonacion($whereCondonacion);
            $countTotal     = $this->condonacionesFacturas->select('COUNT(*) as TOTAL')->where('IDCondonacion', $idCondonacion)->whereNotIn('Estado', array("CANC"))->first();
            $countAprobado  = $this->condonacionesFacturas->select('COUNT(*) as TOTAL')->where(array('IDCondonacion' => $idCondonacion, 'Estado' => 'APRO'))->whereNotIn('Estado', array("CANC"))->first();
            
            if( ($condonacion['IDPeticion'] != '' && $condonacion['IDPeticion'] != null) || $countAprobado['TOTAL'] < $countTotal['TOTAL'] )
            {
                return "false";
            }
            else
            {
                return "true";
            }
        }
        else
		{
            return "false";
		}
    }
    
    public function mostrarAprobadoresGeneral()
    {
        $html = '';
        
        if(isset($this->items['id']))
        {
            /*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
            */
    
            $msjError   = TRUE;
            $idCondonacion  = $this->request->getPost('idCondonacion');
            
            $arrayCondonacion = array(
                'IDCondonacion'  => $idCondonacion
            );
    
            $listadoAprobadores = $this->condonacionesFacturasAprobadores->cantidadFacturasEstadoAprobador($arrayCondonacion);
            
            if(!empty($listadoAprobadores))
            {
                foreach($listadoAprobadores as $aprobadores)
                {
                    $html .= '<div class="d-flex align-items-center">
                        <div class="avatar-xs flex-shrink-0 me-3">
                            <div class="avatar-xs rounded">
                                <div class="avatar-title border bg-light text-primary rounded-circle text-uppercase fs-15">
                                    <span class="mdi mdi-account"></span>
                                </div>
                            </div>
                        </div>
                        <div class="flex-grow-1">
                            <h5 class="fs-13 mb-0">'.ucwords(mb_strtolower($aprobadores['Nombres'].' '.$aprobadores['Apellidos'])).'</h5>
                        </div>
                        <div class="flex-shrink-0 ver-facturas-aprobador" data-bs-target="#mdlFacturasAprobador" data-form="#formFacturasAprobador" data-condonacion="'.$idCondonacion.'" data-usuario="'.$aprobadores['IDUsuarioAprobacion'].'">
                            <div class="d-flex align-items-center gap-1">
                                <div class="avatar-xs">
                                    <div class="avatar-title border bg-dark border-dark border-opacity-25 rounded-2 fs-14">
                                        '.$aprobadores['CANC'].'
                                    </div>
                                </div>
                                <div class="avatar-xs">
                                    <div class="avatar-title border bg-danger border-danger border-opacity-25 rounded-2 fs-14">
                                        '.$aprobadores['RECH'].'
                                    </div>
                                </div>
                                <div class="avatar-xs">
                                    <div class="avatar-title border bg-gris-claro border-opacity-25 rounded-2 fs-14">
                                        '.$aprobadores['PEND'].'
                                    </div>
                                </div>
                                <div class="avatar-xs">
                                    <div class="avatar-title border bg-success border-success border-opacity-25 rounded-2 fs-14">
                                        '.$aprobadores['APRO'].'
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>';
                }
                
            }
            else
            {
                $html = '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
    	            <div class="col-xxl-10 col-md-12 col-12 ">
            	        <div class="alert alert-warning alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                            <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN APROBADORES</strong> - No hay aprobadores para las facturas de esta condonación.
                        </div>
                    </div>
            	</div>';
            }
        }
        else 
		{
            $html = '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
	            <div class="col-xxl-10 col-md-12 col-12 ">
        	        <div class="alert alert-danger alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN SESIÓN</strong> - No hay sesión iniciada. Inicie sesión nuevamente.
                    </div>
                </div>
        	</div>';
		}
		
		echo $html;
    }
    
    public function mostrarFacturasUsuarioAprobador()
    {
        $html = '';
        
        if(isset($this->items['id']))
        {
            
            $msjError   = TRUE;
            $idCondonacion  = $this->request->getPost('idCondonacion');
            $idUsuario      = $this->request->getPost('idUsuario');
            
            $arrayCondonacion = array(
                'IDCondonacion' => $idCondonacion,
                'Aprobador'     => $idUsuario
            );
    
            $listadoFacturas = $this->condonacionesFacturasAprobadores->listarAprobadoresFacturaCondonacion($arrayCondonacion);
            
            if(!empty($listadoFacturas))
            {
                $estadosFactura = array_column($listadoFacturas, 'EstadoFactura');
                
                $html .= '<div class="col-lg-12 p-3">
                    <div class="card m-0" style="box-shadow: 2px 2px #212529;">
                        <div class="card-header">
                            <div class="d-flex align-items-center flex-wrap gap-2">
                                <div class="flex-grow-1"><h4 class="m-0">'.ucwords(mb_strtolower($listadoFacturas[0]['Nombres'].' '.$listadoFacturas[0]['Apellidos'])).'</h4></div>
                                <div class="flex-shrink-0">
                                    <div class="hstack text-nowrap gap-2">';
                                        if(in_array("APRO", $estadosFactura))
                                        {
                                            $html .= '<button type="button" class="btn bg-celeste px-2 py-1" data-tooltip="tooltip" title="Enviar correo con aprobaciones pendientes" data-condonacion="'.$idCondonacion.'" data-aprobador="'.$idUsuario.'" onclick="return enviarAvisoFacturasPendientesAprobar(this)">
                                                <i class="mdi mdi-email-fast-outline" style="font-size: 18px; color: #FFF"></i>
                                            </button>';
                                        }
                                    $html .= '</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row m-0 w-100" style="height: 70vh; flex: 1 1 auto;">
                    <div class="col-xl-4 col-12 d-flex flex-column px-3" style="height: 100%; display: flex; flex-direction: column;">
                        <div class="card flex-fill d-flex flex-column" style="flex: 1 1 auto; display: flex; flex-direction: column; min-height: 0; box-shadow: 2px 2px #212529;">
                            <div class="card-header">
                                <div class="d-flex">
                                    <h5 class="card-title flex-grow-1 mb-0">Facturas</h5>
                                </div>
                            </div>
                            <div class="card-body simplebar-auto-init py-0" style="flex: 1 1 auto; min-height: 0;">';
                    foreach($listadoFacturas as $facturas)
                    {
                        if($facturas['EstadoSolicitudAprobacion'] == "APRO")
                        {
                            $bgaprobacion = "bg-success-25";
                        }
                        else if($facturas['EstadoSolicitudAprobacion'] == "RECH")
                        {
                            $bgaprobacion = "bg-danger-25";
                        }
                        else if($facturas['EstadoSolicitudAprobacion'] == "CANC")
                        {
                            $bgaprobacion = "bg-dark-25";
                        }
                        else if($facturas['EstadoSolicitudAprobacion'] == "PEND")
                        {
                            $bgaprobacion = "bg-gris-claro-25";
                        }
                        
                        $html .= '<div class="card-body my-2 p-2 '.$bgaprobacion.' d-flex justify-content-center visualizar-informacion-factura-aprobador" data-aprobacion="'.$facturas['IDAprobacion'].'" data-bg-original="'.$bgaprobacion.'" style="border-radius: 10px; cursor: pointer;">
                            <a class="d-flex align-items-center">
                                <div class="flex-shrink-0">
                                    <div class="avatar-sm rounded-circle">
                                        <div class="avatar-title border bg-light text-primary rounded-circle text-uppercase fs-24">'.$facturas['TipoFactura'].'</div>
                                    </div>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <p class="my-1 color-black">'.$facturas['FacturaExterna'].'</p>
                                    <div class="d-flex flex-wrap gap-2 align-items-center my-1">'.$facturas['FacturaInterna'].'</div>
                                    <div class="d-flex gap-4 my-1 text-muted justify-content-start align-content-center">
                                        <div>
                                            <div class="badge text-bg-info me-2">S/ '.number_format(round($facturas['DeudaTotal'], 2), 2, '.', '').'</div> | 
                                            <div class="badge text-bg-primary ms-2">S/ '.number_format(round($facturas['ImporteCondonar'], 2), 2, '.', '').'</div>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        </div>';
                    }
                    $html .= '</div>
                        </div>
                    </div>
                    <div class="col-xl-8 col-12 d-flex flex-column px-3" style="height: 100%; display: flex; flex-direction: column;">
                        <div class="card flex-fill d-flex flex-column" style="flex: 1 1 auto; display: flex; flex-direction: column; min-height: 0; box-shadow: 2px 2px #212529;">
                            <div class="card-header">
                                <div class="d-flex">
                                    <h5 class="card-title flex-grow-1 mb-0">Acciones</h5>
                                </div>
                            </div>
                            <div class="card-body simplebar-auto-init py-0" id="ctnAccionesFacturaAprobador" style="flex: 1 1 auto; min-height: 0;">
                                <div class="alert alert-dark alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                                    <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SELECCIONE UNA FACTURA PARA MOSTRAR LA INFORMACIÓN</strong>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>';
            }
            else
            {
                $html = '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
    	            <div class="col-xxl-10 col-md-12 col-12 ">
            	        <div class="alert alert-warning alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                            <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN FACTURAS</strong> - No se encontró facturas para este aprobador
                        </div>
                    </div>
            	</div>';
            }
            
        }
        else 
		{
            $html = '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
	            <div class="col-xxl-10 col-md-12 col-12 ">
        	        <div class="alert alert-danger alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN SESIÓN</strong> - No hay sesión iniciada. Inicie sesión nuevamente.
                    </div>
                </div>
        	</div>';
		}
		
		echo $html;
    }
    
    public function visualizarInformacionFacturaAprobador()
    {
        $html = '';
        
        if(isset($this->items['id']))
        {
            /*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
            */
    
            $msjError   = TRUE;
            $idAprobacion  = $this->request->getPost('idAprobacion');
            
            $arrayTitulos = array(
                "MODFACT"   => "Actualización de Condonación de Factura",
                "DECIFACT"  => "Decisión de Aprobación de Condonación",
                "ESTFACT"   => "Cambio de Estado de Factura",
                "COMENFACT" => "Comentario de Factura",
                "COMENDECIFACT" => "Comentario de Decisión de Aprobación de Condonación",
                "COMENCOND" => "Comentario de Solicitud"
            );
            
            $arrayIconos = array(
                "APRO"  => '<span class="badge bg-success border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Aprobado"><i class="mdi mdi-check-circle align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "RECH"  => '<span class="badge bg-danger border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Rechazado"><i class="mdi mdi-close-circle align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "PEND"  => '<span class="badge bg-gris-claro border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Pendiente"><i class="mdi mdi-timer-sand align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "CANC"  => '<span class="badge bg-dark border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Cancelado"><i class="mdi mdi-cancel align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "COME"  => '<span class="badge bg-come border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Comentario"><i class="mdi mdi-comment align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "MODFACT"  => '<span class="badge bg-orange border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Comentario"><i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i></span>'
            );
            
            $arrayFactura = array(
                'IDAprobacion'  => $idAprobacion
            );
            
            $informacionFactura = $this->condonacionesFacturasAprobadores->obtenerAprobadorFacturaCondonacion($arrayFactura);
            
            $arrayComentarios = array(
                'idAprobacion'  => $idAprobacion
            );
    
            $comentarios   = $this->condonacionesBitacora->listarBitacoraCondonacion($arrayComentarios);
            
            if(!empty($informacionFactura))
            {
                $bgFondoEstadoFactura = $informacionFactura['EstadoFactura'] == "APRO" ? 'bg-success' : ($informacionFactura['EstadoFactura'] == "RECH" ? 'bg-danger' : ($informacionFactura['EstadoFactura'] == "PEND" ? 'bg-gris-claro' : ($informacionFactura['EstadoFactura'] == "CANC" ? 'bg-dark' : 'bg-info'))) ;
                $textoEstadoFactura = $informacionFactura['EstadoFactura'] == "APRO" ? 'APROBADO' : ($informacionFactura['EstadoFactura'] == "RECH" ? 'RECHAZADO' : ($informacionFactura['EstadoFactura'] == "PEND" ? 'PENDIENTE' : ($informacionFactura['EstadoFactura'] == "CANC" ? 'CANCELADO' : 'SIN INFORMACIÓN'))) ;
                
                $html .= '<!-- Nav tabs -->
                <ul class="nav nav-tabs nav-justified nav-border-top nav-border-top-success mb-3" role="tablist">
                    <li class="nav-item" role="presentation">
                        <a class="nav-link active" data-bs-toggle="tab" href="#nav-factura-aprobador" role="tab" aria-selected="true">
                            <i class="ri-home-5-line align-middle me-1"></i> Factura
                        </a>
                    </li>
                    <li class="nav-item" role="presentation">
                        <a class="nav-link" data-bs-toggle="tab" href="#nav-comentarios-factura-aprobador" role="tab" aria-selected="false" tabindex="-1">
                            <i class="ri-user-line me-1 align-middle"></i> Comentarios
                        </a>
                    </li>
                </ul>
                <div class="tab-content text-muted" style="background-color: transparent;">
                    <div class="tab-pane active show" id="nav-factura-aprobador" role="tabpanel" style="background-color: transparent!important">
                        <div class="card" style="border: 1px solid #9B9B9B;">
                            <div class="card-header">
                                <h6 class="card-title fw-semibold mb-0">Información de Factura</h6>
                            </div>
                            <form id="formFacturaCondonacion" class="formularioFacturaCondonacion" autocomplete="off" action="'.$this->items['baseUrl'].'/actualizar-factura-condonacion/'.$informacionFactura['IDFactura'].'" data-condonacion="'.$informacionFactura['IDCondonacion'].'" data-modal="" method="POST">
                                <div class="card-body m-0 p-0">
        				            <span class="respuesta"></span>
                                    <div class="row col-12 m-0 p-0 d-flex">
                						<div class="col-xxl-8 col-md-12 col-12 px-3 mb-3">
                							<div>
                								<label for="txtNroContrato_ifcond" class="form-label">Nro Contrato</label>
                								<input type="text" class="form-control" id="txtNroContrato_ifcond" value="'.$informacionFactura['NroContrato'].'" disabled>
                							</div>
                						</div>
                						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3">
                							<div>
                								<label for="txtEstadoFactura_ifcond" class="form-label">Estado Factura</label>
                								<input type="text" class="form-control '.( $informacionFactura['EstadoFactura'] != "PEND" ? 'text-white' : '' ).' '.$bgFondoEstadoFactura.'" id="txtEstadoFactura_ifcond" value="'.$textoEstadoFactura.'" readonly>
                							</div>
                						</div>
                						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
                							<div>
                								<label for="txtFacturaInterna_ifcond" class="form-label">Factura Interna</label>
                								<input type="text" class="form-control" id="txtFacturaInterna_ifcond" value="'.$informacionFactura['FacturaInterna'].'" disabled>
                							</div>
                						</div>
                						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
                							<div>
                								<label for="txtFacturaExterna_ifcond" class="form-label">Factura Externa</label>
                								<input type="text" class="form-control" id="txtFacturaExterna_ifcond" value="'.$informacionFactura['FacturaExterna'].'" disabled>
                							</div>
                						</div>
                						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
                						    <div>
                								<label for="txtTipoFactura_ifcond" class="form-label">Tipo de Factura</label>
                								<select class="form-select" aria-label="Tipo de Factura" id="txtTipoFactura_ifcond" data-modal="#mdlFacturaCondonacion" disabled>
                									<option value="" selected="">Seleccione una opción</option>
                									<option value="ND" '.($informacionFactura['TipoFactura'] == 'ND' ? 'selected' : '').'>ND</option>
                									<option value="O" '.($informacionFactura['TipoFactura'] == 'O' ? 'selected' : '').'>O</option>
                									<option value="C" '.($informacionFactura['TipoFactura'] == 'C' ? 'selected' : '').'>C</option>
                									<option value="OT" '.($informacionFactura['TipoFactura'] == 'OT' ? 'selected' : '').'>OT</option>
                									<option value="OI" '.($informacionFactura['TipoFactura'] == 'OI' ? 'selected' : '').'>OI</option>
                								</select>
                							</div>
                						</div>
                						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
                						    <div>
                								<label for="txtSegmento_ifcond" class="form-label">Segmento</label>
                								<select class="form-select" aria-label="Segmento" id="txtSegmento_ifcond" data-modal="#mdlFacturaCondonacion" disabled>
                									<option value="" selected="">Seleccione una opción</option>
                									<option value="HBFEPE" '.($informacionFactura['Segmento'] == 'HBFEPE' ? 'selected' : '').'>HBFEPE</option>
                									<option value="HBFDPE" '.($informacionFactura['Segmento'] == 'HBFDPE' ? 'selected' : '').'>HBFDPE</option>
                								</select>
                							</div>
                						</div>
                						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
                						    <div>
                    							<label for="txtDeudaTotal_ifcond" class="form-label">Deuda Total Factura</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">S/.</span>
                                                    <input type="text" step="0.01" class="form-control evaluar-moneda-decimal" aria-label="Deuda Total" id="txtDeudaTotal_ifcond" placeholder="Deuda Total" pattern="^\d+(\.\d+)?$"  title="Solo números y un punto decimal" value="'.$informacionFactura['DeudaTotal'].'" disabled>
                                                </div>
                                            </div>
                                        </div>
                						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3">
                						    <div>
                    							<label for="txtImporte_ifcond" class="form-label">Importe Condonar</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">S/.</span>
                                                    <input type="text" step="0.01" class="form-control evaluar-moneda-decimal" aria-label="Importe" id="txtImporte_ifcond" name="txtImporte_ifcond" placeholder="Importe" pattern="^\d+(\.\d+)?$"  title="Solo números y un punto decimal" value="'.$informacionFactura['ImporteCondonar'].'" '.($informacionFactura['EstadoFactura'] == "APRO" || $informacionFactura['EstadoFactura'] == "CANC" ? 'disabled' : '').'>
                                                </div>
                                            </div>
                                        </div>
                				    </div>
            				    </div>';
            				    
            				    if($informacionFactura['EstadoFactura'] == "PEND" || $informacionFactura['EstadoFactura'] == "RECH")
            				    {
                    				$html .= '<div class="modal-footer">
                    					<button type="submit" id="btnEjecutarFacturaCondonacion" class="btn bg-success d-flex justify-content-center align-items-center color-white"><i class="mdi mdi-import mx-1" style="font-size: 14px;"></i>Guardar</button>
                    				</div>';
            				    }
            				$html .= '</form>
                        </div>
                    </div>
                    <div class="tab-pane" id="nav-comentarios-factura-aprobador" role="tabpanel" style="background-color: transparent;">
                        <div class="row m-0 p-0">
                            <div class="col-lg-12">
                                <div class="col-12 p-3 m-0">
                                    <form class="formularioRegistrarComentarioAprobacionCondonacion comentario m-0" autocomplete="off" action="'.$this->items['baseUrl'].'/registrar-comentario-aprobador-condonacion" method="POST" data-contenedor="ctnComentariosFacturaAprobador">
                    			        <div class="row col-12 m-0 p-0 d-flex">
                    			            <div class="panel m-0">
                                                <div class="panel-heading">
                                                    <h4>Registrar Comentario</h4>
                                                </div>
                                                <div class="panel-content">
                                                    <div class="row">
                                                        <div class="col-10">
                                                            <input type="hidden" id="txtIDCondonacion_rcomaprcond" name="txtIDCondonacion_rcomaprcond" value="'.$informacionFactura['IDCondonacion'].'">
                                                            <input type="hidden" id="txtIDFacturaCondonacion_rcomaprcond" name="txtIDFacturaCondonacion_rcomaprcond" value="'.$informacionFactura['IDFactura'].'">
                                                            <input type="hidden" id="txtIDAprobacionCondonacion_rcomaprcond" name="txtIDAprobacionCondonacion_rcomaprcond" value="'.$informacionFactura['IDAprobacion'].'">
                                							<textarea class="form-control" id="txtComentariosFactura_rcomaprcond" name="txtComentariosFactura_rcomaprcond" rows="4" placeholder="Comentarios...."></textarea>
                                						</div>
                                						<div class="col-2 d-flex justify-content-center align-items-center">
                                						    <button type="submit" class="btn bg-sistema color-white p-2 px-3 mx-1">
                                                                <i class="mdi mdi-content-save" style="font-size: 22px;"></i>
                                                            </button>
                                						</div>
                                                    </div>
                                                </div>
                                            </div>
                    				    </div>
                    			    </form>
                    			</div>
                    			<hr>
                    			<div class="col-12 " id="ctnComentariosFacturaAprobador">';
                                $fechaActual = '';
                                
                                    if(!empty($comentarios))
                                    {
                                        foreach ($comentarios as $index => $evento)
                                        {
                                            $facturaInterna = !empty($evento['FacturaInterna']) ? '<span class="badge bg-info text-white me-1">'.$evento['FacturaInterna'].'</span>' : '';
                                            $facturaExterna = !empty($evento['FacturaExterna']) ? '<span class="badge bg-secondary text-white me-1">'.$evento['FacturaExterna'].'</span>' : '';
                                            
                                            // Título acción
                                            $tituloAccion = '<span class="badge bg-primary-subtle text-primary fw-semibold ms-auto">'.$arrayTitulos[$evento['Accion']].'</span>';
    
                                            $html .= '<div class="d-flex mb-4 p-3 border rounded" style="background-color: #ffffff; box-shadow: 4px 4px #8A8C8E;">
                                                <div class="flex-shrink-0 me-3 d-flex justify-content-center align-items-center">
                                                    <h5>'.(isset($arrayIconos[$evento['ValorBitacora']]) || isset($arrayIconos[$evento['Accion']]) ? (isset($arrayIconos[$evento['ValorBitacora']]) ? $arrayIconos[$evento['ValorBitacora']] : $arrayIconos[$evento['Accion']] ) : '<span class="badge bg-warning border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Registro de Actividad"><i class="mdi mdi-star align-bottom" style="font-size: 20px; color: #FFF;"></i></span>' ).'</h5>
                                                </div>
                                                <div class="flex-grow-1">
                                                    <div class="d-flex justify-content-between align-items-center mb-1">
                                                        <h6 class="mb-0">'.ucwords(mb_strtolower($evento['Nombres'].' '.$evento['Apellidos'])).'</h6>
                                                        <small class="text-muted">'.date('d M Y', strtotime($evento['Fecha'])).' - '.$evento['Hora'].'</small>
                                                    </div>
                                                    <p class="text-muted my-2">'.$evento['Comentario'].'</p>
                                                    <div class="d-flex align-items-center justify-content-between">
                                                        <div>'.$facturaInterna.$facturaExterna.'</div>
                                                        '.$tituloAccion.'
                                                    </div>
                                                </div>
                                            </div>';
                                        }
                                    }
                                    else
                                    {
                                        $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 justify-content-center align-items-center" style="border-radius: 10px;">
                                            <div class="col-xxl-10 col-md-12 col-12 ">
                                                <div class="alert alert-dark alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                                                    <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>NO SE ENCONTRÓ COMENTARIOS DE APROBADOR</strong> - Aún no hay decisión en la aprobación.
                                                </div>
                                            </div>
                                        </div>';
                                    }
                            $html .= '</div>
                            </div>
                        </div>
                    </div>
                </div>';
            }
            else
            {
                $html = '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
    	            <div class="col-xxl-10 col-md-12 col-12 ">
            	        <div class="alert alert-warning alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                            <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN INFORMACIÓN</strong> - No se encontró información en la factura seleccionada. Contáctese con Soporte IT|Desarrollo IT.
                        </div>
                    </div>
            	</div>';
            }
        }
        else 
		{
            $html = '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
	            <div class="col-xxl-10 col-md-12 col-12 ">
        	        <div class="alert alert-danger alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN SESIÓN</strong> - No hay sesión iniciada. Inicie sesión nuevamente.
                    </div>
                </div>
        	</div>';
		}
		
		echo $html;
    }
    
    public function enviarCorreoFacturasPendientesAprobadorCondonacion()
    {
        if(isset($this->items['id']))
        {
            $fechaActual = date("Y-m-d H:i:s");
    
            $idCondonacion  = $this->request->getPost('idCondonacion');
            $idUsuario      = $this->request->getPost('idUsuarioAprobador');
            
            $aprobador       = $this->usuarios->buscarUsuario($idUsuario);
            
            $correoCopia = array();
    		/*
            * ----------------------------
            * PREPARACIÓN DE CUERPO DE CORREO
            * ----------------------------
    		*/
    
            $arrayCuerpo = array(
                "TITULO" => "SOLICITUD DE CONDONACIÓN #".$idCondonacion,
                "BASE_URL"  => base_url(),
                'basePublic'    => $this->items['basePublic'],
                'baseDinamic'   => $this->items['baseDinamic'],
                "MODULO" => "CONDONACIONES",
                "USUARIO" => ucwords(mb_strtolower($aprobador['Nombres'].' '.$aprobador['Apellidos'])),
                "MENSAJE" => "Aún tienes pendientes facturas por aprobar para proceder a realizar las condonaciones. Ingresa al sistema Petitracking para poder gestionarlo.",
                "URL_MODULO" => base_url()."/facturas-condonacion/".$idCondonacion
            );
    
            $cuerpo = $this->plantillasCorreo->avisoPetitracking($arrayCuerpo);
            
    		/*
            * ----------------------------
            * PREPARACIÓN DE PARAMETROS PARA EL CORREO
            * ----------------------------
    		*/
    		
    		$correoCopia[] = $this->items['correoElectronico'];
    		
            $asunto="FACTURAS PENDIENTES - SOLICITUD DE CONDONACIÓN #".$idCondonacion;
            
            $configCorreo = array(
                "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
                "CORREO_ORIGEN" => $this->items['correoElectronico'],
                "CORREOS_DESTINOS" => array($aprobador['Correo']),
                "CORREOS_COPIA" => $correoCopia,
                "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe", "joseenrique.nanquen@verisure.pe"),
                "ASUNTO" => $asunto,
                "MENSAJE" => $cuerpo
            );
    
            $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);
    
            // $dataCorreo = array(
            //     "IDAsignacion"  => $idAsignacion,
            //     "Response"      => $estadoCorreo['RESPUESTA'],
            //     "Error"         => $estadoCorreo['ERROR'],
            //     'UsuarioCrea'   => $this->items['id'],
            //     'FechaCrea'     => $fechaActual,    
            //     'Localhost'     => $this->request->getIPAddress()
            // );
    
            // $this->correoStatusAsignacion->insert($dataCorreo, TRUE);
    
            if($estadoCorreo['ERROR'] != '')
            {
                $message = sprintf($this->mensajeError->msg201, "No se pudo enviar el correo. Inténtelo luego.[INSERT]");
    			echo $this->alertas->alertaError($message);
            }
            else
            {
                $message = sprintf($this->mensajeError->msg201, "Se envió el correo correctamente.");
                echo $this->alertas->alertaExito($message);
            }
        }
        else 
		{
            $message = sprintf($this->mensajeError->msg201, "No se encontró sesión iniciada. Por favor, inicie sesión nuevamente.");
            echo $this->alertas->alertaError($message);
		}
    }
    
    public function comentariosCondonacion()
    {
        $html = '';
        
        if(isset($this->items['id']))
        {
            /*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
            */
    
            $msjError       = TRUE;
            $idCondonacion  = $this->request->getPost('idCondonacion');
            
            $arrayTitulos = array(
                "MODFACT"   => "Actualización de Condonación de Factura",
                "DECIFACT"  => "Decisión de Aprobación de Condonación",
                "ESTFACT"   => "Cambio de Estado de Factura",
                "COMENFACT" => "Comentario de Factura",
                "COMENDECIFACT" => "Comentario de Decisión de Aprobación de Condonación",
                "COMENCOND" => "Comentario de Solicitud"
            );
            
            $arrayIconos = array(
                "APRO"  => '<span class="badge bg-success border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Aprobado"><i class="mdi mdi-check-circle align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "RECH"  => '<span class="badge bg-danger border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Rechazado"><i class="mdi mdi-close-circle align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "PEND"  => '<span class="badge bg-gris-claro border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Pendiente"><i class="mdi mdi-timer-sand align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "CANC"  => '<span class="badge bg-dark border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Cancelado"><i class="mdi mdi-cancel align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "COME"  => '<span class="badge bg-come border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Comentario"><i class="mdi mdi-comment align-bottom" style="font-size: 20px; color: #FFF;"></i></span>',
                "MODFACT"  => '<span class="badge bg-orange border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Comentario"><i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i></span>'
            );
            
            
            /*
            * ----------------------------
            * CONSULTAS SQL
            * ----------------------------
            */
            
            $arrayCondonacion = array(
                'idCondonacion' => $idCondonacion,
                'exCondonacion' => "Y" // exclusivoCondonacion: cuando solo quiero bitacora exclusivo de condonaciones, sin facturas ni aprobadores (estos ultimos null)
            );
    
            $bitacora   = $this->condonacionesBitacora->listarBitacoraCondonacion($arrayCondonacion);
            
            /*
            * ----------------------------
            * ARMAR HTML
            * ----------------------------
            */
            
            $fechaActual = '';
            
            if(!empty($bitacora))
            {
                foreach ($bitacora as $index => $evento)
                {
                    $facturaInterna = !empty($evento['FacturaInterna']) ? '<span class="badge bg-info text-white me-1">'.$evento['FacturaInterna'].'</span>' : '';
                    $facturaExterna = !empty($evento['FacturaExterna']) ? '<span class="badge bg-secondary text-white me-1">'.$evento['FacturaExterna'].'</span>' : '';
                    
                    // Título acción
                    $tituloAccion = '<span class="badge bg-primary-subtle text-primary fw-semibold ms-auto">'.$arrayTitulos[$evento['Accion']].'</span>';

                    $html .= '<div class="d-flex mb-4 p-3 border rounded" style="background-color: #ffffff; box-shadow: 4px 4px #8A8C8E;">
                        <div class="flex-shrink-0 me-3 d-flex justify-content-center align-items-center">
                            <h5>'.(isset($arrayIconos[$evento['ValorBitacora']]) || isset($arrayIconos[$evento['Accion']]) ? (isset($arrayIconos[$evento['ValorBitacora']]) ? $arrayIconos[$evento['ValorBitacora']] : $arrayIconos[$evento['Accion']] ) : '<span class="badge bg-warning border-0 p-2 mx-1 text-white" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Registro de Actividad"><i class="mdi mdi-star align-bottom" style="font-size: 20px; color: #FFF;"></i></span>' ).'</h5>
                        </div>
                        <div class="flex-grow-1">
                            <div class="d-flex justify-content-between align-items-center mb-1">
                                <h6 class="mb-0">'.ucwords(mb_strtolower($evento['Nombres'].' '.$evento['Apellidos'])).'</h6>
                                <small class="text-muted">'.date('d M Y', strtotime($evento['Fecha'])).' - '.$evento['Hora'].'</small>
                            </div>
                            <p class="text-muted my-2">'.$evento['Comentario'].'</p>
                            <div class="d-flex align-items-center justify-content-between">
                                <div>'.$facturaInterna.$facturaExterna.'</div>
                                '.$tituloAccion.'
                            </div>
                        </div>
                    </div>';
                }
            }
            else
            {
                $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 justify-content-center align-items-center" style="border-radius: 10px;">
                    <div class="col-xxl-10 col-md-12 col-12 ">
                        <div class="alert alert-dark alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                            <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>NO SE ENCONTRÓ COMENTARIOS DE SOLICITUD</strong>
                        </div>
                    </div>
                </div>';
            }
        }
        else 
		{
            $html = '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
	            <div class="col-xxl-10 col-md-12 col-12 ">
        	        <div class="alert alert-danger alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN SESIÓN</strong> - No hay sesión iniciada. Inicie sesión nuevamente.
                    </div>
                </div>
        	</div>';
		}
		
		echo $html;
    }
    
    public function registrarComentarioCondonacion()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        $error = '';
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        //Información de Condonación
        
        $comentario             = $this->request->getPost('txtComentariosCondonacion_rcomcond');
        $idCondonacion          = $this->request->getPost('txtIDCondonacion_rcomcond');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error .= $this->complementos->validaCampo($idCondonacion, 'required|trim|numeric', 'ID Condonacion');
        $error .= $this->complementos->validaCampo($comentario, 'required|trim', 'Comentario');
        
        if ($error != '') 
        {
            $message = sprintf($this->mensajeError->msg201, $error);
            $mensaje = $this->alertas->alertaError($message);
            
            $resultado = array(
    			'result'    => (string) 0,
    			'mensaje'   => (string) $mensaje
    		);
    		
    		echo json_encode($resultado);
    		
            EXIT;
        }
        
        /*
        * ----------------------------
        * INSERTAR COMENTARIO
        * ----------------------------
        */

        $data = array (
            'IDCondonacion'         => $idCondonacion,
            'IDFacturaCondonacion'  => null,
            'IDAprobacion'          => null,
            'Accion'                => "COMENCOND",
            'ValorBitacora'         => "COME",
            'Comentario'            => $comentario,
            'UsuarioRegistra'       => $this->items['id'],
            'FechaRegistra'         => $fechaActual,    
            'Localhost'             => $this->request->getIPAddress(),
            'Estado'                => 'A'
        );

        $lastId = $this->condonacionesBitacora->insert($data, TRUE);

		if($lastId !== FALSE)
		{
		    $message = sprintf($this->mensajeError->msg201, "Se registró el comentario exitosamente.");
            $mensaje = $this->alertas->alertaExito($message);
            
            $resultado = array(
    			'result'    => (string) 1,
    			'mensaje'   => (string) $mensaje
    		);
		}
        else
        {
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el comentario. Inténtelo luego.");
            $mensaje = $this->alertas->alertaError($message);
            
            $resultado = array(
    			'result'    => (string) 0,
    			'mensaje'   => (string) $mensaje
    		);
        }
        
        echo json_encode($resultado);
        EXIT;
    }
    
    public function acumuladosFacturaCondonacion()
    {
        $html = '';
        
        if(isset($this->items['id']))
        {
            /*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
            */
    
            $msjError       = TRUE;
            $idCondonacion  = $this->request->getPost('idCondonacion');
            
            /*
            * ----------------------------
            * CONSULTAS SQL
            * ----------------------------
            */
            
            $whereAcumuladoCondonacion = array(
                'IDCondonacion' => 9,
                'arrayNoEstados'=> array("CANC")
            );
    
            $whereAcumuladoContrato = array(
                'IDCondonacion' => 9,
                'arrayNoEstados'=> array("CANC"),
                'GroupBy'       => "Contrato"
            );
    
            $whereAcumuladoTipo = array(
                'IDCondonacion' => 9,
                'arrayNoEstados'=> array("CANC"),
                'GroupBy'       => "TipoFactura"
            );
    
            $whereAcumuladoSegmento = array(
                'IDCondonacion' => 9,
                'arrayNoEstados'=> array("CANC"),
                'GroupBy'       => "Segmento"
            );
    
            $acumuladoCondonacion   = $this->condonacionesFacturas->listadoAcumuladosFacturaCondonacion($whereAcumuladoCondonacion);
            $acumuladoContrato      = $this->condonacionesFacturas->listadoAcumuladosFacturaCondonacion($whereAcumuladoContrato);
            $acumuladoTipoFactura   = $this->condonacionesFacturas->listadoAcumuladosFacturaCondonacion($whereAcumuladoTipo);
            $acumuladoSegmento      = $this->condonacionesFacturas->listadoAcumuladosFacturaCondonacion($whereAcumuladoSegmento);
            
            /*
            * ----------------------------
            * ARMAR HTML
            * ----------------------------
            */
            
            $fechaActual = '';
            
            if(!empty($acumuladoCondonacion) || !empty($acumuladoContrato) || !empty($acumuladoTipoFactura) || !empty($acumuladoSegmento))
            {
                $html .= '<div class="table-responsive mx-0">
                    <table class="table table-borderless mb-0">
                        <tbody>';
                        
                        if(!empty($acumuladoCondonacion))
                        {
                            foreach($acumuladoCondonacion as $acumulado)
                            {
                                $html .= '<tr>
                                    <td class="fw-medium text-secondary" scope="row" colspan="2">Condonación #'.$acumulado['IDCondonacion'].'</td>
                                </tr>
                                <tr>
                                    <td class="fw-medium py-0" scope="row">Deuda Total</td>
                                    <td class="py-0">S/ '.number_format(round($acumulado['Acumulado_DeudaTotal'], 2), 2, '.', ' ').'</td>
                                </tr>
                                <tr>
                                    <td class="fw-medium py-0" scope="row">Importe a Condonar</td>
                                    <td class="py-0">S/ '.number_format(round($acumulado['Acumulado_ImporteCondonar'], 2), 2, '.', ' ').'</td>
                                </tr>';
                            }
                        }
                        
                        if(!empty($acumuladoContrato))
                        {
                            foreach($acumuladoContrato as $acumulado)
                            {
                                $html .= '<tr>
                                    <td class="fw-medium text-secondary" scope="row" colspan="2">Contrato #'.$acumulado['Columna_Agrupada'].'</td>
                                </tr>
                                <tr>
                                    <td class="fw-medium py-0" scope="row">Deuda Total</td>
                                    <td class="py-0">S/ '.number_format(round($acumulado['Acumulado_DeudaTotal'], 2), 2, '.', ' ').'</td>
                                </tr>
                                <tr>
                                    <td class="fw-medium py-0" scope="row">Importe a Condonar</td>
                                    <td class="py-0">S/ '.number_format(round($acumulado['Acumulado_ImporteCondonar'], 2), 2, '.', ' ').'</td>
                                </tr>';
                            }
                        }
                        
                        if(!empty($acumuladoTipoFactura))
                        {
                            foreach($acumuladoTipoFactura as $acumulado)
                            {
                                $html .= '<tr>
                                    <td class="fw-medium text-secondary" scope="row" colspan="2">Tipo de Factura: '.$acumulado['Columna_Agrupada'].'</td>
                                </tr>
                                <tr>
                                    <td class="fw-medium py-0" scope="row">Deuda Total</td>
                                    <td class="py-0">S/ '.number_format(round($acumulado['Acumulado_DeudaTotal'], 2), 2, '.', ' ').'</td>
                                </tr>
                                <tr>
                                    <td class="fw-medium py-0" scope="row">Importe a Condonar</td>
                                    <td class="py-0">S/ '.number_format(round($acumulado['Acumulado_ImporteCondonar'], 2), 2, '.', ' ').'</td>
                                </tr>';
                            }
                        }
                        
                        if(!empty($acumuladoSegmento))
                        {
                            foreach($acumuladoSegmento as $acumulado)
                            {
                                $html .= '<tr>
                                    <td class="fw-medium text-secondary" scope="row" colspan="2">Segmento: '.$acumulado['Columna_Agrupada'].'</td>
                                </tr>
                                <tr>
                                    <td class="fw-medium py-0" scope="row">Deuda Total</td>
                                    <td class="py-0">S/ '.number_format(round($acumulado['Acumulado_DeudaTotal'], 2), 2, '.', ' ').'</td>
                                </tr>
                                <tr>
                                    <td class="fw-medium py-0" scope="row">Importe a Condonar</td>
                                    <td class="py-0">S/ '.number_format(round($acumulado['Acumulado_ImporteCondonar'], 2), 2, '.', ' ').'</td>
                                </tr>';
                            }
                        }
                        
                        $html .= '</tbody>
                    </table>
                </div>';
            }
            else
            {
                $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 justify-content-center align-items-center" style="border-radius: 10px;">
                    <div class="col-xxl-10 col-md-12 col-12 ">
                        <div class="alert alert-dark alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                            <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>NO SE ENCONTRARON FACTURAS PARA CALCULAR EL ACUMULADO</strong>
                        </div>
                    </div>
                </div>';
            }
        }
        else 
		{
            $html = '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
	            <div class="col-xxl-10 col-md-12 col-12 ">
        	        <div class="alert alert-danger alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN SESIÓN</strong> - No hay sesión iniciada. Inicie sesión nuevamente.
                    </div>
                </div>
        	</div>';
		}
		
		echo $html;
    }
    
    public function obtenerInformacionAprobadorFacturaCondonacion()
    {   
        if (isset($this->items['id'])) 
    	{
    		/*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
    		*/
    
    		$msjError = TRUE;
    		$idCondonacion  = $this->request->getPost('idCondonacion');
    		$idAprobacion   = $this->request->getPost('idAprobacion');
    		
    		/*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
    
    		$error = '';
    		$error .= $this->complementos->validaCampo($idAprobacion, 'trim', 'ID');
    
    		if ($error != '') {
    			$message = sprintf($this->mensajeError->msg201, $error);
    			echo $this->alertas->alertaError($message);
    			exit;
    		}
    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
            
            $origenAprobador = "";
            $idOrigenAprobador = 1;
            
            $whereAprobacion = array(
                'IDAprobacion'  => $idAprobacion
            );
    		
    		$datosAprobador = $this->condonacionesFacturasAprobadores->obtenerAprobadorFacturaCondonacion($whereAprobacion);
    		
    		if($datosAprobador['TipoFactura'] == "ND")
            {
                if($datosAprobador['ImporteCondonar'] > 7000)
                {
                    $origenAprobador = "DIRECCION";
                    $idOrigenAprobador = $datosAprobador['IDDireccionAprobacion'];
                }
                else
                {
                    $origenAprobador = "AREA";
                    $idOrigenAprobador = $datosAprobador['IDAreaAprobacion'];
                }
            }
            else
            {
                if($datosAprobador['ImporteCondonar'] == $datosAprobador['DeudaTotal'])
                {
                    $origenAprobador = "DIRECCION";
                    $idOrigenAprobador = $datosAprobador['IDDireccionAprobacion'];
                }
                else
                {
                    $origenAprobador = "AREA";
                    $idOrigenAprobador = $datosAprobador['IDAreaAprobacion'];
                }
            }
            
    		if(!empty($datosAprobador))
    		{
    			$resultado = array(
    				'idaprobacion'          => (string) $idAprobacion,
    				'idcondonacion'         => (string) $datosAprobador['IDCondonacion'],
    				'facturainterna'        => (string) $datosAprobador['FacturaInterna'],
    				'facturaexterna'        => (string) $datosAprobador['FacturaExterna'],
    				'idusuarioaprobacion'   => (string) $datosAprobador['IDUsuarioAprobacion'],
    				'nombreaprobador'       => (string) ucwords(mb_strtolower($datosAprobador['Nombres'])),
    				'apellidoaprobador'     => (string) ucwords(mb_strtolower($datosAprobador['Apellidos'])),
    				'matriculaaprobador'    => (string) $datosAprobador['Matricula'],
    				'origen'                => (string) $origenAprobador,
    				'idorigen'              => (string) $idOrigenAprobador,
    			);
    		} 
    		else 
    		{
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado);
    	} 
    	else 
    	{
            $resultado = array(
				'sesion' => 0,
			);
			echo json_encode($resultado);
        }
    }
    
	/**************************************************************************/
	
    /******************************* OPERADORES *******************************/
    
	/**************************************************************************/
	
    /********************************* PLANES *********************************/
    
	/**************************************************************************/
	
    /******************************* CATEGORÍAS *******************************/
    
	/**************************************************************************/
	
    /*************************** CATEGORÍAS - TIPOS ***************************/
    
	/**************************************************************************/
	
    /********************* CATEGORÍAS - TIPOS - SUBTIPOS **********************/
    
	/**************************************************************************/
	
    /***************************** ELEMENTOS DEMO *****************************/
    
	/**************************************************************************/
	
    /******************* CUENTAS CONTABLES - SUBCATEGORÍAS ********************/
    
	/**************************************************************************/
	
    /************************** PROVEEDORES ***********************************/
    
	/**************************************************************************/
	
    /***************************** OTRAS FUNCIONES ****************************/
    
    function validacionCSVimport($csv, $nombreElemento, $columnas)
    {
        $error = "";
        
		/*
		* ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (!$csv->isValid()) {
            $error = $csv->getErrorString().'-'.$csv->getError();
            return array("error" => $error);
        }

		/* ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            $nombreElemento => [
                'mime_in['.$nombreElemento.',text/csv,text/plain,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/msexcel,application/xls,application/x-xls]',
                'ext_in['.$nombreElemento.',csv]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $error = implode(",", $this->validator->getErrors());
            return array("error" => $error);
        }

		/*
        * ----------------------------
        * VALIDAR SEPARADOR CSV
        * ----------------------------
        */
		$separadorCSV = $this->complementos->validarSeparadorCSV($csv, $columnas);
        
        if (!$separadorCSV) {
            $error = "No se encontró separador de CSV autorizado. Debe usar coma (,) o punto y coma (;) y eliminar celdas vacías a la derecha de la última columna.";
            return array("error" => $error);
        }
        
        return array(
            "error"     => $error,
            "separador" => $separadorCSV
        );
    }
    
	/**************************************************************************/
	
	
}