<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

class CarteraCliente extends BaseController
{
	public function __construct(){
 		$this->requerimientos = new \App\Models\RequerimientosModel();
 		$this->requerimientosPerfil = new \App\Models\RequerimientosPerfilModel();
		$this->requerimientosGruposTrabajo = new \App\Models\RequerimientosGruposTrabajoModel();
		$this->requerimientosMotivo = new \App\Models\RequerimientosMotivoModel();
		
		$this->gruposcarteracliente = new \App\Models\GruposCarteraClienteModel();
		
		$this->formatosAprobacion   = new \App\Models\FormatosAprobacionModel();
		
		$this->usuarioGruposCarteraCliente = new \App\Models\UsuarioGruposCarteraClienteModel();
		
		$this->itemOfertaNomenclatura = new \App\Models\OfertaNomenclaturaModel();
		
	    $this->peticiones = new \App\Models\PeticionesModel();
	    
	    $this->itemOfetaGrupoCarteraCliente = new \App\Models\ItemOfertaGrupoCarteraClienteModel();
	    
	    
//         $this->usuarioPerfil = new \App\Models\UsuarioPerfilModel();
//         $this->usuarioPermisos = new \App\Models\UsuarioPermisosModel();
//         $this->usuarioRutas = new \App\Models\UsuarioRutasModel();
	}
	
	public function listarGruposCarteraCliente()
	{
    	if(isset($this->items['id'])){

			/* ACCIONES */
			$listadoGruposCarteraCliente = $this->gruposcarteracliente->findAll(); 
			
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Grupos de Cartera Cliente | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Grupos de Cartera Cliente',
				'listadoGruposCarteraCliente'  => $listadoGruposCarteraCliente
			);
			$data = array_merge($data, $this->items);
			return view('procesos/GrupoCarteraCliente/listar_grupos_cartera_cliente',$data);			
		} else {
			return view('errors/500');
		}	
	}
	
	public function registrarGrupoCarteraCliente()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $grupoCarteraCliente  = ucwords(mb_strtolower($this->request->getPost('txtGrupoCarteraCliente_i')));
        $observacion    = $this->request->getPost('txtObservacionGrupoCarteraCliente_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($grupoCarteraCliente, 'required|trim|minlength[1]|maxlength[50]', 'Grupo Catera Cliente');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$gtExistente = $this->gruposcarteracliente->where("CarteraCliente", $grupoCarteraCliente)->findAll();

        if(count($gtExistente)>0)
        {
            $msgExistencia .= "<li>El grupo Cartera Cliente ya fue registrado. [CAMPO] <small>GRUPO CARTERA CLIENTE</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'CarteraCliente'  => $grupoCarteraCliente,
            'Observacion'   => $observacion,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress(),
            'UsuarioEstado' => $this->items['id'],
            'FechaEstado'   => $fechaActual,    
            'MotivoEstado'  => "Creación de grupo cartera cliente.",    
            'Estado'        => 'A'
        );

        $lastId = $this->gruposcarteracliente->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $grupoCarteraCliente);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
	public function obtenerDatosGrupoCarteraCliente()
	{
		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idGrupoCarteraCliente = $this->request->getPost('idGrupoCarteraCliente'); 

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idGrupoCarteraCliente, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosGrupoCarteraCliente = $this->gruposcarteracliente->where('IDGrupoCarteraCliente', $idGrupoCarteraCliente)->first();

		if(!empty($datosGrupoCarteraCliente)){
			$resultado = array(
				'idgrupotrabajo'    => (string) $idGrupoCarteraCliente,
				'grupotrabajo'      => (string) $datosGrupoCarteraCliente['CarteraCliente'],
				'observacion'       => (string) $datosGrupoCarteraCliente['Observacion']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}
	
	public function modificarGrupoCarteraCliente($idGrupoCarteraCliente)
	{ 
        $fechaActual = date("Y-m-d H:i:s");
       
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $grupoCarteraCliente  = ucwords(mb_strtolower($this->request->getPost('txtGrupoCarteraCliente_i'))) ;
        $observacion    = $this->request->getPost('txtObservacionGrupoCarteraCliente_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($grupoCarteraCliente, 'required|trim|minlength[1]|maxlength[50]', 'Grupo de Trabajo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'CarteraCliente'      => $grupoCarteraCliente,
            'Observacion'       => $observacion,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->gruposcarteracliente->update([$idGrupoCarteraCliente], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $grupoCarteraCliente);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
	}
	
    public function listarUsuariosGrupoCarteraCliente($idGrupoCarteraCliente)
    {
        if(isset($this->items['id'])){
			/* BUSCAR ACCIONES */
			$whereUGCC = array(
			    "idgrupocarteracliente"    => $idGrupoCarteraCliente
			);
			
			$grupocarteraCliente = $this->gruposcarteracliente->where("IDGrupoCarteraCliente", $idGrupoCarteraCliente)->first(); // grupocarteracliente
			$listaUsuarios = $this->usuarioGruposCarteraCliente->listarUsuariosGrupoCarteraCliente($whereUGCC); //usuariogrupocarteracliente
            // var_dump($listaUsuarios); exit;
			$data = array (
				'session'           => 'on',
				'titulo'            => 'Usuarios - Grupo de Trabajo | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Usuarios asociados - '.$grupocarteraCliente['CarteraCliente'],
                'previo'            => 'listar-grupos-cartera-cliente',
				'listaUsuarios'     => $listaUsuarios,
                'idGrupoCarteraCliente'    => $idGrupoCarteraCliente
			);
			$data = array_merge($data, $this->items); 
			return view('procesos/GrupoCarteraCliente/listar_usuario_grupo_cartera_cliente',$data);	
		} else {
			return view('errors/500');	
		}
    }
    
    public function asociarUsuarioGrupoCarteraCliente()
    { 
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError       = TRUE;
        $idUsuario      = $this->request->getPost('idUsuario');
        $idGrupoCarteraCliente = $this->request->getPost('idGrupoCarteraCliente');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idUsuario, 'required|trim|number', 'ID Usuario');
        $error .= $this->complementos->validaCampo($idGrupoCarteraCliente, 'required|trim|number', 'ID Grupo Cartera Cliente');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereUGCC = array(
            'IdUsuario'         => $idUsuario,
            'IDGrupoCarteraCliente'    => $idGrupoCarteraCliente
        );
        
		$combinacionExistente = $this->usuarioGruposCarteraCliente->where($whereUGCC)->findAll();
		
        if(count($combinacionExistente)>0)
        {
            $msgExistencia .= "<li>El usuario ya fue agregado al grupo de trabajo. [CAMPO] <small>USUARIO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'IdUsuario'         => $idUsuario, 
            'IDGrupoCarteraCliente'    => $idGrupoCarteraCliente,
            'UsuarioRegistra'   => $this->items['id'],
            'FechaRegistra'     => $fechaActual
        );

        $lastId = $this->usuarioGruposCarteraCliente->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function eliminarUsuarioGrupoCarteraCliente()
    {
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $idUsuario      = $this->request->getPost('idUsuario');
        $idGrupoCarteraCliente = $this->request->getPost('idGrupoCarteraCliente');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idUsuario, 'required|trim|number', 'ID Usuario');
        $error .= $this->complementos->validaCampo($idGrupoCarteraCliente, 'required|trim|number', 'ID Grupo de Cartera Cliente');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $whereDelete = array (
            'IdUsuario'         => $idUsuario, 
            'IDGrupoCarteraCliente'    => $idGrupoCarteraCliente
        );

        $lastId = $this->usuarioGruposCarteraCliente->where($whereDelete)->delete();

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg504, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function modificarEstadoGrupocarteraCliente()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idGrupoCarteraCliente = $this->request->getPost('idGrupoCarteraCliente');
        $estado = $this->request->getPost('estado');
        $motivo = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idGrupoCarteraCliente, 'required|trim|numeric', 'ID Grupo Cartera Cliente');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        $lastId = $this->gruposcarteracliente->update([$idGrupoCarteraCliente], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idGrupoCarteraCliente);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    
    public function listadoItemOfertaAsociados()
    {
        $idGrupoCarteraCliente = $this->request->getPost('idGrupoCarteraCliente');
        
        $idUsuario = $this->items['id'];
        
        if (isset($this->items['id'])) {
            $itemGrupoCarteraCliente = $this->itemOfertaNomenclatura->itemOfertaGrupoCarteraClienteAsociado($idGrupoCarteraCliente, $idUsuario);
            
            if (!empty($itemGrupoCarteraCliente)) {
                $listadoItemOferta = $this->itemOfertaNomenclatura->findAll();
                // Hay horarios asociados
                $resultado = array(
                    'itemGrupoCarteraCliente' => $itemGrupoCarteraCliente,
                    'listadoItemOferta'      => $listadoItemOferta
                );
            } else {
                // No hay horarios asociados, devolver la lista completa de horarios
                $listadoItemOferta = $this->itemOfertaNomenclatura->findAll();
                
                $resultado = array(
                    'itemGrupoCarteraCliente' => [],
                    'listadoItemOferta' => $listadoItemOferta
                );
            }
    
            return $this->response->setJSON($resultado);  // Devolver como JSON
        } else {
            return view('errors/500');    
        }
    }
    
    public function listadoTipoCartera()
    { var_dump("Hola David");exit();
        
        if (isset($this->items['id'])) {
            
            $idUsuario = $this->items['id'];
    
            // $solicitante = $this->usuarios->buscarUsuario($idUsuario);
            
            $datosGrupoCarteraCliente = $this->usuarioGruposCarteraCliente->obtenerCarterasPorUsuario($idUsuario);
            
            if($lastId !== FALSE){
    			$message = sprintf($this->mensajeError->msg503, $idGrupoCarteraCliente);
    			echo $this->alertas->alertaExito($message);
    			echo $this->alertas->refrescar(1);
    		}
    
            return $this->response->setJSON($resultado);  // Devolver como JSON
        } else {
            return view('errors/500');    
        }
    }
    
    public function guardarItemsAsociados()
    {
        $fechaActual = date("Y-m-d H:i:s");
        $idUsuario = $this->items['id']; // Usuario actual
    
        // Obtener los datos enviados desde el frontend
        $idGrupoCarteraCliente = $this->request->getPost('idGrupoCarteraCliente'); 
        $itemsSeleccionados = $this->request->getPost('itemsSeleccionados'); // Array de horarios seleccionados
    
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        $error = '';
        $error .= $this->complementos->validaCampo($idGrupoCarteraCliente, 'required|trim|minlength[1]|maxlength[11]', 'ID Grupo Cartera Cliente');
        
        if (is_array($itemsSeleccionados) && count($itemsSeleccionados) > 0) {
            foreach ($itemsSeleccionados as $idItemOferta) {
                $error .= $this->complementos->validaCampo($idItemOferta, 'required|trim|minlength[1]|maxlength[11]', 'ID Item');
            }
        } else {
            $error .= "<li>No se seleccionaron horarios.</li>";
        }
    
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
    
        /*
        * ----------------------------
        * ELIMINAR HORARIOS ASOCIADOS ANTERIORES Y INSERTAR NUEVOS
        * ----------------------------
        */
        // Obtener los horarios actualmente asociados a ese grupo de trabajo
        // $horariosAsociados = $this->horarios->horariosGrupoTrabajoAsociado($idGrupoCarteraCliente, $idUsuario);
        $itemGrupoCarteraCliente = $this->itemOfertaNomenclatura->itemOfertaGrupoCarteraClienteAsociado($idGrupoCarteraCliente, $idUsuario);
   
        try {
            // Si ya hay horarios asociados, eliminarlos antes de agregar los nuevos
            if (count($itemGrupoCarteraCliente) > 0) {
                foreach ($itemGrupoCarteraCliente as $data) {
                    $this->itemOfetaGrupoCarteraCliente
                        ->where(['IDGrupoCarteraCliente' => $data['IDGrupoCarteraCliente'], 'IDOfertaNomenclatura' => $data['IDOfertaNomenclatura']]) // eliminar de la tabla itemofertas_grupocarteracliente
                        ->delete();
                }
            }
    
            // Insertar los nuevos horarios seleccionados
            $lastId = [];
            foreach ($itemsSeleccionados as $idItem) {
                $data = [
                    'IDOfertaNomenclatura'   => $idItem,
                    'IDGrupoCarteraCliente'  => $idGrupoCarteraCliente,
                    'UsuarioRegistra' => $idUsuario,
                    'FechaRegistra'   => $fechaActual,
                ];
    
                // Intentar la inserción de cada registro en la tabla horario_grupotrabajo
                $insertId = $this->itemOfetaGrupoCarteraCliente->insert($data); // insertar en la tabla itemoferta_grupocarteracliente
    
                // Almacenar cada insertId para verificar si hay fallos
                $lastId[] = $insertId;
            }
    
            /*
            * ----------------------------
            * VALIDACIÓN FINAL Y MENSAJE DE ÉXITO
            * ----------------------------
            */
            if (!in_array(FALSE, $lastId, true)) { // Si no hay ningún `FALSE` en las inserciones
                $message = sprintf($this->mensajeError->msg502, 'Item Oferta guardados exitosamente para el grupo Cartera Cliente.');
                echo $this->alertas->alertaExito($message);
                echo $this->alertas->refrescar(1);
            } else {
                // Si alguna inserción falló
                $message = sprintf($this->mensajeError->msg201, 'Error al guardar uno o más Items.');
                echo $this->alertas->alertaError($message);
                EXIT;
            }
        } catch (Exception $e) {
            // Si ocurre una excepción, mostrar el error
            $message = sprintf($this->mensajeError->msg201, 'Error: ' . $e->getMessage());
            echo $this->alertas->alertaError($message);
            EXIT;
        }
    }
	

	public function actualizarAprobador()
	{ 
        $fechaActual = date("Y-m-d H:i:s");
       
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $idUsuario = $this->request->getPost('idUsuario');
        $idGrupo = $this->request->getPost('idGrupoCarteraCliente');
        $estado = $this->request->getPost('estado'); // 'Y' o 'N'
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idUsuario, 'required|trim|minlength[1]|maxlength[50]', 'Usuario');
        $error .= $this->complementos->validaCampo($idGrupo, 'required|trim|minlength[1]|maxlength[50]', 'Grupo de Cartera');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|minlength[1]|maxlength[1]', 'Aprobador');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */  
        
        if ($idUsuario && $idGrupo) {
            $data = [
                'JefeCartera' => $estado,
            ];
    
            $this->usuarioGruposCarteraCliente
                ->where('IdUsuario', $idUsuario)
                ->where('IDGrupoCarteraCliente', $idGrupo)
                ->set($data)
                ->update();
            
            return $this->response->setJSON(['status' => 'ok']);
        } else {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Datos incompletos']);
        }
    		
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////

	public function listarRequerimientos()
	{
    	if(isset($this->items['id'])){

			/* ACCIONES */
			$listadoRequerimientos = $this->requerimientos->findAll();
			
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Requerimientos | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Requerimientos',
				'listadoRequerimientos' => $listadoRequerimientos
			);
			$data = array_merge($data, $this->items);
			return view('configuracion/listar_requerimientos',$data);			
		} else {
			return view('errors/500');
		}	
	}

	public function registrarRequerimiento()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $requerimiento  = ucwords(mb_strtolower($this->request->getPost('txtRequerimiento_ireq')));
        $tipo           = $this->request->getPost('txtTipoRequerimiento_ireq');
        $observacion    = $this->request->getPost('txtObservacionRequerimiento_ireq');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($requerimiento, 'required|trim|minlength[1]|maxlength[50]', 'Requerimiento');
        $error .= $this->complementos->validaCampo($tipo, 'required|trim|minlength[1]|maxlength[10]', 'Tipo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereExistencia = array(
            "Requerimiento" => $requerimiento,
	        "Tipo"          => $tipo
        );
        
		$requerimientoExistente = $this->requerimientos->where($whereExistencia)->findAll();
        
        if(count($requerimientoExistente)>0)
        {
            $msgExistencia .= "<li>El requerimiento ya fue registrado bajo el tipo seleccionado. [CAMPO] <small>REQUERIMIENTO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'Requerimiento' => $requerimiento,
            'Tipo'          => $tipo,
            'Observacion'   => $observacion,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress(),
            'UsuarioEstado' => $this->items['id'],
            'FechaEstado'   => $fechaActual,    
            'MotivoEstado'  => "Creación de requerimiento.",    
            'Estado'        => 'A'
        );

        $lastId = $this->requerimientos->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $requerimiento);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
	public function obtenerDatosRequerimiento()
	{
		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idRequerimiento = $this->request->getPost('idRequerimiento');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idRequerimiento, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosRequerimiento = $this->requerimientos->where('IDRequerimiento', $idRequerimiento)->first();

		if(!empty($datosRequerimiento)){
			$resultado = array(
				'idrequerimiento'   => (string) $idRequerimiento,
				'requerimiento'     => (string) $datosRequerimiento['Requerimiento'],
				'tipo'              => (string) $datosRequerimiento['Tipo'],
				'observacion'       => (string) $datosRequerimiento['Observacion']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}
	
	public function modificarRequerimiento($idRequerimiento)
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $requerimiento  = ucwords(mb_strtolower($this->request->getPost('txtRequerimiento_ireq'))) ;
        $tipo           = $this->request->getPost('txtTipoRequerimiento_ireq');
        $observacion    = $this->request->getPost('txtObservacionRequerimiento_ireq');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($requerimiento, 'required|trim|minlength[1]|maxlength[50]', 'Requerimiento');
        $error .= $this->complementos->validaCampo($tipo, 'required|trim|minlength[1]|maxlength[10]', 'Tipo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'Requerimiento'     => $requerimiento,
            'Tipo'              => $tipo,
            'Observacion'       => $observacion,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->requerimientos->update([$idRequerimiento], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $requerimiento);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
	}
	
    public function modificarEstadoRequerimiento()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idRequerimiento = $this->request->getPost('idRequerimiento');
        $estado = $this->request->getPost('estado');
        $motivo = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idRequerimiento, 'required|trim|numeric', 'ID Requerimiento');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        $lastId = $this->requerimientos->update([$idRequerimiento], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idRequerimiento);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
//     public function listadoRequerimientos()
//     {
//         $tipoRequerimiento = $this->request->getPost("tipoRequerimiento");
        
//         if($tipoRequerimiento != '' && $tipoRequerimiento != null && $tipoRequerimiento != "undefined")
//         {
//             $listado = $this->requerimientos->where("Tipo", $tipoRequerimiento)->findAll();
//         }
//         else
//         {
//             $listado = $this->requerimientos->findAll();
//         }
        
//         $elementos=array();

// 		if (!empty($listado)) {
//             foreach ($listado as $items) {
//                 $elementos[] = array(
// 					'id' => (string) $items['IDRequerimiento'],
//                     'text' => (string) $items['Requerimiento']
//                 );
//             }

//             $resultado = array(
// 				'listadoRequerimientos' => json_encode($elementos)
// 			);
//         } else {
// 			$resultado = array(
// 				'descripcion' => 0,
// 			);
// 		}

//         /*
//          * ----------------------------
//          * DATOS DE AJAX PRE PROCESADOS
//          * ----------------------------
//          */
//         echo json_encode($resultado, JSON_NUMERIC_CHECK);		
//     }

    public function listadoTipoRequerimientos()
    {
        if(isset($this->items['id']))
        {
            $grupoTrabajo = $this->request->getPost("grupoTrabajo");
            
            if($grupoTrabajo != '' && $grupoTrabajo != null && $grupoTrabajo != "undefined")
            {
                $where = array(
                    "grupoTrabajo" => $grupoTrabajo,
                    "estado"    => "A");
                
                $listado = $this->requerimientosGruposTrabajo->listadoTipoRequerimientos($where);
            }
            else
            {
                $listado =array();
            }
            
            $elementos=array();
    
    		if (!empty($listado)) {
                foreach ($listado as $items) {
                    $elementos[] = array(
    					'id' => (string) $items['Tipo'],
                        'text' => (string) $items['Tipo']
                    );
                }
    
                $resultado = array(
    				'listadoTipoRequerimientos' => json_encode($elementos)
    			);
            } else {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
        } 
        else 
        {
    		$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
    }


    public function listadoRequerimientos()
    {
        if(isset($this->items['id']))
        {
            $tipoRequerimiento = $this->request->getPost("tipoRequerimiento");
            $grupoTrabajo = $this->request->getPost("grupoTrabajo"); 
            
            if($tipoRequerimiento != '' && $tipoRequerimiento != null && $tipoRequerimiento != "undefined")
            { 
                $where = array(
                    "perfil"    => $this->items['idPerfil'],
                    "estado"    => "A",
                    "tipo"      => $tipoRequerimiento,
                    "grupoTrabajo" => $grupoTrabajo);
                
                $listado = $this->requerimientos->listadoRequerimientos($where);
            }
            else
            {
                $listado = array();
            }
            
            $elementos=array();
    
    		if (!empty($listado)) {
                foreach ($listado as $items) {
                    $elementos[] = array(
    					'id' => (string) $items['IDRequerimiento'],
                        'text' => (string) $items['Requerimiento']
                    );
                }
    
                $resultado = array(
    				'listadoRequerimientos' => json_encode($elementos)
    			);
            } else {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
        } 
        else 
        {
    		$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
    }
    
	public function listarPerfilesRequerimiento($idRequerimiento)
    {
		if(isset($this->items['id'])){
			/* BUSCAR PERMISOS*/
            
			$listaPerfiles = $this->requerimientosPerfil->listarPerfilesRequerimiento($idRequerimiento);
            $requerimiento = $this->requerimientos->where("IDRequerimiento", $idRequerimiento)->first();
            
			$data = array (
				'session'           => 'on',
				'titulo'            => 'Perfiles Permitidos | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Perfiles Permitidos - '.$requerimiento['Requerimiento'],
                'previo'            => 'listar-requerimientos',
				'listaPerfiles'     => $listaPerfiles,
                'requerimiento'     => $requerimiento,
                'idRequerimiento'   => $idRequerimiento
			);
			$data = array_merge($data, $this->items);
			return view('configuracion/listar_perfiles_requerimiento',$data);			
		} else {
			return view('errors/500');
		}
	}

    public function guardarPerfilesRequerimiento($idRequerimiento)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $perfiles = $this->request->getPost('perfiles') ;
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';

        if(isset($perfiles) && empty($perfiles))
        {
            $error .= "<li>No hay perfiles seleccionados.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        /*
        * ----------------------------
        * LIMPIAR EXISTENCIA PREVIA
        * ----------------------------
        */

        $listadoPerfilesPrev = $this->requerimientosPerfil->where("IDRequerimiento", $idRequerimiento)->findAll();

        if(count($listadoPerfilesPrev) > 0)
        {
            $this->requerimientosPerfil->delete($idRequerimiento);
        }

        /*
        * ----------------------------
        * GENERAR NUEVA DATA
        * ----------------------------
        */

        $dataPerfiles = array();

        foreach($perfiles as $key => $value)
        {
            $dataPerfiles[] = array (
                'IDRequerimiento'   => $idRequerimiento, 
                'IDPerfil'          => $key,
                'UsuarioRegistra'   => $this->items['id'],
                'FechaRegistra'     => $fechaActual
            );
        }
        $lastId = $this->requerimientosPerfil->insertBatch($dataPerfiles, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idRequerimiento);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function listarGruposTrabajoRequerimiento($idRequerimiento)
    {
        if(isset($this->items['id'])){
			/* BUSCAR PERMISOS*/
            
			$listaGruposTrabajo = $this->requerimientosGruposTrabajo->listarGruposTrabajoRequerimiento($idRequerimiento);
            $requerimiento = $this->requerimientos->where("IDRequerimiento", $idRequerimiento)->first();
            
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Grupos de Trabajo autorizados | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Grupos de Trabajo autorizados a gestionar - '.$requerimiento['Requerimiento'],
                'previo'                => 'listar-requerimientos',
				'listaGruposTrabajo'    => $listaGruposTrabajo,
                'requerimiento'         => $requerimiento,
                'idRequerimiento'       => $idRequerimiento
			);
			$data = array_merge($data, $this->items);
			return view('configuracion/listar_grupos_trabajo_requerimiento',$data);			
		} else {
			return view('errors/500');
		}
    }
    
    public function listadoGruposTrabajoRequerimiento()
    {
        $idRequerimiento = $this->request->getPost("idRequerimiento");
        
        if($idRequerimiento == 'TOTAL')
        {
            $listadoGruposTrabajo = $this->grupostrabajo->findAll();
        }
        else
        {
            // $whereGTR = array('IDRequerimiento' => $idRequerimiento);
            $listadoGruposTrabajo = $this->requerimientosGruposTrabajo->listarGruposTrabajoRequerimientoXRequerimiento($idRequerimiento);
        }
        
        $elementos=array();

		if (!empty($listadoGruposTrabajo)) {
            foreach ($listadoGruposTrabajo as $items) {
                $elementos[] = array(
					'id' => (string) $items['IDGrupoTrabajo'],
                    'text' => (string) $items['GrupoTrabajo']
                );
            }

            $resultado = array(
				'listadoGruposTrabajo' => json_encode($elementos)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);
    }
    
    public function guardarGruposTrabajoRequerimiento($idRequerimiento)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $grupostrabajo = $this->request->getPost('grupotrabajo') ;
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';

        if(isset($grupostrabajo) && empty($grupostrabajo))
        {
            $error .= "<li>No hay grupos de trabajo seleccionados.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        /*
        * ----------------------------
        * LIMPIAR EXISTENCIA PREVIA
        * ----------------------------
        */

        $listadoGruposTrabajoPrev = $this->requerimientosGruposTrabajo->where("IDRequerimiento", $idRequerimiento)->findAll();

        if(count($listadoGruposTrabajoPrev) > 0)
        {
            $this->requerimientosGruposTrabajo->delete($idRequerimiento);
        }

        /*
        * ----------------------------
        * GENERAR NUEVA DATA
        * ----------------------------
        */

        $dataGruposTrabajo = array();

        foreach($grupostrabajo as $key => $value)
        {
            $dataGruposTrabajo[] = array (
                'IDRequerimiento'   => $idRequerimiento, 
                'IDGrupoTrabajo'    => $key,
                'UsuarioRegistra'   => $this->items['id'],
                'FechaRegistra'     => $fechaActual
            );
        }
        $lastId = $this->requerimientosGruposTrabajo->insertBatch($dataGruposTrabajo, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idRequerimiento);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function listarMotivosRequerimiento($idRequerimiento)
    {
        if(isset($this->items['id'])){

			/* ACCIONES */
            $requerimiento = $this->requerimientos->where('IDRequerimiento', $idRequerimiento)->first();
			$listaMotivos = $this->requerimientosMotivo->where('IDRequerimiento', $idRequerimiento)->findAll();
			
			$data = array (
				'session'           => 'on',
				'titulo'            => 'Motivos de Requerimiento | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Motivos - '.$requerimiento['Requerimiento'],
                'previo'            => 'listar-requerimientos',
                'requerimiento'     => $requerimiento,
				'listaMotivos'      => $listaMotivos
			);
			$data = array_merge($data, $this->items);
			return view('configuracion/listar_motivos_requerimiento',$data);			
		} else {
			return view('errors/500');
		}
    }
    
    public function registrarMotivoRequerimiento()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError       = TRUE;
        $requerimiento  = $this->request->getPost('txtIDRequerimiento_i');
        $motivo         = ucwords(mb_strtolower($this->request->getPost('txtMotivoRequerimiento_i')));
        $observacion    = $this->request->getPost('txtObservacionMotivoReq_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($requerimiento, 'required|trim|number', 'ID Requerimiento');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim|minlength[1]|maxlength[100]', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereMotivo = array(
            'IDRequerimiento'   => $requerimiento,
            'Motivo'            => $motivo
        );
        
		$motivoExistente = $this->requerimientosMotivo->where($whereMotivo)->findAll();
        
        if(count($motivoExistente)>0)
        {
            $msgExistencia .= "<li>El motivo ya fue registrado. [CAMPO] <small>MOTIVO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'IDRequerimiento'   => $requerimiento,
            'Motivo'            => $motivo,
            'Observacion'       => $observacion,
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'Estado'            => 'A',
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,    
            'MotivoEstado'      => 'Motivo de requerimiento creada.'
        );

        $lastId = $this->requerimientosMotivo->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $motivo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	public function obtenerDatosMotivoRequerimiento() {

		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idMotivo = $this->request->getPost('idMotivo');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idMotivo, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosMotivo = $this->requerimientosMotivo->where('IDMotivo', $idMotivo)->first();

		if(!empty($datosMotivo)){
			$resultado = array(
				'idmotivo'      => (string) $idMotivo,
				'motivo'        => (string) $datosMotivo['Motivo'],
				'observacion'   => (string) $datosMotivo['Observacion']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}
	
    public function modificarMotivoRequerimiento($idMotivo){

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        $msjError       = TRUE;
        $motivo         = ucwords(mb_strtolower($this->request->getPost('txtMotivoRequerimiento_i')));
        $observacion    = $this->request->getPost('txtObservacionMotivoReq_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($motivo, 'required|trim|minlength[1]|maxlength[100]', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */
        
        $data = array (
            'Motivo'            => $motivo,
            'Observacion'       => $observacion,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->requerimientosMotivo->update([$idMotivo], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idMotivo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function modificarEstadoMotivoRequerimiento()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idMotivo = $this->request->getPost('idMotivo');
        $estado = $this->request->getPost('estado');
        $motivo = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idMotivo, 'required|trim|numeric', 'ID Motivo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'Estado'            => $estado,
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,    
            'MotivoEstado'      => $motivo
        );
        
        $lastId = $this->requerimientosMotivo->update([$idMotivo], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idMotivo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function listadoMotivosRequerimiento()
    {
        $idRequerimiento = $this->request->getPost("idRequerimiento");
        
        if($idRequerimiento != '' && $idRequerimiento != null && $idRequerimiento != "undefined")
        {
            $whereMotivos = array(
                "IDRequerimiento"   => $idRequerimiento,
                "Estado"            => "A"
            );
        }
        else
        {
            $whereMotivos = array(
                "IDRequerimiento"   => $idRequerimiento,
                "Estado"            => "A"
            );
        }
        
        $listado = $this->requerimientosMotivo->where($whereMotivos)->findAll();
        
        $elementos=array();

		if (!empty($listado)) {
            foreach ($listado as $items) {
                $elementos[] = array(
					'id' => (string) $items['IDMotivo'],
                    'text' => (string) $items['Motivo'],
                    'adjunto' => (string) $items['RequiereAdjunto']
                );
            }

            $resultado = array(
				'listadoMotivos' => json_encode($elementos)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
    }
        


	public function registrarGrupoTrabajo()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $grupoTrabajo  = ucwords(mb_strtolower($this->request->getPost('txtGrupoTrabajo_i')));
        $observacion    = $this->request->getPost('txtObservacionGrupoTrabajo_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($grupoTrabajo, 'required|trim|minlength[1]|maxlength[50]', 'Grupo de Trabajo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$gtExistente = $this->grupostrabajo->where("GrupoTrabajo", $grupoTrabajo)->findAll();
        
        if(count($gtExistente)>0)
        {
            $msgExistencia .= "<li>El grupo de trabajo ya fue registrado. [CAMPO] <small>GRUPO DE TRABAJO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'GrupoTrabajo'  => $grupoTrabajo,
            'Observacion'   => $observacion,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress(),
            'UsuarioEstado' => $this->items['id'],
            'FechaEstado'   => $fechaActual,    
            'MotivoEstado'  => "Creación de grupo de trabajo.",    
            'Estado'        => 'A'
        );

        $lastId = $this->grupostrabajo->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $grupoTrabajo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
	public function obtenerDatosGrupoTrabajo()
	{
		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idGrupoTrabajo = $this->request->getPost('idGrupoTrabajo');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idGrupoTrabajo, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosGrupoTrabajo = $this->grupostrabajo->where('IDGrupoTrabajo', $idGrupoTrabajo)->first();

		if(!empty($datosGrupoTrabajo)){
			$resultado = array(
				'idgrupotrabajo'    => (string) $idGrupoTrabajo,
				'grupotrabajo'      => (string) $datosGrupoTrabajo['GrupoTrabajo'],
				'observacion'       => (string) $datosGrupoTrabajo['Observacion']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}
	
	public function modificarGrupoTrabajo($idGrupoTrabajo)
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $grupoTrabajo  = ucwords(mb_strtolower($this->request->getPost('txtGrupoTrabajo_i'))) ;
        $observacion    = $this->request->getPost('txtObservacionGrupoTrabajo_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($grupoTrabajo, 'required|trim|minlength[1]|maxlength[50]', 'Grupo de Trabajo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'GrupoTrabajo'      => $grupoTrabajo,
            'Observacion'       => $observacion,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->grupostrabajo->update([$idGrupoTrabajo], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $grupoTrabajo);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
	}
	
    public function modificarEstadoGrupoTrabajo()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idGrupoTrabajo = $this->request->getPost('idGrupoTrabajo');
        $estado = $this->request->getPost('estado');
        $motivo = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idGrupoTrabajo, 'required|trim|numeric', 'ID Grupo de Trabajo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        $lastId = $this->grupostrabajo->update([$idGrupoTrabajo], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idGrupoTrabajo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function listadoGruposTrabajo()
    {
        // $tipoRequerimiento = $this->request->getPost("tipoRequerimiento");
        
        // if($tipoRequerimiento != '' && $tipoRequerimiento != null && $tipoRequerimiento != "undefined")
        // {
        //     $listado = $this->requerimientos->where("Tipo", $tipoRequerimiento)->findAll();
        // }
        // else
        // {
        //     $listado = $this->requerimientos->findAll();
        // }
        
        $listado = $this->grupostrabajo->findAll();
        
        $elementos=array();

		if (!empty($listado)) {
            foreach ($listado as $items) {
                $elementos[] = array(
					'id' => (string) $items['IDGrupoTrabajo'],
                    'text' => (string) $items['GrupoTrabajo']
                );
            }

            $resultado = array(
				'listadoGruposTrabajo' => json_encode($elementos)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
    }
    
    public function listarUsuariosGrupoTrabajo($idGrupoTrabajo)
    {
        if(isset($this->items['id'])){
			/* BUSCAR ACCIONES */
			$whereUGT = array(
			    "idgrupotrabajo"    => $idGrupoTrabajo
			);
			$grupoTrabajo = $this->grupostrabajo->where("IDGrupoTrabajo", $idGrupoTrabajo)->first();
			$listaUsuarios = $this->usuarioGruposTrabajo->listarUsuariosGrupoTrabajo($whereUGT);
            
			$data = array (
				'session'           => 'on',
				'titulo'            => 'Usuarios - Grupo de Trabajo | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Usuarios asociados - '.$grupoTrabajo['GrupoTrabajo'],
                'previo'            => 'listar-grupos-trabajo',
				'listaUsuarios'     => $listaUsuarios,
                'idGrupoTrabajo'    => $idGrupoTrabajo
			);
			$data = array_merge($data, $this->items);
			return view('configuracion/listar_usuarios_grupo_trabajo',$data);			
		} else {
			return view('errors/500');	
		}
    }
    
    public function asociarUsuarioGrupoTrabajo()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError       = TRUE;
        $idUsuario      = $this->request->getPost('idUsuario');
        $idGrupoTrabajo = $this->request->getPost('idGrupoTrabajo');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idUsuario, 'required|trim|number', 'ID Usuario');
        $error .= $this->complementos->validaCampo($idGrupoTrabajo, 'required|trim|number', 'ID Grupo de Trabajo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereUGT = array(
            'IdUsuario'         => $idUsuario,
            'IDGrupoTrabajo'    => $idGrupoTrabajo
        );
        
		$combinacionExistente = $this->usuarioGruposTrabajo->where($whereUGT)->findAll();
		
        if(count($combinacionExistente)>0)
        {
            $msgExistencia .= "<li>El usuario ya fue agregado al grupo de trabajo. [CAMPO] <small>USUARIO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'IdUsuario'         => $idUsuario, 
            'IDGrupoTrabajo'    => $idGrupoTrabajo,
            'UsuarioRegistra'   => $this->items['id'],
            'FechaRegistra'     => $fechaActual
        );

        $lastId = $this->usuarioGruposTrabajo->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function eliminarUsuarioGrupoTrabajo()
    {
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $idUsuario      = $this->request->getPost('idUsuario');
        $idGrupoTrabajo = $this->request->getPost('idGrupoTrabajo');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idUsuario, 'required|trim|number', 'ID Usuario');
        $error .= $this->complementos->validaCampo($idGrupoTrabajo, 'required|trim|number', 'ID Grupo de Trabajo');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $whereDelete = array (
            'IdUsuario'         => $idUsuario, 
            'IDGrupoTrabajo'    => $idGrupoTrabajo
        );

        $lastId = $this->usuarioGruposTrabajo->where($whereDelete)->delete();

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg504, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

    public function listarUsuariosGrupoTrabajoSelect()
    {
        $elemento = $this->request->getPost('term');
        $infoPeticion = $this->peticiones->where("IDPeticion", $elemento['peticion'])->first();
        $whereUGT = array(
		    "idgrupotrabajo"=> $infoPeticion['IDGrupoTrabajoDestino'],
		    "like"          => $elemento['term']
		);
		
		$listado = $this->usuarioGruposTrabajo->listarUsuariosGrupoTrabajo($whereUGT);
        
        // $listado = $this->usuarioModelo->listadoUsuariosSelect($elemento['term'], '', 'Activo');
        
        $elementos=array();

        foreach ($listado as $items) {
            $elementos[] = array(
                'id' => (string) $items['IdUsuario'],
                'text' => (string) $items['Matricula']." | ".$items['Nombres']." ".$items['Apellidos']
            );
        }

        echo json_encode($elementos);
    }
    
	/**************************************************************************/
	
    /************************* FORMATOS DE APROBACIÓN *************************/
    
    public function listarFormatosAprobacion()
    {
        if(isset($this->items['id']))
        {
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Formatos de Aprobación | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Formatos de Aprobación',
				'elementoSeleccionadoModulo'=> "Listado de Formatos",
				'subtitulo'                 => 'Formatos de Aprobación'
			);
			
			$data = array_merge($data, $this->items);
			
			return view('configuracion/listar_formatos_aprobacion',$data);			
		} 
		else 
		{
			return view('errors/500');
		}
    }
    
    public function formatosAprobacionServerside()
    {
        if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id']
            );
            
            /* LISTAR FORMATOS DE APROBACIÓN */
            $dataServerside = $this->formatosAprobacion->listaGeneralFormatosAprobacion($this->request->getPost(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
    			if(in_array("ESTFAP", $this->items['permisos']))
    			{
        			$dataServerside["data"][$key]['EstadoFormato'] = '<button class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0 cambiar-estado-formato-aprobacion" data-estado="'.$value['Estado'].'" data-id="'.$value['IDFormatoAprobacion'].'">'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</button>';
    			}
    			else
    			{
    			    $dataServerside["data"][$key]['EstadoFormato'] = '<span class="badge '.($value['Estado'] == "A" ? 'bg-success' : 'bg-danger').' border-0" >'.($value['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO').'</span>';
    			}
    			
                $acciones = '';
                
                $acciones .= '<button class="badge bg-info border-0 p-2 mx-1 datos-formato-aprobacion" data-bs-target="#registrarFormatoAprobacion" data-form="#formRegistrarFormatoAprobacion" data-id="'.$value['IDFormatoAprobacion'].'" data-accion="ver" id="ver-formato-aprobacion" data-tooltip="tooltip" title="Ver Información Formato Aprobación">
    				<i class="mdi mdi-eye align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			
    			if(in_array("UPDFAP", $this->items['permisos']))
    			{
    			$acciones .= '<button class="badge bg-warning border-0 p-2 mx-1 datos-formato-aprobacion" data-bs-target="#registrarFormatoAprobacion" data-form="#formRegistrarFormatoAprobacion" data-id="'.$value['IDFormatoAprobacion'].'" data-accion="editar" id="editar-formato-aprobacion" data-tooltip="tooltip" title="Editar Formato Aprobación">
    				<i class="mdi mdi-pencil align-bottom" style="font-size: 20px; color: #FFF;"></i>
    			</button>';
    			}
    			
    			$acciones .= '<a data-url="'.$this->items['baseUrl'].'/'.$value['PlantillaFormato'].'" onclick="return abrirPlantillaFormatoAprobacion(this);" class="badge bg-sistema border-0 p-2 mx-1" data-tooltip="tooltip" data-toggle="tooltip" data-placement="top" aria-label="Ver Documento de Formato de Aprobación">
                    <i class="mdi mdi-file-sign align-bottom" style="font-size: 20px; color: #FFF;"></i>
                </a>';
    			
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    	else
    	{
    	    $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    }
    
	/**************************************************************************/
	
    /************************* FORMATOS DE APROBACIÓN *************************/
    
}