<?php

namespace App\Controllers;

require_once APPPATH.'Libraries/spout-3.3.0/src/Spout/Autoloader/autoload.php';

use CodeIgniter\Controller;
use CodeIgniter\HTTP\CLIRequest;
use CodeIgniter\HTTP\IncomingRequest;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

use \App\Libraries\Complementos;
use \App\Libraries\Globales;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;
use \App\Libraries\PlantillasCorreo;


use App\Models\UsuarioPerfilModel;
use App\Models\UsuarioRutasModel;
use App\Models\UsuarioSistemasModel;
use App\Models\ModulosRutasModel;
use App\Models\ModulosCabeceraModel;
use App\Models\UsuarioLogModel;
use App\Models\UsuarioGruposTrabajoModel;
use App\Models\NotificacionesModel;

/**
 * Class BaseController
 *
 * BaseController provides a convenient place for loading components
 * and performing functions that are needed by all your controllers.
 * Extend this class in any new controllers:
 *     class Home extends BaseController
 *
 * For security be sure to declare any new methods as protected or private.
 */
abstract class BaseController extends Controller
{
    /**
     * Instance of the main Request object.
     *
     * @var CLIRequest|IncomingRequest
     */
    protected $request;

    /**
     * An array of helpers to be loaded automatically upon
     * class instantiation. These helpers will be available
     * to all other controllers that extend BaseController.
     *
     * @var list<string>
     */
    protected $helpers = ['form', 'url'];

    /**
     * Be sure to declare properties for any property fetch you initialized.
     * The creation of dynamic property is deprecated in PHP 8.2.
     */
    protected $session;
    // protected $encripto;

    /**
     * @return void
     */
    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        $fechaActual = date("Y-m-d H:i:s");
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);
        
        $this->notificaciones = new \App\Models\NotificacionesModel();
        $this->complementos = new Complementos();
        $this->globales = new Globales();
        $this->scripts = new Scripts();
        $this->error = new Error();
        $this->alertas = new Alertas();	
        $this->pdf = new Pdf();
        $this->plantillasCorreo = new PlantillasCorreo();
        $this->mensajeError = $this->error->msg();
        $this->session = \Config\Services::session();
        
        $this->encripto = service('encrypter');
		$this->items['baseUrl'] = base_url();
		$this->items['basePublic'] = 'public';
		$this->items['baseDinamic'] = 'public';
		$this->items['aleatorio'] = $this->complementos->generar_string_aleatorio(5);
		
        //Obtener url actual
        $uri = new \CodeIgniter\HTTP\URI($this->request->getUri());
        
        $ruta = $uri->getSegment(3);
		$this->items['raiz'] = $uri->getSegment(1);
		
        $rutasExcluidas = array('salir', 'entrar');
        $rutasExternas = $this->globales->urlExternos();
        
        //Si la ruta no est incluida en las excluidas, ingresa a la validacin
        if(!in_array($ruta,$rutasExcluidas))
        {
            //Si la ruta no est incluida en las externas, ingresa a la validacin
            if(!in_array($ruta,$rutasExternas))
            {
                if(isset($this->session->get('sesionUsuario')['accesoTmpId']))
                {
                    $this->usuarioPerfil = new UsuarioPerfilModel();
                    $this->usuarioRutas = new UsuarioRutasModel();
                    $this->usuarioSistemas = new UsuarioSistemasModel();
                    $this->modulosRutas = new ModulosRutasModel();
                    $this->modulosCabecera = new ModulosCabeceraModel();
    		        $this->log = new UsuarioLogModel();
    
                    // if($this->session->get('sesionUsuario')['accesoTmpId'] != '4373')
                    // {
                        // $aud = array(
                        //     'IDUsuario'     => $this->session->get('sesionUsuario')['accesoTmpId'],
                        //     'FechaIngreso'  => $fechaActual,
                        //     'Plataforma'    => $uri->getSegment(1),
                        //     'URL'           => $uri->getSegment(3),
                        //     'JSON'          => null,
                        //     'Localhost'     => $this->request->getIPAddress()
                        // );
                        
                        // $this->log->insert($aud);
                    // }
                    
                    /*
                    * ----------------------
                    * VALIDA PERMISOS DE ACCESO AL SISTEMA
                    * ----------------------
                    */
                    
                    // $autorizacionSistema = $this->usuarioSistemas->join('sistemas', 'usuario_sistemas.IDSistema = sistemas.IDSistema AND usuario_sistemas.IdUsuario = "'.$this->session->get('sesionUsuario')['accesoTmpId'].'"  AND sistemas.Raiz = "compras"')->findAll();
                    
                    // if(!empty($autorizacionSistema))
                    // {
                        /*
                        * ----------------------
                        * VALIDA PERMISOS DE URL
                        * ----------------------
                        */
        
                        $array = array("ruta" => $ruta, "idusuario" => $this->session->get('sesionUsuario')['accesoTmpId']);
                        
                        $vista = $this->usuarioPerfil->obtenerRutaUsuario($array);
                        
                        $rutasGlobales = $this->globales->urlLibres();
    
                        if((count($vista)>0 && $vista['AUTORIZADO']=='1') || in_array($ruta,$rutasGlobales))
                        {
                        
                            /*
                            * ----------------------
                            * OBTENER NOTIFICACIONES NO VISTAS
                            * ----------------------
                            */
                            
                            $arrayNoVistos = array(
                                "idusuario" => $this->session->get('sesionUsuario')['accesoTmpId'],
                                "idperfil" => $this->session->get('sesionUsuario')['accesoTmpIDPerfil']
                            );
                            
                		    $arrayNoVistos = $this->notificaciones->cantidadNotificacionesSinVer($arrayNoVistos);
                		  //  $arrayNoVistos = array();
                            /*
                            * ----------------------
                            * ARMAR VARIABLES GLOBALES
                            * ----------------------
                            */
            
                            $this->items['id'] = $this->session->get('sesionUsuario')['accesoTmpId'];
                            $this->items['usuario'] = $this->session->get('sesionUsuario')['accesoTmpUsuario'];
                            $this->items['matriculaLog'] = $this->session->get('sesionUsuario')['accesoTmpMatricula'];
                            $this->items['idPerfil'] = $this->session->get('sesionUsuario')['accesoTmpIDPerfil'];
                            $this->items['perfil'] = $this->session->get('sesionUsuario')['accesoTmpPerfil'];
                            $this->items['dpto'] = $this->session->get('sesionUsuario')['accesoTmpIdDpto'];
                            $this->items['idArea'] = $this->session->get('sesionUsuario')['accesoTmpIdArea'];
                            $this->items['idSubarea'] = $this->session->get('sesionUsuario')['accesoTmpIdSubarea'];
                            $this->items['idDelegacionLog'] = $this->session->get('sesionUsuario')['accesoTmpIdDelegacion'];
                            $this->items['idCargoLog'] = $this->session->get('sesionUsuario')['accesoTmpIdCargo'];
                            
                            $this->items['notificacionesNoVistasInicio'] = isset($arrayNoVistos['TOTALNOVISTO']) ? $arrayNoVistos['TOTALNOVISTO'] : 0;
                            
                            $this->items['nombres'] = $this->session->get('sesionUsuario')['accesoTmpNombres'];
                            $this->items['apellidos'] = $this->session->get('sesionUsuario')['accesoTmpApellidos'];
                            $this->items['tipoDocumento'] = $this->session->get('sesionUsuario')['accesoTmpTipoDocumento'];
                            $this->items['numeroDocumento'] = $this->session->get('sesionUsuario')['accesoTmpNumeroDocumento'];
                            $this->items['correoElectronico'] = $this->session->get('sesionUsuario')['accesoTmpCorreoElectronico'];
                            $this->items['cargo'] = $this->session->get('sesionUsuario')['accesoTmpCargo'];
                            $this->items['permisos'] = array_column($this->modulosRutas->listadoPermisosUsuarioRuta($this->session->get('sesionUsuario')['accesoTmpId'], $ruta), 'Codigo');
                            $this->items['navbar'] = $this->usuarioRutas->navBarUsuario($this->session->get('sesionUsuario')['accesoTmpId']);
                            $this->items['cabecera'] = $this->modulosCabecera->where("Estado","A")->orderBy('Orden', 'ASC')->findAll();
                            $this->items['linkbaseperfil'] = $vista['URLBase'];
                            
                            //Validar url externas
                            if(in_array($ruta, $rutasGlobales))
                            {
                                $this->items['modulo'] = "Libre";
                            }
                            else
                            {
                                $this->items['modulo'] = $this->modulosRutas->obtenerModulo(array("ruta"=>$ruta))['Modulo'];
                            }
                            
                            $this->items['sistemas'] = $this->usuarioSistemas->join('sistemas', 'usuario_sistemas.IDSistema = sistemas.IDSistema AND usuario_sistemas.IdUsuario = "'.$this->session->get('sesionUsuario')['accesoTmpId'].'"')->findAll();
    
                        }
                        else
                        {
                            echo $this->alertas->reDireccion($this->items['baseUrl'] . '/' .$vista['URLBase'], 1);
                            EXIT;
                        }
                    // }
                    // else
                    // {
                    //     if ($this->session->has('sesionUsuario')) {
                    //         $this->session->destroy('sesionUsuario');
                    //         $this->session->remove('sesionUsuario');
                    //     }
                        
                    //     echo $this->alertas->reDireccion($this->items['baseUrl'] . '/', 1);
                    // }
                } 
                else 
                {
                    // echo "sin sesion";exit;
                    $data = array (
                        'titulo' => 'Landings Verisure | Verisure',
                    );
                    $data = array_merge($data, $this->items);
                    echo view('dashboard/iniciar-sesion',$data);exit;
                }
            }
        }
        // Preload any models, libraries, etc, here.

        // E.g.: $this->session = \Config\Services::session();
    }
    
    public function insertarNotificacion($array)
	{
	    $tablaReferencia        = $array['tabla'];
        $idReferencia           = $array['idreferencia'];
        $mensaje                = $array['mensaje'];
        $url                    = $array['url'];
        $usuarioDestino         = $array['usuariodestino'];
        $idGrupoTrabajoDestino  = $array['gtdestino'];
        $idPerfilDestino        = $array['perfildestino'];
        $usuarioRegistra        = $array['usuarioregistra'];
        $fechaRegistra          = $array['fecharegistra'];
        
        $dataNotificacion = array (
            'TablaReferencia'       => $tablaReferencia, 
            'IDReferencia'          => $idReferencia,
            'Mensaje'               => $mensaje, 
            'URL'                   => $url, 
            'IDUsuarioDestino'      => $usuarioDestino, 
            'IDGrupoTrabajoDestino' => $idGrupoTrabajoDestino, 
            'IDPerfilDestino'       => $idPerfilDestino,
            'UsuarioRegistra'       => $usuarioRegistra,
            'FechaRegistra'         => $fechaRegistra
        );
        
        $this->notificaciones->insert($dataNotificacion, TRUE);
	}
}
