<?php

use CodeIgniter\Router\RouteCollection;
$routes->get('test-controller', 'TestController::index');
// $routes->add('test', function() {
//     return 'Ruta de prueba funcionando';
// });
/**
 * @var RouteCollection $routes
 */
// $routes->get('/', 'Home::index');
$routes->set404Override(function()
{
    echo view('errors/404');
});
/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.
$routes->get('/', 'Acceso::login');

/* ACCESO */
$routes->add('entrar', 'Acceso::entrar');
$routes->add('salir','Acceso::salir');
$routes->add('iniciar-sesion','Acceso::login');
$routes->add('cambiar-password', 'Acceso::cambiarPasswordUsuario');

/* ADMINISTRACIÓN */
$routes->add('descargatxt/(:any)','Administracion::descargatxt/$1');/* NUEVO */

$routes->add('listar-usuarios','Administracion::listarUsuarios');/* NUEVO */

$routes->add('listar-perfiles','Administracion::listarPerfiles');/* NUEVO */
$routes->add('registrar-perfil','Administracion::registrarPerfil');/* NUEVO */
$routes->add('listado-perfil-select','Administracion::listadoPerfilesSelect');/* NUEVO */
$routes->add('obtener-datos-perfil','Administracion::obtenerDatosPerfil');/* NUEVO */
$routes->add('actualizar-perfil/(:any)','Administracion::actualizarPerfil/$1');/* NUEVO */
$routes->add('cambiar-estado-perfil','Administracion::modificarEstadoPerfil');/* NUEVO */

$routes->add('listar-permisos-perfil/(:any)','Administracion::listarPermisosPerfil/$1');/* NUEVO */
$routes->add('grabar-permisos-perfil/(:any)','Administracion::guardarPermisosPerfil/$1');/* NUEVO */
$routes->add('listar-rutas-perfil/(:any)','Administracion::listarRutasPerfil/$1');/* NUEVO */
$routes->add('grabar-rutas-perfil/(:any)','Administracion::guardarRutasPerfil/$1');/* NUEVO */

$routes->add('obtener-cabecera','Administracion::obtenerCabecera');/* NUEVO */
$routes->add('listar-modulos','Administracion::listarModulos');/* NUEVO */
$routes->add('registrar-modulo','Administracion::registrarModulo');/* NUEVO */
$routes->add('cambiar-estado-modulo','Administracion::modificarEstadoModulo');/* NUEVO */
$routes->add('obtener-datos-modulo','Administracion::obtenerDatosModulo');/* NUEVO */
$routes->add('actualizar-modulo/(:any)','Administracion::modificarModulo/$1');/* NUEVO */
$routes->add('listar-rutas-modulo/(:any)','Administracion::listarRutasModulo/$1');/* NUEVO */
$routes->add('grabar-ruta/(:any)','Administracion::guardarRutaModulo/$1');/* NUEVO */
$routes->add('obtener-datos-ruta-modulo','Administracion::obtenerDatosRutaModulo');/* NUEVO */
$routes->add('actualizar-ruta-modulo/(:any)','Administracion::modificarRutaModulo/$1');/* NUEVO */
$routes->add('cambiar-estado-ruta-modulo','Administracion::modificarEstadoRutaModulo');/* NUEVO */
$routes->add('listar-acciones-modulo/(:any)','Administracion::listarAccionesModulo/$1');/* NUEVO */
$routes->add('grabar-accion/(:any)','Administracion::guardarAccionModulo/$1');/* NUEVO */

/******************************************************************************/
	
/* USUARIOS */
$routes->add('usuariosServerside','Usuarios::listarUsuarioDataTable');/* NUEVO */
$routes->add('obtener-datos-usuario/(:any)','Usuarios::obtenerDatosUsuario/$1');
$routes->add('modificar-usuario/(:any)','Usuarios::modificarUsuario/$1');/* NUEVO */
$routes->add('listado-usuarios-select','Usuarios::listadoUsuariosSelect');
$routes->add('listado-usuarios-comprador','Usuarios::listadoUsuariosComprador');

$routes->add('listar-permisos-usuario/(:any)','Usuarios::listarPermisosUsuario/$1');/* NUEVO */
$routes->add('grabar-permisos-usuario/(:any)','Usuarios::guardarPermisosUsuario/$1');/* NUEVO */
$routes->add('listar-rutas-usuario/(:any)','Usuarios::listarRutasUsuario/$1');/* NUEVO */
$routes->add('grabar-rutas-usuario/(:any)','Usuarios::guardarRutasUsuario/$1');/* NUEVO */

/******************************************************************************/

/*************************** NOTIFICACIONES ***********************************/
$routes->add('cargar-notificaciones-header','Notificaciones::cargarNotificacionesHeader');/* NUEVO */
$routes->add('cantidad-notificaciones-header','Notificaciones::cantidadNotificacionesHeader');/* NUEVO */
$routes->add('registrar-vista-notificacion','Notificaciones::registrarVisualizacionNotificacion');/* NUEVO */

/******************************************************************************/
	
/******************************* CONFIGURACIÓN ********************************/ 

$routes->add('listar-requerimientos','Configuracion::listarRequerimientos');/* NUEVO */
$routes->add('registrar-requerimiento','Configuracion::registrarRequerimiento');/* NUEVO */
$routes->add('obtener-datos-requerimiento','Configuracion::obtenerDatosRequerimiento');/* NUEVO */
$routes->add('actualizar-requerimiento/(:any)','Configuracion::modificarRequerimiento/$1');/* NUEVO */
$routes->add('cambiar-estado-requerimiento','Configuracion::modificarEstadoRequerimiento');/* NUEVO */
$routes->add('listado-requerimiento','Configuracion::listadoRequerimientos');/* NUEVO */
$routes->add('listado-tipo-requerimiento','Configuracion::listadoTipoRequerimientos');/* NUEVO */

$routes->add('listar-motivos-requerimiento/(:any)','Configuracion::listarMotivosRequerimiento/$1');/* NUEVO */
$routes->add('registrar-motivo-requerimiento','Configuracion::registrarMotivoRequerimiento');/* NUEVO */
$routes->add('obtener-datos-motivo-requerimiento','Configuracion::obtenerDatosMotivoRequerimiento');/* NUEVO */
$routes->add('actualizar-motivo-requerimiento/(:any)','Configuracion::modificarMotivoRequerimiento/$1');/* NUEVO */
$routes->add('cambiar-estado-motivo-requerimiento','Configuracion::modificarEstadoMotivoRequerimiento');/* NUEVO */
$routes->add('listado-motivo-requerimiento','Configuracion::listadoMotivosRequerimiento');/* NUEVO */

$routes->add('listar-perfiles-requerimiento/(:any)','Configuracion::listarPerfilesRequerimiento/$1');/* NUEVO */
$routes->add('grabar-perfiles-requerimiento/(:any)','Configuracion::guardarPerfilesRequerimiento/$1');/* NUEVO */

$routes->add('listar-grupos-trabajo-requerimiento/(:any)','Configuracion::listarGruposTrabajoRequerimiento/$1');/* NUEVO */
$routes->add('grabar-grupos-trabajo-requerimiento/(:any)','Configuracion::guardarGruposTrabajoRequerimiento/$1');/* NUEVO */
$routes->add('listado-grupos-trabajo-requerimiento','Configuracion::listadoGruposTrabajoRequerimiento');/* NUEVO */

$routes->add('listar-grupos-trabajo','Configuracion::listarGruposTrabajo');/* NUEVO */
$routes->add('registrar-grupo-trabajo','Configuracion::registrarGrupoTrabajo');/* NUEVO */
$routes->add('obtener-datos-grupo-trabajo','Configuracion::obtenerDatosGrupoTrabajo');/* NUEVO */
$routes->add('actualizar-grupo-trabajo/(:any)','Configuracion::modificarGrupoTrabajo/$1');/* NUEVO */
$routes->add('cambiar-estado-grupo-trabajo','Configuracion::modificarEstadoGrupoTrabajo');/* NUEVO */
$routes->add('listado-grupos-trabajo','Configuracion::listadoGruposTrabajo');/* NUEVO */

$routes->add('listar-usuarios-grupo-trabajo/(:any)','Configuracion::listarUsuariosGrupoTrabajo/$1');/* NUEVO */
$routes->add('asociar-usuario-grupo-trabajo','Configuracion::asociarUsuarioGrupoTrabajo');/* NUEVO */
$routes->add('eliminar-usuario-grupo-trabajo','Configuracion::eliminarUsuarioGrupoTrabajo');/* NUEVO */
$routes->add('listado-usuarios-grupotrabajo-select','Configuracion::listarUsuariosGrupoTrabajoSelect');/* NUEVO */

$routes->add('matriz-condonacion-cobranza','Configuracion::matrizCondonacionCobranza');/* NUEVO */
$routes->add('matriz-condonacion-cobranza-serverside','Configuracion::matrizCondonacionCobranzaServerside');/* NUEVO */
$routes->add('importar-csv-matriz-condonacion-cobranza','Configuracion::importarCSVMatrizCondonacionCobranza');/* NUEVO */
$routes->add('obtener-datos-matriz-condonacion-cobranza','Configuracion::obtenerDatosMatrizCondonacionCobranza');/* NUEVO */
/******************************************************************************/
	
/*************************** FICHEROS ************************************/

/* AGING */

$routes->add('fichero-aging','Ficheros::listarFicheroAging'); 
$routes->add('fichero-aging-serverside','Ficheros::ficheroAgingServerside'); 
// $routes->add('nuevo-referido','Referidos::viewReferidoATC'); 

/******************************************************************************/

/* ITEM */

$routes->add('fichero-item','Ficheros::listarFicheroItem'); 
$routes->add('subir-csv-fichero-item', 'Ficheros::subirCsvFicheroItem'); 
$routes->add('fichero-item-serverside','Ficheros::ficheroItemServerside'); 
	
/********************************** PROCESOS **********************************/ 

/* PETICIONES */

$routes->add('listar-peticiones','Peticiones::listarPeticiones');/* NUEVO */
$routes->add('grabar-peticion','Peticiones::registrarPeticion');/* NUEVO */
$routes->add('detalle-peticion/(:any)','Peticiones::detallePeticion/$1');/* NUEVO */
$routes->add('cambio-estado-peticion/(:any)','Peticiones::modificarEstadoPeticion/$1');/* NUEVO */
$routes->add('agregar-comentario-peticion/(:any)','Peticiones::registrarComentarioPeticion/$1');/* NUEVO */
$routes->add('peticionesServersideHistorico','Peticiones::peticionesServersideHistorico');/* NUEVO */
$routes->add('informacion-prospecto-peticion/(:any)','Peticiones::informacionProspectoPeticion/$1');/* NUEVO */
$routes->add('exportar-reporte-peticiones-backoffice/(:any)/(:any)','Peticiones::exportarReportePeticionesBackOffice/$1/$2');/* NUEVO */

$routes->add('listado-monedas','Peticiones::listadoMonedas');/* NUEVO */

$routes->add('facturas-condonacion-peticion','Peticiones::listarFacturasCondonacionPeticion');/* NUEVO */
$routes->add('exportar-facturas-condonacion-peticion/(:any)','Peticiones::exportarFacturasCondonacionPeticion/$1');/* NUEVO */
$routes->add('importar-status-facturas-condonacion-peticion','Peticiones::importarStatusFacturasCondonacionPeticion');/* NUEVO */
$routes->add('mostrar-estado-factura','Peticiones::mostrarEstadoFactura');/* NUEVO */
$routes->add('cambiar-estado-peticion-facturacion','Peticiones::cambiarEstadoPeticionFacturacion');/* NUEVO */

/* CONDONACIONES */

$routes->add('listar-condonaciones','Condonaciones::listarCondonaciones');/* NUEVO */
$routes->add('condonaciones-serverside','Condonaciones::condonacionesServerside');/* NUEVO */
$routes->add('registrar-condonacion','Condonaciones::registrarCondonacion');/* NUEVO */
$routes->add('facturas-condonacion/(:any)','Condonaciones::facturasCondonacion/$1');/* NUEVO */
$routes->add('cambiar-estado-factura-condonacion','Condonaciones::modificarEstadoFacturaCondonacion');/* NUEVO */
$routes->add('cambiar-estado-aprobacion-factura-condonacion','Condonaciones::modificarEstadoAprobacionFacturaCondonacion');/* NUEVO */
$routes->add('recargar-facturas-condonacion','Condonaciones::recargarFacturasCondonacion');/* NUEVO */
$routes->add('obtener-datos-factura-condonacion','Condonaciones::obtenerDatosFacturaCondonacion');/* NUEVO */
$routes->add('actualizar-factura-condonacion/(:any)','Condonaciones::modificarFacturaCondonacion/$1');/* NUEVO */
$routes->add('recargar-bitacora-condonacion','Condonaciones::recargarBitacoraCondonacion');/* NUEVO */
$routes->add('comentarios-aprobador-factura-condonacion','Condonaciones::comentariosAprobadorFacturaCondonacion');/* NUEVO */
$routes->add('comentarios-factura-condonacion','Condonaciones::comentariosFacturaCondonacion');/* NUEVO */
$routes->add('registrar-comentario-factura-condonacion','Condonaciones::registrarComentariosFacturaCondonacion');/* NUEVO */
$routes->add('registrar-comentario-aprobador-condonacion','Condonaciones::registrarComentariosAprobadorCondonacion');/* NUEVO */
$routes->add('validar-boton-peticion-condonacion','Condonaciones::validarBotonPeticionCondonacion');/* NUEVO */
$routes->add('mostrar-aprobadores-general','Condonaciones::mostrarAprobadoresGeneral');/* NUEVO */
$routes->add('mostrar-facturas-aprobador','Condonaciones::mostrarFacturasUsuarioAprobador');/* NUEVO */
$routes->add('visualizar-informacion-factura-aprobador','Condonaciones::visualizarInformacionFacturaAprobador');/* NUEVO */
$routes->add('enviar-correo-facturas-pendientes-aprobador-condonacion','Condonaciones::enviarCorreoFacturasPendientesAprobadorCondonacion');/* NUEVO */
$routes->add('comentarios-condonacion','Condonaciones::comentariosCondonacion');/* NUEVO */
$routes->add('registrar-comentario-condonacion','Condonaciones::registrarComentarioCondonacion');/* NUEVO */
$routes->add('acumulados-factura-condonacion','Condonaciones::acumuladosFacturaCondonacion');/* NUEVO */
$routes->add('obtener-informacion-aprobador-factura-condonacion','Condonaciones::obtenerInformacionAprobadorFacturaCondonacion');/* NUEVO */

$routes->add('registrar-peticion-condonacion','Peticiones::registrarPeticionCondonacion');/* NUEVO */
// $routes->add('gestion-facturas-condonaciones-serverside','Condonaciones::gestionFacturasCondonacionesServerside');/* NUEVO */
// $routes->add('facturas-pendientes-condonacion-usuario','Condonaciones::facturasPendientesCondonacionUsuario');/* NUEVO */
$routes->add('recargar-aprobaciones-condonacion','Condonaciones::recargarTablaAprobacionesCondonacion');/* NUEVO */


$routes->add('condonaciones-cobranzas-serverside','Condonaciones::condonacionesCobranzasServerside');
$routes->add('registrar-condonacion-cobranza','Condonaciones::registrarCondonacionCobranza');
$routes->add('detalle-condonacion-cobranza/(:any)','Condonaciones::detalleCondonacionCobranza/$1');
$routes->add('registrar-comentario-condonacion-cobranza','Condonaciones::registrarComentarioCondonacionCobranza');
$routes->add('comentarios-condonacion-cobranza','Condonaciones::comentariosCondonacionCobranza');
$routes->add('cambiar-estado-condonacion-cobranza','Condonaciones::modificarEstadoCondonacionCobranza');

$routes->add('exportar-pregestion-condonacion-cobranza','Condonaciones::exportarPreGestionCondonacionCobranza');
/* OFERTAS */

$routes->add('listar-ofertas','Ofertas::listarOfertas');/* NUEVO */
$routes->add('listado-item-oferta','Ofertas::listadoItemOferta');/* NUEVO */
$routes->add('analizar-datos-matriz-oferta','Ofertas::analizarDatosMatrizOferta');/* NUEVO */
$routes->add('validar-contrato','Ofertas::validarContrato');/* NUEVO */
$routes->add('registrar-oferta','Ofertas::registrarOferta');/* NUEVO */
$routes->add('ofertas-serverside','Ofertas::ofertasServerside');/* NUEVO */
$routes->add('detalle-Oferta/(:any)','Ofertas::detalleOferta/$1');/* NUEVO */
$routes->add('mostrar-aprobador-general','Ofertas::mostrarAprobadorGeneral');/* NUEVO */
$routes->add('cambiar-estado-oferta','Ofertas::cambiarEstadoOferta');/* NUEVO */
$routes->add('actualizar-detalle-oferta', 'Ofertas::actualizarDetalleOferta');/* NUEVO */
$routes->add('registrar-comentario-oferta','Ofertas::registrarComentarioOferta');/* NUEVO */
$routes->add('comentarios-oferta','Ofertas::comentariosOferta');/* NUEVO */
$routes->add('recargar-bitacora-oferta','Ofertas::recargarBitacoraOferta');/* NUEVO */
$routes->add('enviar-alerta-gestor','Ofertas::enviarAlertaGestor');/* NUEVO */
$routes->add('gestion-nuevas-ofertas-serverside','Ofertas::gestionNuevasOfertasServerside');/* NUEVO */
$routes->add('exportar-nuevas-ofertas-facturacion','Ofertas::exportarNuevasOfertasFacturacion');/* NUEVO */
$routes->add('importar-status-nuevas-ofertas', 'Ofertas::importarStatusNuevasOfertas');

// $routes->add('exportar-reporte-peticiones-backoffice/(:any)/(:any)','Peticiones::exportarReportePeticionesBackOffice/$1/$2');/* NUEVO */

/******************************************************************************/


/* GRUPOS CARTERA CLIENTE */

$routes->add('listar-grupos-cartera-cliente','CarteraCliente::listarGruposCarteraCliente');/* NUEVO */
$routes->add('registrar-grupo-cartera-cliente','CarteraCliente::registrarGrupoCarteraCliente');/* NUEVO */
$routes->add('obtener-datos-grupo-cartera-cliente','CarteraCliente::obtenerDatosGrupoCarteraCliente');/* NUEVO */
$routes->add('actualizar-grupo-cartera-cliente/(:any)','CarteraCliente::modificarGrupoCarteraCliente/$1');/* NUEVO */
$routes->add('cambiar-estado-grupo-cartera-cliente','CarteraCliente::modificarEstadoGrupoCarteraCliente');/* NUEVO */

$routes->add('listar-usuarios-grupo-cartera-cliente/(:any)','CarteraCliente::listarUsuariosGrupoCarteraCliente/$1');/* NUEVO */
$routes->add('asociar-usuario-grupo-cartera-cliente','CarteraCliente::asociarUsuarioGrupoCarteraCliente');/* NUEVO */
$routes->add('eliminar-usuario-grupo-cartera-cliente','CarteraCliente::eliminarUsuarioGrupoCarteraCliente');/* NUEVO */
// $routes->add('listado-usuarios-grupotrabajo-select','Configuracion::listarUsuariosGrupoTrabajoSelect');/* NUEVO */
$routes->add('listado-item-oferta-asociados','CarteraCliente::listadoItemOfertaAsociados');/* NUEVO */
$routes->add('guardar-items-asociados','CarteraCliente::guardarItemsAsociados');/* NUEVO */
$routes->add('listado-tipo-cartera','CarteraCliente::listadoTipoCartera');/* NUEVO */
$routes->add('actualizar-aprobador','CarteraCliente::actualizarAprobador');/* NUEVO */



/******************************************************************************/


	
/*************************** FORMATOS DE APROBACIÓN ***************************/

$routes->add('cartaCondonacion','FormatosAprobacion::cartaCondonacion');/* NUEVO */

/******************************************************************************/
	
/*********************************** REMOTOS **********************************/

$routes->add('listado-direccion-busqueda','Remotos::listadoDireccionBusqueda');/* NUEVO */
$routes->add('listado-region-pais','Remotos::listadoRegionPais');/* NUEVO */
$routes->add('listado-region-departamentos','Remotos::listadoRegionDepartamento');/* NUEVO */
$routes->add('listado-region-provincias','Remotos::listadoRegionProvincia');/* NUEVO */
$routes->add('listado-region-distritos','Remotos::listadoRegionDistrito');/* NUEVO */

$routes->add('listado-monedas','Remotos::listadoMonedas');/* NUEVO */
$routes->add('listado-tipos-documento','Remotos::listadoTiposDocumento');/* NUEVO */
$routes->add('listado-tipos-documento-sunat','Remotos::listadoTiposDocumentoSunat');/* NUEVO */

$routes->add('listado-direccion-estructura','Remotos::listadoDireccionesEstructura');/* NUEVO */
$routes->add('listado-area-estructura','Remotos::listadoAreasEstructura');/* NUEVO */
$routes->add('listado-subarea-estructura','Remotos::listadoSubareasEstructura');/* NUEVO */
$routes->add('listado-delegacion-estructura','Remotos::listadoDelegacionEstructura');/* NUEVO */
$routes->add('listado-cc-delegacion-estructura','Remotos::listadoCCDelegacionEstructura');/* NUEVO */
$routes->add('listado-estructura-delegacion','Remotos::listadoEstructuraDelegacion');/* NUEVO */
$routes->add('exportar-estructura-departamental','Remotos::exportarEstructuraDepartamental');/* NUEVO */

$routes->add('listado-responsables-direccion-estructura','Remotos::listadoResponsablesDireccionEstructura');/* NUEVO */
$routes->add('listado-responsables-area-estructura','Remotos::listadoResponsablesAreaEstructura');/* NUEVO */
$routes->add('listado-responsables-subarea-estructura','Remotos::listadoResponsablesSubareaEstructura');/* NUEVO */

$routes->add('listado-usuarios','Remotos::listadoUsuarios');/* NUEVO */
