<?php namespace App\Models;

use CodeIgniter\Model;

class RequerimientosPerfilModel extends Model {
    
    protected $table = 'requerimientos_perfil';
    protected $primaryKey = 'IDRequerimiento';
    protected $allowedFields = ['IDRequerimiento', 'IDPerfil', 'UsuarioRegistra', 'FechaRegistra'];
    protected $useAutoIncrement = false;
    protected $useSoftDeletes = false;
    
    public function listarPerfilesRequerimiento($idRequerimiento)
    {
      $this->select('perfil.IDPerfil,
        perfil.Perfil,
        IF(requerimientos_perfil.IDPerfil IS NULL, 0, 1) AS "ACTIVO"');
      $this->join('perfil', 'requerimientos_perfil.IDPerfil = perfil.IDPerfil AND requerimientos_perfil.IDRequerimiento = "'.$idRequerimiento.'"', 'right');
      
      $datos = $this->findAll();
      return $datos;
    }
}
