<?php
namespace App\Models;
use CodeIgniter\Model;
use \App\Libraries\Globales;

class PeticionesModel extends Model
{
    protected $table      = 'peticiones';
    protected $primaryKey = 'IDPeticion';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['Peticion', 'NroProspecto', 'IDVentaProspecto', 'IDMotivo', 'Detalle', 'LinkAsociado', 'IDGrupoTrabajoDestino', 'UsuarioAsignado', 'UsuarioCrea', 'FechaCrea', 'IDSubareaCrea', 'IDAreaCrea', 'IDDireccionCrea', 'IDPerfilCrea', 'IDDelegacionCrea', 'IDCargoCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'IDDireccionEstado', 'IDAreaEstado', 'IDSubareaEstado', 'IDDelegacionEstado', 'IDPerfilEstado', 'IDCargoEstado', 'FechaEstado', 'MotivoEstado','NroContrato','PresupuestoAsignado','Producto','Cantidad','TipoMoneda','Categorizacion'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listadoPeticiones($array)
    {
        $this->select('
            peticiones.IDPeticion,
            peticiones.Peticion,
            peticiones.NroProspecto,
            peticiones.IDVentaProspecto,
            peticiones.NroContrato,
            peticiones.IDMotivo,
            requerimientos_motivos.Motivo,
            requerimientos_motivos.IDRequerimiento,
            requerimientos.Requerimiento,
            peticiones.Detalle,
            peticiones.LinkAsociado,
            peticiones.IDGrupoTrabajoDestino,
            grupostrabajo.GrupoTrabajo,
            peticiones.UsuarioAsignado,
            peticiones.UsuarioCrea,
            peticiones.FechaCrea,
            peticiones.IDSubareaCrea,
            peticiones.IDAreaCrea,
            peticiones.IDDireccionCrea,
            peticiones.IDDelegacionCrea,
            peticiones.IDPerfilCrea,
            perfil.Perfil AS "PerfilSolicitante",
            peticiones.Estado,
            peticiones.UsuarioEstado,
            peticiones.FechaEstado,
            peticiones.MotivoEstado');
        $this->join('requerimientos_motivos', 'peticiones.IDMotivo = requerimientos_motivos.IDMotivo', 'left');
        $this->join('requerimientos', 'requerimientos_motivos.IDRequerimiento = requerimientos.IDRequerimiento', 'left');
        $this->join('grupostrabajo', 'peticiones.IDGrupoTrabajoDestino = grupostrabajo.IDGrupoTrabajo', 'left');
        $this->join('perfil', 'peticiones.IDPerfilCrea = perfil.IDPerfil', 'left');
        
        if(!empty($array))
        {
            if(isset($array['IDPerfil']) && in_array($array["IDPerfil"], array(1)))
            {
                $this->whereNotIn('peticiones.Estado', array("APRO", "COMP", "CANC", "AA"));
            }
            else if(isset($array['IDPerfil']) && in_array($array["IDPerfil"], array(9)))
            {
                //VISUALIZO TODAS LAS PETICIONES DE MI GRUPO DE TRABAJO QUE NO ESTÉN APROBADOS CANCELADOS O AA
                $this->groupStart(); // Inicia un grupo de condiciones
                $this->whereIn("peticiones.IDGrupoTrabajoDestino", $array['grupoTrabajo']);
                $this->whereNotIn('peticiones.Estado', array("APRO", "COMP","CANC", "AA"));
                $this->groupEnd(); // Finaliza el grupo de condiciones
                
                //VISUALIZO TODAS LAS PETICIONES CREADAS POR MI QUE NO ESTÉN APROBADOS COMPLETADOS CANCELADOS O AA
                $this->orGroupStart(); // Inicia un grupo de condiciones
                $this->where("peticiones.UsuarioCrea", $array['asignado']);
                $this->whereNotIn('peticiones.Estado', array("APRO", "COMP", "CANC", "AA"));
                $this->groupEnd(); // Finaliza el grupo de condiciones
                
            }
            else
            {
                //si existe la variable grupo de trabajo y no hay datos dentro de grupo de trabajo (no tiene grupo de trabajo asignado)
                if(isset($array['grupoTrabajo']) && empty($array['grupoTrabajo']))
                {
                    
                    //VISUALIZO TODAS LAS PETICIONES CREADAS POR MI QUE NO ESTÉN APROBADOS COMPLETADOS CANCELADOS O AA
                    $this->groupStart(); // Inicia un grupo de condiciones
                    $this->where("peticiones.UsuarioCrea", $array['asignado']);
                    $this->whereNotIn('peticiones.Estado', array("APRO", "COMP", "CANC", "AA"));
                    $this->groupEnd(); // Finaliza el grupo de condiciones
                    
                    //VISUALIZO TODAS LAS PETICIONES ASIGNADAS A MI
                    $this->orGroupStart(); // Inicia un grupo de condiciones
                    $this->where("peticiones.UsuarioAsignado", $array['asignado']);
                    $this->groupEnd(); // Finaliza el grupo de condiciones
                    
                    // $this->where('((peticiones.UsuarioCrea = "'.$array['asignado'].'" && peticiones.Estado NOT IN ("APRO", "COMP", "CANC", "AA")) OR 
                    //       	(peticiones.UsuarioAsignado = "'.$array['asignado'].'"))');
                }
                else
                {
                    
                    //VISUALIZO TODAS LAS PETICIONES CREADAS POR MI QUE NO ESTÉN APROBADOS COMPLETADOS CANCELADOS O AA
                    $this->groupStart(); // Inicia un grupo de condiciones
                    $this->where("peticiones.UsuarioCrea", $array['asignado']);
                    $this->whereNotIn('peticiones.Estado', array("APRO", "COMP", "CANC", "AA"));
                    $this->groupEnd(); // Finaliza el grupo de condiciones
                    
                    //VISUALIZO TODAS LAS PETICIONES ASIGNADAS A MI
                    $this->orGroupStart(); // Inicia un grupo de condiciones
                    $this->where("peticiones.UsuarioAsignado", $array['asignado']);
                    $this->groupEnd(); // Finaliza el grupo de condiciones
                    
                    //VISUALIZO TODAS LAS PETICIONES DE MI GRUPO DE TRABAJO QUE NO ESTÉN ASIGNADAS A ALGUIEN Y NO SEA ESTADO APROBADOS CANCELADOS O AA
                    $this->orGroupStart(); // Inicia un grupo de condiciones
                    
                        $this->groupStart(); // Inicia un grupo de condiciones
                        $this->where("peticiones.UsuarioAsignado IS NULL");
                        $this->orWhere('peticiones.UsuarioAsignado', "");
                        $this->groupEnd(); 
                        
                    $this->whereIn("peticiones.IDGrupoTrabajoDestino", $array['grupoTrabajo']);
                    $this->whereNotIn('peticiones.Estado', array("APRO", "COMP", "CANC", "AA"));
                    
                    $this->groupEnd(); // Finaliza el grupo de condiciones
                    
                    // $this->where('((peticiones.UsuarioCrea = "'.$array['asignado'].'" && peticiones.Estado NOT IN ("APRO", "COMP", "CANC", "AA")) OR 
                    //   	(peticiones.UsuarioAsignado = "'.$array['asignado'].'") OR
                    // 	((peticiones.UsuarioAsignado IS NULL OR peticiones.UsuarioAsignado = "") AND peticiones.IDGrupoTrabajoDestino IN ("'.implode('","',$array['grupoTrabajo']).'") AND peticiones.Estado NOT IN ("APRO", "COMP", "CANC", "AA")))');
                }
                
                if(isset($array['delegaciones']) && !empty($array['delegaciones']))
                {
                    $this->orGroupStart(); // Inicia un grupo de condiciones
                    $this->whereIn("peticiones.IDDelegacionCrea", $array['delegaciones']);
                    $this->whereNotIn('peticiones.Estado', array("APRO", "CANC", "AA"));
                    $this->groupEnd(); // Finaliza el grupo de condiciones
                }
            }
        }
        
        // if($array['IDUsuario'] == 3660)
        // {
        // $this->get();
        // return $this->getLastQuery();
        // }
        // else
        // {
        $datos = $this->findAll();
        return $datos;
        // }
    }
    
    public function obtenerPeticion($idPeticion)
    {
        $this->select('
            peticiones.IDPeticion,
            peticiones.Peticion,
            peticiones.NroProspecto,
            peticiones.IDVentaProspecto,
            peticiones.IDMotivo,
            requerimientos_motivos.Motivo,
            requerimientos_motivos.IDRequerimiento,
            requerimientos.Requerimiento,
            peticiones.Detalle,
            peticiones.LinkAsociado,
            peticiones.IDGrupoTrabajoDestino,
            grupostrabajo.GrupoTrabajo,
            peticiones.UsuarioAsignado,
            peticiones.UsuarioCrea,
            peticiones.FechaCrea,
            peticiones.IDSubareaCrea,
            peticiones.IDAreaCrea,
            peticiones.IDDireccionCrea,
            peticiones.IDPerfilCrea,
            peticiones.IDDelegacionCrea,
            peticiones.IDPerfilCrea,
            perfil.Perfil AS "PerfilSolicitante",
            peticiones.Estado,
            peticiones.UsuarioEstado,
            peticiones.FechaEstado,
            peticiones.MotivoEstado,
            peticiones.NroContrato,
            peticiones.Producto,
            peticiones.Cantidad,
            peticiones.PresupuestoAsignado,
            peticiones.TipoMoneda,
            peticiones.Categorizacion
            ');
        $this->join('requerimientos_motivos', 'peticiones.IDMotivo = requerimientos_motivos.IDMotivo', 'left');
        $this->join('requerimientos', 'requerimientos_motivos.IDRequerimiento = requerimientos.IDRequerimiento', 'left');
        $this->join('grupostrabajo', 'peticiones.IDGrupoTrabajoDestino = grupostrabajo.IDGrupoTrabajo', 'left');
        $this->join('perfil', 'peticiones.IDPerfilCrea = perfil.IDPerfil', 'left');
        
        $this->where('peticiones.IDPeticion', $idPeticion);
        
        $datos = $this->first();
        return $datos;
    }
    
    public function listaGeneralPeticiones($orderBy,$where,$length,$start) 
    {
        
        $this->globales = new Globales();
        
        $sSelect = "IDPeticion, FechaCrea, FechaEstado, DelegacionSolicitante, PerfilSolicitante, NroProspecto, Requerimiento, Motivo, NombreUsuarioEstado, GrupoTrabajo, Estado, 'SININFO' AS acciones_usuario";
        $sTable = "vista_peticiones_historico";
        $whereRespuesta = $where==""?"":"WHERE (".$where.")";
        $consulta = "SELECT " . $sSelect ." FROM ".  $sTable . " " .$whereRespuesta ."  " . $orderBy . " LIMIT ". $length ." OFFSET " .$start;
        
        $obtieneConsulta = $this->db->query($consulta);
        // return $this->db->getLastQuery();
        $consultaTotal = "SELECT count(IDPeticion) as total FROM vista_peticiones_historico";
        $totalRegistros = $this->db->query($consultaTotal);
        $obtieneTotalRegistros = $totalRegistros->getResultArray();
        // echo $consulta;
        // exit;
        if ($obtieneConsulta->getNumRows() > 0) {
            
            $dataServerside = $obtieneConsulta->getResultArray();
            
            foreach($dataServerside as $key=>$value)
            {
                $dataServerside[$key]['TextoEstado'] = $this->globales->estadosPeticion()[$value['Estado']]['PASADO'];
                $dataServerside[$key]['FondoEstado'] = $this->globales->estadosPeticion()[$value['Estado']]['FONDO'];
            }
            
            $datos = [
                // 'draw' => "4",
                'data' => $dataServerside,
                'recordsTotal' => $obtieneTotalRegistros[0]['total'],
                'recordsFiltered' => (int)(($obtieneTotalRegistros[0]['total']*$length)/$length)
            ];
            return $datos;
        } else {
            return FALSE;
        }
    }

    public function buscarInformacionProspectoPeticion($nroProspecto)
    {
        $builder = $this->db->table('vista_informacion_prospecto_dbVENTAS');
        $builder->where('NProspecto', $nroProspecto);
        
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getRowArray();
        
        return $datos;
    }
    
    public function obtenerCantidadPeticiones($array)
    {
        $this->select('IDPeticion');
        
        if(!empty($array))
        {
            if(isset($array['idperfil']) && $array['idperfil'] != 1)
            {
                $this->groupStart(); // Inicia un grupo de condiciones
                if(isset($array['grupostrabajo']) && !empty($array['grupostrabajo']))
                {
                    $this->orWhereIn("IDGrupoTrabajoDestino", $array['grupostrabajo']);
                }
                
                if(isset($array['delegaciones']) && !empty($array['delegaciones']))
                {
                    $this->orWhereIn("IDDelegacionCrea", $array['delegaciones']);
                }
                
                if(isset($array['idusuario']) && $array['idusuario'] != '')
                {
                    $this->orWhere("UsuarioCrea", $array['idusuario']);
                }
                
                $this->groupEnd(); // Finaliza el grupo de condiciones
            }
            
            if(isset($array['mes']) && $array['mes'] != '')
            {
                $this->where("MONTH(FechaCrea)", $array['mes']);
            }
            
            if(isset($array['estadosno']) && !empty($array['estadosno']))
            {
                $this->whereNotIn("Estado", $array['estadosno']);
            }
            
            if(isset($array['estado']) && $array['estado'] != '')
            {
                $this->where("Estado", $array['estado']);
            }
        }
        
        $datos = $this->findAll();
        return $datos;
        // $this->get();
        // return $this->getLastQuery();
    }
    
    public function exportarReporteBackOffice($array)
    {
        $builder = $this->db->table('vista_reporte_peticiones_backoffice');
        
        if(!empty($array))
        {
            if(isset($array['fechaInicio']) && $array['fechaInicio'] != '' && $array['fechaInicio'] != null)
            {
                $builder->where('FECHA_CREACION >=', $array['fechaInicio']);
            }
            
            if(isset($array['fechaFin']) && $array['fechaFin'] != '' && $array['fechaFin'] != null)
            {
                $builder->where('FECHA_CREACION <=', $array['fechaFin']);
            }
        }
        
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getResultArray();
        
        return $datos;
    }
    
}