let pondIMGLanding;

$(function () {
    FilePond.registerPlugin(
        FilePondPluginFileValidateType,    // Validación de extensión
        FilePondPluginImagePreview,        // Previsualización de imágenes
        FilePondPluginImageExifOrientation // Orientación EXIF de imágenes
    );
});

/* FUNCIONES GENERALES */

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES LANDING */

/* ------------------------------- */

function agregarParametrosLanding(contenedorElementos)
{
    var random = generarRandom(5);
    
    let contenedor = `<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px" id="param${random}" style="border-radius: 10px;">
		<div class="col-xxl-12 col-md-12 col-12 mb-2">
			<div>
				<label for="txtNombreParametro_i${random}" class="form-label">Nombre Parametro:</label>
				<input type="text" class="form-control" id="txtNombreParametro_i${random}" name="nombreParametro[${random}]">
			</div>
		</div>
		<div class="col-xxl-5 col-md-10 col-10 ">
		    <div>
				<label for="txtPosicionParametro_i${random}" class="form-label">Posición Parametro:</label>
				<input type="number" class="form-control" id="txtPosicionParametro_i${random}" name="posicionParametro[${random}]">
			</div>
		</div>
		<div class="col-xxl-5 col-md-10 col-10 ">
		    <div>
				<label for="cboTipoDatoParametro${random}" class="form-label">Tipo de Dato:</label>
				<select class="form-select" id="cboTipoDatoParametro${random}" name="tipoDatoParametro[${random}]">
				    <option value="" selecte>Seleccione una opción...</option>
                    <option value="varchar">String</option>
                    <option value="int">Integer</option>
                </select>
			</div>
		</div>
		<div class="col-xxl-2 col-md-2 col-2 d-flex justify-content-end align-items-center">
			<button type="button" class="btn bg-danger px-2 py-1" onclick="return eliminarBloqueDinamico('param${random}');" data-tooltip="tooltip" aria-label="Eliminar Bloque">
                <i class="mdi mdi-trash-can" style="font-size: 24px; color: #FFF"></i>
            </button>
		</div>
	</div>`;

    $("#"+contenedorElementos).append(contenedor);
}

/* ------------------------------- */

$(document).on('click', '#btnAgregarLanding', function(event) {
    let modal = $(this).data("bs-target");
    
    pondIMGLanding.removeFiles();
    $("#txtTituloLanding").val("");
    $("#txtRutaLanding").val("");
    $("#txtObservacionLanding").val("");
    $("#ctnParametrosLanding").empty();
    
    $(modal).modal("show");
});

/* ------------------------------- */

$(document).on('submit', '.formularioAgregarLanding', function(event) {
    event.preventDefault();
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var idForm = formulario.attr('id');
    
    const pondFiles = pondIMGLanding.getFiles();
    
    if (pondFiles.length === 0) {
        Swal.fire({
            text: "Debe adjuntar la imagen del landing.",
            icon: 'warning',
            showCancelButton: false,
            cancelButtonText: 'No',
            confirmButtonColor: '#282e38',
            confirmButtonText: 'OK'
        });
        return false;
    }
    var formData = new FormData(this);
    
    for (var i = 0; i < pondFiles.length; i++) {
        formData.append('itemsFile', pondFiles[i].file);
    }
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            
            formulario.find('.respuesta').html(response);
            
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    return false;
});

/* ------------------------------- */

function abrirModalLanding(idLanding, controller)
{
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
    
    let modal = "#modalParametrosLanding";
    
    $('#ctnParametrosLandingVistaPrevia').empty();
    $("#txtControllerRuta_al").val(controller);
    
    $.post(baseUrl + '/listado-parametros-landing', 
    {
        idLanding : idLanding
    }, 
    function(response) 
    {
        Swal.close();
        console.log(response);
        if (response.session === 0) {
            Swal.fire({
                title: 'No hay sesión iniciada. Logueese nuevamente para poder visualizar la vista previa.',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } else if (response.descripcion === 0) {
            $("#ctnParametrosLandingVistaPrevia").html('<div class="alert alert-warning" role="alert">\n\
                <h4 class="alert-heading">\n\
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-exclamation-triangle-fill flex-shrink-0 me-2" viewBox="0 0 16 16" role="img" aria-label="Warning:">\n\
                    <path d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z"/>\n\
                </svg>\n\
                El landing no requiere parametros para ser visitado.\n\
                </h4>\n\
              </div>');
              $(modal).modal("show");
        } else {
            var items = $.parseJSON(response.listadoParametros);

            for(var i = 0; i < items.length; i++){
                var random = generarRandom(5);
                $("#ctnParametrosLandingVistaPrevia").append('<div class="row col-12 m-0 p-0 mb-3 p-3 border-sistema" style="border-radius: 10px;">\n\
                    <div class="col-xxl-12 col-md-12 col-12 mb-3">\n\
                        <label class="form-label">Posición '+items[i].posicion+': '+items[i].nombre+'</label>\n\
                        <input type="'+(items[i].tipodato == "int" ? "number" : "text")+'" id="parametro'+items[i].posicion+'" name="parametro['+items[i].posicion+']" class="form-control" >\n\
                </div>');
            }
            
            $(modal).modal("show");
        }
    }, 'json');
    // pondIMGLanding.removeFiles();
    // $("#txtTituloLanding").val("");
    // $("#txtRutaLanding").val("");
    // $("#txtObservacionLanding").val("");
    // $("#ctnParametrosLanding").empty();
}

/* ------------------------------- */

$(document).on('click', '#btnAbrirLandingParametros', function(event) {
    let controller = $("#txtControllerRuta_al").val();
    var totalParametros = $('input[name^="parametro["]').length;
    
    var urlLanding = baseUrl+"/"+controller;
    
    if(totalParametros > 0)
    {
        for(var i = 1; i <= totalParametros; i++)
        {
            var param = $('input[name="parametro['+i+']').val();
            
            if(param === undefined || param == "")
            {
                param = 0;
            }
            
            urlLanding = urlLanding+"/"+param;
        }
    }
    
    // console.log(urlLanding);
    // alert(totalParametros);
    window.open(urlLanding ,'_blank');
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES ANULACIONES  */

/* ------------------------------- */

/* ------------------------------- */

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES BANCO */

/* ------------------------------- */

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */
