<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;

use Config\Services;

class LandingDavid extends BaseController
{
	public function __construct()
	{
	    $this->landing              = new \App\Models\LandingModel();
	    $this->landingParametros    = new \App\Models\LandingParametrosModel();
	    
	    $this->referidosField           = new \App\Models\ReferidosFieldModel();
	    $this->referidosFieldDetalle    = new \App\Models\ReferidosFieldDetalleModel();
	    
	    $this->referidosTCTV        = new \App\Models\ReferidosTCTVModel();
	    $this->referidosTCTVDetalle = new \App\Models\ReferidosTCTVDetalleModel();
	    
	    $this->afiliacionMDP        = new \App\Models\AfiliacionMDPModel();
	    $this->afiliacionOtros      = new \App\Models\AfiliacionOtrosModel();
	    
	    $this->VentaModel           = new \App\Models\VentasModel();
	    $this->hojaCertificacion    = new \App\Models\HojaCertificacionModel();
	}

    /**************************** SUPERCOLABORADOR ****************************/
    
	public function listarLanding()
	{
	    if (isset($this->items['id'])) 
    	{
    	    $landings = $this->landing->findAll();
    	    
    	    $data = array (
				'session'                   => 'on',
				'titulo'                    => 'Landings Verisure | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Landings Verisure',
                // 'previo'                => 'listar-proveedores',
				'elementoSeleccionadoModulo'=> "Landings Verisure",
				'subtitulo'                 => 'Landings Verisure',
				'landings'                  => $landings
			);
			
			$data = array_merge($data, $this->items);
			
			return view('procesos/Landing/listar_landing',$data);		
        } else {
            return view('errors/500');
        }
	}
	
	public function nuevaLanding()
	{
	    if (isset($this->items['id'])) 
    	{
    	    $data = array (
				'session'                   => 'on',
				'titulo'                    => 'Nueva Landing Verisure | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Nueva Landing',
                'previo'                    => 'listar-landing',
				'elementoSeleccionadoModulo'=> "Nueva Landing",
				'subtitulo'                 => 'Nueva Landing'
			);
			
			$data = array_merge($data, $this->items);
			
			return view('procesos/Landing/nueva_landing',$data);		
        } else {
            return view('errors/500');
        }
	}
	
	public function registrarLanding()
	{
	    if (isset($this->items['id'])) 
    	{
    	    $fechaActual = date("Y-m-d H:i:s");

            /*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
            */
            
            // var_dump($this->request->getPost());exit;
    
            $msjError       = TRUE;
            $titulo         = $this->request->getPost('txtTituloLanding');
            $ruta           = $this->request->getPost('txtRutaLanding');
            $observacion    = $this->request->getPost('txtObservacionLanding');
            $nombreParam    = $this->request->getPost('nombreParametro');
            $posicionParam  = $this->request->getPost('posicionParametro');
            $tipoParam      = $this->request->getPost('tipoDatoParametro');
    	    $img            = $this->request->getFile("itemsFile");
            /*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
            
            $error = '';
            $error .= $this->complementos->validaCampo($titulo, 'required|trim|alphaspecial|minlength[1]|maxlength[50]', 'Título');
            $error .= $this->complementos->validaCampo($ruta, 'required|trim|alphanumericsymbol|minlength[1]|maxlength[30]', 'Controlador de Ruta Codeigniter');
            
            if(empty($img))
    	    {
    	        $error .= "<li>No se encuentra la imagen asociada al landing. [CAMPO] <small>IMAGEN</small></li>";
    	    }
    	    
            if ($error != '') {
                
                $message = sprintf($this->mensajeError->msg201, $error);
                echo $this->alertas->alertaError($message);
                EXIT;
            }
            
    		/*
    		* ----------------------------
            * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
            * ----------------------------
            */
            
             if (! $img->isValid()) {
                $message = sprintf($this->mensajeError->msg201, $img->getErrorString().'-'.$img->getError());
    			echo $this->alertas->alertaError($message);
    			exit;
            }
            else
            {
                
                if($img->getClientExtension() != null)
                {
                    $extensionImg = strtolower($img->getClientExtension());
                }
                else if($img->guessExtension() != null)
                {
                    $extensionImg = strtolower($img->guessExtension());
                }
                else
                {
                    $extensionImg = strtolower(pathinfo($img->getClientName(), PATHINFO_EXTENSION));
                }
            }

    		/* ----------------------------
            * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
            * ----------------------------
            */
            
            $validationRule = [
                'itemsFile' => [
                    'mime_in[itemsFile,image/jpeg,image/png,image/gif,image/webp]',
                    'ext_in[itemsFile,jpg,jpeg,png,gif,webp]'
                ],
            ];
    
            if (! $this->validate($validationRule)) {
                $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
    			echo $this->alertas->alertaError($message);
    			exit;
            }

    	    /*
            * ----------------------------
            * INSERTAR INFORMACIÓN LANDING
            * ----------------------------
            */
            
            $data = array (
                'Titulo'            => $titulo,
                'ControladorRuta'   => $ruta,
                'Observacion'       => $observacion,
                'ExtensionImg'      => $extensionImg,
                'UsuarioCrea'       => $this->items['id'],
                'FechaCrea'         => $fechaActual,
                'Localhost'         => $this->request->getIPAddress(),
                'Estado'            => "A",
                'UsuarioEstado'     => $this->items['id'],
                'FechaEstado'       => $fechaActual,
                'MotivoEstado'      => "Creación de landing."
            );
    
            $lastId = $this->landing->insert($data, TRUE);
            
            if($lastId !== FALSE){
                $idLanding = $lastId;
            }
            else
            {
                $message = sprintf($this->mensajeError->msg201, "<li>No se pudo adjuntar la factura. Inténtelo luego.[LAND]</li>");
        	    echo $this->alertas->alertaError($message);
        	    exit;
            }
            
    	    /*
            * ----------------------------
            * INSERTAR INFORMACIÓN PARAMETROS
            * ----------------------------
            */
            
            $dataParametros = array();
            
            if(!empty($nombreParam))
            {
                foreach($nombreParam as $key=>$nombre)
                {
                    $dataParametros[] = array (
                        'IDLanding'     => $idLanding,
                        'Nombre'        => $nombre,
                        'Posicion'      => $posicionParam[$key],
                        'TipoDato'      => $tipoParam[$key],
                        'UsuarioCrea'   => $this->items['id'],
                        'FechaCrea'     => $fechaActual,
                        'Localhost'     => $this->request->getIPAddress(),
                        'Estado'        => "A",
                        'UsuarioEstado' => $this->items['id'],
                        'FechaEstado'   => $fechaActual,
                        'MotivoEstado'  => "Creación de parametro de landing."
                    );
                }
            }
            
            $statusParametros = $this->landingParametros->insertBatch($dataParametros);
            
            if($statusParametros === FALSE)
            {
                $this->landing->delete(["IDLanding", $idLanding]);
                
                $message = sprintf($this->mensajeError->msg201, "<li>No se pudo registrar el landing. Inténtelo luego.[PARAM]</li>");
        	    echo $this->alertas->alertaError($message);
        	    exit;
            }
            
    	    /*
            * ----------------------------
            * INSERTAR IMAGEN LANDING
            * ----------------------------
            */
            
            if ($img->isValid() && ! $img->hasMoved()) 
            {
                /*
                * ----------------------------
                * GUARDAR ARCHIVO ADJUNTO
                * ----------------------------
                */
                $ruta = "public/files/Landing/".date("Y", strtotime($fechaActual))."/".date("m", strtotime($fechaActual))."/";
                
                if(!file_exists($ruta))
                {
                    @mkdir($ruta, 0777, true);
                }
        
        		# si exsite la carpeta o se ha creado
        		if (file_exists($ruta) || @mkdir($ruta)) 
                {
                    $nuevonombre = $idLanding.'.'.$extensionImg;
                    
                    $pathimg = $ruta.$nuevonombre;
                    
                    $estadoMove = $img->move($ruta, $nuevonombre);
                    
                    if (!$estadoMove) 
                    {
                        $this->landing->delete(["IDLanding", $idLanding]);
                        $this->landingParametros->delete(["IDLanding", $idLanding]);
                        
                        $message = sprintf($this->mensajeError->msg201, "<li>No se pudo registrar el landing. Inténtelo luego.[IMG]</li>");
                	    echo $this->alertas->alertaError($message);
                	    exit;
                    }
                }
                else
                {
                    $this->landing->delete(["IDLanding", $idLanding]);
                    $this->landingParametros->delete(["IDLanding", $idLanding]);
                    
                    $message = sprintf($this->mensajeError->msg201, "<li>No se pudo registrar el landing. Inténtelo luego.[FICH]</li>");
            	    echo $this->alertas->alertaError($message);
            	    exit;
                }
            }
            
            $message = sprintf($this->mensajeError->msg201, "<li>Se registró el landing correctamente..</li>");
            echo $this->alertas->alertaExito($message);
            echo $this->alertas->refrescar(1);
            EXIT;
        } else {
            $message = sprintf($this->mensajeError->msg201, "<li>Su sesión ha caducado. Inicie sesión e inténtelo de nuevo.</li>");
    	    echo $this->alertas->alertaError($message);
    	    exit;
        }
	}
	
	public function listadoParametrosLanding()
	{
	    if (isset($this->items['id'])) 
    	{
    	    /*
            * ----------------------------
            * INFORMACIÓN RECIBIDA POST
            * ----------------------------
    		*/

    	    $idLanding = $this->request->getPost('idLanding');
    	    
    		/*
            * -------------
            * BASE DE DATOS
            * -------------
            */
    		
    		$listadoParametros = $this->landingParametros->where("IDLanding", $idLanding)->orderBy("Posicion", "ASC")->findAll();
            $parametros = array();
    
            if (!empty($listadoParametros)) {
                foreach($listadoParametros as $value)
                {
                    $parametros[] = array(
    					'idparametro'   => (string) $value['IDParametro'],
             	        'idlanding'     => (string) $value['IDLanding'],
             	        'nombre'        => (string) $value['Nombre'],
             	        'posicion'      => (string) $value['Posicion'],
             	        'tipodato'      => (string) $value['TipoDato']
                    );
                }
    
                $resultado = array(
    				'listadoParametros' => json_encode($parametros)
    			);
            } else {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}

        } 
        else 
        {
            $resultado = array(
				'session' => 0,
			);
        }
        
        echo json_encode($resultado, JSON_NUMERIC_CHECK);
	}
	
	/**************************************************************************/
	
    /************************* LANDING PERSONALIZADOS *************************/
    
    public function pruebaVerisMartLanding()
    {
        echo "landing david";
    }
    
    // public function pruebaVerisMartLanding($param1)
    // {
    //     echo "Un parámetro: ".$param1;
    // }
    
    // public function pruebaVerisMartLanding($param1, $param2)
    // {
    //     echo "Dos parámetros: ".$param1." y ".$param2.";";
    // }
    
    public function referidosField($prospecto, $matriculaVendedor, $tipoVenta, $nombreCliente, $correoCliente)
    {
        $data = array(
            "NroProspecto"      => $prospecto,
            "MatriculaVendedor" => $matriculaVendedor,
            "TipoVenta"         => $tipoVenta,
            "NombreCliente"     => $nombreCliente,
            "CorreoCliente"     => $correoCliente
        );
		
		$data = array_merge($data, $this->items);
		
		return view('landing/referido_field',$data);
    }
    
    public function guardarReferidosField()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        // var_dump($this->request->getPost());exit;

        $msjError           = TRUE;
        $nombreCliente      = $this->request->getPost('NombreCliente');
        $correoCliente      = $this->request->getPost('CorreoCliente');
        $idProspecto        = $this->request->getPost('IdProspectoRP');
        $matricula          = $this->request->getPost('Matricula');
        $tipoVenta          = $this->request->getPost('TipoVenta');
        $auxPrimerNombre    = $this->request->getPost('auxPrimerNombre');
        $auxPrimerApellido  = $this->request->getPost('auxPrimerApellido');
        $auxTelefono        = $this->request->getPost('auxTelefono');
        $detalleNombre      = $this->request->getPost('PrimerNombre');
        $detalleApellido    = $this->request->getPost('PrimerApellido');
        $detalleTelefono    = $this->request->getPost('Telefono');
        $detalleSegmento    = $this->request->getPost('Segmento');
        $cantidadDetalle    = $this->request->getPost('DetalleReferido');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($nombreCliente, 'required|trim|alphaspecial|minlength[1]|maxlength[150]', 'Nombre Cliente');
        $error .= $this->complementos->validaCampo($correoCliente, 'required|trim|email', 'Correo Cliente');
        $error .= $this->complementos->validaCampo($matricula, 'required|trim|minlength[1]|maxlength[10]', 'Matrícula');
        $error .= $this->complementos->validaCampo($idProspecto, 'required|trim|numeric', 'ID Prospecto');
        $error .= $this->complementos->validaCampo($tipoVenta, 'required|trim|minlength[1]|maxlength[10]', 'Tipo Venta');
        
        if($cantidadDetalle === "0")
	    {
	        $error .= "<li>Debe añadir referidos para enviar el formulario.</li>";
	    }
	    
        if ($error != '') {
            
            $concat = sprintf($this->mensajeError->msg201, $error);
            $message = $this->alertas->alertaError($concat);
            // EXIT;
            
            $resultado = array(
    			'success'   => false,
    			'message'   => $message
    		);
    		
    		echo json_encode($resultado);
    		EXIT;
        }
        
	    /*
        * ----------------------------
        * INSERTAR INFORMACIÓN REFERIDOS
        * ----------------------------
        */
        
        $data = array (
            'Matricula'     => $matricula,
            'IdProspectoRP' => $idProspecto,
            'created_at'    => $fechaActual,
            'updated_at'    => $fechaActual,
            'TipoVenta'     => $tipoVenta
        );

        $lastId = $this->referidosField->insert($data, TRUE);
        
        if($lastId !== FALSE){
            $idReferido = $lastId;
        }
        else
        {
            $concat = sprintf($this->mensajeError->msg201, "<li>No se pudo registrar los referidos. Inténtelo luego.[LAND]</li>");
    	    $message = $this->alertas->alertaError($concat);
    	   // exit;
    	   
            $resultado = array(
    			'success'   => false,
    			'message'   => $message
    		);
    		
    		echo json_encode($resultado);
    		EXIT;
        }
        
	    /*
        * ----------------------------
        * INSERTAR INFORMACIÓN DETALLE
        * ----------------------------
        */
        
        //BlackList de Telefonos
        
        $blacklist = array('999999999','987654321','937297146','991834556');
        
        $dataDetalle = array();
        
        if($cantidadDetalle > 0)
        {
            for($i = 0; $i < $cantidadDetalle; $i++)
            {
                if(in_array($detalleTelefono[$i], $blacklist))
                {
                    $dataDetalle[] = array (
                        'Referido_ID'       => $idReferido,
                        'PrimerNombre'      => $detalleNombre[$i],
                        'PrimerApellido'    => $detalleApellido[$i],
                        'Telefono'          => $detalleTelefono[$i],
                        'Segmento'          => $detalleSegmento[$i],
                        'FechaHoraREG'      => $fechaActual,
                        'created_at'        => $fechaActual,
                        'updated_at'        => $fechaActual,
                        'EstadoReferido'    => 'BlackList'
                    );
                }
                else
                {
                    $dataDetalle[] = array (
                        'Referido_ID'       => $idReferido,
                        'PrimerNombre'      => $detalleNombre[$i],
                        'PrimerApellido'    => $detalleApellido[$i],
                        'Telefono'          => $detalleTelefono[$i],
                        'Segmento'          => $detalleSegmento[$i],
                        'created_at'        => $fechaActual,
                        'updated_at'        => $fechaActual,
                        'FechaHoraREG'      => $fechaActual
                    );
                }
            }
        }
        
        $statusDetalle = $this->referidosFieldDetalle->insertBatch($dataDetalle);
        
        if($statusDetalle === FALSE)
        {
            $this->referidosField->delete(["Id", $idReferido]);
            
            $concat = sprintf($this->mensajeError->msg201, "<li>No se pudo registrar los referidos. Inténtelo luego.[PARAM]</li>");
    	    $message = $this->alertas->alertaError($concat);
    	   // exit;
    	   
            $resultado = array(
    			'success'   => false,
    			'message'   => $message
    		);
    		
    		echo json_encode($resultado);
    		EXIT;
        }
        
	    /*
        * ----------------------------
        * ENVIAR CORREO ELECTRÓNICO
        * ----------------------------
        */
        
        $arrayCuerpo = array(
            'baseUrl'   => $this->items['baseUrl'],
            'cantidad'  => $cantidadDetalle,
            'nombre'    => $detalleNombre,
            'apellido'  => $detalleApellido,
            'telefono'  => $detalleTelefono,
            'segmento'  => $detalleSegmento,
            'url_politica'  => "https://clientesverisure.com/politica-de-privacidad-referido/",
            'url_tyc'       => "https://clientesverisure.com/terminos-y-condiciones-referido/"
        );
        
        $cuerpo = $this->plantillasCorreo->cuerpoConfirmacionReferidoCliente($arrayCuerpo);
        
        $asunto='¡Hola! Ya es parte de Alarma Verisure';
        // $correoDestino = array($correoCliente);
        $configCorreo = array(
            "NOMBRE_ORIGEN" => "Programa amigos - Verisure Perú",
            "CORREO_ORIGEN" => 'programa.amigos@verisure.pe',
            "CORREOS_DESTINOS" => array("josejesus.cuadros@verisure.pe"),
            "CORREOS_COPIA" => array(),
            "CORREOS_OCULTO" => array('joseenrique.nanquen@verisure.pe'),
            "ASUNTO" => $asunto,
            "MENSAJE" => $cuerpo
        );

        $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);
        
        $resultado = array(
			'success'  => true
		);
		
		echo json_encode($resultado);
		EXIT;
        // $dataCorreo = array(
        //     "IDOrdenCompra" => $datosOrdenCompra['IDOrdenCompra'],
        //     "Momento"       => "CAMBIO DE ESTADO",
        //     "Response"      => $estadoCorreo['RESPUESTA'],
        //     "Error"         => $estadoCorreo['ERROR'],
        //     'UsuarioCrea'   => $this->items['id'],
        //     'FechaCrea'     => $fechaActual,    
        //     'Localhost'     => $this->request->getIPAddress()
        // );

        // $this->correoStatusOrdenCompra->insert($dataCorreo, TRUE);
    }
    
    public function referidosTCTV($idVenta, $matriculaVendedor, $tipoVenta, $nombreCliente, $centroCosto, $correoCliente)
    {
        $data = array(
            "idVenta"            => $idVenta,
            "MatriculaVendedor" => $matriculaVendedor,
            "TipoVenta"         => $tipoVenta,
            "NombreCliente"     => $nombreCliente,
            "CentroCosto"       => $centroCosto,
            "CorreoCliente"     => $correoCliente
        );
		
		$data = array_merge($data, $this->items);
		
		return view('landing/referido_tctv',$data);
    }
    
    public function guardarReferidosTCTV()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        // var_dump($this->request->getPost());exit;

        $msjError           = TRUE;
        $nombreCliente      = $this->request->getPost('NombreCliente');
        $correoCliente      = $this->request->getPost('CorreoCliente');
        $idVenta            = $this->request->getPost('IdVenta');
        $matricula          = $this->request->getPost('Matricula');
        $tipoVenta          = $this->request->getPost('TipoVenta');
        $centroCosto        = $this->request->getPost('CC');
        $auxPrimerNombre    = $this->request->getPost('auxPrimerNombre');
        $auxPrimerApellido  = $this->request->getPost('auxPrimerApellido');
        $auxTelefono        = $this->request->getPost('auxTelefono');
        $detalleNombre      = $this->request->getPost('PrimerNombre');
        $detalleApellido    = $this->request->getPost('PrimerApellido');
        $detalleTelefono    = $this->request->getPost('Telefono');
        $detalleSegmento    = $this->request->getPost('Segmento');
        $cantidadDetalle    = $this->request->getPost('DetalleReferido');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($nombreCliente, 'required|trim|alphaspecial|minlength[1]|maxlength[150]', 'Nombre Cliente');
        $error .= $this->complementos->validaCampo($correoCliente, 'required|trim|email', 'Correo Cliente');
        $error .= $this->complementos->validaCampo($matricula, 'required|trim|minlength[1]|maxlength[10]', 'Matrícula');
        $error .= $this->complementos->validaCampo($idVenta, 'required|trim|numeric', 'ID Venta');
        $error .= $this->complementos->validaCampo($tipoVenta, 'required|trim|minlength[1]|maxlength[10]', 'Tipo Venta');
        $error .= $this->complementos->validaCampo($centroCosto, 'required|trim|minlength[1]|maxlength[10]', 'Centro de Costo');
        
        if($cantidadDetalle === "0")
	    {
	        $error .= "<li>Debe añadir referidos para enviar el formulario.</li>";
	    }
	    
        if ($error != '') {
            
            $concat = sprintf($this->mensajeError->msg201, $error);
            $message = $this->alertas->alertaError($concat);
            // EXIT;
            
            $resultado = array(
    			'success'   => false,
    			'message'   => $message
    		);
    		
    		echo json_encode($resultado);
    		EXIT;
        }
        
	    /*
        * ----------------------------
        * INSERTAR INFORMACIÓN REFERIDOS
        * ----------------------------
        */
        
        $data = array (
            'IdVenta'       => $idVenta,
            'Matricula'     => $matricula,
            'TipoVenta'     => $tipoVenta,
            'CC'            => $centroCosto,
            'created_at'    => $fechaActual,
            'updated_at'    => $fechaActual
        );

        $lastId = $this->referidosTCTV->insert($data, TRUE);
        
        if($lastId !== FALSE){
            $idReferido = $lastId;
        }
        else
        {
            $concat = sprintf($this->mensajeError->msg201, "<li>No se pudo registrar los referidos. Inténtelo luego.[LAND]</li>");
    	    $message = $this->alertas->alertaError($concat);
    	   // exit;
    	   
            $resultado = array(
    			'success'   => false,
    			'message'   => $message
    		);
    		
    		echo json_encode($resultado);
    		EXIT;
        }
        
	    /*
        * ----------------------------
        * INSERTAR INFORMACIÓN DETALLE
        * ----------------------------
        */
        
        //BlackList de Telefonos
        
        $dataDetalle = array();
        
        if($cantidadDetalle > 0)
        {
            for($i = 0; $i < $cantidadDetalle; $i++)
            {
                $dataDetalle[] = array (
                    'Referido_ID'       => $idReferido,
                    'PrimerNombre'      => $detalleNombre[$i],
                    'PrimerApellido'    => $detalleApellido[$i],
                    'Telefono'          => $detalleTelefono[$i],
                    'Segmento'          => $detalleSegmento[$i],
                    'FechaHoraREG'      => $fechaActual,
                    'created_at'        => $fechaActual,
                    'updated_at'        => $fechaActual,
                    'TipoReferido'      => 'Referido Interno'
                );
            }
        }
        
        $statusDetalle = $this->referidosTCTVDetalle->insertBatch($dataDetalle);
        
        if($statusDetalle === FALSE)
        {
            $this->referidosTCTV->delete(["Id", $idReferido]);
            
            $concat = sprintf($this->mensajeError->msg201, "<li>No se pudo registrar los referidos. Inténtelo luego.[PARAM]</li>");
    	    $message = $this->alertas->alertaError($concat);
    	   // exit;
    	   
            $resultado = array(
    			'success'   => false,
    			'message'   => $message
    		);
    		
    		echo json_encode($resultado);
    		EXIT;
        }
        
	    /*
        * ----------------------------
        * ENVIAR CORREO ELECTRÓNICO
        * ----------------------------
        */
        
        $arrayCuerpo = array(
            'baseUrl'   => $this->items['baseUrl'],
            'cantidad'  => $cantidadDetalle,
            'nombre'    => $detalleNombre,
            'apellido'  => $detalleApellido,
            'telefono'  => $detalleTelefono,
            'segmento'  => $detalleSegmento,
            'url_politica'  => "https://clientesverisure.com/politica-de-privacidad-referido-telemarketing",
            'url_tyc'       => "https://clientesverisure.com/terminos-y-condiciones-referido-telemarketing-2"
        );
        
        $cuerpo = $this->plantillasCorreo->cuerpoConfirmacionReferidoCliente($arrayCuerpo);
        
        $asunto='¡Hola! Ya es parte de Alarma Verisure';
        // $correoDestino = array($correoCliente);
        $configCorreo = array(
            "NOMBRE_ORIGEN" => "Programa amigos - Verisure Perú",
            "CORREO_ORIGEN" => 'programa.amigos@verisure.pe',
            "CORREOS_DESTINOS" => array("josejesus.cuadros@verisure.pe"),
            "CORREOS_COPIA" => array(),
            "CORREOS_OCULTO" => array('joseenrique.nanquen@verisure.pe'),
            "ASUNTO" => $asunto,
            "MENSAJE" => $cuerpo
        );

        $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);
        
        $resultado = array(
			'success'  => true
		);
		
		echo json_encode($resultado);
		EXIT;
		
    }
    
    public function afiliacionMetodoPago($nroContrato, $nombreCliente, $apellidoCliente, $documento, $tipoDocumento, $correoCliente)
    {
        $data = array(
            "NroContrato"            => $nroContrato,
            "NombreCliente" => $nombreCliente,
            "ApellidoCliente"         => $apellidoCliente,
            "Documento"     => $documento,
            "TipoDocumento"       => $tipoDocumento,
            "CorreoCliente"     => $correoCliente
        );
		
		$data = array_merge($data, $this->items);
		
		return view('landing/afiliacion',$data);
    }
    
    public function afiliarCuentaBancaria()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        $encryption = Services::encryption();

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError       = TRUE;
        $nombreCuenta   = $this->request->getPost('ban_nombre_cuenta');
        $correoCuenta   = $this->request->getPost('ban_correo_cliente');
        $tipoDocumento  = $this->request->getPost('ban_tipo_documento');
        $nroDocumento   = $this->request->getPost('ban_nro_documento');
        $banco          = $this->request->getPost('ban_tipo_banco');
        $tipoCuenta     = $this->request->getPost('ban_tipo_cuenta');
        $tipoMoneda     = $this->request->getPost('ban_tipo_moneda');
        $nroCuenta      = $this->request->getPost('ban_nro_cuenta');
        $nroContrato    = $this->request->getPost('ncontrato');
        $urlAfiliacion  = $this->request->getPost('urlAfiliacion');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($nombreCuenta, 'required|trim|alphaspecial|minlength[1]|maxlength[100]', 'Nombre Titular de Cuenta');
        $error .= $this->complementos->validaCampo($correoCuenta, 'required|trim|email', 'Email');
        $error .= $this->complementos->validaCampo($tipoDocumento, 'required|trim|minlength[1]|maxlength[10]', 'Tipo de Documento');
        $error .= $this->complementos->validaCampo($nroDocumento, 'required|trim|minlength[1]|maxlength[20]', 'Documento');
        $error .= $this->complementos->validaCampo($banco, 'required|trim|minlength[1]|maxlength[20]', 'Banco');
        $error .= $this->complementos->validaCampo($tipoCuenta, 'required|trim|minlength[1]|maxlength[10]', 'Tipo de Cuenta');
        $error .= $this->complementos->validaCampo($tipoMoneda, 'required|trim|minlength[1]|maxlength[10]', 'Tipo de Moneda');
        $error .= $this->complementos->validaCampo($nroCuenta, 'required|trim|minlength[1]|maxlength[20]', 'Número de Cuenta');
        $error .= $this->complementos->validaCampo($nroContrato, 'required|trim|minlength[1]|maxlength[9]', 'Número de Contrato');
        
        if ($error != '') {
            
            $concat = sprintf($this->mensajeError->msg201, $error);
            $message = $this->alertas->alertaError($concat);
            // EXIT;
            
            $resultado = array(
    			'success'   => false,
    			'popup'     => false,
    			'message'   => $message
    		);
    		
    		echo json_encode($resultado);
    		EXIT;
        }
        
	    /*
        * ----------------------------
        * VALIDAR SERVICIO DE ENCRIPTACIÓN
        * ----------------------------
        */
        
        if (!$this->encripto) {
            $resultado = array(
    			'success'   => false,
    			'popup'     => true,
    			'message'   => "El servicio de cifrado no está disponible"
    		);
		
    		echo json_encode($resultado);
    		EXIT;
        }
        
	    /*
        * ----------------------------
        * BUSCAR INFORMACIÓN DE AFILIACION
        * ----------------------------
        */
        
        $beneficiary    = $this->afiliacionOtros->where("contrato", $nroContrato)->orderBy('id', 'DESC')->first();
        $beneficiaryMDP = $this->afiliacionMDP->where("ncontrato", $nroContrato)->orderBy('id', 'DESC')->first();
        
	    /*
        * ----------------------------
        * INSERTAR INFORMACIÓN AFILIACIÓN
        * ----------------------------
        */
        
        if(empty($beneficiary))
        {
            $dataInsertOtros = array(
                'contrato'              => $nroContrato,
                'nombre_apellido'       => $nombreCuenta,
                'correo'                => $correoCuenta,
                'tipo_documento'        => $tipoDocumento,
                'documento'             => $nroDocumento,
                'nombre_banco_tarjeta'  => $banco,
                'tipo_tarjeta_cuenta'   => $tipoCuenta,
                'tipo_moneda'           => $tipoMoneda,
                'numero_cuenta_tarjeta' => $nroCuenta,
                'fechahorareg'          => $fechaActual,
                'status'                => 'ENPROCESO'
            );
            
            $lastIdOtros = $this->afiliacionOtros->insert($dataInsertOtros, TRUE);
            
        }
        else
        {
            $dataUpdateOtros = array(
                'status'    => 'Reemplazado'
            );
            
            $lastIdOtrosBefore = $this->afiliacionOtros->update([$beneficiary['id']], $dataUpdateOtros);
            
            $dataInsertOtros = array(
                'contrato'              => $nroContrato,
                'nombre_apellido'       => $nombreCuenta,
                'correo'                => $correoCuenta,
                'tipo_documento'        => $tipoDocumento,
                'documento'             => $nroDocumento,
                'nombre_banco_tarjeta'  => $banco,
                'tipo_tarjeta_cuenta'   => $tipoCuenta,
                'tipo_moneda'           => $tipoMoneda,
                'numero_cuenta_tarjeta' => $nroCuenta,
                'fechahorareg'          => $fechaActual,
                'status'                => 'ENPROCESO'
            );
            
            $lastIdOtrosAfter = $this->afiliacionOtros->insert($dataInsertOtros, TRUE);
            
        }
        
        if(empty($beneficiaryMDP))
        {
            $dataInsertMDP = array(
                'ncontrato'     => $nroContrato,
                'nombre'        => $nombreCuenta,
                'correo'        => $correoCuenta,
                'status'        => "ENPROCESO",
                'numero'        => "****".substr($nroCuenta, -5),
                'tipo'          => $banco,
                'fechahorareg'  => $fechaActual
            );
            
            $lastIdMDP = $this->afiliacionMDP->insert($dataInsertMDP, TRUE);
        }
        else
        {
            $dataUpdateMDP = array(
                'nombre'        => $nombreCuenta,
                'correo'        => $correoCuenta,
                'status'        => "ENPROCESO",
                'numero'        => "****".substr($nroCuenta, -5),
                'tipo'          => $banco,
                'fechahoramod'  => $fechaActual
            );
            
            $lastIdMDP = $this->afiliacionMDP->update([$beneficiaryMDP['id']], $dataUpdateMDP);
        }
        
	    /*
        * ----------------------------
        * ENCRIPTAR RESPUESTA
        * ----------------------------
        */
        
        $status = "200";

        // Encriptar status
        $encryptedData = $this->encripto->encrypt($status);
        
        // Convertir el texto encriptado a base64
        $base64EncryptedData = base64_encode($encryptedData);
        
        // Hacerlo "URL-safe" reemplazando caracteres
        $urlSafeBase64EncryptedData = strtr($base64EncryptedData, '+/', '-_');
        $urlSafeBase64EncryptedData = rtrim($urlSafeBase64EncryptedData, '=');

	    /*
        * ----------------------------
        * ENVIAR CORREO ELECTRÓNICO
        * ----------------------------
        */
        
        $arrayCuerpo = array(
            'baseUrl'           => $this->items['baseUrl'],
            'status'            => $cantidadDetalle,
            'motivo'            => $detalleNombre,
            'url'               => $detalleApellido,
            'url_afiliacion'    => $urlAfiliacion,
            
            'telefono'  => $detalleTelefono,
            'segmento'  => $detalleSegmento,
            'url_politica'  => "https://clientesverisure.com/politica-de-privacidad-referido-telemarketing",
            'url_tyc'       => "https://clientesverisure.com/terminos-y-condiciones-referido-telemarketing-2"
        );
        
        $cuerpo = $this->plantillasCorreo->cuerpoConfirmacionReferidoCliente($arrayCuerpo);
        
        $asunto='¡Hola! Ya es parte de Alarma Verisure';
        // $correoDestino = array($correoCliente);
        $configCorreo = array(
            "NOMBRE_ORIGEN" => "Programa amigos - Verisure Perú",
            "CORREO_ORIGEN" => 'programa.amigos@verisure.pe',
            "CORREOS_DESTINOS" => array("josejesus.cuadros@verisure.pe"),
            "CORREOS_COPIA" => array(),
            "CORREOS_OCULTO" => array('joseenrique.nanquen@verisure.pe'),
            "ASUNTO" => $asunto,
            "MENSAJE" => $cuerpo
        );

        $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);
        
	    /*
        * ----------------------------
        * DEVOLVER RESPUESTA
        * ----------------------------
        */
        
        // Imprimir el resultado cifrado
        // echo $encrypted;
        $resultado = array(
			'success'   => true,
			'popup'     => true,
			'message'   => "Texto encriptado (Base64 URL-safe): " . $urlSafeBase64EncryptedData . "<br>"
		);
		
		echo json_encode($resultado);
		EXIT;
    }
    
    public function afiliarDiners()
    {
        
    }
    
    public function afiliarNiubis()
    {
        
    }
    
    public function hojacertificacion($idVentaEncriptada)
    { 

        $hmac = '';
        if ($idVentaEncriptada) {
            // list($idVentaEncriptada, $hmac) = explode('.', $idVentaEncriptada);
            if (strpos($idVentaEncriptada, '.') !== false) {
            list($idVentaEncriptada, $hmac) = explode('.', $idVentaEncriptada);
            } else {
                // Manejo del error: asignar valores predeterminados o lanzar una excepción
                $hmac = null;
            }

            $key = 'Verisure';

            if ($this->verifyHMAC($idVentaEncriptada, $hmac, $key)) { 
                $decryptedValue = $this->decryptXOR($idVentaEncriptada, $key); 
                $idventa = htmlspecialchars($decryptedValue, ENT_QUOTES, 'UTF-8');
                // $idventa = 359906;
                // Obtener datos de la venta desde el modelo
                $dataVenta = $this->VentaModel->obtenerVentaPorId($idventa);

                // Enviar datos a la vista
                $nombresOpciones = [
                        "Contrafactura" => "Contrafactura",
                        "Tarjetacredito" => "Tarjeta crédito",
                        "Tarjetadebito" => "Tarjeta débito",
                        "Cuentadebito" => "Cuenta débito"
                    ];
                    
                $nombresDescuento = [
                        "ninguno" => "ninguno",
                        "1mes" => "50% descuento 1 mes",
                        "2meses" => "50% descuento 2 meses",
                        "3meses" => "50% descuento 3 meses",
                        "4meses" => "50% descuento 4 meses",
                        "6meses" => "50% descuento 6 meses",
                        "2mesesBBVA" => "50% descuento 2 meses BBVA",
                        "2mesesInterbank" => "50% descuento 2 INTERBANK ",
                    ]; 
                            // Calcular valores usando funciones separadas
                $descuentoFormaPagoCuota = $this->calcularDescuentoFormaPago($dataVenta['FormaPagoCuota']);
                $montoCuota = $this->calcularMontoCuota($dataVenta['TipoKIT'], $dataVenta['TotalCuotaMonitoreo'], $descuentoFormaPagoCuota);
                $baseCuota = $this->calcularBaseCuota($dataVenta['TipoKIT']);
                $PAIData = $this->calcularMontoPAI($dataVenta['PAI']); 
                $totalInstalacion = $dataVenta['PrecioKit'] + $dataVenta['TotalExtra'] + $PAIData['monto'];
                $textoDetalleRegalo = $this->generarTextoRegalos($dataVenta['DetalleRegalos']);
                $DetalleRegalos = json_decode($dataVenta['DetalleRegalos'], true);
                // Generar HTML
                // $dataVenta = json_decode(json_encode($dataVenta), true);
                $html = $this->generarHtmlCertificacion($dataVenta, $descuentoFormaPagoCuota, $baseCuota, $montoCuota, $PAIData, $totalInstalacion, $textoDetalleRegalo, $nombresOpciones, $nombresDescuento, $DetalleRegalos);
       
                $data = array(
                    "nombresOpciones"     => $nombresOpciones,
                    "nombresDescuento"       => $nombresDescuento,
                    "dataVenta"     => $dataVenta,
                    "html"          => $html,
                    "idVentaEncriptada" => $idventa,
                    'montoCuota'        => $montoCuota,
                    "baseCuota"         => $baseCuota,
                    "descuentoFormaPagoCuota"   => $descuentoFormaPagoCuota,
                    "totalInstalacion"          => $totalInstalacion,
                    "cuotas"                    => $PAIData['cuotas'],
                    "montoPAI"                  => $PAIData['monto'],
                    "textoDetalleRegalo"        => $textoDetalleRegalo
                );
        	
        		$data = array_merge($data, $this->items);
        		
        		return view('landing/hojacertificacion',$data);
            } else {
                return view('errors/500');
            }
        } else {
            return view('errors/500');
        }
        

    }
    
    private function decryptXOR($text, $key)
    {
        $text = base64_decode($text);
        $result = '';
        for ($i = 0; $i < strlen($text); $i++) {
            $result .= chr(ord($text[$i]) ^ ord($key[$i % strlen($key)]));
        }
        return $result;
    }

    private function verifyHMAC($data, $hmac, $secret)
    {
        $expectedHmac = '';
        for ($i = 0; $i < strlen($data); $i++) {
            $expectedHmac .= chr(ord($data[$i]) ^ ord($secret[$i % strlen($secret)]));
        }
        return base64_encode($expectedHmac) === $hmac;
    }
    
    private function generarHtmlCertificacion($dataVenta, $descuentoFormaPagoCuota, $baseCuota, $montoCuota, $PAIData, $totalInstalacion, $textoDetalleRegalo, $nombresOpciones, $nombresDescuento, $DetalleRegalos)
    {
        $html = "
        <div class='container'>
            <div class='container'>
                <img src='https://www.clientesverisure.com/libro-de-reclamaciones/public/images/pdfOc3.png' width='110' height='76' style='display: block; margin: 0 auto;' alt='Logo'>
            </div>                  
            <div class='header'>Resumen de Contratación</div>                     
            <div class='section-title'>Datos y Facturación</div>
            <table>
                <tr><td style='width: 50%;'>N° CONTRATO</td><td><div class='internal-border'>{$dataVenta['NContrato']}</div></td></tr>
                <tr><td>DNI/RUC/RUS</td><td><div class='internal-border'>" . ltrim($dataVenta['DocumentoScoring'], "0") . "</div></td></tr>
                <tr><td>Titular del Contrato</td><td><div class='internal-border'>{$dataVenta['NombreScoring']}</div></td></tr>
                <tr><td>Dirección de Instalación</td><td><div class='internal-border'>" . strtoupper($dataVenta['Direccion']) . "</div></td></tr>
                <tr>
                    <td>Tipo de Comprobante</td>
                    <td class='checkbox-group'>
                        <label>
                            <input type='checkbox' " . ($dataVenta['TipoComprobante'] == 'Boleta' ? 'checked' : '') . " disabled> Boleta
                        </label>
                        <label>
                            <input type='checkbox' " . ($dataVenta['TipoComprobante'] == 'Factura' ? 'checked' : '') . " disabled> Factura
                        </label>
                    </td>
                </tr>
                <tr><td>Fecha de Contrato</td><td><div class='internal-border'>{$dataVenta['fechainstalacionver']}</div></td></tr>
                <tr><td>Correo electrónico para Facturación 1</td><td><div class='internal-border'>" . strtoupper($dataVenta['Correo']) . "</div></td></tr>
                <tr><td>Número telefónico autorizado</td><td><div class='internal-border'>{$dataVenta['movil']}</div></td></tr>
            </table>
                
            <div class='section-title'>Cuota de Monitoreo y Costo por Servicio de Instalación</div>
            <table>    
                <tr><td style='text-align: right; width: 50%;'><b>Cuota monitoreo mensual (con IGV)</b></td><td><div class='internal-border'>S/. " . number_format($montoCuota, 2) . "</div></td></tr>";
                if ($descuentoFormaPagoCuota > 0) {
                    $html .= "
                        <tr>
                            <td style='text-align: right;'>Cuota monitoreo</td>
                            <td><div class='internal-border'>S/. " . number_format(($baseCuota + $dataVenta['TotalCuotaMonitoreo']), 2) . "</div></td>
                        </tr>";
                }
                
                if ($dataVenta['FormaPagoCuota'] === 'Tarjetacredito' || $dataVenta['FormaPagoCuota'] === 'Tarjetadebito') {
                    $html .= "
                        <tr>
                            <td style='text-align: right;'>(-) Descuento por forma de pago afiliada (*)</td>
                            <td><div class='internal-border'>S/. " . number_format(($descuentoFormaPagoCuota), 2) . "</div></td>
                        </tr>";
                }
                
                $html .= "
                <tr><td style='text-align: right;'><b>Costo de instalación de equipos (con IGV)</b></td><td><div class='internal-border'>S/. " . number_format($totalInstalacion, 2) . "</div></td></tr>";
                
                if ($PAIData['cuotas'] > 0 || $dataVenta['TotalExtra'] > 0) {
                    $html .= "
                        <tr>
                            <td style='text-align: right;'>Pago inicial</td>
                            <td><div class='internal-border'>S/. " . number_format(($dataVenta['PrecioKit'] + $dataVenta['TotalExtra']), 2) . "</div></td>
                        </tr>";
                }
                
                if ($dataVenta['PAI'] != 'NO') {
                    $html .= "
                        <tr>
                            <td style='text-align: right;'Pago Aplazado de Instalación - PAI <br>(". $PAIData['cuotas'] ." cuotas mensuales de S/. 30.00)</td>
                            <td><div class='internal-border'>S/. " . number_format(($dataVenta['PrecioKit'] + $dataVenta['TotalExtra']), 2) . "</div></td>
                        </tr>";
                }
                
            $html .= "
                </table> 
                <div class='section-title'>Datos de Tarjeta o Cuenta Afiliada</div>
                <table>
                    <tr>
                        <td style='text-align: right; width: 50%;'>Tipo de tarjeta o Cuenta</td>
                        <td><div class='internal-border'>". (isset($nombresOpciones[$dataVenta['FormaPagoCuota']]) ? $nombresOpciones[$dataVenta['FormaPagoCuota']] : 'Forma de pago desconocida')."</div></td>
                    </tr>
                </table>";
                
                if ((count($DetalleRegalos) > 0) || $dataVenta['dsctCuota'] != 'ninguno') {
                    $html .= "
                        <div class='section-title'>Otros datos adicionales</div>
                        <table>";
                    
                    if (count($DetalleRegalos) > 0) {
                        $html .= "
                            <tr>
                                <td style='text-align: right;width: 50%;'>Regalos</td>
                                <td><div class='internal-border'>". ucfirst($textoDetalleRegalo) ."</div></td>
                            </tr>";
                    }
                    
                    if ($dataVenta['dsctCuota'] != 'ninguno') {
                        $html .= "
                            <tr>
                                <td style='text-align: right;width: 50%;'>Oferta en cuota</td>
                                <td><div class='internal-border'>". (isset($nombresDescuento[$dataVenta['dsctCuota']]) ? $nombresDescuento[$dataVenta['dsctCuota']] : 'Descuento cuota desconocida') ."</div></td>
                            </tr>";
                    }
                    
                    $html .= "
                        </table>";
                }


                $html .= "
                <p class='small-note2'>(*) Descuento en el costo mensual aplica SOLO con tarjeta de crédito afiliada. Los cobros se realizan por mes adelantado, los primeros días de cada mes.</p>
                <table class='pricing-table'>
                    <tr>
                        <td class='price-cell' style='width: 25%;'>
                            <div class='price-box'>
                                <span class='currency'>S/</span>
                                <span class='amount'>". number_format($montoCuota, 2) ."</span>
                            </div>
                        </td>
                        <td class='description-cell' style='width: 40%;text-align: right;'>
                            <p class='installment-description'>
                                Cuota mensual del servicio de monitoreo de alarma <span class='include-igv'>(incluye IGV)</span>
                            </p>
                        </td>
                        <td class='description-cell' style='width: 1%;'>
                                <p class='installment-highlight'>
                                ". ($dataVenta['PAI']!='NO' ? '<span class="highlight">+</span>' : '<span class="highlight">x</span>') ."
                            </p>
                        </td>";
                        
                    if ($dataVenta['PAI'] != 'NO') {
                        $html .= "
                            <td class='description-cell' style='width: 30%;'>
                                <p class='installment-highlight'>
                                    <span class='highlight'>S/30.00 x ". $PAIData['cuotas'] ."</span><br> <span class='installment-period'>meses de instalación</span>
                                </p>
                            </td>";
                    }else{
                        $html .= "
                            <td class='description-cell' style='width: 30%;'>
                                <p class='installment-highlight'>
                                    <span class='highlight'>36</span><br> <span class='installment-period'>meses de instalación</span>
                                </p>
                            </td>";
                    }
                        
                        
                $html .= "        
                    </tr>
            </table>
            
            <div class='container'>
                        <div class='section-title'>Condiciones</div>
                        <ol>
                            <li>Ha sido capacitado sobre las características y condiciones de los servicios contratados, así como, el uso del funcionamiento del sistema de alarma</li>
                            <li>Se le descargó correctamente y fue capacitado sobre el uso de la App My Verisure.</li>
                            <li>Tengo conocimiento sobre la vigencia de contrato y periodo de permanencia.</li>
                            <li>Se le entregó y explicó las funciones del Manual de Uso del Sistema de Alarma.</li>
                            <li>Se le informó que nos contactaríamos desde el número (01) 5147321 o (01) 7102330 para la validación de sus datos de instalación.</li>
                            <li>Se le informó que por seguridad es aconsejable cambiar sus palabras claves desde su aplicativo.</li>                            
                        </ol>
                        <ul class='no-bullets'>
                            <li>
                                <label>
                                    <input type='checkbox' name='aceptoterminos' aria-invalid='false' class='form-check-input' id='acepto-condiciones'>
                                    <span class='wpcf7-list-item-label'>Conforme con las condiciones.</span>
                                </label>
                            </li>
                            <li>
                                <label>
                                    <input type='checkbox' name='aceptopolitica' aria-invalid='false' class='form-check-input' id='acepto-politica'>
                                    <span class='wpcf7-list-item-label'>
                                        He leído la <strong><font color='blue'><u>
                                        <a href='https://clientesverisure.com/media/2021/11/politica-de-privacidad-de-datos.pdf' target='_blank'>
                                            Política de Privacidad
                                        </a></u></font></strong>.
                                    </span>
                                </label>
                            </li>
                            <li>
                                <label>
                                    <input type='checkbox' name='aceptopromociones' aria-invalid='false' class='form-check-input' id='acepto-promociones'>
                                    <span class='wpcf7-list-item-label'>Acepto recibir promociones de Verisure, a través de SMS, WhatsApp, pop-ups, locuciones, llamadas u otros medios equivalentes a mis números telefónicos registrados.</span>
                                </label>
                            </li>
                        </ul>
            </div>
            <div class='container installment'>
                <input type='button' id='btn_enviar' value='ACEPTAR' class='wpcf7-form-control wpcf7-submit btn btn-red'>
            </div>
        </div>";
        
        return $html;
    }
    
    private function calcularDescuentoFormaPago($formaPago)
    {
        $descuentos = [
            'Tarjetacredito' => 15,
            'Tarjetadebito' => 10
        ];
        return $descuentos[$formaPago] ?? 0;
    }
    
    private function calcularBaseCuota($tipoKIT)
    {
        $baseCuota = ($tipoKIT === "Basico PRO" || $tipoKIT === "ZeroVision PRO") ? 209 : 199;
        return $baseCuota ;
    }
    
    private function calcularMontoCuota($tipoKIT, $totalCuotaMonitoreo, $descuento)
    {
        $baseCuota = ($tipoKIT === "Basico PRO" || $tipoKIT === "ZeroVision PRO") ? 209 : 199;
        return round($baseCuota + $totalCuotaMonitoreo - $descuento, 2);
    }
    
    private function calcularMontoPAI($PAI)
    {
        $cuotas=0;
        if($PAI !== 'NO'){
            $cuotas = match ($PAI) {
                'PAI 30x36' => 36,
                'PAI 30x48' => 48,
                default => 0
            };
        }
        
        return ['monto' => 30 * $cuotas, 'cuotas' => $cuotas];
    }
    
    private function generarTextoRegalos($detalleRegalos)
    {
        $detalleRegalos = json_decode($detalleRegalos, true);
        if (empty($detalleRegalos)) {
            return "";
        }
    
        $items = array_map(fn($item) => htmlspecialchars(strtolower($item['Item'])), $detalleRegalos);
        return implode(", ", array_slice($items, 0, -1)) . (count($items) > 1 ? " y " : "") . end($items);
    }


    public function enviarHojaCertificacion()
    {  
        
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError               = TRUE;
        
        $idVenta                = $this->request->getPost('idventa');
        $ncontrato              = $this->request->getPost('ncontrato');
        $dniRuc                 = $this->request->getPost('dni_ruc');
        $titularContrato        = $this->request->getPost('titular_contrato');
        $direccionInstalacion   = $this->request->getPost('direccion_instalacion');
        $tipoComprobante        = $this->request->getPost('tipo_comprobante');
        $fechaContrato          = date("Y-m-d", strtotime($this->request->getPost('fecha_contrato')));
        $correoFacturacion      = $this->request->getPost('correo_facturacion');
        $telefonoAutorizado     = $this->request->getPost('telefono_autorizado');
        $cuotaMonitoreo         = str_replace(',','',$this->request->getPost('cuota_monitoreo'));
        $cuotaDescuento         = str_replace(',','',$this->request->getPost('cuota_con_descuento'));
        $descuentoFormaPago     = str_replace(',','',$this->request->getPost('descuento_forma_pago'));
        $costoInstalacion       = str_replace(',','',$this->request->getPost('costo_instalacion'));
        $pagoInicial            = str_replace(',','',$this->request->getPost('pago_inicial'));
        $cuotas                 = $this->request->getPost('cuotas_pai');
        $montoPai               = str_replace(',','',$this->request->getPost('monto_pai'));
        $formaPago              = $this->request->getPost('forma_pago');
        $regalos                = $this->request->getPost('regalos');
        $ofertaCuota            = $this->request->getPost('oferta_cuota');
        $aceptoCondiciones      = $this->request->getPost('acepto_condiciones');
        $aceptoPolitica         = $this->request->getPost('acepto_politica');
        $aceptoPromociones      = $this->request->getPost('acepto_promociones');
        
        $nroDocumento           = $this->request->getPost('ban_nro_documento');
        $fechainstalacionver    = $this->request->getPost('fecha_contrato');
        $PAI                    = $this->request->getPost('pai');
        $NombreScoring          = $this->request->getPost('titular_contrato');
        
        
        
  
        
        if($idVenta){
            
        
            /*
            * -------------------
            * CRECION PDF ADJUNTO
            * -------------------
            */
            
            $nombresOpciones = [
                "Contrafactura" => "Contrafactura",
                "Tarjetacredito" => "Tarjeta crédito",
                "Tarjetadebito" => "Tarjeta débito",
                "Cuentadebito" => "Cuenta débito"
            ];
                        
            $nombresDescuento = [
                "ninguno" => "ninguno",
                "1mes" => "50% descuento 1 mes",
                "2meses" => "50% descuento 2 meses",
                "3meses" => "50% descuento 3 meses",
                "4meses" => "50% descuento 4 meses",
                "6meses" => "50% descuento 6 meses",
                "2mesesBBVA" => "50% descuento 2 meses BBVA",
                "2mesesInterbank" => "50% descuento 2 INTERBANK "
            ]; 
            // $idVenta = '';
            // $hmac = '';
            // if ($idVentaEncriptada) { 
            //     // list($idVentaEncriptada, $hmac) = explode('.', $idVentaEncriptada);
            //     if (strpos($idVentaEncriptada, '.') !== false) { var_dump("hola"); exit();
            //     list($idVentaEncriptada, $hmac) = explode('.', $idVentaEncriptada);
            //     } else {
            //         // Manejo del error: asignar valores predeterminados o lanzar una excepción
            //         $hmac = null;
            //     }
    
            //     $key = 'Verisure';
    
            //     if ($this->verifyHMAC($idVentaEncriptada, $hmac, $key)) { 
            //         $decryptedValue = $this->decryptXOR($idVentaEncriptada, $key); 
            //         $idVenta = htmlspecialchars($decryptedValue, ENT_QUOTES, 'UTF-8');
                    
                    
            //     }
            
            // }
            
            $dataVenta = $this->VentaModel->obtenerVentaPorId($idVenta);
            
            // Calcular valores usando funciones separadas
            $descuentoFormaPagoCuota = $this->calcularDescuentoFormaPago($dataVenta['FormaPagoCuota']);
            $montoCuota = $this->calcularMontoCuota($dataVenta['TipoKIT'], $dataVenta['TotalCuotaMonitoreo'], $descuentoFormaPagoCuota);
            $baseCuota = $this->calcularBaseCuota($dataVenta['TipoKIT']);
            $PAIData = $this->calcularMontoPAI($dataVenta['PAI']); 
            $totalInstalacion = $dataVenta['PrecioKit'] + $dataVenta['TotalExtra'] + $PAIData['monto'];
            $textoDetalleRegalo = $this->generarTextoRegalos($dataVenta['DetalleRegalos']); 
            $DetalleRegalos = json_decode($dataVenta['DetalleRegalos'], true);
    
            ob_start(); 
    		$anio = date('Y');
            
            // Agrega contenido al PDF utilizando HTML
            $html = "";
    
            $html .= "<!DOCTYPE html>
                        <html lang='en'>
                        <head>
                             <meta charset='utf-8'/>
                            <link href='https://fonts.googleapis.com/css2?family=Fira+Sans:ital@0;1&display=swap' rel='stylesheet'>
                            <style type='text/css'>
                                body {
                                    font-family: 'Fira Sans', sans-serif;
                                    margin: 0;
                                    padding: 0px;
                                    box-sizing: border-box;
                                   
                                }
                                table {
                                    width: 100%;
                                    border-collapse: collapse;
                                    margin-bottom: 5px;
                                }
                                .header {
                                    background-color: #e4002b;
                                    color: white;
                                    text-align: center;
                                    padding: 15px;
                                    font-size: 16px;
                                    font-weight: 600;
                                    border-radius: 0 0 40px 0;
                                    margin-bottom: 10px;
                                }
                                .container {
                                    max-width: 700px;
                                    margin: 0 auto;
                                }
                                .section-title {
                                    font-weight: 600;
                                    font-size: 16px;
                                    margin-bottom: 5px;
                                }
                                table td {
                                    padding: 0px 5px 0px 5px;
                                    font-size: 12px;
                                    border: 1px solid #ddd;
                                }
                                .internal-border {
                                    padding: 5px;
                                    width: 100%;
                                   
                                }
                                .small-note2 {
                                    background-color: #e0e3e5;
                                    padding: 10px 15px;
                                    border-radius: 20px;
                                    color: #555;
                                    font-size: 14px;
                                    text-align: center;
                                }
                                .no-bullets {
                                    list-style: none;
                                    padding: 0;
                                }
                                .installment {
                                    margin-top: 20px;
                                }
                                .divimagen{
                                     text-align: center;
                                }
                                .include-igv {
                                    color: #333;
                                    font-weight: bold;
                                    font-size: 12px;
                                }        
                                .price-cell {
                                    text-align: center;
                                    
                                }
                                
                                .description-cell {
                                    padding-left: 10px;
                                    vertical-align: top;
                                }
                                
                                .price-box {
                                    border-radius: 8px;
                                    
                                    justify-content: center;
                                    border: 2px solid #E2002F;
                                    border-radius: 8px;
                                    padding: 10px;
                                }
                                .currency {
                                    font-size: 20px;
                                    font-weight: bold;
                                    margin-right: 5px;
                                }
                                li{
                                    font-size: 10px;
                                }
                        
                                .amount {
                                    font-size: 20px;
                                    font-weight: 600;
                                    color: #333;
                                }
                                
                                
                                .installment-highlight {
                                    font-size: 16px;
                                    color: #E2002F;
                                    font-weight: bold;
                                    margin: 0;
                                }
                                .plus-cell {
                                    padding: 0 5px;
                                    text-align: center;
                                    vertical-align: middle;
                                }
                                
                                .highlight {
                                    font-size: 20px;
                                    color: #E2002F;
                                    font-weight: bold;
                                }
                                
                                .installment-period {
                                    font-size: 14px;
                                    color: #E2002F;
                                    font-weight: 200;
                                }
                                .pricing-table {
                                    border-collapse: collapse;
                                    border: 1px solid #ffffff;
                                    width: auto;
                                }
                                .installment-description {
                                    font-size: 18px;
                                    color: #555;
                                    margin: 0;
                                }
                            </style>
                        </head>
                        <body>
                            <div class='container'>
                                <div class='divimagen' style='margin-bottom: 20px;'>
                                    <img src='https://www.clientesverisure.com/libro-de-reclamaciones/public/images/pdfOc3.png' width='110' height='76'  alt='Logo'>
                                </div>
                                <div class='header'>Resumen de Contratación</div>
                                <div class='section-title'>Datos y Facturación</div>
                                <table>
                                    <tr>
                                        <td style='width: 50%;'>N° CONTRATO</td>
                                        <td ><div class='internal-border'>".$dataVenta['NContrato']."</div></td>
                                    </tr>
                                    <tr>
                                        <td>DNI/RUC/RUS</td>
                                        <td><div class='internal-border'>".ltrim($dataVenta['DocumentoScoring'], '0')."</div></td>
                                    </tr>
                                    <tr>
                                        <td>Titular del Contrato</td>
                                        <td><div class='internal-border'>".$dataVenta['NombreScoring']."</div></td>
                                    </tr>
                                    <tr>
                                        <td>Dirección de Instalación</td>
                                        <td><div class='internal-border'>".strtoupper($dataVenta['Direccion'])."</div></td>
                                    </tr>
                                    <tr>
                                        <td>Tipo de Comprobante</td>
                                        <td> <div class='internal-border'>".strtoupper($dataVenta['TipoComprobante'])."</div></td>
                                    </tr>
                                    <tr>
                                        <td>Fecha de Contrato</td>
                                        <td><div class='internal-border'>".$dataVenta['fechainstalacionver']."</div></td>
                                    </tr>
                                    <tr>
                                        <td>Correo electrónico para Facturación 1</td>
                                        <td><div class='internal-border'>".strtoupper($dataVenta['Correo'])."</div></td>
                                    </tr>
                                    <tr>
                                        <td>Número telefónico autorizado</td>
                                        <td><div class='internal-border'>".$dataVenta['movil']."</div></td>
                                    </tr>
                                </table>
                                <div class='section-title'>Cuota de Monitoreo y Costo por Servicio de Instalación</div>
                                <table>
                                    <tr>
                                        <td style='text-align: right; width: 50%;'><b>Cuota monitoreo mensual (con IGV)</b></td>
                                        <td><div class='internal-border'>S/. ".number_format($montoCuota, 2)."</div></td>
                                    </tr>
                                    ".(($descuentoFormaPagoCuota > 0) ? "<tr><td style='text-align: right;'>Cuota monitoreo</td><td><div class='internal-border'>S/. ".number_format(($baseCuota + $dataVenta['TotalCuotaMonitoreo']), 2)."</div></td></tr>" : "")."
                                    ".(($dataVenta['FormaPagoCuota'] === 'Tarjetacredito' || $dataVenta['FormaPagoCuota'] === 'Tarjetadebito') ? "<tr><td style='text-align: right;'>(-) Descuento por forma de pago afiliada (*)</td><td><div class='internal-border'>S/. ".number_format($descuentoFormaPagoCuota, 2)."</div></td></tr>" : "")."
                                    <tr>
                                        <td style='text-align: right;'><b>Costo de instalación de equipos (con IGV)</b></td>
                                        <td><div class='internal-border'>S/. ".number_format($totalInstalacion, 2)."</div></td>
                                    </tr>
                                    ".(($PAIData['cuotas'] > 0 || $dataVenta['TotalExtra'] > 0) ? "<tr><td style='text-align: right;'>Pago inicial</td><td><div class='internal-border'>S/. ".number_format(($dataVenta['PrecioKit'] + $dataVenta['TotalExtra']), 2)."</div></td></tr>" : "")."
                                    ".(($dataVenta['PAI'] != 'NO') ? "<tr><td style='text-align: right;'>Pago Aplazado de Instalación - PAI <br>(".$PAIData['cuotas']." cuotas mensuales de S/. 30.00)</td><td><div class='internal-border'>S/. ".number_format($PAIData['monto'], 2)."</div></td></tr>" : "")."
                                </table>
                                <div class='section-title'>Datos de Tarjeta o Cuenta Afiliada</div>
                                <table>
                                    <tr>
                                        <td style='text-align: right; width: 50%;'>Tipo de tarjeta o Cuenta</td>
                                        <td><div class='internal-border'>".(isset($nombresOpciones[$dataVenta['FormaPagoCuota']]) ? $nombresOpciones[$dataVenta['FormaPagoCuota']] : "Forma de pago desconocida")."</div></td>
                                    </tr>
                                </table>
                                ".((count($DetalleRegalos) > 0 || $dataVenta['dsctCuota'] != 'ninguno') 
                                    ? "<div class='section-title'>Otros datos adicionales</div>
                                        <table>
                                        ". (count($DetalleRegalos) > 0
                                        ? "<tr>
                                            <td style='text-align: right; width: 50%;'>Regalos</td>
                                            <td><div class='internal-border'>" . ucfirst($textoDetalleRegalo) . "</div></td>
                                        </tr>"
                                        : "").
                                        ($dataVenta['dsctCuota'] != 'ninguno'
                                        ? "<tr>
                                            <td style='text-align: right; width: 50%;'>Oferta en cuota</td>
                                            <td><div class='internal-border'>" . 
                                            (isset($nombresDescuento[$dataVenta['dsctCuota']]) ? $nombresDescuento[$dataVenta['dsctCuota']] : "Descuento cuota desconocida") . 
                                            "</div></td>
                                        </tr>"
                                        : ""
                                        )
                                    : "")."</table>
                                    <p class='small-note2'>(*) Descuento en el costo mensual aplica SOLO con tarjeta de crédito afiliada. Los cobros se realizan por mes adelantado, los primeros días de cada mes.</p>
                                    <table class='pricing-table' style='border: none important!;'>
                                        <tr>
                                            <td class='price-cell' style='width: 25%;border: none important!;'>
                                                <div class='price-box'>
                                                    <span class='currency'>S/</span>
                                                    <span class='amount'>".number_format($montoCuota, 2)."</span>
                                                </div>
                                            </td>
                                            <td class='description-cell' style='width: 40%;text-align: right;border: none important!;'>
                                                <p class='installment-description'>Cuota mensual del servicio de monitoreo de alarma <span class='include-igv'>(incluye IGV)</span></p>
                                            </td>
                                            <td class='description-cell' style='width: 1%;border: none important!;'>
                                                <p class='installment-highlight'>".($dataVenta['PAI'] != 'NO' ? "<span class='highlight'>+</span>" : "<span class='highlight'>x</span>")."</p>
                                            </td>
                                            <td class='description-cell' style='width: 30%;border: none important!;'>
                                                <p class='installment-highlight'>".($dataVenta['PAI'] != 'NO' ? "<span class='highlight'>S/30.00 x ".$cuotas."</span><br> <span class='installment-period'>meses de instalación</span>" : "<span class='highlight'>36</span><br> <span class='installment-period'>meses de instalación</span>")."</p>
                                            </td>
                                        </tr>
                                    </table>
                                    <div class='container'>
                                        <div class='section-title'>Condiciones</div>
                                        <ol class='no-bullets'>
                                            <li>(*) Ha sido capacitado sobre las características y condiciones de los servicios contratados, así como, el uso del funcionamiento del sistema de alarma</li>
                                            <li>(*) Se le descargó y fue capacitado sobre el uso de la App My Verisure.</li>
                                            <li>(*) Tengo conocimiento sobre la vigencia de contrato y periodo de permanencia.</li>
                                            <li>(*) Se le entregó y explicó el Manual de Uso del Sistema de Alarma.</li>
                                            <li>(*) Se le informó que nos contactaríamos desde el número (01) 5147321 o (01) 7102330 para la validación de sus datos de instalación.</li>
                                            <li>(*) Se le informó que por seguridad es aconsejable cambiar sus palabras claves desde su aplicativo.</li>
                                        </ol>
                                    </div>
                            </div>
                        </body>
                        </html>";
    
    			ob_end_clean();   
                
                $filename=$idVenta;
                $this->pdf->guardarpdf($html, $filename, $stream=TRUE, $paper = 'A4', $orientation = "portrait");
    
    
                // Ruta al archivo
                $filePath = FCPATH . 'public/pdfs/'.$filename.'.pdf';
                
                // Verificar si el archivo existe
                if (!file_exists($filePath)) {
                    // Manejar el error o generar un mensaje de error
                    throw new \Exception("El archivo PDF no existe: " . $filePath);
                }
    
                // Obtener el tamaño del archivo
                $fileSize = filesize($filePath);
                
                // Leer el contenido del archivo
                $fileContent = file_get_contents($filePath);
                
                // Convertir a Base64
                $fileBase64 = base64_encode($fileContent);
    
            
            /*
            * ----------------------------
            * VALIDACIÓN DE REQUERIMIENTOS
            * ----------------------------
            */
            
        //     $error = '';
        //     $error .= $this->complementos->validaCampo($nombreCuenta, 'required|trim|alphaspecial|minlength[1]|maxlength[100]', 'Nombre Titular de Cuenta');
        //     $error .= $this->complementos->validaCampo($correoCuenta, 'required|trim|email', 'Email');
        //     $error .= $this->complementos->validaCampo($tipoDocumento, 'required|trim|minlength[1]|maxlength[10]', 'Tipo de Documento');
        //     $error .= $this->complementos->validaCampo($nroDocumento, 'required|trim|minlength[1]|maxlength[20]', 'Documento');
        //     $error .= $this->complementos->validaCampo($banco, 'required|trim|minlength[1]|maxlength[20]', 'Banco');
        //     $error .= $this->complementos->validaCampo($tipoCuenta, 'required|trim|minlength[1]|maxlength[10]', 'Tipo de Cuenta');
        //     $error .= $this->complementos->validaCampo($tipoMoneda, 'required|trim|minlength[1]|maxlength[10]', 'Tipo de Moneda');
        //     $error .= $this->complementos->validaCampo($nroCuenta, 'required|trim|minlength[1]|maxlength[20]', 'Número de Cuenta');
        //     $error .= $this->complementos->validaCampo($nroContrato, 'required|trim|minlength[1]|maxlength[9]', 'Número de Contrato');
            
        //     if ($error != '') {
                
        //         $concat = sprintf($this->mensajeError->msg201, $error);
        //         $message = $this->alertas->alertaError($concat);
        //         // EXIT;
                
        //         $resultado = array(
        // 			'success'   => false,
        // 			'popup'     => false,
        // 			'message'   => $message
        // 		);
        		
        // 		echo json_encode($resultado);
        // 		EXIT;
        //     }
            
    	    /*
            * ----------------------------
            * VALIDAR SERVICIO DE ENCRIPTACIÓN
            * ----------------------------
            */
            
        //     if (!$this->encripto) {
        //         $resultado = array(
        // 			'success'   => false,
        // 			'popup'     => true,
        // 			'message'   => "El servicio de cifrado no está disponible"
        // 		);
    		
        // 		echo json_encode($resultado);
        // 		EXIT;
        //     }
            
            /*
            * ----------------------------
            * ENVIAR CORREO ELECTRÓNICO
            * ----------------------------
            */
            $arrayCuerpo = array(
                'baseUrl'               => $this->items['baseUrl'],
                'NombreScoring'         => $NombreScoring,
                'ncontrato'             =>$ncontrato,
                'fechainstalacionover'  =>$fechainstalacionver,
                'PAI'                   => $PAI,
                'cuotas'                => $cuotas
            );
            
            $cuerpo = $this->plantillasCorreo->envioHojaCertificacion($arrayCuerpo);
            
            $asunto='Estado de contratación de servicio  – Alarmas Verisure';
            $usuarioEnvio="Certificacion de la Venta";
            $remitente="certificaciondelaventa@verisure.pe";
            // $correoDestino = array($correoCliente);
            $configCorreo = array(
                "NOMBRE_ORIGEN" => $usuarioEnvio,
                "CORREO_ORIGEN" => $remitente,
                "CORREOS_DESTINOS" => array("josejesus.cuadros@verisure.pe"),
                "CORREOS_COPIA" => array(),
                "CORREOS_OCULTO" => array('placido.curilopez@verisure.pe'),
                "ASUNTO" => $asunto,
                "MENSAJE" => $cuerpo,
                "ADJUNTOS" => array(
                                array(
                                    'FileName' => $idVenta.'.pdf',
                                    'Encode' => 'Base64',
                                    'Size' => $fileSize,
                                    'Value' => $fileBase64
                                )
                )
            );
     
            $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);
            
            $estadoCorreoDecoded = is_string($estadoCorreo) ? json_decode($estadoCorreo, true) : $estadoCorreo;


            // Verificar si la clave "ERROR" existe y si está vacía
            if (isset($estadoCorreoDecoded['ERROR']) && $estadoCorreoDecoded['ERROR'] === '') {

        
        
        $fechaActual = date("Y-m-d H:i:s");
        
                $dataInsert = array (
                    'idventa'=>$idVenta,
                    'ncontrato'=>$ncontrato,
                    'dni_ruc'=>$dniRuc,
                    'titular_contrato'=>$titularContrato,
                    'direccion_instalacion'=>$direccionInstalacion,
                    'tipo_comprobante'=>$tipoComprobante,
                    'fecha_contrato'=>$fechaContrato,
                    'correo_facturacion'=>$correoFacturacion,
                    'telefono_autorizado'=>$telefonoAutorizado,
                    'cuota_monitoreo'=>$cuotaMonitoreo,
                    'cuota_con_descuento'=>$cuotaDescuento,
                    'descuento_forma_pago'=>$descuentoFormaPago,
                    'costo_instalacion'=>$costoInstalacion,
                    'pago_inicial'=>$pagoInicial,
                    'cuotas_pai'=>$cuotas,
                    'monto_pai'=>$montoPai,
                    'forma_pago'=>$formaPago,
                    'regalos'=>$regalos,
                    'oferta_cuota'=>$ofertaCuota,
                    'acepto_condiciones'=>$aceptoCondiciones,
                    'acepto_politica'=>$aceptoPolitica,
                    'acepto_promociones'=>$aceptoPromociones,
                    'estado'=>'AceptaCondiciones',
                    'fecharegistro'=> $fechaActual
                ); 
          
            
                $idhojacertificacion=$this->hojaCertificacion->insert($dataInsert, TRUE);
                
                if($idhojacertificacion > 0){
                    echo json_encode($estadoCorreo);
                }else{
                    echo "No se guardaron los datos en Certificación";
                }
            } else {
                // Hay un error
                echo "Se encontró un error: " . $estadoCorreoDecoded['ERROR'];
            }

            // echo json_encode($estadoCorreo);
        }else{
            
        }

    }
    
	/**************************************************************************/
	
    /************************ REGIÓN DISTRITO *********************************/
    
	/**************************************************************************/
	
    /**************************** MONEDAS *************************************/
    
	/**************************************************************************/
	
    /***************************** TIPOS DOCUMENTO ****************************/
    
	/**************************************************************************/
	
    /************************** ESTRUCTURA DIRECCIÓN **************************/
    
	/**************************************************************************/
	
    /**************************** ESTRUCTURA ÁREAS ****************************/
    
	/**************************************************************************/
	
    /*************************** ESTRUCTURA SUBÁREAS **************************/
    
	/**************************************************************************/
	
    /******************* ESTRUCTURA SUBÁREAS - DELEGACIONES *******************/
    
	/**************************************************************************/
	
    /************************* ESTRUCTURA DELEGACIONES ************************/
    
	/**************************************************************************/
	
    /************************* ESTRUCTURA DEPARTAMENTAL ************************/
    
	/**************************************************************************/
	
    /******************************** USUARIOS ********************************/
    
	/**************************************************************************/
	
	
}