<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>

<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>

    			<!-- Start table -->
            <div class="row">
                    <div class="col-12">
                        
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title mb-0">Arrow Nav Steps</h4>
                            </div>
                            <div class="card-body">
                                <!--<form action="#" class="form-steps" autocomplete="off">-->
                                    <div class="step-arrow-nav mb-4">
                                        <ul class="nav nav-pills custom-nav nav-justified" role="tablist">
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link active" id="step-import-tab" data-bs-toggle="pill" data-bs-target="#step-import" type="button" role="tab" aria-controls="step-import" aria-selected="true">1. Importar</button>
                                            </li>
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link" id="step-report-tab" data-bs-toggle="pill" data-bs-target="#step-report" type="button" role="tab" aria-controls="step-report" aria-selected="false" disabled>2. Reporte</button>
                                            </li>
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link" id="step-save-tab" data-bs-toggle="pill" data-bs-target="#step-save" type="button" role="tab" aria-controls="step-save" aria-selected="false" disabled>3. Guardar</button>
                                            </li>
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link" id="step-export-tab" data-bs-toggle="pill" data-bs-target="#step-export" type="button" role="tab" aria-controls="step-export" aria-selected="false" disabled>4. Exportar</button>
                                            </li>
                                        </ul>
                                    </div>
                        
                                    <div class="tab-content">
        								<!-- Paso 1: Importar -->
        								<div class="tab-pane fade show active" id="step-import" role="tabpanel" aria-labelledby="step-import-tab">
        									<div id="formulario-container">
        										<form class="formimportarCSVMetricasComplementarias" autocomplete="off" action="<?= $baseUrl ?>/importar-csv-metricas-complementarias" method="POST" enctype="multipart/form-data">
        											<h4 class="text-primary mb-4">
        												<i class="mdi mdi-file-import"></i> Importar Métricas Complementarias
        											</h4>
        											<div class="alert alert-info shadow-sm p-3 rounded">
        												<ul>
        													<li>Las fechas deben contar con el formato <strong>YYYY-MM-DD</strong>.</li>
        													<li>Evitar espacios en blanco al inicio y al final del campo.</li>
        												</ul>
        											</div>
        											<div class="mb-4">
        												<label for="fileCSVMetricasComplementarias" class="form-label">Seleccione Archivo CSV</label>
        												<input class="form-control" type="file" id="fileCSVMetricasComplementarias" name="fileCSVMetricasComplementarias" required>
        											</div>
        											<div class="d-flex justify-content-end">
        												<button type="submit" class="btn btn-success">
        													<i class="mdi mdi-content-save"></i> Guardar
        												</button>
        											</div>
        										</form>
        									</div>
        									<div id="reporte-tabla-container" class="mt-4" style="display: none;">
        										<div class="d-flex justify-content-end mb-2">
        											<button class="btn btn-primary me-2" id="abrir-formulario-modal">
        												<i class="mdi mdi-pencil"></i> Modificar Datos
        											</button>
        											<button class="btn btn-danger" id="eliminar-datos-importados">
        												<i class="mdi mdi-delete"></i> Eliminar Todo
        											</button>
        										</div>
        										<div class="table-responsive">
        											<table class="table table-bordered" id="tblMetricaNovedades2"></table>
        										</div>
        									</div>
        									<div class="d-flex justify-content-between mt-4">
                                                <button type="button" class="btn btn-success nexttab primerNexTab d-none" data-nexttab="step-report-tab">Siguiente</button>
                                            </div>
        								</div>

                        
                                        <!-- Step 2: Reporte -->
                                        <div class="tab-pane fade" id="step-report" role="tabpanel" aria-labelledby="step-report-tab">
                                            <!--<button class="btn btn-info mx-1 d-flex align-items-center" id="reporte-novedades">-->
                                            <!--    <i class="mdi mdi-plus-circle" style="font-size: 18px;"></i> Generar Reporte Novedades-->
                                            <!--</button>-->
                                            <div id="reporte-tabla-calculo-container" class="mt-4" style="display: none;">
                                                <div class="table-responsive">
                                                    <table class="table table-bordered" id="tblCalculoMetrica"></table>
                                                </div>
                                            </div>
                                            <div id="mensaje-sin-datos" class="alert alert-warning mt-3" style="display: none;">
                                                No hay datos disponibles para mostrar en el reporte.
                                            </div>
                                            <div class="d-flex justify-content-between mt-4">
                                                <button type="button" class="btn btn-light previestab" data-previous="step-import-tab">Anterior</button>
                                                <button type="button" class="btn btn-success nexttab" id="siguienteStep" data-nexttab="step-save-tab">Siguiente</button>
                                            </div>
                                        </div>
                        
                                        <!-- Step 3: Guardar -->
                                        <div class="tab-pane fade" id="step-save" role="tabpanel" aria-labelledby="step-save-tab">
                                            <div class="container mt-4">
                                                <button class="btn btn-success mb-3" id="guardar-reporte-novedades">
                                                    <i class="mdi mdi-content-save"></i> Guardar Reporte Novedades
                                                </button>
                                                <div class="alert alert-warning text-center" id="alerta-step-3">
                                                    <strong>Importante:</strong> La data que se muestra a continuación será guardada generando el <strong>Reporte de Novedades</strong>
                                                    Esta acción no podrá ser revertida y solo se puede crear un reporte por cada cierre.
                                                </div>
                                            </div>
                                            
                                            <div class="row">
                                                <div class="table-responsive mt-4">
                                                    <table class="table table-bordered" id="tblDatosFinales">
                                                        <!-- La tabla será inicializada con JavaScript -->
                                                    </table>
                                                </div>
                                            </div>
                                            <div class="d-flex justify-content-between mt-4">
                                                <button type="button" class="btn btn-light previestab" data-previous="step-report-tab">Anterior</button>
                                                <button type="button" class="btn btn-success nexttab" data-nexttab="step-export-tab">Siguiente</button>
                                            </div>
                                        </div>
                        
                                        <!-- Step 4: Exportar -->
                                        <div class="tab-pane fade" id="step-export" role="tabpanel" aria-labelledby="step-export-tab">
                                            
                                            <div class="container mt-4">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <!-- Encabezado -->
                                                        <h3 class="text-primary text-center mb-4">
                                                            <i class="mdi mdi-file-export"></i> Exportación de Reportes Generados
                                                        </h3>
                                                        <p class="text-center text-muted">
                                                            Seleccione el año y el reporte que desea exportar. También puede previsualizar los datos antes de proceder.
                                                        </p>
                                                    </div>
                                                </div>
                                            
                                                <!-- Selects y Botón Exportar -->
                                                <div class="row g-4 align-items-center">
                                                    <div class="col-md-6">
                                                        <label for="selectYear" class="form-label text-dark fw-bold">Seleccione Año</label>
                                                        <select id="selectYear" class="form-select shadow-sm">
                                                            <option value="">Seleccione un Reporte</option>
                                                            <!-- Opciones dinámicas desde el backend -->
                                                        </select>
                                                    </div>
                                                    <input type="hidden" id="idReporteNovedades">
                                        
                                                    <div class="col-md-6 d-grid">
                                                        <button type="button" class="btn btn-warning btn-lg shadow-sm d-flex align-items-center justify-content-center" id="btnReporteNovedades">
                                                            <i class="mdi mdi-file-download me-2"></i> Exportar
                                                        </button>
                                                    </div>
                                                </div>
                                            
                                            </div>
                                            
                                            <div class="row">
                                                <!-- Tabla para previsualización -->
                                                <div class="row mt-5">
                                                    <div class="col-md-12">
                                                        <div class="table-responsive shadow-sm rounded">
                                                            <table id="reportePreviewTable" class="table table-bordered table-hover align-middle">
                                                                
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="d-flex justify-content-start mt-4">
                                                <button type="button" class="btn btn-light previestab" data-previous="step-save-tab">Anterior</button>
                                            </div>
                                        </div>
                                    </div>
                                <!--</form>-->
                            </div>
                        </div>

                            <!-- end card -->
                    </div>
                </div>
                <!-- End table -->
                
	    </div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
	
</div>
	
<!-- Modal para importar nuevamente -->
<div class="modal fade" id="modalFormulario" tabindex="-1" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title">Importar Nuevamente</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
			</div>
			<div class="modal-body">
				<div id="formulario-container-modal">
					<!-- El formulario se reutiliza aquí -->
					<form  id="formimportarCSVMetricasComplementarias2" class="formimportarCSVMetricasComplementarias" autocomplete="off" action="<?= $baseUrl ?>/importar-csv-metricas-complementarias" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
        				<span class="respuesta"></span>
        				<div class="row modal-body">
        					<div class="col-12 mb-3">
        						<h4>Consideraciones:</h4>
        						<p>1.- Las fechas deben contar con el formato "YYYY-MM-DD".</p>
        						<p>2.- Evitar espacios en blanco al inicio y al final del campo</p>
        						<p>3.- Formato de las columnas [ATC, TMO, WP] son dos decimales y separado por "."</p>
        						<p>4.- Formato de la columna [PROD] son valores enteros.</p>
        					</div>
        
        					<div class="col-6 mb-3 d-flex justify-content-end">
        						
        						<a class='btn btn-info border-0 texto-indicador' style="color: #FFF" href='<?= base_url().'/public/docs/Plantillas/plantilla csv metricas desempeno.csv' ?>' download='Plantilla CSV Metricas'>Descargar Plantilla</a>
        						
        					</div>
        					<div class="mb-3">
        						<label for="fileCSVMetricasComplementarias" class="form-label">Seleccione CSV:</label>
        						<input class="form-control" type="file" id="fileCSVMetricasComplementarias" name="fileCSVMetricasComplementarias">
        					</div>
        				</div>
        				<div class="modal-footer">
        					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
        					<button type="submit" class="btn btn-success guardar-datos-de-importacion"><i class="mdi mdi-content-save"></i> Guardar</button>
        				</div>
        			</form>
				</div>
			</div>
		</div>
	</div>
</div>
	
<?= $this->section('js'); ?>
<script>
$(function () {
    
/************************************************/

$(document).ready(function () {
    
    const formularioContainer = $('#formulario-container');
    const tablaContainer = $('#reporte-tabla-container');
    const dataTableId = '#tblMetricaNovedades2';

    // Inicializar el DataTable
    const dataTable = $(dataTableId).DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            // "url": baseUrl + "/reporte-novedades-data-table",
            "url": baseUrl + "/metricas-complementarias-data-table",
            "type": "GET",
            "error": function (xhr, textStatus, errorThrown) {
                console.error("Error en el servidor:", xhr.responseText || "Sin detalles");
                alert("Ocurrió un error al cargar los datos.");
            }
        },
        "columns": [
            { "data": "idUsuario", "title": "ID Usuario" },
            { "data": "GrupoTrabajo", "title": "GrupoTrabajo" },
            { "data": "Nombres", "title": "Nombres" },
            { "data": "Apellidos", "title": "Apellidos" },
            { "data": "meses_en_empresa", "title": "Meses en Empresa" },
            { "data": "dias_trabajo_efectivo", "title": "Días Trabajo Efectivo" },
            { "data": "fechas_trabajo_efectivo", "title": "Fechas Trabajo Efectivo" },
            { "data": "dias_teletrabajo", "title": "Días Teletrabajo" },
            { "data": "fechas_teletrabajo", "title": "Fechas Teletrabajo" },
            { "data": "HHEE25", "title": "HHEE 25%" },
            { "data": "HHEE35", "title": "HHEE 35%" },
            { "data": "HHEE_dominical_100", "title": "HHEE Dominical 100%" },
            { "data": "HHEE_feriado", "title": "HHEE Feriado" },
            { "data": "HHEE_1ro_de_mayo", "title": "HHEE 1ro Mayo" },
            { "data": "HHEE_nocturnas", "title": "HHEE Nocturnas" },
            { "data": "bono_productividad", "title": "Bono Productividad" },
            { "data": "otros_bonos", "title": "Otros Bonos" },
            { "data": "bono_de_carrera", "title": "Bono de Carrera" },
            { "data": "bonificacion_por_desempeno", "title": "Bonificación Desempeño" },
            { "data": "bono_responsabilidad", "title": "Bono Responsabilidad" },
            { "data": "bono_inicio", "title": "Bono Inicio" },
            { "data": "bono_veritombola", "title": "Bono Veritombola" },
            { "data": "comisiones_upselling", "title": "Comisiones Upselling" },
            { "data": "reintegro_afecto", "title": "Reintegro Afecto" },
            { "data": "gift_card", "title": "Gift Card" },
            { "data": "gift_card_upselling", "title": "Gift Card Upselling" },
            { "data": "obsequios_upselling", "title": "Obsequios Upselling" },
            { "data": "obsequios_al_personal", "title": "Obsequios al Personal" },
            { "data": "descuento_por_equipo_celular", "title": "Descuento Equipo Celular" },
            { "data": "descuento_uniforme_materiales", "title": "Descuento Uniforme Materiales" },
            { "data": "descuento_por_demos", "title": "Descuento por Demos" },
            { "data": "descuento_eps", "title": "Descuento EPS" },
            { "data": "descuento_alarma_verisure", "title": "Descuento Alarma Verisure" },
            { "data": "descuento_seguro_rimac", "title": "Descuento Seguro Rimac" },
            { "data": "observaciones", "title": "Observaciones" },
            // { "data": "fecha_creacion", "title": "Fecha Creación" }
        ]
        ,
        "lengthMenu": [[5, 10, 25, 50], [5, 10, 25, 50]],
        "order": [[0, 'asc']],
        "initComplete": function (settings, json) {  console.log("initComplete ejecutado", json);
            if (json.data.length === 0) {
                // Si no hay datos, muestra el formulario y oculta la tabla
                formularioContainer.show();
                tablaContainer.hide();
                $('.primerNexTab').addClass('d-none');
            } else {
                // Si hay datos, oculta el formulario y muestra la tabla
                formularioContainer.hide();
                tablaContainer.show();
                $('.primerNexTab').removeClass('d-none');
            }
        }
    });

    // Manejo del evento de envío del formulario
    $(document).on('submit', '.formimportarCSVMetricasComplementarias', function (e) {
        e.preventDefault(); // Prevenir el envío del formulario por defecto

        const formData = new FormData(this); // Recoger los datos del formulario

        $.ajax({
            url: $(this).attr('action'), // URL configurada en el atributo "action"
            type: 'POST',
            data: formData,
            processData: false, // Evitar que jQuery procese los datos
            contentType: false, // Evitar que jQuery configure el tipo de contenido
            // beforeSend: function () {
            //     // Mostrar un loader o deshabilitar el botón si es necesario
            //     console.log("Procesando la importación...");
            // },
            success: function (response) {
                $('.respuesta').html(response);
                if (response.includes("toastr['success']")) {
                   

                    // Ocultar el formulario y mostrar la tabla
                    formularioContainer.hide();
                    tablaContainer.show();

                    // Recargar los datos del DataTable
                    dataTable.ajax.reload(null, false);

                    // Habilitar y cambiar al siguiente paso
                    // $('#step-report-tab').removeAttr('disabled').tab('show');
                    
                    $('.primerNexTab').removeClass('d-none');
                    $("#modalFormulario").modal('hide');
                } else {
                    // alert(response.message); // Mostrar mensaje de error
                    $('.primerNexTab').addClass('d-none');
                }
            },
            error: function (xhr, textStatus, errorThrown) {
                console.error("Error en el servidor:", xhr.responseText || "Sin detalles");
                alert("Ocurrió un error al importar el archivo.");
            },
            complete: function () {
                // Acciones al finalizar el proceso (si es necesario)
                console.log("Importación completada.");
            }
        });
    });

    // Cambiar entre tabs usando los botones "Siguiente" y "Anterior" // esta mas abajo
    // $(document).on('click', '.nexttab', function () {
    //     const nextTab = $(this).data('nexttab');
    //     $(`#${nextTab}`).removeAttr('disabled').tab('show');
    // });

    // $(document).on('click', '.previestab', function () {
    //     const previousTab = $(this).data('previous');
    //     $(`#${previousTab}`).tab('show');
    // });
    
    // Botón para abrir el modal
    $('#abrir-formulario-modal').on('click', function () {
        const modalContainer = $('#formulario-container-modal');
        modalContainer.html($('#formulario-container').html());
        $('#modalFormulario').modal('show');
    });

    // Botón para eliminar datos importados
    // $('#eliminar-datos-importados').on('click', function () {
    //     if (confirm('¿Estás seguro de eliminar todos los datos importados?')) {
    //         $.ajax({
    //             url: baseUrl + "/eliminar-datos-importados",
    //             type: 'POST',
    //             success: function (response) {
    //                 if (response.status === 'success') {
    //                     dataTable.ajax.reload();
    //                     formularioContainer.show();
    //                     tablaContainer.hide();
    //                 } else {
    //                     alert(response.message);
    //                 }
    //             },
    //             error: function () {
    //                 alert('Error al eliminar datos.');
    //             }
    //         });
    //     }
    // });
    
});

/************************************************/

$(document).ready(function () {
    const dataTableContainer = $('#reporte-tabla-calculo-container');
    const mensajeSinDatos = $('#mensaje-sin-datos');
    const siguienteBtn = $('#siguienteStep');
    const dataTableId = '#tblCalculoMetrica';

    // Al cambiar a Step 2
    $('#step-report-tab').on('shown.bs.tab', function () {
        // Realizar AJAX para verificar si hay datos
        $.ajax({
            url: baseUrl + "/metricas-calculadas-data-table",
            type: "GET",
            dataType: "json",
            success: function (response) {
                if (response.data && response.data.length > 0) {
                    // Ocultar mensaje de "sin datos" y mostrar el contenedor
                    mensajeSinDatos.hide();
                    dataTableContainer.show();
                    siguienteBtn.show();

                    // Inicializar el DataTable
                    if (!$.fn.DataTable.isDataTable(dataTableId)) { // Evitar reinicializar
                        $(dataTableId).DataTable({
                            "processing": true,
                            "serverSide": true,
                            "ajax": {
                                "url": baseUrl + "/metricas-calculadas-data-table",
                                "type": "GET"
                            },
                            "columns": [
                                { "title": "idUsuario" , "data": "idUsuario" , "class": "text-center"},
                                { "title": "GrupoTrabajo" , "data": "GrupoTrabajo" , "class": "text-center"},
                                { "title": "Nombres" , "data": "Nombres" , "class": "text-center"},
                                { "title": "Apellidos" , "data": "Apellidos" , "class": "text-center"},
                                { "title": "categoria" , "data": "categoria" , "class": "text-center"},
                                { "title": "horas_trabajadas" , "data": "horas_trabajadas" , "class": "text-center"},
                                { "title": "tardanza" , "data": "tardanza" , "class": "text-center"},
                                { "title": "horas_extras" , "data": "horas_extras" , "class": "text-center"},
                                { "title": "total_faltas" , "data": "total_faltas" , "class": "text-center"},
                                { "title": "bono_desempeno" , "data": "bono_desempeno" , "class": "text-center"},
                                { "title": "comision_total" , "data": "comision_total" , "class": "text-center"},
                            ],
                            "lengthMenu": [[10, 25, 50], [10, 25, 50]],
                            "order": [[0, 'asc']]
                        });
                    } else {
                        // Recargar DataTable si ya está inicializado
                        $(dataTableId).DataTable().ajax.reload(null, false);
                    }
                } else {
                    // Si no hay datos, mostrar mensaje
                    dataTableContainer.hide();
                    mensajeSinDatos.show();
                    siguienteBtn.hide();
                }
            },
            error: function (xhr, textStatus, errorThrown) {
                console.error("Error en el servidor:", xhr.responseText || "Sin detalles");
                alert("Ocurrió un error al verificar los datos.");
            }
        });
    });

});

/************************************************/

$(document).ready(function () {
    const dataTableFinalId = '#tblDatosFinales';
    const mensajeSinDatos = $('#mensaje-sin-datos'); // Mensaje de "sin datos"
    const step4Tab = $('#step-export-tab'); // Referencia al tab del Step 4
    
    // Al mostrar el Step 3
    $('#step-save-tab').on('shown.bs.tab', function () {
        // Realizar AJAX para obtener los datos de métricas calculadas y datos importados
        $.ajax({
            url: baseUrl + "/reporte-novedades-data-table", // URL para obtener los datos combinados
            type: "GET",
            dataType: "json",
            success: function (response) {
                if (response.data && response.data.length > 0) {
                    // Inicializar DataTable
                    if (!$.fn.DataTable.isDataTable(dataTableFinalId)) {
                        $(dataTableFinalId).DataTable({
                            "data": response.data,
                            "columns": [
                                { "title": "idUsuario" , "data": "idUsuario" , "class": "text-center"},
                                { "title": "Nombres" , "data": "Nombres" , "class": "text-center"},
                                { "title": "Apellidos" , "data": "Apellidos" , "class": "text-center"},
                                { "title": "categoria" , "data": "categoria" , "class": "text-center"},
                                { "title": "horas_trabajadas" , "data": "horas_trabajadas" , "class": "text-center"},
                                { "title": "tardanza" , "data": "tardanza" , "class": "text-center"},
                                { "title": "horas_extras" , "data": "horas_extras" , "class": "text-center"},
                                { "title": "total_faltas" , "data": "total_faltas" , "class": "text-center"},
                                { "title": "bono_desempeno" , "data": "bono_desempeno" , "class": "text-center"},
                                { "title": "comision_total" , "data": "comision_total" , "class": "text-center"},
                                { "title": "dias_trabajo_efectivo", "data": "dias_trabajo_efectivo", "class": "text-center" },
                                { "title": "fechas_trabajo_efectivo", "data": "fechas_trabajo_efectivo", "class": "text-center" },
                                { "title": "dias_teletrabajo", "data": "dias_teletrabajo", "class": "text-center" },
                                { "title": "fechas_teletrabajo", "data": "fechas_teletrabajo", "class": "text-center" },
                                { "title": "HHEE25", "data": "HHEE25", "class": "text-center" },
                                { "title": "HHEE35", "data": "HHEE35", "class": "text-center" },
                                { "title": "HHEE_dominical_100", "data": "HHEE_dominical_100", "class": "text-center" },
                                { "title": "HHEE_feriado", "data": "HHEE_feriado", "class": "text-center" },
                                // { "title": "HHEE_1ro_de_mayo", "data": "HHEE_1ro_de_mayo", "class": "text-center" },
                                { "title": "HHEE_nocturnas", "data": "HHEE_nocturnas", "class": "text-center" },
                                { "title": "bono_productividad", "data": "bono_productividad", "class": "text-center" },
                                { "title": "otros_bonos", "data": "otros_bonos", "class": "text-center" },
                                { "title": "bono_de_carrera", "data": "bono_de_carrera", "class": "text-center" },
                                { "title": "bonificacion_por_desempeno", "data": "bonificacion_por_desempeno", "class": "text-center" },
                                { "title": "bono_responsabilidad", "data": "bono_responsabilidad", "class": "text-center" },
                                { "title": "bono_inicio", "data": "bono_inicio", "class": "text-center" },
                                { "title": "bono_veritombola", "data": "bono_veritombola", "class": "text-center" },
                                { "title": "comisiones_upselling", "data": "comisiones_upselling", "class": "text-center" },
                                { "title": "reintegro_afecto", "data": "reintegro_afecto", "class": "text-center" },
                                { "title": "gift_card", "data": "gift_card", "class": "text-center" },
                                { "title": "gift_card_upselling", "data": "gift_card_upselling", "class": "text-center" },
                                { "title": "obsequios_upselling", "data": "obsequios_upselling", "class": "text-center" },
                                { "title": "obsequios_al_personal", "data": "obsequios_al_personal", "class": "text-center" },
                                { "title": "descuento_por_equipo_celular", "data": "descuento_por_equipo_celular", "class": "text-center" },
                                { "title": "descuento_uniforme_materiales", "data": "descuento_uniforme_materiales", "class": "text-center" },
                                { "title": "descuento_por_demos", "data": "descuento_por_demos", "class": "text-center" }
                            ],
                            "lengthMenu": [[10, 25, 50], [10, 25, 50]],
                            "order": [[0, 'asc']]
                        });
                    } else {
                        // Recargar datos si ya está inicializado
                        // $(dataTableFinalId).DataTable().clear().rows.add(response.data).draw();
                    }
                } else {
                    // $(dataTableFinalId).DataTable().clear().draw(); // Limpiar tabla
                    console.log("No hay datos disponibles para mostrar.");
                }
            },
            error: function (xhr, textStatus, errorThrown) {
                console.error("Error al cargar los datos finales:", xhr.responseText || "Sin detalles");
                Swal.fire({
                    html: "Ocurrió un error al cargar los datos finales.",
                    icon: "error",
                    heightAuto: true
                });
            }
        });
    });

    // Manejar el botón de guardar reporte
    $('#guardar-reporte-novedades').on('click', function () {
        var usuarioSession = <?= json_encode($idUsuarioSession); ?>;
        Swal.fire({
            title: '¿Está seguro?',
            html: 'La data que se guardará corresponde al reporte de novedades y no podrá ser modificada después.',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Guardar',
            cancelButtonText: 'Cancelar',
            heightAuto: true
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: baseUrl + '/grabar-reporte-novedades/'+ usuarioSession, // Endpoint para guardar el reporte
                    type: "POST",
                    success: function (response) { console.log(response);
                        $('.respuesta_global').html(response);
                        if (response.includes("toastr['success']")) {
                            Swal.fire({
                                    html: 'Reporte guardado exitosamente.',
                                    icon: 'success',
                                    heightAuto: true,
                                    showConfirmButton: true
                            });
                            $(dataTableFinalId).DataTable().clear().draw();
                            // Recargar los datos del DataTable
                            // $(dataTableFinalId).DataTable().ajax.reload(null, false);
                        // if ($.fn.DataTable.isDataTable(dataTableFinalId)) {
                        //     $(dataTableFinalId).DataTable().ajax.reload(null, false);
                        //     $('#tblDatosFinales').show(); // Asegurar que la tabla esté visible
                        // }
        
                        } else {
                            Swal.fire({
                                html: 'Ocurrió un error al guardar el reporte.',
                                icon: 'error',
                                heightAuto: true,
                                showConfirmButton: true
                            });
                        }
                
                
                        // if (response.data && response.data.length > 0) {
                        //     $(dataTableFinalId).DataTable().ajax.reload(null, false);
                                    
                        //     // Recargar el DataTable
                        //     // $(dataTableFinalId).DataTable().ajax.reload(function () {
                        //         // if ($(dataTableFinalId).DataTable().data().count() === 0) {
                                    
                                
                        //             // mensajeSinDatos.show(); // Mostrar mensaje "sin datos"
                        //             // Ir automáticamente al Step 4
                        //             // step4Tab.removeAttr('disabled').tab('show');
                        //         // }
                        //     // });
                        // } else {
                        //     Swal.fire({
                        //                 html: 'Reporte guardado exitosamente.',
                        //                 icon: 'success',
                        //                 heightAuto: true,
                        //                 showConfirmButton: true
                        //             });
                        //     // mensajeSinDatos.show(); // Mostrar mensaje "sin datos"
                        //     // $(dataTableFinalId).DataTable().clear().draw(); // Limpiar tabla
                        // }
                            
                    },
                    error: function (xhr, textStatus, errorThrown) {
                        Swal.fire({
                            html: 'Ocurrió un error al guardar el reporte.',
                            icon: 'error',
                            heightAuto: true,
                            showConfirmButton: true
                        });
                        console.error("Error al guardar el reporte:", xhr.responseText || "Sin detalles");
                    }
                });
            }
        });
    

    });
    
});


/* ------------------------------- */

$(document).ready(function () {
    // Inicializa Select2
    $("#selectYear").select2({
        placeholder: 'Seleccione un reporte',
        allowClear: true,
        ajax: {
            url: baseUrl + '/listado-reporte-novedades-select',
            dataType: 'json',
            type: "POST",
            delay: 250,
            processResults: function (data) {
                const results = data.map(function (item) {
                    return { id: item.idReporte, text: item.comboReporte };
                });

                // Insertar la opción "todos" al inicio
                results.unshift({ id: 'todos', text: 'Todos' });

                return { results: results };
            },
            error: function () {
                Swal.fire({
                    icon: 'error',
                    title: 'Error al cargar los datos',
                    text: 'No se pudieron cargar los reportes. Por favor, inténtelo más tarde.',
                    heightAuto: true
                });
            }
        }
    });

    // Maneja el cambio en el Select2
    $("#selectYear").on("change", function () {
        const selectedValue = $(this).val();
        if (selectedValue) {
            // Llama a la función para cargar la tabla del reporte seleccionado
            cargarReporteTabla(selectedValue);
            $("#idReporteNovedades").val(selectedValue);
        } else {
            // Limpia la tabla si no hay selección
            limpiarTablaReporte();
        }
    });
});

// Función para inicializar el DataTable con ServerSide
function cargarReporteTabla(idReporte) { console.log(idReporte);
    const tableId = '#reportePreviewTable';

    if ($.fn.DataTable.isDataTable(tableId)) {
        $(tableId).DataTable().destroy(); // Destruye la instancia existente
    }

    $(tableId).DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: baseUrl + '/obtener-reporte-novedades-seleccionada',
            type: 'GET',
            data: { idReporte: idReporte },
        },
        columns: [
                { "title": "GrupoTrabajo" , "data": "GrupoTrabajo" , "class": "text-center"},
                { "title": "UsuarioRegistra" , "data": "UsuarioRegistra" , "class": "text-center"},
                { "title": "categoria" , "data": "categoria" , "class": "text-center"},
                { "title": "horas_trabajadas" , "data": "horas_trabajadas" , "class": "text-center"},
                { "title": "tardanza" , "data": "tardanza" , "class": "text-center"},
                { "title": "horas_extras" , "data": "horas_extras" , "class": "text-center"},
                { "title": "total_faltas" , "data": "total_faltas" , "class": "text-center"},
                { "title": "bono_desempeno" , "data": "bono_desempeno" , "class": "text-center"},
                { "title": "comision_total" , "data": "comision_total" , "class": "text-center"},
                { "title": "dias_trabajo_efectivo", "data": "dias_trabajo_efectivo", "class": "text-center" },
                { "title": "fechas_trabajo_efectivo", "data": "fechas_trabajo_efectivo", "class": "text-center" },
                { "title": "dias_teletrabajo", "data": "dias_teletrabajo", "class": "text-center" },
                { "title": "fechas_teletrabajo", "data": "fechas_teletrabajo", "class": "text-center" },
                { "title": "HHEE25", "data": "HHEE25", "class": "text-center" },
                { "title": "HHEE35", "data": "HHEE35", "class": "text-center" },
                { "title": "HHEE_dominical_100", "data": "HHEE_dominical_100", "class": "text-center" },
                { "title": "HHEE_feriado", "data": "HHEE_feriado", "class": "text-center" },
                // { "title": "HHEE_1ro_de_mayo", "data": "HHEE_1ro_de_mayo", "class": "text-center" },
                { "title": "HHEE_nocturnas", "data": "HHEE_nocturnas", "class": "text-center" },
                { "title": "bono_productividad", "data": "bono_productividad", "class": "text-center" },
                { "title": "otros_bonos", "data": "otros_bonos", "class": "text-center" },
                { "title": "bono_de_carrera", "data": "bono_de_carrera", "class": "text-center" },
                { "title": "bonificacion_por_desempeno", "data": "bonificacion_por_desempeno", "class": "text-center" },
                { "title": "bono_responsabilidad", "data": "bono_responsabilidad", "class": "text-center" },
                { "title": "bono_inicio", "data": "bono_inicio", "class": "text-center" },
                { "title": "bono_veritombola", "data": "bono_veritombola", "class": "text-center" },
                { "title": "comisiones_upselling", "data": "comisiones_upselling", "class": "text-center" },
                { "title": "reintegro_afecto", "data": "reintegro_afecto", "class": "text-center" },
                { "title": "gift_card", "data": "gift_card", "class": "text-center" },
                { "title": "gift_card_upselling", "data": "gift_card_upselling", "class": "text-center" },
                { "title": "obsequios_upselling", "data": "obsequios_upselling", "class": "text-center" },
                { "title": "obsequios_al_personal", "data": "obsequios_al_personal", "class": "text-center" },
                { "title": "descuento_por_equipo_celular", "data": "descuento_por_equipo_celular", "class": "text-center" },
                { "title": "descuento_uniforme_materiales", "data": "descuento_uniforme_materiales", "class": "text-center" },
                { "title": "descuento_por_demos", "data": "descuento_por_demos", "class": "text-center" }
                            ],
        lengthMenu: [[10, 25, 50], [10, 25, 50]],
        order: [[0, 'asc']],
        language: {
            emptyTable: "No hay datos disponibles",
            loadingRecords: "Cargando...",
            processing: "Procesando...",
            search: "Buscar:",
            lengthMenu: "Mostrar _MENU_ registros",
            zeroRecords: "No se encontraron registros",
            info: "Mostrando _START_ a _END_ de _TOTAL_ registros",
            infoEmpty: "Mostrando 0 a 0 de 0 registros",
            infoFiltered: "(filtrado de _MAX_ registros totales)",
        },
    });
}

// Función para limpiar la tabla si no hay reporte seleccionado
function limpiarTablaReporte() {
    const tableId = '#reportePreviewTable';
    if ($.fn.DataTable.isDataTable(tableId)) {
        $(tableId).DataTable().clear().draw();
    }
}


    
/* ------------------------------- */
/***********************************************/

    // let isDataTableInitialized = false; // Bandera para verificar si el DataTable ya está inicializado

    // $('#reporte-novedades').on('click', function () {
    //     // Si el DataTable ya está inicializado, no volver a inicializarlo
    //     if (isDataTableInitialized) {
    //         return;
    //     }

    //     // Inicializar el DataTable
    //     $('#tblMetricaNovedades2').DataTable({
    //         "serverSide": true,
    //         "processing": true,
    //         "ajax": {
    //             "url": baseUrl + "/reporte-novedades-data-table",
    //             "type": 'GET',
    //             "dataSrc": function (json) {
    //                 console.log(json); // Depuración: verifica la estructura de la respuesta
    //                 return json.data || [];
    //             },
    //             "error": function (xhr, error, thrown) {
    //                 console.error("Error en el servidor:", xhr.responseText);
    //             }
    //         },
    //         "columns": [
    //         { "title": "idUsuario" , "data": "idUsuario" , "class": "text-center"},
    //         { "title": "Nombres" , "data": "Nombres" , "class": "text-center"},
    //         { "title": "Apellidos" , "data": "Apellidos" , "class": "text-center"},
    //         { "title": "categoria" , "data": "categoria" , "class": "text-center"},
    //         { "title": "horas_trabajadas" , "data": "horas_trabajadas" , "class": "text-center"},
    //         { "title": "tardanza" , "data": "tardanza" , "class": "text-center"},
    //         { "title": "horas_extras" , "data": "horas_extras" , "class": "text-center"},
    //         { "title": "total_faltas" , "data": "total_faltas" , "class": "text-center"},
    //         { "title": "bono_desempeno" , "data": "bono_desempeno" , "class": "text-center"},
    //         { "title": "comision_total" , "data": "comision_total" , "class": "text-center"},
    //         { "title": "dias_trabajo_efectivo", "data": "dias_trabajo_efectivo", "class": "text-center" },
    //         { "title": "fechas_trabajo_efectivo", "data": "fechas_trabajo_efectivo", "class": "text-center" },
    //         { "title": "dias_teletrabajo", "data": "dias_teletrabajo", "class": "text-center" },
    //         { "title": "fechas_teletrabajo", "data": "fechas_teletrabajo", "class": "text-center" },
    //         { "title": "HHEE25", "data": "HHEE25", "class": "text-center" },
    //         { "title": "HHEE35", "data": "HHEE35", "class": "text-center" },
    //         { "title": "HHEE_dominical_100", "data": "HHEE_dominical_100", "class": "text-center" },
    //         { "title": "HHEE_feriado", "data": "HHEE_feriado", "class": "text-center" },
    //         // { "title": "HHEE_1ro_de_mayo", "data": "HHEE_1ro_de_mayo", "class": "text-center" },
    //         { "title": "HHEE_nocturnas", "data": "HHEE_nocturnas", "class": "text-center" },
    //         { "title": "bono_productividad", "data": "bono_productividad", "class": "text-center" },
    //         { "title": "otros_bonos", "data": "otros_bonos", "class": "text-center" },
    //         { "title": "bono_de_carrera", "data": "bono_de_carrera", "class": "text-center" },
    //         { "title": "bonificacion_por_desempeno", "data": "bonificacion_por_desempeno", "class": "text-center" },
    //         { "title": "bono_responsabilidad", "data": "bono_responsabilidad", "class": "text-center" },
    //         { "title": "bono_inicio", "data": "bono_inicio", "class": "text-center" },
    //         { "title": "bono_veritombola", "data": "bono_veritombola", "class": "text-center" },
    //         { "title": "comisiones_upselling", "data": "comisiones_upselling", "class": "text-center" },
    //         { "title": "reintegro_afecto", "data": "reintegro_afecto", "class": "text-center" },
    //         { "title": "gift_card", "data": "gift_card", "class": "text-center" },
    //         { "title": "gift_card_upselling", "data": "gift_card_upselling", "class": "text-center" },
    //         { "title": "obsequios_upselling", "data": "obsequios_upselling", "class": "text-center" },
    //         { "title": "obsequios_al_personal", "data": "obsequios_al_personal", "class": "text-center" },
    //         { "title": "descuento_por_equipo_celular", "data": "descuento_por_equipo_celular", "class": "text-center" },
    //         { "title": "descuento_uniforme_materiales", "data": "descuento_uniforme_materiales", "class": "text-center" },
    //         { "title": "descuento_por_demos", "data": "descuento_por_demos", "class": "text-center" }
    //     ],

    //         "lengthMenu": [[10, 25, 50], [10, 25, 50]],
    //         "aaSorting": [[1, 'asc']]
    //     });


    //     // Marcar el DataTable como inicializado
    //     isDataTableInitialized = true;
    // });
    
    // $(document).on('click', '#guardar-reporte-novedades', function(e) { 
    //     e.preventDefault();
    // 		var usuarioSession = <?= json_encode($idUsuarioSession); ?>;
    		
    //         $.ajax({        
    //             url: baseUrl + '/grabar-reporte-novedades/'+ usuarioSession,
    //             type: "POST",
    //             success: function(response) {
    //                 $('.respuesta_global').html(response);
    //             }, 
    //             error: function(jqXHR, textStatus, errorThrown){
    //                 //$.unblockUI({});
    //                 Swal.close();
    //                 alert('Ha ocurrido un error interno.');
    //                 console.log(jqXHR );
    //                 console.log(textStatus);
    //                 console.log(errorThrown);
    //             }
    //         });
    // });
    
    
    $(document).on('click', '.nexttab', function () {
    const nextTab = $(this).data('nexttab');
    $(`#${nextTab}`).removeAttr('disabled').tab('show');
    });
    
    $(document).on('click', '.previestab', function () {
        const previousTab = $(this).data('previous');
        $(`#${previousTab}`).tab('show');
    });

        
});


</script>
<?php $this->endSection(); ?>	
	
<?php $this->endSection(); ?>