<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>

<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb_alias ?></h5>
                            <div class="d-flex">
								<?php
								// if(in_array("VERPLA", $permisos))
								// {
								?>
                                <!--<button class="btn btn-info mx-1 d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#importarCSVUsuarioFlota">-->
								<!--	<i class='mdi mdi-routes-clock align-bottom me-2 text-muted' style='font-size: 18px;'></i> Ver Planificación-->
								<!--</button>-->
								<button type="button" class="btn bg-warning d-flex align-items-center mx-1 color-white" id="btnMetricas">
    								<i class="mdi mdi-file-download" style="font-size: 14px;"></i> Exportar
    							</button>
                                <?php
								// }
								?>
							</div>
						</div>
					</div>
				</div>
			</div>
    			<!-- Start table -->
            <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title">Métricas de Desempeño</h4>
                                <div class="table-responsive">
                                    
                                    <table class="table table-bordered" id="tblMetricaNovedades">
                                        <thead class="justify-content-center text-center align-middle">
                                            <tr>
                                                <th>ID Usuario</th>
                                                <th class="text-center">Nombres</th>
                                                <th>Apellidos</th>
                                                <th>Categoría</th>
                                                <th>Meses en Empresa</th>
                                                <th>% Cumplimiento Procesos</th>
                                                <th>Bonificación Cumplimiento Procesos</th>
                                                <th>% Atención Cliente</th>
                                                <th>Bonificación Atención Cliente</th>
                                                <th>% TMO</th>
                                                <th>Bonificación TMO</th>
                                                <th>% Productividad</th>
                                                <th>Bonificación Productividad</th>
                                                <th>% WP</th>
                                                <th>Bonificación WP</th>
                                                <th>Desempeño Final</th>
                                                <th>Horas Trabajadas</th>
                                                <th>Tardanza</th>
                                                <th>Horas Extras</th>
                                                <th>Total Faltas</th>
                                                <th>Bono Desempeño</th>
                                                <th>Comisión Total</th>
                                            </tr>
                                        </thead>
                                        <tbody class="justify-content-center text-center align-middle">
                                            <?php foreach ($dataMetricas as $usuario): ?>
                                                <tr>
                                                    <td><?= $usuario['idUsuario']; ?></td>
                                                    <td><?= $usuario['Nombres']; ?></td>
                                                    <td><?= $usuario['Apellidos']; ?></td>
                                                    <td><?= $usuario['categoria']; ?></td>
                                                    <td><?= number_format($usuario['meses_en_empresa'], 2); ?></td>
                                                    <td><?= $usuario['cumplimiento_cumplimiento_procesos']; ?></td>
                                                    <td><?= $usuario['bonificacion_cumplimiento_procesos']; ?></td>
                                                    <td><?= $usuario['cumplimiento_atencion_cliente']; ?></td>
                                                    <td><?= $usuario['bonificacion_atencion_cliente']; ?></td>
                                                    <td><?= $usuario['cumplimiento_tmo']; ?></td>
                                                    <td><?= $usuario['bonificacion_tmo']; ?></td>
                                                    <td><?= $usuario['cumplimiento_productividad']; ?></td>
                                                    <td><?= $usuario['bonificacion_productividad']; ?></td>
                                                    <td><?= $usuario['cumplimiento_wp']; ?></td>
                                                    <td><?= $usuario['bonificacion_wp']; ?></td>
                                                    <td><?= $usuario['desempeno_final']; ?></td>
                                                    <td><?= $usuario['horas_trabajadas']; ?></td>
                                                    <td><?= $usuario['tardanza']; ?></td>
                                                    <td><?= $usuario['horas_extras']; ?></td>
                                                    <td><?= $usuario['total_faltas']; ?></td>
                                                    <td><?= $usuario['bono_desempeno']; ?></td>
                                                    <td><?= $usuario['comision_total']; ?></td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- End table -->
                
	    </div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	
	
<!-- Modal Importar Metricas Desempeño Usuarios -->
<div class="modal fade bd-example-modal-lg" id="importarCSVMetricasComplementarias" tabindex="-1" role="dialog" aria-labelledby="exampleimportarCSVMetricasComplementarias" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleimportarCSVMetricasComplementarias">Importar Desempeño </h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formulario" id="formimportarCSVMetricasComplementarias" autocomplete="off" action="<?= $baseUrl ?>/importar-csv-metricas-complementarias" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="row modal-body">
					<div class="col-12 mb-3">
						<h4>Consideraciones:</h4>
						<p>1.- Las fechas deben contar con el formato "YYYY-MM-DD".</p>
						<p>2.- Evitar espacios en blanco al inicio y al final del campo</p>
						<p>3.- Formato de las columnas [ATC, TMO, WP] son dos decimales y separado por "."</p>
						<p>4.- Formato de la columna [PROD] son valores enteros.</p>
					</div>

					<div class="col-6 mb-3 d-flex justify-content-end">
						
						<a class='btn btn-info border-0 texto-indicador' style="color: #FFF" href='<?= base_url().'/public/docs/Plantillas/plantilla csv metricas desempeno.csv' ?>' download='Plantilla CSV Metricas'>Descargar Plantilla</a>
						
					</div>
					<div class="mb-3">
						<label for="fileCSVDesempeno" class="form-label">Seleccione CSV:</label>
						<input class="form-control" type="file" id="fileCSVMetricasComplementarias" name="fileCSVMetricasComplementarias">
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" class="btn btn-success"><i class="mdi mdi-content-save"></i> Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>
	
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<?php $this->endSection(); ?>