<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
							<h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb ?></h5>
							<div>
								<button class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#anadirEstructura">
								<i class="mdi mdi-plus-circle"></i> Subir clientes
								</button>
								<a href="<?= $baseUrl ?>/reporte-heavyusers" class="btn btn-primary">
								<i class="mdi mdi-download"></i> Reporte
								</a>
							</div>
						</div>
						<div class="card-body">
							<table id="ajax-clientes" class="table table-bordered nowrap table-striped align-middle" style="width:100%">
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<!-- Modal cargar -->
<div class="modal fade" id="anadirEstructura" tabindex="-1" role="dialog" aria-labelledby="exampleanadirEstructura" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleanadirEstructura">Cargar Clientes</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formulario" action="<?= $baseUrl ?>/grabar-clientes" method="POST" enctype="multipart/form-data">
				<div class="modal-body">
					<p>Descarga <a href="<?= $baseUrl ?>/public/PRUEBASHU1.xlsx" target="_blank">aquí</a> el archivo</p>
					<span class="respuesta"></span>
					<div class="row">
						<div class="col-12 col-md-12 col-lg-12">
							<div>
								<label for="fotos" class="form-label">Coloca aquí el archivo con los clientes</label>
								<input class="form-control" type="file" id="estructura" name="estructura">
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="submit" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<!-- Modal Editar -->
<div class="modal fade" id="editarHeavyUser" tabindex="-1" role="dialog" aria-labelledby="exampleeditarHeavyUser" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleeditarHeavyUser">Actualizar info</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formulario" id="formulario-actualizar-gestion" action="<?= $baseUrl ?>/actualizar-gestion" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="gestionable" class="form-label">Gestionable</label>
							<select class="form-select" aria-label="Acción" id="gestionable" name="gestionable">
								<option selected="" value="">Seleccione una opción</option>
								<option value="Si">Si</option>
								<option value="No">No</option>
							</select>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="accion" class="form-label">Acción</label>
							<select class="form-select" aria-label="Acción" id="accion" name="accion">
								<option value="">Seleccione una opción</option>
								<?php foreach($listaAcciones as $items){ ?>
									<option value="<?= $items['id_accion'] ?>"><?= $items['accion'] ?></option>
								<?php } ?>
							</select>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="subaccion" class="form-label">Sub-Acción</label>
							<select class="form-select" aria-label="Acción" id="subaccion" name="subaccion">
								<option value="">Seleccione una opción</option>
							</select>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="estado" class="form-label">Estado</label>
							<select class="form-select" aria-label="estado" id="estado" name="estado">
								<option selected="" value="">Seleccione una opción</option>
								<option value="No Iniciado">No Iniciado</option>
								<option value="No Contactado">No Contactado</option>
								<option value="Stand By">Stand By</option>
								<option value="En Progreso">En Progreso</option>
								<option value="Ilocalizado">Ilocalizado</option>
								<option value="Inviable">Inviable</option>
								<option value="Completado">Completado</option>
								<option value="No aplica">No aplica</option>
							</select>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3" id="divMantenimiento">
							<label for="fecha_mantenimiento" class="form-label">Fecha de mantenimiento</label>
                            <input type="date" class="form-control" id="fecha_mantenimiento" name="fecha_mantenimiento" disabled>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="comentarios" class="form-label">Comentarios</label>
                            <textarea class="form-control" id="comentarios" name="comentarios"></textarea>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<!-- Modal historico -->
<div class="modal fade" id="verHistorico" tabindex="-1" aria-labelledby="scrollableModalTitle" style="display: none;" aria-hidden="true">
	<div class="modal-dialog modal-dialog-scrollable modal-xl modal-dialog-centered">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="scrollableModalTitle">Seguimiento de Gestiones</h5>
				<button id="cerrar-modal-planner" type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
				<div class="col-12 col-md-12 col-lg-12">
					<!-- Active Tables -->
					<table class="table table-nowrap mb-0">
						<thead>
							<tr>
								<th scope="col" class="align-middle text-center">Gestionable</th>
								<th scope="col" class="align-middle text-center">Acción</th>
								<th scope="col" class="align-middle text-center">Subacción</th>
								<th scope="col" class="align-middle text-center">Estado</th>
								<th scope="col" class="align-middle text-center">Fecha de acción</th>
							</tr>
						</thead>
						<tbody id="bodyRutas">
						</tbody>
					</table>
				</div>
			</div>
		</div>
		<!-- /.modal-content -->
	</div>
	<!-- /.modal-dialog -->
</div>
<?php $this->endSection(); ?>