<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<form id="formAgregarAccion" class="formulario" autocomplete="off" method="POST" action="<?= $baseUrl ?>/registrar-ubicacion-acceso/<?= $idDireccion ?>">
                        <span class="respuesta"></span>
                        <!-- Horizontal Form -->
                        <div class="card">
                            <div class="card-header d-flex align-items-center" style="background-color: #d2d6de;">
                                <h5 class="card-title mb-0 flex-grow-1" style=""><?= $breadcrumb_alias ?></h5>
                                <div>
                                    <a href="<?= $baseUrl.'/'.$previo ?>" class="btn px-2 py-0" style="border-radius: 45%; background-color: red;"><i class="mdi mdi-arrow-left-circle" style="font-size: 24px; color: #FFF"></i></a>
                                </div>
                            </div>
                            <!-- /.card-header -->
                            
                            <div class="card-body row">
                                <div class="col-4 m-0" style="border-right: 1px solid red;">
									<div class="col-xxl-12 col-md-12 col-12 mb-3">
										<label for="txtUbicacionAcceso" class="form-label">Ubicación</label>
										<div class="input-group">
											<input type="text" class="form-control" aria-label="Ubicación de Acceso" id="txtUbicacionAcceso" name="txtUbicacionAcceso">
										</div>
									</div>
									<div class="col-xxl-12 col-md-12 col-12 d-flex flex-row-reverse">
										<div>
											<?php
											if (in_array("ADUBAC", $permisos)) 
											{
											?>
											<button type="submit" class="btn btn-success">
												<i class="mdi mdi-content-save"></i> Guardar
											</button>
											<?php
											}
											?>
										</div>
									</div>
                                </div>
                                <div class="col-lg-8">
									<table id="tblUbicacionesAcceso" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
										<thead>
											<tr>
												<th class="text-center align-middle">Correlativo</th>
												<th class="text-center align-middle">Código</th>
												<th class="text-center align-middle">Estado</th>
											</tr>
										</thead>
										<tbody>
											<?php 
											foreach($listaUbicaciones as $items){ ?>
											<tr>
												<td class="text-center align-middle"><?= $items['IDUbicacionAcceso'] ?></td>
												<td class="text-center align-middle"><?= $items['Ubicacion'] ?></td>
												<td class="text-center align-middle">
													<?php
													if (in_array("ADUBAC", $permisos)) 
													{
													?>
													<button class="badge <?= $items['Estado'] == 'A' ? 'bg-success' : 'bg-warning' ?> border-0 cambiar-estado-ubicacion-acceso" data-estado="<?= $items['Estado'] ?>" data-id="<?= $items['IDUbicacionAcceso'] ?>">
														<?= $items['Estado'] == 'A' ? 'ACTIVO' : 'INACTIVO' ?>
													</button>
													<?php
													}
													else
													{
													?>
													<span class="badge <?= $items['Estado'] == 'A' ? 'bg-success' : 'bg-warning' ?> border-0">
														<?= $items['Estado'] == 'A' ? 'ACTIVO' : 'INACTIVO' ?>
													</span>
													<?php
													}
													?>
												</td>
											</tr>
											<?php } ?>
										</tbody>
									</table>
                                </div>
                            </div>
                            <!-- /.card-body -->
                        </div>
                    </form>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<?php $this->endSection(); ?>