<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb_alias ?></h5>
                            <div>
								<?php
								if (in_array("ADSUES", $permisos)) 
								{
								?>
                                <button class="btn btn-primary datos-subarea-estructura" data-bs-toggle="modal" data-bs-target="#informacionSubareaEstructura" data-id="0" data-accion="crear" id="crear-subarea-estructura">
									<i class="mdi mdi-plus-circle"></i> Agregar
								</button>
								<?php
								}
								?>
								<a href="<?= $baseUrl.'/'.$previo ?>" class="btn px-2 py-0" style="border-radius: 45%; background-color: red;"><i class="mdi mdi-arrow-left-circle" style="font-size: 24px; color: #FFF"></i></a>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblSubareasEstructura" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								<thead>
									<tr>
										<th class="text-center align-middle">Código</th>
										<th class="text-center align-middle">Subárea</th>
										<th class="text-center align-middle">Correo</th>
										<th class="text-center align-middle">Observación</th>
										<th class="text-center align-middle">Estado</th>
										<th class="text-center align-middle">Acciones</th>
									</tr>
								</thead>
								<tbody>
									<?php 
									foreach($listaSubareas as $items){ ?>
									<tr>
										<td class="text-center align-middle"><?= $items['IDSubarea'] ?></td>
										<td class="text-center align-middle"><?= $items['Subarea'] ?></td>
										<td class="text-center align-middle"><?= $items['Correo'] ?></td>
										<td class="text-center align-middle"><?= $items['Observacion'] ?></td>
										<td class="text-center align-middle">
										<?php
										if (in_array("ESSUES", $permisos)) 
										{
										?>
											<button class="badge <?= $items['Estado'] == "A" ? 'bg-success' : 'bg-warning' ?> border-0 cambiar-estado-subarea-estructura" data-estado="<?= $items['Estado'] ?>" data-id="<?=$items['IDSubarea'] ?>"><?= $items['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO' ?></button>
										<?php
										}
										else
										{
										?>
											<span class="badge <?= $items['Estado'] == "A" ? 'bg-success' : 'bg-warning' ?> border-0" ><?= $items['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO' ?></span>
										<?php
										}
										?>
										</td>
										<td class="text-center align-middle">
											<div class="dropdown d-inline-block">
												<button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
													<i class="ri-more-fill align-middle"></i>
												</button>
												<ul class="dropdown-menu dropdown-menu-end">
													<li>
														<a href="#!" class="dropdown-item datos-subarea-estructura" data-bs-toggle="modal" data-bs-target="#informacionSubareaEstructura" data-id="<?= $items['IDSubarea'] ?>" data-accion="ver" id="ver-subarea-estructura">
															<i class="ri-eye-fill align-bottom me-2 text-muted"></i> Ver
														</a>
													</li>
													<?php
													if (in_array("UPSUES", $permisos)) 
													{
													?>
													<li>
														<a href="#!" class="dropdown-item edit-item-btn datos-subarea-estructura" data-bs-toggle="modal" data-bs-target="#informacionSubareaEstructura" data-id="<?= $items['IDSubarea'] ?>" data-accion="editar" id="editar-subarea-estructura">
															<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Editar
														</a>
													</li>
													<?php
													}
													
													if (in_array("ASDESU", $permisos)) 
													{
													?>
													<li>
														<a href="<?= $baseUrl ?>/listar-delegaciones-subarea-estructura/<?= $items['IDSubarea'] ?>" class="dropdown-item">
															<i class="mdi mdi-domain align-bottom me-2 text-muted"></i> Delegaciones
														</a>
													</li>
													<?php
													}
													?>
												</ul>
											</div>
										</td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<!-- Modal Información Tipo Categoria -->
<div class="modal fade" id="informacionSubareaEstructura" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionSubareaEstructura" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleinformacionSubareaEstructura">Información del subárea</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionSubareaEstructura" class="formulario" autocomplete="off" action="" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDAreaEstructura_i" name="txtIDAreaEstructura_i" value="<?= $area['IDArea'] ?>">
					<input type="hidden" id="txtIDSubareaEstructura_i" name="txtIDSubareaEstructura_i">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtSubareaEstructura_i" class="form-label">Subárea</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Nombre Subárea" id="txtSubareaEstructura_i" name="txtSubareaEstructura_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtCorreoSubareaEstructura_i" class="form-label">Correo</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Correo Subárea" id="txtCorreoSubareaEstructura_i" name="txtCorreoSubareaEstructura_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtObservacionSubareaEstructura_i" class="form-label">Observación</label>
								<textarea class="form-control" id="txtObservacionSubareaEstructura_i" name="txtObservacionSubareaEstructura_i" rows="3"></textarea>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" id="btnEjecutarSubareaEstructura" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Actualizar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>