<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb ?></h5>
                            <div>
								<?php
								if (in_array("ADDARE", $permisos)) 
								{
								?>
                                <button class="btn btn-primary datos-area" data-bs-toggle="modal" data-bs-target="#informacionArea" data-id="0" data-accion="crear" id="crear-area">
									<i class="mdi mdi-plus-circle"></i> Añadir
								</button>
								<?php
								}
								?>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblAreas" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								<thead>
									<tr>
										<th class="text-center align-middle">Código</th>
										<th class="text-center align-middle">Área</th>
										<th class="text-center align-middle">LN</th>
										<th class="text-center align-middle">Departamento</th>
										<th class="text-center align-middle">Responsable</th>
										<th class="text-center align-middle">Estado</th>
										<th class="text-center align-middle">Acciones</th>
									</tr>
								</thead>
								<tbody>
									<?php
									foreach($listadoAreas as $items){ ?>
									<tr>
										<td class="text-center align-middle"><?= $items['IdArea'] ?></td>
										<td class="text-center align-middle"><?= $items['NombreArea'] ?></td>
										<td class="text-center align-middle"><?= $items['LN'] ?></td>
										<td class="text-center align-middle"><?= $items['NombreDpto'] ?></td>
										<td class="text-center align-middle"><?= $items['Nombres'].' '.$items['Apellidos'] ?></td>
										<td class="text-center align-middle">
											<?php
											if (in_array("ESTARE", $permisos)) 
											{
											?>
											<button class="badge <?= $items['Estado'] == 'A' ? 'bg-success' : 'bg-warning' ?> border-0 cambiar-estado-area" data-estado="<?= $items['Estado'] ?>" data-id="<?= $items['IdArea'] ?>">
												<?= $items['Estado'] == 'A' ? 'ACTIVO' : 'INACTIVO' ?>
											</button>
											<?php
											}
											else
											{
											?>
											<span class="badge <?= $items['Estado'] == 'A' ? 'bg-success' : 'bg-warning' ?> border-0">
												<?= $items['Estado'] == 'A' ? 'ACTIVO' : 'INACTIVO' ?>
											</span>
											<?php
											}
											?>
										</td>
										<td class="text-center align-middle">
											<div class="dropdown d-inline-block">
												<button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
												<i class="ri-more-fill align-middle"></i>
												</button>
												<ul class="dropdown-menu dropdown-menu-end">
													<li>
														<a href="#!" class="dropdown-item datos-area" data-bs-toggle="modal" data-bs-target="#informacionArea" data-id="<?= $items['IdArea'] ?>" data-accion="ver" id="ver-area">
															<i class="ri-eye-fill align-bottom me-2 text-muted"></i> Ver
														</a>
													</li>
													<?php
													if (in_array("UPDARE", $permisos)) 
													{
													?>
													<li>
														<a href="#!" class="dropdown-item edit-item-btn datos-area" data-bs-toggle="modal" data-bs-target="#informacionArea" data-id="<?= $items['IdArea'] ?>" data-accion="editar" id="editar-area">
															<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Editar
														</a>
													</li>
													<?php
													}
													?>
												</ul>
											</div>
										</td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<!-- Modal Información Area -->
<div class="modal fade" id="informacionArea" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionArea" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleinformacionArea">Información de Área</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionArea" class="formulario" autocomplete="off" action="" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDArea_i" name="txtIDArea_i">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtArea_i" class="form-label">Nombre</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Nombre Área" id="txtArea_i" name="txtArea_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtLN_i" class="form-label">LN</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Línea de Negocio" id="txtLN_i" name="txtLN_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtDptoArea_i" class="form-label">Departamento</label>
								<select class="form-select" aria-label="Marca" id="txtDptoArea_i" name="txtDptoArea_i">
									<option value="">Seleccione una opción</option>
									
								</select>
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtResponsableArea_i" class="form-label">Responsable</label>
								<select class="form-select" aria-label="Tipo" id="txtResponsableArea_i" name="txtResponsableArea_i">
									<option value="">Seleccione una opción</option>
									
								</select>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" id="btnEjecutarArea" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Actualizar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>