<?php
namespace App\Models;
use CodeIgniter\Model;

class ModuloModel extends Model
{
    protected $table      = 'modulos';
    protected $primaryKey = 'IDModulo';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDCabecera', 'Modulo', 'Orden', 'Icono', 'Observacion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listarModulos()
    {
        $this->select('modulos.IDModulo,
            modulos.IDCabecera,
            modulos.Modulo,
            modulos.Orden,
            modulos.Icono,
            modulos.Observacion,
            modulos.Estado,
            modulos_cabecera.Cabecera,
            modulos_rutas.Ruta');
        $this->join('modulos_cabecera', 'modulos.IDCabecera = modulos_cabecera.IDCabecera', 'left');
        $this->join('modulos_rutas', 'modulos.IDModulo = modulos_rutas.IDModulo AND modulos_rutas.RaizModulo = "Y"', 'left');
        
        $datos = $this->findAll();
        return $datos;
    }
}