<?php
namespace App\Models;
use CodeIgniter\Model;

class GruposTrabajoModel extends Model
{
    protected $table      = 'grupostrabajo';
    protected $primaryKey = 'IDGrupoTrabajo';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['GrupoTrabajo', 'Observacion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado', 'JefeGrupoTrabajo','IdSubarea', 'multi_horario'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function obtenerGrupoTrabajo($idGrupoTrabajo)
    {
        $this->select('grupostrabajo.*,
            estructura_subarea.IDArea,
            estructura_area.IDDireccion');
        $this->join('estructura_subarea', 'grupostrabajo.IdSubarea = estructura_subarea.IDSubarea', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->where('grupostrabajo.IDGrupoTrabajo', $idGrupoTrabajo);
        $datos = $this->first();
        return $datos;
    }
    
    public function listaMetricasComplementariasServerSide($get, $adicionales, $grupoTrabajoIds, $tipofuncion)
    {
        
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
        // $this->globales = new Globales();
        $fields = array(
            0 => 'tblusuario.idUsuario',                  // ID Usuario
            1 => 'tblusuario.Nombres',                    // Nombres
            2 => 'tblusuario.Apellidos',                  // Apellidos
            3 => 'md.categoria',                          // Categoría
            4 => 'horas_trabajadas',                      // Horas Trabajadas
            5 => 'tardanza',                              // Tardanza
            6 => 'horas_extras',                          // Horas Extras
            7 => 'total_faltas',                          // Total Faltas
            8 => 'bono_desempeno',                        // Bono Desempeño
            9 => 'comision_total',                        // Comisión Total
        );

        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $this->select('
            grupostrabajo.GrupoTrabajo,
            tblusuario.idUsuario, 
            tblusuario.Nombres, 
            tblusuario.Apellidos, 
            DATEDIFF(CURDATE(), tblusuario.FechaIngreso) / 30 AS meses_en_empresa,
            temp_metricas_complementarias.dias_trabajo_efectivo,
            temp_metricas_complementarias.fechas_trabajo_efectivo,
            temp_metricas_complementarias.dias_teletrabajo,
            temp_metricas_complementarias.fechas_teletrabajo,
            temp_metricas_complementarias.HHEE25,
            temp_metricas_complementarias.HHEE35,
            temp_metricas_complementarias.HHEE_dominical_100,
            temp_metricas_complementarias.HHEE_feriado,
            temp_metricas_complementarias.HHEE_1ro_de_mayo,
            temp_metricas_complementarias.HHEE_nocturnas,
            temp_metricas_complementarias.bono_productividad,
            temp_metricas_complementarias.otros_bonos,
            temp_metricas_complementarias.bono_de_carrera,
            temp_metricas_complementarias.bonificacion_por_desempeno,
            temp_metricas_complementarias.bono_responsabilidad,
            temp_metricas_complementarias.bono_inicio,
            temp_metricas_complementarias.bono_veritombola,
            temp_metricas_complementarias.comisiones_upselling,
            temp_metricas_complementarias.reintegro_afecto,
            temp_metricas_complementarias.gift_card,
            temp_metricas_complementarias.gift_card_upselling,
            temp_metricas_complementarias.obsequios_upselling,
            temp_metricas_complementarias.obsequios_al_personal,
            temp_metricas_complementarias.descuento_por_equipo_celular,
            temp_metricas_complementarias.descuento_uniforme_materiales,
            temp_metricas_complementarias.descuento_por_demos,
            temp_metricas_complementarias.descuento_eps,
            temp_metricas_complementarias.descuento_alarma_verisure,
            temp_metricas_complementarias.descuento_seguro_rimac,
            temp_metricas_complementarias.observaciones,
            temp_metricas_complementarias.fecha_creacion
        ');
        $this->join('usuario_grupostrabajo ug', 'grupostrabajo.IDGrupoTrabajo = ug.IDGrupoTrabajo', 'left');
        $this->join('tblusuario', 'ug.IdUsuario = tblusuario.IdUsuario', 'left');
        $this->join('temp_metricas_complementarias', 'tblusuario.Matricula = temp_metricas_complementarias.matricula', 'left');
        $this->join('tbl_metricas_desempeno md', 'tblusuario.idUsuario = md.idUsuario', 'left');
        // LEFT JOIN con `temp_metricas_complementarias`
        // $this->join('grupostrabajo gt', 'ug.IDGrupoTrabajo = gt.IDGrupoTrabajo', 'left');
        // $this->groupBy('tblusuario.idUsuario');
        $this->whereIn('ug.IDGrupoTrabajo', $grupoTrabajoIds);
        // $this->where($adicionales);
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        if($tipofuncion == 'dataTable'){
            if (isset($get['search']) &&  $get['search']['value'] != "") 
            {
                $this->groupStart(); // Inicia un grupo de condiciones
                foreach ($get['columns'] as $k => $column) 
                {
                    if(array_key_exists($k, $fields))
                    {
                        $this->orLike($fields[$k], $get['search']['value']);
                    }
                }
                $this->groupEnd(); // Finaliza el grupo de condiciones
            }
            
            /*
            * ----------------------------
            * ORDENAMIENTO DE QUERY
            * ----------------------------
            */
            if (isset($get['order'])) {
                foreach ($get['order'] as $order) {
                    if(array_key_exists($order['column'], $fields))
                    {
                        $this->orderBy($fields[$order['column']], $order['dir']);
                    }
                }
            }
            /*
            * ----------------------------
            * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
            * ----------------------------
            */
            if (!empty($get['length']) && $get['length'] != -1) {
                $this->limit($get['length'], $get['start']);
            }

        }    
        /*
        * ----------------------------
        * EJECUTAR CONSULTA Y DEVOLVER VALORES
        * ----------------------------
        */
        $result = $this->get()->getResultArray(); 
        
        // Retornar datos y totales
        return   $result;  
    }
    
    // public function getFilteredRecords($adicionales, $grupoTrabajoIds, $searchValue, $fields)
    // {
    //     $this->select('id');
    //     $this->join('usuario_grupostrabajo ug', 'grupostrabajo.IDGrupoTrabajo = ug.IDGrupoTrabajo', 'left');
    //     $this->whereIn('ug.IDGrupoTrabajo', $grupoTrabajoIds);
    //     $this->where($adicionales);
    
    //     if (!empty($searchValue)) {
    //         $this->groupStart();
    //         foreach ($fields as $field) {
    //             $this->orLike($field, $searchValue);
    //         }
    //         $this->groupEnd();
    //     }
    
    //     return $this->countAllResults();
    // }

}