<?php
namespace App\Models;
use CodeIgniter\Model;

class DireccionModel extends Model
{
    protected $table      = 'direccion';
    protected $primaryKey = 'id_direccion';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['Direccion', 'id_distrito', 'fechahorareg', 'fija', 'eliminacion_logica', 'codigoSunat'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;


    public function obtenerDireccion($idDireccion)
    {
        $this->select('
            direccion.id_direccion,
            direccion.Direccion,
            direccion.codigoSunat,
            direccion.eliminacion_logica,
            distrito_ini.id_distrito,
            distrito_ini.desc_ubigeo_inei,
            prov_inei.id_prov_inei,
            prov_inei.desc_prov_inei,
            dep_inei.id_dep_inei,
            dep_inei.desc_dep_inei');
        $this->join('distrito_ini', 'direccion.id_distrito = distrito_ini.id_distrito', 'left');
        $this->join('prov_inei', 'distrito_ini.id_prov_inei = prov_inei.id_prov_inei', 'left');
        $this->join('dep_inei', 'prov_inei.id_dep_inei = dep_inei.id_dep_inei', 'left');
        $this->where("direccion.id_direccion", $idDireccion);
        $datos = $this->first();
        return $datos;
    }
    
    public function listadoDireccion()
    {
        $this->select('
            direccion.id_direccion,
            direccion.Direccion,
            direccion.codigoSunat,
            direccion.eliminacion_logica,
            distrito_ini.desc_ubigeo_inei,
            prov_inei.desc_prov_inei,
            dep_inei.desc_dep_inei');
        $this->join('distrito_ini', 'direccion.id_distrito = distrito_ini.id_distrito', 'left');
        $this->join('prov_inei', 'distrito_ini.id_prov_inei = prov_inei.id_prov_inei', 'left');
        $this->join('dep_inei', 'prov_inei.id_dep_inei = dep_inei.id_dep_inei', 'left');
        $datos = $this->findAll();
        return $datos;
    }
    
    public function listadoDireccionSelect($variable)
    {
        $this->select('
            direccion.id_direccion,
            direccion.Direccion,
            distrito_ini.desc_ubigeo_inei,
            prov_inei.desc_prov_inei,
            dep_inei.desc_dep_inei');
        $this->join('distrito_ini', 'direccion.id_distrito = distrito_ini.id_distrito', 'left');
        $this->join('prov_inei', 'distrito_ini.id_prov_inei = prov_inei.id_prov_inei', 'left');
        $this->join('dep_inei', 'prov_inei.id_dep_inei = dep_inei.id_dep_inei', 'left');
        $this->like("direccion.Direccion", $variable);
        $this->orLike("distrito_ini.desc_ubigeo_inei", $variable);
        $this->orLike("prov_inei.desc_prov_inei", $variable);
        $this->orLike("dep_inei.desc_dep_inei", $variable);
        
        $datos = $this->findAll();
        return $datos;
    }
}