<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Globales;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

require 'vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;
class Veriactivos extends BaseController
{
    protected $permisos;

	public function __construct()
    {
        //bm_tabla: (base master)_(nombre tabla)
		$this->bm_departamento = new \App\Models\DepartamentoCCModel();
        $this->bm_area = new \App\Models\AreaCCModel();
        
        $this->auditoria = new \App\Models\AuditoriaModel();
        
        $this->usuarios = new \App\Models\UsuarioModelo();
        $this->moviles = new \App\Models\VAMovilesModel();
        $this->lineas = new \App\Models\VALineasModel();
        $this->contratos = new \App\Models\VALineasContratoModel();
        $this->seguros = new \App\Models\VALineasSeguroModel();
        $this->segurosMovil = new \App\Models\VALineasSeguroMovilesModel();
        $this->marcas = new \App\Models\VAMarcasModel();
        $this->dispositivos = new \App\Models\VAMarcasDispositivosModel();
        $this->categorias = new \App\Models\CategoriaModel();
        $this->tipos = new \App\Models\TipoModel();
        $this->subtipos = new \App\Models\SubTipoModel();
        $this->operadores = new \App\Models\VAOperadoresModel();
        $this->planes = new \App\Models\VAOperadoresPlanesModel();
        $this->asignaciones = new \App\Models\VAAsignacionesModel();
        $this->detalleasignaciones = new \App\Models\VAAsignacionesDetalleModel();
        $this->asignacionesAdjuntos = new \App\Models\VAAsignacionesAdjuntosModel();
        $this->reposiciones = new \App\Models\VAReposicionesModel();
        $this->reposicionesDetalle = new \App\Models\VAReposicionesDetalleModel();
        $this->reposicionesAdjuntos = new \App\Models\VAReposicionesAdjuntosModel();
        $this->reposicionesCronogramaPago = new \App\Models\VAReposicionesCronogramaPagoModel();
        $this->devoluciones = new \App\Models\VADevolucionesModel();
        $this->devolucionesDetalle = new \App\Models\VADevolucionesDetalleModel();
        $this->devolucionesAdjuntos = new \App\Models\VADevolucionesAdjuntosModel();

        $this->correoStatusAsignacion = new \App\Models\CorreoStatusAsignacionModel();
        $this->correoStatusDevolucion = new \App\Models\CorreoStatusDevolucionModel();
        $this->correoStatusReposicion = new \App\Models\CorreoStatusReposicionModel();
	}

	public function obtenerEstadosMovil(){
    	/*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        $listadoEstados = $this->globales->estadosMovil();
        
        $estados=array();

		if (!empty($listadoEstados)) {
            foreach ($listadoEstados as $key=>$value) {
                $estados[] = array(
					'id' => (string) $key,
         	        'estado' => (string) $value,
                );
            }

            $resultado = array(
				'listadoEstados' => json_encode($estados)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}

	public function obtenerMotivoEstadoMovil(){
    	/*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        
		$estado = $this->request->getPost('estado');
        $listadoMotivos = $this->globales->motivoEstadoMovil($estado);

        $motivos=array();

		if (!empty($listadoMotivos)) {
            foreach ($listadoMotivos as $key=>$value) {
                $motivos[] = array(
					'id' => (string) $key,
         	        'motivo' => (string) $value
                );
            }

            $resultado = array(
				'listadoMotivos' => json_encode($motivos)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}

	public function obtenerEstadosLinea(){
    	/*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        $listadoEstados = $this->globales->estadosLinea();
        
        $estados=array();

		if (!empty($listadoEstados)) {
            foreach ($listadoEstados as $key=>$value) {
                $estados[] = array(
					'id' => (string) $key,
         	        'estado' => (string) $value,
                );
            }

            $resultado = array(
				'listadoEstados' => json_encode($estados)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}

	public function obtenerMotivoEstadoLinea(){
    	/*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        
		$estado = $this->request->getPost('estado');
        $listadoMotivos = $this->globales->motivoEstadoLinea($estado);

        $motivos=array();

		if (!empty($listadoMotivos)) {
            foreach ($listadoMotivos as $key=>$value) {
                $motivos[] = array(
					'id' => (string) $key,
         	        'motivo' => (string) $value
                );
            }

            $resultado = array(
				'listadoMotivos' => json_encode($motivos)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}

	public function obtenerCategorias(){
    	/*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        $listadoCategorias = $this->categorias->findAll();
        
        $categorias=array();

		if (!empty($listadoCategorias)) {
            foreach ($listadoCategorias as $items) {
                $categorias[] = array(
					'id' => (string) $items['id_categoria'],
         	        'categoria' => (string) $items['nombre_categoria'],
                );
            }

            $resultado = array(
				'listadoCategorias' => json_encode($categorias)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}

	public function obtenerTipos(){
    	/*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        
		$idCategoria = $this->request->getPost('idCategoria');

        if($idCategoria == 'TOTAL')
        {
            $listadoTipos = $this->tipos->findAll();
        }
        else
        {
            $whereTipos = array('id_categoria' => $idCategoria);
            $listadoTipos = $this->tipos->where($whereTipos)->findAll();
        }
        
        $tipos=array();

		if (!empty($listadoTipos)) {
            foreach ($listadoTipos as $items) {
                $tipos[] = array(
					'id' => (string) $items['id_tipo'],
         	        'tipo' => (string) $items['nombre_tipo'],
                );
            }

            $resultado = array(
				'listadoTipos' => json_encode($tipos)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}

	public function obtenerSubtipos(){
    	/*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        
		$idTipo = $this->request->getPost('idTipo');

        if($idTipo == 'TOTAL')
        {
            $listadoSubtipos = $this->subtipos->findAll();
        }
        else
        {
            $whereSubTipos = array('id_tipo' => $idTipo);
            $listadoSubtipos = $this->subtipos->where($whereSubTipos)->findAll();
        }
        
        $subtipos=array();

		if (!empty($listadoSubtipos)) {
            foreach ($listadoSubtipos as $items) {
                $subtipos[] = array(
					'id' => (string) $items['id_subtipo'],
         	        'subtipo' => (string) $items['nombre_subtipo'],
                );
            }

            $resultado = array(
				'listadoSubtipos' => json_encode($subtipos)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}

	public function obtenerMarcas(){
    	/*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        $listadoMarcas = $this->marcas->where("Estado", "A")->findAll();
        
        $marcas=array();

		if (!empty($listadoMarcas)) {
            foreach ($listadoMarcas as $items) {
                $marcas[] = array(
					'id' => (string) $items['IDMarca'],
         	        'marca' => (string) $items['Marca'],
                );
            }

            $resultado = array(
				'listadoMarcas' => json_encode($marcas)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}

	public function obtenerDispositivos(){
    	/*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        
		$idMarca = $this->request->getPost('idMarca');

        if($idMarca == 'TOTAL')
        {
            $listadoDispositivos = $this->dispositivos->where("Estado", "A")->findAll();
        }
        else
        {
            $whereDispositivos = array('IDMarca' => $idMarca, "Estado" => "A");
            $listadoDispositivos = $this->dispositivos->where($whereDispositivos)->findAll();
        }
        
        $dispositivos=array();

		if (!empty($listadoDispositivos)) {
            foreach ($listadoDispositivos as $items) {
                $dispositivos[] = array(
					'id' => (string) $items['IDDispositivo'],
         	        'dispositivo' => (string) $items['Modelo'],
                );
            }

            $resultado = array(
				'listadoDispositivos' => json_encode($dispositivos)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}

	public function obtenerOperadores(){
    	/*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        $listadoOperadores = $this->operadores->where("Estado", "A")->findAll();
        
        $operadores=array();

		if (!empty($listadoOperadores)) {
            foreach ($listadoOperadores as $items) {
                $operadores[] = array(
					'id' => (string) $items['IDOperador'],
         	        'operador' => (string) $items['Operador'],
                );
            }

            $resultado = array(
				'listadoOperadores' => json_encode($operadores)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}

	public function obtenerPlanes(){
    	/*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
		$idOperador = $this->request->getPost('idOperador');

        if($idOperador == 'TOTAL')
        {
            $listadoPlanes = $this->planes->where("Estado", "A")->findAll();
        }
        else
        {
            $wherePlanes = array('IDOperador' => $idOperador, "Estado" => "A");
            $listadoPlanes = $this->planes->where($wherePlanes)->findAll();
        }
        
        $planes=array();

		if (!empty($listadoPlanes)) {
            foreach ($listadoPlanes as $items) {
                $planes[] = array(
					'id' => (string) $items['IDPlan'],
         	        'plan' => (string) $items['Plan'],
                );
            }

            $resultado = array(
				'listadoPlanes' => json_encode($planes)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}

	public function listarMarcas(){
		if(isset($this->items['id'])){

			/* ACCIONES */
			$listaMarcas = $this->marcas
							->findAll();

			$data = array (
				'session'           => 'on',
				'titulo'            => 'Marcas | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Marcas',
				'listaMarcas'       => $listaMarcas
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/marcas/listar_marcas',$data);			
		} else {
			return view('errors/500');
		}
	}
	
    public function insertarMarca(){

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $marca = ucfirst(mb_strtolower($this->request->getPost('txtMarca_i')));

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($marca, 'required|trim|alpha|minlength[1]|maxlength[50]', 'Marca');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$marcaExistente = $this->marcas->where('Marca', $marca)->findAll();

        if(count($marcaExistente)>0)
        {
            $msgExistencia .= "<li>La marca ya fue registrado. [CAMPO] <small>MARCA</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }


        $data = array (
            'Marca'         => $marca, 
            'FechaEstado'   => $fechaActual,
            'UsuarioEstado' => $this->items['id'],
            'Estado'        => 'A',
            'MotivoCambio'  => "Registro de marca.",  
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $lastId = $this->marcas->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $marca);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }  

	public function obtenerDatosMarca() {

		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idMarca = $this->request->getPost('idMarca');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idMarca, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosMarca = $this->marcas->where('IDMarca', $idMarca)->first();

		if(!empty($datosMarca)){
			$resultado = array(
				'idmarca' => (string) $idMarca,
				'marca' => (string) $datosMarca['Marca']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}

    public function modificarMarca($idMarca){

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $marca = ucfirst(mb_strtolower($this->request->getPost('txtMarca_i')));

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($marca, 'required|trim|alpha|minlength[1]|maxlength[50]', 'Marca');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'Marca'             => $marca,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );
        $lastId = $this->marcas->update([$idMarca], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idMarca);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

    public function modificarEstadoMarca(){

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idMarca = $this->request->getPost('idMarca');
        $motivo = $this->request->getPost('motivo');
        $estado = $this->request->getPost('estado');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idMarca, 'required|trim|numeric', 'ID Marca');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'FechaEstado'       => $fechaActual,
            'UsuarioEstado'     => $this->items['id'],
            'Estado'            => $estado,
            'MotivoCambio'      => $motivo,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );
        $lastId = $this->marcas->update([$idMarca], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idMarca);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	public function listarDispositivos($idMarca){
		if(isset($this->items['id'])){

			/* ACCIONES */
            $marca = $this->marcas->where("IDMarca", $idMarca)->first();
			$listaDispositivos = $this->dispositivos->listadoDispositivosXMarca($idMarca);

			$data = array (
				'session'           => 'on',
				'titulo'            => 'Dispositivos | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Dispositivos | '.$marca['Marca'],
                'previo'            => 'listar-marcas',
                'idMarca'           => $idMarca,
				'listaDispositivos' => $listaDispositivos
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/marcas/listar_dispositivos',$data);			
		} else {
			return view('errors/500');
		}
	}
    
	public function obtenerDatosDispositivos() {

		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idDispositivo = $this->request->getPost('idDispositivo');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idDispositivo, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosDispositivos = $this->dispositivos->obtenerDispositivo($idDispositivo);

		if(!empty($datosDispositivos)){
			$resultado = array(
				'iddispositivo' => (string) $idDispositivo,
				'modelo' => (string) $datosDispositivos['Modelo'],
				'idcategoria' => (string) $datosDispositivos['id_categoria'],
				'idtipo' => (string) $datosDispositivos['id_tipo'],
				'idsubtipo' => (string) $datosDispositivos['Subtipo']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}

    public function insertarDispositivo(){

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idMarca = $this->request->getPost('txtIDMarca_i');
        $modelo = $this->request->getPost('txtModelo_i');
        $subtipo = $this->request->getPost('txtSubtipo_i');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idMarca, 'required|trim|numeric', 'ID Marca');
        $error .= $this->complementos->validaCampo($modelo, 'required|trim|minlength[1]|maxlength[30]', 'Modelo');
        $error .= $this->complementos->validaCampo($subtipo, 'required|trim|numeric', 'Subtipo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        $whereModeloExistencia = array('Modelo' => $modelo, 'IDMarca' =>$idMarca);
		$modeloExistente = $this->dispositivos->where($whereModeloExistencia)->findAll();
        
        if(count($modeloExistente)>0)
        {
            $msgExistencia .= "<li>El modelo ya fue registrado en la marca. [CAMPO] <small>MODELO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        $data = array (
            'IDMarca'       => $idMarca, 
            'Modelo'        => $modelo, 
            'Subtipo'       => $subtipo, 
            'FechaEstado'   => $fechaActual,
            'UsuarioEstado' => $this->items['id'],
            'Estado'        => 'A',
            'MotivoCambio'  => "Registro de dispositivo.",  
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $lastId = $this->dispositivos->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $modelo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }  

    public function modificarDispositivo($idDispositivo){

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $modelo = $this->request->getPost('txtModelo_i');
        $subtipo = $this->request->getPost('txtSubtipo_i');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($modelo, 'required|trim|minlength[1]|maxlength[30]', 'Modelo');
        $error .= $this->complementos->validaCampo($subtipo, 'required|trim|numeric', 'Subtipo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'Modelo'            => $modelo,
            'Subtipo'           => $subtipo,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );
        $lastId = $this->dispositivos->update([$idDispositivo], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $modelo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

    public function modificarEstadoDispositivo(){

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idDispositivo = $this->request->getPost('idDispositivo');
        $motivo = $this->request->getPost('motivo');
        $estado = $this->request->getPost('estado');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idDispositivo, 'required|trim|numeric', 'ID Dispositivo');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'FechaEstado'       => $fechaActual,
            'UsuarioEstado'     => $this->items['id'],
            'Estado'            => $estado,
            'MotivoCambio'      => $motivo,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );
        $lastId = $this->dispositivos->update([$idDispositivo], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idDispositivo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
	public function listarOperadores(){
		if(isset($this->items['id'])){

			/* ACCIONES */
			$listaOperadores = $this->operadores
							->findAll();

			$data = array (
				'session'           => 'on',
				'titulo'            => 'Operadores | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Operadores',
				'listaOperadores'   => $listaOperadores
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/operadores/listar_operadores',$data);			
		} else {
			return view('errors/500');
		}
	}
	
    public function insertarOperador(){

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $operador = $this->request->getPost('txtOperador_i');
        $observacion = $this->request->getPost('txtObservacion_i');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($operador, 'required|trim', 'Operador');
        $error .= $this->complementos->validaCampo($observacion, 'trim', 'Observación');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$operadorExistente = $this->operadores->where('Operador', $operador)->findAll();
        
        if(count($operadorExistente)>0)
        {
            $msgExistencia .= "<li>El operador ya fue registrado. [CAMPO] <small>OPERADOR</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }


        $data = array (
            'Operador'      => $operador, 
            'Observacion'   => $observacion, 
            'FechaEstado'   => $fechaActual,
            'UsuarioEstado' => $this->items['id'],
            'Estado'        => 'A',
            'MotivoCambio'  => "Registro de operador.",  
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $lastId = $this->operadores->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $operador);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }  

	public function obtenerDatosOperador() {

		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idOperador = $this->request->getPost('idOperador');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idOperador, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosOperador = $this->operadores->where('IDOperador ', $idOperador)->first();

		if(!empty($datosOperador)){
			$resultado = array(
				'idoperador' => (string) $idOperador,
				'operador' => (string) $datosOperador['Operador'],
				'observacion' => (string) $datosOperador['Observacion']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}

    public function modificarOperador($idOperador){

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $operador = $this->request->getPost('txtOperador_i');
        $observacion = $this->request->getPost('txtObservacion_i');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($operador, 'required|trim', 'Operador');
        $error .= $this->complementos->validaCampo($observacion, 'trim', 'Observación');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'Operador'          => $operador,
            'Observacion'       => $observacion,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );
        $lastId = $this->operadores->update([$idOperador], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idOperador);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

    public function modificarEstadoOperador(){

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idOperador = $this->request->getPost('idOperador');
        $motivo = $this->request->getPost('motivo');
        $estado = $this->request->getPost('estado');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idOperador, 'required|trim|numeric', 'ID Operador');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'FechaEstado'       => $fechaActual,
            'UsuarioEstado'     => $this->items['id'],
            'Estado'            => $estado,
            'MotivoCambio'      => $motivo,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );
        $lastId = $this->operadores->update([$idOperador], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idOperador);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	public function listarPlanes($idOperador){
		if(isset($this->items['id'])){

			/* ACCIONES */
            $operador = $this->operadores->where("IDOperador", $idOperador)->first();
			$listaPlanes = $this->planes->where("IDOperador", $idOperador)->findAll();

			$data = array (
				'session'           => 'on',
				'titulo'            => 'Planes | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Planes - '.$operador['Operador'],
                'previo'            => 'listar-operadores',
                'idOperador'        => $idOperador,
				'listaPlanes'       => $listaPlanes
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/operadores/listar_planes',$data);			
		} else {
			return view('errors/500');
		}
	}
    
    public function insertarPlan(){

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idOperador = $this->request->getPost('txtIDOperador_i');
        $plan = $this->request->getPost('txtPlan_i');
        $planOperador = $this->request->getPost('txtPlanOperador_i');
        $precioplan = $this->request->getPost('txtPrecioPlan_i');
        $descuento = $this->request->getPost('txtPorcentDescuento_i');
        $preciofinal = $this->request->getPost('txtPrecioFinal_i');
        $capacidad = $this->request->getPost('txtCapacidadDescarga_i');
        $observacion = $this->request->getPost('txtObservacion_i');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idOperador, 'required|trim|numeric', 'ID Operador');
        $error .= $this->complementos->validaCampo($plan, 'required|trim|minlength[1]|maxlength[50]', 'Plan');
        $error .= $this->complementos->validaCampo($planOperador, 'required|trim|minlength[1]|maxlength[150]', 'Plan Operador');
        $error .= $this->complementos->validaCampo($precioplan, 'required|trim|decimal', 'Precio Plan');
        $error .= $this->complementos->validaCampo($descuento, 'required|trim|decimal', 'Descuento');
        $error .= $this->complementos->validaCampo($preciofinal, 'required|trim|decimal', 'Precio Final');
        $error .= $this->complementos->validaCampo($capacidad, 'required|trim', 'Capacidad');
        $error .= $this->complementos->validaCampo($observacion, 'trim', 'Observación');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        $wherePlanExistencia = array('Plan' => $plan, 'IDOperador' =>$idOperador);
		$planExistente = $this->planes->where($wherePlanExistencia)->findAll();
        
        if(count($planExistente)>0)
        {
            $msgExistencia .= "<li>El plan ya fue registrado en el operador. [CAMPO] <small>PLAN</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        $data = array (
            'IDOperador'            => $idOperador, 
            'Plan'                  => $plan, 
            'PlanOperador'          => $planOperador, 
            'PrecioPlan'            => $precioplan, 
            'PorcentajeDescuento'   => $descuento, 
            'PrecioFinal'           => $preciofinal, 
            'GBPlan'                => $capacidad, 
            'Observacion'           => $observacion, 
            'FechaEstado'           => $fechaActual,
            'UsuarioEstado'         => $this->items['id'],
            'Estado'                => 'A',
            'MotivoCambio'          => "Registro de plan.",  
            'UsuarioCrea'           => $this->items['id'],
            'FechaCrea'             => $fechaActual,    
            'Localhost'             => $this->request->getIPAddress()
        );

        $lastId = $this->planes->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $plan);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }  

	public function obtenerDatosPlan() {

		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idPlan = $this->request->getPost('idPlan');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idPlan, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosPlan = $this->planes->where("IDPlan", $idPlan)->first();

		if(!empty($datosPlan)){
			$resultado = array(
				'idplan' => (string) $idPlan,
				'plan' => (string) $datosPlan['Plan'],
				'planoperador' => (string) $datosPlan['PlanOperador'],
				'precioplan' => (string) $datosPlan['PrecioPlan'],
				'descuento' => (string) $datosPlan['PorcentajeDescuento'],
				'preciofinal' => (string) $datosPlan['PrecioFinal'],
				'capacidad' => (string) $datosPlan['GBPlan'],
				'observacion' => (string) $datosPlan['Observacion']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}

    public function modificarPlan($idPlan){

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $plan = $this->request->getPost('txtPlan_i');
        $planOperador = $this->request->getPost('txtPlanOperador_i');
        $precioplan = $this->request->getPost('txtPrecioPlan_i');
        $descuento = $this->request->getPost('txtPorcentDescuento_i');
        $preciofinal = $this->request->getPost('txtPrecioFinal_i');
        $capacidad = $this->request->getPost('txtCapacidadDescarga_i');
        $observacion = $this->request->getPost('txtObservacion_i');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($plan, 'required|trim|minlength[1]|maxlength[50]', 'Plan');
        $error .= $this->complementos->validaCampo($planOperador, 'required|trim|minlength[1]|maxlength[150]', 'Plan Operador');
        $error .= $this->complementos->validaCampo($precioplan, 'required|trim|decimal', 'Precio Plan');
        $error .= $this->complementos->validaCampo($descuento, 'required|trim|decimal', 'Descuento');
        $error .= $this->complementos->validaCampo($preciofinal, 'required|trim|decimal', 'Precio Final');
        $error .= $this->complementos->validaCampo($capacidad, 'required|trim', 'Capacidad');
        $error .= $this->complementos->validaCampo($observacion, 'required|trim', 'Observación');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'Plan'                  => $plan,
            'PlanOperador'          => $planOperador,
            'PrecioPlan'            => $precioplan,
            'PorcentajeDescuento'   => $descuento,
            'PrecioFinal'           => $preciofinal,
            'GBPlan'                => $capacidad,
            'Observacion'           => $observacion,
            'UsuarioModifica'       => $this->items['id'],
            'FechaModifica'         => $fechaActual,    
            'Localhost'             => $this->request->getIPAddress()
        );
        $lastId = $this->planes->update([$idPlan], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $plan);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

    public function modificarEstadoPlan(){

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idPlan = $this->request->getPost('idPlan');
        $motivo = $this->request->getPost('motivo');
        $estado = $this->request->getPost('estado');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idPlan, 'required|trim|numeric', 'ID Plan');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'FechaEstado'       => $fechaActual,
            'UsuarioEstado'     => $this->items['id'],
            'Estado'            => $estado,
            'MotivoCambio'      => $motivo,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );
        $lastId = $this->planes->update([$idPlan], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idPlan);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	public function listarMoviles(){
		if(isset($this->items['id'])){

			/* ACCIONES */
			$listaMoviles = $this->moviles->listadoMoviles('');

            foreach($listaMoviles as $key=>$value)
            {
                //Obtener Usuario Remitente
                $asignado = $this->usuarios->where("IdUsuario ", $value['UsuarioAsignado'])->first();
                //var_dump($asignado);
                if($asignado != null)
                {
                    $listaMoviles[$key]['NombreAsignado'] = strtoupper($asignado['Nombres'].' '.$asignado['Apellidos']);
                    $listaMoviles[$key]['UsuarioAsignado'] = $asignado['Usuario'] ;
                }
                else
                {
                    $listaMoviles[$key]['NombreAsignado'] = "--";
                    $listaMoviles[$key]['UsuarioAsignado'] = "--";
                }

                if($value['Estado']=='ACT')
                {
                    $bg = "bg-success";
                }
                else if($value['Estado']=='AVE')
                {
                    $bg = "bg-warning";
                }
                else if($value['Estado']=='REP')
                {
                    $bg = "bg-primary";
                }
                else if($value['Estado']=='BAJ')
                {
                    $bg = "bg-danger";
                }

                $listaMoviles[$key]['EstadoInformacion'] = "<span class='badge ".$bg." border-0'>".$this->globales->estadosMovil()[$value['Estado']]." | ".$this->globales->motivoEstadoMovil($value['Estado'])[$value['Situacion']]."</span>";
            }
                    
			$data = array (
				'session'           => 'on',
				'titulo'            => 'Moviles | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Móviles',
				'listaMoviles'      => $listaMoviles
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/moviles/listar_moviles',$data);			
		} else {
			return view('errors/500');
		}
	}
	
    public function insertarMovil(){

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $modelo = $this->request->getPost('txtModeloComercial_i');
        $proveedor = $this->request->getPost('txtProveedor_i');
        $imei = $this->request->getPost('txtIMEI_i');
        $fechaCompra = $this->request->getPost('txtFechaCompra_i');
        $precioCompra = $this->request->getPost('txtPrecioCompra_i');
        $precioLista = $this->request->getPost('txtPrecioLista_i');
        $estado = $this->request->getPost('txtEstadoMovil_i');
        $situacion = $this->request->getPost('txtMotivoMovil_i');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($modelo, 'required|trim', 'Modelo');
        $error .= $this->complementos->validaCampo($proveedor, 'required|trim|minlength[1]|maxlength[50]', 'Proveedor');
        $error .= $this->complementos->validaCampo($imei, 'required|trim|numeric|minlength[15]|maxlength[15]', 'IMEI');
        $error .= $this->complementos->validaCampo($fechaCompra, 'required|dateDos', 'Fecha Compra');
        $error .= $this->complementos->validaCampo($precioCompra, 'required|decimal|trim|minnumber[0]', 'Precio Compra');
        $error .= $this->complementos->validaCampo($precioLista, 'required|decimal|trim|minnumber[0]', 'Precio Lista');
        $error .= $this->complementos->validaCampo($estado, 'required', 'Estado');
        $error .= $this->complementos->validaCampo($situacion, 'required', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

		$imeiExistente = $this->moviles->where('IMEI', $imei)->findAll();

        if(count($imeiExistente)>0)
        {
            $message = sprintf($this->mensajeError->msg201, "<li>El IMEI ya fue registrado. [CAMPO] <small>IMEI</small></li>");
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        $data = array (
            'IDModelo'          => $modelo, 
            'Proveedor'         => ucfirst($proveedor), 
            'IMEI'              => $imei, 
            'FechaCompra'       => date("Y-m-d", strtotime($fechaCompra)), 
            'PrecioCompra'      => $precioCompra, 
            'PrecioLista'       => $precioLista, 
            'FechaEstado'       => $fechaActual,
            'UsuarioEstado'     => $this->items['id'],
            'Estado'            => $estado,  
            'Situacion'         => $situacion,
            'MotivoCambio'      => "Registro de equipo móvil.",  
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->moviles->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $imei.' '.$modelo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }  

	public function obtenerDatosMovil() {

		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idMovil = $this->request->getPost('idMovil');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idMovil, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosMovil = $this->moviles->obtenerMovil($idMovil);

		if(!empty($datosMovil)){
			$resultado = array(
				'idmovil' => (string) $idMovil,
				'marca' => (string) $datosMovil['IDMarca'],
				'modelo' => (string) $datosMovil['IDModelo'],
				'proveedor' => (string) $datosMovil['Proveedor'],
				'imei' => (string) $datosMovil['IMEI'],
				'fecha_compra' => (string) $datosMovil['FechaCompra'],
				'precio_compra' => (string) $datosMovil['PrecioCompra'],
				'precio_lista' => (string) $datosMovil['PrecioLista']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}

    public function modificarMovil($idMovil){

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $marca = $this->request->getPost('txtMarca_i');
        $modelo = $this->request->getPost('txtModeloComercial_i');
        $proveedor = $this->request->getPost('txtProveedor_i');
        $imei = $this->request->getPost('txtIMEI_i');
        $fechaCompra = $this->request->getPost('txtFechaCompra_i');
        $precioCompra = $this->request->getPost('txtPrecioCompra_i');
        $precioLista = $this->request->getPost('txtPrecioLista_i');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($marca, 'required|trim', 'Marca');
        $error .= $this->complementos->validaCampo($modelo, 'required|trim', 'Modelo');
        $error .= $this->complementos->validaCampo($proveedor, 'required|trim', 'Proveedor');
        $error .= $this->complementos->validaCampo($precioCompra, 'required|decimal|trim|minnumber[0]', 'Precio Compra');
        $error .= $this->complementos->validaCampo($precioLista, 'required|decimal|trim|minnumber[0]', 'Precio Lista');

        if($imei != NULL)
        {
            $error .= $this->complementos->validaCampo($imei, 'required|trim|numeric|minlength[15]|maxlength[15]', 'IMEI');
        }

        if($fechaCompra != NULL)
        {
            $error .= $this->complementos->validaCampo($fechaCompra, 'required|trim|dateDos', 'Fecha de Compra');
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'Marca'             => ucfirst($marca), 
            'ModeloComercial'   => $modelo, 
            'Proveedor'         => ucfirst($proveedor),
            'PrecioCompra'      => $precioCompra, 
            'PrecioLista'       => $precioLista, 
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        if($imei != NULL)
        {
            $data["IMEI"] = $imei;
        }

        if($fechaCompra != NULL)
        {
            $data["FechaCompra"] = $fechaCompra;
        }


        $lastId = $this->moviles->update([$idMovil], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idMovil);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	public function listarLineas(){
		if(isset($this->items['id'])){

			/* ACCIONES */
			$listaLineas = $this->lineas
							->listarLineas();

            foreach($listaLineas as $key=>$value)
            {
                //Obtener Usuario Remitente
                $asignado = $this->usuarios->where("IdUsuario ", $value['UsuarioAsignado'])->first();
                //var_dump($asignado);
                if($asignado != null)
                {
                    $listaLineas[$key]['NombreAsignado'] = strtoupper($asignado['Nombres'].' '.$asignado['Apellidos']);
                    $listaLineas[$key]['UsuarioAsignado'] = $asignado['Usuario'] ;
                }
                else
                {
                    $listaLineas[$key]['NombreAsignado'] = "--";
                    $listaLineas[$key]['UsuarioAsignado'] = "--";
                }
            }
                            


			$data = array (
				'session'               => 'on',
				'titulo'                => 'Líneas | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Líneas',
				'listaLineas'           => $listaLineas
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/lineas/listar_lineas',$data);			
		} else {
			return view('errors/500');
		}
	}

    public function subirCSVLinea()
    {
        $fechaActual = date("Y-m-d H:i:s");
        $fechaActualAdd = date("Y-m-d H:i:s", strtotime($fechaActual)+1);
        
        /*
        * ----------------------------
        * DECLARAR Y ASIGNAR VARIABLE A ARCHIVO OBTENIDO
        * ----------------------------
        */
        
        $csv = $this->request->getFile("fileCSVLinea");

        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $csv->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $csv->getErrorString().'-'.$csv->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'fileCSVLinea' => [
                'mime_in[fileCSVLinea,text/csv,text/plain]',
                'ext_in[fileCSVLinea,csv]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        /*
        * ----------------------------
        * VALIDAR SEPARADOR CSV
        * ----------------------------
        */
        
        $separadorCSV = $this->complementos->validarSeparadorCSV($csv, 21);
        
        if (!$separadorCSV) {
            $message = sprintf($this->mensajeError->msg201, "No se encontró separador de CSV autorizado. Debe usar coma (,) o punto y coma (;) y eliminar celdas vacías a la derecha de la última columna.");
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y VALIDAR DATOS CORRECTOS
        * ----------------------------
        */
        
        //Declaramos variables
        $fila = 0;
        $filasError = array();
        $ejecutarInsert = true;
        //Abrimos el archivo
        $handle = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handle, 0, $separadorCSV)) !== FALSE)
        {
            $fila++;

            if($fila>1)
            {
                $data = array_map("utf8_encode", $data);
                //Asignamos valores de CSV a variables locales
                $linea = $data[0];
                $iccid = $data[1];
                $plan = $data[2];
                $modelo = $data[7];
                $imei = $data[9];
                $usuario = $data[13];

                //Validamos existencia de Linea:
                $datosLinea = $this->lineas->where("Numero",trim($linea))->first();
                if(!empty($datosLinea))
                {
                    $filasError[$fila]['LINEA'] = "LINEA EXISTENTE";
                    $ejecutarInsert = false;
                }

                //Validamos existencia de ICCID:
                $datosiccid = $this->lineas->where("ICCID",trim($iccid))->first();
                if(!empty($datosiccid))
                {
                    $filasError[$fila]['ICCID'] = "ICCID EXISTENTE";
                    $ejecutarInsert = false;
                }

                //Validamos existencia de Plan:
                $datosPlan = $this->planes->where("Plan", trim($plan))->first();
                if(empty($datosPlan))
                {
                    $filasError[$fila]['PLAN'] = "PLAN NO EXISTE";
                    $ejecutarInsert = false;
                }

                //Validamos existencia de Modelo:
                $datosDispositivos = $this->dispositivos->where("Modelo", trim($modelo))->first();
                if(empty($datosDispositivos))
                {
                    $filasError[$fila]['MODELO'] = "MODELO NO EXISTE";
                    $ejecutarInsert = false;
                }
                
                //Validamos existencia de IMEI:
                $datosImei = $this->moviles->where('IMEI', trim($imei))->first();
                if(!empty($datosImei))
                {
                    $filasError[$fila]['IMEI'] = "IMEI EXISTENTE";
                    $ejecutarInsert = false;
                }

                //Validamos usuario correcto:
                if($usuario != '' && $usuario != null)
                {
                    $datosUsuario = $this->usuarios->where("Usuario ", $usuario)->first();

                    if(empty($datosUsuario))
                    {
                        $filasError[$fila]['USUARIO'] = "USUARIO NO VÁLIDO-".$usuario;
                        $ejecutarInsert = false;
                    }
                }
            }
        }

        fclose($handle);

        if(!$ejecutarInsert)
        {
            $raiz = 'public/';
            $nombre = 'error.txt';
            $file = 'public/error.txt';
            
            if (file_exists($file)) {
                unlink($file);
            }
            
            $txt= fopen($file, 'a') or die ('Problemas al crear el archivo');
            #  Se establecen los datos que va a conterner el archivo
            foreach($filasError as $key=>$value)
            {
                fwrite($txt, "FILA: ".$key."\n");
                foreach($value as $celda=>$error)
                {
                    fwrite($txt, $celda.": ".$error."\n");
                }
            }
            #  Se hace el ciere para no sobre escribir datos 
            fclose($txt);

            $message = sprintf($this->mensajeError->msg201, "Se detectaron diversas inconsistencias.");
            $salida1 = $this->alertas->alertaError($message);
            $salida2 = $this->alertas->descargaArchivoTXT($nombre);
			echo $salida1.$salida2;
			//echo $salida1;
            
			exit;
        }
        
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y EJECUTAR INSERTS
        * ----------------------------
        */
            
        //Declaramos variables
        $arrayLineaInsert = array();
        $arrayContratoInsert = array();
        $arrayEquipoInsert = array();
        $arrayAsignacionInsert = array();
        $arrayAsignacionDetalleInsert = array();
        $filainsert = 0;
        //Abrimos el archivo
        $handleInsert = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handleInsert, 0, $separadorCSV)) !== FALSE)
        {
            $data = array_map("utf8_encode", $data);
            $filainsert++;
            if($filainsert > 1)
            {
                $a = trim($data[3]);
                //Asignamos valores de CSV a variables locales
                $linea = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $iccid = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                $plan = trim($data[2]," \t\n\r\0\x0B\xc2\xa0");
                $inicioContrato = trim($data[3]," \t\n\r\0\x0B\xc2\xa0");
                $diaFacturacion = trim($data[4]," \t\n\r\0\x0B\xc2\xa0");
                $periodo = trim($data[5]," \t\n\r\0\x0B\xc2\xa0");
                $cuotaEquipo = trim($data[6]," \t\n\r\0\x0B\xc2\xa0");
                $modelo = trim($data[7]," \t\n\r\0\x0B\xc2\xa0");
                $proveedor = trim($data[8]," \t\n\r\0\x0B\xc2\xa0");
                $imei = trim($data[9]," \t\n\r\0\x0B\xc2\xa0");
                $fechaCompra = trim($data[10]," \t\n\r\0\x0B\xc2\xa0");
                $precioCompra = trim($data[11]," \t\n\r\0\x0B\xc2\xa0");
                $precioLista = trim($data[12]," \t\n\r\0\x0B\xc2\xa0");
                $asignado = trim($data[13]," \t\n\r\0\x0B\xc2\xa0");
                $tipoasignado = trim($data[14]," \t\n\r\0\x0B\xc2\xa0");
                $observacionasignado = trim($data[15]," \t\n\r\0\x0B\xc2\xa0");
                $fechaasignado = trim($data[16]," \t\n\r\0\x0B\xc2\xa0");
                $obslinea = trim($data[17]," \t\n\r\0\x0B\xc2\xa0");
                $obsmovil = trim($data[18]," \t\n\r\0\x0B\xc2\xa0");
                $repolinea = trim($data[19]," \t\n\r\0\x0B\xc2\xa0");
                $repomovil = trim($data[20]," \t\n\r\0\x0B\xc2\xa0");

                //Armar array de Linea e insertar datos:
                $dataLinea = array (
                    'Numero'            => $linea, 
                    'ICCID'             => $iccid, 
                    'FechaEstado'       => $fechaActual,
                    'UsuarioEstado'     => $this->items['id'],
                    'Estado'            => 'ACT',  
                    'Situacion'         => 'NUE',
                    'MotivoCambio'      => "Registro de línea.",  
                    'UsuarioCrea'       => $this->items['id'],
                    'FechaCrea'         => $fechaActual,    
                    'Localhost'         => $this->request->getIPAddress()
                );

                $lastIdLinea = $this->lineas->insert($dataLinea, TRUE);
                
                if($lastIdLinea === FALSE){
                    //Eliminar registros previos
                    
                    $message = sprintf($this->mensajeError->msg201, "No se pudo insertar los registros solicitados. Inténtelo luego.".$filainsert);
                    echo $this->alertas->alertaError($message);
                    echo $this->alertas->refrescar(1);
                    exit;
                }

                $arrayLineaInsert[] = $lastIdLinea;

                //Armar array de Movil e insertar datos:

                if($imei != '' && $imei != null)
                {
                    $datosDispositivos = $this->dispositivos->where("Modelo", trim($modelo))->first();

                    $dataMovil = array (
                        'IDModelo'          => $datosDispositivos['IDDispositivo'], 
                        'Proveedor'         => ucfirst($proveedor), 
                        'IMEI'              => $imei, 
                        'FechaCompra'       => $fechaCompra, 
                        'PrecioCompra'      => $precioCompra, 
                        'PrecioLista'       => $precioLista, 
                        'FechaEstado'       => $fechaActual,
                        'UsuarioEstado'     => $this->items['id'],
                        'Estado'            => "ACT",  
                        'Situacion'         => "NUE",
                        'MotivoCambio'      => "Registro de equipo móvil.",  
                        'UsuarioCrea'       => $this->items['id'],
                        'FechaCrea'         => $fechaActual,    
                        'Localhost'         => $this->request->getIPAddress()
                    );

                    $lastIdMovil = $this->moviles->insert($dataMovil, TRUE);

                    if($lastIdMovil === FALSE){
                        //Eliminar registros previos
                        
                        $this->lineas->whereIn('IDLinea', $arrayLineaInsert)->delete();

                        $message = sprintf($this->mensajeError->msg201, "No se pudo insertar los registros solicitados. Inténtelo luego.");
                        echo $this->alertas->alertaError($message);
                        echo $this->alertas->refrescar(1);
                        exit;
                    }
                    $arrayEquipoInsert[] = $lastIdMovil;
                }
                else
                {
                    $lastIdMovil = null;
                }
                    
                if($plan != '' && $plan != null)
                {
                    //Armar array de Contrato e insertar datos:
                    $datosPlan = $this->planes->where("Plan", trim($plan))->first();
                    $dataContrato = array (
                        'IDLinea'           => $lastIdLinea, 
                        'IDPlan'            => $datosPlan['IDPlan'],  
                        'InicioContrato'    => $inicioContrato, 
                        'DiaFacturacion'    => $diaFacturacion, 
                        'Permanencia'       => ($periodo == 'SP' ? 'N' : 'Y'), 
                        'PeriodoPermanencia'=> $periodo, 
                        'EquipoAsociado'    => $lastIdMovil,
                        'MontoCuota'        => $cuotaEquipo,
                        'FechaEstado'       => $fechaActual,
                        'UsuarioEstado'     => $this->items['id'],
                        'Estado'            => 'VIGENTE',
                        'MotivoCambio'      => "Registro de contrato.",  
                        'UsuarioCrea'       => $this->items['id'],
                        'FechaCrea'         => $fechaActual,    
                        'Localhost'         => $this->request->getIPAddress()
                    );
            
                    $lastIdContrato = $this->contratos->insert($dataContrato, TRUE);
                    
                    if($lastIdContrato === FALSE){
                        //Eliminar registros previos
                        
                        $this->lineas->whereIn('IDLinea', $arrayLineaInsert)->delete();
                        $this->moviles->whereIn('IDMovil', $arrayEquipoInsert)->delete();

                        $message = sprintf($this->mensajeError->msg201, "No se pudo insertar los registros solicitados. Inténtelo luego.");
                        echo $this->alertas->alertaError($message);
                        echo $this->alertas->refrescar(1);
                        exit;
                    }
                    $arrayContratoInsert[] = $lastIdContrato;
                }
                    
                //Validamos usuario correcto:
                if($asignado != '' && $asignado != null)
                {
                    //Armar array de Asignaciones e insertar datos:
                    $datosUsuario = $this->usuarios->buscarUsuarioXusuario($asignado);
                    
                    $dataAsignacion = array (
                        'UsuarioAsignado'       => $datosUsuario['IdUsuario'], 
                        'CargoAsignado'         => $datosUsuario['Cargo'], 
                        'AreaAsignado'          => $datosUsuario['IdArea'], 
                        'DepartamentoAsignado'  => $datosUsuario['IdDpto'], 
                        'FechaAsignado'         => $fechaasignado, 
                        'TipoAsignado'          => $tipoasignado, 
                        'Observacion'           => $observacionasignado, 
                        'UsuarioRemitente'      => $this->items['id'], 
                        'CargoRemitente'        => $this->items['cargo'], 
                        'AreaRemitente'         => $this->items['idArea'], 
                        'DepartamentoRemitente' => $this->items['dpto'], 
                        'TokenLinkFirma'        => $this->complementos->generar_string_aleatorio(15),
                        'LiberadoFirma'         => 'Y',
                        'UsuarioCrea'           => $this->items['id'],
                        'FechaCrea'             => $fechaActualAdd,    
                        'Localhost'             => $this->request->getIPAddress()
                    );

                    $lastIdAsignacion = $this->asignaciones->insert($dataAsignacion, TRUE);
                    
                    if($lastIdAsignacion === FALSE){
                        //Eliminar registros previos
                        
                        $this->contratos->whereIn('IDContrato', $arrayContratoInsert)->delete();
                        $this->lineas->whereIn('IDLinea', $arrayLineaInsert)->delete();
                        $this->moviles->whereIn('IDMovil', $arrayEquipoInsert)->delete();

                        $message = sprintf($this->mensajeError->msg201, "No se pudo insertar los registros solicitados. Inténtelo luego.");
                        echo $this->alertas->alertaError($message);
                        echo $this->alertas->refrescar(1);
                        exit;
                    }
                    $arrayAsignacionInsert[] = $lastIdAsignacion;

                    $dataDetalleAsignacion = array();

                    $dataDetalleAsignacion[] = array (
                        'IDAsignacion'      => $lastIdAsignacion, 
                        'TipoElemento'      => "LINEA",  
                        'IDElemento'        => $lastIdLinea, 
                        'Observacion'       => $obslinea, 
                        'MontoReposicion'   => $repolinea, 
                        'UsuarioCrea'       => $this->items['id'],
                        'FechaCrea'         => $fechaActualAdd,    
                        'Localhost'         => $this->request->getIPAddress()
                    );
                    
                    if($lastIdMovil!='' && $lastIdMovil != null)
                    {
                        $dataDetalleAsignacion[] = array (
                            'IDAsignacion'      => $lastIdAsignacion, 
                            'TipoElemento'      => "MOVIL",  
                            'IDElemento'        => $lastIdMovil, 
                            'Observacion'       => $obsmovil, 
                            'MontoReposicion'   => $repomovil, 
                            'UsuarioCrea'       => $this->items['id'],
                            'FechaCrea'         => $fechaActualAdd,    
                            'Localhost'         => $this->request->getIPAddress()
                        );
                    }
                    
                    $lastIdDetalleAsignacion = $this->detalleasignaciones->insertBatch($dataDetalleAsignacion);
                        
                    if($lastIdDetalleAsignacion === FALSE){
                        //Eliminar registros previos
                        
                        $this->contratos->whereIn('IDContrato', $arrayContratoInsert)->delete();
                        $this->asignaciones->whereIn('IDAsignacion', $arrayAsignacionInsert)->delete();
                        $this->lineas->whereIn('IDLinea', $arrayLineaInsert)->delete();
                        $this->moviles->whereIn('IDMovil', $arrayEquipoInsert)->delete();

                        $message = sprintf($this->mensajeError->msg201, "No se pudo insertar los registros solicitados. Inténtelo luego.");
                        echo $this->alertas->alertaError($message);
                        echo $this->alertas->refrescar(1);
                        exit;
                    }
                    $arrayAsignacionDetalleInsert[] = $lastIdDetalleAsignacion;
                }
                
            }
        }

        fclose($handleInsert);

        $message = sprintf($this->mensajeError->msg201, "Se insertaron el total de ".$filainsert." filas.");
        echo $this->alertas->alertaExito($message);
        echo $this->alertas->refrescar(1);

    }
	
	public function obtenerDatosLinea() {

		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idLinea = $this->request->getPost('idLinea');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idLinea, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosLinea = $this->lineas->where("IDLinea",$idLinea)->first();

		if(!empty($datosLinea)){
			$resultado = array(
				'idlinea' => (string) $idLinea,
				'numero' => (string) $datosLinea['Numero'],
				'iccid' => (string) $datosLinea['ICCID']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}

    public function insertarLinea(){

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $numero = $this->request->getPost('txtNumero');
        $iccid = $this->request->getPost('txtICCID');
        $estado = $this->request->getPost('txtEstadoLinea');
        $situacion = $this->request->getPost('txtMotivoLinea');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($numero, 'required|trim|numeric|minlength[9]|maxlength[9]', 'Número');
        $error .= $this->complementos->validaCampo($iccid, 'trim|numeric|minlength[15]|maxlength[30]', 'ICCID');
        $error .= $this->complementos->validaCampo($estado, 'required', 'Estado');
        $error .= $this->complementos->validaCampo($situacion, 'required', 'Situación');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */
        $msgExistencia = '';
        
		$iccidExistente = $this->lineas->where('ICCID', $iccid)->findAll();
		$numeroExistente = $this->lineas->where('Numero', $numero)->findAll();

        if($iccid != '' && count($iccidExistente)>0)
        {
            $msgExistencia .= "<li>El ICCID ya fue registrado. [CAMPO] <small>ICCID</small></li>";
        }

        if(count($numeroExistente)>0)
        {
            $msgExistencia .= "<li>El Número ya fue registrado. [CAMPO] <small>Número</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */

        $data = array (
            'Numero'            => $numero, 
            'ICCID'             => $iccid, 
            'FechaEstado'       => $fechaActual,
            'UsuarioEstado'     => $this->items['id'],
            'Estado'            => $estado,  
            'Situacion'         => $situacion,
            'MotivoCambio'      => "Registro de línea.",  
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->lineas->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $numero);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }  

    public function modificarLinea($idLinea){

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $numero = $this->request->getPost('txtNumero');
        $iccid = $this->request->getPost('txtICCID');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($numero, 'required|trim|numeric|minlength[9]|maxlength[9]', 'Número');
        $error .= $this->complementos->validaCampo($iccid, 'trim|numeric|minlength[15]|maxlength[30]', 'ICCID');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        
        $msgExistencia = '';
        
		$iccidExistente = $this->lineas->where('ICCID', $iccid)->findAll();
		$numeroExistente = $this->lineas->where('Numero', $numero)->findAll();

        if($iccid != '' && count($iccidExistente)>0)
        {
            $msgExistencia .= "<li>El ICCID ya fue registrado. [CAMPO] <small>ICCID</small></li>";
        }

        if(count($numeroExistente)>0)
        {
            $msgExistencia .= "<li>El Número ya fue registrado. [CAMPO] <small>Número</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
*/
        $data = array (
            'Numero'            => $numero, 
            'ICCID'             => $iccid, 
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->lineas->update([$idLinea], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idLinea);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	public function contratoLinea($idLinea){
		if(isset($this->items['id'])){

			/* ACCIONES */
            $linea = $this->lineas->where('IDLinea', $idLinea)->first();
			$listaContratos = $this->contratos->listarContratosXLinea($idLinea);
            $periodoPermanencia = $this->globales->permanenciaContrato();
            
            foreach($listaContratos as $key=>$items)
            {
                $listaContratos[$key]['Penalidad'] = $this->complementos->calculoPenalidadMovil($items);
            }
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Contratos de línea | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Contratos de línea - '.$linea['Numero'],
                'previo'                => 'listar-lineas',
                'linea'                 => $linea,
				'listaContratos'        => $listaContratos,
                'periodoPermanencia'    => $periodoPermanencia
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/lineas/listar_contratos',$data);			
		} else {
			return view('errors/500');
		}
	}
	
	public function validarContratoLineaActual()
	{
	    $idLinea = $this->request->getPost('idLinea');
	    
	    $contrato = $this->contratos->where("IDLinea", $idLinea)->orderBy('FechaCrea', 'DESC')->first();
	    
	    if($contrato['Permanencia']=='N')
	    {
	        $resultado = array(
				'mensaje'   => (string) "¿Deseas crear un nuevo contrato para esta línea?",
				'form'      => (string) "REG"
			);
	    }
	    else
	    {
	        $resultado = array(
				'mensaje'   => (string) "El contrato vigente cuenta con permanencia, por lo que deberá pagar una penalidad, ¿Deseas continuar?",
				'form'      => (string) "PEN"
			);
	    }
	    
		echo json_encode($resultado, JSON_NUMERIC_CHECK);
	}
	
    public function insertarContrato(){

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $montoDeducible = $this->request->getPost('txtMontoDeducible');
        $idLinea = $this->request->getPost('txtIdLinea');
        $idplan = $this->request->getPost('txtPlan');
        $inicioContrato = $this->request->getPost('txtInicioContrato');
        $diaFacturacion = $this->request->getPost('txtDiaFacturacion');
        $periodo = $this->request->getPost('txtPeriodoPermanencia');
        $cuotaEquipo = $this->request->getPost('txtValorCuota');
        $estadoContrato = $this->request->getPost('txtEstado_contrato');
        
        $incluyeMovil = $this->request->getPost('chkIncluyeMovil'); // on o vacio

        $modelo = $this->request->getPost('txtModeloComercial');
        $proveedor = $this->request->getPost('txtProveedor');
        $imei = $this->request->getPost('txtIMEI');
        $fechaCompra = $this->request->getPost('txtFechaCompra');
        $precioCompra = $this->request->getPost('txtPrecioCompra');
        $precioLista = $this->request->getPost('txtPrecioLista');
        $estadoEquipo = $this->request->getPost('txtEstado_equipo');
        $situacionEquipo = $this->request->getPost('txtMotivo_equipo');
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idplan, 'required|trim|numeric', 'IDPlan');
        $error .= $this->complementos->validaCampo($inicioContrato, 'required|dateDos', 'Inicio de contrato');
        $error .= $this->complementos->validaCampo($diaFacturacion, 'required|number|minnumber[1]|maxnumber[31]', 'Dia facturación');
        $error .= $this->complementos->validaCampo($periodo, 'required|trim', 'Permanencia');
        $error .= $this->complementos->validaCampo($cuotaEquipo, 'required|decimal|trim|minnumber[0]', 'Valor de Cuota');
        $error .= $this->complementos->validaCampo($estadoContrato, 'required', 'Estado Contrato');

        if(isset($montoDeducible))
        {
            $error .= $this->complementos->validaCampo($montoDeducible, 'required|decimal|trim|minnumber[0]', 'Monto Penalidad');
        }
        
        if($incluyeMovil != '')
        {
            $error .= $this->complementos->validaCampo($modelo, 'required|trim|minlength[1]|maxlength[50]', 'Modelo');
            $error .= $this->complementos->validaCampo($proveedor, 'required|trim|minlength[1]|maxlength[50]', 'Proveedor');
            $error .= $this->complementos->validaCampo($imei, 'required|trim|numeric|minlength[15]|maxlength[15]', 'IMEI');
            $error .= $this->complementos->validaCampo($fechaCompra, 'required|dateDos', 'Fecha Compra');
            $error .= $this->complementos->validaCampo($precioCompra, 'required|decimal|trim|minnumber[0]', 'Precio Compra');
            $error .= $this->complementos->validaCampo($precioLista, 'required|decimal|trim|minnumber[0]', 'Precio Lista');
            $error .= $this->complementos->validaCampo($estadoEquipo, 'required', 'Estado Equipo');
            $error .= $this->complementos->validaCampo($situacionEquipo, 'required', 'Motivo Equipo');
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */
        
        $msgExistencia = '';
        
		$imeiExistente = $this->moviles->where('IMEI', $imei)->findAll();

        if(count($imeiExistente)>0)
        {
            $msgExistencia .= "<li>El IMEI ya fue registrado. [CAMPO] <small>IMEI</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */
        
        //Actualizamos Contrato previo
        
        $contratoActual = $this->contratos->where("IDLinea", $idLinea)->orderBy('FechaCrea', 'DESC')->first();
        
        $dataContratoActual = array (
            'Permanencia'       => 'N',
            'FechaEstado'       => $fechaActual,
            'UsuarioEstado'     => $this->items['id'],
            'Estado'            => "CADUCADO",
            'MotivoCambio'      => "CONTRATO CADUCADO POR NUEVO CONTRATO.",
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );
        
        if(isset($montoDeducible))
        {
            $dataContratoActual['MontoDeducible'] = $montoDeducible;
            $dataContratoActual['FechaPagoDeducible'] = $fechaActual;
        }
        
        $lastId = $this->contratos->update([$contratoActual['IDContrato']], $dataContratoActual);

		if($lastId === FALSE){
			$message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al actualizar el contrato actual. Inténtelo luego.</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
		}
        
        if($incluyeMovil != '')
        {
            $dataEquipo = array (
                'IDModelo'          => $modelo, 
                'Proveedor'         => ucfirst($proveedor), 
                'IMEI'              => $imei, 
                'FechaCompra'       => date("Y-m-d", strtotime($fechaCompra)), 
                'PrecioCompra'      => $precioCompra, 
                'PrecioLista'       => $precioLista, 
                'FechaEstado'       => $fechaActual,
                'UsuarioEstado'     => $this->items['id'],
                'Estado'            => $estadoEquipo,  
                'Situacion'         => $situacionEquipo,
                'MotivoCambio'      => "Registro de equipo móvil.",  
                'UsuarioCrea'       => $this->items['id'],
                'FechaCrea'         => $fechaActual,    
                'Localhost'         => $this->request->getIPAddress()
            );

            $lastIdEquipo = $this->moviles->insert($dataEquipo, TRUE);
            
            if($lastIdEquipo !== FALSE){
                $idMovil = $lastIdEquipo;
            }
            else
            {
                $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al guardar el equipo. Inténtelo luego.</li>");
                echo $this->alertas->alertaError($message);
                EXIT;
            }
        }
        else
        {
            $idMovil = null;
        }

        $dataContrato = array (
            'IDLinea'           => $idLinea, 
            'IDPlan'            => $idplan,  
            'InicioContrato'    => date("Y-m-d", strtotime($inicioContrato)), 
            'DiaFacturacion'    => $diaFacturacion, 
            'Permanencia'       => ($periodo == 'SP' ? 'N' : 'Y'), 
            'PeriodoPermanencia'=> $periodo, 
            'EquipoAsociado'    => $idMovil,
            'MontoCuota'        => $cuotaEquipo,
            'FechaEstado'       => $fechaActual,
            'UsuarioEstado'     => $this->items['id'],
            'Estado'            => $estadoContrato,
            'MotivoCambio'      => "Registro de contrato.",  
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->contratos->insert($dataContrato, TRUE);
        
		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idLinea);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }  

	public function obtenerDatosContrato() {

		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idContrato = $this->request->getPost('idContrato');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idContrato, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosContrato = $this->contratos->obtenerContrato($idContrato);
        
		if(!empty($datosContrato)){
			$resultado = array(
				'idcontrato'        => (string) $idContrato,
				'idplan'            => (string) $datosContrato['IDPlan'],
				'idoperador'        => (string) $datosContrato['IDOperador'],
				'iniciocontrato'    => (string) $datosContrato['InicioContrato'],
				'periodo'           => (string) $datosContrato['PeriodoPermanencia'],
				'diafacturacion'    => (string) $datosContrato['DiaFacturacion'],
				'montocuota'        => (string) $datosContrato['MontoCuota']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}

    public function modificarContrato($idContrato){

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idplan = $this->request->getPost('txtPlan_i');
        $inicioContrato = $this->request->getPost('txtInicioContrato_i');
        $periodo = $this->request->getPost('txtPeriodoPermanencia_i');
        $diaFacturacion = $this->request->getPost('txtDiaFacturacion_i');
        $cuotaEquipo = $this->request->getPost('txtValorCuota_i');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idplan, 'required|trim|numeric', 'IDPlan');
        $error .= $this->complementos->validaCampo($inicioContrato, 'required|dateDos', 'Inicio de contrato');
        $error .= $this->complementos->validaCampo($diaFacturacion, 'required|number|minnumber[1]|maxnumber[31]', 'Dia facturación');
        $error .= $this->complementos->validaCampo($periodo, 'required|trim', 'Permanencia');
        $error .= $this->complementos->validaCampo($cuotaEquipo, 'required|decimal|trim|minnumber[0]', 'Valor de Cuota');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * VALIDACIÓN DE PLAN A ACTUALIZAR
        * ----------------------------
        */
        
        $planOrigen = $this->auditoria->obtenerPrimerPlanContrato($idContrato);
        
        if(empty($planOrigen))
        {
            $planOrigen = $this->contratos->obtenerContrato($idContrato);
        }
        
        $planSeleccionado = $this->planes->where("IDPlan", $idplan)->first();
        
        $mensajeValidacion = $this->complementos->validarUpgradePlan($planOrigen, $planSeleccionado);
        
        if($mensajeValidacion != '')
        {
            $message = sprintf($this->mensajeError->msg201, $mensajeValidacion);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * ACTUALIZACIÓN DE DATOS
        * ----------------------------
        */
        
        $data = array (
            'IDPlan'            => $idplan, 
            'InicioContrato'    => date("Y-m-d", strtotime($inicioContrato)), 
            'DiaFacturacion'    => $diaFacturacion,  
            'Permanencia'       => ($periodo == 'SP' ? 'N' : 'Y'), 
            'PeriodoPermanencia'=> $periodo,  
            'MontoCuota'        => $cuotaEquipo,  
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );
        $lastId = $this->contratos->update([$idContrato], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idContrato);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	public function seguroLinea($idLinea){
		if(isset($this->items['id'])){

			/* ACCIONES */
            $linea = $this->lineas->where('IDLinea', $idLinea)->first();
			$listaSeguros = $this->seguros->listadoSegurosXLinea($idLinea);
            
            //FUNCIÓN PARA QUITAR ARRAY CON VALORES NULOS O VACIOS
            $arrFinal = array_filter($listaSeguros, function($item){
                $notEmpty=count($item) == count(array_filter(array_map('trim', $item)));
                return $notEmpty;
            });

			$data = array (
				'session'           => 'on',
				'titulo'            => 'Seguros de línea | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Seguros de línea',
                'previo'            => 'listar-lineas',
                'linea'             => $linea,
				'listaSeguros'      => $arrFinal
			);


			$data = array_merge($data, $this->items);
			return view('veriactivos/lineas/listar_seguros',$data);			
		} else {
			return view('errors/500');
		}
	}

	public function listadoMovilesSeguro($idSeguro){
		if(isset($this->items['id'])){

			/* ACCIONES */
            $seguro = $this->seguros->where('IDSeguro', $idSeguro)->first();
			$listaMoviles = $this->segurosMovil->listadoMovilesXSeguro($idSeguro);
            
            //FUNCIÓN PARA QUITAR ARRAY CON VALORES NULOS O VACIOS
            /*$arrFinal = array_filter($listaSeguros, function($item){
                $notEmpty=count($item) == count(array_filter(array_map('trim', $item)));
                return $notEmpty;
            });*/

			$data = array (
				'session'           => 'on',
				'titulo'            => 'Móviles asociados a seguro | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Móviles en seguro',
                'previo'            => 'seguro-linea/'.$seguro['IDLinea'],
                'idSeguro'          => $idSeguro,
                'seguro'            => $seguro,
				'listaMoviles'      => $listaMoviles
			);


			$data = array_merge($data, $this->items);
			return view('veriactivos/lineas/listar_seguro_moviles',$data);			
		} else {
			return view('errors/500');
		}
	}
	
    public function insertarMovilSeguro(){

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idSeguro = $this->request->getPost('txtIdSeguro');
        $marca = $this->request->getPost('txtMarca');
        $modelo = $this->request->getPost('txtModeloComercial');
        $proveedor = $this->request->getPost('txtProveedor');
        $imei = $this->request->getPost('txtIMEI');
        $fechaCompra = $this->request->getPost('txtFechaCompra');
        $precioCompra = $this->request->getPost('txtPrecioCompra');
        $precioLista = $this->request->getPost('txtPrecioLista');
        $estado = $this->request->getPost('txtEstado');
        $situacion = $this->request->getPost('txtSituacion');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idSeguro, 'required', 'ID-Seguro');
        $error .= $this->complementos->validaCampo($marca, 'required|trim|alpha|minlength[1]|maxlength[50]', 'Marca');
        $error .= $this->complementos->validaCampo($modelo, 'required|trim|minlength[1]|maxlength[50]', 'Modelo');
        $error .= $this->complementos->validaCampo($proveedor, 'required|trim|minlength[1]|maxlength[50]', 'Proveedor');
        $error .= $this->complementos->validaCampo($imei, 'required|trim|numeric|minlength[15]|maxlength[15]', 'IMEI');
        $error .= $this->complementos->validaCampo($fechaCompra, 'required|dateDos', 'Fecha Compra');
        $error .= $this->complementos->validaCampo($precioCompra, 'required|decimal|trim|minnumber[0]', 'Precio Compra');
        $error .= $this->complementos->validaCampo($precioLista, 'required|decimal|trim|minnumber[0]', 'Precio Lista');
        $error .= $this->complementos->validaCampo($estado, 'required', 'Estado');
        $error .= $this->complementos->validaCampo($situacion, 'required', 'Situación');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

		$imeiExistente = $this->moviles->where('IMEI', $imei)->findAll();

        if(count($imeiExistente)>0)
        {
            $message = sprintf($this->mensajeError->msg201, "<li>El IMEI ya fue registrado. [CAMPO] <small>IMEI</small></li>");
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        $data = array (
            'Marca'             => ucfirst($marca), 
            'ModeloComercial'   => $modelo, 
            'Proveedor'         => ucfirst($proveedor), 
            'IMEI'              => $imei, 
            'FechaCompra'       => date("Y-m-d", strtotime($fechaCompra)), 
            'PrecioCompra'      => $precioCompra, 
            'PrecioLista'       => $precioLista, 
            'FechaEstado'       => $fechaActual,
            'UsuarioEstado'     => $this->items['id'],
            'Estado'            => $estado,  
            'Situacion'         => $situacion,
            'MotivoCambio'      => "Registro de equipo móvil.",  
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastIdEquipo = $this->moviles->insert($data, TRUE);

        if($lastIdEquipo !== FALSE){
            $idMovil = $lastIdEquipo;
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al guardar el equipo. Inténtelo luego.</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $dataSeguroMovil = array (
            'IDSeguro'          => $idSeguro, 
            'IDMovil'           => $idMovil, 
            'FechaCompra'       => date("Y-m-d", strtotime($fechaCompra)), 
            'FechaRegistra'     => $fechaActual,
            'UsuarioRegistra'   => $this->items['id']
        );

        $lastId = $this->segurosMovil->insert($dataSeguroMovil);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $marca.' '.$modelo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }  

	public function obtenerDatosSeguro() {

		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idSeguro = $this->request->getPost('idSeguro');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idSeguro, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosSeguro = $this->seguros->where('IDSeguro', $idSeguro)->first();
        
		if(!empty($datosSeguro)){
			$resultado = array(
				'idseguro' => (string) $idSeguro,
				'nro_seguro' => (string) $datosSeguro['NroSeguro'],
				'servicio' => (string) $datosSeguro['Servicio'],
				'plan' => (string) $datosSeguro['Plan'],
				'costo_plan' => (string) $datosSeguro['CostoPlan'],
				'inicio_contrato' => (string) $datosSeguro['InicioContrato']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}

    public function modificarSeguro($idSeguro){

        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $numSeguro = $this->request->getPost('txtNumSeguro_i');
        $servicio = $this->request->getPost('txtServicio_i');
        $plan = $this->request->getPost('txtPlan_i');
        $costoPlan = $this->request->getPost('txtCostoPlan_i');
        //$inicioContrato = $this->request->getPost('txtInicioContrato_i');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($numSeguro, 'required|trim', 'Número de Seguro');
        $error .= $this->complementos->validaCampo($servicio, 'required|trim', 'Servicio');
        $error .= $this->complementos->validaCampo($plan, 'required|trim', 'Plan');
        $error .= $this->complementos->validaCampo($costoPlan, 'required|decimal|trim|minnumber[0]', 'Costo de Plan');
        //$error .= $this->complementos->validaCampo($inicioContrato, 'required|dateDos', 'Inicio de contrato');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'NroSeguro'       => $numSeguro, 
            'Servicio'          => $servicio, 
            'Plan'              => $plan, 
            'CostoPlan'         => $costoPlan, 
            //'InicioContrato'    => date("Y-m-d", strtotime($inicioContrato)),
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->seguros->update([$idSeguro], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idSeguro);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

    public function actaAsignacion($idAsignacion, $token)
    {
        $asignacion = $this->asignaciones->where("IDAsignacion", $idAsignacion)->first();

        $whereFirma = array(
            "IDAsignacion"  => $idAsignacion,
            "Firma"         => "Y"
        );
        $firmaAsignacion = $this->asignacionesAdjuntos->where($whereFirma)->first();

        if($token == $asignacion['TokenLinkFirma'])
        {
			/* ACCIONES */

            $remitente = $this->usuarios->where("IdUsuario ", $asignacion['UsuarioRemitente'])->first();
            $asignado = $this->usuarios->buscarUsuario($asignacion['UsuarioAsignado']);
            $depaAsignacion = $this->bm_departamento->where("IdDpto", $asignacion['DepartamentoAsignado'])->first();
            $areaAsignacion = $this->bm_area->where("IdArea", $asignacion['DepartamentoAsignado'])->first();

            $asignacion['NombreRemitente'] = strtoupper($remitente['Nombres'].' '.$remitente['Apellidos']);
            $asignacion['NombreAsignado'] = $asignado['Nombres'];
            $asignacion['ApellidosAsignado'] = $asignado['Apellidos'];
            $asignacion['DocumentoAsignado'] = $asignado['NumeroDoc'];
            $asignacion['GerenciaAsignado'] = $depaAsignacion['NombreDpto'];
            $asignacion['AreaAsignado'] = $areaAsignacion['NombreArea'];
            $asignacion['FechaAsignacion'] = "Lima, ".date('d', strtotime($asignacion['FechaAsignado']))." de ".$this->complementos->parseoMes(date('m', strtotime($asignacion['FechaAsignado'])))." de ".date('Y', strtotime($asignacion['FechaAsignado']));

			$detalleAsignacion = $this->detalleasignaciones->where("IDAsignacion", $idAsignacion)->findAll();
            
            foreach($detalleAsignacion as $key=>$value)
            {
                //Obtener elemento
                if($value['TipoElemento']=='MOVIL')
                {
                    $dataElemento = $this->moviles->obtenerMovil($value['IDElemento']);
                    $detalleAsignacion[$key]['Marca'] = $dataElemento['Marca'];
                    $detalleAsignacion[$key]['Modelo'] = $dataElemento['Modelo'];
                    $detalleAsignacion[$key]['Serie'] = $dataElemento['IMEI'];
                }
                else if($value['TipoElemento']=='LINEA')
                {
                    $dataElemento = $this->lineas->obtenerLinea($value['IDElemento']);
                    $detalleAsignacion[$key]['TipoElemento'] = $value['TipoElemento'].' - '.$dataElemento['Numero'];
                    $detalleAsignacion[$key]['Marca'] = $dataElemento['Operador'];
                    $detalleAsignacion[$key]['Modelo'] = $dataElemento['Plan'];
                    $detalleAsignacion[$key]['Serie'] = $dataElemento['ICCID'];
                }
                else
                {
                    $informacionElemento = "SIN INFORMACIÓN";
                }
                
            }

			$data = array (
				'titulo'                => 'Asignaciones | Verisure',
				'asignacion'            => $asignacion,
                'detalle'               => $detalleAsignacion,
                'firmaAsignacion'       => $firmaAsignacion
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/asignaciones/acta_asignacion',$data);	
        }
        else
        {
            return view('errors/500');
        }
    }

    public function subirFirmaActaAsignacion()
    {
        $fechaActual = date("Y-m-d H:i:s");

        $idAsignacion = $this->request->getPost("txtIDAsignacion");
        $canvasFirma = $this->request->getPost("firmaActaAsignacion");
        
        $adjunto = $this->request->getFile("fileFotoDNI");
        
        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $adjunto->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $adjunto->getErrorString().'-'.$adjunto->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'fileFotoDNI' => [
                'mime_in[fileFotoDNI,image/png,image/jpg,image/jpeg,image/gif,application/pdf]',
                'ext_in[fileFotoDNI,png,jpg,jpeg,gif,pdf]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        if($adjunto->guessExtension() != null)
        {
            $extensionDoc = $adjunto->guessExtension();
        }
        else
        {
            $nombre_original = $adjunto->getBasename();
            $fileNameCmps = explode(".", $nombre_original);
            $extensionDoc = strtolower(end($fileNameCmps));
        }

        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */

        $asignacion = $this->asignaciones->where("IDAsignacion", $idAsignacion)->first();

        $data = array (
            'IDAsignacion'      => $idAsignacion, 
            'Nombre'            => "DOCUMENTO DE IDENTIDAD", 
            'Extension'         => $extensionDoc,
            'Observacion'       => "DOCUMENTO DE IDENTIDAD ADJUNTADO EN LA FIRMA.",
            'ReemplazoFirma'    => 'N',  
            'UsuarioCrea'       => $asignacion['UsuarioAsignado'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->asignacionesAdjuntos->insert($data, TRUE);

		if($lastId === FALSE){
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
			exit;
		}

        /*
        * ----------------------------
        * GUARDAR ARCHIVO ADJUNTO
        * ----------------------------
        */
        $ruta = "public/docs/ActaAsignacion/";
        $nombreArchivo = $idAsignacion."-".$lastId;

        if(!file_exists($ruta))
        {
            @mkdir($ruta, 0777, true);
        }

		# si exsite la carpeta o se ha creado
		if (file_exists($ruta) || @mkdir($ruta)) 
        {
            $nuevonombre = $nombreArchivo.'.'.$extensionDoc;
            
            $estadoMove = $adjunto->move($ruta, $nuevonombre);
            
            if (!$estadoMove) {
                $this->asignacionesAdjuntos->delete(["IDAdjuntoAsignacion", $lastId]);
                $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[SAVEDOC]");
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        else
        {
            $this->asignacionesAdjuntos->delete(["IDAdjuntoAsignacion", $lastId]);
            $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
            echo $this->alertas->alertaError($message);
        }
        
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */

        $dataFirma = array (
            'IDAsignacion'      => $idAsignacion, 
            'Nombre'            => "FIRMA", 
            'Extension'         => "png",
            'Observacion'       => "FIRMA DEL ASIGNADO.",
            'ReemplazoFirma'    => 'N',  
            'Firma'             => 'Y',  
            'UsuarioCrea'       => $asignacion['UsuarioAsignado'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastIdFirma = $this->asignacionesAdjuntos->insert($dataFirma, TRUE);

		if($lastIdFirma === FALSE){
            unlink($ruta.$nombreArchivo.'.'.$extensionDoc);
            $this->asignacionesAdjuntos->delete(["IDAdjuntoAsignacion", $lastId]);
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la firma. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
			exit;
		}

        /*
        * ----------------------------
        * GUARDAR FIRMA
        * ----------------------------
        */

        $ruta = "public/docs/ActaAsignacion/";
        $nombreArchivoFirma = $idAsignacion."-".$lastIdFirma;

        if(!file_exists($ruta))
        {
            @mkdir($ruta, 0777, true);
        }

		# si exsite la carpeta o se ha creado
		if (file_exists($ruta) || @mkdir($ruta)) 
        {
            $nuevonombreFirma = $nombreArchivoFirma.'.png';
            
            $datos = base64_decode(
                preg_replace('/^[^,]*,/', '', $canvasFirma)
            );

            $estadoFirma = file_put_contents($ruta.$nuevonombreFirma, $datos);
            
            if ($estadoFirma===FALSE) {
                unlink($ruta.$nombreArchivo.'.'.$extensionDoc);
                $this->asignacionesAdjuntos->delete(["IDAdjuntoAsignacion", $lastId]);
                $this->asignacionesAdjuntos->delete(["IDAdjuntoAsignacion", $lastIdFirma]);
                $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la firma. Inténtelo luego.[SAVEDOC]");
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        else
        {
            unlink($ruta.$nombreArchivo.'.'.$extensionDoc);
            $this->asignacionesAdjuntos->delete(["IDAdjuntoAsignacion", $lastId]);
            $this->asignacionesAdjuntos->delete(["IDAdjuntoAsignacion", $lastIdFirma]);
            $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
            echo $this->alertas->alertaError($message);
        }

        /*
        * ----------------------------
        * PREPARACIÓN DE CUERPO DE CORREO
        * ----------------------------
        */
        
        $usuarioRemitente = $this->usuarios->where("IdUsuario", $asignacion['UsuarioRemitente'])->first();
        
        $usuarioAsignado = $this->usuarios->where("IdUsuario", $asignacion['UsuarioAsignado'])->first();
        
        $arrayCuerpo = array(
            "TITULO" => "FIRMA DE ACTA DE ASIGNACIÓN",
            "ACTA" => "ACTA DE ASIGNACIÓN",
            "USUARIO" => ucwords(mb_strtolower($usuarioRemitente['Nombres'].' '.$usuarioRemitente['Apellidos'])),
            "CODIGO" => $idAsignacion
        );

        $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActasConfirmacion($arrayCuerpo);
        
        /*
        * ----------------------------
        * PREPARACIÓN DE PARAMETROS PARA EL CORREO
        * ----------------------------
        */

        $asunto='FIRMA DE ACTA DE ASIGNACIÓN: '.$idAsignacion.' - '.$usuarioAsignado['Nombres'].' '.$usuarioAsignado['Apellidos'];
        //$correoDestino = array($asignado['Correo']);
        $configCorreo = array(
            "NOMBRE_ORIGEN" => $usuarioAsignado['Nombres'].' '.$usuarioAsignado['Apellidos'],
            "CORREO_ORIGEN" => $usuarioAsignado['Correo'],
            "CORREOS_DESTINOS" => array($usuarioRemitente['Correo']),
            "CORREOS_COPIA" => array("soporteti@verisure.pe"),
            "CORREOS_OCULTO" => array(),
            "ASUNTO" => $asunto,
            "MENSAJE" => $cuerpo
        );

        $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);

        $dataCorreo = array(
            "IDAsignacion"  => $idAsignacion,
            "Response"      => $estadoCorreo['RESPUESTA'],
            "Error"         => $estadoCorreo['ERROR'],
            'UsuarioCrea'   => $reposicion['UsuarioAdjudicado'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $this->correoStatusAsignacion->insert($dataCorreo, TRUE);

        $message = sprintf($this->mensajeError->msg201, "La firma fue registrada exitosamente.");
        echo $this->alertas->alertaExito($message);
        echo $this->alertas->refrescar(1);
    }

    public function listarAsignaciones(){
		if(isset($this->items['id'])){

			/* ACCIONES */
			
			if($this->items['idPerfil'] == 3)
			{
			    $cccordinador = $this->globales->listadoCentroCostoCoordinador();
			
			    if(array_key_exists($this->items['id'], $cccordinador))
			    {
			        $centroscosto = $cccordinador[$this->items['id']];
			        $listaAsignaciones = $this->asignaciones->listarAsignaciones($centroscosto);
			    }
			    else
			    {
			        $listaAsignaciones = array();
			    }
			    
			}
			else
			{
			    $centroscosto = array();
			    $listaAsignaciones = $this->asignaciones->listarAsignaciones($centroscosto);
			}
			/*echo $this->items['idPerfil'];
			var_dump($centroscosto);
			exit;*/
            

            /*foreach($listaAsignaciones as $key=>$value)
            {
                //Obtener Usuario Asignado
			    $asignado = $this->usuarios->where("IdUsuario ", $value['UsuarioAsignado'])->first();
			    $remitente = $this->usuarios->where("IdUsuario ", $value['UsuarioRemitente'])->first();

                $listaAsignaciones[$key]['NombreAsignado'] = strtoupper($asignado['Nombres'].' '.$asignado['Apellidos']);
                $listaAsignaciones[$key]['MatriculaAsignado'] = $asignado['Matricula'];
                $listaAsignaciones[$key]['NombreRemitente'] = strtoupper($asignado['Nombres'].' '.$asignado['Apellidos']);
            }*/

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Asignaciones | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Actas de asignación',
				'listaAsignaciones'     => $listaAsignaciones
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/asignaciones/listar_asignaciones',$data);			
		} else {
			return view('errors/500');
		}
	}

    public function detalleActaAsignacion($idAsignacion)
    {
        if(isset($this->items['id'])){

			// ACCIONES
            $asignacion = $this->asignaciones->where("IDAsignacion",$idAsignacion)->first();
            $listaDetalle = $this->detalleasignaciones->listarDetalleAsignacion($idAsignacion);
            $listaAdjunto = $this->asignacionesAdjuntos->where("IDAsignacion", $idAsignacion)->findAll();    

            foreach($listaDetalle as $key=>$value)
            {
                //Obtener elemento
                if($value['TipoElemento']=='MOVIL')
                {
                    $dataElemento = $this->moviles->obtenerMovil($value['IDElemento']);
                    $listaDetalle[$key]['Marca'] = $dataElemento['Marca'];
                    $listaDetalle[$key]['Modelo'] = $dataElemento['Modelo'];
                    $listaDetalle[$key]['Serie'] = $dataElemento['IMEI'];
                }
                else if($value['TipoElemento']=='LINEA')
                {
                    $dataElemento = $this->lineas->obtenerLinea($value['IDElemento']);
                    $listaDetalle[$key]['TipoElemento'] = $value['TipoElemento'].' - '.$dataElemento['Numero'];
                    $listaDetalle[$key]['Marca'] = $dataElemento['Operador'];
                    $listaDetalle[$key]['Modelo'] = $dataElemento['Plan'];
                    $listaDetalle[$key]['Serie'] = $dataElemento['ICCID'];
                }
                else
                {
                    $informacionElemento = "SIN INFORMACIÓN";
                }
                
            }

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Detalle de Asignación | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Detalle de asignación | '.$asignacion['IDAsignacion'],
                'previo'                => 'listar-asignaciones',
				'listaDetalle'          => $listaDetalle,
                'listaAdjunto'          => $listaAdjunto,
                'idAsignacion'          => $idAsignacion
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/asignaciones/listar_detalle_asignacion',$data);			
		} else {
			return view('errors/500');
		}
    }

    public function documentoAsociado($idAsignado)
    {
        if(isset($this->items['id'])){

			/* ACCIONES */

            $asignacion = $this->asignaciones->where("IDAsignacion",$idAsignado)->first();
            $remitente = $this->usuarios->where("IdUsuario ", $asignacion['UsuarioRemitente'])->first();
            $asignado = $this->usuarios->buscarUsuario($asignacion['UsuarioAsignado']);
            $depaAsignacion = $this->bm_departamento->where("IdDpto", $asignacion['DepartamentoAsignado'])->first();
            $areaAsignacion = $this->bm_area->where("IdArea", $asignacion['DepartamentoAsignado'])->first();

            $whereFirma = array(
                "IDAsignacion"  => $idAsignado,
                "Firma"         => "Y"
            );
            $firmaAsignacion = $this->asignacionesAdjuntos->where($whereFirma)->first();

            $asignacion['NombreRemitente'] = strtoupper($remitente['Nombres'].' '.$remitente['Apellidos']);
            $asignacion['NombreAsignado'] = $asignado['Nombres'];
            $asignacion['ApellidosAsignado'] = $asignado['Apellidos'];
            $asignacion['DocumentoAsignado'] = $asignado['NumeroDoc'];
            $asignacion['GerenciaAsignado'] = $depaAsignacion['NombreDpto'];
            $asignacion['AreaAsignado'] = $areaAsignacion['NombreArea'];
            $asignacion['FechaAsignacion'] = "Lima, ".date('d', strtotime($asignacion['FechaAsignado']))." de ".$this->complementos->parseoMes(date('m', strtotime($asignacion['FechaAsignado'])))." de ".date('Y', strtotime($asignacion['FechaAsignado']));

			$detalleAsignacion = $this->detalleasignaciones->where("IDAsignacion", $idAsignado)->findAll();
            
            foreach($detalleAsignacion as $key=>$value)
            {
                //Obtener elemento
                if($value['TipoElemento']=='MOVIL')
                {
                    $dataElemento = $this->moviles->obtenerMovil($value['IDElemento']);
                    $detalleAsignacion[$key]['Marca'] = $dataElemento['Marca'];
                    $detalleAsignacion[$key]['Modelo'] = $dataElemento['Modelo'];
                    $detalleAsignacion[$key]['Serie'] = $dataElemento['IMEI'];
                }
                else if($value['TipoElemento']=='LINEA')
                {
                    $dataElemento = $this->lineas->obtenerLinea($value['IDElemento']);
                    $detalleAsignacion[$key]['TipoElemento'] = $value['TipoElemento'].' - '.$dataElemento['Numero'];
                    $detalleAsignacion[$key]['Marca'] = $dataElemento['Operador'];
                    $detalleAsignacion[$key]['Modelo'] = $dataElemento['Plan'];
                    $detalleAsignacion[$key]['Serie'] = $dataElemento['ICCID'];
                }
                else
                {
                    $informacionElemento = "SIN INFORMACIÓN";
                }
                
            }

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Asignaciones | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Acta de Asignación',
                'previo'                => 'listar-asignaciones',
				'asignacion'            => $asignacion,
                'detalle'               => $detalleAsignacion,
                'firmaAsignacion'       => $firmaAsignacion
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/asignaciones/documento_asignado',$data);			
		} else {
			return view('errors/500');
		}
    }

    public function nuevaAsignacion()
    {
        if(isset($this->items['id'])){

			/* ACCIONES */
			$listaUsuariosRemitente = $this->usuarios->where(array("CC"=>930, "Estado"=>"Activo"))->findAll();

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Nueva Asignación | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Nueva asignación',
                'previo'                => 'listar-asignaciones',
				'listaUsuariosRemitente'=> $listaUsuariosRemitente
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/asignaciones/nueva_asignacion',$data);			
		} else {
			return view('errors/500');
		}
    }

    public function subirCSVAsignacion()
    {
        $fechaActual = date("Y-m-d H:i:s");
        $fechaActualAdd = date("Y-m-d H:i:s", strtotime($fechaActual)+1);
        
        /*
        * ----------------------------
        * DECLARAR Y ASIGNAR VARIABLE A ARCHIVO OBTENIDO
        * ----------------------------
        */
        
        $csv = $this->request->getFile("fileCSVAsignacion");

        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $csv->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $csv->getErrorString().'-'.$csv->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'fileCSVLinea' => [
                'mime_in[fileCSVAsignacion,text/csv,text/plain]',
                'ext_in[fileCSVAsignacion,csv]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        /*
        * ----------------------------
        * VALIDAR SEPARADOR CSV
        * ----------------------------
        */
        
        $separadorCSV = $this->complementos->validarSeparadorCSV($csv, 7);
        
        if (!$separadorCSV) {
            $message = sprintf($this->mensajeError->msg201, "No se encontró separador de CSV autorizado. Debe usar coma (,) o punto y coma (;) y eliminar celdas vacías a la derecha de la última columna.");
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y VALIDAR DATOS CORRECTOS
        * ----------------------------
        */
        
        //Declaramos variables
        $fila = 0;
        $filasError = array();
        $arrayElementos = array();
        $ejecutarInsert = true;
        //Abrimos el archivo
        $handle = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handle, 0, $separadorCSV)) !== FALSE)
        {
            $fila++;

            if($fila>1)
            {
                $data = array_map("utf8_encode", $data);
                //Asignamos valores de CSV a variables locales
                $tipo           = $data[0];
                $referencia     = $data[1];
                $usuario        = $data[2];
                
                if($tipo == 'LINEA')
                {
                    $disponible = $this->lineas->listarLineasDisponibles($referencia);
                    
                    if(empty($disponible))
                    {
                        $filasError[$fila]['REFERENCIA'] = "ELEMENTO SE ENCUENTRA ASIGNADO";
                        $ejecutarInsert = false;
                    }
                    //Validamos existencia de Linea:
                    $datosLinea = $this->lineas->where("Numero",trim($referencia))->first();
                    if(empty($datosLinea))
                    {
                        $filasError[$fila]['REFERENCIA'] = "ELEMENTO NO EXISTE";
                        $ejecutarInsert = false;
                    }
                }
                else if($tipo == 'MOVIL')
                {
                    $disponible = $this->moviles->listarMovilesDisponibles($referencia);
                    
                    if(empty($disponible))
                    {
                        $filasError[$fila]['REFERENCIA'] = "ELEMENTO SE ENCUENTRA ASIGNADO";
                        $ejecutarInsert = false;
                    }
                    //Validamos existencia de IMEI:
                    $datosImei = $this->moviles->where('IMEI', trim($referencia))->first();
                    if(empty($datosImei))
                    {
                        $filasError[$fila]['REFERENCIA'] = "IMEI NO EXISTE";
                        $ejecutarInsert = false;
                    }
                }
                else
                {
                    $filasError[$fila]['TIPO'] = "TIPO NO DECLARADO";
                    $ejecutarInsert = false;
                }
                
                //Validamos usuario correcto:
                if($usuario != '' && $usuario != null)
                {
                    $datosUsuario = $this->usuarios->where("Usuario ", $usuario)->first();

                    if(empty($datosUsuario))
                    {
                        $filasError[$fila]['USUARIO'] = "USUARIO NO VÁLIDO-".$usuario;
                        $ejecutarInsert = false;
                    }
                }
                
                //Validamos repetición de elementos
                $filaRepetida = array_search($referencia, $arrayElementos);
                if($filaRepetida !== FALSE)
                {
                    $filasError[$fila]['REFERENCIA'] = "VALOR REPETIDO-FILA ".$filaRepetida;
                    $ejecutarInsert = false;
                }
                
                $arrayElementos[$fila] = $referencia;
                
            }
        }

        fclose($handle);

        if(!$ejecutarInsert)
        {
            $raiz = 'public/';
            $nombre = 'error.txt';
            $file = 'public/error.txt';
            
            if (file_exists($file)) {
                unlink($file);
            }
            
            $txt= fopen($file, 'a') or die ('Problemas al crear el archivo');
            #  Se establecen los datos que va a conterner el archivo
            foreach($filasError as $key=>$value)
            {
                fwrite($txt, "FILA: ".$key."\n");
                foreach($value as $celda=>$error)
                {
                    fwrite($txt, $celda.": ".$error."\n");
                }
            }
            #  Se hace el ciere para no sobre escribir datos 
            fclose($txt);

            $message = sprintf($this->mensajeError->msg201, "Se detectaron diversas inconsistencias.");
            $salida1 = $this->alertas->alertaError($message);
            $salida2 = $this->alertas->descargaArchivoTXT($nombre);
			echo $salida1.$salida2;
			//echo $salida1;
            
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y EJECUTAR INSERTS
        * ----------------------------
        */
            
        //Declaramos variables
        $arrayAsignacionInsert = array();
        $arrayAsignacionDetalleInsert = array();
        $filainsert = 0;
        //Abrimos el archivo
        $handleInsert = fopen($csv, "r");
        $arrayAsig = array();
        $arrayDetalleAsig = array();
        
        //Recorremos las filas del CSV
        while (($data = fgetcsv($handleInsert, 0, $separadorCSV)) !== FALSE)
        {
            $data = array_map("utf8_encode", $data);
            $filainsert++;
            if($filainsert > 1)
            {
                $a = trim($data[3]);
                //Asignamos valores de CSV a variables locales
                $tipo = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $referencia = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                $usuario = trim($data[2]," \t\n\r\0\x0B\xc2\xa0");
                $tipoAsignado = trim($data[3]," \t\n\r\0\x0B\xc2\xa0");
                $obsAsignado = trim($data[4]," \t\n\r\0\x0B\xc2\xa0");
                $fechaAsignado = trim($data[5]," \t\n\r\0\x0B\xc2\xa0");
                $obsElemento = trim($data[6]," \t\n\r\0\x0B\xc2\xa0");
                
                if(!array_key_exists($usuario, $arrayAsig)) 
                {
                    $arrayAsig[$usuario] = array(
                        "TIPO"          => $tipoAsignado,
                        "OBSERVACION"   => $obsAsignado,
                        "FECHA"         => $fechaAsignado);
                }
                
                $arrayDetalleAsig[$usuario][] = array(
                    "TIPOELEMENTO"  => $tipo,
                    "ELEMENTO"      => $referencia,
                    "OBSERVACION"   => $obsElemento);
                
                
            }
        }

        fclose($handleInsert);
        
        $arrayInsertAsign=array();
        
        foreach($arrayAsig as $usuario => $valor)
        {
            
            $datosAsignado = $this->usuarios->buscarUsuarioXusuario($usuario);
            $tokenAsignacion = $this->complementos->generar_string_aleatorio(15);
    
            $dataAsignacion = array (
                'UsuarioAsignado'       => $datosAsignado['IdUsuario'], 
                'CargoAsignado'         => $datosAsignado['Cargo'], 
                'AreaAsignado'          => $datosAsignado['IdArea'], 
                'DepartamentoAsignado'  => $datosAsignado['IdDpto'], 
                'FechaAsignado'         => $valor['FECHA'], 
                'TipoAsignado'          => $valor['TIPO'], 
                'Observacion'           => $valor['OBSERVACION'], 
                'UsuarioRemitente'      => $this->items['id'], 
                'CargoRemitente'        => $this->items['cargo'], 
                'AreaRemitente'         => $this->items['idArea'], 
                'DepartamentoRemitente' => $this->items['dpto'], 
                'TokenLinkFirma'        => $tokenAsignacion,
                'LiberadoFirma'         => 'Y',
                'UsuarioCrea'           => $this->items['id'],
                'FechaCrea'             => $fechaActual,    
                'Localhost'             => $this->request->getIPAddress()
            );
    
            $lastIdAsignacion = $this->asignaciones->insert($dataAsignacion, TRUE);
            
            if($lastIdAsignacion !== FALSE){
                $arrayInsertAsign[] = $lastIdAsignacion;
                
                $dataDetalle = array();
                
                foreach($arrayDetalleAsig[$usuario] as $detalle)
                {
                    $totalReposicion = 0;
        
                    if($detalle['TIPOELEMENTO'] == "LINEA")
                    {
                        $infolinea = $this->lineas->where("Numero", trim($detalle['ELEMENTO']))->first();
                        $elemento = $infolinea['IDLinea'];
                        $totalReposicion = 1;
                    }
                    else if($detalle['TIPOELEMENTO'] == "MOVIL")
                    {
                        $infomovil = $datosImei = $this->moviles->where('IMEI', trim($detalle['ELEMENTO']))->first();
                        $elemento = $infomovil['IDMovil'];
                        $contrato = $this->contratos->obtenerContratosXEquipo($infomovil['IDMovil']);
                        $montoTotal = $this->complementos->calculoPenalidadMovil($contrato);
            
                        $totalReposicion = $montoTotal;
                    }
                    
                    $dataDetalle[] = array (
                        'IDAsignacion'      => $lastIdAsignacion, 
                        'TipoElemento'      => $detalle['TIPOELEMENTO'],  
                        'IDElemento'        => $elemento, 
                        'Observacion'       => $detalle['OBSERVACION'], 
                        'MontoReposicion'   => $totalReposicion, 
                        'UsuarioCrea'       => $this->items['id'],
                        'FechaCrea'         => $fechaActual,    
                        'Localhost'         => $this->request->getIPAddress()
                    );
                }
                $lastId = $this->detalleasignaciones->insertBatch($dataDetalle);
                
        		if($lastId !== FALSE){
                    
                    /*
                    * ----------------------------
                    * PREPARACIÓN DE CUERPO DE CORREO
                    * ----------------------------
                    */
        
                    $arrayCuerpo = array(
                        "TITULO" => "ACTA DE ASIGNACIÓN",
                        "ACTA" => "ACTA DE ASIGNACIÓN",
                        "USUARIO" => ucwords(mb_strtolower($datosAsignado['Nombres'].' '.$datosAsignado['Apellidos'])),
                        "URL_ACTA" => base_url()."/acta-asignacion/".$lastIdAsignacion."/".$tokenAsignacion
                    );
        
                    $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActas($arrayCuerpo);
                    
                    /*
                    * ----------------------------
                    * PREPARACIÓN DE PARAMETROS PARA EL CORREO
                    * ----------------------------
                    */
        
                    $asunto='ACTA DE ASIGNACIÓN: '.$lastIdAsignacion.' - '.$datosAsignado['Nombres'].' '.$datosAsignado['Apellidos'];
                    //$correoDestino = array($asignado['Correo']);
                    $configCorreo = array(
                        "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
                        "CORREO_ORIGEN" => $this->items['correoElectronico'],
                        "CORREOS_DESTINOS" => array($this->items['correoElectronico']),
                        "CORREOS_COPIA" => array("josejesus.cuadros@verisure.pe"),
                        "CORREOS_OCULTO" => array(),
                        "ASUNTO" => $asunto,
                        "MENSAJE" => $cuerpo
                    );
        
                    $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);
        
                    $dataCorreo = array(
                        "IDAsignacion"  => $lastIdAsignacion,
                        "Response"      => $estadoCorreo['RESPUESTA'],
                        "Error"         => $estadoCorreo['ERROR'],
                        'UsuarioCrea'   => $this->items['id'],
                        'FechaCrea'     => $fechaActual,    
                        'Localhost'     => $this->request->getIPAddress()
                    );
        
                    $this->correoStatusAsignacion->insert($dataCorreo, TRUE);
                    
        		}
        		else
                {
                    $this->detalleasignaciones->whereIn('IDAsignacion', $arrayInsertAsign)->delete();
                    $this->asignaciones->whereIn('IDAsignacion', $arrayInsertAsign)->delete();
                    $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar la asignación. Inténtelo luego.</li>");
                    echo $this->alertas->alertaError($message);
                    EXIT;
                }
            }
            else
            {
                $this->detalleasignaciones->whereIn('IDAsignacion', $arrayInsertAsign)->delete();
                $this->asignaciones->whereIn('IDAsignacion', $arrayInsertAsign)->delete();
                $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar la asignación. Inténtelo luego.</li>");
                echo $this->alertas->alertaError($message);
                EXIT;
            }
                
        }

        $message = sprintf($this->mensajeError->msg201, "Se insertaron el total de ".count($arrayAsig)." asignaciones.");
        echo $this->alertas->alertaExito($message);
        echo $this->alertas->refrescar(1);

    }
	
    public function adjuntarDocumentoAsignacion($idAsignacion)
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $nombre = $this->request->getPost('txtNombreAdjunto_i');
        $observacion = $this->request->getPost('txtObservacionAdjunto_i');
        $reemplazafirma = $this->request->getPost('chkAdjuntoFirma');
        $adjunto = $this->request->getFile("fileAdjuntoAsignacion");

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($nombre, 'required|trim|minlength[9]|maxlength[15]', 'Nombre');
        $error .= $this->complementos->validaCampo($observacion, 'trim', 'Observación');
        

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $adjunto->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $adjunto->getErrorString().'-'.$adjunto->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'fileAdjuntoAsignacion' => [
                'mime_in[fileAdjuntoAsignacion,image/png,image/jpg,image/jpeg,image/gif,application/pdf]',
                'ext_in[fileAdjuntoAsignacion,pdf]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        if($adjunto->guessExtension() != null)
        {
            $extensionDoc = $adjunto->guessExtension();
        }
        else
        {
            $nombre_original = $adjunto->getBasename();
            $fileNameCmps = explode(".", $nombre_original);
            $extensionDoc = strtolower(end($fileNameCmps));
        }
        
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */

        $data = array (
            'IDAsignacion'      => $idAsignacion, 
            'Nombre'            => $nombre, 
            'Extension'         => $extensionDoc,
            'Observacion'       => $observacion,
            'ReemplazoFirma'    => ((isset($reemplazafirma) && $reemplazafirma != null) ? 'Y' : 'N'),  
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->asignacionesAdjuntos->insert($data, TRUE);

		if($lastId === FALSE){
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
			exit;
		}

        /*
        * ----------------------------
        * GUARDAR ARCHIVO ADJUNTO
        * ----------------------------
        */
        $ruta = "public/docs/ActaAsignacion/";
        $nombreArchivo = $idAsignacion."-".$lastId;

        if(!file_exists($ruta))
        {
            @mkdir($ruta, 0777, true);
        }

		# si exsite la carpeta o se ha creado
		if (file_exists($ruta) || @mkdir($ruta)) 
        {
            $nuevonombre = $nombreArchivo.'.'.$extensionDoc;
            
            $estadoMove = $adjunto->move($ruta, $nuevonombre);
            
            if (!$estadoMove) {
                $this->asignacionesAdjuntos->delete(["IDAdjuntoAsignacion", $lastId]);
                $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[SAVEDOC]");
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
            echo $this->alertas->alertaError($message);
        }
        
        $message = sprintf($this->mensajeError->msg201, "El archivo adjunto fue registrado exitosamente.");
        echo $this->alertas->alertaExito($message);
        echo $this->alertas->refrescar(1);
    }
    
    public function obtenerElementosAsignacion()
    {
        /*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        
        $post = $this->request->getPost('term');
        //var_dump($this->request->getPost());exit;
        $elementos=array();

        if($post['elemento'] == 'MOVIL')
        {
            $listado = $this->moviles->listarMovilesDisponibles($post['term']);

            foreach ($listado as $items) {
                $elementos[] = array(
                    'id' => (string) $items['IDMovil'],
                    'text' => (string) $items['IMEI']." | ".$items['Marca']." ".$items['Modelo']
                );
            }
            
        }
        else if($post['elemento'] == 'LINEA')
        {
            $listado = $this->lineas->listarLineasDisponibles($post['term']);

            foreach ($listado as $items) {
                $elementos[] = array(
                    'id' => (string) $items['IDLinea'],
                    'text' => (string) $items['Numero']." | ".$items['Operador']." ".$items['Plan']
                );
            }
        }
        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($elementos);		
    }
	
    public function obtenerMontoReposicion()
    {
        $idItem = $this->request->getPost('idItem');
        $elemento = $this->request->getPost('elemento');
        /*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        $totalReposicion = 0;

        if($elemento == "LINEA")
        {
            $totalReposicion = 1;
        }
        else if($elemento == "MOVIL")
        {
            $contrato = $this->contratos->obtenerContratosXEquipo($idItem);
            $montoTotal = $this->complementos->calculoPenalidadMovil($contrato);

            $totalReposicion = $montoTotal;
        }
        
        $resultado = array(
            'reposicion' => (string) $totalReposicion
        );
        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado);
    }

    public function listadoUsuariosSelect()
    {
        $elemento = $this->request->getPost('term');
        
        $listado = $this->usuarios->listadoUsuariosSelect($elemento['term']);

        $elementos=array();

        foreach ($listado as $items) {
            $elementos[] = array(
                'id' => (string) $items['IdUsuario'],
                'text' => (string) $items['Matricula']." | ".$items['Nombres']." ".$items['Apellidos']
            );
        }

        echo json_encode($elementos);
    }

    public function guardarAsignacion()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $asignado = $this->request->getPost('txtAsignado');
        $fechaasignado = $this->request->getPost('txtFechaAsignado');
        $tipoasignado = $this->request->getPost('txtTipoAsignado');
        $remitente = $this->request->getPost('txtRemitenteAsignacion');
        $observacion = $this->request->getPost('txtObservacion');
        
        $elementoDetalle = $this->request->getPost('elemento');
        $itemDetalle = $this->request->getPost('item');
        $observacionDetalle = $this->request->getPost('obselemento');
        $reposicionDetalle = $this->request->getPost('reposicion');
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        $error = '';
        $error .= $this->complementos->validaCampo($asignado, 'required|trim', 'Usuario asignado');
        $error .= $this->complementos->validaCampo($fechaasignado, 'required|dateDos', 'Fecha de asignación');
        $error .= $this->complementos->validaCampo($tipoasignado, 'required|alphabet|trim', 'Tipo de asignación');
        $error .= $this->complementos->validaCampo($remitente, 'required|trim', 'Usuario remitente');
        
        if(count($elementoDetalle)==0 || count($itemDetalle)==0)
        {
            $error .= "<li>Debe registrar un item en la asignación.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
    
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        foreach($elementoDetalle as $key=>$detalle)
        {
            $itemAsignado = $this->detalleasignaciones->validarElementoAsignado($detalle, $itemDetalle[$key]);
            if(count($itemAsignado)>0)
            {
                $msgExistencia .= "<li>El ".$etiquetaitem[$key]." ya fue asignado.</li>";
            }
        }
		
        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
       */
        $datosAsignado = $this->usuarios->buscarUsuario($asignado);
        $tokenAsignacion = $this->complementos->generar_string_aleatorio(15);

        $dataAsignacion = array (
            'UsuarioAsignado'       => $asignado, 
            'CargoAsignado'         => $datosAsignado['Cargo'], 
            'AreaAsignado'          => $datosAsignado['IdArea'], 
            'DepartamentoAsignado'  => $datosAsignado['IdDpto'], 
            'FechaAsignado'         => $fechaasignado, 
            'TipoAsignado'          => $tipoasignado, 
            'Observacion'           => $observacion, 
            'UsuarioRemitente'      => $remitente, 
            'CargoRemitente'        => $this->items['cargo'], 
            'AreaRemitente'         => $this->items['idArea'], 
            'DepartamentoRemitente' => $this->items['dpto'], 
            'TokenLinkFirma'        => $tokenAsignacion,
            'LiberadoFirma'         => 'Y',
            'UsuarioCrea'           => $this->items['id'],
            'FechaCrea'             => $fechaActual,    
            'Localhost'             => $this->request->getIPAddress()
        );

        $lastIdAsignacion = $this->asignaciones->insert($dataAsignacion, TRUE);
        
        if($lastIdAsignacion !== FALSE){
            $idAsignacion = $lastIdAsignacion;
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar la asignación. Inténtelo luego.</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
        }
            
        $dataDetalle = array();

        foreach($elementoDetalle as $key=>$detalle)
        {
            $dataDetalle[] = array (
                'IDAsignacion'      => $idAsignacion, 
                'TipoElemento'      => $detalle,  
                'IDElemento'        => $itemDetalle[$key], 
                'Observacion'       => $observacionDetalle[$key], 
                'MontoReposicion'   => $reposicionDetalle[$key], 
                'UsuarioCrea'       => $this->items['id'],
                'FechaCrea'         => $fechaActual,    
                'Localhost'         => $this->request->getIPAddress()
            );
        }
        $lastId = $this->detalleasignaciones->insertBatch($dataDetalle);
        
		if($lastId !== FALSE){
            
            /*
            * ----------------------------
            * PREPARACIÓN DE CUERPO DE CORREO
            * ----------------------------
            */

            $arrayCuerpo = array(
                "TITULO" => "ACTA DE ASIGNACIÓN",
                "ACTA" => "ACTA DE ASIGNACIÓN",
                "USUARIO" => ucwords(mb_strtolower($datosAsignado['Nombres'].' '.$datosAsignado['Apellidos'])),
                "URL_ACTA" => base_url()."/acta-asignacion/".$idAsignacion."/".$tokenAsignacion
            );

            $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActas($arrayCuerpo);
            
            /*
            * ----------------------------
            * PREPARACIÓN DE PARAMETROS PARA EL CORREO
            * ----------------------------
            */

            $asunto='ACTA DE ASIGNACIÓN: '.$idAsignacion.' - '.$datosAsignado['Nombres'].' '.$datosAsignado['Apellidos'];
            //$correoDestino = array($asignado['Correo']);
            $configCorreo = array(
                "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
                "CORREO_ORIGEN" => $this->items['correoElectronico'],
                "CORREOS_DESTINOS" => array($this->items['correoElectronico']),
                "CORREOS_COPIA" => array("josejesus.cuadros@verisure.pe"),
                "CORREOS_OCULTO" => array(),
                "ASUNTO" => $asunto,
                "MENSAJE" => $cuerpo
            );

            $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);

            $dataCorreo = array(
                "IDAsignacion"  => $idAsignacion,
                "Response"      => $estadoCorreo['RESPUESTA'],
                "Error"         => $estadoCorreo['ERROR'],
                'UsuarioCrea'   => $this->items['id'],
                'FechaCrea'     => $fechaActual,    
                'Localhost'     => $this->request->getIPAddress()
            );

            $this->correoStatusAsignacion->insert($dataCorreo, TRUE);
            
			$message = sprintf($this->mensajeError->msg502, $idAsignacion);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->reDireccion(base_url()."/documento-asignado/".$idAsignacion, 1);
		} 
    }

    public function enviarCorreoAsignacion()
    {
        $fechaActual = date("Y-m-d H:i:s");

        $idAsignacion = $this->request->getPost('idAsignacion');
        $asignacion = $this->asignaciones->where("IDAsignacion", $idAsignacion)->first();
        $asignado = $this->usuarios->buscarUsuario($asignacion['UsuarioAsignado']);
        
		/*
        * ----------------------------
        * PREPARACIÓN DE CUERPO DE CORREO
        * ----------------------------
		*/

        $arrayCuerpo = array(
            "TITULO" => "ACTA DE ASIGNACIÓN",
            "ACTA" => "ACTA DE ASIGNACIÓN",
            "USUARIO" => ucwords(mb_strtolower($asignado['Nombres'].' '.$asignado['Apellidos'])),
            "URL_ACTA" => base_url()."/acta-asignacion/".$idAsignacion."/".$asignacion['TokenLinkFirma']
        );

        $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActas($arrayCuerpo);
        
		/*
        * ----------------------------
        * PREPARACIÓN DE PARAMETROS PARA EL CORREO
        * ----------------------------
		*/

        $asunto='ACTA DE ASIGNACIÓN: '.$idAsignacion.' - '.$asignado['Nombres'].' '.$asignado['Apellidos'];
        //$correoDestino = array($asignado['Correo']);
        $configCorreo = array(
            "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
            "CORREO_ORIGEN" => $this->items['correoElectronico'],
            "CORREOS_DESTINOS" => array($this->items['correoElectronico']),
            "CORREOS_COPIA" => array("josejesus.cuadros@verisure.pe"),
            "CORREOS_OCULTO" => array(),
            "ASUNTO" => $asunto,
            "MENSAJE" => $cuerpo
        );

        $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);

        $dataCorreo = array(
            "IDAsignacion"  => $idAsignacion,
            "Response"      => $estadoCorreo['RESPUESTA'],
            "Error"         => $estadoCorreo['ERROR'],
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $this->correoStatusAsignacion->insert($dataCorreo, TRUE);

        if($estadoCorreo['ERROR'] != '')
        {
            $message = sprintf($this->mensajeError->msg201, "No se pudo enviar el correo. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "Se envió el correo correctamente.");
            echo $this->alertas->alertaExito($message);
        }
        
    }

    public function actaReposicion($idReposicion, $token)
    {
        $reposicion = $this->reposiciones->where("IDReposicion", $idReposicion)->first();

        $whereFirma = array(
            "IDReposicion"  => $idReposicion,
            "Firma"         => "Y"
        );
        $firmaReposicion = $this->reposicionesAdjuntos->where($whereFirma)->first();

        if($token == $reposicion['TokenLinkFirma'])
        {
			/* ACCIONES */
            $remitente = $this->usuarios->where("IdUsuario ", $reposicion['UsuarioCrea'])->first();
            $adjudicado = $this->usuarios->buscarUsuario($reposicion['UsuarioAdjudicado']);

            $depaReposicion = $this->bm_departamento->where("IdDpto", $reposicion['DepartamentoAdjudicado'])->first();
            $areaReposicion = $this->bm_area->where("IdArea", $reposicion['DepartamentoAdjudicado'])->first();
            
            $reposicion['NombreRemitente'] = strtoupper($remitente['Nombres'].' '.$remitente['Apellidos']);
            $reposicion['NombreAdjudicado'] = $adjudicado['Nombres'];
            $reposicion['ApellidosAdjudicado'] = $adjudicado['Apellidos'];
            $reposicion['DocumentoAdjudicado'] = $adjudicado['NumeroDoc'];
            $reposicion['GerenciaAdjudicado'] = $depaReposicion['NombreDpto'];
            $reposicion['AreaAdjudicado'] = $areaReposicion['NombreArea'];
            $reposicion['MatriculaAdjudicado'] = $adjudicado['Matricula'];
            $reposicion['FechaAdjudicado'] = "Lima, ".date('d', strtotime($reposicion['FechaCrea']))." de ".$this->complementos->parseoMes(date('m', strtotime($reposicion['FechaCrea'])))." de ".date('Y', strtotime($reposicion['FechaCrea']));

			$detalleReposicion = $this->reposicionesDetalle->listarDetalleReposicion($idReposicion);
            
            foreach($detalleReposicion as $key=>$value)
            {
                //Obtener elemento
                if($value['TipoElemento']=='MOVIL')
                {
                    $dataElemento = $this->moviles->obtenerMovil($value['IDElemento']);
                    $detalleReposicion[$key]['ELEMENTO'] = $dataElemento['Marca'].' '.$dataElemento['Modelo'].' '.$dataElemento['IMEI'];
                }
                else if($value['TipoElemento']=='LINEA')
                {
                    $dataElemento = $this->lineas->obtenerLinea($value['IDElemento']);
                    $detalleReposicion[$key]['TipoElemento'] = $value['TipoElemento'].' - '.$dataElemento['Numero'];
                    $detalleReposicion[$key]['ELEMENTO'] = $dataElemento['Operador'].' '.$dataElemento['Plan'].' '.$dataElemento['ICCID'];
                }
                else
                {
                    $informacionElemento = "SIN INFORMACIÓN";
                }
                
            }

            $cronograma = $this->reposicionesCronogramaPago->where("IDReposicion", $idReposicion)->findAll();

            foreach($cronograma as $key=>$value)
            {
                $cronograma[$key]['MesDescontado'] = $this->complementos->parseoMes($value['MesCuota'], FALSE);
            }

			$data = array (
				'titulo'                => 'Reposiciones | Verisure',
                'idReposicion'          => $idReposicion,
				'reposicion'            => $reposicion,
                'cronograma'            => $cronograma,
                'detalle'               => $detalleReposicion,
                'firmaReposicion'       => $firmaReposicion
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/reposiciones/acta_reposicion',$data);	
        }
        else
        {
            return view('errors/500');
        }
    }

    public function subirFirmaActaReposicion()
    {
        $fechaActual = date("Y-m-d H:i:s");

        $idReposicion = $this->request->getPost("txtIDReposicion");
        $canvasFirma = $this->request->getPost("firmaActaReposicion");
        
        $adjunto = $this->request->getFile("fileFotoDNI");
        
        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $adjunto->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $adjunto->getErrorString().'-'.$adjunto->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'fileFotoDNI' => [
                'mime_in[fileFotoDNI,image/png,image/jpg,image/jpeg,image/gif,application/pdf]',
                'ext_in[fileFotoDNI,png,jpg,jpeg,gif,pdf]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        if($adjunto->guessExtension() != null)
        {
            $extensionDoc = $adjunto->guessExtension();
        }
        else
        {
            $nombre_original = $adjunto->getBasename();
            $fileNameCmps = explode(".", $nombre_original);
            $extensionDoc = strtolower(end($fileNameCmps));
        }

        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */

        $reposicion = $this->reposiciones->where("IDReposicion", $idReposicion)->first();

        $data = array (
            'IDReposicion'      => $idReposicion, 
            'Nombre'            => "DOCUMENTO DE IDENTIDAD", 
            'Extension'         => $extensionDoc,
            'Observacion'       => "DOCUMENTO DE IDENTIDAD ADJUNTADO EN LA FIRMA.",
            'ReemplazoFirma'    => 'N',  
            'UsuarioCrea'       => $reposicion['UsuarioAdjudicado'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->reposicionesAdjuntos->insert($data, TRUE);

		if($lastId === FALSE){
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
			exit;
		}

        /*
        * ----------------------------
        * GUARDAR ARCHIVO ADJUNTO
        * ----------------------------
        */
        $ruta = "public/docs/ActaReposicion/";
        $nombreArchivo = $idReposicion."-".$lastId;

        if(!file_exists($ruta))
        {
            @mkdir($ruta, 0777, true);
        }

		# si exsite la carpeta o se ha creado
		if (file_exists($ruta) || @mkdir($ruta)) 
        {
            $nuevonombre = $nombreArchivo.'.'.$extensionDoc;
            
            $estadoMove = $adjunto->move($ruta, $nuevonombre);
            
            if (!$estadoMove) {
                $this->reposicionesAdjuntos->delete(["IDAdjuntoReposicion", $lastId]);
                $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[SAVEDOC]");
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        else
        {
            $this->reposicionesAdjuntos->delete(["IDAdjuntoReposicion", $lastId]);
            $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
            echo $this->alertas->alertaError($message);
        }
        
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */

        $dataFirma = array (
            'IDReposicion'      => $idReposicion, 
            'Nombre'            => "FIRMA", 
            'Extension'         => "png",
            'Observacion'       => "FIRMA DE USUARIO DE REPOSICIÓN.",
            'ReemplazoFirma'    => 'N',  
            'Firma'             => 'Y',  
            'UsuarioCrea'       => $reposicion['UsuarioAdjudicado'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastIdFirma = $this->reposicionesAdjuntos->insert($dataFirma, TRUE);

		if($lastIdFirma === FALSE){
            unlink($ruta.$nombreArchivo.'.'.$extensionDoc);
            $this->reposicionesAdjuntos->delete(["IDAdjuntoReposicion", $lastId]);
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la firma. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
			exit;
		}

        /*
        * ----------------------------
        * GUARDAR FIRMA
        * ----------------------------
        */

        $nombreArchivoFirma = $idReposicion."-".$lastIdFirma;

        if(!file_exists($ruta))
        {
            @mkdir($ruta, 0777, true);
        }

		# si exsite la carpeta o se ha creado
		if (file_exists($ruta) || @mkdir($ruta)) 
        {
            $nuevonombreFirma = $nombreArchivoFirma.'.png';
            
            $datos = base64_decode(
                preg_replace('/^[^,]*,/', '', $canvasFirma)
            );

            $estadoFirma = file_put_contents($ruta.$nuevonombreFirma, $datos);
            
            if ($estadoFirma===FALSE) {
                unlink($ruta.$nombreArchivo.'.'.$extensionDoc);
                $this->reposicionesAdjuntos->delete(["IDAdjuntoReposicion", $lastId]);
                $this->reposicionesAdjuntos->delete(["IDAdjuntoReposicion", $lastIdFirma]);
                $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la firma. Inténtelo luego.[SAVEDOC]");
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        else
        {
            unlink($ruta.$nombreArchivo.'.'.$extensionDoc);
            $this->reposicionesAdjuntos->delete(["IDAdjuntoReposicion", $lastId]);
            $this->reposicionesAdjuntos->delete(["IDAdjuntoReposicion", $lastIdFirma]);
            $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
            echo $this->alertas->alertaError($message);
        }
        
        /*
        * ----------------------------
        * PREPARACIÓN DE CUERPO DE CORREO
        * ----------------------------
        */
        
        $usuarioRemitente = $this->usuarios->where("IdUsuario", $reposicion['UsuarioCrea'])->first();
        
        $usuarioAdjudicado = $this->usuarios->where("IdUsuario", $reposicion['UsuarioAdjudicado'])->first();
        
        $arrayCuerpo = array(
            "TITULO" => "FIRMA DE ACTA DE REPOSICIÓN",
            "ACTA" => "ACTA DE REPOSICIÓN",
            "USUARIO" => ucwords(mb_strtolower($usuarioRemitente['Nombres'].' '.$usuarioRemitente['Apellidos'])),
            "CODIGO" => $reposicion['IDReposicion']
        );

        $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActasConfirmacion($arrayCuerpo);
        
        /*
        * ----------------------------
        * PREPARACIÓN DE PARAMETROS PARA EL CORREO
        * ----------------------------
        */

        $asunto='FIRMA DE ACTA DE REPOSICIÓN: '.$reposicion['IDReposicion'].' - '.$usuarioAdjudicado['Nombres'].' '.$usuarioAdjudicado['Apellidos'];
        //$correoDestino = array($asignado['Correo']);
        $configCorreo = array(
            "NOMBRE_ORIGEN" => $usuarioAdjudicado['Nombres'].' '.$usuarioAdjudicado['Apellidos'],
            "CORREO_ORIGEN" => $usuarioAdjudicado['Correo'],
            "CORREOS_DESTINOS" => array($usuarioRemitente['Correo']),
            "CORREOS_COPIA" => array("soporteti@verisure.pe"),
            "CORREOS_OCULTO" => array(),
            "ASUNTO" => $asunto,
            "MENSAJE" => $cuerpo
        );

        $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);

        $dataCorreo = array(
            "IDReposicion"  => $reposicion['IDReposicion'],
            "Response"      => $estadoCorreo['RESPUESTA'],
            "Error"         => $estadoCorreo['ERROR'],
            'UsuarioCrea'   => $reposicion['UsuarioAdjudicado'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $this->correoStatusReposicion->insert($dataCorreo, TRUE);

        $message = sprintf($this->mensajeError->msg201, "La firma fue registrada exitosamente.");
        echo $this->alertas->alertaExito($message);
        echo $this->alertas->refrescar(1);
    }

    public function listarReposiciones(){
		if(isset($this->items['id'])){

			/* ACCIONES */

			if($this->items['idPerfil'] == 3)
			{
			    $cccordinador = $this->globales->listadoCentroCostoCoordinador();
			
			    if(array_key_exists($this->items['id'], $cccordinador))
			    {
			        $centroscosto = $cccordinador[$this->items['id']];
			        $listadoReposicion = $this->reposiciones->listarReposiciones($centroscosto);
			    }
			    else
			    {
			        $listadoReposicion = array();
			    }
			    
			}
			else
			{
			    $centroscosto = array();
			    $listadoReposicion = $this->reposiciones->listarReposiciones($centroscosto);
			}
            
            foreach($listadoReposicion as $key=>$item)
            {
                /*$adjudicado = $this->usuarios->where("IdUsuario ", $item['UsuarioAdjudicado'])->first();
                $listadoReposicion[$key]['NombreAdjudicado'] = $adjudicado['Nombres'].' '.$adjudicado['Apellidos'];
                $listadoReposicion[$key]['MatriculaAdjudicado'] = $adjudicado['Matricula'];*/
                
                $detalleReposicion = $this->reposicionesDetalle->listarDetalleReposicion($item['IDReposicion']);
                $montosTrabajador = array_sum(array_column($detalleReposicion, 'TotalTrabajador'));

                $listadoReposicion[$key]['TotalDescuentoTrabajador'] = $montosTrabajador;
                $listadoReposicion[$key]['TotalElementos'] = (empty($detalleReposicion) ? 0 : count($detalleReposicion));
            }
            
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Actas de Reposición | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Actas de Reposición',
				'listaReposiciones'     => $listadoReposicion
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/reposiciones/listar_reposiciones',$data);			
		} else {
			return view('errors/500');
		}
	}

    public function nuevaReposicion()
    {
        if(isset($this->items['id'])){

			/* ACCIONES */
			$listaUsuariosRemitente = $this->usuarios->where(array("CC"=>930, "Estado"=>"Activo"))->findAll();

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Nueva Reposición | Verisure',
                'previo'                => 'listar-reposiciones',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Nueva reposición',
				'listaUsuariosRemitente'=> $listaUsuariosRemitente
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/reposiciones/nueva_reposicion',$data);			
		} else {
			return view('errors/500');
		}
    }

	public function listadoItemsAsignados() {

		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idUsuario = $this->request->getPost('idUsuario');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idUsuario, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$listadoItems = $this->detalleasignaciones->listarDetalleAsignadosUsuario($idUsuario);
        $items = array();

        if (!empty($listadoItems)) {
            foreach($listadoItems as $value)
            {
                //Obtener elemento
                if($value['TipoElemento']=='MOVIL')
                {
                    $dataElemento = $this->moviles->obtenerMovil($value['IDElemento']);
                    $elemento = $value['TipoElemento'].' | '.$dataElemento['IMEI'].' '.$dataElemento['Marca'].' '.$dataElemento['Modelo'];
                }
                else if($value['TipoElemento']=='LINEA')
                {
                    $dataElemento = $this->lineas->obtenerLinea($value['IDElemento']);
                    $elemento = $value['TipoElemento'].' | '.$dataElemento['Numero'].' '.$dataElemento['Operador'].' '.$dataElemento['Plan'].' '.$dataElemento['ICCID'];
                }
                else
                {
                    $elemento = '';
                }
                //var_dump($items);
            
                $items[] = array(
					'id' => (string) $value['IDDetalleAsignacion'],
         	        'item' => (string) $elemento
                );
            }

            
            $resultado = array(
				'listadoItems' => json_encode($items)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}

    public function obtenerMontoDescuentoReposicion()
    {
        $idDetalleAsignacion = $this->request->getPost('idDetalleAsignacion');
		$idUsuario = $this->request->getPost('idUsuario');
        $situacion = $this->request->getPost('situacion');
        /*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        $detalle = $this->detalleasignaciones->obtenerDetalleAsignacion($idDetalleAsignacion);

        $totalDescuento = 0;
        $totalVerisure = 0;
        $totalTrabajador = 0;
        if($detalle['TipoElemento']=="LINEA")
        {
            $totalDescuento = 1;
            $totalVerisure = 0;
            $totalTrabajador = 1;
        }
        else if($detalle['TipoElemento']=="MOVIL")
        {
            $contrato = $this->contratos->obtenerContratosXEquipo($detalle['IDElemento']);
            $montoTotal = $this->complementos->calculoPenalidadMovil($contrato);
            $cantidadRobo = $this->detalleasignaciones->obtenerMovilesRobadosUsuario($idUsuario);
            $porcentajes = $this->complementos->calculoPorcentajeResponsabilidadMovil(count($cantidadRobo), $montoTotal, $situacion);

            $totalDescuento = $montoTotal;
            $totalVerisure = $porcentajes['VERISURE'];
            $totalTrabajador = $porcentajes['TRABAJADOR'];
        }
        else
        {
            $totalDescuento = "SIN INFORMACIÓN";
            $totalVerisure = "SIN INFORMACIÓN";
            $totalTrabajador = "SIN INFORMACIÓN";
        }
        
        $resultado = array(
            'total' => (string) $totalDescuento,
            'verisure' => (string) $totalVerisure,
            'trabajador' => (string) $totalTrabajador
        );
        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado);		
    }

    public function registrarReposicion()
    {
        $fechaActual = date("Y-m-d H:i:s");
        $fechaActualAdd = date("Y-m-d H:i:s", strtotime($fechaActual)+1);
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        

        $msjError = TRUE;
        $adjudicado = $this->request->getPost('txtAdjudicadoReposicion');
        $motivo = $this->request->getPost('txtMotivoReposicion');
        $cuotas = $this->request->getPost('txtCuotasReposicion');
        $observacion = $this->request->getPost('txtObservacion');
        
        $itemDetalle = $this->request->getPost('itemReposicion');
        $etiquetaitem = $this->request->getPost('etiquetaitem');
        $totalDescuento = $this->request->getPost('totalDescuento');
        $totalVerisure = $this->request->getPost('totalVerisure');
        $totalTrabajador = $this->request->getPost('totalTrabajador');
        $obsDetalle = $this->request->getPost('obselemento');

        $adjunto = $this->request->getFile("fileAdjuntoReposicion");
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        $error = '';
        $error .= $this->complementos->validaCampo($adjudicado, 'required|trim', 'Usuario adjudicado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim|minlength[3]|maxlength[3]', 'Motivo');
        $error .= $this->complementos->validaCampo($cuotas, 'required|trim|minlength[1]|maxlength[1]', 'Cuotas');
        
        if(empty($itemDetalle))
        {
            $error .= "<li>Debe registrar un item en la reposición.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        if($motivo == 'ROB' || $motivo == 'PER')
        {
            /*
            * ----------------------------
            * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
            * ----------------------------
            */
            
            if (! $adjunto->isValid()) {
                $message = sprintf($this->mensajeError->msg201, $adjunto->getErrorString().'-'.$adjunto->getError());
                echo $this->alertas->alertaError($message);
                exit;
            }
            
            /*
            * ----------------------------
            * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
            * ----------------------------
            */
            
            $validationRule = [
                'fileAdjuntoReposicion' => [
                    'mime_in[fileAdjuntoReposicion,image/png,image/jpg,image/jpeg,image/gif,application/pdf]',
                    'ext_in[fileAdjuntoReposicion,pdf]'
                ],
            ];

            if (! $this->validate($validationRule)) {
                $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        foreach($itemDetalle as $detalle)
        {
            $itemRepuesto = $this->reposicionesDetalle->where("IDDetalleAsignacion", $detalle)->findAll();

            if(!empty($itemRepuesto))
            {
                $msgExistencia .= "<li>El ".$etiquetaitem[$detalle]." ya fue repuesto.</li>";
            }
        }
		
        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * INSERCIÓN DE DATOS REPOSICIÓN
        * ----------------------------
        */

        $datosAdjudicado = $this->usuarios->buscarUsuario($adjudicado);
        $tokenReposicion = $this->complementos->generar_string_aleatorio(15);

        $dataReposicion = array (
            'UsuarioAdjudicado'         => $adjudicado, 
            'CargoAdjudicado'           => $datosAdjudicado['Cargo'], 
            'AreaAdjudicado'            => $datosAdjudicado['IdArea'], 
            'DepartamentoAdjudicado'    => $datosAdjudicado['IdDpto'], 
            'TokenLinkFirma'            => $tokenReposicion, 
            'LiberadoFirma'             => "Y", 
            'Motivo'                    => $motivo, 
            'Observacion'               => $observacion, 
            'Cuotas'                    => $cuotas, 
            'UsuarioCrea'               => $this->items['id'],
            'CargoCrea'                 => $this->items['cargo'], 
            'AreaCrea'                  => $this->items['idArea'], 
            'DepartamentoCrea'          => $this->items['dpto'], 
            'FechaCrea'                 => $fechaActual,    
            'Localhost'                 => $this->request->getIPAddress()
        );

        $lastIdReposicion = $this->reposiciones->insert($dataReposicion, TRUE);
        
        if($lastIdReposicion !== FALSE){
            $idReposicion = $lastIdReposicion;
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar la reposición. Inténtelo luego.</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $dataDetalle = array();
        $totalSumaTrabajador = 0;

        foreach($itemDetalle as $detalle)
        {
            $dataDetalle[] = array (
                'IDReposicion'          => $idReposicion, 
                'IDDetalleAsignacion'   => $detalle,  
                'TotalDescuento'        => $totalDescuento[$detalle], 
                'TotalVerisure'         => $totalVerisure[$detalle], 
                'TotalTrabajador'       => $totalTrabajador[$detalle], 
                'Observacion'           => $obsDetalle[$detalle], 
                'UsuarioCrea'           => $this->items['id'],
                'FechaCrea'             => $fechaActual,    
                'Localhost'             => $this->request->getIPAddress()
            );

            $totalSumaTrabajador += $totalTrabajador[$detalle];
        }

        $lastIdDetalleReposicion = $this->reposicionesDetalle->insertBatch($dataDetalle);
        
		if($lastIdDetalleReposicion === FALSE){
			//$message = sprintf($this->mensajeError->msg502, $idAsignacion);
			//echo $this->alertas->alertaExito($message);
			//echo $this->alertas->reDireccion(base_url()."/documento-reposicion/".$idReposicion, 1);
            $this->reposiciones->where('IDReposicion', $idReposicion)->delete();
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la reposición. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
			exit;
		} 

        /*
        * ----------------------------
        * INSERCIÓN DE DATOS REPOSICIÓN - CRONOGRAMA DE PAGOS
        * ----------------------------
        */
        
        $diaPlanilla = $this->globales->diaCortePlanilla();

        $cuotasTrabajador = ($cuotas == 'Y' ? $this->complementos->rangoDescuentosMoviles($totalSumaTrabajador) : 1);

        $fechaPlanillaActual = date("Y-m-".$diaPlanilla);

        $timePlanilla = strtotime($fechaPlanillaActual);
        $timeActual = strtotime($fechaActual);

        $mesInicioCuotas=0;
        $anioInicioCuotas=0;

        if($timePlanilla > $timeActual)
        {
            $mesInicioCuotas = date("m");
            $anioInicioCuotas = date("Y");
        }
        else
        {
            $mesActual = date("m");
            $anioActual = date("Y");

            if($mesActual == 12)
            {
                $mesInicioCuotas = 1;
                $anioInicioCuotas = $anioActual +1 ;
            }
            else
            {
                $mesInicioCuotas = $mesActual + 1;
                $anioInicioCuotas = $anioActual;
            }
        }
            
        $dataCronogramaPago = array();
        
        $descuentoMensual = number_format(round($totalSumaTrabajador / $cuotasTrabajador, 2), 2, '.', '');

        for($i=1; $i<=$cuotasTrabajador;$i++)
        {
            if($i == ($cuotasTrabajador))
            {
                $montoCuota = ($totalSumaTrabajador - (($cuotasTrabajador - 1)*$descuentoMensual));
            }
            else
            {
                $montoCuota = $descuentoMensual;
            }

            $dataCronogramaPago[] = array (
                'IDReposicion'          => $idReposicion, 
                'NroCuota'              => $i, 
                'MesCuota'              => $mesInicioCuotas, 
                'AnioCuota'             => $anioInicioCuotas, 
                'MontoCuota'            => $montoCuota, 
                'Observacion'           => 'Cuota generada automáticamente', 
                'UsuarioCrea'           => $this->items['id'],
                'FechaCrea'             => $fechaActual,    
                'Localhost'             => $this->request->getIPAddress()
            );

            $mesInicioCuotas++;

            if($mesInicioCuotas > 12)
            {
                $mesInicioCuotas = 1;
                $anioInicioCuotas = $anioInicioCuotas + 1;
            }
        }

        $lastIdCronograma = $this->reposicionesCronogramaPago->insertBatch($dataCronogramaPago);
        
		if($lastIdCronograma === FALSE){
            $this->reposicionesDetalle->where('IDReposicion', $idReposicion)->delete();
            $this->reposiciones->where('IDReposicion', $idReposicion)->delete();
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la reposición. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
			exit;
		} 

        
        /*
        * ----------------------------
        * GUARDAR ARCHIVO ADJUNTO
        * ----------------------------
        */
        
        if($motivo == 'ROB' || $motivo == 'PER')
        {
            if($adjunto->guessExtension() != null)
            {
                $extensionDoc = $adjunto->guessExtension();
            }
            else
            {
                $nombre_original = $adjunto->getBasename();
                $fileNameCmps = explode(".", $nombre_original);
                $extensionDoc = strtolower(end($fileNameCmps));
            }
            
            /*
            * ----------------------------
            * INSERCIÓN DE DATOS ADJUNTOS
            * ----------------------------
            */

            $dataAdjuntoReposicion = array (
                'IDReposicion'      => $idReposicion, 
                'Nombre'            => "Denuncia Reposición", 
                'Extension'         => $extensionDoc,
                'Observacion'       => "Reporte de denuncia de equipos.",
                'ReemplazoFirma'    => "N",  
                'UsuarioCrea'       => $this->items['id'],
                'FechaCrea'         => $fechaActual,    
                'Localhost'         => $this->request->getIPAddress()
            );

            $lastIdAdjuntosReposiciones = $this->reposicionesAdjuntos->insert($dataAdjuntoReposicion, TRUE);

            if($lastIdAdjuntosReposiciones === FALSE){
                $this->reposicionesCronogramaPago->where('IDReposicion', $idReposicion)->delete();
                $this->reposicionesDetalle->where('IDReposicion', $idReposicion)->delete();
                $this->reposiciones->where('IDReposicion', $idReposicion)->delete();
                /*$this->devolucionesDetalle->where('IDDevolucion', $idDevolucion)->delete();
                $this->devoluciones->where('IDDevolucion', $idDevolucion)->delete();*/
                $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[INSERT]");
                echo $this->alertas->alertaError($message);
                exit;
            }

            /*
            * ----------------------------
            * GUARDAR ARCHIVO ADJUNTO REPOSICIÓN
            * ----------------------------
            */
            $ruta = "public/docs/ActaReposicion/";
            $nombreArchivo = $idReposicion."-".$lastIdAdjuntosReposiciones;

            if(!file_exists($ruta))
            {
                @mkdir($ruta, 0777, true);
            }

            # si exsite la carpeta o se ha creado
            if (file_exists($ruta) || @mkdir($ruta)) 
            {
                $nuevonombre = $nombreArchivo.'.'.$extensionDoc;
                
                $estadoMove = $adjunto->move($ruta, $nuevonombre);
                
                if (!$estadoMove) {
                    $this->reposicionesCronogramaPago->where('IDReposicion', $idReposicion)->delete();
                    $this->reposicionesAdjuntos->where('IDAdjuntoReposicion', $lastIdAdjuntosReposiciones)->delete();
                    $this->reposicionesDetalle->where('IDReposicion', $idReposicion)->delete();
                    $this->reposiciones->where('IDReposicion', $idReposicion)->delete();
                    $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[SAVEDOC]");
                    echo $this->alertas->alertaError($message);
                    exit;
                }
            }
            else
            {
                $this->reposicionesCronogramaPago->where('IDReposicion', $idReposicion)->delete();
                $this->reposicionesAdjuntos->where('IDAdjuntoReposicion', $lastIdAdjuntosReposiciones)->delete();
                $this->reposicionesDetalle->where('IDReposicion', $idReposicion)->delete();
                $this->reposiciones->where('IDReposicion', $idReposicion)->delete();
                $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
                echo $this->alertas->alertaError($message);
                exit;
            }
            
        }
        
        /*
        * ----------------------------
        * PREPARACIÓN DE CUERPO DE CORREO DE REPOSICIÓN
        * ----------------------------
        */

        $arrayCuerpo = array(
            "TITULO" => "ACTA DE REPOSICIÓN",
            "ACTA" => "ACTA DE REPOSICIÓN",
            "USUARIO" => ucwords(mb_strtolower($datosAdjudicado['Nombres'].' '.$datosAdjudicado['Apellidos'])),
            "URL_ACTA" => base_url()."/acta-reposicion/".$idReposicion."/".$tokenReposicion
        );

        $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActas($arrayCuerpo);
        
        /*
        * ----------------------------
        * PREPARACIÓN DE PARAMETROS PARA EL CORREO
        * ----------------------------
        */

        $asunto='ACTA DE REPOSICIÓN: '.$idReposicion.' - '.$datosAdjudicado['Nombres'].' '.$datosAdjudicado['Apellidos'];
        //$correoDestino = array($asignado['Correo']);
        $configCorreo = array(
            "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
            "CORREO_ORIGEN" => $this->items['correoElectronico'],
            "CORREOS_DESTINOS" => array($this->items['correoElectronico']),
            "CORREOS_COPIA" => array("josejesus.cuadros@verisure.pe"),
            "CORREOS_OCULTO" => array(),
            "ASUNTO" => $asunto,
            "MENSAJE" => $cuerpo
        );

        $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);

        $dataCorreo = array(
            "IDReposicion"  => $idReposicion,
            "Response"      => $estadoCorreo['RESPUESTA'],
            "Error"         => $estadoCorreo['ERROR'],
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $this->correoStatusReposicion->insert($dataCorreo, TRUE);
        
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS DEVOLUCIÓN
        * ----------------------------
        */
        
        $datosUsuario = $this->usuarios->buscarUsuario($adjudicado);
        $tokenDevolucion = $this->complementos->generar_string_aleatorio(15);

        $dataDevolucion = array (
            'UsuarioDevolucion'         => $adjudicado, 
            'CargoDevolucion'           => $datosUsuario['Cargo'], 
            'AreaDevolucion'            => $datosUsuario['IdArea'], 
            'DepartamentoDevolucion'    => $datosUsuario['IdDpto'], 
            'Motivo'                    => "REPOSICION", 
            'Observacion'               => "Devolución generada desde reposición.", 
            'TokenLinkFirma'            => $tokenDevolucion, 
            'UsuarioCrea'               => $this->items['id'],
            'CargoCrea'                 => $this->items['cargo'], 
            'AreaCrea'                  => $this->items['idArea'], 
            'DepartamentoCrea'          => $this->items['dpto'], 
            'FechaCrea'                 => $fechaActualAdd,
            'Localhost'                 => $this->request->getIPAddress()
        );

        $lastIdDevolucion = $this->devoluciones->insert($dataDevolucion, TRUE);
        
        if($lastIdDevolucion !== FALSE){
            $idDevolucion = $lastIdDevolucion;
        }
        else
        {
            if($motivo == 'ROB' || $motivo == 'PER')
            {
                $this->reposicionesAdjuntos->where('IDAdjuntoReposicion', $lastIdAdjuntosReposiciones)->delete();
                unlink($ruta.$nuevonombre);
            }

            $this->reposicionesCronogramaPago->where('IDReposicion', $idReposicion)->delete();
            $this->reposicionesDetalle->where('IDReposicion', $idReposicion)->delete();
            $this->reposiciones->where('IDReposicion', $idReposicion)->delete();
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar la reposición. Inténtelo luego.</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $dataDetalleDevolucion = array();

        foreach($itemDetalle as $detalle)
        {
            $dataDetalleDevolucion[] = array (
                'IDDevolucion'          => $idDevolucion, 
                'IDDetalleAsignacion'   => $detalle,  
                'MotivoDevolucion'      => $motivo,
                'Observacion'           => $obsDetalle[$detalle],
                'UsuarioCrea'           => $this->items['id'],
                'FechaCrea'             => $fechaActualAdd,    
                'Localhost'             => $this->request->getIPAddress()
            );
        }
        $lastIdDetalleDevolucion = $this->devolucionesDetalle->insertBatch($dataDetalleDevolucion);
        
		if($lastIdDetalleDevolucion === FALSE){
			//$message = sprintf($this->mensajeError->msg502, $idAsignacion);
			//echo $this->alertas->alertaExito($message);
			//echo $this->alertas->reDireccion(base_url()."/documento-reposicion/".$idReposicion, 1);
            if($motivo == 'ROB' || $motivo == 'PER')
            {
                $this->reposicionesAdjuntos->where('IDAdjuntoReposicion', $lastIdAdjuntosReposiciones)->delete();
                unlink($ruta.$nuevonombre);
            }

            $this->reposicionesCronogramaPago->where('IDReposicion', $idReposicion)->delete();
            $this->reposicionesDetalle->where('IDReposicion', $idReposicion)->delete();
            $this->reposiciones->where('IDReposicion', $idReposicion)->delete();
            $this->devoluciones->where('IDDevolucion', $idDevolucion)->delete();
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la reposición. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
			exit;
		} 

        /*
        * ----------------------------
        * PREPARACIÓN DE CUERPO DE CORREO DE DEVOLUCIÓN
        * ----------------------------
        */

        $arrayCuerpo = array(
            "TITULO" => "ACTA DE DEVOLUCIÓN",
            "ACTA" => "ACTA DE DEVOLUCIÓN",
            "USUARIO" => ucwords(mb_strtolower($datosUsuario['Nombres'].' '.$datosUsuario['Apellidos'])),
            "URL_ACTA" => base_url()."/acta-devolucion/".$idDevolucion."/".$tokenDevolucion
        );

        $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActas($arrayCuerpo);
        
        /*
        * ----------------------------
        * PREPARACIÓN DE PARAMETROS PARA EL CORREO
        * ----------------------------
        */

        $asunto='ACTA DE DEVOLUCIÓN: '.$idDevolucion.' - '.$datosUsuario['Nombres'].' '.$datosUsuario['Apellidos'];
        //$correoDestino = array($asignado['Correo']);
        $configCorreo = array(
            "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
            "CORREO_ORIGEN" => $this->items['correoElectronico'],
            "CORREOS_DESTINOS" => array($this->items['correoElectronico']),
            "CORREOS_COPIA" => array("josejesus.cuadros@verisure.pe"),
            "CORREOS_OCULTO" => array(),
            "ASUNTO" => $asunto,
            "MENSAJE" => $cuerpo
        );

        $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);

        $dataCorreo = array(
            "IDDevolucion"  => $idDevolucion,
            "Response"      => $estadoCorreo['RESPUESTA'],
            "Error"         => $estadoCorreo['ERROR'],
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $this->correoStatusDevolucion->insert($dataCorreo, TRUE);
        
        $message = sprintf($this->mensajeError->msg201, "La reposición fue solicitada exitosamente.");
        echo $this->alertas->alertaExito($message);
        echo $this->alertas->reDireccion(base_url()."/documento-reposicion/".$idReposicion, 1);
    }

    public function documentoReposicion($idReposicion)
    {
        if(isset($this->items['id'])){

			/* ACCIONES */

            $reposicion = $this->reposiciones->where("IDReposicion",$idReposicion)->first();
            $remitente = $this->usuarios->where("IdUsuario ", $reposicion['UsuarioCrea'])->first();
            $adjudicado = $this->usuarios->buscarUsuario($reposicion['UsuarioAdjudicado']);

            $depaReposicion = $this->bm_departamento->where("IdDpto", $reposicion['DepartamentoAdjudicado'])->first();
            $areaReposicion = $this->bm_area->where("IdArea", $reposicion['DepartamentoAdjudicado'])->first();
            
            $whereFirma = array(
                "IDReposicion"  => $idReposicion,
                "Firma"         => "Y"
            );
            $firmaReposicion = $this->reposicionesAdjuntos->where($whereFirma)->first();

            $reposicion['NombreRemitente'] = strtoupper($remitente['Nombres'].' '.$remitente['Apellidos']);
            $reposicion['NombreAdjudicado'] = $adjudicado['Nombres'];
            $reposicion['ApellidosAdjudicado'] = $adjudicado['Apellidos'];
            $reposicion['DocumentoAdjudicado'] = $adjudicado['NumeroDoc'];
            $reposicion['GerenciaAdjudicado'] = $depaReposicion['NombreDpto'];
            $reposicion['AreaAdjudicado'] = $areaReposicion['NombreArea'];
            $reposicion['MatriculaAdjudicado'] = $adjudicado['Matricula'];
            $reposicion['FechaAdjudicado'] = "Lima, ".date('d', strtotime($reposicion['FechaCrea']))." de ".$this->complementos->parseoMes(date('m', strtotime($reposicion['FechaCrea'])))." de ".date('Y', strtotime($reposicion['FechaCrea']));

			$detalleReposicion = $this->reposicionesDetalle->listarDetalleReposicion($idReposicion);
            
            //$asumeTotalTrabajador = 0;
            foreach($detalleReposicion as $key=>$value)
            {
                //$asumeTotalTrabajador += $value['TotalTrabajador'];
                //Obtener elemento
                if($value['TipoElemento']=='MOVIL')
                {
                    $dataElemento = $this->moviles->obtenerMovil($value['IDElemento']);
                    $detalleReposicion[$key]['ELEMENTO'] = $dataElemento['Marca'].' '.$dataElemento['Modelo'].' '.$dataElemento['IMEI'];
                }
                else if($value['TipoElemento']=='LINEA')
                {
                    $dataElemento = $this->lineas->obtenerLinea($value['IDElemento']);
                    $detalleReposicion[$key]['TipoElemento'] = $value['TipoElemento'].' - '.$dataElemento['Numero'];
                    $detalleReposicion[$key]['ELEMENTO'] = $dataElemento['Operador'].' '.$dataElemento['Plan'].' '.$dataElemento['ICCID'];
                }
                else
                {
                    $informacionElemento = "SIN INFORMACIÓN";
                }
                
            }
            //$reposicion['MontoTotalTrabajador'] = $asumeTotalTrabajador;
            //$reposicion['CuotasTrabajador'] = ($reposicion['Cuotas'] == 'Y' ? $this->complementos->rangoDescuentosMoviles($asumeTotalTrabajador) : 1);

            $cronograma = $this->reposicionesCronogramaPago->where("IDReposicion", $idReposicion)->findAll();

            foreach($cronograma as $key=>$value)
            {
                $cronograma[$key]['MesDescontado'] = $this->complementos->parseoMes($value['MesCuota'], FALSE);
            }


			$data = array (
				'session'               => 'on',
				'titulo'                => 'Reposiciones | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Acta de descuento',
                'previo'                => 'listar-reposiciones',
                'idReposicion'          => $idReposicion,
				'reposicion'            => $reposicion,
                'cronograma'            => $cronograma,
                'detalle'               => $detalleReposicion,
                'firmaReposicion'       => $firmaReposicion
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/reposiciones/documento_reposicion',$data);			
		} else {
			return view('errors/500');
		}
    }

    public function detalleActaReposicion($idReposicion)
    {
        if(isset($this->items['id'])){

			/* ACCIONES */
            $reposicion = $this->reposiciones->where("IDReposicion",$idReposicion)->first();
            $listaDetalle = $this->reposicionesDetalle->listarDetalleReposicion($idReposicion);
            $listaAdjunto = $this->reposicionesAdjuntos->where("IDReposicion", $idReposicion)->findAll();    

            foreach($listaDetalle as $key=>$value)
            {
                //Obtener elemento
                if($value['TipoElemento']=='MOVIL')
                {
                    $dataElemento = $this->moviles->obtenerMovil($value['IDElemento']);
                    $listaDetalle[$key]['Elemento'] = $dataElemento['Marca'].' '.$dataElemento['Modelo'].' '.$dataElemento['IMEI'];
                }
                else if($value['TipoElemento']=='LINEA')
                {
                    $dataElemento = $this->lineas->obtenerLinea($value['IDElemento']);
                    $listaDetalle[$key]['TipoElemento'] = $value['TipoElemento'].' - '.$dataElemento['Numero'];
                    $listaDetalle[$key]['Elemento'] = $dataElemento['Operador'].' '.$dataElemento['Plan'].' '.$dataElemento['ICCID'];
                }
                else
                {
                    $informacionElemento = "SIN INFORMACIÓN";
                }
                
            }

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Detalle de Reposición | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Detalle de Reposición | '.$reposicion['IDReposicion'],
                'previo'                => 'listar-reposiciones',
				'listaDetalle'          => $listaDetalle,
                'listaAdjunto'          => $listaAdjunto,
                'idReposicion'          => $idReposicion
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/reposiciones/listar_detalle_reposicion',$data);			
		} else {
			return view('errors/500');
		}
    }

    public function enviarCorreoReposicion()
    {
        $fechaActual = date("Y-m-d H:i:s");

        $idReposicion = $this->request->getPost('idReposicion');
        $reposicion = $this->reposiciones->where("IDReposicion", $idReposicion)->first();
        $adjudicado = $this->usuarios->buscarUsuario($reposicion['UsuarioAdjudicado']);
        
		/*
        * ----------------------------
        * PREPARACIÓN DE CUERPO DE CORREO
        * ----------------------------
		*/

        $arrayCuerpo = array(
            "TITULO" => "ACTA DE REPOSICIÓN",
            "ACTA" => "ACTA DE REPOSICIÓN",
            "USUARIO" => ucwords(mb_strtolower($adjudicado['Nombres'].' '.$adjudicado['Apellidos'])),
            "URL_ACTA" => base_url()."/acta-reposicion/".$idReposicion."/".$reposicion['TokenLinkFirma']
        );

        $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActas($arrayCuerpo);
		/*
        * ----------------------------
        * PREPARACIÓN DE PARAMETROS PARA EL CORREO
        * ----------------------------
		*/

        $asunto='ACTA DE REPOSICIÓN: '.$idReposicion.' - '.$adjudicado['Nombres'].' '.$adjudicado['Apellidos'];
        //$correoDestino = array($asignado['Correo']);
        $configCorreo = array(
            "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
            "CORREO_ORIGEN" => $this->items['correoElectronico'],
            "CORREOS_DESTINOS" => array($this->items['correoElectronico']),
            "CORREOS_COPIA" => array("josejesus.cuadros@verisure.pe"),
            "CORREOS_OCULTO" => array(),
            "ASUNTO" => $asunto,
            "MENSAJE" => $cuerpo
        );

        $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);

        $dataCorreo = array(
            "IDReposicion"  => $idReposicion,
            "Response"      => $estadoCorreo['RESPUESTA'],
            "Error"         => $estadoCorreo['ERROR'],
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $this->correoStatusReposicion->insert($dataCorreo, TRUE);

        if($estadoCorreo['ERROR'] != '')
        {
            $message = sprintf($this->mensajeError->msg201, "No se pudo enviar el correo. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "Se envió el correo correctamente.");
            echo $this->alertas->alertaExito($message);
        }
        
    }
    
    public function listarDescuentosMensual()
    {
        if(isset($this->items['id'])){

			/* ACCIONES */
            
            $listadoMensual = $this->reposicionesCronogramaPago->obtenerDescuentosMes(date("m"), date("Y"));
            
            foreach($listadoMensual as $key=>$item)
            {
                $usuario = $this->usuarios->where("IdUsuario ", $item['UsuarioAdjudicado'])->first();
                $listadoMensual[$key]['NombreUsuario'] = $usuario['Nombres'].' '.$usuario['Apellidos'];
                $listadoMensual[$key]['MatriculaUsuario'] = $usuario['Matricula'];
                $listadoMensual[$key]['Periodo'] = $this->complementos->parseoMes(date("m"), FALSE).' '.date("Y");
            }
            
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Descuentos por Reposición | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Descuentos del mes',
				'subtitulo'             => 'Descuentos '.$this->complementos->parseoMes(date("m"), FALSE).' '.date("Y"),
				'listadoMensual'        => $listadoMensual
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/reposiciones/listar_descuentos_mensual',$data);
		} else {
			return view('errors/500');
		}
    }
    
    public function recargarTablaDescuentoMensual()
    {
        $resultado['data'] = array();
        
        $listadoMensual = $this->reposicionesCronogramaPago->obtenerDescuentosMes($this->request->getPost("mes"), $this->request->getPost("anio"));
        foreach($listadoMensual as $key=>$item)
        {
            $usuario = $this->usuarios->where("IdUsuario ", $item['UsuarioAdjudicado'])->first();
            
            $resultado['data'][$key] = array(
				'usuario' => (string) $usuario['Nombres'].' '.$usuario['Apellidos'],
				'monto_descuento' => (string) $item['MontoCuota'],
                'periodo' => $this->complementos->parseoMes($this->request->getPost("mes"), FALSE).' '.$this->request->getPost("anio"),
				'cuota' => (string) $item['NroCuota'].' | '.$item['UltimaCuota'],
				'cobrado' => (string) $item['Cobrado'],
				'monto_cobrado' => (string) $item['MontoCobro'],
				'fecha_cobro' => (string) ($item['FechaCobro'] != '' && $item['FechaCobro'] != null ? date("d-m-Y", strtotime($item['FechaCobro'])) : ''),
				'observacion_cobro' => (string) $item['ObservacionCobro']
			);
        }
        
        $resultado['subtitulo'] = 'Descuentos '.$this->complementos->parseoMes($this->request->getPost("mes"), FALSE).' '.$this->request->getPost("anio");
		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado, JSON_NUMERIC_CHECK);		
    }
    
    public function exportarDescuentoMensual($mes, $anio)
    {
        $listadoMensual = $this->reposicionesCronogramaPago->obtenerDescuentosPendientesMes($mes, $anio);
        
        $filename = "text.csv";
        $writer = WriterEntityFactory::createCSVWriter();
        $writer->setFieldDelimiter(';');
        $writer->openToBrowser($filename);
        
        $cells = [
            WriterEntityFactory::createCell("Código"),
            WriterEntityFactory::createCell("Matrícula"),
            WriterEntityFactory::createCell("Usuario"),
            WriterEntityFactory::createCell("Monto Descuento"),
            WriterEntityFactory::createCell("Periodo"),
            WriterEntityFactory::createCell("Cuota"),
            WriterEntityFactory::createCell("Monto Cobrado"),
            WriterEntityFactory::createCell("Fecha Cobro"),
            WriterEntityFactory::createCell("Observación Cobro")
        ];
        
        /** add a row at a time */
        $singleRow = WriterEntityFactory::createRow($cells);
        $writer->addRow($singleRow);
        
        foreach($listadoMensual as $key=>$item)
        {
            $usuario = $this->usuarios->where("IdUsuario ", $item['UsuarioAdjudicado'])->first();
            $periodo = (string) $this->complementos->parseoMes($mes, FALSE).' | '.$anio;
			$cells = [
                WriterEntityFactory::createCell($item['IDCronogramaPago']),
                WriterEntityFactory::createCell($usuario['Matricula']),
                WriterEntityFactory::createCell($usuario['Nombres'].' '.$usuario['Apellidos']),
                WriterEntityFactory::createCell($item['MontoCuota']),
                WriterEntityFactory::createCell($periodo),
                WriterEntityFactory::createCell($item['NroCuota'].' | '.$item['UltimaCuota']),
                WriterEntityFactory::createCell(""),
                WriterEntityFactory::createCell(""),
                WriterEntityFactory::createCell("")
            ];
            
            /** add a row at a time */
            $singleRow = WriterEntityFactory::createRow($cells);
            $writer->addRow($singleRow);

        }
        
        $writer->close();
    }

    public function importarDescuentosMensual()
    {
        $fechaActual = date("Y-m-d H:i:s");
        $fechaActualAdd = date("Y-m-d H:i:s", strtotime($fechaActual)+1);
        
        /*
        * ----------------------------
        * DECLARAR Y ASIGNAR VARIABLE A ARCHIVO OBTENIDO
        * ----------------------------
        */
        
        $csv = $this->request->getFile("file");

        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $csv->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $csv->getErrorString().'-'.$csv->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'file' => [
                'mime_in[file,text/csv,text/plain]',
                'ext_in[file,csv]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        /*
        * ----------------------------
        * VALIDAR SEPARADOR CSV
        * ----------------------------
        */
        
        $separadorCSV = $this->complementos->validarSeparadorCSV($csv, 9);
        
        if (!$separadorCSV) {
            $message = sprintf($this->mensajeError->msg201, "No se encontró separador de CSV autorizado. Debe usar coma (,) o punto y coma (;) y eliminar celdas vacías a la derecha de la última columna.");
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y VALIDAR DATOS CORRECTOS
        * ----------------------------
        */
        
        //Declaramos variables
        $fila = 0;
        $filasError = array();
        $arrayElementos = array();
        $ejecutarInsert = true;
        //Abrimos el archivo
        $handle = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handle, 0, $separadorCSV)) !== FALSE)
        {
            $fila++;

            if($fila>1)
            {
                $data = array_map("utf8_encode", $data);
                //Asignamos valores de CSV a variables locales
                $id = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $montoCobrado = trim($data[6]," \t\n\r\0\x0B\xc2\xa0");
                $fechaCobro = trim($data[7]," \t\n\r\0\x0B\xc2\xa0");
                
                if($id == '' || $id == null)
                {
                    $filasError[$fila]['CÓDIGO'] = "EL CÓDIGO SE ENCUENTRA VACÍO.";
                    $ejecutarInsert = false;
                }
                
                if(strtotime($fechaCobro)=='' || strtotime($fechaCobro)==0)
                {
                    $filasError[$fila]['FECHA COBRO'] = "LA FECHA NO CUENTA CON EL FORMATO ADECUADO (YYYY-MM-DD).";
                    $ejecutarInsert = false;
                }
                
                if(!is_numeric($montoCobrado) && $montoCobrado != null && $montoCobrado != '')
                {
                    $filasError[$fila]['MONTO COBRADO'] = "EL MONTO INGRESADO NO ES UN NÚMERO.";
                    $ejecutarInsert = false;
                }
                else if($montoCobrado != null && $montoCobrado != '')
                {
                    if(strtotime($fechaCobro) == '')
                    {
                        $filasError[$fila]['FECHA COBRO'] = "NO ES UN FORMATO DE FECHA VÁLIDO.".'-'.$montoCobrado.'-';
                        $ejecutarInsert = false;
                    }
                }
                
            }
        }

        fclose($handle);

        if(!$ejecutarInsert)
        {
            $raiz = 'public/';
            $nombre = 'error.txt';
            $file = 'public/error.txt';
            
            if (file_exists($file)) {
                unlink($file);
            }
            
            $txt= fopen($file, 'a') or die ('Problemas al crear el archivo');
            #  Se establecen los datos que va a conterner el archivo
            foreach($filasError as $key=>$value)
            {
                fwrite($txt, "FILA: ".$key."\n");
                foreach($value as $celda=>$error)
                {
                    fwrite($txt, $celda.": ".$error."\n");
                }
            }
            #  Se hace el ciere para no sobre escribir datos 
            fclose($txt);

            $message = sprintf($this->mensajeError->msg201, "Se detectaron diversas inconsistencias.");
            $salida1 = $this->alertas->alertaError($message);
            $salida2 = $this->alertas->descargaArchivoTXT($nombre);
			echo $salida1.$salida2;
			//echo $salida1;
            
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y EJECUTAR INSERTS
        * ----------------------------
        */
            
        //Declaramos variables
        $arrayUpdateDescuento = [];
        
        $filainsert = 0;
        //Abrimos el archivo
        $handleInsert = fopen($csv, "r");
        
        //Recorremos las filas del CSV
        while (($data = fgetcsv($handleInsert, 0, $separadorCSV)) !== FALSE)
        {
            $data = array_map("utf8_encode", $data);
            $filainsert++;
            if($filainsert > 1)
            {
                //Asignamos valores de CSV a variables locales
                $idCronograma = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $montoCobrado = trim($data[6]," \t\n\r\0\x0B\xc2\xa0");
                $fechaCobro = trim($data[7]," \t\n\r\0\x0B\xc2\xa0");
                $observacionCobro = trim($data[8]," \t\n\r\0\x0B\xc2\xa0");
                
                if($montoCobrado != ''  && $montoCobrado != null)
                {
                    $arrayUpdateDescuento[] = array(
                        "IDCronogramaPago" => $idCronograma,
                        "Cobrado"           => "Y",
                        "FechaCobro"        => $fechaCobro!='' && $fechaCobro!=null ? date("Y-m-d", strtotime($fechaCobro)) : date("Y-m-d", strtotime($fechaActual)) ,
                        "MontoCobro"        => $montoCobrado,
                        "ObservacionCobro"  => $observacionCobro,
                        "UsuarioModifica"   => $this->items['id'],
                        'FechaModifica'     => $fechaActual,    
                        'Localhost'         => $this->request->getIPAddress());
                }
                
            }
        }

        fclose($handleInsert);
        
        $lastId = $this->reposicionesCronogramaPago->updateBatch($arrayUpdateDescuento, 'IDCronogramaPago');

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg201, "Cobros registrados correctamente.");
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
        
    }

    public function actaDevolucion($idDevolucion, $token)
    {
        $devolucion = $this->devoluciones->where("IDDevolucion", $idDevolucion)->first();

        $whereFirma = array(
            "IDDevolucion"  => $idDevolucion,
            "Firma"         => "Y"
        );
        $firmaDevolucion = $this->devolucionesAdjuntos->where($whereFirma)->first();

        if($token == $devolucion['TokenLinkFirma'])
        {
			/* ACCIONES */

            $remitente = $this->usuarios->where("IdUsuario ", $devolucion['UsuarioCrea'])->first();
            $usuarioDevuelto = $this->usuarios->buscarUsuario($devolucion['UsuarioDevolucion']);
            
            $depaDevuelto = $this->bm_departamento->where("IdDpto", $devolucion['DepartamentoDevolucion'])->first();
            $areaDevuelto = $this->bm_area->where("IdArea", $devolucion['AreaDevolucion'])->first();

            $devolucion['NombreRemitente'] = strtoupper($remitente['Nombres'].' '.$remitente['Apellidos']);
            $devolucion['NombreUsuario'] = $usuarioDevuelto['Nombres'];
            $devolucion['ApellidosUsuario'] = $usuarioDevuelto['Apellidos'];
            $devolucion['DocumentoUsuario'] = $usuarioDevuelto['NumeroDoc'];
            $devolucion['GerenciaUsuario'] = $depaDevuelto['NombreDpto'];
            $devolucion['AreaUsuario'] = $areaDevuelto['NombreArea'];
            $devolucion['CargoUsuario'] = $devolucion['CargoDevolucion'];
            $devolucion['MatriculaUsuario'] = $usuarioDevuelto['Matricula'];
            $devolucion['FechaDevolucion'] = "Lima, ".date('d', strtotime($devolucion['FechaCrea']))." de ".$this->complementos->parseoMes(date('m', strtotime($devolucion['FechaCrea'])))." de ".date('Y', strtotime($devolucion['FechaCrea']));

			$detalleDevolucion = $this->devolucionesDetalle->listarDetalleDevolucion($idDevolucion);
            
            foreach($detalleDevolucion as $key=>$value)
            {
                //Obtener elemento
                if($value['TipoElemento']=='MOVIL')
                {
                    $dataElemento = $this->moviles->obtenerMovil($value['IDElemento']);
                    $detalleDevolucion[$key]['Elemento'] = $dataElemento['Marca'].' '.$dataElemento['Modelo'].' '.$dataElemento['IMEI'];
                }
                else if($value['TipoElemento']=='LINEA')
                {
                    $dataElemento = $this->lineas->obtenerLinea($value['IDElemento']);
                    $detalleDevolucion[$key]['TipoElemento'] = $value['TipoElemento'].' - '.$dataElemento['Numero'];
                    $detalleDevolucion[$key]['Elemento'] = $dataElemento['Operador'].' '.$dataElemento['Plan'].' '.$dataElemento['ICCID'];
                }
                else
                {
                    $informacionElemento = "SIN INFORMACIÓN";
                }
                
            }

            $situacionMovil = $this->globales->motivoEstadoMovil('');

			$data = array (
				'titulo'                => 'Devoluciones | Verisure',
                'idDevolucion'          => $idDevolucion,
				'devolucion'            => $devolucion,
                'detalle'               => $detalleDevolucion,
                'situacionMovil'        => $situacionMovil,
                'firmaDevolucion'       => $firmaDevolucion
			);
            
			$data = array_merge($data, $this->items);
			return view('veriactivos/devoluciones/acta_devolucion',$data);	
        }
        else
        {
            return view('errors/500');
        }
    }

    public function subirFirmaActaDevolucion()
    {
        $fechaActual = date("Y-m-d H:i:s");

        $idDevolucion = $this->request->getPost("txtIDDevolucion");
        $canvasFirma = $this->request->getPost("firmaActaDevolucion");
        
        $adjunto = $this->request->getFile("fileFotoDNI");
        
        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $adjunto->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $adjunto->getErrorString().'-'.$adjunto->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'fileFotoDNI' => [
                'mime_in[fileFotoDNI,image/png,image/jpg,image/jpeg,image/gif,application/pdf]',
                'ext_in[fileFotoDNI,png,jpg,jpeg,gif,pdf]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        if($adjunto->guessExtension() != null)
        {
            $extensionDoc = $adjunto->guessExtension();
        }
        else
        {
            $nombre_original = $adjunto->getBasename();
            $fileNameCmps = explode(".", $nombre_original);
            $extensionDoc = strtolower(end($fileNameCmps));
        }

        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */

        $devolucion = $this->devoluciones->where("IDDevolucion", $idDevolucion)->first();

        $data = array (
            'IDDevolucion'      => $idDevolucion, 
            'Nombre'            => "DOCUMENTO DE IDENTIDAD", 
            'Extension'         => $extensionDoc,
            'Observacion'       => "DOCUMENTO DE IDENTIDAD ADJUNTADO EN LA FIRMA.",
            'ReemplazoFirma'    => 'N',  
            'UsuarioCrea'       => $devolucion['UsuarioDevolucion'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->devolucionesAdjuntos->insert($data, TRUE);

		if($lastId === FALSE){
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
			exit;
		}

        /*
        * ----------------------------
        * GUARDAR ARCHIVO ADJUNTO
        * ----------------------------
        */
        $ruta = "public/docs/ActaDevolucion/";
        $nombreArchivo = $idDevolucion."-".$lastId;

        if(!file_exists($ruta))
        {
            @mkdir($ruta, 0777, true);
        }

		# si exsite la carpeta o se ha creado
		if (file_exists($ruta) || @mkdir($ruta)) 
        {
            $nuevonombre = $nombreArchivo.'.'.$extensionDoc;
            
            $estadoMove = $adjunto->move($ruta, $nuevonombre);
            
            if (!$estadoMove) {
                $this->devolucionesAdjuntos->delete(["IDAdjuntoDevolucion", $lastId]);
                $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[SAVEDOC]");
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        else
        {
            $this->devolucionesAdjuntos->delete(["IDAdjuntoDevolucion", $lastId]);
            $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
            echo $this->alertas->alertaError($message);
        }
        
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */

        $dataFirma = array (
            'IDDevolucion'      => $idDevolucion, 
            'Nombre'            => "FIRMA", 
            'Extension'         => "png",
            'Observacion'       => "FIRMA DE USUARIO QUE DEVUELVE DISPOSITIVOS.",
            'ReemplazoFirma'    => 'N',  
            'Firma'             => 'Y',  
            'UsuarioCrea'       => $devolucion['UsuarioDevolucion'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastIdFirma = $this->devolucionesAdjuntos->insert($dataFirma, TRUE);

		if($lastIdFirma === FALSE){
            unlink($ruta.$nombreArchivo.'.'.$extensionDoc);
            $this->devolucionesAdjuntos->delete(["IDAdjuntoDevolucion", $lastId]);
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la firma. Inténtelo luego.[INSERT]-".$lastIdFirma."-");
			echo $this->alertas->alertaError($message);
			exit;
		}

        /*
        * ----------------------------
        * GUARDAR FIRMA
        * ----------------------------
        */

        $nombreArchivoFirma = $idDevolucion."-".$lastIdFirma;

        if(!file_exists($ruta))
        {
            @mkdir($ruta, 0777, true);
        }

		# si exsite la carpeta o se ha creado
		if (file_exists($ruta) || @mkdir($ruta)) 
        {
            $nuevonombreFirma = $nombreArchivoFirma.'.png';
            
            $datos = base64_decode(
                preg_replace('/^[^,]*,/', '', $canvasFirma)
            );

            $estadoFirma = file_put_contents($ruta.$nuevonombreFirma, $datos);
            
            if ($estadoFirma===FALSE) {
                unlink($ruta.$nombreArchivo.'.'.$extensionDoc);
                $this->devolucionesAdjuntos->delete(["IDAdjuntoDevolucion", $lastId]);
                $this->devolucionesAdjuntos->delete(["IDAdjuntoDevolucion", $lastIdFirma]);
                $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la firma. Inténtelo luego.[SAVEDOC]-");
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        else
        {
            unlink($ruta.$nombreArchivo.'.'.$extensionDoc);
            $this->devolucionesAdjuntos->delete(["IDAdjuntoDevolucion", $lastId]);
            $this->devolucionesAdjuntos->delete(["IDAdjuntoDevolucion", $lastIdFirma]);
            $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
            echo $this->alertas->alertaError($message);
        }

        /*
        * ----------------------------
        * PREPARACIÓN DE CUERPO DE CORREO
        * ----------------------------
        */
        
        $usuarioRemitente = $this->usuarios->where("IdUsuario", $devolucion['UsuarioCrea'])->first();
        
        $usuarioDevolucion = $this->usuarios->where("IdUsuario", $devolucion['UsuarioDevolucion'])->first();
        
        $arrayCuerpo = array(
            "TITULO" => "FIRMA DE ACTA DE DEVOLUCIÓN",
            "ACTA" => "ACTA DE DEVOLUCIÓN",
            "USUARIO" => ucwords(mb_strtolower($usuarioRemitente['Nombres'].' '.$usuarioRemitente['Apellidos'])),
            "CODIGO" => $idDevolucion
        );

        $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActasConfirmacion($arrayCuerpo);
        
        /*
        * ----------------------------
        * PREPARACIÓN DE PARAMETROS PARA EL CORREO
        * ----------------------------
        */

        $asunto='FIRMA DE ACTA DE DEVOLUCIÓN: '.$idDevolucion.' - '.$usuarioDevolucion['Nombres'].' '.$usuarioDevolucion['Apellidos'];
        //$correoDestino = array($asignado['Correo']);
        $configCorreo = array(
            "NOMBRE_ORIGEN" => $usuarioDevolucion['Nombres'].' '.$usuarioDevolucion['Apellidos'],
            "CORREO_ORIGEN" => $usuarioDevolucion['Correo'],
            "CORREOS_DESTINOS" => array($usuarioRemitente['Correo']),
            "CORREOS_COPIA" => array("soporteti@verisure.pe"),
            "CORREOS_OCULTO" => array(),
            "ASUNTO" => $asunto,
            "MENSAJE" => $cuerpo
        );

        $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);

        $dataCorreo = array(
            "IDDevolucion"  => $idDevolucion,
            "Response"      => $estadoCorreo['RESPUESTA'],
            "Error"         => $estadoCorreo['ERROR'],
            'UsuarioCrea'   => $devolucion['UsuarioDevolucion'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $this->correoStatusDevolucion->insert($dataCorreo, TRUE);

        $message = sprintf($this->mensajeError->msg201, "La firma fue registrada exitosamente.");
        echo $this->alertas->alertaExito($message);
        echo $this->alertas->refrescar(1);
    }

    public function listarDevoluciones()
    {
        if(isset($this->items['id'])){

			/* ACCIONES */
            
			if($this->items['idPerfil'] == 3)
			{
			    $cccordinador = $this->globales->listadoCentroCostoCoordinador();
			
			    if(array_key_exists($this->items['id'], $cccordinador))
			    {
			        $centroscosto = $cccordinador[$this->items['id']];
			        $listadoDevolucion = $this->devoluciones->listarDevoluciones($centroscosto);
			    }
			    else
			    {
			        $listadoDevolucion = array();
			    }
			    
			}
			else
			{
			    $centroscosto = array();
			    $listadoDevolucion = $this->devoluciones->listarDevoluciones($centroscosto);
			}
            
/* 
            foreach($listadoDevolucion as $key=>$item)
            {
                $usuario = $this->usuarios->where("IdUsuario ", $item['UsuarioDevolucion'])->first();
                $listadoDevolucion[$key]['NombreUsuario'] = $usuario['Nombres'].' '.$usuario['Apellidos'];
                $listadoDevolucion[$key]['MatriculaUsuario'] = $usuario['Matricula'];

                $receptor = $this->usuarios->where("IdUsuario ", $item['UsuarioCrea'])->first();
                $listadoDevolucion[$key]['NombreReceptor'] = $receptor['Nombres'].' '.$receptor['Apellidos'];
            }
            */
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Actas de Devolución | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Actas de Devolución',
				'listadoDevolucion'     => $listadoDevolucion
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/devoluciones/listar_devoluciones',$data);			
		} else {
			return view('errors/500');
		}
    }

    public function documentoDevolucion($idDevolucion)
    {
        if(isset($this->items['id'])){

			/* ACCIONES */

            $devolucion = $this->devoluciones->where("IDDevolucion",$idDevolucion)->first();
            $remitente = $this->usuarios->where("IdUsuario ", $devolucion['UsuarioCrea'])->first();
            $usuarioDevuelto = $this->usuarios->buscarUsuario($devolucion['UsuarioDevolucion']);
            
            $whereFirma = array(
                "IDDevolucion"  => $idDevolucion,
                "Firma"         => "Y"
            );
            $firmaDevolucion = $this->devolucionesAdjuntos->where($whereFirma)->first();

            $devolucion['NombreRemitente'] = strtoupper($remitente['Nombres'].' '.$remitente['Apellidos']);
            $devolucion['NombreUsuario'] = $usuarioDevuelto['Nombres'];
            $devolucion['ApellidosUsuario'] = $usuarioDevuelto['Apellidos'];
            $devolucion['DocumentoUsuario'] = $usuarioDevuelto['NumeroDoc'];
            $devolucion['GerenciaUsuario'] = $usuarioDevuelto['NombreDpto'];
            $devolucion['AreaUsuario'] = $usuarioDevuelto['NombreArea'];
            $devolucion['CargoUsuario'] = $usuarioDevuelto['Cargo'];
            $devolucion['MatriculaUsuario'] = $usuarioDevuelto['Matricula'];
            $devolucion['FechaDevolucion'] = "Lima, ".date('d', strtotime($devolucion['FechaCrea']))." de ".$this->complementos->parseoMes(date('m', strtotime($devolucion['FechaCrea'])))." de ".date('Y', strtotime($devolucion['FechaCrea']));

			$detalleDevolucion = $this->devolucionesDetalle->listarDetalleDevolucion($idDevolucion);
            
            foreach($detalleDevolucion as $key=>$value)
            {
                //Obtener elemento
                if($value['TipoElemento']=='MOVIL')
                {
                    $dataElemento = $this->moviles->obtenerMovil($value['IDElemento']);
                    $detalleDevolucion[$key]['Elemento'] = $dataElemento['Marca'].' '.$dataElemento['Modelo'].' '.$dataElemento['IMEI'];
                }
                else if($value['TipoElemento']=='LINEA')
                {
                    $dataElemento = $this->lineas->obtenerLinea($value['IDElemento']);
                    $detalleDevolucion[$key]['TipoElemento'] = $value['TipoElemento'].' - '.$dataElemento['Numero'];
                    $detalleDevolucion[$key]['Elemento'] = $dataElemento['Operador'].' '.$dataElemento['Plan'].' '.$dataElemento['ICCID'];
                }
                else
                {
                    $informacionElemento = "SIN INFORMACIÓN";
                }
                
            }

            $situacionMovil = $this->globales->motivoEstadoMovil('');

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Devoluciones | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Acta de Devolución',
                'previo'                => 'listar-devoluciones',
                'idDevolucion'          => $idDevolucion,
				'devolucion'            => $devolucion,
                'detalle'               => $detalleDevolucion,
                'situacionMovil'        => $situacionMovil,
                'firmaDevolucion'       => $firmaDevolucion
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/devoluciones/documento_devolucion',$data);			
		} else {
			return view('errors/500');
		}
    }
    
    public function detalleActaDevolucion($idDevolucion)
    {
        if(isset($this->items['id'])){

			/* ACCIONES */
            $devolucion = $this->devoluciones->where("IDDevolucion",$idDevolucion)->first();
            $listaDetalle = $this->devolucionesDetalle->listarDetalleDevolucion($idDevolucion);
            $listaAdjunto = $this->devolucionesAdjuntos->where("IDDevolucion", $idDevolucion)->findAll();    

            foreach($listaDetalle as $key=>$value)
            {
                //Obtener elemento
                if($value['TipoElemento']=='MOVIL')
                {
                    $dataElemento = $this->moviles->obtenerMovil($value['IDElemento']);
                    $listaDetalle[$key]['Elemento'] = $dataElemento['Marca'].' '.$dataElemento['Modelo'].' '.$dataElemento['IMEI'];
                }
                else if($value['TipoElemento']=='LINEA')
                {
                    $dataElemento = $this->lineas->obtenerLinea($value['IDElemento']);
                    $listaDetalle[$key]['TipoElemento'] = $value['TipoElemento'].' - '.$dataElemento['Numero'];
                    $listaDetalle[$key]['Elemento'] = $dataElemento['Operador'].' '.$dataElemento['Plan'].' '.$dataElemento['ICCID'];
                }
                else
                {
                    $informacionElemento = "SIN INFORMACIÓN";
                }
                
            }

            $situacionMovil = $this->globales->motivoEstadoMovil('');

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Detalle de Devolución | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Detalle de Devolución | '.$idDevolucion,
                'previo'                => 'listar-devoluciones',
				'listaDetalle'          => $listaDetalle,
                'situacionMovil'        => $situacionMovil,
                'idDevolucion'          => $idDevolucion,
                'listaAdjunto'          => $listaAdjunto
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/devoluciones/listar_detalle_devolucion',$data);			
		} else {
			return view('errors/500');
		}
    }

    public function nuevaDevolucion()
    {
        if(isset($this->items['id'])){

			/* ACCIONES */
			//$listaUsuariosRemitente = $this->usuarios->where(array("CC"=>930, "Estado"=>"Activo"))->findAll();

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Nueva Devolución | Verisure',
                'previo'                => 'listar-devoluciones',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Nueva Devolución'
			);
			$data = array_merge($data, $this->items);
			return view('veriactivos/devoluciones/nueva_devolucion',$data);			
		} else {
			return view('errors/500');
		}
    }

    public function listadoPendientesDevolucionUsuario()
    {
		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idUsuario = $this->request->getPost('idUsuario');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idUsuario, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$listadoItems = $this->detalleasignaciones->listarDetalleAsignadosUsuario($idUsuario);
        $items = array();

        if (!empty($listadoItems)) {
            foreach($listadoItems as $value)
            {
                //Obtener elemento
                if($value['TipoElemento']=='MOVIL')
                {
                    $dataElemento = $this->moviles->obtenerMovil($value['IDElemento']);
                    $elemento = $value['TipoElemento'].' | '.$dataElemento['IMEI'].' '.$dataElemento['Marca'].' '.$dataElemento['Modelo'];
                }
                else if($value['TipoElemento']=='LINEA')
                {
                    $dataElemento = $this->lineas->obtenerLinea($value['IDElemento']);
                    $elemento = $value['TipoElemento'].' | '.$dataElemento['Numero'].' '.$dataElemento['Operador'].' '.$dataElemento['Plan'].' '.$dataElemento['ICCID'];
                }
                else
                {
                    $elemento = '';
                }
                //var_dump($items);
            
                $items[] = array(
					'idDetalleAsignacion' => (string) $value['IDDetalleAsignacion'],
         	        'item' => (string) $elemento
                );
            }

            $resultado = array(
				'listadoItems' => json_encode($items)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
    }
    
    public function registrarDevolucion()
    {
        $fechaActual = date("Y-m-d H:i:s");
        $fechaActualAdd = date("Y-m-d H:i:s", strtotime($fechaActual)+1);
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        

        $msjError = TRUE;
        $usuarioDevolucion = $this->request->getPost('txtUsuarioDevolucion');
        $observacion = $this->request->getPost('txtObservacion');
        
        $elemento = $this->request->getPost('elemento');
        $etiqueta = $this->request->getPost('etiqueta');
        $situacion = $this->request->getPost('txtSituacionElemento');
        $obsElemento = $this->request->getPost('txtObservacionElemento');
        
        $adjunto = $this->request->getFile("fileAdjuntoDevolucion");
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        $error = '';
        $error .= $this->complementos->validaCampo($usuarioDevolucion, 'required|trim', 'Usuario');
        $error .= $this->complementos->validaCampo($observacion, 'required|trim', 'Observación');
        
        if(empty($situacion))
        {
            $error .= "<li>Debe seleccionar la situación del item mostrado.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $arraySituacion = array_column($situacion, 'SITUACION');
        
        if(in_array("ROB", $arraySituacion) || in_array("PER", $arraySituacion))
        {
            /*
            * ----------------------------
            * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
            * ----------------------------
            */
            
            if (! $adjunto->isValid()) {
                $message = sprintf($this->mensajeError->msg201, $adjunto->getErrorString().'-'.$adjunto->getError());
                echo $this->alertas->alertaError($message);
                exit;
            }
            
            /*
            * ----------------------------
            * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
            * ----------------------------
            */
            
            $validationRule = [
                'fileAdjuntoDevolucion' => [
                    'mime_in[fileAdjuntoDevolucion,image/png,image/jpg,image/jpeg,image/gif,application/pdf]',
                    'ext_in[fileAdjuntoDevolucion,pdf]'
                ],
            ];

            if (! $this->validate($validationRule)) {
                $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        foreach($elemento as $detalle)
        {
            $elementoDevuelto = $this->devolucionesDetalle->where("IDDetalleAsignacion", $detalle)->findAll();

            if(!empty($elementoDevuelto))
            {
                $msgExistencia .= "<li>El ".$etiquetaitem[$detalle]['ETIQUETA']." ya fue devuelto.</li>";
            }
        }
		
        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * INSERCIÓN DE DATOS DEVOLUCIÓN
        * ----------------------------
        */
        
        $datosUsuario = $this->usuarios->buscarUsuario($usuarioDevolucion);
        $tokenDevolucion = $this->complementos->generar_string_aleatorio(15);

        $dataDevolucion = array (
            'UsuarioDevolucion'         => $usuarioDevolucion, 
            'CargoDevolucion'           => $datosUsuario['Cargo'], 
            'AreaDevolucion'            => $datosUsuario['IdArea'], 
            'DepartamentoDevolucion'    => $datosUsuario['IdDpto'], 
            'Motivo'                    => "CESE", 
            'Observacion'               => $observacion, 
            'TokenLinkFirma'            => $tokenDevolucion, 
            'UsuarioCrea'               => $this->items['id'],
            'CargoCrea'                 => $this->items['cargo'], 
            'AreaCrea'                  => $this->items['idArea'], 
            'DepartamentoCrea'          => $this->items['dpto'], 
            'FechaCrea'                 => $fechaActual,
            'Localhost'                 => $this->request->getIPAddress()
        );

        $lastIdDevolucion = $this->devoluciones->insert($dataDevolucion, TRUE);
        
        if($lastIdDevolucion !== FALSE){
            $idDevolucion = $lastIdDevolucion;
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar la devolución. Inténtelo luego.[AD]</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $dataDetalleDevolucion = array();

        foreach($elemento as $detalle)
        {
            $dataDetalleDevolucion[] = array (
                'IDDevolucion'          => $idDevolucion, 
                'IDDetalleAsignacion'   => $detalle,  
                'MotivoDevolucion'      => $situacion[$detalle]['SITUACION'],
                'Observacion'           => $obsElemento[$detalle]['OBSERVACION'],
                'UsuarioCrea'           => $this->items['id'],
                'FechaCrea'             => $fechaActual,    
                'Localhost'             => $this->request->getIPAddress()
            );
        }
        $lastIdDetalleDevolucion = $this->devolucionesDetalle->insertBatch($dataDetalleDevolucion);
        
		if($lastIdDetalleDevolucion === FALSE){
            $this->devoluciones->where('IDDevolucion', $idDevolucion)->delete();
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la devolución. Inténtelo luego.[ADD]");
			echo $this->alertas->alertaError($message);
			exit;
		} 

        $situacionesReposicion = array_diff($arraySituacion, array("DEV"));

        if(!empty($situacionesReposicion))
        {
            /*
            * ----------------------------
            * INSERCIÓN DE DATOS REPOSICIÓN
            * ----------------------------
            */

            $datosAdjudicado = $this->usuarios->buscarUsuario($usuarioDevolucion);
            $tokenReposicion = $this->complementos->generar_string_aleatorio(15);

            $dataReposicion = array (
                'UsuarioAdjudicado'         => $usuarioDevolucion, 
                'CargoAdjudicado'           => $datosAdjudicado['Cargo'], 
                'AreaAdjudicado'            => $datosAdjudicado['IdArea'], 
                'DepartamentoAdjudicado'    => $datosAdjudicado['IdDpto'], 
                'TokenLinkFirma'            => $tokenReposicion, 
                'LiberadoFirma'             => "Y", 
                'Motivo'                    => "REPOSICIÓN POR ACTA DE DEVOLUCIÓN", 
                'Observacion'               => $observacion, 
                'Cuotas'                    => 'N', 
                'UsuarioCrea'               => $this->items['id'],
                'CargoCrea'                 => $this->items['cargo'], 
                'AreaCrea'                  => $this->items['idArea'], 
                'DepartamentoCrea'          => $this->items['dpto'], 
                'FechaCrea'                 => $fechaActualAdd,    
                'Localhost'                 => $this->request->getIPAddress()
            );

            $lastIdReposicion = $this->reposiciones->insert($dataReposicion, TRUE);
            
            if($lastIdReposicion !== FALSE){
                $idReposicion = $lastIdReposicion;
            }
            else
            {
                $this->devolucionesDetalle->where('IDDevolucion', $idDevolucion)->delete();
                $this->devoluciones->where('IDDevolucion', $idDevolucion)->delete();
                $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar la devolución. Inténtelo luego[AR].</li>");
                echo $this->alertas->alertaError($message);
                EXIT;
            }

            $dataDetalle = array();
            $totalSumaTrabajador = 0;

            foreach($elemento as $detalle)
            {
                if($situacion[$detalle]['SITUACION'] != 'DEV')
                {
                    $detalleAsignacion = $this->detalleasignaciones->obtenerDetalleAsignacion($detalle);

                    if($detalleAsignacion['TipoElemento']=="LINEA")
                    {
                        $totalDescuento = 1;
                        $totalVerisure = 0;
                        $totalTrabajador = 1;
                    }
                    else if($detalleAsignacion['TipoElemento']=="MOVIL")
                    {
                        $contrato = $this->contratos->obtenerContratosXEquipo($detalleAsignacion['IDElemento']);
                        $montoTotal = $this->complementos->calculoPenalidadMovil($contrato);
                        $cantidadRobo = $this->detalleasignaciones->obtenerMovilesRobadosUsuario($usuarioDevolucion);
                        $porcentajes = $this->complementos->calculoPorcentajeResponsabilidadMovil(count($cantidadRobo), $montoTotal, $situacion[$detalle]['SITUACION']);

                        $totalDescuento = $montoTotal;
                        $totalVerisure = $porcentajes['VERISURE'];
                        $totalTrabajador = $porcentajes['TRABAJADOR'];
                    }
                    else
                    {
                        $totalDescuento = "0";
                        $totalVerisure = "0";
                        $totalTrabajador = "0";
                    }
                    
                    $dataDetalle[] = array (
                        'IDReposicion'          => $idReposicion, 
                        'IDDetalleAsignacion'   => $detalle,  
                        'TotalDescuento'        => $totalDescuento, 
                        'TotalVerisure'         => $totalVerisure, 
                        'TotalTrabajador'       => $totalTrabajador, 
                        'Observacion'           => $obsElemento[$detalle]['OBSERVACION'], 
                        'UsuarioCrea'           => $this->items['id'],
                        'FechaCrea'             => $fechaActualAdd,    
                        'Localhost'             => $this->request->getIPAddress()
                    );

                    $totalSumaTrabajador += $totalTrabajador;
                }
            }

            $lastIdDetalleReposicion = $this->reposicionesDetalle->insertBatch($dataDetalle);
            
            if($lastIdDetalleReposicion === FALSE){
                $this->devolucionesDetalle->where('IDDevolucion', $idDevolucion)->delete();
                $this->devoluciones->where('IDDevolucion', $idDevolucion)->delete();
                $this->reposiciones->where('IDReposicion', $idReposicion)->delete();
                $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la devolución. Inténtelo luego.[ARD]");
                echo $this->alertas->alertaError($message);
                exit;
            } 
            
            /*
            * ----------------------------
            * INSERCIÓN DE DATOS REPOSICIÓN - CRONOGRAMA DE PAGOS
            * ----------------------------
            */
            
            $diaPlanilla = $this->globales->diaCortePlanilla();

            $cuotasTrabajador = 1;

            $fechaPlanillaActual = date("Y-m-".$diaPlanilla);

            $timePlanilla = strtotime($fechaPlanillaActual);
            $timeActual = strtotime($fechaActual);

            $mesInicioCuotas=0;
            $anioInicioCuotas=0;

            if($timePlanilla > $timeActual)
            {
                $mesInicioCuotas = date("m");
                $anioInicioCuotas = date("Y");
            }
            else
            {
                $mesActual = date("m");
                $anioActual = date("Y");

                if($mesActual == 12)
                {
                    $mesInicioCuotas = 1;
                    $anioInicioCuotas = $anioActual +1 ;
                }
                else
                {
                    $mesInicioCuotas = $mesActual + 1;
                    $anioInicioCuotas = $anioActual;
                }
            }

            $dataCronogramaPago = array();
            
            $descuentoMensual = number_format(round($totalSumaTrabajador / $cuotasTrabajador, 2), 2, '.', '');

            for($i=1; $i<=$cuotasTrabajador;$i++)
            {
                if($i == ($cuotasTrabajador))
                {
                    $montoCuota = ($totalSumaTrabajador - (($cuotasTrabajador - 1)*$descuentoMensual));
                }
                else
                {
                    $montoCuota = $descuentoMensual;
                }

                $dataCronogramaPago[] = array (
                    'IDReposicion'          => $idReposicion, 
                    'NroCuota'              => $i, 
                    'MesCuota'              => $mesInicioCuotas, 
                    'AnioCuota'             => $anioInicioCuotas, 
                    'MontoCuota'            => $montoCuota, 
                    'Observacion'           => 'Cuota generada automáticamente', 
                    'UsuarioCrea'           => $this->items['id'],
                    'FechaCrea'             => $fechaActual,    
                    'Localhost'             => $this->request->getIPAddress()
                );

                $mesInicioCuotas++;

                if($mesInicioCuotas > 12)
                {
                    $mesInicioCuotas = 1;
                    $anioInicioCuotas = $anioInicioCuotas + 1;
                }
            }

            $lastIdCronograma = $this->reposicionesCronogramaPago->insertBatch($dataCronogramaPago);
            
            if($lastIdCronograma === FALSE){
                $this->reposicionesDetalle->where('IDReposicion', $idReposicion)->delete();
                $this->reposiciones->where('IDReposicion', $idReposicion)->delete();
                $this->devolucionesDetalle->where('IDDevolucion', $idDevolucion)->delete();
                $this->devoluciones->where('IDDevolucion', $idDevolucion)->delete();
                $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la reposición. Inténtelo luego.[INSERT]");
                echo $this->alertas->alertaError($message);
                exit;
            } 

            
            /*
            * ----------------------------
            * GUARDAR ARCHIVO ADJUNTO
            * ----------------------------
            */
            
            
            if($adjunto->guessExtension() != null)
            {
                $extensionDoc = $adjunto->guessExtension();
            }
            else
            {
                $nombre_original = $adjunto->getBasename();
                $fileNameCmps = explode(".", $nombre_original);
                $extensionDoc = strtolower(end($fileNameCmps));
            }

            if(in_array("ROB", $arraySituacion) || in_array("PER", $arraySituacion))
            {
                /*
                * ----------------------------
                * INSERCIÓN DE DATOS ADJUNTOS
                * ----------------------------
                */

                $dataAdjuntoReposicion = array (
                    'IDReposicion'      => $idReposicion, 
                    'Nombre'            => "Denuncia Reposición", 
                    'Extension'         => $extensionDoc,
                    'Observacion'       => "Reporte de denuncia de equipos.",
                    'ReemplazoFirma'    => "N",  
                    'UsuarioCrea'       => $this->items['id'],
                    'FechaCrea'         => $fechaActualAdd,    
                    'Localhost'         => $this->request->getIPAddress()
                );

                $lastIdAdjuntosReposiciones = $this->reposicionesAdjuntos->insert($dataAdjuntoReposicion, TRUE);

                if($lastIdAdjuntosReposiciones === FALSE){
                    $this->reposicionesCronogramaPago->where('IDReposicion', $idReposicion)->delete();
                    $this->reposicionesDetalle->where('IDReposicion', $idReposicion)->delete();
                    $this->reposiciones->where('IDReposicion', $idReposicion)->delete();
                    $this->devolucionesDetalle->where('IDDevolucion', $idDevolucion)->delete();
                    $this->devoluciones->where('IDDevolucion', $idDevolucion)->delete();
                    $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el acta de devolución. Inténtelo luego.[ARA]");
                    echo $this->alertas->alertaError($message);
                    exit;
                }

                /*
                * ----------------------------
                * GUARDAR ARCHIVO ADJUNTO REPOSICIÓN
                * ----------------------------
                */
                $ruta = "public/docs/ActaReposicion/";
                $nombreArchivo = $idReposicion."-".$lastIdAdjuntosReposiciones;

                if(!file_exists($ruta))
                {
                    @mkdir($ruta, 0777, true);
                }

                # si exsite la carpeta o se ha creado
                if (file_exists($ruta) || @mkdir($ruta)) 
                {
                    $nuevonombre = $nombreArchivo.'.'.$extensionDoc;
                    
                    $estadoMove = $adjunto->move($ruta, $nuevonombre);
                    
                    if (!$estadoMove) {
                        $this->reposicionesCronogramaPago->where('IDReposicion', $idReposicion)->delete();
                        $this->reposicionesAdjuntos->where('IDAdjuntoReposicion', $lastIdAdjuntosReposiciones)->delete();
                        $this->reposicionesDetalle->where('IDReposicion', $idReposicion)->delete();
                        $this->reposiciones->where('IDReposicion', $idReposicion)->delete();
                        $this->devolucionesDetalle->where('IDDevolucion', $idDevolucion)->delete();
                        $this->devoluciones->where('IDDevolucion', $idDevolucion)->delete();
                        $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el acta de devolución. Inténtelo luego.[SAVEDOC]");
                        echo $this->alertas->alertaError($message);
                        exit;
                    }
                }
                else
                {
                    $this->reposicionesCronogramaPago->where('IDReposicion', $idReposicion)->delete();
                    $this->reposicionesAdjuntos->where('IDAdjuntoReposicion', $lastIdAdjuntosReposiciones)->delete();
                    $this->reposicionesDetalle->where('IDReposicion', $idReposicion)->delete();
                    $this->reposiciones->where('IDReposicion', $idReposicion)->delete();
                    $this->devolucionesDetalle->where('IDDevolucion', $idDevolucion)->delete();
                    $this->devoluciones->where('IDDevolucion', $idDevolucion)->delete();
                    $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
                    echo $this->alertas->alertaError($message);
                    exit;
                }
            }

            
            /*
            * ----------------------------
            * PREPARACIÓN DE CUERPO DE CORREO DE REPOSICIÓN
            * ----------------------------
            */

            $arrayCuerpo = array(
                "TITULO" => "ACTA DE REPOSICIÓN",
                "ACTA" => "ACTA DE REPOSICIÓN",
                "USUARIO" => ucwords(mb_strtolower($datosAdjudicado['Nombres'].' '.$datosAdjudicado['Apellidos'])),
                "URL_ACTA" => base_url()."/acta-reposicion/".$idReposicion."/".$tokenReposicion
            );

            $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActas($arrayCuerpo);
            
            /*
            * ----------------------------
            * PREPARACIÓN DE PARAMETROS PARA EL CORREO
            * ----------------------------
            */

            $asunto='ACTA DE REPOSICIÓN: '.$idReposicion.' - '.$datosAdjudicado['Nombres'].' '.$datosAdjudicado['Apellidos'];
            //$correoDestino = array($asignado['Correo']);
            $configCorreo = array(
                "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
                "CORREO_ORIGEN" => $this->items['correoElectronico'],
                "CORREOS_DESTINOS" => array($this->items['correoElectronico']),
                "CORREOS_COPIA" => array("josejesus.cuadros@verisure.pe"),
                "CORREOS_OCULTO" => array(),
                "ASUNTO" => $asunto,
                "MENSAJE" => $cuerpo
            );

            $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);

            $dataCorreo = array(
                "IDReposicion"  => $idReposicion,
                "Response"      => $estadoCorreo['RESPUESTA'],
                "Error"         => $estadoCorreo['ERROR'],
                'UsuarioCrea'   => $this->items['id'],
                'FechaCrea'     => $fechaActual,    
                'Localhost'     => $this->request->getIPAddress()
            );

            $this->correoStatusReposicion->insert($dataCorreo, TRUE);
            
        }
        
        /*
        * ----------------------------
        * PREPARACIÓN DE CUERPO DE CORREO DE DEVOLUCIÓN
        * ----------------------------
        */

        $arrayCuerpo = array(
            "TITULO" => "ACTA DE DEVOLUCIÓN",
            "ACTA" => "ACTA DE DEVOLUCIÓN",
            "USUARIO" => ucwords(mb_strtolower($datosUsuario['Nombres'].' '.$datosUsuario['Apellidos'])),
            "URL_ACTA" => base_url()."/acta-devolucion/".$idDevolucion."/".$tokenDevolucion
        );

        $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActas($arrayCuerpo);
        
        /*
        * ----------------------------
        * PREPARACIÓN DE PARAMETROS PARA EL CORREO
        * ----------------------------
        */

        $asunto='ACTA DE DEVOLUCIÓN: '.$idDevolucion.' - '.$datosUsuario['Nombres'].' '.$datosUsuario['Apellidos'];
        //$correoDestino = array($asignado['Correo']);
        $configCorreo = array(
            "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
            "CORREO_ORIGEN" => $this->items['correoElectronico'],
            "CORREOS_DESTINOS" => array($this->items['correoElectronico']),
            "CORREOS_COPIA" => array("josejesus.cuadros@verisure.pe"),
            "CORREOS_OCULTO" => array(),
            "ASUNTO" => $asunto,
            "MENSAJE" => $cuerpo
        );

        $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);

        $dataCorreo = array(
            "IDDevolucion"  => $idDevolucion,
            "Response"      => $estadoCorreo['RESPUESTA'],
            "Error"         => $estadoCorreo['ERROR'],
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $this->correoStatusDevolucion->insert($dataCorreo, TRUE);
        
        $message = sprintf($this->mensajeError->msg201, "La devolución fue solicitada exitosamente.");
        echo $this->alertas->alertaExito($message);
        echo $this->alertas->reDireccion(base_url()."/documento-devolucion/".$idDevolucion, 1);
        
    }

    public function enviarCorreoDevolucion()
    {
        $fechaActual = date("Y-m-d H:i:s");

        $idDevolucion = $this->request->getPost('idDevolucion');
        $devolucion = $this->devoluciones->where("IDDevolucion", $idDevolucion)->first();
        $usuarioDevolucion = $this->usuarios->buscarUsuario($devolucion['UsuarioDevolucion']);
        
		/*
        * ----------------------------
        * PREPARACIÓN DE CUERPO DE CORREO
        * ----------------------------
		*/

        $arrayCuerpo = array(
            "TITULO" => "ACTA DE DEVOLUCIÓN",
            "ACTA" => "ACTA DE DEVOLUCIÓN",
            "USUARIO" => ucwords(mb_strtolower($usuarioDevolucion['Nombres'].' '.$usuarioDevolucion['Apellidos'])),
            "URL_ACTA" => base_url()."/acta-devolucion/".$idDevolucion."/".$devolucion['TokenLinkFirma']
        );

        $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActas($arrayCuerpo);
		/*
        * ----------------------------
        * PREPARACIÓN DE PARAMETROS PARA EL CORREO
        * ----------------------------
		*/

        $asunto='ACTA DE DEVOLUCIÓN: '.$idDevolucion.' - '.$usuarioDevolucion['Nombres'].' '.$usuarioDevolucion['Apellidos'];
        //$correoDestino = array($asignado['Correo']);
        $configCorreo = array(
            "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
            "CORREO_ORIGEN" => $this->items['correoElectronico'],
            "CORREOS_DESTINOS" => array($this->items['correoElectronico']),
            "CORREOS_COPIA" => array("josejesus.cuadros@verisure.pe"),
            "CORREOS_OCULTO" => array(),
            "ASUNTO" => $asunto,
            "MENSAJE" => $cuerpo
        );

        $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);

        $dataCorreo = array(
            "IDDevolucion"  => $idDevolucion,
            "Response"      => $estadoCorreo['RESPUESTA'],
            "Error"         => $estadoCorreo['ERROR'],
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $this->correoStatusDevolucion->insert($dataCorreo, TRUE);

        if($estadoCorreo['ERROR'] != '')
        {
            $message = sprintf($this->mensajeError->msg201, "No se pudo enviar el correo. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "Se envió el correo correctamente.");
            echo $this->alertas->alertaExito($message);
        }
        
    }
    
    public function adjuntarDocumentoDevolucion($idDevolucion)
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $nombre = $this->request->getPost('txtNombreAdjunto_i');
        $observacion = $this->request->getPost('txtObservacionAdjunto_i');
        $reemplazafirma = $this->request->getPost('chkAdjuntoFirma');
        $adjunto = $this->request->getFile("fileAdjuntoDevolucion");

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($nombre, 'required|trim|minlength[9]|maxlength[50]', 'Nombre');
        $error .= $this->complementos->validaCampo($observacion, 'trim', 'Observación');
        

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $adjunto->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $adjunto->getErrorString().'-'.$adjunto->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'fileAdjuntoDevolucion' => [
                'mime_in[fileAdjuntoDevolucion,image/png,image/jpg,image/jpeg,image/gif,application/pdf]',
                'ext_in[fileAdjuntoDevolucion,pdf]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        if($adjunto->guessExtension() != null)
        {
            $extensionDoc = $adjunto->guessExtension();
        }
        else
        {
            $nombre_original = $adjunto->getBasename();
            $fileNameCmps = explode(".", $nombre_original);
            $extensionDoc = strtolower(end($fileNameCmps));
        }
        
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */

        $data = array (
            'IDDevolucion'      => $idDevolucion, 
            'Nombre'            => $nombre, 
            'Extension'         => $extensionDoc,
            'Observacion'       => $observacion,
            'ReemplazoFirma'    => ((isset($reemplazafirma) && $reemplazafirma != null) ? 'Y' : 'N'),  
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->devolucionesAdjuntos->insert($data, TRUE);

		if($lastId === FALSE){
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
			exit;
		}

        /*
        * ----------------------------
        * GUARDAR ARCHIVO ADJUNTO
        * ----------------------------
        */
        $ruta = "public/docs/ActaDevolucion/";
        $nombreArchivo = $idDevolucion."-".$lastId;

        if(!file_exists($ruta))
        {
            @mkdir($ruta, 0777, true);
        }

		# si exsite la carpeta o se ha creado
		if (file_exists($ruta) || @mkdir($ruta)) 
        {
            $nuevonombre = $nombreArchivo.'.'.$extensionDoc;
            
            $estadoMove = $adjunto->move($ruta, $nuevonombre);
            
            if (!$estadoMove) {
                $this->devolucionesAdjuntos->delete(["IDAdjuntoDevolucion", $lastId]);
                $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[SAVEDOC]");
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
            echo $this->alertas->alertaError($message);
        }
        
        $message = sprintf($this->mensajeError->msg201, "El archivo adjunto fue registrado exitosamente.");
        echo $this->alertas->alertaExito($message);
        echo $this->alertas->refrescar(1);
    }
    
}