<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Globales;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

require 'vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;

class Planificacion extends BaseController
{
	public function __construct(){
		$this->usuarioModelo = new \App\Models\UsuarioModelo();
		$this->perfilModelo = new \App\Models\PerfilModelo();
		$this->subAccionModelo = new \App\Models\SubAccionModelo();
        $this->direccionModelo = new \App\Models\DireccionModel();
        $this->departamentoINEI = new \App\Models\INEIDepartamentoModel();
        $this->provinciaINEI = new \App\Models\INEIProvinciaModel();
        $this->distritoINEI = new \App\Models\INEIDistritoModel();
        $this->modulo = new \App\Models\ModuloModel();
        $this->moduloAcciones = new \App\Models\ModulosAccionesModel();
        $this->moduloRutas = new \App\Models\ModulosRutasModel();
        $this->moduloCabecera = new \App\Models\ModulosCabeceraModel();
        $this->perfilPermisos = new \App\Models\PerfilPermisosModelo();
        $this->perfilRutas = new \App\Models\PerfilRutasModelo();
        
        $this->grupoTrabajo = new \App\Models\GruposTrabajoModel();
        $this->grupoTrabajoUsuarios = new \App\Models\UsuarioGruposTrabajoModel();
        $this->horarios = new \App\Models\HorariosModel();
        $this->asistencia = new \App\Models\AsistenciaModel();
        $this->planificacion = new \App\Models\PlanificacionModel();
        $this->metricasDesempeno = new \App\Models\MetricasDesempenoModel();
        
        $this->sistemas = new \App\Models\SistemasModel();
		$this->departamentos = new \App\Models\DepartamentoModel();
        $this->areas = new \App\Models\AreaModel();
        $this->cargos = new \App\Models\CargosModel();
        
        
        $this->estructuraDirecciones = new \App\Models\EstructuraDireccionModel();
        $this->estructuraAreas = new \App\Models\EstructuraAreaModel();
        $this->estructuraSubareas = new \App\Models\EstructuraSubareaModel();
        $this->estructuraSubareaDelegaciones = new \App\Models\EstructuraSubareaDelegacionesModel();
        $this->estructuraDelegaciones = new \App\Models\EstructuraDelegacionModel();
	}

	public function listarPlanificacion(){
	    
		if(isset($this->items['id'])){ 
		    $idUsuarioPlanificacion = $this->items['id'];
		    
            if(in_array('VIUSPL',$this->items['permisos'])){
                
                $fechaActual = date("Y-m-d");
    			
    			// Utiliza la función DATE() para comparar solo la fecha en tu consulta
                $asistenciaUsuario = $this->asistencia
                    ->where('IdUsuario', $idUsuarioPlanificacion)
                    ->where('DATE(FechaHoraRegistro)', $fechaActual)
                    // ->orderBy('FechaHoraRegistro', 'DESC')
                    ->findAll();
              
                // Inicializar un array para guardar el estado de cada evento (inicio o fin)
                $estadoEventos = [];
                foreach ($asistenciaUsuario as $asistencia) {
                    $estadoEventos[$asistencia['id_horario']] = $asistencia['TipoRegistro'];
                }
                
                $data = array (
				'session'               => 'on',
				'titulo'                => 'Planificación | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Listado de planificación',
				'idUsuarioPlanificacion'    => $idUsuarioPlanificacion,
				'estadoEventos'         => $estadoEventos
    			);
    			
    			$data = array_merge($data, $this->items);
    			
    			return view('planificacion/ver_planificacion_usuario',$data);
    			
            }else if (in_array('VIADPL',$this->items['permisos'])){
            /* NUEVO REQUERIMIENTO */
		    
		    $idUsuario = $this->items['id'];
			
			/* GRUPO DE TRABAJO */
			
			$whereUsuarioCrea = array(
				'JefeGrupoTrabajo' => $idUsuario
			);
			
		    $grupoTrabajo = $this->grupoTrabajo->where($whereUsuarioCrea)->findAll(); 
		
			/* USUARIOS GRUPO DE TRABAJO */
			
			$whereUsuarioRegistra = array(
				'UsuarioRegistra' => $idUsuario
			);
			
			$grupoTrabajoUsuarios = $this->grupoTrabajoUsuarios->where($whereUsuarioRegistra)->findAll();
			
            /* BUSCAR PERFILES  */
            
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Planificación | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Listado de planificación',
				'grupoTrabajo'          => $grupoTrabajo,
				'grupoTrabajoUsuarios'  => $grupoTrabajoUsuarios
			);
			$data = array_merge($data, $this->items);
			return view('planificacion/listar_planificacion',$data);
            }else{
                return view('errors/500');
            }			
		} else {
			return view('errors/500');	
		}
        
	}
	
	public function listarPlanificacionDataTable()
    {
        $fechaActual = date("Y-m-d");
        $idGrupoTrabajo = $this->request->getVar('idGrupoTrabajo');
        $idUsuario = $this->items['id'];
        $adicionales = array(
            "grupostrabajo.JefeGrupoTrabajo" => $idUsuario,
            "grupostrabajo.IdGrupoTrabajo" => $idGrupoTrabajo,
            "planificacion.FechaTrabajo"   => $fechaActual
        );

        // $adicionales = array(
        //     "IDPerfil"  => $this->items['idPerfil'],
        //     "IDUsuario" => $this->items['id'],
        //     'IdGrupoTrabajo' => 4
        // );
        /* LISTAR ORDEN DE COMPRA */
        $dataServerside = $this->planificacion->listaPlanificacionServerSide($this->request->getGet(), $adicionales);
        $recordsTotal = !empty($dataServerside) ? count($dataServerside) : 0;
        // $recordsFiltered = count($this->horarios->where('EliminacionLogica',1)->findAll());
        $wherePlanificacion = array('UsuarioCreador' => $this->items['id']);
        $recordsFiltered = count($this->planificacion->where($wherePlanificacion)->groupBy('IdUsuario')->findAll());
        
        foreach($dataServerside as $key=>$value)
        {
            $dataServerside[$key]['Acciones'] = "<div class='dropdown d-inline-block'>
                                                    <button class='btn btn-soft-secondary btn-sm dropdown' type='button' data-bs-toggle='dropdown' aria-expanded='false'>
                                                    <i class='ri-more-fill align-middle'></i>
                                                    </button>
                                                    <ul class='dropdown-menu dropdown-menu-end'>
                                                        <li>
                                                            <a href='".$this->items['baseUrl']."/listar-planificacion-usuario/". $value['IdUsuario'] ."' class='dropdown-item d-flex justify-content-start align-items-center' data-idplanificacion='" . $value['IdPlanificacion'] . "'>
                                                                <i class='mdi mdi-routes-clock align-bottom me-2 text-muted' style='font-size: 18px;'></i> Ver Horario
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div>";
            if($value['Estado'] == 'Activo'){
                $dataServerside[$key]['EstadoUsuario'] = "<button class='badge bg-success border-0')>Activo</button>";
            }else{
                $dataServerside[$key]['EstadoUsuario'] = "<button class='badge bg-danger border-0')>Inactivo</button>";
            }
        }

        $datos = [
            'draw' => $this->request->getGet('draw'),
            'recordsTotal' => $recordsTotal,
            'recordsFiltered' => $recordsFiltered,
            'data' => $dataServerside
        ];
        echo json_encode($datos, JSON_NUMERIC_CHECK);    
    }
    
	public function listarPlanificacionUsuario($idUsuarioPlanificacion)
    {
        $fechaActual = date("Y-m-d");
		if(isset($this->items['id'])){
		    $idUsuarioSession = $this->items['id'];
		    /************ TARDANZA | HE | FALTAS **************/
		    $whereMetrica = array('p.FechaTrabajo >=' => '2024-10-02',
                                  'p.FechaTrabajo <=' => $fechaActual,
                                  'tblusuario.idUsuario' => $idUsuarioPlanificacion);   
                                  
		    $dataMetricas = $this->usuarioModelo
                ->select('
                    tblusuario.idUsuario, 
                    tblusuario.Nombres, 
                    tblusuario.Apellidos, 
                    p.FechaTrabajo,
                    a_inicio.IdAsistencias AS inicio_asistencia,
                    a_inicio.Motivo AS motivo_cambio,
                    a_fin.IdAsistencias AS fin_asistencia,
                    TIME_FORMAT(a_inicio.FechaHoraRegistro, "%H:%i:%s") AS InicioTrabajo,
                    DATEDIFF(CURDATE(), tblusuario.FechaIngreso) / 30 AS meses_en_empresa,
                    -- Horas trabajadas
                    CASE
                        -- Horarios que cruzan la medianoche
                        WHEN h.HoraFin < h.HoraInicio THEN 
                            TIME_FORMAT(SEC_TO_TIME(SUM(TIME_TO_SEC(
                                TIMEDIFF(
                                    -- Si la hora de salida es al día siguiente, ajustamos el cálculo
                                    IF(a_fin.FechaHoraRegistro < CONCAT(p.FechaTrabajo, " ", h.HoraInicio), 
                                        CONCAT(DATE_ADD(p.FechaTrabajo, INTERVAL 1 DAY), " ", h.HoraFin), 
                                        a_fin.FechaHoraRegistro), 
                                    a_inicio.FechaHoraRegistro)
                            ))), "%H:%i:%s")
                        ELSE 
                            -- Horarios normales
                            TIME_FORMAT(SEC_TO_TIME(SUM(TIME_TO_SEC(TIMEDIFF(a_fin.FechaHoraRegistro, a_inicio.FechaHoraRegistro)))), "%H:%i:%s")
                    END AS horas_trabajadas,
                    
                    -- Tardanzas
                    CASE
                        -- Horarios que cruzan la medianoche
                        WHEN h.HoraFin < h.HoraInicio THEN 
                            CASE 
                               
                                WHEN a_inicio.FechaHoraRegistro > CONCAT(p.FechaTrabajo, " ", h.HoraInicio) THEN 
                                    TIME_FORMAT(SEC_TO_TIME(SUM(TIME_TO_SEC(TIMEDIFF(a_inicio.FechaHoraRegistro, CONCAT(p.FechaTrabajo, " ", h.HoraInicio))))), "%H:%i:%s")
                                
                                WHEN a_inicio.FechaHoraRegistro > CONCAT(DATE_ADD(p.FechaTrabajo, INTERVAL 1 DAY), " ", h.HoraFin) THEN 
                                    TIME_FORMAT(SEC_TO_TIME(SUM(TIME_TO_SEC(TIMEDIFF(a_inicio.FechaHoraRegistro, CONCAT(DATE_ADD(p.FechaTrabajo, INTERVAL 1 DAY), " ", h.HoraFin))))), "%H:%i:%s")
                                ELSE "00:00:00"
                            END
                        ELSE
                            -- Horarios normales que no cruzan la medianoche
                            CASE 
                                WHEN a_inicio.FechaHoraRegistro > CONCAT(p.FechaTrabajo, " ", h.HoraInicio) THEN 
                                    TIME_FORMAT(SEC_TO_TIME(SUM(TIME_TO_SEC(TIMEDIFF(a_inicio.FechaHoraRegistro, CONCAT(p.FechaTrabajo, " ", h.HoraInicio))))), "%H:%i:%s")
                                ELSE "00:00:00"
                            END
                    END AS tardanza,
                    
                    -- Horas extras
                    CASE
                        -- Horarios que cruzan la medianoche
                        WHEN h.HoraFin < h.HoraInicio THEN
                            CASE
                                -- Si la hora de salida es mayor que la hora fin al día siguiente
                                WHEN a_fin.FechaHoraRegistro > CONCAT(DATE_ADD(p.FechaTrabajo, INTERVAL 1 DAY), " ", h.HoraFin) THEN 
                                    TIMEDIFF(a_fin.FechaHoraRegistro, CONCAT(DATE_ADD(p.FechaTrabajo, INTERVAL 1 DAY), " ", h.HoraFin))
                                ELSE "00:00:00"
                            END
                        ELSE
                            -- Horarios normales
                            CASE
                                WHEN a_fin.FechaHoraRegistro > CONCAT(p.FechaTrabajo, " ", h.HoraFin) THEN 
                                    TIMEDIFF(a_fin.FechaHoraRegistro, CONCAT(p.FechaTrabajo, " ", h.HoraFin))
                                ELSE "00:00:00"
                            END
                    END AS horas_extras,
                    
                    -- Faltas
                    COUNT(CASE 
                        -- Si no hay registro de inicio ni fin
                        WHEN a_inicio.FechaHoraRegistro IS NULL AND a_fin.FechaHoraRegistro IS NULL THEN 1
                        -- Horarios que cruzan la medianoche
                        WHEN h.HoraFin < h.HoraInicio AND 
                             a_inicio.FechaHoraRegistro IS NULL AND a_fin.FechaHoraRegistro IS NULL THEN 1
                    END) AS total_faltas
                ')

                ->join('planificacion p', 'p.IdUsuario = tblusuario.idUsuario')
                ->join('horarios h', 'p.id_horario = h.id_horario')
                ->join('asistencia a_inicio', 'p.IdUsuario = a_inicio.IdUsuario AND a_inicio.TipoRegistro = "inicio" AND a_inicio.FechaHoraRegistro LIKE CONCAT(p.FechaTrabajo, "%") AND a_inicio.id_horario = p.id_horario','left')
                ->join('asistencia a_fin', 'p.IdUsuario = a_fin.IdUsuario AND a_fin.TipoRegistro = "fin" AND a_fin.FechaHoraRegistro LIKE CONCAT(p.FechaTrabajo, "%") AND a_fin.id_horario = p.id_horario','left')
                ->groupBy('p.FechaTrabajo')
                ->where($whereMetrica)
            
                ->findAll();
                
		    
		    /****************************/
		    
			/* BUSCAR PERMISOS*/
			
			$whereDatos = array('planificacion.IdUsuario' => $idUsuarioPlanificacion,
			                    'horarios.EliminacionLogica' => 1,
			                    'planificacion.FechaTrabajo >=' => date('Y-m-01'),
			                    'planificacion.FechaTrabajo <=' => date('Y-m-t')); // como obtener el ultimo dia del mes actual
			
			$datos = $this->planificacion
			                ->join('horarios','planificacion.id_horario=horarios.id_horario','left')
			                ->where($whereDatos)
			                ->findAll();
			       
			//echo $this->planificacion->getLastQuery()->getQuery(); exit();
			
			$UsuarioCreadorPlanificacion = $this->planificacion->select('UsuarioCreador')->where('IdUsuario',$idUsuarioPlanificacion)->first();
			
			$whereHorarios = array('UsuarioRegistra' => $UsuarioCreadorPlanificacion['UsuarioCreador'],
			                       'EliminacionLogica' => 1);
			
			$dataHorarios = $this->horarios->where($whereHorarios)->findAll();
            
            /********************************************************************/
            $listadoHorarios = $this->horarios->listarHorariosXPlanificacion($idUsuarioPlanificacion);
            
            // Definir un conjunto de clases de colores
            $colorClasses = [
                'bg-success-subtle text-success',
                'bg-info-subtle text-info',
                'bg-warning-subtle text-warning',
                'bg-danger-subtle text-danger',
                'bg-secondary-subtle text-secondary',
                'bg-primary-subtle text-primary'
            ];
            
            // Barajar las clases de colores para la asignación aleatoria
            shuffle($colorClasses);
            
            // Generar HTML
            $htmlHorarios = '';
            $totalHorarios = count($listadoHorarios);
            $totalColorClasses = count($colorClasses);
            

            
            for ($i = 0; $i < $totalHorarios; $i++) {
                
                /*******************************************/
                $idGrupoTrabajo = $listadoHorarios[$i]['IDGrupoTrabajo'];
                $whereGrupoTrabajo = array('IDGrupoTrabajo' => $idGrupoTrabajo);
                
                $multiHorario = $this->grupoTrabajo->select('multi_horario')->where($whereGrupoTrabajo)->first();
                
                /******************************************/
    
                // Seleccionar la clase de color basada en el índice
                $colorClass = $colorClasses[$i % $totalColorClasses];
    
                // Generar el HTML dinámico
                $deshabilitar = "";
                if($idUsuarioPlanificacion == $idUsuarioSession){
                    $deshabilitar = "d-none";
                }
                $htmlHorarios .= '
                <div class="external-event fc-event '. $deshabilitar .' ' . $colorClass . '" data-class="' . $colorClass . '" data-id="' . $listadoHorarios[$i]['id_horario'] .  '" data-codigo="' . $listadoHorarios[$i]['codigo'] . '" data-horario="' . $listadoHorarios[$i]['horario'] . '" data-hora-inicio="' . $listadoHorarios[$i]['HoraInicio'] . '" data-hora-fin="' . $listadoHorarios[$i]['HoraFin'] . '"data-grupo-trabajo="' . $listadoHorarios[$i]['IDGrupoTrabajo'] . '"data-multi-horario="' . $multiHorario['multi_horario'] . '">
                    <i class="mdi mdi-checkbox-blank-circle me-2"></i>
                    ' . $listadoHorarios[$i]['horario'] . ' | ' . $listadoHorarios[$i]['codigo'] . '
                </div>';
            }
            
            /********************************************************************/

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Planificacion Horaria | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Planificacion Horaria',
                'previo'                => 'listar-planificacion',
                'idUsuarioPlanificacion'             => $idUsuarioPlanificacion,
                'htmlHorarios'          => $htmlHorarios, // Pasar HTML generado
                'dataMetricas'          => $dataMetricas,
                'idUsuarioSession'     => $idUsuarioSession,
                'deshabilitar'         => $deshabilitar
			);
		
			$data = array_merge($data, $this->items);
			return view('planificacion/listar_planificacion_usuario',$data);			
		} else {
			return view('errors/500');
		}
	}
	
	public function verPlanificacionHoraria($idGrupoTrabajo)
    {
		if(isset($this->items['id'])){
			/* BUSCAR PERMISOS*/
			
			// Obtener el último año y mes en FechaCreacion
            $subconsultaFecha = "(SELECT DATE_FORMAT(MAX(FechaCreacion), '%Y-%m') FROM planificacion)";
            
            $where = array(
                'planificacion.IDGrupoTrabajo' => $idGrupoTrabajo,
                'DATE_FORMAT(planificacion.FechaCreacion, "%Y-%m") =' => $subconsultaFecha
            );

            // Ejecutar la consulta
            $datos = $this->planificacion
                            ->distinct()
                            
                            ->join('horarios', 'planificacion.id_horario = horarios.id_horario', 'left')
                            ->where($where, null, false)
                            ->groupBy('horarios.id_horario')  // Agrupa por id_horario para evitar duplicados en horarios
                            ->findAll();
            
            // Definir un conjunto de clases de colores
            $colorClasses = [
                'bg-success-subtle text-success',
                'bg-info-subtle text-info',
                'bg-warning-subtle text-warning',
                'bg-danger-subtle text-danger',
                'bg-secondary-subtle text-secondary',
                'bg-primary-subtle text-primary'
            ];
            
            // Barajar las clases de colores para la asignación aleatoria
            shuffle($colorClasses);
            
            // Generar HTML
            $htmlHorarios = '';
            $totalHorarios = count($datos);
            $totalColorClasses = count($colorClasses);
            

            
            for ($i = 0; $i < $totalHorarios; $i++) {
                
                /*******************************************/
                // $idGrupoTrabajo = $datos[$i]['IDGrupoTrabajo'];
                $whereGrupoTrabajo = array('IDGrupoTrabajo' => $idGrupoTrabajo);
                
                $multiHorario = $this->grupoTrabajo->select('multi_horario')->where($whereGrupoTrabajo)->first();
                
                /******************************************/
    
                // Seleccionar la clase de color basada en el índice
                $colorClass = $colorClasses[$i % $totalColorClasses];
    
                // Generar el HTML dinámico
                $htmlHorarios .= '
                <div class="external-event fc-event ' . $colorClass . '" data-class="' . $colorClass . '" data-id="' . $datos[$i]['id_horario'] .  '" data-codigo="' . $datos[$i]['codigo'] . '" data-horario="' . $datos[$i]['horario'] . '" data-hora-inicio="' . $datos[$i]['HoraInicio'] . '" data-hora-fin="' . $datos[$i]['HoraFin'] . '"data-grupo-trabajo="' . $datos[$i]['IDGrupoTrabajo'] . '"data-multi-horario="' . $multiHorario['multi_horario'] . '">
                    <i class="mdi mdi-checkbox-blank-circle me-2"></i>
                    ' . $datos[$i]['horario'] . ' | ' . $datos[$i]['codigo'] . '
                </div>';
            }
            
            /********************************************************************/

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Planificacion Horaria Grupal | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Planificacion Horaria Grupal',
                'previo'                => 'listar-planificacion',
                'idGrupoTrabajo'             => $idGrupoTrabajo,
                'htmlHorarios'          => $htmlHorarios // Pasar HTML generado
			);
			$data = array_merge($data, $this->items);
			return view('planificacion/ver_planificacion_horaria',$data);			
		} else {
			return view('errors/500');
		}
	}
	
	public function CalendarioPlanificacion()
    { 

// 		if(isset($this->items['id'])){
			/* BUSCAR PERMISOS*/
			
			$fechaActual = date("Y-m-d");
            $idUsuarioPlanificacion = $this->request->getPost('idUsuarioPlanificacion');
          
            $start = $this->request->getPost('start'); // Fecha de inicio de la vista 

            $end = $this->request->getPost('end'); // Fecha de fin de la vista 

            // Asegúrate de que las fechas se conviertan al formato adecuado si es necesario
            $startDate = date('Y-m-d', strtotime($start));
            $endDate = date('Y-m-d', strtotime($end));
			
			$whereDatos = array('planificacion.IdUsuario' => $idUsuarioPlanificacion,
			                    'horarios.EliminacionLogica' => 1,
			                    'planificacion.FechaTrabajo >=' => $start,
                                'planificacion.FechaTrabajo <=' => $end
                                );
			
			$datos = $this->planificacion
			                ->select('planificacion.FechaTrabajo,planificacion.IdUsuario,planificacion.IdPlanificacion,grupostrabajo.GrupoTrabajo,horarios.horario,horarios.id_horario,horarios.HoraInicio,horarios.HoraFin,horarios.codigo,tblusuario.Nombres,tblusuario.Apellidos')
			                ->join('horarios','planificacion.id_horario=horarios.id_horario','left')
			                ->join('grupostrabajo','grupostrabajo.IDGrupoTrabajo=planificacion.IDGrupoTrabajo','left')
			                ->join('tblusuario','tblusuario.IdUsuario=grupostrabajo.JefeGrupoTrabajo','left')
			                ->where($whereDatos)
			                ->findAll();

    		$data = [];
        
            foreach ($datos as $event) {
                $end = $event['FechaTrabajo'].' '.$event['HoraFin'];
                $jefeGrupoTrabajo = $event['Nombres'].' '.$event['Apellidos'];
                // Corregir si la hora de fin es anterior a la hora de inicio (posiblemente cruzando la medianoche)
                if ($event['HoraFin'] < $event['HoraInicio']) {
                    $end = date('Y-m-d', strtotime($event['FechaTrabajo'].' +1 day')) . ' ' . $event['HoraFin'];
                }
                
                // Utiliza la función DATE() para comparar solo la fecha en tu consulta
                // $asistencia = $this->asistencia
                    // ->where('IdUsuario', $idUsuarioPlanificacion)
                    // ->where('DATE(FechaHoraRegistro)', $fechaActual)
                    // ->orderBy('FechaHoraRegistro', 'DESC')
                    // ->findAll();
                    
                
                $whereAsistencia = array(
                    'id_horario' => $event['id_horario'],
                    'IdUsuario' => $idUsuarioPlanificacion,
                    'DATE(FechaHoraRegistro)' => $event['FechaTrabajo']
                    );
                // Verificar si ya marcó asistencia para este evento
                $asistencia = $this->asistencia
                                    ->select('TipoRegistro,FechaHoraRegistro')
                                    ->where($whereAsistencia)
                                    // ->where('DATE(FechaHoraRegistro)', $event['FechaTrabajo']) // Comparar solo la fecha
                                    ->orderBy('FechaHoraRegistro', 'DESC')
                                    ->first();
                // var_dump($asistencia);
                $estadoAsistencia = $asistencia ? $asistencia['TipoRegistro'] : null; // 'inicio', 'fin' o null
        

        
                $data[] = array(
                    'title' => $event['horario'].' - '.$event['codigo'],
                    'start' => $event['FechaTrabajo'].' '.$event['HoraInicio'],
                    'end' => $end,
                    'grupoTrabajo' => $event['GrupoTrabajo'],
                    'jefeGrupoTrabajo' =>$jefeGrupoTrabajo,
                    'id_horario' => $event['id_horario'],
                    'id_planificacion' => $event['IdPlanificacion'],
                    'estadoAsistencia' => $estadoAsistencia, // Agregamos el estado
                );
            }

            // Enviar los datos en formato JSON
            echo json_encode($data);

	} 
	
	public function CalendarioGeneralPlanificacion()
    { 

// 		if(isset($this->items['id'])){
			/* BUSCAR PERMISOS*/
            $idGrupoTrabajo = $this->request->getPost('idGrupoTrabajo'); 

            // $start = $this->request->getPost('start'); // Fecha de inicio de la vista 

            // $end = $this->request->getPost('end'); // Fecha de fin de la vista 

            // Asegúrate de que las fechas se conviertan al formato adecuado si es necesario
            // $startDate = date('Y-m-d', strtotime($start));
            // $endDate = date('Y-m-d', strtotime($end));
			
			$whereDatos = array('planificacion.IDGrupoTrabajo' => $idGrupoTrabajo,
			                    'horarios.EliminacionLogica' => 1,
			                 //   'planificacion.FechaTrabajo >=' => $start,
                    //             'planificacion.FechaTrabajo <=' => $end
                                );
			
			$datos = $this->planificacion
			                ->select('planificacion.FechaTrabajo,planificacion.Motivo,planificacion.IdUsuario,planificacion.IdPlanificacion,grupostrabajo.JefeGrupoTrabajo,grupostrabajo.GrupoTrabajo,horarios.horario,horarios.id_horario,horarios.HoraInicio,horarios.HoraFin,horarios.codigo,tblusuario.Nombres,tblusuario.Apellidos,tblusuario.Matricula')
			                ->join('horarios','planificacion.id_horario=horarios.id_horario','left')
			                ->join('grupostrabajo','grupostrabajo.IDGrupoTrabajo=planificacion.IDGrupoTrabajo','left')
			                ->join('tblusuario','tblusuario.IdUsuario=planificacion.IdUsuario','left')
			                ->where($whereDatos)
			                ->findAll();

    		$data = [];
        
            foreach ($datos as $event) { 
                $datoJefeUsuario = $this->usuarioModelo
                                        ->select('tblusuario.IdUsuario,grupostrabajo.JefeGrupoTrabajo,tblusuario.Nombres,tblusuario.Apellidos')
                                        ->join('grupostrabajo','grupostrabajo.JefeGrupoTrabajo=tblusuario.IdUsuario')
                                        ->where('tblusuario.IdUsuario',$event['JefeGrupoTrabajo'])
                                        ->first();
                                        
                $end = $event['FechaTrabajo'].' '.$event['HoraFin'];
                $jefeGrupoTrabajo = $datoJefeUsuario['Nombres'].' '.$datoJefeUsuario['Apellidos'];
                // Corregir si la hora de fin es anterior a la hora de inicio (posiblemente cruzando la medianoche)
                if ($event['HoraFin'] < $event['HoraInicio']) {
                    $end = date('Y-m-d', strtotime($event['FechaTrabajo'].' +1 day')) . ' ' . $event['HoraFin'];
                }
        
                $data[] = array(
                    'title' => $event['codigo'],
                    'subtitle' => $event['Nombres'],
                    'title2' => $event['Matricula'].' - '.$event['codigo'],
                    'start' => $event['FechaTrabajo'].' '.$event['HoraInicio'],
                    'end' => $end,
                    'grupoTrabajo' => $event['GrupoTrabajo'],
                    'jefeGrupoTrabajo' => $jefeGrupoTrabajo,
                    'id_horario' => $event['id_horario'],
                    'id_planificacion' => $event['IdPlanificacion'],
                    'idUsuarioPlanificacion' => $event['IdUsuario'],
                    'nombreUsuarioPlanificacion' => $event['Nombres'].' '.$event['Apellidos'],
                    'matricula' => $event['Matricula'],
                    'motivo' => $event['Motivo']
                );
            }
            
            /*************************************************/

            // Enviar los datos en formato JSON
            echo json_encode($data);

	}
	
	public function ListarMatriculas()
    { 

// 		if(isset($this->items['id'])){
			/* BUSCAR PERMISOS*/
            $idGrupoTrabajo = $this->request->getPost('idGrupoTrabajo'); 
			
			$whereDatos = array('planificacion.IDGrupoTrabajo' => $idGrupoTrabajo,
			                    'horarios.EliminacionLogica' => 1,
                                );
			
			$datos = $this->planificacion
			                ->select('planificacion.FechaTrabajo,planificacion.IdUsuario,planificacion.IdPlanificacion,grupostrabajo.GrupoTrabajo,horarios.horario,horarios.id_horario,horarios.HoraInicio,horarios.HoraFin,horarios.codigo,tblusuario.Nombres,tblusuario.Apellidos,tblusuario.Matricula')
			                ->distinct()
			                ->join('horarios','planificacion.id_horario=horarios.id_horario','left')
			                ->join('grupostrabajo','grupostrabajo.IDGrupoTrabajo=planificacion.IDGrupoTrabajo','left')
			                ->join('tblusuario','tblusuario.IdUsuario=planificacion.IdUsuario','left')
			                ->where($whereDatos)
			                ->groupBy('tblusuario.Matricula') // Agrupa por id_horario para evitar duplicados en horarios
			                ->findAll();

    		$data = [];
        
            foreach ($datos as $event) {
                $end = $event['FechaTrabajo'].' '.$event['HoraFin'];
                $jefeGrupoTrabajo = $event['Nombres'].' '.$event['Apellidos'];
                // Corregir si la hora de fin es anterior a la hora de inicio (posiblemente cruzando la medianoche)

        
                $data[] = array(
                    'title' => $event['Matricula'],
                    'subtitle' => $event['Nombres']
                );
            }

            // Enviar los datos en formato JSON
            echo json_encode($data);

	}	
	
	public function listadoDetalleHorariosCalendario()
    {
        /*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
		
		$idHorarioSeleccionado = $this->request->getPost('idSeleccionado');
		$fechaCalendarioElegida = $this->request->getPost('fechaCalendarioElegida');
		$idUsuarioPlanificacion = $this->request->getPost('idUsuarioPlanificacion');
		
		$fechaReordenada = str_replace('/', '-', $fechaCalendarioElegida);
		$fechaConvertida = date('Y-m-d', strtotime($fechaReordenada)); 
            
        if(!empty($idHorarioSeleccionado)){
            // $listaDetalleHorarioSeleccionado = $this->planificacion->listarHorariosXSeleccion($idHorarioSeleccionado);
            $listaDetalleHorarioSeleccionado = $this->horarios->where('id_horario',$idHorarioSeleccionado)->first(); 
            $datosGrupoTrabajo = $this->grupoTrabajoUsuarios
                                    ->join('grupostrabajo', 'grupostrabajo.IDGrupoTrabajo = usuario_grupostrabajo.IDGrupoTrabajo','left')
                                    ->join('tblusuario', 'tblusuario.IdUsuario = grupostrabajo.JefeGrupoTrabajo','left')
                                    ->where('usuario_grupostrabajo.IdUsuario',$idUsuarioPlanificacion)
                                    ->first();
            // var_dump($datosGrupoTrabajo); exit();
        }

		if (!empty($listaDetalleHorarioSeleccionado)) {
            
            // $event = $listaDetalleHorarioSeleccionado[0];
            
            $jefeGrupoTrabajo = $datosGrupoTrabajo['Nombres'] . ' ' . $datosGrupoTrabajo['Apellidos'];
            // $motivo = $event['Motivo'] == NULL ? "" : $event['Motivo'];
            $dataListaDetalleHorarioSeleccionado = array(
                'codigo' => $listaDetalleHorarioSeleccionado['codigo'],
                'FechaTrabajo' => $fechaConvertida,
                'horaInicio' => $listaDetalleHorarioSeleccionado['HoraInicio'],
                'horaFin' => $listaDetalleHorarioSeleccionado['HoraFin'],
                'grupoTrabajo' => $datosGrupoTrabajo['GrupoTrabajo'],
                'jefeGrupoTrabajo' => $jefeGrupoTrabajo
                // 'motivo' => $event['Motivo']
            );

            $resultado = array(
				'dataListaDetalleHorarioSeleccionado' => json_encode($dataListaDetalleHorarioSeleccionado)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}
		
        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);
    }
    
	public function listadoGrupoTrabajoEstructuraPlanificacion()
    { 
    	/*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
			
		/* GRUPO DE TRABAJO */
			
		$listadoGrupoTrabajo = $this->grupoTrabajo->findAll();
        
        $grupoTrabajo=array();

		if (!empty($listadoGrupoTrabajo)) {
            foreach ($listadoGrupoTrabajo as $items) {
                $grupoTrabajo[] = array(
					'id' => (string) $items['IDGrupoTrabajo'],
         	        'text' => (string) $items['GrupoTrabajo'],
                );
            }

            $resultado = array(
				'listadoGrupoTrabajo' => json_encode($grupoTrabajo)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);
        
    }
    
    public function listadoUsuariosGrupoTrabajoEstructuraPlanificacion()
    { 
    	/*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        
		$idGrupoTrabajo = $this->request->getPost('idGrupoTrabajo');
		
		/* USUARIOS GRUPO DE TRABAJO */
		
		$whereGrupoTrabajo = array(
				'grupostrabajo.IDGrupoTrabajo' => $idGrupoTrabajo
			);
		
		$listadoUsuariosGrupoTrabajo = $this->usuarioModelo
                        ->select('tblusuario.Matricula, CONCAT(tblusuario.Nombres, " ", tblusuario.Apellidos) AS NombreCompleto, tblusuario.Cargo, grupostrabajo.GrupoTrabajo')
                        ->join('usuario_grupostrabajo', 'usuario_grupostrabajo.IdUsuario = tblusuario.IdUsuario')
                        ->join('grupostrabajo', 'grupostrabajo.IDGrupoTrabajo = usuario_grupostrabajo.IDGrupoTrabajo')
                        ->where($whereGrupoTrabajo)
                        ->findAll();
        
        $usuariosGrupoTrabajo=array();

		if (!empty($listadoUsuariosGrupoTrabajo)) {
            foreach ($listadoUsuariosGrupoTrabajo as $items) {
                $usuariosGrupoTrabajo[] = array(
					'Matricula' => (string) $items['Matricula'],
         	        'NombreCompleto' => (string) $items['NombreCompleto'],
         	        'Cargo' => (string) $items['Cargo'],
         	        'GrupoTrabajo' => (string) $items['GrupoTrabajo']
                );
            }

            $resultado = array(
				'listadoUsuariosGrupoTrabajo' => json_encode($usuariosGrupoTrabajo)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);
        
    }
    
    public function listarHorarioDataTableModal()
    {
        
        $idGrupoTrabajo = $this->request->getVar('idGrupoTrabajo');
        
        $adicionales = array(
            "IDPerfil"  => $this->items['idPerfil'],
            "IDUsuario" => $this->items['id'],
            'idGrupoTrabajo' => $idGrupoTrabajo
        );
        /* LISTAR ORDEN DE COMPRA */
        $dataServerside = $this->horarios->listaGeneralHorariosServerSide($this->request->getGet(), $adicionales);
        $recordsTotal = !empty($dataServerside) ? count($dataServerside) : 0;
        $recordsFiltered = count($this->horarios->where('EliminacionLogica',1)->findAll());
        foreach($dataServerside as $key=>$value)
        {
            $dataServerside[$key]['horarioEleccion'] = "<div class='form-check form-check-success d-flex justify-content-center align-items-center'>
                                                            <input class='form-check-input' type='checkbox' name='chk_horarios' data-idhorario='" . $value['id_horario'] . "' checked>
                                                        </div>";
            if($value['Estado'] == 'A'){
                $dataServerside[$key]['EstadoHorario'] = "<button class='badge bg-success border-0')>Activo</button>";
            }else{
                $dataServerside[$key]['EstadoHorario'] = "<button class='badge bg-danger border-0')>Inactivo</button>";
            }
        }

        $datos = [
            'draw' => $this->request->getGet('draw'),
            'recordsTotal' => $recordsTotal,
            'recordsFiltered' => $recordsFiltered,
            'data' => $dataServerside
        ];
        echo json_encode($datos, JSON_NUMERIC_CHECK);    
    }
    
    public function importarPlanificacion()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DECLARAR Y ASIGNAR VARIABLE A ARCHIVO OBTENIDO
        * ----------------------------
        */
        
        $csv = $this->request->getFile("fileCSVPlanificacion");

        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $csv->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $csv->getErrorString().'-'.$csv->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO-
        * ----------------------------
        */
        
        $validationRule = [
            'fileCSVPlanificacion' => [
                'mime_in[fileCSVPlanificacion,text/csv,text/plain]',
                'ext_in[fileCSVPlanificacion,csv]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        /*
        * ----------------------------
        * VALIDAR SEPARADOR CSV
        * ----------------------------
        */
        
        $separadorCSV = $this->complementos->validarSeparadorCSV($csv, 31);
        
        if (!$separadorCSV) {
            $message = sprintf($this->mensajeError->msg201, "No se encontró separador de CSV autorizado. Debe usar coma (,) o punto y coma (;) y eliminar celdas vacías a la derecha de la última columna.");
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y VALIDAR DATOS CORRECTOS
        * ----------------------------
        */
        
        //Declaramos variables
        $fila = 1; //en bluehost
        $filasError = array();
        $ejecutarInsert = true;
        //Abrimos el archivo
        $handle = fopen($csv, "r");
        // $header = fgetcsv($handle, 0, $separadorCSV);

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handle, 0, $separadorCSV)) !== FALSE)
        {

            if($fila == 1){
                for ($i = 1; $i < count($data); $i++) {
                    
                    $fechaTrabajo = date('Y-m-d', strtotime($data[$i]));
                    if (!empty($fechaTrabajo)) {
    					$fecha_formateada = $this->complementos->myUrlEncode($fechaTrabajo);
    					$fechaPedido_formateada = date('Y-m-d', strtotime(str_replace('/', '-', $fecha_formateada)));
    				}else{
    				    $ejecutarInsert = false;
    				}
                }
            }
            else
            {
                
                $data = array_map("utf8_encode", $data);
                //Asignamos valores de CSV a variables locales
                $matricula      = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");


                // Validar existencia de matricula:
                $whereMatricula = array(
				    'tblusuario.Matricula' => $matricula
			    );
		
                $idUsuario = $this->usuarioModelo
                               ->select('tblusuario.IdUsuario')
                               ->where($whereMatricula)
                               ->first();

                if (empty($idUsuario)) {
                    $filasError[$fila]['MATRICULA'] = "LA MATRICULA NO EXISTE";
                    $ejecutarInsert = false;
                }else{
                    $grupoTrabajo = $this->usuarioModelo
                               ->select('tblusuario.IdUsuario,usuario_grupostrabajo.IDGrupoTrabajo')
                               ->join('usuario_grupostrabajo','usuario_grupostrabajo.IdUsuario = tblusuario.IdUsuario')
                               ->where($whereMatricula)
                               ->first();
                    if(empty($grupoTrabajo['IDGrupoTrabajo'])){
                        $filasError[$fila]['MATRICULA'] = "LA MATRICULA NO CUENTA CON GRUPO TRABAJO ASOCIADO";
                        $ejecutarInsert = false;
                    }
                }
                
                for ($i = 1; $i < count($data); $i++) {
                    
                    // $fechaTrabajo = date('Y-m-d', strtotime($data[$i]));
                    $codigoHorario = trim($data[$i], " \t\n\r\0\x0B\xc2\xa0");;  

                    // Validar existencia de código de horario:
                    
                    $whereCodigo = array(
    				    'horarios.codigo' => $codigoHorario
    			    );
    		
                    $idHorario = $this->horarios
                                   ->select('id_horario')
                                   ->where($whereCodigo)
                                   ->first();
               
                    if (empty($idHorario)) {
                        $filasError[$fila]['HORARIO'] = "EL CODIGO DE HORARIO NO EXISTE";
                        $ejecutarInsert = false;
                    }
                }
            }
            $fila++;
            
        }

        fclose($handle);

        if(!$ejecutarInsert)
        {
            $raiz = 'public/';
            $nombre = 'error.txt';
            $file = 'public/error.txt';
            
            if (file_exists($file)) {
                unlink($file);
            }
            
            $txt= fopen($file, 'a') or die ('Problemas al crear el archivo');
            #  Se establecen los datos que va a conterner el archivo
            foreach($filasError as $key=>$value)
            {
                fwrite($txt, "FILA: ".$key."\n");
                foreach($value as $celda=>$error)
                {
                    fwrite($txt, $celda.": ".$error."\n");
                }
            }
            #  Se hace el ciere para no sobre escribir datos 
            fclose($txt);

            $message = sprintf($this->mensajeError->msg201, "Se detectaron diversas inconsistencias.");
            $salida1 = $this->alertas->alertaError($message);
            $salida2 = $this->alertas->descargaArchivoTXT($nombre);
			echo $salida1.$salida2;
			//echo $salida1;
            
			exit;
        }
        

        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y EJECUTAR INSERTS
        * ----------------------------
        */
            
        //Declaramos variables
        $arrayInsert = array();
        $arrayUpdate = array();
        
        $fila = 1;
        $filainsert = 0;
        $filaupdate = 0;
        //Abrimos el archivo
        $handleInsert = fopen($csv, "r");
        $arrayFechas = array();
        $matriculaActual = "";
        $dataInsert = array();
        
        date_default_timezone_set('America/Lima');
		$fechaCreacion = date("Y-m-d H:i:s");
		$idUsuarioCreador = $this->items['id'];
		
        //Recorremos las filas del CSV
        while (($data = fgetcsv($handleInsert, 0, $separadorCSV)) !== FALSE)
        {
            $data = array_map("utf8_encode", $data);
            for ($i = 0; $i < count($data); $i++) {
                if($fila == 1)
                {
                    
                    if ($i>0) {
    					$fecha_formateada = $this->complementos->myUrlEncode($data[$i]);
    					$arrayFechas[$i] = date('Y-m-d', strtotime(str_replace('/', '-', $fecha_formateada)));
    				}
    
                }else{
                    
                    if($i == 0)
                    {
                        $matriculaActual = $data[$i];
                    }
                    else
                    {
                        $whereMatricula = array(
        				    'tblusuario.Matricula' => $matriculaActual
        			    );
    		
                        $idUsuario = $this->usuarioModelo
                              ->select('tblusuario.IdUsuario,usuario_grupostrabajo.IDGrupoTrabajo')
                               ->join('usuario_grupostrabajo','usuario_grupostrabajo.IdUsuario = tblusuario.IdUsuario')
                              ->where($whereMatricula)
                              ->first();
                               
                        $whereCodigo = array(
        				    'horarios.codigo' => $data[$i]
        			    );
        		
                        $idHorario = $this->horarios
                                      ->select('id_horario')
                                      ->where($whereCodigo)
                                      ->first();
                        
                        if ($idUsuario > 0 && $idHorario> 0) {
                            $dataInsert = array(
                                'IdUsuario' => $idUsuario['IdUsuario'],
                                'FechaTrabajo' => $arrayFechas[$i],
                                'id_horario' => $idHorario['id_horario'],
                                'FechaCreacion' => $fechaCreacion,
                                'UsuarioCreador' => $idUsuarioCreador,
                                'IDGrupoTrabajo' => $idUsuario['IDGrupoTrabajo']
                            );
                            $statusInsert = $this->planificacion->insert($dataInsert,true);
                            
                            $filainsert++;
                        }
                    }
                }
                    
            }
            $fila++;
            
        }

        fclose($handleInsert);
        // $statusInsert = $this->planificacion->insertBatch($dataInsert);
        $mensajeConfirmacion = '';
        
        if($statusInsert !== FALSE){
            $mensajeConfirmacion .= "Se registraron el total de ".$filainsert." fila(s).<br>";
            
        }
        else {
            $mensajeConfirmacion .= "No se pudo realizar el registro solicitado. Inténtelo luego.<br>";
        }
        
        $message = sprintf($this->mensajeError->msg201, $mensajeConfirmacion);
        echo $this->alertas->alertaExito($message);
        //echo $this->alertas->refrescar(1);
        exit;
    }
    
    public function importarDesempeno()
    {
        $fechaActual = date("Y-m-d");
        
        /*
        * ----------------------------
        * DECLARAR Y ASIGNAR VARIABLE A ARCHIVO OBTENIDO
        * ----------------------------
        */
        
        $csv = $this->request->getFile("fileCSVDesempeno");

        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $csv->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $csv->getErrorString().'-'.$csv->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO-
        * ----------------------------
        */
        
        $validationRule = [
            'fileCSVDesempeno' => [
                'mime_in[fileCSVDesempeno,text/csv,text/plain]',
                'ext_in[fileCSVDesempeno,csv]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        /*
        * ----------------------------
        * VALIDAR SEPARADOR CSV
        * ----------------------------
        */
        
        $separadorCSV = $this->complementos->validarSeparadorCSV($csv, 6);
        
        if (!$separadorCSV) {
            $message = sprintf($this->mensajeError->msg201, "No se encontró separador de CSV autorizado. Debe usar coma (,) o punto y coma (;) y eliminar celdas vacías a la derecha de la última columna.");
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y VALIDAR DATOS CORRECTOS
        * ----------------------------
        */
        
        //Declaramos variables
        $fila = 0; //en bluehost
        $filasError = array();
        $ejecutarInsert = true;
        //Abrimos el archivo
        $handle = fopen($csv, "r");
        // $header = fgetcsv($handle, 0, $separadorCSV);

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handle, 0, $separadorCSV)) !== FALSE)
        {
            $fila++;

            if($fila>1)
            {
                $data = array_map("utf8_encode", $data);
                //Asignamos valores de CSV a variables locales
                $matricula                = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $cumplimientoProceso      = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                $atencionCliente          = trim($data[2]," \t\n\r\0\x0B\xc2\xa0");
                $tmo                      = trim($data[3]," \t\n\r\0\x0B\xc2\xa0");
                $productividad            = trim($data[4]," \t\n\r\0\x0B\xc2\xa0");
                $wp                       = trim($data[5]," \t\n\r\0\x0B\xc2\xa0");
                $categoria                = trim($data[6]," \t\n\r\0\x0B\xc2\xa0");
                $tiempoTrabajando         = trim($data[7]," \t\n\r\0\x0B\xc2\xa0");


                // Validar existencia de matricula:
                $whereMatricula = array(
				    'tblusuario.Matricula' => $matricula
			    );
		
                $idUsuario = $this->usuarioModelo
                              ->select('tblusuario.IdUsuario')
                              ->where($whereMatricula)
                              ->first();

                if (empty($idUsuario)) {
                    $filasError[$fila]['MATRICULA'] = "LA MATRICULA NO EXISTE ";
                    $ejecutarInsert = false;
                }
                // else{
                //     $grupoTrabajo = $this->usuarioModelo
                //               ->select('tblusuario.IdUsuario,usuario_grupostrabajo.IDGrupoTrabajo')
                //               ->join('usuario_grupostrabajo','usuario_grupostrabajo.IdUsuario = tblusuario.IdUsuario')
                //               ->where($whereMatricula)
                //               ->first();
                //     if(empty($grupoTrabajo['IDGrupoTrabajo'])){
                //         $filasError[$fila]['MATRICULA'] = "LA MATRICULA NO CUENTA CON GRUPO TRABAJO ASOCIADO";
                //         $ejecutarInsert = false;
                //     }
                // }
                
                 //Validamos existencia de CUMPLIMIENTO DE PROCESOS:
                
                if(!is_numeric($cumplimientoProceso) && $cumplimientoProceso < 0)
                {
                    $filasError[$fila]['Cantidad'] = "CANTIDAD NO PERMITIDA";
                    $ejecutarInsert = false;
                }
                
                //Validamos existencia de ATENCION AL CLIENTE:
                if(!is_numeric($atencionCliente) && $atencionCliente < 0)
                {
                    $filasError[$fila]['Cantidad'] = "CANTIDAD NO PERMITIDA";
                    $ejecutarInsert = false;
                }
                
                //Validamos existencia de TMO:
                if(!is_numeric($tmo) && $tmo < 0)
                {
                    $filasError[$fila]['Cantidad'] = "CANTIDAD NO PERMITIDA";
                    $ejecutarInsert = false;
                }
                
                //Validamos existencia de PRODUCTIVIDAD:
                if(!is_numeric($productividad) && $productividad < 0)
                {
                    $filasError[$fila]['Cantidad'] = "CANTIDAD NO PERMITIDA";
                    $ejecutarInsert = false;
                }
                
                //Validamos existencia de WP:
                if(!is_numeric($wp) && $wp < 0)
                {
                    $filasError[$fila]['Cantidad'] = "CANTIDAD NO PERMITIDA";
                    $ejecutarInsert = false;
                }
                
                //Validamos existencia de CATEGORIA:
                
                if(empty($categoria))
                {
                    $filasError[$fila]['Cantidad'] = "CATEGORIA NO PERMITIDA";
                    $ejecutarInsert = false;
                }
                
                //Validamos existencia de TIEMPO EN EL TRABAJO:
                
                if(!is_numeric($tiempoTrabajando) && $tiempoTrabajando < 0)
                {
                    $filasError[$fila]['Cantidad'] = "TIEMPO TRABAJO NO PERMITIDA";
                    $ejecutarInsert = false;
                }
        
            // $fila++;
            }
            
        }

        fclose($handle);

        if(!$ejecutarInsert)
        {
            $raiz = 'public/';
            $nombre = 'error.txt';
            $file = 'public/error.txt';
            
            if (file_exists($file)) {
                unlink($file);
            }
            
            $txt= fopen($file, 'a') or die ('Problemas al crear el archivo');
            #  Se establecen los datos que va a conterner el archivo
            foreach($filasError as $key=>$value)
            {
                fwrite($txt, "FILA: ".$key."\n");
                foreach($value as $celda=>$error)
                {
                    fwrite($txt, $celda.": ".$error."\n");
                }
            }
            #  Se hace el ciere para no sobre escribir datos 
            fclose($txt);

            $message = sprintf($this->mensajeError->msg201, "Se detectaron diversas inconsistencias.");
            $salida1 = $this->alertas->alertaError($message);
            $salida2 = $this->alertas->descargaArchivoTXT($nombre);
			echo $salida1.$salida2;
			//echo $salida1;
            
			exit;
        }
        

        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y EJECUTAR INSERTS
        * ----------------------------
        */
            
        //Declaramos variables
        $arrayInsert = array();
        $arrayUpdate = array();
        
        $fila = 1;
        $filainsert = 0;
        // $filaupdate = 0;
        //Abrimos el archivo
        $handleInsert = fopen($csv, "r");
        $arrayFechas = array();
        // $matriculaActual = "";
        $dataInsert = array();
        
        date_default_timezone_set('America/Lima');
		$fechaCreacion = date("Y-m-d H:i:s");
		$idUsuarioCreador = $this->items['id'];
		
		$dataInsertBatch = [];

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handleInsert, 0, $separadorCSV)) !== FALSE)
        {
            
            // $fila++;

            if($fila>1)
            {
                $data = array_map("utf8_encode", $data);
                $matricula                = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $cumplimientoProceso      = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                $atencionCliente          = trim($data[2]," \t\n\r\0\x0B\xc2\xa0");
                $tmo                      = trim($data[3]," \t\n\r\0\x0B\xc2\xa0");
                $productividad            = trim($data[4]," \t\n\r\0\x0B\xc2\xa0");
                $wp                       = trim($data[5]," \t\n\r\0\x0B\xc2\xa0");
                $categoria                = trim($data[6]," \t\n\r\0\x0B\xc2\xa0");
                $tiempoTrabajando         = trim($data[7]," \t\n\r\0\x0B\xc2\xa0");
                
                
                $whereMatricula = array(
				    'tblusuario.Matricula' => $matricula
			    );
		
                $idUsuario = $this->usuarioModelo
                              ->select('tblusuario.IdUsuario')
                              ->where($whereMatricula)
                              ->first();


                $dataInsertBatch[] = [
                    'IdUsuario' => $idUsuario['IdUsuario'],
                    'mes' => $fechaActual,
                    'cumplimiento_procesos' => $cumplimientoProceso,
                    'atencion_cliente' => $atencionCliente,
                    'tmo' => $tmo,
                    'productividad' => $productividad,
                    'wp' => $wp,
                    'categoria' => $categoria,
                    'tiempo_trabajo' => $tiempoTrabajando
                ];
                            
                $filainsert++;
                  
            }

            $fila++;
            
        }
        
        // Realiza la inserción por lotes si hay datos para insertar
        if (!empty($dataInsertBatch)) {
            $statusInsert = $this->metricasDesempeno->insertBatch($dataInsertBatch);
        }

        fclose($handleInsert);
        // $statusInsert = $this->planificacion->insertBatch($dataInsert);
        $mensajeConfirmacion = '';
        
        if($statusInsert !== FALSE){
            $mensajeConfirmacion .= "Se registraron el total de ".$filainsert." fila(s).<br>";
            
        }
        else {
            $mensajeConfirmacion .= "No se pudo realizar el registro solicitado. Inténtelo luego.<br>";
        }
        
        $message = sprintf($this->mensajeError->msg201, $mensajeConfirmacion);
        echo $this->alertas->alertaExito($message);
        //echo $this->alertas->refrescar(1);
        exit;
    }

    
    public function listarHorarios()
    {
        if(isset($this->items['id'])){
            
            $idUsuario = $this->items['id'];
            
			/* LISTAR HORARIOS */
			$whereHoraios = array(
			    "UsuarioRegistra"    => $idUsuario
			);
			
			$listaHorarios = $this->horarios->where($whereHoraios)->findAll();
// 			$listaUsuarios = $this->usuarioGruposTrabajo->listarUsuariosGrupoTrabajo($whereUGT);
            
			$data = array (
				'session'           => 'on',
				'titulo'            => 'Usuarios - Grupo de Trabajo | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Usuarios asociados - '.$grupoTrabajo['GrupoTrabajo'],
                'previo'            => 'listar-grupos-trabajo',
				'listaHorarios'     => $listaHorarios,
                'idGrupoTrabajo'    => $idGrupoTrabajo
			);
			$data = array_merge($data, $this->items);
			return view('configuracion/listar_usuarios_grupo_trabajo',$data);			
		} else {
			return view('errors/500');	
		}
    }
    
    public function actualizarPlanificacionHoraria()
    { 
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $idHorario  = $this->request->getPost('lista_horarios');
        $idPlanificacion  = $this->request->getPost('idPlanificacion');
        $motivoCambio  = mb_strtoupper($this->request->getPost('motivo_cambio'));

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($motivoCambio, 'required|trim|minlength[1]|maxlength[200]', 'Motivo Cambio');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'id_horario'       => $idHorario,
            'Motivo'           => $motivoCambio,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual, 
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->planificacion->update([$idPlanificacion], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $motivoCambio);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
    }
    
    public function ActualizarHoraIngreso()
    { 
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $idUsuario  = $this->request->getPost('idUsuario'); 
        $fecha  = $this->request->getPost('fecha'); 
        $motivoCambio  = mb_strtoupper($this->request->getPost('motivo')); 
        $nuevaHoraIngreso  = $this->request->getPost('nuevaHoraIngreso'); 
        $idInicioAsistencia  = $this->request->getPost('inicioAsistencia'); 
        
        $fechaHoraIngresoCambio = date("Y-m-d H:i:s", strtotime($fecha . ' ' . $nuevaHoraIngreso)); 
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idUsuario, 'required|numeric|trim|minlength[1]|maxlength[11]', 'Usuario');
        $error .= $this->complementos->validaCampo($fecha, 'required|trim|minlength[1]|maxlength[11]', 'Fecha');
        $error .= $this->complementos->validaCampo($idInicioAsistencia, 'required|numeric|trim|minlength[1]|maxlength[11]', 'Asistencia');
        $error .= $this->complementos->validaCampo($nuevaHoraIngreso, 'required|trim|minlength[1]|maxlength[10]', 'Hora Ingreso');
        $error .= $this->complementos->validaCampo($motivoCambio, 'required|trim|minlength[1]|maxlength[200]', 'Motivo Cambio');
        
        if(empty($idInicioAsistencia)){
            $mensagePersonalizado = 'El usuario no tiene registro de asistencia, no puede modificar la hora ingreso';
            $mensage = sprintf($this->mensajeError->msg201, $mensagePersonalizado);
            echo $this->alertas->alertaError($mensage);
            exit;
        }
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'FechaHoraRegistro'       => $fechaHoraIngresoCambio,
            'Motivo'           => $motivoCambio
        );

        $lastId = $this->asistencia->update([$idInicioAsistencia], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $motivoCambio);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
    }    
    
    public function calendarioPlanificacionCrear()
    { 
        $fechaActual = date("Y-m-d H:i:s");
        $idUsuarioCreador = $this->items['id'];
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $idUsuario  = $this->request->getPost('idUsuario');
        $idHorario  = $this->request->getPost('idHorario');
        $grupoTrabajo  = $this->request->getPost('grupoTrabajo');
        $fecha  = mb_strtoupper($this->request->getPost('fecha'));

        // Extraer la parte relevante de la fecha (los primeros 11 caracteres)
        $fecha_extraccion = substr($fecha, 0, 11);
        
        // Convertir la fecha extraída al formato Y-m-d
        $fecha_formateada = date('Y-m-d', strtotime($fecha_extraccion));
    
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idUsuario, 'required|numeric|trim|minlength[1]|maxlength[11]', 'Usuario');
        $error .= $this->complementos->validaCampo($idHorario, 'required|numeric|trim|minlength[1]|maxlength[11]', 'Horario');
        $error .= $this->complementos->validaCampo($grupoTrabajo, 'required|numeric|trim|minlength[1]|maxlength[11]', 'Grupo Trabajo');
    
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            

        $dataPlanificacion = array (
            'IdUsuario'           => $idUsuario, 
            'FechaTrabajo'      => $fecha_formateada, 
            'id_horario'    => $idHorario, 
            'UsuarioCreador' => $idUsuarioCreador,
            'FechaCreacion' => $fechaActual,
            'IDGrupoTrabajo' => $grupoTrabajo

        );

        $lastIdPlanificacion = $this->planificacion->insert($dataPlanificacion, TRUE);
        
    
        if($lastIdPlanificacion !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $fechaActual);
            echo $this->alertas->alertaExito($message);
            echo $this->alertas->refrescar(1);
        } else {
            // Manejo de error en caso de que la actualización falle
            echo $this->alertas->alertaError('No se pudo actualizar la planificación.');
        }		
    }
    
    public function calendarioPlanificacionActualizar()
    { 
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $idUsuario  = $this->request->getPost('idUsuario');
        $idHorario  = $this->request->getPost('idHorario');
        $motivoCambio  = $this->request->getPost('motivo');
        $fecha  = mb_strtoupper($this->request->getPost('fecha'));
        
        // Extraer la parte relevante de la fecha (los primeros 11 caracteres)
        $fecha_extraccion = substr($fecha, 0, 11);
        
        // Convertir la fecha extraída al formato Y-m-d
        $fecha_formateada = date('Y-m-d', strtotime($fecha_extraccion));
    
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idUsuario, 'required|numeric|trim|minlength[1]|maxlength[11]', 'Usuario');
        $error .= $this->complementos->validaCampo($idHorario, 'required|numeric|trim|minlength[1]|maxlength[11]', 'Horario');
    
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
    	
        // $data = array (
        //     'id_horario' => $idHorario
        // );
        
        // // Actualizar registro basado en idUsuario y fecha
        // $updated = $this->planificacion->where('IdUsuario', $idUsuario)
        //                                 ->where('FechaTrabajo', $fecha_formateada)
        //                                 ->update(null, $data);
        /******************/    
        
         $dataWhere = array (
            'FechaTrabajo' => $fecha_formateada,
            'IdUsuario' =>  $idUsuario
        );
        
        $idPlanificacion = $this->planificacion->select('IdPlanificacion')->where($dataWhere)->first();

        $data = array (
            'id_horario'        => $idHorario,
            'Motivo'            => $motivoCambio,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual, 
            'Localhost'         => $this->request->getIPAddress()
        );

        $updated = $this->planificacion->update([$idPlanificacion['IdPlanificacion']], $data);
    
        if($updated !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $fecha_formateada);
            echo $this->alertas->alertaExito($message);
            echo $this->alertas->refrescar(1);
        } else {
            // Manejo de error en caso de que la actualización falle
            echo $this->alertas->alertaError('No se pudo actualizar la planificación.');
        }		
    }

    public function registrartHoraTrabajo()
    {  
        $fechaActual = date("Y-m-d H:i:s");
        $idUsuarioSession = $this->items['id'];
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $idUsuario  = $this->request->getPost('idUsuario'); 
        $tipo  = $this->request->getPost('tipo'); 
        $idHorario  = $this->request->getPost('id_horario');
        $fecha  = mb_strtoupper($this->request->getPost('fechaHora'));

        // Extraer la parte relevante de la fecha (los primeros 11 caracteres)
        $fecha_extraccion = substr($fecha, 0, 11);
        
        // Convertir la fecha extraída al formato Y-m-d
        $fecha_formateada = date('Y-m-d', strtotime($fecha_extraccion));

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idUsuario, 'required|numeric|trim|minlength[1]|maxlength[11]', 'Usuario');
        $error .= $this->complementos->validaCampo($idHorario, 'required|numeric|trim|minlength[1]|maxlength[11]', 'Horario');
        $error .= $this->complementos->validaCampo($tipo, 'required|trim|minlength[1]|maxlength[11]', 'Grupo Trabajo');
    
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
        if($idUsuarioSession === $idUsuario){ 
            $dataAsistencia = array (
                'IdUsuario'           => $idUsuarioSession, 
                'FechaHoraRegistro'   => $fechaActual, 
                'TipoRegistro'        => $tipo,
                'id_horario'          => $idHorario
            );

            $lastIdAsistencia = $this->asistencia->insert($dataAsistencia, TRUE);
        }else{
            $lastIdAsistencia =  FALSE;
        }
       
    
        if($lastIdAsistencia !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $fechaActual);
            echo $this->alertas->alertaExito($message);
            echo $this->alertas->refrescar(1);
        } else {
            // Manejo de error en caso de que la actualización falle
            echo $this->alertas->alertaError('No se pudo actualizar la planificación.');
        }		
    }
    
    public function ActualizarPlanificacionGeneral()
    { 
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $idHorario  = $this->request->getPost('lista_horarios');
        $idPlanificacion  = $this->request->getPost('idPlanificacion'); 
        $motivoCambio  = mb_strtoupper($this->request->getPost('motivo_cambio_planificacion_horaria')); 

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($motivoCambio, 'required|trim|minlength[1]|maxlength[200]', 'Motivo Cambio');
        $error .= $this->complementos->validaCampo($idHorario, 'required|trim|numeric|minlength[1]|maxlength[200]', 'Id Horario');
        $error .= $this->complementos->validaCampo($idPlanificacion, 'required|trim|numeric|minlength[1]|maxlength[200]', 'Id Planificacion');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'id_horario'        => $idHorario,
            'Motivo'            => $motivoCambio,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual, 
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->planificacion->update([$idPlanificacion], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $motivoCambio);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
    }
	
	/************************************************************************************************/

    public function listadoPaqueteria()
    {
        if(isset($this->items['id'])){

			/* ACCIONES */
			$listaPaqueteria = $this->paqueteria->listarPaqueteria();

            foreach($listaPaqueteria as $key=>$value)
            {
                //Obtener 
                $ccRemitente = $this->cc->where("IdDpto ", $value['CCRemitente'])->first();
                $ccDestinatario = $this->cc->where("IdDpto ", $value['CCDestinatario'])->first();
                $remitente = $this->usuarios->where("IdUsuario ", $value['UsuarioRemitente'])->first();
                $destinatario = $this->usuarios->where("IdUsuario ", $value['UsuarioDestinatario'])->first();
                
                if($ccRemitente != null)
                {
                    $listaPaqueteria[$key]['CCRemitente'] = strtoupper($ccRemitente['NombreDpto']);
                }
                else
                {
                    $listaPaqueteria[$key]['CCRemitente'] = "--";
                }
                
                if($ccDestinatario != null)
                {
                    $listaPaqueteria[$key]['CCDestinatario'] = strtoupper($ccDestinatario['NombreDpto']);
                }
                else
                {
                    $listaPaqueteria[$key]['CCDestinatario'] = "--";
                }
                
                if($remitente != null)
                {
                    $listaPaqueteria[$key]['NombreRemitente'] = strtoupper($remitente['Nombres'].' '.$remitente['Apellidos']);
                }
                else
                {
                    $listaPaqueteria[$key]['NombreRemitente'] = "--";
                }
                
                if($destinatario != null)
                {
                    $listaPaqueteria[$key]['NombreDestinatario'] = strtoupper($destinatario['Nombres'].' '.$destinatario['Apellidos']);
                }
                else
                {
                    $listaPaqueteria[$key]['NombreDestinatario'] = "--";
                }
                
                
            }
            $estados = $this->globales->estadosPaqueteria();
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Paquetería | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Paquetería',
				'listaPaqueteria'       => $listaPaqueteria,
                'estados'               => $estados
			);
			$data = array_merge($data, $this->items);
			return view('paqueteria/listar_paqueteria',$data);			
		} else {
			return view('errors/500');
		}
    }
    
    public function nuevaPaqueteria()
    {
        if(isset($this->items['id'])){

			/* ACCIONES */
			//$listaUsuariosRemitente = $this->usuarios->where(array("CC"=>930, "Estado"=>"Activo"))->findAll();
            $ccRemitente = $this->cc->where("IdDpto ", $this->items['dpto'])->first();
			$listadoElementos = $this->detalleasignaciones->detalleAsignacionSinPaqueteria();

			foreach($listadoElementos as $key=>$value)
            {
                //Obtener elemento
                if($value['TipoElemento']=='MOVIL')
                {
                    $dataElemento = $this->moviles->obtenerMovil($value['IDElemento']);
                    $listadoElementos[$key]['NombreElemento'] = $dataElemento['IMEI']." | ".$dataElemento['Marca']." ".$dataElemento['Modelo'];
                }
                else if($value['TipoElemento']=='LINEA')
                {
                    $dataElemento = $this->lineas->obtenerLinea($value['IDElemento']);
                    $listadoElementos[$key]['NombreElemento'] = $dataElemento['Numero']." | ".$dataElemento['Operador']." ".$dataElemento['Plan'];
                }
                else
                {
                    $listadoElementos[$key]['NombreElemento'] = "SIN INFORMACIÓN";
                }
                
            }

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Nueva Paquetería | Verisure',
                'previo'                => 'listar-paqueteria',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Nueva paquetería',
				//'listaUsuariosRemitente'=> $listaUsuariosRemitente,
				'elementosDetalle'		=> $listadoElementos,
                'ccRemitente'           => $ccRemitente
			);
			$data = array_merge($data, $this->items);
			return view('paqueteria/nueva_paqueteria',$data);			
		} else {
			return view('errors/500');
		}
    }

	public function listadoCCSelect()
	{
		$elemento = $this->request->getPost('term');
        
        $listado = $this->cc->listadoCCSelect($elemento['term']);

        $elementos=array();

        foreach ($listado as $items) {
            $elementos[] = array(
                'id' => (string) $items['IdDpto'],
                'text' => (string) $items['CC']." | ".$items['NombreDpto']
            );
        }

        echo json_encode($elementos);
	}

	public function listadoUsuariosCCSelect()
	{
		$elemento = $this->request->getPost('term');
        
        $listado = $this->usuarios->listadoUsuariosSelect($elemento['term'], '');

        $elementos=array();

        foreach ($listado as $items) {
            $elementos[] = array(
                'id' => (string) $items['IdUsuario'],
                'text' => (string) $items['Matricula']." | ".$items['Nombres']." ".$items['Apellidos']." ".$items['CC']
            );
        }

        echo json_encode($elementos);
	}

    public function guardarPaqueteria()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $ccdestinatario = $this->request->getPost('txtCCDestinatario');
        $destinatario = $this->request->getPost('txtDestinatario');
        $direcdestinatario = $this->request->getPost('txtDireccionDestinatario');
        //$fechaenvio = $this->request->getPost('txtFechaEnvio');
        //$diasviaje = $this->request->getPost('txtDiasViaje');
        $ccremitente = $this->request->getPost('txtCCRemitente');
        $remitente = $this->request->getPost('txtRemitente');
        $direcremitente = $this->request->getPost('txtDireccionRemitente');
        //$proveedor = $this->request->getPost('txtProveedor');
        $observacion = $this->request->getPost('txtObservacion');
        
        $elementoDetalle = $this->request->getPost('elemento');
        $etiquetaelemento = $this->request->getPost('etiquetaelemento');
        $observacionDetalle = $this->request->getPost('obselemento');
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        $error = '';
        $error .= $this->complementos->validaCampo($ccdestinatario, 'required|trim', 'Centro de Costo Destinatario');
        $error .= $this->complementos->validaCampo($destinatario, 'required|trim', 'Destinatario');
        $error .= $this->complementos->validaCampo($direcdestinatario, 'required|trim', 'Dirección Destinatario');
        //$error .= $this->complementos->validaCampo($fechaenvio, 'required|dateDos', 'Fecha de envío');
        //$error .= $this->complementos->validaCampo($diasviaje, 'required|numeric|trim', 'Dias estimados de viaje');
        $error .= $this->complementos->validaCampo($ccremitente, 'required|trim', 'Centro de Costo Remitente');
        $error .= $this->complementos->validaCampo($remitente, 'required|trim', 'Usuario remitente');
        $error .= $this->complementos->validaCampo($direcremitente, 'required|trim', 'Dirección Remitente');
        //$error .= $this->complementos->validaCampo($proveedor, 'required|trim', 'Proveedor');
        $error .= $this->complementos->validaCampo($observacion, 'required|trim', 'Observación');
        
        if(count($elementoDetalle)==0)
        {
            $error .= "<li>Debe registrar un item para el envío de paquetería.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        foreach($elementoDetalle as $key=>$detalle)
        {
            $itemAsignado = $this->paqueteriadetalle->where("IDDetalleAsignacion", $detalle)->findAll();
            if(count($itemAsignado)>0)
            {
                $msgExistencia .= "<li>El ".$etiquetaelemento[$key]." ya fue asignado.</li>";
            }
        }
		
        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
       */
        $dataPaqueteria = array (
            'CCRemitente'           => $ccremitente, 
            'UsuarioRemitente'      => $remitente, 
            'DireccionRemitente'    => $direcremitente, 
            //'FechaEnvio'            => $fechaenvio, 
            //'DiasEstimadoTransito'  => $diasviaje, 
            'CCDestinatario'        => $ccdestinatario, 
            'UsuarioDestinatario'   => $destinatario, 
            'DireccionDestinatario' => $direcdestinatario, 
            //'Proveedor'             => $proveedor, 
            'Descripcion'           => $observacion, 
            'UsuarioCrea'           => $this->items['id'],
            'FechaCrea'             => $fechaActual,
            'Estado'                => "REG",
            'FechaEstado'           => $fechaActual,
            'UsuarioEstado'         => $this->items['id'],
            'MotivoCambio'          => "Registro de envío de paquetería",
            'Localhost'             => $this->request->getIPAddress()
        );

        $lastIdPaqueteria = $this->paqueteria->insert($dataPaqueteria, TRUE);
        
        if($lastIdPaqueteria !== FALSE){
            $idPaqueteria = $lastIdPaqueteria;
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar la paquetería. Inténtelo luego.</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
        }
            
        $dataDetalle = array();

        foreach($elementoDetalle as $key=>$detalle)
        {
            $dataDetalle[] = array (
                'IDPaqueteria'          => $idPaqueteria, 
                'IDDetalleAsignacion'   => $detalle,  
                'Observacion'           => $observacionDetalle[$key], 
                'UsuarioCrea'           => $this->items['id'],
                'FechaCrea'             => $fechaActual,    
                'Estado'                => "REG",    
                'Localhost'             => $this->request->getIPAddress()
            );
        }
        $lastId = $this->paqueteriadetalle->insertBatch($dataDetalle);
        
		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idPaqueteria);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->reDireccion(base_url()."/listar-paqueteria", 1);
		} 
    }
    
    public function timelinePaqueteria($idPaqueteria)
    {
        if(isset($this->items['id'])){

			/* ACCIONES */
			$listadoEstados = $this->auditoria->listarAuditoriaEstadosPaqueteria($idPaqueteria);

			foreach($listadoEstados as $key=>$value)
            {
                $modifica = $this->usuarios->where("IdUsuario ", $value['UsuarioModifica'])->first();
                if($modifica != null)
                {
                    $listadoEstados[$key]['NombreModifica'] = strtoupper($modifica['Nombres'].' '.$modifica['Apellidos']);
                }
                else
                {
                    $listadoEstados[$key]['NombreModifica'] = "--";
                }
            }

            $estados = $this->globales->estadosPaqueteria();

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Timeline Paquetería | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Timeline Paquetería',
                'previo'                => 'listar-paqueteria',
				'listadoEstados'        => $listadoEstados,
                'estados'               => $estados,
                'idPaqueteria'          => $idPaqueteria
			);
			$data = array_merge($data, $this->items);
			return view('paqueteria/timeline-paqueteria',$data);			
		} else {
			return view('errors/500');
		}
    }
    
    public function guardarEstadoPaqueteria($idPaqueteria)
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $estado = $this->request->getPost('txtEstadoPaqueteria');

        if($estado == 'ENV')
        {
            $diasviaje = $this->request->getPost('txtDiasViaje');
            $proveedor = $this->request->getPost('txtProveedor');
        }
        
        $observacion = $this->request->getPost('txtObservacion');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        $error = '';

        if($estado == 'ENV')
        {
            $error .= $this->complementos->validaCampo($proveedor, 'required|trim', 'Proveedor');
            $error .= $this->complementos->validaCampo($diasviaje, 'required|numeric|trim', 'Dias estimados de viaje');
        }
        
        $error .= $this->complementos->validaCampo($observacion, 'required|trim', 'Observación');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * ACTUALIZACIÓN DE DATOS
        * ----------------------------
       */
      
        $dataPaqueteria = array (
            'UsuarioModifica'       => $this->items['id'],
            'FechaModifica'         => $fechaActual,
            'Estado'                => $estado,
            'FechaEstado'           => $fechaActual,
            'UsuarioEstado'         => $this->items['id'],
            'MotivoCambio'          => $observacion,
            'Localhost'             => $this->request->getIPAddress()
        );
        if($estado == "ENV")
        {
            $dataPaqueteria['FechaEnvio'] = date('Y-m-d', strtotime($fechaActual));
            $dataPaqueteria['DiasEstimadoTransito'] = $diasviaje;
            $dataPaqueteria['Proveedor'] = $proveedor;
        }
        else if($estado == "REC")
        {
            $dataPaqueteria['FechaRecepcion'] = date('Y-m-d', strtotime($fechaActual));
            $dataPaqueteria['UsuarioRecepcion'] = $this->items['id'];
            $dataPaqueteria['ObservacionRecepcion'] = $observacion;
        }

        $lastId = $this->paqueteria->update([$idPaqueteria], $dataPaqueteria);
        
		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idPaqueteria);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->reDireccion(base_url()."/timeline-paqueteria/".$idPaqueteria, 1);
		} 
    }
    
    public function guiaRemisionPaqueteria($idPaqueteria)
    {
        if(isset($this->items['id'])){

			/* ACCIONES */
            
			$paqueteria = $this->paqueteria->where("IDPaqueteria", $idPaqueteria)->first();
            $detallePaqueteria = $this->paqueteriadetalle->listarDetallePaqueteria($idPaqueteria);

                //Obtener 
            $ccRemitente = $this->cc->where("IdDpto ", $paqueteria['CCRemitente'])->first();
            $ccDestinatario = $this->cc->where("IdDpto ", $paqueteria['CCDestinatario'])->first();
            $remitente = $this->usuarios->where("IdUsuario ", $paqueteria['UsuarioRemitente'])->first();
            $destinatario = $this->usuarios->where("IdUsuario ", $paqueteria['UsuarioDestinatario'])->first();
            $direccionRemitente = $this->direccion->where("id_direccion ", $paqueteria['DireccionRemitente'])->first();
            $direccionDestinatario = $this->direccion->where("id_direccion ", $paqueteria['DireccionDestinatario'])->first();

            if($ccRemitente != null)
            {
                $paqueteria['CCRemitente'] = strtoupper($ccRemitente['NombreDpto']);
            }
            else
            {
                $paqueteria['CCRemitente'] = "--";
            }
            
            if($ccDestinatario != null)
            {
                $paqueteria['CCDestinatario'] = strtoupper($ccDestinatario['NombreDpto']);
            }
            else
            {
                $paqueteria['CCDestinatario'] = "--";
            }
            
            if($remitente != null)
            {
                $paqueteria['NombreRemitente'] = strtoupper($remitente['Nombres'].' '.$remitente['Apellidos']);
                $paqueteria['MatriculaRemitente'] = $remitente['Matricula'] ;
            }
            else
            {
                $paqueteria['NombreRemitente'] = "--";
                $paqueteria['MatriculaRemitente'] = "--";
            }
            
            if($destinatario != null)
            {
                $paqueteria['NombreDestinatario'] = strtoupper($destinatario['Nombres'].' '.$destinatario['Apellidos']);
                $paqueteria['MatriculaDestinatario'] = $destinatario['Matricula'] ;
            }
            else
            {
                $paqueteria['NombreDestinatario'] = "--";
                $paqueteria['MatriculaDestinatario'] = "--";
            }

            if($direccionRemitente != null)
            {
                $paqueteria['DireccionRemitente'] = $direccionRemitente['Direccion'] ;
            }
            else
            {
                $paqueteria['DireccionRemitente'] = "--";
            }

            if($direccionDestinatario != null)
            {
                $paqueteria['DireccionDestinatario'] = $direccionDestinatario['Direccion'] ;
            }
            else
            {
                $paqueteria['DireccionDestinatario'] = "--";
            }
            
            foreach($detallePaqueteria as $key=>$value)
            {
                $asignado = $this->usuarios->where("IdUsuario ", $value['UsuarioAsignado'])->first();

                $detallePaqueteria[$key]['UsuarioAsignado'] = strtoupper($asignado['Nombres'].' '.$asignado['Apellidos']);
                //Obtener elemento
                if($value['TipoElemento']=='MOVIL')
                {
                    $dataElemento = $this->moviles->obtenerMovil($value['IDElemento']);
                    $detallePaqueteria[$key]['Elemento'] = $value['TipoElemento']."-".$dataElemento['Marca']." ".$dataElemento['Modelo']." ".$dataElemento['IMEI'];
                    $detallePaqueteria[$key]['Descripcion'] = $value['Observacion'];
                }
                else if($value['TipoElemento']=='LINEA')
                {
                    $dataElemento = $this->lineas->obtenerLinea($value['IDElemento']);
                    $detallePaqueteria[$key]['Elemento'] = $value['TipoElemento']."-".$dataElemento['Numero']." ".$dataElemento['Operador']." ".$dataElemento['ICCID'];
                    $detallePaqueteria[$key]['Descripcion'] = $value['Observacion'];
                }
                else
                {
                    $detallePaqueteria[$key]['Elemento'] = "--";
                    $detallePaqueteria[$key]['Descripcion'] = "--";
                }
                
            }

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Guia Paquetería | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Guia Paquetería',
                'previo'                => 'listar-paqueteria',
                'idPaqueteria'          => $idPaqueteria,
                'paqueteria'            => $paqueteria,
                'detallePaqueteria'     => $detallePaqueteria
			);
			$data = array_merge($data, $this->items);
			return view('paqueteria/guia-paqueteria',$data);			
		} else {
			return view('errors/500');
		}
    }
    
    public function borrarEvento()
    {
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $idPlanificacion = $this->request->getPost('id') ; 
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idPlanificacion, 'required|trim|number', 'ID Planificacion');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $whereDelete = array (
            'IdPlanificacion'     => $idPlanificacion
        );
        
        // $dataPlanificacion = $this->planificacion->join('horario','horario.id_horario')where($whereDelete)->first(); 
        $dataPlanificacion = $this->planificacion
			                ->join('horarios','planificacion.id_horario=horarios.id_horario','left')
			                ->where($whereDelete)
			                ->first();
			                
	    $PlanificacionHorarioEliminado = $dataPlanificacion['horario'] . ' - ' . $dataPlanificacion['codigo'];
	    
        $lastId = $this->planificacion->where($whereDelete)->delete();

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg504, $PlanificacionHorarioEliminado);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    // private function generateCssClass($codigo)
    // {
    //     // Asignar clases de Bootstrap según el patrón del código
    //     if (preg_match('/^A/', $codigo)) {
    //         // Clase para códigos que empiezan con 'A'
    //         return 'bg-success-subtle text-success';
    //     } elseif (preg_match('/^B/', $codigo)) {
    //         // Clase para códigos que empiezan con 'B'
    //         return 'bg-info-subtle text-info';
    //     } elseif (preg_match('/^C/', $codigo)) {
    //         // Clase para códigos que empiezan con 'C'
    //         return 'bg-warning-subtle text-warning';
    //     } else {
    //         // Clase por defecto si el código no coincide con ningún patrón
    //         return 'bg-secondary-subtle text-secondary';
    //     }
    // }
}