<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Globales;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

require 'vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;

class Paqueteria extends BaseController
{
	public function __construct(){
		$this->usuarios = new \App\Models\UsuarioModelo();
		$this->cc = new \App\Models\DepartamentoCCModel();

        $this->auditoria = new \App\Models\AuditoriaModel();
		$this->paqueteria = new \App\Models\PaqueteriaModel();
		$this->paqueteriadetalle = new \App\Models\PaqueteriaDetalleModel();
		$this->moviles = new \App\Models\VAMovilesModel();
		$this->lineas = new \App\Models\VALineasModel();
		$this->detalleasignaciones = new \App\Models\VAAsignacionesDetalleModel();
		$this->direccion = new \App\Models\DireccionModel();
	}

    public function listadoPaqueteria()
    {
        if(isset($this->items['id'])){

			/* ACCIONES */
			$listaPaqueteria = $this->paqueteria->listarPaqueteria();

            foreach($listaPaqueteria as $key=>$value)
            {
                //Obtener 
                $ccRemitente = $this->cc->where("IdDpto ", $value['CCRemitente'])->first();
                $ccDestinatario = $this->cc->where("IdDpto ", $value['CCDestinatario'])->first();
                $remitente = $this->usuarios->where("IdUsuario ", $value['UsuarioRemitente'])->first();
                $destinatario = $this->usuarios->where("IdUsuario ", $value['UsuarioDestinatario'])->first();
                
                if($ccRemitente != null)
                {
                    $listaPaqueteria[$key]['CCRemitente'] = strtoupper($ccRemitente['NombreDpto']);
                }
                else
                {
                    $listaPaqueteria[$key]['CCRemitente'] = "--";
                }
                
                if($ccDestinatario != null)
                {
                    $listaPaqueteria[$key]['CCDestinatario'] = strtoupper($ccDestinatario['NombreDpto']);
                }
                else
                {
                    $listaPaqueteria[$key]['CCDestinatario'] = "--";
                }
                
                if($remitente != null)
                {
                    $listaPaqueteria[$key]['NombreRemitente'] = strtoupper($remitente['Nombres'].' '.$remitente['Apellidos']);
                }
                else
                {
                    $listaPaqueteria[$key]['NombreRemitente'] = "--";
                }
                
                if($destinatario != null)
                {
                    $listaPaqueteria[$key]['NombreDestinatario'] = strtoupper($destinatario['Nombres'].' '.$destinatario['Apellidos']);
                }
                else
                {
                    $listaPaqueteria[$key]['NombreDestinatario'] = "--";
                }
                
                
            }
            $estados = $this->globales->estadosPaqueteria();
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Paquetería | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Paquetería',
				'listaPaqueteria'       => $listaPaqueteria,
                'estados'               => $estados
			);
			$data = array_merge($data, $this->items);
			return view('paqueteria/listar_paqueteria',$data);			
		} else {
			return view('errors/500');
		}
    }
    
    public function nuevaPaqueteria()
    {
        if(isset($this->items['id'])){

			/* ACCIONES */
			//$listaUsuariosRemitente = $this->usuarios->where(array("CC"=>930, "Estado"=>"Activo"))->findAll();
            $ccRemitente = $this->cc->where("IdDpto ", $this->items['dpto'])->first();
			$listadoElementos = $this->detalleasignaciones->detalleAsignacionSinPaqueteria();

			foreach($listadoElementos as $key=>$value)
            {
                //Obtener elemento
                if($value['TipoElemento']=='MOVIL')
                {
                    $dataElemento = $this->moviles->obtenerMovil($value['IDElemento']);
                    $listadoElementos[$key]['NombreElemento'] = $dataElemento['IMEI']." | ".$dataElemento['Marca']." ".$dataElemento['Modelo'];
                }
                else if($value['TipoElemento']=='LINEA')
                {
                    $dataElemento = $this->lineas->obtenerLinea($value['IDElemento']);
                    $listadoElementos[$key]['NombreElemento'] = $dataElemento['Numero']." | ".$dataElemento['Operador']." ".$dataElemento['Plan'];
                }
                else
                {
                    $listadoElementos[$key]['NombreElemento'] = "SIN INFORMACIÓN";
                }
                
            }

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Nueva Paquetería | Verisure',
                'previo'                => 'listar-paqueteria',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Nueva paquetería',
				//'listaUsuariosRemitente'=> $listaUsuariosRemitente,
				'elementosDetalle'		=> $listadoElementos,
                'ccRemitente'           => $ccRemitente
			);
			$data = array_merge($data, $this->items);
			return view('paqueteria/nueva_paqueteria',$data);			
		} else {
			return view('errors/500');
		}
    }

	public function listadoCCSelect()
	{
		$elemento = $this->request->getPost('term');
        
        $listado = $this->cc->listadoCCSelect($elemento['term']);

        $elementos=array();

        foreach ($listado as $items) {
            $elementos[] = array(
                'id' => (string) $items['IdDpto'],
                'text' => (string) $items['CC']." | ".$items['NombreDpto']
            );
        }

        echo json_encode($elementos);
	}

	public function listadoUsuariosCCSelect()
	{
		$elemento = $this->request->getPost('term');
        
        $listado = $this->usuarios->listadoUsuariosSelect($elemento['term'], '');

        $elementos=array();

        foreach ($listado as $items) {
            $elementos[] = array(
                'id' => (string) $items['IdUsuario'],
                'text' => (string) $items['Matricula']." | ".$items['Nombres']." ".$items['Apellidos']." ".$items['CC']
            );
        }

        echo json_encode($elementos);
	}

    public function guardarPaqueteria()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $ccdestinatario = $this->request->getPost('txtCCDestinatario');
        $destinatario = $this->request->getPost('txtDestinatario');
        $direcdestinatario = $this->request->getPost('txtDireccionDestinatario');
        //$fechaenvio = $this->request->getPost('txtFechaEnvio');
        //$diasviaje = $this->request->getPost('txtDiasViaje');
        $ccremitente = $this->request->getPost('txtCCRemitente');
        $remitente = $this->request->getPost('txtRemitente');
        $direcremitente = $this->request->getPost('txtDireccionRemitente');
        //$proveedor = $this->request->getPost('txtProveedor');
        $observacion = $this->request->getPost('txtObservacion');
        
        $elementoDetalle = $this->request->getPost('elemento');
        $etiquetaelemento = $this->request->getPost('etiquetaelemento');
        $observacionDetalle = $this->request->getPost('obselemento');
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        $error = '';
        $error .= $this->complementos->validaCampo($ccdestinatario, 'required|trim', 'Centro de Costo Destinatario');
        $error .= $this->complementos->validaCampo($destinatario, 'required|trim', 'Destinatario');
        $error .= $this->complementos->validaCampo($direcdestinatario, 'required|trim', 'Dirección Destinatario');
        //$error .= $this->complementos->validaCampo($fechaenvio, 'required|dateDos', 'Fecha de envío');
        //$error .= $this->complementos->validaCampo($diasviaje, 'required|numeric|trim', 'Dias estimados de viaje');
        $error .= $this->complementos->validaCampo($ccremitente, 'required|trim', 'Centro de Costo Remitente');
        $error .= $this->complementos->validaCampo($remitente, 'required|trim', 'Usuario remitente');
        $error .= $this->complementos->validaCampo($direcremitente, 'required|trim', 'Dirección Remitente');
        //$error .= $this->complementos->validaCampo($proveedor, 'required|trim', 'Proveedor');
        $error .= $this->complementos->validaCampo($observacion, 'required|trim', 'Observación');
        
        if(count($elementoDetalle)==0)
        {
            $error .= "<li>Debe registrar un item para el envío de paquetería.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        foreach($elementoDetalle as $key=>$detalle)
        {
            $itemAsignado = $this->paqueteriadetalle->where("IDDetalleAsignacion", $detalle)->findAll();
            if(count($itemAsignado)>0)
            {
                $msgExistencia .= "<li>El ".$etiquetaelemento[$key]." ya fue asignado.</li>";
            }
        }
		
        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
       */
        $dataPaqueteria = array (
            'CCRemitente'           => $ccremitente, 
            'UsuarioRemitente'      => $remitente, 
            'DireccionRemitente'    => $direcremitente, 
            //'FechaEnvio'            => $fechaenvio, 
            //'DiasEstimadoTransito'  => $diasviaje, 
            'CCDestinatario'        => $ccdestinatario, 
            'UsuarioDestinatario'   => $destinatario, 
            'DireccionDestinatario' => $direcdestinatario, 
            //'Proveedor'             => $proveedor, 
            'Descripcion'           => $observacion, 
            'UsuarioCrea'           => $this->items['id'],
            'FechaCrea'             => $fechaActual,
            'Estado'                => "REG",
            'FechaEstado'           => $fechaActual,
            'UsuarioEstado'         => $this->items['id'],
            'MotivoCambio'          => "Registro de envío de paquetería",
            'Localhost'             => $this->request->getIPAddress()
        );

        $lastIdPaqueteria = $this->paqueteria->insert($dataPaqueteria, TRUE);
        
        if($lastIdPaqueteria !== FALSE){
            $idPaqueteria = $lastIdPaqueteria;
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar la paquetería. Inténtelo luego.</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
        }
            
        $dataDetalle = array();

        foreach($elementoDetalle as $key=>$detalle)
        {
            $dataDetalle[] = array (
                'IDPaqueteria'          => $idPaqueteria, 
                'IDDetalleAsignacion'   => $detalle,  
                'Observacion'           => $observacionDetalle[$key], 
                'UsuarioCrea'           => $this->items['id'],
                'FechaCrea'             => $fechaActual,    
                'Estado'                => "REG",    
                'Localhost'             => $this->request->getIPAddress()
            );
        }
        $lastId = $this->paqueteriadetalle->insertBatch($dataDetalle);
        
		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idPaqueteria);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->reDireccion(base_url()."/listar-paqueteria", 1);
		} 
    }
    
    public function timelinePaqueteria($idPaqueteria)
    {
        if(isset($this->items['id'])){

			/* ACCIONES */
			$listadoEstados = $this->auditoria->listarAuditoriaEstadosPaqueteria($idPaqueteria);

			foreach($listadoEstados as $key=>$value)
            {
                $modifica = $this->usuarios->where("IdUsuario ", $value['UsuarioModifica'])->first();
                if($modifica != null)
                {
                    $listadoEstados[$key]['NombreModifica'] = strtoupper($modifica['Nombres'].' '.$modifica['Apellidos']);
                }
                else
                {
                    $listadoEstados[$key]['NombreModifica'] = "--";
                }
            }

            $estados = $this->globales->estadosPaqueteria();

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Timeline Paquetería | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Timeline Paquetería',
                'previo'                => 'listar-paqueteria',
				'listadoEstados'        => $listadoEstados,
                'estados'               => $estados,
                'idPaqueteria'          => $idPaqueteria
			);
			$data = array_merge($data, $this->items);
			return view('paqueteria/timeline-paqueteria',$data);			
		} else {
			return view('errors/500');
		}
    }
    
    public function guardarEstadoPaqueteria($idPaqueteria)
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $estado = $this->request->getPost('txtEstadoPaqueteria');

        if($estado == 'ENV')
        {
            $diasviaje = $this->request->getPost('txtDiasViaje');
            $proveedor = $this->request->getPost('txtProveedor');
        }
        
        $observacion = $this->request->getPost('txtObservacion');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        $error = '';

        if($estado == 'ENV')
        {
            $error .= $this->complementos->validaCampo($proveedor, 'required|trim', 'Proveedor');
            $error .= $this->complementos->validaCampo($diasviaje, 'required|numeric|trim', 'Dias estimados de viaje');
        }
        
        $error .= $this->complementos->validaCampo($observacion, 'required|trim', 'Observación');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * ACTUALIZACIÓN DE DATOS
        * ----------------------------
       */
      
        $dataPaqueteria = array (
            'UsuarioModifica'       => $this->items['id'],
            'FechaModifica'         => $fechaActual,
            'Estado'                => $estado,
            'FechaEstado'           => $fechaActual,
            'UsuarioEstado'         => $this->items['id'],
            'MotivoCambio'          => $observacion,
            'Localhost'             => $this->request->getIPAddress()
        );
        if($estado == "ENV")
        {
            $dataPaqueteria['FechaEnvio'] = date('Y-m-d', strtotime($fechaActual));
            $dataPaqueteria['DiasEstimadoTransito'] = $diasviaje;
            $dataPaqueteria['Proveedor'] = $proveedor;
        }
        else if($estado == "REC")
        {
            $dataPaqueteria['FechaRecepcion'] = date('Y-m-d', strtotime($fechaActual));
            $dataPaqueteria['UsuarioRecepcion'] = $this->items['id'];
            $dataPaqueteria['ObservacionRecepcion'] = $observacion;
        }

        $lastId = $this->paqueteria->update([$idPaqueteria], $dataPaqueteria);
        
		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idPaqueteria);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->reDireccion(base_url()."/timeline-paqueteria/".$idPaqueteria, 1);
		} 
    }
    
    public function guiaRemisionPaqueteria($idPaqueteria)
    {
        if(isset($this->items['id'])){

			/* ACCIONES */
            
			$paqueteria = $this->paqueteria->where("IDPaqueteria", $idPaqueteria)->first();
            $detallePaqueteria = $this->paqueteriadetalle->listarDetallePaqueteria($idPaqueteria);

                //Obtener 
            $ccRemitente = $this->cc->where("IdDpto ", $paqueteria['CCRemitente'])->first();
            $ccDestinatario = $this->cc->where("IdDpto ", $paqueteria['CCDestinatario'])->first();
            $remitente = $this->usuarios->where("IdUsuario ", $paqueteria['UsuarioRemitente'])->first();
            $destinatario = $this->usuarios->where("IdUsuario ", $paqueteria['UsuarioDestinatario'])->first();
            $direccionRemitente = $this->direccion->where("id_direccion ", $paqueteria['DireccionRemitente'])->first();
            $direccionDestinatario = $this->direccion->where("id_direccion ", $paqueteria['DireccionDestinatario'])->first();

            if($ccRemitente != null)
            {
                $paqueteria['CCRemitente'] = strtoupper($ccRemitente['NombreDpto']);
            }
            else
            {
                $paqueteria['CCRemitente'] = "--";
            }
            
            if($ccDestinatario != null)
            {
                $paqueteria['CCDestinatario'] = strtoupper($ccDestinatario['NombreDpto']);
            }
            else
            {
                $paqueteria['CCDestinatario'] = "--";
            }
            
            if($remitente != null)
            {
                $paqueteria['NombreRemitente'] = strtoupper($remitente['Nombres'].' '.$remitente['Apellidos']);
                $paqueteria['MatriculaRemitente'] = $remitente['Matricula'] ;
            }
            else
            {
                $paqueteria['NombreRemitente'] = "--";
                $paqueteria['MatriculaRemitente'] = "--";
            }
            
            if($destinatario != null)
            {
                $paqueteria['NombreDestinatario'] = strtoupper($destinatario['Nombres'].' '.$destinatario['Apellidos']);
                $paqueteria['MatriculaDestinatario'] = $destinatario['Matricula'] ;
            }
            else
            {
                $paqueteria['NombreDestinatario'] = "--";
                $paqueteria['MatriculaDestinatario'] = "--";
            }

            if($direccionRemitente != null)
            {
                $paqueteria['DireccionRemitente'] = $direccionRemitente['Direccion'] ;
            }
            else
            {
                $paqueteria['DireccionRemitente'] = "--";
            }

            if($direccionDestinatario != null)
            {
                $paqueteria['DireccionDestinatario'] = $direccionDestinatario['Direccion'] ;
            }
            else
            {
                $paqueteria['DireccionDestinatario'] = "--";
            }
            
            foreach($detallePaqueteria as $key=>$value)
            {
                $asignado = $this->usuarios->where("IdUsuario ", $value['UsuarioAsignado'])->first();

                $detallePaqueteria[$key]['UsuarioAsignado'] = strtoupper($asignado['Nombres'].' '.$asignado['Apellidos']);
                //Obtener elemento
                if($value['TipoElemento']=='MOVIL')
                {
                    $dataElemento = $this->moviles->obtenerMovil($value['IDElemento']);
                    $detallePaqueteria[$key]['Elemento'] = $value['TipoElemento']."-".$dataElemento['Marca']." ".$dataElemento['Modelo']." ".$dataElemento['IMEI'];
                    $detallePaqueteria[$key]['Descripcion'] = $value['Observacion'];
                }
                else if($value['TipoElemento']=='LINEA')
                {
                    $dataElemento = $this->lineas->obtenerLinea($value['IDElemento']);
                    $detallePaqueteria[$key]['Elemento'] = $value['TipoElemento']."-".$dataElemento['Numero']." ".$dataElemento['Operador']." ".$dataElemento['ICCID'];
                    $detallePaqueteria[$key]['Descripcion'] = $value['Observacion'];
                }
                else
                {
                    $detallePaqueteria[$key]['Elemento'] = "--";
                    $detallePaqueteria[$key]['Descripcion'] = "--";
                }
                
            }

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Guia Paquetería | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Guia Paquetería',
                'previo'                => 'listar-paqueteria',
                'idPaqueteria'          => $idPaqueteria,
                'paqueteria'            => $paqueteria,
                'detallePaqueteria'     => $detallePaqueteria
			);
			$data = array_merge($data, $this->items);
			return view('paqueteria/guia-paqueteria',$data);			
		} else {
			return view('errors/500');
		}
    }
}