<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

class Horarios extends BaseController
{
	public function __construct(){
	    $this->usuarioModelo = new \App\Models\UsuarioModelo();
		$this->grupoTrabajo = new \App\Models\GruposTrabajoModel();
		$this->usuarioGruposTrabajo = new \App\Models\UsuarioGruposTrabajoModel();
		$this->horariosModelo = new \App\Models\HorariosModel();
		$this->grupoTrabajoUsuarios = new \App\Models\UsuarioGruposTrabajoModel();
	}
	
	
	/**********************************/
	
	public function listarHorario()
	{
	   /* NUEVO REQUERIMIENTO */
		    
		$idUsuario = $this->items['id'];
			
	    /* GRUPO DE TRABAJO */
			
	    $whereUsuarioCrea = array(
			'JefeGrupoTrabajo' => $idUsuario
		);
			
		$grupoTrabajo = $this->grupoTrabajo->where($whereUsuarioCrea)->findAll(); 
			
		/* USUARIOS GRUPO DE TRABAJO */
			
// 		$whereUsuarioRegistra = array(
// 			'UsuarioRegistra' => $idUsuario
// 		);
			
// 		$grupoTrabajoUsuarios = $this->grupoTrabajoUsuarios->where($whereUsuarioRegistra)->findAll();
			
        /* BUSCAR PERFILES  */
            
		$data = array (
			'session'               => 'on',
			'titulo'                => 'Horarios | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Listado de horarios',
				'grupoTrabajo'          => $grupoTrabajo
				// 'grupoTrabajoUsuarios'  => $grupoTrabajoUsuarios
			);
			$data = array_merge($data, $this->items);
			return view('horarios/listado-horarios',$data);
	}
	
	public function listadoHorariosEstructura()
    {
        /*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        
		$idUsuarioPlanificacion = $this->request->getPost('idUsuarioPlanificacion');
		
		$idHorarioSeleccionado = $this->request->getPost('idSeleccionado');

        if($idUsuarioPlanificacion == 'TOTAL')
        {
            $listadoHorarios = $this->horariosModelo->findAll();
        }
        else
        { 
            $listadoHorarios = $this->horariosModelo->listarHorariosXPlanificacion($idUsuarioPlanificacion);
            
        }
        

        $horarios=array();

		if (!empty($listadoHorarios)) {
            foreach ($listadoHorarios as $items) {
                $horarios[] = array(
					'id' => (string) $items['id_horario'],
         	        'text' => (string) $items['horario'].' | '.$items['codigo']
                );
            }

            $resultado = array(
				'listadoHorarios' => json_encode($horarios)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}
		
        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);
    }
    
    public function listarHorarioDataTable()
    {

        $idUsuario = $this->items['id'];

        $adicionales = array(
            "IDPerfil"  => $this->items['idPerfil'],
            "IDUsuario" => $this->items['id'],
            "Idusuario" => $idUsuario
        );
        /* LISTAR ORDEN DE COMPRA */
        $dataServerside = $this->horariosModelo->listaHorariosServerSide($this->request->getGet(), $adicionales);
        // $recordsTotal = !empty($dataServerside) ? count($dataServerside) : 0;
        // $recordsFiltered = count($this->horariosModelo->where('EliminacionLogica',1)->findAll());
        // $whereHorarios = array('UsuarioRegistra' => $this->items['id']);
        
        // $recordsFiltered = count($this->horariosModelo->where($whereHorarios)->groupBy('id_horario')->findAll());
        
        foreach($dataServerside["data"] as $key=>$value)
        {
            $dataServerside["data"][$key]['Acciones'] = "
                                                <button class='badge border-0 bg-info p-2 mx-1 datos-horario' data-id='".$value['id_horario'] ."' type='button' data-bs-target='#informacionHorario' data-form='#formInformacionHorario' data-accion='ver' id='ver-horario'>
                                                    <i class='ri-eye-fill align-middle' style='font-size: 20px; color: #FFF;'></i>
                                                </button>
                                                <button class='badge border-0 bg-warning p-2 mx-1 datos-horario' data-id='".$value['id_horario'] ."' type='button' data-bs-target='#informacionHorario' data-form='#formInformacionHorario' data-accion='editar' id='editar-horario'>
                                                    <i class='ri-edit-2-fill align-middle' style='font-size: 20px; color: #FFF;'></i>
                                                </button>";
            
			if (in_array("ESTHOR", $this->items['permisos'])) 
			{
			    $dataServerside["data"][$key]['EstadoHorario'] = "<span class='badge ".($value['estadoHorario'] == "A" ? "bg-success" : "bg-danger")." border-0 cambiar-estado-horario' style='cursor: pointer;' data-id='".$value['id_horario'] ."' data-estado='".$value['estadoHorario'] ."'>".($value['estadoHorario'] == "A" ? "Activo" : "Inactivo")."</span>";
			}
			else
			{
			    $dataServerside["data"][$key]['EstadoHorario'] = "<span class='badge ".($value['estadoHorario'] == "A" ? "bg-success" : "bg-danger")." border-0'>".($value['estadoHorario'] == "A" ? "Activo" : "Inactivo")."</span>";
			}
        }

        $datos = [
            'draw'              => $dataServerside['draw'],
            'data'              => $dataServerside['data'],
            'recordsTotal'      => $dataServerside['recordsTotal'],
            'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
        ];
        
        echo json_encode($datos, JSON_NUMERIC_CHECK);    
    }
    
    public function registrarHorario()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $codigo     = $this->request->getPost('txtCodigoHorario_i');
        $horario    = $this->request->getPost('txtHorario_i');
        $inicio     = $this->request->getPost('txtInicioHorario_i');
        $fin        = $this->request->getPost('txtFinHorario_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($codigo, 'required|trim|alphaspecial|minlength[1]|maxlength[5]', 'Código');
        $error .= $this->complementos->validaCampo($horario, 'required|trim|minlength[1]|maxlength[20]', 'Horario');
        $error .= $this->complementos->validaCampo($inicio, 'required|trim', 'Inicio');
        $error .= $this->complementos->validaCampo($fin, 'required|trim', 'Fin');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereHorario = array(
            "horario" => $horario
        );
        
        $whereCodigo = array(
            "codigo" => $codigo
        );
        
        $whereTiempos = array(
            "HoraInicio"=> $inicio,
            "HoraFin"   => $fin
        );
        
		$horarioExistente   = $this->horariosModelo->where($whereHorario)->findAll();
		$codigoExistente    = $this->horariosModelo->where($whereCodigo)->findAll();
		$tiemposExistente   = $this->horariosModelo->where($whereTiempos)->findAll();
		
        if(count($horarioExistente)>0)
        {
            $msgExistencia .= "<li>El horario ya fue registrada previamente. [CAMPO] <small>HORARIO</small></li>";
        }

        if(count($codigoExistente)>0)
        {
            $msgExistencia .= "<li>El código ya fue registrada previamente. [CAMPO] <small>CÓDIGO</small></li>";
        }

        if(count($tiemposExistente)>0)
        {
            $msgExistencia .= "<li>La combinación de Inicio y Fin ya fue registrada previamente. [CAMPO] <small>INICIO - FIN</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'horario'           => $horario,
            'codigo'            => $codigo,
            'HoraInicio'        => $inicio,
            'HoraFin'           => $fin,
            'UsuarioRegistra'   => $this->items['id'],
            'FechaRegistra'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,    
            'MotivoEstado'      => "Creación de horario.",    
            'Estado'            => 'A'
        );

        $lastId = $this->horariosModelo->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $horario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

    public function obtenerDetallesHorario()
    {
        if(isset($this->items['id']))
        {
            $idHorario = $this->request->getPost('id_horario');
            $whereHorarios = array('id_horario' => $idHorario);
            // $datoHorario = $this->horariosModelo->find($idHorario);
            
    		$datoHorario = $this->horariosModelo->where($whereHorarios)->first();
    
    		if(!empty($datoHorario))
    		{
    			$resultado = array(
    				'codigo'      => (string) $datoHorario['codigo'],
    				'horario'       => (string) $datoHorario['horario'],
    				'HoraInicio' => (string) $datoHorario['HoraInicio'],
    				'HoraFin' => (string) $datoHorario['HoraFin']
    			);
    			
    		} else {
    			$resultado = array(
    				'descripcion' => 0
    			);
    		}
    
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado);
        }
        else
        {
            $resultado = array(
                'descripcion' => 0
            );
            
            echo json_encode($resultado);
        }
    }
    
    public function actualizarHorario($idHorario)
    {
        $fechaActual = date("Y-m-d H:i:s"); 

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $codigo     = $this->request->getPost('txtCodigoHorario_i');
        $horario    = $this->request->getPost('txtHorario_i');
        $inicio     = $this->request->getPost('txtInicioHorario_i');
        $fin        = $this->request->getPost('txtFinHorario_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($codigo, 'required|trim|alphaspecial|minlength[1]|maxlength[5]', 'Código');
        $error .= $this->complementos->validaCampo($horario, 'required|trim|minlength[1]|maxlength[20]', 'Horario');
        $error .= $this->complementos->validaCampo($inicio, 'required|trim', 'Inicio');
        $error .= $this->complementos->validaCampo($fin, 'required|trim', 'Fin');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'codigo'            => $codigo,
            'horario'           => $horario,
            'HoraInicio'        => $inicio,
            'HoraFin'           => $fin,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual
        );
        
        $lastId = $this->horariosModelo->update([$idHorario], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idHorario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function eliminarHorario()
    {
        $fechaActual = date("Y-m-d H:i:s");

        // $idHorario = $this->request->getPost('id_horario');
        // $this->horarios->delete($idHorario); // Asegúrate de que tu modelo maneje la eliminación correctamente
        // return $this->response->setJSON(['status' => 'success']);
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $idHorario = $this->request->getPost('idHorario');
        $estado = $this->request->getPost('estado');
        $motivo = $this->request->getPost('motivo');
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idHorario, 'required|trim|number', 'ID Horario');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

//         $whereDelete = array (
//             'id_horario'         => $idHorario
//         );

//         $lastId = $this->horariosModelo->where($whereDelete)->delete();

// 		if($lastId !== FALSE){
// 			$message = sprintf($this->mensajeError->msg504, $idHorario);
// 			echo $this->alertas->alertaExito($message);
// 			echo $this->alertas->refrescar(1);
// 		}

        
        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        $lastId = $this->horariosModelo->update([$idHorario], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idHorario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}

    }

	public function listarGruposTrabajo()
	{
    	if(isset($this->items['id'])){

			/* ACCIONES */
			$listadoGruposTrabajo = $this->grupostrabajo->findAll();
			
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Grupos de Trabajo | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Grupos de Trabajo',
				'listadoGruposTrabajo'  => $listadoGruposTrabajo
			);
			$data = array_merge($data, $this->items);
			return view('configuracion/listar_grupos_trabajo',$data);			
		} else {
			return view('errors/500');
		}	
	}

	public function registrarGrupoTrabajo()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $grupoTrabajo  = ucwords(mb_strtolower($this->request->getPost('txtGrupoTrabajo_i')));
        $observacion    = $this->request->getPost('txtObservacionGrupoTrabajo_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($grupoTrabajo, 'required|trim|minlength[1]|maxlength[50]', 'Grupo de Trabajo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$gtExistente = $this->grupostrabajo->where("GrupoTrabajo", $grupoTrabajo)->findAll();
        
        if(count($gtExistente)>0)
        {
            $msgExistencia .= "<li>El grupo de trabajo ya fue registrado. [CAMPO] <small>GRUPO DE TRABAJO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'GrupoTrabajo'  => $grupoTrabajo,
            'Observacion'   => $observacion,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress(),
            'UsuarioEstado' => $this->items['id'],
            'FechaEstado'   => $fechaActual,    
            'MotivoEstado'  => "Creación de grupo de trabajo.",    
            'Estado'        => 'A'
        );

        $lastId = $this->grupostrabajo->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $grupoTrabajo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
	public function obtenerDatosGrupoTrabajo()
	{
		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idGrupoTrabajo = $this->request->getPost('idGrupoTrabajo');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idGrupoTrabajo, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosGrupoTrabajo = $this->grupostrabajo->where('IDGrupoTrabajo', $idGrupoTrabajo)->first();

		if(!empty($datosGrupoTrabajo)){
			$resultado = array(
				'idgrupotrabajo'    => (string) $idGrupoTrabajo,
				'grupotrabajo'      => (string) $datosGrupoTrabajo['GrupoTrabajo'],
				'observacion'       => (string) $datosGrupoTrabajo['Observacion']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}
	
	public function modificarGrupoTrabajo($idGrupoTrabajo)
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $grupoTrabajo  = ucwords(mb_strtolower($this->request->getPost('txtGrupoTrabajo_i'))) ;
        $observacion    = $this->request->getPost('txtObservacionGrupoTrabajo_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($grupoTrabajo, 'required|trim|minlength[1]|maxlength[50]', 'Grupo de Trabajo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'GrupoTrabajo'      => $grupoTrabajo,
            'Observacion'       => $observacion,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->grupostrabajo->update([$idGrupoTrabajo], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $grupoTrabajo);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
	}
	
    public function modificarEstadoGrupoTrabajo()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idGrupoTrabajo = $this->request->getPost('idGrupoTrabajo');
        $estado = $this->request->getPost('estado');
        $motivo = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idGrupoTrabajo, 'required|trim|numeric', 'ID Grupo de Trabajo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        $lastId = $this->grupostrabajo->update([$idGrupoTrabajo], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idGrupoTrabajo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function listadoGruposTrabajo()
    {
        // $tipoRequerimiento = $this->request->getPost("tipoRequerimiento");
        
        // if($tipoRequerimiento != '' && $tipoRequerimiento != null && $tipoRequerimiento != "undefined")
        // {
        //     $listado = $this->requerimientos->where("Tipo", $tipoRequerimiento)->findAll();
        // }
        // else
        // {
        //     $listado = $this->requerimientos->findAll();
        // }
        
        $listado = $this->grupostrabajo->findAll();
        
        $elementos=array();

		if (!empty($listado)) {
            foreach ($listado as $items) {
                $elementos[] = array(
					'id' => (string) $items['IDGrupoTrabajo'],
                    'text' => (string) $items['GrupoTrabajo']
                );
            }

            $resultado = array(
				'listadoGruposTrabajo' => json_encode($elementos)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
    }
    
    public function listarUsuariosGrupoTrabajo($idGrupoTrabajo)
    {
        if(isset($this->items['id'])){
			/* BUSCAR ACCIONES */
			$whereUGT = array(
			    "idgrupotrabajo"    => $idGrupoTrabajo
			);
			$grupoTrabajo = $this->grupostrabajo->where("IDGrupoTrabajo", $idGrupoTrabajo)->first();
			$listaUsuarios = $this->usuarioGruposTrabajo->listarUsuariosGrupoTrabajo($whereUGT);
            
			$data = array (
				'session'           => 'on',
				'titulo'            => 'Usuarios - Grupo de Trabajo | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Usuarios asociados - '.$grupoTrabajo['GrupoTrabajo'],
                'previo'            => 'listar-grupos-trabajo',
				'listaUsuarios'     => $listaUsuarios,
                'idGrupoTrabajo'    => $idGrupoTrabajo
			);
			$data = array_merge($data, $this->items);
			return view('configuracion/listar_usuarios_grupo_trabajo',$data);			
		} else {
			return view('errors/500');	
		}
    }
    
    public function asociarUsuarioGrupoTrabajo()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError       = TRUE;
        $idUsuario      = $this->request->getPost('idUsuario');
        $idGrupoTrabajo = $this->request->getPost('idGrupoTrabajo');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idUsuario, 'required|trim|number', 'ID Usuario');
        $error .= $this->complementos->validaCampo($idGrupoTrabajo, 'required|trim|number', 'ID Grupo de Trabajo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereUGT = array(
            'IdUsuario'         => $idUsuario,
            'IDGrupoTrabajo'    => $idGrupoTrabajo
        );
        
		$combinacionExistente = $this->usuarioGruposTrabajo->where($whereUGT)->findAll();
		
        if(count($combinacionExistente)>0)
        {
            $msgExistencia .= "<li>El usuario ya fue agregado al grupo de trabajo. [CAMPO] <small>USUARIO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'IdUsuario'         => $idUsuario, 
            'IDGrupoTrabajo'    => $idGrupoTrabajo,
            'UsuarioRegistra'   => $this->items['id'],
            'FechaRegistra'     => $fechaActual
        );

        $lastId = $this->usuarioGruposTrabajo->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function eliminarUsuarioGrupoTrabajo()
    {
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $idUsuario      = $this->request->getPost('idUsuario');
        $idGrupoTrabajo = $this->request->getPost('idGrupoTrabajo');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idUsuario, 'required|trim|number', 'ID Usuario');
        $error .= $this->complementos->validaCampo($idGrupoTrabajo, 'required|trim|number', 'ID Grupo de Trabajo');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $whereDelete = array (
            'IdUsuario'         => $idUsuario, 
            'IDGrupoTrabajo'    => $idGrupoTrabajo
        );

        $lastId = $this->usuarioGruposTrabajo->where($whereDelete)->delete();

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg504, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

    public function listarUsuariosGrupoTrabajoSelect()
    {
        $elemento = $this->request->getPost('term');
        $infoPeticion = $this->peticiones->where("IDPeticion", $elemento['peticion'])->first();
        $whereUGT = array(
		    "idgrupotrabajo"=> $infoPeticion['IDGrupoTrabajo'],
		    "like"          => $elemento['term']
		);
		
		$listado = $this->usuarioGruposTrabajo->listarUsuariosGrupoTrabajo($whereUGT);
        
        // $listado = $this->usuarioModelo->listadoUsuariosSelect($elemento['term'], '', 'Activo');
        
        $elementos=array();

        foreach ($listado as $items) {
            $elementos[] = array(
                'id' => (string) $items['IdUsuario'],
                'text' => (string) $items['Matricula']." | ".$items['Nombres']." ".$items['Apellidos']
            );
        }

        echo json_encode($elementos);
    }
}