<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

class Configuracion extends BaseController
{
	public function __construct(){
		$this->grupostrabajo = new \App\Models\GruposTrabajoModel();
		
		$this->usuarioGruposTrabajo = new \App\Models\UsuarioGruposTrabajoModel();
		$this->horarios = new \App\Models\HorariosModel();
		$this->horarioGrupoTrabajo = new \App\Models\HorarioGrupoTrabajoModel();
	}

	public function listarGruposTrabajo()
	{
    	if(isset($this->items['id'])){

			/* ACCIONES */
			$listadoGruposTrabajo = $this->grupostrabajo->findAll();
			$listadoHorarios = $this->horarios->findAll();
			
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Grupos de Trabajo | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Grupos de Trabajo',
				'listadoGruposTrabajo'  => $listadoGruposTrabajo,
				'listadoHorarios'  => $listadoHorarios
			);
			$data = array_merge($data, $this->items);
			return view('configuracion/listar_grupos_trabajo',$data);			
		} else {
			return view('errors/500');
		}	
	}

	public function registrarGrupoTrabajo()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $grupoTrabajo  = ucwords(mb_strtolower($this->request->getPost('txtGrupoTrabajo_i')));
        $observacion    = $this->request->getPost('txtObservacionGrupoTrabajo_i');
        $horarioMultiple = $this->request->getPost('txt_horario_multiple'); 
        
        if($horarioMultiple == 'on'){
            $horarioMultiple = "SI";
        }else{
            $horarioMultiple = "NO";
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($grupoTrabajo, 'required|trim|minlength[1]|maxlength[50]', 'Grupo de Trabajo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$gtExistente = $this->grupostrabajo->where("GrupoTrabajo", $grupoTrabajo)->findAll();
        
        if(count($gtExistente)>0)
        {
            $msgExistencia .= "<li>El grupo de trabajo ya fue registrado. [CAMPO] <small>GRUPO DE TRABAJO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'GrupoTrabajo'  => $grupoTrabajo,
            'Observacion'   => $observacion,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress(),
            'UsuarioEstado' => $this->items['id'],
            'FechaEstado'   => $fechaActual,    
            'MotivoEstado'  => "Creación de grupo de trabajo.",    
            'Estado'        => 'A',
            'multi_horario' => $horarioMultiple
        );

        $lastId = $this->grupostrabajo->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $grupoTrabajo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
	public function listarUsuarioGrupoDataTable()
    {  
      
        $idGrupoTrabajo = $this->request->getVar('idGrupoTrabajo');
        $idUsuario = $this->items['id'];
        $adicionales = array(
            // "grupostrabajo.JefeGrupoTrabajo" => $idUsuario,
            'vista_usuarios_grupostrabajo.IdGrupoTrabajo' => $idGrupoTrabajo
        );
        
        /* BUSCAR ACCIONES */

        // 		$listaUsuarios = $this->usuarioGruposTrabajo->listarUsuariosGrupoTrabajo($adicionales);

        /* LISTAR ORDEN DE COMPRA */
        $dataServerside = $this->usuarioGruposTrabajo->listarUsuariosGrupoTrabajoServerSide($this->request->getGet(), $adicionales); //var_dump($dataServerside);exit();
        $recordsTotal = !empty($dataServerside) ? count($dataServerside) : 0;
        // $recordsFiltered = count($this->horarios->where('EliminacionLogica',1)->findAll());
        $wherePlanificacion = array('UsuarioCreador' => $this->items['id']);
        $recordsFiltered = count($this->usuarioGruposTrabajo->contarUsuariosGrupoTrabajoServerSide($adicionales));
   
        foreach($dataServerside as $key=>$value)
        {
            $dataServerside[$key]['Eliminar'] = "<button class='badge bg-danger border-0 p-2 eliminar-usuario-grupo-trabajo' data-usuario= '" . $value['IdUsuario'] . "' data-grupotrabajo='" . $value['IDGrupoTrabajo'] . "'>
                                                        <i class='mdi mdi-trash-can-outline align-bottom' style='font-size: 20px; color: #FFF;'></i>
                                                </button>";
            
            $dataServerside[$key]['Ingreso'] = "<button class='badge bg-success border-0')>" . $value['FechaIngreso'] . "</button>";
            
            if($value['FechaCese'] == NULL){
                $dataServerside[$key]['Cese'] = "<button class='badge bg-danger border-0')>-</button>";
            }else{
                $dataServerside[$key]['Cese'] = "<button class='badge bg-danger border-0')>" . $value['FechaCese'] . "</button>";
            }
        }

        $datos = [
            'draw' => $this->request->getGet('draw'),
            'recordsTotal' => $recordsTotal,
            'recordsFiltered' => $recordsFiltered,
            'data' => $dataServerside
        ];
        echo json_encode($datos, JSON_NUMERIC_CHECK);    
    }
	
	public function obtenerDatosGrupoTrabajo()
	{
		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idGrupoTrabajo = $this->request->getPost('idGrupoTrabajo');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idGrupoTrabajo, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosGrupoTrabajo = $this->grupostrabajo->obtenerGrupoTrabajo($idGrupoTrabajo);

		if(!empty($datosGrupoTrabajo)){
			$resultado = array(
				'idgrupotrabajo'    => (string) $idGrupoTrabajo,
				'IDDireccion'    => (string) $datosGrupoTrabajo['IDDireccion'],
				'IDArea'    => (string) $datosGrupoTrabajo['IDArea'],
				'IdSubarea'    => (string) $datosGrupoTrabajo['IdSubarea'],
				'JefeGrupoTrabajo'    => (string) $datosGrupoTrabajo['JefeGrupoTrabajo'],
				'grupotrabajo'      => (string) $datosGrupoTrabajo['GrupoTrabajo'],
				'observacion'       => (string) $datosGrupoTrabajo['Observacion'],
				'multiHorario'       => (string) $datosGrupoTrabajo['multi_horario']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}
	
	public function modificarGrupoTrabajo($idGrupoTrabajo)
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $grupoTrabajo  = ucwords(mb_strtolower($this->request->getPost('txtGrupoTrabajo_i'))) ;
        $observacion    = $this->request->getPost('txtObservacionGrupoTrabajo_i');
        $direccion    = $this->request->getPost('txtDireccionGrupoTrabajoUsuario_i');
        $area    = $this->request->getPost('txtAreaGrupoTrabajo_i');
        $subarea    = $this->request->getPost('txtSubArea_i');
        $jefeGrupoTrabajo    = $this->request->getPost('txtJefeGrupoTrabajo_i');
        $horarioMultiple = $this->request->getPost('txt_horario_multiple'); 
        
        if($horarioMultiple == 'on'){
            $horarioMultiple = "SI";
        }else{
            $horarioMultiple = "NO";
        }

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($grupoTrabajo, 'required|trim|minlength[1]|maxlength[50]', 'Grupo de Trabajo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'GrupoTrabajo'      => $grupoTrabajo,
            'Observacion'       => $observacion,
            'JefeGrupoTrabajo'  => $jefeGrupoTrabajo,
            'IdSubarea'         => $subarea,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'multi_horario'     => $horarioMultiple
        );

        $lastId = $this->grupostrabajo->update([$idGrupoTrabajo], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $grupoTrabajo);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
	}
	
    public function modificarEstadoGrupoTrabajo()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idGrupoTrabajo = $this->request->getPost('idGrupoTrabajo');
        $estado = $this->request->getPost('estado');
        $motivo = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idGrupoTrabajo, 'required|trim|numeric', 'ID Grupo de Trabajo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        $lastId = $this->grupostrabajo->update([$idGrupoTrabajo], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idGrupoTrabajo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function listadoGruposTrabajo()
    {
        // $tipoRequerimiento = $this->request->getPost("tipoRequerimiento");
        
        // if($tipoRequerimiento != '' && $tipoRequerimiento != null && $tipoRequerimiento != "undefined")
        // {
        //     $listado = $this->requerimientos->where("Tipo", $tipoRequerimiento)->findAll();
        // }
        // else
        // {
        //     $listado = $this->requerimientos->findAll();
        // }
        
        $listado = $this->grupostrabajo->findAll();
        
        $elementos=array();

		if (!empty($listado)) {
            foreach ($listado as $items) {
                $elementos[] = array(
					'id' => (string) $items['IDGrupoTrabajo'],
                    'text' => (string) $items['GrupoTrabajo']
                );
            }

            $resultado = array(
				'listadoGruposTrabajo' => json_encode($elementos)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
    }
    
    public function listarUsuariosGrupoTrabajo($idGrupoTrabajo)
    {
        if(isset($this->items['id'])){
			/* BUSCAR ACCIONES */
			$whereUGT = array(
			    "idgrupotrabajo"    => $idGrupoTrabajo
			);
			$grupoTrabajo = $this->grupostrabajo->where("IDGrupoTrabajo", $idGrupoTrabajo)->first();
			$listaUsuarios = $this->usuarioGruposTrabajo->listarUsuariosGrupoTrabajo($whereUGT);
            
			$data = array (
				'session'           => 'on',
				'titulo'            => 'Usuarios - Grupo de Trabajo | Verisure',
				'breadcrumb'        => $this->items['modulo'],
				'breadcrumb_alias'  => 'Usuarios asociados - '.$grupoTrabajo['GrupoTrabajo'],
                'previo'            => 'listar-grupos-trabajo',
				'listaUsuarios'     => $listaUsuarios,
                'idGrupoTrabajo'    => $idGrupoTrabajo
			);
			$data = array_merge($data, $this->items);
			return view('configuracion/listar_usuarios_grupo_trabajo',$data);			
		} else {
			return view('errors/500');	
		}
    }
    
    public function asociarUsuarioGrupoTrabajo()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError       = TRUE;
        $idUsuario      = $this->request->getPost('idUsuario');
        $idGrupoTrabajo = $this->request->getPost('idGrupoTrabajo');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idUsuario, 'required|trim|number', 'ID Usuario');
        $error .= $this->complementos->validaCampo($idGrupoTrabajo, 'required|trim|number', 'ID Grupo de Trabajo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */
        
        $validacionPertenenciaUnicoGrupo = $this->usuarioGruposTrabajo->where('IdUsuario',$idUsuario)->findAll();                                                      
        
        $msgExistencia = '';
        
        $whereUGT = array(
            'IdUsuario'         => $idUsuario,
            'IDGrupoTrabajo'    => $idGrupoTrabajo
        );
        
		$combinacionExistente = $this->usuarioGruposTrabajo->where($whereUGT)->findAll();
		
		if(count($combinacionExistente)>0)
		{
            $msgExistencia .= "<li>El usuario ya fue agregado al grupo de trabajo. [CAMPO] <small>USUARIO</small></li>";
		}
		
		if(count($validacionPertenenciaUnicoGrupo)>0)
        {
            $msgExistencia .= "<li>El usuario Pertenece a un grupo de trabajo. [CAMPO] <small>USUARIO</small></li>";
        }
		
        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'IdUsuario'         => $idUsuario, 
            'IDGrupoTrabajo'    => $idGrupoTrabajo,
            'UsuarioRegistra'   => $this->items['id'],
            'FechaRegistra'     => $fechaActual
        );

        $lastId = $this->usuarioGruposTrabajo->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function eliminarUsuarioGrupoTrabajo()
    {
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $idUsuario      = $this->request->getPost('idUsuario');
        $idGrupoTrabajo = $this->request->getPost('idGrupoTrabajo');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idUsuario, 'required|trim|number', 'ID Usuario');
        $error .= $this->complementos->validaCampo($idGrupoTrabajo, 'required|trim|number', 'ID Grupo de Trabajo');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $whereDelete = array (
            'IdUsuario'         => $idUsuario, 
            'IDGrupoTrabajo'    => $idGrupoTrabajo
        );

        $lastId = $this->usuarioGruposTrabajo->where($whereDelete)->delete();

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg504, $idUsuario);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

    public function listarUsuariosGrupoTrabajoSelect()
    {
        $elemento = $this->request->getPost('term');
        $infoPeticion = $this->peticiones->where("IDPeticion", $elemento['peticion'])->first();
        $whereUGT = array(
		    "idgrupotrabajo"=> $infoPeticion['IDGrupoTrabajo'],
		    "like"          => $elemento['term']
		);
		
		$listado = $this->usuarioGruposTrabajo->listarUsuariosGrupoTrabajo($whereUGT);
        
        // $listado = $this->usuarioModelo->listadoUsuariosSelect($elemento['term'], '', 'Activo');
        
        $elementos=array();

        foreach ($listado as $items) {
            $elementos[] = array(
                'id' => (string) $items['IdUsuario'],
                'text' => (string) $items['Matricula']." | ".$items['Nombres']." ".$items['Apellidos']
            );
        }

        echo json_encode($elementos);
    }
    
    public function listadoHorariosAsociados()
    {
        $idGrupoTrabajo = $this->request->getPost('idGrupoTrabajo');
        
        $idUsuario = $this->items['id'];
        
        if (isset($this->items['id'])) {
            $HorariosGrupoTrabajo = $this->horarios->horariosGrupoTrabajoAsociado($idGrupoTrabajo, $idUsuario);
            
            if (!empty($HorariosGrupoTrabajo)) {
                $listadoHorarios = $this->horarios->findAll();
                // Hay horarios asociados
                $resultado = array(
                    'horariosGrupoTrabajo' => $HorariosGrupoTrabajo,
                    'listadoHorarios'      => $listadoHorarios
                );
            } else {
                // No hay horarios asociados, devolver la lista completa de horarios
                $listadoHorarios = $this->horarios->findAll();
                
                $resultado = array(
                    'horariosGrupoTrabajo' => [],
                    'listadoHorarios' => $listadoHorarios
                );
            }
    
            return $this->response->setJSON($resultado);  // Devolver como JSON
        } else {
            return view('errors/500');    
        }
    }

    public function guardarHorariosAsociados()
    {
        $fechaActual = date("Y-m-d H:i:s");
        $idUsuario = $this->items['id']; // Usuario actual
    
        // Obtener los datos enviados desde el frontend
        $idGrupoTrabajo = $this->request->getPost('idGrupoTrabajo');
        $horarios = $this->request->getPost('horarios'); // Array de horarios seleccionados
    
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        $error = '';
        $error .= $this->complementos->validaCampo($idGrupoTrabajo, 'required|trim|minlength[1]|maxlength[11]', 'ID Grupo de Trabajo');
        
        if (is_array($horarios) && count($horarios) > 0) {
            foreach ($horarios as $idHorario) {
                $error .= $this->complementos->validaCampo($idHorario, 'required|trim|minlength[1]|maxlength[11]', 'ID Horario');
            }
        } else {
            $error .= "<li>No se seleccionaron horarios.</li>";
        }
    
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
    
        /*
        * ----------------------------
        * ELIMINAR HORARIOS ASOCIADOS ANTERIORES Y INSERTAR NUEVOS
        * ----------------------------
        */
        // Obtener los horarios actualmente asociados a ese grupo de trabajo
        $horariosAsociados = $this->horarios->horariosGrupoTrabajoAsociado($idGrupoTrabajo, $idUsuario);
   
        try {
            // Si ya hay horarios asociados, eliminarlos antes de agregar los nuevos
            if (count($horariosAsociados) > 0) {
                foreach ($horariosAsociados as $data) {
                    $this->horarioGrupoTrabajo
                        ->where(['IDGrupoTrabajo' => $data['IDGrupoTrabajo'], 'id_horario' => $data['id_horario']])
                        ->delete();
                }
            }
    
            // Insertar los nuevos horarios seleccionados
            $lastId = [];
            foreach ($horarios as $idHorario) {
                $data = [
                    'id_horario'      => $idHorario,
                    'IDGrupoTrabajo'  => $idGrupoTrabajo,
                    'UsuarioRegistra' => $idUsuario,
                    'FechaRegistra'   => $fechaActual,
                ];
    
                // Intentar la inserción de cada registro en la tabla horario_grupotrabajo
                $insertId = $this->horarioGrupoTrabajo->insert($data);
    
                // Almacenar cada insertId para verificar si hay fallos
                $lastId[] = $insertId;
            }
    
            /*
            * ----------------------------
            * VALIDACIÓN FINAL Y MENSAJE DE ÉXITO
            * ----------------------------
            */
            if (!in_array(FALSE, $lastId, true)) { // Si no hay ningún `FALSE` en las inserciones
                $message = sprintf($this->mensajeError->msg502, 'Horarios guardados exitosamente para el grupo de trabajo.');
                echo $this->alertas->alertaExito($message);
                echo $this->alertas->refrescar(1);
            } else {
                // Si alguna inserción falló
                $message = sprintf($this->mensajeError->msg201, 'Error al guardar uno o más horarios.');
                echo $this->alertas->alertaError($message);
                EXIT;
            }
        } catch (Exception $e) {
            // Si ocurre una excepción, mostrar el error
            $message = sprintf($this->mensajeError->msg201, 'Error: ' . $e->getMessage());
            echo $this->alertas->alertaError($message);
            EXIT;
        }
    }

}