<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>

<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
		<!-- start page title -->
    		<div class="row">
    			<div class="col-12">
    				<div class="page-title-box d-sm-flex align-items-center justify-content-between">
    					<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
    
    					<div class="page-title-right">
    						<ol class="breadcrumb m-0">
    							<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
    							<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
    						</ol>
    					</div>
    
    				</div>
    			</div>
    		</div>
            <!-- end page title -->
            <div class="row justify-content-center">
                <div class="col-12 col-xxl-10">
                    <form id="formRegistrarOrdenCompra" class="formularioRegistrarOrdenCompra" autocomplete="off" action="<?= $baseUrl ?>/registrar-orden-compra" method="POST" accept-charset="utf-8">
                        <div id="smartwizard-noc" class="bg-white">
                            <ul class="nav contenedorTab">
                                <li class="nav-item">
                                    <a class="nav-link" href="#step-1" onclick="">
                                        <span class="num">
                                            <img src="<?= $baseUrl ?>/<?= $basePublic ?>/images/informacionGeneral2.png" width="36" height="32">
                                        </span>
                                        Información General
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="#step-2">
                                        <span class="num">
                                            <img src="<?= $baseUrl ?>/<?= $basePublic ?>/images/datosProvedor2.png" width="36" height="32">
                                        </span>
                                        Datos del Proveedor
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="#step-3">
                                        <span class="num">
                                            <img src="<?= $baseUrl ?>/<?= $basePublic ?>/images/verisureCompras2.png" width="36" height="32">
                                        </span>
                                        Items
                                    </a>
                                </li>
                                <li class="nav-item paso-4">
                                    <a class="nav-link " href="#step-4" onclick="return recargarPrevisualizacionNuevaOrdenCompra();">
                                        <span class="num">
                                            <img src="<?= $baseUrl ?>/<?= $basePublic ?>/images/ordenCompra2.png" width="36" height="32">
                                        </span>
                                        Requerimiento
                                    </a>
                                </li>
                            </ul>
                        
                            <div class="tab-content" id="ctnSmartWizard">
                                <div id="step-1" class="tab-pane" role="tabpanel" aria-labelledby="step-1">
                                    <div class="alert alert-danger bg-red-verisure color-white my-1">
                                        Requerimiento
                                    </div>
                                    <div class="row textoOscuroCorporativo m-0 p-0">
                                        <div class="row g-2 col-md-12 m-0 p-3">
                                        
                                            <div class="col-12 col-md-6">
                                                <div class="form-group">
                                                    <label for="solicitante">Solicitante</label>
                                                    <input type="text" class="form-control" id="solicitante" name="solicitante" value="<?= ucwords(mb_strtolower($nombres.' '.$apellidos)) ?>" placeholder="Solicitante" disabled>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-6">
                                                <div class="form-group">
                                                    <label for="matricula">Matricula</label>
                                                    <input type="text" class="form-control" id="matricula" name="matricula" value="<?= $matriculaLog ?>" placeholder="Matricula" disabled>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="conceptoOC">Concepto</label>
                                                    <input type="text" class="form-control " id="conceptoOC" name="conceptoOC" placeholder="Concepto">
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4">
                                                <div class="formgroup">
                                                    <label for="txtFechaPedidoOC">Fecha Pedido</label>
                                                    <div class="col-auto">
    
                                                        <div class="input-group mb-2">
                                                            <div class="input-group-prepend">
                                                                <div class="input-group-text contenedorCalendario"><span class="mdi mdi-calendar-month"></span> <!--<img src="<?= $baseUrl ?>/<?= $basePublic ?>/images/iconoCalendario2.png" width="17.5" height="20"> <i class="far fa-calendar-alt"></i> --> </div>
                                                            </div>
                                                            <input type="date" class="form-control pull-right " id="txtFechaPedidoOC" name="txtFechaPedidoOC" min="<?= date("Y-m-d") ?>" value="<?= date("Y-m-d") ?>">
                                                        </div>
                                                    </div>
                                                    <!-- <input type="text" class="form-control pull-right " id="fechapedido" name="fechapedido" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask><i class="far fa-calendar-alt"></i> -->
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="cboCompradorOC">Comprador</label>
                                                    <select class="form-select" id="cboCompradorOC" name="cboCompradorOC">
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="cboEnvioFacturaOC">Envío de Factura</label>
                                                    <select class="form-select" id="cboEnvioFacturaOC" name="cboEnvioFacturaOC">
                                                        <option value="" selected>Seleccione una opción</option>
                                                        <option value="SI">SI</option>
                                                        <option value="NO">NO</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="cboBudgetOC">Budget</label>
                                                    <select class="form-select" id="cboBudgetOC" name="cboBudgetOC">
                                                        <option value="" selected>Seleccione una opción</option>
                                                        <option value="SI">SI</option>
                                                        <option value="NO">NO</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="cboIGVOC">IGV</label>
                                                    <select class="form-select" name="cboIGVOC" id="cboIGVOC">
                                                        <option value="Afecta" selected>Afecta</option>
                                                        <option value="Afecta10">IGV 10%</option>
                                                        <option value="Noafecta">No afecta</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-6">
                                                <div class="form-group">
                                                    <label for="cboCategoriaOC">Categoria</label>
                                                    <select class="form-select" id="cboCategoriaOC" name="cboCategoriaOC">
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-6">
                                                <div class="form-group">
                                                    <label for="cboSubcategoriaOC">Subcategoria</label>
                                                    <select class="form-select" id="cboSubcategoriaOC" name="cboSubcategoriaOC">
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-6">
                                                <div class="form-group">
                                                    <label for="cboDelegacionOC">CC - LN (Delegación)</label>
                                                    <select class="form-select" id="cboDelegacionOC" name="cboDelegacionOC">
                                                    </select>
                                                    <input type="hidden" id="txtCCOC" name="txtCCOC">
                                                    <input type="hidden" id="txtLNOC" name="txtLNOC">
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-6">
                                                <div class="form-group ">
                                                    <label for="cboSubareaOC">Subárea - Área - Dirección</label>
                                                    <select class="form-select" id="cboSubareaOC" name="cboSubareaOC">
                                                    </select>
                                                </div>
                                            </div>
    
                                            <div class="col-12 col-md-12">
                                                <div class="form-group">
                                                    <label for="observaciones">Observaciones</label>
                                                    <textarea class="form-control" id="observaciones" name="observaciones" placeholder="Ingresar..." rows="4"></textarea>
                                                </div>
                                            </div>
                                            <hr class="m-0 p-0 my-3">
                                            <?php
                                            if(in_array($idPerfil, array(1, 2)))
                                            {
                                            ?>
                                            <h3 class="mb-3">Compras</h3>
                                            <!--<div class="row g-2 col-md-12 m-0 p-3">-->
                                            <!--<div class="col-xxl-4 col-md-4 col-12">-->
                                            <!--    <div class="form-group">-->
                                            <!--        <label for="cboDimensionesOC">Dimensiones</label>-->
                                            <!--        <select class="form-select" name="cboDimensionesOC" id="cboDimensionesOC">-->
                                            <!--        </select>-->
                                            <!--    </div>-->
                                            <!--</div>-->
                                            <!--</div>-->
                                            <div class="col-12 col-md-12 justify-content-end my-3">
            									<div class="col-xxl-4 col-md-4 col-12 border-sistema-2px p-2 d-flex justify-content-between align-items-center" style="border-radius: 15px;">
                        						    <h5 class="color-sistema m-0" for="chkCompraCentralizadaOC">¿Compra Centralizada?</h5>
                        						    <div class="form-check form-switch form-switch-lg d-flex justify-content-start align-items-center" for="chkCompraCentralizadaOC">
                        								<input class="form-check-input form-check-input-sistema" type="checkbox" role="switch" name="chkCompraCentralizadaOC" id="chkCompraCentralizadaOC">
                        								<label class="form-check-label m-0" for="chkCompraCentralizadaOC"></label>
                        							</div>
                        						</div>
                        					</div>
                        					<?php
                                            }
                                            ?>
                                            
                                        </div>
                                    </div>
                                </div>
                                <div id="step-2" class="tab-pane" role="tabpanel" aria-labelledby="step-2">
                                    <div class="alert alert-danger bg-red-verisure color-white my-1">
                                        Información General
                                    </div>
                                    <div class="row textoOscuroCorporativo m-0 p-0">
                                        <div class="row g-2 col-md-12 m-0 p-3">
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="cboProveedorOC">Proveedor</label>
                                                    <select class="form-select" id="cboProveedorOC" name="cboProveedorOC">
                                                    </select>
                                                    <input type="hidden" id="txtProveedorNombreOC">
                                                </div>
                                            </div>
                                            <!--<div class="col-12 col-md-4">-->
                                            <!--    <div class="form-group">-->
                                            <!--        <label for="proovedor">Nombre Proveedor</label>-->
                                            <!--        <input type="text" class="form-control " id="proovedor_valor" name="proovedor_valor" placeholder="Digite nombre o Ruc">-->
                                            <!--    </div>-->
                                            <!--</div>-->
                                            <div class="col-12 col-md-4 mb-2">
                                                <div class="form-group">
                                                    <label for="lblRUCOC">RUC</label>
                                                    <input type="text" class="form-control" id="lblRUCOC" name="lblRUCOC" placeholder="RUC" disabled>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4 mb-2">
                                                <div class="form-group">
                                                    <label for="lblContactoOC">Contacto</label>
                                                    <input type="text" class="form-control " id="lblContactoOC" name="lblContactoOC" placeholder="Contacto" disabled>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4 mb-2">
                                                <div class="form-group">
                                                    <label for="lblPaisOC">Pais</label>
                                                    <input type="text" class="form-control " id="lblPaisOC" name="lblPaisOC" placeholder="Pais" disabled>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4 mb-2">
                                                <div class="form-group">
                                                    <label for="lblDepartamento">Departamento</label>
                                                    <input type="text" class="form-control " id="lblDepartamento" name="lblDepartamento" placeholder="Departamento" disabled>
                                                    
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4 mb-2">
                                                <div class="form-group">
                                                    <label for="lblProvincia">Provincia</label>
                                                    <input type="text" class="form-control " id="lblProvincia" name="lblProvincia" placeholder="Provincia" disabled>
                                                    
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4 mb-2">
                                                <div class="form-group">
                                                    <label for="lblDistritoOC">Distrito</label>
                                                    <input type="text" class="form-control " id="lblDistritoOC" name="lblDistritoOC" placeholder="Distrito" disabled>
                                                    
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4 mb-2">
                                                <div class="form-group">
                                                    <label for="lblDireccionOC">Dirección</label>
                                                    <input type="text" class="form-control " id="lblDireccionOC" name="lblDireccionOC" placeholder="Dirección" disabled>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4 mb-2">
                                                <div class="form-group">
                                                    <label for="lblEmailOC">Email</label>
                                                    <input type="text" class="form-control " id="lblEmailOC" name="lblEmailOC" placeholder="Correo" disabled>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4 mb-2">
                                                <div class="form-group">
                                                    <label for="lblTelefono01OC">Telefono 01</label>
                                                    <input type="text" class="form-control " id="lblTelefono01OC" name="lblTelefono01OC" placeholder="Teléfono 01" disabled>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4 mb-2">
                                                <div class="form-group">
                                                    <label for="lblTelefono02OC">Telefono 02</label>
                                                    <input type="text" class="form-control " id="lblTelefono02OC" name="lblTelefono02OC" placeholder="Teléfono 02" disabled>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4 mb-2">
                                                <div class="form-group">
                                                    <label for="cboFormaPagoOC">Forma de Pago</label>
                                                    <select class="form-select" id="cboFormaPagoOC" name="cboFormaPagoOC">
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-12 mb-2">
                                                <div class="form-group tipologiaNuevaOc">
                                                    <label for="cboMultiTipologiaOC">Tipo</label>
                                                    <select class="form-select" id="cboMultiTipologiaOC" name="cboMultiTipologiaOC[]" multiple="multiple" disabled>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="alert alert-danger bg-red-verisure color-white my-1">
                                        Modalidad de Pago
                                    </div>
                                    <div class="row textoOscuroCorporativo m-0 p-0">
                                        <div class="row g-2 col-md-12 m-0 p-3">
                                            <div class="col-12 col-md-6 mb-2">
                                                <div class="form-group">
                                                    <label for="cboModalidadPagoOC">Modalidad de Pago</label>
                                                    <select class="form-select " name="cboModalidadPagoOC" id="cboModalidadPagoOC">
                                                        
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-6 mb-2">
                                                <div class="form-group">
                                                    <label for="cboBancoOC">Banco</label>
                                                    <select class="form-select" name="cboBancoOC" id="cboBancoOC">
                                                        
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4 mb-2">
                                                <div class="form-group">
                                                    <label for="cboMonedaOC">Moneda</label>
                                                    <select class="form-select moneda-Tipo" name="cboMonedaOC" id="cboMonedaOC">
                                                        
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4 mb-2">
                                                <div class="form-group">
                                                    <label for="txtCuentaOC">Número de Cuenta:</label>
                                                    <input type="text" class="form-control validanumericos" id="txtCuentaOC" placeholder="Número de Cuenta" name="txtCuentaOC">
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4 mb-2">
                                                <div class="form-group">
                                                    <label for="txtCCIOC">CCI:</label>
                                                    <input type="text" class="form-control validanumericos" id="txtCCIOC" placeholder="Número de Cuenta" name="txtCCIOC">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="alert alert-danger bg-red-verisure color-white my-1">
                                        Detracción
                                    </div>
                                    <div class="row textoOscuroCorporativo m-0 p-0">
                                        <div class="row g-2 col-md-12 m-0 p-3">
                                            <div class="col-12 col-md-6 mb-2">
                                                <div class="form-group">
                                                    <label for="txtCuentaDetraccionOC">Cuenta Detracción:</label>
                                                    <input type="text" class="form-control validanumericos" id="txtCuentaDetraccionOC" placeholder="Cuenta Detracción" name="txtCuentaDetraccionOC" disabled>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-6 mb-2">
                                                <div class="form-group">
                                                    <label for="cboCodigoDetraccionOC">Código Detracción</label>
                                                    <select class="form-select" name="cboCodigoDetraccionOC" id="cboCodigoDetraccionOC" disabled>
                                                        
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div id="step-3" class="tab-pane" role="tabpanel" aria-labelledby="step-3">
                                    <div class="alert alert-danger bg-red-verisure color-white my-1">
                                        Creación de Items
                                    </div>
                                    <div class="row textoOscuroCorporativo m-0 p-0">
                                        <div class="row g-2 col-md-12 m-0 p-3">
                                            <div class="col-12 m-0 p-0 my-2">
                                                <button type="button" id="nuevo-item-oc" class="btn btn-danger float-end" data-bs-toggle="modal" data-bs-target="#modal-nuevo-item">
                                                    <i class="fas fa-plus mr-2"></i>Nuevo Item
                                                </button>
                                            </div>
                                            <div class="col-12">
                                                <span class="respuesta"></span>
                                                <div class="table-responsive">
                                                    <!--<table id="example1_oc" class="table table-striped mb-4">-->
                                                    <!--    <thead>-->
                                                    <!--        <tr>-->
                                                    <!--            <th class="text-center align-middle" style="font-size: .8rem;">#</th>-->
                                                    <!--            <th class="text-center align-middle" style="font-size: .8rem;">Descripción</th>-->
                                                    <!--            <th class="text-center align-middle" style="font-size: .8rem;">Cantidad</th>-->
                                                    <!--            <th class="text-center align-middle" style="font-size: .8rem;">Precio Unitario</th>-->
                                                    <!--            <th class="text-center align-middle" style="font-size: .8rem;">Precio Total</th>-->
                                                    <!--            <th class="text-center align-middle" style="font-size: .8rem;">Acciones</th>-->
                                                    <!--        </tr>-->
                                                    <!--    </thead>-->
                                                    <!--    <tbody>-->
                                                    <!--    </tbody>-->
                                                    <!--</table>-->
                                                    <div class="row p-3 m-0 d-flex bg-sistema" style="border-radius: 10px;">
                                                        <div class="col-6 m-0 p-0">
                                                            <h5 class="m-0 color-white">Descripción</h5>
                                                        </div>
                                                        <div class="col-1 m-0 p-0">
                                                            <h5 class="m-0 color-white">Cantidad</h5>
                                                        </div>
                                                        <div class="col-2 m-0 p-0">
                                                            <h5 class="m-0 color-white">Precio Unitario</h5>
                                                        </div>
                                                        <div class="col-2 m-0 p-0">
                                                            <h5 class="m-0 color-white">Precio Total</h5>
                                                        </div>
                                                        <div class="col-1 m-0 p-0">
                                                            <h5 class="m-0 color-white">Acciones</h5>
                                                        </div>
                                                    </div>
                                                    <div class="row p-0 py-3 m-0 d-flex" id="ctnDetalleItemOC">
                                                        
                                                    </div>
                                                    <div class="row p-3 m-0 d-flex">
                                                        <div class="col-9 m-0 p-0 px-3 d-flex align-items-center justify-content-end">
                                                            <h5 class="m-0 color-sistema">Subtotal</h5>
                                                        </div>
                                                        <div class="col-3 m-0 p-0">
                                                            <div class="input-group">
                                                                <span class="input-group-text lblSimboloMoneda"></span>
                                                                <input type="text" class="form-control" id="subtotaldetalleoc" name="subtotaldetalleoc" readonly>
                                                            </div>
                                                        </div>
                                                        <div class="col-9 m-0 p-0 px-3 d-flex align-items-center justify-content-end">
                                                            <h5 class="m-0 color-sistema">IGV</h5>
                                                        </div>
                                                        <div class="col-3 m-0 p-0">
                                                            <div class="input-group">
                                                                <span class="input-group-text lblSimboloMoneda"></span>
                                                                <input type="text" class="form-control" id="igvdetalleoc" name="igvdetalleoc" readonly>
                                                            </div>
                                                        </div>
                                                        <div class="col-9 m-0 p-0 px-3 d-flex align-items-center justify-content-end">
                                                            <h5 class="m-0 color-sistema">Total</h5>
                                                        </div>
                                                        <div class="col-3 m-0 p-0">
                                                            <div class="input-group">
                                                                <span class="input-group-text lblSimboloMoneda"></span>
                                                                <input type="text" class="form-control" id="totaldetalleoc" name="totaldetalleoc" readonly>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div id="step-4" class="tab-pane" role="tabpanel" aria-labelledby="step-4">
                                    <div class="alert alert-danger bg-red-verisure color-white my-1">
                                        Información General
                                    </div>
                                    <div class="row textoOscuroCorporativo m-0 p-0">
                                        <div class="row g-2 col-md-12 m-0 p-3">
                                            <div class="col-12 col-md-6">
                                                <div class="form-group">
                                                    <label for="lblConceptoOrdenCompra">Concepto:</label>
                                                    <input type="text" class="form-control" id="lblConceptoOrdenCompra" placeholder="Concepto" disabled>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-6">
                                                <div class="form-group">
                                                    <!-- <label for="solicitante_4">Solicitante:</label>
                                                        <input type="text" class="form-control validanumericos" id="solicitante_4" placeholder="Solicitante" name="solicitante_4"> -->
                                                    <label for="lblSolicitanteOrdenCompra">Solicitante</label>
                                                    <input type="text" class="form-control" id="lblSolicitanteOrdenCompra" placeholder="Solicitante" disabled>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-6">
                                                <div class="form-group">
                                                    <label for="lblFechaPedidoOrdenCompra">Fecha Pedido:</label>
                                                    <input type="text" class="form-control" id="lblFechaPedidoOrdenCompra" placeholder="Fecha Pedido" disabled>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-6">
                                                <div class="form-group">
                                                    <label for="lblFormaPagoOrdenCompra">Forma de Pago:</label>
                                                    <input type="text" class="form-control" id="lblFormaPagoOrdenCompra" placeholder="Forma de Pago" disabled>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-6">
                                                <div class="form-group">
                                                    <label for="lblCentroCostoOrdenCompra">Centro de Costo</label>
                                                    <input type="text" class="form-control" id="lblCentroCostoOrdenCompra" placeholder="Centro de Costo" disabled>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-6">
                                                <div class="form-group">
                                                    <label for="lblSubareaOrdenCompra">Subárea - Área - Dirección</label>
                                                    <input type="text" class="form-control" id="lblSubareaOrdenCompra" placeholder="Subárea - Área - Dirección" disabled>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="alert alert-danger bg-red-verisure color-white my-1">
                                        Información del Proveedor
                                    </div>
                                    <div class="row textoOscuroCorporativo m-0 p-0">
                                        <div class="row g-2 col-md-12 m-0 p-3">
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="lblProveedorOrdenCompra">Nombre Proveedor</label>
                                                    <input type="text" class="form-control " id="lblProveedorOrdenCompra" placeholder="RUC" disabled>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="lblRUCOrdenCompra">RUC</label>
                                                    <input type="text" class="form-control " id="lblRUCOrdenCompra" placeholder="RUC" disabled>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="lblContactoOrdenCompra">Contacto</label>
                                                    <input type="text" class="form-control " id="lblContactoOrdenCompra" placeholder="Contacto" disabled>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="lblPaisOrdenCompra">Pais</label>
                                                    <input type="text" class="form-control " id="lblPaisOrdenCompra" placeholder="Pais" disabled>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="lblDepartamentoOrdenCompra">Departamento</label>
                                                    <input type="text" class="form-control " id="lblDepartamentoOrdenCompra" placeholder="Departamento" disabled>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="lblProvinciaOrdenCompra">Provincia</label>
                                                    <input type="text" class="form-control " id="lblProvinciaOrdenCompra" placeholder="Provincia" disabled>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="lblDistritoOrdenCompra">Distrito</label>
                                                    <input type="text" class="form-control " id="lblDistritoOrdenCompra" placeholder="Distrito" disabled>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="lblDireccionOrdenCompra">Dirección</label>
                                                    <input type="text" class="form-control " id="lblDireccionOrdenCompra" placeholder="Dirección" disabled>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="lblEmailOrdenCompra">Email</label>
                                                    <input type="text" class="form-control " id="lblEmailOrdenCompra" placeholder="Correo" disabled>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="lblTelefono01OrdenCompra">Telefono</label>
                                                    <input type="text" class="form-control " id="lblTelefono01OrdenCompra" placeholder="Telefono 01" disabled>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="lblTelefono02OrdenCompra">Telefono 2</label>
                                                    <input type="text" class="form-control " id="lblTelefono02OrdenCompra" placeholder="Telefono 02" disabled>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="alert alert-danger bg-red-verisure color-white my-1">
                                        Información de Pago
                                    </div>
                                    <div class="row textoOscuroCorporativo m-0 p-0">
                                        <div class="row g-2 col-md-12 m-0 p-3">
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="lblMedioPagoOrdenCompra">Medio de Pago:</label>
                                                    <input type="text" class="form-control " id="lblMedioPagoOrdenCompra" placeholder="Medio de Pago" disabled>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="lblBancoOrdenCompra">Banco:</label>
                                                    <input type="text" class="form-control " id="lblBancoOrdenCompra" placeholder="Banco" disabled>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="lblCuentaBancariaOrdenCompra">Cuenta Bancaria:</label>
                                                    <input type="text" class="form-control" id="lblCuentaBancariaOrdenCompra" placeholder="Cuenta Bancaria" disabled>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="lblCCIOrdenCompra">CCI:</label>
                                                    <input type="text" class="form-control" id="lblCCIOrdenCompra" placeholder="CCI" disabled>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="lblCuentaDetraccionOrdenCompra">Cuenta Detracción:</label>
                                                    <input type="text" class="form-control" id="lblCuentaDetraccionOrdenCompra" placeholder="Cuenta Detracción" disabled>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-4">
                                                <div class="form-group">
                                                    <label for="lblCodigoDetraccionOrdenCompra">Código Detracción:</label>
                                                    <input type="text" class="form-control" id="lblCodigoDetraccionOrdenCompra" placeholder="Código Detracción" disabled>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="alert alert-danger bg-red-verisure color-white my-1">
                                        Detalle de Compra
                                    </div>
                                    <div class="row textoOscuroCorporativo m-0 p-0">
                                        <div class="row g-2 col-md-12 m-0 p-3">
                                            <div class="col-12">
                                                <div class="table-responsive">
                                                    <table id="tblItemOrdenCompra" class="table table-striped">
                                                        <thead>
                                                            <tr>
                                                                <th class="text-center align-middle" style="font-size: .8rem;">#</th>
                                                                <th class="text-center align-middle" style="font-size: .8rem;">Descripción</th>
                                                                <th class="text-center align-middle" style="font-size: .8rem;">Cantidad</th>
                                                                <th class="text-center align-middle" style="font-size: .8rem;">Precio Unitario</th>
                                                                <th class="text-center align-middle" style="font-size: .8rem;">Precio Total</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        
                            <!-- Include optional progressbar HTML -->
                            <div class="progress">
                                <div class="progress-bar" role="progressbar" style="width: 0%" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                        </div>
                    </form>
                </div>
                <!-- /.col -->
            </div>
            <!-- end row-->
    
            <div class="row my-2">
                <div class="contenedor-imagen">
                    <img src="<?= $baseUrl ?>/<?= $basePublic ?>/images/img-footer4.png" width="100%">
                </div>
            </div>
            <!-- end row-->
    
        </div>
        <!-- container-fluid -->
    </div>
</div>
<?= $this->section('js'); ?>
<script>
    $(function () {
        $('#cboCompradorOC').select2({
            
        });
        $('#cboEnvioFacturaOC').select2({
            
        });
        $('#cboBudgetOC').select2({
            
        });
        $('#cboIGVOC').select2({
            
        });
        
        selectCategoriaCuentaContable("cboCategoriaOC", "TOTAL", "", "");
        selectDelegacionesEstructura("cboDelegacionOC", "TOTAL", "", "");
        selectCompradores("cboCompradorOC", "", "", "");
        selectDimensionesDelegacion("cboDimensionesOC", "", "");
        
        $("#cboProveedorOC").select2({
            minimumInputLength: 2,
            placeholder: 'Seleccione Proveedor',
            allowClear: true,
            language: {
                errorLoading: function() {
                    return "La carga falló";
                },
                noResults: function() {
                    return "No hay resultado";
                },
                searching: function() {
                    return "Buscando..";
                }
            },
            ajax: {
                url: baseUrl + '/listado-proveedores-autocompletado',
                dataType: 'json',
                type: "POST",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term
                    };
                },
                processResults: function (data) {
                    return {
                        results: data
                    };
                }
            }
        });
    
    });
</script>
<?php $this->endSection(); ?>
<!-- /.content -->

<!-- MODAL PARA EL REGISTRO DE ITEMS-->
<div class="modal fade zoomIn" id="modal-nuevo-item" data-bs-backdrop="static" aria-hidden="true" tabindex="-1" role="dialog" autocomplete="off">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content" style="border: none;">
            <div class="modal-header bg-sistema p-3">
                <h4 class="modal-title color-white">Añadir nuevo Item</h4>
                <button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close">
				</button>
            </div>
            <div class="modal-body row g-2">
                <div class="col-12">
                    <div class="form-group">
                        <label for="descripcionItem">Descripción</label>
                        <input type="text" class="form-control validanumericos" id="descripcionItem" name="descripcionItem" placeholder="Descripción">
                    </div>
                </div>
                <div class="col-6">
                    <div class="form-group">
                        <label for="cantidadItem">Cantidad</label>
                        <input type="text" class="form-control" id="cantidadItem" name="cantidadItem" placeholder="Cantidad" onkeypress="return validarNumerosEnteros(event, this);">
                    </div>
                </div>
                <div class="col-6">
                    <div class="form-group">
                        <label for="precioItem">Precio Unitario</label>
                        <input type="text" class="form-control" id="precioItem" name="precioItem" placeholder="Precio" onkeypress="return validarNumerosDecimales(event, this);">
                    </div>
                </div>
                <!--<div class="col-4">-->
                <!--    <div class="form-group">-->
                <!--        <label for="txtTotalItemOC">Total</label>-->
                <!--        <input type="text" class="form-control validanumericos" id="txtTotalItemOC" name="txtTotalItemOC" placeholder="Total" readonly>-->
                <!--    </div>-->
                <!--</div>-->
            </div>
            <div class="modal-footer justify-content-end">
                <button type="button" class="btn bg-danger d-flex justify-content-end align-items-center color-white" data-bs-dismiss="modal"><span class="mdi mdi-close-thick me-2" style="font-size: 15px;"></span>Cerrar</button>
                <button type="button" onclick="agregarItemOC();" class="btn bg-success d-flex justify-content-end align-items-center color-white guardar"><span class="mdi mdi-content-save me-2" style="font-size: 15px;"></span>Guardar</button>
            </div>
        </div>
    </div>
</div>
<?php $this->endSection(); ?>