<?php
namespace App\Models;
use CodeIgniter\Model;

class ModulosRutasModel extends Model
{
    protected $table      = 'modulos_rutas';
    protected $primaryKey = 'IDRuta';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDModulo', 'Ruta', 'TipoRuta', 'RaizModulo', 'Estado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function obtenerModulo($array)
    {
        $this->select('modulos_rutas.IDRuta,
            modulos_rutas.IDModulo,
            modulos_rutas.Ruta,
            modulos_rutas.Estado,
            modulos.Modulo');
        $this->join('modulos', 'modulos_rutas.IDModulo = modulos.IDModulo');
        
        if(isset($array['IDRuta']) && $array['IDRuta'] != '')
        {
            $this->where('modulos_rutas.IDRuta',$array['IDRuta']);
        }

        if(isset($array['ruta']) && $array['ruta'] != '')
        {
            $this->where('modulos_rutas.Ruta',$array['ruta']);
        }
        $datos = $this->first();
        return $datos;
    }

    public function listadoPermisosUsuarioRuta($idUsuario, $ruta)
    {
        $this->select('modulos_acciones.Codigo');
        $this->join('modulos_acciones', 'modulos_rutas.IDModulo = modulos_acciones.IDModulo', 'left');
        $this->join('usuario_permisos', 'modulos_acciones.IDAccionModulo = usuario_permisos.IDAccionModulo', 'left');
        $this->where('modulos_rutas.Ruta',$ruta);
        $this->where('usuario_permisos.IdUsuario',$idUsuario);
        
        $datos = $this->findAll();
        return $datos;
    }
}