<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;

class Proveedor extends BaseController
{
	public function __construct(){
 		$this->tipologia            = new \App\Models\TipologiaModel();
 		$this->banco                = new \App\Models\BancosModel();
 		$this->formasPago           = new \App\Models\FormaPagoModel();
 		$this->modalidadPago        = new \App\Models\ModalidadPagoModel();
 		$this->detraccionCodigo     = new \App\Models\DetraccionCodigoModel();
 		$this->cuentaContable       = new \App\Models\CuentaContableModel();
 		$this->cuentaContableCategorias = new \App\Models\CuentaContableCategoriaModel();
 		$this->cuentaContableSubcategorias = new \App\Models\CuentaContableSubcategoriaModel();
 		
 		$this->regionPais           = new \App\Models\RegionPaisModel();
        $this->regionDepartamento   = new \App\Models\RegionDepartamentoModel();
        $this->regionProvincia      = new \App\Models\RegionProvinciaModel();
        $this->regionDistrito       = new \App\Models\RegionDistritoModel();
        
 		$this->proveedor            = new \App\Models\ProveedorModel();
 		$this->proveedorTipologia   = new \App\Models\ProveedorTipologiaModel();
 		$this->proveedorPago        = new \App\Models\ProveedorPagoModel();
 		
 		$this->tiposDocumento = new \App\Models\TiposDocumentoModel();
 		
 		//Funciones de sistema externo proveedores
 		$this->proveedorExternos    = new \App\Models\ExternosProveedorModel();
 		
 		$this->externosAcceso       = new \App\Models\ExternosAccesoModel();
	}

    /************************** PROVEEDORES ***********************************/
    
	public function listarProveedores()
	{
    	if (isset($this->items['id'])) 
    	{
            $data = array (
				'session'               => 'on',
				'titulo'                => 'Proveedores | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Listado de Proveedores'
			);
			
            $data = array_merge($data, $this->items);

            return view('proveedor/listar_proveedores', $data);
        } else {
            return view('errors/500');
        }
	}
	
    // public function proveedoresServerside()
    // {
    //     $orderBy = " ORDER BY ";

    //     foreach ($this->request->getGet('order') as $order) {
    //         $orderBy .= $order['column'] + 1 . " {$order['dir']}, ";
    //     }

    //     $orderBy = substr($orderBy, 0, -2);
    //     $columns = $this->request->getGet('columns');
    //     $fields = ['proveedor.RUC','proveedor.Nombre','proveedor.Contacto','Departamento','Provincia','Distrito','proveedor.Telefono01', 'proveedor.Telefono02','proveedor.Email', 'proveedor.Estado','acciones_proveedor'];
    //     $where = '';

    //     foreach ($columns as $k => $column) {
    //         if ($this->request->getGet('search')['value']!="") {
    //             if($k == 10){}
    //             else
    //             {
    //                 $where .= $fields[$k]." LIKE '%".$this->request->getGet('search')['value']."%' OR ";
    //             }
                
    //         }
    //     }

    //     $where = substr($where, 0, -5);
    //     $length = $this->request->getGet('length');
    //     $start = $this->request->getGet('start'); 

    //     /* LISTAR ORDEN DE COMPRA */
    //     $listaProveedor = $this->proveedor->listaGeneralProveedor($orderBy,$where,$length,$start);
    //     echo json_encode($listaProveedor);
    // }
    
    public function proveedoresServerside()
    {
        $adicionales = array(
            "IDPerfil"  => $this->items['idPerfil'],
            "IDUsuario" => $this->items['id']
        );
        /* LISTAR PROVEEDOR */
        $dataServerside = $this->proveedor->listaGeneralProveedor($this->request->getGet(), $adicionales);
        $recordsTotal = !empty($dataServerside) ? count($dataServerside) : 0;
        $recordsFiltered = $this->proveedor->countAll();
        
        foreach($dataServerside as $key=>$value)
        {
            if(isset($value['IDDistrito']) && $value['IDDistrito'] != NULL && $value['IDDistrito'] != '')
            {
                $region = $this->regionDistrito->obtenerRegionxIDDistrito($value['IDDistrito']);
                $dataServerside[$key]['Departamento'] = $region['Departamento'];
                $dataServerside[$key]['Provincia'] = $region['Provincia'];
                $dataServerside[$key]['Distrito'] = $region['Distrito'];
            }
            else
            {
                $dataServerside[$key]['Departamento'] = "";
                $dataServerside[$key]['Provincia'] = "";
                $dataServerside[$key]['Distrito'] = "";
            }
            
            $acciones = "";
            $acciones .= "<div class='dropdown d-inline-block'>
    				<button class='btn btn-soft-secondary btn-sm dropdown' type='button' data-bs-toggle='dropdown' aria-expanded='false'>
    				<i class='ri-more-fill align-middle'></i>
    				</button>
    				<ul class='dropdown-menu dropdown-menu-end'>
    				    <li>
    						<a href='#!' class='dropdown-item d-flex justify-content-start align-items-center btnInformacionProveedor' data-bs-target='#editarProveedor' data-id='".$value['IDProveedor']."' data-accion='ver' id='ver-proveedor'>
    							<i class='ri-eye-fill align-bottom me-2 text-muted' style='font-size: 18px;'></i> Ver
    						</a>
    					</li>";
    					
    					if (in_array("UPDPRO", $this->items['permisos'])) 
    					{
        					$acciones .= "<li>
        						<a href='#!' class='dropdown-item edit-item-btn d-flex justify-content-start align-items-center btnInformacionProveedor' data-bs-target='#editarProveedor' data-id='".$value['IDProveedor']."' data-accion='editar' id='editar-proveedor'>
        							<i class='ri-pencil-fill align-bottom me-2 text-muted' style='font-size: 18px;'></i> Editar
        						</a>
        					</li>";
    					}
    					
    					if (in_array("UPPRMP", $this->items['permisos']))
    					{
        					$acciones .= "<li>
        						<a class='dropdown-item edit-item-btn d-flex justify-content-start align-items-center modalidadPagoProveedor' style='cursor: pointer;' data-bs-target='#editarModalidadPagoProveedor' data-id='".$value['IDProveedor']."'>
        							<i class='mdi mdi-cash-multiple align-bottom me-2 text-muted' style='font-size: 18px;'></i> Modalidades de Pago
        						</a>
        					</li>";
    					}
    					
    					if (in_array("UACPRO", $this->items['permisos']))
    					{
        					$acciones .= "<li>
        						<a href='".base_url()."/listar-accesos-proveedor/".$value['IDProveedor']."' class='dropdown-item d-flex justify-content-start align-items-center'>
        							<i class='mdi mdi-table-account align-bottom me-2 text-muted' style='font-size: 18px;'></i> Usuarios de Acceso
        						</a>
        					</li>";
    					}
    				// 	if (in_array("OCASPR", $this->items['permisos']))
    				// 	{
        // 					$acciones .= "<li>
        // 						<a href='".base_url()."/listar-ordenes-compra/".$value['IDProveedor']."' class='dropdown-item d-flex justify-content-start align-items-center'>
        // 							<i class='mdi mdi-file-table align-bottom me-2 text-muted' style='font-size: 18px;'></i> Órdenes de Compra
        // 						</a>
        // 					</li>";
    					
    				// 	}
    							
				$acciones .= "</ul>
			</div>";
            
            $dataServerside[$key]['acciones'] = $acciones;
        }
        
        $datos = [
                // 'draw' => $this->request->getGet('draw'),
            'data'              => $dataServerside,
            'recordsTotal'      => $recordsTotal,
            'recordsFiltered'   => (int) $recordsFiltered
        ];
        
        echo json_encode($datos, JSON_NUMERIC_CHECK);
    }

	public function registrarProveedor()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $ruc                = $this->request->getPost('ruc');
        $proveedor          = mb_strtoupper($this->request->getPost('proveedor'));
        $contacto           = mb_strtoupper($this->request->getPost('contacto'));
        $distrito           = $this->request->getPost('distrito');
        $direccion          = mb_strtoupper($this->request->getPost('direccion'));
        $correo             = $this->request->getPost('correo');
        $telefono01         = $this->request->getPost('telefono01');
        $telefono02         = $this->request->getPost('telefono02');
        $formapago          = $this->request->getPost('formapago');
        $cuentadetraccion   = $this->request->getPost('cuenta_detraccion');
        $codigodetraccion   = $this->request->getPost('codigo_detraccion');
        $gcn                = $this->request->getPost('cboGrupoContableNegocio');
        $griva              = $this->request->getPost('cboGrupoRegistroIVA');
        $gcp                = $this->request->getPost('cboGrupoContableProveedor');
        $observaciones      = $this->request->getPost('observaciones');
        
        $tipologia          = $this->request->getPost('tipologia');
        
        $modalidadpago      = $this->request->getPost('modalidadpago');
        $banco              = $this->request->getPost('banco');
        $cuentabancaria     = $this->request->getPost('cuenta');
        $cuentainterbancaria= $this->request->getPost('cci');
        $moneda             = $this->request->getPost('moneda');
        $prioridad          = $this->request->getPost('prioridad');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($ruc, 'required|trim|numeric|minlength[1]|maxlength[20]', 'RUC');
        $error .= $this->complementos->validaCampo($proveedor, 'required|trim|alphaspecial|minlength[1]|maxlength[150]', 'Proveedor');
        $error .= $this->complementos->validaCampo($contacto, 'required|trim|alphaspecial|minlength[1]|maxlength[150]', 'Contacto');
        $error .= $this->complementos->validaCampo($distrito, 'trim|numeric', 'ID Distrito');
        $error .= $this->complementos->validaCampo($direccion, 'trim|alphaspecial|minlength[1]|maxlength[200]', 'Dirección');
        $error .= $this->complementos->validaCampo($correo, 'trim|email|minlength[1]|maxlength[150]', 'Email');
        $error .= $this->complementos->validaCampo($telefono01, 'trim|numeric|minlength[7]|maxlength[9]', 'Telefono 01');
        $error .= $this->complementos->validaCampo($telefono02, 'trim|numeric|minlength[7]|maxlength[9]', 'Telefono 02');
        $error .= $this->complementos->validaCampo($formapago, 'required|trim|alphanumeric|minlength[1]|maxlength[70]', 'Forma Pago');
        $error .= $this->complementos->validaCampo($cuentadetraccion, 'trim|minlength[1]|maxlength[25]', 'Cuenta Detracción');
        $error .= $this->complementos->validaCampo($codigodetraccion, 'trim|minlength[1]|maxlength[3]', 'Código Detracción');
        $error .= $this->complementos->validaCampo($observaciones, 'trim', 'Observaciones');
        
        if(empty($tipologia))
        {
            $error .= "<li>Debe seleccionar una tipología como mínimo.</li>";
        }
        
        if(empty($modalidadpago))
        {
            $error .= "<li>Debe agregar una modalidad de pago como mínimo.</li>";
        }
        
        if(!empty($prioridad))
        {
            $cantidadPrioridad = array_count_values($prioridad);
            
            if($cantidadPrioridad[1] > 1)
            {
                $error .= "<li>Solo se debe agregar una modalidad de pago con prioridad 1.</li>";
            }
        }
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereExistencia = array(
            "RUC" => $ruc
        );
        
		$rucExistente = $this->proveedor->where($whereExistencia)->findAll();
        
        if(count($rucExistente)>0)
        {
            $msgExistencia .= "<li>El RUC ya fue registrado anteriormente. [CAMPO] <small>RUC</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS A PROVEEDOR
        * ----------------------------
        */

        $data = array (
            'Nombre'            => $proveedor,
            'RUC'               => $ruc,
            'Contacto'          => $contacto,
            'IDDistrito'        => $distrito,
            'Direccion'         => $direccion,
            'Telefono01'        => $telefono01,
            'Telefono02'        => $telefono02,
            'Email'             => $correo,
            'FormaPago'         => $formapago,
            'CuentaDetraccion'  => $cuentadetraccion,
            'CodigoDetraccion'  => $codigodetraccion,
            'GCN'               => $gcn,
            'GRIVA'             => $griva,
            'GCP'               => $gcp,
            'Observacion'       => $observaciones,
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,    
            'MotivoEstado'      => "Creación de proveedor.",    
            'Estado'            => 'A'
        );

        $lastIdProveedor = $this->proveedor->insert($data, TRUE);

        if($lastIdProveedor !== FALSE){
            $idProveedor = $lastIdProveedor;
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar el proveedor. Inténtelo luego.</li>[P]");
            echo $this->alertas->alertaError($message);
            EXIT;
        }
            
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS A PROVEEDOR-TIPOLOGÍA
        * ----------------------------
        */

        $dataTipologia = array();

        foreach($tipologia as $value)
        {
            $dataTipologia[] = array (
                'IDProveedor'       => $idProveedor, 
                'IDTipologia'       => $value, 
                'UsuarioRegistra'   => $this->items['id'],
                'FechaRegistra'     => $fechaActual,    
                'Localhost'         => $this->request->getIPAddress()
            );
        }
        $lastIdTipologia = $this->proveedorTipologia->insertBatch($dataTipologia);
        
        if($lastIdProveedor === FALSE)
        {
            $this->proveedor->delete(["IDProveedor", $idProveedor]);
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar el proveedor. Inténtelo luego.</li>[PT]");
            echo $this->alertas->alertaError($message);
            EXIT;
        }
            
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS A PROVEEDOR-PAGO
        * ----------------------------
        */

        $dataPago = array();

        foreach($modalidadpago as $key=>$detalle)
        {
            if($detalle != '')
            {
                $dataPago[] = array (
                    'IDProveedor'           => $idProveedor, 
                    'ModalidadPago'         => $detalle,  
                    'Banco'                 => $banco[$key], 
                    'CuentaBancaria'        => $cuentabancaria[$key], 
                    'CuentaInterbancaria'   => $cuentainterbancaria[$key], 
                    'Moneda'                => $moneda[$key],  
                    'Prioridad'             => $prioridad[$key],
                    'UsuarioCrea'           => $this->items['id'],
                    'FechaCrea'             => $fechaActual,    
                    'Localhost'             => $this->request->getIPAddress(),
                    'UsuarioEstado'         => $this->items['id'],
                    'FechaEstado'           => $fechaActual,    
                    'MotivoEstado'          => "Creación de modalidad de pago de proveedor.",    
                    'Estado'                => 'A'
                );
            }
        }
        $lastId = $this->proveedorPago->insertBatch($dataPago);
        
        if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $proveedor);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		} 
		else
		{
		    $this->proveedorTipologia->delete(["IDProveedor", $idProveedor]);
		    $this->proveedor->delete(["IDProveedor", $idProveedor]);
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar el proveedor. Inténtelo luego.</li>[PP]");
            echo $this->alertas->alertaError($message);
            EXIT;
		}
	}
	
	public function obtenerDatosProveedor()
	{
		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idProveedor = $this->request->getPost('idProveedor');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idProveedor, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosProveedor = $this->proveedor->obtenerProveedor($idProveedor);
		
		if(isset($datosProveedor['IDDistrito']) && $datosProveedor['IDDistrito'] != NULL && $datosProveedor['IDDistrito'] != '')
        {
            $region = $this->regionDistrito->obtenerRegionxIDDistrito($datosProveedor['IDDistrito']);
            $datosProveedor['IDDepartamento'] = $region['IDDepartamento'];
            $datosProveedor['Departamento']   = $region['Departamento'];
            $datosProveedor['IDProvincia']    = $region['IDProvincia'];
            $datosProveedor['Provincia']      = $region['Provincia'];
            $datosProveedor['Distrito']       = $region['Distrito'];
            $datosProveedor['IDPais']         = $region['IDPais'];
            $datosProveedor['Pais']           = $region['Pais'];
        }
        else
        {
            $datosProveedor['IDDepartamento'] = "";
            $datosProveedor['Departamento']   = "";
            $datosProveedor['IDProvincia']    = "";
            $datosProveedor['Provincia']      = "";
            $datosProveedor['Distrito']       = "";
            $datosProveedor['IDPais']         = "";
            $datosProveedor['Pais']           = "";
        }
        
		$simboloMoneda = $datosProveedor['Moneda'] != '' && $datosProveedor['Moneda'] != null ? $this->globales->monedas()[$datosProveedor['Moneda']]['SIMBOLO'] : "S/";
		
		if(!empty($datosProveedor)){
			$resultado = array(
				'idrequerimiento'   => (string) $idProveedor,
				'proveedor'         => (string) $datosProveedor['Nombre'],
				'ruc'               => (string) $datosProveedor['RUC'],
				'contacto'          => (string) $datosProveedor['Contacto'],
				'idtipodocumento'   => (string) $datosProveedor['IDTipoDocumento'],
				'idpais'            => (string) $datosProveedor['IDPais'],
				'iddepartamento'    => (string) $datosProveedor['IDDepartamento'],
				'idprovincia'       => (string) $datosProveedor['IDProvincia'],
				'iddistrito'        => (string) $datosProveedor['IDDistrito'],
				'pais'              => (string) $datosProveedor['Pais'],
				'departamento'      => (string) $datosProveedor['Departamento'],
				'provincia'         => (string) $datosProveedor['Provincia'],
				'distrito'          => (string) $datosProveedor['Distrito'],
				'direccion'         => (string) $datosProveedor['Direccion'],
				'correo'            => (string) $datosProveedor['Email'],
				'telefono01'        => (string) $datosProveedor['Telefono01'],
				'telefono02'        => (string) $datosProveedor['Telefono02'],
				'formapago'         => (string) $datosProveedor['FormaPago'],
				'tipologia'         => (string) $datosProveedor['TIPOLOGIAS'],
				'cuentadetraccion'  => (string) $datosProveedor['CuentaDetraccion'],
				'codigodetraccion'  => (string) $datosProveedor['CodigoDetraccion'],
				'gcn'               => (string) $datosProveedor['GCN'],
				'griva'             => (string) $datosProveedor['GRIVA'],
				'gcp'               => (string) $datosProveedor['GCP'],
				'modalidadpago'     => (string) $datosProveedor['ModalidadPago'],
				'banco'             => (string) $datosProveedor['Banco'],
				'cuentabancaria'    => (string) $datosProveedor['CuentaBancaria'],
				'cci'               => (string) $datosProveedor['CuentaInterbancaria'],
				'moneda'            => (string) $datosProveedor['Moneda'] != '' && $datosProveedor['Moneda'] != null ? $datosProveedor['Moneda'] : "PEN",
				'simbolomoneda'     => (string) $simboloMoneda
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}
	
	public function modificarProveedor($idProveedor)
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $ruc                = $this->request->getPost('ruc_e');
        $proveedor          = mb_strtoupper($this->request->getPost('proveedor_e'));
        $contacto           = mb_strtoupper($this->request->getPost('contacto_e'));
        $distrito           = $this->request->getPost('distrito_e');
        $direccion          = mb_strtoupper($this->request->getPost('direccion_e'));
        $correo             = $this->request->getPost('correo_e');
        $telefono01         = $this->request->getPost('telefono01_e');
        $telefono02         = $this->request->getPost('telefono02_e');
        $formapago          = $this->request->getPost('formapago_e');
        $cuentadetraccion   = $this->request->getPost('cuenta_detraccion_e');
        $codigodetraccion   = $this->request->getPost('codigo_detraccion_e');
        $gcn                = $this->request->getPost('cboGrupoContableNegocio_e');
        $griva              = $this->request->getPost('cboGrupoRegistroIVA_e');
        $gcp                = $this->request->getPost('cboGrupoContableProveedor_e');
        $observaciones      = $this->request->getPost('observaciones_e');
        
        $tipologia          = $this->request->getPost('tipologia_e');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($ruc, 'required|trim|numeric|minlength[1]|maxlength[20]', 'RUC');
        $error .= $this->complementos->validaCampo($proveedor, 'required|trim|alphaspecial|minlength[1]|maxlength[150]', 'Proveedor');
        $error .= $this->complementos->validaCampo($contacto, 'required|trim|alphaspecial|minlength[1]|maxlength[150]', 'Contacto');
        $error .= $this->complementos->validaCampo($distrito, 'trim|numeric', 'ID Distrito');
        $error .= $this->complementos->validaCampo($direccion, 'trim|alphaspecial|minlength[1]|maxlength[200]', 'Dirección');
        $error .= $this->complementos->validaCampo($correo, 'trim|email|minlength[1]|maxlength[150]', 'Email');
        $error .= $this->complementos->validaCampo($telefono01, 'trim|numeric|minlength[7]|maxlength[9]', 'Telefono 01');
        $error .= $this->complementos->validaCampo($telefono02, 'trim|numeric|minlength[7]|maxlength[9]', 'Telefono 02');
        $error .= $this->complementos->validaCampo($formapago, 'required|trim|alphanumeric|minlength[1]|maxlength[70]', 'Forma Pago');
        $error .= $this->complementos->validaCampo($cuentadetraccion, 'trim|minlength[1]|maxlength[25]', 'Cuenta Detracción');
        $error .= $this->complementos->validaCampo($codigodetraccion, 'trim|minlength[1]|maxlength[3]', 'Código Detracción');
        $error .= $this->complementos->validaCampo($observaciones, 'trim', 'Observaciones');
        
        if(empty($tipologia))
        {
            $error .= "<li>Debe seleccionar una tipología como mínimo.</li>";
        }
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'Nombre'            => $proveedor,
            'RUC'               => $ruc,
            'Contacto'          => $contacto,
            'IDDistrito'        => $distrito,
            'Direccion'         => $direccion,
            'Telefono01'        => $telefono01,
            'Telefono02'        => $telefono02,
            'Email'             => $correo,
            'FormaPago'         => $formapago,
            'CuentaDetraccion'  => $cuentadetraccion,
            'CodigoDetraccion'  => $codigodetraccion,
            'GCN'               => $gcn,
            'GRIVA'             => $griva,
            'GCP'               => $gcp,
            'Observacion'       => $observaciones,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->proveedor->update([$idProveedor], $data);

        if($lastId !== FALSE){
             
            /*
            * ----------------------------
            * INSERCIÓN DE DATOS A PROVEEDOR-TIPOLOGÍA
            * ----------------------------
            */
            
            $this->proveedorTipologia->where('IDProveedor', $idProveedor)->delete();
    
            $dataTipologia = array();
    
            foreach($tipologia as $value)
            {
                $dataTipologia[] = array (
                    'IDProveedor'       => $idProveedor, 
                    'IDTipologia'       => $value, 
                    'UsuarioRegistra'   => $this->items['id'],
                    'FechaRegistra'     => $fechaActual,    
                    'Localhost'         => $this->request->getIPAddress()
                );
            }
            $lastIdTipologia = $this->proveedorTipologia->insertBatch($dataTipologia);
            
            $message = sprintf($this->mensajeError->msg503, $proveedor);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
	}
	
    public function modificarEstadoProveedor()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idProveedor = $this->request->getPost('idProveedor');
        $estado = $this->request->getPost('estado');
        $motivo = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idProveedor, 'required|trim|numeric', 'ID Proveedor');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        $lastId = $this->proveedor->update([$idProveedor], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idProveedor);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
	public function listadoProveedores()
	{
    	/*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        
        $whereProveedor = array('Estado' => "A");
        $listadoProveedores = $this->proveedor->listadoProveedor($whereProveedor);
        
        $proveedores=array();

		if (!empty($listadoProveedores)) {
            foreach ($listadoProveedores as $items) {
                
                $proveedores[] = array(
					'id' => (string) $items['IDProveedor'],
         	        'text' => (string) $items['RUC'].' | '.$items['Nombre'],
                );
                    
            }

            $resultado = array(
				'listadoProveedores' => json_encode($proveedores)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado);		
	}
	
	public function listadoProveedoresAutocompletado()
	{
    	$elemento = $this->request->getPost('term');
    	
    	$array = array(
    	    "variable"  => $elemento['term'],
    	    "Estado"    => "A"
    	);
    	
        $listado = $this->proveedor->listadoProveedoresAutocompletado($array);
        
        $elementos=array();

        foreach ($listado as $items) {
            $elementos[] = array(
                'id' => (string) $items['IDProveedor'],
                'text' => (string) $items['RUC']." | ".$items['Nombre']
            );
        }

        echo json_encode($elementos);		
	}
	
	public function exportarProveedores()
	{
	    $whereProveedor = array('desde' => "2024-06-01");
        $listadoProveedores = $this->proveedor->listadoProveedor($whereProveedor);
        // var_dump($whereProveedor); exit;
        $filename = "Proveedores.csv";
        $writer = WriterEntityFactory::createCSVWriter();
        $writer->setFieldDelimiter(';');
        $writer->openToBrowser($filename);
        
        $cells = [
            WriterEntityFactory::createCell("Tipo de Documento"),
            WriterEntityFactory::createCell("RUC"),
            WriterEntityFactory::createCell("Nombre"),
            WriterEntityFactory::createCell("Dirección 01"),
            WriterEntityFactory::createCell("Dirección 02"),
            WriterEntityFactory::createCell("Cod. Postal"),
            WriterEntityFactory::createCell("Población"),
            WriterEntityFactory::createCell("Cod. País/Región"),
            WriterEntityFactory::createCell("Departamento"),
            WriterEntityFactory::createCell("Programa"),
            WriterEntityFactory::createCell("Grupo Contable Negocio"),
            WriterEntityFactory::createCell("Grupo Registro IVA neg"),
            WriterEntityFactory::createCell("Grupo Contable Proveedor"),
            WriterEntityFactory::createCell("Cod. Términos pago"),
            WriterEntityFactory::createCell("Cod. Forma Pago"),
            WriterEntityFactory::createCell("SUNAT Tabla 02"),
            WriterEntityFactory::createCell("Nro Cuenta")
        ];
        
        /** add a row at a time */
        $singleRow = WriterEntityFactory::createRow($cells);
        $writer->addRow($singleRow);
        
        foreach($listadoProveedores as $key=>$item)
        {
            if(isset($item['IDDistrito']) && $item['IDDistrito'] != NULL && $item['IDDistrito'] != '')
            {
                $region = $this->regionDistrito->obtenerRegionxIDDistrito($item['IDDistrito']);
                
                $departamento   = $region['Departamento'];
                $provincia      = $region['Provincia'];
                $distrito       = $region['Distrito'];
                $pais           = $region['Pais'];
            }
            else
            {
                $departamento = "";
                $provincia   = "";
                $distrito    = "";
                $pais      = "";
            }
            
            if(isset($item['IDTipoDocumento']) && $item['IDTipoDocumento'] != NULL && $item['IDTipoDocumento'] != '')
            {
                $tipodoc = $this->tiposDocumento->where("IDTipoDocumento", $item['IDTipoDocumento'])->first();
                
                $sunattabla02   = $tipodoc['CodigoSUNAT'];
            }
            else
            {
                $sunattabla02 = "";
            }
            // $fechaAsignacion = $item['Fecha de Asignación'] != '' && $item['Fecha de Asignación'] != null ? date("Y-m-d", strtotime($item['Fecha de Asignación'])) : "";
			$cells = [
                WriterEntityFactory::createCell("RUC"),
                WriterEntityFactory::createCell($item['RUC']),
                WriterEntityFactory::createCell($item['Nombre']),
                WriterEntityFactory::createCell($item['Direccion']),
                WriterEntityFactory::createCell(""),
                WriterEntityFactory::createCell($distrito),
                WriterEntityFactory::createCell($provincia),
                WriterEntityFactory::createCell($pais),
                WriterEntityFactory::createCell("910"),
                WriterEntityFactory::createCell("0"),
                WriterEntityFactory::createCell($item['GCN']),
                WriterEntityFactory::createCell($item['GRIVA']),
                WriterEntityFactory::createCell($item['GCP']),
                WriterEntityFactory::createCell($item['FormaPago']),
                WriterEntityFactory::createCell($item['ModalidadPago']),
                WriterEntityFactory::createCell($sunattabla02),
                WriterEntityFactory::createCell($item['CuentaBancaria']),
            ];
            
            /** add a row at a time */
            $singleRow = WriterEntityFactory::createRow($cells);
            $writer->addRow($singleRow);

        }
        
        $writer->close();
	}
	/**************************************************************************/
	
    /********************* MODALIDAD DE PAGO - PROVEEDOR **********************/
    
    public function recargarTablaModalidadPagoProveedor()
    {
        $resultado['data'] = array();
        
        $idProveedor = $this->request->getPost("idProveedor");
        $moneda = $this->globales->monedas();
            
        $listadoModalidadPago = $this->proveedorPago->listarModalidadPagoProveedor($idProveedor);
        
        foreach($listadoModalidadPago as $key=>$item)
        {
            $resultado['data'][$key] = array(
				'idproveedor'           => (string) $idProveedor,
				'idproveedorpago'       => (string) $item['IDProveedorPago'],
				'codigomodalidadpago'   => (string) $item['CodigoModalidadPago'],
				'modalidadpago'         => (string) $item['ModalidadPago'],
				'codigobanco'           => (string) $item['CodigoBanco'],
				'banco'                 => (string) $item['NombreBanco'],
				'cuentabancaria'        => (string) $item['CuentaBancaria'],
				'cuentainterbancaria'   => (string) $item['CuentaInterbancaria'],
                'moneda'                => (string) "(".$moneda[$item['Moneda']]['SIMBOLO'].") ".$moneda[$item['Moneda']]['NOMBRE'],
				'prioridad'             => (string) $item['Prioridad'],
				'estado'                => (string) $item['Estado'],
				'acciones'              => (string) ""
			);
        }
        
		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);
    }
    
	public function registrarModalidadPagoProveedor()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        $resultado = array(
			'insert'    => (string) false,
			'mensaje'   => (string) "Error"
		);

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $idProveedor          = $this->request->getPost('idproveedor_pp');
        
        $modalidadpago      = $this->request->getPost('modalidadPago_pp');
        $banco              = $this->request->getPost('banco_pp');
        $cuentabancaria     = $this->request->getPost('nrocuenta_pp');
        $cuentainterbancaria= $this->request->getPost('cci_pp');
        $moneda             = $this->request->getPost('moneda_pp');
        $prioridad          = $this->request->getPost('prioridad_pp');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idProveedor, 'required|trim|numeric', 'ID Proveedor');
        $error .= $this->complementos->validaCampo($modalidadpago, 'required|trim|alpha|minlength[1]|maxlength[50]', 'Modalidad de Pago');
        $error .= $this->complementos->validaCampo($banco, 'required|trim|alpha|minlength[1]|maxlength[50]', 'Banco');
        $error .= $this->complementos->validaCampo($cuentabancaria, 'required|trim|minlength[1]|maxlength[50]', 'Cuenta Bancaria');
        $error .= $this->complementos->validaCampo($cuentainterbancaria, 'required|trim|minlength[1]|maxlength[50]', 'Cuenta Interbancaria');
        $error .= $this->complementos->validaCampo($moneda, 'required|trim|alpha|minlength[1]|maxlength[5]', 'Moneda');
        $error .= $this->complementos->validaCampo($prioridad, 'required|trim|numeric', 'Prioridad');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaError($message)
			);
			echo json_encode($resultado);
			EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        if($prioridad == 1)
        {
            $wherePrioridad = array(
                "IDProveedor"   => $idProveedor,
                "Prioridad"     => "1"
            );
            
    		$prioridadExistente = $this->proveedorPago->where($wherePrioridad)->findAll();
            
            if(count($prioridadExistente)>0)
            {
                $msgExistencia .= "<li>La prioridad 1 ya fue registrada para el proveedor seleccionado. [CAMPO] <small>PRIORIDAD</small></li>";
            }
        }
        
        $whereModalidad = array(
            "IDProveedor"           => $idProveedor,
            "ModalidadPago"         => $modalidadpago,
            "Banco"                 => $banco,
            "CuentaBancaria"        => $cuentabancaria,
            "CuentaInterbancaria"   => $cuentainterbancaria,
            "Moneda"                => $moneda
        );
        
		$mppExistente = $this->proveedorPago->where($whereModalidad)->findAll();
        
        if(count($mppExistente)>0)
        {
            $msgExistencia .= "<li>La modalidad de pago ya fue registrado para el proveedor. [CAMPO] <small>MODALIDAD DE PAGO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaPeligro($message)
			);
			echo json_encode($resultado);
			EXIT;
        }
        
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS A PROVEEDOR
        * ----------------------------
        */

        $data = array (
            'IDProveedor'           => $idProveedor,
            'ModalidadPago'         => $modalidadpago,
            'Banco'                 => $banco,
            'CuentaBancaria'        => $cuentabancaria,
            'CuentaInterbancaria'   => $cuentainterbancaria,
            'Moneda'                => $moneda,
            'Prioridad'             => $prioridad,
            'UsuarioCrea'           => $this->items['id'],
            'FechaCrea'             => $fechaActual,    
            'Localhost'             => $this->request->getIPAddress(),
            'UsuarioEstado'         => $this->items['id'],
            'FechaEstado'           => $fechaActual,    
            'MotivoEstado'          => "Creación de modalidad de pago de proveedor.",    
            'Estado'                => 'A'
        );

        $lastIdProveedor = $this->proveedorPago->insert($data, TRUE);
        
        if($lastIdProveedor !== FALSE){
            $message = sprintf($this->mensajeError->msg201, "<li>La modalidad de pago fue registrada exitosamente.</li>");
            
            $resultado = array(
				'insert'    => (string) true,
				'mensaje'   => (string) $this->alertas->alertaExito($message)
			);
			
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar la modalidad de pago del proveedor. Inténtelo luego.</li>");
            
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaError($message)
			);
			
        }
        
        echo json_encode($resultado);
           
	}
	
	public function obtenerDatosModalidadPagoProveedor()
	{
		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idProveedorPago = $this->request->getPost('idProveedorPago');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idProveedorPago, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosProveedorPago = $this->proveedorPago->where("IDProveedorPago", $idProveedorPago)->first();

		if(!empty($datosProveedorPago)){
			$resultado = array(
				'idproveedorpago'   => (string) $idProveedorPago,
				'cuenta'            => (string) $datosProveedorPago['CuentaBancaria'],
				'cci'               => (string) $datosProveedorPago['CuentaInterbancaria'],
				'prioridad'         => (string) $datosProveedorPago['Prioridad'],
				'banco'             => (string) $datosProveedorPago['Banco'],
				'modalidadpago'     => (string) $datosProveedorPago['ModalidadPago'],
				'moneda'            => (string) $datosProveedorPago['Moneda']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}
	
	public function modificarModalidadPagoProveedor($idProveedorPago)
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $modalidadpago      = $this->request->getPost('modalidadPago_pp');
        $banco              = $this->request->getPost('banco_pp');
        $cuentabancaria     = $this->request->getPost('nrocuenta_pp');
        $cuentainterbancaria= $this->request->getPost('cci_pp');
        $moneda             = $this->request->getPost('moneda_pp');
        $prioridad          = $this->request->getPost('prioridad_pp');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($modalidadpago, 'required|trim|alpha|minlength[1]|maxlength[50]', 'Modalidad de Pago');
        $error .= $this->complementos->validaCampo($banco, 'required|trim|alpha|minlength[1]|maxlength[50]', 'Banco');
        $error .= $this->complementos->validaCampo($cuentabancaria, 'required|trim|minlength[1]|maxlength[50]', 'Cuenta Bancaria');
        $error .= $this->complementos->validaCampo($cuentainterbancaria, 'required|trim|minlength[1]|maxlength[50]', 'Cuenta Interbancaria');
        $error .= $this->complementos->validaCampo($moneda, 'required|trim|alpha|minlength[1]|maxlength[5]', 'Moneda');
        $error .= $this->complementos->validaCampo($prioridad, 'required|trim|numeric', 'Prioridad');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaError($message)
			);
			echo json_encode($resultado);
			EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'ModalidadPago'         => $modalidadpago,
            'Banco'                 => $banco,
            'CuentaBancaria'        => $cuentabancaria,
            'CuentaInterbancaria'   => $cuentainterbancaria,
            'Moneda'                => $moneda,
            'Prioridad'             => $prioridad,
            'UsuarioModifica'       => $this->items['id'],
            'FechaModifica'         => $fechaActual,    
            'Localhost'             => $this->request->getIPAddress()
        );

        $lastId = $this->proveedorPago->update([$idProveedorPago], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg201, "<li>La modalidad de pago fue actualizada exitosamente.</li>");
            
            $resultado = array(
				'insert'    => (string) true,
				'mensaje'   => (string) $this->alertas->alertaExito($message)
			);
			
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al actualizar la modalidad de pago del proveedor. Inténtelo luego.</li>");
            
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaError($message)
			);
			
        }
        
        echo json_encode($resultado);
           		
	}
	
    public function modificarEstadoModalidadPagoProveedor()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idProveedorPago    = $this->request->getPost('idProveedorPago');
        $estado             = $this->request->getPost('estado');
        $motivo             = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idProveedorPago, 'required|trim|numeric', 'ID Modalidad de Pago Proveedor');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaError($message)
			);
			echo json_encode($resultado);
			EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        $lastId = $this->proveedorPago->update([$idProveedorPago], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg201, "<li>Se cambió el estado de la modalidad de pago exitosamente.</li>");
            
            $resultado = array(
				'insert'    => (string) true,
				'mensaje'   => (string) $this->alertas->alertaExito($message)
			);
			
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al cambiar el estado de la modalidad de pago del proveedor. Inténtelo luego.</li>");
            
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaError($message)
			);
			
        }
        
        echo json_encode($resultado);
           		
    }
    
	/**************************************************************************/
	
    /********************* USUARIOS DE ACCESO - PROVEEDOR **********************/
    
	public function listadoUsuariosAccesoProveedor($idProveedor)
	{
	    if (isset($this->items['id'])) 
    	{
    	    $proveedor = $this->proveedor->where("IDProveedor", $idProveedor)->first();
    	    
    	    $usuarios = $this->proveedorExternos->listadoExternosProveedor($idProveedor);
    	    
            $data = array (
				'session'               => 'on',
				'titulo'                => 'Usuarios Asociados - Proveedor | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Listado de Usuarios de Acceso',
                'previo'                => 'listar-proveedores',
				'elementoSeleccionadoModulo'    => $proveedor['Nombre'],
				'subtitulo'             => 'Listado de Usuarios de Acceso',
				'proveedor'             => $proveedor,
				'listadoUsuarios'       => $usuarios
			);
			
            $data = array_merge($data, $this->items);

            return view('proveedor/listar_proveedor_accesos', $data);
        } else {
            return view('errors/500');
        }
	}
	
	public function registrarUsuarioExternoProveedor()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $idproveedor    = $this->request->getPost('txtIDProveedor');
        $nombres        = ucwords(mb_strtolower($this->request->getPost('txtNombresExterno')));
        $apellidos      = ucwords(mb_strtolower($this->request->getPost('txtApellidosExterno')));
        $nrodocumento   = $this->request->getPost('txtNroDocumentoExterno');
        $nrocontacto    = $this->request->getPost('txtNroContactoExterno');
        $correo         = $this->request->getPost('txtCorreoElectronicoExterno');
        $cargo          = ucwords(mb_strtolower($this->request->getPost('txtCargoExterno')));

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idproveedor, 'required|trim|numeric', 'ID Proveedor');
        $error .= $this->complementos->validaCampo($nombres, 'required|trim|alphaspecial|minlength[1]|maxlength[150]', 'Nombres');
        $error .= $this->complementos->validaCampo($apellidos, 'required|trim|alphaspecial|minlength[1]|maxlength[150]', 'Apellidos');
        $error .= $this->complementos->validaCampo($nrodocumento, 'required|trim|numeric|minlength[1]|maxlength[15]', 'Nro Documento');
        $error .= $this->complementos->validaCampo($nrocontacto, 'trim|numeric|minlength[7]|maxlength[10]', 'Nro Contacto');
        $error .= $this->complementos->validaCampo($correo, 'trim|email|minlength[1]|maxlength[200]', 'Correo Electrónico');
        $error .= $this->complementos->validaCampo($cargo, 'required|trim|alphaspecial|minlength[1]|maxlength[200]', 'Cargo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$emailExistente = $this->externosAcceso->where("CorreoElectronico",$correo)->findAll();
		$documentoExistente = $this->externosAcceso->where("NroDocumento",$nrodocumento)->findAll();
        
        if(count($emailExistente)>0)
        {
            $msgExistencia .= "<li>El Correo Electrónico ya fue registrado previamente. [CAMPO] <small>CORREO ELECTRÓNICO</small></li>";
        }

        if(count($documentoExistente)>0)
        {
            $msgExistencia .= "<li>El Nro de Documento ya fue registrada previamente. [CAMPO] <small>NRO DOCUMENTO</small></li>";
        }
        
        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'Nombres'           => $nombres,
            'Apellidos'         => $apellidos,
            'NroDocumento'      => $nrodocumento,
            'NroContacto'       => $nrocontacto,
            'CorreoElectronico' => $correo,
            'Cargo'             => $cargo,
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,    
            'MotivoEstado'      => "Creación de usuario externo.",    
            'Estado'            => 'A'
        );

        $lastId = $this->externosAcceso->insert($data, TRUE);

		if($lastId !== FALSE){
		    
		    //Si se inserta con éxito, se asocia al proveedor.
		    $externoProveedor = array (
                'IDExterno'         => $lastId,
                'IDProveedor'       => $idproveedor,
                'UsuarioRegistra'   => $this->items['id'],
                'FechaRegistra'     => $fechaActual
            );
		    
            $this->proveedorExternos->insert($externoProveedor, TRUE);

			$message = sprintf($this->mensajeError->msg502, $nombres.' '.$apellidos);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
	public function eliminarUsuarioExternoProveedor()
	{
	    /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $idExterno = $this->request->getPost('idExterno') ;
        $idProveedor = $this->request->getPost('idProveedor');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idExterno, 'required|trim|number', 'ID Usuario Externo');
        $error .= $this->complementos->validaCampo($idProveedor, 'required|trim|number', 'ID Proveedor');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $whereDelete = array (
            'IDExterno'     => $idExterno, 
            'IDProveedor'   => $idProveedor
        );

        $lastId = $this->proveedorExternos->where($whereDelete)->delete();

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg504, $idExterno);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
    public function busquedaUsuarioExterno()
    {
        $elemento = $this->request->getPost('term');
        
        $where = array(
            "like"      => true,
            "busqueda"  => $elemento['term']
        );
        
        $listado = $this->externosAcceso->listadoExternosAcceso($where);

        $elementos=array();

        foreach ($listado as $items) {
            $elementos[] = array(
                'id' => (string) $items['IDExterno'],
                'text' => (string) $items['Nombres'].' '.$items['Apellidos'].' | '.$items['CorreoElectronico']
            );
        }

        echo json_encode($elementos);
    }

    public function asociarUsuarioExternoProveedor()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $idExterno      = $this->request->getPost('idExterno');
        $idProveedor    = $this->request->getPost('idProveedor');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idExterno, 'required|trim|number', 'ID Usuario Externo');
        $error .= $this->complementos->validaCampo($idProveedor, 'required|trim|number', 'ID Proveedor');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $where = array(
            'IDExterno'     => $idExterno,
            'IDProveedor'   => $idProveedor
        );
        
		$combinacionExistente = $this->proveedorExternos->where($where)->findAll();
		
        if(count($combinacionExistente)>0)
        {
            $msgExistencia .= "<li>El usuario está asociado al proveedor. [CAMPO] <small>USUARIO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'IDExterno'         => $idExterno, 
            'IDProveedor'       => $idProveedor,
            'UsuarioRegistra'   => $this->items['id'],
            'FechaRegistra'     => $fechaActual
        );

        $lastId = $this->proveedorExternos->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idExterno);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function obtenerUsuarioExternoProveedor()
    {
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idUsuarioExterno = $this->request->getPost('idUsuarioExterno');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idUsuarioExterno, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosExternos = $this->externosAcceso->where("IDExterno", $idUsuarioExterno)->first();
		
		if(!empty($datosExternos)){
			$resultado = array(
				'idexternos'    => (string) $idUsuarioExterno,
				'nombre'        => (string) $datosExternos['Nombres'],
				'apellido'      => (string) $datosExternos['Apellidos'],
				'nrodocumento'  => (string) $datosExternos['NroDocumento'],
				'nrocontacto'   => (string) $datosExternos['NroContacto'],
				'correo'        => (string) $datosExternos['CorreoElectronico'],
				'cargo'         => (string) $datosExternos['Cargo']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);
    }
    
    public function modificarUsuarioExternoProveedor($idExterno)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $nombre         = ucwords(mb_strtolower($this->request->getPost('txtNombresExterno')));
        $apellido       = ucwords(mb_strtolower($this->request->getPost('txtApellidosExterno')));
        $nrodocumento   = $this->request->getPost('txtNroDocumentoExterno');
        $nrocontacto    = $this->request->getPost('txtNroContactoExterno');
        $email          = mb_strtolower($this->request->getPost('txtCorreoElectronicoExterno'));
        $cargo          = ucwords(mb_strtolower($this->request->getPost('txtCargoExterno')));
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($nombre, 'required|trim|alphaspecial|minlength[1]|maxlength[150]', 'Nombres');
        $error .= $this->complementos->validaCampo($apellido, 'required|trim|alphaspecial|minlength[1]|maxlength[150]', 'Apellidos');
        $error .= $this->complementos->validaCampo($nrodocumento, 'required|trim|numeric|minlength[1]|maxlength[15]', 'Nro Documento');
        $error .= $this->complementos->validaCampo($nrocontacto, 'required|trim|numeric|minlength[1]|maxlength[10]', 'Nro Contacto');
        $error .= $this->complementos->validaCampo($email, 'trim|email|minlength[1]|maxlength[200]', 'Correo Electrónico');
        $error .= $this->complementos->validaCampo($cargo, 'required|trim|alphaspecial|minlength[1]|maxlength[200]', 'Cargo');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'Nombres'           => $nombre,
            'Apellidos'         => $apellido,
            'NroDocumento'      => $nrodocumento,
            'NroContacto'       => $nrocontacto,
            'CorreoElectronico' => $email,
            'Cargo'             => $cargo,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->externosAcceso->update([$idExterno], $data);

        if($lastId !== FALSE){
             
            $message = sprintf($this->mensajeError->msg503, $idExterno);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }	
    }
    
    public function modificarPasswordExternoProveedor()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idExterno = $this->request->getPost('idExterno');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idExterno, 'required|trim|numeric', 'ID Usuario');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * -------------
        * GENERAR CONTRASEÑA
        * -------------
        */
        
		$aleatorio = $this->complementos->generar_string_aleatorio(5);
		$infoUsuario = $this->externosAcceso->where('IDExterno', $idExterno)->first();
    	
        $passwordaleatorio="Verisure".$aleatorio.date("Y")."*";
        // $passwordxdni="Verisure2024*";
        $user_password_hash=password_hash($passwordaleatorio,PASSWORD_DEFAULT);
        
        $data = array (
            'Password'          => $user_password_hash,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->externosAcceso->update([$idExterno], $data);

		if($lastId !== FALSE){
		    /*
            * ----------------------------
            * PREPARACIÓN DE CUERPO DE CORREO
            * ----------------------------
            */
            
            $arrayCuerpo = array(
                "TITULO"        => "CAMBIO DE CONTRASEÑA",
                "USUARIO"       => ucwords(mb_strtolower($infoUsuario['Nombres'].' '.$infoUsuario['Apellidos'])),
                "USER"          => $infoUsuario['CorreoElectronico'],
                "PASSWORD"      => $passwordaleatorio
            );
    
            $cuerpo = $this->plantillasCorreo->cuerpoCambioPasswordGenerado($arrayCuerpo);
            
            /*
            * ----------------------------
            * PREPARACIÓN DE PARAMETROS PARA EL CORREO
            * ----------------------------
            */
    
            $asunto='CAMBIO DE CONTRASEÑA - SISTEMA PROVEEDOR';
            //$correoDestino = array($asignado['Correo']);
            $configCorreo = array(
                "NOMBRE_ORIGEN" => "Verisure Perú",
                "CORREO_ORIGEN" => 'no-reply@verisure.pe',
                "CORREOS_DESTINOS" => array($infoUsuario['CorreoElectronico']),
                "CORREOS_COPIA" => array(),
                "CORREOS_OCULTO" => array('josejesus.cuadros@verisure.pe', 'joseenrique.nanquen@verisure.pe'),
                "ASUNTO" => $asunto,
                "MENSAJE" => $cuerpo
            );
    
            $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);
    
            // $dataCorreo = array(
            //     "IDUsuario"     => $idUsuario,
            //     "Asunto"        => $asunto,
            //     "Response"      => $estadoCorreo['RESPUESTA'],
            //     "Error"         => $estadoCorreo['ERROR'],
            //     'UsuarioCrea'   => $this->items['id'],
            //     'FechaCrea'     => $fechaActual,    
            //     'Localhost'     => $this->request->getIPAddress()
            // );
    
            // $this->correoStatusUsuario->insert($dataCorreo, TRUE);
            
			$message = sprintf($this->mensajeError->msg503, $idExterno);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function modificarEstadoExternoProveedor()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idExterno  = $this->request->getPost('idExterno');
        $estado     = $this->request->getPost('estado');
        $motivo     = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idExterno, 'required|trim|numeric', 'ID Usuario Externo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        $lastId = $this->externosAcceso->update([$idExterno], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $idExterno);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al cambiar el estado del usuario. Inténtelo luego.</li>");
            echo $this->alertas->alertaError($message);
        }
    }
    
	/**************************************************************************/
	
    /*************************** USUARIOS DE ACCESO ***************************/
    
	public function listadoAccesoExternos()
	{
	    if (isset($this->items['id'])) 
    	{
    	    $externos = $this->externosAcceso->findAll();
    	    
            $data = array (
				'session'               => 'on',
				'titulo'                => 'Accesos Externos | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Usuarios Externos',
				'elementoSeleccionadoModulo'    => "Usuarios Externos",
				'subtitulo'             => 'Listado de Usuarios Externos',
				'listadoUsuarios'       => $externos
			);
			
            $data = array_merge($data, $this->items);

            return view('proveedor/listar_acceso_externos', $data);
        } else {
            return view('errors/500');
        }
	}
	
	/**************************************************************************/
	
	
	
	
}