<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Globales;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

class Peticiones extends BaseController
{
	public function __construct(){
	    $this->peticiones = new \App\Models\PeticionesModel();
	    $this->peticionesAdjuntos = new \App\Models\PeticionesAdjuntosModel();
	    $this->peticionesComentarios = new \App\Models\PeticionesComentariosModel();
	    $this->peticionesComentariosAdjuntos = new \App\Models\PeticionesComentariosAdjuntosModel();
	    
        $this->usuarios = new \App\Models\UsuarioModel();
        $this->responsablesAprobacion   = new \App\Models\ResponsablesSubareaModel();
	    
        $this->estructuraDirecciones = new \App\Models\EstructuraDireccionModel();
        $this->estructuraAreas = new \App\Models\EstructuraAreaModel();
        $this->estructuraSubareas = new \App\Models\EstructuraSubareaModel();
        $this->estructuraSubareaDelegaciones= new \App\Models\EstructuraSubareaDelegacionesModel();
        $this->estructuraDelegaciones = new \App\Models\EstructuraDelegacionModel();
        $this->cargos = new \App\Models\CargosModel();
        
        $this->auditoria = new \App\Models\AuditoriaModel();
        $this->notificaciones = new \App\Models\NotificacionesModel();
        $this->notificacionesVistos = new \App\Models\NotificacionesVisualizadasModel();
//  		$this->requerimientos = new \App\Models\RequerimientosModel();
//  		$this->requerimientosPerfil = new \App\Models\RequerimientosPerfilModel();
// 		$this->requerimientosMotivo = new \App\Models\RequerimientosMotivoModel();
//         $this->usuarioPerfil = new \App\Models\UsuarioPerfilModel();
//         $this->usuarioPermisos = new \App\Models\UsuarioPermisosModel();
//         $this->usuarioRutas = new \App\Models\UsuarioRutasModel();

        $this->ordenCompra              = new \App\Models\OrdenCompraModel();
        $this->ordenCompraDetalle       = new \App\Models\OrdenCompraDetalleModel();
        $this->ordenCompraResponsable   = new \App\Models\OrdenCompraResponsablesModel();
        
        $this->correoStatusOrdenCompra  = new \App\Models\CorreoStatusOrdenCompraModel();
        $this->correoStatusPeticiones  = new \App\Models\CorreoStatusPeticionesModel();
	}
	
	public function insertarNotificacion($array)
	{
	    $tablaReferencia        = $array['tabla'];
        $idReferencia           = $array['idreferencia'];
        $mensaje                = $array['mensaje'];
        $url                    = $array['url'];
        $usuarioDestino         = $array['usuariodestino'];
        // $idGrupoTrabajoDestino  = $array['gtdestino'];
        $idPerfilDestino        = $array['perfildestino'];
        $usuarioRegistra        = $array['usuarioregistra'];
        $fechaRegistra          = $array['fecharegistra'];
        
        $dataNotificacion = array (
            'TablaReferencia'       => $tablaReferencia, 
            'IDReferencia'          => $idReferencia,
            'Mensaje'               => $mensaje, 
            'URL'                   => $url, 
            'IDUsuarioDestino'      => $usuarioDestino, 
            // 'IDGrupoTrabajoDestino' => $idGrupoTrabajoDestino, 
            'IDPerfilDestino'       => $idPerfilDestino,
            'UsuarioRegistra'       => $usuarioRegistra,
            'FechaRegistra'         => $fechaRegistra
        );
        
        $this->notificaciones->insert($dataNotificacion, TRUE);
	}
	
	public function marcarVisualizadoNotificacionMasivo($array)
	{
	    $fechaActual = date("Y-m-d H:i:s");

	    $notificaciones = $this->notificaciones->listarNotificaciones($array);
	    
	    if(!empty($notificaciones))
	    {
		    $dataNotifVistos = array();
		    
            foreach($notificaciones as $item)
            {
                $dataNotifVistos[] = array (
                    'IDNotificacion'    => $item['IDNotificacion'], 
                    'UsuarioVisualizado'=> $this->items['id'],  
                    'FechaVisualizado'  => $fechaActual
                );

            }
            
            $this->notificacionesVistos->insertBatch($dataNotifVistos);
	    }
	}

    public function listarPeticiones()
    {
		if(isset($this->items['id'])){

			/* ACCIONES */
			
			/* Listado de Peticiones */
			
            $where = array(
		        "IDUsuario"      => $this->items['id'],
		        "IDPerfil"      => $this->items['idPerfil'],
		        "IDArea"        => $this->items['idArea'],
		        "asignado"      => $this->items['id']
		    );
            
			$listadoPeticiones = $this->peticiones->listadoPeticiones($where);
			
			/* Cálculo de totales Dashboard */
			
			$whereTotal = array(
		        "idperfil"      => $this->items['idPerfil'],
		        "idusuario"     => $this->items['id']
		    );
            
            $whereMes = array(
		        "idperfil"      => $this->items['idPerfil'],
		        "idusuario"     => $this->items['id'],
		        "mes"           => date("m")
		    );
            
            $wherePendientes = array(
		        "idperfil"      => $this->items['idPerfil'],
		        "idusuario"     => $this->items['id'],
		        "estadosno"     => array("COMP", "APRO", "CANC", "AA")
		    );
            
            $whereSinIniciar = array(
		        "idperfil"      => $this->items['idPerfil'],
		        "idusuario"     => $this->items['id'],
		        "estado"        => "CREA"
		    );
		    
		    $totalTickets = count($this->peticiones->obtenerCantidadPeticiones($whereTotal));
			$totalMes = count($this->peticiones->obtenerCantidadPeticiones($whereMes));
			$pendientesGeneral = count($this->peticiones->obtenerCantidadPeticiones($wherePendientes));
			$noIniciados = count($this->peticiones->obtenerCantidadPeticiones($whereSinIniciar));
		    
			$cantidadesGenerales = array(
			    "Totales"       => $totalTickets,
			    "Mes"           => $totalMes,
			    "Pendientes"    => $pendientesGeneral,
			    "NoIniciados"   => $noIniciados
			);
			
            foreach($listadoPeticiones as $key=>$item)
            {
                $array = array(
                    "idusuario"         => $this->items['id'],
                    "idperfil"          => $this->items['idPerfil'],
                    "solonovisto"       => "Y",
                    "idreferencia"      => $item['IDPeticion'],
                    "tablareferencia"   => "peticiones"
                );
                
    		    $notificaciones = $this->notificaciones->listarNotificaciones($array);
    		    
                $listadoPeticiones[$key]['NotificacionesNoVistas'] = count($notificaciones);
    		    
                $solicitante = $this->usuarios->where("IdUsuario ", $item['UsuarioCrea'])->first();
                $listadoPeticiones[$key]['UsuarioSolicitante'] = $solicitante['Nombres'].' '.$solicitante['Apellidos'];
                $listadoPeticiones[$key]['MatriculaSolicitante'] = $solicitante['Matricula'];
                
                $direccionSolicitante = $this->estructuraDirecciones->where("IDDireccion", $item['IDDireccionCrea'])->first();
                $areaSolicitante = $this->estructuraAreas->where("IDArea", $item['IDAreaCrea'])->first();
                $subareaSolicitante = $this->estructuraSubareas->where("IDSubarea", $item['IDSubareaCrea'])->first();
                $delegacionSolicitante = $this->estructuraDelegaciones->where("IDDelegacion", $item['IDDelegacionCrea'])->first();
                
                $listadoPeticiones[$key]['DireccionSolicitante'] = $direccionSolicitante['Direccion'];
                $listadoPeticiones[$key]['AreaSolicitante'] = $areaSolicitante['Area'];
                $listadoPeticiones[$key]['SubareaSolicitante'] = $subareaSolicitante['Subarea'];
                $listadoPeticiones[$key]['DelegacionSolicitante'] = $delegacionSolicitante['CC'].' - '.$delegacionSolicitante['LN'].' | '.$delegacionSolicitante['Delegacion'];
            
                $cambio = $this->usuarios->where("IdUsuario ", $item['UsuarioEstado'])->first();
                $listadoPeticiones[$key]['NombreUsuarioEstado'] = $cambio['Nombres'].' '.$cambio['Apellidos'];
                $listadoPeticiones[$key]['MatriculaUsuarioEstado'] = $cambio['Matricula'];
            }
            
            $estados = $this->globales->estadosPeticion();
    
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Peticiones | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Listado de Peticiones',
				'listadoPeticiones'     => $listadoPeticiones,
				'estadosPeticion'       => $estados,
				'cantidadesGenerales'   => $cantidadesGenerales
			);
			
			$data = array_merge($data, $this->items);
			return view('procesos/Peticiones/listar_peticiones',$data);			
		} else {
			return view('errors/500');
		}
	}
	
	public function peticionesServersideHistorico()
	{
	    $estadosPeticion = $this->globales->estadosPeticion();
    
	    $adicionales = array(
            "IDPerfil"  => $this->items['idPerfil'],
            "IDUsuario" => $this->items['id']
        );
        
        /* LISTAR ORDEN DE COMPRA */
        $dataServerside = $this->peticiones->listaGeneralPeticiones($this->request->getGet(), $adicionales);
        $recordsTotal = !empty($dataServerside) ? count($dataServerside) : 0;
        $recordsFiltered = $this->peticiones->countAll();
        
        foreach($dataServerside as $key=>$value)
        {
            if($value['IDDelegacionCrea'] != '' && $value['IDDelegacionCrea'] != null)
            {
                $delegacion = $this->estructuraDelegaciones->where("IDDelegacion", $value['IDDelegacionCrea'])->first();
                $dataServerside[$key]['DelegacionSolicitante'] = $delegacion['CC'].' - '.$delegacion['LN'].' | '.$delegacion['Delegacion'];
            }
            else
            {
                $dataServerside[$key]['DelegacionSolicitante'] = "Sin información";
            }
            
            if($value['UsuarioEstado'] != '' && $value['UsuarioEstado'] != null)
            {
                $ultimo = $this->usuarios->where("IdUsuario", $value['UsuarioEstado'])->first();
                $dataServerside[$key]['UsuarioUltimoCambio'] = ucwords(mb_strtolower($ultimo['Nombres'].' '.$ultimo['Apellidos']));
            }
            else
            {
                $dataServerside[$key]['UsuarioUltimoCambio'] = "Sin información";
            }
            
            if($value['UsuarioAsignado'] != '' && $value['UsuarioAsignado'] != null)
            {
                $asignado = $this->usuarios->where("IdUsuario", $value['UsuarioAsignado'])->first();
                $dataServerside[$key]['UsuarioAsignado'] = ucwords(mb_strtolower($asignado['Nombres'].' '.$asignado['Apellidos']));
            }
            else
            {
                $dataServerside[$key]['UsuarioAsignado'] = "";
            }
            
            $btnEstado = "";
            $btnEstado .= '<span class="badge '.$estadosPeticion[$value['Estado']]['FONDO'].' border-0">
				'.$estadosPeticion[$value['Estado']]['PASADO'].'
			</span>';
            
            $acciones = "";
            $acciones .= '<span class="badge bg-sistema border-0 p-2">
                <a href="'.$this->items['baseUrl'].'/detalle-peticion/'.$value['NroPeticion'].'" class="color-white">
					<i class="ri-eye-fill align-bottom" style="font-size: 18px;"></i>
				</a>
			</span>';
			
			$fechaCreacion = '<span class="d-none">'.date("YmdHis", strtotime($value['FechaCrea'])).'</span>'.date("Y-m-d", strtotime($value['FechaCrea'])).'<br>'.date("H:i:s", strtotime($value['FechaCrea']));
			$fechaUltimo = '<span class="d-none">'.date("YmdHis", strtotime($value['FechaEstado'])).'</span>'.date("Y-m-d", strtotime($value['FechaEstado'])).'<br>'.date("H:i:s", strtotime($value['FechaEstado']));
			
            $dataServerside[$key]['acciones'] = $acciones;
            $dataServerside[$key]['BtnEstado'] = $btnEstado;
            $dataServerside[$key]['FechaCreacion'] = $fechaCreacion;
            $dataServerside[$key]['FechaUltimoCambio'] = $fechaUltimo;
        }
        
        $datos = [
                // 'draw' => $this->request->getGet('draw'),
            'data'              => $dataServerside,
            'recordsTotal'      => $recordsTotal,
            'recordsFiltered'   => (int) $recordsFiltered
        ];
        
        echo json_encode($datos, JSON_NUMERIC_CHECK);
	    
	    
	    
// 	    $busqueda = false;
// 	    $orderBy = " ORDER BY ";
	    
//         foreach ($this->request->getGet('order') as $order) {
//             $orderBy .= $order['column'] + 1 . " {$order['dir']}, ";
//         }

//         $orderBy = substr($orderBy, 0, -2);
//         $columns = $this->request->getGet('columns');
//         $fields = ['IDPeticion', 'FechaCrea', 'FechaEstado', 'DelegacionSolicitante', 'PerfilSolicitante', 'NroProspecto', 'Requerimiento', 'Motivo', 'NombreUsuarioEstado', 'GrupoTrabajo', 'Estado', 'acciones_usuario'];
//         $where = '';
//         // echo $this->items['idPerfil']; exit;
// 		if($this->items['idPerfil'] != 1)
// 		{
// 		    $where .= '(UsuarioCrea = "'.$this->items['id'].'") AND (';
// 		}
        
//         foreach ($columns as $k => $column) {
//             if ($this->request->getGet('search')['value']!="") {
//                 $busqueda = true;
//                 if($k == 11){}
//                 else
//                 {
//                     $where .= $fields[$k]." LIKE '%".$this->request->getGet('search')['value']."%' OR ";
//                 }
                
//             }
//         }
        
//         if($busqueda)
//         {
//             $where = substr($where, 0, -4);
            
//             if($this->items['idPerfil'] != 1)
// 		    {
//                 $where.=')';
// 		    }
//         }
//         else
//         {
//             $where = substr($where, 0, -6);
//         }

//         $length = $this->request->getGet('length');
//         $start = $this->request->getGet('start'); 

//         /* LISTAR ORDEN DE COMPRA */
//         $listaPeticiones = $this->peticiones->listaGeneralPeticiones($orderBy,$where,$length,$start);
//         // echo $listaPeticiones; exit;
//         echo json_encode($listaPeticiones, JSON_NUMERIC_CHECK);
	}
	
	public function registrarPeticion()
	{
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError       = TRUE;
        $peticion       = $this->request->getPost('txtPeticion_poc');
        $motivoReq      = $this->request->getPost('txtMotivoRequerimiento_poc');
        $req            = $this->request->getPost('txtRequerimiento_poc');
        $detalleReq     = $this->request->getPost('txtDetallePeticion_poc');
        $linkReq        = $this->request->getPost('txtLinkPeticion_poc');
        $formulario     = $this->request->getPost('txtFormularioRegistrarPeticion');
        
        $responsable    = $this->request->getPost('txtCompradorResponsable_poc');
        $marca          = $this->request->getPost('txtMarcaModelo_poc');
        $presupuesto    = $this->request->getPost('txtPresupuestoAsignado_poc');
        $moneda         = $this->request->getPost('cboMoneda_poc');
        $cantidad       = $this->request->getPost('txtCantidad_poc');

	    $adjuntos       = $this->request->getFiles("itemsFile"); 
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        $error = '';
        $error .= $this->complementos->validaCampo($peticion, 'required|trim|alphaspecial', 'Petición');
        $error .= $this->complementos->validaCampo($motivoReq, 'required|trim|numeric', 'Motivo del Requerimiento');
        $error .= $this->complementos->validaCampo($linkReq, 'trim|url', 'Link Asociado');
        
        $error .= $this->complementos->validaCampo($responsable, 'trim|numeric', 'Responsable');
        $error .= $this->complementos->validaCampo($presupuesto, 'required|trim|float', 'Presupuesto Asignado');
        $error .= $this->complementos->validaCampo($marca, 'required|trim|minlength[1]|maxlength[200]', 'Marca / Modelo');
        $error .= $this->complementos->validaCampo($cantidad, 'required|trim|numeric|minlength[1]', 'Cantidad');
        $error .= $this->complementos->validaCampo($moneda,  'required|trim|alpha|minlength[1]|maxlength[5]', 'Tipo Moneda');
        
        $error .= $this->complementos->validaCampo($detalleReq, 'required|trim', 'Detalle del requerimiento');
      
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */
        $message = '';
        
        $dataPeticion = array (
            'Peticion'              => $peticion,
            'IDMotivo'              => $motivoReq, 
            'Detalle'               => $detalleReq, 
            'LinkAsociado'          => $linkReq,
            'PresupuestoAsignado'   => $presupuesto == '' ? null : $presupuesto,
            'Producto'              => $marca == '' ? null : $marca,
            'Cantidad'              => $cantidad == '' ? null : $cantidad,
            'TipoMoneda'            => $moneda == '' ? null : $moneda,
            'UsuarioCrea'           => $this->items['id'],
            'FechaCrea'             => $fechaActual,
            'IDSubareaCrea'         => $this->items['idSubarea'], 
            'IDAreaCrea'            => $this->items['idArea'], 
            'IDDireccionCrea'       => $this->items['dpto'], 
            'IDPerfilCrea'          => $this->items['idPerfil'],
            'IDDelegacionCrea'      => $this->items['idDelegacionLog'],
            'IDCargoCrea'           => $this->items['idCargoLog'],
            'Estado'                => "CREA", 
            'UsuarioEstado'         => $this->items['id'],
            'IDDireccionEstado'     => $this->items['dpto'], 
            'IDAreaEstado'          => $this->items['idArea'], 
            'IDSubareaEstado'       => $this->items['idSubarea'], 
            'IDDelegacionEstado'    => $this->items['idDelegacionLog'],
            'IDPerfilEstado'        => $this->items['idPerfil'],
            'IDCargoEstado'         => $this->items['idCargoLog'],
            'FechaEstado'           => $fechaActual,
            'MotivoEstado'          => $peticion.': '.$detalleReq,
            'Localhost'             => $this->request->getIPAddress()
        );
        
        $lastId = $this->peticiones->insert($dataPeticion, TRUE);
        
		if($lastId !== FALSE)
		{
		    /*
            * ----------------------------
            * INSERCIÓN DE NOTIFICACIÓN
            * ----------------------------
            */
		    $nuevaNotificacion = array (
                'tabla'             => 'peticiones', 
                'idreferencia'      => $lastId,
                'mensaje'           => "Se ha <span class='color-crea'>CREADO</span> una nueva petición.", 
                'url'               => "detalle-peticion/".$lastId, 
                'usuariodestino'    => null, 
                'perfildestino'     => 2,
                'usuarioregistra'   => $this->items['id'],
                'fecharegistra'     => $fechaActual
            );
		    $this->insertarNotificacion($nuevaNotificacion);
		    
		    /*
            * ----------------------------
            * ASIGNAR USUARIO SI EXISTE RESPONSABLE
            * ----------------------------
            */
            
            if($responsable != '' && $responsable != null)
            {
                $compradorResponsable = $this->usuarios->where("IdUsuario ", $responsable)->first();
                
                $dataPeticionAsignacion = array (
                    'UsuarioAsignado'       => $responsable,
                    'UsuarioModifica'       => $this->items['id'],
                    'Estado'                => "ASIG", 
                    'UsuarioEstado'         => $this->items['id'],
                    'IDSubareaEstado'       => $this->items['idSubarea'], 
                    'IDAreaEstado'          => $this->items['idArea'], 
                    'IDDireccionEstado'     => $this->items['dpto'], 
                    'IDPerfilEstado'        => $this->items['idPerfil'],
                    'IDDelegacionEstado'    => $this->items['idDelegacionLog'],
                    'IDCargoEstado'         => $this->items['idCargoLog'],
                    'FechaModifica'         => date("Y-m-d H:i:s", strtotime($fechaActual) + 1),
                    'FechaEstado'           => date("Y-m-d H:i:s", strtotime($fechaActual) + 1),
                    'MotivoEstado'          => "El usuario ".$compradorResponsable['Nombres']." ".$compradorResponsable['Apellidos']." (".$compradorResponsable['Matricula'].") ha sido asignado a esta petición.",
                    'Localhost'             => $this->request->getIPAddress()
                );
                
                $this->peticiones->update([$lastId], $dataPeticionAsignacion);
            }
            
		    /*
            * ----------------------------
            * ENVIAR CORREO INFORMATIVO A RESPONSABLE O A DANIEL GHASSAN
            * ----------------------------
            */
            
            if($responsable != '' && $responsable != null)
            {
                $compradorResponsable = $this->usuarios->where("IdUsuario ", $responsable)->first();
                $nombreResponsable = ucwords(mb_strtolower($compradorResponsable['Nombres'].' '.$compradorResponsable['Apellidos']));
                $correoResponsable = $compradorResponsable['Correo'];
                
            }
            else
            {
                //id de Daniel Ghassan = 4578
                $compradorResponsable = $this->usuarios->where("IdUsuario ", "4578")->first();
                $nombreResponsable = ucwords(mb_strtolower($compradorResponsable['Nombres'].' '.$compradorResponsable['Apellidos']));
                $correoResponsable = $compradorResponsable['Correo'];
            }
            
            $datosPeticion = $this->peticiones->obtenerPeticion($lastId);
            
            if($datosPeticion['IDDelegacionCrea'] != '' && $datosPeticion['IDDelegacionCrea'] != null)
            {
                $delegacion = $this->estructuraDelegaciones->where("IDDelegacion", $datosPeticion['IDDelegacionCrea'])->first();
                $delegacionSolicitante = $delegacion['CC'].' - '.$delegacion['LN'].' | '.$delegacion['Delegacion'];
            }
            else
            {
                $delegacionSolicitante = "Sin información";
            }
            
            $arrayCuerpo = array(
                'IDPeticion'            => $lastId,
                'NombreComprador'       => $nombreResponsable,
                'Peticion'              => $datosPeticion['Peticion'],
                'NombreSolicitante'     => ucwords(mb_strtolower($this->items['nombres'].' '.$this->items['apellidos'])),
                'FechaCrea'             => date("Y-m-d", strtotime($datosPeticion['FechaCrea'])),
                'DelegacionSolicitante' => $delegacionSolicitante,
                'Categorizacion'        => $datosPeticion['Requerimiento'],
                'MotivoCategorizacion'  => $datosPeticion['Motivo'],
                'Observaciones'         => $datosPeticion['Detalle'],
                'basePublic'        => $this->items['basePublic'],
                'baseDinamic'       => $this->items['baseDinamic']
            );
    
            $cuerpo = $this->plantillasCorreo->informacionNuevaPeticionOrdenCompra($arrayCuerpo);
            
            $arrayCopia = "daniel.rojasandrade@verisure.pe" == $correoResponsable ? array() : array("daniel.rojasandrade@verisure.pe");
            
            $asunto='Petición N# '.$lastId;
            //$correoDestino = array($aprobador['Correo']);
            $configCorreo = array(
                "NOMBRE_ORIGEN" => "Sistema de Orden de Compra",
                "CORREO_ORIGEN" => 'compras@verisure.pe',
                "CORREOS_DESTINOS" => array($correoResponsable),
                "CORREOS_COPIA" => $arrayCopia,
                "CORREOS_OCULTO" => array('josejesus.cuadros@verisure.pe', 'joseenrique.nanquen@verisure.pe'),
                "ASUNTO" => $asunto,
                "MENSAJE" => $cuerpo
            );
    
            $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);
            
            $dataCorreo = array(
                "IDPeticion"    => $lastId,
                "Momento"       => "REGISTRO",
                "Response"      => $estadoCorreo['RESPUESTA'],
                "Error"         => $estadoCorreo['ERROR'],
                'UsuarioCrea'   => $this->items['id'],
                'FechaCrea'     => $fechaActual,    
                'Localhost'     => $this->request->getIPAddress()
            );

            $this->correoStatusPeticiones->insert($dataCorreo, TRUE);
            
		    /*
            * ----------------------------
            * INSERTAR ADJUNTOS SI ES QUE HAY
            * ----------------------------
            */
	        $adjuntosGuardados = 0;
	        $adjuntosNoGuardados = 0;
	        
		    if(!empty($adjuntos['itemsFile']))
    	    {
    	        foreach ($adjuntos['itemsFile'] as $key => $value) 
    	        {
    	           // echo $key."<br>";
                    if ($value->isValid() && ! $value->hasMoved()) 
                    {
                        if($value->getClientExtension() != null)
                        {
                            $extensionDoc = $value->getClientExtension();
                        }
                        else if($value->guessExtension() != null)
                        {
                            $extensionDoc = $value->guessExtension();
                        }
                        else
                        {
                            $extensionDoc = pathinfo($value->getClientName(), PATHINFO_EXTENSION);
                        }
            
                        $nombreArchivo = pathinfo($value->getClientName(), PATHINFO_FILENAME);
                        /*
                        * ----------------------------
                        * GUARDAR ARCHIVO ADJUNTO
                        * ----------------------------
                        */
                        $dataAdjunto = array (
                            'IDPeticion'            => $lastId, 
                            'Nombre'                => $nombreArchivo,
                            'Extension'             => $extensionDoc, 
                            'UsuarioCrea'           => $this->items['id'],
                            'FechaCrea'             => $fechaActual,
                            'Localhost'             => $this->request->getIPAddress()
                        );
                        
                        $lastIdAdjunto = $this->peticionesAdjuntos->insert($dataAdjunto, TRUE);
                        
                        if($lastIdAdjunto !== FALSE)
		                {
                            /*
                            * ----------------------------
                            * GUARDAR ARCHIVO ADJUNTO
                            * ----------------------------
                            */
                            $ruta = $this->items['baseDinamic']."/files/Peticiones/Asociados/".date("Y", strtotime($fechaActual))."/".date("m", strtotime($fechaActual))."/";
                            
                            if(!file_exists($ruta))
                            {
                                @mkdir($ruta, 0777, true);
                            }
                    
                    		# si exsite la carpeta o se ha creado
                    		if (file_exists($ruta) || @mkdir($ruta)) 
                            {
                                $nuevonombre = $lastIdAdjunto.'-'.$lastId.'.'.$extensionDoc;
                                
                                $estadoMove = $value->move($ruta, $nuevonombre);
                                
                                if (!$estadoMove) {
                                    $adjuntosNoGuardados++;
                                }
                                else
                                {
                                    $adjuntosGuardados++;
                                }
                            }
                            else
                            {
                                $adjuntosNoGuardados++;
                            }
		                }
                        else
                        {
                            $adjuntosNoGuardados++;
                        }
                    }
                    else
                    {
                        $adjuntosNoGuardados++;
                    }
                }
    	    }
    	    
            $message = sprintf($this->mensajeError->msg502, $peticion);
            
            if(!empty($adjuntos['itemsFile']) && $adjuntosNoGuardados > 0)
    	    {
    	        $message .= "<li>No se pudo guardar (".$adjuntosNoGuardados.") adjunto(s) solicitado(s). Inténtelo luego.</li>";
    	    }
    	    
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		} 
		else
		{
		    $message = sprintf($this->mensajeError->msg201, "<li>No se pudo registrar la petición. Inténtelo luego o póngase en contacto con Soporte IT.</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
		}
	}

    public function detallePeticion($idPeticion)
    {
        if(isset($this->items['id']))
        {
			// ACCIONES
            $peticion = $this->peticiones->obtenerPeticion($idPeticion);
            
            if(empty($peticion))
            {
                return view('errors/404');
            }
            else
            {
                $moneda = $this->globales->monedas();
                
                if(!empty($peticion['UsuarioAsignado']) && $peticion['UsuarioAsignado'] != '' && $peticion['UsuarioAsignado'] != null)
                {
                    $asignado = $this->usuarios->where("IdUsuario ", $peticion['UsuarioAsignado'])->first();
                    $peticion['UsuarioGestion'] = $asignado['Nombres'].' '.$asignado['Apellidos'];
                    $peticion['MatriculaGestion'] = $asignado['Matricula'];
                }
                else
                {
                    $peticion['UsuarioGestion'] = "Sin información";
                    $peticion['MatriculaGestion'] = "Sin información";
                }
                
                $direccion = $this->estructuraDirecciones->where("IDDireccion", $peticion['IDDireccionEstado'])->first();
                $area = $this->estructuraAreas->where("IDArea", $peticion['IDAreaEstado'])->first();
                $subarea = $this->estructuraSubareas->where("IDSubarea", $peticion['IDSubareaEstado'])->first();
                $delegacion = $this->estructuraDelegaciones->where("IDDelegacion", $peticion['IDDelegacionEstado'])->first();
                
                $peticion['DireccionGestion'] = $direccion['Direccion'];
                $peticion['AreaGestion'] = $area['Area'];
                $peticion['SubareaGestion'] = $subarea['Subarea'];
                $peticion['DelegacionGestion'] = $delegacion['Delegacion'];
            
                $solicitante = $this->usuarios->where("IdUsuario ", $peticion['UsuarioCrea'])->first();
                $peticion['UsuarioSolicitante'] = $solicitante['Nombres'].' '.$solicitante['Apellidos'];
                $peticion['MatriculaSolicitante'] = $solicitante['Matricula'];
                
                $direccionSolicitante = $this->estructuraDirecciones->where("IDDireccion", $peticion['IDDireccionCrea'])->first();
                $areaSolicitante = $this->estructuraAreas->where("IDArea", $peticion['IDAreaCrea'])->first();
                $subareaSolicitante = $this->estructuraSubareas->where("IDSubarea", $peticion['IDSubareaCrea'])->first();
                $delegacionSolicitante = $this->estructuraDelegaciones->where("IDDelegacion", $peticion['IDDelegacionCrea'])->first();
                
                $peticion['DireccionSolicitante'] = $direccionSolicitante['Direccion'];
                $peticion['AreaSolicitante'] = $areaSolicitante['Area'];
                $peticion['SubareaSolicitante'] = $subareaSolicitante['Subarea'];
                $peticion['DelegacionSolicitante'] = $delegacionSolicitante['CC'].' - '.$delegacionSolicitante['LN'].' | '.$delegacionSolicitante['Delegacion'];
                $peticion['CCSolicitante'] = $delegacionSolicitante['CC'];
                
                if($peticion['TipoMoneda'] != '' && $peticion['TipoMoneda'] != null)
                {
                    if (array_key_exists($peticion['TipoMoneda'], $moneda)) 
                    {
                        $items = $moneda[$peticion['TipoMoneda']];
                        $peticion['TipoMonedaText'] = "(".$items['SIMBOLO'].") ".$items['NOMBRE'];
                    } 
                    else 
                    {
                        $peticion['TipoMonedaText'] = '';
                    }
                }
                else
                {
                    $peticion['TipoMonedaText'] = '';
                }                

                $estados = $this->globales->estadosPeticion();
                $iconos = $this->globales->iconosExtension();
                
                $auditoriaPeticion = $this->auditoria->listarAuditoriaEstadosPeticion($idPeticion);
                
                $comentariosPeticion = $this->peticionesComentarios->listadoComentariosPeticion($idPeticion);
                $adjuntosPeticion = $this->peticionesAdjuntos->where("IDPeticion", $idPeticion)->findAll();
                
                $timelinePeticion = array_merge($comentariosPeticion, $auditoriaPeticion);
                
                $fechaAud = array_column($timelinePeticion, 'Fecha');
                array_multisort($fechaAud, SORT_DESC, $timelinePeticion);
                
                foreach($timelinePeticion as $key=>$value)
                {
                    $modifica = $this->usuarios->where("IdUsuario ", $value['IDUsuario'])->first();
                    $timelinePeticion[$key]['NombreUsuarioModifica'] = $modifica['Nombres'].' '.$modifica['Apellidos'];
                    $timelinePeticion[$key]['MatriculaUsuarioModifica'] = $modifica['Matricula'];
                    
                    $direccion = $this->estructuraDirecciones->where("IDDireccion", $value['IDDireccion'])->first();
                    $area = $this->estructuraAreas->where("IDArea", $value['IDArea'])->first();
                    $subarea = $this->estructuraSubareas->where("IDSubarea", $value['IDSubarea'])->first();
                    $delegacion = $this->estructuraDelegaciones->where("IDDelegacion", $value['IDDelegacion'])->first();
                    $cargo = $this->cargos->where("IDCargo", $value['IDCargo'])->first();
                    
                    $timelinePeticion[$key]['DireccionModifica'] = $direccion['Direccion'];
                    $timelinePeticion[$key]['AreaModifica'] = $area['Area'];
                    $timelinePeticion[$key]['SubareaModifica'] = $subarea['Subarea'];
                    $timelinePeticion[$key]['DelegacionModifica'] = $delegacion['CC'].' - '.$delegacion['LN'].' | '.$delegacion['Delegacion'];
                    $timelinePeticion[$key]['CargoModifica'] = $cargo['Cargo'];
                    
                    if($value['IDComentarioPeticion'] != '')
                    {
                        $timelinePeticion[$key]['AdjuntosComentario'] = $this->peticionesComentariosAdjuntos->where("IDComentarioPeticion", $value['IDComentarioPeticion'])->findAll();
                    }
                    else
                    {
                        $timelinePeticion[$key]['AdjuntosComentario'] = array();
                    }
                }
                
                // foreach($comentariosPeticion as $key=>$value)
                // {
                //     $modifica = $this->usuarios->where("IdUsuario ", $value['IDUsuario'])->first();
                //     $comentariosPeticion[$key]['NombreUsuario'] = $modifica['Nombres'].' '.$modifica['Apellidos'];
                //     $comentariosPeticion[$key]['MatriculaUsuario'] = $modifica['Matricula'];
                    
                //     $direccion = $this->estructuraDirecciones->where("IDDireccion", $value['IDDireccion'])->first();
                //     $area = $this->estructuraAreas->where("IDArea", $value['IDArea'])->first();
                //     $subarea = $this->estructuraSubareas->where("IDSubarea", $value['IDSubarea'])->first();
                //     $delegacion = $this->estructuraDelegaciones->where("IDDelegacion", $value['IDDelegacion'])->first();
                //     $cargo = $this->cargos->where("IDCargo", $value['IDCargo'])->first();
                    
                //     $comentariosPeticion[$key]['Direccion'] = $direccion['Direccion'];
                //     $comentariosPeticion[$key]['Area'] = $area['Area'];
                //     $comentariosPeticion[$key]['Subarea'] = $subarea['Subarea'];
                //     $comentariosPeticion[$key]['Delegacion'] = $delegacion['CC'].' - '.$delegacion['LN'].' | '.$delegacion['Delegacion'];
                //     $comentariosPeticion[$key]['Cargo'] = $cargo['Cargo'];
                    
                // }
                
                /*
                * ----------------------------
                * ACTUALIZAR VISUALIZACION NOTIFICACIONES
                * ----------------------------
                */
                $array = array(
                    "idusuario"         => $this->items['id'],
                    "idperfil"          => $this->items['idPerfil'],
                    "solonovisto"       => "Y",
                    "idreferencia"      => $idPeticion,
                    "tablareferencia"   => "peticiones"
                );
                
                $this->marcarVisualizadoNotificacionMasivo($array);
                
                /*
                * ----------------------------
                * ARMAR INFORMACIÓN A MOSTRAR
                * ----------------------------
                */
    			$data = array (
    				'session'                   => 'on',
    				'titulo'                    => 'Detalle de Petición | Verisure',
    				'breadcrumb'                => $this->items['modulo'],
    				'breadcrumb_alias'          => 'Detalle de Petición | '.$peticion['Peticion'],
                    'previo'                    => 'listar-peticiones',
    				'estadosPeticion'           => $estados,
                    'peticion'                  => $peticion,
                    'timelinePeticion'          => $timelinePeticion,
                    // 'comentariosPeticion'       => $comentariosPeticion,
                    'adjuntosPeticion'          => $adjuntosPeticion,
                    'iconosExtension'           => $iconos
    			);
                
    			$data = array_merge($data, $this->items);
    // 			var_dump($data); exit;
    			return view('procesos/Peticiones/ver_detalle_peticion',$data);	
            }
		} else {
			return view('errors/500');
		}
    }

	public function registrarComentarioPeticion()
	{
	    $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError       = TRUE;
        $idPeticion     = $this->request->getPost('txtNroPeticion_acp');
        $comentario     = $this->request->getPost('txtComentarioPeticion_acp');
        $linkComentario = $this->request->getPost('txtLinkComentarioPeticion_acp');
        
	    $adjuntos       = $this->request->getFiles("itemsFile"); 
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        $error = '';
        $error .= $this->complementos->validaCampo($idPeticion, 'required|trim|numeric', 'ID Petición');
        $error .= $this->complementos->validaCampo($comentario, 'required|trim', 'Comentario');
        $error .= $this->complementos->validaCampo($linkComentario, 'trim|url', 'Link asociado');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */
        $message = '';
        
        $dataComentario = array (
            'IDPeticion'            => $idPeticion, 
            'Comentario'            => $comentario,
            'Link'                  => $linkComentario, 
            'UsuarioCrea'           => $this->items['id'],
            'FechaCrea'             => $fechaActual,
            'IDSubareaCrea'         => $this->items['idSubarea'], 
            'IDAreaCrea'            => $this->items['idArea'], 
            'IDDireccionCrea'       => $this->items['dpto'], 
            'IDPerfilCrea'          => $this->items['idPerfil'],
            'IDDelegacionCrea'      => $this->items['idDelegacionLog'],
            'IDCargoCrea'           => $this->items['idCargoLog'],
            'Estado'                => "A", 
            'UsuarioEstado'         => $this->items['id'],
            'FechaEstado'           => $fechaActual,
            'MotivoEstado'          => $comentario,
            'Localhost'             => $this->request->getIPAddress()
        );
        $lastId = $this->peticionesComentarios->insert($dataComentario, TRUE);
        
		if($lastId !== FALSE)
		{
		    /*
            * ----------------------------
            * INSERCIÓN DE NOTIFICACIÓN
            * ----------------------------
            */
            // $gruposTrabajoHabilitados = $this->gruposTrabajoUsuario->where("IdUsuario", $this->items['id'])->findAll();
            $infPeticion = $this->peticiones->where("IDPeticion", $idPeticion)->first();
            
		    $nuevaNotificacion = array (
                'tabla'             => 'peticiones', 
                'idreferencia'      => $idPeticion,
                'mensaje'           => "Se ha <span class='color-come'>COMENTADO</span> la petición #".$idPeticion.".", 
                'url'               => "detalle-peticion/".$idPeticion, 
                'usuarioregistra'   => $this->items['id'],
                'fecharegistra'     => $fechaActual
            );
            
            if($this->items['id'] == $infPeticion['UsuarioCrea'])
            {
                $asignado = $infPeticion['UsuarioAsignado'] != '' && $infPeticion['UsuarioAsignado'] != null ? $infPeticion['UsuarioAsignado'] : null;
                $nuevaNotificacion['usuariodestino'] = $asignado;
                $nuevaNotificacion['perfildestino'] = 2;
            }
            else if($this->items['id'] == $infPeticion['UsuarioAsignado'])
            {
                $nuevaNotificacion['usuariodestino'] = $infPeticion['UsuarioCrea'];
                $nuevaNotificacion['perfildestino'] = null;
            }
            else
            {
                $nuevaNotificacion['usuariodestino'] = $infPeticion['UsuarioCrea'];
                $nuevaNotificacion['perfildestino'] = 2;
            }
            
		    $this->insertarNotificacion($nuevaNotificacion);
		    
		    /*
            * ----------------------------
            * INSERTAR ADJUNTOS SI ES QUE HAY
            * ----------------------------
            */
            
		    if(!empty($adjuntos['itemsFile']))
    	    {
    	        foreach ($adjuntos['itemsFile'] as $key => $value) 
    	        {
                    if ($value->isValid() && ! $value->hasMoved()) 
                    {
                        if($value->getClientExtension() != null)
                        {
                            $extensionDoc = $value->getClientExtension();
                        }
                        else if($value->guessExtension() != null)
                        {
                            $extensionDoc = $value->guessExtension();
                        }
                        else
                        {
                            $extensionDoc = pathinfo($value->getClientName(), PATHINFO_EXTENSION);
                        }
            
                        $nombreArchivo = pathinfo($value->getClientName(), PATHINFO_FILENAME);
                        /*
                        * ----------------------------
                        * GUARDAR ARCHIVO ADJUNTO
                        * ----------------------------
                        */
                        $dataAdjunto = array (
                            'IDComentarioPeticion'  => $lastId, 
                            'Nombre'                => $nombreArchivo,
                            'Extension'             => $extensionDoc, 
                            'UsuarioCrea'           => $this->items['id'],
                            'FechaCrea'             => $fechaActual,
                            'Localhost'             => $this->request->getIPAddress()
                        );
                        
                        $lastIdAdjunto = $this->peticionesComentariosAdjuntos->insert($dataAdjunto, TRUE);
                        
                        if($lastIdAdjunto !== FALSE)
		                {
                            /*
                            * ----------------------------
                            * GUARDAR ARCHIVO ADJUNTO
                            * ----------------------------
                            */
                            $ruta = $this->items['baseDinamic']."/files/Peticiones/Comentarios/".date("Y", strtotime($fechaActual))."/".date("m", strtotime($fechaActual))."/";
                            
                            if(!file_exists($ruta))
                            {
                                @mkdir($ruta, 0777, true);
                            }
                    
                    		# si exsite la carpeta o se ha creado
                    		if (file_exists($ruta) || @mkdir($ruta)) 
                            {
                                $nuevonombre = $lastIdAdjunto.'-'.$lastId.'.'.$extensionDoc;
                                
                                $estadoMove = $value->move($ruta, $nuevonombre);
                            }
		                }
                    }
                }
    	    }
    	    
		    
			$message .= sprintf($this->mensajeError->msg201, "El comentario fue agregado con éxito.");
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		} 
	}
	
    public function modificarEstadoPeticion($idPeticion)
    {
        $fechaActual = date("Y-m-d H:i:s");
        $fechaActualAdd = date("Y-m-d H:i:s", strtotime($fechaActual)+1);
        
        $infoPeticion = $this->peticiones->where("IDPeticion", $idPeticion)->first();
        
	    $nuevaNotificacion = array (
            'tabla'             => 'peticiones', 
            'idreferencia'      => $idPeticion,
            'url'               => "detalle-peticion/".$idPeticion, 
            'usuarioregistra'   => $this->items['id'],
            'fecharegistra'     => $fechaActual
        );
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError       = TRUE;
        $estado         = $this->request->getPost('txtEstadoPeticion_i');
        $motivo         = $this->request->getPost('txtMotivoCambioEstadoPeticion_i');
        $usuarioAsignado= $this->request->getPost('txtAsignarUsuarioPeticion_i');
        $categorizacion = $this->request->getPost('categorizacion');
        
        $linkValorizado = $this->request->getPost('txtLinkCompletarPeticion_acp');
        $adjuValorizado = $this->request->getFiles('valorizadoCompletado');
        
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idPeticion, 'required|trim|numeric', 'ID Petición');
        // $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[4]|maxlength[4]', 'Estado');

        if($estado == 'ASIG')
        {
            $error .= $this->complementos->validaCampo($usuarioAsignado, 'required|trim|numeric', 'Usuario Asignado');
        }
        
        if($estado == 'INIC')
        {
            if($infoPeticion['Categorizacion'] == '' || $infoPeticion['Categorizacion'] == null)
            {
                $error .= $this->complementos->validaCampo($categorizacion, 'required|trim|alpha|minlength[1]|maxlength[2]', 'Categorización');
            }
        }
        
        if($estado == 'COMP')
        {
            //AGREGAR VALIDACIÓN DE LINK Y ADJUNTO VALORIZADO
        }
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        $dataPeticion = array (
            'UsuarioModifica'       => $this->items['id'],
            'Estado'                => $estado, 
            'UsuarioEstado'         => $this->items['id'],
            'IDSubareaEstado'       => $this->items['idSubarea'], 
            'IDAreaEstado'          => $this->items['idArea'], 
            'IDDireccionEstado'     => $this->items['dpto'], 
            'IDPerfilEstado'        => $this->items['idPerfil'],
            'IDDelegacionEstado'    => $this->items['idDelegacionLog'],
            'IDCargoEstado'         => $this->items['idCargoLog'],
            'Localhost'             => $this->request->getIPAddress()
        );
        
        if($estado == 'ASIG')
        {
            if($infoPeticion['Estado'] != 'CREA' && $infoPeticion['Estado'] != 'COMP' && $infoPeticion['Estado'] != 'ESPE' && $infoPeticion['Estado'] != 'ASIG')
            {
                $message = sprintf($this->mensajeError->msg201, "No se puede gestionar el cambio de estado. Inténtelo luego.[".$estado."]");
                echo $this->alertas->alertaError($message);
    			exit;
            }
            else
            {
                $asignado = $this->usuarios->where("IdUsuario ", $usuarioAsignado)->first();
                $dataPeticion['FechaModifica']  = $fechaActual;
                $dataPeticion['FechaEstado']    = $fechaActual;
                $dataPeticion['MotivoEstado']   = $motivo != '' && $motivo != null ? $motivo."<br>Usuario asignado: ".$asignado['Nombres']." ".$asignado['Apellidos']." (".$asignado['Matricula'].")" : "El usuario ".$asignado['Nombres']." ".$asignado['Apellidos']." (".$asignado['Matricula'].") ha sido asignado a esta petición.";
                $dataPeticion['UsuarioAsignado']= $usuarioAsignado;
                
                $nuevaNotificacion['usuariodestino'] = $infoPeticion['UsuarioCrea'];
                $nuevaNotificacion['perfildestino'] = null;
                $nuevaNotificacion['mensaje'] = "Se ha <span class='color-asig'>ASIGNADO</span> la petición #".$idPeticion.".";
            }
        }
        else if($estado == 'INIC')
        {
            if(!(
                ($infoPeticion['Estado'] == 'CREA' || $infoPeticion['Estado'] == 'COMP' || $infoPeticion['Estado'] == 'ESPE') && 
                ($infoPeticion['UsuarioAsignado'] == '' || $infoPeticion['UsuarioAsignado'] == null)
                ) && 
                $infoPeticion['Estado'] != 'ASIG' && $infoPeticion['Estado'] != 'REEV')
            {
                $message = sprintf($this->mensajeError->msg201, "No se puede gestionar el cambio de estado. Inténtelo luego.[".$estado."]");
                echo $this->alertas->alertaError($message);
    			exit;
            }
            else
            {
                if($infoPeticion['UsuarioAsignado'] != '' && $infoPeticion['UsuarioAsignado'] != null)
                {
                    $dataPeticion['FechaModifica']  = $fechaActual;
                    $dataPeticion['FechaEstado']    = $fechaActual;
                    $dataPeticion['MotivoEstado']   = $motivo != '' && $motivo != null ? $motivo : "Gestión Iniciada.";
                    
                    if($infoPeticion['Categorizacion'] == '' || $infoPeticion['Categorizacion'] == null)
                    {
                        $dataPeticion['Categorizacion'] = $categorizacion;
                    }
                    
                    $nuevaNotificacion['usuariodestino'] = $infoPeticion['UsuarioCrea'];
                    $nuevaNotificacion['perfildestino'] = null;
                    $nuevaNotificacion['mensaje'] = "Se ha <span class='color-asig'>INICIADO LA GESTIÓN</span> de la petición #".$idPeticion.".";
                }
                else
                {
                    $dataPeticionPrev = array (
                        'UsuarioAsignado'       => $this->items['id'],
                        'UsuarioModifica'       => $this->items['id'],
                        'FechaModifica'         => $fechaActual,
                        'Estado'                => 'ASIG', 
                        'FechaEstado'           => $fechaActual,
                        'UsuarioEstado'         => $this->items['id'],
                        'IDSubareaEstado'       => $this->items['idSubarea'], 
                        'IDAreaEstado'          => $this->items['idArea'], 
                        'IDDireccionEstado'     => $this->items['dpto'], 
                        'IDPerfilEstado'        => $this->items['idPerfil'],
                        'IDDelegacionEstado'    => $this->items['idDelegacionLog'],
                        'IDCargoEstado'         => $this->items['idCargoLog'],
                        'MotivoEstado'          => "El usuario ".$this->items['nombres']." ".$this->items['apellidos']." ha sido asignado a esta petición.",
                        'Localhost'             => $this->request->getIPAddress()
                    );
                    $lastIdPrev = $this->peticiones->update([$idPeticion], $dataPeticionPrev);
                    
                    if($lastIdPrev !== FALSE){
            			$dataPeticion['FechaModifica']  = $fechaActualAdd;
                        $dataPeticion['FechaEstado']    = $fechaActualAdd;
                        $dataPeticion['MotivoEstado']   = $motivo != '' && $motivo != null ? $motivo : "Gestión Iniciada.";
                        
                        if($infoPeticion['Categorizacion'] == '' || $infoPeticion['Categorizacion'] == null)
                        {
                            $dataPeticion['Categorizacion'] = $categorizacion;
                        }
                        
                        $nuevaNotificacion['usuariodestino'] = $infoPeticion['UsuarioCrea'];
                        $nuevaNotificacion['perfildestino'] = null;
                        $nuevaNotificacion['mensaje'] = "Se ha <span class='color-asig'>INICIADO LA GESTIÓN</span> de la petición #".$idPeticion.".";
            		}
            		else
            		{
            		    $message = sprintf($this->mensajeError->msg201, "No se puede gestionar la asignación del usuario. Inténtelo luego.[".$estado."]");
                        echo $this->alertas->alertaError($message);
            			exit;
            		}
                }
            }
        }
        else if($estado == 'ESPE')
        {
            if($infoPeticion['Estado'] == 'INIC')
            {
                $dataPeticion['FechaModifica']  = $fechaActual;
                $dataPeticion['FechaEstado']    = $fechaActual;
                $dataPeticion['MotivoEstado']   = $motivo != '' && $motivo != null ? $motivo : "Gestión en espera.";
                $dataPeticion['UsuarioAsignado']= NULL;
                
                $nuevaNotificacion['usuariodestino'] = $infoPeticion['UsuarioCrea'];
                $nuevaNotificacion['perfildestino'] = null;
                $nuevaNotificacion['mensaje'] = "Se encuentra <span class='color-espe'>EN ESPERA LA GESTIÓN</span> de la petición #".$idPeticion.".";
            }
            else
            {
                $message = sprintf($this->mensajeError->msg201, "No cuenta con estado previo autorizado para pausar la petición. Inténtelo luego.[".$estado."]");
                echo $this->alertas->alertaError($message);
    			exit;
            }
        }
        else if($estado == 'COMP')
        {
            if($infoPeticion['Estado'] != 'INIC')
            {
                $message = sprintf($this->mensajeError->msg201, "No se puede gestionar el cambio de estado. Inténtelo luego.[".$estado."]");
                echo $this->alertas->alertaError($message);
    			exit;
            }
            else
            {
                $dataPeticion['FechaModifica']  = $fechaActual;
                $dataPeticion['FechaEstado']    = $fechaActual;
                $dataPeticion['MotivoEstado']   = $motivo != '' && $motivo != null ? $motivo : "Gestión Terminada.";
                $dataPeticion['UsuarioAsignado']= NULL;
                
                //SE REGISTRA Y SE GUARDA VALORIZADOS COMO COMENTARIOS.
                
    		    if(!empty($adjuValorizado['valorizadoCompletado']) || $linkValorizado != '')
        	    {
                    $dataComentarioCompletado = array (
                        'IDPeticion'            => $idPeticion, 
                        'Comentario'            => "Se registró el siguiente valorizado: ",
                        'Link'                  => $linkValorizado, 
                        'UsuarioCrea'           => $this->items['id'],
                        'FechaCrea'             => $fechaActualAdd,
                        'IDSubareaCrea'         => $this->items['idSubarea'], 
                        'IDAreaCrea'            => $this->items['idArea'], 
                        'IDDireccionCrea'       => $this->items['dpto'], 
                        'IDPerfilCrea'          => $this->items['idPerfil'],
                        'IDDelegacionCrea'      => $this->items['idDelegacionLog'],
                        'IDCargoCrea'           => $this->items['idCargoLog'],
                        'Estado'                => "A", 
                        'UsuarioEstado'         => $this->items['id'],
                        'FechaEstado'           => $fechaActualAdd,
                        'MotivoEstado'          => "Se registró el siguiente valorizado: ",
                        'Localhost'             => $this->request->getIPAddress()
                    );
                    
                    $lastIdComentarioComp = $this->peticionesComentarios->insert($dataComentarioCompletado, TRUE);
                    
                    if(!empty($adjuValorizado['valorizadoCompletado']) )
                    {
            	        foreach ($adjuValorizado['valorizadoCompletado'] as $key => $value) 
            	        {
                            if ($value->isValid() && ! $value->hasMoved()) 
                            {
                                if($value->getClientExtension() != null)
                                {
                                    $extensionDoc = $value->getClientExtension();
                                }
                                else if($value->guessExtension() != null)
                                {
                                    $extensionDoc = $value->guessExtension();
                                }
                                else
                                {
                                    $extensionDoc = pathinfo($value->getClientName(), PATHINFO_EXTENSION);
                                }
                    
                                $nombreArchivo = pathinfo($value->getClientName(), PATHINFO_FILENAME);
                                /*
                                * ----------------------------
                                * GUARDAR ARCHIVO ADJUNTO
                                * ----------------------------
                                */
                                $dataAdjunto = array (
                                    'IDComentarioPeticion'  => $lastIdComentarioComp, 
                                    'Nombre'                => $nombreArchivo,
                                    'Extension'             => $extensionDoc, 
                                    'UsuarioCrea'           => $this->items['id'],
                                    'FechaCrea'             => $fechaActualAdd,
                                    'Localhost'             => $this->request->getIPAddress()
                                );
                                
                                $lastIdAdjunto = $this->peticionesComentariosAdjuntos->insert($dataAdjunto, TRUE);
                                
                                if($lastIdAdjunto !== FALSE)
        		                {
                                    /*
                                    * ----------------------------
                                    * GUARDAR ARCHIVO ADJUNTO
                                    * ----------------------------
                                    */
                                    $ruta = $this->items['baseDinamic']."/files/Peticiones/Comentarios/".date("Y", strtotime($fechaActualAdd))."/".date("m", strtotime($fechaActualAdd))."/";
                                    
                                    if(!file_exists($ruta))
                                    {
                                        @mkdir($ruta, 0777, true);
                                    }
                            
                            		# si exsite la carpeta o se ha creado
                            		if (file_exists($ruta) || @mkdir($ruta)) 
                                    {
                                        $nuevonombre = $lastIdAdjunto.'-'.$lastIdComentarioComp.'.'.$extensionDoc;
                                        
                                        $estadoMove = $value->move($ruta, $nuevonombre);
                                    }
        		                }
                            }
                        }
        	        }
        	    }
        	    
                
                $nuevaNotificacion['usuariodestino'] = $infoPeticion['UsuarioCrea'];
                $nuevaNotificacion['perfildestino'] = null;
                $nuevaNotificacion['mensaje'] = "Se ha <span class='color-comp'>COMPLETADO LA GESTIÓN</span> de la petición #".$idPeticion.".";
            }
        }
        else if($estado == 'APRO')
        {
            if($infoPeticion['Estado'] != 'COMP')
            {
                $message = sprintf($this->mensajeError->msg201, "No se puede gestionar el cambio de estado. Inténtelo luego.[".$estado."]");
                echo $this->alertas->alertaError($message);
    			exit;
            }
            else
            {
                //Registrar la OC antes de la aprobación.
                
                $idOrdenCompra = $this->registrarOrdenCompra($this->request->getPost());
                
                $dataPeticion['FechaModifica']  = $fechaActual;
                $dataPeticion['FechaEstado']    = $fechaActual;
                $dataPeticion['MotivoEstado']   = $motivo != '' && $motivo != null ? $motivo : "Gestión Aprobada.";
                $dataPeticion['UsuarioAsignado']= NULL;
                $dataPeticion['IDOrdenCompra']  = $idOrdenCompra;
                
                $nuevaNotificacion['usuariodestino'] = null;
                $nuevaNotificacion['perfildestino'] = 2;
                $nuevaNotificacion['mensaje'] = "Se ha <span class='color-apro'>APROBADO LA GESTIÓN</span> de la petición #".$idPeticion.".";
            }
        }
        else if($estado == 'REEV')
        {
            if($infoPeticion['Estado'] != 'COMP')
            {
                $message = sprintf($this->mensajeError->msg201, "No se puede gestionar el cambio de estado. Inténtelo luego.[".$estado."]");
                echo $this->alertas->alertaError($message);
    			exit;
            }
            else
            {
                $dataPeticion['FechaModifica']  = $fechaActual;
                $dataPeticion['FechaEstado']    = $fechaActual;
                $dataPeticion['MotivoEstado']   = $motivo != '' && $motivo != null ? $motivo : "Gestión Reevaluada.";
                $dataPeticion['UsuarioAsignado']= NULL;
                
                $nuevaNotificacion['usuariodestino'] = null;
                $nuevaNotificacion['perfildestino'] = 2;
                $nuevaNotificacion['mensaje'] = "Se ha <span class='color-reev'>REEVALUADO LA GESTIÓN</span> de la petición #".$idPeticion.".";
            }
        }
        else if($estado == 'CANC')
        {
                $dataPeticion['FechaModifica']  = $fechaActual;
                $dataPeticion['FechaEstado']    = $fechaActual;
                $dataPeticion['MotivoEstado']   = $motivo != '' && $motivo != null ? $motivo : "Petición Cancelada.";
                $dataPeticion['UsuarioAsignado']= NULL;
                
                $nuevaNotificacion['usuariodestino'] = $infoPeticion['UsuarioCrea'];
                $nuevaNotificacion['perfildestino'] = null;
                $nuevaNotificacion['mensaje'] = "Se ha <span class='color-canc'>CANCELADO</span> la petición #".$idPeticion.".";
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "No se encontró gestión para el estado solicitado. Inténtelo luego.[".$estado."]");
            echo $this->alertas->alertaError($message);
			exit;
        }
        
        $lastId = $this->peticiones->update([$idPeticion], $dataPeticion);

		if($lastId !== FALSE){
		    
		    /*
            * ----------------------------
            * INSERCIÓN DE NOTIFICACIÓN
            * ----------------------------
            */
            
            if($estado != 'INIC')
            {
                $this->insertarNotificacion($nuevaNotificacion);
            }
		    
		    
			$message = sprintf($this->mensajeError->msg503, $idPeticion);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
		
	public function informacionProspectoPeticion($numProspecto)
	{
		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosProspecto = $this->peticiones->buscarInformacionProspectoPeticion($numProspecto);

		if(!empty($datosProspecto)){
			$resultado = array(
				'nroprospecto'  => (string) $numProspecto,
				'venta'         => (string) $datosProspecto['VENTA'],
				'cliente'       => (string) $datosProspecto['NombCliente'],
				'direccion'     => (string) $datosProspecto['DirCliente'],
				'intCliente'    => (string) $datosProspecto['IntCliente'],
				'referencia'    => (string) $datosProspecto['RefCliente'],
				'distrito'      => (string) $datosProspecto['DistCliente'],
				'provincia'     => (string) $datosProspecto['ProvCliente'],
				't1'            => (string) $datosProspecto['T1Cliente'],
				't2'            => (string) $datosProspecto['T2Cliente'],
				'correo'        => (string) $datosProspecto['CorreoCliente'],
				'fechavisita'   => (string) $datosProspecto['FechaVisita'],
				'horavisita'    => (string) $datosProspecto['HoraVisita'],
				'visitaobras'   => (string) $datosProspecto['FVisitaObras']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);	
	}
	
	public function registrarRequerimientoLicitacionPeticion()
	{
	    $idRequerimiento = $this->registrarOrdenCompra($this->request->getPost());
	    
	    $fechaActual = date("Y-m-d H:i:s");
	    $fechaActualCrea = date("Y-m-d H:i:s", strtotime($fechaActual)-1);
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError       = TRUE;
        $peticion       = htmlspecialchars(trim($this->request->getPost('conceptoOC')), ENT_QUOTES,'UTF-8');
        $motivoReq      = 7;
        $req            = 3;
        $detalleReq     = htmlspecialchars(trim($this->request->getPost('observaciones')), ENT_QUOTES,'UTF-8');
        $linkReq        = NULL;
        
        $responsable    = $this->request->getPost('cboCompradorOC');
        $marca          = htmlspecialchars(trim($this->request->getPost('conceptoOC')), ENT_QUOTES,'UTF-8');
        $presupuesto    = htmlspecialchars(trim($this->request->getPost('totaldetalleoc')), ENT_QUOTES,'UTF-8');
        $moneda         = $this->request->getPost('cboMonedaOC');
        $cantidad       = array_sum($this->request->getPost('cantidaditemoc'));

        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */
        
        $message = '';
        
        $dataPeticion = array (
            'Peticion'              => $peticion,
            'IDMotivo'              => $motivoReq, 
            'Detalle'               => $detalleReq, 
            'LinkAsociado'          => $linkReq,
            'PresupuestoAsignado'   => $presupuesto == '' ? null : $presupuesto,
            'Producto'              => $marca == '' ? null : $marca,
            'Cantidad'              => $cantidad == '' ? null : $cantidad,
            'TipoMoneda'            => $moneda == '' ? null : $moneda,
            'UsuarioCrea'           => $this->items['id'],
            'FechaCrea'             => $fechaActualCrea,
            'IDSubareaCrea'         => $this->items['idSubarea'], 
            'IDAreaCrea'            => $this->items['idArea'], 
            'IDDireccionCrea'       => $this->items['dpto'], 
            'IDPerfilCrea'          => $this->items['idPerfil'],
            'IDDelegacionCrea'      => $this->items['idDelegacionLog'],
            'IDCargoCrea'           => $this->items['idCargoLog'],
            'Estado'                => "CREA", 
            'UsuarioEstado'         => $this->items['id'],
            'IDDireccionEstado'     => $this->items['dpto'], 
            'IDAreaEstado'          => $this->items['idArea'], 
            'IDSubareaEstado'       => $this->items['idSubarea'], 
            'IDDelegacionEstado'    => $this->items['idDelegacionLog'],
            'IDPerfilEstado'        => $this->items['idPerfil'],
            'IDCargoEstado'         => $this->items['idCargoLog'],
            'FechaEstado'           => $fechaActualCrea,
            'MotivoEstado'          => "Petición creada automáticamente por Requerimiento de licitación",
            'Localhost'             => $this->request->getIPAddress()
        );
        
        $lastId = $this->peticiones->insert($dataPeticion, TRUE);
        
		if($lastId !== FALSE)
		{
		   
		    /*
            * ----------------------------
            * APROBAR PETICIÓN
            * ----------------------------
            */
            
            $dataPeticionApro = array (
                'IDOrdenCompra'         => $idRequerimiento,
                'UsuarioModifica'       => $this->items['id'],
                'FechaModifica'         => $fechaActual,
                'Estado'                => "APRO", 
                'UsuarioEstado'         => $this->items['id'],
                'FechaEstado'           => $fechaActual,
                'MotivoEstado'          => "Aprobación automática por Requerimiento de Licitación",
                'IDSubareaEstado'       => $this->items['idSubarea'], 
                'IDAreaEstado'          => $this->items['idArea'], 
                'IDDireccionEstado'     => $this->items['dpto'], 
                'IDPerfilEstado'        => $this->items['idPerfil'],
                'IDDelegacionEstado'    => $this->items['idDelegacionLog'],
                'IDCargoEstado'         => $this->items['idCargoLog'],
                'Localhost'             => $this->request->getIPAddress()
            );
            
            $this->peticiones->update([$lastId], $dataPeticionApro);
            
            $message = sprintf($this->mensajeError->msg201, "<li>Se registró el requerimiento Nro ".$idRequerimiento." con éxito.</li>");
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		} 
		else
		{
		    $message = sprintf($this->mensajeError->msg201, "<li>No se pudo registrar la petición. Inténtelo luego o póngase en contacto con Soporte IT.</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
		}
	}
	
	public function registrarOrdenCompra($array)
	{
	    $fechaActual = date("Y-m-d H:i:s");
        
        $moneda = $this->globales->monedas();
        $impuestos = $this->globales->porcentajeImpuestos();
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $concepto_oc    = htmlspecialchars(trim($array['conceptoOC']), ENT_QUOTES,'UTF-8');
		$fechapedido    = $array['txtFechaPedidoOC'];
		$comprador      = $array['cboCompradorOC'];
		$envioFactura   = $array['cboEnvioFacturaOC'];
		$budget         = $array['cboBudgetOC'];
		$condicionesIgv = $array['cboIGVOC'];
		$subcategoria   = $array['cboSubcategoriaOC'];
		$delegacion     = $array['cboDelegacionOC'];
		$cc             = $array['txtCCOC'];
		$ln             = $array['txtLNOC'];
		$subarea        = $array['cboSubareaOC'];
		$observaciones  = htmlspecialchars(trim($array['observaciones']), ENT_QUOTES,'UTF-8');
	    $idProveedor    = $array['cboProveedorOC'];
		$formapago      = $array['cboFormaPagoOC'];
		$modalidadPago  = $array['cboModalidadPagoOC'];
		$banco          = $array['cboBancoOC'];
		$tipomoneda     = $array['cboMonedaOC'];
		
		$subtotal       = htmlspecialchars(trim($array['subtotaldetalleoc']), ENT_QUOTES,'UTF-8');
		$igvOc          = htmlspecialchars(trim($array['igvdetalleoc']), ENT_QUOTES,'UTF-8');
		$totalOC        = htmlspecialchars(trim($array['totaldetalleoc']), ENT_QUOTES,'UTF-8');
		
		$cuentabancaria = htmlspecialchars($array['txtCuentaOC'], ENT_QUOTES,'UTF-8');
		$cuentainterbancaria    = $array['txtCCIOC'];
		
		$items          = $array['correlativo'];
		$descripcionitem= $array['descripcionitemoc'];
		$cantidaditem   = $array['cantidaditemoc'];
		$precioitem     = $array['precioitemoc'];
		
        $estado_OC = "PendienteFirma1";
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
		$error = '';
		$error .= $this->complementos->validaCampo($concepto_oc, 'required|trim|minlength[1]|maxlength[255]', 'Concepto');
		$error .= $this->complementos->validaCampo($fechapedido, 'required|trim|dateDos|minlength[1]|maxlength[60]', 'Fecha Pedido');
		$error .= $this->complementos->validaCampo($comprador, 'required|trim|numeric', 'Comprador');
		$error .= $this->complementos->validaCampo($envioFactura, 'required|trim|alpha|minlength[1]|maxlength[2]', 'Envio Factura');
		$error .= $this->complementos->validaCampo($budget, 'required|trim|alpha|minlength[1]|maxlength[2]', 'Budget');
		$error .= $this->complementos->validaCampo($condicionesIgv, 'trim|alpha|minlength[1]|maxlength[10]', 'Condiciones IGV');
		$error .= $this->complementos->validaCampo($subcategoria, 'required|trim|numeric', 'Subcategoría');
		$error .= $this->complementos->validaCampo($delegacion, 'required|trim|numeric', 'Delegación');
		$error .= $this->complementos->validaCampo($cc, 'required|trim|numeric', 'CC');
		$error .= $this->complementos->validaCampo($ln, 'required|trim|numeric', 'LN');
		$error .= $this->complementos->validaCampo($subarea, 'required|trim|numeric', 'Subárea');
		$error .= $this->complementos->validaCampo($observaciones, 'trim', 'Observaciones');
		$error .= $this->complementos->validaCampo($idProveedor, 'required|trim|numeric', 'Id Proveedor');
		$error .= $this->complementos->validaCampo($formapago, 'required|trim|alphanumeric|minlength[1]|maxlength[30]', 'Forma de Pago');
		$error .= $this->complementos->validaCampo($modalidadPago, 'required|trim|alphanumeric|minlength[1]|maxlength[30]', 'Modalidad Pago');
		$error .= $this->complementos->validaCampo($banco, 'required|trim|minlength[1]|maxlength[200]', 'Banco');
		$error .= $this->complementos->validaCampo($tipomoneda, 'required|trim|alpha|minlength[1]|maxlength[5]', 'Tipo Moneda');
		
		$error .= $this->complementos->validaCampo($subtotal, 'required|trim|float', 'Sub Total');
		$error .= $this->complementos->validaCampo($igvOc, 'required|trim|float', 'Igv');
		$error .= $this->complementos->validaCampo($totalOC, 'required|trim|float', 'Total');
		
		$error .= $this->complementos->validaCampo($cuentabancaria, 'trim|minlength[1]|maxlength[100]', 'Cuenta Bancaria');
		$error .= $this->complementos->validaCampo($cuentainterbancaria, 'trim|minlength[1]|maxlength[100]', 'CCI');
		
        if(empty($items))
        {
            $error .= "<li>No hay items agregados al requerimiento.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        $centralizada = 0;
        
        /*
        * ----------------------------
        * VALIDACIÓN DE RESPONSABLES
        * ----------------------------
        */
        
        // $informacionSubarea = $this->estructuraSubareas->obtenerSubarea($subarea);
        $informacionSubarea = $this->responsablesAprobacion->where("IDSubarea", $subarea)->first();
        
        // if($informacionSubarea['Responsable_Subarea'] == '' || $informacionSubarea['Responsable_Subarea'] == null || $informacionSubarea['Responsable_Area'] == '' || $informacionSubarea['Responsable_Area'] == null || $informacionSubarea['Responsable_Direccion'] == '' || $informacionSubarea['Responsable_Direccion'] == null)
        if($informacionSubarea['Aprobador01'] == '' || $informacionSubarea['Aprobador01'] == null || $informacionSubarea['Aprobador02'] == '' || $informacionSubarea['Aprobador02'] == null || $informacionSubarea['Aprobador03'] == '' || $informacionSubarea['Aprobador03'] == null)
        {
			$message = sprintf($this->mensajeError->msg201, "<li>No se encontró usuarios responsables de firma para esta subárea. Por favor, seleccionar otra subárea o póngase en contacto con Soporte IT.</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * CREACIÓN DE ORDEN DE COMPRA
        * ----------------------------
        */
        
        $porcentajeigv = isset($impuestos[$condicionesIgv]) ? $impuestos[$condicionesIgv]['MULTIPLICADOR'] : "0";

        $data = array (
            'Concepto'              => $concepto_oc,
            'IDProveedor'           => $idProveedor,
            'FormaPago'             => $formapago,
            'Observacion'           => $observaciones,
            'Subtotal'              => $subtotal,
            'IGV'                   => $igvOc,
            'Total'                 => $totalOC,
            'FechaPedido'           => $fechapedido,
            'PorcentajeIGV'         => $porcentajeigv,
            'CondicionesIGV'        => $condicionesIgv,
            'ModalidadPago'         => $modalidadPago,
            'Banco'                 => $banco,
            'CuentaBancaria'        => $cuentabancaria,
            'CuentaInterbancaria'   => $cuentainterbancaria,
            'TipoMoneda'            => $tipomoneda,
            'MontoCambio'           => (isset($moneda[$tipomoneda]) ? $moneda[$tipomoneda]['CAMBIO'] : 1),
            'Budget'                => $budget,
            'UsuarioSolicitante'    => $this->items['id'],
            'IDDelegacion'          => $delegacion,
            'CC'                    => $cc,
            'LN'                    => $ln,
            'IDSubarea'             => $subarea,
            'CompraCentralizada'    => $centralizada,
            'EnvioFactura'          => $envioFactura,
            'IDSubcategoria'        => $subcategoria,
            'UsuarioComprador'      => $comprador,
            'UsuarioCrea'           => $this->items['id'],
            'FechaCrea'             => $fechaActual,    
            'Localhost'             => $this->request->getIPAddress(),
            'UsuarioEstado'         => $this->items['id'],
            'FechaEstado'           => $fechaActual,    
            'MotivoEstado'          => $observaciones,    
            'Estado'                => $estado_OC
        );

        $lastId = $this->ordenCompra->insert($data, TRUE);
        
        if($lastId !== FALSE){
            $idOrdenCompra = $lastId;
        }
        else
        {
    		$message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar el requerimiento. Inténtelo luego.</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * CREACIÓN DEL DETALLE DE LA ORDEN DE COMPRA
        * ----------------------------
        */

        $dataDetalle = array();

        foreach($items as $key)
        {
            $dataDetalle[] = array (
                'IDOrdenCompra'     => $idOrdenCompra, 
                'Descripcion'       => $descripcionitem[$key],  
                'Cantidad'          => $cantidaditem[$key], 
                'PrecioUnitario'    => $precioitem[$key], 
                'UsuarioCrea'       => $this->items['id'],
                'FechaCrea'         => $fechaActual,    
                'Localhost'         => $this->request->getIPAddress(),
                'UsuarioEstado'     => $this->items['id'],
                'FechaEstado'       => $fechaActual,    
                'MotivoEstado'      => "Creación de detalle OC desde Petición.",    
                'Estado'            => "A"
            );
        }
        
        $lastIdDetalle = $this->ordenCompraDetalle->insertBatch($dataDetalle);
        
        if($lastIdDetalle === FALSE)
        {
    		$message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar el detalle del requerimiento. Registrelos luego.</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * REGISTRAR USUARIOS RESPONSABLES DE LA FIRMA DE LA ORDEN DE COMPRA
        * ----------------------------
        */
        
        // SI DELEGACION USUARIO LOGUEADO = $delegacion 
        
        // if($this->items['idDelegacionLog'] == $delegacion && $informacionSubarea['Responsable_Subarea'] == $this->items['id'])
        // {
        //     $informacionSubarea['Responsable_Subarea'] = $informacionSubarea['Responsable_Area'];
        //     $informacionSubarea['Responsable_Area'] = $informacionSubarea['Responsable_Direccion'];
        // }
        // else if($this->items['idDelegacionLog'] == $delegacion && $informacionSubarea['Responsable_Area'] == $this->items['id'])
        // {
        //     $informacionSubarea['Responsable_Subarea'] = $informacionSubarea['Responsable_Direccion'];
        //     $informacionSubarea['Responsable_Area'] = $informacionSubarea['Responsable_Direccion'];
        // }
        
        if($this->items['idDelegacionLog'] == $delegacion && $informacionSubarea['Aprobador01'] == $this->items['id'])
        {
            $informacionSubarea['Aprobador01'] = $informacionSubarea['Aprobador02'];
            $informacionSubarea['Aprobador02'] = $informacionSubarea['Aprobador03'];
        }
        else if($this->items['idDelegacionLog'] == $delegacion && $informacionSubarea['Aprobador02'] == $this->items['id'])
        {
            $informacionSubarea['Aprobador01'] = $informacionSubarea['Aprobador03'];
            $informacionSubarea['Aprobador02'] = $informacionSubarea['Aprobador03'];
        }
        
        // $dataResponsables = array (
        //     'IDOrdenCompra' => $idOrdenCompra,
        //     'UsuarioFirma1' => $informacionSubarea['Responsable_Subarea'],
        //     'UsuarioFirma2' => $informacionSubarea['Responsable_Area'],
        //     'UsuarioFirma3' => $informacionSubarea['Responsable_Direccion'],
        //     'UsuarioCrea'   => $this->items['id'],
        //     'FechaCrea'     => $fechaActual,    
        //     'Localhost'     => $this->request->getIPAddress(),
        //     'UsuarioEstado' => $this->items['id'],
        //     'FechaEstado'   => $fechaActual,    
        //     'MotivoEstado'  => "Habilitar usuarios responsables firma OC.",    
        //     'Estado'        => "A"
        // );
        
        $dataResponsables = array (
            'IDOrdenCompra' => $idOrdenCompra,
            'UsuarioFirma1' => $informacionSubarea['Aprobador01'],
            'UsuarioFirma2' => $informacionSubarea['Aprobador02'],
            'UsuarioFirma3' => $informacionSubarea['Aprobador03'],
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress(),
            'UsuarioEstado' => $this->items['id'],
            'FechaEstado'   => $fechaActual,    
            'MotivoEstado'  => "Habilitar usuarios responsables firma OC.",    
            'Estado'        => "A"
        );

        $lastIdResponsable = $this->ordenCompraResponsable->insert($dataResponsables, TRUE);
		    
        if($lastIdResponsable !== FALSE)
        {
            $informacionOC = $this->ordenCompra->obtenerOrdenCompra($idOrdenCompra);
            
    	    $solicitante    = $this->usuarios->where("IdUsuario ", $informacionOC['UsuarioSolicitante'])->first();
    	    
    	    $responsable01 = $this->usuarios->where("IdUsuario ", $informacionOC['UsuarioFirma1'])->first();
    	    $responsable02 = $this->usuarios->where("IdUsuario ", $informacionOC['UsuarioFirma2'])->first();
    	    $responsable03 = $this->usuarios->where("IdUsuario ", $informacionOC['UsuarioFirma3'])->first();
    	    
    	    $informacionOC['IDSolicitante']        = $informacionOC['UsuarioSolicitante'];
    	    $informacionOC['UsuarioSolicitante']   = ucwords(mb_strtolower($solicitante['Nombres'].' '.$solicitante['Apellidos']));
    	    $informacionOC['CorreoSolicitante']    = $solicitante['Correo'];
    	    
    	    $informacionOC['UsuarioAprobador01']   = ucwords(mb_strtolower($responsable01['Nombres'].' '.$responsable01['Apellidos']));
    	    $informacionOC['CorreoAprobador01']    = $responsable01['Correo'];
    	    $informacionOC['MatriculaAprobador01'] = $responsable01['Matricula'];
    	    $informacionOC['IDAprobador01']        = $informacionOC['UsuarioFirma1'];
    	    
    	    $informacionOC['UsuarioAprobador02']   = ucwords(mb_strtolower($responsable02['Nombres'].' '.$responsable02['Apellidos']));
    	    $informacionOC['CorreoAprobador02']    = $responsable02['Correo'];
    	    $informacionOC['MatriculaAprobador02'] = $responsable02['Matricula'];
    	    
    	    $informacionOC['UsuarioAprobador03']   = ucwords(mb_strtolower($responsable03['Nombres'].' '.$responsable03['Apellidos']));
    	    $informacionOC['CorreoAprobador03']    = $responsable03['Correo'];
    	    $informacionOC['MatriculaAprobador03'] = $responsable03['Matricula'];
    	    
            $estadoCorreo = $this->complementos->enviarCorreoOrdenCompraPrimeraFirma($informacionOC,$idOrdenCompra);

            $dataCorreo = array(
                "IDOrdenCompra" => $idOrdenCompra,
                "Momento"       => "REGISTRO",
                "Response"      => $estadoCorreo['RESPUESTA'],
                "Error"         => $estadoCorreo['ERROR'],
                'UsuarioCrea'   => $this->items['id'],
                'FechaCrea'     => $fechaActual,    
                'Localhost'     => $this->request->getIPAddress()
            );

            $this->correoStatusOrdenCompra->insert($dataCorreo, TRUE);
            
            return $idOrdenCompra;
        }
        else
        {
    		$message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al asociar a los responsables de la firma del requerimiento. Asócielos luego.</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
	}
	
// 	public function listadoMonedas()
// 	{
//     	/*
//         * ----------------------
//         * OBTIENE Y VALIDA DATOS
//         * ----------------------
//         */
//         $listadoMonedas = array(
//             "PEN" => array(
//                 "NOMBRE" => "Soles",
//                 "SIMBOLO" => "S/"
//                 ),
//             "USD" => array(
//                 "NOMBRE" => "Dólares Americanos",
//                 "SIMBOLO" => "$"
//                 ),
//             "EUR" => array(
//                 "NOMBRE" => "Euros",
//                 "SIMBOLO" => "€"
//                 )
//         );
        
//         $monedas = array();

// 		if (!empty($listadoMonedas)) {
//     //         foreach ($listadoDistritos as $items) {
//     //             $distritos[] = array(
// 				// 	'id'    => (string) $items['IDDistrito'],
//     //      	        'text'  => (string) $items['Distrito'],
//     //             );
//     //         }
                
//             foreach ($listadoMonedas as $key => $items) {
//                 $monedas[] = array(
// 					'id'    => (string) $key,
//          	        'text'  => (string) "(".$items['SIMBOLO'].") ".$items['NOMBRE'],
//          	        'simbolo'   => (string) $items['SIMBOLO']
//                 );
//             }
            
//             $resultado = array(
// 				'listadoMonedas' => json_encode($monedas)
// 			);
//         } else {
// 			$resultado = array(
// 				'descripcion' => 0,
// 			);
// 		}

//         /*
//          * ----------------------------
//          * DATOS DE AJAX PRE PROCESADOS
//          * ----------------------------
//          */
//         echo json_encode($resultado, JSON_NUMERIC_CHECK);		
// 	}	
}