<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<ul class="nav nav-tabs nav-justified nav-border-top nav-border-top-success mb-3 bg-white" role="tablist">
                <li class="nav-item" role="presentation">
                    <a class="nav-link active" data-bs-toggle="tab" href="#nav-peticiones-pendientes" role="tab" aria-selected="true">
                        <i class="ri-home-5-line align-middle me-1"></i> Peticiones Pendientes
                    </a>
                </li>
                <li class="nav-item" role="presentation" id="navPeticionesHistorico">
                    <a class="nav-link" data-bs-toggle="tab" href="#nav-peticiones-historico" role="tab" aria-selected="false" tabindex="-1">
                        <i class="ri-user-line me-1 align-middle"></i> Histórico de Peticiones
                    </a>
                </li>
            </ul>
            <div class="tab-content text-muted" style="background-color: transparent;">
                <div class="tab-pane active show" id="nav-peticiones-pendientes" role="tabpanel" style="background-color: transparent!important">
                    <div class="row">
                        <div class="col-xxl-3 col-sm-6">
                            <div class="card card-animate">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <p class="fw-medium text-muted mb-0">Total de peticiones</p>
                                            <h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target="<?= $cantidadesGenerales['Totales'] ?>"><?= $cantidadesGenerales['Totales'] ?></span></h2>
                                            <!--<h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target="547">547</span>k</h2>-->
                                            <!--<p class="mb-0 text-muted"><span class="badge bg-light text-success mb-0"> <i class="ri-arrow-up-line align-middle"></i> 17.32 % </span> vs. previous month</p>-->
                                        </div>
                                        <div>
                                            <div class="avatar-sm flex-shrink-0">
                                                <span class="avatar-title bg-sistema-25 rounded-circle fs-4">
                                                    <i class="mdi mdi-ticket-account" style="font-size: 28px;"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div><!-- end card body -->
                            </div> <!-- end card-->
                        </div>
                        <!--end col-->
                        <div class="col-xxl-3 col-sm-6">
                            <div class="card card-animate">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <p class="fw-medium text-muted mb-0">Peticiones del mes</p>
                                            <h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target="<?= $cantidadesGenerales['Mes'] ?>"><?= $cantidadesGenerales['Mes'] ?></span></h2>
                                            <!--<h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target="124">124</span>k</h2>-->
                                            <!--<p class="mb-0 text-muted"><span class="badge bg-light text-danger mb-0"> <i class="ri-arrow-down-line align-middle"></i> 0.96 % </span> vs. previous month</p>-->
                                        </div>
                                        <div>
                                            <div class="avatar-sm flex-shrink-0">
                                                <span class="avatar-title bg-sistema-25 rounded-circle fs-4">
                                                    <i class="mdi mdi-calendar-month-outline" style="font-size: 28px;"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div><!-- end card body -->
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-xxl-3 col-sm-6">
                            <div class="card card-animate">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <p class="fw-medium text-muted mb-0">Peticiones pendientes</p>
                                            <h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target="<?= $cantidadesGenerales['Pendientes'] ?>"><?= $cantidadesGenerales['Pendientes'] ?></span></h2>
                                            <!--<h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target="107">107</span>K</h2>-->
                                            <!--<p class="mb-0 text-muted"><span class="badge bg-light text-danger mb-0"> <i class="ri-arrow-down-line align-middle"></i> 3.87 % </span> vs. previous month</p>-->
                                        </div>
                                        <div>
                                            <div class="avatar-sm flex-shrink-0">
                                                <span class="avatar-title bg-sistema-25 rounded-circle fs-4">
                                                    <i class="mdi mdi-timer-sand" style="font-size: 28px;"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div><!-- end card body -->
                            </div>
                        </div>
                        <!--end col-->
                        <div class="col-xxl-3 col-sm-6">
                            <div class="card card-animate">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <p class="fw-medium text-muted mb-0">Peticiones sin iniciar</p>
                                            <h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target="<?= $cantidadesGenerales['NoIniciados'] ?>"><?= $cantidadesGenerales['NoIniciados'] ?></span></h2>
                                            <!--<h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value" data-target="15.95">15.95</span>%</h2>-->
                                            <!--<p class="mb-0 text-muted"><span class="badge bg-light text-success mb-0"> <i class="ri-arrow-up-line align-middle"></i> 1.09 % </span> vs. previous month</p>-->
                                        </div>
                                        <div>
                                            <div class="avatar-sm flex-shrink-0">
                                                <span class="avatar-title bg-sistema-25 rounded-circle fs-4">
                                                    <i class="mdi mdi-clock-alert-outline" style="font-size: 28px;"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div><!-- end card body -->
                            </div>
                        </div>
                        <!--end col-->
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card" id="ticketsList">
                                <div class="card-header border-0">
                                    <div class="d-flex align-items-center">
                                        <h5 class="card-title mb-0 flex-grow-1">Peticiones</h5>
                                        <div class="flex-shrink-0">
                                            <div class="d-flex flex-wrap gap-2">
                                                <?php
                								if (in_array("ADRELI", $permisos)) 
                								{
                								?>
                                                <button type="button" class="btn bg-success color-white px-2 py-1 mx-1" data-bs-target="#registrarRequerimientoLicitacion" data-form="#formRegistrarRequerimientoLicitacion" id="btnNuevoRequerimientoLicitacion">
                                                    <i class="mdi mdi-plus-thick me-1" style="font-size: 14px;"></i>Compra Descentralizada
                                                </button>
                                                <!--<button type="button" class="btn btn-primary" > <i class="ri-equalizer-fill me-1 align-bottom"></i>-->
                                                <!--    Filters-->
                                                <!--</button>-->
                                                <?php    
                								}
                								
                								if (in_array("ADDPET", $permisos)) 
                								{
                								?>
                                                <button type="button" class="btn bg-sistema color-white px-2 py-1 mx-1" data-bs-target="#registrarPeticion" data-form="#formRegistrarPeticion" id="btnNuevaPeticion">
                                                    <i class="mdi mdi-plus-thick me-1" style="font-size: 14px;"></i>Petición
                                                </button>
                                                <!--<button type="button" class="btn btn-primary" > <i class="ri-equalizer-fill me-1 align-bottom"></i>-->
                                                <!--    Filters-->
                                                <!--</button>-->
                                                <?php    
                								}
                								?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--end card-body-->
                                <div class="card-body">
                                    <div class="mb-4 table-responsive">
                                        <table class="table table-bordered dt-responsive nowrap table-striped align-middle" id="tblPeticiones" width="100%">
                                            <thead>
                                                <tr>
                                                    <th class="sort desc">Nro Petición</th>
                                                    <th class="sort">Nro Requerimiento</th>
                                                    <th class="sort">Fecha de Creación</th>
                                                    <th class="sort">Fecha Último Cambio</th>
                                                    <th class="sort">Delegación Solicitante</th>
                                                    <th class="sort">Perfil Solicitante</th>
                                                    <th class="sort">Categorización</th>
                                                    <th class="sort">Motivo</th>
                                                    <th class="sort">Usuario Último Cambio</th>
                                                    <th class="sort">Estado</th>
                                                    <th class="sort">Acción</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                foreach($listadoPeticiones as $items)
                                                {
                                                ?>
                                                <tr>
                                                    <td class="text-center align-middle"><?= $items['NotificacionesNoVistas'] > 0 ? "<span class='mdi mdi-exclamation-thick mr-2' style='font-size: 18px; color: red;'></span>" : "" ?><?= $items['IDPeticion'] ?></td>
                                                    <td class="text-center align-middle"></td>
                                                    <td class="text-center align-middle"><?= date("d-m-Y", strtotime($items['FechaCrea'])) ?><br><?= date("H:i:s", strtotime($items['FechaCrea'])) ?><br></td>
                                                    <td class="text-center align-middle"><?= date("d-m-Y", strtotime($items['FechaEstado'])) ?><br><?= date("H:i:s", strtotime($items['FechaEstado'])) ?></td>
                                                    <td class="text-center align-middle"><?= $items['DelegacionSolicitante'] ?></td>
                                                    <td class="text-center align-middle"><?= $items['PerfilSolicitante'] ?></td>
                                                    <td class="text-center align-middle"><?= $items['Requerimiento'] ?></td>
                                                    <td class="text-center align-middle"><?= $items['Motivo'] ?></td>
                                                    <td class="text-center align-middle"><?= $items['NombreUsuarioEstado'] ?></td>
                                                    <td class="text-center align-middle">
                                                        <span class="badge <?= $estadosPeticion[$items['Estado']]['FONDO'] ?> border-0">
            												<?= $estadosPeticion[$items['Estado']]['PASADO'] ?>
            											</span>
                                                    </td>
                                                    <td class="text-center align-middle">
                                                        <span class="badge bg-sistema border-0 p-2">
                                                            <a href="<?= $baseUrl ?>/detalle-peticion/<?= $items['IDPeticion'] ?>" class="color-white">
            													<i class="ri-eye-fill align-bottom" style="font-size: 18px;"></i>
            												</a>
            											</span>
                                                    </td>
                                                </tr>
                                                <?php
                                                }
                                                ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <!--end card-body-->
                            </div>
                            <!--end card-->
                        </div>
                        <!--end col-->
                    </div>
                </div>
                <div class="tab-pane" id="nav-peticiones-historico" role="tabpanel" style="background-color: transparent;">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card" id="ticketsList">
                                <div class="card-header border-0">
                                    <div class="d-flex align-items-center">
                                        <h5 class="card-title mb-0 flex-grow-1">Histórico de Peticiones</h5>
                                        <div class="flex-shrink-0">
                                            <div class="d-flex flex-wrap gap-2">
                                                <!--<button type="button" class="btn btn-primary" > <i class="ri-equalizer-fill me-1 align-bottom"></i>-->
                                                <!--    Filters-->
                                                <!--</button>-->
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--end card-body-->
                                <div class="card-body">
                                    <div class="mb-4">
                                        <table class="table table-bordered dt-responsive nowrap table-striped align-middle" id="tblHistoricoPeticiones">
                                            
                                        </table>
                                    </div>
                                </div>
                                <!--end card-body-->
                            </div>
                            <!--end card-->
                        </div>
                        <!--end col-->
                    </div>
                </div>
            </div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<!-- Modal Registrar Petición -->
<div class="modal fade zoomIn" id="registrarPeticion" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleRegistrarPeticion" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema d-flex justify-content-start align-items-center p-3">
				<h5 class="modal-title color-white" id="exampleRegistrarPeticion">Registrar Petición</h5>
                <button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close" id="close-modal"></button>
			</div>
			<form id="formRegistrarPeticion" class="formularioRegistrarPeticion" autocomplete="off" action="<?= $baseUrl ?>/grabar-peticion" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
				    <input type="hidden" id="txtFormularioRegistrarPeticion" name="txtFormularioRegistrarPeticion" value="formRegistrarPeticion">
					<div class="row">
					    <div class="col-12 m-0 p-0">
    						<div class="col-xxl-8 col-md-12 col-12 px-3 mb-3">
    							<div>
    								<label for="txtPeticion_poc" class="form-label color-sistema">Petición</label>
    								<input type="text" class="form-control color-sistema border-color-sistema" id="txtPeticion_poc" name="txtPeticion_poc">
    							</div>
    						</div>
    					</div>				
				        <div class="col-xxl-4 col-md-12 col-12 px-3 mb-3">
						    <div>
								<label for="txtTipoRequerimiento_poc" class="form-label">Tipo Categorización</label>
								<select class="form-select" aria-label="Tipo de Requerimiento" id="txtTipoRequerimiento_poc" name="txtTipoRequerimiento_poc" data-modal="registrarPeticion">
									<option selected="" value="">Seleccione una opción</option>
								</select>
							</div>
						</div>
				        <div class="col-xxl-4 col-md-12 col-12 px-3 mb-3">
						    <div>
								<label for="txtRequerimiento_poc" class="form-label">Categorización</label>
								<select class="form-select" aria-label="Requerimiento" id="txtRequerimiento_poc" name="txtRequerimiento_poc" data-modal="registrarPeticion">
									<option selected="" value="">Seleccione una opción</option>
								</select>
								<input type="hidden" id="txtRequerimientoTextPeticion" name="txtRequerimientoTextPeticion">
							</div>
						</div>
				        <div class="col-xxl-4 col-md-12 col-12 px-3 mb-3">
						    <div>
								<label for="txtMotivoRequerimiento_poc" class="form-label">Motivo de la Categorización</label>
								<select class="form-select" aria-label="Motivo del Requerimiento" id="txtMotivoRequerimiento_poc" name="txtMotivoRequerimiento_poc" data-modal="registrarPeticion">
									<option selected="" value="">Seleccione una opción</option>
								</select>
							</div>
						</div>	
				        <div class="col-xxl-12 col-md-12 col-12 mb-3">
						    <div>
								<label for="txtCompradorResponsable_poc" class="form-label">Comprador Responsable</label>
								<select class="form-select" aria-label="Comprador Responsable" id="txtCompradorResponsable_poc" name="txtCompradorResponsable_poc" data-modal="registrarPeticion">
									<option selected="" value="">Seleccione una opción</option>
								</select>
							</div>
						</div>
				        <div class="col-xxl-12 col-md-12 col-12 px-3 mb-3">
						    <div>
								<label for="txtMarcaModelo_poc" class="form-label">Marca / Modelo</label>
								<input type="text" class="form-control" id="txtMarcaModelo_poc" name="txtMarcaModelo_poc">
							</div>
						</div>
						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3">
							<div>
								<label for="txtPresupuestoAsignado_poc" class="form-label">Presupuesto asignado</label>
								<input type="text" class="form-control" id="txtPresupuestoAsignado_poc" name="txtPresupuestoAsignado_poc" onkeypress="return validarNumerosDecimales(event, this);"> 
							</div>
						</div>
				        <div class="col-xxl-4 col-md-12 col-12 px-3 mb-3">
						    <div>
								<label for="cboMoneda_poc" class="form-label">Moneda</label>
                                <select class="form-select" aria-label="Moneda" name="cboMoneda_poc" id="cboMoneda_poc" data-modal="registrarPeticion">
                                    <option selected="" value="">Seleccione una opción</option>
                                </select>
							</div>
						</div>	
				        <div class="col-xxl-4 col-md-12 col-12 px-3 mb-3">
						    <div>
								<label for="txtCantidad_poc" class="form-label">Cantidad</label>
								<input type="text" class="form-control" id="txtCantidad_poc" name="txtCantidad_poc" onkeypress="return validarNumerosEnteros(event, this);">
							</div>
						</div>
						
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtDetallePeticion_poc" class="form-label">Detalle</label>
								<textarea class="form-control" id="txtDetallePeticion_poc" name="txtDetallePeticion_poc" rows="4"></textarea>
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 px-3 mb-3">
							<div>
								<label for="txtLinkPeticion_poc" class="form-label">Link Asociado:</label>
								<input type="text" class="form-control" id="txtLinkPeticion_poc" name="txtLinkPeticion_poc">
							</div>
						</div>
    					<div class="col-12 mb-0 d-flex justify-content-center">
    					    <div class="col-12 m-0 p-0">
    					        <input type="file" id="txtAdjunto_poc" class="filepond" name="txtAdjunto_poc" data-max-file-size="100MB" data-max-files="6" />
    					    </div>
    					</div>
						<!--<div class="col-xxl-12 col-md-12 col-12 bg-sistema color-white p-2 mb-3 d-flex justify-content-between align-items-center" style="border-radius: 10px;">-->
						<!--    Archivos adjuntos-->
						<!--    <button type="button" class="btn bg-success px-2 py-1" onclick="return agregarAdjunto('ctnAdjuntosPeticiones');" data-tooltip="tooltip" aria-label="Agregar Adjunto">-->
      <!--                          <i class="mdi mdi-plus" style="font-size: 24px; color: #FFF"></i>-->
      <!--                      </button>-->
						<!--</div>-->
						<!--<div class="col-xxl-12 col-md-12 col-12 m-0 p-0" id="ctnAdjuntosPeticiones">-->
						    
						<!--</div>-->
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Registrar</button>
				</div>
			</form>
		</div>
	</div>
</div>


<!--Modal Aprobar Petición -->
<div class="modal fade zoomIn" id="registrarRequerimientoLicitacion" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleregistrarRequerimientoLicitacion" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-xl" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleaprobarPeticion">Registrar Requerimiento</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formRegistrarRequerimientoLicitacion" class="formulario form-steps" autocomplete="off" action="<?= $baseUrl ?>/registrar-requerimiento-licitacion-peticion" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="row">
					    <div class="step-arrow-nav mb-4">
                            <ul class="nav nav-pills custom-nav nav-justified" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" id="tabInformacionGeneralOC" data-bs-toggle="pill" data-bs-target="#tabcontentInformacionGeneralOC" type="button" role="tab" aria-controls="tabcontentInformacionGeneralOC" aria-selected="true" data-position="0">Información General</button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="tabInformacionProveedorOC" data-bs-toggle="pill" data-bs-target="#tabcontentInformacionProveedorOC" type="button" role="tab" aria-controls="tabcontentInformacionProveedorOC" aria-selected="false" data-position="1">Proveedor</button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="tabInformacionItemsOC" data-bs-toggle="pill" data-bs-target="#tabcontentInformacionItemsOC" type="button" role="tab" aria-controls="tabcontentInformacionItemsOC" aria-selected="false" data-position="2">Items</button>
                                </li>
                            </ul>
                        </div>
    
                        <div class="tab-content">
                            <div class="tab-pane fade active show" id="tabcontentInformacionGeneralOC" role="tabpanel" aria-labelledby="tabInformacionGeneralOC">
                                <div>
                                    <div class="row g-2 col-md-12 m-0 px-3">
                                        <div class="col-12 col-md-6">
                                            <div class="form-group">
                                                <label for="solicitante">Solicitante</label>
                                                <input type="text" class="form-control" id="solicitante" name="solicitante" value="<?= ucwords(mb_strtolower($nombres.' '.$apellidos)) ?>" placeholder="Solicitante" disabled>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <div class="form-group">
                                                <label for="matricula">Matricula</label>
                                                <input type="text" class="form-control" id="matricula" name="matricula" value="<?= $matriculaLog ?>" placeholder="Matricula" disabled>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4">
                                            <div class="form-group">
                                                <label for="conceptoOC">Concepto</label>
                                                <input type="text" class="form-control " id="conceptoOC" name="conceptoOC" placeholder="Concepto">
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4">
                                            <div class="formgroup">
                                                <label for="txtFechaPedidoOC">Fecha Pedido</label>
                                                <div class="col-auto">

                                                    <div class="input-group mb-2">
                                                        <div class="input-group-prepend">
                                                            <div class="input-group-text contenedorCalendario"><span class="mdi mdi-calendar-month"></span> <!--<img src="<?= $baseUrl ?>/public/images/iconoCalendario2.png" width="17.5" height="20"> <i class="far fa-calendar-alt"></i> --> </div>
                                                        </div>
                                                        <input type="date" class="form-control pull-right " id="txtFechaPedidoOC" name="txtFechaPedidoOC" min="<?= date("Y-m-d") ?>" value="<?= date("Y-m-d") ?>">
                                                    </div>
                                                </div>
                                                <!-- <input type="text" class="form-control pull-right " id="fechapedido" name="fechapedido" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask><i class="far fa-calendar-alt"></i> -->
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4">
                                            <div class="form-group">
                                                <label for="cboCompradorOC">Comprador</label>
                                                <select class="form-select" id="cboCompradorOC" name="cboCompradorOC">
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4">
                                            <div class="form-group">
                                                <label for="cboEnvioFacturaOC">Envío de Factura</label>
                                                <select class="form-select" id="cboEnvioFacturaOC" name="cboEnvioFacturaOC">
                                                    <option value="" selected>Seleccione una opción</option>
                                                    <option value="SI">SI</option>
                                                    <option value="NO">NO</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4">
                                            <div class="form-group">
                                                <label for="cboBudgetOC">Budget</label>
                                                <select class="form-select" id="cboBudgetOC" name="cboBudgetOC">
                                                    <option value="" selected>Seleccione una opción</option>
                                                    <option value="SI">SI</option>
                                                    <option value="NO">NO</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4">
                                            <div class="form-group">
                                                <label for="cboIGVOC">IGV</label>
                                                <select class="form-select" name="cboIGVOC" id="cboIGVOC">
                                                    <option value="Afecta" selected>Afecta</option>
                                                    <option value="Noafecta">No afecta</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <div class="form-group">
                                                <label for="cboCategoriaOC">Categoria</label>
                                                <select class="form-select" id="cboCategoriaOC" name="cboCategoriaOC">
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <div class="form-group">
                                                <label for="cboSubcategoriaOC">Subcategoria</label>
                                                <select class="form-select" id="cboSubcategoriaOC" name="cboSubcategoriaOC">
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <div class="form-group">
                                                <label for="cboDelegacionOC">CC - LN (Delegación)</label>
                                                <select class="form-select" id="cboDelegacionOC" name="cboDelegacionOC">
                                                </select>
                                                <input type="hidden" id="txtCCOC" name="txtCCOC">
                                                <input type="hidden" id="txtLNOC" name="txtLNOC">
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <div class="form-group ">
                                                <label for="cboSubareaOC">Subárea - Área - Dirección</label>
                                                <select class="form-select" id="cboSubareaOC" name="cboSubareaOC">
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-12 col-md-12">
                                            <div class="form-group">
                                                <label for="observaciones">Observaciones</label>
                                                <textarea class="form-control" id="observaciones" name="observaciones" placeholder="Ingresar..." rows="4"></textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="d-flex align-items-start gap-3 mt-4">
                                    <button type="button" class="btn btn-success btn-label right ms-auto nexttab nexttab" data-nexttab="tabInformacionProveedorOC"><i class="ri-arrow-right-line label-icon align-middle fs-16 ms-2"></i>Registrar Proveedor</button>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="tabcontentInformacionProveedorOC" role="tabpanel" aria-labelledby="tabInformacionProveedorOC">
                                <div>
                                    <div class="row g-2 col-md-12 m-0 px-3">
                                        <div class="col-12 col-md-4">
                                            <div class="form-group">
                                                <label for="cboProveedorOC">Proveedor</label>
                                                <select class="form-select" id="cboProveedorOC" name="cboProveedorOC">
                                                </select>
                                                <input type="hidden" id="txtProveedorNombreOC">
                                            </div>
                                        </div>
                                        <!--<div class="col-12 col-md-4">-->
                                        <!--    <div class="form-group">-->
                                        <!--        <label for="proovedor">Nombre Proveedor</label>-->
                                        <!--        <input type="text" class="form-control " id="proovedor_valor" name="proovedor_valor" placeholder="Digite nombre o Ruc">-->
                                        <!--    </div>-->
                                        <!--</div>-->
                                        <div class="col-12 col-md-4 mb-2">
                                            <div class="form-group">
                                                <label for="lblRUCOC">RUC</label>
                                                <input type="text" class="form-control" id="lblRUCOC" name="lblRUCOC" placeholder="RUC" disabled>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 mb-2">
                                            <div class="form-group">
                                                <label for="lblContactoOC">Contacto</label>
                                                <input type="text" class="form-control " id="lblContactoOC" name="lblContactoOC" placeholder="Contacto" disabled>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 mb-2">
                                            <div class="form-group">
                                                <label for="lblPaisOC">Pais</label>
                                                <input type="text" class="form-control " id="lblPaisOC" name="lblPaisOC" placeholder="Pais" disabled>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 mb-2">
                                            <div class="form-group">
                                                <label for="lblDepartamento">Departamento</label>
                                                <input type="text" class="form-control " id="lblDepartamento" name="lblDepartamento" placeholder="Departamento" disabled>
                                                
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 mb-2">
                                            <div class="form-group">
                                                <label for="lblProvincia">Provincia</label>
                                                <input type="text" class="form-control " id="lblProvincia" name="lblProvincia" placeholder="Provincia" disabled>
                                                
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 mb-2">
                                            <div class="form-group">
                                                <label for="lblDistritoOC">Distrito</label>
                                                <input type="text" class="form-control " id="lblDistritoOC" name="lblDistritoOC" placeholder="Distrito" disabled>
                                                
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 mb-2">
                                            <div class="form-group">
                                                <label for="lblDireccionOC">Dirección</label>
                                                <input type="text" class="form-control " id="lblDireccionOC" name="lblDireccionOC" placeholder="Dirección" disabled>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 mb-2">
                                            <div class="form-group">
                                                <label for="lblEmailOC">Email</label>
                                                <input type="text" class="form-control " id="lblEmailOC" name="lblEmailOC" placeholder="Correo" disabled>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 mb-2">
                                            <div class="form-group">
                                                <label for="lblTelefono01OC">Telefono 01</label>
                                                <input type="text" class="form-control " id="lblTelefono01OC" name="lblTelefono01OC" placeholder="Teléfono 01" disabled>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 mb-2">
                                            <div class="form-group">
                                                <label for="lblTelefono02OC">Telefono 02</label>
                                                <input type="text" class="form-control " id="lblTelefono02OC" name="lblTelefono02OC" placeholder="Teléfono 02" disabled>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 mb-2">
                                            <div class="form-group">
                                                <label for="cboFormaPagoOC">Forma de Pago</label>
                                                <select class="form-select" id="cboFormaPagoOC" name="cboFormaPagoOC">
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-12 mb-2">
                                            <div class="form-group tipologiaNuevaOc">
                                                <label for="cboMultiTipologiaOC">Tipo</label>
                                                <select class="form-select" id="cboMultiTipologiaOC" name="cboMultiTipologiaOC[]" multiple="multiple" disabled>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row g-2 col-md-12 m-0 px-3">
                                        <div class="col-12 col-md-6 mb-2">
                                            <div class="form-group">
                                                <label for="cboModalidadPagoOC">Modalidad de Pago</label>
                                                <select class="form-select " name="cboModalidadPagoOC" id="cboModalidadPagoOC">
                                                    
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6 mb-2">
                                            <div class="form-group">
                                                <label for="cboBancoOC">Banco</label>
                                                <select class="form-select" name="cboBancoOC" id="cboBancoOC">
                                                    
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 mb-2">
                                            <div class="form-group">
                                                <label for="cboMonedaOC">Moneda</label>
                                                <select class="form-select moneda-Tipo" name="cboMonedaOC" id="cboMonedaOC">
                                                    
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 mb-2">
                                            <div class="form-group">
                                                <label for="txtCuentaOC">Número de Cuenta:</label>
                                                <input type="text" class="form-control validanumericos" id="txtCuentaOC" placeholder="Número de Cuenta" name="txtCuentaOC">
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 mb-2">
                                            <div class="form-group">
                                                <label for="txtCCIOC">CCI:</label>
                                                <input type="text" class="form-control validanumericos" id="txtCCIOC" placeholder="Número de Cuenta" name="txtCCIOC">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row g-2 col-md-12 m-0 px-3">
                                        <div class="col-12 col-md-6 mb-2">
                                            <div class="form-group">
                                                <label for="txtCuentaDetraccionOC">Cuenta Detracción:</label>
                                                <input type="text" class="form-control validanumericos" id="txtCuentaDetraccionOC" placeholder="Cuenta Detracción" name="txtCuentaDetraccionOC" disabled>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6 mb-2">
                                            <div class="form-group">
                                                <label for="cboCodigoDetraccionOC">Código Detracción</label>
                                                <select class="form-select" name="cboCodigoDetraccionOC" id="cboCodigoDetraccionOC" disabled>
                                                    
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="d-flex align-items-start gap-3 mt-4">
                                    <button type="button" class="btn btn-light btn-label previestab" data-previous="tabInformacionGeneralOC"><i class="ri-arrow-left-line label-icon align-middle fs-16 me-2"></i> Regresar a información general</button>
                                    <button type="button" class="btn btn-success btn-label right ms-auto nexttab nexttab" data-nexttab="tabInformacionItemsOC"><i class="ri-arrow-right-line label-icon align-middle fs-16 ms-2"></i>Registrar Items</button>
                                </div>
                            </div>
                            <!-- end tab pane -->
                            <div class="tab-pane fade" id="tabcontentInformacionItemsOC" role="tabpanel" aria-labelledby="tabInformacionItemsOC">
                                <div>
                                    <div class="row g-2 col-md-12 m-0 px-3">
                                        <div class="col-12 m-0 p-0 p-3 border-sistema-2px" style="border-radius: 10px;">
                							<div class="form-group row">
                								<div class="col-4">
                                                    <div class="form-group">
                                                        <label for="descripcionItem">Descripción</label>
                                                        <input type="text" class="form-control validanumericos" id="descripcionItem" name="descripcionItem" placeholder="Descripción">
                                                    </div>
                                                </div>
                                                <div class="col-3">
                                                    <div class="form-group">
                                                        <label for="cantidadItem">Cantidad</label>
                                                        <input type="text" class="form-control" id="cantidadItem" name="cantidadItem" placeholder="Cantidad" onkeypress="return validarNumerosEnteros(event, this);">
                                                    </div>
                                                </div>
                                                <div class="col-3">
                                                    <div class="form-group">
                                                        <label for="precioItem">Precio Unitario</label>
                                                        <input type="text" class="form-control" id="precioItem" name="precioItem" placeholder="Precio" onkeypress="return validarNumerosDecimales(event, this);">
                                                    </div>
                                                </div>
                								<div class="col-2 d-flex justify-content-end align-items-center">
                            					    <button type="button" onclick="agregarItemOC();" class="btn bg-success px-2 py-1 ms-2 d-flex justify-content-center align-items-center color-white" >
                                                        <i class="mdi mdi-plus" style="font-size: 24px; color: #FFF"></i> Agregar
                                                    </button>
                            					</div>
                							</div>
                                        </div>
                                        <div class="col-12">
                                            <span class="respuesta"></span>
                                            <div class="table-responsive">
                                                <div class="row p-3 m-0 d-flex bg-sistema" style="border-radius: 10px;">
                                                    <div class="col-6 m-0 p-0">
                                                        <h5 class="m-0 color-white">Descripción</h5>
                                                    </div>
                                                    <div class="col-1 m-0 p-0">
                                                        <h5 class="m-0 color-white">Cantidad</h5>
                                                    </div>
                                                    <div class="col-2 m-0 p-0">
                                                        <h5 class="m-0 color-white">Precio Unitario</h5>
                                                    </div>
                                                    <div class="col-2 m-0 p-0">
                                                        <h5 class="m-0 color-white">Precio Total</h5>
                                                    </div>
                                                    <div class="col-1 m-0 p-0">
                                                        <h5 class="m-0 color-white">Acciones</h5>
                                                    </div>
                                                </div>
                                                <div class="row p-0 py-3 m-0 d-flex" id="ctnDetalleItemOC">
                                                    
                                                </div>
                                                <div class="row p-3 m-0 d-flex">
                                                    <div class="col-9 m-0 p-0 px-3 d-flex align-items-center justify-content-end">
                                                        <h5 class="m-0 color-sistema">Subtotal</h5>
                                                    </div>
                                                    <div class="col-3 m-0 p-0">
                                                        <div class="input-group">
                                                            <span class="input-group-text lblSimboloMoneda"></span>
                                                            <input type="text" class="form-control" id="subtotaldetalleoc" name="subtotaldetalleoc" readonly>
                                                        </div>
                                                    </div>
                                                    <div class="col-9 m-0 p-0 px-3 d-flex align-items-center justify-content-end">
                                                        <h5 class="m-0 color-sistema">IGV</h5>
                                                    </div>
                                                    <div class="col-3 m-0 p-0">
                                                        <div class="input-group">
                                                            <span class="input-group-text lblSimboloMoneda"></span>
                                                            <input type="text" class="form-control" id="igvdetalleoc" name="igvdetalleoc" readonly>
                                                        </div>
                                                    </div>
                                                    <div class="col-9 m-0 p-0 px-3 d-flex align-items-center justify-content-end">
                                                        <h5 class="m-0 color-sistema">Total</h5>
                                                    </div>
                                                    <div class="col-3 m-0 p-0">
                                                        <div class="input-group">
                                                            <span class="input-group-text lblSimboloMoneda"></span>
                                                            <input type="text" class="form-control" id="totaldetalleoc" name="totaldetalleoc" readonly>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="d-flex align-items-start gap-3 mt-4">
                                    <button type="button" class="btn btn-light btn-label previestab" data-previous="tabInformacionProveedorOC"><i class="ri-arrow-left-line label-icon align-middle fs-16 me-2"></i> Regresar a información de proveedor</button>
                                    <button type="submit" class="btn btn-success btn-label right ms-auto"><i class="mdi mdi-content-save label-icon align-middle fs-16 ms-2"></i>Guardar</button>
                                </div>
                            </div>
                            <!-- end tab pane -->
                        </div>
                        <!-- end tab content -->
					</div>
				</div>
			</form>
		</div>
	</div>
</div>

<?= $this->section('js'); ?>
<script>
	$(function () {
		pondRegistrarPeticion = FilePond.create(
            document.querySelector("#txtAdjunto_poc"), {
                labelIdle: 'Arrastra y suelta los adjuntos asociados a la petición <span class="filepond--label-action">explora</span>',
                allowMultiple: true,
                instantUpload: false,
                allowProcess: false,
                // acceptedFileTypes: [
                //   'application/vnd.ms-outlook',   // Common MIME type for .msg files
                //   'application/octet-stream',       // Generic MIME type for binary files
                //   'application/x-msg'               // Alternative MIME type
                // ]
            }
        );
	});
</script>
<?php $this->endSection(); ?>

<?php $this->endSection(); ?>