<?php
namespace App\Models;
use CodeIgniter\Model;

class OrdenCompraModel extends Model
{
    protected $table      = 'ordencompra';
    protected $primaryKey = 'IDOrdenCompra';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['Concepto', 'IDProveedor', 'FormaPago', 'Observacion', 'Subtotal', 'PorcentajeIGV', 'IGV', 'Total', 'FechaPedido', 'CondicionesIGV', 'ModalidadPago', 'Banco', 'CuentaBancaria', 'CuentaInterbancaria', 'TipoMoneda', 'MontoCambio', 'Budget', 'UsuarioSolicitante', 'IDDelegacion', 'IDSubarea', 'CC', 'LN', 'UsuarioComprador', 'CompraCentralizada', 'Dimension', 'EnvioFactura', 'IDSubcategoria', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    // public function obtenerOrdenCompraTotal($idOrdenCompra)
    // {
    //     $this->select('ordencompra.IDOrdenCompra,
    //         CONCAT(US.Nombres," ",US.Apellidos) AS "UsuarioSolicitante",
    //         ordencompra.Concepto,
    //         proveedor.Nombre AS "Proveedor",
    //         ordencompra.Total,
    //         ordencompra.Observacion,
    //         ordencompra.FechaPedido,
    //         ordencompra.Budget,
    //         ordencompra.ModalidadPago,
    //         ordencompra.CompraCentralizada,
    //         ordencompra.TipoMoneda,
    //         ordencompra.MontoCambio,
    //         ordencompra.FormaPago,
    //         ordencompra.IDDelegacion,
    //         ordencompra.IDSubarea,
    //         dbMASTERUSUARIO.estructura_subarea.IDArea,
    //         dbMASTERUSUARIO.estructura_area.IDDireccion,
    //         ordencompra.CC,
    //         ordencompra.LN,
    //         ordencompra.Estado,
    //         US.Correo AS "CorreoSolicitante",
    //         ordencompra_responsables.UsuarioFirma1,
    //         CONCAT(U1.Nombres," ",U1.Apellidos) AS "UsuarioAprobador01",
    //         U1.Correo AS "CorreoAprobador01",
    //         U1.Matricula AS "MatriculaAprobador01",
    //         U1.IdUsuario AS "IDAprobador01",
    //         ordencompra_responsables.UsuarioFirma2,
    //         CONCAT(U2.Nombres," ",U2.Apellidos) AS "UsuarioAprobador02",
    //         U2.Correo AS "CorreoAprobador02",
    //         U2.Matricula AS "MatriculaAprobador02",
    //         ordencompra_responsables.UsuarioFirma3,
    //         CONCAT(U3.Nombres," ",U3.Apellidos) AS "UsuarioAprobador03",
    //         U3.Correo AS "CorreoAprobador03",
    //         U3.Matricula AS "MatriculaAprobador03"');
        
    //     $this->join('dbMASTERUSUARIO.tblusuario US', 'ordencompra.UsuarioCrea = US.IdUsuario', 'left');
    //     $this->join('proveedor', 'ordencompra.IDProveedor = proveedor.IDProveedor', 'left');
    //     $this->join('dbMASTERUSUARIO.estructura_delegacion', 'ordencompra.IDDelegacion = dbMASTERUSUARIO.estructura_delegacion.IDDelegacion', 'left');
    //     $this->join('dbMASTERUSUARIO.estructura_subarea', 'ordencompra.IDSubarea = dbMASTERUSUARIO.estructura_subarea.IDSubarea', 'left');
    //     $this->join('dbMASTERUSUARIO.estructura_area', 'dbMASTERUSUARIO.estructura_subarea.IDArea = dbMASTERUSUARIO.estructura_area.IDArea', 'left');
    //     $this->join('dbMASTERUSUARIO.estructura_direccion', 'dbMASTERUSUARIO.estructura_area.IDDireccion = dbMASTERUSUARIO.estructura_direccion.IDDireccion', 'left');
    //     $this->join('ordencompra_responsables', 'ordencompra.IDOrdenCompra = ordencompra_responsables.IDOrdenCompra', 'left');
    //     $this->join('dbMASTERUSUARIO.tblusuario U1', 'ordencompra_responsables.UsuarioFirma1 = U1.IdUsuario', 'left');
    //     $this->join('dbMASTERUSUARIO.tblusuario U2', 'ordencompra_responsables.UsuarioFirma2 = U2.IdUsuario', 'left');
    //     $this->join('dbMASTERUSUARIO.tblusuario U3', 'ordencompra_responsables.UsuarioFirma3 = U3.IdUsuario', 'left');
    //     $this->where('ordencompra.IDOrdenCompra', $idOrdenCompra);
        
    //     $datos = $this->first();
    //     return $datos;
    // }
    
    public function obtenerOrdenCompra($idOrdenCompra)
    {
        $this->select('ordencompra.IDOrdenCompra,
            ordencompra.Concepto,
            ordencompra.IDProveedor,
            proveedor.Nombre AS "Proveedor",
            proveedor.RUC,
            proveedor.Contacto,
            proveedor.CuentaDetraccion,
            proveedor.IDDistrito,
            proveedor.Direccion,
            proveedor.Email,
            proveedor.Telefono01,
            proveedor.Telefono02,
            ordencompra.Subtotal,
            ordencompra.PorcentajeIGV,
            ordencompra.IGV,
            ordencompra.Total,
            ordencompra.UsuarioComprador,
            ordencompra.Observacion,
            ordencompra.FechaPedido,
            ordencompra.Budget,
            ordencompra.CondicionesIGV,
            ordencompra.ModalidadPago,
            ordencompra.Banco,
            ordencompra.CuentaBancaria,
            ordencompra.CuentaInterbancaria,
            ordencompra.CompraCentralizada,
            ordencompra.TipoMoneda,
            ordencompra.MontoCambio,
            ordencompra.FormaPago,
            ordencompra.EnvioFactura,
            ordencompra.UsuarioSolicitante,
            ordencompra.IDDelegacion,
            ordencompra.IDSubarea,
            ordencompra.IDSubcategoria,
            cuentacontable_subcategorias.Subcategoria,
            cuentacontable_subcategorias.IDCategoriaCC,
            cuentacontable_categorias.Categoria,
            cuentacontable_categorias.IDCuentaContable,
            cuentacontable.CodigoCuentaContable,
            cuentacontable.CuentaContable,
            ordencompra.CC,
            ordencompra.LN,
            ordencompra.Estado,
            ordencompra.UsuarioCrea,
            ordencompra_responsables.UsuarioFirma1,
            ordencompra_responsables.UsuarioFirma2,
            ordencompra_responsables.UsuarioFirma3,
            comprobantes_pago.NroFactura,
            comprobantes_pago.FechaEmisionFactura,
            ordencompra.FechaCrea,
            formaspago.FormaPago as "descripcionFormaPago",
            formaspago.DiasPago,
            modalidadpago.ModalidadPago as "descripcionModalidadPago",
            bancos.Nombre as "descripcionBanco"');
        
        $this->join('comprobantes_pago', 'ordencompra.IDOrdenCompra = comprobantes_pago.IDOrigen AND comprobantes_pago.Origen = "OC" AND comprobantes_pago.TipoComprobante = "1"', 'left');
        $this->join('proveedor', 'ordencompra.IDProveedor = proveedor.IDProveedor', 'left');
        $this->join('cuentacontable_subcategorias', 'ordencompra.IDSubcategoria = cuentacontable_subcategorias.IDSubcategoriaCC', 'left');
        $this->join('cuentacontable_categorias', 'cuentacontable_subcategorias.IDCategoriaCC = cuentacontable_categorias.IDCategoriaCC', 'left');
        $this->join('cuentacontable', 'cuentacontable_categorias.IDCuentaContable = cuentacontable.IDCuentaContable', 'left');
        $this->join('ordencompra_responsables', 'ordencompra.IDOrdenCompra = ordencompra_responsables.IDOrdenCompra', 'left');
        $this->join('formaspago', 'ordencompra.FormaPago = formaspago.Codigo', 'left');
        $this->join('modalidadpago', 'ordencompra.ModalidadPago = modalidadpago.Codigo', 'left');
        $this->join('bancos', 'ordencompra.Banco = bancos.CodigoInterno', 'left');
        $this->where('ordencompra.IDOrdenCompra', $idOrdenCompra);
        
        $datos = $this->first();
        return $datos;
    }
    
    // public function listaGeneralOrdenCompra($get, $adicionales) 
    // {
    //     /*
    //     * ----------------------------
    //     * VALORES ESTÁTICOS A UTILIZAR
    //     * ----------------------------
    //     */
    
    //     // $this->globales = new Globales();
        
    //     $fields = array(
    //         0 => 'ordencompra.IDOrdenCompra', 
    //         1 => 'ordencompra.FechaCrea', 
    //         2 => 'ordencompra.Concepto', 
    //         3 => 'proveedor.Nombre', 
    //         5 => 'ordencompra.CC', 
    //         6 => 'ordencompra.Total', 
    //         7 => 'ordencompra.Estado', 
    //         9 => 'cuentacontable_subcategorias.Subcategoria');
        
    //     /*
    //     * ----------------------------
    //     * ARMADO DE VALORES QUERY
    //     * ----------------------------
    //     */
        
    //     $this->select('ordencompra.IDOrdenCompra AS oc,
    //         ordencompra.FechaCrea AS emision,
    //         ordencompra.UsuarioCrea,
    //         ordencompra.UsuarioComprador,
    //         ordencompra.IDDelegacion,
    //         ordencompra.CC AS cc,
    //         ordencompra.Concepto AS concepto,
    //         proveedor.Nombre AS proveedor,
    //         ordencompra.TipoMoneda,
    //         ordencompra.UsuarioSolicitante,
    //         ordencompra.MontoCambio,
    //         ordencompra.Total,
    //         ordencompra.Estado,
    //         cuentacontable_subcategorias.Subcategoria AS categoria');
            
    //     $this->join('ordencompra_responsables', 'ordencompra.IDOrdenCompra = ordencompra_responsables.IDOrdenCompra', 'left');
    //     $this->join('proveedor', 'ordencompra.IDProveedor = proveedor.IDProveedor', 'left');
    //     $this->join('cuentacontable_subcategorias', 'ordencompra.IDSubcategoria = cuentacontable_subcategorias.IDSubcategoriaCC', 'left');
    //     $this->join('cuentacontable_categorias', 'cuentacontable_subcategorias.IDCategoriaCC = cuentacontable_categorias.IDCategoriaCC', 'left');
        
    //     /*
    //     * ----------------------------
    //     * ARMADO DE CONDICIONES QUERY
    //     * ----------------------------
    //     */
        
    //     if ($get['search']['value'] != "") 
    //     {
    //         $this->groupStart(); // Inicia un grupo de condiciones
            
    //         foreach ($get['columns'] as $k => $column) 
    //         {
    //             if(array_key_exists($k, $fields))
    //             {
    //                 $this->orLike($fields[$k], $get['search']['value']);
    //             }
    //         }
            
    //         $this->groupEnd(); // Finaliza el grupo de condiciones
    //     }
        
    //     if(isset($adicionales['Vista']) && $adicionales['Vista'] == "Pendientes")
    //     {
    //         if(in_array($adicionales['IDPerfil'], array(1,2)))
    //         {
    //             //SI USUARIO LOGUEADO ES PERFIL 1 O 2 (ADMIN O COMPRAS), NO HAY LIMITE EN OC, SOLO POR EL ESTADO
    //             $this->whereNotIn('ordencompra.Estado', array("Aprobado", "Anulado", "Rechazado", "Cancelado"));
    //         }
    //         else if(in_array($adicionales['IDPerfil'], array(4)))
    //         {
    //             //SI USUARIO LOGUEADO ES PERFIL 4, SOLO PODRÁ VER LAS OC QUE TIENE PENDIENTE POR FIRMAR
    //             $this->groupStart(); // Inicia un grupo de condiciones
                
    //                 $this->groupStart(); // Inicia un grupo de condiciones
    //                     $this->where("ordencompra.Estado", "PendienteFirma1");
    //                     $this->where('ordencompra_responsables.UsuarioFirma1', $adicionales['IDUsuario']);
    //                 $this->groupEnd();
                    
    //                 $this->orGroupStart(); // Inicia un grupo de condiciones
    //                     $this->where("ordencompra.Estado", "PendienteFirma2");
    //                     $this->where('ordencompra_responsables.UsuarioFirma2', $adicionales['IDUsuario']);
    //                 $this->groupEnd();
                    
    //                 $this->orGroupStart(); // Inicia un grupo de condiciones
    //                     $this->where("ordencompra.Estado", "PendienteFirma3");
    //                     $this->where('ordencompra_responsables.UsuarioFirma3', $adicionales['IDUsuario']);
    //                 $this->groupEnd();
                    
    //             $this->groupEnd(); // Finaliza el grupo de condiciones
    //         }
    //         else
    //         {
    //             //SI USUARIO LOGUEADO ES PERFIL DISTINTO A 1 Y 2 y 4, SOLO PODRÁ VER SUS OC CREADAS
    //             $this->where("ordencompra.UsuarioCrea", $adicionales['IDUsuario']);
    //             $this->whereNotIn('ordencompra.Estado', array("Aprobado", "Anulado", "Rechazado", "Cancelado"));
    //         }
    //     }
        
    //     if(isset($adicionales['Vista']) && $adicionales['Vista'] == "Historico")
    //     {
    //         if(in_array($adicionales['IDPerfil'], array(1,2)))
    //         {
    //             $this->whereIn('ordencompra.Estado', array("Aprobado", "Anulado", "Rechazado", "Cancelado"));
    //         }
    //         else if(in_array($adicionales['IDPerfil'], array(4)))
    //         {
    //             //SI USUARIO LOGUEADO ES PERFIL 4, SOLO PODRÁ VER LAS OC QUE LE TOCABA FIRMAR
    //             $this->whereIn('ordencompra.Estado', array("Aprobado", "Anulado", "Rechazado"));
    //             $this->groupStart(); // Inicia un grupo de condiciones
                
    //                 $this->where('ordencompra_responsables.UsuarioFirma1', $adicionales['IDUsuario']);
    //                 $this->orWhere('ordencompra_responsables.UsuarioFirma2', $adicionales['IDUsuario']);
    //                 $this->orWhere('ordencompra_responsables.UsuarioFirma3', $adicionales['IDUsuario']);
                        
    //             $this->groupEnd(); // Finaliza el grupo de condiciones
    //         }
    //         else
    //         {
    //             $this->where("ordencompra.UsuarioCrea", $adicionales['IDUsuario']);
    //             $this->whereIn('ordencompra.Estado', array("Aprobado", "Anulado", "Rechazado", "Cancelado"));
    //         }
    //     }
        
        
    //     /*
    //     * ----------------------------
    //     * ORDENAMIENTO DE QUERY
    //     * ----------------------------
    //     */
        
    //     foreach ($get['order'] as $order) {
    //         if(array_key_exists($order['column'], $fields))
    //         {
    //             $this->orderBy($fields[$order['column']], $order['dir']);
    //         }
    //     }
        
    //     /*
    //     * ----------------------------
    //     * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
    //     * ----------------------------
    //     */
        
    //     /* Antes de Codeiginiter 4.5.4*/
    //     // $this->limit($get['length'], $get['start']);
        
    //     /*
    //     * ----------------------------
    //     * EJECUTAR CONSULTA, LIMITAR CANTIDAD DE RESULTADOS DE QUERY Y DEVOLVER VALORES
    //     * ----------------------------
    //     */
        
    //     /* Antes de Codeiginiter 4.5.4*/
    //     // $this->get();
    //     // return $this->getLastQuery();
        
    //     // $result = $this->get()->getResultArray();
    //     // return $result;
        
    //     /* Despues de Codeiginiter 4.5.4*/
    //     $result = $this->findAll($get['length'], $get['start']);
        
    //     // echo $this->getLastQuery();
    //     // exit;
        
    //     return $result;
    // }


    public function listaGeneralOrdenCompra($get, $adicionales) 
    {
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
    
        // $this->globales = new Globales();
        
        $fields = array(
            0 => 'ordencompra.IDOrdenCompra', 
            1 => 'ordencompra.FechaCrea', 
            2 => 'ordencompra.Concepto', 
            3 => 'proveedor.Nombre', 
            5 => 'ordencompra.CC', 
            6 => 'ordencompra.Total', 
            7 => 'ordencompra.Estado', 
            9 => 'cuentacontable_subcategorias.Subcategoria');
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS total");
        $totalQuery = $this->get();
        $totalRecords = $totalQuery->getRow()->total;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $this->select('ordencompra.IDOrdenCompra AS oc,
            ordencompra.FechaCrea AS emision,
            ordencompra.UsuarioCrea,
            ordencompra.UsuarioComprador,
            ordencompra.IDDelegacion,
            ordencompra.CC AS cc,
            ordencompra.Concepto AS concepto,
            proveedor.Nombre AS proveedor,
            ordencompra.TipoMoneda,
            ordencompra.UsuarioSolicitante,
            ordencompra.MontoCambio,
            ordencompra.Total,
            ordencompra.Estado,
            cuentacontable_subcategorias.Subcategoria AS categoria');
            
        $this->join('ordencompra_responsables', 'ordencompra.IDOrdenCompra = ordencompra_responsables.IDOrdenCompra', 'left');
        $this->join('proveedor', 'ordencompra.IDProveedor = proveedor.IDProveedor', 'left');
        $this->join('cuentacontable_subcategorias', 'ordencompra.IDSubcategoria = cuentacontable_subcategorias.IDSubcategoriaCC', 'left');
        $this->join('cuentacontable_categorias', 'cuentacontable_subcategorias.IDCategoriaCC = cuentacontable_categorias.IDCategoriaCC', 'left');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if(isset($adicionales['Vista']) && $adicionales['Vista'] == "Pendientes")
        {
            if(in_array($adicionales['IDPerfil'], array(1,2,6)))
            {
                //SI USUARIO LOGUEADO ES PERFIL 1 O 2 (ADMIN O COMPRAS), NO HAY LIMITE EN OC, SOLO POR EL ESTADO
                $this->whereNotIn('ordencompra.Estado', array("Aprobado", "Anulado", "Rechazado", "Cancelado"));
            }
            else if(in_array($adicionales['IDPerfil'], array(4)))
            {
                //SI USUARIO LOGUEADO ES PERFIL 4, SOLO PODRÁ VER LAS OC QUE TIENE PENDIENTE POR FIRMAR
                $this->groupStart(); // Inicia un grupo de condiciones
                
                    $this->groupStart(); // Inicia un grupo de condiciones
                        $this->where("ordencompra.Estado", "PendienteFirma1");
                        $this->where('ordencompra_responsables.UsuarioFirma1', $adicionales['IDUsuario']);
                    $this->groupEnd();
                    
                    $this->orGroupStart(); // Inicia un grupo de condiciones
                        $this->where("ordencompra.Estado", "PendienteFirma2");
                        $this->where('ordencompra_responsables.UsuarioFirma2', $adicionales['IDUsuario']);
                    $this->groupEnd();
                    
                    $this->orGroupStart(); // Inicia un grupo de condiciones
                        $this->where("ordencompra.Estado", "PendienteFirma3");
                        $this->where('ordencompra_responsables.UsuarioFirma3', $adicionales['IDUsuario']);
                    $this->groupEnd();
                    
                $this->groupEnd(); // Finaliza el grupo de condiciones
            }
            else
            {
                //SI USUARIO LOGUEADO ES PERFIL DISTINTO A 1 Y 2 y 4, SOLO PODRÁ VER SUS OC CREADAS
                $this->where("ordencompra.UsuarioCrea", $adicionales['IDUsuario']);
                $this->whereNotIn('ordencompra.Estado', array("Aprobado", "Anulado", "Rechazado", "Cancelado"));
            }
        }
        
        if(isset($adicionales['Vista']) && $adicionales['Vista'] == "Historico")
        {
            if(in_array($adicionales['IDPerfil'], array(1,2,6)))
            {
                $this->whereIn('ordencompra.Estado', array("Aprobado", "Anulado", "Rechazado", "Cancelado"));
            }
            else if(in_array($adicionales['IDPerfil'], array(4)))
            {
                //SI USUARIO LOGUEADO ES PERFIL 4, SOLO PODRÁ VER LAS OC QUE LE TOCABA FIRMAR
                $this->whereIn('ordencompra.Estado', array("Aprobado", "Anulado", "Rechazado"));
                $this->groupStart(); // Inicia un grupo de condiciones
                
                    $this->where('ordencompra_responsables.UsuarioFirma1', $adicionales['IDUsuario']);
                    $this->orWhere('ordencompra_responsables.UsuarioFirma2', $adicionales['IDUsuario']);
                    $this->orWhere('ordencompra_responsables.UsuarioFirma3', $adicionales['IDUsuario']);
                        
                $this->groupEnd(); // Finaliza el grupo de condiciones
            }
            else
            {
                $this->where("ordencompra.UsuarioCrea", $adicionales['IDUsuario']);
                $this->whereIn('ordencompra.Estado', array("Aprobado", "Anulado", "Rechazado", "Cancelado"));
            }
        }
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
            
        }
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS FILTRADOS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS filtered");
        $filteredQuery = $this->get();
        if ($filteredQuery === false) {
            // echo $this->getLastQuery();
            // return [];
            $filteredRecords = $totalRecords;
        }
        $filteredRecords = $filteredQuery->getRow()->filtered;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY (NUEVAMENTE PARA ENVIAR LA DATA)
        * ----------------------------
        */
        
        $this->select('ordencompra.IDOrdenCompra AS oc,
            ordencompra.FechaCrea AS emision,
            ordencompra.UsuarioCrea,
            ordencompra.UsuarioComprador,
            ordencompra.IDDelegacion,
            ordencompra.CC AS cc,
            ordencompra.Concepto AS concepto,
            proveedor.Nombre AS proveedor,
            ordencompra.TipoMoneda,
            ordencompra.UsuarioSolicitante,
            ordencompra.MontoCambio,
            ordencompra.Total,
            ordencompra.Estado,
            cuentacontable_subcategorias.Subcategoria AS categoria');
            
        $this->join('ordencompra_responsables', 'ordencompra.IDOrdenCompra = ordencompra_responsables.IDOrdenCompra', 'left');
        $this->join('proveedor', 'ordencompra.IDProveedor = proveedor.IDProveedor', 'left');
        $this->join('cuentacontable_subcategorias', 'ordencompra.IDSubcategoria = cuentacontable_subcategorias.IDSubcategoriaCC', 'left');
        $this->join('cuentacontable_categorias', 'cuentacontable_subcategorias.IDCategoriaCC = cuentacontable_categorias.IDCategoriaCC', 'left');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if(isset($adicionales['Vista']) && $adicionales['Vista'] == "Pendientes")
        {
            if(in_array($adicionales['IDPerfil'], array(1,2)))
            {
                //SI USUARIO LOGUEADO ES PERFIL 1 O 2 (ADMIN O COMPRAS), NO HAY LIMITE EN OC, SOLO POR EL ESTADO
                $this->whereNotIn('ordencompra.Estado', array("Aprobado", "Anulado", "Rechazado", "Cancelado"));
            }
            else if(in_array($adicionales['IDPerfil'], array(4)))
            {
                //SI USUARIO LOGUEADO ES PERFIL 4, SOLO PODRÁ VER LAS OC QUE TIENE PENDIENTE POR FIRMAR
                $this->groupStart(); // Inicia un grupo de condiciones
                
                    $this->groupStart(); // Inicia un grupo de condiciones
                        $this->where("ordencompra.Estado", "PendienteFirma1");
                        $this->where('ordencompra_responsables.UsuarioFirma1', $adicionales['IDUsuario']);
                    $this->groupEnd();
                    
                    $this->orGroupStart(); // Inicia un grupo de condiciones
                        $this->where("ordencompra.Estado", "PendienteFirma2");
                        $this->where('ordencompra_responsables.UsuarioFirma2', $adicionales['IDUsuario']);
                    $this->groupEnd();
                    
                    $this->orGroupStart(); // Inicia un grupo de condiciones
                        $this->where("ordencompra.Estado", "PendienteFirma3");
                        $this->where('ordencompra_responsables.UsuarioFirma3', $adicionales['IDUsuario']);
                    $this->groupEnd();
                    
                $this->groupEnd(); // Finaliza el grupo de condiciones
            }
            else
            {
                //SI USUARIO LOGUEADO ES PERFIL DISTINTO A 1 Y 2 y 4, SOLO PODRÁ VER SUS OC CREADAS
                $this->where("ordencompra.UsuarioCrea", $adicionales['IDUsuario']);
                $this->whereNotIn('ordencompra.Estado', array("Aprobado", "Anulado", "Rechazado", "Cancelado"));
            }
        }
        
        if(isset($adicionales['Vista']) && $adicionales['Vista'] == "Historico")
        {
            if(in_array($adicionales['IDPerfil'], array(1,2,6)))
            {
                $this->whereIn('ordencompra.Estado', array("Aprobado", "Anulado", "Rechazado", "Cancelado"));
            }
            else if(in_array($adicionales['IDPerfil'], array(4)))
            {
                //SI USUARIO LOGUEADO ES PERFIL 4, SOLO PODRÁ VER LAS OC QUE LE TOCABA FIRMAR
                $this->whereIn('ordencompra.Estado', array("Aprobado", "Anulado", "Rechazado"));
                $this->groupStart(); // Inicia un grupo de condiciones
                
                    $this->where('ordencompra_responsables.UsuarioFirma1', $adicionales['IDUsuario']);
                    $this->orWhere('ordencompra_responsables.UsuarioFirma2', $adicionales['IDUsuario']);
                    $this->orWhere('ordencompra_responsables.UsuarioFirma3', $adicionales['IDUsuario']);
                        
                $this->groupEnd(); // Finaliza el grupo de condiciones
            }
            else
            {
                $this->where("ordencompra.UsuarioCrea", $adicionales['IDUsuario']);
                $this->whereIn('ordencompra.Estado', array("Aprobado", "Anulado", "Rechazado", "Cancelado"));
            }
        }
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
            
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $this->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->limit($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA, LIMITAR CANTIDAD DE RESULTADOS DE QUERY Y DEVOLVER VALORES
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->get();
        // return $this->getLastQuery();
        
        // $result = $this->get()->getResultArray();
        // return $result;
        
        /* Despues de Codeiginiter 4.5.4*/
        $result = $this->findAll($get['length'], $get['start']);
        
        // echo $this->getLastQuery();
        // exit;
        
        // return $result;
        
        /*
        * ----------------------------
        * DEVOLVER RESULTADOS Y LOS DATOS DE PAGINACIÓN
        * ----------------------------
        */
        
        return [
            'draw' => $get['draw'], // Número de la petición para sincronizar
            'recordsTotal' => $totalRecords, // Total de registros sin filtrar
            'recordsFiltered' => $filteredRecords, // Total de registros después de aplicar filtros
            'data' => $result // Los datos actuales para mostrar
        ];
    }

    // public function obtenerCantidadOrdenCompra($array)
    // {
    //     $this->select('ordencompra.IDOrdenCompra');
    //     $this->join('ordencompra_responsables', 'ordencompra.IDOrdenCompra = ordencompra_responsables.IDOrdenCompra', 'left');
        
    //     if(!empty($array))
    //     {
    //         if(isset($array['idperfil']) && !in_array($array['idperfil'], array(1,2)))
    //         {
    //             //OBTENER EL PERFIL QUE EVALUE LOS RESULTADOS POR RESPONSABLE
    //             if($array['idperfil'] == 4 && isset($array['responsable']) && $array['responsable'] != '')
    //             {
    //                 $this->groupStart(); // Inicia un grupo de condiciones
    //                     $this->orWhere("ordencompra_responsables.UsuarioFirma1", $array['responsable']);
    //                     $this->orWhere("ordencompra_responsables.UsuarioFirma2", $array['responsable']);
    //                     $this->orWhere("ordencompra_responsables.UsuarioFirma3", $array['responsable']);
    //                 $this->groupEnd(); // Finaliza el grupo de condiciones
    //             }
    //             else if(isset($array['solicitante']) && $array['solicitante'] != '')
    //             {
    //                 $this->where("ordencompra.UsuarioCrea", $array['solicitante']);
    //             }
    //         }
            
    //         if(isset($array['estado']) && $array['estado'] != '')
    //         {
    //             $this->where("ordencompra.Estado", $array['estado']);
    //         }
    //     }
        
    //     $datos = $this->findAll();
    //     // echo $this->getLastQuery();
    //     // exit;
    //     return $datos;
    // }
    
    public function obtenerCantidadOrdenCompra($array)
    {
        $this->select('ordencompra.Estado, COUNT(*) AS "CantidadEstado"');
        $this->join('ordencompra_responsables', 'ordencompra.IDOrdenCompra = ordencompra_responsables.IDOrdenCompra', 'left');
        
        if(!empty($array))
        {
            if(isset($array['idperfil']) && !in_array($array['idperfil'], array(1,2,6)))
            {
                //OBTENER EL PERFIL QUE EVALUE LOS RESULTADOS POR RESPONSABLE
                if($array['idperfil'] == 4 && isset($array['responsable']) && $array['responsable'] != '')
                {
                    //SI USUARIO LOGUEADO ES PERFIL 4, SE CALCULA LOS PORCENTAJES DE ACUERDO A LO QUE TIENE PENDIENTE POR FIRMAR
                    $this->groupStart(); // Inicia un grupo de condiciones
                    
                        $this->groupStart(); // Inicia un grupo de condiciones
                            $this->where("ordencompra.Estado", "PendienteFirma1");
                            $this->where('ordencompra_responsables.UsuarioFirma1', $array['responsable']);
                        $this->groupEnd();
                        
                        $this->orGroupStart(); // Inicia un grupo de condiciones
                            $this->where("ordencompra.Estado", "PendienteFirma2");
                            $this->where('ordencompra_responsables.UsuarioFirma2', $array['responsable']);
                        $this->groupEnd();
                        
                        $this->orGroupStart(); // Inicia un grupo de condiciones
                            $this->where("ordencompra.Estado", "PendienteFirma3");
                            $this->where('ordencompra_responsables.UsuarioFirma3', $array['responsable']);
                        $this->groupEnd();
                        
                        $this->orGroupStart(); // Inicia un grupo de condiciones
                            $this->whereIn("ordencompra.Estado", array("Aprobado", "Rechazado", "Anulado", "Cancelado"));
                            $this->groupStart(); // Inicia un grupo de condiciones
                                $this->orWhere("ordencompra_responsables.UsuarioFirma1", $array['responsable']);
                                $this->orWhere("ordencompra_responsables.UsuarioFirma2", $array['responsable']);
                                $this->orWhere("ordencompra_responsables.UsuarioFirma3", $array['responsable']);
                            $this->groupEnd(); // Finaliza el grupo de condiciones
                        $this->groupEnd();
                        
                    $this->groupEnd(); // Finaliza el grupo de condiciones
                }
                else
                {
                    $this->where("ordencompra.UsuarioCrea", $array['solicitante']);
                }
                
            }
        }
        
        $this->groupBy('ordencompra.Estado');
        
        $datos = $this->findAll();
        // echo $this->getLastQuery();
        // exit;
        return $datos;
    }
    
    public function datosExportarOrdenCompra($array)
    {
        $this->select('ordencompra.IDOrdenCompra,
            ordencompra.Estado,
            ordencompra.FechaCrea,
            ordencompra.FechaPedido,
            ordencompra.Concepto,
            ordencompra.Observacion,
            ordencompra.UsuarioSolicitante,
            ordencompra.IDProveedor,
            proveedor.Nombre AS "Proveedor",
            proveedor.RUC,
            proveedor.Contacto,
            proveedor.Direccion,
            proveedor.IDDistrito,
            proveedor.Telefono01,
            proveedor.Telefono02,
            proveedor.Email,
            proveedor.CodigoDetraccion,
            ordencompra.FormaPago,
            ordencompra.ModalidadPago,
            ordencompra.Banco,
            ordencompra.CuentaBancaria,
            ordencompra.TipoMoneda,
            ordencompra.CuentaInterbancaria,
            ordencompra.CC,
            ordencompra.LN,
            ordencompra.IDSubarea,
            ordencompra.CondicionesIGV,
            ordencompra.Subtotal,
            ordencompra.PorcentajeIGV,
            ordencompra.IGV,
            ordencompra.Total,
            ordencompra.MontoCambio,
            ordencompra_detalle.IDDetalleOC,
            ordencompra_detalle.Descripcion,
            ordencompra_detalle.Cantidad,
            ordencompra_detalle.PrecioUnitario,
            ordencompra.IDSubcategoria,
            cuentacontable_subcategorias.Subcategoria,
            cuentacontable_subcategorias.IDCategoriaCC,
            cuentacontable_categorias.Categoria,
            ordencompra.UsuarioComprador,
            ordencompra.MotivoEstado,
            ordencompra_responsables.UsuarioFirma1,
            ordencompra_responsables.UsuarioFirma2,
            ordencompra_responsables.UsuarioFirma3');
            // formaspago.FormaPago as "descripcionFormaPago",
            // modalidadpago.ModalidadPago as "descripcionModalidadPago",
            // bancos.Nombre as "descripcionBanco"');
        
        $this->join('proveedor', 'ordencompra.IDProveedor = proveedor.IDProveedor', 'left');
        $this->join('ordencompra_detalle', 'ordencompra.IDOrdenCompra = ordencompra_detalle.IDOrdenCompra', 'left');
        $this->join('ordencompra_responsables', 'ordencompra.IDOrdenCompra = ordencompra_responsables.IDOrdenCompra', 'left');
        $this->join('cuentacontable_subcategorias', 'ordencompra.IDSubcategoria = cuentacontable_subcategorias.IDSubcategoriaCC', 'left');
        $this->join('cuentacontable_categorias', 'cuentacontable_subcategorias.IDCategoriaCC = cuentacontable_categorias.IDCategoriaCC', 'left');
        // $this->join('formaspago', 'ordencompra.FormaPago = formaspago.Codigo', 'left');
        // $this->join('modalidadpago', 'ordencompra.ModalidadPago = modalidadpago.Codigo', 'left');
        // $this->join('bancos', 'ordencompra.Banco = bancos.CodigoInterno', 'left');
        
        if(!empty($array) && $array != '')
        {
            if(isset($array["fechaInicio"]) && $array["fechaInicio"] != '')
            {
                $this->where('ordencompra.FechaPedido >=', $array["fechaInicio"]);
            }
            
            if(isset($array["fechaFin"]) && $array["fechaFin"] != '')
            {
                $this->where('ordencompra.FechaPedido <=', $array["fechaFin"]);
            }
            
            if(isset($array["idordencompra"]) && $array["idordencompra"] != '')
            {
                $this->where('ordencompra.IDOrdenCompra', $array["idordencompra"]);
            }
        }
        
        $this->orderBy("ordencompra.IDOrdenCompra", "DESC");
        
        // $this->get();
        // return $this->getLastQuery();
        
        $datos = $this->findAll();
        return $datos;
    }
    
}