<?php
session_start();
date_default_timezone_set('America/Lima');
include 'config/db.php';
include 'config/conexion.php';

if (!isset($_SESSION['user_login_status'])) {
    header("location: ./login/index.php");
    exit;
}
if ($_SESSION['pzmktteleventa'] == 0) {
    header("location: ./denegado.php");
    exit;
}
?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Verisure | VeriSmart</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png">
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">

    <!-- Theme style -->
    <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
    <!-- AdminLTE Skins. Choose a skin from the css/skins
             folder instead of downloading all of them to reduce the load. -->
    <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">

    <!-- daterange picker -->
    <link rel="stylesheet" href="admin/bower_components/bootstrap-daterangepicker/daterangepicker.css">
    <!-- bootstrap datepicker -->
    <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
    <!-- iCheck for checkboxes and radio inputs -->
    <link rel="stylesheet" href="admin/plugins/iCheck/all.css">
    <!-- Bootstrap Color Picker -->
    <link rel="stylesheet" href="admin/bower_components/bootstrap-colorpicker/dist/css/bootstrap-colorpicker.min.css">
    <!-- Bootstrap time Picker -->
    <link rel="stylesheet" href="admin/plugins/timepicker/bootstrap-timepicker.min.css">
    <!-- Select2 -->
    <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">
    <!-- Bootsrap Toogle -->
    <link href="admin/plugins/bootstrap-toggle-master/css/bootstrap-toggle.min.css" rel="stylesheet" type="text/css" />
    <link href="admin/bower_components/bootstrap-table/dist/bootstrap-table.min.css" rel="stylesheet" type="text/css" />
    <!-- bootstrap wysihtml5 - text editor -->
    <link rel="stylesheet" href="admin/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css">

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->

    <!-- Google Font -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">

    <!-- Alertifyjs -->
    <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css" />

    <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">

    <style>
        .modal-header-danger {
            color: #fff;
            background-color: #e4002b;
        }

        .espacio {
            height: 10px;
        }

        .thumbnail_style {
            text-align: center;
            border: none;
        }

        .caption h3 {
            margin-top: -10px;
            font-size: 24px;
        }

        .caption p {
            color: #777;
            font-size: 13px;
            padding: 0px 25px 0px 25px;
        }

        .caption a {
            color: #777;
            font-size: 10px;
        }


        #myWizard2 .form-control {
            border-radius: 4px
        }

        #myWizard3 .form-control {
            border-radius: 4px
        }

        #c-slider {
            margin: auto;
            width: 100%;
            max-width: 900px;
            position: relative;
            overflow: hidden;

        }

        #slider {
            display: flex;
            width: 200%;

        }

        #slider section {
            width: 100%;
        }


        .select2-container--default .select2-selection--single {

            border: 1px solid #d2d6de;
            border-radius: 4px;
            font-size: 12px;
            padding: 4px 6px;
        }

        .btn-nuevo {
            color: #FFFFFF;
            background-color: #444444;
            border-color: #444444;
        }

        .btn-nuevo:hover,
        .btn-nuevo:focus,
        .btn-nuevo:active,
        .btn-nuevo.active,
        .open .dropdown-toggle.btn-nuevo {
            color: #FFFFFF;
            background-color: #616161;
            border-color: #444444;
        }

        .btn-nuevo:active,
        .btn-nuevo.active,
        .open .dropdown-toggle.btn-nuevo {
            background-image: none;
        }

        .btn-nuevo.disabled,
        .btn-nuevo[disabled],
        fieldset[disabled] .btn-nuevo,
        .btn-nuevo.disabled:hover,
        .btn-nuevo[disabled]:hover,
        fieldset[disabled] .btn-nuevo:hover,
        .btn-nuevo.disabled:focus,
        .btn-nuevo[disabled]:focus,
        fieldset[disabled] .btn-nuevo:focus,
        .btn-nuevo.disabled:active,
        .btn-nuevo[disabled]:active,
        fieldset[disabled] .btn-nuevo:active,
        .btn-nuevo.disabled.active,
        .btn-nuevo[disabled].active,
        fieldset[disabled] .btn-nuevo.active {
            background-color: #444444;
            border-color: #444444;
        }
    </style>
    <style>
        html,
        body {
            margin: 0;
            padding: 0;
            height: 100%;
        }
    </style>
    <style>
        .bootstrap-timepicker .input-group-addon i {
            width: 11px;
            height: 0px;
        }

        .nav-tabs-custom>.nav-tabs>li.active {
            border-top-color: #e4002b;
        }
    </style>
    <style>
        .left-side,
        .main-header,
        .main-sidebar {
            position: fixed
        }

        .main-header {
            top: 0;
            right: 0;
            left: 0;
            z-index: 1000
        }

        .content-wrapper,
        .right-side {
            padding-top: 50px;
        }

        @media (max-width:767px) {

            .content-wrapper,
            .right-side {
                padding-top: 100px;
            }
        }

        .layout-boxed .wrapper {
            max-width: 100%
        }

        .wrapper {
            overflow: hidden;
            height: 100%;
            overflow-y: auto;
        }

        .ui-autocomplete {
            position: absolute;
            z-index: 1000;
            cursor: default;
            padding: 0;
            margin-top: 2px;
            list-style: none;
            font-size: 11px;
            font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
            background-color: #fff;
            border: 1px solid #ccc;
            -webkit-border-radius: 5px;
            -moz-border-radius: 5px;
            border-radius: 5px;
            -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, .2);
            -moz-box-shadow: 0 5px 10px rgba(0, 0, 0, .2);
            box-shadow: 0 5px 10px rgba(0, 0, 0, .2);
            z-index: 1051 !important
        }

        input[type=search]::-webkit-search-cancel-button {
            -webkit-appearance: searchfield-cancel-button
        }

        .pagination>.active>a,
        .pagination>.active>a:focus,
        .pagination>.active>a:hover,
        .pagination>.active>span,
        .pagination>.active>span:focus,
        .pagination>.active>span:hover {
            z-index: 3;
            color: #222d32;
            cursor: default;
            background-color: #c1c1c1;
            border-color: #ddd
        }

        .backpack-filter label {
            color: #868686;
            font-weight: 600;
            text-transform: uppercase
        }

        .navbar-filters {
            min-height: 25px;
            border-radius: 0;
            margin-bottom: 6px;
            margin-top: 0;
            background: 0 0;
            border-color: #f4f4f4;
            border: none
        }

        .navbar-filters .navbar-collapse {
            padding: 0;
            border: 0
        }

        .navbar-filters .navbar-toggle {
            padding: 10px 15px;
            border-radius: 0
        }

        .navbar-filters .navbar-brand {
            height: 25px;
            padding: 5px 15px;
            font-size: 14px;
            text-transform: uppercase
        }

        @media (min-width:768px) {
            .navbar-filters .navbar-nav>li>a {
                padding-top: 5px;
                padding-bottom: 5px
            }
        }

        @media (max-width:768px) {
            .navbar-filters .navbar-nav {
                margin: 0
            }
        }

        .navbar-filters .navbar-nav>.active>a,
        .navbar-filters .navbar-nav>.active>a:focus,
        .navbar-filters .navbar-nav>.active>a:hover,
        .navbar-filters .navbar-nav>.open>a,
        .navbar-filters .navbar-nav>.open>a:focus,
        .navbar-filters .navbar-nav>.open>a:hover,
        .navbar-filters li>a:active {
            background-color: #e4e7ea;
            border-radius: 3px
        }

        .navbar-filters li {
            margin: 0 2px
        }

        .navbar-filters li>a {
            border-radius: 2px
        }

        .navbar-filters .nav.navbar-nav {
            float: none
        }

        .pb-0,
        .py-0 {
            padding-bottom: 0 !important
        }

        .pt-0,
        .py-0 {
            padding-top: 0 !important
        }

        .mb-0,
        .my-0 {
            margin-bottom: 0 !important
        }

        .p-0 {
            padding: 0 !important
        }

        .m-b-0 {
            margin-bottom: 0 !important
        }

        .select2-container--default .select2-selection--single {
            border: 1px solid #d2d6de;
            font-size: 12px;
            padding: 4px 6px
        }

        .select2-container--default .select2-selection--multiple .select2-selection__choice {
            color: #333
        }

        .input-group.date {
            width: 320px;
            max-width: 100%
        }

        .daterangepicker .dropdown-menu {
            z-index: 3001 !important
        }

        .select2-container--default .select2-search--dropdown .select2-search__field,
        .select2-container--default.select2-container--focus .select2-selection--multiple {
            border-color: #aaa !important
        }

        .form-inline .select2-container {
            display: inline-block
        }

        .select2-drop-active {
            border: none
        }

        .select2-container .select2-choice,
        .select2-container .select2-choices,
        .select2-container .select2-choices .select2-search-field input {
            border: none
        }

        .select2-container-active .select2-choice {
            border: none;
            box-shadow: none
        }

        .select2-container--default .select2-dropdown {
            margin-top: -2px;
            margin-left: -1px
        }

        .navbar-collapse.in {
            overflow-y: visible
        }

        .d-none {
            display: none !important
        }

        @media (min-width:992px) {
            .d-lg-block {
                display: block !important
            }
        }

        @media (min-width:992px) {
            .navbar-expand-lg .navbar-toggler {
                display: none
            }
        }

        .navbar-toggler {
            padding: .25rem .75rem;
            font-size: 1.25rem;
            background-color: transparent;
            border: 1px solid transparent;
        }

        .whiteinput {
            background-color: #fff !important;
        }

        .callout {
            border-radius: 3px;
            margin: 0 0 20px 0;
            padding: 15px;
            border-left: 0px solid #eee
        }

        .swal2-popup {
            font-size: 1.5rem !important
        }

        .swal2-styled.swal2-confirm {
            background-color: #e4002b !important
        }

        .ocultar {
            display: none;
        }
    </style>
</head>

<body class="sidebar-collapse skin-red sidebar-mini">

    <div class="wrapper">
        <!-- Header -->
        <?php include 'admin/header.php'; ?>
        <!-- Left side column. contains the logo and sidebar -->
        <?php
        $marketing = "active";
        $televentalead = "active";
        include 'admin/main-sidebar.php';
        ?>
        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <div style="font-size:180%;">
                    TELEVENTA &nbsp <span style="font-size:80%;color:#DAD8D4"> | &nbsp </span><span style="font-size:80%;color:#8D8A80"> TRANSFERENCIAS SIN ASIGNAR </span>
                </div>
                <ol class="breadcrumb">
                    <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
                    <li><a href="#.php">Televenta</a></li>
                    <li class="active">Transferencias</li>
                </ol>
            </section>

            <!-- Main content -->
            <section class="content">
                <div class="row">
                    <div class="col-md-12">

                        <div class="box box-danger">
                            <div class="box-header">
                                <table style="width:90%;">
                                    <tr>
                                        <td style="width: 7%;">
                                            <h3 class="box-title">TELEFONO:</h3>
                                        </td>
                                        <td style="width: 83%;">
                                            <div filter-name="BUSCAR" filter-type="text" class="input-group input-group-sm" style="width: 200px;">
                                                <input type="text" name="lblmatriculausuario" value="<?php echo $matriculausuario; ?>" hidden="" id="lblmatriculausuario">
                                                <input type="text" name="lblperfilusuario" value="<?php echo $nombacceso; ?>" hidden="" id="lblperfilusuario">
                                                <input type="text" name="lblnombreusuario" value="<?php echo $nombreusuario; ?>" hidden="" id="lblnombreusuario">
                                                <input type="search" name="input_buscar" id="text-filter-BUSCAR" type="text" value="" class="form-control" placeholder="">

                                                <div class="input-group-btn">
                                                    <button type="button" id="btn-buscar" class="btn btn-default"><i class="fa fa-search"></i></button>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Total Registros: <span id="counttotal"></span></td>
                                    </tr>
                                    <tr>
                                        <td colspan="2">Registros por página: <span id="count"></span></td>
                                    </tr>
                                    <tr class="selectrow">
                                        <td colspan="2">N° Seleccionados: <span id="countselectedRows">0</span></td>
                                    </tr>
                                </table>

                                <div class="box-tools pull-right">
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-danger btn-sm dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
                                            <i class="fa fa-users"></i></button>
                                        <ul class="dropdown-menu" role="menu">
                                            <li><a href="#" data-toggle="modal" data-target="#modal-asig"><i class="fa fa-user"></i> Transferir por Busq.Telefono/DNI</a></li>
                                            <li><a href="#" id="asig"><i class="fa fa-user"></i> Transferir Gestor Individual ó Masivo</a></li>
                                        </ul>
                                    </div>
                                    <button class="btn btn-success btn-sm ocultar" name="btnExportarTVLeads" id="btnExportarTVLeads">Exportar Transferencia sin Asignar</button>
                                    <a class="btn btn-nuevo btn-sm" href="#" style="border-radius: 0px;" onclick="javascript:window.location.reload();" title="Actualizar"><i class="fa fa-refresh"></i></a>
                                </div>

                            </div>
                            <!-- /.box-header -->

                            <div class="box-body" id="vistaboy">
                                <nav class="navbar navbar-default navbar-filters">
                                    <div class="container-fluid">
                                        <!-- Brand and toggle get grouped for better mobile display -->


                                        <div class="navbar-header navbar-expand-lg">

                                            <a class="nav-item d-none d-lg-block navbar-brand"><span class="fa fa-filter"></span></a>
                                            <button class="navbar-toggler navbar-brand" type="button" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1" aria-controls="bs-example-navbar-collapse-1" aria-expanded="false" aria-label="Toggle filters">
                                                <span class="fa fa-filter"></span> Filtros
                                            </button>

                                        </div>

                                        <!-- Collect the nav links, forms, and other content for toggling -->
                                        <div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
                                            <ul class="nav navbar-nav">
                                                <!-- THE ACTUAL FILTERS -->
                                                <li filter-name="IDLEAD" filter-type="text" class="dropdown">
                                                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">IDLEAD <span class="caret"></span></a>
                                                    <div class="dropdown-menu p-0">
                                                        <div class="form-group backpack-filter m-b-0">
                                                            <div class="input-group">
                                                                <input class="form-control pull-right" id="text-filter-IDLEAD" type="text" value="">
                                                                <div class="input-group-addon text-filter-IDLEAD-clear-button">
                                                                    <a class="" href="#"><i class="fa fa-times"></i></a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li filter-name="FECHAULTIMAGESTIONCC" filter-type="date_range" class="dropdown">
                                                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">FECHAULTIMAGESTIONCC <span class="caret"></span></a>
                                                    <div class="dropdown-menu p-0">
                                                        <div class="form-group backpack-filter m-b-0">
                                                            <div class="input-group date">
                                                                <div class="input-group-addon">
                                                                    <i class="fa fa-calendar"></i>
                                                                </div>
                                                                <input class="form-control pull-left whiteinput" id="daterangepicker-FECHAULTIMAGESTIONCC" type="text" readonly>
                                                                <div class="input-group-addon daterangepicker-FECHAULTIMAGESTIONCC-clear-button">
                                                                    <a class="" href=""><i class="fa fa-times"></i></a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li filter-name="FECHACOTIZACION" filter-type="date_range" class="dropdown">
                                                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">FECHACOTIZACION <span class="caret"></span></a>
                                                    <div class="dropdown-menu p-0">
                                                        <div class="form-group backpack-filter m-b-0">
                                                            <div class="input-group date">
                                                                <div class="input-group-addon">
                                                                    <i class="fa fa-calendar"></i>
                                                                </div>
                                                                <input class="form-control pull-left whiteinput" id="daterangepicker-FECHACOTIZACION" type="text" readonly>
                                                                <div class="input-group-addon daterangepicker-FECHACOTIZACION-clear-button">
                                                                    <a class="" href=""><i class="fa fa-times"></i></a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li filter-name="CAMPAÑA" filter-type="select2_multiple" class="nav-item dropdown">
                                                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">CAMPAÑA <span class="caret"></span></a>
                                                    <div class="dropdown-menu p-0">
                                                        <div class="form-group backpack-filter m-b-0">
                                                            <select id="filter_CAMPAÑA" name="filter_CAMPAÑA" class="form-control input-sm select2" placeholder="" multiple>
                                                                <option value="Primer intento">Primer intento</option>
                                                                <option value="recovery">recovery</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li filter-name="ORIGEN" filter-type="text" class="dropdown">
                                                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">ORIGEN <span class="caret"></span></a>
                                                    <div class="dropdown-menu p-0">
                                                        <div class="form-group backpack-filter m-b-0">
                                                            <div class="input-group">
                                                                <input class="form-control pull-right" id="text-filter-ORIGEN" type="text" value="">
                                                                <div class="input-group-addon text-filter-ORIGEN-clear-button">
                                                                    <a class="" href="#"><i class="fa fa-times"></i></a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>

                                                <li filter-name="DEPARTAMENTO" filter-type="text" class="dropdown">
                                                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">DEPARTAMENTO <span class="caret"></span></a>
                                                    <div class="dropdown-menu p-0">
                                                        <div class="form-group backpack-filter m-b-0">
                                                            <div class="input-group">
                                                                <input class="form-control pull-right" id="text-filter-DEPARTAMENTO" type="text" value="">
                                                                <div class="input-group-addon text-filter-DEPARTAMENTO-clear-button">
                                                                    <a class="" href="#"><i class="fa fa-times"></i></a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li filter-name="PROVINCIA" filter-type="text" class="dropdown">
                                                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">PROVINCIA <span class="caret"></span></a>
                                                    <div class="dropdown-menu p-0">
                                                        <div class="form-group backpack-filter m-b-0">
                                                            <div class="input-group">
                                                                <input class="form-control pull-right" id="text-filter-PROVINCIA" type="text" value="">
                                                                <div class="input-group-addon text-filter-PROVINCIA-clear-button">
                                                                    <a class="" href="#"><i class="fa fa-times"></i></a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li filter-name="DISTRITO" filter-type="text" class="dropdown">
                                                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">DISTRITO <span class="caret"></span></a>
                                                    <div class="dropdown-menu p-0">
                                                        <div class="form-group backpack-filter m-b-0">
                                                            <div class="input-group">
                                                                <input class="form-control pull-right" id="text-filter-DISTRITO" type="text" value="">
                                                                <div class="input-group-addon text-filter-DISTRITO-clear-button">
                                                                    <a class="" href="#"><i class="fa fa-times"></i></a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li filter-name="SEGMENTO" filter-type="select2_multiple" class="nav-item dropdown">
                                                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">SEGMENTO <span class="caret"></span></a>
                                                    <div class="dropdown-menu p-0">
                                                        <div class="form-group backpack-filter m-b-0">
                                                            <select id="filter_SEGMENTO" name="filter_SEGMENTO" class="form-control input-sm select2" placeholder="" multiple>
                                                                <option value="RES">RES</option>
                                                                <option value="NEG">NEG</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li filter-name="TIPOTRANSF" filter-type="select2_multiple" class="nav-item dropdown">
                                                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">TIPOTRANSF <span class="caret"></span></a>
                                                    <div class="dropdown-menu p-0">
                                                      <div class="form-group backpack-filter m-b-0">
                                                			<select id="filter_TIPOTRANSF" name="filter_TIPOTRANSF" class="form-control input-sm select2" placeholder="" multiple>
                                                                <option value="EnLinea">En Linea</option>
                                                                <option value="BD">BD</option>
                                                                <option value="BD48horas">BD - 48 horas</option>                                                      
                                                			</select>
                                                		</div>
                                                    </div>
                                                 </li>                                                

                                                <li filter-name="TIPIFICACION" filter-type="select2_multiple" class="nav-item dropdown">
                                                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">TIPIFICACION <span class="caret"></span></a>
                                                    <div class="dropdown-menu p-0">
                                                        <div class="form-group backpack-filter m-b-0">
                                                            <select id="filter_TIPIFICACION" name="filter_TIPIFICACION" class="form-control input-sm select2" placeholder="" multiple>
                                                                <option value="apagado">Apagado </option>
                                                                <option value="atc">ATC</option>
                                                                <option value="backoffice">BackOffice</option>
                                                                <option value="clienteError">Cliente Error</option>
                                                                <option value="contestaCorta">Contesta y corta</option>
                                                                <option value="devolverLlamada">Devolver llamada</option>
                                                                <option value="duplicado">Duplicado</option>
                                                                <option value="inviable">Inviable </option>
                                                                <option value="noAceptaVisita">No acepta visita</option>
                                                                <option value="noContacto">No Contacto</option>
                                                                <option value="noCotizó">No Cotizó </option>
                                                                <option value="otros">Otros</option>
                                                                <option value="prov">Prov</option>
                                                                <option value="prueba">Prueba</option>
                                                                <option value="RP">RP</option>
                                                                <option value="telefonoError">Telefono Error</option>
                                                                <option value="televenta">Televenta </option>
                                                                <option value="upselling">Upselling</option>
                                                                <option value="visitaAceptada">Visita Aceptada</option>
                                                                <option value="visitaReconfirmar">Visita por reconfirmar</option>
                                                                <option value="zscc">ZSCC - zona sin cobertura comercial </option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li filter-name="SUBTIPIFICACION" filter-type="select2_multiple" class="nav-item dropdown">
                                                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">SUBTIPIFICACION <span class="caret"></span></a>
                                                    <div class="dropdown-menu p-0">
                                                        <div class="form-group backpack-filter m-b-0">
                                                            <select id="filter_SUBTIPIFICACION" name="filter_SUBTIPIFICACION" class="form-control input-sm select2" placeholder="" multiple>
                                                                <option value="camaras">Cámaras</option>
                                                                <option value="cobranzas">Cobranzas</option>
                                                                <option value="consultaFactura">Consulta de facturacion</option>
                                                                <option value="facturacion">Facturación</option>
                                                                <option value="inconvenienteAlarma">Inconvenientes con alarma</option>
                                                                <option value="noPagoMensual">No desea pago mensual</option>
                                                                <option value="repeccion">Recepción</option>
                                                                <option value="rrhh">RRHH</option>
                                                                <option value="suspensionBajaServicio">Suspension/baja de servicio</option>
                                                                <option value="televenta">Televenta</option>
                                                                <option value="televentaCovid">Televenta - Covid</option>
                                                                <option value="televentaPrecio">Televenta - Precio</option>
                                                                <option value="televentaScoring">Scoring - TV</option>
                                                                <option value="trasladoDispositivos">Traslado de dispositivos</option>
                                                                <option value="visitaAceptada">Visita aceptada</option>
                                                                <option value="visitaAceptadaCamara">Visita aceptada por cámaras</option>
                                                                <option value="yaEncontroAlarma">Ya encontró alarma</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li><a href="#" id="remove_filters_button" class="hidden"><i class="fa fa-eraser"></i> Remover Filtros</a></li>
                                            </ul>
                                        </div><!-- /.navbar-collapse -->
                                    </div><!-- /.container-fluid -->
                                </nav>
                                <div id="myGrid" style="height: 480px" class="ag-theme-fresh"></div>
                                <div id="ningunresultado"></div>

                            </div>
                            <!-- /.box-body -->
                            <div class="box-footer clearfix">
                                <ul class="pagination pagination-sm no-margin pull-right" id="paginador"></ul>
                            </div>
                            <!-- /.box-footer -->
                        </div>
                        <!-- /.box -->


                    </div>
                </div>
                <div class="test-header" style="display:none"><span id="selectedRows"></span></div>
            </section>
            <!-- /.content -->

            <!-- modal -->
            <div class="modal fade" id="modal-asig" style="overflow:hidden;">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header modal-header-danger">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h3 id="myModalLabel">TRANSFERIR POR TELEFONO/DNI</h3>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-xs-1"></div>
                                <div class="col-xs-10">
                                    <div class="form-group">
                                        <label class="col-sm-4 control-label" style="font-size: 18px;color: #444">TELEFONO/DNI:</label>
                                        <div class="col-sm-8">
                                            <div class="input-group input-group-sm">
                                                <input type="text" class="form-control input-sm" name="lblnclientebuscar" id="lblnclientebuscar" placeholder="Buscar transferencia.." onkeypress="return event.charCode >= 48 && event.charCode <= 57" maxlength="9">
                                                <div class="input-group-btn">
                                                    <button type="submit" id="buscarnum" class="btn btn-nuevo2 btn-sm" style="border-radius: 0px;"><i class="fa fa-search"></i></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xs-1"></div>
                            </div>
                            <div class="espacio" style="height:10px;"></div>
                            <div class="row">
                                <div class="col-xs-1"></div>
                                <div class="col-xs-10">
                                    <table class="table table-border" id="tblVentas" border="1">
                                        <thead>
                                            <tr style="height:1vw">
                                                <td style="width:5%;" class="text-center">OPCIONES</td>
                                                <td style="width:5%;" class="text-center">TELEFONO</td>
                                                <td style="width:5%;" class="text-center">DOCUMENTO</td>
                                                <td style="width:5%;" class="text-center">TIPO TRANSF.</td>
                                                <td style="width:5%;" class="text-center">CONTACTO</td>
                                                <!-- <td style="width:5%;" class="text-center">ESTADO</td> -->
                                            </tr>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="col-xs-1"></div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-nuevo" data-dismiss="modal">Cerrar</button>
                        </div>
                    </div>
                    <!-- /.modal-content -->
                </div>
                <!-- /.modal-dialog -->
            </div>

            <div class="modal fade" id="modal-asignar">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header modal-header-danger">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h3 id="myModalLabel">ASIGNAR TELEVENTA</h3>
                        </div>

                        <div class="modal-body">
                            <div class="row">
                                <div class="col-xs-1"></div>
                                <div class="col-xs-10">
                                    <div class="form-group">


                                        <label class="col-sm-4 control-label" style="font-size: 14px;color: #444"> GESTOR:</label>

                                        <div class="col-sm-8">

                                            <select class="form-control cbxtelecierre input-sm" id="cboGestorTV" name="cboGestorTV" style="width: 100%;">
                                                <option value="">Seleccione</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xs-1"></div>
                            </div>
                            <div class="espacio"></div>
                            <span style="display:none" id="selectedRowsModal"></span>
                            <span style="display:none" id="countselectedRowsModal">0</span>
                        </div>
                        <div class="modal-footer">
                            <?php if ($nombacceso == 'test') {
                            } else { ?>
                                <input type="button" class="btn btn-danger" id="btnAsignar" name="btnAsignar" value="Asignar">
                            <?php } ?>

                            <button type="button" class="btn btn-nuevo" data-dismiss="modal">Cerrar</button>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /.modal -->
        </div>
        <!-- /.content-wrapper -->
        <div class="control-sidebar-bg"></div>
    </div>
    <!-- ./wrapper -->
    <!-- jQuery v1.11 -->
    <script src="admin/bower_components/jquery/dist/jquery_v1.11.js" type="text/javascript"></script>
    <!-- jQuery UI 1.11.4 -->
    <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
    <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <!-- Bootstrap 3.3.7 -->
    <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
    <!-- Select2 -->
    <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
    <!-- Sparkline -->
    <script src="admin/bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>
    <!-- jQuery Knob Chart -->
    <script src="admin/bower_components/jquery-knob/dist/jquery.knob.min.js"></script>
    <!-- Bootstrap WYSIHTML5 -->
    <script src="admin/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js"></script>
    <!-- Slimscroll -->
    <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
    <!-- FastClick -->
    <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
    <!-- AdminLTE App -->
    <script src="admin/dist/js/adminlte.min.js"></script>
    <script src="admin/bower_components/ag-grid-master/dist/ag-grid.min.js" type="text/javascript"></script>
    <!-- InputMask -->
    <script src="admin/plugins/input-mask/jquery.inputmask.js"></script>
    <script src="admin/plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
    <script src="admin/plugins/input-mask/jquery.inputmask.extensions.js"></script>
    <!-- date-range-picker -->
    <script src="admin/bower_components/moment/min/moment.min.js"></script>
    <script src="admin/bower_components/bootstrap-daterangepicker/daterangepicker.js"></script>
    <!-- bootstrap datepicker -->
    <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
    <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>
    <!-- bootstrap color picker -->
    <script src="admin/bower_components/bootstrap-colorpicker/dist/js/bootstrap-colorpicker.min.js"></script>
    <!-- bootstrap time picker -->
    <script src="admin/plugins/timepicker/bootstrap-timepicker.min.js"></script>
    <!-- Alertify -->
    <script src="admin/bower_components/alertifyjs/alertify.min.js" type="text/javascript"></script>
    <!-- Notificaciones -->
    <script src="js/notificaciones.js" type="text/javascript"></script>
    <!-- GRILLA DE BUSCAR NUMERO -->
    <!-- sweetalert -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    <script src="admin/bower_components/ag-grid-master/dist/ag-grid.min.js" type="text/javascript"></script>
    <!-- SCRIPT AG-GRID PRINCIPAL-->
    <!-- TOOGLE -->
    <script src="admin/plugins/bootstrap-toggle-master/js/bootstrap-toggle.min.js"></script>
    <script>
        //GLOBALES
        const perfilUsuario = $('#headerPerfilUsuario').val();
        //PARAMETROS DE PAGINACION
        const paginador = $(".pagination");
        const itemsPorPagina = 500;
        const numerosPorPagina = 8;
    </script>
    <!-- GRID PRINCIPAL -->
    <script>
        var columnDefs = [{
                headerName: 'IDLEAD_CC',
                field: 'IdLeadCC',
                width: 130,
                pinned: 'left',
                headerCheckboxSelection: true,
                headerCheckboxSelectionFilteredOnly: true,
                checkboxSelection: true
            },
            {
                headerName: 'TELEFONO',
                field: 'Telefono',
                width: 150,
                    cellRenderer: function (params) {
                        return '<input type="text" value="' + params.value + '" style="background-color: transparent;border: 0;width: 100%;" readonly="readonly"/>';
                    }
            },
            {
                headerName: 'APELLIDOS Y NOMBRES',
                field: 'NombreCompleto',
                width: 250
            },            
            {
                headerName: 'FECHAULTIMAGESTION CC',
                field: 'FechaUltimaGestion',
                width: 200,
                filter: 'date',
                filterParams: {
                    filterOptions: ['equals', 'notEqual', 'lessThan', 'lessThanOrEqual', 'greaterThan', 'greaterThanOrEqual', 'inRange'],
                    // use inRangeInclusive: true for the range filter to include the selected 
                    // from and to dates. Setting it false would fetch only the inbetween dates
                    inRangeInclusive: true,
                    comparator: function(filterLocalDateAtMidnight, cellValue) {
                        //using moment js
                        var dateAsString = moment(cellValue).format('DD/MM/YYYY');
                        var dateParts = dateAsString.split("/");
                        var cellDate = new Date(Number(dateParts[2]), Number(dateParts[1]) - 1, Number(dateParts[0]));

                        if (filterLocalDateAtMidnight.getTime() == cellDate.getTime()) {
                            return 0
                        }

                        if (cellDate < filterLocalDateAtMidnight) {
                            return -1;
                        }

                        if (cellDate > filterLocalDateAtMidnight) {
                            return 1;
                        }
                    }
                }
            },
            {
                headerName: 'OBSERVACIONES CC',
                field: 'Observaciones',
                width: 350
            },            
            {
                headerName: 'DEPARTAMENTO',
                field: 'Departamento',
                width: 150
            },            
            {
                headerName: 'PROVINCIA',
                field: 'Provincia',
                width: 150
            },
            {
                headerName: 'DISTRITO',
                field: 'Distrito',
                width: 150
            },
            
            {
                headerName: 'SUBTIPIFICACION',
                field: 'SubTipificacion',
                width: 240
            },              
            {
                headerName: 'TIPOTRANSFERENCIA',
                field: 'TipoTransferencia',
                width: 260
            },

            {
                headerName: 'SEGMENTO',
                field: 'Segmento',
                width: 100
            },            
            
            // {
            //     headerName: 'GESTION',
            //     field: 'Gestion',
            //     width: 150
            // },
            // {
            //     headerName: 'CAMPAÑA',
            //     field: 'Campana',
            //     width: 150
            // },

            // {
            //     headerName: 'ORIGEN',
            //     field: 'Origen',
            //     width: 250
            // },
            // {
            //     headerName: 'FECHA HORA COTIZACION',
            //     field: 'FechaHoraCotizacion',
            //     width: 210
            // },            
            // {
            //     headerName: 'TIPIFICACION',
            //     field: 'ResultadoGestion',
            //     width: 140
            // },
          
            // {
            //     headerName: 'TELEFONO2',
            //     field: 'Telefono2',
            //     width: 100
            // },


            // {
            //     headerName: 'GESTOR CC',
            //     field: 'GestorUltimo',
            //     width: 150
            // },
            // {
            //     headerName: 'TIPO CONTACTO',
            //     field: 'Contacto',
            //     width: 100
            // },
            // {
            //     headerName: 'OBS. TRANSFERENCIA',
            //     field: 'ObsTransferencia',
            //     width: 150
            // }            
        ];
        var gridOptions = {
            columnDefs: columnDefs,
            onPaginationChanged: onPaginationChanged,
            rowData: null,
            enableFilter: true,
            enableColResize: true,
            enableSorting: true,
            rowSelection: 'multiple',
            onSelectionChanged: onSelectionChanged,
            localeText: {
                // for filter panel
                page: 'página',
                more: 'Más',
                to: 'a',
                of: 'de',
                next: 'Siguiente',
                last: 'Último',
                first: 'Primero',
                previous: 'Anterior',
                loadingOoo: 'Cargando...',
                // for set filter
                selectAll: 'Seleccionar todo',
                searchOoo: 'Buscando...',
                blanks: 'Espacios en blanco',
                // for number filter and text filter
                filterOoo: 'Filtrar...',
                applyFilter: 'Aplicar Filtro',
                // for number filter
                equals: 'Igual',
                notEqual: 'No es igual',
                lessThanOrEqual: 'Menor o igual',
                greaterThanOrEqual: 'Mayor que o igual',
                inRange: 'En el rango',
                lessThan: 'Menos que',
                greaterThan: 'Mas grande que',
                // for text filter
                contains: 'Contiene',
                startsWith: 'Comienza con',
                endsWith: 'Termina con',
                notContains: 'No contiene',
                // the header of the default group column
                group: 'Grupo',
                // tool panel
                columns: 'columnas',
                rowGroupColumns: 'Grupo columnas',
                rowGroupColumnsEmptyMessage: 'No hay resultado',
                valueColumns: 'Columna de valor',
                pivotMode: 'Modo pivote',
                groups: 'grupos',
                values: 'valor',
                pivots: 'pivote',
                valueColumnsEmptyMessage: 'No hay resultado',
                pivotColumnsEmptyMessage: 'No hay resultado',
                // other
                noRowsToShow: '<div class="callout callout-danger">\n\
                                <span class="pull-left">\n\
                                <img src="admin/dist/img/noresults-img.png" style="width: 70%">\n\
                                </span>\n\<h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>\n\
                                <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>\n\
                                <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>\n\
                                <br></div>',
                // enterprise menu
                pinColumn: 'Aclar columna',
                valueAggregation: 'Agregar valor',
                autosizeThiscolumn: 'Auto tamaño esta columna ',
                autosizeAllColumns: 'Auto tamaño todas columnas',
                groupBy: 'Agrupar',
                ungroupBy: 'Agrupar uno',
                resetColumns: 'Restaurar Columnas',
                expandAll: 'expandir todo',
                collapseAll: 'desplegar todo',
                toolPanel: 'Panel de Heramientas',
                export: 'Exportar',
                csvExport: 'Exportar CSV',
                excelExport: 'Exportar Excel',
                // enterprise menu pinning
                pinLeft: 'Anclar a derecha',
                pinRight: 'Anclar a izquierda',
                noPin: 'Desanclar',
                // enterprise menu aggregation and status panel
                sum: 'Sumar',
                min: 'Minimo',
                max: 'Maximo',
                first: 'Primero',
                last: 'Ultimo',
                none: 'Nada',
                count: 'Contador',
                average: 'Promedio',
                // standard menu
                copy: 'Copiar',
                copyWithHeaders: 'Copiar Cabecera',
                ctrlC: 'Ctrl+C',
                paste: 'Pegar',
                ctrlV: 'Ctrl+V'
            },
            enableSorting: true
        };


        function onPaginationChanged(params) {
            this.gridRowCount = params.api.paginationGetRowCount();
            $("#count").html(this.gridRowCount);
        }

        function onFilterChanged(value) {
            gridOptions.api.setQuickFilter(value);
        }

        function onSelectionChanged() {
            var selectedRows = gridOptions.api.getSelectedRows();
            var selectedRowsString = '';
            var countselectedRows = 0;
            selectedRows.forEach(function(selectedRow, index) {
                if (index !== 0) {
                    selectedRowsString += ', ';
                    countselectedRows += 0;
                }
                selectedRowsString += selectedRow.IdLeadCC;
                countselectedRows += 1;
            });

            document.querySelector('#selectedRows').innerHTML = selectedRowsString;
            document.querySelector('#countselectedRows').innerHTML = countselectedRows;
        }

        function listar(pagenum) {
            var cadena = Urlcadena();
            var gridDiv = document.querySelector('#myGrid');
            new agGrid.Grid(gridDiv, gridOptions);
            ajaxUpdateUriParameter(gridDiv, itemsPorPagina, pagenum, cadena, true);
        }

        function refresh() {
            var pagenum = $(".pagination").find("li.active .page_link").html().valueOf() - 1;
            var cadena = Urlcadena();
            var gridDiv = document.querySelector('#myGrid');
            ajaxUpdateUriParameter(gridDiv, itemsPorPagina, pagenum, cadena, false);
        }
    </script>
    <!-- FUNCIONES DE LA PAGINACION-->
    <script>
        var totalPaginas;

        function creaPaginador(totalItems) {
            $(".pagination li").remove();
            totalPaginas = Math.ceil(totalItems / itemsPorPagina);
            $('<li><a href="#" class="first_link"><i class="fa fa-angle-double-left"></i></a></li>').appendTo(paginador);
            if (totalPaginas > 1) {
                $('<li><a href="#" class="prev_link"><i class="fa fa-angle-left"></i></a></li>').appendTo(paginador);
            }
            var pag = 0;
            while (totalPaginas > pag) {
                $('<li><a href="#" class="page_link">' + (pag + 1) + '</a></li>').appendTo(paginador);
                pag++;
            }

            if (numerosPorPagina > 1) {
                $(".page_link").hide();
                $(".page_link").slice(0, numerosPorPagina).show();
            }
            if (totalPaginas > 1) {
                $('<li><a href="#" class="next_link"><i class="fa fa-angle-right"></i></a></li>').appendTo(paginador);
            }
            $('<li><a href="#" class="last_link"><i class="fa fa-angle-double-right"></i></a></li>').appendTo(paginador);

            paginador.find(".page_link:first").addClass("active");
            paginador.find(".page_link:first").parents("li").addClass("active");

            paginador.find(".prev_link").hide();

            paginador.find("li .page_link").click(function() {
                var irpagina = $(this).html().valueOf() - 1;
                cargaPagina(irpagina);
                return false;
            });

            paginador.find("li .first_link").click(function() {
                var irpagina = 0;
                cargaPagina(irpagina);
                return false;
            });

            paginador.find("li .prev_link").click(function() {
                var irpagina = parseInt(paginador.data("pag")) - 1;
                cargaPagina(irpagina);
                return false;
            });

            paginador.find("li .next_link").click(function() {
                var irpagina = parseInt(paginador.data("pag")) + 1;
                cargaPagina(irpagina);
                return false;
            });

            paginador.find("li .last_link").click(function() {
                var irpagina = totalPaginas - 1;
                cargaPagina(irpagina);
                return false;
            });

            //cargaPagina(0);

        }

        function cargaPagina(pagina) {

            var cadena = Urlcadena();
            var gridDiv = document.querySelector('#myGrid');
            ajaxUpdateUriParameter(gridDiv, itemsPorPagina, pagina, cadena, false);

            if (pagina >= 1) {
                paginador.find(".prev_link").show();
            } else {
                paginador.find(".prev_link").hide();
            }
            if (pagina < (totalPaginas - numerosPorPagina)) {
                paginador.find(".next_link").show();
            } else {
                paginador.find(".next_link").hide();
            }
            paginador.data("pag", pagina);

            if (numerosPorPagina > 1) {
                $(".page_link").hide();
                if (pagina < (totalPaginas - numerosPorPagina)) {
                    $(".page_link").slice(pagina, numerosPorPagina + pagina).show();
                } else {
                    if (totalPaginas > numerosPorPagina) {
                        $(".page_link").slice(totalPaginas - numerosPorPagina).show();
                    } else {
                        $(".page_link").slice(0).show();
                    }

                }
            }
            paginador.children().removeClass("active");
            paginador.children().eq(pagina + 2).addClass("active");


        }

        function normalizeAmpersand(string) {
            return string.replace(/&amp;/g, "&").replace(/amp%3B/g, "");
        }

        function Urlcadena() {
            var cadena = '';
            var filterscount = 0;
            var registro = [];

            var valueIDLEAD = $("#text-filter-IDLEAD").val();
            var valueCAMPAÑA = $("#filter_CAMPAÑA").val();
            var valueFECHAULTIMAGESTIONCC = $("#daterangepicker-FECHAULTIMAGESTIONCC").val();
            var valuePROVINCIA = $("#text-filter-PROVINCIA").val();
            var valueDISTRITO = $("#text-filter-DISTRITO").val();
            var valueSEGMENTO = $("#filter_SEGMENTO").val();
            var valueFECHACOTIZACION = $("#daterangepicker-FECHACOTIZACION").val();
            var valueTIPOTRANSF=$("#filter_TIPOTRANSF").val();
            var valueTIPIFICACION = $("#filter_TIPIFICACION").val();
            var valueSUBTIPIFICACION = $("#filter_SUBTIPIFICACION").val();
            var valueORIGEN = $("#text-filter-ORIGEN").val();
            var valueBUSCAR = $("#text-filter-BUSCAR").val();
            cadena += 'sortdatafield=IdLeadCC&sortorder=desc&';
            if (valueIDLEAD !== '') {
                registro.push({
                    nombrecampo: 'IdLeadCC',
                    valor: valueIDLEAD,
                    condicion: 'CONTAINS',
                    operador: 0
                });
            }
            if (valueBUSCAR !== '') {
                registro.push({
                    nombrecampo: 'Telefono',
                    valor: valueBUSCAR,
                    condicion: 'CONTAINS',
                    operador: 2
                });
                registro.push({
                    nombrecampo: 'Telefono2',
                    valor: valueBUSCAR,
                    condicion: 'CONTAINS',
                    operador: 2
                });
            }

            if (valueCAMPAÑA !== null) {
                for (var i = 0; i < valueCAMPAÑA.length; i++) {
                    registro.push({
                        nombrecampo: 'Campaña',
                        valor: valueCAMPAÑA[i],
                        condicion: 'EQUAL',
                        operador: 1
                    });
                }
            }
            if (valueFECHAULTIMAGESTIONCC !== '') {
                var separador = " - ",
                    arrFechaUltimaGestion = valueFECHAULTIMAGESTIONCC.split(separador);
                registro.push({
                    nombrecampo: 'FechaUltimaGestion',
                    valor: arrFechaUltimaGestion[0].replace(new RegExp("/", "g"), "-"),
                    condicion: 'GREATER_THAN_OR_EQUAL_TIME',
                    operador: 0
                });
                registro.push({
                    nombrecampo: 'FechaUltimaGestion',
                    valor: arrFechaUltimaGestion[1].replace(new RegExp("/", "g"), "-"),
                    condicion: 'LESS_THAN_OR_EQUAL_TIME',
                    operador: 0
                });
            }
            if (valuePROVINCIA !== '') {
                registro.push({
                    nombrecampo: 'Provincia',
                    valor: valuePROVINCIA,
                    condicion: 'CONTAINS',
                    operador: 0
                });
            }
            if (valueDISTRITO !== '') {
                registro.push({
                    nombrecampo: 'Distrito',
                    valor: valueDISTRITO,
                    condicion: 'CONTAINS',
                    operador: 0
                });
            }
            if (valueSEGMENTO !== null) {
                for (var i = 0; i < valueSEGMENTO.length; i++) {
                    registro.push({
                        nombrecampo: 'Segmento',
                        valor: valueSEGMENTO[i],
                        condicion: 'EQUAL',
                        operador: 1
                    });
                }
            }
            if (valueORIGEN !== '') {
                registro.push({
                    nombrecampo: 'Origen',
                    valor: valueORIGEN,
                    condicion: 'CONTAINS',
                    operador: 0
                });
            }
            if (valueFECHACOTIZACION !== '') {
                var separador = " - ",
                    arrFECHACOTIZACION = valueFECHACOTIZACION.split(separador);
                registro.push({
                    nombrecampo: 'FechaHoraCotizacion',
                    valor: arrFECHACOTIZACION[0].replace(new RegExp("/", "g"), "-"),
                    condicion: 'GREATER_THAN_OR_EQUAL_TIME',
                    operador: 0
                });
                registro.push({
                    nombrecampo: 'FechaHoraCotizacion',
                    valor: arrFECHACOTIZACION[1].replace(new RegExp("/", "g"), "-"),
                    condicion: 'LESS_THAN_OR_EQUAL_TIME',
                    operador: 0
                });
            }

            if(valueTIPOTRANSF!==null){
                 for(var i=0;i<valueTIPOTRANSF.length;i++){
                          registro.push({nombrecampo:'TipoTransferencia',valor:valueTIPOTRANSF[i],condicion:'EQUAL',operador:1});   
                 }
            }            
            
            if (valueTIPIFICACION !== null) {
                for (var i = 0; i < valueTIPIFICACION.length; i++) {
                    registro.push({
                        nombrecampo: 'ResultadoGestion',
                        valor: valueTIPIFICACION[i],
                        condicion: 'EQUAL',
                        operador: 1
                    });
                }
            }
            if (valueSUBTIPIFICACION !== null) {
                for (var i = 0; i < valueSUBTIPIFICACION.length; i++) {
                    registro.push({
                        nombrecampo: 'SubTipificacion',
                        valor: valueSUBTIPIFICACION[i],
                        condicion: 'EQUAL',
                        operador: 1
                    });
                }
            }
            console.log(registro);
            if (registro.length > 0) {
                for (i = 0; i < registro.length; i++) {
                    cadena += 'filtervalue' + i + '=' + registro[i].valor + '&';
                    cadena += 'filtercondition' + i + '=' + registro[i].condicion + '&';
                    cadena += 'filterdatafield' + i + '=' + registro[i].nombrecampo + '&';
                    cadena += 'filteroperator' + i + '=' + registro[i].operador + '&';
                }

                $('#remove_filters_button').removeClass('hidden');
            }
            cadena += 'filterscount=' + registro.length;


            console.log(cadena);

            return cadena;
        }

        function ajaxUpdateUriParameter(gridDiv, itemsPorPagina, pagenum, cadena, activoPaginador) {
            gridOptions.api.showLoadingOverlay();
            $.ajax({
                type: 'GET',
                dataType: 'json',
                url: 'ajax/selectListarLeadTV_v2.php',
                data: 'pagesize=' + itemsPorPagina + '&pagenum=' + pagenum + '&' + cadena,
                success: function(r) {
                    if (r[0].tipo == 0) {
                        $("#ningunresultado").html(r[0].mensaje);
                        $("#ningunresultado").show("200");
                        $('#myGrid').hide("fast");
                        $("#counttotal").html(r[0].TotalRows);
                        $('#paginador').hide("fast");
                        gridOptions.api.hideOverlay();
                    } else {
                        $('#myGrid').show(200);
                        $('#paginador').show(200);
                        $("#ningunresultado").hide("fast");
                        gridOptions.api.setRowData(r[0].Rows);
                        if (activoPaginador == true) {
                            creaPaginador(r[0].TotalRows);
                            paginador.data("pag", pagenum);
                        }
                        $("#counttotal").html(r[0].TotalRows);
                    }

                }

            });
        }

        $("#remove_filters_button").click(function(e) {
            e.preventDefault();
            // comportamiento por ajax
            var pagenum = 0;
            var cadena = 'sortdatafield=IdLeadCC&sortorder=desc&filterscount=0';
            console.log(cadena);
            var gridDiv = document.querySelector('#myGrid');
            ajaxUpdateUriParameter(gridDiv, itemsPorPagina, pagenum, cadena, true);
            // borrar todos los filtros
            $(".navbar-filters li[filter-name]").trigger('filter:clear');
        });

        // hide the Remove filters button when no filter is active
        $(".navbar-filters li[filter-name]").on('filter:clear', function() {
            var anyActiveFilters = false;
            $(".navbar-filters li[filter-name]").each(function() {
                if ($(this).hasClass('active')) {
                    anyActiveFilters = true;
                    console.log('ACTIVE FILTER');
                }
            });

            if (anyActiveFilters == false) {
                $('#remove_filters_button').addClass('hidden');
            }
        });
    </script>
    <!-- FILTROS DE LA GRID PRINCIPAL -->
    <script type="text/javascript">
        //Filtro IDLEAD
        $('#text-filter-IDLEAD').on('change', function(e) {
            var pagenum = 0;
            var value = $(this).val();
            var cadena = Urlcadena();
            var gridDiv = document.querySelector('#myGrid');
            ajaxUpdateUriParameter(gridDiv, itemsPorPagina, pagenum, cadena, true);

            // marque este filtro como activo en los filtros en navbar-filters
            if (value != '') {
                $('li[filter-name=IDLEAD]').removeClass('active').addClass('active');
            } else {
                $('li[filter-name=IDLEAD]').trigger('filter:clear');
            }

        });
        $('li[filter-name=IDLEAD]').on('filter:clear', function(e) {
            $('li[filter-name=IDLEAD]').removeClass('active');
            $('#text-filter-IDLEAD').val('');
        });
        // Limpiar button IDLEAD
        $(".text-filter-IDLEAD-clear-button").click(function(e) {
            e.preventDefault();
            $('li[filter-name=IDLEAD]').trigger('filter:clear');
            $('#text-filter-IDLEAD').val('');
            $('#text-filter-IDLEAD').trigger('change');
        });
        //Filtro BUSCAR
        $('#text-filter-BUSCAR').on('change', function(e) {
            var pagenum = 0;
            var value = $(this).val();
            var cadena = Urlcadena();
            var gridDiv = document.querySelector('#myGrid');
            ajaxUpdateUriParameter(gridDiv, itemsPorPagina, pagenum, cadena, true);
        });
        $('li[filter-name=BUSCAR]').on('filter:clear', function(e) {
            $('#text-filter-BUSCAR').val('');
        });
        //Filtro FECHAULTIMAGESTIONCC
        function applyDateRangeFilterFECHAULTIMAGESTIONCC(start, end) {
            if (start && end) {
                var dates = {
                    'from': start.format('YYYY-MM-DD'),
                    'to': end.format('YYYY-MM-DD')
                };
                var value = JSON.stringify(dates);
            } else {
                //this change to empty string,because addOrUpdateUriParameter method just judgment string
                var value = '';
            }

            // mark this filter as active in the navbar-filters
            if (value !== '') {
                $('li[filter-name=FECHAULTIMAGESTIONCC]').removeClass('active').addClass('active');
            } else {
                $('li[filter-name=FECHAULTIMAGESTIONCC]').trigger('filter:clear');
            }


        }

        var dateRangeInput = $('#daterangepicker-FECHAULTIMAGESTIONCC').daterangepicker({
            timePicker: false,
            ranges: {
                'Today': [moment().startOf('day'), moment().endOf('day')],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
            },
            alwaysShowCalendars: true,
            autoUpdateInput: false
        });

        dateRangeInput.on('apply.daterangepicker', function(ev, picker) {
            applyDateRangeFilterFECHAULTIMAGESTIONCC(picker.startDate, picker.endDate);
            $(this).val(picker.startDate.format('YYYY/MM/DD') + ' - ' + picker.endDate.format('YYYY/MM/DD'));
            var pagenum = 0;
            var cadena = Urlcadena();
            var gridDiv = document.querySelector('#myGrid');
            ajaxUpdateUriParameter(gridDiv, itemsPorPagina, pagenum, cadena, true);
        });
        /*
            dateRangeInput.on('cancel.daterangepicker', function(ev, picker) {
                $(this).val('');
            });
            */

        $('li[filter-name=FECHAULTIMAGESTIONCC]').on('hide.bs.dropdown', function() {
            if ($('.daterangepicker').is(':visible'))
                return false;
        });

        $('li[filter-name=FECHAULTIMAGESTIONCC]').on('filter:clear', function(e) {
            // console.log('daterangepicker filter cleared');
            //if triggered by remove filters click just remove active class,no need to send ajax
            $('li[filter-name=FECHAULTIMAGESTIONCC]').removeClass('active');
            $(this).val('');
            $('#daterangepicker-FECHAULTIMAGESTIONCC').val('');
        });

        // datepicker clear button
        $(".daterangepicker-FECHAULTIMAGESTIONCC-clear-button").click(function(e) {
            e.preventDefault();
            applyDateRangeFilterFECHAULTIMAGESTIONCC(null, null);
            $('li[filter-name=FECHAULTIMAGESTIONCC]').trigger('filter:clear');
            var pagenum = 0;
            var cadena = Urlcadena();
            var gridDiv = document.querySelector('#myGrid');
            ajaxUpdateUriParameter(gridDiv, itemsPorPagina, pagenum, cadena, true);
        })
        //Filtro FECHACOTIZACION
        function applyDateRangeFilterFECHACOTIZACION(start, end) {
            if (start && end) {
                var dates = {
                    'from': start.format('YYYY-MM-DD'),
                    'to': end.format('YYYY-MM-DD')
                };
                var value = JSON.stringify(dates);
            } else {
                //this change to empty string,because addOrUpdateUriParameter method just judgment string
                var value = '';
            }

            // mark this filter as active in the navbar-filters
            if (value !== '') {
                $('li[filter-name=FECHACOTIZACION]').removeClass('active').addClass('active');
            } else {
                $('li[filter-name=FECHACOTIZACION]').trigger('filter:clear');
            }


        }

        var dateRangeInput = $('#daterangepicker-FECHACOTIZACION').daterangepicker({
            timePicker: false,
            ranges: {
                'Today': [moment().startOf('day'), moment().endOf('day')],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
            },
            alwaysShowCalendars: true,
            autoUpdateInput: false
        });

        dateRangeInput.on('apply.daterangepicker', function(ev, picker) {
            applyDateRangeFilterFECHACOTIZACION(picker.startDate, picker.endDate);
            $(this).val(picker.startDate.format('YYYY/MM/DD') + ' - ' + picker.endDate.format('YYYY/MM/DD'));
            var pagenum = 0;
            var cadena = Urlcadena();
            var gridDiv = document.querySelector('#myGrid');
            ajaxUpdateUriParameter(gridDiv, itemsPorPagina, pagenum, cadena, true);
        });
        /*
            dateRangeInput.on('cancel.daterangepicker', function(ev, picker) {
                $(this).val('');
            });
            */

        $('li[filter-name=FECHACOTIZACION]').on('hide.bs.dropdown', function() {
            if ($('.daterangepicker').is(':visible'))
                return false;
        });

        $('li[filter-name=FECHACOTIZACION]').on('filter:clear', function(e) {
            // console.log('daterangepicker filter cleared');
            //if triggered by remove filters click just remove active class,no need to send ajax
            $('li[filter-name=FECHACOTIZACION]').removeClass('active');
            $(this).val('');
            $('#daterangepicker-FECHACOTIZACION').val('');
        });

        // datepicker clear button
        $(".daterangepicker-FECHACOTIZACION-clear-button").click(function(e) {
            e.preventDefault();
            applyDateRangeFilterFECHACOTIZACION(null, null);
            $('li[filter-name=FECHACOTIZACION]').trigger('filter:clear');
            var pagenum = 0;
            var cadena = Urlcadena();
            var gridDiv = document.querySelector('#myGrid');
            ajaxUpdateUriParameter(gridDiv, itemsPorPagina, pagenum, cadena, true);
        })
        //Filtro CAMPAÑA
        $('select[name=filter_CAMPAÑA]').not('[data-filter-enabled]').each(function() {
            var filterName = $(this).attr('data-filter-name');

            $(this).select2({
                allowClear: true,
                closeOnSelect: false,
                width: "100%",
                dropdownParent: $(this).parent('.form-group'),
                placeholder: $(this).attr('placeholder')
            });

            $(this).change(function() {
                var value = '';
                if ($(this).val() !== null) {
                    // clean array from undefined, null, "".
                    var values = $(this).val().filter(function(e) {
                        return e === 0 || e
                    });
                    // stringify only if values is not empty. otherwise it will be '[]'.
                    value = values.length !== 0 ? JSON.stringify(values) : '';

                }

                var pagenum = 0;
                var cadena = Urlcadena();
                var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv, itemsPorPagina, pagenum, cadena, true);

                // mark this filter as active in the navbar-filters
                if (value.length !== 0) {
                    $("li[filter-name=CAMPAÑA]").removeClass('active').addClass('active');
                } else {
                    //$("li[filter-name=CAMPAÑA]").removeClass("active");
                    //$("li[filter-name=CAMPAÑA]").find('.dropdown-menu').removeClass("show");
                    $("li[filter-name=CAMPAÑA]").trigger("filter:clear");
                }

            });


        });
        // when the dropdown is opened, autofocus on the select2
        $("li[filter-name=CAMPAÑA]").on('shown.bs.dropdown', function() {
            $('#filter_CAMPAÑA').select2('open');
        });
        // clear filter event (used here and by the Remove all filters button)
        $("li[filter-name=CAMPAÑA]").on('filter:clear', function(e) {
            // console.log('select2 filter cleared');
            $("li[filter-name=CAMPAÑA]").removeClass('active');
            $('#filter_CAMPAÑA').val(null).trigger('change.select2');
            //$("li[filter-name=CAMPAÑA] .select2").select2("val", "");
        });

        //Filtro ORIGEN
        $('#text-filter-ORIGEN').on('change', function(e) {
            var pagenum = 0;
            var value = $(this).val();
            var cadena = Urlcadena();
            var gridDiv = document.querySelector('#myGrid');
            ajaxUpdateUriParameter(gridDiv, itemsPorPagina, pagenum, cadena, true);

            // marque este filtro como activo en los filtros en navbar-filters
            if (value != '') {
                $('li[filter-name=ORIGEN]').removeClass('active').addClass('active');
            } else {
                $('li[filter-name=ORIGEN]').trigger('filter:clear');
            }

        });
        $('li[filter-name=ORIGEN]').on('filter:clear', function(e) {
            $('li[filter-name=ORIGEN]').removeClass('active');
            $('#text-filter-ORIGEN').val('');
        });
        // Limpiar button ORIGEN
        $(".text-filter-ORIGEN-clear-button").click(function(e) {
            e.preventDefault();
            $('li[filter-name=ORIGEN]').trigger('filter:clear');
            $('#text-filter-ORIGEN').val('');
            $('#text-filter-ORIGEN').trigger('change');
        });
        //Filtro PROVINCIA
        $('#text-filter-PROVINCIA').on('change', function(e) {
            var pagenum = 0;
            var value = $(this).val();
            var cadena = Urlcadena();
            var gridDiv = document.querySelector('#myGrid');
            ajaxUpdateUriParameter(gridDiv, itemsPorPagina, pagenum, cadena, true);

            // marque este filtro como activo en los filtros en navbar-filters
            if (value != '') {
                $('li[filter-name=PROVINCIA]').removeClass('active').addClass('active');
            } else {
                $('li[filter-name=PROVINCIA]').trigger('filter:clear');
            }

        });
        $('li[filter-name=PROVINCIA]').on('filter:clear', function(e) {
            $('li[filter-name=PROVINCIA]').removeClass('active');
            $('#text-filter-PROVINCIA').val('');
        });
        // Limpiar button PROVINCIA
        $(".text-filter-PROVINCIA-clear-button").click(function(e) {
            e.preventDefault();
            $('li[filter-name=PROVINCIA]').trigger('filter:clear');
            $('#text-filter-PROVINCIA').val('');
            $('#text-filter-PROVINCIA').trigger('change');
        });

        //Filtro DISTRITO
        $('#text-filter-DISTRITO').on('change', function(e) {
            var pagenum = 0;
            var value = $(this).val();
            var cadena = Urlcadena();
            var gridDiv = document.querySelector('#myGrid');
            ajaxUpdateUriParameter(gridDiv, itemsPorPagina, pagenum, cadena, true);

            // marque este filtro como activo en los filtros en navbar-filters
            if (value != '') {
                $('li[filter-name=DISTRITO]').removeClass('active').addClass('active');
            } else {
                $('li[filter-name=DISTRITO]').trigger('filter:clear');
            }

        });
        $('li[filter-name=DISTRITO]').on('filter:clear', function(e) {
            $('li[filter-name=DISTRITO]').removeClass('active');
            $('#text-filter-DISTRITO').val('');
        });
        // Limpiar button DISTRITO
        $(".text-filter-DISTRITO-clear-button").click(function(e) {
            e.preventDefault();
            $('li[filter-name=DISTRITO]').trigger('filter:clear');
            $('#text-filter-DISTRITO').val('');
            $('#text-filter-DISTRITO').trigger('change');
        });
        //Filtro SEGMENTO
        $('select[name=filter_SEGMENTO]').not('[data-filter-enabled]').each(function() {
            var filterName = $(this).attr('data-filter-name');

            $(this).select2({
                allowClear: true,
                closeOnSelect: false,
                width: "100%",
                dropdownParent: $(this).parent('.form-group'),
                placeholder: $(this).attr('placeholder')
            });

            $(this).change(function() {
                var value = '';
                if ($(this).val() !== null) {
                    // clean array from undefined, null, "".
                    var values = $(this).val().filter(function(e) {
                        return e === 0 || e
                    });

                    // stringify only if values is not empty. otherwise it will be '[]'.
                    value = values.length !== 0 ? JSON.stringify(values) : '';

                }


                var pagenum = 0;
                var cadena = Urlcadena();
                var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv, itemsPorPagina, pagenum, cadena, true);

                // mark this filter as active in the navbar-filters
                if (value.length !== 0) {
                    $("li[filter-name=SEGMENTO]").removeClass('active').addClass('active');
                } else {
                    //$("li[filter-name=SEGMENTO]").removeClass("active");
                    //$("li[filter-name=SEGMENTO]").find('.dropdown-menu').removeClass("show");
                    $("li[filter-name=SEGMENTO]").trigger("filter:clear");
                }

            });


        });
        // when the dropdown is opened, autofocus on the select2
        $("li[filter-name=SEGMENTO]").on('shown.bs.dropdown', function() {
            $('#filter_SEGMENTO').select2('open');
        });
        // clear filter event (used here and by the Remove all filters button)
        $("li[filter-name=SEGMENTO]").on('filter:clear', function(e) {
            // console.log('select2 filter cleared');
            $("li[filter-name=SEGMENTO]").removeClass('active');
            $('#filter_SEGMENTO').val(null).trigger('change.select2');
            //$("li[filter-name=SEGMENTO] .select2").select2("val", "");
        });

        //Filtro TIPIFICACION
        $('select[name=filter_TIPIFICACION]').not('[data-filter-enabled]').each(function() {
            var filterName = $(this).attr('data-filter-name');

            $(this).select2({
                allowClear: true,
                closeOnSelect: false,
                width: "100%",
                dropdownParent: $(this).parent('.form-group'),
                placeholder: $(this).attr('placeholder')
            });

            $(this).change(function() {
                var value = '';
                if ($(this).val() !== null) {
                    // clean array from undefined, null, "".
                    var values = $(this).val().filter(function(e) {
                        return e === 0 || e
                    });
                    console.log(values);
                    // stringify only if values is not empty. otherwise it will be '[]'.
                    value = values.length !== 0 ? JSON.stringify(values) : '';

                }
                console.log(value);

                var pagenum = 0;
                var cadena = Urlcadena();
                var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv, itemsPorPagina, pagenum, cadena, true);

                // mark this filter as active in the navbar-filters
                if (value.length !== 0) {
                    $("li[filter-name=TIPIFICACION]").removeClass('active').addClass('active');
                } else {
                    //$("li[filter-name=TIPIFICACION]").removeClass("active");
                    //$("li[filter-name=TIPIFICACION]").find('.dropdown-menu').removeClass("show");
                    $("li[filter-name=TIPIFICACION]").trigger("filter:clear");
                }

            });


        });
        // when the dropdown is opened, autofocus on the select2
        $("li[filter-name=TIPIFICACION]").on('shown.bs.dropdown', function() {
            $('#filter_TIPIFICACION').select2('open');
        });
        // clear filter event (used here and by the Remove all filters button)
        $("li[filter-name=TIPIFICACION]").on('filter:clear', function(e) {
            // console.log('select2 filter cleared');
            $("li[filter-name=TIPIFICACION]").removeClass('active');
            $('#filter_TIPIFICACION').val(null).trigger('change.select2');
            //$("li[filter-name=TIPIFICACION] .select2").select2("val", "");
        });

//Filtro TIPOTRANSF
    $('select[name=filter_TIPOTRANSF]').not('[data-filter-enabled]').each(function () {
            	var filterName = $(this).attr('data-filter-name');

                $(this).select2({
                	allowClear: true,
					closeOnSelect: false,
					width: "100%",
					dropdownParent: $(this).parent('.form-group'),
	        	    placeholder: $(this).attr('placeholder')
                });

                $(this).change(function() {
	                var value = '';
	                if ($(this).val() !== null) {
	                    // clean array from undefined, null, "".
	                    var values = $(this).val().filter(function(e){ return e === 0 || e });
	                    console.log(values);
	                    // stringify only if values is not empty. otherwise it will be '[]'.
	                    value = values.length !== 0 ? JSON.stringify(values) : '';
	                    
	                }
	                console.log(value);
	                
	                var pagenum=0;
    			    var cadena=Urlcadena();
    			    var gridDiv = document.querySelector('#myGrid');
                    ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
	                
					// mark this filter as active in the navbar-filters
					if (value.length!==0) {
						$("li[filter-name=TIPOTRANSF]").removeClass('active').addClass('active');
					}
					else
					{
						//$("li[filter-name=TIPOTRANSF]").removeClass("active");
						//$("li[filter-name=TIPOTRANSF]").find('.dropdown-menu').removeClass("show");
						$("li[filter-name=TIPOTRANSF]").trigger("filter:clear");
					}
					
				});

			
            });
            	// when the dropdown is opened, autofocus on the select2
				$("li[filter-name=TIPOTRANSF]").on('shown.bs.dropdown', function () {
					$('#filter_TIPOTRANSF').select2('open');
				});
				// clear filter event (used here and by the Remove all filters button)
				$("li[filter-name=TIPOTRANSF]").on('filter:clear', function(e) {
					// console.log('select2 filter cleared');
					$("li[filter-name=TIPOTRANSF]").removeClass('active');
	                $('#filter_TIPOTRANSF').val(null).trigger('change.select2');
	                //$("li[filter-name=TIPOTRANSF] .select2").select2("val", "");
				});



        //Filtro SUBTIPIFICACION
        $('select[name=filter_SUBTIPIFICACION]').not('[data-filter-enabled]').each(function() {
            var filterName = $(this).attr('data-filter-name');

            $(this).select2({
                allowClear: true,
                closeOnSelect: false,
                width: "100%",
                dropdownParent: $(this).parent('.form-group'),
                placeholder: $(this).attr('placeholder')
            });

            $(this).change(function() {
                var value = '';
                if ($(this).val() !== null) {
                    // clean array from undefined, null, "".
                    var values = $(this).val().filter(function(e) {
                        return e === 0 || e
                    });
                    console.log(values);
                    // stringify only if values is not empty. otherwise it will be '[]'.
                    value = values.length !== 0 ? JSON.stringify(values) : '';

                }
                console.log(value);

                var pagenum = 0;
                var cadena = Urlcadena();
                var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv, itemsPorPagina, pagenum, cadena, true);

                // mark this filter as active in the navbar-filters
                if (value.length !== 0) {
                    $("li[filter-name=SUBTIPIFICACION]").removeClass('active').addClass('active');
                } else {
                    //$("li[filter-name=SUBTIPIFICACION]").removeClass("active");
                    //$("li[filter-name=SUBTIPIFICACION]").find('.dropdown-menu').removeClass("show");
                    $("li[filter-name=SUBTIPIFICACION]").trigger("filter:clear");
                }

            });


        });
        // when the dropdown is opened, autofocus on the select2
        $("li[filter-name=SUBTIPIFICACION]").on('shown.bs.dropdown', function() {
            $('#filter_SUBTIPIFICACION').select2('open');
        });
        // clear filter event (used here and by the Remove all filters button)
        $("li[filter-name=SUBTIPIFICACION]").on('filter:clear', function(e) {
            // console.log('select2 filter cleared');
            $("li[filter-name=SUBTIPIFICACION]").removeClass('active');
            $('#filter_SUBTIPIFICACION').val(null).trigger('change.select2');
            //$("li[filter-name=SUBTIPIFICACION] .select2").select2("val", "");
        });
    </script>
    <!-- ACCIONES DEL DOM -->
    <script>
        $('#buscarnum').click(function() {
            var numero = $("#lblnclientebuscar").val();
            const contenedor = document.querySelector('#tblVentas tbody');
            while (contenedor.firstChild) {
                contenedor.removeChild(contenedor.firstChild);
            }
            if (numero == "") {
                alertify.warning("Número Vacio");
                $("#lblnclientebuscar").focus();
            } else {
                $.ajax({
                    url: 'ajax/findTranferencia.php',
                    method: "POST",
                    data: {
                        numero: numero
                    },
                    dataType: "json",
                    success: function(datos) {
                        console.log(datos);
                        if (datos !== null) {
                            for (let [llave, valor] of Object.entries(datos)) {
                                const row = document.createElement('tr');
                                if (valor.EstadoLead == "Transferido") {
                                    row.innerHTML = `   <td class="tblBody text-center">Transferido</td> 
                                                            <td class="tblBody text-center">${valor.Telefono}</td>
                                                            <td class="tblBody text-center">${valor.NDocumento}</td>
                                                            <td class="tblBody text-center">${valor.TipoTransferencia}</td>
                                                            
                                                            <td class="tblBody text-center">${valor.Nombres} ${valor.Apellidos}</td>
                                                        `

                                } else {
                                    row.innerHTML = `   <td class="tblBody text-center">
                                                                <a class="fa fa-user asignarGestor" data-id="${valor.IdLeadCC}" data-estado="${valor.EstadoLead}" href="#" title="Asignar Gestor" style="text-decoration:none;color:#4c4c4c"></a>
                                                            </td> 
                                                            <td class="tblBody text-center">${valor.Telefono}</td>
                                                            <td class="tblBody text-center">${valor.NDocumento}</td>
                                                            <td class="tblBody text-center">${valor.TipoTransferencia}</td>
                                                            <td class="tblBody text-center">${valor.Nombres} ${valor.Apellidos}</td>
                                                        `
                                }

                                //Agrega el HTML del carrito en el tbody 
                                contenedor.appendChild(row);
                            }
                        } else {
                            const row = document.createElement('tr');
                            row.innerHTML = ` <td colspan="4" class="tblBody text-center">No se encontro con ningun dato</td>`
                            //Agrega el HTML del carrito en el tbody 
                            contenedor.appendChild(row);
                        }
                    }
                });
            }
        });
        $('#tblVentas').on("click", function(e) {

            if (e.target.classList.contains('asignarGestor')) {
                const leadId = e.target.getAttribute('data-id');
                const EstadoLead = e.target.getAttribute('data-estado');
                <?php
                $html_tc = [];
                $sql_tc = "SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) GestorTC FROM yifi58ge_dbUSUARIO.tblusuario u  
                        INNER JOIN yifi58ge_dbUSUARIO.tblarea a on a.IdArea=u.IdArea
                        WHERE a.IdArea='40' and u.Estado='Activo'";
                $result_tc = mysqli_query($con, $sql_tc);
                if (mysqli_num_rows($result_tc) > 0) {
                    while ($row_t = mysqli_fetch_array($result_tc)) {
                        $html_tc[] = array_map("utf8_encode", ['id' => $row_t['Matricula'], 'text' => $row_t['Matricula'] . ' - ' . utf8_encode($row_t['GestorTC'])]);
                    }
                }
                ?>
                var array = <?php echo json_encode($html_tc); ?>;
                var options = {};
                $.map(array,
                    function(o) {
                        options[o.id] = o.text;
                    });
                console.log(EstadoLead);

                if (EstadoLead === null || EstadoLead === '' || EstadoLead === 'null') {
                    //SWAL
                    Swal.fire({
                        title: 'ASIGNACIÓN DEL GESTOR',
                        input: 'select',
                        inputOptions: options,
                        inputPlaceholder: 'Seleccionar Gestor',
                        showCancelButton: true,
                        confirmButtonColor: '#e4002b',
                        confirmButtonText: 'Asignar',
                        showLoaderOnConfirm: true,
                        preConfirm: (gestor) => {
                            let data = {
                                gestor: gestor,
                                leadId: leadId
                            };
                            console.log(data);
                            fetch('./ajax/insertTeleventaTransferencia.php', {
                                    method: 'POST',
                                    body: JSON.stringify(data)
                                })
                                .then(function(res) {
                                    console.log(res);
                                    return res.json();
                                })
                                .then(function(datos) {
                                    console.log(datos);
                                })
                                .catch(function(error) {
                                    Swal.showValidationMessage(
                                        `Solicitud ERROR: ${error}`
                                    )
                                })
                        },
                        allowOutsideClick: () => !Swal.isLoading()
                    }).then((result) => {
                        if (result.isConfirmed) {
                            Swal.fire(
                                'Transferido!',
                                'El lead ha sido transferido satisfactoriamente!',
                                'success'
                            )
                            $('#modal-asig').modal('hide');
                            var contenedor = document.querySelector('#tblVentas tbody');
                            while (contenedor.firstChild) {
                                contenedor.removeChild(contenedor.firstChild);
                            }
                            refresh();
                        }
                    })
                    //END SWAL    
                } else {
                    Swal.fire(
                        'Error!',
                        'El lead ya fue transferido a televenta',
                        'error'
                    )
                }
            } //END IF
        });
        $('#asig').click(function() {
            var selectrows = $('#selectedRows').text();
            var countselectedRows = $('#countselectedRows').text();
            var mensaje = '';

            if (selectrows == "" || selectrows.length == 0) {
                swal.fire(
                    'Alerta',
                    'Debes seleccionar un registro a asignar',
                    'warning');
            } else {

                $('#cboGestorTV').val('').trigger('change');
                $('#modal-asignar').modal('show');
                $('#selectedRowsModal').text(selectrows);
                $('#countselectedRowsModal').text(countselectedRows);
            }
        });
        $('#btnAsignar').on('click', function() {
            var selectrows = $('#selectedRowsModal').text();
            var countselectedRows = $('#countselectedRowsModal').text();
            var cboGestorTV = $('#cboGestorTV').val();
            if (cboGestorTV == "") {
                swal.fire(
                    'Alerta',
                    'Debes seleccionar Gestor',
                    'warning');
            } else {
                //Algunas variables por default de alertify
                alertify.defaults.theme.ok = "btn btn-nuevo";
                alertify.defaults.theme.cancel = "btn btn-danger";

                var lastX, lastY;
                if (countselectedRows == 1) {
                    mensaje = '¿Deseas  asignar de ' + countselectedRows + ' registro seleccionado?';
                } else {
                    mensaje = '¿Deseas asignar de los ' + countselectedRows + ' registros seleccionados?'
                }

                alertify.confirm('<span style="color:red"><i class="fa fa-warning"></i></span><strong> ADVERTENCIA</strong>', mensaje, function() {
                    var datos = {
                        cboGestorTV: cboGestorTV,
                        selectrows
                    };
                    console.log(datos);

                    $.ajax({
                        type: 'POST',
                        url: 'ajax/updateTVAsignarLead.php',
                        data: datos,
                        dataType: "Json",
                        success: function(r) {
                            console.log(r);
                            if (r.respuesta == "exito") {

                                swal.fire({
                                    title: 'Transferido!',
                                    text: 'Transferencia del Lead exitosa',
                                    type: 'success'
                                }).then((result) => {
                                    if (result.value) {
                                        $('#modal-asignar').modal('hide');
                                    }
                                });
                                $('#selectedRows').text('');
                                $('#countselectedRows').text('0');
                                $('#selectedRowsModal').text('');
                                $('#countselectedRowsModal').text('0');
                                refresh();
                            } else {
                                alertify.error("Fallo el server");

                            }
                        }
                    });


                }, function() {
                    alertify.error('Se ha cancelado las modificaciones')
                }).set({
                    transition: 'zoom',
                    'labels': {
                        ok: '<i class="fa fa-check"></i> Aceptar',
                        cancel: '<i class="fa fa-remove"></i> Cancelar'
                    },
                    'onshow': function() {

                        lastX = window.scrollX;
                        lastY = window.scrollY;
                    },
                    'onfocus': function() {
                        window.scrollTo(lastX, lastY);
                    }
                }).show();
            }

        });
    </script>
    <!-- DOCUMENT READY -->
    <script>
        $(document).ready(function() {
            listar(0);
            //listarBUSCAR();
            var alterClass = function() {
                var ww = document.body.clientWidth;
                if (ww < 767) {
                    $('body').removeClass('sidebar-collapse');

                } else if (ww >= 768) {
                    $('body').addClass('sidebar-collapse');
                }
            };
            $(window).resize(function() {
                alterClass();
            });
            //Fire it when the page first loads:
            alterClass();

            //USUARIO OPERADOR DE CALL CENTER
            if ($('#lblmatriculausuario').val() == 'NT9897') {
                $('#btnExportarTVLeads').addClass('ocultar');
            } else {
                $('#btnExportarTVLeads').removeClass('ocultar');
            }



            $('.selectgestor').select2({
                placeholder: 'Seleccione Gestor',
                allowClear: true,
                language: {
                    errorLoading: function() {
                        return "La carga falló";
                    },
                    noResults: function() {
                        return "No hay resultado";
                    },
                    searching: function() {

                        return "Buscando..";
                    }
                },
                ajax: {
                    url: 'ajax/selectGestor.php',
                    dataType: 'json',
                    delay: 250,
                    processResults: function(data) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                }
            });
            $('.cbxtelecierre').select2({
                placeholder: 'Seleccione Gestor TV',
                allowClear: true,
                language: {
                    errorLoading: function() {
                        return "La carga falló";
                    },
                    noResults: function() {
                        return "No hay resultado";
                    },
                    searching: function() {

                        return "Buscando..";
                    }
                },
                ajax: {
                    url: 'ajax/selectMatriculaTV_v2.php',
                    dataType: 'json',
                    delay: 250,
                    processResults: function(data) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                }
            });
        });
    </script>

    <!-- AUXILIARES -->
    <script>
        $('#btnExportarTVLeads').on('click', function(e) {
            Swal.fire({
                title: '¿Desea Exportar a CSV?',
                text: "Está accediendo a un información de propiedad de VERISURE PERU SAC; para ejercer esta acción asegúrese de contar con la autorización de la empresa o su Jefe Directo por escrito. Le recordamos que el uso de esta información se encuentra estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a la información o su uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente. Si usted revela información de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa y del Reglamento Interno, que podría incluso suponer la posible comisión de un delito o falta, con la consecuencia de despido.”",
                icon: 'info',
                showCancelButton: true,
                confirmButtonColor: '#333',
                confirmButtonText: 'Si, descargar'
            }).then((result) => {
                if (result.isConfirmed) {
                    window.open('./ajax/spout/exportTeleventaLead.php');
                }
            })
        })
    </script>

</body>

</html>