<?php
    session_start();
    if (!isset($_SESSION['user_login_status'])) {
            header("location: ./login/index.php");
    		exit;
            }
    
    if ($_SESSION['pzvtaconsulta']==0) {
         header("location: ./denegado.php");
    		exit;
            }


    date_default_timezone_set('America/Lima');
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }
    function format_date_dd_mm_Y($date)
    {
        return date('d/m/Y', strtotime($date));
    }
    function format_date_Y_mm_dd($date)
    {
        return date('Y-m-d', strtotime($date));
    }
    
    
    include 'config/db.php';
    include 'config/conexion.php';

?>


<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Verisure | VeriSmart</title>
        <!-- Tell the browser to be responsive to screen width -->
        <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
        <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png" >
        <!-- Bootstrap 3.3.7 -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
        <!-- Font Awesome -->
        <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
        <!-- Ionicons -->
        <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">
       <!-- Theme style -->
        <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
        <!-- AdminLTE Skins. Choose a skin from the css/skins
             folder instead of downloading all of them to reduce the load. -->
        <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">
        <!-- bootstrap datepicker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
        <!-- iCheck for checkboxes and radio inputs -->
        <link rel="stylesheet" href="admin/plugins/iCheck/all.css">
        <!-- Bootstrap time Picker -->
        <link rel="stylesheet" href="admin/plugins/timepicker/bootstrap-timepicker.min.css">
        <!-- Select2 -->
        <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">
        <!-- Bootstrap toogle-->
        <link href="admin/plugins/bootstrap-toggle-master/css/bootstrap-toggle.min.css" rel="stylesheet" type="text/css"/>
        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->
        <!-- Google Font -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
        <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
        <!-- DATE TIME PICKER -->
        <link href="admin/bower_components/bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.min.css" rel="stylesheet" type="text/css"/>
        <!-- Alertifyjs -->
        <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
        <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>
        <link href="admin/plugins/dropzone/dropzone.css" rel="stylesheet" type="text/css"/>
        <style>
            .control-label{
                text-align: left;
                margin: 5px 0;
                font-size: 12px;
                font-weight: 700;
            }
            
            .span-rojo{
                color: red;
            }
            
            .swal2-styled.swal2-confirm{
                background-color: #e4002b!important;
            }

        </style>
        <style>
        
            .ocultar{
                display:none;
            }

            .modal-header-danger {
                color:#fff;
                background-color: #e4002b;              
            }

            .ocultarcliente{
                display:none;
            }
            .ocultarcolaborador{
                display:none;
            }
            .preloader{
                background-color:#FFF;
                width: 100%;
                height: 100%;
                position: absolute;
                z-index: 1;
            }

            .dataTables_wrapper .myfilter .dataTables_filter{float:left}
            .dataTables_wrapper .mylength .dataTables_length{float:right}
            div.dataTables_scrollBody thead th {
                vertical-align: top;
            } 
            td {
                max-width: 250px;
                overflow: hidden;
                white-space: nowrap;
                text-overflow: ellipsis;

            }
            .espacio{
                height:10px;
            }
            
           .espacio2{
                height:15px;
            }

            .thumbnail_style{
                text-align:center;
                border:none;
            }


            .caption h4{
                margin-top: -10px;
                font-size:13px;
                font-weight:  bold;
            }

            .caption p{
                color:#777;
                font-size:13px;
            }

            .caption a{
                color:#777;
                font-size:10px;
            }


            #frmEditarVenta .form-control{
                border-radius: 4px
            }

            #c-slider{
                margin: auto;
                width: 100%;
                max-width: 900px;
                position: relative;
                overflow: hidden;

            }
            #slider{
                display: flex;
                width: 200%;

            }
            #slider section{
                width: 100%;
            }


            .select2-container--default .select2-selection--single {

                border: 1px solid #d2d6de;
                border-radius: 4px;font-size: 12px;
                padding:4px 6px;
            }

            .btn-nuevo { 
                color: #FFFFFF; 
                background-color: #444444; 
                border-color: #444444; 
            } 

            .btn-nuevo:hover, 
            .btn-nuevo:focus, 
            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
                color: #FFFFFF; 
                background-color: #616161;  
                border-color: #444444; 
            } 

            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
                background-image: none; 
            } 

            .btn-nuevo.disabled, 
            .btn-nuevo[disabled], 
            fieldset[disabled] .btn-nuevo, 
            .btn-nuevo.disabled:hover, 
            .btn-nuevo[disabled]:hover, 
            fieldset[disabled] .btn-nuevo:hover, 
            .btn-nuevo.disabled:focus, 
            .btn-nuevo[disabled]:focus, 
            fieldset[disabled] .btn-nuevo:focus, 
            .btn-nuevo.disabled:active, 
            .btn-nuevo[disabled]:active, 
            fieldset[disabled] .btn-nuevo:active, 
            .btn-nuevo.disabled.active, 
            .btn-nuevo[disabled].active, 
            fieldset[disabled] .btn-nuevo.active { 
                background-color: #444444; 
                border-color: #444444; 
            } 
            

            input[type=number]::-webkit-outer-spin-button,
            
            input[type=number]::-webkit-inner-spin-button {
            
                -webkit-appearance: none;
            
                margin: 0;
            
            }

 

            input[type=number] {
            
                -moz-appearance:textfield;
            
            }
        </style>
        
        <style>
            .main-header,.main-sidebar,.left-side{position:fixed}
           
            .main-header {
                top: 0;
                right: 0;
                left: 0
            }
             .content-wrapper,
             .right-side {
                padding-top: 50px
            }
            
            @media (max-width:767px) {
                 .content-wrapper,
                 .right-side {
                    padding-top: 100px
                }
            }
            
            .layout-boxed .wrapper {
                max-width: 100%
            }
            
            .wrapper {
                overflow: hidden
            
             .control-sidebar {
                position: fixed;
                height: 100%;
                overflow-y: auto;
                padding-bottom: 50px
            }


  </style>

        <style>
            

            .ui-autocomplete {
                position: absolute;
                z-index: 1000;
                cursor: default;
                padding: 0;
                margin-top: 2px;
                list-style: none;
                font-size: 11px;
                font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
                background-color: #ffffff;
                border: 1px solid #ccc;
                -webkit-border-radius: 5px;
                   -moz-border-radius: 5px;
                        border-radius: 5px;
                -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                   -moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                        box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                        
                    z-index: 1051 !important;    
                        
            }
            
            
            
            
            
               hr {
              height: 4px;
              width: 100%;
              background-color: #ecf0f5;
            
            }
            
            
            
            hr {
                /* margin-top: 20px; */
                margin-bottom: 20px;
                border: 0;
                /* border-top: 1px solid #eee; */
            }
            
            
            hr {
                display: block;
                unicode-bidi: isolate;
                -webkit-margin-before: 0.5em;
                -webkit-margin-after: 0.5em;
                -webkit-margin-start: auto;
                -webkit-margin-end: auto;
                overflow: hidden;
                border-style: inset;
               
            }
            
            .box.box-custom {
                border-top-color: #ffffff;
            }
            
            .box {
                position: relative;
                border-radius: 3px;
                background: #ffffff;
                border-top: 3px solid #d2d6de;
                margin-bottom: 5px;
                width: 100%;
                box-shadow: 0 1px 1px rgba(0,0,0,0.1);
            }
            
                    </style>
        
        <style>
            #divLoading {
                  background: rgba(66,118,164,0.4);
                  width: 100%;
                  height: 100%;
                  min-height: 100%;
                  position: absolute;
                  top: 0;
                  left: 0;
                  z-index: 10000;
                  display:none;
                }
            
            .spinner {
              margin: 300px auto 0;
              width: 70px;
              text-align: center;
            }
            
            .spinner > div {
              background-color: #E30613;
              width: 18px;
              height: 18px;
              border-radius: 100%;
              display: inline-block;
              -webkit-animation: sk-bouncedelay 1.4s infinite ease-in-out both;
              animation: sk-bouncedelay 1.4s infinite ease-in-out both;
            }
            
            .spinner .bounce1 {
              -webkit-animation-delay: -0.32s;
              animation-delay: -0.32s;
            }
            
            .spinner .bounce2 {
              -webkit-animation-delay: -0.16s;
              animation-delay: -0.16s;
            }
            
            @-webkit-keyframes sk-bouncedelay {
              0%, 80%, 100% { -webkit-transform: scale(0) }
              40% { -webkit-transform: scale(1.0) }
            }
            
            @keyframes sk-bouncedelay {
              0%, 80%, 100% { 
                -webkit-transform: scale(0);
                transform: scale(0);
              } 40% { 
                -webkit-transform: scale(1.0);
                transform: scale(1.0);
              }
            }

        .multimediaFisica {
            min-height: 0px;
            padding: 10px 10px;
            margin: 20px;
        }

</style>

    </head>
    <body class="sidebar-collapse skin-red sidebar-mini">
        <div id="divLoading" style="display: none;">
            <div class="spinner">
              <div class="bounce1"></div>
              <div class="bounce2"></div>
              <div class="bounce3"></div>
            </div>
        </div>
        <div class="wrapper">
            <!-- Header -->
            <?php include 'admin/header.php'; ?>
            <!-- Left side column. contains the logo and sidebar -->
            <?php


            $referidorppr="active";
            include 'admin/main-sidebar.php';

            ?>


            <!-- Content Wrapper. Contains page content -->
            <div class="content-wrapper">
                <!-- Content Header (Page header) -->
            <section class="content-header">
                <div style="font-size:180%;"> PROGRAMA COLABORADORES &nbsp</div> 
            </section>                
                <!-- Main content -->
                <section class="content">
                    <div class="row">
                        <div class="col-md-2"></div>
                        <div class="col-md-8">
                            <!-- /.box-header -->
                            <div class="box box-danger">
                                <div class="box-header">
                                    <h3 class="box-title">REGISTRO DE COLABORADOR</h3>
                                    <input id="lblcat" name="lblcat" hidden="">
                                    <div class="box-tools pull-right">
                                         <a href="consultaventa.php" id="regresar" class="btn btn-danger btn-sm" ><i class="fa fa-reply"></i></a>
                                    </div>
                                </div>
                                <div class="espacio"></div>
                            </div>
                            <!-- FORM -->
                            <form id="frmEditarVenta" method="POST">
                                <!-- COMERCIAL -->
                                <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                       <h5>INFORMACION DEL COLABORADOR</h5>
                        
                                      <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                        </button>
                                        
                                      </div>
                                    </div>
                                    <!-- /.box-header -->
                                    <div class="box-body">

                                        <input type="hidden" id="idCO" name="idCO">
                                        <div class="form-horizontal">
                                            <div class="row">
                                                <div class="col-xs-12 col-lg-6">
                                                    <div class="form-group">
                                                        <label class="col-xs-5 col-lg-6 control-label" for="lblprimernombre">PRIMER NOMBRE:<span class="span-rojo"> * </span> </label>
                                                        <div class="col-xs-7 col-lg-6">
                                                            <input type="text" name="lblprimernombre" id="lblprimernombre" value="" class="form-control input-sm" style="width: 100%;"> 
                                                            <input type="hidden" name="lblmatriculareg" id="lblmatriculareg" value="<?php echo $matriculausuario;?>"> 
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xs-12 col-lg-6">
                                                    <div class="form-group">
                                                        <label class="col-xs-5 col-lg-6 control-label" for="lblsegundonombre">SEGUNDO NOMBRE: </label>
                                                        <div class="col-xs-7 col-lg-6">
                                                            <input type="text" name="lblsegundonombre" id="lblsegundonombre" value="" class="form-control input-sm" style="width: 100%;"> 
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-xs-12 col-lg-6">
                                                    <div class="form-group">
                                                        <label class="col-xs-5 col-lg-6 control-label" for="lblapellidopaterno">APELLIDO PATERNO: <span class="span-rojo"> * </span> </label>
                                                        <div class="col-xs-7 col-lg-6">
                                                            <input class="form-control input-sm" name="lblapellidopaterno" id="lblapellidopaterno" style="width: 100%;" value="">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xs-12 col-lg-6">
                                                    <div class="form-group">
                                                        <label class="col-xs-5 col-lg-6 control-label" for="lblapellidomaterno">APELLIDO MATERNO: <span class="span-rojo"> * </span></label>
                                                        <div class="col-xs-7 col-lg-6">
                                                            <input class="form-control input-sm" name="lblapellidomaterno" id="lblapellidomaterno" style="width: 100%;" value="">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-xs-12 col-lg-6">
                                                    <div class="form-group">
                                                        <label class="col-xs-5 col-lg-6 control-label" for="lbltipodoc">TIPO DOCUMENTO: <span class="span-rojo"> * </span></label>
                                                        <div class="col-xs-7 col-lg-6">
                                                                <select class="form-control input-sm" name="lbltipodoc" id="lbltipodoc">
                                                                    <option value="">Seleccione</option>
                                                                    <option value="DNI">DNI</option>
                                                                    <option value="CE">CE</option>
                                                                </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xs-12 col-lg-6">
                                                    <div class="form-group">
                                                        <label class="col-xs-5 col-lg-6 control-label" for="lbldocumento">DOCUMENTO: <span class="span-rojo"> * </span></label>
                                                        <div class="col-xs-7 col-lg-6">
                                                            <input type="text" class="form-control input-sm" name="lbldocumento" id="lbldocumento" value="" maxlength="11" onkeypress="return filterFloat(event, this);">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-xs-12 col-lg-6">
                                                    <div class="form-group">
                                                        <label class="col-xs-5 col-lg-6 control-label" for="lbltelefono">TELEFONO: <span class="span-rojo"> * </span></label>
                                                        <div class="col-xs-7 col-lg-6">
                                                              <input type="text" class="form-control input-sm" name="lbltelefono" id="lbltelefono" value="" onkeypress="return event.charCode >= 48 && event.charCode <= 57" maxlength="9">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xs-12 col-lg-6">
                                                    <div class="form-group">
                                                        <label class="col-xs-5 col-lg-6 control-label" for="lblcorreo">CORREO: <span class="span-rojo"> * </span></label>
                                                        <div class="col-xs-7 col-lg-6">
                                                            <input type="text" class="form-control input-sm" id="lblcorreo" value="" name="lblcorreo">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-xs-12 col-lg-6">
                                                    <div class="form-group">
                                                        <label class="col-xs-5 col-lg-6 control-label" for="lblfechanacimiento">FECHA NACIMIENTO: <span class="span-rojo"> * </span></label>
                                                        <div class="col-xs-7 col-lg-6">
                                                            <div class="input-group">
                                                                <input type="text" class="form-control input-sm" id="lblfechanacimiento" name="lblfechanacimiento">
                                                                <div class="input-group-addon">
                                                                  <i class="fa fa-calendar"></i>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xs-12 col-lg-6">
                                                    <div class="form-group">
                                                        <label class="col-xs-5 col-lg-6 control-label" for="lbldireccion">DIRECCION: <span class="span-rojo"> * </span></label>
                                                        <div class="col-xs-7 col-lg-6">
                                                            <textarea class="form-control input-sm" name="lbldireccion" id="lbldireccion" rows="2" style="resize:none" placeholder="Ingresar..."></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-xs-12 col-lg-6">
                                                    <div class="form-group">
                                                        <label class="col-xs-5 col-lg-6 control-label" for="Departamental">DEPARTAMENTO: <span class="span-rojo"> * </span></label>
                                                        <div class="col-xs-7 col-lg-6">
                                                           <select class="form-control input-sm select2full" name="Departamental" id="Departamental" style="width: 100%">
                                                                <option value="" selected>Seleccione</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xs-12 col-lg-6">
                                                    <div class="form-group">
                                                        <label class="col-xs-5 col-lg-6 control-label" for="Provincial">PROVINCIA: <span class="span-rojo"> * </span></label>
                                                        <div class="col-xs-7 col-lg-6">
                                                           <select class="form-control input-sm select2full" name="Provincial" id="Provincial" style="width: 100%">
                                                                <option value="">Seleccione</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>                                            

                                            <div class="row">
                                                <div class="col-xs-12 col-lg-6">
                                                    <div class="form-group">
                                                        <label class="col-xs-5 col-lg-6 control-label" for="Distrital">DISTRITO: <span class="span-rojo"> * </span></label>
                                                        <div class="col-xs-7 col-lg-6">
                                                            <select class="form-control input-sm select2full" name="Distrital" id="Distrital" style="width: 100%">
                                                                <option value="">Seleccione</option>
                                                                <option value="NoIndica" disabled>No Indica</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xs-12 col-lg-6 hidden_estado hidden">
                                                    <div class="form-group">
                                                        <label class="col-xs-5 col-lg-6 control-label" for="EstadoColaborador">ESTADO COLABORADOR: <span class="span-rojo"> * </span></label>
                                                        <div class="col-xs-7 col-lg-6">
                                                            <select class="form-control input-sm" name="EstadoColaborador" id="EstadoColaborador" style="width: 100%">
                                                                <option value="Validado">Validado</option>
                                                                <option value="PendienteValidacion">PendienteValidación</option>
                                                                <option value="EliminarDatos">EliminarDatos</option>
                                                                <option value="NoValidado">NoValidado</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>                                                
                                            </div>

                                            <div class="row">
                                                <div class="col-xs-12 col-lg-6">
                                                    <div class="form-group">
                                                        <label class="col-xs-12 col-lg-6 control-label" for="archivoTC">T&C Y POLÍTICA DE PRIVACIDAD FIRMADOS: <span class="span-rojo"> * </span></label>
                                                        <div class="col-xs-12 col-lg-6">

                                                               <div class="form-group agregarMultimedia"> 
                                                                      <!--=====================================
                                                                      SUBIR MULTIMEDIA DE PRODUCTO FÍSICO
                                                                      ======================================-->
                                                                      
                                                                      <div class="multimediaFisica multimediaFisicaTC needsclick dz-clickable">
                                                                        <div class="dz-message needsclick">
                                                                          Arrastrar o dar click para subir imagenes.
                                                                        </div>
                                                                      </div>
                                                                </div>
                                                                <div id="imagenTC" class="hidden">
                    
                                                                </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xs-12 col-lg-6">
                                                    <div class="form-group">
                                                        <label class="col-xs-12 col-lg-6 control-label" for="archivoDNI">COPIA DNI: <span class="span-rojo"> * </span></label>
                                                        <div class="col-xs-12 col-lg-6">
                                                                <div class="form-group agregarMultimedia"> 
                                                                      <!--=====================================
                                                                      SUBIR MULTIMEDIA DE PRODUCTO FÍSICO
                                                                      ======================================-->
                                                                      
                                                                      <div class="multimediaFisica multimediaFisicaDNI needsclick dz-clickable">
                                                        
                                                                        <div class="dz-message needsclick">
                                                                          
                                                                          Arrastrar o dar click para subir imagenes.
                                                        
                                                                        </div>
                                                        
                                                                      </div>
                                                                </div>
                                                                <div id="imagenDNI" class="hidden">
                        
                                                                </div>                                                                 
                                                        </div>
                                                    </div>
                                                </div> 
                                            </div>
                                            <div class="row">
                                                <div class="col-xs-12 col-lg-6">
                                                    <div class="form-group">
                                                        <label class="col-xs-12 col-lg-6 control-label" for="archivoRecibo">RECIBO DE SERVICIOS BÁSICOS:</label>
                                                        <div class="col-xs-12 col-lg-6">
                                                                <div class="form-group agregarMultimedia"> 
                                                                      <!--=====================================
                                                                      SUBIR MULTIMEDIA DE PRODUCTO FÍSICO
                                                                      ======================================-->
                                                                      
                                                                      <div class="multimediaFisica multimediaFisicaRecibo needsclick dz-clickable">
                                                        
                                                                        <div class="dz-message needsclick">
                                                                          
                                                                          Arrastrar o dar click para subir imagenes.
                                                        
                                                                        </div>
                                                        
                                                                      </div>
                                                                </div>
                                                                <div id="imagenRecibo" class="hidden">
                            
                                                                </div>                                                                  
                                                        </div>
                                                    </div>
                                                </div> 
                                                <input type="hidden" id="datosImagenes">
                                            </div>
                                            
                                            <div class="row hidden_estado hidden">
                                                <div class="col-xs-12 col-lg-12">
                                                    <div class="form-group">
                                                        <label class="col-xs-12 col-lg-3 control-label" for="lblobservacion">OBSERVACIÓN:</label>
                                                        <div class="col-xs-12 col-lg-6">
                                                              <textarea rows="2" class="form-control input-sm" id="lblobservacion" name="lblobservacion" style="width: 100%;resize:none"></textarea>    
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-xs-12 col-lg-4">
                                                </div>
                                                <div class="col-xs-12 col-lg-4">
                                                    <div class="form-group">
                                                        <div class="col-xs-12 col-lg-12">
                                                        <label class="col-xs-12 col-lg-12"><input type="checkbox" name="aceptoterminos" value="1" aria-invalid="false" class="form-check-input" id="aceptoterminos"><span class="wpcf7-list-item-label"> Acepto los <a href="https://clientesverisure.com/terminos-y-condiciones-colaborador-externo" style="color: #828282;" target="_blank">Términos y Condiciones</a></span></label>
                                                        <label class="col-xs-12 col-lg-12"><input type="checkbox" name="aceptopolitica" value="1" aria-invalid="false" class="form-check-input" id="aceptopolitica"><span class="wpcf7-list-item-label"> Acepto <a href="https://clientesverisure.com/politica-de-privacidad-referido-colaborador" style="color: #828282;" target="_blank">Politica de Tratamiento de Datos</a></span></label>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xs-12 col-lg-4">
                                                </div>                                                
                                            </div> 
                                            
                                 
                                            <div class="row">
                                                <div class="col-xs-12 col-lg-4">
                                                </div>
                                                <div class="col-xs-12 col-lg-4">
                                                    <div class="form-group">
                                                        <div class="col-xs-12 col-lg-12">
                                                            <?php if($nombacceso=='test'){ } else{ ?>
                                                             <a class="btn btn-nuevo btn-sm btn-block" id="btnGuardarEditarVenta" href="#"><i class="fa fa-save"></i> ENVIAR</a>
                                                              <?php } ?>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xs-12 col-lg-4">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /.box-body -->
                                </div>

                            </form>
                            <!-- FORM -->
                        </div>
                         <div class="col-md-2"></div>
                    </div>
                </section>
                <!-- /.content -->
            </div>
            <!-- /.content-wrapper -->
            <div class="control-sidebar-bg"></div>
        </div>
        <!-- ./wrapper -->
        
        <!-- jQuery v1.11 -->
        <script src="admin/bower_components/jquery/dist/jquery_v1.11.js" type="text/javascript"></script>
        <!-- jQuery UI 1.11.4 -->
        <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
        <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
        <script>
        $.widget.bridge('uibutton', $.ui.button);</script>
        <!-- Bootstrap 3.3.7 -->
        <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
        <!-- Select2 -->
        <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
        <!-- Sparkline -->
        <script src="admin/bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>
       <!-- Slimscroll -->
        <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
        <!-- FastClick -->
        <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
        <!-- AdminLTE App -->
        <script src="admin/dist/js/adminlte.min.js"></script>
        <!-- InputMask -->
        <script src="admin/plugins/input-mask/jquery.inputmask.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.extensions.js"></script>
        <!-- bootstrap datepicker -->
        <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
        <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>
       <!-- bootstrap time picker -->
       <script src="admin/plugins/timepicker/bootstrap-timepicker.min.js" type="text/javascript"></script>
         <!-- Alertify -->
        <script src="admin/bower_components/alertifyjs/alertify.min.js" type="text/javascript"></script>
        <!-- SweetAlert -->
        <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <!-- Bootstrap toogle -->
        <script src="admin/plugins/bootstrap-toggle-master/js/bootstrap-toggle.min.js"></script>
        <script src="admin/plugins/dropzone/dropzone.js"></script>
        <!-- momentjs -->
        <script src="//cdnjs.cloudflare.com/ajax/libs/moment.js/2.15.2/moment.min.js"></script>        
        <!-- CONSTANTES GLOBALES -->
        <script>
            const queryString = window.location.search;
            const urlParams = new URLSearchParams(queryString);
            const accion = urlParams.get('accion');
            const idColaborador = urlParams.get('Id');
            const regresar = urlParams.get('rc');
            const PerfilUsuario = $('#headerPerfilUsuario').val();
            //Fecha y hora del momento
            const FechaActual = moment().format('DD/MM/YYYY HH:mm');
            let arregloImagenes = [];

            console.log(accion);
            console.log(urlParams);
        </script>
        <!-- INICIADORES -->
        <script>
            $('.selectdistrito').select2({
                placeholder: 'Seleccione Distrito - Provincia',
                allowClear: true,
                language: {
                    errorLoading: function () {
                        return "La carga falló";
                    },
                    noResults: function () {
                        return "No hay resultado";
                    },
                    searching: function () {

                        return "Buscando..";
                    }
                },
                ajax: {
                    url: 'ajax/selectDistritoField.php',
                    dataType: 'json',
                    delay: 250,
                    processResults: function (data) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                }
            });
            
            $('.select2full').select2({
              selectOnClose: true
            });
            $('#visitaConcertada').bootstrapToggle({
                on:'SI',
                off:'NO',
                onstyle:'success',
                offstyle:'danger'
            });
            
            $('#visitaConcertada').change(function(){
                if($(this).prop('checked')){
                    $('#hidVisitaConcertada').val('SI');
                    $('.datosVisitaConcertada').removeClass('ocultar');
                    //.classList().remove('ocultar');
                }else{
                    $('#hidVisitaConcertada').val('NO');
                    $('.datosVisitaConcertada').addClass('ocultar');
                    //.classList().add('ocultar');
                }    
            });
            
            //Date picker
            $('#lblfechanacimiento').datepicker({
                autoclose: true,
                language: 'es',
                firstDay: 1,
                todayHighlight: true,
                format: 'dd/mm/yyyy',
            });
        </script>
        <!-- EVENTOS -->
        <script>
            $("#lbltipoventa").change(function () {
               const tps= $("#lbltipoventa").val();
                $("#lbltiventa").val(tps);
                if(tps=="RPPR"){
                    $('.colaborador').removeClass('ocultarcolaborador');
                    $('.cliente').addClass('ocultarcliente');
                    
                }else if(tps=="RPPA"){
                    $('.colaborador').addClass('ocultarcolaborador');
                    $('.cliente').removeClass('ocultarcliente');
                }else{
                    $('.cliente').addClass('ocultarcliente');
                    $('.colaborador').addClass('ocultarcolaborador');
                }
            
            });
            
        </script>
        <!-- DOCUMENT READY -->
        <script>
            $(document).ready(function () {

                if(accion == 'actualizar'){
                    
                    
                $('#aceptoterminos').attr('checked', true);
                $('#aceptoterminos').attr('disabled', true);
                
                $('#aceptopolitica').attr('checked', true);
                $('#aceptopolitica').attr('disabled', true);
                
                $('#lbldocumento').attr('readonly', true);
                $('#lbltipodoc').attr('disabled', true);


                $("#btnGuardarEditarVenta").text('Modificar Datos');
                
                    cargarDatos(idColaborador);
                    
                    if(PerfilUsuario==1 || PerfilUsuario==15){
                        $('#regresar').attr('href', 'colaboradoresRPPR.php');
                    }
                    
                } else {
                
                    cargardepartamento();
                    
                }
                 
                 
                 
                $('#datemask').inputmask('dd/mm/yyyy', {
                    'placeholder': 'dd/mm/yyyy'
                });
                $('[data-mask]').inputmask();


                                
            })
        </script>
        <!-- BTN GUARDAR -->
        <script>

                //SUBIR IMAGENES

                var arrayFilesTC = [];
                
                
                
                $(".multimediaFisicaTC").dropzone({
                	url: "/",
                	addRemoveLinks: true,
                	acceptedFiles: ".jpeg, .jpg, .png, .pdf",
                	maxFilesize: 6, //2mb
                	maxFiles: 1, 	//maximo 1 archivos
                	init: function(){

                         this.on("maxfilesexceeded", function(file){
                                    Swal.fire(
                                      'Alerta', '¡No más archivos por favor! Se reemplaza con el último archivo..', 'warning'
                                    );                                    
                                });
                
                		this.on("addedfile", function(file){
                			arrayFilesTC.push(file);
                			console.log("arrayFilesTC", arrayFilesTC);
                		})
                		this.on("removedfile", function(file){
                			var index = arrayFilesTC.indexOf(file);
                			arrayFilesTC.splice(index, 1);
                			console.log("arrayFilesTC", arrayFilesTC);
                		})
                
                	},
                   maxfilesexceeded: function (files) {
                    this.removeAllFiles();
                    this.addFile(files);
                  },                	
                
                })
                
                var arrayFilesDNI = [];
                
                $(".multimediaFisicaDNI").dropzone({
                	url: "/",
                	addRemoveLinks: true,
                	acceptedFiles: ".jpeg, .jpg, .png, .pdf",
                	maxFilesize: 6, //2mb
                	maxFiles: 1, 	//maximo 1 archivos
                	init: function(){

                         this.on("maxfilesexceeded", function(file){
                                    Swal.fire(
                                      'Alerta', '¡No más archivos por favor! Se reemplaza con el último archivo..', 'warning'
                                    );                                    
                                });
                
                		this.on("addedfile", function(file){
                			arrayFilesDNI.push(file);
                			console.log("arrayFilesDNI", arrayFilesDNI);
                		})
                		this.on("removedfile", function(file){
                			var index = arrayFilesDNI.indexOf(file);
                			arrayFilesDNI.splice(index, 1);
                			console.log("arrayFilesDNI", arrayFilesDNI);
                		})
                
                	},
                   maxfilesexceeded: function (files) {
                    this.removeAllFiles();
                    this.addFile(files);
                  },                	
                
                })     
                

                var arrayFilesRecibo = [];
                
                $(".multimediaFisicaRecibo").dropzone({
                	url: "/",
                	addRemoveLinks: true,
                	acceptedFiles: ".jpeg, .jpg, .png, .pdf",
                	maxFilesize: 6, //2mb
                	maxFiles: 1, 	//maximo 1 archivos
                	init: function(){

                         this.on("maxfilesexceeded", function(file){
                                    Swal.fire(
                                      'Alerta', '¡No más archivos por favor! Se reemplaza con el último archivo..', 'warning'
                                    );                                    
                                });
                
                		this.on("addedfile", function(file){
                			arrayFilesRecibo.push(file);
                			console.log("arrayFilesRecibo", arrayFilesRecibo);
                		})
                		this.on("removedfile", function(file){
                			var index = arrayFilesRecibo.indexOf(file);
                			arrayFilesRecibo.splice(index, 1);
                			console.log("arrayFilesRecibo", arrayFilesRecibo);
                		})
                
                	},
                   maxfilesexceeded: function (files) {
                    this.removeAllFiles();
                    this.addFile(files);
                  },                	
                
                })             
        
            $('#btnGuardarEditarVenta').on('click', function(){
                $(this).prop('disabled', true);
                
            if(accion == 'registrar'){

                //DATOS

                const lblprimernombre = $("#lblprimernombre").val();
                const lblmatriculareg =$("#lblmatriculareg").val();
                const lblsegundonombre =$("#lblsegundonombre").val();
                const lblapellidopaterno =$("#lblapellidopaterno").val();
                const lblapellidomaterno =$("#lblapellidomaterno").val();
                const lbltipodoc =$("#lbltipodoc").val();
                const lbldocumento =$("#lbldocumento").val();
                const lbltelefono =$("#lbltelefono").val();
                const lblcorreo =$("#lblcorreo").val();
                const lblfechanacimiento =$("#lblfechanacimiento").val();
                const lbldireccion =$("#lbldireccion").val();
                const Departamental = $("#Departamental option:selected").text();
                const Provincial = $('#Provincial option:selected').text();
                const Distrital = $('#Distrital option:selected').text();
                const CodigoUbigeo= $('#Distrital').val();

                const datos = {
                    array:'array1',
                    lblprimernombre,
                    lblmatriculareg,
                    lblsegundonombre,
                    lblapellidopaterno,
                    lblapellidomaterno,
                    lbltipodoc,
                    lbldocumento,
                    lbltelefono,
                    lblcorreo,
                    lblfechanacimiento,
                    lbldireccion,
                    Departamental,
                    Provincial,
                    Distrital,
                    CodigoUbigeo,
                    arrayFilesTC,
                    arrayFilesDNI
                }
                

                 if (!$('#aceptoterminos').prop('checked') || !$('#aceptopolitica').prop('checked')) {
                                Swal.fire({
                                    title: '¡Advertencia!',
                                    text: "Aceptar las politicas y terminos.",
                                    icon: 'warning',
                                    showCancelButton: false,
                                    confirmButtonColor: '#636465',
                                    cancelButtonColor: '#8b8d8e',
                                    confirmButtonText: 'Muchas Gracias!'
                                });
                 } else{
                
                    if(validarForm(datos)){
    
                    const arrayResultado = [...arrayFilesTC , ...arrayFilesDNI,...arrayFilesRecibo];
                    console.log(arrayResultado);
                    
    
                                        Swal.fire({
                                            title: '¿Deseas guardar el colaborador?',
                                            icon: 'info',
                                            showCancelButton: true,
                                            confirmButtonText: 'Guardar',
                                        }).then((result) => {
                                          /* Read more about isConfirmed, isDenied below */
                                            if (result.isConfirmed) {
                                                
                                            $(this).prop('disabled', true);    
                                                
                                            var multimediaFisica = null;
                            
                            	   			var listaMultimedia = [];
                            	   			var finalFor = 0;
                            	   			var arrayFotos  = new Array();                                          
    
    	   			for(var i = 0; i < arrayResultado.length; i++){
    	   			    var error="";
    
    	   				var datosMultimedia = new FormData();
    	   				datosMultimedia.append("file", arrayResultado[i]);
    					datosMultimedia.append("lbldocumento", lbldocumento);
    					$.ajax({
    						url:"ajax/insertImagenesrppr.php",
    						method: "POST",
    						data: datosMultimedia,
    						cache: false,
    						contentType: false,
    						processData: false,
    						beforeSend: function() {
    						    $('.guardarProducto').html("Enviando ...");
    						 },
    						success: function(respuesta){
    						    error=respuesta;
    							listaMultimedia.push({"foto" : respuesta})
    							
    							
    							if((finalFor + 1) == arrayResultado.length){
    							    if(arrayResultado.length==2){
    							      listaMultimedia.push({"foto" : ""})  
    							    }
    							    
    							    multimediaFisica = JSON.stringify(listaMultimedia);
    							    
    							    datos.imagenes = multimediaFisica;
    							    
                                                $.ajax({
                                                    type: 'POST',
                                                    url: './Controller/ControllerReferidoRPPR.php',
                    	                            data: {function: JSON.stringify(datos)},
                                                    dataType: "Json",
                                                    success: function (datosR) {
                                                        console.log(datosR);
                                                        if(datosR.respuesta == 'exito'){
                                                        $(this).prop('disabled', false);    
                                                            Swal.fire({
                                                              title: "¡Colaborador registrado!",
                                                              text: "Se generó Colaborador N°" + datosR.idReferido,
                                                              icon: 'success',
                                                              confirmButtonColor: '#e4002b',
                                                              confirmButtonText: 'Ok',
                                                              allowOutsideClick: false
                                                            }).then((result) => {
                                                            //   location.href="consultaventa.php";
                                                            window.location.reload();
                                                            })
                                                        }else if(datosR.respuesta == 'duplicado'){
                                                                Swal.fire(
                                                                  'Alerta', 'Ya se encuentra registrado colaborador: '+ datosR.idReferido, 'warning'
                                                                );
                                                        
                                                        } else {
                                                            Swal.fire({
                                                                title: "Error",
                                                                text: "Comuniquese con soporte en desarrollo@verisure.pe",
                                                                icon: 'error'
                                                            });
                                                        }
                                                        
                                                    }
                                                })
    								
    								
    							}
    
    							finalFor++;
    							
    							console.log("Guardar imagen");
    							
    						}
    
    					})
    					
    					   if(error=='error'){
                                Swal.fire(
                                  'Error', 'Error al subir la imagen, por favor de verificar que no tengan acentos el nombre y sea de extensión .png,.jpg,.pdf,.jpeg', 'error'
                                );
    						    break; 
    					    }
    					
    	   				    
    	   			}
    
                                                
                                                
    
                                                
                                            } else if (result.isDenied) {
                                                $(this).prop('disabled', false);    
                                            }
                                        })
                    
    
                    }
                    
                 }
                
            }

            if(accion == 'actualizar'){

                const lblprimernombre = $("#lblprimernombre").val();

                const lblsegundonombre =$("#lblsegundonombre").val();
                const lblapellidopaterno =$("#lblapellidopaterno").val();
                const lblapellidomaterno =$("#lblapellidomaterno").val();
                const lbldocumento =$("#lbldocumento").val();
                const lbltelefono =$("#lbltelefono").val();
                const lblcorreo =$("#lblcorreo").val();
                const lblfechanacimiento =$("#lblfechanacimiento").val();
                const lbldireccion =$("#lbldireccion").val();
                const Departamental = $("#Departamental option:selected").text();
                const Provincial = $('#Provincial option:selected').text();
                const Distrital = $('#Distrital option:selected').text();
                const CodigoUbigeo= $('#Distrital').val();
                const Observacion=$("#lblobservacion").val();

                const datos = {
                    array:'array6',
                    lblprimernombre,
                    lblsegundonombre,
                    lblapellidopaterno,
                    lblapellidomaterno,
                    lbltelefono,
                    lblcorreo,
                    lblfechanacimiento,
                    lbldireccion,
                    Departamental,
                    Provincial,
                    Distrital,
                    CodigoUbigeo,
                    Observacion,
                    idColaborador
                }
    
                Swal.fire({
                    title: '¿Qué datos requiere modificar?',
                    html: '',
                    showDenyButton: true,
                    showCancelButton: true,
                    confirmButtonText: `Información`,
                    denyButtonText: `Imagenes`,
                    icon: 'info',
                }).then((result) => {
                    //Información
                    if (result.isConfirmed) {
                        
                        if(validarForm(datos)){

                                        Swal.fire({
                                            title: '¿Deseas modificar datos del colaborador?',
                                            icon: 'info',
                                            showCancelButton: true,
                                            confirmButtonText: 'Actualizar',
                                        }).then((result) => {
                                          /* Read more about isConfirmed, isDenied below */
                                            if (result.isConfirmed) {

                                            $.ajax({
                                                    type: 'POST',
                                                    url: './Controller/ControllerReferidoRPPR.php',
                    	                            data: {function: JSON.stringify(datos)},
                                                    dataType: "Json",
                                                    success: function (datosR) {
                                                        console.log(datosR);
                                                        if(datosR.respuesta == 'exito'){
                                                            Swal.fire({
                                                              title: "¡Colaborador modificado!",
                                                              text: "Datos actualizados",
                                                              icon: 'success',
                                                              confirmButtonColor: '#e4002b',
                                                              confirmButtonText: 'Ok',
                                                              allowOutsideClick: false
                                                            }).then((result) => {
                                                            window.location.reload();
                                                            })
                                                        }else if(datosR.respuesta == 'duplicado'){
                                                                Swal.fire(
                                                                  'Alerta', 'Ya se encuentra registrado colaborador: '+ datosR.idReferido, 'warning'
                                                                );
                                                        
                                                        } else {
                                                            Swal.fire({
                                                                title: "Error",
                                                                text: "Comuniquese con soporte en desarrollo@verisure.pe",
                                                                icon: 'error'
                                                            });
                                                        }
                                                        
                                                    }
                                                })

                                                
                                            } else if (result.isDenied) {
                                                $(this).prop('disabled', false);
                                                return;
                                            }
                                        })

                
                    
                        }
    
                    }
                    //Imagenes
                    else if (result.isDenied) {
                        
                        console.log(datos);
                        
                        if($('#datosImagenes').val().length>0){
                            arregloImagenes = JSON.parse($('#datosImagenes').val());
                        }else{
                            arregloImagenes.push({"foto" : ""})
                            arregloImagenes.push({"foto" : ""})
                            arregloImagenes.push({"foto" : ""})
                        }
                        

                        var multimediaFisica = null;
                        var listaMultimedia = [];
                        var finalFor = 0;
                        var arrayFotos  = new Array();
                        
                        if(arrayFilesTC.length>0){
                             subidaImagen(arrayFilesTC,lbldocumento,listaMultimedia,0);
                        }else{
                             
                             listaMultimedia.splice(0, 0, {"foto" : ""});
                        }

                        if(arrayFilesDNI.length>0){
                            subidaImagen(arrayFilesDNI,lbldocumento,listaMultimedia,1);
                        }else{
                             listaMultimedia.splice(1, 0, {"foto" : ""});
                        }

                        if(arrayFilesRecibo.length>0){

                            subidaImagen(arrayFilesRecibo,lbldocumento,listaMultimedia,2);
        					
                        }else{
                             listaMultimedia.splice(2, 0, {"foto" : ""});
                        }
                        

                        let timerInterval

                        Swal.fire({
                                        title: 'Guardando imagenes ....',
                                        html: '',
                                        timer: 5000,
                                        allowOutsideClick: false,
                                        didOpen: () => {
                                            Swal.showLoading()
                                        },
                                        onClose: () => {
                                            clearInterval(timerInterval)
                                        }
                                    }).then((result) => {
                                        if (result.dismiss === Swal.DismissReason.timer) {
                                            // window.close();
                                        }
                                    })

                                      
                        
                        setTimeout(function () {
                            
                             if(listaMultimedia.length>0){
                            
                            console.log(listaMultimedia.length);
                            console.log(arregloImagenes.length);
                            
                            for (var i = 0; i<listaMultimedia.length; i++){
                                
                                if(listaMultimedia[i].foto!=""){
                                        arregloImagenes[i] = {
                                          "foto": listaMultimedia[i].foto
                                        }
                                }
                                
                            }
                            
                           var imagenesJSON = JSON.stringify(arregloImagenes);
                            

                            const datos = {
                                array:'array7',
                                imagenes:imagenesJSON,
                                idColaborador
                            }                    
                            
                            $.ajax({
                            type: 'POST',
                            url: './Controller/ControllerReferidoRPPR.php',
                            data: {function: JSON.stringify(datos)},
                            dataType: 'json',
                            success: function (data) {
                                
                                 if(data){

                                     Swal.fire({
                                      title: "¡Modificado!",
                                      text: "Se modifico imagenes",
                                      icon: 'success',
                                      confirmButtonColor: '#e4002b',
                                      confirmButtonText: 'Ok',
                                      allowOutsideClick: false
                                    }).then((result) => {
                                        window.location.reload();
                                    })
     
                                    
                                 }else{
                                    Swal.fire(
                                      'Alerta!', 'No se modifico, por favor de revisar', 'warning'
                                    );                             
                                 }
                                
        
                            }
                            })  

                            console.log(imagenesJSON);
                            
                            
                        }                            
                            
                        }, 5000);                        


                    } else {
                        return;
                    }
                })            
    
                
                
              
                
                
                
            }

            })

            async function subidaImagen(arrayFiles,lbldocumento,listaMultimedia,posicion){


        	   			    var error="";
        	   				var datosMultimedia = new FormData();
        	   				datosMultimedia.append("file", arrayFiles[0]);
        					datosMultimedia.append("lbldocumento", lbldocumento);
        					await $.ajax({
        						url:"ajax/insertImagenesrppr.php",
        						method: "POST",
        						data: datosMultimedia,
        						cache: false,
        						contentType: false,
        						processData: false,
        						beforeSend: function() {
        						    $('.guardarProducto').html("Enviando ...");
        						 },
        						success: function(respuesta){
        						    error=respuesta;
        						    listaMultimedia.splice(posicion, 0, {"foto" : respuesta});
        							
        							if(error=='error'){
                                    Swal.fire(
                                      'Error', 'Error al subir la imagen, por favor de verificar que no tengan acentos el nombre y sea de extensión .png,.jpg,.pdf,.jpeg', 'error'
                                    );
        						    return;
        					        }

        							console.log("Guardar imagen");
        							
        						}
        
        					})
            }            
            
                        
            
            
            $('#EstadoColaborador').on('change',function(){
                
                $("#EstadoColaborador option:selected").each(function () {
                    const estado = $(this).val();

                    const datos = {
                        array:'array5',
                        estado,
                        idColaborador
                    }                    
                    

                    $.ajax({
                    type: 'POST',
                    url: './Controller/ControllerReferidoRPPR.php',
                    data: {function: JSON.stringify(datos)},
                    dataType: 'json',
                    success: function (data) {
                        
                         if(data){
                            Swal.fire(
                              'Modificado!', 'Se modifico el estado a: '+ estado, 'success'
                            );
                         }else{
                            Swal.fire(
                              'Alerta!', 'No se modifico ningun estado', 'warning'
                            );                             
                         }
                        
                        

                    }
                    })                    

                    
                });               
                
            });
            
        </script>
        <!-- FUNCIONES -->
        <script>

            function validarForm(datos){
                
                const {lblprimernombre,
                    lblmatriculareg,
                    lblapellidopaterno,
                    lblapellidomaterno,
                    lbltipodoc,
                    lbldocumento,
                    lbltelefono,
                    lblcorreo,
                    lblfechanacimiento,
                    lbldireccion,
                    Departamental,
                    Provincial,
                    Distrital,
                    CodigoUbigeo,
                    arrayFilesTC,
                    arrayFilesDNI
                } = datos;


                if (lblprimernombre == "") {
                    Swal.fire(
                      'Alerta', 'Por favor ingresar Nombre del Cliente', 'warning'
                    );
                    $("#frmEditarVenta #lblprimernombre").focus();
                    return false;
                }
                
                if (lblapellidopaterno == "") {
                    Swal.fire(
                      'Alerta', 'Por favor ingresar Nombre del Cliente', 'warning'
                    );
                    $("#frmEditarVenta #lblapellidopaterno").focus();
                    return false;
                }
                if (lblapellidomaterno == "") {
                    Swal.fire(
                      'Alerta', 'Por favor ingresar Nombre del Cliente', 'warning'
                    );
                    $("#frmEditarVenta #lblapellidomaterno").focus();
                    return false;
                }
                if (lbltipodoc == "") {
                    Swal.fire(
                      'Alerta', 'Por favor ingresar Nombre del Cliente', 'warning'
                    );
                    $("#frmEditarVenta #lbltipodoc").focus();
                    return false;
                }

                if (lbltipodoc == "DNI") {
                    if (lbldocumento.length!=8) {
                        alertify.warning("Por favor ingresar los 8 digitos del DNI");
                        $("#lbldocumento").focus();
                        return false;
                    }
                }
                
                if (lbltipodoc == "CE") {
                    if (lbldocumento.length==0) {
                       alertify.warning("Por favor ingresar CE");
                       $("#lbldocumento").focus();
                       return false;
                    }
                }                
                
                if (lbldocumento == "") {
                    Swal.fire(
                      'Alerta', 'Por favor ingresar Nombre del Cliente', 'warning'
                    );
                    $("#frmEditarVenta #lbldocumento").focus();
                    return false;
                }
                
                if (lbltelefono == "") {
                    Swal.fire(
                      'Alerta', 'Por favor ingresar Nombre del Cliente', 'warning'
                    );
                    $("#frmEditarVenta #lbltelefono").focus();
                    return false;
                }                
                
                if (lblcorreo == "" || !/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test(lblcorreo)) {
                    Swal.fire(
                      'Alerta', 'Por favor ingresar correo válido', 'warning'
                    );
                    $("#frmEditarVenta #lblcorreo").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }

                if (lblfechanacimiento == "") {
                    Swal.fire(
                      'Alerta', 'Por favor ingresar Nombre del Cliente', 'warning'
                    );
                    $("#frmEditarVenta #lblfechanacimiento").focus();
                    return false;
                }

                
                if (lbldireccion == "") {
                    Swal.fire(
                      'Alerta', 'Por favor ingresar la Direccion del Cliente', 'warning'
                    );
                    $("#frmEditarVenta #lbldireccion").focus();
                    return false;
                }
                if (Departamental == "") {
                    alertify.warning("Por favor ingresar Departamento correspondiente");
                    $("#Departamental").focus();
                    return false;
                }
                if (Provincial == "") {
                    alertify.warning("Por favor ingresar Pronvincia correspondiente");
                    $("#Provincial").focus();
                    return false;
                }
                if (Distrital == "") {
                    alertify.warning("Por favor ingresar Distrito correspondiente");
                    $("#Distrital").focus();
                    return false;
                }
                
                if(accion=="registrar"){

                    if(arrayFilesTC == "" || arrayFilesTC.length == 0 ){
    
                        Swal.fire(
                          'Alerta', 'Debes adjuntar imagen de T&C Y POLITICA DE PRIVACIDAD FIRMADOS','warning'
                        );
                        return false;                                    
                                        
                    }
                    if(arrayFilesDNI == "" || arrayFilesDNI.length == 0 ){
    
                        Swal.fire(
                          'Alerta', 'Debes adjuntar imagen Copia DNI','warning'
                        );
                        return false;                                    
                                        
                    }
                    
                }
                


                return true;
            }
            
            function filterFloat(evt, input) {
                // Backspace = 8, Enter = 13, ‘0′ = 48, ‘9′ = 57, ‘.’ = 46, ‘-’ = 43
                var key = window.Event ? evt.which : evt.keyCode;
                var chark = String.fromCharCode(key);
                var tempValue = input.value + chark;
                if (key >= 48 && key <= 57) {
                    if (filter(tempValue) === false) {
                        return false;
                    } else {
                        return true;
                    }
                } else {
                    if (key == 8 || key == 13 || key == 0) {
                        return true;
                    } else if (key == 46) {
                        if (filter(tempValue) === false) {
                            return false;
                        } else {
                            return true;
                        }
                    } else {
                        return false;
                    }
                }
            }

            function filter(__val__) {
                var preg = /^([0-9]+\.?[0-9]{0,2})$/;
                if (preg.test(__val__) === true) {
                    return true;
                } else {
                    return false;
                }

            }
        </script>

        <!-- EVENTOS -->
        <script>
            
            $("#Departamental").change(function () {
                $("#Departamental option:selected").each(function () {
                    var Provincial = $(this).val();
                    var datos={
                        Provincial:Provincial
                    };
                    var provincia= $("#Provincial");
                    var distrito= $("#Distrital");
                    
                     $.ajax({
                        data:datos,
                        url:   './ajax/selectProvincial.php',
                        type:  'POST',
                        dataType: 'json',
                        beforeSend: function () {
                            //provincia.prop('disabled', true);
                            //distrito.prop('disabled', true);
                        },
                        success:  function (r) {
                            provincia.prop('disabled', false);
                            distrito.prop('disabled', false);
                            
                            // Limpiamos el select de Provincia
                            provincia.find('option').remove();
                            provincia.append('<option value="">Seleccione</option>');
                            // Limpiamos el select de Distrito
                            distrito.find('option').remove();
                            distrito.append('<option value="">Seleccione</option>');
                            distrito.append('<option value="NoIndica">No Indica</option>');
                            
                            $(r).each(function(i, v){ // indice, valor
                                provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
                            })
                            
                            provincia.prop('disabled', false);
                            distrito.prop('disabled', false);
                        },
                        error: function(){
                            //alert('Ocurrio un error en el servidor ..');
                            provincia.prop('disabled', false);
                            distrito.prop('disabled', false);
                        }
                    });

                });
            });
            
        
            $("#Provincial").change(function () {
                $("#Provincial option:selected").each(function () {
                    var Provincial = $(this).val();
                    
                    var datos={
                        Provincial:Provincial
                    };
                    
                    var distrito = $("#Distrital");
                    
                    $.ajax({
                        data:datos,
                        url:   './ajax/selectDistrital.php',
                        type:  'POST',
                        dataType: 'json',
                        beforeSend: function () {
                           //provincia.prop('disabled', true);
                        },
                        success:  function (r) {
                            distrito.prop('disabled', false);
                            
                            // Limpiamos el select
                            distrito.find('option').remove();
                            distrito.append('<option value="">Seleccione</option>');
                            distrito.append('<option value="NoIndica">No Indica</option>');
                            
                            $(r).each(function(i, v){ // indice, valor
                                distrito.append('<option value="' + v.id + '">' + v.text + '</option>');
                            })
                            
                            distrito.prop('disabled', false);
                        },
                        error: function(){
                            //alert('Ocurrio un error en el servidor ..');
                            distrito.find('option').remove();
                            distrito.append('<option value="">Seleccione</option>');
                            distrito.append('<option value="NoIndica">No Indica</option>');
                            distrito.prop('disabled', false);
                        }
                    });
                    // END AJAX
                });
            });
                
         
            $('#Distrital').change(function() {
                const distrito = $(this);
                
                
                if(distrito.val() == 'NoIndica'){
                
                    var departamental= $("#Departamental");
                    var provincia= $("#Provincial");
                    
                    departamental.append('<option value="NoIndica" selected>No Indica</option>');
                    
                    provincia.find('option').remove();
                    provincia.append('<option value="NoIndica" selected>No Indica</option>');
                    
                    distrito.find('option').remove();
                    distrito.append('<option value="">Seleccione</option>');
                    distrito.append('<option value="NoIndica" selected>No Indica</option>');
                }
            })
          
            $(document).on('keydown', '.select2', function(e) {
                if (e.originalEvent && e.which == 40) {
                    e.preventDefault();
                    $(this).siblings('select').select2('open');
                } 
            });
            
            $(document).on("select2:close", '.select2-hidden-accessible', function () { $(this).focus(); });

            function cargardepartamento(departamento, provincia, distrito,accion){
                const Departamental = $("#Departamental");
                const EquifaxDepartamental = $('#EquifaxDepartamental');
                const Provincial= $("#Provincial");
                const Distrital= $("#Distrital");
                
                /*
                if(accion == 'actualizar'){
                    if(departamento == null || provincia == null || distrito == null){
                        Departamental.find('option').remove();
                        Departamental.append('<option value="">Seleccione</option>');
                        Departamental.append('<option value="NoIndica" selected>No Indica</option>');
                        Provincial.find('option').remove();
                        Provincial.append('<option value="">Seleccione</option>');
                        Provincial.append('<option value="NoIndica" selected>No Indica</option>');
                        // Limpiamos el select de Distrito
                        Distrital.find('option').remove();
                        Distrital.append('<option value="">Seleccione</option>');
                        Distrital.append('<option value="NoIndica" selected>No Indica</option>');
                        
                        return;
                    }
                }
                */
                
                 $.ajax({
                    url:   './ajax/selectDepartamental.php',
                    type:  'POST',
                    dataType: 'json',
                    success:  function (datos) {
                        
                        // Limpiamos el select de Departamento 
                        Departamental.find('option').remove();
                        Departamental.append('<option value="">Seleccione</option>');
                        Departamental.append('<option value="NoIndica">No Indica</option>');
                        //Departamento equifax
                        EquifaxDepartamental.find('option').remove();
                        EquifaxDepartamental.append('<option value="">Seleccione</option>');
                        //LLENAR LOS CAMPOS DEPARTAMENTO 
                        $(datos).each(function(i, v){ // indice, valor
                            if(v.id == departamento ){
                                Departamental.append('<option value="' + v.id + '" selected>' + v.text + '</option>');
                                EquifaxDepartamental.append('<option value="' + v.id + '">' + v.text + '</option>');
                            } else {
                                Departamental.append('<option value="' + v.id + '">' + v.text + '</option>');
                                EquifaxDepartamental.append('<option value="' + v.id + '">' + v.text + '</option>');
                            }
                        })
                        
                        //Seleccionar al departamento de Lima si es un nuevo registro
                        if(accion == 'actualizar'){
                            if(departamento == '' || departamento == null){
                                $("#Departamental option[value='NoIndica']").attr("selected",true);
                            }
                        } else {
                            
                            if(departamento == '' || departamento == null){
                                $("#Departamental option[value='15']").attr("selected",true);
                            }
                        }
                        
                        $("#Departamental option:selected").each(function () {
                            
                            const datos={
                                Provincial: $(this).val()
                            };

                            $.ajax({
                                data: datos,
                                url:   './ajax/selectProvincial.php',
                                type:  'POST',
                                dataType: 'json',
                                success:  function (data) {
                                    
                                    Provincial.prop('disabled', false);
                                    Distrital.prop('disabled', false);    
                                    // Limpiamos el select de Provincia
                                    Provincial.find('option').remove();
                                    Provincial.append('<option value="">Seleccione</option>');
                                    Provincial.append('<option value="NoIndica">No Indica</option>');
                                    // Limpiamos el select de Distrito
                                    Distrital.find('option').remove();
                                    Distrital.append('<option value="">Seleccione</option>');
                                    
                                    $(data).each(function(i, v){ // indice, valor
                                        if(v.id == provincia ){
                                            Provincial.append('<option value="' + v.id + '" selected>' + v.text + '</option>');
                                        } else {
                                            Provincial.append('<option value="' + v.id + '">' + v.text + '</option>');
                                        }
                                    })
                                    
                                    if(accion == 'actualizar'){
                                        if(provincia == '' || provincia == null){
                                            $("#Provincial option[value='NoIndica']").attr("selected",true);
                                        }
                                    } else {
                                        if(provincia == '' || provincia == null){
                                            $("#Provincial option[value='128']").attr("selected",true);
                                        }
                                    }
                                    
                                    $("#Provincial option:selected").each(function () {
                                        const datos={
                                            Provincial: $(this).val()
                                        };
                                        
                                        const Distrital= $("#Distrital");
                                        
                                        $.ajax({
                                            data:datos,
                                            url:   './ajax/selectDistrital.php',
                                            type:  'POST',
                                            dataType: 'json',
                                            success:  function (data) {
                                                
                                                // Limpiamos el select
                                                Distrital.find('option').remove();
                                                Distrital.append('<option value="">Seleccione</option>');
                                                Distrital.append('<option value="NoIndica">No Indica</option>');
                                                
                                                $(data).each(function(i, v){ // indice, valor

                                                    if(v.id == distrito ){
                                                        Distrital.append('<option value="' + v.id + '" selected>' + v.text + '</option>');
                                                    } else {
                                                        Distrital.append('<option value="' + v.id + '">' + v.text + '</option>');
                                                    }
                                                    
                                                }) //END EACH
                                                
                                                if(accion == 'actualizar'){
                                                    if(departamento == null){
                                                        $("#Distrital option[value='NoIndica']").attr("selected",true);
                                                    }
                                                } 
                                            } //END SUCCESS
                                        }); //END AJAX SELECT DISTRITAL
                                    }) //END EACH PROVINCIAL
                                } //END SUCCESS AJAX SELECT PROVINCIAL
                            })
                            
                        }) //END DEPARTAMENTAL SELECTED

                        $("#EquifaxDepartamental option[value='15']").attr("selected",true);

                        $("#EquifaxDepartamental option:selected").each(function () {

                            const datos={
                                Provincial: $(this).val()
                            };
                            
                            const EquifaxProvincial= $("#EquifaxProvincial");
                            const EquifaxDistrital= $("#EquifaxDistrital");
                            
                            $.ajax({
                                data:datos,
                                url:   './ajax/selectProvincial.php',
                                type:  'POST',
                                dataType: 'json',
                                success:  function (data) {
                                    // Limpiamos el select de Provincia
                                    EquifaxProvincial.find('option').remove();
                                    EquifaxProvincial.append('<option value="">Seleccione</option>');
                                    // Limpiamos el select de Distrito
                                    EquifaxDistrital.find('option').remove();
                                    EquifaxDistrital.append('<option value="">Seleccione</option>');
                                    
                                    $(data).each(function(i, v){ // indice, valor
                                        EquifaxProvincial.append('<option value="' + v.id + '">' + v.text + '</option>');
                                    })
                                    
                                    $("#EquifaxProvincial option[value='128']").attr("selected",true);
                                    
                                    $("#EquifaxProvincial option:selected").each(function () {
                                        
                                        const datos={
                                            Provincial: $(this).val()
                                        };
                                    
                                        $.ajax({
                                            data:datos,
                                            url:   './ajax/selectDistrital.php',
                                            type:  'POST',
                                            dataType: 'json',
                                            success:  function (data) {
                                                // Limpiamos el select
                                                EquifaxDistrital.find('option').remove();
                                                EquifaxDistrital.append('<option value="">Seleccione</option>');
                                                
                                                $(data).each(function(i, v){ // indice, valor
                                                    EquifaxDistrital.append('<option value="' + v.id + '">' + v.text + '</option>');
                                                })
                                                EquifaxDistrital.trigger('change');
                                                
                                                EquifaxDistrital.prop('disabled', false);
                                            }
                                        });

                                    });
                            
                                }
                            });

                        });
                    }
                 })
                
            }
            

            async function cargarDatos(idColaborador){
                
                datos ={array:'array4',
                        idColaborador: idColaborador
                        };
                
               await $.ajax({
                    type: 'POST',
                    url: './Controller/ControllerReferidoRPPR.php',
                    data: {function: JSON.stringify(datos)},
                    dataType: 'json',
                    success: function (data) {
                        
                        const datosCO = data[0];
                            
                         if(datosCO != null){
                            console.log(datosCO);
                            completarFormulario(datosCO);
                         }
                        
                        

                    }
                })
            }


            
            function completarFormulario(datosCO){
                

                const {PrimerNombre, SegundoNombre, ApellidoPaterno, ApellidoMaterno, TipoDocumento, Documento, Telefono, Correo, FechaNacimiento, Direccion, Distrito, Provincia, Departamento, CodUbigeoReniec, FechaHoraREG, MatriculaREG, EstadoReferido, Imagenes,IdDepartamental,IdProvincial,Observacion} = datosCO;
                
                
                $("#lblprimernombre").val(PrimerNombre);
                $("#lblmatriculareg").val();
                $("#lblsegundonombre").val(SegundoNombre);
                $("#lblapellidopaterno").val(ApellidoPaterno);
                $("#lblapellidomaterno").val(ApellidoMaterno);
                $("#lbltipodoc").val(TipoDocumento);
                $("#lbldocumento").val(Documento);
                $("#lbltelefono").val(Telefono);
                $("#lblcorreo").val(Correo);
                $("#lblfechanacimiento").val(FechaNacimiento);
                $("#lbldireccion").val(Direccion);
                $("#idCO").val(idColaborador);
                $(".hidden_estado").removeClass('hidden');
                $("#EstadoColaborador").val(EstadoReferido);
                
                $("#lblobservacion").val(Observacion);
                var datosImagenes=Imagenes || [];
                $('#datosImagenes').val(datosImagenes);
                
                
                
                
                cargardepartamento(IdDepartamental, IdProvincial, CodUbigeoReniec,accion);
                console.log(datosImagenes);
                var Imagen=JSON.parse(Imagenes) || [];
                

                
                if(Imagen !== '' || Imagen !==null){
                    if(Imagen.length>0){
                        for (var i = 0; i<Imagen.length; i++){
                            if(i==0){
                                $('#imagenTC').removeClass('hidden');
                                
                                if(Imagen[i].foto.search(".pdf")>0){
                                    $('#imagenTC').append('<div class="col-md-4"><div class="thumbnail"><a href="https://www.verismart.com.pe/verismart'+Imagen[i].foto.replace('../', '/')+'" download><img src="https://www.verismart.com.pe/verismart/img/icono-pdf.jpg" alt="T&C" style="width:100%"></a></div></div>');                                                     
                                }else{
                                    $('#imagenTC').append('<div class="col-md-4"><div class="thumbnail"><a href="https://www.verismart.com.pe/verismart'+Imagen[i].foto.replace('../', '/')+'" download><img src="https://www.verismart.com.pe/verismart'+Imagen[i].foto.replace('../', '/')+'" alt="T&C" style="width:100%"></a></div></div>');                                                     
                                }
                                
                        
                            }else if(i==1){
                                $('#imagenDNI').removeClass('hidden');
                                
                                if(Imagen[i].foto.search(".pdf")>0){
                                    $('#imagenDNI').append('<div class="col-md-4"><div class="thumbnail"><a href="https://www.verismart.com.pe/verismart'+Imagen[i].foto.replace('../', '/')+'" download><img src="https://www.verismart.com.pe/verismart/img/icono-pdf.jpg" alt="DNI" style="width:100%"></a></div></div>');                                                     
                                }else{
                                    $('#imagenDNI').append('<div class="col-md-4"><div class="thumbnail"><a href="https://www.verismart.com.pe/verismart'+Imagen[i].foto.replace('../', '/')+'" download><img src="https://www.verismart.com.pe/verismart'+Imagen[i].foto.replace('../', '/')+'" alt="DNI" style="width:100%"></a></div></div>');                                                     
                                }                                
                                
                            }else if(i==2){
                                if(Imagen[i].foto!==""){
                                $('#imagenRecibo').removeClass('hidden');
    
                                if(Imagen[i].foto.search(".pdf")>0){
                                    $('#imagenRecibo').append('<div class="col-md-4"><div class="thumbnail"><a href="https://www.verismart.com.pe/verismart'+Imagen[i].foto.replace('../', '/')+'" download><img src="https://www.verismart.com.pe/verismart/img/icono-pdf.jpg" alt="Recibo" style="width:100%"></a></div></div>');                                                     
                                }else{
                                    $('#imagenRecibo').append('<div class="col-md-4"><div class="thumbnail"><a href="https://www.verismart.com.pe/verismart'+Imagen[i].foto.replace('../', '/')+'" download><img src="https://www.verismart.com.pe/verismart'+Imagen[i].foto.replace('../', '/')+'" alt="Recibo" style="width:100%"></a></div></div>');                                                     
                                }
                                
                                    
                                }
                            }
                        }
                        
                    }
                    
                }


                    if(PerfilUsuario==1 || PerfilUsuario==15){
                        $('#regresar').attr('href', 'colaboradoresRPPR.php');
                    }else{
                        $("#lblobservacion").attr('disabled', true);
                        
                        if(EstadoReferido!=="NoValidado"){
                            $("#lblprimernombre").attr('readonly', true);
            
                            $("#lblsegundonombre").attr('readonly', true);
                            $("#lblapellidopaterno").attr('readonly', true);
                            $("#lblapellidomaterno").attr('readonly', true);
            
                            $("#lbltelefono").attr('readonly', true);
                            $("#lblcorreo").attr('readonly', true);
                            $("#lblfechanacimiento").attr('disabled', true);
                            $("#lbldireccion").attr('readonly', true);
            
                            $('#Departamental').attr('disabled', true);
                            $('#Provincial').attr('disabled', true);
                            $('#Distrital').attr('disabled', true);
                            
                            $("#EstadoColaborador").attr('disabled', true);
                            
                            $(".agregarMultimedia").addClass('hidden');
                            $("#btnGuardarEditarVenta").addClass('hidden');
                            
                        }
                        
                        
                    }                
                
            
                
            }

            
        </script>
        
    </body>
</html>
