<?php
    session_start();
    if (!isset($_SESSION['user_login_status'])) {
        header("location: ./login/index.php");
    	exit;
    }
    
    date_default_timezone_set('America/Lima');
    include 'config/db.php';
    include 'config/conexion.php';

    //include 'config/dbsec.php';
    //include 'config/conexionsec.php';

?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Verisure | VeriSmart</title>
        <!-- Tell the browser to be responsive to screen width -->
        <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
        <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png" >
        <!-- Bootstrap 3.3.7 -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
        <!-- Font Awesome -->
        <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
        <!-- Ionicons -->
        <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">

        <!-- Theme style -->
        <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
        <!-- AdminLTE Skins. Choose a skin from the css/skins
             folder instead of downloading all of them to reduce the load. -->
        <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">

        <!-- daterange picker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-daterangepicker/daterangepicker.css">
        <!-- bootstrap datepicker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
        <!-- iCheck for checkboxes and radio inputs -->
        <link rel="stylesheet" href="admin/plugins/iCheck/all.css">
        <!-- Bootstrap Color Picker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-colorpicker/dist/css/bootstrap-colorpicker.min.css">
        <!-- Bootstrap time Picker -->
        <link rel="stylesheet" href="admin/plugins/timepicker/bootstrap-timepicker.min.css">
        <!-- Select2 -->
        <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">
        <!-- Bootsrap Toogle -->
        <link href="admin/plugins/bootstrap-toggle-master/css/bootstrap-toggle.min.css" rel="stylesheet" type="text/css"/>

        <link href="admin/bower_components/bootstrap-table/dist/bootstrap-table.min.css" rel="stylesheet" type="text/css"/>
        <!-- bootstrap wysihtml5 - text editor -->
        <link rel="stylesheet" href="admin/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css">

        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->

        <link href="admin/bower_components/bootstrap-table/dist/bootstrap-table.min.css" rel="stylesheet" type="text/css"/>

        <!-- Google Font -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">

        <!-- Alertifyjs -->
        <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
        <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>

        <style>

            .callout {
                border-radius: 3px;
                margin: 0 0 20px 0;
                padding: 15px;
                border-left: 0px solid #eee;
            }
            @font-face {
                font-family: 'fontello';
                src: url('./font/fontello.eot?11113651');
                src: url('./font/fontello.eot?11113651#iefix') format('embedded-opentype'),
                url('./font/fontello.woff?11113651') format('woff'),
                url('./font/fontello.ttf?11113651') format('truetype'),
                url('./font/fontello.svg?11113651#fontello') format('svg');
                font-weight: normal;
                font-style: normal;
            }

            .demo-icon {
                font-family: "fontello";
                font-style: normal;
                font-weight: normal;
                /* speak: none; */
                display: inline-block;
                text-decoration: inherit;
                width: 1em;
                margin-right: .1em;
                text-align: center;
                /* opacity: .8; */
                font-variant: normal;
                text-transform: none;
                line-height: 1.7em;
                margin-left: .1em;
                /* font-size: 120%; */
                -webkit-font-smoothing: antialiased;
                -moz-osx-font-smoothing: grayscale;
                /* text-shadow: 1px 1px 1px rgba(127, 127, 127, 0.3); */
            }

        
            .thumbnail .caption {
                padding: 0px;
                color: #333;
                margin-bottom: 0px; 
            }

            .modal-header-success {
                color:#fff;
                background-color: #008d4c;              
            }
            .modal-header-danger {
                color:#fff;
                background-color: #fb1e1e;              
            }

            @media (min-height: 500px) {
              /*  .modal-body { height: 550px; }*/
            }

            @media (min-height: 800px) {
               /*  .modal-body { height: 550px; }*/
            }
            

            .espacio{
                height:10px;
            }

            .espacio2{
                height:15px;
            }

            .thumbnail_style{
                text-align:center;
                border:none;
            }
            .bg-gray {
                color: #666;
                background-color: #eeeeee !important;
            }

            .caption h4{
                margin-top: -10px;
                font-size:13px;
                font-weight:  bold;
            }

            .caption p{
                color:#777;
                font-size:13px;
            }

            .caption a{
                color:#777;
                font-size:10px;
            }


            #myWizard2 .form-control{
                border-radius: 4px
            }

            #c-slider{
                margin: 0;
                width: 100%;
                max-width: 900px;
                position: relative;
                overflow: hidden;

            }
            #slider{
                display: flex;
                width: 200%;

            }


            #slider section{
                width: 100%;
            }


            .select2-container--default .select2-selection--single {

                border: 1px solid #d2d6de;
                border-radius: 4px;font-size: 12px;
                padding:4px 6px;
            }

            .btn-nuevo { 
                color: #FFFFFF; 
                background-color: #444444; 
                border-color: #444444; 
            } 

            .btn-nuevo:hover, 
            .btn-nuevo:focus, 
            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
                color: #FFFFFF; 
                background-color: #616161;  
                border-color: #444444; 
            } 

            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
                background-image: none; 
            } 

            .btn-nuevo.disabled, 
            .btn-nuevo[disabled], 
            fieldset[disabled] .btn-nuevo, 
            .btn-nuevo.disabled:hover, 
            .btn-nuevo[disabled]:hover, 
            fieldset[disabled] .btn-nuevo:hover, 
            .btn-nuevo.disabled:focus, 
            .btn-nuevo[disabled]:focus, 
            fieldset[disabled] .btn-nuevo:focus, 
            .btn-nuevo.disabled:active, 
            .btn-nuevo[disabled]:active, 
            fieldset[disabled] .btn-nuevo:active, 
            .btn-nuevo.disabled.active, 
            .btn-nuevo[disabled].active, 
            fieldset[disabled] .btn-nuevo.active { 
                background-color: #444444; 
                border-color: #444444; 
            } 
            
            .btn-nuevo2 { 
                color: #444444;
                background-color: #eeeeee;
                border-color: #d2d6de;
            } 


            .btn-nuevo2:hover, 
            .btn-nuevo2:focus, 
            .btn-nuevo2:active, 
            .btn-nuevo2.active, 
            .open .dropdown-toggle.btn-nuevo2 { 
              color: #FFFFFF; 
              background-color: #616161; 
              border-color: #444444; 
            } 
 
            .btn-nuevo2:active, 
            .btn-nuevo2.active, 
            .open .dropdown-toggle.btn-nuevo2 { 
              background-image: none; 
            } 
             
            .btn-nuevo2.disabled, 
            .btn-nuevo2[disabled], 
            fieldset[disabled] .btn-nuevo2, 
            .btn-nuevo2.disabled:hover, 
            .btn-nuevo2[disabled]:hover, 
            fieldset[disabled] .btn-nuevo2:hover, 
            .btn-nuevo2.disabled:focus, 
            .btn-nuevo2[disabled]:focus, 
            fieldset[disabled] .btn-nuevo2:focus, 
            .btn-nuevo2.disabled:active, 
            .btn-nuevo2[disabled]:active, 
            fieldset[disabled] .btn-nuevo2:active, 
            .btn-nuevo2.disabled.active, 
            .btn-nuevo2[disabled].active, 
            fieldset[disabled] .btn-nuevo2.active { 
              background-color: #444444; 
              border-color: #444444; 
            } 
 
            .btn-nuevo2 .badge { 
              color: #444444; 
              background-color: #FFFFFF; 
            }
            
             .btn-nuevo3 {
                color: #fb1e1e;
                background-color: #ffffff;
                border-color: #d2d6de;
            }
            
            .btn-nuevo3:hover, 
            .btn-nuevo3:focus, 
            .btn-nuevo3:active, 
            .btn-nuevo3.active, 
            .open .dropdown-toggle.btn-nuevo3 { 
              color: #FFFFFF; 
              background-color: #dddddd; 
              border-color: #dddddd; 
              
            } 
             
            .btn-nuevo3:active, 
            .btn-nuevo3.active, 
            .open .dropdown-toggle.btn-nuevo3 { 
              background-image: none; 
            } 
             
            .btn-nuevo3.disabled, 
            .btn-nuevo3[disabled], 
            fieldset[disabled] .btn-nuevo3, 
            .btn-nuevo3.disabled:hover, 
            .btn-nuevo3[disabled]:hover, 
            fieldset[disabled] .btn-nuevo3:hover, 
            .btn-nuevo3.disabled:focus, 
            .btn-nuevo3[disabled]:focus, 
            fieldset[disabled] .btn-nuevo3:focus, 
            .btn-nuevo3.disabled:active, 
            .btn-nuevo3[disabled]:active, 
            fieldset[disabled] .btn-nuevo3:active, 
            .btn-nuevo3.disabled.active, 
            .btn-nuevo3[disabled].active, 
            fieldset[disabled] .btn-nuevo3.active { 
              background-color: #444444; 
              border-color: #444444; 
            } 
 


        </style>
        <style>
            .main-header,.main-sidebar,.left-side{position:fixed}
       
            .main-header {
            top: 0;
            right: 0;
            left: 0
            }
            .content-wrapper,
            .right-side {
            padding-top: 50px
            }
            
            @media (max-width:767px) {
            .content-wrapper,
            .right-side {
            padding-top: 100px
            }
            }
            
            .layout-boxed .wrapper {
            max-width: 100%
            }
            
            .wrapper {
            overflow: hidden
            
            .control-sidebar {
            position: fixed;
            height: 100%;
            overflow-y: auto;
            padding-bottom: 50px
            }       
        </style>
        <style> html, body { margin: 0; padding: 0; height: 100%; } </style>

        <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
        <style>

            .ui-autocomplete {
                position: absolute;
                z-index: 1000;
                cursor: default;
                padding: 0;
                margin-top: 2px;
                list-style: none;
                font-size: 11px;
                font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
                background-color: #ffffff;
                border: 1px solid #ccc;
                -webkit-border-radius: 5px;
                -moz-border-radius: 5px;
                border-radius: 5px;
                -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                -moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);

                z-index: 1051 !important;    

            }

            input[type="search"]::-webkit-search-cancel-button {
                -webkit-appearance: searchfield-cancel-button;
            }
            .swal2-popup {
                font-size: 1.5rem;
            }            
        </style>

    </head>


    <body class="sidebar-collapse skin-red sidebar-mini">

        <div class="wrapper">
            <!-- Header -->
            <?php include 'admin/header.php'; ?>
            <!-- Left side column. contains the logo and sidebar -->
            <?php

            $configamp="active";
            $amp="active";
    
            include 'admin/main-sidebar.php';
            ?>


            <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <div style="font-size:180%;"> F.U.C &nbsp <span style="font-size:80%;color:#DAD8D4"> | &nbsp <span style="font-size:80%;color:#8D8A80"> GENERAL </span></span> </div> 
                <ol class="breadcrumb">
                    <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
                    <li><a href="reclamos.php">F.U.C</a></li>
                    <li class="active">Registro de Solicitudes</li>
                </ol>


            </section>

            <!-- Main content -->
            <section class="content">
                <div class="row">
                    <div class="col-md-12">
                        <div class="box box-danger">
                            <div class="box-header">
                                <table  style="width:90%;">
                                    <tr>
                                        <td style="width: 7%;"><h3 class="box-title">BUSCAR:</h3></td>
                                        <td style="width: 83%;">
                                            <div class="input-group input-group-sm" style="width: 200px;">
                                                <input type="text" name="lblmatriculausuario" value="<?php echo $matriculausuario;?>" hidden="" id="lblmatriculausuario" >
                                                <input type="text" name="lblperfilusuario" value="<?php echo $nombacceso;?>" hidden="" id="lblperfilusuario" >
                                                <input type="text" name="lblnombreusuario" value="<?php echo $nombreusuario;?>" hidden="" id="lblnombreusuario" >
                                                <input type="search" name="table_buscar" oninput="onFilterChanged(this.value)" class="form-control" placeholder="Buscar..">

                                                <div class="input-group-btn">
                                                    <button type="submit" class="btn btn-default"><i class="fa fa-search"></i></button>
                                                </div>
                                            </div>
                                        </td>
                                        
                                    </tr>
                                    <tr><td>Total Registros: <span id="count"></span></td></tr> 
                                    <tr class="selectrow"><td colspan="2">N° Seleccionados: <span id="countselectedRows">0</span></td></tr>
                                </table>
                                <div class="box-tools pull-right">
                                    <!--<a class="btn btn-nuevo btn-sm"  href="#" style="border-radius: 0px;" onclick="javascript:window.location.reload();" title="Actualizar"><i class="fa fa-refresh"></i></a> -->
                                    <?php 
                                        if($nombacceso=='SupervisorCOB' || $nombacceso=='SupervisorCobranza' || $nombacceso=='GerenciaAdministracion' || $nombacceso=='MediosPagos' || $nombacceso=='Administrador'){
                                    ?>
                                    <button class="btn btn-primary btn-sm" name="btnCargarArchivo" id="btnCargarArchivo">Actualizar estados (Masiva)</button>
                                    
                                    <button type="button" class="btn btn-warning btn-sm" id="cambioEstado"><i class="fa fa-wrench"> Cambio Estado</i></button>
                                    <div class="btn-group">
                                          <button type="button" class="btn btn-success btn-sm dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
                                            <i class="fa fa-download"></i></button>
                                        <ul class="dropdown-menu" role="menu">
                                            <li><a href="#" onclick="Export()"><i class="fa fa-download"></i> Exportar TODO</a></li>
                                            <li><a href="#" onclick="ExportSeleccionados()"><i class="fa fa-download"></i> Exportar SELECCIONADOS</a></li>
                                        </ul>
                                    </div>                                    
                                    <?php 
                                        } 
                                    ?>
                                    <button type="submit" class="btn btn-danger btn-sm" style="border-radius: 0px;" data-toggle="modal" data-target="#modal-default" id="d"><i class="fa fa-plus"></i> Nueva solicitud</button>
                                    <a class="btn btn-nuevo btn-sm" href="#" style="border-radius: 0px;" onclick="javascript:window.location.reload();" title="Actualizar"><i class="fa fa-refresh"></i></a>
                                 
                                </div>
                            </div>
                            <!-- /.box-header -->

                            <div class="box-body" id="vistaboy">
                                <div id="myGrid"  style="height: 100%" class="ag-theme-fresh"></div>
                                <div  id="ningunresultado"></div>
                            </div>
                            <!-- /.box-body -->
                        </div>
                        <!-- /.box -->
                    </div>
                </div>
                <div class="test-header" style="display:none"><span id="selectedRows"></span></div>                
            </section>
            <!-- /.content -->
            <div class="modal fade" id="modal-default" style="overflow:hidden;">

                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header modal-header-danger">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h3 id="myModalLabel">VALIDAR CLIENTE</h3>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-xs-1"></div>
                                <div class="col-xs-10">
                                    <div class="form-group">
                                        <label class="col-sm-4 control-label" style="font-size: 18px;color: #444"> N° Cliente:</label>
                                        <div class="col-sm-8">
                                            <div class="input-group input-group-sm">
                                                <input type="text" class="form-control input-sm" name="lblnclientebuscar" id="lblnclientebuscar" placeholder="Buscar número cliente.." onkeypress="return event.charCode >= 48 && event.charCode <= 57" maxlength="7" >
                                                <div class="input-group-btn">
                                                    <button type="submit" id="buscarnum"  class="btn btn-nuevo2 btn-sm" style="border-radius: 0px;"><i class="fa fa-search"></i></button></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xs-1"></div>
                            </div>
                            <div class="espacio"></div>
                            <div id="resultado">
                                
                            </div>
                            <div id="ningunresultado3"></div>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-nuevo" data-dismiss="modal">Cerrar</button>
                        </div>
                    </div>  
                    <!-- /.modal-content -->
                </div>
                <!-- /.modal-dialog -->
            </div>
            <!-- MODAL CAMBIO DE ESTADO -->
            <div class="modal fade" id="modal-cambioEstado">
                <div class="modal-dialog">
                    <div class="modal-content">
                      <div class="modal-header modal-header-danger">
                          <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                          <h3 id="myModalLabel">CAMBIO DE ESTADO</h3>
                      </div>

                      <div class="modal-body">
                          <div class="row">
                              <div class="col-xs-1"></div>
                              <div class="col-xs-10">
                                  <div class="form-group">
                                      <label class="col-sm-4 control-label" style="font-size: 14px;color: #444"> ESTADO:</label>
                                      <div class="col-sm-8">
                                                    <select class="form-control input-sm" id="cboEstado" name="cboEstado" style="width: 100%;">
                                                        <option value="Seleccione" disabled selected>Seleccione</option>
                                                        <option value="Ingresado">Ingresado</option>
                                                        <option value="AvisoBO">Aviso a BO</option>
                                                        <option value="AvisoATC">Aviso a ATC</option>
                                                        <option value="AvisoMKT">Aviso a MKT</option>
                                                        <option value="AcargoMDP">A cargo de MDP</option>
                                                        <option value="AcargoCOB">A cargo de Cob</option>
                                                        <!--<option value="En proceso">En proceso</option>-->
                                                        <option value="Gestionado">Gestionado</option>
                                                        <option value="Rechazado">Rechazado</option>
                                                        <option value="Duplicado">Duplicado</option>
                                                    </select>
                                      </div>
                                  </div>
                              </div>
                              <div class="col-xs-1"></div>
                          </div>
                          <div class="espacio"></div>
                          <span style="display:none" id="selectedRowsModal"></span>
                          <span style="display:none" id="countselectedRowsModal">0</span>
                      </div>
                      <div class="modal-footer">
                <?php if($nombacceso=='test'){ } else{ ?>
                         <input type="button" class="btn btn-danger" id="btnCambioEstado" name="btnCambioEstado" value="Cambiar">
                <?php } ?>
                         
                          <button type="button" class="btn btn-nuevo" data-dismiss="modal">Cerrar</button>
                      </div>
                    </div>
                </div>
            </div>
            
            <!-- Modal Plantilla de importacion -->
            <div class="modal fade" id="modalPlantillas">
                <div class="modal-dialog modal-sm">
                    <div class="modal-content">
                        <div class="modal-header modal-header-danger">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h3>Actualización masiva</h3>
                        </div>
                        <div class="modal-body" style="background: #e2e2e2;">
                            <div class="box box-danger">
                                <div class="box-header with-border">
                                    <!--<h4 class="box-title">Actualizar estados de las solicitudes</h4> -->
                                </div>
                                <div class="box-body">
                                    <div class="form-group">
                                        <button class="btn btn-danger" id="btnDescargarSolicitudes" name="btnDescargarSolicitudes">Descargar Solicitudes Pendientes</button>
                                    </div>
                                    <form id="formularioImportar" enctype="multipart/form-data" action="ajax/importarSolicitudesActualizadas.php" method="POST">
                                        
                                        <!-- MAX_FILE_SIZE debe preceder al campo de entrada del fichero -->
                                        <input type="hidden" name="MAX_FILE_SIZE" value="40000" />
                                        <!-- El nombre del elemento de entrada determina el nombre en el array $_FILES -->
                                        <input class="form-control" id="inputPlantilla" name="inputPlantilla" type="file" />
                                        <input type="submit" class="btn btn-nuevo form-control" value="CARGAR ARCHIVO" />
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /.modal -->
            <!-- MODAL DETALLE DE SOLICITUD -->
            
            <div class="modal fade" id="modal-detalleSolicitud">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header modal-header-danger">
                          <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                          <h3 id="myModalLabel">DETALLE SOLICITUD</h3>
                        </div>

                        <div class="modal-body">
                            <div class="row">
                                <div class="col-xs-1"></div>
                            <div class="col-xs-10">
                                    <dl class="dl-horizontal" id="infoSolicitud">
                                        
                                    </dl>
                                    <dl class="dl-horizontal" id="detalleSolicitud">
                                    </dl>
                            </div>
                            <div class="col-xs-1"></div>
                        </div>

                      </div>
                      <div class="modal-footer">
                          <button type="button" class="btn btn-nuevo" data-dismiss="modal">Cerrar</button>
                      </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.content-wrapper -->



            <div class="control-sidebar-bg"></div>
        </div>
        <!-- ./wrapper -->

        <!-- jQuery v1.11 -->

        <script src="admin/bower_components/jquery/dist/jquery_v1.11.js" type="text/javascript"></script>
        <!-- jQuery UI 1.11.4 -->
        <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
        <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
        <script>$.widget.bridge('uibutton', $.ui.button);</script>
        <!-- Bootstrap 3.3.7 -->
        <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
        <!-- Select2 -->
        <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
        <!-- Sparkline -->
        <script src="admin/bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>

        <!-- jQuery Knob Chart -->
        <script src="admin/bower_components/jquery-knob/dist/jquery.knob.min.js"></script> 
        <!-- Bootstrap WYSIHTML5 -->
        <script src="admin/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js"></script>
        <!-- Slimscroll -->
        <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
        <!-- FastClick -->
        <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
        <!-- AdminLTE App -->
        <script src="admin/dist/js/adminlte.min.js"></script>


        <script src="admin/bower_components/bootstrap-table/dist/bootstrap-table.min.js" type="text/javascript"></script>
        <script src="admin/bower_components/ag-grid-master/dist/ag-grid.min.js" type="text/javascript"></script>
        <!-- InputMask -->
        <script src="admin/plugins/input-mask/jquery.inputmask.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.extensions.js"></script>

        <!-- date-range-picker -->
        <script src="admin/bower_components/moment/min/moment.min.js"></script>
        <script src="admin/bower_components/bootstrap-daterangepicker/daterangepicker.js"></script>
        <!-- bootstrap datepicker -->
        <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
        <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>
        <!-- bootstrap color picker -->
        <script src="admin/bower_components/bootstrap-colorpicker/dist/js/bootstrap-colorpicker.min.js"></script>
        <!-- bootstrap time picker -->
        <script src="admin/plugins/timepicker/bootstrap-timepicker.min.js"></script>
        <!-- Alertify -->
        <script src="admin/bower_components/alertifyjs/alertify.min.js" type="text/javascript"></script>
        <!-- SweetAlert -->
        <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <!--GRID -->
        <script>

            var columnDefs = [
                {
                    headerName: '',
                    field: 'IdDetalleSolicitud',
                    width: 90,
                    pinned: 'left',
                    cellRenderer: function (params) {
                        return '<a class="fa fa-map-o detalleSolicitud" href="#" id="'+ params.value +'" title="Ver Detalle Solicitud" style="text-decoration:none;color:#4c4c4c">\n\</a>';
                    },
                    headerCheckboxSelection: true,
                    headerCheckboxSelectionFilteredOnly: true,
                    checkboxSelection: true
                },
                {headerName: '#', field: 'IdSolicitud', width: 80},
                {headerName: 'SOLICITUD', field: 'Solicitud', width: 500},
                {headerName: 'FECHAREGISTRO', field: 'FechaHoraReg', width: 163,
                    filter:'date', filterParams: {
                    filterOptions: ['equals', 'notEqual', 'lessThan', 'lessThanOrEqual', 'greaterThan', 'greaterThanOrEqual', 'inRange'],
                    // use inRangeInclusive: true for the range filter to include the selected 
                    // from and to dates. Setting it false would fetch only the inbetween dates
                    inRangeInclusive: true,  
                    comparator: function(filterLocalDateAtMidnight, cellValue) {
                      //using moment js
                      var dateAsString = moment(cellValue).format('DD/MM/YYYY');
                      var dateParts = dateAsString.split("/");
                      var cellDate = new Date(Number(dateParts[2]), Number(dateParts[1]) - 1, Number(dateParts[0]));
                
                      if (filterLocalDateAtMidnight.getTime() == cellDate.getTime()) {
                        return 0
                      }
                
                      if (cellDate < filterLocalDateAtMidnight) {
                        return -1;
                      }
                
                      if (cellDate > filterLocalDateAtMidnight) {
                        return 1;
                      }
                    }
                  }
                },
                {headerName: 'NCliente', field: 'NCliente', width: 100},
                {headerName: 'ESTADO', field: 'Estado', width: 100},
                {headerName: 'GESTOR', field: 'NombreCompleto', width: 350},
                
            ];

            var gridOptions = {
                columnDefs: columnDefs,
                onPaginationChanged: onPaginationChanged,
                rowData: null,
                enableFilter: true,
                enableColResize: true,
                rowSelection: 'multiple',
                onSelectionChanged: onSelectionChanged,
                localeText: {
                    // for filter panel
                    page: 'página',
                    more: 'Más',
                    to: 'a',
                    of: 'de',
                    next: 'Siguiente',
                    last: 'Último',
                    first: 'Primero',
                    previous: 'Anterior',
                    loadingOoo: 'Cargando...',
                    // for set filter
                    selectAll: 'Seleccionar todo',
                    searchOoo: 'Buscando...',
                    blanks: 'Espacios en blanco',
                    // for number filter and text filter
                    filterOoo: 'Filtrar...',
                    applyFilter: 'Aplicar Filtro',
                    // for number filter
                    equals: 'Igual',
                    notEqual: 'No es igual',
                    lessThanOrEqual: 'Menor o igual',
                    greaterThanOrEqual: 'Mayor que o igual',
                    inRange: 'En el rango',
                    lessThan: 'Menos que',
                    greaterThan: 'Mas grande que',
                    // for text filter
                    contains: 'Contiene',
                    startsWith: 'Comienza con',
                    endsWith: 'Termina con',
                    notContains:'No contiene',
                    // the header of the default group column
                    group: 'Grupo',
                    // tool panel
                    columns: 'columnas',
                    rowGroupColumns: 'Grupo columnas',
                    rowGroupColumnsEmptyMessage: 'No hay resultado',
                    valueColumns: 'Columna de valor',
                    pivotMode: 'Modo pivote',
                    groups: 'grupos',
                    values: 'valor',
                    pivots: 'pivote',
                    valueColumnsEmptyMessage: 'No hay resultado',
                    pivotColumnsEmptyMessage: 'No hay resultado',
                    // other
                    noRowsToShow: '<div class="callout callout-danger">\n\
                                    <span class="pull-left">\n\
                                    <img src="admin/dist/img/noresults-img.png" style="width: 70%">\n\
                                    </span>\n\<h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>\n\
                                    <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>\n\
                                    <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>\n\
                                    <br></div>',
                    // enterprise menu
                    pinColumn: 'Aclar columna',
                    valueAggregation: 'Agregar valor',
                    autosizeThiscolumn: 'Auto tamaño esta columna ',
                    autosizeAllColumns: 'Auto tamaño todas columnas',
                    groupBy: 'Agrupar',
                    ungroupBy: 'Agrupar uno',
                    resetColumns: 'Restaurar Columnas',
                    expandAll: 'expandir todo',
                    collapseAll: 'desplegar todo',
                    toolPanel: 'Panel de Heramientas',
                    export: 'Exportar',
                    csvExport: 'Exportar CSV',
                    excelExport: 'Exportar Excel',
                    // enterprise menu pinning
                    pinLeft: 'Anclar a derecha',
                    pinRight: 'Anclar a izquierda',
                    noPin: 'Desanclar',
                    // enterprise menu aggregation and status panel
                    sum: 'Sumar',
                    min: 'Minimo',
                    max: 'Maximo',
                    first: 'Primero',
                            last: 'Ultimo',
                            none: 'Nada',
                    count: 'Contador',
                    average: 'Promedio',
                    // standard menu
                    copy: 'Copiar',
                    copyWithHeaders: 'Copiar Cabecera',
                    ctrlC: 'Ctrl+C',
                    paste: 'Pegar',
                    ctrlV: 'Ctrl+V'
                },
                enableSorting: true
            };

            function onSelectionChanged() {
                var selectedRows = gridOptions.api.getSelectedRows();
                var selectedRowsString = '';
                var countselectedRows=0;
                selectedRows.forEach(function(selectedRow, index) {
                    if (index!==0) {
                        selectedRowsString += ', ';
                        countselectedRows +=0;
                    }
                    
                    selectedRowsString += selectedRow.IdDetalleSolicitud;
                    countselectedRows +=1;
                });
                
                document.querySelector('#selectedRows').innerHTML = selectedRowsString;
                document.querySelector('#countselectedRows').innerHTML = countselectedRows;
            }

            function onPaginationChanged(params) {
                this.gridRowCount = params.api.paginationGetRowCount();
                $("#count").html(this.gridRowCount);
            }
            
            
            function onFilterChanged(value) {
                gridOptions.api.setQuickFilter(value);
            }

            function listar() {
                
                var gridDiv = document.querySelector('#myGrid');
                new agGrid.Grid(gridDiv, gridOptions);
                
                agGrid.simpleHttpRequest({url:'ajax/selectListarSolicitudesReclamo.php'}).then(function (data) {
                    gridOptions.api.setRowData(data);
                });
                
                $('#vistaboy').height(function (index, height) {
                    return $(window).height() * 65 / 100;
                });
            }

            function cambio(){
                $('#vistaboy').height(function (index, height) {
                return $(window).height() * 65 / 100;
                });
            
            }

            function refresh() {
                var gridDiv = document.querySelector('#myGrid');
                agGrid.simpleHttpRequest({url:'ajax/selectListarSolicitudesReclamo.php'}).then(function (data) {
                    console.log(data);
                    gridOptions.api.setRowData(data);
                });
                
                $('#vistaboy').height(function (index, height) {
                    return $(window).height() * 65 / 100;
                });                
            }
        </script>
        <!-- GLOBALES -->
        <script>
            const divResultado = document.querySelector('#resultado');
            const modalfooter = document.querySelector('.modal-footer');
        </script>
        <!-- DOCUMENT READY -->
        <script>
            $(document).ready(function () {
                //Cargar grilla
                listar();
                
                $(window).resize(() => { alterClass(); cambio(); });
                
                //Fire it when the page first loads:
                alterClass();
            });
    
        </script>
        <!-- EVENTOS -->
        <script>
            $('#buscarnum').click(function () {
                const ncliente=$('#lblnclientebuscar').val();
                
                if(ncliente==""){
                    alertify.warning("NCliente Vacio");
                    $("#lblnclientebuscar").focus();
                }else if (!/^([0-9])*$/.test(ncliente)){
                    alertify.warning("El valor " + ncliente + " no es un número");
                    $("#lblnclientebuscar").focus();
                }else {
                    $.ajax({
                        url: 'ajax/findDataNCliente_v2.php',
                        type: 'POST',
                        data: {ncliente: ncliente},
                        dataType:"json", 
                        success: function (data) {
                            
                            console.log(data);
                            
                            if(data.resultado == 'exito'){
                                
                                const {NombApellido, IdCliente} = data.datos;
                                
                                //Construccion del resultado en HTML
                                divResultado.innerHTML += `
                                    <div class="row">
                                        <div class="col-xs-1"></div>
                                        <div class="col-xs-10">
                                            <div id="vistaboy9">
                                                <div class="callout bg-gray">
                                                    <h4><i class="fa fa-user" style="color: #fe7474;"></i>¡CLIENTE!</h4>
                                                    <p>${NombApellido}</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                `;
                                
                                modalfooter.innerHTML += `
                                    <a class="btn btn-danger" href="editarsolicitud.php?idcliente=${IdCliente}">Registrar</a>
                                `
                                
                            } else {
                                divResultado.innerHTML += `
                                    <div class="row">
                                        <div class="col-xs-1"></div>
                                        <div class="col-xs-10">
                                            <div id="vistaboy9">
                                                <div class="callout bg-gray">
                                                    <h4><i class="fa fa-user" style="color: #fe7474;"></i>¡CLIENTE NO ENCONTRADO!</h4>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                `;
                                
                                modalfooter.innerHTML += `
                                    <a class="btn btn-danger" href="editarsolicitud.php">Registrar</a>
                                `
                            }
                            
                        }
                    });
                         
                }
            });
                
            $('#d').click(function () {
                $('#lblnclientebuscar').val('');
                document.getElementById("ningunresultado3").style.display="none";
            });
                        
            $("#lblnclientebuscar").on("keydown", function (event) {
                if (event.keyCode == $.ui.keyCode.DELETE || event.keyCode == $.ui.keyCode.BACKSPACE){
                    $('#lblnclientebuscar').val('');
                    document.getElementById("ningunresultado3").style.display="none";
                }
            });
            
            $('#cambioEstado').click(function(){

                var selectrows= $('#selectedRows').text();
                var countselectedRows=$('#countselectedRows').text();
                var mensaje='';
                
                console.log(selectrows);
                
                if(selectrows=="" || selectrows.length==0){
                    swal.fire(
                        'Alerta',
                        'Debes seleccionar un registro a cambiar estado',
                        'warning');
                }else{
                 
                    $('#cboEstado').val('Seleccione').trigger('change');
                    $('#modal-cambioEstado').modal('show');
                    $('#selectedRowsModal').text(selectrows);
                    $('#countselectedRowsModal').text(countselectedRows);
                }
            });   
            
            $('#btnCambioEstado').on('click', function(){
                
                $( ".cancel-button" ).prop( "disabled", false);
                $( ".habilitado-button" ).prop( "disabled", false);
                
                var selectrows= $('#selectedRowsModal').text();
                var countselectedRows= $('#countselectedRowsModal').text();
                var cboEstado=$('#cboEstado').val();
                
                if(cboEstado=="Seleccione"){
                    swal.fire(
                        'Alerta',
                        'Debes seleccionar una Estado',
                        'warning'); 
                }else{
                    //Algunas variables por default de alertify
                    alertify.defaults.theme.ok = "habilitado-button btn btn-nuevo";
                    alertify.defaults.theme.cancel = "cancel-button btn btn-danger";

                    var lastX,lastY;
                    if(countselectedRows==1){
                        mensaje='¿Deseas  asignar de '+countselectedRows+' registro seleccionado?';
                    }else{
                        mensaje='¿Deseas asignar de los '+countselectedRows+' registros seleccionados?'
                    }
                
                    alertify.confirm('<span style="color:red"><i class="fa fa-warning"></i></span><strong> ADVERTENCIA</strong>', mensaje, function(){ 
                        var datos = {cboEstado:cboEstado,selectrows};
                        console.log(datos);
                        
                        $( ".cancel-button" ).prop( "disabled", true);
                        $( ".habilitado-button" ).prop( "disabled", true);
                        
                        $.ajax({
                           type: 'POST',
                           url: 'ajax/updateEstadoSolicitud.php',
                           data: datos,
                           dataType: "Json",
                           success: function (r) {
                               console.log(r);
                                if (r.respuesta == "exito") {
                                    
                                     swal.fire({
                                            title: 'Modificado!',
                                            text: 'Modificación exitosa',
                                            type: 'success'
                                        }).then((result) => {
                                                if (result.value) {
                                                   $('#selectedRows').text('');
                                                   $('#countselectedRows').text('0');
                                                   $('#selectedRowsModal').text('');
                                                   $('#countselectedRowsModal').text('0');
                                                   $('#modal-cambioEstado').modal('hide');
                                                   refresh();
                                                }
                                        })
  
                                }
                                else {
                                    alertify.error("Fallo el server");
                                    $( ".cancel-button" ).prop( "disabled", false);
                                }
                           }
                        });
                        
                    }, function(){ $( ".cancel-button" ).prop( "disabled", false); alertify.error('Se ha cancelado las modificaciones')}).set({transition:'zoom','labels': {ok:'<i class="fa fa-check"></i> Aceptar', cancel:'<i class="fa fa-remove"></i> Cancelar'},'onshow':function(){
        
                        lastX = window.scrollX;
                        lastY = window.scrollY;
                    },
                    'onfocus':function(){
                        window.scrollTo(lastX, lastY);
                    }  }).show(); 
                }
            });
          
            $('#btnCargarArchivo').on('click', function(){
                $('#modalPlantillas').modal('show');
            })
            
            $('#btnDescargarSolicitudes').on('click', function(e){
                e.preventDefault();
                
                var conf = confirm("¿Desea Exportar a CSV?");
                if(conf == true){
                    window.open("./ajax/exportSolicitudesReclamoPendientes.php", '_blank');
                }
            })
            
            $('#formularioImportar').on('submit', function(e){
                
                e.preventDefault();
                
                var Form = new FormData($('#formularioImportar')[0]);
                console.log($('#formularioImportar')[0]);
                console.log(Form);
                
                $.ajax({
                    url: 'ajax/importarSolicitudesActualizadas.php',
                    type: 'post',
                    data: Form,
                    processData: false,
                    contentType: false,
                    cache: false,
                    success: function(data){
                        console.log(data);
                        const arrayResultado = JSON.parse(data);
                        
                        console.log(arrayResultado);
                        
                        let textohtml = `<table class="table table-striped">
                                            <tbody>
                                                <tr>
                                                    <th style="text-align: center!important;">FILA</th>
                                                    <th style="text-align: center!important;">ID SOLICITUD</th>
                                                    <th style="text-align: center!important;">RESULTADO</th>
                                                </tr>`;
                        
                        let i = 0;
                        
                        for (let fila of arrayResultado){
                            i++;
                            
                            let {respuesta, id} = fila;
                            
                            let icono;
                            if(respuesta == 'error'){
                                icono = '<i class="fa fa-close text-red"><i>';
                            } else if(respuesta == 'sincambios'){
                                icono = '<i class="fa fa-exclamation text-yellow">SIN CAMBIOS<i>';
                            } else {
                                icono = '<i class="fa fa-check text-green"><i>';
                            }
                            
                            textohtml += `<tr><td>${i}</td><td>${id}</td><td>${icono}</td><tr>`;
                            
                        }
                        
                        textohtml += '</tbody></table>';
                        
                        console.log(textohtml);
                        
                        Swal.fire({
                          title: '<strong><u>Resultado</u></strong>',
                          icon: 'info',
                          html: textohtml
                        })
                        
                        refresh();         
                    }
                    
                });
                
            })
            
            function limpiarHTML(cont) {
                //forma recomendada
                while (cont.firstChild) {
                    cont.removeChild(cont.firstChild);
                }
                
            }
            
            $(document).on('click', '.detalleSolicitud', function(e){
                const infoSolicitud = document.querySelector('#infoSolicitud');
                const detalleSolicitud = document.querySelector('#detalleSolicitud');
                limpiarHTML(infoSolicitud);
                limpiarHTML(detalleSolicitud);
                
                e.preventDefault();
                const Id = $(this).attr("id");
                console.log(Id);
                
                $.ajax({
                    type: 'post',
                    data: {tipo: 'solicitud', Id: Id},
                    url:'ajax/selectListarSolicitudesReclamo.php',
                    dataType: 'Json',
                    success: function(data){
                        console.log(data[0]);
                        
                        const datos = data[0];
                        
                        const {Solicitud, Detalle} = datos;
                        
                        const objDetalle = JSON.parse(Detalle);
                        
                        infoSolicitud.innerHTML += `
                                    <dt>Id Detalle Solicitud: </dt>
                                    <dd>${Id}</dd>
                                    <dt>Solicitud: </dt>
                                    <dd>${Solicitud}</dd>
                        `;
                        
                        const {columna1, columna2, columna3, columna4 , columna5, columna6, columna7, columna8, columna9, columna10} = objDetalle;
                        
                        detalleSolicitud.innerHTML += `
                            <dt>Columna1: </dt>
                            <dd>${columna1}</dd>
                            <dt>Columna2: </dt>
                            <dd>${columna2}</dd>
                            <dt>Columna3: </dt>
                            <dd>${columna3}</dd>
                            <dt>Columna4: </dt>
                            <dd>${columna4}</dd>
                            <dt>Columna5: </dt>
                            <dd>${columna5}</dd>
                            <dt>Columna6: </dt>
                            <dd>${columna6}</dd>
                            <dt>Columna7: </dt>
                            <dd>${columna7}</dd>
                            <dt>Columna8: </dt>
                            <dd>${columna8}</dd>
                            <dt>Columna9: </dt>
                            <dd>${columna9}</dd>
                            <dt>Columna10: </dt>
                            <dd>${columna10}</dd>
                        `;
                        
                        console.log(detalleSolicitud);
                    }
                })
                
                
                $('#modal-detalleSolicitud').modal('show');
            })
        </script>
        
        <script>
            function alterClass() {
                var ww = document.body.clientWidth;
                if (ww < 767) {
                    $('body').removeClass('sidebar-collapse');

                } else if (ww >= 768) {
                    $('body').addClass('sidebar-collapse');

                }
            };
        </script>
        
        <script>
            function Export(){
                var conf = confirm("¿Desea Exportar a CSV?");
                if(conf == true){
                    window.open("./ajax/exportSolicitudesReclamo.php", '_blank');
                }
            }
            
            function ExportSeleccionados(){
                var selectrows= $('#selectedRows').text();
                var countselectedRows=$('#countselectedRows').text();
                
                console.log(selectrows);
                console.log(countselectedRows);
                
                if(countselectedRows == '0'){
                    Swal.fire('Error', 'Seleccionar filas para exportar', 'error');
                    return;
                }
                
                Swal.fire({
                    title: '¿Desea Exportar a CSV?',
                    text: "Está accediendo a un información de propiedad de VERISURE PERU SAC; para ejercer esta acción asegúrese de contar con la autorización de la empresa o su Jefe Directo por escrito. Le recordamos que el uso de esta información se encuentra estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a la información o su uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente. Si usted revela información de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa y del Reglamento Interno, que podría incluso suponer la posible comisión de un delito o falta, con la consecuencia de despido.”",
                    icon: 'info',
                    showCancelButton: true,
                    confirmButtonColor: '#333',
                    cancelButtonColor: '#e4002b',
                    confirmButtonText: 'Si, descargar'
                }).then((result) => {
                    console.log(result.isConfirmed);
                    if (result.isConfirmed) {
                        window.open(`./ajax/exportSolicitudesReclamoSeleccionadas.php?selectrows=${selectrows}`, '_blank');
                    }
                })
                
            }
        </script>
        
      

    </body>
</html>