<?php

    function eliminar_tildes($cadena){

        //Codificamos la cadena en formato utf8 en caso de que nos de errores
        //$cadena = utf8_encode($cadena);
        
        //Ahora reemplazamos las letras
        $cadena = str_replace(
            array('á', 'à', 'ä', 'â', 'ª', 'Á', 'À', 'Â', 'Ä'),
            array('a', 'a', 'a', 'a', 'a', 'A', 'A', 'A', 'A'),
            $cadena
        );

        $cadena = str_replace(
            array('é', 'è', 'ë', 'ê', 'É', 'È', 'Ê', 'Ë'),
            array('e', 'e', 'e', 'e', 'E', 'E', 'E', 'E'),
            $cadena );

        $cadena = str_replace(
            array('í', 'ì', 'ï', 'î', 'Í', 'Ì', 'Ï', 'Î'),
            array('i', 'i', 'i', 'i', 'I', 'I', 'I', 'I'),
            $cadena );

        $cadena = str_replace(
            array('ó', 'ò', 'ö', 'ô', 'Ó', 'Ò', 'Ö', 'Ô'),
            array('o', 'o', 'o', 'o', 'O', 'O', 'O', 'O'),
            $cadena );

        $cadena = str_replace(
            array('ú', 'ù', 'ü', 'û', 'Ú', 'Ù', 'Û'),
            array('u', 'u', 'u', 'u', 'U', 'U', 'U'),
            $cadena );

        $cadena = str_replace(
            array('ñ', 'Ñ', 'ç', 'Ç'),
            array('n', 'N', 'c', 'C'),
            $cadena
        );

        return strtoupper($cadena);
    }

    /* FUNCIÓN PARA ANALIZAR LOS CAMPOS DEL FORMULARIO */
    function validaCampo($post, $parametros, $etiqueta, $con) { 
        $delimita = explode('|', trim(trim($parametros, '|')));
        //var_dump($delimita);
        $mensaje = '';
        foreach ($delimita as $items) {
            $valor = trim($items);
            $transValor = '';
            if (strpos($valor, 'minnumber') !== FALSE) {
                $temp = str_replace('minnumber', '', $valor);
                $temp = str_replace('[', '', $temp);
                $temp = str_replace(']', '', $temp);
                $transValor = (int) $temp;
            }
            if (strpos($valor, 'maxnumber') !== FALSE) {
                $temp = str_replace('maxnumber', '', $valor);
                $temp = str_replace('[', '', $temp);
                $temp = str_replace(']', '', $temp);
                $transValor = (int) $temp;
            }
            if (strpos($valor, 'minlength') !== FALSE) {
                $temp = str_replace('minlength', '', $valor);
                $temp = str_replace('[', '', $temp);
                $temp = str_replace(']', '', $temp);
                $transValor = (int) $temp;
            }
            if (strpos($valor, 'maxlength') !== FALSE) {
                $temp = str_replace('maxlength', '', $valor);
                $temp = str_replace('[', '', $temp);
                $temp = str_replace(']', '', $temp);
                $transValor = (int) $temp;
            }
            if (strpos($valor, 'matched') !== FALSE) {
                $temp = str_replace('matched', '', $valor);
                $temp = str_replace('[', '', $temp);
                $temp = str_replace(']', '', $temp);
                $data = explode('%', $temp);
                $otraEtiqueta = (string) $data[0];
                $otroPost = (string) $data[1];
            }
            $transEtiqueta = '<small>' . $etiqueta . '</small>';
            if (($valor == 'trim') && ($post != trim($post))) {
                $mensaje .= '<li>No se permiten espacios en los extremos. [CAMPO] ' . $transEtiqueta . '</li>';
            } else
            if (($valor == 'required') && ($post == '')) {
                $mensaje .= '<li>Completar el campo <b>' . $transEtiqueta . '</b>.</li>';
            } else
            if (($valor == 'alpha') && ($post != '') && (!preg_match("/^([[:alpha:]])*$/", $post))) {
                $mensaje .= '<li>Se permiten unicamente carácteres alfabéticos. [CAMPO] ' . $transEtiqueta . '</li>';
            } else
            if (($valor == 'alphanumeric') && ($post != '') && (!preg_match("/^([\.[:alnum:]])*$/", $post))) {
                $mensaje .= '<li>Se permiten unicamente carácteres alfanuméricos.[CAMPO] ' . $transEtiqueta . '</li>';
            } else
            if (($valor == 'numeric') && ($post != '') && (!preg_match("/^([[:digit:]])*$/", $post))) {
                $mensaje .= '<li>Se permiten unicamente carácteres numéricos. [CAMPO]. ' . $transEtiqueta . '</li>';
            } else
            if (($valor == 'alphaspace') && ($post != '') && (!ctype_alpha(str_replace(' ', '', $post)))) {
                $mensaje .= '<li>Se permiten únicamente carácteres alfabéticos y espacios. [CAMPO] ' . $transEtiqueta . '</li>';
            } else
            if (($valor == 'decimal') && ($post != '') && (!preg_match("/^[0-9]+(\.[0-9]+)?$/", $post))) {
                $mensaje .= '<li>Se permiten únicamente números enteros y decimales. [CAMPO] ' . $transEtiqueta . '</li>';
            } else
            if (($valor == 'date') && ($post != '') && (!preg_match('/^(\d\d\-\d\d\-\d\d\d\d){1,1}$/', $post))) {
                $mensaje .= '<li>Se permiten únicamente fechas con formato dd-mm-yyyy. [CAMPO] ' . $transEtiqueta . '</li>';
            } else
            if (($valor == 'dateDos') && ($post != '') && (!preg_match('/^(\d\d\d\d\-\d\d\-\d\d){1,1}$/', $post))) {
                $mensaje .= '<li>Se permiten únicamente fechas con formato yyyy-mm-dd. [CAMPO] ' . $transEtiqueta . '</li>';
            } else
            if (($valor == 'alphaspecial') && ($post != '') && (!preg_match('/^[.a-zñÑáéíóú\d_\s\/]+$/i', $post))) {
                $mensaje .= '<li>Se permiten únicamente carácteres alfabéticos especiales. [CAMPO] ' . $transEtiqueta . '</li>';
            } else
            if (($valor == 'name') && ($post != '') && (!preg_match('/^[a-zA-ZÀ-ÿ ]*$/', $post))) {
                $mensaje .= '<li>Se permiten únicamente carácteres alfabéticos y tildes. [CAMPO] ' . $transEtiqueta . '</li>';
            } else
            if (($valor == 'desplegables') && ($post != '') && (!ctype_alpha(str_replace(' ', '', $post)))) {
                $mensaje .= '<li>Se permiten únicamente carácteres alfabéticos y tildes. [CAMPO] ' . $transEtiqueta . '</li>';
            } else
            if (($valor == 'url') && ($post != '') && (!preg_match('/^[http:\/\/|www.|https:\/\/]/i', $post))) {
                $mensaje .= '<li>Se permiten únicamente direcciones con formato URL. [CAMPO] ' . $transEtiqueta . '</li>';
            } else
            if (($valor == 'ftp') && ($post != '') && (!preg_match('/^[ftp.]/i', $post))) {
                $mensaje .= '<li>Se permiten únicamente direcciones con formato FTP. [CAMPO] ' . $transEtiqueta . '</li>';
            } else
            if ((strpos($valor, 'minnumber') !== FALSE) && ($post != '') && ($post < $transValor)) {
                $mensaje .= '<li>El número ingresado es menor de ' . $transValor . '. [CAMPO] ' . $transEtiqueta . '</li>';
            } else
            if ((strpos($valor, 'maxnumber') !== FALSE) && ($post != '') && ($post > $transValor)) {
                $mensaje .= '<li>El número ingresado es mayor de ' . $transValor . '. [CAMPO] ' . $transEtiqueta . '</li>';
            } else
            if ((strpos($valor, 'minlength') !== FALSE) && ($post != '') && (mb_strlen($post) < $transValor)) {
                $mensaje .= '<li>El texto ingresado es menor a ' . $transValor . ' carácteres. [CAMPO] ' . $transEtiqueta . '</li>';
            } else
            if ((strpos($valor, 'maxlength') !== FALSE) && ($post != '') && (mb_strlen($post) > $transValor)) {
                $mensaje .= '<li>El texto ingresado es mayor a ' . $transValor . ' carácteres. [CAMPO] ' . $transEtiqueta . '</li>';
            } else
            if (($valor == 'email') && ($post != '') && (!preg_match('/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,})$/i', $post))) {
                $mensaje .= '<li>Se permiten únicamente direcciones de correo electrónico. [CAMPO] ' . $transEtiqueta . '</li>';
            } else
            if ((strpos($valor, 'matched') !== FALSE) && ($post != '' || $otroPost != '') && ($post != $otroPost)) {
                $mensaje .= ''
                        . '<li>No se relacionan. '
                        . '[CAMPO] <small>' . $etiqueta . '</small>'
                        . ' y '
                        . '[CAMPO] <small>' . $otraEtiqueta . '</small>'
                        . '</li>';
            }
        }
        if ($mensaje != '') {
            return $mensaje;
        } else {
            return '';
        }
    }

    /* FUNCIÓN PARA LIMPIAR LOS CAMPOS DEL FORMULARIO */
    function sanitizaCampo($post, $parametros, $con) { 
        $delimita = explode('|', trim(trim($parametros, '|')));

        foreach ($delimita as $items) {
            $valor = trim($items);
            $transValor = '';
            if($valor == 'sanitizeemail'){
                $post = filter_var($post, FILTER_SANITIZE_EMAIL);
            }
            if($valor == 'sanitizefloat'){
                $post = filter_var($post, FILTER_SANITIZE_NUMBER_FLOAT);
            }
            if($valor == 'sanitizeint'){
                $post = filter_var($post, FILTER_SANITIZE_NUMBER_INT);
            }
            if($valor == 'sanitizeip'){                
                if(!filter_var($post, FILTER_VALIDATE_IP)){
                    $post = mysqli_real_escape_string($con, $post);
                    $post = filter_var($post, FILTER_SANITIZE_URL);
                }
            }
            if($valor == 'sanitizeurl'){
                $post = filter_var($post, FILTER_SANITIZE_URL);
            }
            if($valor == 'sanitizestring'){
                $post = filter_var($post, FILTER_SANITIZE_STRING);
            }
            if($valor == 'scapestring'){
                $post = mysqli_real_escape_string($con, $post);
            }
            if($valor == 'htmlspecialchars'){
                $post = htmlspecialchars($post);                
            }
            if($valor == 'stringtonull'){
                if ($post == '' || empty($post)){
                    $post = NULL;
                }
                else if(!isset($post)){
                    $post = NULL;
                }else {
                    $post = $post;
                }
            }
        }
        if ($post != '') {
            return $post;
        } else {
            return '';
        }
    }
    
    
    
    function desanitizaCampo($post,$parametros){
         $delimita = explode('|', trim(trim($parametros, '|')));
        foreach ($delimita as $items) {
            $valor = trim($items);
            $transValor = '';
            if($valor == 'htmlspecialchars'){
                $post = htmlspecialchars_decode($post);                
            }            
            if($valor == 'scapestring'){
                $post = mysqli_unreal_escape_string($post);
            }

        }
        if ($post != '') {
            return $post;
        } else {
            return '';
        }
    }
    
    
    function mysqli_unreal_escape_string($string) {
    $characters = array('x00', 'n', 'r', '\\', '\'', '"','x1a');
    $o_chars = array("\x00", "\n", "\r", "\\", "'", "\"", "\x1a");
    for ($i = 0; $i < strlen($string); $i++) {
        if (substr($string, $i, 1) == '\\') {
            foreach ($characters as $index => $char) {
                if ($i <= strlen($string) - strlen($char) && substr($string, $i + 1, strlen($char)) == $char) {
                    $string = substr_replace($string, $o_chars[$index], $i, strlen($char) + 1);
                    break;
                }
            }
        }
    }
    return $string;
    }
    
    
    function eliminar_acentos($cadena){

		$cadena = utf8_encode($cadena);
		//Reemplazamos la A y a
		$cadena = str_replace(
		array('Á', 'À', 'Â', 'Ä', 'á', 'à', 'ä', 'â', 'ª'),
		array('A', 'A', 'A', 'A', 'a', 'a', 'a', 'a', 'a'),
		$cadena
		);

		//Reemplazamos la E y e
		$cadena = str_replace(
		array('É', 'È', 'Ê', 'Ë', 'é', 'è', 'ë', 'ê'),
		array('E', 'E', 'E', 'E', 'e', 'e', 'e', 'e'),
		$cadena );

		//Reemplazamos la I y i
		$cadena = str_replace(
		array('Í', 'Ì', 'Ï', 'Î', 'í', 'ì', 'ï', 'î'),
		array('I', 'I', 'I', 'I', 'i', 'i', 'i', 'i'),
		$cadena );

		//Reemplazamos la O y o
		$cadena = str_replace(
		array('Ó', 'Ò', 'Ö', 'Ô', 'ó', 'ò', 'ö', 'ô'),
		array('O', 'O', 'O', 'O', 'o', 'o', 'o', 'o'),
		$cadena );

		//Reemplazamos la U y u
		$cadena = str_replace(
		array('Ú', 'Ù', 'Û', 'Ü', 'ú', 'ù', 'ü', 'û'),
		array('U', 'U', 'U', 'U', 'u', 'u', 'u', 'u'),
		$cadena );

		//Reemplazamos la N, n, C y c
		$cadena = str_replace(
		array('Ñ', 'ñ', 'Ç', 'ç'),
		array('N', 'n', 'C', 'c'),
		$cadena
		);
		
		return $cadena;
	}    
    
?>