<?php
    session_start();
    if (!isset($_SESSION['user_login_status'])) {
        header("location: ./login/index.php");
    	exit;
    }

    if ($_SESSION['pzmktmarketing']==0) {
        header("location: ./denegado.php");
		exit;
    }
        
    $user = $_SESSION['id_usuario']; //MODIFICACION EMU 16.05

    date_default_timezone_set('America/Lima');
    
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }
    function format_date_dd_mm_Y($date){
        return date('d/m/Y', strtotime($date));
    }
    function format_date_Y_mm_dd($date){
        return date('Y-m-d', strtotime($date));
    }

    include 'config/db.php';
    include 'config/conexion.php';
    include 'helper/helper_validacion.php';

    if (isset($_GET['idventa'])) {
        $idventa = sanitizaCampo($_GET['idventa'], 'sanitizeint|scapestring|htmlspecialchars', $con);
        $idventa = htmlspecialchars($idventa);
    } else {
    	header("location: ./denegado.php");
    	exit;
    }

    $fechames=date("M-Y");
    

    try {
        
    $stmtCategoria = $con->prepare("SELECT
        u.IdUsuario,
        v.Matricula,
        v.Comercial,
        v.CC,
        v.JefeVenta,
        CONCAT(m.Nombres,' ',m.Apellidos) NombJefeVenta,
        v.EstadoVenta,
        v.CategoriaVenta,
        v.TipoVenta,
        v.Segmento,
        v.MesesAutorizado,
        v.NProspecto,
        v.NContrato,
        v.IdCliente,
        c.NombApellido Cliente,
        c.Correo,
        c.Telefonouno,
        c.Telefonodos,
        c.Direccion,
        c.Referencia,
        c.Interior,
        c.objGeofinder,
        g.IdGeografico,
        g.Distrito,
        g.Provincia,
        v.PrecioKit,
        v.TotalExtra,
        v.ResumenVenta,
        v.ExtraAutorizado,
        v.FormaPago,
        v.N590,
        v.PAI,
        v.CCOriginal,
    	v.EstadoVisita,
    	DATE_FORMAT(v.FechaVisita,'%d/%m/%Y') FechaVisita,
    	TIME_FORMAT(v.HoraVisita,'%r') HoraVisita,
    	DATE_FORMAT(v.FVencimientoVisita,'%d/%m/%Y') FVencimientoVisita,
    	DATE_FORMAT(v.FVisitaObras, '%d/%m/%Y') FVisitaObras,
    	v.FObras, 
    	v.GestorMKT,
    	CONCAT(mk.Nombres,' ',mk.Apellidos) Operador,
    	v.OrigenVisita,
    	v.GrupoACD,
    	v.ComentarioVisita,
        v.Checkin,
        v.InfoCheckIn,
        v.VisitaNoVisitable,
        v.infoVNOV,
        v.LeadID,
        agen.IdAgenda,
        agen.InstaladoX,
        agen.MatriculaTec,
        CONCAT(t.Nombres,' ',t.Apellidos) Instalador,
        t.LN LNInstalador,
        DATE_FORMAT(agen.FechaInst, '%d/%m/%Y') FechaInst, 
        TIME_FORMAT(agen.HoraInst,'%r') HoraInst,
        agen.Comentario,
        agen.MotivoInviable,
        agen.MotivoCancelada,
        agen.Repercusion,
        f.MotivoIncidencia,
        DATE_FORMAT(f.FechaRecepcionDOC, '%d/%m/%Y') FechaRecepcionDOC,
        DATE_FORMAT(f.FechaFacturacion, '%d/%m/%Y') FechaFacturacion,
        f.DOCOriginal,
        f.Segmentacion,
        f.Pago,
        f.Autoriza,
        f.DNI,
        f.ElementosCTOPS,
        f.DOCPAI,
        f.FaltaDOC,
        f.RehacerCTO,
        f.Afiliacion,
        f.Prospecto_NroGuia,
        f.FueraHora,
        v.EstadoTelecierre,
        v.TCGestor,
        v.TCComentario,
        v.PrecioKITOriginal,
        v.TotalExtraOriginal,
        v.ResumenVentaOriginal,
        v.ExtraAutorizadoOriginal,
        v.FormaPagoOriginal,
        v.MesesAutorizadoOriginal,
        v.PAIOriginal,
        v.TCMotivoNoVenta,
        v.TCTipoVenta,
        v.MesVisita,
        c.IdDocVisita,
        docv.TipoDocumento,
        docv.Documento,
        c.DireccionAprox,
        c.TipoDireccion,
        c.IdDireccion,
        tmp.AccionMKT as AccionTmp,
        tmp.FechaHoraReg,
        v.IdConsultaScoring,
        v.Accion,
        v.PerfilScoring,
        v.IdLead,
        c.TipoSegmento,
        c.NPiso,
        c.TipoVial,
        v.MotivoAsignacion,
        v.ContactoAsignacion,
        v.CumpleRanking,
        v.visePiso,
        v.rubroNeg,
        v.puertaCalle,
        v.nobleParedes,
        v.nobleTecho,
        v.metros,
        v.motivoInteres,
        v.conSistema,
        v.empresaSistema,
        v.bancarizado,
        l.FechaHoraCotizacion,
        c.Telefonotres,
        l.Gestion,
        v.SeAnula,
        v.ComentariosAnulacion,
        v.DetalleAnulacion,
        v.errorGestion,
        v.segundaDireccion
        FROM yifi58ge_dbVENTAS.tblventa v 
        INNER JOIN yifi58ge_dbUSUARIO.tblusuario u on v.IdUsuario=u.IdUsuario 
        INNER JOIN yifi58ge_dbUSUARIO.tblarea a on a.IdArea=u.IdArea 
        INNER JOIN yifi58ge_dbUSUARIO.tblusuario m on m.Matricula=u.Manager
        INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente
        INNER JOIN yifi58ge_dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
        INNER JOIN yifi58ge_dbVENTAS.tblagenda agen on agen.IdVenta=v.IdVenta
        INNER JOIN yifi58ge_dbVENTAS.tblfacturacion f on f.IdVenta=v.IdVenta
        LEFT JOIN yifi58ge_dbUSUARIO.tblusuario t on t.Matricula=agen.MatriculaTec
        LEFT JOIN yifi58ge_dbUSUARIO.tblusuario mk on mk.Matricula=v.GestorMKT
        LEFT JOIN yifi58ge_dbVENTAS.tbldocumento docv on docv.IdDoc=c.IdDocVisita
        LEFT JOIN yifi58ge_dbVENTAS.tbltmpscoring tmp on tmp.IdConsultaScoring=v.IdConsultaScoring
        LEFT JOIN yifi58ge_dbVENTAS.tblLeadCC l on l.IdLeadCC=v.IdLead
        WHERE v.IdVenta=?");
    $stmtCategoria->bind_param('i', $idventa);
    $stmtCategoria->execute();
    $stmtCategoria->store_result();
    $stmtCategoria->bind_result($idu,
$matricula,
$comercial,
$dc,
$matjefe,
$jefeventa,
$estadoventa,
$categoriaventa,
$tipoventa,
$segmento,
$mesesautorizados,
$nprospecto,
$ncontrato,
$idcliente,
$cliente,
$correo,
$movil,
$fijo,
$direccion,
$Referencia,
$Interior,
$objGeofinder,
$idgeografico,
$distrito,
$provincia,
$preciokit,
$totalextra,
$resumenventa,
$regaloutorizado,
$formadepago,
$n590,
$PAI,
$CCOriginal,
$estadovisita,
$fechavisita,
$horavisita,
$fvencimientovisita,
$FVisitaObras,
$FObras,
$matriculagestormkt,
$operadormkt,
$origenvisita,
$GrupoACD,
$comentariovisita,
$checkin,
$InfoCheckIn,
$VisitaNoVisitable,
$infoVNOV,
$LeadID,
$idagenda,
$instaladox,
$matriculatec,
$nomreinstalador,
$lninstalador,
$fechainstalacionver,
$horainstalacionver,
$comentarioagenda,
$motivoinviable,
$motivocancelado,
$repercucion,
$factmotivoincidencia,
$factfecharecepciondoc,
$factfechafacturacion,
$factdocoriginal,
$factsegmentacion,
$factpago,
$factautoriza,
$factdni,
$factelementosctops,
$factdocpai,
$factfaltadoc,
$factrehacercto,
$factafiliacion,
$factprospecto_nroguia,
$factfuerahora,
$estadotelecierre,
$TCGestor,
$TCComentario,
$PrecioKITOriginal,
$TotalExtraOriginal,
$ResumenVentaOriginal,
$ExtraAutorizadoOriginal,
$FormaPagoOriginal,
$MesesAutorizadoOriginal,
$PAIOriginal,
$TCMotivoNoVenta,
$TCTipoVenta,
$mesvisita,
$IdDocVisita,
$TipoDocumento,
$Documento,
$DireccionAprox,
$TipoDireccion,
$IdDireccion,
$lblAccionTmp,
$lblFechaHoraReg,
$lblIdConsultaScoring,
$lblAccion,
$lblPerfilScoring,
$IdLead,
$TipoSegmento,
$NPiso,
$TipoVial,
$MotivoAsignacion,
            $ContactoAsignacion,
            $CumpleRanking,
            $visePiso,
            $rubroNeg,
            $puertaCalle,
            $nobleParedes,
            $nobleTecho,
            $metros,
            $motivoInteres,
            $conSistema,
            $empresaSistema,
            $bancarizado,
            $FechaHoraCotizacion,
            $Telefonotres,
            $Gestion,
            $SeAnula,
            $ComentariosAnulacion,
            $DetalleAnulacion,
            $errorGestion,
            $segundaDireccion);
    $stmtCategoria->fetch();


$objGeofinder=desanitizaCampo($objGeofinder,'htmlspecialchars|htmlspecialchars|scapestring');

            if($InfoCheckIn != '' || $InfoCheckIn != null){
                $objCheckIn=json_decode($InfoCheckIn, true);
                
                $Distancia= number_format (floatval($objCheckIn['Distancia']), 2);
                $FechaEnvio=$objCheckIn['FechaEnvio'];
                $Tipo=$objCheckIn['Tipo'];
                $MatriculaCheckIn=$objCheckIn['Matricula'];
                $lblnombcomercial=$objCheckIn['lblnombcomercial'];
                $ObservacionesCheckIN= $objCheckIn['ObservacionesCheckIN'];
            } else {
                $objCheckIn='';
                
                $Distancia='';
                $FechaEnvio='';
                $Tipo='';
                $MatriculaCheckIn='';
                $lblnombcomercial='';
                $ObservacionesCheckIN='';
            }


    
    
    $stmtCategoria->close();

 
    } catch (\Exception $e) {
      
    }
    
 

    $html=NULL;
    try {
        
    $stmtJE = $con->prepare("SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) JefeVenta FROM yifi58ge_dbUSUARIO.tblusuario u  where u.CC=? AND u.LN='11' AND (u.Categoria ='JE' OR u.Categoria ='COACH' OR u.Categoria ='DEL' or u.Categoria='JE/DEL' or u.Categoria='GERENTE TERRITORIAL') LIMIT 50");
    $stmtJE->bind_param('i', $dc);
    $stmtJE->execute();
    $stmtJE->store_result();
    $stmtJE->bind_result($MatriculaJE,$JefeVentaJE);

    if($stmtJE->num_rows>0){
        while( $row = $stmtJE->fetch()){
            if($MatriculaJE==$matjefe){
               $html .= '<option value="'.$MatriculaJE.'" selected>'.$MatriculaJE.' - '.utf8_encode($JefeVentaJE).' </option>';
            }else{
               $html .= '<option value="'.$MatriculaJE.'">'.$MatriculaJE.' - '.utf8_encode($JefeVentaJE).' </option>';            
            }       
        }
    }else{
        $html .= '<option>No se encontraron resultado</option>';
    }
    
    $stmtJE->close();
 
    } catch (\Exception $e) {
      
    }
    

    
    /* JEFES DE DELEGACION */
    $htmlJ = NULL;
    
    $sqlJ = $con->prepare("SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) GerenteDelegacion FROM yifi58ge_dbUSUARIO.tblusuario u WHERE u.Categoria ='DEL' AND Estado = 'Activo'"); 
    //$sql->bind_param('i',$CCOriginal);
    $sqlJ->execute();
    $sqlJ->store_result();
    $sqlJ->bind_result(
        $MatriculaRowJ,
        $GerenteDelegacionRow
    ); 
    
    if ($sqlJ->num_rows > 0) {
        while ($sqlJ->fetch()) { 
            $Matricula = $MatriculaRowJ;
            $GerenteDelegacion = $GerenteDelegacionRow;            
            
            if($ContactoAsignacion == $Matricula){
                $htmlJ .= '<option value="'.$Matricula.'" selected>'.$Matricula.' - '.utf8_encode($GerenteDelegacion).' </option>';
            } else {
                $htmlJ .= '<option value="'.$Matricula.'">'.$Matricula.' - '.utf8_encode($GerenteDelegacion).' </option>';                
            }
        }
    }else{
        $htmlJ .= '<option>No se encontraron resultado</option>';
    }    
    


$html_tecnico=NULL;
if($lninstalador=="" || empty($lninstalador)){
$html_tecnico.= '<option></option>';
}else{

    try {
        
    $stmtTecnico = $con->prepare("SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) Instalador FROM yifi58ge_dbUSUARIO.tblusuario u INNER JOIN yifi58ge_dbUSUARIO.tblarea a on a.IdArea=u.IdArea");
    $stmtTecnico->execute();
    $stmtTecnico->store_result();
    $stmtTecnico->bind_result($MatriculaTEC,$InstaladorTEC);

    if($stmtTecnico->num_rows>0){
        while( $row = $stmtTecnico->fetch()){
            if($MatriculaTEC==$matriculatec){
               $html_tecnico .= '<option value="'.$MatriculaTEC.'" selected>'.$MatriculaTEC.' - '.utf8_encode($InstaladorTEC).' </option>';
            }else{
               $html_tecnico .= '<option value="'.$MatriculaTEC.'">'.$MatriculaTEC.' - '.utf8_encode($InstaladorTEC).' </option>';            
            }       
        }
    }else{
        $html_tecnico .= '<option>No se encontraron resultado</option>';
    }
    
    $stmtTecnico->close();
 
    } catch (\Exception $e) {
      
    }



}

    
    $html_tc=NULL;
    
    if($TCGestor=="" || empty($TCGestor)){
        $html_tc.= '<option></option>';
    }else{

    try {
        
    $stmtTC = $con->prepare("SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) Telecierre FROM yifi58ge_dbUSUARIO.tblusuario u WHERE u.IdPerfil='12'");
    $stmtTC->execute();
    $stmtTC->store_result();
    $stmtTC->bind_result($MatriculaTC,$Telecierre);

    if($stmtTC->num_rows>0){
        while( $row = $stmtTC->fetch()){
            if($MatriculaTC==$TCGestor){
               $html_tc .= '<option value="'.$MatriculaTC.'" selected>'.$MatriculaTC.' - '.utf8_encode($Telecierre).' </option>';
            }else{
               $html_tc .= '<option value="'.$MatriculaTC.'">'.$MatriculaTC.' - '.utf8_encode($Telecierre).' </option>';            
            }       
        }
    }else{
        $html_tc .= '<option>No se encontraron resultado</option>';
    }
    
    $stmtTC->close();
 
    } catch (\Exception $e) {
      
    }

        

    }

?>


<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Verisure | VeriSmart</title>
        <!-- Tell the browser to be responsive to screen width -->
        <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
        <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png" >
        <!-- Bootstrap 3.3.7 -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
        <!-- Font Awesome -->
        <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
        <!-- Ionicons -->
        <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">
        <!-- Theme style -->
        <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
        <!-- AdminLTE Skins. Choose a skin from the css/skins
             folder instead of downloading all of them to reduce the load. -->
        <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">
        <!-- bootstrap datepicker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
        <!-- iCheck for checkboxes and radio inputs -->
        <link rel="stylesheet" href="admin/plugins/iCheck/all.css">
        <!-- Bootstrap time Picker -->
        <link rel="stylesheet" href="admin/plugins/timepicker/bootstrap-timepicker.min.css">
        <!-- Select2 -->
        <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">
        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->
        <!-- Google Font -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
        <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
        <link href="admin/plugins/bootstrap-toggle-master/css/bootstrap-toggle.min.css" rel="stylesheet" type="text/css"/>
        <link href="admin/bower_components/bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.min.css" rel="stylesheet" type="text/css"/>
        
        <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
        <!-- Alertifyjs -->
        <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>
        <!-- LEAFLET -->
        <link rel="stylesheet" href="https://unpkg.com/leaflet@1.7.1/dist/leaflet.css"
           integrity="sha512-xodZBNTC5n17Xt2atTPuE1HxjVMSvLVW9ocqUKLsCC5CXdbqCmblAshOMAS6/keqq/sMZMZ19scR4PsZChSR7A=="
           crossorigin=""/>
        <link rel="stylesheet" href="lib/leaflet_AwesomeMarkers/dist/leaflet.awesome-markers.css">
  
        <style>
        
            #map { height: 450px; }

            .modal-header-danger {
                color:#fff;
                background-color: #e4002b;              
            }
            .modal-header-success {
                color:#fff;
                background-color: #008d4c;
            }

            .preloader{
                background-color:#FFF;
                width: 100%;
                height: 100%;
                position: absolute;
                z-index: 1;
            }

            .dataTables_wrapper .myfilter .dataTables_filter{float:left}
            .dataTables_wrapper .mylength .dataTables_length{float:right}
            div.dataTables_scrollBody thead th {
                vertical-align: top;
            } 
            td {
                max-width: 250px;
                overflow: hidden;
                white-space: nowrap;
                text-overflow: ellipsis;

            }
            .espacio{
                height:10px;
            }
            
           .espacio2{
                height:15px;
            }

            .thumbnail_style{
                text-align:center;
                border:none;
            }


            .caption h4{
                margin-top: -10px;
                font-size:13px;
                font-weight:  bold;
            }

            .caption p{
                color:#777;
                font-size:13px;
            }

            .caption a{
                color:#777;
                font-size:10px;
            }


            #frmEditarVenta .form-control{
                border-radius: 4px
            }

            #c-slider{
                margin: auto;
                width: 100%;
                max-width: 900px;
                position: relative;
                overflow: hidden;

            }
            #slider{
                display: flex;
                width: 200%;

            }
            #slider section{
                width: 100%;
            }


            .select2-container--default .select2-selection--single {

                border: 1px solid #d2d6de;
                border-radius: 4px;font-size: 12px;
                padding:4px 6px;
            }

            .btn-nuevo { 
                color: #FFFFFF; 
                background-color: #444444; 
                border-color: #444444; 
            } 

            .btn-nuevo:hover, 
            .btn-nuevo:focus, 
            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
                color: #FFFFFF; 
                background-color: #616161;  
                border-color: #444444; 
            } 

            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
                background-image: none; 
            } 

            .btn-nuevo.disabled, 
            .btn-nuevo[disabled], 
            fieldset[disabled] .btn-nuevo, 
            .btn-nuevo.disabled:hover, 
            .btn-nuevo[disabled]:hover, 
            fieldset[disabled] .btn-nuevo:hover, 
            .btn-nuevo.disabled:focus, 
            .btn-nuevo[disabled]:focus, 
            fieldset[disabled] .btn-nuevo:focus, 
            .btn-nuevo.disabled:active, 
            .btn-nuevo[disabled]:active, 
            fieldset[disabled] .btn-nuevo:active, 
            .btn-nuevo.disabled.active, 
            .btn-nuevo[disabled].active, 
            fieldset[disabled] .btn-nuevo.active { 
                background-color: #444444; 
                border-color: #444444; 
            } 


        </style>
        
        <style>
            .main-header,.main-sidebar,.left-side{position:fixed}
       
            .main-header {
                top: 0;
                right: 0;
                left: 0
            }
            .content-wrapper,
            .right-side {
                padding-top: 50px
            }

            @media (max-width:767px) {
                 .content-wrapper,
                 .right-side {
                    padding-top: 100px
                }
            }

            .layout-boxed .wrapper {
                max-width: 100%
            }

            .wrapper {
                overflow: hidden
            
                .control-sidebar {
                position: fixed;
                height: 100%;
                overflow-y: auto;
                padding-bottom: 50px
            }       
        
        </style>
     
        <style>
            .ui-autocomplete {
                position: absolute;
                z-index: 1000;
                cursor: default;
                padding: 0;
                margin-top: 2px;
                list-style: none;
                font-size: 11px;
                font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
                background-color: #ffffff;
                border: 1px solid #ccc;
                -webkit-border-radius: 5px;
                   -moz-border-radius: 5px;
                        border-radius: 5px;
                -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                   -moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                        box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                        
                    z-index: 1051 !important;    
                        
            }

            hr {
                height: 4px;
                width: 100%;
                background-color: #ecf0f5;
            }

            hr {
                /* margin-top: 20px; */
                margin-bottom: 20px;
                border: 0;
                /* border-top: 1px solid #eee; */
            }

            hr {
                display: block;
                unicode-bidi: isolate;
                -webkit-margin-before: 0.5em;
                -webkit-margin-after: 0.5em;
                -webkit-margin-start: auto;
                -webkit-margin-end: auto;
                overflow: hidden;
                border-style: inset;
               
            }

            .box.box-custom {
                border-top-color: #ffffff;
            }

            .box {
                position: relative;
                border-radius: 3px;
                background: #ffffff;
                border-top: 3px solid #d2d6de;
                margin-bottom: 5px;
                width: 100%;
                box-shadow: 0 1px 1px rgba(0,0,0,0.1);
            }

        </style>
        
        <style>
            .btn-blanco {
              background-color: white;
            }
    
            .btn-blanco{
              border: none;
            }
    
            .btn-blanco i{
              color: #E4002B;
            }
    
            .blanco-sinborde{
              background: white!important;
              border: none;
            }
            
            .info-tec label{
                text-align:left; 
                padding: 8px 15px;    
            }
            
            .info-tec button{
                padding: 4px 10px; 
                font-size: 16px;    
            }
            
            .info-tec p{
                padding: 4px 10px; 
                font-size: 16px; 
                font-weight: 600;
                display: inline-block;
            }
            
            
            .texto-derecha{
                text-align: right;
            }
    
        </style>
        
        <style>
            .ocultar{
                display: none;
            }
        </style>
        
        <style>
            .red{
                color: #E4002B;
            }
            .green{
                color: green;
            }
            .orange{
                color: orange;
            }
            
            select + span.select2:focus, select + span.select2 *:focus { 	outline-color: #7d3c8c; 	outline-width: 1px; }
            .select2-container--default.select2-container--focus, .select2-selection.select2-container--focus, .select2-container--default:focus, .select2-selection:focus, .select2-container--default:active, .select2-selection:active {
                outline: none;
                border: 1px solid #3c8dbc;
                border-radius: 4px;
            }
            
            .btn-verisure { 
                color: #ffffff; 
                background-color: #FF0033; 
                border-color: #FF0033; 
            } 
             
            .btn-verisure:hover, 
            .btn-verisure:focus, 
            .btn-verisure:active, 
            .btn-verisure.active, 
            .open .dropdown-toggle.btn-verisure { 
                color: #ffffff; 
                background-color: #a62828; 
                border-color: #a62828; 
            } 
             
            .btn-verisure:active, 
            .btn-verisure.active, 
            .open .dropdown-toggle.btn-verisure { 
                background-image: none; 
            } 
             
            .btn-verisure.disabled, 
            .btn-verisure[disabled], 
            fieldset[disabled] .btn-verisure, 
            .btn-verisure.disabled:hover, 
            .btn-verisure[disabled]:hover, 
            fieldset[disabled] .btn-verisure:hover, 
            .btn-verisure.disabled:focus, 
            .btn-verisure[disabled]:focus, 
            fieldset[disabled] .btn-verisure:focus, 
            .btn-verisure.disabled:active, 
            .btn-verisure[disabled]:active, 
            fieldset[disabled] .btn-verisure:active, 
            .btn-verisure.disabled.active, 
            .btn-verisure[disabled].active, 
            fieldset[disabled] .btn-verisure.active { 
              background-color: #555758; 
              border-color: #555758; 
            } 
        </style>
        
        <style>
            #divLoading {
                  background: rgba(66,118,164,0.4);
                  width: 100%;
                  height: 100%;
                  min-height: 100%;
                  position: absolute;
                  top: 0;
                  left: 0;
                  z-index: 999999999;
                  display:none;
                }
            
            .spinner {
              margin: 300px auto 0;
              width: 70px;
              text-align: center;
            }
            
            .spinner > div {
              background-color: #e4002b;
              width: 18px;
              height: 18px;
              border-radius: 100%;
              display: inline-block;
              -webkit-animation: sk-bouncedelay 1.4s infinite ease-in-out both;
              animation: sk-bouncedelay 1.4s infinite ease-in-out both;
            }
            
            .spinner .bounce1 {
              -webkit-animation-delay: -0.32s;
              animation-delay: -0.32s;
            }
            
            .spinner .bounce2 {
              -webkit-animation-delay: -0.16s;
              animation-delay: -0.16s;
            }
            
            @-webkit-keyframes sk-bouncedelay {
              0%, 80%, 100% { -webkit-transform: scale(0) }
              40% { -webkit-transform: scale(1.0) }
            }
            
            @keyframes sk-bouncedelay {
              0%, 80%, 100% {
                -webkit-transform: scale(0);
                transform: scale(0);
              } 40% {
                -webkit-transform: scale(1.0);
                transform: scale(1.0);
              }
            }
            
            .centrar-texto {
                text-align: center;
            }
            
            .m_get_started.fix {
                height: 100%;
                padding: 0;
                text-align: center;
                opacity: 1;
            }
            
            .callout {
                border-radius: 3px;
                margin: 0 0 20px 0;
                padding: 15px 30px 15px 15px;
                border-left: 5px solid #f03;
                -webkit-box-shadow: 10px 10px 5px -9px rgba(0,0,0,0.75);
                -moz-box-shadow: 10px 10px 5px -9px rgba(0,0,0,0.75);
                box-shadow: 10px 10px 5px -9px rgba(0,0,0,0.75);
            }
            .bg-deuda{
                color: #000;
                background-color: #ffffff !important;
            }
            
            .bg-visita{
                color: #fff;
                background-color: #008000 !important;
            }
            .bg-gestion{
             color: #fff;
            background-color: #6a6659 !important;   
            }
            .bg-televenta{
                color: #fff;
                background-color: #f39c12 !important;
                cursor: pointer;
            }
            
            input#nombres { text-transform: uppercase; }
            input#apellido_p { text-transform: uppercase; }
            input#apellido_m { text-transform: uppercase; }
        </style>

    </head>

    <body class="sidebar-collapse skin-red sidebar-mini">

        <div class="wrapper">
            <!-- Header -->
            <?php include 'admin/header.php'; ?>
            <!-- Left side column. contains the logo and sidebar -->
            <?php
                $visita = "active";
                $marketing="active";
                include 'admin/main-sidebar.php';
            ?>
            <!-- Content Wrapper. Contains page content -->
            <div class="content-wrapper">
                <!-- Content Header (Page header) -->
                <section class="content-header">
                    <h1>
                        EDITAR VISITA
                    </h1>
                    <ol class="breadcrumb">
                        <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
                        <li><a href="visita.php">Visitas</a></li>
                        <li class="active">Editar de Visita</li>
                    </ol>
                </section>
                <!-- Main content -->
                <section class="content">
                    <div class="row">
                        <div class="col-md-2"></div>
                        <div class="col-md-8">
                            <!-- /.box-header -->
                            <div class="box box-danger">
                                <div class="box-header">
                                    <h3 class="box-title">EDITAR 
                                        <?php $nombc = "";
                                            if ($categoriaventa == "Online"){
                                                $nombc="VENTA ONLINE";
                                            }else if($categoriaventa == "Ficha"){
                                                $nombc="VENTA FICHA";
                                            }else if($categoriaventa == "VAsignada"){
                                                $nombc="VISITA ASIGNADA";
                                            }else if($categoriaventa == "Anulada"){
                                                $nombc="ANULADA";
                                            }else if($categoriaventa == "Cancelada"){
                                                $nombc="CANCELADA";
                                            }else if($categoriaventa == "NoVendida"){
                                                $nombc="NO VENDIDA";
                                            }else if($categoriaventa == "Delegacion"){
                                                $nombc="VENTA DELEGACIÓN";
                                            }
                                            echo $nombc." - ".$nprospecto." | ".$ncontrato 
                                        ?>
                                    </h3>
                                    <input id="lblcat" name="lblcat" value="<?php echo $categoriaventa;?>" hidden="">
                                    <div class="box-tools pull-right">
                                        <div class="btn-group">
                                          <button type="button" id="erroresGestion" class="btn btn-sm btn-warning">Errores de Gestión</button>
                                          <button type="button" class="btn btn-sm btn-warning dropdown-toggle" data-toggle="dropdown">
                                            <span class="caret"></span>
                                            <span class="sr-only">Toggle Dropdown</span>
                                          </button>
                                          <ul class="dropdown-menu" role="menu">
                                            <li><a href="#" id="errorGestion"><i class="fa fa-exclamation-circle"></i> Tipificar error</a></li>
                                          </ul>
                                        </div>                                        
                                        <div class="btn-group">
                                          <button type="button" id="infoZonificacion" class="btn btn-sm btn-warning">Información Zonificación</button>
                                          <button type="button" class="btn btn-sm btn-warning dropdown-toggle" data-toggle="dropdown">
                                            <span class="caret"></span>
                                            <span class="sr-only">Toggle Dropdown</span>
                                          </button>
                                          <ul class="dropdown-menu" role="menu">
                                            <li><a id="ModEnviar" name="ModEnviar"><i class="fa fa-envelope"></i> Descargar</a></li>
                                            <li><a id="btnResumenVisita" name="btnResumenVisita"><i class="fa fa-file"></i> Resumen Visita</a></li>
                                            <li><a href="#" id="lognumero"><i class="fa fa-pencil-square-o"></i> Validacion por Telf.</a></li>
                                            <li><a href="#" id="calificarVisita"><i class="fa fa-exclamation-circle"></i> Calificar Visita</a></li>
                                          </ul>
                                        </div>
                                        
                                        <!--<button class="btn btn-warning btn-sm" id="infoZonificacion" style="margin-right: 5px">Info. Zonificacion</button> -->
                                        <!--<a class="btn btn-default btn-sm" id="ModEnviar" name="ModEnviar"><i class="fa fa-envelope"></i> Descargar</a> -->
                                        <a download="message.eml" id="downloadlink" class="btn btn-nuevo" style="display: none">Descargar</a> 
                                        <!-- <btn class="btn btn-success btn-sm" id="btnResumenVisita" name="btnResumenVisita">Resumen</btn> -->
                                        <?php 
                                            if($estadovisita=='VGenerada'){ 
                                        ?>
                                            <!-- <a class="btn btn-primary btn-sm" href="#" id="lognumero"><i class="fa fa-pencil-square-o"></i> Validacion por Telf.</a> -->
                                        <?php }                                             
                                        
                                            if($estadoventa=='Facturada' || $estadoventa=='PorFacturar' || $nombacceso=='test'){
                                            }else{ 
                                        ?>
                                        <a class="btn btn-nuevo btn-sm" id="btnGuardarEditarVenta" href="#"><i class="fa fa-save"></i> Guardar</a>
                                        <?php   
                                            } 
                                        ?>
                                         <a href="visita.php" class="btn btn-danger btn-sm" ><i class="fa fa-reply"></i> Regresar</a>
                                    </div>
                                </div>
                                <div class="espacio"></div>
                            </div>
                            <form id="frmEditarVenta" method="POST">
                                <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                        <h5>INFORMACION DE VENTA</h5>
                                        <div class="box-tools pull-right">
                                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                            </button>
                                        </div>
                                        <input type="hidden" id="lblgestorbackoffice" name="lblgestorbackoffice" value="<?php echo $matriculausuario; ?>">
                                        <input type="hidden" id="lblcalificarGestion" name="lblcalificarGestion" value="">
                                    </div>
                                    <!-- /.box-header -->
                                    <div class="box-body">
                                        <table cellspacing="0"  style="width:100%;border-collapse: separate;padding: 20px;" >
                                            <tr>
                                                <td style="width:15%;font-size: 12px">LEAD ID:</td>
                                                <td style="width:25%;">
                                                    <input name="lblleadid" id="lblleadid" maxlength="18" class="form-control input-sm" value="<?php echo $LeadID;?>" style="width: 100%;"/>
                                                    <input type="hidden" id="leadID" name="leadID" value="<?php echo $IdLead; ?>"
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">FECHA HORA COTIZACION</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                   
                                                    <div class='input-group'>
                                                        <input type='text' class="form-control input-sm datetimepicker" id="fechahoraCotizacion" name="fechahoraCotizacion" value="<?php echo $FechaHoraCotizacion;?>" readonly/>
                                                        <span class="input-group-addon">
                                                            <span class="glyphicon glyphicon-calendar"></span>
                                                        </span>
                                                    </div>                                                    
                                                    
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">ASIGNACION:</td>
                                                <td style="width:25%;">
                                                    <select class="form-control input-sm" name="lblasignacion" id="lblasignacion" style="width: 100%;">
                                                        <option value="">Seleccione</option>
                                                        <option value="Gerente" <?php if ($MotivoAsignacion == "Gerente") {echo "selected";}?>>Gerente</option>
                                                        <option value="BO" <?php if ($MotivoAsignacion == "BO") {echo "selected";}?>>BO</option>
                                                        <option value="Ranking" <?php if ($MotivoAsignacion == "Ranking") {echo "selected";}?>>Ranking</option>
                                                        <option value="Otros" <?php if ($MotivoAsignacion == "Otros") {echo "selected";}?>>Otros</option>
                                                    </select>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">COMENTARIOS ERROR GESTION:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    <input type="hidden" id="lblErrorGestion" name="lblErrorGestion" value="">
                                                    <input name="lblcomentarioserrorgestion" id="lblcomentarioserrorgestion" class="form-control input-sm" value="" style="width: 100%;" disabled>
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">CONTACTO ASIGNACIÓN:</td>
                                                <td style="width:25%;">
                                                    <select class="form-control input-sm" name="lblcontactoasignacion" id="lblcontactoasignacion" style="width: 100%;">
                                                        <option value="">Seleccione</option>
                                                        <!--<option value="1" <?php if ($ContactoAsignacion == "1") {echo "selected";}?>>1</option>
                                                        <option value="2" <?php if ($ContactoAsignacion == "2") {echo "selected";}?>>2</option>
                                                        <option value="3" <?php if ($ContactoAsignacion == "3") {echo "selected";}?>>3</option>-->
                                                        <?php echo $htmlJ;?>
                                                        <option value="Otros">Otros</option>
                                                    </select>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">CUMPLE RANKING:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    <select class="form-control input-sm" name="lblcumpleranking" id="lblcumpleranking" style="width: 100%;">
                                                        <option value="">Seleccione</option>
                                                        <option value="Sí - Top 3" <?php if ($CumpleRanking == "Sí - Top 3") {echo "selected";}?>>Sí - Top 3</option>
                                                        <option value="Estrella" <?php if ($CumpleRanking == "Estrella’") {echo "selected";}?>>Estrella</option>
                                                        <option value="Apto" <?php if ($CumpleRanking == "Apto’") {echo "selected";}?>>Apto</option>
                                                        <option value="No" <?php if ($CumpleRanking == "No") {echo "selected";}?>>No</option>
                                                    </select>
                                                </td>
                                            </tr>

                                            <tr class="espacio"></tr>                                          
                                            <tr>
                                                <td style="width:15%;font-size: 12px">CHECK-IN:</td>
                                                <td style="width:25%;">
                                                    <input type="checkbox" name="checki" id="checki" <?php if($checkin=="SI"){echo 'checked';}else{echo '';}?> data-size="small"/>
                                                    <input type="hidden" name="hidden_checki" id="hidden_checki" value="<?php echo $checkin;?>">
                                                    <input type="hidden" name="info_checkin" id="info_checkin" value='<?php echo $InfoCheckIn; ?>'>
                                                    <button type="button" class="btn btn-danger btn-sm" id="btnInfoCheckIn" href="#" data-toggle="modal" data-target="#modal-checkin">Info. Check-IN</button>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">MES VISITA:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    <div class="input-group">
                                                        <div class="input-group-addon input-sm">
                                                            <i class="fa fa-calendar"></i>
                                                        </div>
                                                        <input name="lblmesvisita" class="form-control input-sm" id="lblmesvisit" value="<?php if(isset($mesvisita)){ echo $mesvisita;}else{echo $fechames;}?>" style="width: 100%;cursor:pointer;background-color: #fff;" readonly="readonly"/> 
                                                    </div> 
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">MATRICULA:</td>

                                                <td style="width:25%;"><input name="lblmatricula" id="lblmatricula" class="form-control input-sm" value="<?php echo $matricula;?>" style="width: 100%;"/>
                                                   
                                                    <input id="lblidusuario" name="lblidusuario" value="<?php echo $idu;?>" hidden="">
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">COMERCIAL:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%"><input name="lblnombcomercial" id="lblnombcomercial" class="form-control input-sm" style="width: 100%;" value="<?php echo $comercial;?>" readonly="readonly"></td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">DC:</td>
                                                <td style="width:25%;">
                                                    <select class="form-control input-sm" name="lbldc" id="lbldc" style="width: 100%;">
                                                        <option value="">Seleccione</option>
                                                        <option value="40" <?php if ($CCOriginal == "40") {echo "selected";}?>>40</option>
                                                        <option value="41" <?php if ($CCOriginal == "41") {echo "selected";}?>>41</option>
                                                        <option value="42" <?php if ($CCOriginal == "42") {echo "selected";}?>>42</option>
                                                        <option value="80" <?php if ($CCOriginal == "80") {echo "selected";}?>>80</option>
                                                        <option value="100" <?php if ($CCOriginal == "100") {echo "selected";}?>>100</option>
                                                        <option value="120" <?php if ($CCOriginal == "120") {echo "selected";}?>>120</option>
                                                        <option value="121" <?php if ($CCOriginal == "121") {echo "selected";}?>>121</option>
                                                        <option value="140" <?php if ($CCOriginal == "140") {echo "selected";}?>>140</option>
                                                        <option value="141" <?php if ($CCOriginal == "141") {echo "selected";}?>>141</option>
                                                        <option value="150" <?php if ($CCOriginal == "150") {echo "selected";}?>>150</option>
                                                        <option value="151" <?php if ($CCOriginal == "151") {echo "selected";}?>>151</option>
                                                        <option value="152" <?php if ($CCOriginal == "152") {echo "selected";}?>>152</option>
                                                        <option value="153" <?php if ($CCOriginal == "153") {echo "selected";}?>>153</option>
                                                        <option value="154" <?php if ($CCOriginal == "154") {echo "selected";}?>>154</option>
                                                        <option value="155" <?php if ($CCOriginal == "155") {echo "selected";}?>>155</option>
                                                        <option value="156" <?php if ($CCOriginal == "156") {echo "selected";}?>>156</option>
                                                        <option value="157" <?php if ($CCOriginal == "157") {echo "selected";}?>>157</option>
                                                        <option value="158" <?php if ($CCOriginal == "158") {echo "selected";}?>>158</option>
                                                        <option value="159" <?php if ($CCOriginal == "159") {echo "selected";}?>>159</option>
                                                        <option value="200" <?php if ($CCOriginal == "200") {echo "selected";}?>>200</option>
                                                        <option value="250" <?php if ($CCOriginal == "250") {echo "selected";}?>>250</option>
                                                        <option value="251" <?php if ($CCOriginal == "251") {echo "selected";}?>>251</option>
                                                        <option value="252" <?php if ($CCOriginal == "252") {echo "selected";}?>>252</option>
                                                        <option value="20" <?php if ($CCOriginal == "20") {echo "selected";}?>>20</option>
                                                        <option value="511" <?php if ($CCOriginal == "511") {echo "selected";}?>>511</option>
                                                        <option value="513" <?php if ($CCOriginal == "513") {echo "selected";}?>>513</option>
                                                        <option value="512" <?php if ($CCOriginal == "512") {echo "selected";}?> hidden="">512</option>
                                                        <option value="601" <?php if ($CCOriginal == "601") {echo "selected";}?> hidden="">601</option>
                                                        <option value="701" <?php if ($CCOriginal == "701") {echo "selected";}?>>701</option>
                                                        <option value="702" <?php if ($CCOriginal == "702") {echo "selected";}?>>702</option>
                                                        <option value="901" <?php if ($CCOriginal == "901") {echo "selected";}?>>901</option>
                                                        <option value="130" <?php if ($CCOriginal == "130") {echo "selected";}?>>130</option>
                                                        <option value="230" <?php if ($CCOriginal == "230") {echo "selected";}?>>230</option>
                                                        <option value="60" <?php if ($CCOriginal == "60") {echo "selected";}?>>60</option>
                                                    </select>
                                                    <input type="hidden" name="lbldcobjzonificacion" id="lbldcobjzonificacion" /> 
                                                     <input type="hidden" name="txtMotivoDelegacion" id="txtMotivoDelegacion" />
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">JEFE VENTA:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    <select class="form-control input-sm" name="lbljefeventa" id="lbljefeventa" style="width: 100%;">
                                                        <?php echo $html;?>
                                                    </select>
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">ESTADO VISITA:</td>
                                                <td style="width:25%;">
                                                    <select name="lblestadovisita" id="lblestadovisita" class="form-control input-sm">
                                                        <option value="">Seleccione</option>
                                                        <option value="Asignada"<?php if ($estadovisita == "Asignada") {echo "selected";}?>>Asignada</option>
                                                        <option value="AnuladaCC" <?php if ($estadovisita == "AnuladaCC") {echo "selected";}?>>AnuladaCC</option>
                                                        <option value="PendienteValidarVnoV" <?php if($estadovisita == "PendienteValidarVnoV") {echo "selected";} ?> disabled hidden>PendienteValidarVnoV</option>
                                                        <option value="AnuladaTEC"<?php if ($estadovisita == "AnuladaTEC") {echo "selected";}?>>AnuladaTEC</option>
                                                        <option value="AnuladaOP"<?php if ($estadovisita == "AnuladaOP") {echo "selected";}?>>AnuladaOP</option>
                                                        <option value="AnuladaCLI"<?php if ($estadovisita == "AnuladaCLI") {echo "selected";}?>>AnuladaCLI</option>
                                                        <option value="AnuladaporCruce"<?php if ($estadovisita == "AnuladaporCruce") {echo "selected";}?>>Anulada por Cruce</option>
                                                        <option value="AnuladaNoImputableOper"<?php if ($estadovisita == "AnuladaNoImputableOper") {echo "selected";}?>>Anulada No Imputable Oper</option>
                                                        <option value="AnuladaTECAudio"<?php if ($estadovisita == "AnuladaTECAudio") {echo "selected";}?>>AnuladaTECAudio</option>
                                                        <option value="Vendida"<?php if ($estadovisita == "Vendida") {echo "selected";}?> hidden="">Vendida</option>
                                                        <option value="NoVendida"<?php if ($estadovisita == "NoVendida") {echo "selected";}?>>NoVendida</option>
                                                    </select>
                                                    <input id="lblestvisita" name="lblestvisita" value="<?php echo $estadovisita; ?>" hidden="" />
                                                    
                                                    <input id="hidEstadoVisita" name="hidEstadoVisita" value="<?php echo $estadovisita; ?>" hidden="" />
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">ESTADO VENTA:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    <input type="text" name="lblestadoventa" id="lblestadoventa" value="<?php echo $estadoventa ;?>" class="form-control input-sm" style="width: 100%;" readonly="readonly"/>
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr class="trAnulaciones <?php if($SeAnula == '') { echo "ocultar"; } ?>">
                                                <td style="width:15%;font-size: 12px">SE ANULA:</td>
                                                <td style="width:25%;">
                                                    <input type="checkbox" name="seanula" id="seanula" <?php if($SeAnula=="SI"){echo 'checked';}else{echo '';}?> data-size="small"/ disabled>
                                                    <input type="hidden" name="lblseanula" id="lblseanula" value='<?= $SeAnula; ?>'>
                                                    <input type="hidden" name="lblseanulaH" id="lblseanulaH" value='<?= $SeAnula; ?>'>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">DETALLE:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%;">
                                                    <select name="lbldetalle" id="lbldetalle" class="form-control input-sm" disabled>
                                                        <option value="">Seleccione</option>
                                                        <option value="AAHH"<?php if ($detalleAnulacion == "AAHH") {echo "selected";}?>>AAHH</option>
                                                        <option value="CAMARAS" <?php if ($detalleAnulacion == "CAMARAS") {echo "selected";}?>>CAMARAS</option>
                                                        <option value="COBERTURA" <?php if($detalleAnulacion == "COBERTURA") {echo "selected";} ?>>COBERTURA</option>
                                                        <option value="CRUCE-RE"<?php if ($detalleAnulacion == "CRUCE-RE") {echo "selected";}?>>CRUCE-RE</option>
                                                        <option value="CRUCE-RP"<?php if ($detalleAnulacion == "CRUCE-RP") {echo "selected";}?>>CRUCE-RP</option>
                                                        <option value="CRUCE-YA ES CLIENTE"<?php if ($detalleAnulacion == "CRUCE-YA ES CLIENTE") {echo "selected";}?>>CRUCE-YA ES CLIENTE</option>
                                                        <option value="DATO INCORRECTO"<?php if ($detalleAnulacion == "DATO INCORRECTO") {echo "selected";}?>>DATO INCORRECTO</option>
                                                        <option value="DECISOR"<?php if ($detalleAnulacion == "DECISOR") {echo "selected";}?>>DECISOR</option>
                                                        <option value="DIRECCION"<?php if ($detalleAnulacion == "DIRECCION") {echo "selected";}?>>DIRECCION</option>
                                                        <option value="DOCUMENTO"<?php if ($detalleAnulacion == "DOCUMENTO") {echo "selected";}?>>DOCUMENTO</option>
                                                        <option value="FALTA DE AUDIO"<?php if ($detalleAnulacion == "FALTA DE AUDIO") {echo "selected";}?>>FALTA DE AUDIO</option>
                                                        <option value="FILTRO DE OBRAS"<?php if ($detalleAnulacion == "FILTRO DE OBRAS") {echo "selected";}?>>FILTRO DE OBRAS</option>
                                                        <option value="INFORMACION FALSA"<?php if ($detalleAnulacion == "INFORMACION FALSA") {echo "selected";}?>>INFORMACION FALSA</option>
                                                        <option value="INVIABLE"<?php if ($detalleAnulacion == "INVIABLE") {echo "selected";}?>>INVIABLE</option>
                                                        <option value="PAGO MENSUAL"<?php if ($detalleAnulacion == "PAGO MENSUAL") {echo "selected";}?>>PAGO MENSUAL</option>
                                                        <option value="SIN CONFIRMACION"<?php if ($detalleAnulacion == "SIN CONFIRMACION") {echo "selected";}?>>SIN CONFIRMACION</option>
                                                        <option value="VISITA CANCELADA"<?php if ($detalleAnulacion == "VISITA CANCELADA") {echo "selected";}?>>VISITA CANCELADA</option>
                                                    </select>
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr class="trAnulaciones <?php if($ComentariosAnulacion == '') { echo "ocultar"; } ?>">
                                                <td style="width:15%;"></td>
                                                <td style="width:25%;">
                                                    
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">COMENTARIOS ANULACIÓN:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%;">
                                                    <input name="lblcomentarios" id="lblcomentarios" class="form-control input-sm" value="<?= $ComentariosAnulacion ?>" style="width: 100%;" disabled>
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">SEGMENTO:</td>
                                                <td style="width:25%;">
                                                    <select class="form-control input-sm" name="lblsegmento" id="lblsegmento">
                                                        <option>Seleccione</option>
                                                        <option value="RES"<?php if ($segmento == "RES") {echo "selected";}?>>RES</option>
                                                        <option value="NEG"<?php if ($segmento == "NEG") {echo "selected";}?>>NEG</option>
                                                    </select></td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">RECURSO:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    <select class="form-control input-sm" name="lbltipoventa" id="lbltipoventa">
                                                            <option value="RE" <?php if ($tipoventa== "RE") {echo "selected";}?>>RE</option>
                                                            <option value="RPMKT" <?php if ($tipoventa== "RPMKT") {echo "selected";}?>>RPMKT</option>
                                                            <option value="REGGCC" <?php if ($tipoventa== "REGGCC") {echo "selected";}?>>REGGCC</option>
                                                    </select>
                                                </td>
                                            </tr>
                                            <tr class="espacio Lead__tiposegmento  <?php if ($segmento == "NEG") {echo "ocultar";}?>"></tr>
                                            <tr class="Lead__tiposegmento  <?php if ($segmento == "NEG") {echo "ocultar";}?>">
                                                <td style="width:15%;font-size: 12px"><span class="Lead__tiposegmento <?php if ($segmento == "NEG") {echo "ocultar";}?>">TIPO RESIDENCIAL:</span></td>
                                                <td style="width:25%;">
                                                    <select class="form-control input-sm Lead__tiposegmento <?php if ($segmento == "NEG") {echo "ocultar";}?>" name="lbltiposegmento" id="lbltiposegmento">
                                                        <option value="">Seleccione</option>
                                                        <option value="Casa"<?php if ($TipoSegmento == "Casa") {echo "selected";}?>>Casa</option>
                                                        <option value="Departamento"<?php if ($TipoSegmento == "Departamento") {echo "selected";}?>>Departamento</option>
                                                    </select>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">N° PISO:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    <input type="number" class="form-control input-sm" id="lblnpiso" name="lblnpiso" max="99"  min="0" value="<?php echo $NPiso;?>">
                                                </td>
                                            </tr>
                                           <tr class="espacio Lead__tiposegmento  <?php if ($segmento == "NEG") {echo "ocultar";}?>"></tr>
                                            <tr class="Lead__tiposegmento  <?php if ($segmento == "NEG") {echo "ocultar";}?>">
                                                <td style="width:15%;font-size: 12px"><span class="Lead__tiposegmento <?php if ($segmento == "NEG") {echo "ocultar";}?>">VIVE PISO A PROTEGER:</span></td>
                                                <td style="width:25%;">
                                                        <select class="form-control input-sm" name="visePiso" id="visePiso" style="width: 100%">
                                                            <option value="">Seleccione</option>
                                                            <option value="Si" <?php if ($visePiso== "Si") {echo "selected";}?>>Si</option>
                                                            <option value="No - para familiar" <?php if ($visePiso== "No - para familiar") {echo "selected";}?>>No, para familiar</option>
                                                            <option value="No - para alquiler" <?php if ($visePiso== "No - para alquiler") {echo "selected";}?>>No, para alquiler</option>
                                                            <option value="No - para turismo" <?php if ($visePiso== "No - para turismo") {echo "selected";}?>>No, para turismo</option>
                                                        </select>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px"></td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    
                                                </td>
                                            </tr>
                                            <tr class="espacio Lead__nlocales  <?php if ($segmento == "RES") {echo "ocultar";}?>"></tr>
                                            <tr class="Lead__nlocales  <?php if ($segmento == "RES") {echo "ocultar";}?>">
                                                <td style="width:15%;font-size: 12px"><span class="Lead__nlocales <?php if ($segmento == "RES") {echo "ocultar";}?>">RUBRO DE NEGOCIO:</span></td>
                                                <td style="width:25%;">
                                                       <input type="text" class="form-control input-sm" id="rubroNeg" name="rubroNeg" value="<?php echo $rubroNeg;?>">
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">PUERTA A CALLE:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                     <select class="form-control input-sm" name="puertaCalle" id="puertaCalle" style="width: 100%">
                                                            <option value="">Seleccione</option>
                                                            <option value="Si" <?php if ($puertaCalle== "Si") {echo "selected";}?>>Si</option>
                                                            <option value="No" <?php if ($puertaCalle== "No") {echo "selected";}?>>No</option>
                                                     </select>
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">PAREDES - LADRILLO Y CEMENTO:</td>
                                                <td style="width:25%">
                                                    <select class="form-control input-sm" name="nobleParedes" id="nobleParedes" style="width: 100%" >
                                                        <option value="">Seleccione</option>
                                                        <option value="Si" <?php if ($nobleParedes== "Si") {echo "selected";}?>>Si</option>
                                                        <option value="No" <?php if ($nobleParedes== "No") {echo "selected";}?>>No</option>
                                                    </select>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">TECHO - LADRILLO Y CEMENTO:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    <select class="form-control input-sm" name="nobleTecho" id="nobleTecho" style="width: 100%">
                                                        <option value="">Seleccione</option>
                                                        <option value="Si" <?php if ($nobleTecho== "Si") {echo "selected";}?>>Si</option>
                                                        <option value="No" <?php if ($nobleTecho== "No") {echo "selected";}?>>No</option>
                                                    </select>
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">M2:</td>
                                                <td style="width:25%">
                                                    <input type="text" class="form-control input-sm" id="mcuadrados"  name="mcuadrados" value="<?php echo $metros;?>" maxlength="50" onkeypress="return (event.charCode >= 46 && event.charCode <= 57)">
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">MOTIVO INTERÉS:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    <select class="form-control input-sm" name="motivoInteres" id="motivoInteres" style="width: 100%">
                                                        <option value="">Seleccione</option>
                                                        <option value="Robo" <?php if ($motivoInteres== "Robo") {echo "selected";}?>>Robo</option>
                                                        <option value="Prevencion" <?php if ($motivoInteres== "Prevencion") {echo "selected";}?>>Prevención</option>
                                                    </select>
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">CON SISTEMA DE ALARMAS:</td>
                                                <td style="width:25%">
                                                    <select class="form-control input-sm" name="conSistema" id="conSistema" style="width: 100%">
                                                        <option value="">Seleccione</option>
                                                        <option value="Si" <?php if ($conSistema== "Si") {echo "selected";}?>>Si</option>
                                                        <option value="No" <?php if ($conSistema== "No") {echo "selected";}?>>No</option>
                                                    </select>                                                    
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px"><span class="Lead__empresaAlarmas <?php if ($conSistema == "No" || $conSistema == "") {echo "ocultar";}?>">EMPRESA ALARMAS:</span></td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    <input type="text" class="form-control input-sm Lead__empresaAlarmas <?php if ($conSistema == "No" || $conSistema == "") {echo "ocultar";}?>" id="empresaSistema"  name="empresaSistema" value="<?php echo $empresaSistema;?>" maxlength="50">
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">CLIENTE BANCARIZADO:</td>
                                                <td style="width:25%">
                                                    <select class="form-control input-sm" name="bancarizado" id="bancarizado" style="width: 100%">
                                                        <option value="">Seleccione</option>
                                                        <option value="Si" <?php if ($bancarizado== "Si") {echo "selected";}?>>Si</option>
                                                        <option value="No" <?php if ($bancarizado== "No") {echo "selected";}?>>No</option>
                                                    </select>                                                 
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px"></td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    
                                                </td>
                                            </tr>                                              
                                                                                        
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">N° PROSPECTO:</td>
                                                <td style="width:25%">
                                                    <input type="text" class="form-control input-sm" name="lblnprospecto" id="lblnprospecto" data-inputmask='"mask": "999999"' value="<?php echo $nprospecto;?>" data-mask>
                                                    <input type="text" name="lblnprospectohidden" id="lblnprospectohidden" value="<?php echo $nprospecto;?>" hidden>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">N° CONTRATO:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    <input type="text" class="form-control input-sm" name="lblncontrato" id="lblncontrato" data-inputmask='"mask": "9999999"' value="<?php echo $ncontrato;?>" data-mask readonly="readonly">
                                                </td>
                                            </tr> 
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">ASIGNADO POR:</td>
                                                <td style="width:25%;">
                                                    <select class="form-control selectgestor input-sm" name="lblasignado" id="lblasignado" style="width: 100%;">
                                                        <option value="<?php echo $matriculagestormkt; ?>"><?php echo $matriculagestormkt.' - '.$operadormkt; ?></option>
                                                    </select>
                                                    <input type="hidden" id="nombreOperadorCC" name="nombreOperadorCC" value="<?php echo $operadormkt; ?>">
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">ORIGEN:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%"><input class="form-control input-sm" name="lblorigen" id="lblorigen" value="<?php echo $origenvisita;?>" ></td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">GRUPO ACD:</td>
                                                <td style="width:25%;">
                                                    <select class="form-control input-sm select2" name="cboGrupoACD" id="cboGrupoACD" style="width: 100%">
                                                        <option value="" selected disabled>Seleccione</option>
                                                        <option value="LEADS_INT - LEADS_ INTERNET_ PRIMER INT.">LEADS_INT - LEADS_ INTERNET_ PRIMER INT.</option>
                                                        <option value="CORTO - WWW CORTO">CORTO - WWW CORTO</option>
                                                        <option value="LARGO - WWW LARGO">LARGO - WWW LARGO</option>
                                                        <option value="61317 - SEO">61317 - SEO</option>
                                                        <option value="61315 - SEM GENERICO - 514 73 22">61315 - SEM GENERICO - 514 73 22</option>
                                                        <option value="61314 - SEM MARCA - 514 73 18">61314 - SEM MARCA - 514 73 18</option>
                                                        <option value="61324 - CAMARAS - 514 81 97">61324 - CAMARAS - 514 81 97</option>
                                                        <option value="61308 - FACEBOOK INBOUND">61308 - FACEBOOK INBOUND</option>
                                                        <option value="61318 - REDES SOCIALES 514 73 28">61318 - REDES SOCIALES 514 73 28</option>
                                                        <option value="61281 - MKT RE - 514 73 00">61281 - MKT RE - 514 73 00</option>
                                                        <option value="61322 - RADIO 514 8190">61322 - RADIO 514 8190</option>
                                                        <option value="61366 - PERU_MKT_TV_AMERICA">61366 - PERU_MKT_TV_AMERICA</option>
                                                        <option value="61364 - PERU_MKT_TV_CANALN">61364 - PERU_MKT_TV_CANALN</option>
                                                        <option value="61367 - PERU_MKT_TV_MOVISTAR">61367 - PERU_MKT_TV_MOVISTAR</option>
                                                        <option value="61368 - PERU_MKT_TV_ROLA">61368 - PERU_MKT_TV_ROLA</option>
                                                        <option value="61365 - PERU_MKT_TV_RPP">61365 - PERU_MKT_TV_RPP</option>
                                                        <option value="61370 - PERU_MKT_TV_SONY">61370 - PERU_MKT_TV_SONY</option>
                                                        <option value="61369 - PERU_MKT_TV_TURNER">61369 - PERU_MKT_TV_TURNER</option>
                                                        <option value="61329 - PERU_MKT_SMS_NC">61329 - PERU_MKT_SMS_NC</option>
                                                        <option value="61280 - ATENCION AL CLIENTE 5147302">61280 - ATENCION AL CLIENTE 5147302</option>
                                                        <option value="61280 - MKT_RP - 514 7301">61280 - MKT_RP - 514 7301</option>
                                                        <option value="61323 - PERU_MKT_BACKUP1">61323 - PERU_MKT_BACKUP1</option>
                                                        <option value="61313 - RELLAMADA INTERNET 5148210">61313 - RELLAMADA INTERNET 5148210</option>
                                                        <option value="61325 - RELLAMADA RECOVERY 5148198">61325 - RELLAMADA RECOVERY 5148198</option>
                                                        <option value="61325 - RELLAMADA RECOVERY 7102339">61325 - RELLAMADA RECOVERY 7102339</option>
                                                        <option value="TELEVENTA - TELEVENTA">TELEVENTA - TELEVENTA</option>
                                                        <option value="61381 - PERU_MKT_TV_ABIERTA_04">61381 - PERU_MKT_TV_ABIERTA_04</option>
                                                        <option value="61382 - PERU_MKT_TV_ABIERTA_LATINA">61382 - PERU_MKT_TV_ABIERTA_LATINA</option>
                                                        <option value="61383 - PERU_MKT_TV_ABIERTA_WILLAX">61383 - PERU_MKT_TV_ABIERTA_WILLAX</option>
                                                        <option value="61384 - PERU_MKT_TV_ABIERTA_ATV">61384 - PERU_MKT_TV_ABIERTA_ATV</option>
                                                    </select>
                                                    <input type=hidden id="txtGrupoACD" name="txtGrupoACD" value="<?php echo $GrupoACD ?>">
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px" id="txtFvisita"><?php if ($FObras=='SI'){echo 'FECHA VISITA(OBRAS):';}else{echo 'FECHA VISITA:';} ?></td>
                                                <td style="width:25%"> <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfvisita"  name="lblfvisita" value="<?php echo $fechavisita;?>"  data-inputmask="'alias': 'dd/mm/yyyy'" data-mask>
                                                        </div>
                                                
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">HORA VISITA:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    <div class="bootstrap-timepicker timepicker">
                                                        <div class="input-group">
                                                            <input type="text" class="form-control input-sm" placeholder="12:00 AM" name="lblhvisita" id="lblhvisita" value="<?php echo $horavisita;?>"  >
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-clock-o"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">FECHA VENCIMIENTO:</td>
                                                <td style="width:25%;">
                                                    <div class="input-group">
                                                        <div class="input-group-addon input-sm">
                                                            <i class="fa fa-calendar"></i>
                                                        </div>
                                                        <input type="text" class="form-control pull-right input-sm" id="lblfvencimientob" value="<?php echo $fvencimientovisita;?>" name="lblfvencimientob" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask>
                                                        <input type="hidden" class="form-control pull-right input-sm" id="lblfvencimiento" value="<?php echo $fvencimientovisita;?>"  name="lblfvencimiento">
                                                    </div>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">MESES AUTORIZADOS:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%"><input type="text" maxlength="3" class="form-control input-sm" id="lblmesesautorizados" name="lblmesesautorizados"  value="<?php echo $mesesautorizados;?>" onkeypress="return filterFloat(event, this);" readonly="readonly"></td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">OBRAS:</td>
                                                <td style="width:25%;">
                                                    <input type="checkbox" name="FObras" id="FObras" <?php if ($FObras=='SI'){echo 'checked';}else{echo '';}?> data-size="small">
                                                    <input type="hidden" name="ValFObras" id="ValFObras" value="<?php if ($FObras=='SI'){echo 'SI';}else{echo 'NO';} ?>">
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px; <?php if ($FObras=='NO' || $FObras=='' ){echo 'display: none;';} ?>"  id="txtFVisitaReal">FECHA VISITA REAL:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%; <?php if ($FObras=='NO' || $FObras==''){echo 'display: none;';} ?>" id="dpFVisitaReal"> 
                                                    <div class="input-group">
                                                        <div class="input-group-addon input-sm">
                                                            <i class="fa fa-calendar"></i>
                                                        </div>
                                                        <input type="text" class="form-control pull-right input-sm" id="lblFVisitaReal"  name="lblFVisitaReal" value="<?php if($FVisitaObras!='0'){ echo $FVisitaObras; } else { echo '';} ?>" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">CLIENTE:</td>

                                                <td style="width:25%;"><input name="lblnombcliente" class="form-control input-sm" id="lblnombcliente" value="<?php echo $cliente;?>" style="width: 100%;"/></td>
                                                <input id="lblidcliente" name="lblidcliente" value="<?php echo $idcliente;?>" hidden="">
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">CORREO:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%"><input type="text"  class="form-control input-sm" id="lblcorreo" value="<?php echo $correo;?>" name="lblcorreo"></td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">TIPO DOCUMENTO VISITA:</td>
                                                <td style="width:25%;"> 
                                                    <select class="form-control input-sm" name="lbltipodoc" id="lbltipodoc">
                                                        <option value="">Seleccione</option>
                                                        <option value="DNI" <?php if ($TipoDocumento== "DNI") {echo "selected";}?>>DNI</option>
                                                        <option value="RUC" <?php if ($TipoDocumento== "RUC") {echo "selected";}?>>RUC</option>
                                                        <option value="CE" <?php if ($TipoDocumento== "CE") {echo "selected";}?>>CE</option>
                                                    </select>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">DOCUMENTO VISITA:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%"> 
                                                    <div class="input-group" style="width: 100%">
                                                        <input type="text" class="form-control input-sm" name="lbldocumento" id="lbldocumento" value="<?php echo $Documento ;?>" maxlength="12" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
                                                        <input id="lblIdDocVisita" name="lblIdDocVisita" value="<?php echo $IdDocVisita;?>" hidden="">
                                                        <div class="input-group-addon btn" id="setAccion">
                                                            <i class="fa fa-dashboard"></i>
                                                        </div>
                                                    </div> 
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                    <td style="width:15%;font-size: 12px">ACCION:</td>
                                                    <td style="width:25%;">
                                                    <input type="text" class="form-control input-sm" name="lblaccion" id="lblaccion" maxlength="70" value="<?php echo $lblAccion;?>"  readonly>
                                                    </td>
                                                    <td style="width:10%"></td>
                                                    <td style="width:15%;font-size: 12px">FECHA CONSULTA:</td>
                                                    <td style="width:2%"></td>
                                                    <td style="width:25%">
                                                      <input type="text" class="form-control input-sm" name="lblFechaHoraReg" id="lblFechaHoraReg" value="<?php echo $lblFechaHoraReg;?>"  readonly>
                                                      <input type="hidden" name="lblIdConsultaScoring" id="lblIdConsultaScoring" value="<?php echo $lblIdConsultaScoring;?>" >
                                                      <input type="hidden" name="lblperfilscoring" id="lblperfilscoring" value="<?php echo $lblPerfilScoring;?>" >
                                                    </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">DIRECCIÓN:</td>
                                                <td colspan="3" style="width:50%">
                                                    <div class="input-group" style="width: 100%">
                                                        <input type="text" class="form-control input-sm" id="lbldireccion" name="lbldireccion" placeholder="Ingresar dirección ..." value="<?php echo $direccion;?>">
                                                        <!--
                                                        <div class="input-group-addon btn" id="setDireccion">
                                                            <i class="fa fa-cart-plus"></i>
                                                        </div>
                                                        -->
                                                        
                                                    </div>
                                                </td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%"><select class="form-control selectdistrito input-sm" name="lbldistrito" id="lbldistrito" style="width: 100%;">
                                                    <option value="<?php echo $idgeografico; ?>"><?php echo $distrito.' - '.$provincia; ?></option>
                                                </select></td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">TIPO DIRECCION:</td>
                                                <td style="width:25%">
                                                     <select class="form-control input-sm selecttipodireccion" name="tipovial" id="tipovial" style="width: 100%">
                                                        <option value="">Seleccione</option>
                                                        <option value="Alameda" <?php if ($TipoVial== "Alameda") {echo "selected";}?>>Alameda</option>
                                                        <option value="Asentamiento Humano" <?php if ($TipoVial== "Asenamiento Humano") {echo "selected";}?>>Asentamiento Humano</option>
                                                        <option value="Avenida" <?php if ($TipoVial== "Avenida") {echo "selected";}?>>Avenida</option>
                                                        <option value="Calle" <?php if ($TipoVial== "Calle") {echo "selected";}?>>Calle</option>
                                                        <option value="Centro Poblado" <?php if ($TipoVial== "Centro Poblado") {echo "selected";}?>>Centro Poblado</option>
                                                        <option value="Jiron" <?php if ($TipoVial== "Jiron") {echo "selected";}?>>Jiron</option>
                                                        <option value="Malecon" <?php if ($TipoVial== "Malecon") {echo "selected";}?>>Malecon</option>
                                                        <option value="Ovalo" <?php if ($TipoVial== "ovalo") {echo "selected";}?>>ovalo</option>
                                                        <option value="Pasaje" <?php if ($TipoVial== "ovalo") {echo "selected";}?>>Pasaje</option>
                                                        <option value="Pueblo Joven" <?php if ($TipoVial== "Pueblo Joven") {echo "selected";}?>>Pueblo Joven</option>
                                                        <option value="Urbanizacion" <?php if ($TipoVial== "Urbanizacion") {echo "selected";}?>>Urbanizacion</option>
                                                        <option value="Ampliacion" <?php if ($TipoVial== "Ampliacion") {echo "selected";}?>>Ampliacion</option>
                                                        <option value="Upis" <?php if ($TipoVial== "Upis") {echo "selected";}?>>Upis</option>
                                                        <option value="Prolongacion" <?php if ($TipoVial== "Prolongacion") {echo "selected";}?>>Prolongacion</option>
                                                        <option value="Caserio" <?php if ($TipoVial== "Caserio") {echo "selected";}?>>Caserio</option>
                                                        <option value="Fundo" <?php if ($TipoVial== "Fundo") {echo "selected";}?>>Fundo</option>
                                                        <option value="Asociacion" <?php if ($TipoVial== "Asociacion") {echo "selected";}?>>Asociación</option>
                                                        <option value="Cooperativa" <?php if ($TipoVial== "Cooperativa") {echo "selected";}?>>Cooperativa</option>
                                                        <option value="Conjunto habitacional" <?php if ($TipoVial== "Conjunto habitacional") {echo "selected";}?>>Conjunto habitacional</option>
                                                        <option value="APV" <?php if ($TipoVial== "APV") {echo "selected";}?>>APV</option>
                                                        <option value="Variante" <?php if ($TipoVial== "Variante") {echo "selected";}?>>Variante</option>
                                                        <option value="Zona" <?php if ($TipoVial== "Zona") {echo "selected";}?>>Zona</option>
                                                        <option value="Sector" <?php if ($TipoVial== "Sector") {echo "selected";}?>>Sector</option>
                                                        <option value="Grupo" <?php if ($TipoVial== "Grupo") {echo "selected";}?>>Grupo</option>
                                                        <option value="Kilometro" <?php if ($TipoVial== "Kilometro") {echo "selected";}?>>Kilometro</option>
                                                        <option value="Parcela" <?php if ($TipoVial== "Parcela") {echo "selected";}?>>Parcela</option>
                                                        <option value="Agrupacion" <?php if ($TipoVial== "Agrupacion") {echo "selected";}?>>Agrupacion</option>                                                        
                                                    </select>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px"></td>
                                                <td style="width:2%"></td>
                                                <td colspan="6" style="width:50%">
                                                   
                                                </td>
                                            </tr>                                            
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">INTERIOR:</td>
                                                <td style="width:25%">
                                                    <input type="text" class="form-control input-sm" name="lblinterior" id="lblinterior" value="<?php echo $Interior; ?>">
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">REFERENCIA:</td>
                                                <td style="width:2%"></td>
                                                <td colspan="6" style="width:50%">
                                                    <div class="input-group" style="display: flex">
                                                        <input type="text" class="form-control input-sm" id="lblreferencia" name="lblreferencia" value="<?php echo $Referencia; ?>">
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">DIR. GEO:</td>
                                                <td colspan="3" style="width:50%">
                                                    <div class="input-group" style="width: 100%">
                                                        <input type="text" class="form-control input-sm" id="lbldireccionAprox" name="lbldireccionAprox" placeholder="" value="<?php echo $DireccionAprox;?>" readonly>
                                                        <div class="input-group-addon btn" id="setDireccion">
                                                            <i class="fa fa-map-marker"></i>
                                                        </div>
                                                        <input type="hidden" id="objGeofinder" name="objGeofinder" value='<?php echo $objGeofinder; ?>'>
                                                        <input type="hidden" id="lblIdDireccion" name="lblIdDireccion" value="<?php echo $IdDireccion; ?>">
                                                        <input type="hidden" id="idZonificacion" name="idZonificacion">
                                                        <input type="hidden" id="objZonificacionVerisure" name="objZonificacionVerisure">
                                                        <input type="hidden" id="microzona" name="microzona">
                                                        <input type="hidden" id="CalidadGeo" name="CalidadGeo">
                                                        <!--
                                                        <div class="input-group-addon btn" id="setDireccionAprox">
                                                            <i class="fa fa-map-marker"></i>
                                                        </div>
                                                        -->
                                                    </div>
                                                </td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    <select class="form-control input-sm" name="lbltipoDireccion" id="lbltipoDireccion" style="width: 100%;">
                                                        <option value="" disabled selected>Seleccione</option>
                                                        <option value="Exacta" <?php if ($TipoDireccion== "Exacta") {echo "selected";}?>>Exacta</option>
                                                        <option value="Aproximada" <?php if ($TipoDireccion== "Aproximada") {echo "selected";}?>>Aproximada</option>
                                                    </select>
                                                    <input type="hidden" id="hidTipoDireccion" value="<?php echo $TipoDireccion; ?>">
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">TELEFONO UNO:</td>
                                                <td style="width:25%"><input type="text" class="form-control input-sm" name="lblmovil" id="lblmovil" value="<?php echo $movil;?>"  onkeypress="return event.charCode >= 48 && event.charCode <= 57" maxlength="9">
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">TELEFONO DOS:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%"><input type="text" class="form-control input-sm" name="lblfijo" id="lblfijo" value="<?php echo $fijo;?>" onkeypress="return event.charCode >= 48 && event.charCode <= 57" maxlength="9">
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">COMENTARIO VISITA:</td>
                                                <td colspan="5" style="width:77%">
                                                    <textarea class="form-control input-sm" name="lblcomentariovisita" id="lblcomentariovisita" rows="3" style="resize:none"  placeholder="Ingresar..."><?php echo $comentariovisita;?></textarea>
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">SEGUNDA DIRECCION</td>
                                                <td style="width:25%">
                                                    
                                                    <select class="form-control input-sm" name="segundaDireccion" id="segundaDireccion" style="width: 100%" >
                                                        <option value="">Seleccione</option>
                                                        <option value="Si" <?php if ($segundaDireccion== "Si") {echo "selected";}?>>Si</option>
                                                        <option value="No" <?php if ($segundaDireccion== "No") {echo "selected";}?>>No</option>
                                                    </select>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px"></td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
         
                                                </td>
                                            </tr>                                             
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">PRECIOKIT:</td>
    
                                                <td style="width:25%"><div class="input-group">
                                                        <div class="input-group-addon input-sm">
                                                            <i class="">S/.</i>
                                                        </div>
                                                       <input type="text" class="form-control input-sm" name="lblpreciokit" id="lblpreciokit" value="<?php echo $preciokit;?>" onkeypress="return filterFloat(event, this);"  readonly="readonly"/>
                                                    </div>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">TOTAL EXTRA:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%"><div class="input-group">
                                                        <div class="input-group-addon input-sm">
                                                            <i class="">S/.</i>
                                                        </div>
                                                       <input type="text" class="form-control input-sm" name="lbltotalextra" id="lbltotalextra" value="<?php echo $totalextra;?>" onkeypress="return filterFloat(event, this);"  readonly="readonly" />
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                             <tr>
                                                <td style="width:15%;font-size: 12px">RESUMEN INST.:</td>
    
                                                <td colspan="5" style="width:77%"><textarea class="form-control input-sm" name="lblresumenventa" id="lblresumenventa" rows="1" style="resize:none"  placeholder="Ingresar..."  readonly="readonly"><?php echo $resumenventa;?></textarea></td>
    
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">REGALO AUTORIZADO:</td>
                                                <td style="width:25%;font-size: 12px">
                                                    <select class="form-control input-sm" name="lblextraautorizado" id="lblextraautorizado" disabled="disabled" >
                                                        <option>Seleccione</option>
                                                        <option value="Ninguno"<?php if ($regaloutorizado == "Ninguno") {echo "selected";}?>>Ninguno</option>
                                                        <option value="Mando a distancia"<?php if ($regaloutorizado == "Mando a distancia") {echo "selected";}?>>Mando a distancia</option>
                                                        <option value="Magnetico"<?php if ($regaloutorizado == "Magnetico") {echo "selected";}?>>Magnetico</option>
                                                        <option value="Pulsador"<?php if ($regaloutorizado == "Pulsador") {echo "selected";}?>>Pulsador</option>
                                                    </select>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">FORMA DE PAGO:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    <select class="form-control input-sm" name="lblformadepago" id="lblformadepago" disabled="disabled">
                                                        <option value="">Seleccione</option>                                                                                
                                                        <option value="Cheque" <?php if ($formadepago == "Cheque") {echo "selected";}?>>Cheque</option>
                                                         <option value="Deposito" <?php if ($formadepago == "Deposito") {echo "selected";}?>>Depósito</option>
                                                        <option value="Transferencia" <?php if ($formadepago == "Transferencia") {echo "selected";}?>>Transferencia</option>
                                                        <option value="TransferenciaInterbancaria" <?php if ($formadepago == "TransferenciaInterbancaria") {echo "selected";}?>>Transferencia Interbancaria</option>
                                                        <option value="PagoPOSVisa" <?php if ($formadepago == "PagoPOSVisa") {echo "selected";}?>>Pago POSVisa</option>
                                                        <option value="PagoPOSMC" <?php if ($formadepago == "PagoPOSMC") {echo "selected";}?>>Pago POSMC</option>
                                                        <option value="TarjetadeCredito" <?php if ($formadepago == "TarjetadeCredito") {echo "selected";}?>>Tarjeta de Crédito</option>
                                                        <option value="PagoPasarella" <?php if ($formadepago == "PagoPasarella") {echo "selected";}?>>Pago Pasarella</option>
                                                    </select>
                                                </td>
                                            </tr> 
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">590:</td>

                                                <td style="width:25%"><div class="input-group">
                                                        <div class="input-group-addon input-sm">
                                                            <i class="fa fa-calendar"></i>
                                                        </div>
                                                        <input type="text" class="form-control pull-right input-sm" id="mesano" value="<?php echo $n590;?>" name="lbl590" disabled="disabled">
                                                    </div>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">PAI:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%"><select class="form-control input-sm" name="lblPAI" id="lblPAI" disabled="disabled">
                                                        <option>Seleccione</option>
                                                        <option value="BBVA-DIN"<?php if ($PAI == "BBVA-DIN") {echo "selected";}?>>BBVA-DIN</option>
                                                        <option value="PAI 30x36"<?php if ($PAI == "PAI 30x36") {echo "selected";}?>>PAI 30x36</option>
                                                        <option value="NO"<?php if ($PAI == "NO") {echo "selected";}?>>NO</option>
                                                       
                                                    </select>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                    <!-- /.box-body -->
                                </div>
                                <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                       <h5>INFORMACIÓN DE TELECIERRE</h5>
                        
                                      <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                        </button>
                                        
                                      </div>
                                    </div>
                                    <!-- /.box-header -->
                                    <div class="box-body">
                                     <table cellspacing="0" style="width:100%;border-collapse: separate;padding: 20px;">
                        <tr>
                                                                                                <td style="width:15%;font-size: 12px">ESTADO TELECIERRE:</td>
                                                              <td style="width:25%"><select class="form-control input-sm" name="lblestadotelecierre" id="lblestadotelecierre" disabled="disabled">
                                                                                                        <option value="">Seleccione</option>
                           <option value="NoContactado" <?php if ($estadotelecierre== "NoContactado") {echo "selected";}?>>No Contactado</option>
                        <option value="NoVisitado" <?php if ($estadotelecierre== "NoVisitado") {echo "selected";}?>>No Visitado</option>
                        <option value="Contactado" <?php if ($estadotelecierre== "Contactado") {echo "selected";}?>>Contactado</option>
                        <option value="PendienteRespuesta" <?php if ($estadotelecierre== "PendienteRespuesta") {echo "selected";}?>>Pendiente Respuesta</option>
                        <option value="Online" <?php if ($estadotelecierre== "Online") {echo "selected";}?>>Vendida Online</option>
                        <option value="Ficha" <?php if ($estadotelecierre== "Ficha") {echo "selected";}?>>Vendida Ficha</option>
                        <option value="NoVendida" <?php if ($estadotelecierre== "NoVendida") {echo "selected";}?>>No Vendida</option>
                        
                                                                            </select>
                              
                                                                                                </td>
                                                                                                <td style="width:10%"></td>
                                                                                                <td style="width:15%;font-size: 12px"></td>
                                                                                                <td style="width:2%"></td>
                                                                                                <td style="width:25%">
                                                                                                </td>
                                                                                            </tr>
                                                                                            <tr class="espacio"></tr>
                                                                                              
                        <tr>
                                                                                                <td style="width:15%;font-size: 12px">TIPO VENTA TC:</td>
                                                              <td style="width:25%"><select class="form-control input-sm" name="lbltipoventatc" id="lbltipoventatc" disabled="disabled">
                                                                                                        <option value="">Seleccione</option>
                                        <option value="Telecierre" <?php if ($TCTipoVenta== "Telecierre") {echo "selected";}?>>Telecierre</option>
                                        <option value="Televenta" <?php if ($TCTipoVenta== "Televenta") {echo "selected";}?>>Televenta</option>
                        
                        
                                                                            </select>
                              
                                                                                                </td>
                                                                                                <td style="width:10%"></td>
                                                                                                <td style="width:15%;font-size: 12px">MOTIVO NO VENTA:</td>
                                                                                                <td style="width:2%"></td>
                                                                                                <td style="width:25%"><select class="form-control input-sm" name="lblmovivonoventatc" id="lblmovivonoventatc" disabled="disabled">
                                                                                             <option value="">Seleccione</option>
                                                                                             <option value="NoInteresado" <?php if ($TCMotivoNoVenta=== "NoInteresado") {echo "selected";}?>>No Interesado</option>
                                                                                             <option value="Economico" <?php if ($TCMotivoNoVenta=== "Economico") {echo "selected";}?>>Económico</option>
                                                                                             <option value="Competencia" <?php if ($TCMotivoNoVenta=== "Competencia") {echo "selected";}?>>Competencia</option>
                        <option value="NoVisitado" <?php if ($TCMotivoNoVenta=== "NoVisitado") {echo "selected";}?>>No Visitado</option>
                                                                                             <option value="TiempoContrato" <?php if ($TCMotivoNoVenta=== "TiempoContrato") {echo "selected";}?>>Tiempo Contrato</option>
                                                                                             <option value="Monitoreo" <?php if ($TCMotivoNoVenta=== "Monitoreo") {echo "selected";}?>>Monitoreo</option>
                                                                                             <option value="Especialista" <?php if ($TCMotivoNoVenta=== "Especialista") {echo "selected";}?>>Especialista</option>
                                                                                             <option value="Cliente" <?php if ($TCMotivoNoVenta=== "Cliente") {echo "selected";}?>>Cliente</option>
                                                                            </select>
                         
                                                                                                </td>
                                                                                            </tr>
                                                                                            <tr class="espacio"></tr>
                                                                                             <tr>
                                                                                                <td style="width:15%;font-size: 12px">CC TC:</td>
                    <td style="width:25%"> 
                        <select class="form-control input-sm" name="lblcctc" id="lblcctc">
                        <?php if ($dc == "511") { ?>
                        <option value="511" <?php if ($dc == "511") {echo "selected";}?> >511</option>
                        <option value="<?php 
                                               if ($CCOriginal == "150") {echo "150";}
                                            else if($CCOriginal == "151"){echo "151";}
                                            else if($CCOriginal == "152"){echo "152";}
                                            else if($CCOriginal == "153"){echo "153";}
                                            else if($CCOriginal == "154"){echo "154";}
                                            else if($CCOriginal == "155"){echo "155";}
                                            else if($CCOriginal == "156"){echo "156";}
                                            else if($CCOriginal == "157"){echo "157";}
                                            else if($CCOriginal == "158"){echo "158";}
                                            else if($CCOriginal == "159"){echo "159";}
                                            else if($CCOriginal == "200"){echo "200";}
                                            else if($CCOriginal == "250"){echo "250";}
                                            else if($CCOriginal == "251"){echo "251";}
                                            else if($CCOriginal == "252"){echo "252";}
                                            else if($CCOriginal == "20"){echo "20";}
                                            else if($CCOriginal == "140"){echo "140";}
                                            else if($CCOriginal == "141"){echo "141";}
                                            else if($CCOriginal == "120"){echo "120";}
                                            else if($CCOriginal == "121"){echo "121";}
                                            else if($CCOriginal == "100"){echo "100";}
                                            else if($CCOriginal == "80"){echo "80";}
                                            else if($CCOriginal == "40"){echo "40";}
                                            else if($CCOriginal == "41"){echo "41";}
                                            else if($CCOriginal == "42"){echo "42";}
                                            else if($CCOriginal == "601"){echo "601";}
                                            else if($CCOriginal == "701"){echo "701";}
                                            else if($CCOriginal == "702"){echo "702";}
                                            else if($CCOriginal == "901"){echo "901";}
                                            else if($CCOriginal == "130"){echo "130";}
                                            else if($CCOriginal == "230"){echo "230";}
                                            else if($CCOriginal == "60"){echo "60";}
                                            ?>">
                                    
                                    <?php if ($CCOriginal == "150") {echo "150";}
                                            else if($CCOriginal == "151"){echo "151";}
                                            else if($CCOriginal == "152"){echo "152";}
                                            else if($CCOriginal == "153"){echo "153";}
                                            else if($CCOriginal == "154"){echo "154";}
                                            else if($CCOriginal == "155"){echo "155";}
                                            else if($CCOriginal == "156"){echo "156";}
                                            else if($CCOriginal == "157"){echo "157";}
                                            else if($CCOriginal == "158"){echo "158";}
                                            else if($CCOriginal == "159"){echo "159";}
                                            else if($CCOriginal == "200"){echo "200";}
                                            else if($CCOriginal == "250"){echo "250";}
                                            else if($CCOriginal == "251"){echo "251";}
                                            else if($CCOriginal == "252"){echo "252";}
                                            else if($CCOriginal == "20"){echo "20";}
                                            else if($CCOriginal == "140"){echo "140";}
                                            else if($CCOriginal == "141"){echo "141";}
                                            else if($CCOriginal == "120"){echo "120";}
                                            else if($CCOriginal == "121"){echo "121";}
                                            else if($CCOriginal == "100"){echo "100";}
                                            else if($CCOriginal == "80"){echo "80";}
                                            else if($CCOriginal == "40"){echo "40";}
                                            else if($CCOriginal == "41"){echo "41";}
                                            else if($CCOriginal == "42"){echo "42";}
                                            else if($CCOriginal == "601"){echo "601";}
                                            else if($CCOriginal == "701"){echo "701";}
                                            else if($CCOriginal == "702"){echo "702";}
                                            else if($CCOriginal == "901"){echo "901";}
                                            else if($CCOriginal == "130"){echo "130";}
                                            else if($CCOriginal == "230"){echo "230";}
                                            else if($CCOriginal == "60"){echo "60";}
                                              
                         ?></option>
                        <?php }else if($dc == "500"){?>
                            <option value="500" <?php if ($dc == "500") {echo "selected";}?> hidden="">500</option>
                        <?php }else if($dc == "512"){?>
                        <option value="512" <?php if ($dc == "512") {echo "selected";}?> hidden="">512</option>
                        <?php }else{?>
                                <option value="150" <?php if ($dc == "150") {echo "selected";}?>>150</option>
                                <option value="151" <?php if ($dc == "151") {echo "selected";}?>>151</option>
                                <option value="152" <?php if ($dc == "152") {echo "selected";}?>>152</option>
                                <option value="153" <?php if ($dc == "153") {echo "selected";}?>>153</option>
                                <option value="154" <?php if ($dc == "154") {echo "selected";}?>>154</option>
                                <option value="155" <?php if ($dc == "155") {echo "selected";}?>>155</option>
                                <option value="156" <?php if ($dc == "156") {echo "selected";}?>>156</option>
                                <option value="157" <?php if ($dc == "157") {echo "selected";}?>>157</option>
                                <option value="158" <?php if ($dc == "158") {echo "selected";}?>>158</option>
                                <option value="159" <?php if ($dc == "159") {echo "selected";}?>>159</option>
                                <option value="200" <?php if ($dc == "200") {echo "selected";}?>>200</option>
                                <option value="250" <?php if ($dc == "250") {echo "selected";}?>>250</option>
                                <option value="251" <?php if ($dc == "251") {echo "selected";}?>>251</option>
                                <option value="252" <?php if ($dc == "252") {echo "selected";}?>>252</option>
                                <option value="20" <?php if ($dc == "20") {echo "selected";}?>>20</option>
                                <option value="140" <?php if ($dc == "140") {echo "selected";}?>>140</option>
                                <option value="141" <?php if ($dc == "141") {echo "selected";}?>>141</option>
                                <option value="80" <?php if ($dc == "80") {echo "selected";}?>>80</option>
                                <option value="120" <?php if ($dc == "120") {echo "selected";}?>>120</option>
                                <option value="121" <?php if ($dc == "121") {echo "selected";}?>>121</option>
                                <option value="100" <?php if ($dc == "100") {echo "selected";}?>>100</option>
                                <option value="40" <?php if ($dc == "40") {echo "selected";}?>>40</option>
                                <option value="41" <?php if ($dc == "41") {echo "selected";}?>>41</option>
                                <option value="42" <?php if ($dc == "42") {echo "selected";}?>>42</option>
                                <option value="511" <?php if ($dc == "511") {echo "selected";}?> >511</option>
                                <option value="513" <?php if ($dc == "513") {echo "selected";}?>>513</option>
                                <option value="601" <?php if ($dc == "601") {echo "selected";}?> hidden="">601</option>
                                <option value="701" <?php if ($dc == "701") {echo "selected";}?>>701</option>
                                <option value="702" <?php if ($dc == "702") {echo "selected";}?>>702</option>
                                <option value="901" <?php if ($dc == "901") {echo "selected";}?>>901</option>
                                <option value="130" <?php if ($dc == "130") {echo "selected";}?>>130</option>
                                <option value="230" <?php if ($dc == "230") {echo "selected";}?>>230</option>
                                <option value="60" <?php if ($dc == "60") {echo "selected";}?>>60</option>
                        <?php } ?>
                                                                                                        
                        
                        
                                                                            </select>
                               
                                                                                                </td>
                                                                                                <td style="width:10%"></td>
                                                                                                <td style="width:15%;font-size: 12px">GESTOR TC:</td>
                                                                                                <td style="width:2%"></td>
                                                                                                <td style="width:25%"> 
                        
                        <select name="lblgestortc" id="lblgestortc" class="form-control cbxtelecierre input-sm" style="width: 100%;" disabled="disabled">
                                                                                                      <?php echo $html_tc;?>
                                                       </select>
                                                                                                </td>
                                                                                            </tr>
                                                                                            <tr class="espacio"></tr>
                                                                       
                                                                                            
                                                                                             <tr>
                                                                                                <td style="width:15%;font-size: 12px">PRECIOKIT TC:</td>
                        
                                                                                                <td style="width:25%"><div class="input-group" disabled="disabled">
                                                                                                        <div class="input-group-addon input-sm">
                                                                                                            <i class="">S/.</i>
                                                                                                        </div>
                                                                                                       <input type="text" class="form-control input-sm" name="lblpreciokittc" id="lblpreciokittc" value="<?php echo $preciokit;?>" onkeypress="return filterFloat(event, this);" disabled="disabled" />
                                                                                                    </div>
                                                                                                </td>
                                                                                                <td style="width:10%"></td>
                                                                                                <td style="width:15%;font-size: 12px">TOTAL EXTRA TC:</td>
                                                                                                <td style="width:2%"></td>
                                                                                                <td style="width:25%"><div class="input-group" disabled="disabled">
                                                                                                        <div class="input-group-addon input-sm">
                                                                                                            <i class="">S/.</i>
                                                                                                        </div>
                                                                                                       <input type="text" class="form-control input-sm" name="lbltotalextratc" id="lbltotalextratc" value="<?php echo $totalextra;?>" onkeypress="return filterFloat(event, this);" disabled="disabled"/>
                                                                                                    </div>
                                                                                                    
                                                                                                    
                                                                                                    
                                                                                                </td>
                                                                                            </tr>
                        <tr class="espacio"></tr>
                                                                                             <tr>
                                                                                                <td style="width:15%;font-size: 12px">RESUMEN INST. TC:</td>
                        
                                                                                                <td colspan="5" style="width:77%"><textarea class="form-control input-sm" name="lblresumenventatc" id="lblresumenventatc" rows="1" style="resize:none"  placeholder="Ingresar..." disabled="disabled"><?php echo $resumenventa;?></textarea></td>
                        
                                                                                            </tr>
                         <tr class="espacio"></tr>
                                                                                            <tr>
                                                                                                <td style="width:15%;font-size: 12px">REGALO AUTORIZADO TC:</td>
                        
                                                                                                <td style="width:25%;font-size: 12px"><select class="form-control input-sm" name="lblextraautorizadotc" id="lblextraautorizadotc" disabled="disabled">
                                                                                                        <option>Seleccione</option>
                        <option value="Ninguno"<?php if ($regaloutorizado == "Ninguno") {echo "selected";}?>>Ninguno</option>
                                                                                                         <option value="Mando a distancia"<?php if ($regaloutorizado == "Mando a distancia") {echo "selected";}?>>Mando a distancia</option>
                                                                                                          <option value="Magnetico"<?php if ($regaloutorizado == "Magnetico") {echo "selected";}?>>Magnetico</option>
                                                                                                           <option value="Pulsador"<?php if ($regaloutorizado == "Pulsador") {echo "selected";}?>>Pulsador</option>
                                                                                                      
                        
                                                                                                    </select>
                                                                                                </td>
                                                                                                <td style="width:10%"></td>
                                                                                                <td style="width:15%;font-size: 12px">FORMA DE PAGO TC:</td>
                                                                                                <td style="width:2%"></td>
                                                                                                <td style="width:25%">
                                                                                                   <select class="form-control input-sm" name="lblformadepagotc" id="lblformadepagotc" disabled="disabled">
                        <option value="">Seleccione</option>                                                                                
                        <option value="Cheque" <?php if ($formadepago == "Cheque") {echo "selected";}?>>Cheque</option>
                                                                                                         <option value="Deposito" <?php if ($formadepago == "Deposito") {echo "selected";}?>>Depósito</option>
                                                                                                        <option value="Transferencia" <?php if ($formadepago == "Transferencia") {echo "selected";}?>>Transferencia</option>
                                                                                                        <option value="TransferenciaInterbancaria" <?php if ($formadepago == "TransferenciaInterbancaria") {echo "selected";}?>>Transferencia Interbancaria</option>
                                                                                                        <option value="PagoPOSVisa" <?php if ($formadepago == "PagoPOSVisa") {echo "selected";}?>>Pago POSVisa</option>
                                                                                                        <option value="PagoPOSMC" <?php if ($formadepago == "PagoPOSMC") {echo "selected";}?>>Pago POSMC</option>
                                                                                                        <option value="TarjetadeCredito" <?php if ($formadepago == "TarjetadeCredito") {echo "selected";}?>>Tarjeta de Crédito</option>
                                                                                                        <option value="PagoPasarella" <?php if ($formadepago == "PagoPasarella") {echo "selected";}?>>Pago Pasarella</option>
                                                                                                    </select>
                                                                                                </td>
                                                                                            </tr> 
                                                                                            <tr class="espacio"></tr>
                                                                                            <tr>
                                                                                                <td style="width:15%;font-size: 12px">MESES AUTORIZADOS TC:</td>
                        
                                                                                                <td style="width:25%"><input type="text" maxlength="3" class="form-control input-sm" id="lblmesesautorizadostc" name="lblmesesautorizadostc"  value="<?php echo $mesesautorizados;?>" onkeypress="return filterFloat(event, this);" disabled="disabled">
                                                                                                </td>
                                                                                                <td style="width:10%"></td>
                                                                                                <td style="width:15%;font-size: 12px">PAI TC:</td>
                                                                                                <td style="width:2%"></td>
                                                                                                <td style="width:25%"><select class="form-control input-sm" name="lblPAItc" id="lblPAItc" disabled="disabled">
                                                                                                        <option>Seleccione</option>
                                                                                                        <option value="BBVA-DIN"<?php if ($PAI == "BBVA-DIN") {echo "selected";}?>>BBVA-DIN</option>
                                                                                                        <option value="PAI 30x36"<?php if ($PAI == "PAI 30x36") {echo "selected";}?>>PAI 30x36</option>
                                                                                                        <option value="NO"<?php if ($PAI == "NO") {echo "selected";}?>>NO</option>
                                                                                                       
                                                                                                    </select>
                                                                                                </td>
                                                                                            </tr>
                                                                                            <tr class="espacio"></tr>
                                                                                           
                                                                                            <tr>
                                                          
                        
                        <td style="width:15%;font-size: 12px">COMENTARIO TC:</td>
                        
                        <td colspan="5" style="width:77%"><textarea class="form-control input-sm" name="lblcomentariotc" id="lblcomentariotc" rows="3" style="resize:none"  placeholder="Ingresar..." disabled="disabled"><?php echo $TCComentario;?></textarea></td>
                                                                                            </tr>
                                                                                            
                                                                                           
                                                                                        </table>
                                    </div>
                                    <!-- /.box-body -->
                        
                                  </div>
                                <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                       <h5>INFORMACION DE AGENDA</h5>
                        
                                      <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                        </button>
                                        
                                      </div>
                                    </div>
                                    <!-- /.box-header -->
                                    <div class="box-body">
                                     <table cellspacing="0" style="width:100%;border-collapse: separate;padding: 20px;">
                                                                                              <tr>
                                                                                                <td style="width:15%;font-size: 12px">INSTALADOX:</td>
                        
                                                                                                <td style="width:25%"><select class="form-control input-sm" name="lblinstaladox" id="lblinstaladox" disabled="disabled">
                                                                                                        <option>Seleccione</option>
                                                                                                         <option value="TEC"<?php if ($instaladox == "TEC") {echo "selected";}?>>TEC</option>
                                                                                                        <option value="DEL"<?php if ($instaladox == "DEL") {echo "selected";}?>>DEL</option>
                                                                                                    </select>
                                                                                                    
                                                                                                    <input id="lblidagenda" name="lblidagenda" value="<?php echo $idagenda;?>" hidden="">
                                                                                                </td>
                                                                                                <td style="width:10%"></td>
                                                                                                <td style="width:15%;font-size: 12px">TÉCNICO:</td>
                                                                                                <td style="width:2%"></td>
                                                                                                <td style="width:25%"> 
                                                                                                    <select name="lbltecnico" id="lbltecnico" class="form-control cbxtecnico input-sm" style="width: 100%;" disabled="disabled">
                                                                                                        <?php echo $html_tecnico;?>
                                                                                                    </select>
                                                                                                </td>
                                                                                            </tr>
                                                                                            <tr class="espacio"></tr>
                                                                       
                                                                                            
                                                                                            <tr>
                                                                                                <td style="width:15%;font-size: 12px">F.INSTALACIÓN:</td>
                        
                                                                                                <td style="width:25%"><div class="input-group" id="fi">
                                                                                                        <div class="input-group-addon input-sm">
                                                                                                            <i class="fa fa-calendar"></i>
                                                                                                        </div>
                                                                                                        <input type="text" class="form-control pull-right input-sm" id="fechainst" value="<?php echo $fechainstalacionver;?>"  name="lblfinstalacion" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled="disabled">
                                                                                                    </div>
                                                                                                    
                                                                                                </td>
                                                                                                <td style="width:10%"></td>
                                                                                                <td style="width:15%;font-size: 12px">H.INSTALACIÓN:</td>
                                                                                                <td style="width:2%"></td>
                                                                                                
                                                                                                <td style="width:25%">
                                                                     
                                                                                                    
                                                                                                    <div class="bootstrap-timepicker timepicker">
                                                                                                     <div class="input-group">
                                                                                                         <input type="text" class="form-control input-sm" placeholder="12:00 AM" name="lblhinstalacion" id="horainst" value="<?php echo $horainstalacionver;?>" disabled="disabled" >
                                                                                                            <div class="input-group-addon input-sm">
                                                                                                                <i class="fa fa-clock-o"></i>
                                                                                                            </div>
                                                                                                        </div>
                                                                                                    </div>
                                                                                                       
                                                                                                    
                                                                                                </td>
                                                                                            </tr>
                                                                                            <tr class="espacio"></tr>
                                                                                            <tr>
                                                                                                <td style="width:15%;font-size: 12px">REPERCUCIÓN:</td>
                                                                                                <td colspan="3" style="width:50%"><textarea class="form-control input-sm" name="lblrepercucion" id="lblrepercucion" rows="1" style="resize:none" placeholder="Ingresar..." disabled="disabled"><?php echo $repercucion;?></textarea></td>
                                                                                                <td style="width:2%"></td>
                                                                                                <td style="width:25%"><a class="btn btn-danger btn-sm"  href="#" data-toggle="modal" id="logcambios" data-target="#modal-default"><i class="fa fa-pencil-square-o"></i> Log Cambios</a></td>
                                                                                            </tr>
                                                                                            <tr class="espacio"></tr>
                                                                                            
                                                                                            <tr>
                                                                                                <td style="width:15%;font-size: 12px">COMENTARIO:</td>
                        
                                                                                                <td colspan="3" style="width:50%"><textarea class="form-control input-sm" name="lblcomentarioagenda" id="lblcomentarioagenda" rows="1" style="resize:none" placeholder="Ingresar..." disabled="disabled"><?php utf8_encode($comentarioagenda);?></textarea></td>
                        
                                                                                                <td style="width:2%"></td>
                                                                                                <td style="width:25%"> </td>
                                                                                            </tr>
                                                                                            
                                                                                            <tr class="espacio" id="tinviableespacio"></tr>
                                                                                            <tr id="tinviable">
                                                                                                <td style="width:15%;font-size: 12px">MOTIVO INVIABLE:</td>
                        
                                                                                                <td colspan="3" style="width:50%"><textarea class="form-control input-sm" name="lblinviable" id="lblinviable" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo $motivoinviable;?></textarea></td>
                        
                                                                                                <td style="width:2%"></td>
                                                                                                <td style="width:25%"></td>
                                                                                            </tr>
                                                                                            
                                                                                            <tr class="espacio" id="tcanceladoespacio"></tr>
                                                                                            <tr id="tcancelado">
                                                                                                <td style="width:15%;font-size: 12px">MOTIVO CANCELADO:</td>
                        
                                                                                                <td colspan="3" style="width:50%"><textarea class="form-control input-sm" name="lblcancelado" id="lblcancelado" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo $motivocancelado;?></textarea></td>
                        
                                                                                                <td style="width:2%"></td>
                                                                                                <td style="width:25%"></td>
                                                                                            </tr>
                        
                                                                                          
                                                                                        </table>
                                    </div>
                                    <!-- /.box-body -->
                        
                                  </div>
                                <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                      <h5>INFORMACION DE FACTURACIÓN</h5>
                        
                                      <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                        </button>
                                        
                                      </div>
                                    </div>
                                    <!-- /.box-header -->
                                    <div class="box-body">
                                  <table cellspacing="0" style="width:100%;border-collapse: separate;padding: 20px;">
                                                                                            <tr>
                                                                                                <td style="width:15%;font-size: 12px">MOTIVO INCIDENCIA:</td>
                                                                                                <td colspan="7" style="width:77%"><textarea class="form-control input-sm" name="lblmotivoincidencia" id="lblmotivoincidencia" rows="1" style="resize:none" placeholder="Ingresar..." disabled="disabled"><?php echo $factmotivoincidencia;?></textarea></td>
                                                                                            </tr>
                                                                                            <tr class="espacio"></tr>
                                                                                            <tr>
                                                                                                <td style="width:15%;font-size: 12px">FECHA RECEPCION DOC.:</td>
                                                                                                <td style="width:25%"><div class="input-group">
                                                                                                        <div class="input-group-addon input-sm">
                                                                                                            <i class="fa fa-calendar"></i>
                                                                                                        </div>
                                                                                                        <input type="text" class="form-control pull-right input-sm" id="lblfecharecpciondoc"  name="lblfecharecpciondoc" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask value="<?php echo $factfecharecepciondoc;?>" disabled="disabled" >
                                                                                                    </div>
                                                                                                </td>
                                                                                                <td style="width:10%"></td>
                                                                                                <td style="width:15%;font-size: 12px">FECHA DE FACTURACIÓN: <span style="font-size: 12px; color:red ">(*)</span></td>
                                                                                                <td style="width:2%"></td>
                                                                                                <td style="width:25%"><div class="input-group">
                                                                                                        <div class="input-group-addon input-sm">
                                                                                                            <i class="fa fa-calendar"></i>
                                                                                                        </div>
                                                                                                        <input type="text" class="form-control pull-right input-sm" id="lblfechafacturacion"  name="lblfechafacturacion" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask value="<?php echo $factfechafacturacion;?>" disabled="disabled" />
                                                                                                    </div></td>
                                                                                            </tr>
                                        </table>
                                        
                                        <table cellspacing="0"  style="width:100%;border-collapse: separate;padding: 20px">                                                  
                                                                                            <tr>
                                                                                                <td style="font-size: 12px; color:red ">MOTIVOS DE INCIDENCIA (*):</td>
                                                                                            </tr>
                                                                                            <tr class="espacio"></tr>
                                                                                            <tr>
                                                                                                <td style="width:8%;font-size: 12px">DOC. ORIGINAL:</td>
                                                                                                <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactdocoriginal" id="lblfactdocoriginal" value="<?php echo $factdocoriginal;?>" disabled="disabled" /></td>
                                                                                                <td style="width:8%"></td>
                                                                                                <td style="width:8%;font-size: 12px">FALTA DNI:</td>
                                                                                                <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactdni" id="lblfactdni" value="<?php echo $factdni;?>" disabled="disabled" /></td>
                                                                                                <td style="width:8%"></td>
                                                                                                <td style="width:8%;font-size: 12px">REHACER CTO:</td>
                                                                                                <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactrehacercto" id="lblfactrehacercto" value="<?php echo $factrehacercto;?>" disabled="disabled" /></td>
                                                                                            </tr>
                                                                                            <tr class="espacio"></tr>
                                                                                            <tr>
                                                                                                <td style="width:8%;font-size: 12px">SEGMENTACIÓN:</td>
                                                                                                <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactsegmentacion" id="lblfactsegmentacion" value="<?php echo $factsegmentacion;?>" disabled="disabled" /></td>
                                                                                                <td style="width:8%"></td>
                                                                                                <td style="width:8%;font-size: 12px">ELEMENTOS CTO PS:</td>
                                                                                                <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactelementosctops" id="lblfactelementosctops" value="<?php echo $factelementosctops;?>" disabled="disabled" /></td>
                                                                                                <td style="width:8%"></td>
                                                                                                <td style="width:8%;font-size: 12px">AFILIACION:</td>
                                                                                                <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactafiliacion" id="lblfactafiliacion" value="<?php echo $factafiliacion;?>" disabled="disabled" /></td>
                                                                                            </tr>
                                                                                            <tr class="espacio"></tr>
                                                                                            <tr>
                                                                                                <td style="width:8%;font-size: 12px">PAGO:</td>
                                                                                                <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactpago" id="lblfactpago" value="<?php echo $factpago;?>" disabled="disabled" /></td>   
                                                                                                <td style="width:8%"></td>
                                                                                                <td style="width:8%;font-size: 12px">DOC PAI:</td>
                                                                                                <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactdocpai" id="lblfactdocpai" value="<?php echo $factdocpai;?>" disabled="disabled" /></td>
                                                                                                <td style="width:8%"></td>
                                                                                                <td style="width:8%;font-size: 12px">PROSPECTO/NRO GUIA:</td>
                                                                                                <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactprospecto_nroguia" id="lblfactprospecto_nroguia" value="<?php echo $factprospecto_nroguia;?>" disabled="disabled" /></td>
                                                                                            </tr>
                                                                                            <tr class="espacio"></tr>
                                                                                            <tr>
                                                                                                <td style="width:8%;font-size: 12px">AUTORIZA:</td>
                                                                                                <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactautoriza" id="lblfactautoriza" value="<?php echo $factautoriza;?>" disabled="disabled" /></td>
                                                                                                <td style="width:8%"></td>
                                                                                                <td style="width:8%;font-size: 12px">FALTA DOC (P.A./CTO):</td>
                                                                                                <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactfaltadoc" id="lblfactfaltadoc" value="<?php echo $factfaltadoc;?>" disabled="disabled" /></td>
                                                                                                <td style="width:8%"></td>
                                                                                                <td style="width:8%;font-size: 12px">FUERA DE HORA:</td>
                                                                                                <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactfuerahora" id="lblfactfuerahora" value="<?php echo $factfuerahora;?>" disabled="disabled" /></td>
                                                                                            </tr>
                                            </table> 
                                    </div>
                                    <!-- /.box-body -->
                               
                                  </div>
                            </form>
                        </div>
                        <div class="col-md-2"></div>
                    </div>
                    <div class="modal fade" id="modal-default">
                        <div class="modal-dialog modal-lg">
                        <div class="modal-content">
                            <div class="modal-header modal-header-danger">
                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                <h4>GESTIONES DE AGENDAMIENTO</h4>
                            </div>
                            <div class="modal-body" id="vistaboy">
                                <div id="myGrid"  style="height: 100%" class="ag-theme-fresh"></div>
                                <div  id="ningunresultado"></div>
                            </div> 
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                            </div>                  
                        </div>
                    </div>  
                        <!-- /.modal-content -->
                    </div>
                </section>
                    <!-- /.modal-dialog -->
            </div>
                <!-- /.modal -->
                
            <div class="modal fade" id="mapgeofinder">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header modal-header-success">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h4 class="modal-title">DIRECCION</h4>
                        </div>
                        <div class="modal-body" style="width: 100%;height:100%;">
                           <iframe height="450"  allowTransparency="true" frameborder="0" scrolling="yes" style="width:100%;" src="GFWIDGET-PE-v2/buscadorDirExacta.html" type= "text/javascript"></iframe>
                        </div>
                        <div class="modal-footer">
                            <!--<button type="button" class="btn btn-danger pull-irght" id="btnDireccionManual">MANUAL</button> -->
                            <button type="button" class="btn btn-default pull-right" data-dismiss="modal">CERRAR</button>
                        </div>
                    </div>
                    <!-- /.modal-content -->

                </div>
                <!-- /.modal-dialog -->
            </div>
            
            <!--MODAL MAPA -->
            <div class="modal fade" id="mapgeofinderDirAprox">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header modal-header-danger">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h4 class="modal-title"><i class=""></i> DIRECCION APROXIMADA</h4>
                        </div>
                        <div class="modal-body" style="width: 100%;height:100%;">
                           <iframe id="geofinderwidgetDirAprox" name="geofinderwidgetDirAprox" height="450"  allowTransparency="true" frameborder="0" scrolling="yes" style="width:100%;" src="GFWIDGET-PE-v2/buscadorDirAprox.html" type= "text/javascript"></iframe>
                        </div>
                        <div class="modal-footer">
                            <!--<button type="button" class="btn btn-danger pull-irght" id="btnGuardarDirAprox">Guardar</button>-->
                            <button type="button" class="btn btn-default pull-right" data-dismiss="modal">CERRAR</button>
                        </div>
                    </div>
                    <!-- /.modal-content -->

                </div>
                <!-- /.modal-dialog -->
            </div>
            <!-- MODAL CHECK IN -->
            <div class="modal fade" id="modal-checkin">
                        <div class="modal-dialog modal-log">
                            <div class="modal-content">
                                <div class="modal-header modal-header-danger">
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                    <h4>Validar Check-IN ...</h4>
                                </div>
                                <div class="modal-body">
                                    <div class="box box-solid">
                                        <div class="box-header with-border">
                                            <i class="fa fa-map-marker"></i>
                                            <h3 class="box-title">Información del Check-IN</h3>
                                        </div>
                                        <!-- /.box-header -->
                                        <div class="box-body">
                                            <dl class="dl-horizontal">
                                                <dt>Distancia: </dt>
                                                <dd><?php echo $Distancia.' metros'; ?></dd>
                                                <dt>Fecha envío:</dt>
                                                <dd><?php echo $FechaEnvio; ?></dd>
                                                <dt>Tipo:</dt>
                                                <dd><?php echo $Tipo; ?></dd>
                                                <dt>Matricula:</dt>
                                                <dd><?php echo $lblnombcomercial.' ('.$MatriculaCheckIn.')'; ?></dd>
                                                <!-- <dt>Visita No Visitable:</dt>
                                                <dd><?php //echo $VisitaNoVisitable; ?></dd> -->
                                                <dt>Observaciones Check-IN:</dt>
                                                <dd><?php echo $ObservacionesCheckIN; ?></dd>
                                            </dl>
                                        </div>
                                        <!-- /.box-body -->
                                    </div>
                                    <!--
                                    <div class="box box-solid">
                                        <div class="box-header with-border">
                                            <i class="fa fa-map-marker"></i>
                                            <h3 class="box-title">Información de la VnoV</h3>
                                        </div>
                                        <div class="box-body">
                                            <dl class="dl-horizontal">
                                                <dt>MotivoVNOV: </dt>
                                                <dd></dd>
                                            </dl>
                                        </div>
                                    </div>
                                    -->
                                    <div id="mapContenedor">
                                        <div id="map"></div>
                                    </div>
                                    
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-success" id="btnGuardarCheckIn">Validar</button>
                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                                </div>  
                            </div>
                        </div>
                    </div>
            <!-- MODAL DE DUPLICIDAD -->
            <div class="modal fade" id="modal-numero">
    
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header modal-header-danger">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                <h3 id="myModalLabel">INFORMACIÓN - NUMERO</h3>
                        </div>
                        <div class="modal-body">
                                    <div class="row">
                                        <!-- left column -->
                                        <div class="col-xs-12">
                                            <!-- general form elements -->
                                            <div class="box box-danger">
                                                <div class="box-header with-border">
                                                  <h1 class="box-title">VALIDAR NÚMERO - <span id="spanNumero"></span></h1>
                                                </div>
                                                <!-- /.box-header -->
                                                <!-- form start -->
                                                <div class="box-body" id="bodyprincipal">
                                                    <p id="tot">Total de registros: <code><span id="countBUSCAR"></span></code></p>
                                                    <div  id="vistaboy9" style="height: 280px">
                                                    <div id="myGrid3"  style="height: 100%" class="ag-theme-fresh"></div>
                                                    <div  id="ningunresultadoNumero"></div>
                                                      </div>
                                                </div>
                                                <!-- /.box-body -->
                                            </div>
                                            <!-- /.box -->
                                        </div>
                                    </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                        </div>   
                    </div>
                    <!-- /.modal-content -->
                </div>
                <!-- /.modal-dialog -->
            </div>   
            <!-- MODAL SCORING -->
            <div class="modal fade" id="modal-consultascoring">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header modal-header-danger">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h4>CONSULTAR SCORING</h4>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-horizontal" style="padding: 10px 20px 0">
                                        <div class="form-group">
                                            <label style="text-align: left;">TIPO DOCUMENTO:</label>
                                            <select class="form-control input-sm" name="EquifaxTipoDocumento" id="EquifaxTipoDocumento">
                                                <option value="">Seleccione</option>
                                                <option value="1">DNI</option>
                                                <option value="3">Carnet Extranjeria</option>
                                                <option value="6">RUC</option>
                                            </select>
                                            <a href="https://soluciones.equifax.com.pe/efx-portal-web/" target="_blank" title="Modal de Busqueda de Documento" id="btnBusquedaDocumento">(No tengo el Número de Documento)</a>
                                        </div>
                                        <div class="form-group">
                                            <label id="labeltelefono">DOCUMENTO: </label>
                                            <input type="text" class="form-control input-sm" name="EquifaxDocumento" id="EquifaxDocumento" maxlength="12" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
                                        </div>
                                        <div class="form-group">
                                        <label>DEPARTAMENTO: </label>
                                            <select class="form-control input-sm select2full" name="EquifaxDepartamental" id="EquifaxDepartamental" style="width: 100%">
                                                    <option value="" selected>Seleccione</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                        <label>PROVINCIA: </label>
                                             <select class="form-control input-sm select2full" name="EquifaxProvincial" id="EquifaxProvincial" style="width: 100%">
                                                    <option value="">Seleccione</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                        <label>DISTRITO: </label>
                                            <select class="form-control input-sm select2full" name="EquifaxDistrital" id="EquifaxDistrital" style="width: 100%">
                                                    <option value="">Seleccione</option>
                                            </select>
                                         </div>
                                        <div class="form-group" style="margin-top:40px;">
                                            <button class="btn  btn-block btn-verisure" id="btnScoring">Consultar Scoring</button>
                                            <button class="btn  btn-block btn-verisure" style="display:none" id="btnNuevaScoring">Nueva Consulta</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <main class="contenedor ocultar box box-danger" id="ResultadoEquifax">
                                        <div id="resultado">
                                            <div class="callout bg-deuda">
                                                <h4><i class="fa fa-bullhorn"></i> Resultado de la Consulta:</h4>
                                                <h2 style="text-align: center;"><small class="label bg-visita"><span class="TextoAccion"></span></small><small class="label bg-televenta"><span class="TextoAccion"></span></small><small class="label bg-gestion"><span class="TextoAccion"></span></small></h2>
                                                <input type="hidden" id="idscoring">
                                                <!--<strong>N°Operación: </strong><span id="NOperacion">S32012280000162</span><br>-->
                                                <strong>Fecha Consulta: </strong><span id="FechaConsulta">13/11/2019 12:24:34</span><br><br>
                                                <div class="row">
                                                    <div class="col-xs-12">
                                                        <strong><i class="fa fa-user text-danger"></i> Nombre del Solicitante:</strong><br><span id="NombreCompleto">DUBOIS DORIBAL DUBOIS DORIBAL GLADYS ELVIRA</span><br>
                                                        <strong><i class="fa fa-folder-open text-danger"></i> <span id="TDocumento">DNI:</span></strong><br><span id="NumeroDocumento">00007039332</span><br>
                                                    </div>
                                       
                                                    <div class="col-xs-12">
                                                        <div class="contenido-score">
                                                            <div class="score-info">
                                                                <div>
                                                                    <strong>SCORE - RIESGO</strong>
                                                                    <br>
                                                
                                                                    <span id="Riesgo">Bajo</span>
                                                                </div>
                                                                <div>
                                                                    <strong>SCORE - VALOR</strong>
                                                                    <br>
                                                                    <div id="ValorScoring">952</div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                  </main>    
                                </div>
                             </div> 
                        </div>

                    </div>
                </div>
            </div>
            <!-- MODAL RESUMEN -->
            <div class="modal fade" id="modal-resumenVisita">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header modal-header-danger">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h4>RESUMEN VISITA</h4>
                        </div>
                        <div class="modal-body">
                            <table class="table">
                                <tbody>
                                    <tr>
                                        <td>FECHA HORA COTIZACION</td>
                                        <td><?php echo $FechaHoraCotizacion; ?></td>
                                    </tr>
                                    <tr>
                                        <td>GESTION</td>
                                        <td><?php echo $Gestion; ?></td>
                                    </tr>                                     
                                    <?php if($Gestion=='inbound'){?>
                                    <tr>
                                        <td>TELEFONO INBOUND</td>
                                        <td><?php echo ($Telefonotres=='')?$movil:$Telefonotres; ?></td>
                                    </tr>
                                    <?php } ?>
                                    <tr>
                                        <td>TIPO DOCUMENTO</td>
                                        <td><?php echo $TipoDocumento; ?></td>
                                    </tr>
                                    <tr>
                                        <td>NDOCUMENTO</td>
                                        <td><?php echo $Documento; ?></td>
                                    </tr>
                                    <tr>
                                        <td>LEADID</td>
                                        <td><?php echo $LeadID; ?></td>
                                    </tr>
                                    <tr>
                                        <td>NPROSPECTO</td>
                                        <td><?php echo $nprospecto; ?></td>
                                    </tr>
                                    <tr>
                                        <td>GRUPO ACD</td>
                                        <td><?php echo $GrupoACD; ?></td>
                                    </tr>
                                    <tr>
                                        <td>CLIENTE</td>
                                        <td><?php echo $cliente; ?></td>
                                    </tr>
                                    <tr>
                                        <td>DIRECCION</td>
                                        <td>
                                            <textarea style="width: 100%" rows="2"><?php echo $direccion; ?></textarea>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>INTERIOR</td>
                                        <td>
                                            <textarea style="width: 100%" rows="2"><?php echo $Interior; ?></textarea>
                                        </td>
                                    </tr>                                    
                                    <tr>
                                        <td>REFERENCIA</td>
                                        
                                        <td>
                                            <textarea style="width: 100%" rows="2"><?php echo $Referencia; ?></textarea>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>DISTRITO</td>
                                        <td><?php echo $distrito; ?></td>
                                    </tr>
                                    <tr>
                                        <td>PROVINCIA</td>
                                        <td><?php echo $provincia; ?></td>
                                    </tr>
                                    <tr>
                                        <td>TIPO DE INSTALACION</td>
                                        <td><?php echo $segmento; ?></td>
                                    </tr>
                                    <tr>
                                        <td>FECHA VISITA:</td>
                                        <td><?php echo $fechavisita; ?></td>
                                    </tr>
                                    <tr>
                                        <td>HORA VISITA:</td>
                                        <td><?php echo $horavisita; ?></td>
                                    </tr>
                                    <tr>
                                        <td>RECURSO</td>
                                        <td><?php echo $tipoventa; ?></td>
                                    </tr>
                                    <tr>
                                        <td>CORREO</td>
                                        <td><?php echo $correo; ?></td>
                                    </tr>
                                    <tr>
                                        <td>TELEFONO</td>
                                        <td><?php echo $movil; ?></td>
                                    </tr>
                                    <tr>
                                        <td>TELEFONO 2</td>
                                        <td><?php echo $fijo; ?></td>
                                    </tr>
                                    <tr>
                                        <td>ASIGNADO POR:</td>
                                        <td><?php echo $matriculagestormkt; ?></td>
                                    </tr>
                                    <tr>
                                        <td>ASIGNADO A:</td>
                                        <td><?php echo $matricula; ?></td>
                                    </tr>
                                    <tr>
                                        <td>CC:</td>
                                        <td><?php echo $CCOriginal; ?></td>
                                    </tr>
                                    
                                    <tr>
                                        <td>COMENTARIOS</td>
                                        <td>
                                            <textarea style="width: 100%" rows="6"><?php echo $comentariovisita; ?></textarea>
                                        </td>
                                    </tr>
                                    
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
                
                <!-- /.content -->
        </div>
        <!-- /.content-wrapper -->
           


            <div class="control-sidebar-bg"></div>
        </div>
        <!-- ./wrapper -->
        
        <!-- jQuery v1.11 -->
        <script src="admin/bower_components/jquery/dist/jquery_v1.11.js" type="text/javascript"></script>

        <!-- jQuery UI 1.11.4 -->
        <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
        <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
        <script>
        $.widget.bridge('uibutton', $.ui.button);</script>
        <!-- Bootstrap 3.3.7 -->
        <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
        <!-- Select2 -->
        <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
        <!-- Sparkline -->
        <script src="admin/bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>
       <!-- Slimscroll -->
        <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
        <!-- FastClick -->
        <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
        <!-- AdminLTE App -->
        <script src="admin/dist/js/adminlte.min.js"></script>
        <script src="admin/bower_components/ag-grid-master/dist/ag-grid.min.js" type="text/javascript"></script>
        <!-- InputMask -->
        <script src="admin/plugins/input-mask/jquery.inputmask.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.extensions.js"></script>
        <!-- BOOTSTRAP TOOGLE -->
        <script src="admin/plugins/bootstrap-toggle-master/js/bootstrap-toggle.min.js"></script>
        <!-- bootstrap datepicker -->
        <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
        <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>
        <!-- bootstrap time picker -->
        <script src="admin/plugins/timepicker/bootstrap-timepicker.min.js" type="text/javascript"></script>
        <script src="admin/bower_components/moment/min/moment.min.js"></script>
         <!-- Alertify -->
        <script src="admin/bower_components/alertifyjs/alertify.min.js" type="text/javascript"></script>
        <!-- Notificaciones -->
        <script src="js/notificaciones.js" type="text/javascript"></script>
        <!-- SWAL -->
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
        <!-- LEAFLET -->
        <script src="https://unpkg.com/leaflet@1.7.1/dist/leaflet.js" integrity="sha512-XQoYMqMTK8LvdxXYG3nZ448hOEQiglfqkJs1NOQV44cWnUrBc8PkAOcXy20w0vlaXaVUearIOBhiXZ5V3ynxwA==" crossorigin=""></script>
        <script src="lib/leaflet_AwesomeMarkers/dist/leaflet.awesome-markers.js"></script>
        <!-- AGGRID -->
        <script>
            var columnDefs = [
                    {headerName: 'FechaHoraREG', field: 'FechaHoraREG', width: 140},
                    {headerName: 'FechaInst', field: 'FechaInst', width: 130, pinned: 'left'},
                    {headerName: 'HoraInst', field: 'HoraInst', width: 105, pinned: 'left'},
                    {headerName: 'InstaladoX', field: 'InstaladoX', width: 100},
                    {headerName: 'MatriculaTec', field: 'MatriculaTec', width: 110},
                    {headerName: 'Repercusion', field: 'Repercusion', width: 130},
                    {headerName: 'MotivoInviable', field: 'MotivoInviable', width: 150},
                    {headerName: 'Comentario', field: 'Comentario', width: 200},
                    {headerName: 'EstadoVenta', field: 'EstadoVenta', width: 120},
                    {headerName: 'Gestor', field: 'GestorAgenda', width: 120}
                ];

            var gridOptions = {
                columnDefs: columnDefs,
                rowData: null,
                enableFilter: true,
                enableColResize: true,
                localeText: {
                    // for filter panel
                    page: 'página',
                    more: 'Más',
                    to: 'a',
                    of: 'de',
                    next: 'Siguiente',
                    last: 'Último',
                    first: 'Primero',
                    previous: 'Anterior',
                    loadingOoo: 'Cargando...',
                    // for set filter
                    selectAll: 'Seleccionar todo',
                    searchOoo: 'Buscando...',
                    blanks: 'Espacios en blanco',
                    // for number filter and text filter
                    filterOoo: 'Filtrar...',
                    applyFilter: 'Aplicar Filtro',
                    // for number filter
                    equals: 'Igual',
                    notEqual: 'No es igual',
                    lessThanOrEqual: 'Menor o igual',
                    greaterThanOrEqual: 'Mayor que o igual',
                    inRange: 'En el rango',
                    lessThan: 'Menos que',
                    greaterThan: 'Mas grande que',
                    // for text filter
                    contains: 'Contiene',
                    startsWith: 'Comienza con',
                    endsWith: 'Termina con',
                    notContains:'No contiene',
                    // the header of the default group column
                    group: 'Grupo',
                    // tool panel
                    columns: 'columnas',
                    rowGroupColumns: 'Grupo columnas',
                    rowGroupColumnsEmptyMessage: 'No hay resultado',
                    valueColumns: 'Columna de valor',
                    pivotMode: 'Modo pivote',
                    groups: 'grupos',
                    values: 'valor',
                    pivots: 'pivote',
                    valueColumnsEmptyMessage: 'No hay resultado',
                    pivotColumnsEmptyMessage: 'No hay resultado',
                    // other
                    noRowsToShow: '<div class="callout callout-danger">\n\
                                    <span class="pull-left">\n\
                                    <img src="admin/dist/img/noresults-img.png" style="width: 70%">\n\
                                    </span>\n\<h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>\n\
                                    <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>\n\
                                    <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>\n\
                                    <br></div>',
                    // enterprise menu
                    pinColumn: 'Aclar columna',
                    valueAggregation: 'Agregar valor',
                    autosizeThiscolumn: 'Auto tamaño esta columna ',
                    autosizeAllColumns: 'Auto tamaño todas columnas',
                    groupBy: 'Agrupar',
                    ungroupBy: 'Agrupar uno',
                    resetColumns: 'Restaurar Columnas',
                    expandAll: 'expandir todo',
                    collapseAll: 'desplegar todo',
                    toolPanel: 'Panel de Heramientas',
                    export: 'Exportar',
                    csvExport: 'Exportar CSV',
                    excelExport: 'Exportar Excel',
                    // enterprise menu pinning
                    pinLeft: 'Anclar a derecha',
                    pinRight: 'Anclar a izquierda',
                    noPin: 'Desanclar',
                    // enterprise menu aggregation and status panel
                    sum: 'Sumar',
                    min: 'Minimo',
                    max: 'Maximo',
                    first: 'Primero',
                            last: 'Ultimo',
                            none: 'Nada',
                    count: 'Contador',
                    average: 'Promedio',
                    // standard menu
                    copy: 'Copiar',
                    copyWithHeaders: 'Copiar Cabecera',
                    ctrlC: 'Ctrl+C',
                    paste: 'Pegar',
                    ctrlV: 'Ctrl+V'
                },
                enableSorting: true
            };

            function onFilterChanged(value) {
                gridOptions.api.setQuickFilter(value);
            }
            function listar() {
             var idventa='<?php echo $idventa; ?>';
                $.ajax({
                    url: 'ajax/findDataHisAgenda.php?idventa='+idventa,
                    success: function (data) {
        
                        if (data == 1) {
                            var gridDiv = document.querySelector('#myGrid');
                            new agGrid.Grid(gridDiv, gridOptions);
        
                            agGrid.simpleHttpRequest({url: 'ajax/selectListarHistAgenda.php?idventa='+idventa}).then(function (data) {
        
                                gridOptions.api.setRowData(data);
                            });
                            $('#vistaboy').height(function (index, height) {
        
                                return $(window).height() * 35 / 100;
                            });
                           
                        } else {
        
                            $("#ningunresultado").html(data);
        
                            var gridDiv = document.querySelector('#myGrid');
                            new agGrid.Grid(gridDiv, gridOptions);
        
                            agGrid.simpleHttpRequest({url: 'ajax/selectListarHistAgenda.php?idventa='+idventa}).then(function (data) {
        
                                gridOptions.api.setRowData(data);
                            });
                            $('#myGrid').hide("fast");
        
                        }
        
                    }
                });
            }
            
            var refresh = function () {
                var idventa='<?php echo $idventa; ?>';
                $.ajax({
                    url: 'ajax/findDataHisAgenda.php?idventa='+idventa,
                    success: function (data) {
                        if (data == 1) {
                            var gridDiv = document.querySelector('#myGrid');
                            agGrid.simpleHttpRequest({url: 'ajax/selectListarHistAgenda.php?idventa='+idventa}).then(function (data) {
                                gridOptions.api.setRowData(data);
                            });
                            $('#vistaboy').height(function (index, height) {
        
                                return $(window).height() * 35 / 100;
                            });
                            $("#ningunresultado").hide("fast");
                            $('#myGrid').show(200);
                        } else {
        
                            $("#ningunresultado").html(data);
                            $('#myGrid').hide("fast");
        
                        }
                    }   
                });
            }

            // setup the grid after the page has finished loading
            
        </script>

        <!-- ERROR DE GESTION -->
        <script>
            $('#errorGestion').on('click', async function(){
                const { value: formValues } = await Swal.fire({
                  title: 'Tipificar Error de Gestión',
                  html:
                    `<select style="width: 100%;" id="tipo_error" class="swal2-select">
                        <option value="" disabled selected>Colocar tipificación</option>
                        <option value='Segmento incorrecto'>Segmento incorrecto</option>
                        <option value='Sin rubro del negocio'>Sin rubro del negocio</option>
                        <option value='Error tipo residencial'>Error tipo residencial</option>
                        <option value='Error número de piso'>Error número de piso</option>
                        <option value='Origen incorrecto'>Origen incorrecto</option>
                        <option value='Grupo ACD erróneo '>Grupo ACD erróneo </option>
                        <option value='Fecha de visita incorrecta'>Fecha de visita incorrecta</option>
                        <option value='Acepta visita – menos 2 horas'>Acepta visita – menos 2 horas</option>
                        <option value='No acepta visita en Verismart'>No acepta visita en Verismart</option>
                        <option value='Horario incorrecto'>Horario incorrecto</option>
                        <option value='Fecha en obras'>Fecha en obras</option>
                        <option value='Nombre incompleto'>Nombre incompleto</option>
                        <option value='Visita sin scoring'>Visita sin scoring</option>
                        <option value='Orden de dirección'>Orden de dirección</option>
                        <option value='Dirección incompleta'>Dirección incompleta</option>
                        <option value='Dirección incorrecta'>Dirección incorrecta</option>
                        <option value='Zona restringida'>Zona restringida</option>
                        <option value='Distrito erróneo'>Distrito erróneo</option>
                        <option value='No ingresa tipo dirección'>No ingresa tipo dirección</option>
                        <option value='No ingresa número de dpto'>No ingresa número de dpto</option>
                        <option value='Referencias no exactas'>Referencias no exactas</option>
                        <option value='Geolocalización incorrecta'>Geolocalización incorrecta</option>
                        <option value='Teléfono erróneo'>Teléfono erróneo</option>
                        <option value='Comentarios incompletos'>Comentarios incompletos</option>
                        <option value='Datos no coincide'>Datos no coincide</option>
                        <option value='No acepta visita en Infopoint'>No acepta visita en Infopoint</option>
                        <option value='Error infopoint'>Error infopoint</option>
                        <option value='Error tipificación'>Error tipificación</option>
                        <option value='Otros'>Otros</option>
                    </select>`,
                  focusConfirm: false,
                  preConfirm: () => {
                      let tipoError = document.getElementById('tipo_error').value;
                        return [
                                  tipoError
                                ]
                  }
                })
                
                //console.log(formValues);
                
                if (formValues) {
                    
                    const arregloError = JSON.stringify(formValues);
                    //console.log(arregloError);
                    $('#lblErrorGestion').val(formValues[0]);
                    $('#lblcomentarioserrorgestion').prop('disabled', false);
                    Swal.fire('Error de Gestión seleccionado', '', 'success');
                }
            })
        </script>
        <!-- GRILLAS BUSCAR -->
        <script type="text/javascript">
            var columnDefsBUSCAR = [
                {headerName: 'ID', field: 'ID', width: 60},
                {headerName: 'FechaHoraREG', field: 'FechaHoraREG', width: 120},
                {headerName: 'Matricula', field: 'Matricula', width: 120},
                {headerName: 'Comercial', field: 'Comercial', width: 150},
                {headerName: 'CC', field: 'CC', width: 60},
                {headerName: 'NProspecto', field: 'NProspecto', width: 100},
                {headerName: 'TipoVenta', field: 'TipoVenta', width: 120},
                {headerName: 'Telefonouno', field: 'Telefonouno', width: 120},
                {headerName: 'Telefonodos', field: 'Telefonodos', width: 120},
                {headerName: 'OrigenVista', field: 'OrigenVista', width: 120}
            ];
            var gridOptionsBUSCAR = {
                    columnDefs: columnDefsBUSCAR,
                    onPaginationChanged: onPaginationChangedBUSCAR,
                    rowData: null,
                    enableFilter: true,
                    enableColResize: true,
                    localeText: {
                        // for filter panel
                        page: 'página',
                        more: 'Más',
                        to: 'a',
                        of: 'de',
                        next: 'Siguiente',
                        last: 'Último',
                        first: 'Primero',
                        previous: 'Anterior',
                        loadingOoo: 'Cargando...',
                        // for set filter
                        selectAll: 'Seleccionar todo',
                        searchOoo: 'Buscando...',
                        blanks: 'Espacios en blanco',
                        // for number filter and text filter
                        filterOoo: 'Filtrar...',
                        applyFilter: 'Aplicar Filtro',
                        // for number filter
                        equals: 'Igual',
                        notEqual: 'No es igual',
                        lessThanOrEqual: 'Menor o igual',
                        greaterThanOrEqual: 'Mayor que o igual',
                        inRange: 'En el rango',
                        lessThan: 'Menos que',
                        greaterThan: 'Mas grande que',
                        // for text filter
                        contains: 'Contiene',
                        startsWith: 'Comienza con',
                        endsWith: 'Termina con',
                        notContains:'No contiene',
                        // the header of the default group column
                        group: 'Grupo',
                        // tool panel
                        columns: 'columnas',
                        rowGroupColumns: 'Grupo columnas',
                        rowGroupColumnsEmptyMessage: 'No hay resultado',
                        valueColumns: 'Columna de valor',
                        pivotMode: 'Modo pivote',
                        groups: 'grupos',
                        values: 'valor',
                        pivots: 'pivote',
                        valueColumnsEmptyMessage: 'No hay resultado',
                        pivotColumnsEmptyMessage: 'No hay resultado',
                        // other
                        noRowsToShow: '<div class="callout callout-danger">\n\
                        <span class="pull-left">\n\
                        <img src="admin/dist/img/noresults-img.png" style="width: 70%">\n\
                        </span>\n\<h4><i class="fa fa-search"></i> ¡ADVERTENCIA!</h4>\n\
                        <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>\n\
                        <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>\n\
                        <br></div>',
                        // enterprise menu
                        pinColumn: 'Aclar columna',
                        valueAggregation: 'Agregar valor',
                        autosizeThiscolumn: 'Auto tamaño esta columna ',
                        autosizeAllColumns: 'Auto tamaño todas columnas',
                        groupBy: 'Agrupar',
                        ungroupBy: 'Agrupar uno',
                        resetColumns: 'Restaurar Columnas',
                        expandAll: 'expandir todo',
                        collapseAll: 'desplegar todo',
                        toolPanel: 'Panel de Heramientas',
                        export: 'Exportar',
                        csvExport: 'Exportar CSV',
                        excelExport: 'Exportar Excel',
                        // enterprise menu pinning
                        pinLeft: 'Anclar a derecha',
                        pinRight: 'Anclar a izquierda',
                        noPin: 'Desanclar',
                        // enterprise menu aggregation and status panel
                        sum: 'Sumar',
                        min: 'Minimo',
                        max: 'Maximo',
                        first: 'Primero',
                                last: 'Ultimo',
                                none: 'Nada',
                        count: 'Contador',
                        average: 'Promedio',
                        // standard menu
                        copy: 'Copiar',
                        copyWithHeaders: 'Copiar Cabecera',
                        ctrlC: 'Ctrl+C',
                        paste: 'Pegar',
                        ctrlV: 'Ctrl+V'
                    },
                    enableSorting: true,
                    onGridReady: function(params) {
                    var defaultSortModel = [
                            {colId: "Matricula", sort: "asc"}
                        ];
                    params.api.setSortModel(defaultSortModel);
                }
                };            

            function onPaginationChangedBUSCAR(params) {
               this.gridRowCount = params.api.paginationGetRowCount();
               $("#countBUSCAR").html(this.gridRowCount);
             }

             function onFilterChangedBUSCAR(value) {
                 gridOptions.api.setQuickFilter(value);
             }

             function listarBUSCAR() {
                 var numero='9';
               $.ajax({
                   url: 'ajax/findDataxNumero.php?numero=' + numero,
                   success: function (data) {
                       if (data == 1) {
                           var gridDiv = document.querySelector('#myGrid3');
                           new agGrid.Grid(gridDiv, gridOptionsBUSCAR);
                           agGrid.simpleHttpRequest({url: 'ajax/selectListarXNumero.php?numero='+numero}).then(function (datos) {
                              gridOptionsBUSCAR.api.setRowData(datos);
                           });
                           /*$('#vistaboy9').height(function (index, height) {
                               return $(window).height() * 35 / 100;
                           });*/
                       } else {
                           $("#ningunresultadoNumero").html(data);
                           var gridDiv = document.querySelector('#myGrid3');
                           new agGrid.Grid(gridDiv, gridOptionsBUSCAR);
                           agGrid.simpleHttpRequest({url: 'ajax/selectListarXNumero.php?numero=' + numero}).then(function (datos) {
                               gridOptionsBUSCAR.api.setRowData(datos);
                           });
                           $('#tot').hide("fast");
                           $('#myGrid3').hide("fast");
                       }
                   }
               });
               }

             var refreshBUSCAR = function () {
                 var numero=$("#lblmovil").val();
                 $.ajax({
                     url: 'ajax/findDataxNumero.php?numero=' + numero,
                     success: function (data) {
                         if (data == 1) {
                             var gridDiv = document.querySelector('#myGrid3');
                             agGrid.simpleHttpRequest({url: 'ajax/selectListarXNumero.php?numero=' + numero}).then(function (data) {
                                 gridOptionsBUSCAR.api.setRowData(data);
                             });
                             /*$('#vistaboy9').height(function (index, height) {
                                 return $(window).height() * 35 / 100;
                             });*/
                             $("#ningunresultadoNumero").hide("fast");
                             $("#btnsiguiente").show("fast");
                             $('#myGrid3').show(200);
                              $('#tot').show(200);
                         } else {
                             $('#ningunresultadoNumero').show(200);
                             $("#ningunresultadoNumero").html(data);
                             $("#btnsiguiente").show("fast");
                             $('#myGrid3').hide("fast");
                             $('#tot').hide("fast");
                         }
                     }
                 });
               }

                 // setup the grid after the page has finished loading
        </script>                 
        <!-- DOCUMENT READY --> 
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                
                localStorage.setItem('PosicionObjExacta', '{}');
                localStorage.setItem('PosicionObjAprox', '{}');
                
                marcarUbicacionMapa();
        
                listar();
                listarBUSCAR();
                
                asignarMicrozona();
                
                $('#cboGrupoACD').val($('#txtGrupoACD').val());
        
            });
        </script>
        <!-- EVENTOS -->
        <script>
            //MODIFICACION EMU 16.05    
            $('#FObras').bootstrapToggle({
                on:'SI',
                off:'NO',
                onstyle:'success',
                offstyle:'danger'
            });
            //MODIFICACION EMU 21.05
            $('#FObras').change(function(){
              if($(this).prop('checked')){
                 $('#ValFObras').val('SI');
                 $('#txtFVisitaReal').show();
                 $('#dpFVisitaReal').show();
                $('#txtFvisita').html("FECHA VISITA (OBRAS):");
                 $('#txtFVisitaReal').html("FECHA VISITA ORIGINAL:");
                 
              }else{
                $('#ValFObras').val('NO');
                 $('#txtFVisitaReal').hide();
                 $('#dpFVisitaReal').hide();
                 $('#txtFvisita').html("FECHA VISITA:");
                 $('#txtFVisitaReal').html("");
               }
               
            });
            
            $("#lbldc").change(function () {
                $("#lbldc option:selected").each(function () {
                    var lbldc = $(this).val();
                    $.post("./ajax/selectJefeVenta.php", { lbldc: lbldc }, function(data){
                        $("#lbljefeventa").html(data);
                    });
                    
                    $('#lblcctc').val(lbldc);
                });
            });
            
            $("#lblinstaladox").change(function () {
                $("#lblinstaladox option:selected").each(function () {
                    var lblinstaladox= $(this).val();
                    $.post("./ajax/selectTecnico.php", { lblinstaladox: lblinstaladox }, function(data){
                        $("#lbltecnico").html(data);
                    });            
                });
            });
   
            $('#checki').bootstrapToggle({
                on:'SI',
                off:'NO',
                onstyle:'success',
                offstyle:'danger'
            });

            $('#checki').change(function(){
              if($(this).prop('checked')){
                 $('#hidden_checki').val('SI');
              }else{
                $('#hidden_checki').val('NO');
               }
            });

            $("#lblestadoventa").change(function () {
                var condiciones = $("#lblestadoventa").val();
                bloquear(condiciones);
            });

            $("#lblcategoria").change(function () {
                var categoria = $("#lblcategoria").val();
                 $("#lblcat").val(categoria);
                bloquearxCategoria(categoria);
                    
            });

            $("#lblestadovisita").change(function () {
                var estadovisita = $("#lblestadovisita").val();
                $("#lblestvisita").val(estadovisita);
                    
                if(estadovisita =="AnuladaTEC"){
                    $("#lblestadoventa").val("AnuladaTEC");
                    $("#lblcat").val("Anulada");
                }
                if(estadovisita =="AnuladaOP"){
                    $("#lblestadoventa").val("AnuladaOP");
                    $("#lblcat").val("Anulada");
                }
                if(estadovisita =="AnuladaCLI"){
                    $("#lblestadoventa").val("AnuladaCLI");
                    $("#lblcat").val("Anulada");
                }
                if(estadovisita =="AnuladaporCruce"){
                    $("#lblestadoventa").val("AnuladaporCruce");
                    $("#lblcat").val("Anulada");
                }
                if(estadovisita =="AnuladaNoImputableOper"){
                    $("#lblestadoventa").val("AnuladaNoImputableOper");
                    $("#lblcat").val("Anulada");
                }
                if(estadovisita =="AnuladaTECAudio"){
                    $("#lblestadoventa").val("AnuladaTECAudio");
                    $("#lblcat").val("Anulada");
                }                
                if(estadovisita =="Asignada"){
                    $("#lblestadoventa").val("VAsignada");
                    $("#lblcat").val("VAsignada");
                }
                if(estadovisita =="NoVendida"){
                    $("#lblestadoventa").val("NoVendida");
                    $("#lblcat").val("NoVendida");
                }
                if(estadovisita =="PendienteValidarVnoV"){
                    $("#lblestadoventa").val("PendienteValidarVnoV");
                    $("#lblcat").val("VAsignada");
                }
                if(estadovisita =="AnuladaCC"){
                    $("#lblestadoventa").val("AnuladaCC");
                    $("#lblcat").val("Anulada");
                }
                
                /* ANULACIONES */
                if(estadovisita =="Asignada" || estadovisita =="AnuladaTEC" || estadovisita =="AnuladaOP" || estadovisita =="AnuladaCLI" || estadovisita =="AnuladaporCruce" || estadovisita =="AnuladaNoImputableOper" || estadovisita =="AnuladaTECAudio" || estadovisita =="AnuladaCC" || estadovisita =="NoVendida"){
                    $(".trAnulaciones").removeClass("ocultar");
                    $("#lblseanula").val("SI");
                    
                    if(estadovisita =="Asignada"){
                        $("#lblmotivoanulacion").val("Asignada");
                    } else if (estadovisita =="AnuladaTEC"){
                        $("#lblmotivoanulacion").val("Técnico");
                    } else if (estadovisita =="AnuladaOP"){
                        $("#lblmotivoanulacion").val("Operador");
                    } else if (estadovisita =="AnuladaCLI"){
                        $("#lblmotivoanulacion").val("Cliente");
                    } else if (estadovisita =="AnuladaporCruce"){
                        $("#lblmotivoanulacion").val("Cruce");
                    } else if (estadovisita =="AnuladaNoImputableOper"){
                        $("#lblmotivoanulacion").val("NoImputableOper");
                    } else if (estadovisita =="AnuladaTECAudio"){
                        $("#lblmotivoanulacion").val("TECAudio");                        
                    } else if (estadovisita =="AnuladaCC"){
                        $("#lblmotivoanulacion").val("AnuladaCC");
                    } else if (estadovisita == "PendienteValidarVnoV") {
                        $("#lblmotivoanulacion").val("PendienteValidarVnoV");
                    } else if (estadovisita == "NoVendida") {
                        $("#lblmotivoanulacion").val("NoVendida");
                    } else {
                        $("#lblmotivoanulacion").val("SI");
                    }
                } else {
                    $(".trAnulaciones").addClass("ocultar");
                    $("#lblseanula").val("NO");
                }
            });
   
            $('#lblmatricula').on('keyup', function () {
                var dato = $('#lblmatricula').val();
                var url = 'ajax/findMatricula.php';
                $.ajax({
                    type: 'POST',
                    url: url,
                    data: 'dato=' + dato,
                    success: function (datos) {
                        $('.mensajematricula').html(datos);
                    }
                });
                return false;
            });
               
            $("#lblmatricula").autocomplete({
                source: "./ajax/selectMatricula.php",
                minLength: 2,
                select: function (event, ui) {
                    event.preventDefault();
                    $('#lblidusuario').val(ui.item.idusuario);
                    $('#lblmatricula').val(ui.item.matricula);
                    $('#lblnombcomercial').val(ui.item.comercial);
                }
            });

            $("#lblmatricula").on("keydown", function (event) {
                if (event.keyCode == $.ui.keyCode.LEFT || event.keyCode == $.ui.keyCode.RIGHT || event.keyCode == $.ui.keyCode.UP || event.keyCode == $.ui.keyCode.DOWN || event.keyCode == $.ui.keyCode.DELETE || event.keyCode == $.ui.keyCode.BACKSPACE){
                    $('#lblidusuario').val("");
                    $('#lblmatricula').val("");
                    $('#lblnombcomercial').val("");
                }
                if (event.keyCode == $.ui.keyCode.DELETE) {
                    $('#lblmatricula').val("");
                    $('#lblidusuario').val("");
                    $('#lblnombcomercial').val("");
                }
            });
            
            $("#lbltipodoc").change(function () {
                var tipodoc = $("#lbltipodoc").val();
                if(tipodoc=="DNI"){
                   $('#lbldocumento').attr('maxlength', 8);
                }else if(tipodoc=="RUC"){
                   $('#lbldocumento').attr('maxlength', 11);
                }else{
                   $('#lbldocumento').attr('maxlength', 12);
                }
            });
            
            $('#lblsegmento').change(function(){
                if($('#lblsegmento').val() == 'NEG'){
                    $('.Lead__nlocales').removeClass('ocultar');
                    $('.Lead__tiposegmento').addClass('ocultar');
                    $("#lbltiposegmento").val("");
                } else{
                    $('.Lead__tiposegmento').removeClass('ocultar');
                    $('.Lead__nlocales').addClass('ocultar');
                }

            })
            $('#conSistema').change(function(){
                if($('#conSistema').val() == 'Si'){
                    $('.Lead__empresaAlarmas').removeClass('ocultar');
                } else{
                    $('.Lead__empresaAlarmas').addClass('ocultar');
                    $("#empresaSistema").val("");
                }
            })             
            
        </script>
        <!-- OTRAS EVENTOS -->
        <script>
            $(document).ready(function () {
                                                                                
                notificacion();
                                                                                
                bloquear('<?php echo $estadoventa; ?>');

                var alterClass = function () {
                    var ww = document.body.clientWidth;
                    if (ww < 767) {
                        $('body').removeClass('sidebar-collapse');
                    } else if (ww >= 768) {
                        $('body').addClass('sidebar-collapse');
                    }
                    ;
                };

                $(window).resize(function () {
                    alterClass();
                });
                //Fire it when the page first loads:
                alterClass();
                                                                                
                $('.selectdistrito').select2({
                    placeholder: 'Seleccione Distrito - Provincia',
                    allowClear: true,
                    language: {
                        errorLoading: function () {
                            return "La carga falló";
                        },
                        noResults: function () {
                            return "No hay resultado";
                        },
                        searching: function () {

                            return "Buscando..";
                        }
                    },
                    ajax: {
                        url: 'ajax/selectDistrito.php',
                        dataType: 'json',
                        delay: 250,
                        processResults: function (data) {
                            return {
                                results: data
                            };
                        },
                        cache: true
                    }
                });
                                                                                
                $('.cbxtecnico').select2({
                    placeholder: 'Seleccione',
                    allowClear: true,
                    language: {
                        errorLoading: function () {
                            return "La carga falló";
                        },
                        noResults: function () {
                            return "No hay resultado";
                        },
                        searching: function () {
    
                            return "Buscando..";
                        }
                    }
                });

                $('.selectgestor').select2({
                    placeholder: 'Seleccione Gestor',
                    allowClear: true,
                    language: {
                        errorLoading: function () {
                            return "La carga falló";
                        },
                        noResults: function () {
                            return "No hay resultado";
                        },
                        searching: function () {
    
                            return "Buscando..";
                        }
                    },
                    ajax: {
                        url: 'ajax/selectGestor.php',
                        dataType: 'json',
                        delay: 250,
                        processResults: function (data) {
                            return {
                                results: data
                            };
                        },
                        cache: true
                    }
                });

                $('.selecttipodireccion').select2({
                  placeholder: 'Seleccione Tipo Dirección',
                  selectOnClose: true,
                  minimumInputLength: 2,
                  language: {
                            errorLoading: function () {
                            return "La carga falló";
                        },
                        noResults: function () {
                            return "No hay resultado";
                        },
                        searching: function () {
                            return "Buscando..";
                        },
                        inputTooShort: function() {
                            return "Escribir minimo 2 caracteres";
                        }                    
                    },              
                })                
                

                $('#datemask').inputmask('dd/mm/yyyy', {'placeholder': 'dd/mm/yyyy'});
                                                               
                $('#lblfecharecpciondoc').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });
                
                $('#lblfechafacturacion').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });
                //Money Euro
                $('[data-mask]').inputmask();
                //Date picker
                $('#fechainst').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });
                //Date picker
                $('#horainst').timepicker({
                    defaultTime:false,                                                                                    
                    showInputs: true,
                    minuteStep: 1
                });
                $('#mesano').datepicker({
                    autoclose: true,
                    language: 'en',
                    firstDay: 1, format: 'M-yyyy',
                    viewMode: "years",
                    minViewMode: "months"
    
                });
                $('#lblmesvisit').datepicker({
                    autoclose: true,
                    language: 'en',
                    firstDay: 1, format: 'M-yyyy',
                    viewMode: "years",
                    minViewMode: "months",
                    orientation: 'bottom',
                    todayBtn: 'linked',
                    todayHighlight:true
                });

                $('#lblfvencimiento').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1,
                    format: 'dd/mm/yyyy'
                });

                $('#lblfvencimientob').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1,
                    format: 'dd/mm/yyyy',
                    startDate: '<?php echo $fvencimientovisita; ?>'
                }).on('changeDate', function (selected) {
                    var minDate = new Date(selected.date.valueOf()); // agregar 5 días 
                    $('#lblfvencimiento').datepicker('setStartDate', minDate); // bloquea de la fecha inicial
                    $('#lblfvencimiento').datepicker('setDate', minDate); // mostrar fecha
                });
            
                $('#lblfvisita').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                }).on('changeDate', function (selected) {
                    var minDate = new Date(selected.date.valueOf() + (1000 * 60 * 60 * 24 * 5)); // agregar 5 días 
                    $('#lblfvencimiento').datepicker('setStartDate', minDate); // bloquea de la fecha inicial
                    $('#lblfvencimiento').datepicker('setDate', minDate); // mostrar fecha
                    $('#lblfvencimientob').datepicker('setStartDate', minDate);
                    $('#lblfvencimientob').datepicker('setDate', minDate);
                });

                $('#lblhvisita').timepicker({
                    defaultTime:false,                                                                                    
                    showInputs: true,
                    minuteStep: 1
                });
                                                                              
                $('#lblFVisitaReal').datepicker({
                autoclose: true,
                language: 'es',
                firstDay: 1
                });

               $('#logcambios').click(function () {
                    refresh();
                });
            $('#lognumero').on("click", function () {
            
                var numero=$("#lblmovil").val();
                $("#spanNumero").text(numero);
                $('#modal-numero').modal('show');
                if(numero==""){
                    alertify.warning("Número Vacio");
                    $("#lblmovil").focus();
                } else {
                    refreshBUSCAR();
                }
            });                 
               
            var refreshBUSCAR = function () {
                 var numero=$("#lblmovil").val();
                 $.ajax({
                     url: 'ajax/findDataxNumero.php?numero=' + numero,
                     success: function (data) {
                         if (data == 1) {
                             var gridDiv = document.querySelector('#myGrid3');
                             agGrid.simpleHttpRequest({url: 'ajax/selectListarXNumero.php?numero=' + numero}).then(function (data) {
                                 gridOptionsBUSCAR.api.setRowData(data);
                             });
                             /*$('#vistaboy9').height(function (index, height) {
                                 return $(window).height() * 35 / 100;
                             });*/
                             $("#ningunresultadoNumero").hide("fast");
                             $("#btnsiguiente").show("fast");
                             $('#myGrid3').show(200);
                              $('#tot').show(200);
                         } else {
                             $('#ningunresultadoNumero').show(200);
                             $("#ningunresultadoNumero").html(data);
                             $("#btnsiguiente").show("fast");
                             $('#myGrid3').hide("fast");
                             $('#tot').hide("fast");
                         }
                     }
                 });
               }

                                                           
                $('#ModEnviar').on('click', function(){
                    //textbox = document.getElementById('textbox');
                    var idVen = '<?php echo $idventa; ?>';
                    var Nprospecto=$('#lblnprospecto').val();
    
                    //Algunas variables por default de alertify
                    alertify.defaults.theme.ok = "btn btn-nuevo";
                    alertify.defaults.theme.cancel = "btn btn-danger";
                    var lastX,lastY;
                    alertify.confirm('<span style="color:red"><i class="fa fa-warning"></i></span><strong> ADVERTENCIA</strong>', '¿Desea descargar el archivo de envio?', function(){
                            // Primero validará el formulario.
                            var datos = {idVen:idVen};
                            $.ajax({
                               type: 'POST',
                               url: 'ajax/correoenviovisita.php',
                               data: datos,
                               success: function (r) {
                                   
                                   var link = document.getElementById('downloadlink');
                                    link.href = makeTextFile(r);
                                    //link.style.display = 'block';
    
                                    download("correo_"+Nprospecto+".eml", makeTextFile(r));
    
                               }
                            });
                    }, function(){ alertify.error('Se ha cancelado el envio de correo')}).set({transition:'zoom','labels': {ok:'<i class="fa fa-check"></i> Aceptar', cancel:'<i class="fa fa-remove"></i> Cancelar'},'onshow':function(){
                        lastX = window.scrollX;
                        lastY = window.scrollY;
                    },
                    'onfocus':function(){
                        window.scrollTo(lastX, lastY);
                    }  }).show();
                })                                        
                                        
            });
                                                                            
            var  bloquear = function (condiciones){
                                                                           
                $('#tinviable').hide();
                $('#lblinviable').hide();
                $('#lblinviable').disabled=true;
                $('#tinviableespacio').hide();
                        
                $('#tcancelado').hide();
                $('#lblcancelado').hide();
                $('#lblcancelado').disabled=true;
                $('#tcanceladoespacio').hide();
                                                      
                if (condiciones == "Inviable") {
                    $('#tinviable').show();
                    $('#lblinviable').show();
                    $('#lblinviable').show();
                    $('#lblinviable').disabled=false;
                    $('#tinviableespacio').show();
                }else if(condiciones=="Cancelado"){
                    $('#tcancelado').show();
                    $('#lblcancelado').show();
                    $('#lblcancelado').disabled=false;
                    $('#tcanceladoespacio').show();
                } 
                else {
                    $('#tinviable').hide();
                    $('#lblinviable').hide();
                    $('#lblinviable').disabled=true;
                    $('#tinviableespacio').hide();
                    
                    $('#tcancelado').hide();
                    $('#lblcancelado').hide();
                    $('#lblcancelado').disabled=true;
                    $('#tcanceladoespacio').hide();
                   
                }
    
            }

        function validaForm() {
                
            if($("#frmEditarVenta #lblestadovisita").val() == "AnuladaCC"){
                return true;
            }    

            if ($("#frmEditarVenta #lblmatricula").val() == "") {
                alertify.warning("Por favor ingresar la Matricula correspondiente");
                $("#frmEditarVenta #lblmatricula").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                return false;
            }
            if ($("#frmEditarVenta #lblnombcomercial").val() == "") {
                alertify.warning("Por favor ingresar la Matricula valida");
                $("#frmEditarVenta #lblmatricula").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                return false;
            }
            if ($("#frmEditarVenta #lbldc").val() == "" || $("#frmEditarVenta #lbldc").val() == "Seleccione") {
                alertify.warning("Por favor ingresar CC correcto");
                $("#frmEditarVenta #lbldc").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                return false;
            }
            if ($("#frmEditarVenta #lbljefeventa").val() == "" || $("#frmEditarVenta #lbljefeventa").val() == "No se encontraron resultado") {
                alertify.warning("Por favor revisar Jefe de Estructura Comercial");
                $("#frmEditarVenta #lbljefeventa").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                return false;
            }
            if ($("#frmEditarVenta #lblestadovisita").val() == "Seleccione" || $("#frmEditarVenta #lblestadovisita").val() == "") {
                alertify.warning("Por favor ingresar Estado de Visita correcto");
                $("#frmEditarVenta #lblestadovisita").focus();
                return false;
            }
            if ($("#frmEditarVenta #lblestadoventa").val() == "Seleccione" || $("#frmEditarVenta #lblestadoventa").val() == "") {
                alertify.warning("Por favor ingresar Estado de Venta correcto");
                $("#frmEditarVenta #lblestadoventa").focus();
                return false;
            }
            if ($("#frmEditarVenta #lbltipoventa").val() == "Seleccione") {
                alertify.warning("Por favor ingresar Recurso correcto");
                $("#frmEditarVenta #lbltipoventa").focus();
                return false;
            }
            if ($("#frmEditarVenta #lblsegmento").val() == "Seleccione") {
                alertify.warning("Por favor ingresar Segmento correcto");
                $("#frmEditarVenta #lblsegmento").focus();
                return false;
            }

            if($("#frmEditarVenta #lblsegmento").val() == 'RES'){
                if($("#frmEditarVenta #lbltiposegmento").val() == '' || $("#frmEditarVenta #lbltiposegmento").val() == null || $("#frmEditarVenta #lbltiposegmento").val() == 'Seleccione'){
                    Swal.fire('Faltan datos', 'Por favor ingresar tipo residencial correcto', 'warning');
                    return false;
                    }

                if($("#frmEditarVenta #lblnpiso").val() == '' || $("#frmEditarVenta #lblnpiso").val() == null){
                    Swal.fire('Faltan datos', 'Por favor ingresar N°Piso correcto', 'warning');
                    return false;
                }                     
                    
            }
                
 
            
            
            if ($("#frmEditarVenta #lblnprospecto").val() == "") {
                alertify.warning("Por favor ingresar N° Prospecto");
                $("#frmEditarVenta #lblnprospecto").focus();
                return false;
            }
            if ($("#frmEditarVenta #lblfvencimiento").val() == "") {
                alertify.warning("Por favor ingresar Fecha de Vencimiento");
                $("#frmEditarVenta #lblfvencimiento").focus();
                return false;
            }
            if ($("#frmEditarVenta #lblorigen").val() == "") {
                alertify.warning("Por favor ingresar Origen");
                $("#frmEditarVenta #lblorigen").focus();
                return false;
            }
            if ($("#frmEditarVenta #lblfvisita").val() == "") {
                alertify.warning("Por favor ingresar Fecha de Visita");
                $("#frmEditarVenta #lblfvisita").focus();
                return false;
            }
            if ($("#frmEditarVenta #lblhvisita").val() == "") {
                alertify.warning("Por favor ingresar Hora de Visita");
                $("#frmEditarVenta #lblhvisita").focus();
                return false;
            }
            if ($("#frmEditarVenta #lblnombcliente").val() == "") {
                alertify.warning("Por favor ingresar Nombre del Cliente");
                $("#frmEditarVenta #lblnombcliente").focus();
                return false;
            }
            if ($("#frmEditarVenta #lblcorreo").val() == "" || !/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test($("#frmEditarVenta #lblcorreo").val())) {
                alertify.warning("Por favor ingresar correo válido");
                $("#frmEditarVenta #lblcorreo").focus();
                return false;
            }
            //NUEVA FUNCION SI SELECCIONA DNI/RUC
            if ($("#frmEditarVenta #lbltipodoc").val() == "") {
               alertify.warning("Por favor Seleccionar Tipo Documento");
               $("#frmEditarVenta #lbltipodoc").focus();
               return false;
            }
            if ($("#frmEditarVenta #lbldocumento").val() == "") {
               alertify.warning("Por favor ingresar Documento");
               $("#frmEditarVenta #lbldocumento").focus();
               return false;
            }    
            if ($("#frmEditarVenta #lbltipodoc").val() == "RUC") {
                if ($("#frmEditarVenta #lbldocumento").val().length!=11) {
                   alertify.warning("Por favor ingresar los 11 digitos del RUC");
                   $("#frmEditarVenta #lbldocumento").focus();
                   return false;
                }
                if ($("#frmEditarVenta #lbldocumento").val().substr(0,2)==10 || $("#frmEditarVenta #lbldocumento").val().substr(0,2)==20 || $("#frmEditarVenta #lbldocumento").val().substr(0,2)==15) {
                }else{
                    alertify.warning("Por favor ingresar correctamente el RUC debe comenzar 10 o 20");
                   $("#frmEditarVenta #lbldocumento").focus();
                   return false;
                }
            }
            if ($("#frmEditarVenta #lbltipodoc").val() == "DNI") {
                if ($("#frmEditarVenta #lbldocumento").val().length!=8) {
                   alertify.warning("Por favor ingresar los 8 digitos del DNI");
                   $("#frmEditarVenta #lbldocumento").focus();
                   return false;
                }
            }                        
            if ($("#frmEditarVenta #lbltipodoc").val() == "CE") {
                if ($("#frmEditarVenta #lbldocumento").val().length==0) {
                   alertify.warning("Por favor ingresar CE");
                   $("#frmEditarVenta #lbldocumento").focus();
                   return false;
                }
            }                                     
            if ($("#frmEditarVenta #lbldireccion").val() == "") {
                alertify.warning("Por favor ingresar la Direccion del Cliente");
                $("#frmEditarVenta #lbldireccion").focus();
                return false;
            }
            if ($("#frmEditarVenta #lblmesvisit").val() == "") {
                alertify.warning("Por favor ingresar Mes-Visita");
                $("#frmEditarVenta #lblmesvisit").focus();
                return false;
            }


            if ($("#frmEditarVenta #lblasignado").val() == "") {
                alertify.warning("Por favor ingresar Gestor correcto");

                $("#frmEditarVenta #lblasignado").select2('open');
                return false;
            }
            if ($("#frmEditarVenta #lbldistrito").val() == "") {
                alertify.warning("Por favor ingresar Distrito correcto");

                $("#frmEditarVenta #lbldistrito").select2('open');
                return false;
            }
            if ($("#frmEditarVenta #lblmovil").val() == "") {
                alertify.warning("Por favor ingresar Telefono, de caso contrario digite: 0");
                $("#frmEditarVenta #lblmovil").focus();
                return false;
            }
            if (!/^([0-9])*$/.test($("#frmEditarVenta #lblfijo").val()) ) {
                    alertify.warning("El valor de Teléfono Dos no es un número");
                    $("#frmEditarVenta #lblfijo").focus();
                    return false;
            }
            if ($("#frmEditarVenta #lblleadid").val() == "") {
                alertify.warning("Por favor ingresar Lead ID"); 
                $("#frmEditarVenta #lblleadid").focus();
                return false;
            }
            if ($("#frmEditarVenta #lblcomentariovisita").val() == "") {
                alertify.warning("Por favor ingresar Comentario de Visita");
                $("#frmEditarVenta #lblcomentariovisita").focus();
                return false;
            }
            /*if($("#frmEditarVenta #hidEstadoVisita").val() == "VGenerada"){
                if ($("#frmEditarVenta #lblcalificarGestion").val() == "") {
                    alertify.warning("Por favor calificar la visita");
                    return false;
                }
            }*/

            if ($("#frmEditarVenta #lblasignacion").val() == "") {
                alertify.warning("Por favor ingresar motivo asignacion");
                $("#frmEditarVenta #lblasignacion").focus();
                return false;
            }
            

            if ($("#frmEditarVenta #lblcontactoasignacion").val() == "") {
                alertify.warning("Por favor ingresar el contacto asignación"); 
                $("#frmEditarVenta #lblcontactoasignacion").focus();
                return false;
            }
            
            if ($("#frmEditarVenta #lblcumpleranking").val() == "") {
                alertify.warning("Por favor ingresar si cumple ranking"); 
                $("#frmEditarVenta #lblcumpleranking").focus();
                return false;
            }          
            
            if ($("#frmEditarVenta #lblErrorGestion").val() != "" && $("#frmEditarVenta #lblcomentarioserrorgestion").val() == "") {
                alertify.warning("Por favor ingresar comentarios de error de gestion"); 
                $("#frmEditarVenta #lblcomentarioserrorgestion").focus();
                return false;
            }
            
            return true; 
        }

            var calcDataTableHeight = function () {
                return $(window).height() * 65 / 100;
            };

            function filterFloat(evt, input) {
                // Backspace = 8, Enter = 13, ‘0′ = 48, ‘9′ = 57, ‘.’ = 46, ‘-’ = 43
                var key = window.Event ? evt.which : evt.keyCode;
                var chark = String.fromCharCode(key);
                var tempValue = input.value + chark;
                if (key >= 48 && key <= 57) {
                    if (filter(tempValue) === false) {
                        return false;
                    } else {
                        return true;
                    }
                } else {
                    if (key == 8 || key == 13 || key == 0) {
                        return true;
                    } else if (key == 46) {
                        if (filter(tempValue) === false) {
                            return false;
                        } else {
                            return true;
                        }
                    } else {
                        return false;
                    }
                }
            }

            function filter(__val__) {
            var preg = /^([0-9]+\.?[0-9]{0,2})$/;
            if (preg.test(__val__) === true) {
                return true;
            } else {
                return false;
            }
            
            }

        </script>
        <!-- BTN GUARDAR -->
        <script>
            $('#btnGuardarEditarVenta').click(async function () {
                    
                    const EstadoVisita = $('#hidEstadoVisita').val();
                    
                    if(EstadoVisita == 'VGenerada'){
                        console.log($('#lbldc').val());
                        if($('#lbldc').val() != '' ){
                            let validarDelegacion = await validarDelegacionZonificacion();
    
                            if(validarDelegacion == false){
                                return;
                            }
                        }
                        let headerMatriculaUsuario = $('#headerMatriculaUsuario').val();
                        
                        var catgventa=$('#lblcat').val();
                        var ediventa='<?php echo $idventa;?>';
                        //Algunas variables por default de alertify
                        alertify.defaults.theme.ok = "btn btn-nuevo";
                        alertify.defaults.theme.cancel = "btn btn-danger";
                        var lastX,lastY;
                        
                        var datos = $('#frmEditarVenta').serialize();
                        console.log(datos);
                        alertify.confirm('<span style="color:red"><i class="fa fa-warning"></i></span><strong> ADVERTENCIA</strong>', '¿Desea guardar los cambios que ha realizado?', function(){ if (validaForm()) {
                            // Primero validará el formulario.
                            
                            $.ajax({
                                type: 'POST',
                                url: 'ajax/updateAsignacionVisita.php',
                                data: "MatriculaUsuario="+headerMatriculaUsuario+"&lblcategoria=" + catgventa + "&lblidventa="+ediventa+"&" + datos,
                                dataType: 'Json',
                                success: function (data) {
                                    console.log(data);
                                    if(data.resultado == 'exito'){
                                        
                                        Swal.fire('Visita Asignada Correctamente', '', 'success');
                                        $('#hidEstadoVisita').val('Asignada');
                                        $('#lblestvisita').val('Asignada');
                                        
                                        enviarEncuesta();
                                    } else if(data.resultado == 'ExisteNProspecto'){
                                        Swal.fire('El NProspecto', '', 'success');
                                    }
                                }
                            });
                        } }
                        , function(){ alertify.error('No se han guardado los cambios')}).set({transition:'zoom','labels': {ok:'<i class="fa fa-check"></i> Aceptar', cancel:'<i class="fa fa-remove"></i> Cancelar'},'onshow':function(){
                            lastX = window.scrollX;
                            lastY = window.scrollY;
                        },
                            'onfocus':function(){
                            window.scrollTo(lastX, lastY);
                        }  }).show();
                  
                    } 
                    else {
                        //alert('NO HICE NADA');
                        //return;
                                                                                  
                        var catgventa=$('#lblcat').val();
                        var ediventa='<?php echo $idventa;?>';
                        //Algunas variables por default de alertify
                        alertify.defaults.theme.ok = "btn btn-nuevo";
                        alertify.defaults.theme.cancel = "btn btn-danger";
                        var lastX,lastY;
                            alertify.confirm('<span style="color:red"><i class="fa fa-warning"></i></span><strong> ADVERTENCIA</strong>', '¿Desea guardar los cambios que ha realizado?', function(){ if (validaForm()) {
                            // Primero validará el formulario.
                            var datos = $('#frmEditarVenta').serialize();
                            $.ajax({
                                type: 'POST',
                                url: 'ajax/updateVisita_v4.php',
                                data: "lblcategoria=" + catgventa + "&lblidventa="+ediventa+"&" + datos,
                                success: function (r) {
                                    if (r == 1) {
                                    enviarEncuesta();
                                    alertify.success("Modificado con exito");
                                    }else if(r==2){
                                        alertify.warning("Ya existe N° prospecto");
                                    }
                                    else if(r==20){
                                        alertify.error("Debe realizar una modificación");
                                    }
                                    else {
                                        alertify.error("Fallo el server, comuniquese con soporte");
                                       
                                    }
                                }
                            });
                        } }
                        , function(){ alertify.error('No se han guardado los cambios')}).set({transition:'zoom','labels': {ok:'<i class="fa fa-check"></i> Aceptar', cancel:'<i class="fa fa-remove"></i> Cancelar'},'onshow':function(){
                            lastX = window.scrollX;
                            lastY = window.scrollY;
                        },
                            'onfocus':function(){
                            window.scrollTo(lastX, lastY);
                        }  }).show();
                    
                    }
                });
                //END BTN GUARDAR VENTA  
        </script>
        <!-- SCRIPT DIRECCION -->
        <script>
            const url = "GFWIDGET-PE-v2/index.html";
            let validarObjGeofinder;
            let validarObjGeofinderDirAprox;
            
            $('#setDireccion').on('click', function(e){
                e.preventDefault();
                if ($('#lbldireccionAprox').val() === ''){
                    $('#mapgeofinder').modal('show');
                    buscarDireccionLocalStorage();
                } else {
                    
                    let tipoDireccion = $('#hidTipoDireccion').val();
                    
                    if(tipoDireccion === 'Exacta'){
                        
                        $('#mapgeofinder').modal('show');
                        
                        buscarDireccionLocalStorage();
                        
                    }
                    else if(tipoDireccion === 'Aproximada'){
                        $('#mapgeofinderDirAprox').modal('show');
                    }
                    else{
                        $('#mapgeofinder').modal('show');
                        buscarDireccionLocalStorage();
                    }
                }
            })
            
            //BOTON PARA ABRIR MODAL DE DIRECCIONES APROXIMADAS
            
            $("#mapgeofinderDirAprox").on('shown.bs.modal', function(){
                
                //$('#geofinderwidgetDirAprox').attr("src", $('#geofinderwidgetDirAprox').attr("src"));
                
                //$('.leaflet-popup-content').width('310');
                
                if(localStorage.getItem("ObjGeofinderDirAprox") === null){
                    $('#mapgeofinderDirAprox').modal('show');
                }
                
                clearInterval(validarObjGeofinder);
                validarObjGeofinderDirAprox = setInterval(() => {
                    if(localStorage.getItem("ObjGeofinderDirAprox") !== null){
                        const ObjGeofinderDirAprox = JSON.parse(localStorage.getItem("ObjGeofinderDirAprox"));
                        //LLENA EL INPUT ObjGeofinder con la información guardada
                        $('#objGeofinder').val(JSON.stringify(ObjGeofinderDirAprox));
                        //OBTENER SECCION DEL OBJETO GEOFINDER
                        let arregloZonas = ObjGeofinderDirAprox.zonas;
                        let microzona;
                        for (let objetoZona of arregloZonas){
                            if(objetoZona.tipo === "MICROZONA"){
                                microzona= objetoZona.valor;
                            }
                        }
                        if(microzona !== ''){
                            consultarZona(microzona);
                        }
                        //OBTIENE DIRECCION DEL CAMPO GEOFINDER Y LO LLENA EN EL INPUT
                        let direccionAprox = ObjGeofinderDirAprox.fulladdress;
                        //
                        $('#lbldireccionAprox').val(direccionAprox);
                        
                        //LIMPIA EL INTERVALO DE VALIDACION DE OBJGEOFINDER    
                        clearInterval(validarObjGeofinderDirAprox);

                        $("#setDireccionAprox").removeAttr("href");
                        
                        //ELIMINA EL LOCAL STORAGE
                        localStorage.removeItem("ObjGeofinderDirAprox");
                        
                        //OCULTAR EL MODAL
                         $('#mapgeofinderDirAprox').modal('hide');
                    } 
                }, 2000);
            });
            
            $("#mapgeofinderDirAprox").on('hidden.bs.modal', function(){
                clearInterval(validarObjGeofinder);
            })
            
            $('#mapgeofinder').on('hidden.bs.modal', function(){
                clearInterval(validarObjGeofinder);
            })
        </script>
        <!-- BTN DIRECCION MANUAL-->
        <script>
            $('#btnDireccionManual').click(function(){
                Swal.fire({
                    title: '¿Estás seguro?',
                    text: "La dirección se registrará manualmente",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Si, manual'
                }).then((result) => {
                    if (result.isConfirmed) {
                        Swal.fire({
                            title: 'Ingrese la dirección del cliente:',
                            input: 'text',
                            showCancelButton: true,
                            confirmButtonText: 'Confirmar',
                            preConfirm: (direccion) => {
                                $('#lbldireccion').val(direccion);
                                $('#mapgeofinder').modal('hide');
                            }
                        })
                    }
                } ) //END RESULT
            });//END FUNCTION
        </script>
        <!-- DESCARGAR ARCHIVO PARA ENVIO CORREO -->
        <script>
            var textFile = null,
            makeTextFile = function (text) {
              var data = new Blob([text], {type: 'text/plain'});
              if (textFile !== null) {
                window.URL.revokeObjectURL(textFile);
              }
              textFile = window.URL.createObjectURL(data);
              return textFile;
            };

            var create = document.getElementById('create'),
            textbox = document.getElementById('textbox');
            /*
              create.addEventListener('click', function () {

              }, false);
              */

              function download(nombre, url) {
                  var link= document.createElement('a');
                  link.setAttribute('href', url);
                  link.setAttribute('download', nombre);
                  link.click();
              }
        </script> 
        <!-- SCRIPT FUNCIONES DIRECCIONES NUEVA -->
        <script>
            function buscarDireccionLocalStorage(){
                if(localStorage.getItem("ObjGeofinder") === null){
                    $('#mapgeofinder').modal('show'); 
                } 
                    
                validarObjGeofinder = setInterval(() => {
                    
                    //VERIFICA QUE EL OBJGEOFINDER EXISTE EN EL LOCAL STORAGE
                    if(localStorage.getItem("ObjGeofinder") !== null){
                        const ObjGeofinder = JSON.parse(localStorage.getItem("ObjGeofinder"));
                        //MOSTRAR MENSAJE DE CON LOS DATOS DE LA SECCION UBICADA
                        //OBTENER SECCION DEL OBJETO GEOFINDER
                        let arregloZonas = ObjGeofinder.zonas;
                        let microzona;
                        for (let objetoZona of arregloZonas){
                            if(objetoZona.tipo === "MICROZONA"){
                                microzona= objetoZona.valor;
                            }
                        }
                        if(microzona !== ''){
                            consultarZona(microzona);
                        }
                        
                        //LLENA EL INPUT ObjGeofinder con la información guardada
                        $('#objGeofinder').val(JSON.stringify(ObjGeofinder));
                        //OBTIENE DIRECCION DEL CAMPO GEOFINDER Y LO LLENA EN EL INPUT
                        let direccion = ObjGeofinder.fulladdress;
                        $('#lbldireccionAprox').val(direccion);
                        
                        //LIMPIA EL INTERVALO DE VALIDACION DE OBJGEOFINDER    
                        clearInterval(validarObjGeofinder);

                        $("#setDireccion").removeAttr("href");
                        
                        //ELIMINA EL LOCAL STORAGE
                        localStorage.removeItem("ObjGeofinder");
                        
                        //LIMPIA EL 
                         $('#mapgeofinder').modal('hide');
                    } 
                }, 2000);
                
            }
            
            function marcarUbicacionMapa(){
                let objGeofinder = $('#objGeofinder').val();
                let lbltipoDireccion = $('#lbltipoDireccion').val();
                
                if(objGeofinder){
                    
                    if(lbltipoDireccion === 'Exacta'){
                        $('#geofinderwidget').attr("src", $('#geofinderwidget').attr("src"))
                        localStorage.setItem('PosicionObjExacta', objGeofinder);
                        localStorage.setItem('PosicionObjAprox', '{}');
                    } else {
                        $('#geofinderwidgetDirAprox').attr("src", $('#geofinderwidgetDirAprox').attr("src"))
                        localStorage.setItem('PosicionObjExacta', '{}');
                        localStorage.setItem('PosicionObjAprox', objGeofinder);
                    }
                }
            }
            
            const map = L.map('map')
            
            $('#modal-checkin').on('shown.bs.modal', function(){
                
                L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                    attribution: 'Map data &copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors, Imagery © <a href="https://www.mapbox.com/">Mapbox</a>'
                }).addTo(map);
                
                let objGeofinder = $('#objGeofinder').val();
                let objCheckIn = $('#info_checkin').val();
                
                if(objGeofinder !== ''){
                    objGeofinder= JSON.parse(objGeofinder);
                    //Datos de la direccion georeferenciada
                    
                    const latitudCliente = objGeofinder.y;
                    const longitudCliente = objGeofinder.x;
                    
                    map.setView(new L.LatLng(latitudCliente, longitudCliente), 14);
                    
                    L.marker([latitudCliente,longitudCliente], {icon: L.AwesomeMarkers.icon({icon: 'home', prefix: 'fa', markerColor: 'green'}) }).addTo(map)
                    .bindPopup('Ubicación de cliente.<br>')
                    .openPopup();
                } else {
                    map.setView(new L.LatLng(-77.0311, 77), 14);
                }
                
                if(objCheckIn !== ''){
                    objCheckIn= JSON.parse(objCheckIn);
                    
                    const latitudComercial = objCheckIn.Latitud;
                    const longitudComercial = objCheckIn.Longitud;
                    
                    //const latitudReubicacion = objCheckIn.latitudReubicacion;
                    //const longitudReubicacion = objCheckIn.longitudReubicacion;

                        L.marker([latitudComercial, longitudComercial], {icon: L.AwesomeMarkers.icon({icon: 'user', prefix: 'fa', markerColor: 'blue'})})
                            .addTo(map).bindPopup('Check-In Comercial')
                            .openPopup();
                    /*
                    if(latitudReubicacion != '' || longitudReubicacion!=''){
                        L.marker([latitudReubicacion, longitudReubicacion], {icon: L.AwesomeMarkers.icon({icon: 'home', prefix: 'fa', markerColor: 'black'})})
                            .addTo(map).bindPopup('Reubicación del cliente')
                            .openPopup();
                    }
                    */
                } else {
                    Swal.fire(
                      'Check-IN RE!',
                      'Pendiente enviar check-in por el especialista',
                      'warning'
                    )
                }
                    
                
            })
            
            $('#btnGuardarCheckIn').on('click', () => {
                $('#hidden_checki').val('SI');
                
                $('#checki').bootstrapToggle('on');
                $('#modal-checkin').modal('hide')

            })
            

        </script>
        <!-- SCRIPT DE ZONIFICACION -->
        <script>
            function asignarMicrozona(){
                if($('#objGeofinder').val() != ''){
                    const objGeofinder = JSON.parse($('#objGeofinder').val());
                    
                    let arregloZonas = objGeofinder.zonas;
                    let microzona;
                    for (let objetoZona of arregloZonas){
                        if(objetoZona.tipo === "MICROZONA"){
                            microzona= objetoZona.valor;
                        }
                    }
                    
                    if(microzona !== ''){
                        $('#microzona').val(microzona);
                   
                        consultarZonaCC(microzona);
                    }
                    
                    consultarZonaCC(microzona)
                }
            }
            
            function consultarZonaCC(microzona){
                
                microzona = convertirMicrozona(microzona);
                
                data = {microzona: microzona};
                
                fetch('ajax/findDataZonificacion.php', {method: 'POST', body: JSON.stringify(data)})
                .then(function(res) {
                    return res.json();
                })
                .then(function(datos) {
                    if(datos.resultado === "exito"){
                        
                        let datosZonficacion = datos.datos;
                        
                        //<p> <strong>Codigo Zonificacion:</strong> ${datosZonficacion.CodigoDelegacion} </p> 
                        //<p> <strong>Delegado:</strong> ${datosZonficacion.Delegado} (${datosZonficacion.MatriculaDelegado}) </p>
                        
                        $('#objZonificacionVerisure').val(JSON.stringify(datosZonficacion));
                        $('#idZonificacion').val(datosZonficacion.IdZonificacion);
                        $('#microzona').val(datosZonficacion.Microzona);
                        $('#lbldcobjzonificacion').val(datosZonficacion.CodigoDelegacion);
                    } 
                    /*
                    else {
                        Swal.fire(
                          'Error!',
                          'El prospecto no pudo ser zonificado, comuniquese con soporte',
                          'error'
                        )
                    }
                    */
                })
                .catch(function(error) {
                    console.log(error);
                })
            }

            
            function convertirMicrozona(microzona){
                let nuevaMicrozona = '';
                
                if(microzona.includes('-')){
                
                arraymicrozona = microzona.split("-");
                
                const ubigeo = arraymicrozona[0];
                
                let correlativo = '';
                
                //LISTA DE UBIGEOS CON 3 CARACTERES DE CORRELATIVOS
                
                const arregloUbigeos = ['150132',
                                        '150133',
                                        '130101',
                                        '130104',
                                        '130105',
                                        '130111',
                                        '130103',
                                        '130106',
                                        '130107',
                                        '130109',
                                        '130102',
                                        '200101',
                                        '200104',
                                        '200105',
                                        '200107',
                                        '200108',
                                        '200109',
                                        '200110',
                                        '200111',
                                        '200114',
                                        '200115',
                                        '040122',
                                        '040117',
                                        '040112',
                                        '040129',
                                        '040128',
                                        '040104',
                                        '040103',
                                        '040126',
                                        '040101',
                                        '040111',
                                        '040116',
                                        '040107',
                                        '040109',
                                        '040110',
                                        '040123',
                                        '040124',
                                        '040102',
                                        '040120',
                                        '040118',
                                        '040108',
                                        '040125',
                                        '040121',
                                        '040114',
                                        '040113',
                                        '040119',
                                        '040105',
                                        '040106'];

                if(arregloUbigeos.includes(ubigeo)){
                    
                    correlativo = arraymicrozona[1];
                    
                    if(ubigeo == '150132'){
                        if(correlativo == '0100' || correlativo == '0101' || correlativo == '0102'){
                            correlativo = correlativo.slice(1, 4)
                            nuevaMicrozona = `${ubigeo}${correlativo}`;
                        } else {
                            correlativo = correlativo.slice(2, 4);
                    
                            nuevaMicrozona = `${ubigeo}${correlativo}`;
                        }
                    } else {
                    
                        correlativo = correlativo.slice(1, 4)
                    
                        nuevaMicrozona = `${ubigeo}${correlativo}`;
                    }
                } else {
                    correlativo = arraymicrozona[1];
                    correlativo = correlativo.slice(2, 4);
                    
                    nuevaMicrozona = `${ubigeo}${correlativo}`;
                }
                
                } else {
                    nuevaMicrozona = microzona;
                }
                
                return nuevaMicrozona;
                
            }
            
    function consultarZona(microzona){
                
                console.log('MICROZONA');
                console.log(microzona);
                
                microzona = convertirMicrozona(microzona);
                console.log('CONVERTIDA MICROZONA');
                console.log(microzona);
                
                data = {microzona: microzona};
                
                
                fetch('ajax/findDataZonificacion.php', {method: 'POST', body: JSON.stringify(data)})
                .then(function(res) {
                    return res.json();
                })
                .then(function(datos) {
                    console.log(datos);
                    if(datos.resultado === "exito"){
                        
                        let datosZonficacion = datos.datos;
                        //zona LIM - 15, 155-JVD/ Delegacion Callao, Delegado Michael Castillo 
                        Swal.fire(
                          'Prospecto Zonificado',
                          ` <p> <strong>Zona:</strong> ${datosZonficacion.Zona}</p> 
                            
                            <p> <strong>Delegacion:</strong> ${datosZonficacion.NombreDelegacion} (${datosZonficacion.CodigoDelegacion}) </p> 
                            
                            <p> <strong>Delegado:</strong> ${datosZonficacion.Delegado} (${datosZonficacion.MatriculaDelegado}) </p>
                            
                          `,
                          'info'
                        )
                        
                        //
                        //
                        
                        $('#objZonificacionVerisure').val(JSON.stringify(datosZonficacion));
                        $('#idZonificacion').val(datosZonficacion.IdZonificacion);
                        $('#microzona').val(datosZonficacion.Microzona);
                        $('#lbldcobjzonificacion').val(datosZonficacion.CodigoDelegacion);
                    } 
                    /*
                    else {
                        Swal.fire(
                          'Error!',
                          'El prospecto no pudo ser zonificado, comuniquese con soporte',
                          'error'
                        )
                    }
                    */
                })
                .catch(function(error) {
                    Swal.fire(
                          'Error en la busqueda de microzona',
                          'Por favor, comunicarse con el área de desarrollo',
                          'error'
                        )
                })
            }
        
            $('#infoZonificacion').on('click', () => {
                let microzona = $('#microzona').val();
                
                console.log('INFO ZONIFICACION');
                console.log(microzona);
                
                if(microzona == ''){
                    
                    if($('#lbldireccionAprox').val() === ''){
                        Swal.fire(
                          'Alerta!',
                          'Debe buscar una dirección para obtener la información de zonificación',
                          'warning'
                        )
                    } else {
                        Swal.fire(
                          'Alerta!',
                          'La dirección no cuenta con información de zonificación.',
                          'warning'
                        )
                        $('#lbldcobjzonificacion').val('');
                    }
                    
                    
                } else {
                    
                    if($('#idZonificacion').val() == '' || $('#idZonificacion').val() == null){
                        Swal.fire(
                          'Alerta!',
                          'La dirección no cuenta con información de zonificación.',
                          'warning'
                        )
                    }
                    
                    consultarZona(microzona);
                }
                
            })
            
            async function validarDelegacionZonificacion(){
                //VALIDA SI EL CC DE ZONIFICACION ES DIFERENTE AL CC SELECCIONADO
                
                //if($("#lbldc").val() != '120' && $("#lbldc").val() != '200' && $("#lbldc").val() != '41' && $("#lbldc").val() != '40' && distritoIca()){
                // VALIDA SI EXISTE UN OBJETI DE ZONIFICACION
                if($('#lbldcobjzonificacion').val() != ''){
                    //VALIDA SI LA DC SELECCIONADA SE ENCUENTRA EN LA ZONIFICACION
                    if($("#lbldc").val() != '100' && $("#lbldc").val() != '140'){
                        if ($("#lbldc").val() !== $('#lbldcobjzonificacion').val()) {
                            if($('#lbltipoventa').val() === 'RE'){
                                let respuesta = await Swal.fire({
                                    title: 'Alerta!',
                                    text: "El CC no coincide con el resultado de Zonificacion",
                                    icon: 'warning',
                                    showCancelButton: true,
                                    confirmButtonColor: '#e4002b',
                                    cancelButtonColor: '#444444',
                                    input: 'text',
                                    confirmButtonText: 'Si, continuar!',
                                    preConfirm: (motivo) => {
                                        if (motivo !== '') {
                                            $('#txtMotivoDelegacion').val(motivo);
                                        } else {
                                            Swal.showValidationMessage('First input missing')   
                                        }
                                    }
                                }).then((result) => {
                                    let resultado;
                                    
                                    if (result.isConfirmed) {
                                         resultado = true;
                                    }
                                    else if(result.isDismissed){
                                         resultado = false;
                                    }
                                    
                                    return resultado;
                                })
                                
                                return respuesta;
                            }
                        }
                    }    
                }
                
            }
        </script>
        <!-- NUEVOS SCRIPT PARA EDITAR VISITA -->
        <script>
            $("#mapgeofinderDirAprox").on('hidden.bs.modal', function(){
                clearInterval(validarObjGeofinder);
                
                validarDireccion();
            })
            
            $('#mapgeofinder').on('hidden.bs.modal', function(){
            
                validarDireccion();
            })
            
            function validarDireccion(){
                
                Swal.fire({
                  title: '¿La dirección fue georeferenciada correctamente por CallCenter?',
                  showDenyButton: true,
                  showCancelButton: true,
                  confirmButtonText: `Si, correcta`,
                  denyButtonText: `No, tuve que corregirla`,
                  cancelButtonText: 'Sin Georeferenciar'
                }).then((result) => {
                  /* Read more about isConfirmed, isDenied below */
                    if (result.isConfirmed) {
                        $('#CalidadGeo').val('SI');
                        Swal.fire('Validada!', '', 'success');
                    } else if (result.isDenied) {
                        $('#CalidadGeo').val('NO');
                        Swal.fire('Corregida', '', 'info');
                    } else {
                        $('#CalidadGeo').val('SINGEO');
                    }
                })
            }
        </script>
        <!-- SCORING -->
        <script>
            
            $('#setAccion').on('click', function(e){
                e.preventDefault();
                
                if($('#lblaccion').val() == ''){
                    $('#modal-consultascoring').modal('show');
                } else {
                    Swal.fire({
                        title: '¿Quieres Scorear?',
                        text: "El prospecto ya cuenta con un score",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '##454141',
                        confirmButtonText: 'Si, Scorear'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                $('#modal-consultascoring').modal('show');
                            }
                    } ) //END RESULT
                }
            })
            
            $('#EquifaxDepartamental').change(() => {
                $("#EquifaxDepartamental option:selected").each(function () {
                    //Obtener valor del Departamento y asignarlo a la variable provincia (mala definicion de la funcion)
                    const Provincial = $(this).val();
                    //Genera un objeto provincia (departamento) para traer los datos de la provincia
                    const datos={
                        Provincial:Provincial
                    };
                    //Definir las variables del select de provincia y distrito. Se modifica a const por se constantes
                    const provincia= $("#EquifaxProvincial");
                    const distrito= $("#EquifaxDistrital");
                    //Ajax para traer los datos de la base de datos. //CONSULTAR PROVINCIA
                    $.ajax({
                        data:datos,
                        url:   './ajax/selectProvincial.php',
                        type:  'POST',
                        dataType: 'json',
                        success:  function (r) {
                            provincia.prop('disabled', false);
                            distrito.prop('disabled', false);
                            
                            // Limpiamos el select de Provincia
                            provincia.find('option').remove();
                            provincia.append('<option value="">Seleccione</option>');
                            // Limpiamos el select de Distrito
                            distrito.find('option').remove();
                            distrito.append('<option value="">Seleccione</option>');
                            
                            $(r).each(function(i, v){ // indice, valor
                                provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
                            })
                            
                            provincia.prop('disabled', false);
                            distrito.prop('disabled', false);
                        },
                        error: function()
                        {
                            //alert('Ocurrio un error en el servidor ..');
                            provincia.prop('disabled', false);
                            distrito.prop('disabled', false);
                        }
                    });
                })      
            })
            
            $("#EquifaxProvincial").change(function () {
                $("#EquifaxProvincial option:selected").each(function () {
                    var Provincial = $(this).val();
                    var datos={
                        Provincial:Provincial
                    };
                    var provincia= $("#EquifaxDistrital");
                     $.ajax({
                        data:datos,
                        url:   './ajax/selectDistrital.php',
                        type:  'POST',
                        dataType: 'json',
                        success:  function (r) {
                            provincia.prop('disabled', false);
                            
                            // Limpiamos el select
                            provincia.find('option').remove();
                            provincia.append('<option value="">Seleccione</option>');
                            
                            $(r).each(function(i, v){ // indice, valor
                                provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
                            })
                            
                            provincia.prop('disabled', false);
                        },
                        error: function(){
                            //alert('Ocurrio un error en el servidor ..');
                            provincia.find('option').remove();
                            provincia.append('<option value="">Seleccione</option>');
                            provincia.prop('disabled', false);
                        } //END ERROR
                    }); //END AJAX
                }); //END OPTION SELECTED
            });
            
            $("#modal-consultascoring" ).on('shown.bs.modal', function(){
                cargardepartamentoEquifax();
            });
            
            $('#btnScoring').on('click', function(){
                $('#btnScoring').prop('disabled', true);
                
                $('#divLoading').show();
                
                var matriculausuario=$('#matriculausuario').val(); 
                var nombreusuario=$('#nombreusuario').val();
                var TipoDocumento = $('#EquifaxTipoDocumento').val();
                var Documento = $('#EquifaxDocumento').val();
                var Departamental=$("#EquifaxDepartamental option:selected").text();
                var Provincial=$("#EquifaxProvincial option:selected").text();
                var Distrital=$("#EquifaxDistrital option:selected").text();
                var Ubigeo=$("#EquifaxDistrital").val();
                
                var datos = {
                    matriculausuario:matriculausuario,
                    nombreusuario:nombreusuario,
                    TipoDocumento: TipoDocumento,
                    Documento: Documento,
                    Departamental:Departamental,
                    Provincial:Provincial,
                    Distrital:Distrital,
                    Ubigeo:Ubigeo
                }
                
                if(validaFormEquifax(datos)){
                    
                    $.ajax({
                        type: "Post",
                        data: datos,
                        url: "ajax/funciones/soap2_pre.php",
                        dataType: "Json",
                        success: function (data){
                            
                            console.log(data);
                            
                            if (data.tipo == 'exito'){
                                
                                //AGREGA EL NDOCUMENTO AL INPUT
                                //$('#lbltipodoc').val($('#EquifaxTipoDocumento').val());
                                $('#lbldocumento').val($('#EquifaxDocumento').val());
                                //GENERAR RESULTADO PARA EL MODAL
                                $('#FechaConsulta').html(data.fecha);
                                //AGREGAR FECHA SCORING AL CAMPO FECHA ULTIMA CONSULTA
                                $('#fechaConsultaScoring').val(data.fecha);
                                //ARREGLO DE DATOS DEL RESULTADO
                                var resultado = data.datos;
                                //RESULTADO DE SCORING
                                var resultadooperacion=data.AccionMKT;
                                //var resultadooperacion=resultado.respuestaSVC11Type.GrupoCampos.Campo[1].Valor;
                                //PEGAR RESULTADO DE SCORING Y ID EN LOS CAMPOS
                                $('#lblaccion').val(resultadooperacion);
                                $('#lblIdConsultaScoring').val(data.id_scoring);
                                $('#lblFechaHoraReg').val(data.fecha);
                                $('#lblperfilscoring').val(data.PerfilScoring)
                                
                                $('.TextoAccion').html(resultadooperacion);
                                
                                if(resultadooperacion=="Generar Visita"){
                                    $('.bg-visita').show();
                                    $('.bg-televenta').hide();
                                    $('.bg-gestion').hide();
                                }else if(resultadooperacion=="Pasar a base de datos-48 horas" || resultadooperacion=="Pasar a Televenta"){
                                    $('.bg-visita').hide();
                                    $('.bg-televenta').show();
                                    $('.bg-gestion').hide();
                                }else{
                                    $('.bg-visita').hide();
                                    $('.bg-televenta').hide();
                                    $('.bg-gestion').show();
                                }
                                
                                $('#idscoring').val(data.id_scoring);
                                //$('#ResultadoOperacion').html(resultado.respuestaSVC11Type.GrupoCampos.Campo[1].Valor);
                               //$('#NOperacion').html(resultado.respuestaSVC11Type.Header.NumeroOperacion);
                                $('#Riesgo').html(resultado.respuestaSVC11Type.Scores.Score.Riesgo + ' Riesgo');
                                if (resultado.respuestaSVC11Type.Integrante.TipoDocumento == 1){
                                    $('#NombreCompleto').html(resultado.respuestaSVC11Type.Integrante.ApellidoPaterno +' '+resultado.respuestaSVC11Type.Integrante.ApellidoMaterno +' '+resultado.respuestaSVC11Type.Integrante.Nombres);
                                    $('#TDocumento').html("DNI:");
                                }
                                else if (resultado.respuestaSVC11Type.Integrante.TipoDocumento == 6){
                                    if(resultado.respuestaSVC11Type.Integrante.NumeroDocumento.substr(0,2)==10 || resultado.respuestaSVC11Type.Integrante.NumeroDocumento.substr(0,2)==15 || resultado.respuestaSVC11Type.Integrante.NumeroDocumento.substr(0,2)==17){
                                        $('#NombreCompleto').html(resultado.respuestaSVC11Type.Integrante.ApellidoPaterno +' '+resultado.respuestaSVC11Type.Integrante.ApellidoMaterno +' '+resultado.respuestaSVC11Type.Integrante.Nombres);
                                    }else{
                                        $('#NombreCompleto').html(resultado.respuestaSVC11Type.Integrante.RazonSocial);
                                    }
                                    $('#TDocumento').html("RUC:");
                                }else{
                                    $('#NombreCompleto').html(resultado.respuestaSVC11Type.Integrante.ApellidoPaterno +' '+resultado.respuestaSVC11Type.Integrante.ApellidoMaterno +' '+resultado.respuestaSVC11Type.Integrante.Nombres);
                                    $('#TDocumento').html("CE:");
                                }
            
                                $('#NumeroDocumento').html(resultado.respuestaSVC11Type.Integrante.NumeroDocumento);
            
                                $('#ValorScoring').html(resultado.respuestaSVC11Type.Scores.Score.Valor);
                                
                                if(resultadooperacion=="Pasar a base de datos-48 horas"){
                                      $('#lbltipotransf').val('BD48horas');
                                 }else{
                                      $('#lbltipotransf').val('');
                                  }
                                            
                                $('#divLoading').hide();

                                $('#ResultadoEquifax').show();
                                $('#EquifaxTipoDocumento').prop('disabled', true); 
                                $('#EquifaxDocumento').prop('disabled', true);
                                
                                $("#EquifaxDepartamental").prop('disabled', true); 
                                $("#EquifaxProvincial").prop('disabled', true); 
                                $("#EquifaxDistrital").prop('disabled', true);
                                //$('#btnScoring').hide();
                                //$('#btnScoring').prop('disabled', false);
                                $('#btnNuevaScoring').show();
                            } else {
                                $('#divLoading').hide();
                                alert(data.mensaje);
                                $('#btnScoring').show();
                                $('#btnScoring').prop('disabled', false);
                                $('#btnNuevaScoring').hide();
                            }
                        } //END SUCCESS
                    }) //END AJAX
                } else{
                    
                    $('#divLoading').hide();
                    $('#btnScoring').prop('disabled', false);
                }
                
            })
            
            $('#btnNuevaScoring').on('click',function(){
                    $('#ResultadoEquifax').hide();
                    $('#EquifaxTipoDocumento').prop('disabled', false); 
                    $('#EquifaxDocumento').prop('disabled', false);
                    
                    $("#EquifaxDepartamental").prop('disabled', false); 
                    $("#EquifaxProvincial").prop('disabled', false); 
                    $("#EquifaxDistrital").prop('disabled', false);
                    
                    $('#btnNuevaScoring').hide();
                    $('#btnScoring').show();
                    $('#btnScoring').prop('disabled', false);
                    
                    $('#idscoring').val("");
                    
                    $('#EquifaxTipoDocumento').val("1"); 
                    $('#EquifaxDocumento').val("");
                    
                    $("#EquifaxDepartamental").val("");
                    $("#EquifaxProvincial").find('option').remove();
                    $("#EquifaxProvincial").append('<option value="">Seleccione</option>');
                    $("#EquifaxDistrital").find('option').remove();
                    $("#EquifaxDistrital").append('<option value="">Seleccione</option>');
                    
                    cargardepartamentoEquifax();
                    
          });
            
            function cargardepartamentoEquifax(departamento, provincia, distrito){
                const EquifaxDepartamental = $('#EquifaxDepartamental');
                
                $.ajax({
                    url:   './ajax/selectDepartamental.php',
                    type:  'POST',
                    dataType: 'json',
                    success:  function (datos) {
                        //Departamento equifax
                        EquifaxDepartamental.find('option').remove();
                        EquifaxDepartamental.append('<option value="">Seleccione</option>');
                        //LLENAR LOS CAMPOS DEPARTAMENTO 
                        $(datos).each(function(i, v){ // indice, valor
                            if(v.id == departamento ){
                                EquifaxDepartamental.append('<option value="' + v.id + '">' + v.text + '</option>');
                            } else {
                                EquifaxDepartamental.append('<option value="' + v.id + '">' + v.text + '</option>');
                            }
                            
                            //Seleccionar al departamento de Lima si es un nuevo registro
                            if(departamento == '' || departamento == null){
                                $("#Departamental option[value='15']").attr("selected",true);
                            }
                            
                            $("#EquifaxDepartamental option[value='15']").attr("selected",true);
                        
                            $("#EquifaxDepartamental option:selected").each(function () {

                            const datos={
                                Provincial: $(this).val()
                            };
                            
                            const EquifaxProvincial= $("#EquifaxProvincial");
                            const EquifaxDistrital= $("#EquifaxDistrital");
                            
                            $.ajax({
                                data:datos,
                                url:   './ajax/selectProvincial.php',
                                type:  'POST',
                                dataType: 'json',
                                success:  function (data) {
                                    // Limpiamos el select de Provincia
                                    EquifaxProvincial.find('option').remove();
                                    EquifaxProvincial.append('<option value="">Seleccione</option>');
                                    // Limpiamos el select de Distrito
                                    EquifaxDistrital.find('option').remove();
                                    EquifaxDistrital.append('<option value="">Seleccione</option>');
                                    
                                    $(data).each(function(i, v){ // indice, valor
                                        EquifaxProvincial.append('<option value="' + v.id + '">' + v.text + '</option>');
                                    })
                                    
                                    $("#EquifaxProvincial option[value='128']").attr("selected",true);
                                    
                                    $("#EquifaxProvincial option:selected").each(function () {
                                        
                                        const datos={
                                            Provincial: $(this).val()
                                        };
                                    
                                        $.ajax({
                                            data:datos,
                                            url:   './ajax/selectDistrital.php',
                                            type:  'POST',
                                            dataType: 'json',
                                            success:  function (data) {
                                                // Limpiamos el select
                                                EquifaxDistrital.find('option').remove();
                                                EquifaxDistrital.append('<option value="">Seleccione</option>');
                                                
                                                $(data).each(function(i, v){ // indice, valor
                                                    EquifaxDistrital.append('<option value="' + v.id + '">' + v.text + '</option>');
                                                })
                                                EquifaxDistrital.trigger('change');
                                                
                                                EquifaxDistrital.prop('disabled', false);
                                            }
                                        });

                                    });
                            
                                }
                            });

                        });
                        })
                    }
                })
            }
            
            function validaFormEquifax(datos){
                const {TipoDocumento, Documento, Departamental, Provincial, Distrital} = datos;
                
                if (TipoDocumento == "") {
                    alertify.warning("Por favor ingresar Tipo de Documento");
                    return false;
                }
                
                if (Documento == "") {
                   alertify.warning("Por favor ingresar Número de Documento");
                   return false;
                }
                
                if (TipoDocumento == "6") {
                    if (Documento.length!=11) {
                       alertify.warning("Por favor ingresar los 11 digitos del RUC");
                       $("#EquifaxDocumento").focus();
                       return false;
                    }
                    
                    if (Documento.substr(0,2)==10 || Documento.substr(0,2)==20 || Documento.substr(0,2)==15 || Documento.substr(0,2)==17) {
                              
                    }else{
                        alertify.warning("Por favor ingresar correctamente el RUC debe comenzar 10 o 20");
                        $("#EquifaxDocumento").focus();
                        return false;
                    }
                }
                
                if (TipoDocumento == "1") {
                    if (Documento.length!=8) {
                        alertify.warning("Por favor ingresar los 8 digitos del DNI");
                        $("#EquifaxDocumento").focus();
                        return false;
                    }
                }
                
                if (TipoDocumento == "3") {
                    if (Documento.length==0) {
                       alertify.warning("Por favor ingresar CE");
                       $("#EquifaxDocumento").focus();
                       return false;
                    }
                }
                
                if (Departamental == "") {
                    alertify.warning("Por favor ingresar Departamento correspondiente");
                    $("#EquifaxDepartamental").focus();
                    return false;
                }
                if (Provincial == "") {
                    alertify.warning("Por favor ingresar Pronvincia correspondiente");
                    $("#EquifaxProvincial").focus();
                    return false;
                }
                if (Distrital == "") {
                    alertify.warning("Por favor ingresar Distrito correspondiente");
                    $("#EquifaxDistrital").focus();
                    return false;
                }
                
                return true;
            }
        </script>
        <!-- RESUMEN VISITA -->
        <script>
            $('#btnResumenVisita').on('click', function(){
                $('#modal-resumenVisita').modal('show');
            })
        </script>
        <!-- CALIFICACION -->
        <script>
            $('#calificarVisita').on('click', async function(){
                const { value: formValues } = await Swal.fire({
                  title: 'Calificación de la Visita',
                  html:
                    `<select style="width: 100%;" id="califacion" class="swal2-select">
                        <option value="" disabled selected>Calificar Visita</option>
                        <option value="bueno">Bueno</option>
                        <option value="malo">Malo</option>
                    </select>
                    <select style="width: 100%;" id="cantidadErrores" class="swal2-select">
                        <option value="" disabled selected>Cantidad errores</option>
                        <option value="1">1</option>
                        <option value="2 a 3">2 a 3</option>
                        <option value="4 a más">4 a más</option>
                    </select>
                    <textarea class="swal2-textarea" style="width: 100%;" id="calificacion-observaciones" rows="3" placeholder="Indicar observaciones"></textarea>`,
                  focusConfirm: false,
                  preConfirm: () => {
                      let califacion=document.getElementById('califacion').value;
                      let cantidadErrores=document.getElementById('cantidadErrores').value;
                      let calificacion_observaciones=document.getElementById('calificacion-observaciones').value;
                        return [
                                  califacion,
                                  cantidadErrores,
                                  calificacion_observaciones
                                ]
                  }
                })
                
                console.log(formValues);
                
                if (formValues) {
                    
                    const arregloCalificacion = JSON.stringify(formValues);
                    console.log(arregloCalificacion);
                    $('#lblcalificarGestion').val(arregloCalificacion);
                    Swal.fire('Calificada', '', 'success');
                }
            })
        </script>
        <!-- SCRIPT DE QSERVUS -->
        <script>
            function enviarEncuesta(){
                let lblcorreo = $('#lblcorreo').val();
                let lblnombcliente = $('#lblnombcliente').val();
                let fechaGestion = moment().format('DD-MM-YYYY');
                console.log(fechaGestion);
                let lblmatricula = $('#lblasignado').val();
                console.log($('#lblfvisita').val());
                let lblfvisita = moment($('#lblfvisita').val(), 'DD/MM/YYYY').format('DD-MM-YYYY');
                console.log(lblfvisita);
                let lblorigen = $('#lblorigen').val();
                let lblsegmento = $('#lblsegmento').val();
                let lbldistrito = $('#lbldistrito option:selected').text();
                console.log(lbldistrito);
                let arraylbldistrito = lbldistrito.split(" - ");
                
                let distrito = arraylbldistrito[0];
                let provincia = arraylbldistrito[1];
                
                console.log(distrito);
                
                data =  {
                  "campaign_id": 309690,
                  "survey_id": 336615,
                  "respondent_email": lblcorreo,
                  "respondent_name": lblnombcliente,
                  "respondent_phone": "",
                  "respondent_expiration_days": 10,
                  "fecha_de gestion": fechaGestion,
                  "matricula_operador": lblmatricula,
                  "fecha_de_visita": lblfvisita,
                  "origen": lblorigen,
                  "segmento": lblsegmento,
                  "city": distrito,
                  "state_description": provincia,
                  "apellido": lblnombcliente
                }
                
                console.log(data);

                fetch('https://qservus.redcalidad.com/api/addrespondent/', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'Authorization': 'Token 69091bedd687e3b2da71f0d804df3853242a493c'
                        },
                        body: JSON.stringify(data),
                    })
                    .then(response => response.json())
                    .then(data => {
                      console.log('Success:', data);
                    })
                    .catch((error) => {
                      console.error('Error:', error);
                    });
        
            }
        </script>
    </body>
</html>