<?php
header("Content-Type: text/html;charset=utf-8");
session_start();
if (!isset($_SESSION['user_login_status'])) {
    header("location: ./login/index.php");
    exit;
}

if ($_SESSION['mktclivtacerti'] == 1 || $_SESSION['matriculausuario'] == "Q26482" || $_SESSION['matriculausuario'] == "PC9691" || $_SESSION['matriculausuario'] == "Q30623" || $_SESSION['matriculausuario'] == "Q62590") {
} else {
    header("location: ./denegado.php");
    exit;
}


date_default_timezone_set('America/Lima');
function myUrlEncode($string)
{
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

include 'config/db.php';
include 'config/conexion.php';
require (__DIR__) . '/helper/helper_validacion.php';

$rc = NULL;

if (isset($_GET['rc'])) {

    $rc = sanitizaCampo($_GET['rc'], 'sanitizestring|scapestring|htmlspecialchars', $con);
    $rc = htmlspecialchars($rc);
}

if (isset($_GET['idventa'])) {

    $idventa = sanitizaCampo($_GET['idventa'], 'sanitizeint|scapestring|htmlspecialchars', $con);
    $idventa = htmlspecialchars($idventa);
}

$fechames = date("M-Y");

$sql_venta = $con->prepare("SELECT 
    u.IdUsuario,
    v.Matricula,
    v.Comercial,
    v.CC,
    v.JefeVenta,
    CONCAT(m.Nombres,' ',m.Apellidos) NombJefeVenta,
    v.EstadoVenta,
    v.CategoriaVenta,
    v.TipoVenta,
    v.Segmento,
    v.MesesAutorizado,
    v.NProspecto,
    v.NContrato,
    v.IdCliente,
    c.NombApellido Cliente,
    c.Correo,
    c.Telefonouno,
    c.Telefonodos,
    c.Direccion,
    g.IdGeografico,
    g.Distrito,
    g.Provincia,
    v.PrecioKit,
    v.TotalExtra,
    v.ResumenVenta,
    v.ExtraAutorizado,
    v.FormaPago,
    v.N590,
    v.PAI,
    v.EstadoVisita,
    v.CCOriginal,
    v.HojaCertificacion,
    v.CertificadoValidado,
    agen.IdAgenda,
    agen.InstaladoX,
    agen.MatriculaTec,
    CONCAT(t.Nombres,' ',t.Apellidos) Instalador,
t.LN LNInstalador,
    DATE_FORMAT(agen.FechaInst, '%d/%m/%Y') FechaInst, 
    TIME_FORMAT(agen.HoraInst,'%r') HoraInst,
    agen.Comentario,
    agen.MotivoInviable,
    agen.MotivoCancelada,
    agen.Repercusion,
    f.MotivoIncidencia,
    DATE_FORMAT(f.FechaRecepcionDOC, '%d/%m/%Y') FechaRecepcionDOC,
    DATE_FORMAT(f.FechaFacturacion, '%d/%m/%Y') FechaFacturacion,
    f.DOCOriginal,
    f.Segmentacion,
    f.Pago,
    f.Autoriza,
    f.DNI,
    f.ElementosCTOPS,
    f.DOCPAI,
    f.FaltaDOC,
    f.RehacerCTO,
    f.Afiliacion,
    f.Prospecto_NroGuia,
    f.FueraHora,
    v.GestorCertVenta,
    CONCAT(cer.Nombres,' ',cer.Apellidos) NombGestorCertVenta,
    v.FechaApertura,
    v.IdCertVenta,
    DATE_FORMAT(vtacert.FechaCierre,'%d/%m/%Y') FechaCierre,
    vtacert.TipoCierre,
    vtacert.MotivoIncidencia as MotivoIncidenciaCert,
    vtacert.SolucionIncidencia,
    vtacert.IncidenciaTecnica,
    vtacert.FormaPago as FormaPagoCert,
    vtacert.Comentario as ComentarioCert,
    v.TCGestor,
    CONCAT(ut.Nombres, ' ', ut.Apellidos) GestorTCTV,
    ut.Manager as JefeTCTV,
    vtacert.kitnoinstalado,
    DATE_FORMAT(vtacert.fechacorrecion_kitnoinstalado,'%d/%m/%Y') fechacorrecion_kitnoinstalado,
    vtacert.errorcomprobantepago,
    DATE_FORMAT(vtacert.fechacorrecion_errorcomprobantepago,'%d/%m/%Y') fechacorrecion_errorcomprobantepago,
    vtacert.errorsegmento,
    DATE_FORMAT(vtacert.fechacorrecion_errorsegmento,'%d/%m/%Y') fechacorrecion_errorsegmento,
    vtacert.fueranomalcomercial,
    DATE_FORMAT(vtacert.fechacorrecion_fueranomalcomercial,'%d/%m/%Y') fechacorrecion_fueranomalcomercial,
    vtacert.fueranormativatecnica,
    DATE_FORMAT(vtacert.fechacorrecion_fueranormativatecnica,'%d/%m/%Y') fechacorrecion_fueranormativatecnica,
    vtacert.incidenciadatos,
    DATE_FORMAT(vtacert.fechacorrecion_incidenciadatos,'%d/%m/%Y') fechacorrecion_incidenciadatos,
    vtacert.inconformidadfuncionamiento,
    DATE_FORMAT(vtacert.fechacorrecion_inconformidadfuncionamiento,'%d/%m/%Y') fechacorrecion_inconformidadfuncionamiento,
    vtacert.inconformidadpagoinicial,
    DATE_FORMAT(vtacert.fechacorrecion_inconformidadpagoinicial,'%d/%m/%Y') fechacorrecion_inconformidadpagoinicial,
    vtacert.inconformidadpagomensual,
    DATE_FORMAT(vtacert.fechacorrecion_inconformidadpagomensual,'%d/%m/%Y') fechacorrecion_inconformidadpagomensual,
    vtacert.inconformidadtiempopermanencia,
    DATE_FORMAT(vtacert.fechacorrecion_inconformidadtiempopermanencia,'%d/%m/%Y') fechacorrecion_inconformidadtiempopermanencia,
    vtacert.inconformidadubicaciondispositivos,
    DATE_FORMAT(vtacert.fechacorrecion_inconformidadubicaciondispositivos,'%d/%m/%Y') fechacorrecion_inconformidadubicaciondispositivos,
    vtacert.noconcefuncionamiento,
    DATE_FORMAT(vtacert.fechacorrecion_noconcefuncionamiento,'%d/%m/%Y') fechacorrecion_noconcefuncionamiento,
    vtacert.notienecontrato,
    DATE_FORMAT(vtacert.fechacorrecion_notienecontrato,'%d/%m/%Y') fechacorrecion_notienecontrato,
    vtacert.promesaspendientes,
    DATE_FORMAT(vtacert.fechacorrecion_promesaspendientes,'%d/%m/%Y') fechacorrecion_promesaspendientes,
    vtacert.reclamocomercial,
    DATE_FORMAT(vtacert.fechacorrecion_reclamocomercial,'%d/%m/%Y') fechacorrecion_reclamocomercial,
    vtacert.solicitabaja,
    DATE_FORMAT(vtacert.fechacorrecion_solicitabaja,'%d/%m/%Y') fechacorrecion_solicitabaja,
    vtacert.tarjetaafiliadanopertenecetitular,
    DATE_FORMAT(vtacert.fechacorrecion_tarjetaafiliadanopertenecetitular,'%d/%m/%Y') fechacorrecion_tarjetaafiliadanopertenecetitular,
    vtacert.recepmanual,
    DATE_FORMAT(vtacert.fechacorrecion_recepmanual,'%d/%m/%Y') fechacorrecion_recepmanual,
    vtacert.descargaapp,
    DATE_FORMAT(vtacert.fechacorrecion_descargaapp,'%d/%m/%Y') fechacorrecion_descargaapp,
    vtacert.capacitado,
    DATE_FORMAT(vtacert.fechacorrecion_capacitado,'%d/%m/%Y') fechacorrecion_capacitado,
    vtacert.numerollamadas,
    vtacert.FechaPendiente,
    vtacert.FechaPrimeraGestion,
    vtacert.FechaFinalizadoconIncidencia,
    vtacert.FechaResuelto,
    vtacert.ComentarioComercial,
    vtacert.RespComercial,
    vtacert.nuevohorarioSugerido,
    vtacert.FechaUltimaGestion,
    gt.EstadoLlamada,
    gt.Comentario as ComentarioGestion,
    gt.FechaHoraProgramacion,
    vtacert.Tipogenero,
    DATE_FORMAT(vtacert.FechaNacimiento,'%d/%m/%Y') FechaNacimiento,
    vtacert.jsonIncidencias
FROM yifi58ge_dbVENTAS.tblventa v 
INNER JOIN yifi58ge_dbUSUARIO.tblusuario u on v.IdUsuario=u.IdUsuario 
INNER JOIN yifi58ge_dbUSUARIO.tblarea a on a.IdArea=u.IdArea 
INNER JOIN yifi58ge_dbUSUARIO.tblusuario m on m.Matricula=u.Manager
INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente
INNER JOIN yifi58ge_dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
INNER JOIN yifi58ge_dbVENTAS.tblagenda agen on agen.IdVenta=v.IdVenta
INNER JOIN yifi58ge_dbVENTAS.tblfacturacion f on f.IdVenta=v.IdVenta
LEFT JOIN yifi58ge_dbUSUARIO.tblusuario t on t.Matricula=agen.MatriculaTec
LEFT JOIN yifi58ge_dbUSUARIO.tblusuario cer on cer.Matricula=v.GestorCertVenta
LEFT JOIN yifi58ge_dbVENTAS.tblcertificacionventa vtacert on vtacert.IdCertVenta=v.IdCertVenta
LEFT JOIN yifi58ge_dbUSUARIO.tblusuario ut on v.TCGestor=ut.Matricula
LEFT JOIN yifi58ge_dbVENTAS.tblgestioncertificacionventa gt on gt.IdGestionCert=vtacert.IdGestionCert
WHERE v.IdVenta=?");
$sql_venta->bind_param('i', $idventa);
$sql_venta->execute();
$sql_venta->store_result();
$sql_venta->bind_result(
    $IdUsuarioRow,
    $MatriculaRow,
    $ComercialRow,
    $CCRow,
    $JefeVentaRow,
    $NombJefeVentaRow,
    $EstadoVentaRow,
    $CategoriaVentaRow,
    $TipoVentaRow,
    $SegmentoRow,
    $MesesAutorizadoRow,
    $NProspectoRow,
    $NContratoRow,
    $IdClienteRow,
    $ClienteRow,
    $CorreoRow,
    $TelefonounoRow,
    $TelefonodosRow,
    $DireccionRow,
    $IdGeograficoRow,
    $DistritoRow,
    $ProvinciaRow,
    $PrecioKitRow,
    $TotalExtraRow,
    $ResumenVentaRow,
    $ExtraAutorizadoRow,
    $FormaPagoRow,
    $N590Row,
    $PAIRow,
    $EstadoVisitaRow,
    $CCOriginalRow,
    $HojaCertificacionRow,
    $CertificadoValidadoRow,
    $IdAgendaRow,
    $InstaladoXRow,
    $MatriculaTecRow,
    $InstaladorRow,
    $LNInstaladorRow,
    $FechaInstRow,
    $HoraInstRow,
    $ComentarioRow,
    $MotivoInviableRow,
    $MotivoCanceladaRow,
    $RepercusionRow,
    $MotivoIncidenciaRow,
    $FechaRecepcionDOCRow,
    $FechaFacturacionRow,
    $DOCOriginalRow,
    $SegmentacionRow,
    $PagoRow,
    $AutorizaRow,
    $DNIRow,
    $ElementosCTOPSRow,
    $DOCPAIRow,
    $FaltaDOCRow,
    $RehacerCTORow,
    $AfiliacionRow,
    $Prospecto_NroGuiaRow,
    $FueraHoraRow,
    $GestorCertVentaRow,
    $NombGestorCertVentaRow,
    $FechaAperturaRow,
    $IdCertVentaRow,
    $FechaCierreRow,
    $TipoCierreRow,
    $MotivoIncidenciaCertRow,
    $SolucionIncidenciaRow,
    $IncidenciaTecnicaRow,
    $FormaPagoCertRow,
    $ComentarioCertRow,
    $TCGestorRow,
    $GestorTCTVRow,
    $JefeTCTVRow,
    $kitnoinstaladoRow,
    $fechacorrecion_kitnoinstaladoRow,
    $errorcomprobantepagoRow,
    $fechacorrecion_errorcomprobantepagoRow,
    $errorsegmentoRow,
    $fechacorrecion_errorsegmentoRow,
    $fueranomalcomercialRow,
    $fechacorrecion_fueranomalcomercialRow,
    $fueranormativatecnicaRow,
    $fechacorrecion_fueranormativatecnicaRow,
    $incidenciadatosRow,
    $fechacorrecion_incidenciadatosRow,
    $inconformidadfuncionamientoRow,
    $fechacorrecion_inconformidadfuncionamientoRow,
    $inconformidadpagoinicialRow,
    $fechacorrecion_inconformidadpagoinicialRow,
    $inconformidadpagomensualRow,
    $fechacorrecion_inconformidadpagomensualRow,
    $inconformidadtiempopermanenciaRow,
    $fechacorrecion_inconformidadtiempopermanenciaRow,
    $inconformidadubicaciondispositivosRow,
    $fechacorrecion_inconformidadubicaciondispositivosRow,
    $noconcefuncionamientoRow,
    $fechacorrecion_noconcefuncionamientoRow,
    $notienecontratoRow,
    $fechacorrecion_notienecontratoRow,
    $promesaspendientesRow,
    $fechacorrecion_promesaspendientesRow,
    $reclamocomercialRow,
    $fechacorrecion_reclamocomercialRow,
    $solicitabajaRow,
    $fechacorrecion_solicitabajaRow,
    $tarjetaafiliadanopertenecetitularRow,
    $fechacorrecion_tarjetaafiliadanopertenecetitularRow,
    $recepmanualRow,
    $fechacorrecion_recepmanualRow,
    $descargaappRow,
    $fechacorrecion_descargaappRow,
    $capacitadoRow,
    $fechacorrecion_capacitadoRow,
    $numerollamadasRow,
    $FechaPendiente,
    $FechaPrimeraGestion,
    $FechaFinalizadoconIncidencia,
    $FechaResuelto,
    $ComentarioComercial,
    $RespComercial,
    $nuevohorarioSugerido,
    $FechaUltimaGestion,
    $EstadoLlamada,
    $ComentarioGestion,
    $FechaHoraProgramacion,
    $Tipogenero,
    $FechaNacimiento,
    $jsonIncidencias
);

$numrows_venta = $sql_venta->num_rows;

if ($numrows_venta > 0) {
    while ($sql_venta->fetch()) {
        $idu = $IdUsuarioRow;
        $matricula = $MatriculaRow;
        $comercial = $ComercialRow;
        $matjefe = $JefeVentaRow;
        $jefeventa = $NombJefeVentaRow;
        $dc = $CCRow;
        $estadoventa = $EstadoVentaRow;
        $categoriaventa = $CategoriaVentaRow;
        $tipoventa = $TipoVentaRow;
        $segmento = $SegmentoRow;
        $mesesautorizados = $MesesAutorizadoRow;
        $nprospecto = $NProspectoRow;
        $ncontrato = $NContratoRow;
        $idcliente = $IdClienteRow;
        $cliente = $ClienteRow;
        $correo = $CorreoRow;
        $movil = $TelefonounoRow;
        $fijo = $TelefonodosRow;
        $direccion = $DireccionRow;
        $preciokit = $PrecioKitRow;
        $totalextra = $TotalExtraRow;
        $resumenventa = $ResumenVentaRow;
        $regaloutorizado = $ExtraAutorizadoRow;
        $formadepago = $FormaPagoRow;
        $n590 = $N590Row;
        $PAI = $PAIRow;
        $idgeografico = $IdGeograficoRow;
        $distrito = $DistritoRow;
        $provincia = $ProvinciaRow;
        $lninstalador = $LNInstaladorRow;
        $idagenda = $IdAgendaRow;
        $instaladox = $InstaladoXRow;
        $matriculatec = $MatriculaTecRow;
        $nomreinstalador = $InstaladorRow;
        $fechainstalacionver = $FechaInstRow;
        $horainstalacionver = $HoraInstRow;
        $comentarioagenda = $ComentarioRow;
        $motivoinviable = $MotivoInviableRow;
        $motivocancelado = $MotivoCanceladaRow;
        $repercucion = $RepercusionRow;
        $CCOriginal = $CCOriginalRow;
        $factmotivoincidencia = $MotivoIncidenciaRow;
        $factfecharecepciondoc = $FechaRecepcionDOCRow;
        $factfechafacturacion = $FechaFacturacionRow;
        $factdocoriginal = $DOCOriginalRow;
        $factsegmentacion = $SegmentacionRow;
        $factpago = $PagoRow;
        $factautoriza = $AutorizaRow;
        $factdni = $DNIRow;
        $factelementosctops = $ElementosCTOPSRow;
        $factdocpai = $DOCPAIRow;
        $factfaltadoc = $FaltaDOCRow;
        $factrehacercto = $RehacerCTORow;
        $factafiliacion = $AfiliacionRow;
        $factprospecto_nroguia = $Prospecto_NroGuiaRow;
        $factfuerahora = $FueraHoraRow;
        $estadovisita = $EstadoVisitaRow;
        $hojacertificacion = $HojaCertificacionRow;
        $certificadovalidado = $CertificadoValidadoRow;
        $GestorCertVenta = $GestorCertVentaRow;
        $NombGestorCertVenta = $NombGestorCertVentaRow;
        $idcertventa = $IdCertVentaRow;
        $FechaApertura = $FechaAperturaRow;

        if (!empty($GestorCertVenta)) {
            $htmlGestor = '<option value="' . $GestorCertVenta . '" selected>' . $GestorCertVenta . ' - ' . $NombGestorCertVenta . '</option>';
        } else {
            $htmlGestor = '<option value="" selected>Seleccione</option>';
        }

        $FechaCierre = $FechaCierreRow;
        $TipoCierre = $TipoCierreRow;
        $MotivoIncidencia = $MotivoIncidenciaCertRow;
        $SolucionIncidencia = $SolucionIncidenciaRow;
        $inci_tecnica = $IncidenciaTecnicaRow;
        $FormaPagoCert = $FormaPagoCertRow;
        $ComentarioCert = $ComentarioCertRow;
        $TCGestor = $TCGestorRow;
        $GestorTCTV = $GestorTCTVRow;
        $JefeTCTV = $JefeTCTVRow;

        if ($dc == 511 || $dc == 512) {
            $matricula = $TCGestor;
            $comercial = $GestorTCTV;
            $matjefe = $JefeTCTV;
        }

        $kitnoinstalado = $kitnoinstaladoRow;
        $fechacorrecion_kitnoinstalado = $fechacorrecion_kitnoinstaladoRow;
        $errorcomprobantepago = $errorcomprobantepagoRow;
        $fechacorrecion_errorcomprobantepago = $fechacorrecion_errorcomprobantepagoRow;
        $errorsegmento = $errorsegmentoRow;
        $fechacorrecion_errorsegmento = $fechacorrecion_errorsegmentoRow;
        $fueranomalcomercial = $fueranomalcomercialRow;
        $fechacorrecion_fueranomalcomercial = $fechacorrecion_fueranomalcomercialRow;
        $fueranormativatecnica = $fueranormativatecnicaRow;
        $fechacorrecion_fueranormativatecnica = $fechacorrecion_fueranormativatecnicaRow;
        $incidenciadatos = $incidenciadatosRow;
        $fechacorrecion_incidenciadatos = $fechacorrecion_incidenciadatosRow;
        $inconformidadfuncionamiento = $inconformidadfuncionamientoRow;
        $fechacorrecion_inconformidadfuncionamiento = $fechacorrecion_inconformidadfuncionamientoRow;
        $inconformidadpagoinicial = $inconformidadpagoinicialRow;
        $fechacorrecion_inconformidadpagoinicial = $fechacorrecion_inconformidadpagoinicialRow;
        $inconformidadpagomensual = $inconformidadpagomensualRow;
        $fechacorrecion_inconformidadpagomensual = $fechacorrecion_inconformidadpagomensualRow;
        $inconformidadtiempopermanencia = $inconformidadtiempopermanenciaRow;
        $fechacorrecion_inconformidadtiempopermanencia = $fechacorrecion_inconformidadtiempopermanenciaRow;
        $inconformidadubicaciondispositivos = $inconformidadubicaciondispositivosRow;
        $fechacorrecion_inconformidadubicaciondispositivos = $fechacorrecion_inconformidadubicaciondispositivosRow;
        $noconcefuncionamiento = $noconcefuncionamientoRow;
        $fechacorrecion_noconcefuncionamiento = $fechacorrecion_noconcefuncionamientoRow;
        $notienecontrato = $notienecontratoRow;
        $fechacorrecion_notienecontrato = $fechacorrecion_notienecontratoRow;
        $promesaspendientes = $promesaspendientesRow;
        $fechacorrecion_promesaspendientes = $fechacorrecion_promesaspendientesRow;
        $reclamocomercial = $reclamocomercialRow;
        $fechacorrecion_reclamocomercial = $fechacorrecion_reclamocomercialRow;
        $solicitabaja = $solicitabajaRow;
        $fechacorrecion_solicitabaja = $fechacorrecion_solicitabajaRow;
        $tarjetaafiliadanopertenecetitular = $tarjetaafiliadanopertenecetitularRow;
        $fechacorrecion_tarjetaafiliadanopertenecetitular = $fechacorrecion_tarjetaafiliadanopertenecetitularRow;
        $recepmanual = $recepmanualRow;
        $fechacorrecion_recepmanual = $fechacorrecion_recepmanualRow;
        $descargaapp = $descargaappRow;
        $fechacorrecion_descargaapp = $fechacorrecion_descargaappRow;
        $capacitado = $capacitadoRow;
        $fechacorrecion_capacitado = $fechacorrecion_capacitadoRow;
        $numerollamadas = $numerollamadasRow;

        
        if ($numerollamadas == "") {
            $numerollamadas=0;
        }
        
        // ($dc==511 || $dc==512)?$TCGestor:$matricula
    }
}


$html = NULL;

$sql = $con->prepare("SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) JefeVenta FROM yifi58ge_dbUSUARIO.tblusuario u  where u.CC=? AND (u.Categoria ='JE' OR u.Categoria ='COACH' OR u.Categoria ='DEL' ) LIMIT 50");
$sql->bind_param('i', $dc);
$sql->execute();
$sql->store_result();
$sql->bind_result(
    $MatriculaRow,
    $JefeVentaRow
);

if ($sql->num_rows > 0) {
    while ($sql->fetch()) {

        if ($MatriculaRow == $matjefe) {
            $html .= '<option value="' . $MatriculaRow . '" selected>' . $MatriculaRow . ' - ' . $JefeVentaRow . ' </option>';
        } else {
            $html .= '<option value="' . $MatriculaRow . '">' . $MatriculaRow . ' - ' . $JefeVentaRow . ' </option>';
        }
    }
} else {
    $html .= '<option>No se encontraron resultado</option>';
}


$html_tecnico = NULL;
if ($lninstalador == "" || empty($lninstalador)) {
    $html_tecnico .= '<option></option>';
} else {

    $sql_tecnico = $con->prepare("SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) Instalador FROM yifi58ge_dbUSUARIO.tblusuario u  
INNER JOIN yifi58ge_dbUSUARIO.tblarea a on a.IdArea=u.IdArea
WHERE u.LN=? ");
    $sql_tecnico->bind_param('i', $lninstalador);
    $sql_tecnico->execute();
    $sql_tecnico->store_result();
    $sql_tecnico->bind_result(
        $MatriculaRow,
        $InstaladorRow
    );


    if ($sql_tecnico->num_rows > 0) {
        while ($sql_tecnico->fetch()) {
            $Matricula = $MatriculaRow;
            $Instalador = $InstaladorRow;
            if ($Matricula == $matriculatec) {
                $html_tecnico .= '<option value="' . $Matricula . '" selected>' . $Matricula . ' - ' . ($Instalador) . ' </option>';
            } else {
                $html_tecnico .= '<option value="' . $Matricula . '">' . $Matricula . ' - ' . ($Instalador) . ' </option>';
            }
        }
    } else {
        $html_tecnico .= '<option>No se encontraron resultado</option>';
    }
}


//INFORMACION AFILIACION
//  if($dc == 100 || $dc == 140 || $dc == 152 || $dc == 159 || $dc == 155 || $dc == 154 || $dc == 200 || $dc == 141 || $dc == 120 || $dc == 121 || $dc == 40 || $dc == 41 || $dc == 42 || $dc == 80){
if (!empty($ncontrato)) {
    $sqlafiliacion = $con->prepare("SELECT status,ACTION_DESCRIPTION,dataMap FROM yifi58ge_dbREFERIDO.tblafiliacion where beneficiaryId=?");
    $sqlafiliacion->bind_param('s', $ncontrato);
    $sqlafiliacion->execute();
    $sqlafiliacion->store_result();
    $sqlafiliacion->bind_result(
        $statusRow,
        $ACTION_DESCRIPTIONRow,
        $dataMapRow
    );

    if ($sqlafiliacion->num_rows > 0) {
        while ($sqlafiliacion->fetch()) {
            $estadoafiliacion = $statusRow;
            $ACTION_DESCRIPTION = $ACTION_DESCRIPTIONRow;
            $dataMap = $dataMapRow;
            if (isset($dataMap) && !empty($dataMap)) {
                $objAfiliacion = json_decode($dataMap, true);
                if (isset($objAfiliacion['mensaje_autorizacion']['dataMap']['CARD'])) {
                    $card = $objAfiliacion['mensaje_autorizacion']['dataMap']['CARD'];
                    $tipocuenta = 'Tarjeta';
                } else {
                    $card = '';
                    $tipocuenta = '';
                }
            }
        }
    } else {
        $estadoafiliacion = 'Pendiente';
        $ACTION_DESCRIPTION = '';
        $dataMap = '';
        $card = '';
        $tipocuenta = '';
    }


    $variablecuenta = array('Diners Club', 'visa', 'mastercard', 'American Express');
    //INFORMACION AFILIACION
    $sqlafiliacionmdp = $con->prepare("SELECT id,status,motivo,numero,tipo,correo FROM yifi58ge_dbREFERIDO.tblmdpafiliacion where ncontrato=? ");
    $sqlafiliacionmdp->bind_param('s', $ncontrato);
    $sqlafiliacionmdp->execute();
    $sqlafiliacionmdp->store_result();
    $sqlafiliacionmdp->bind_result(
        $idRow,
        $statusRow,
        $motivoRow,
        $numeroRow,
        $tipoRow,
        $correoRow
    );

    if ($sqlafiliacionmdp->num_rows > 0) {
        while ($sqlafiliacionmdp->fetch()) {
            $idnmdp = $idRow;
            $estadoafiliacionmdp = $statusRow;
            $motivomdp = $motivoRow;
            $card = $numeroRow;
            $tipo = $tipoRow;
            $correoenviomdp = $correoRow;
            if (in_array($tipo, $variablecuenta)) {
                $tipocuenta = 'Tarjeta';
            } else {
                $tipocuenta = 'Cuenta';
            }
        }
    } else {
        $idnmdp = '';
        $estadoafiliacionmdp = '';
        $motivomdp = '';
        $tipo = '';
        $correoenviomdp = '';
        $tipocuenta = '';
    }
} else {
    $estadoafiliacion = 'Pendiente';
    $ACTION_DESCRIPTION = '';
    $dataMap = '';
    $card = '';
    $tipocuenta = '';
}

// }else{
//              $estadoafiliacion='Pendiente';
//              $ACTION_DESCRIPTION='';
//              $dataMap='';
//              $card='';
//              $tipocuenta='';
//     }



?>


<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Verisure | VeriSmart</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png">
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
    <!-- AdminLTE Skins. Choose a skin from the css/skins
             folder instead of downloading all of them to reduce the load. -->
    <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">


    <!-- bootstrap datepicker -->
    <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
    <link href="//cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/4.17.37/css/bootstrap-datetimepicker.css" rel="stylesheet"/>
    <!-- iCheck for checkboxes and radio inputs -->
    <link rel="stylesheet" href="admin/plugins/iCheck/all.css">
    <!-- Bootstrap time Picker -->
    <link rel="stylesheet" href="admin/plugins/timepicker/bootstrap-timepicker.min.css">
    <!-- Select2 -->
    <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">


    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->

    <!-- Google Font -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
    <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
    <link href="admin/plugins/bootstrap-toggle-master/css/bootstrap-toggle.min.css" rel="stylesheet" type="text/css" />

    <link href="admin/bower_components/bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.min.css" rel="stylesheet" type="text/css" />
    <!-- Alertifyjs -->
    <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css" />


    <style>
        .modal-header-danger {
            color: #fff;
            background-color: #e4002b;
        }


        .preloader {
            background-color: #FFF;
            width: 100%;
            height: 100%;
            position: absolute;
            z-index: 1;
        }

        .dataTables_wrapper .myfilter .dataTables_filter {
            float: left
        }

        .dataTables_wrapper .mylength .dataTables_length {
            float: right
        }

        div.dataTables_scrollBody thead th {
            vertical-align: top;
        }

        td {
            max-width: 250px;
            overflow: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;

        }

        .espacio {
            height: 10px;
        }

        .espacio2 {
            height: 15px;
        }

        .thumbnail_style {
            text-align: center;
            border: none;
        }


        .caption h4 {
            margin-top: -10px;
            font-size: 13px;
            font-weight: bold;
        }

        .caption p {
            color: #777;
            font-size: 13px;
        }

        .caption a {
            color: #777;
            font-size: 10px;
        }


        #frmEditarVenta .form-control {
            border-radius: 4px
        }

        #c-slider {
            margin: auto;
            width: 100%;
            max-width: 900px;
            position: relative;
            overflow: hidden;

        }

        #slider {
            display: flex;
            width: 200%;

        }

        #slider section {
            width: 100%;
        }


        .select2-container--default .select2-selection--single {

            border: 1px solid #d2d6de;
            border-radius: 4px;
            font-size: 12px;
            padding: 4px 6px;
        }

        .btn-nuevo {
            color: #FFFFFF;
            background-color: #444444;
            border-color: #444444;
        }

        .btn-nuevo:hover,
        .btn-nuevo:focus,
        .btn-nuevo:active,
        .btn-nuevo.active,
        .open .dropdown-toggle.btn-nuevo {
            color: #FFFFFF;
            background-color: #616161;
            border-color: #444444;
        }

        .btn-nuevo:active,
        .btn-nuevo.active,
        .open .dropdown-toggle.btn-nuevo {
            background-image: none;
        }

        .btn-nuevo.disabled,
        .btn-nuevo[disabled],
        fieldset[disabled] .btn-nuevo,
        .btn-nuevo.disabled:hover,
        .btn-nuevo[disabled]:hover,
        fieldset[disabled] .btn-nuevo:hover,
        .btn-nuevo.disabled:focus,
        .btn-nuevo[disabled]:focus,
        fieldset[disabled] .btn-nuevo:focus,
        .btn-nuevo.disabled:active,
        .btn-nuevo[disabled]:active,
        fieldset[disabled] .btn-nuevo:active,
        .btn-nuevo.disabled.active,
        .btn-nuevo[disabled].active,
        fieldset[disabled] .btn-nuevo.active {
            background-color: #444444;
            border-color: #444444;
        }
    </style>

    <style>
        .main-header,
        .main-sidebar,
        .left-side {
            position: fixed
        }

        .main-header {
            top: 0;
            right: 0;
            left: 0
        }

        .content-wrapper,
        .right-side {
            padding-top: 50px
        }

        @media (max-width:767px) {

            .content-wrapper,
            .right-side {
                padding-top: 100px
            }
        }

        .layout-boxed .wrapper {
            max-width: 100%
        }

        .wrapper {
            overflow: hidden .control-sidebar {
                position: fixed;
                height: 100%;
                overflow-y: auto;
                padding-bottom: 50px
            }
    </style>



    <style>
        .ui-autocomplete {
            position: absolute;
            z-index: 1000;
            cursor: default;
            padding: 0;
            margin-top: 2px;
            list-style: none;
            font-size: 11px;
            font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
            background-color: #ffffff;
            border: 1px solid #ccc;
            -webkit-border-radius: 5px;
            -moz-border-radius: 5px;
            border-radius: 5px;
            -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
            -moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
            box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);

            z-index: 1051 !important;

        }





        hr {
            height: 4px;
            width: 100%;
            background-color: #ecf0f5;

        }



        hr {
            /* margin-top: 20px; */
            margin-bottom: 20px;
            border: 0;
            /* border-top: 1px solid #eee; */
        }


        hr {
            display: block;
            unicode-bidi: isolate;
            -webkit-margin-before: 0.5em;
            -webkit-margin-after: 0.5em;
            -webkit-margin-start: auto;
            -webkit-margin-end: auto;
            overflow: hidden;
            border-style: inset;

        }

        .box.box-custom {
            border-top-color: #ffffff;
        }

        .box {
            position: relative;
            border-radius: 3px;
            background: #ffffff;
            border-top: 3px solid #d2d6de;
            margin-bottom: 5px;
            width: 100%;
            box-shadow: 0 1px 1px rgba(0, 0, 0, 0.1);
        }

        .swal2-popup {
            font-size: 1.5rem !important;
        }

        .swal2-styled.swal2-confirm {
            background-color: #e4002b !important;
        }

        .ocultar {
            display: none;
        }

        label {
            font-weight: 400;
            font-size: 12px;
        }

        .subtitulo {
            text-decoration: underline;
            font-weight: bold;
        }

        .centrar-texto {
            text-align: center;
        }
    </style>

    <style>
        .toggle.ios,
        .toggle-on.ios,
        .toggle-off.ios {
            border-radius: 20px;
        }

        .toggle.ios .toggle-handle {
            border-radius: 20px;
        }
    </style>





</head>

<body class="sidebar-collapse skin-red sidebar-mini">

    <div class="wrapper">
        <!-- Header -->
        <?php include 'admin/header.php'; ?>
        <!-- Left side column. contains the logo and sidebar -->
        <?php

        $configamp = "active";
        $vtacertificadora = "active";
        include 'admin/main-sidebar.php';
        ?>


        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <h1>
                    VENTA CERTIFICADA
                </h1>
                <ol class="breadcrumb">
                    <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
                    <li class="active">Editar de Venta</li>
                </ol>


            </section>



            <!-- Main content -->
            <section class="content">


                <div class="row">
                    <div class="col-md-2"></div>

                    <div class="col-md-8">


                        <!-- /.box-header -->

                        <div class="box box-danger">
                            <div class="box-header">
                                <?php if ($tipoventa == 'RE') {



                                ?>
                                    <h3 class="box-title">EDITAR <select name="lblcategoria" id="lblcategoria" style="border:none;-moz-appearance:none;-webkit-appearance:none;-ms-appearance:none;-o-appearance:none;">


                                            <?php
                                            if ($estadoventa == "AgendadaTEC" || $estadoventa == "Instalada" || $estadoventa == "Incidencia" || $estadoventa == "IncidenciaGestCorreo" || $estadoventa == "IncidenciaGestValija" || $estadoventa == "NoDoc" || $estadoventa == "DocEnvi" || $estadoventa == "PorFacturar"  || $estadoventa == "Facturada") {
                                            ?>

                                                <option value="<?php echo $categoriaventa; ?>" <?php if ($categoriaventa == "Online" || $categoriaventa == "Ficha" || $categoriaventa == "Delegacion") {
                                                                                                    echo "selected";
                                                                                                } ?>><?php

                                                                                                                                                                                                                            if ($categoriaventa == "Online") {
                                                                                                                                                                                                                                $nombc = "VENTA ONLINE";
                                                                                                                                                                                                                            } else if ($categoriaventa == "Ficha") {
                                                                                                                                                                                                                                $nombc = "VENTA FICHA";
                                                                                                                                                                                                                            } else if ($categoriaventa == "Delegacion") {
                                                                                                                                                                                                                                $nombc = "VENTA DELEGACIÓN ";
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            echo $nombc;
                                                                                                                                                                                                                            ?> - <?php echo $nprospecto . " | " . $ncontrato ?></option>

                                            <?php
                                            } else {
                                            ?>


                                                <option value="Online" <?php if ($categoriaventa == "Online") {
                                                                            echo "selected";
                                                                        } ?> hidden="">VENTA ONLINE - <?php echo $nprospecto . " | " . $ncontrato ?></option>
                                                <option value="Ficha" <?php if ($categoriaventa == "Ficha") {
                                                                            echo "selected";
                                                                        } ?>>VENTA FICHA - <?php echo $nprospecto . " | " . $ncontrato ?></option>
                                                <option value="Delegacion" <?php if ($categoriaventa == "Delegacion") {
                                                                                echo "selected";
                                                                            } ?>>VENTA DELEGACIÓN - <?php echo $nprospecto . " | " . $ncontrato ?></option>
                                                <option value="VAsignada" <?php if ($categoriaventa == "VAsignada") {
                                                                                echo "selected";
                                                                            } ?> hidden="">VISITA ASIGNADA - <?php echo $nprospecto . " | " . $ncontrato ?></option>
                                                <option value="Cancelada" <?php if ($categoriaventa == "Cancelada") {
                                                                                echo "selected";
                                                                            } ?> hidden="">CANCELADA - <?php echo $nprospecto . " | " . $ncontrato ?></option>
                                                <option value="NoVendida" <?php if ($categoriaventa == "NoVendida") {
                                                                                echo "selected";
                                                                            } ?>>NO VENDIDA - <?php echo $nprospecto . " | " . $ncontrato ?></option>

                                            <?php
                                            }

                                            ?>

                                        </select></h3>
                                <?php } else {

                                ?>
                                    <h3 class="box-title">EDITAR

                                        <select name="lblcategoria" id="lblcategoria" style="border:none;-moz-appearance:none;-webkit-appearance:none;-ms-appearance:none;-o-appearance:none;">


                                            <?php
                                            if ($estadoventa == "AgendadaTEC" || $estadoventa == "Instalada" || $estadoventa == "Incidencia" || $estadoventa == "IncidenciaGestCorreo" || $estadoventa == "IncidenciaGestValija"  || $estadoventa == "NoDoc" || $estadoventa == "DocEnvi" || $estadoventa == "PorFacturar" || $estadoventa == "Facturada") {
                                            ?>

                                                <option value="<?php echo $categoriaventa; ?>" <?php if ($categoriaventa == "Online" || $categoriaventa == "Ficha" || $categoriaventa == "Delegacion") {
                                                                                                    echo "selected";
                                                                                                } ?>><?php

                                                                                                                                                                                                                            if ($categoriaventa == "Online") {
                                                                                                                                                                                                                                $nombc = "VENTA ONLINE";
                                                                                                                                                                                                                            } else if ($categoriaventa == "Ficha") {
                                                                                                                                                                                                                                $nombc = "VENTA FICHA";
                                                                                                                                                                                                                            } else if ($categoriaventa == "Delegacion") {
                                                                                                                                                                                                                                $nombc = "VENTA DELEGACIÓN ";
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            echo $nombc;
                                                                                                                                                                                                                            ?> - <?php echo $nprospecto . " | " . $ncontrato ?></option>

                                            <?php
                                            } else {
                                            ?>
                                                <option value="ProspectoRP" <?php if ($categoriaventa == "ProspectoRP") {
                                                                                echo "selected";
                                                                            } ?> hidden="">NUEVO PROSPECTO RP - <?php echo $nprospecto . " | " . $ncontrato ?></option>
                                                <option value="Online" <?php if ($categoriaventa == "Online") {
                                                                            echo "selected";
                                                                        } ?> hidden="">VENTA ONLINE - <?php echo $nprospecto . " | " . $ncontrato ?></option>
                                                <option value="Ficha" <?php if ($categoriaventa == "Ficha") {
                                                                            echo "selected";
                                                                        } ?>>VENTA FICHA - <?php echo $nprospecto . " | " . $ncontrato ?></option>
                                                <option value="Delegacion" <?php if ($categoriaventa == "Delegacion") {
                                                                                echo "selected";
                                                                            } ?>>VENTA DELEGACIÓN - <?php echo $nprospecto . " | " . $ncontrato ?></option>
                                                <option value="NoVendida" <?php if ($categoriaventa == "NoVendida") {
                                                                                echo "selected";
                                                                            } ?>>NO VENDIDA - <?php echo $nprospecto . " | " . $ncontrato ?></option>
                                                <option value="Cancelada" <?php if ($categoriaventa == "Cancelada") {
                                                                                echo "selected";
                                                                            } ?> hidden="">CANCELADA - <?php echo $nprospecto . " | " . $ncontrato ?></option>

                                            <?php
                                            }

                                            ?>


                                        </select>
                                    </h3>
                                <?php
                                }

                                ?>
                                <input id="lblcat" name="lblcat" value="<?php echo $categoriaventa; ?>" hidden="">



                                <div class="box-tools pull-right">
                                    <?php if ($nombacceso == 'test') {
                                    }/*else if($rc=='totales' && $nombacceso=='GestorVTACertificada'){
                                                }else if($rc=='totales' && ($matriculausuario=='Q03911' || $matriculausuario=='Q26485' || $matriculausuario=='WK8630')){    
                                                }*/ else { ?>
                                        <!--<a class="btn btn-nuevo btn-sm" id="btnGuardarEditarVenta" href="#"><i class="fa fa-save"></i> Guardar</a>-->
                                    <?php   } ?>
                                    <a href="<?php if ($rc == 'totales') {
                                                    echo 'ventastotales.php';
                                                } else if ($rc == 'asignacion') {
                                                    echo 'ventacertificadaasignacion.php';
                                                } else if ($rc == 'cert') {
                                                    echo 'certificacionventa.php';                                                    
                                                } else {
                                                    echo 'ventacertificada.php';
                                                }
                                                ?>" class="btn btn-danger btn-sm"><i class="fa fa-reply"></i> Regresar</a>


                                </div>


                            </div>
                            <div class="espacio"></div>



                        </div>

                        <form id="frmEditarVenta" method="POST">

                            <div class="box box-custom">
                                <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                    <h5>INFORMACION DE VENTA</h5>


                                    <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                        </button>

                                    </div>
                                </div>
                                <!-- /.box-header -->
                                <div class="box-body">
                                    <table cellspacing="0" style="width:100%;border-collapse: separate;padding: 20px;">

                                        <tr>
                                            <td style="width:15%;font-size: 12px">MATRICULA:</td>

                                            <td style="width:25%;"><input name="lblmatricula" id="lblmatricula" class="form-control input-sm" value="<?php echo $matricula; ?>" style="width: 100%;" <?php if ($estadoventa == 'Incidencia' || $estadoventa == 'IncidenciaGestCorreo' || $estadoventa == 'IncidenciaGestValija' || $estadoventa == 'NoDoc' || $estadoventa == 'DocEnvi' || $estadoventa == 'Instalada' || $estadoventa == 'PorFacturar' || $estadoventa == 'Facturada') {
                                                                                                                                                                                                    ?> readonly="readonly" <?php } ?> />

                                                <input id="lblidusuario" name="lblidusuario" value="<?php echo $idu; ?>" hidden="">
                                                <input id="lblrc" name="lblrc" value="<?php echo $rc; ?>" hidden="">
                                            </td>
                                            <td style="width:10%"></td>
                                            <td style="width:15%;font-size: 12px">COMERCIAL:</td>
                                            <td style="width:2%"></td>
                                            <td style="width:25%"><input name="lblnombcomercial" id="lblnombcomercial" class="form-control input-sm" style="width: 100%;" value="<?php echo $comercial; ?>" readonly="readonly"></td>
                                        </tr>
                                        <tr class="espacio"></tr>
                                        <tr>
                                            <td style="width:15%;font-size: 12px">DC:</td>

                                            <td style="width:25%;">
                                                <select class="form-control input-sm" name="lbldc" id="lbldc" style="width: 100%;">
                                                    <?php if ($dc == "150") { ?>
                                                        <option value="150" <?php if ($dc == "150") {
                                                                                echo "selected";
                                                                            } ?>>150</option>
                                                    <?php } else if ($dc == "151") { ?>
                                                        <option value="151" <?php if ($dc == "151") {
                                                                                echo "selected";
                                                                            } ?>>151</option>
                                                    <?php } else if ($dc == "152") { ?>
                                                        <option value="152" <?php if ($dc == "152") {
                                                                                echo "selected";
                                                                            } ?>>152</option>
                                                    <?php } else if ($dc == "153") { ?>
                                                        <option value="153" <?php if ($dc == "153") {
                                                                                echo "selected";
                                                                            } ?>>153</option>
                                                    <?php } else if ($dc == "154") { ?>
                                                        <option value="154" <?php if ($dc == "154") {
                                                                                echo "selected";
                                                                            } ?>>154</option>
                                                    <?php } else if ($dc == "155") { ?>
                                                        <option value="155" <?php if ($dc == "155") {
                                                                                echo "selected";
                                                                            } ?>>155</option>
                                                    <?php } else if ($dc == "156") { ?>
                                                        <option value="156" <?php if ($dc == "156") {
                                                                                echo "selected";
                                                                            } ?>>156</option>
                                                    <?php } else if ($dc == "157") { ?>
                                                        <option value="157" <?php if ($dc == "157") {
                                                                                echo "selected";
                                                                            } ?>>157</option>
                                                    <?php } else if ($dc == "158") { ?>
                                                        <option value="158" <?php if ($dc == "158") {
                                                                                echo "selected";
                                                                            } ?>>158</option>
                                                    <?php } else if ($dc == "159") { ?>
                                                        <option value="159" <?php if ($dc == "159") {
                                                                                echo "selected";
                                                                            } ?>>159</option>
                                                    <?php } else if ($dc == "200") { ?>
                                                        <option value="200" <?php if ($dc == "200") {
                                                                                echo "selected";
                                                                            } ?>>200</option>
                                                    <?php } else if ($dc == "120") { ?>
                                                        <option value="120" <?php if ($dc == "120") {
                                                                                echo "selected";
                                                                            } ?>>120</option>
                                                    <?php } else if ($dc == "140") { ?>
                                                        <option value="140" <?php if ($dc == "140") {
                                                                                echo "selected";
                                                                            } ?>>140</option>
                                                    <?php } else if ($dc == "141") { ?>
                                                        <option value="141" <?php if ($dc == "141") {
                                                                                echo "selected";
                                                                            } ?>>141</option>
                                                    <?php } else if ($dc == "80") { ?>
                                                        <option value="80" <?php if ($dc == "80") {
                                                                                echo "selected";
                                                                            } ?>>80</option>
                                                    <?php } else if ($dc == "100") { ?>
                                                        <option value="100" <?php if ($dc == "100") {
                                                                                echo "selected";
                                                                            } ?>>100</option>
                                                    <?php } else if ($dc == "40") { ?>
                                                        <option value="40" <?php if ($dc == "40") {
                                                                                echo "selected";
                                                                            } ?>>40</option>

                                                    <?php } else if ($dc == "41") { ?>
                                                        <option value="41" <?php if ($dc == "41") {
                                                                                echo "selected";
                                                                            } ?>>41</option>
                                                    <?php } else if ($dc == "42") { ?>
                                                        <option value="42" <?php if ($dc == "42") {
                                                                                echo "selected";
                                                                            } ?>>42</option>
                                                    <?php } else if ($dc == "121") { ?>
                                                        <option value="121" <?php if ($dc == "121") {
                                                                                echo "selected";
                                                                            } ?>>121</option>
                                                    <?php } else if ($dc == "250") { ?>
                                                        <option value="250" <?php if ($dc == "250") {
                                                                                echo "selected";
                                                                            } ?>>250</option>
                                                    <?php } else if ($dc == "251") { ?>
                                                        <option value="251" <?php if ($dc == "251") {
                                                                                echo "selected";
                                                                            } ?>>251</option>
                                                    <?php } else if ($dc == "252") { ?>
                                                        <option value="252" <?php if ($dc == "252") {
                                                                                echo "selected";
                                                                            } ?>>252</option>
                                                    <?php } else if ($dc == "20") { ?>
                                                        <option value="20" <?php if ($dc == "20") {
                                                                                echo "selected";
                                                                            } ?>>20</option>
                                                    <?php } else if ($dc == "511") { ?>
                                                        <option value="511" <?php if ($dc == "511") {
                                                                                echo "selected";
                                                                            } ?>>511</option>

                                                    <?php } else if ($dc == "512") { ?>
                                                        <option value="512" <?php if ($dc == "512") {
                                                                                echo "selected";
                                                                            } ?>>512</option>
                                                    <?php } else if ($dc == "513") { ?>
                                                        <option value="513" <?php if ($dc == "513") {
                                                                                echo "selected";
                                                                            } ?>>513</option>

                                                    <?php } else if ($dc == "500") { ?>
                                                        <option value="500" <?php if ($dc == "500") {
                                                                                echo "selected";
                                                                            } ?>>500</option>
                                                    <?php } else if ($dc == "599") { ?>
                                                        <option value="599" <?php if ($dc == "599") {
                                                                                echo "selected";
                                                                            } ?>>599</option>

                                                    <?php } else if ($dc == "601") { ?>
                                                        <option value="601" <?php if ($dc == "601") {
                                                                                echo "selected";
                                                                            } ?>>601</option>
                                                    <?php } else if ($dc == "701") { ?>
                                                        <option value="701" <?php if ($dc == "701") {
                                                                                echo "selected";
                                                                            } ?>>701</option>
                                                    <?php } else if ($dc == "702") { ?>
                                                        <option value="702" <?php if ($dc == "702") {
                                                                                echo "selected";
                                                                            } ?>>702</option>
                                                    <?php } else if ($dc == "901") { ?>
                                                        <option value="901" <?php if ($dc == "901") {
                                                                                echo "selected";
                                                                            } ?>>901</option>
                                                                            
                                                    <?php } else if ($dc == "130") { ?>
                                                        <option value="130" <?php if ($dc == "130") {
                                                                                echo "selected";
                                                                            } ?>>130</option>
                                                                            
                                                    <?php } else if ($dc == "230") { ?>
                                                        <option value="230" <?php if ($dc == "230") {
                                                                                echo "selected";
                                                                            } ?>>230</option>
                                                    <?php } else if ($dc == "60") { ?>
                                                        <option value="60" <?php if ($dc == "60") {
                                                                                echo "selected";
                                                                            } ?>>60</option>                                                                               

                                                    <?php } else { ?>
                                                        <option value="" selected></option>
                                                    <?php } ?>
                                                </select>
                                            </td>
                                            <td style="width:10%"></td>
                                            <td style="width:15%;font-size: 12px">JEFE VENTA:</td>
                                            <td style="width:2%"></td>
                                            <td style="width:25%">

                                                <select class="form-control input-sm" name="lbljefeventa" id="lbljefeventa" style="width: 100%;">
                                                    <?php echo $html; ?>
                                                </select>
                                        </tr>
                                        <tr class="espacio"></tr>
                                        <tr>
                                            <td style="width:15%;font-size: 12px">ESTADO VENTA:</td>

                                            <td style="width:25%;"><select name="lblestadoventa" id="lblestadoventa" class="form-control input-sm">
                                                    <option>Seleccione</option>
                                                    <?php
                                                    if ($estadoventa == "ProspectoRP" || $estadoventa == "VAsignada" || $estadoventa == "PendienteData" || $estadoventa == "PendienteAgenda" || $estadoventa == "AgendadaDEL" || $estadoventa == "NoVendida" || $estadoventa == "Cancelada" || $estadoventa == "Postergada") {
                                                    ?>
                                                        <option value="ProspectoRP" <?php if ($estadoventa == "ProspectoRP") {
                                                                                        echo "selected";
                                                                                    } ?> hidden="">ProspectoRP</option>
                                                        <option value="VAsignada" <?php if ($estadoventa == "VAsignada") {
                                                                                        echo "selected";
                                                                                    } ?> hidden="">VAsignada</option>
                                                        <option value="PendienteData" <?php if ($estadoventa == "PendienteData") {
                                                                                            echo "selected";
                                                                                        } ?> hidden="">PendienteData</option>
                                                        <option value="PendienteAgenda" <?php if ($estadoventa == "PendienteAgenda") {
                                                                                            echo "selected";
                                                                                        } ?>>PendienteAgenda</option>
                                                        <option value="AgendadaDEL" <?php if ($estadoventa == "AgendadaDEL") {
                                                                                        echo "selected";
                                                                                    } ?>>AgendadaDEL</option>
                                                        <option value="NoVendida" <?php if ($estadoventa == "NoVendida") {
                                                                                        echo "selected";
                                                                                    } ?> hidden="">NoVendida</option>
                                                        <option value="Postergada" <?php if ($estadoventa == "Postergada") {
                                                                                        echo "selected";
                                                                                    } ?> hidden="">Postergada</option>
                                                        <option value="Cancelada" <?php if ($estadoventa == "Cancelada") {
                                                                                        echo "selected";
                                                                                    } ?> hidden="" disabled="disabled">Cancelada</option>
                                                    <?php
                                                    }
                                                    if ($estadoventa == "AgendadaTEC") {
                                                    ?>
                                                        <option value="AgendadaTEC" <?php if ($estadoventa == "AgendadaTEC") {
                                                                                        echo "selected";
                                                                                    } ?>>AgendadaTEC</option>

                                                    <?php
                                                    }
                                                    if ($estadoventa == "Instalada" || $estadoventa == "InstaladaDEL" || $estadoventa == "IncidenciaAuditoria") {
                                                    ?>
                                                        <option value="Instalada" <?php if ($estadoventa == "Instalada") {
                                                                                        echo "selected";
                                                                                    } ?> hidden="">Instalada</option>
                                                        <option value="InstaladaDEL" <?php if ($estadoventa == "InstaladaDEL") {
                                                                                            echo "selected";
                                                                                        } ?> hidden="">InstaladaDEL</option>
                                                        <option value="IncidenciaAuditoria" <?php if ($estadoventa == "IncidenciaAuditoria") {
                                                                                                echo "selected";
                                                                                            } ?> hidden="">IncidenciaAuditoria</option>
                                                        <option value="DocEnvi" <?php if ($estadoventa == "DocEnvi") {
                                                                                    echo "selected";
                                                                                } ?>>DocEnvi</option>
                                                    <?php
                                                    }
                                                    if ($estadoventa == "Facturada" || $estadoventa == "PorFacturar") {
                                                    ?>
                                                        <option value="Facturada" <?php if ($estadoventa == "Facturada") {
                                                                                        echo "selected";
                                                                                    } ?> hidden="" disabled="disabled">Facturada</option>
                                                        <option value="PorFacturar" <?php if ($estadoventa == "PorFacturar") {
                                                                                        echo "selected";
                                                                                    } ?> hidden="">PorFacturar</option>
                                                    <?php
                                                    }
                                                    if ($estadoventa == "Incidencia" || $estadoventa == "IncidenciaGestCorreo" || $estadoventa == "IncidenciaGestValija") {
                                                    ?>
                                                        <option value="Incidencia" <?php if ($estadoventa == "Incidencia") {
                                                                                        echo "selected";
                                                                                    } ?> hidden="" disabled="disabled">Incidencia</option>
                                                        <option value="IncidenciaGestCorreo" <?php if ($estadoventa == "IncidenciaGestCorreo") {
                                                                                                    echo "selected";
                                                                                                } ?>>IncidenciaGestCorreo</option>
                                                        <option value="IncidenciaGestValija" <?php if ($estadoventa == "IncidenciaGestValija") {
                                                                                                    echo "selected";
                                                                                                } ?>>IncidenciaGestValija</option>
                                                    <?php
                                                    }
                                                    if ($estadoventa == "Ilocalizable") {
                                                    ?>
                                                        <option value="PendienteData" <?php if ($estadoventa == "PendienteData") {
                                                                                            echo "selected";
                                                                                        } ?> hidden="">PendienteData</option>
                                                        <option value="PendienteAgenda" <?php if ($estadoventa == "PendienteAgenda") {
                                                                                            echo "selected";
                                                                                        } ?>>PendienteAgenda</option>
                                                        <option value="AgendadaDEL" <?php if ($estadoventa == "AgendadaDEL") {
                                                                                        echo "selected";
                                                                                    } ?> hidden="">AgendadaDEL</option>
                                                        <option value="Ilocalizable" <?php if ($estadoventa == "Ilocalizable") {
                                                                                            echo "selected";
                                                                                        } ?>>Ilocalizable</option>
                                                    <?php
                                                    }
                                                    if ($estadoventa == "Inviable") {
                                                    ?>
                                                        <option value="PendienteData" <?php if ($estadoventa == "PendienteData") {
                                                                                            echo "selected";
                                                                                        } ?> hidden="">PendienteData</option>
                                                        <option value="PendienteAgenda" <?php if ($estadoventa == "PendienteAgenda") {
                                                                                            echo "selected";
                                                                                        } ?>>PendienteAgenda</option>
                                                        <option value="AgendadaDEL" <?php if ($estadoventa == "AgendadaDEL") {
                                                                                        echo "selected";
                                                                                    } ?> hidden="">AgendadaDEL</option>
                                                        <option value="Inviable" <?php if ($estadoventa == "Inviable") {
                                                                                        echo "selected";
                                                                                    } ?>>Inviable</option>
                                                    <?php
                                                    }
                                                    if ($estadoventa == "NoDoc" || $estadoventa == "DocEnvi") {
                                                    ?>
                                                        <option value="NoDoc" <?php if ($estadoventa == "NoDoc") {
                                                                                    echo "selected";
                                                                                } ?> hidden="" disabled="disabled">NoDoc</option>
                                                        <option value="DocEnvi" <?php if ($estadoventa == "DocEnvi") {
                                                                                    echo "selected";
                                                                                } ?>>DocEnvi</option>
                                                    <?php
                                                    }
                                                    ?>

                                                    <option value="NoVendida" <?php if ($estadoventa == "NoVendida") {
                                                                                    echo "selected";
                                                                                } ?> hidden="">NoVendida</option>


                                                </select>
                                                <input id="lblestventa" name="lblestventa" value="<?php echo $estadoventa; ?>" hidden="" />
                                                <input id="lblestvisita" name="lblestvisita" value="<?php echo $estadovisita; ?>" hidden="" />
                                            </td>
                                            <td style="width:10%"></td>
                                            <td style="width:15%;font-size: 12px">RECURSO:</td>
                                            <td style="width:2%"></td>
                                            <td style="width:25%"><select name="lbltipoventa" id="lbltipoventa" class="form-control input-sm">
                                                    <option>Seleccione</option>
                                                    <option value="RE" <?php if ($tipoventa == "RE") {
                                                                            echo "selected";
                                                                        } ?> hidden="" disabled="disabled">RE</option>
                                                    <option value="RPTMK" <?php if ($tipoventa == "RPTMK") {
                                                                                echo "selected";
                                                                            } ?>>RPTMK</option>
                                                    <option value="RPMKT" <?php if ($tipoventa == "RPMKT") {
                                                                                echo "selected";
                                                                            } ?>>RPMKT</option>
                                                    <option value="RP" <?php if ($tipoventa == "RP") {
                                                                            echo "selected";
                                                                        } ?>>RP</option>
                                                    <option value="RPPA" <?php if ($tipoventa == "RPPA") {
                                                                                echo "selected";
                                                                            } ?>>RPPA</option>
                                                    <option value="RPPR" <?php if ($tipoventa == "RPPR") {
                                                                                echo "selected";
                                                                            } ?>>RPPR</option>



                                                </select>
                                                <input id="lbltiventa" name="lbltiventa" value="<?php echo $tipoventa; ?>" hidden="" />
                                            </td>
                                        </tr>
                                        <tr class="espacio"></tr>

                                        <tr>
                                            <td style="width:15%;font-size: 12px">SEGMENTO:</td>

                                            <td style="width:25%"><select class="form-control input-sm" name="lblsegmento" id="lblsegmento">
                                                    <option>Seleccione</option>
                                                    <option value="RES" <?php if ($segmento == "RES") {
                                                                            echo "selected";
                                                                        } ?>>RES</option>
                                                    <option value="NEG" <?php if ($segmento == "NEG") {
                                                                            echo "selected";
                                                                        } ?>>NEG</option>

                                                </select></td>
                                            <td style="width:10%"></td>
                                            <td style="width:15%;font-size: 12px">MESES AUTORIZADOS:</td>
                                            <td style="width:2%"></td>
                                            <td style="width:25%"><input type="text" maxlength="3" class="form-control input-sm" id="lblmesesautorizados" name="lblmesesautorizados" value="<?php echo $mesesautorizados; ?>" onkeypress="return filterFloat(event, this);" disabled></td>
                                        </tr>

                                        <tr class="espacio"></tr>
                                        <tr>
                                            <td style="width:15%;font-size: 12px">N° PROSPECTO:</td>

                                            <td style="width:25%"><input type="text" class="form-control input-sm" name="lblnprospecto" id="lblnprospecto">
                                                <input type="text" name="lblnprospectohidden" id="lblnprospectohidden" value="<?php echo $nprospecto; ?>" hidden>
                                            </td>
                                            <td style="width:10%"></td>
                                            <td style="width:15%;font-size: 12px">N° CONTRATO:</td>
                                            <td style="width:2%"></td>
                                            <td style="width:25%"><input type="text" class="form-control input-sm" name="lblncontrato" id="lblncontrato" value="<?php echo $ncontrato; ?>" readonly="readonly">
                                            </td>
                                        </tr>

                                        <tr class="espacio"></tr>


                                        <tr>
                                            <td style="width:15%;font-size: 12px">CLIENTE:</td>

                                            <td style="width:25%;"><input name="lblnombcliente" class="form-control input-sm" id="lblnombcliente" value="<?php echo $cliente; ?>" style="width: 100%;" /></td>
                                            <input id="lblidcliente" name="lblidcliente" value="<?php echo $idcliente; ?>" hidden="">
                                            <td style="width:10%"></td>
                                            <td style="width:15%;font-size: 12px">CORREO:</td>
                                            <td style="width:2%"></td>
                                            <td style="width:25%"><input type="text" class="form-control input-sm" id="lblcorreo" value="<?php echo $correo; ?>" name="lblcorreo"></td>
                                        </tr>

                                        <tr class="espacio"></tr>
                                        <tr>
                                            <td style="width:15%;font-size: 12px">DIRECCIÓN:</td>

                                            <td colspan="3" style="width:50%"><textarea class="form-control input-sm" name="lbldireccion" id="lbldireccion" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo $direccion; ?></textarea></td>

                                            <td style="width:2%"></td>
                                            <td style="width:25%"><select class="form-control selectdistrito input-sm" name="lbldistrito" id="lbldistrito" style="width: 100%;">
                                                    <option value="<?php echo $idgeografico; ?>"><?php echo utf8_encode($distrito) . ' - ' . $provincia; ?></option>
                                                </select></td>
                                        </tr>
                                        <tr class="espacio"></tr>
                                        <tr>
                                            <td style="width:15%;font-size: 12px">TELEFONO UNO:</td>

                                            <td style="width:25%"><input type="text" class="form-control input-sm" name="lblmovil" id="lblmovil" value="<?php echo $movil; ?>" onkeypress="return event.charCode >= 48 && event.charCode <= 57" maxlength="9">
                                            </td>
                                            <td style="width:10%"></td>
                                            <td style="width:15%;font-size: 12px">TELEFONO DOS:</td>
                                            <td style="width:2%"></td>
                                            <td style="width:25%"><input type="text" class="form-control input-sm" name="lblfijo" id="lblfijo" value="<?php echo $fijo; ?>" onkeypress="return event.charCode >= 48 && event.charCode <= 57" maxlength="9">
                                            </td>
                                        </tr>
                                        <tr class="espacio"></tr>

                                        <tr>
                                            <td style="width:15%;font-size: 12px">PRECIO KIT:</td>

                                            <td style="width:25%">
                                                <div class="input-group">
                                                    <div class="input-group-addon input-sm">
                                                        <i class="">S/.</i>
                                                    </div>
                                                    <input type="text" class="form-control input-sm" name="lblpreciokit" id="lblpreciokit" value="<?php echo $preciokit; ?>" onkeypress="return filterFloat(event, this);" disabled>
                                                </div>
                                            </td>
                                            <td style="width:10%"></td>
                                            <td style="width:15%;font-size: 12px">TOTAL EXTRA:</td>
                                            <td style="width:2%"></td>
                                            <td style="width:25%">
                                                <div class="input-group">
                                                    <div class="input-group-addon input-sm">
                                                        <i class="">S/.</i>
                                                    </div>
                                                    <input type="text" class="form-control input-sm" name="lbltotalextra" id="lbltotalextra" value="<?php echo $totalextra; ?>" onkeypress="return filterFloat(event, this);" disabled>
                                                </div>



                                            </td>
                                        </tr>
                                        <tr class="espacio"></tr>
                                        <tr>
                                            <td style="width:15%;font-size: 12px">RESUMEN INST.:</td>

                                            <td colspan="5" style="width:77%"><textarea class="form-control input-sm" name="lblresumenventa" id="lblresumenventa" rows="1" style="resize:none" placeholder="Ingresar..." disabled><?php echo $resumenventa; ?></textarea></td>

                                        </tr>
                                        <tr class="espacio"></tr>
                                        <tr>
                                            <td style="width:15%;font-size: 12px">REGALO AUTORIZADO:</td>

                                            <td style="width:25%;font-size: 12px"><select class="form-control input-sm" name="lblextraautorizado" id="lblextraautorizado" disabled>
                                                    <option>Seleccione</option>
                                                    <option value="Ninguno" <?php if ($regaloutorizado == "Ninguno") {
                                                                                echo "selected";
                                                                            } ?>>Ninguno</option>
                                                    <option value="Mando a distancia" <?php if ($regaloutorizado == "Mando a distancia") {
                                                                                            echo "selected";
                                                                                        } ?>>Mando a distancia</option>
                                                    <option value="Magnetico" <?php if ($regaloutorizado == "Magnetico") {
                                                                                    echo "selected";
                                                                                } ?>>Magnetico</option>
                                                    <option value="Pulsador" <?php if ($regaloutorizado == "Pulsador") {
                                                                                    echo "selected";
                                                                                } ?>>Pulsador</option>


                                                </select>
                                            </td>
                                            <td style="width:10%"></td>
                                            <td style="width:15%;font-size: 12px">FORMA DE PAGO:</td>
                                            <td style="width:2%"></td>
                                            <td style="width:25%">
                                                <select class="form-control input-sm" name="lblformadepago" id="lblformadepago" disabled>
                                                    <option value="">Seleccione</option>
                                                    <option value="Cheque" <?php if ($formadepago == "Cheque") {
                                                                                echo "selected";
                                                                            } ?>>Cheque</option>
                                                    <option value="Deposito" <?php if ($formadepago == "Deposito") {
                                                                                    echo "selected";
                                                                                } ?>>Depósito</option>
                                                    <option value="Transferencia" <?php if ($formadepago == "Transferencia") {
                                                                                        echo "selected";
                                                                                    } ?>>Transferencia</option>
                                                    <option value="TransferenciaInterbancaria" <?php if ($formadepago == "TransferenciaInterbancaria") {
                                                                                                    echo "selected";
                                                                                                } ?>>Transferencia Interbancaria</option>
                                                    <option value="PagoPOSVisa" <?php if ($formadepago == "PagoPOSVisa") {
                                                                                    echo "selected";
                                                                                } ?>>Pago POSVisa</option>
                                                    <option value="PagoPOSMC" <?php if ($formadepago == "PagoPOSMC") {
                                                                                    echo "selected";
                                                                                } ?>>Pago POSMC</option>
                                                    <option value="TarjetadeCredito" <?php if ($formadepago == "TarjetadeCredito") {
                                                                                            echo "selected";
                                                                                        } ?>>Tarjeta de Crédito</option>
                                                    <option value="PagoPasarella" <?php if ($formadepago == "PagoPasarella") {
                                                                                        echo "selected";
                                                                                    } ?>>Pago Pasarella</option>
                                                </select>
                                            </td>
                                        </tr>
                                        <tr class="espacio"></tr>
                                        <tr>
                                            <td style="width:15%;font-size: 12px">590:</td>

                                            <td style="width:25%">
                                                <div class="input-group">
                                                    <div class="input-group-addon input-sm">
                                                        <i class="fa fa-calendar"></i>
                                                    </div>
                                                    <input type="text" class="form-control pull-right input-sm" id="mesano" data-role="date" value="<?php if (isset($n590)) {
                                                                                                                                                        echo $n590;
                                                                                                                                                    } else {
                                                                                                                                                        echo $fechames;
                                                                                                                                                    } ?>" name="lbl590" readonly="readonly" disabled>
                                                </div>
                                            </td>
                                            <td style="width:10%"></td>
                                            <td style="width:15%;font-size: 12px">PAI:</td>
                                            <td style="width:2%"></td>
                                            <td style="width:25%"><select class="form-control input-sm" name="lblPAI" id="lblPAI" disabled>
                                                    <option>Seleccione</option>
                                                    <option value="BBVA-DIN" <?php if ($PAI == "BBVA-DIN") {
                                                                                    echo "selected";
                                                                                } ?>>BBVA-DIN</option>
                                                    <option value="PAI 30x36" <?php if ($PAI == "PAI 30x36") {
                                                                                    echo "selected";
                                                                                } ?>>PAI 30x36</option>
                                                    
                                                    <option value="PAI 30x48" <?php if ($PAI == "PAI 30x48") {
                                                                                    echo "selected";
                                                                                } ?>>PAI 30x48</option>
                                                                                
                                                    <option value="NO" <?php if ($PAI == "NO") {
                                                                            echo "selected";
                                                                        } ?>>NO</option>

                                                </select>
                                            </td>
                                        </tr>
                                        <tr class="espacio"></tr>

                                        <tr>

                                            <td style="width:15%;font-size: 12px">HOJA CERTIFICACIÓN:</td>

                                            <td style="width:25%;"><input type="checkbox" name="hojacertificacion" id="hojacertificacion" <?php if ($hojacertificacion == "SI") {
                                                                                                                                                echo 'checked';
                                                                                                                                            } else {
                                                                                                                                                echo '';
                                                                                                                                            } ?> data-size="small" />

                                                <input type="hidden" name="hidden_hojacertificacion" id="hidden_hojacertificacion" value="<?php echo $hojacertificacion; ?>">
                                            </td>

                                            <td style="width:10%"></td>
                                            <td style="width:15%;font-size: 12px">CERTIFICADO VALIDADO:</td>
                                            <td style="width:2%"></td>
                                            <td style="width:25%"><input type="checkbox" name="certificadovalidado" id="certificadovalidado" <?php if ($certificadovalidado == "SI") {
                                                                                                                                                    echo 'checked';
                                                                                                                                                } else {
                                                                                                                                                    echo '';
                                                                                                                                                } ?> data-size="small" />


                                                <input type="hidden" name="hidden_certificadovalidado" id="hidden_certificadovalidado" value="<?php echo $certificadovalidado; ?>">
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                                <!-- /.box-body -->

                            </div>

                            <!-- INFORMACION DE NUEVA CERTIFICACION -->
                            <div class="box box-custom">
                                <input type="hidden" id="idcertventa" value="<?php if (isset($idcertventa)) {
                                                                                    echo $idcertventa;
                                                                                } else {
                                                                                } ?>">
                                <input type="hidden" id="lblpermiso" value="<?php echo $nombacceso; ?>">
                                <input type="hidden" id="idVenta" value="<?php echo $idventa; ?>">
                                <input type="hidden" id="estadoVenta" value="<?php echo $estadoventa; ?>">
                                <input type="hidden" id="categoriaVenta" value="<?php echo $categoriaventa; ?>">
                                <input type="hidden" id="tipoVenta" value="<?php echo $tipoventa; ?>">
                                <input type="hidden" id="FechaPendiente" value="<?php echo $FechaPendiente; ?>">
                                <input type="hidden" id="FechaPrimeraGestion" value="<?php echo $FechaPrimeraGestion; ?>">
                                <input type="hidden" id="FechaFinalizadoconIncidencia" value="<?php echo $FechaFinalizadoconIncidencia; ?>">
                                <input type="hidden" id="FechaResuelto" value="<?php echo $FechaResuelto; ?>">
                                

                                <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                    <h5>INFORMACION DE CERTIFICACIÓN VENTA</h5>

                                    <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                        </button>
                                    </div>
                                </div>
                                <!-- /.box-header -->
                                <div class="box-body">
                                    <div class="form-horizontal">
                                    <div class="box box-custom">
                                    
                                        <div class="box-header with-border">
                                            <label class="col-sm-4 col-xs-4 subtitulo" style="text-align:left;font-size: 12px;" for="">RESUMEN VENTAS:</label>
                                            <div class="box-tools pull-right">
                                               <a class="btn btn-nuevo btn-sm" id="btnGuardarResumenVenta" href="#" style="border-radius: 40px;"><i class="fa fa-save"></i> Guardar Resumen Venta</a>
                                            </div>
                                        </div>
                                        <!-- /.box-header -->
                                        <div class="box-body">
                                            <div class="form-horizontal" style="padding: 20px;">
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                   <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblasignado">MATRICULA ASIGNADA:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <select class="form-control selectgestor input-sm" name="lblasignado" id="lblasignado" style="width: 100%;">
                                                                    <?php echo $htmlGestor; ?>></php>
                                                                </select>
                                                                <input type="hidden" id="hidlblasignadoCert" value="<?php echo $GestorCertVenta; ?>">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechaapertura_cert">FECHA DE ASIGNACIÓN:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <div class="input-group" id="fi">
                                                                    <div class="input-group-addon input-sm">
                                                                        <i class="fa fa-calendar"></i>
                                                                    </div>
                                                                    <input type="text" class="form-control pull-right input-sm" id="lblfechaapertura_cert" value="<?php echo $FechaApertura; ?>" name="lblfechaapertura_cert" disabled>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>                                            
                                                </div>                                                
                                                <div class="form-group" style="margin-bottom: 0px;">
        
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lbltipocierre_cert">ESTADO DE CERTIFICACIÓN:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <select class="form-control input-sm" name="lbltipocierre_cert" id="lbltipocierre_cert">
                                                                    <option value="">Seleccione</option>
                                                                </select>
                                                                <input type="hidden" id="hidlbltipocierre_cert" value="<?php echo $TipoCierre; ?>">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblsolucionincidencia_cert"><span class="motivocierretc">ESTADO DE INCIDENCIA</span></label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <select class="form-control input-sm motivocierretc" name="lblsolucionincidencia_cert" id="lblsolucionincidencia_cert">
                                                                    <option value="">Seleccione</option>
                                                                </select>
                                                                <input type="hidden" id="hidlblsolucionincidencia_cert" value="<?php echo $SolucionIncidencia; ?>">
                                                                <select class="form-control input-sm" name="lblmotivoincidencia_cert" id="lblmotivoincidencia_cert" style="display:none">
                                                                    <option value="">Seleccione</option>
                                                                </select>
                                                                <input type="hidden" id="hidlblmotivoincidencia_cert" value="<?php echo $MotivoIncidencia; ?>">
                                                            </div>
                                                        </div>
                                                    </div>                                            
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
        
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechanacimiento">FECHA NACIMIENTO:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                            

                                                                <div class="input-group" id="fi">
                                                                    <div class="input-group-addon input-sm">
                                                                        <i class="fa fa-calendar"></i>
                                                                    </div>
                                                                    <input type="text" class="form-control pull-right input-sm" id="lblfechanacimiento" name="lblfechanacimiento" value="<?php echo $FechaNacimiento; ?>" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask>
                                                                </div>                                                                
                                                                
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblsolucionincidencia_cert">TIPO DE GÉNERO</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <select class="form-control input-sm" name="lbltipogenero" id="lbltipogenero">
                                                                    <option value="">Seleccione</option>
                                                                    <option value="Masculino" <?php if($Tipogenero=="Masculino"){echo 'selected';}?>>Masculino</option>
                                                                    <option value="Femenino" <?php if($Tipogenero=="Femenino"){echo 'selected';}?>>Femenino</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>                                            
                                                </div>                                                
        
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 subtitulo" style="text-align:left;color:red;font-size: 12px;" for="btnModalProductosC">MOTIVO INCIDENCIAS (*):</label>
                                                            <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                                                               	<button type="button" class="btn btn-danger btn-sm" id="btnModalProductosC" style="border-radius: 40px;">
                    										    <i class="fa fa-cart-plus"></i> Añadir
                    								    	    </button>
                    								    	    <input type="hidden" id="datosIncidencia" value='<?php echo $jsonIncidencias; ?>'>
                                                            </div>
                                                        </div>
                                                    </div>                                          
        
                                                    <div class="col-sm-6 col-md-6 hidden">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblformapago_cert">FORMA PAGO:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <select class="form-control input-sm" name="lblformapago_cert" id="lblformapago_cert">
                                                                    <option value="">Seleccione</option>
                                                                    <option value="Validada">Validada</option>
                                                                    <option value="Pendiente">Pendiente</option>
                                                                    <option value="Modificada">Modificada</option>
                                                                    <option value="Incidencia">Incidencia</option>
                                                                </select>
                                                                <input type="hidden" id="hidlblformapago_cert" value="<?php echo $FormaPagoCert; ?>">
                                                                <input type="hidden" name="hidden_inci_tecnica" id="hidden_inci_tecnica" value="<?php echo $inci_tecnica; ?>">
                                                            </div>
                                                        </div>
                                                    </div>                                            
                                                </div>
        
                                    
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                    <div class="col-md-12 table-responsive p-0">
                    									<table class="table table-hover text-nowrap" id="tbdatos">
                    										<thead>
                    											<tr>
                    												<th>#</th>
                    												<th>Motivo</th>
                    												<th>SubMotivo</th>
                    												<th>Fecha Incidencia</th>
                    												<th>¿Resuelta?</th>
                    												<th>Fecha Solucion</th>
                    												<th>Opciones</th>
                    											</tr>
                    										</thead>
                    										<tbody>
                    										</tbody>
                    									</table>
                    								</div>
                                                </div>        
                                            </div>
                                        </div>
                                        <!-- /.box-body -->
                                    </div>
                                    <div class="box box-custom">
                                    
                                        <div class="box-header with-border">
                                            <label class="col-sm-4 col-xs-4 subtitulo" style="text-align:left;font-size: 12px;" for="btnModalGestionC">RESUMEN GESTIÓN:</label>
                                            <div class="box-tools pull-right">
                                                        <button type="button" class="btn btn-nuevo btn-sm" id="btnModalGestionC" style="border-radius: 40px;">
            										    <i class="fa fa-plus"></i> Agregar Gestión
            								    	    </button>
                                                        <a class="btn btn-default btn-sm" href="#" data-toggle="modal" id="logcambios_cert" data-target="#modal-default-cert" style="border-radius: 40px;"><i class="fa fa-pencil-square-o"></i> Historial</a>
                                            </div>
                                        </div>
                                        <!-- /.box-header -->
                                        <div class="box-body">
                                            <div class="form-horizontal" style="padding: 20px;">
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblnumerollamadas">NRO LLAMADAS:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <input type="text" class="form-control pull-right input-sm" id="lblnumerollamadas" name="lblnumerollamadas" value="<?php echo $numerollamadas; ?>" disabled>
                                                            </div>
                                                        </div>
                                                    </div>                                          
                                                </div>

                                                <div class="form-group" style="margin-bottom: 0px;">
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblestadollamada">ESTADO DE LLAMADA:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <input type="text" class="form-control pull-right input-sm" id="lblestadollamada" name="lblestadollamada" value="<?php echo $EstadoLlamada; ?>" disabled>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechaultimallamada">FECHA ULTIMA LLAMADA:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <div class="input-group" id="fi">
                                                                    <div class="input-group-addon input-sm">
                                                                        <i class="fa fa-calendar"></i>
                                                                    </div>
                                                                    <input type="text" class="form-control pull-right input-sm" id="lblfechaultimallamada" value="<?php echo $FechaUltimaGestion; ?>" name="lblfechaultimallamada" disabled>
                                                                    <input type="hidden" id="lblfechacierre_cert" value="<?php echo $FechaCierre; ?>" name="lblfechacierre_cert">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblestadollamada">FECHA HORA PROGRAMACIÓN:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <input type="text" class="form-control pull-right input-sm" id="lblfechahoraprogramacion" name="lblfechahoraprogramacion" value="<?php echo $FechaHoraProgramacion; ?>" disabled>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                </div>                                                
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                    <div class="col-sm-6 col-md-8">
                                                        <div class="form-group">
                                                            <label class="col-md-3 col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcomentario_cert"><span style="color:#2c3b41">COMENTARIO:</span></label>
                                                            <div class="col-md-9 col-sm-8 col-xs-8">
                                                                <textarea class="form-control input-sm" name="lblcomentario_cert" id="lblcomentario_cert" rows="3" style="resize:none" placeholder="Ingresar..." disabled><?php echo $ComentarioGestion; ?></textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>


                                                
                                                
                                            </div>
                                        </div>
                                        <!-- /.box-body -->
                                    </div>                                    
 
                                    <div class="box box-custom">
                                        
                                            <div class="box-header with-border">
                                                <label class="col-sm-4 col-xs-4 subtitulo" style="text-align:left;font-size: 12px;" for="btnModalGestionC">RESUMEN COMERCIAL:</label>
                                                <div class="box-tools pull-right">
                                                    <button type="button" class="btn btn-nuevo btn-sm ocultar" id="btnModalRespuestaC" style="border-radius: 40px;">
            										    <i class="fa fa-plus"></i> Agregar Respuesta
            								    	    </button>                                                    
                                                    <a class="btn btn-default btn-sm" href="#" data-toggle="modal" id="logcambios_comentario_comercial" data-target="#modal-comentario_comercial" style="border-radius: 40px;"><i class="fa fa-pencil-square-o"></i> Log Comentario</a>
                                                </div>
                                            </div>
                                            <!-- /.box-header -->
                                            <div class="box-body">
                                                <div class="form-horizontal" style="padding: 20px;">
                                                  
                                                    <div class="form-group" style="margin-bottom: 0px;">
                                                        <div class="col-sm-6 col-md-8">
                                                            <div class="form-group">
            
                                                                <label class="col-md-3 col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcomentario_comercial"><span style="color:#2c3b41">RESPUESTA COMERCIAL:</span></label>
                                                                <div class="col-md-9 col-sm-8 col-xs-8">
                                                                    <textarea class="form-control input-sm" name="lblcomentario_comercial" id="lblcomentario_comercial" rows="3" style="resize:none" placeholder="Ingresar..." disabled><?php echo $ComentarioComercial; ?></textarea>
                                                                </div>
                                                            </div>
                                                        </div>
     
                                                    </div>                                        
            
                                                    <div class="form-group" style="margin-bottom: 0px;">
    
                                                        <div class="col-sm-6 col-md-6">
                                                            <div class="form-group">
                                                                <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lbltipocierre_cert">HORARIO SUGERIDO:</label>
                                                                <div class="col-sm-8 col-xs-8">
                                                                    <select class="form-control input-sm" name="lblhorariosugerido2" id="lblhorariosugerido2" disabled>
                                                                        <option>Seleccione</option>
                                                                        <option value="9:00 am - 12 pm" <?php if ($nuevohorarioSugerido=='9:00 am - 12 pm') {echo "selected";} ?>>9:00 am - 12 pm</option>
                                                                        <option value="12:00 pm - 3:00 pm" <?php if ($nuevohorarioSugerido=='12:00 pm - 3:00 pm') {echo "selected";} ?>>12:00 pm - 3:00 pm</option>
                                                                        <option value="3:00 pm - 6:00 pm" <?php if ($nuevohorarioSugerido=='3:00 pm - 6:00 pm') {echo "selected";} ?>>3:00 pm - 6:00 pm</option>
                                                                    </select>  
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div> 
                                                    
                                                    
                                                </div>
                                            </div>
                                            <!-- /.box-body -->
                                        </div>  
                                        
                                    </div>

                                </div>
                                <!-- /.box-body -->
                            </div>

                            <div class="box box-custom">
                                <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                    <h5>INFORMACION DE AGENDA</h5>

                                    <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                        </button>

                                    </div>
                                </div>
                                <!-- /.box-header -->
                                <div class="box-body">
                                    <table cellspacing="0" style="width:100%;border-collapse: separate;padding: 20px;">
                                        <tr>
                                            <td style="width:15%;font-size: 12px">INSTALADOX:</td>

                                            <td style="width:25%"><select class="form-control input-sm" name="lblinstaladox" id="lblinstaladox">
                                                    <option>Seleccione</option>
                                                    <option value="TEC" <?php if ($instaladox == "TEC") {
                                                                            echo "selected";
                                                                        } ?>>TEC</option>
                                                    <option value="DEL" <?php if ($instaladox == "DEL") {
                                                                            echo "selected";
                                                                        } ?>>DEL</option>
                                                </select>

                                                <input id="lblidagenda" name="lblidagenda" value="<?php echo $idagenda; ?>" hidden="">
                                            </td>
                                            <td style="width:10%"></td>
                                            <td style="width:15%;font-size: 12px">TÉCNICO:</td>
                                            <td style="width:2%"></td>
                                            <td style="width:25%">
                                                <select name="lbltecnico" id="lbltecnico" class="form-control cbxtecnico input-sm" style="width: 100%;">
                                                    <?php echo $html_tecnico; ?>
                                                </select>
                                            </td>
                                        </tr>
                                        <tr class="espacio"></tr>


                                        <tr>
                                            <td style="width:15%;font-size: 12px">F.INSTALACIÓN:</td>

                                            <td style="width:25%">
                                                <div class="input-group" id="fi">
                                                    <div class="input-group-addon input-sm">
                                                        <i class="fa fa-calendar"></i>
                                                    </div>
                                                    <input type="text" class="form-control pull-right input-sm" id="fechainst" value="<?php echo $fechainstalacionver; ?>" name="lblfinstalacion" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask>
                                                </div>

                                            </td>
                                            <td style="width:10%"></td>
                                            <td style="width:15%;font-size: 12px">H.INSTALACIÓN:</td>
                                            <td style="width:2%"></td>

                                            <td style="width:25%">


                                                <div class="bootstrap-timepicker timepicker">
                                                    <div class="input-group">
                                                        <input type="text" class="form-control input-sm" placeholder="12:00 AM" name="lblhinstalacion" id="horainst" value="<?php echo $horainstalacionver; ?>">
                                                        <div class="input-group-addon input-sm">
                                                            <i class="fa fa-clock-o"></i>
                                                        </div>
                                                    </div>
                                                </div>


                                            </td>
                                        </tr>
                                        <tr class="espacio"></tr>
                                        <tr>
                                            <td style="width:15%;font-size: 12px">REPERCUCIÓN:</td>
                                            <td colspan="3" style="width:50%"><textarea class="form-control input-sm" name="lblrepercucion" id="lblrepercucion" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo $repercucion; ?></textarea></td>
                                            <td style="width:2%"></td>
                                            <td style="width:25%"><a class="btn btn-danger btn-sm" href="#" data-toggle="modal" id="logcambios" data-target="#modal-default"><i class="fa fa-pencil-square-o"></i> Log Cambios</a></td>
                                        </tr>
                                        <tr class="espacio"></tr>

                                        <tr>
                                            <td style="width:15%;font-size: 12px">COMENTARIO:</td>

                                            <td colspan="3" style="width:50%"><textarea class="form-control input-sm" name="lblcomentarioagenda" id="lblcomentarioagenda" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo utf8_encode($comentarioagenda); ?></textarea></td>

                                            <td style="width:2%"></td>
                                            <td style="width:25%"> </td>
                                        </tr>

                                        <tr class="espacio" id="tinviableespacio"></tr>
                                        <tr id="tinviable">
                                            <td style="width:15%;font-size: 12px">MOTIVO INVIABLE:</td>

                                            <td colspan="3" style="width:50%"><textarea class="form-control input-sm" name="lblinviable" id="lblinviable" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo utf8_encode($motivoinviable); ?></textarea></td>

                                            <td style="width:2%"></td>
                                            <td style="width:25%"></td>
                                        </tr>

                                        <tr class="espacio" id="tcanceladoespacio"></tr>
                                        <tr id="tcancelado">
                                            <td style="width:15%;font-size: 12px">MOTIVO CANCELADO:</td>

                                            <td colspan="3" style="width:50%"><textarea class="form-control input-sm" name="lblcancelado" id="lblcancelado" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo $motivocancelado; ?></textarea></td>

                                            <td style="width:2%"></td>
                                            <td style="width:25%"></td>
                                        </tr>

                                    </table>
                                </div>
                                <!-- /.box-body -->

                            </div>



                            <div class="box box-custom">
                                <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                    <h5>INFORMACION DE FACTURACIÓN</h5>

                                    <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                        </button>

                                    </div>
                                </div>
                                <!-- /.box-header -->
                                <div class="box-body">
                                    <table cellspacing="0" style="width:100%;border-collapse: separate;padding: 20px;">

                                        <?php
                                        if ($estadoventa == 'InstaladaDEL' || $estadoventa == 'Instalada' || $estadoventa == 'IncidenciaGestCorreo' || $estadoventa == 'IncidenciaGestValija' || $estadoventa == 'Facturada' || $estadoventa == 'PorFacturar' || $estadoventa == 'DocEnvi'  || $estadoventa == 'Incidencia' || $estadoventa == 'NoDoc') {
                                        ?>
                                            <tr>
                                                <td style="width:15%;font-size: 12px"></td>
                                                <td style="width:25%">
                                                </td>
                                                <td style="width:10%"></td>

                                                <td colspan="3" style="width:42%">
                                                    <label class="label label-danger" style="font-size:12px">ESTADO DE AFILIACION</label>
                                                    <label class="label label-default" style="font-size:12px"><?php if ($estadoafiliacion == "NOREGISTRADO") {
                                                                                                                    echo "RECHAZADO:" . $ACTION_DESCRIPTION;
                                                                                                                } else if ($estadoafiliacion == 'REGISTRADO') {
                                                                                                                    echo 'AFILIADO';
                                                                                                                } else if ($estadoafiliacionmdp == 'ENPROCESO') {
                                                                                                                    echo 'ENPROCESO';
                                                                                                                } else if ($estadoafiliacionmdp == 'AFILIADO') {
                                                                                                                    echo 'AFILIADO';
                                                                                                                } else if ($estadoafiliacionmdp == 'RECHAZADO') {
                                                                                                                    echo "RECHAZADO:" . $motivomdp;
                                                                                                                } else {
                                                                                                                    echo 'PENDIENTE';
                                                                                                                } ?></label>
                                                    <?php if (isset($card) && !empty($card)) { ?>
                                                        <label class="label label-default" style="font-size:12px"><?php echo $tipocuenta . ' ' . $card; ?></label>
                                                    <?php }

                                                    ?>
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                        <?php } ?>


                                        <tr>
                                            <td style="width:15%;font-size: 12px">MOTIVO INCIDENCIA:</td>
                                            <td colspan="7" style="width:77%"><textarea class="form-control input-sm" name="lblmotivoincidencia" id="lblmotivoincidencia" rows="1" style="resize:none" placeholder="Ingresar..." disabled="disabled"><?php echo $factmotivoincidencia; ?></textarea></td>
                                        </tr>
                                        <tr class="espacio"></tr>
                                        <tr>
                                            <td style="width:15%;font-size: 12px">FECHA RECEPCION DOC.:</td>
                                            <td style="width:25%">
                                                <div class="input-group">
                                                    <div class="input-group-addon input-sm">
                                                        <i class="fa fa-calendar"></i>
                                                    </div>
                                                    <input type="text" class="form-control pull-right input-sm" id="lblfecharecpciondoc" name="lblfecharecpciondoc" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask value="<?php echo $factfecharecepciondoc; ?>" disabled="disabled">
                                                </div>
                                            </td>
                                            <td style="width:10%"></td>
                                            <td style="width:15%;font-size: 12px">FECHA DE FACTURACIÓN: <span style="font-size: 12px; color:red ">(*)</span></td>
                                            <td style="width:2%"></td>
                                            <td style="width:25%">
                                                <div class="input-group">
                                                    <div class="input-group-addon input-sm">
                                                        <i class="fa fa-calendar"></i>
                                                    </div>
                                                    <input type="text" class="form-control pull-right input-sm" id="lblfechafacturacion" name="lblfechafacturacion" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask value="<?php echo $factfechafacturacion; ?>" disabled="disabled" />
                                                </div>
                                            </td>
                                        </tr>
                                    </table>

                                    <table cellspacing="0" style="width:100%;border-collapse: separate;padding: 20px">
                                        <tr>
                                            <td style="font-size: 12px; color:red ">MOTIVOS DE INCIDENCIA (*):</td>
                                        </tr>
                                        <tr class="espacio"></tr>
                                        <tr>
                                            <td style="width:8%;font-size: 12px">DOC. ORIGINAL:</td>
                                            <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactdocoriginal" id="lblfactdocoriginal" value="<?php echo $factdocoriginal; ?>" disabled="disabled" /></td>
                                            <td style="width:8%"></td>
                                            <td style="width:8%;font-size: 12px">FALTA DNI:</td>
                                            <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactdni" id="lblfactdni" value="<?php echo $factdni; ?>" disabled="disabled" /></td>
                                            <td style="width:8%"></td>
                                            <td style="width:8%;font-size: 12px">REHACER CTO:</td>
                                            <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactrehacercto" id="lblfactrehacercto" value="<?php echo $factrehacercto; ?>" disabled="disabled" /></td>
                                        </tr>
                                        <tr class="espacio"></tr>
                                        <tr>
                                            <td style="width:8%;font-size: 12px">SEGMENTACIÓN:</td>
                                            <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactsegmentacion" id="lblfactsegmentacion" value="<?php echo $factsegmentacion; ?>" disabled="disabled" /></td>
                                            <td style="width:8%"></td>
                                            <td style="width:8%;font-size: 12px">ELEMENTOS CTO PS:</td>
                                            <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactelementosctops" id="lblfactelementosctops" value="<?php echo $factelementosctops; ?>" disabled="disabled" /></td>
                                            <td style="width:8%"></td>
                                            <td style="width:8%;font-size: 12px">AFILIACION:</td>
                                            <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactafiliacion" id="lblfactafiliacion" value="<?php echo $factafiliacion; ?>" disabled="disabled" /></td>
                                        </tr>
                                        <tr class="espacio"></tr>
                                        <tr>
                                            <td style="width:8%;font-size: 12px">PAGO:</td>
                                            <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactpago" id="lblfactpago" value="<?php echo $factpago; ?>" disabled="disabled" /></td>
                                            <td style="width:8%"></td>
                                            <td style="width:8%;font-size: 12px">DOC PAI:</td>
                                            <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactdocpai" id="lblfactdocpai" value="<?php echo $factdocpai; ?>" disabled="disabled" /></td>
                                            <td style="width:8%"></td>
                                            <td style="width:8%;font-size: 12px">PROSPECTO/NRO GUIA:</td>
                                            <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactprospecto_nroguia" id="lblfactprospecto_nroguia" value="<?php echo $factprospecto_nroguia; ?>" disabled="disabled" /></td>
                                        </tr>
                                        <tr class="espacio"></tr>
                                        <tr>
                                            <td style="width:8%;font-size: 12px">AUTORIZA:</td>
                                            <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactautoriza" id="lblfactautoriza" value="<?php echo $factautoriza; ?>" disabled="disabled" /></td>
                                            <td style="width:8%"></td>
                                            <td style="width:8%;font-size: 12px">FALTA DOC (P.A./CTO):</td>
                                            <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactfaltadoc" id="lblfactfaltadoc" value="<?php echo $factfaltadoc; ?>" disabled="disabled" /></td>
                                            <td style="width:8%"></td>
                                            <td style="width:8%;font-size: 12px">FUERA DE HORA:</td>
                                            <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactfuerahora" id="lblfactfuerahora" value="<?php echo $factfuerahora; ?>" disabled="disabled" /></td>
                                        </tr>
                                    </table>
                                </div>
                                <!-- /.box-body -->

                            </div>

                        </form>




                    </div>





                    <div class="col-md-2"></div>


                </div>

                <div class="modal fade" id="modal-default">
                    <div class="modal-dialog modal-lg">
                        <div class="modal-content">
                            <div class="modal-header modal-header-danger">
                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                <h4>GESTIONES DE AGENDAMIENTO</h4>
                            </div>
                            <div class="modal-body" id="vistaboy">
                                <div id="myGrid" style="height: 100%" class="ag-theme-fresh"></div>
                                <div id="ningunresultado"></div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                            </div>
                        </div>
                    </div>
                    <!-- /.modal-content -->
                </div>
               
        </div>
        

        <div class="modal fade" id="modal-default-cert">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header modal-header-danger">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                        <h4>GESTIONES DE CERTIFICACION DE LA VENTA</h4>
                    </div>
                    <div class="modal-body" id="vistaboy_cert">
                        <div id="myGrid_cert" style="height: 100%" class="ag-theme-fresh"></div>
                        <div id="ningunresultado_cert"></div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                    </div>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>

        <!-- MODAL PRODUCTOS -->
        
        <div class="modal fade" id="modal_productosC">
        	<div class="modal-dialog">
        		<div class="modal-content">
        			<div class="modal-header">
        				 <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
        				<h4 class="modal-title">AÑADIR INCIDENCIAS</h4>
        				
        			</div>
        			<div class="modal-body">
        				<div class="form-group row divvisible">
        					<label for="modalmotivoIncidencia" class="col-lg-3 col-form-label">Motivo<span class="text-danger">*</span></label>
        					<div class="col-12 col-lg-9">
        						<select class="form-control selectItem input-sm" name="modalmotivoIncidencia" id="modalmotivoIncidencia" style="width: 100%;">
        						</select>
        					</div>
        				</div>
        				<div class="form-group row divvisible">
        					<label for="modalsubmotivoIncidencia" class="col-lg-3 col-form-label">SubMotivo <span class="text-danger">*</span></label>
        					<div class="col-12 col-lg-9">
        						<select class="form-control selectItem input-sm" name="modalsubmotivoIncidencia" id="modalsubmotivoIncidencia" style="width: 100%;">
        						</select>
        					</div>
        				</div>
        				<div class="form-group row divbtnEditar" style="display:none">
        					<label for="modalresuelto" class="col-lg-3 col-form-label">¿Resuelto? <span class="text-danger">*</span></label>
        					<div class="col-12 col-lg-9">
        						<select class="form-control selectItem input-sm" name="modalresuelto" id="modalresuelto" style="width: 100%;">
        						    <option value="SI">SI</option>
        						    <option value="NO">NO</option>
        						</select>
        						<input type="hidden" id="modalfechaactual" name="modalfechaactual">
        					</div>
        				</div>        				
        			</div>
        			<div class="modal-footer justify-content-between">
        				<button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
        				<button type="button" class="btn btn-danger" id="btnAgregar" name="btnAgregar"><i class="fa fa-plus"></i>&nbsp Agregar</button>
        				<button type="button" class="btn btn-danger" id="btnEditar" name="btnEditar" style="display:none"><i class="fa fa-edit"></i>&nbsp Editar</button>
        			</div>
        		</div>
        		<!-- /.modal-content -->
        	</div>
        	<!-- /.modal-dialog -->
        </div>
        <!-- /.modal -->        
        

        <!-- MODAL PRODUCTOS -->
        
        <div class="modal fade" id="modal_gestionC">
        	<div class="modal-dialog">
        		<div class="modal-content">
        			<div class="modal-header">
        				 <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
        				<h4 class="modal-title">AÑADIR GESTIÓN</h4>
        			</div>
        			<div class="modal-body">
        				<div class="form-group row divvisible">
        					<label for="modalmotivoIncidencia" class="col-lg-3 col-form-label">ESTADO DE LLAMADA:<span class="text-danger">*</span></label>
        					<div class="col-12 col-lg-9">
                                                        <select class="form-control input-sm" name="modalestadollamada" id="modalestadollamada">
                                                            <option value="">Seleccione</option>
                                                            <option value="ContactoEfectivo">Contacto Efectivo</option>
                                                            <option value="DevolverLlamada">Devolver Llamada</option>
                                                            <option value="NoContesta">No Contesta</option>
                                                            <option value="ProgramacionWhatsapp">Programacion Whatsapp</option>
                                                        </select>
        					</div>
        				</div>
        				<div class="form-group row clRellamada ocultar">
        					<label for="modalsubmotivoIncidencia" class="col-lg-3 col-form-label">FECHA HORA PROGRAMACIÓN: <span class="text-danger">*</span></label>
        					<div class="col-12 col-lg-9">
        					                            <div class='input-group'>
                                                            <input type='text' class="form-control input-sm datetimepicker" id="modalfechahoraRellamada" name="modalfechahoraRellamada" />
                                                            <span class="input-group-addon">
                                                                <span class="glyphicon glyphicon-calendar"></span>
                                                            </span>
                                                        </div>
        					</div>
        				</div>
        				<div class="form-group row">
        					<label for="modalresuelto" class="col-lg-3 col-form-label">COMENTARIO <span class="text-danger">*</span></label>
        					<div class="col-12 col-lg-9">
        						<textarea class="form-control input-sm" name="modalcomentario_cert" id="modalcomentario_cert" rows="3" style="resize:none" placeholder="Ingresar..."></textarea>
        					</div>
        				</div>        				
        			</div>
        			<div class="modal-footer justify-content-between">
        				<button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
        				<button type="button" class="btn btn-danger" id="btnAgregarGestion" name="btnAgregarGestion"><i class="fa fa-plus"></i>&nbsp Agregar</button>
        			</div>
        		</div>
        		<!-- /.modal-content -->
        	</div>
        	<!-- /.modal-dialog -->
        </div>
        <!-- /.modal --> 
        

                <div class="modal fade" id="modal-comentario_comercial">
                    	<div class="modal-dialog modal-lg">
                    		<div class="modal-content">
                    			<div class="modal-header modal-header-danger">
                    				<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    				<h4>HISTORIAL RESPUESTA COMERCIAL</h4>
                    			</div>
                    			<div class="modal-body" id="vistaboy_comentariocertcert">
                    				<div id="myGrid_comentariocertcert"  style="height: 100%" class="ag-theme-fresh"></div>
                    				<div  id="ningunresultado_comentariocert"></div>
                    			</div>
                    			<div class="modal-footer">
                    				<button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                    			</div>
                    		</div>
                    	</div>
                    	<!-- /.modal-content -->
                    </div>                    

                    <!-- MODAL LOG_COMENTARIO -->
                    <div class="modal fade" id="modal_respuestaC">
                    	<div class="modal-dialog">
                    		<div class="modal-content">
                    			<div class="modal-header">
                    				 <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    				<h4 class="modal-title">AÑADIR RESPUESTA COMERCIAL</h4>
                    			</div>
                    			<div class="modal-body">
                    				<div class="form-group row ">
                    					<label for="modalhorariosugerido" class="col-lg-3 col-form-label">HORARIO SUGERIDO:<span class="text-danger">*</span></label>
                    					<div class="col-12 col-lg-9">
                                                                    <select class="form-control input-sm" name="modalhorariosugerido" id="modalhorariosugerido">
                                                                        <option>Seleccione</option>
                                                                        <option value="9:00 am - 12 pm">9:00 am - 12 pm</option>
                                                                        <option value="12:00 pm - 3:00 pm">12:00 pm - 3:00 pm</option>
                                                                        <option value="3:00 pm - 6:00 pm">3:00 pm - 6:00 pm</option>
                                                                    </select>  
                                                   
                    					</div>
                    				</div>
                    				<div class="form-group row">
                    					<label for="modalcomentario_comercial" class="col-lg-3 col-form-label">COMENTARIO: <span class="text-danger">*</span></label>
                    					<div class="col-12 col-lg-9">
                    					      <textarea class="form-control input-sm" name="modalcomentario_comercial" id="modalcomentario_comercial" rows="4" style="resize:none" placeholder="Ingresar...">
                    					          
                    					      </textarea>
                    					</div>
                    				</div>
                    			</div>
                    			<div class="modal-footer justify-content-between">
                    				<button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                    				<button type="button" class="btn btn-danger" id="btnAgregarRespuesta" name="btnAgregarRespuesta"><i class="fa fa-plus"></i>&nbsp Agregar</button>
                    			</div>
                    		</div>
                    		<!-- /.modal-content -->
                    	</div>
                    	<!-- /.modal-dialog -->
                    </div>
                    <!-- /.modal -->  
        
        
    </div>
   


    </section>
    <!-- /.content -->






    </div>
    <!-- /.content-wrapper -->



    <div class="control-sidebar-bg"></div>
    </div>
    <!-- ./wrapper -->





    <!-- jQuery v1.11 -->

    <script src="admin/bower_components/jquery/dist/jquery_v1.11.js" type="text/javascript"></script>

    <!-- jQuery UI 1.11.4 -->
    <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
    <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <!-- Bootstrap 3.3.7 -->
    <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
    <!-- Select2 -->
    <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
    <!-- Sparkline -->
    <script src="admin/bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>

    <!-- Slimscroll -->
    <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
    <!-- FastClick -->
    <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
    <!-- AdminLTE App -->
    <script src="admin/dist/js/adminlte.min.js"></script>

    <script src="admin/bower_components/ag-grid-master/dist/ag-grid.min.js" type="text/javascript"></script>

    <!-- InputMask -->
    <script src="admin/plugins/input-mask/jquery.inputmask.js"></script>
    <script src="admin/plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
    <script src="admin/plugins/input-mask/jquery.inputmask.extensions.js"></script>

    <script src="admin/plugins/bootstrap-toggle-master/js/bootstrap-toggle.min.js"></script>

    <!-- date-range-picker -->
    <script src="admin/bower_components/moment/min/moment.min.js"></script>
    <!-- bootstrap datepicker -->
    <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
    <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/4.17.37/js/bootstrap-datetimepicker.min.js"></script>
    <!-- bootstrap time picker -->
    <script src="admin/plugins/timepicker/bootstrap-timepicker.min.js" type="text/javascript"></script>

    <!-- Alertify -->
    <script src="admin/bower_components/alertifyjs/alertify.min.js" type="text/javascript"></script>
    <!-- SweetAlert -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
		<!--GLOBALES -->
		<script>
			//ARREGLO DE DATOS QUE CONTIENE LA LISTA DE EXTRAS
			let arregloDatos = [];

		</script>  
    <script>
        var columnDefs = [{
                headerName: 'FechaHoraREG',
                field: 'FechaHoraREG',
                width: 140
            },
            {
                headerName: 'FechaInst',
                field: 'FechaInst',
                width: 130,
                pinned: 'left'
            },
            {
                headerName: 'HoraInst',
                field: 'HoraInst',
                width: 105,
                pinned: 'left'
            },
            {
                headerName: 'InstaladoX',
                field: 'InstaladoX',
                width: 100
            },
            {
                headerName: 'MatriculaTec',
                field: 'MatriculaTec',
                width: 110
            },
            {
                headerName: 'Repercusion',
                field: 'Repercusion',
                width: 130
            },
            {
                headerName: 'MotivoInviable',
                field: 'MotivoInviable',
                width: 150
            },
            {
                headerName: 'Comentario',
                field: 'Comentario',
                width: 200
            },
            {
                headerName: 'EstadoVenta',
                field: 'EstadoVenta',
                width: 120
            },
            {
                headerName: 'Gestor',
                field: 'GestorAgenda',
                width: 120
            }
        ];

        var gridOptions = {
            columnDefs: columnDefs,
            rowData: null,
            enableFilter: true,
            enableColResize: true,
            localeText: {
                // for filter panel
                page: 'página',
                more: 'Más',
                to: 'a',
                of: 'de',
                next: 'Siguiente',
                last: 'Último',
                first: 'Primero',
                previous: 'Anterior',
                loadingOoo: 'Cargando...',
                // for set filter
                selectAll: 'Seleccionar todo',
                searchOoo: 'Buscando...',
                blanks: 'Espacios en blanco',
                // for number filter and text filter
                filterOoo: 'Filtrar...',
                applyFilter: 'Aplicar Filtro',
                // for number filter
                equals: 'Igual',
                notEqual: 'No es igual',
                lessThanOrEqual: 'Menor o igual',
                greaterThanOrEqual: 'Mayor que o igual',
                inRange: 'En el rango',
                lessThan: 'Menos que',
                greaterThan: 'Mas grande que',
                // for text filter
                contains: 'Contiene',
                startsWith: 'Comienza con',
                endsWith: 'Termina con',
                notContains: 'No contiene',
                // the header of the default group column
                group: 'Grupo',
                // tool panel
                columns: 'columnas',
                rowGroupColumns: 'Grupo columnas',
                rowGroupColumnsEmptyMessage: 'No hay resultado',
                valueColumns: 'Columna de valor',
                pivotMode: 'Modo pivote',
                groups: 'grupos',
                values: 'valor',
                pivots: 'pivote',
                valueColumnsEmptyMessage: 'No hay resultado',
                pivotColumnsEmptyMessage: 'No hay resultado',
                // other
                noRowsToShow: '<div class="callout callout-danger">\n\
<span class="pull-left">\n\
<img src="admin/dist/img/noresults-img.png" style="width: 70%">\n\
</span>\n\<h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>\n\
<strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>\n\
<p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>\n\
<br></div>'


                    ,
                // enterprise menu
                pinColumn: 'Aclar columna',
                valueAggregation: 'Agregar valor',
                autosizeThiscolumn: 'Auto tamaño esta columna ',
                autosizeAllColumns: 'Auto tamaño todas columnas',
                groupBy: 'Agrupar',
                ungroupBy: 'Agrupar uno',
                resetColumns: 'Restaurar Columnas',
                expandAll: 'expandir todo',
                collapseAll: 'desplegar todo',
                toolPanel: 'Panel de Heramientas',
                export: 'Exportar',
                csvExport: 'Exportar CSV',
                excelExport: 'Exportar Excel',
                // enterprise menu pinning
                pinLeft: 'Anclar a derecha',
                pinRight: 'Anclar a izquierda',
                noPin: 'Desanclar',
                // enterprise menu aggregation and status panel
                sum: 'Sumar',
                min: 'Minimo',
                max: 'Maximo',
                first: 'Primero',
                last: 'Ultimo',
                none: 'Nada',
                count: 'Contador',
                average: 'Promedio',
                // standard menu
                copy: 'Copiar',
                copyWithHeaders: 'Copiar Cabecera',
                ctrlC: 'Ctrl+C',
                paste: 'Pegar',
                ctrlV: 'Ctrl+V'
            },
            enableSorting: true
        };

        var columnDefsCert = [
                        {headerName: 'FechaHoraREG', field: 'FechaHoraRegistro', width: 140},
                        {headerName: 'MatriculaAsignada', field: 'MatriculaAsignada', width: 70},                        
                        {headerName: 'FechaAsignacion', field: 'FechaAsignacion', width: 130},
                        {headerName: 'MatriculaGestor', field: 'MatriculaGestor', width: 130},
                        {headerName: 'EstadoLlamada', field: 'EstadoLlamada', width: 130},
                        {headerName: 'Comentario', field: 'Comentario', width: 130},
                        {headerName: 'FechaHoraProgramacion', field: 'FechaHoraProgramacion', width: 130},
                        {headerName: 'numerollamadas', field: 'numerollamadas', width: 130}
        ];

        var gridOptionsCert = {
            columnDefs: columnDefsCert,
            rowData: null,
            enableFilter: true,
            enableColResize: true,
            localeText: {
                // for filter panel
                page: 'página',
                more: 'Más',
                to: 'a',
                of: 'de',
                next: 'Siguiente',
                last: 'Último',
                first: 'Primero',
                previous: 'Anterior',
                loadingOoo: 'Cargando...',
                // for set filter
                selectAll: 'Seleccionar todo',
                searchOoo: 'Buscando...',
                blanks: 'Espacios en blanco',
                // for number filter and text filter
                filterOoo: 'Filtrar...',
                applyFilter: 'Aplicar Filtro',
                // for number filter
                equals: 'Igual',
                notEqual: 'No es igual',
                lessThanOrEqual: 'Menor o igual',
                greaterThanOrEqual: 'Mayor que o igual',
                inRange: 'En el rango',
                lessThan: 'Menos que',
                greaterThan: 'Mas grande que',
                // for text filter
                contains: 'Contiene',
                startsWith: 'Comienza con',
                endsWith: 'Termina con',
                notContains: 'No contiene',
                // the header of the default group column
                group: 'Grupo',
                // tool panel
                columns: 'columnas',
                rowGroupColumns: 'Grupo columnas',
                rowGroupColumnsEmptyMessage: 'No hay resultado',
                valueColumns: 'Columna de valor',
                pivotMode: 'Modo pivote',
                groups: 'grupos',
                values: 'valor',
                pivots: 'pivote',
                valueColumnsEmptyMessage: 'No hay resultado',
                pivotColumnsEmptyMessage: 'No hay resultado',
                // other
                noRowsToShow: '<div class="callout callout-danger">\n\
<span class="pull-left">\n\
<img src="admin/dist/img/noresults-img.png" style="width: 70%">\n\
</span>\n\<h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>\n\
<strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>\n\
<p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>\n\
<br></div>'


                    ,
                // enterprise menu
                pinColumn: 'Aclar columna',
                valueAggregation: 'Agregar valor',
                autosizeThiscolumn: 'Auto tamaño esta columna ',
                autosizeAllColumns: 'Auto tamaño todas columnas',
                groupBy: 'Agrupar',
                ungroupBy: 'Agrupar uno',
                resetColumns: 'Restaurar Columnas',
                expandAll: 'expandir todo',
                collapseAll: 'desplegar todo',
                toolPanel: 'Panel de Heramientas',
                export: 'Exportar',
                csvExport: 'Exportar CSV',
                excelExport: 'Exportar Excel',
                // enterprise menu pinning
                pinLeft: 'Anclar a derecha',
                pinRight: 'Anclar a izquierda',
                noPin: 'Desanclar',
                // enterprise menu aggregation and status panel
                sum: 'Sumar',
                min: 'Minimo',
                max: 'Maximo',
                first: 'Primero',
                last: 'Ultimo',
                none: 'Nada',
                count: 'Contador',
                average: 'Promedio',
                // standard menu
                copy: 'Copiar',
                copyWithHeaders: 'Copiar Cabecera',
                ctrlC: 'Ctrl+C',
                paste: 'Pegar',
                ctrlV: 'Ctrl+V'
            },
            enableSorting: true
        };

            var columnDefsComentarioCert  = [
                        {headerName: 'FechaHoraREG', field: 'FechaHoraREG', width: 140},
                        {headerName: 'Matricula', field: 'Matricula', width: 70},                        
                        {headerName: 'HorarioSugerido', field: 'HorarioSugerido', width: 130},
                        {headerName: 'Comentario', field: 'Comentario', width: 235}
            ]; 
        
            var gridOptionsComentarioCert = {
                columnDefs: columnDefsComentarioCert,
                rowData: null,
                enableFilter: true,
                enableColResize: true,
                localeText: {
                    // for filter panel
                    page: 'página',
                    more: 'Más',
                    to: 'a',
                    of: 'de',
                    next: 'Siguiente',
                    last: 'Último',
                    first: 'Primero',
                    previous: 'Anterior',
                    loadingOoo: 'Cargando...',
                    // for set filter
                    selectAll: 'Seleccionar todo',
                    searchOoo: 'Buscando...',
                    blanks: 'Espacios en blanco',
                    // for number filter and text filter
                    filterOoo: 'Filtrar...',
                    applyFilter: 'Aplicar Filtro',
                    // for number filter
                    equals: 'Igual',
                    notEqual: 'No es igual',
                    lessThanOrEqual: 'Menor o igual',
                    greaterThanOrEqual: 'Mayor que o igual',
                    inRange: 'En el rango',
                    lessThan: 'Menos que',
                    greaterThan: 'Mas grande que',
                    // for text filter
                    contains: 'Contiene',
                    startsWith: 'Comienza con',
                    endsWith: 'Termina con',
                    notContains:'No contiene',
                    // the header of the default group column
                    group: 'Grupo',
                    // tool panel
                    columns: 'columnas',
                    rowGroupColumns: 'Grupo columnas',
                    rowGroupColumnsEmptyMessage: 'No hay resultado',
                    valueColumns: 'Columna de valor',
                    pivotMode: 'Modo pivote',
                    groups: 'grupos',
                    values: 'valor',
                    pivots: 'pivote',
                    valueColumnsEmptyMessage: 'No hay resultado',
                    pivotColumnsEmptyMessage: 'No hay resultado',
                    // other
                    noRowsToShow: '<div class="callout callout-danger">\n\
        <span class="pull-left">\n\
        <img src="admin/dist/img/noresults-img.png" style="width: 70%">\n\
        </span>\n\<h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>\n\
        <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>\n\
        <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>\n\
        <br></div>',
                    // enterprise menu
                    pinColumn: 'Aclar columna',
                    valueAggregation: 'Agregar valor',
                    autosizeThiscolumn: 'Auto tamaño esta columna ',
                    autosizeAllColumns: 'Auto tamaño todas columnas',
                    groupBy: 'Agrupar',
                    ungroupBy: 'Agrupar uno',
                    resetColumns: 'Restaurar Columnas',
                    expandAll: 'expandir todo',
                    collapseAll: 'desplegar todo',
                    toolPanel: 'Panel de Heramientas',
                    export: 'Exportar',
                    csvExport: 'Exportar CSV',
                    excelExport: 'Exportar Excel',
                    // enterprise menu pinning
                    pinLeft: 'Anclar a derecha',
                    pinRight: 'Anclar a izquierda',
                    noPin: 'Desanclar',
                    // enterprise menu aggregation and status panel
                    sum: 'Sumar',
                    min: 'Minimo',
                    max: 'Maximo',
                    first: 'Primero',
                            last: 'Ultimo',
                            none: 'Nada',
                    count: 'Contador',
                    average: 'Promedio',
                    // standard menu
                    copy: 'Copiar',
                    copyWithHeaders: 'Copiar Cabecera',
                    ctrlC: 'Ctrl+C',
                    paste: 'Pegar',
                    ctrlV: 'Ctrl+V'
                },
                enableSorting: true
            };  


        function onFilterChanged(value) {
            gridOptions.api.setQuickFilter(value);
            gridOptionsCert.api.setQuickFilter(value);
        }

        function listar() {
            var idventa = $("#idVenta").val();
            $.ajax({
                url: 'ajax/findDataHisAgenda.php?idventa=' + idventa,
                success: function(data) {

                    if (data == 1) {
                        var gridDiv = document.querySelector('#myGrid');
                        new agGrid.Grid(gridDiv, gridOptions);

                        agGrid.simpleHttpRequest({
                            url: 'ajax/selectListarHistAgenda.php?idventa=' + idventa
                        }).then(function(data) {

                            gridOptions.api.setRowData(data);
                        });
                        $('#vistaboy').height(function(index, height) {

                            return $(window).height() * 35 / 100;
                        });

                    } else {

                        $("#ningunresultado").html(data);

                        var gridDiv = document.querySelector('#myGrid');
                        new agGrid.Grid(gridDiv, gridOptions);

                        agGrid.simpleHttpRequest({
                            url: 'ajax/selectListarHistAgenda.php?idventa=' + idventa
                        }).then(function(data) {

                            gridOptions.api.setRowData(data);
                        });



                        $('#myGrid').hide("fast");

                    }





                }
            });
        }
        var refresh = function() {
            var idventa = $("#idVenta").val();
            $.ajax({
                url: 'ajax/findDataHisAgenda.php?idventa=' + idventa,
                success: function(data) {

                    if (data == 1) {

                        var gridDiv = document.querySelector('#myGrid');
                        agGrid.simpleHttpRequest({
                            url: 'ajax/selectListarHistAgenda.php?idventa=' + idventa
                        }).then(function(data) {
                            gridOptions.api.setRowData(data);
                        });
                        $('#vistaboy').height(function(index, height) {

                            return $(window).height() * 35 / 100;
                        });
                        $("#ningunresultado").hide("fast");
                        $('#myGrid').show(200);
                    } else {

                        $("#ningunresultado").html(data);
                        $('#myGrid').hide("fast");

                    }





                }
            });

        }

       

        function listarCert() {
            var gridDiv = document.querySelector('#myGrid_cert');
            new agGrid.Grid(gridDiv, gridOptionsCert);
        } 

var refresh_cert = function () {
                var idventa=$("#idcertventa").val();

                    var datos = {
                        array:'array8',
                        idventa: idventa
                    };            
                
                $.ajax({
                    type: 'POST',
                    url: './Controller/ControllerVenta.php',
    	            data: {function: JSON.stringify(datos)}, 
                    dataType: "Json",
                    success: function (data) {
    
                        if(data.length>0){
                                var gridDiv = document.querySelector('#myGrid_cert');
                                gridOptionsCert.api.setRowData(data);
                                $('#vistaboy_cert').height(function (index, height) {
                                    return $(window).height() * 35 / 100;
                                });
                                $("#ningunresultado_cert").hide("fast");
                                $('#myGrid_cert').show(200);                
                        }else{
                                $("#ningunresultado_cert").html(`
                                    <div class="callout bg-gray">
                                        <span class="pull-left">
                                          <img src="admin/dist/img/noresults-img.png" style="width: 70%">
                                        </span>
                                          <h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>
                                        <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>
                                        <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>
                                        <br>
                                    </div>                        
                                `);
                                $('#myGrid_cert').hide("fast");                
                        }
                    }
                });
                
        
            }     

        function listarComentarioCert() {
            var gridDiv = document.querySelector('#myGrid_comentariocertcert');
            new agGrid.Grid(gridDiv, gridOptionsComentarioCert);
        } 
        var refresh_comenariocert = function () {
                var idventa=$("#idVenta").val();
    
                    var datos = {
                        array:'array6',
                        idventa: idventa
                    };            
                
                $.ajax({
                    type: 'POST',
                    url: './Controller/ControllerVenta.php',
    	            data: {function: JSON.stringify(datos)}, 
                    dataType: "Json",
                    success: function (data) {
    
                        if(data.length>0){
                                var gridDiv = document.querySelector('#myGrid_comentariocertcert');
                                gridOptionsComentarioCert.api.setRowData(data);
                                $('#vistaboy_comentariocertcert').height(function (index, height) {
                                    return $(window).height() * 35 / 100;
                                });
                                $("#ningunresultado_comentariocert").hide("fast");
                                $('#myGrid_comentariocertcert').show(200);                
                        }else{
                                $("#ningunresultado_comentariocert").html(`
                                    <div class="callout bg-gray">
                                        <span class="pull-left">
                                          <img src="admin/dist/img/noresults-img.png" style="width: 70%">
                                        </span>
                                          <h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>
                                        <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>
                                        <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>
                                        <br>
                                    </div>                        
                                `);
                                $('#myGrid_comentariocertcert').hide("fast");                
                        }
                    }
                });
                
        
            }           
        // setup the grid after the page has finished loading
        document.addEventListener('DOMContentLoaded', function() {

            listar();
            listarCert();
            listarComentarioCert();

        });
    </script>


    <script>
        $(function() {

            $("#lbldc").change(function() {
                $("#lbldc option:selected").each(function() {
                    var lbldc = $(this).val();
                    $.post("./ajax/selectJefeVenta.php", {
                        lbldc: lbldc
                    }, function(data) {
                        $("#lbljefeventa").html(data);
                    });
                });

            });

            $("#lblinstaladox").change(function() {
                $("#lblinstaladox option:selected").each(function() {
                    var lblinstaladox = $(this).val();
                    $.post("./ajax/selectTecnico.php", {
                        lblinstaladox: lblinstaladox
                    }, function(data) {
                        $("#lbltecnico").html(data);
                    });
                });

            });



            $('#hojacertificacion').bootstrapToggle({
                on: 'SI',
                off: 'NO',
                onstyle: 'success',
                offstyle: 'danger'
            });

            $('#hojacertificacion').change(function() {
                if ($(this).prop('checked')) {
                    $('#hidden_hojacertificacion').val('SI');
                } else {
                    $('#hidden_hojacertificacion').val('NO');
                }
            });

            $('#inci_tecnica').bootstrapToggle({
                on: 'SI',
                off: 'NO',
                onstyle: 'success',
                offstyle: 'danger'
            });

            $('#inci_tecnica').change(function() {
                if ($(this).prop('checked')) {
                    $('#hidden_inci_tecnica').val('SI');
                } else {
                    $('#hidden_inci_tecnica').val('NO');
                }
            });

            $('#certificadovalidado').bootstrapToggle({
                on: 'SI',
                off: 'NO',
                onstyle: 'success',
                offstyle: 'danger'
            });

            $('#certificadovalidado').change(function() {
                if ($(this).prop('checked')) {
                    $('#hidden_certificadovalidado').val('SI');
                } else {
                    $('#hidden_certificadovalidado').val('NO');
                }
            });


            $("#lblestadoventa").change(function() {
                var condiciones = $("#lblestadoventa").val();
                $("#lblestventa").val(condiciones);
                bloquear(condiciones);

            });


            $("#lbltipoventa").change(function() {
                var tps = $("#lbltipoventa").val();
                $("#lbltiventa").val(tps);

            });

            $("#lblcategoria").change(function() {
                var categoria = $("#lblcategoria").val();
                var recurso = $("#lbltiventa").val();
                $("#lblcat").val(categoria);
                bloquearxCategoria(categoria);
                if (recurso == "RE") {

                    if (categoria == "Ficha") {

                        $("#lblestadoventa").val("PendienteAgenda");
                        $("#lblestvisita").val("Vendida");
                        $("#lblestventa").val("PendienteAgenda");
                        $('#lblestadoventa')[0].disabled = false;
                    }
                    if (categoria == "Online") {
                        $("#lblestadoventa").val("PendienteData");
                        $("#lblestvisita").val("Vendida");
                        $("#lblestventa").val("PendienteData");
                        $('#lblestadoventa')[0].disabled = false;
                    }
                    if (categoria == "VAsignada") {
                        $("#lblestadoventa").val("VAsignada");
                        $("#lblestvisita").val("Asignada");
                        $("#lblestventa").val("VAsignada");
                    }
                    if (categoria == "Delegacion") {
                        $("#lblestadoventa").val("AgendadaDEL");
                        $("#lblestvisita").val("Vendida");
                        $("#lblestventa").val("AgendadaDEL");
                        $('#lblestadoventa')[0].disabled = false;
                        $('#lblncontrato')[0].disabled = false;

                    }
                    if (categoria == "NoVendida") {
                        $("#lblestadoventa").val("NoVendida");
                        $("#lblestvisita").val("NoVendida");
                        $("#lblestventa").val("NoVendida");
                        $('#lblestadoventa')[0].disabled = true;
                    }



                } else {

                    if (categoria == "Ficha") {

                        $("#lblestadoventa").val("PendienteAgenda");
                        $("#lblestventa").val("PendienteAgenda");
                        $("#lblestvisita").val("");
                    }
                    if (categoria == "Online") {
                        $("#lblestadoventa").val("PendienteData");
                        $("#lblestventa").val("PendienteData");
                        $("#lblestvisita").val("");
                    }
                    if (categoria == "Delegacion") {
                        $("#lblestadoventa").val("AgendadaDEL");
                        $("#lblestventa").val("AgendadaDEL");
                        $("#lblestvisita").val("");
                    }

                    if (categoria == "NoVendida") {
                        $("#lblestadoventa").val("NoVendida");
                        $("#lblestventa").val("NoVendida");
                        $("#lblestvisita").val("");
                        $('#lblestadoventa')[0].disabled = true;
                    }

                    if (categoria == "ProspectoRP") {
                        $("#lblestadoventa").val("ProspectoRP");
                        $("#lblestvisita").val("");
                        $("#lblestventa").val("ProspectoRP");
                    }


                }

            });



            $('#lblmatricula').on('keyup', function() {
                var dato = $('#lblmatricula').val();
                var url = 'ajax/findMatricula.php';
                $.ajax({
                    type: 'POST',
                    url: url,
                    data: 'dato=' + dato,
                    success: function(datos) {
                        $('.mensajematricula').html(datos);
                    }
                });
                return false;
            });

            $("#lblmatricula").autocomplete({
                source: "./ajax/selectMatricula.php",
                minLength: 2,
                select: function(event, ui) {
                    event.preventDefault();
                    $('#lblidusuario').val(ui.item.idusuario);
                    $('#lblmatricula').val(ui.item.matricula);
                    $('#lblnombcomercial').val(ui.item.comercial);
                    //                        $('#lbldc').val(ui.item.dc);
                    //                        $('#lbljefeventa').val(ui.item.jefe);

                }
            });

            $("#lblmatricula").on("keydown", function(event) {
                if (event.keyCode == $.ui.keyCode.LEFT || event.keyCode == $.ui.keyCode.RIGHT || event.keyCode == $.ui.keyCode.UP || event.keyCode == $.ui.keyCode.DOWN || event.keyCode == $.ui.keyCode.DELETE || event.keyCode == $.ui.keyCode.BACKSPACE) {
                    $('#lblidusuario').val("");
                    $('#lblmatricula').val("");
                    $('#lblnombcomercial').val("");
                    //                        $('#lbldc').val("");
                    //                        $('#lbljefeventa').val("");

                }
                if (event.keyCode == $.ui.keyCode.DELETE) {
                    $('#lblmatricula').val("");
                    $('#lblidusuario').val("");
                    $('#lblnombcomercial').val("");
                    //                        $('#lbldc').val("");
                    //                        $('#lbljefeventa').val("");
                }
            });

        });
    </script>

    <script>
        $(document).ready(function() {
            //bloquearbotonguardar();
            var estadoVenta = $("#estadoVenta").val();
            var categoriaVenta = $("#categoriaVenta").val();
            var tipoVenta = $("#tipoVenta").val();
            bloquear(estadoVenta);
            bloquearxCategoria(categoriaVenta);

            bloquearxRecurso(tipoVenta);

            cargarTipoCierre();
            cargarMotivoIncidencia($('#hidlbltipocierre_cert').val());
            cargarSolucionIncidencia($('#hidlbltipocierre_cert').val());
            $('#lbltipocierre_cert').val($('#hidlbltipocierre_cert').val());
            $('#lblmotivoincidencia_cert').val($('#hidlblmotivoincidencia_cert').val());
            $('#lblsolucionincidencia_cert').val($('#hidlblsolucionincidencia_cert').val());
            $('#lblformapago_cert').val($('#hidlblformapago_cert').val());

            var alterClass = function() {
                var ww = document.body.clientWidth;
                if (ww < 767) {
                    $('body').removeClass('sidebar-collapse');
                } else if (ww >= 768) {
                    $('body').addClass('sidebar-collapse');
                };
            };

            $(window).resize(function() {
                alterClass();
            });
            //Fire it when the page first loads:
            alterClass();
            
			if($('#datosIncidencia').val() != ''){
			      arregloDatos = JSON.parse($('#datosIncidencia').val());
			      datosHTMLN();
			}
			        

            $('#btnGuardarEditarVenta').click(function() {
                var gestor = $('#lblasignado option:selected').val();
                var lblfechacierre_cert = $('#lblfechacierre_cert').val();
                var lbltipocierre_cert = $('#lbltipocierre_cert').val();
                var lblmotivoincidencia_cert = $('#lblmotivoincidencia_cert').val();
                var lblsolucionincidencia_cert = $('#lblsolucionincidencia_cert').val();
                var hidden_hojacertificacion = $('#hidden_hojacertificacion').val();
                var hidden_inci_tecnica = $('#hidden_inci_tecnica').val();
                var hidden_certificadovalidado = $('#hidden_certificadovalidado').val();
                var ediventa = $("#idVenta").val();
                var idcertventa = $('#idcertventa').val();
                var lblfechaapertura_cert = $('#lblfechaapertura_cert').val();
                var lblformapago_cert = $('#lblformapago_cert').val();
                var lblcomentario_cert = $('#lblcomentario_cert').val();

                //lblmotivoincidencia_cert --<ya usar
                //hidden_inci_tecnica --> ya no usar
                
                var hidden_kitnoinstalado= $('#hidden_kitnoinstalado').val();
                var lblfechacorrecion_kitnoinstalado= $('#lblfechacorrecion_kitnoinstalado').val();
                var hidden_errorcomprobantepago= $('#hidden_errorcomprobantepago').val();
                var lblfechacorrecion_errorcomprobantepago= $('#lblfechacorrecion_errorcomprobantepago').val();
                var hidden_errorsegmento= $('#hidden_errorsegmento').val();
                var lblfechacorrecion_errorsegmento= $('#lblfechacorrecion_errorsegmento').val();
                var hidden_fueranomalcomercial= $('#hidden_fueranomalcomercial').val();
                var lblfechacorrecion_fueranomalcomercial= $('#lblfechacorrecion_fueranomalcomercial').val();
                var hidden_fueranormativatecnica= $('#hidden_fueranormativatecnica').val();
                var lblfechacorrecion_fueranormativatecnica= $('#lblfechacorrecion_fueranormativatecnica').val();
                var hidden_incidenciadatos= $('#hidden_incidenciadatos').val();
                var lblfechacorrecion_incidenciadatos= $('#lblfechacorrecion_incidenciadatos').val();
                var hidden_inconformidadfuncionamiento= $('#hidden_inconformidadfuncionamiento').val();
                var lblfechacorrecion_inconformidadfuncionamiento= $('#lblfechacorrecion_inconformidadfuncionamiento').val();
                var hidden_inconformidadpagoinicial= $('#hidden_inconformidadpagoinicial').val();
                var lblfechacorrecion_inconformidadpagoinicial= $('#lblfechacorrecion_inconformidadpagoinicial').val();
                var hidden_inconformidadpagomensual= $('#hidden_inconformidadpagomensual').val();
                var lblfechacorrecion_inconformidadpagomensual= $('#lblfechacorrecion_inconformidadpagomensual').val();
                var hidden_inconformidadtiempopermanencia= $('#hidden_inconformidadtiempopermanencia').val();
                var lblfechacorrecion_inconformidadtiempopermanencia= $('#lblfechacorrecion_inconformidadtiempopermanencia').val();
                var hidden_inconformidadubicaciondispositivos= $('#hidden_inconformidadubicaciondispositivos').val();
                var lblfechacorrecion_inconformidadubicaciondispositivos= $('#lblfechacorrecion_inconformidadubicaciondispositivos').val();
                var hidden_noconcefuncionamiento= $('#hidden_noconcefuncionamiento').val();
                var lblfechacorrecion_noconcefuncionamiento= $('#lblfechacorrecion_noconcefuncionamiento').val();
                var hidden_notienecontrato= $('#hidden_notienecontrato').val();
                var lblfechacorrecion_notienecontrato= $('#lblfechacorrecion_notienecontrato').val();
                var hidden_promesaspendientes= $('#hidden_promesaspendientes').val();
                var lblfechacorrecion_promesaspendientes= $('#lblfechacorrecion_promesaspendientes').val();
                var hidden_reclamocomercial= $('#hidden_reclamocomercial').val();
                var lblfechacorrecion_reclamocomercial= $('#lblfechacorrecion_reclamocomercial').val();
                var hidden_solicitabaja= $('#hidden_solicitabaja').val();
                var lblfechacorrecion_solicitabaja= $('#lblfechacorrecion_solicitabaja').val();
                var hidden_tarjetaafiliadanopertenecetitular= $('#hidden_tarjetaafiliadanopertenecetitular').val();
                var lblfechacorrecion_tarjetaafiliadanopertenecetitular= $('#lblfechacorrecion_tarjetaafiliadanopertenecetitular').val();
                var hidden_recepmanual= $('#hidden_recepmanual').val();
                var lblfechacorrecion_recepmanual= $('#lblfechacorrecion_recepmanual').val();
                var hidden_descargaapp= $('#hidden_descargaapp').val();
                var lblfechacorrecion_descargaapp= $('#lblfechacorrecion_descargaapp').val();
                var hidden_capacitado= $('#hidden_capacitado').val();
                var lblfechacorrecion_capacitado= $('#lblfechacorrecion_capacitado').val();
                
                var lblnumerollamadas= $('#lblnumerollamadas').val();
                var FechaPendiente= $('#FechaPendiente').val();
                var FechaPrimeraGestion= $('#FechaPrimeraGestion').val();
                var FechaFinalizadoconIncidencia= $('#FechaFinalizadoconIncidencia').val();
                var FechaResuelto= $('#FechaResuelto').val();


                var datos = {
                    array:'array3',
                    gestor: gestor,
                    lblfechacierre_cert: lblfechacierre_cert,
                    lbltipocierre_cert: lbltipocierre_cert,
                    lblmotivoincidencia_cert: lblmotivoincidencia_cert,
                    lblsolucionincidencia_cert: lblsolucionincidencia_cert,
                    hidden_hojacertificacion: hidden_hojacertificacion,
                    hidden_inci_tecnica: hidden_inci_tecnica,
                    hidden_certificadovalidado: hidden_certificadovalidado,
                    ediventa: ediventa,
                    idcertventa: idcertventa,
                    lblfechaapertura_cert: lblfechaapertura_cert,
                    lblformapago_cert: lblformapago_cert,
                    lblcomentario_cert: lblcomentario_cert,
                    hidden_kitnoinstalado: hidden_kitnoinstalado,
                    lblfechacorrecion_kitnoinstalado: lblfechacorrecion_kitnoinstalado,
                    hidden_errorcomprobantepago: hidden_errorcomprobantepago,
                    lblfechacorrecion_errorcomprobantepago: lblfechacorrecion_errorcomprobantepago,
                    hidden_errorsegmento: hidden_errorsegmento,
                    lblfechacorrecion_errorsegmento: lblfechacorrecion_errorsegmento,
                    hidden_fueranomalcomercial: hidden_fueranomalcomercial,
                    lblfechacorrecion_fueranomalcomercial: lblfechacorrecion_fueranomalcomercial,
                    hidden_fueranormativatecnica: hidden_fueranormativatecnica,
                    lblfechacorrecion_fueranormativatecnica: lblfechacorrecion_fueranormativatecnica,
                    hidden_incidenciadatos: hidden_incidenciadatos,
                    lblfechacorrecion_incidenciadatos: lblfechacorrecion_incidenciadatos,
                    hidden_inconformidadfuncionamiento: hidden_inconformidadfuncionamiento,
                    lblfechacorrecion_inconformidadfuncionamiento: lblfechacorrecion_inconformidadfuncionamiento,
                    hidden_inconformidadpagoinicial: hidden_inconformidadpagoinicial,
                    lblfechacorrecion_inconformidadpagoinicial: lblfechacorrecion_inconformidadpagoinicial,
                    hidden_inconformidadpagomensual: hidden_inconformidadpagomensual,
                    lblfechacorrecion_inconformidadpagomensual: lblfechacorrecion_inconformidadpagomensual,
                    hidden_inconformidadtiempopermanencia: hidden_inconformidadtiempopermanencia,
                    lblfechacorrecion_inconformidadtiempopermanencia: lblfechacorrecion_inconformidadtiempopermanencia,
                    hidden_inconformidadubicaciondispositivos: hidden_inconformidadubicaciondispositivos,
                    lblfechacorrecion_inconformidadubicaciondispositivos: lblfechacorrecion_inconformidadubicaciondispositivos,
                    hidden_noconcefuncionamiento: hidden_noconcefuncionamiento,
                    lblfechacorrecion_noconcefuncionamiento: lblfechacorrecion_noconcefuncionamiento,
                    hidden_notienecontrato: hidden_notienecontrato,
                    lblfechacorrecion_notienecontrato: lblfechacorrecion_notienecontrato,
                    hidden_promesaspendientes: hidden_promesaspendientes,
                    lblfechacorrecion_promesaspendientes: lblfechacorrecion_promesaspendientes,
                    hidden_reclamocomercial: hidden_reclamocomercial,
                    lblfechacorrecion_reclamocomercial: lblfechacorrecion_reclamocomercial,
                    hidden_solicitabaja: hidden_solicitabaja,
                    lblfechacorrecion_solicitabaja: lblfechacorrecion_solicitabaja,
                    hidden_tarjetaafiliadanopertenecetitular: hidden_tarjetaafiliadanopertenecetitular,
                    lblfechacorrecion_tarjetaafiliadanopertenecetitular: lblfechacorrecion_tarjetaafiliadanopertenecetitular,
                    hidden_recepmanual: hidden_recepmanual,
                    lblfechacorrecion_recepmanual: lblfechacorrecion_recepmanual,
                    hidden_descargaapp: hidden_descargaapp,
                    lblfechacorrecion_descargaapp: lblfechacorrecion_descargaapp,
                    hidden_capacitado: hidden_capacitado,
                    lblfechacorrecion_capacitado: lblfechacorrecion_capacitado,
                    lblnumerollamadas:lblnumerollamadas,
                    FechaPendiente,
                    FechaPrimeraGestion,
                    FechaFinalizadoconIncidencia,
                    FechaResuelto
                };

            Swal.fire({
                title: '¿Deseas guardar los cambios generados?',
                html: '',
                showDenyButton: true,
                showCancelButton: true,
                confirmButtonText: `Gestión`,
                denyButtonText: `Información`,
                icon: 'info',
            }).then((result) => {
                //GESTION
                if (result.isConfirmed) {
                    datos.lbltipoaccion = 'gestion';
                    console.log(datos);
                        console.log('Entra Gestion');
                        if (validaForm()) {
                            
                            $.ajax({
                                type: 'POST',
                                url: './Controller/ControllerVenta.php',
	                            data: {function: JSON.stringify(datos)},                                
                                dataType: "Json",
                                success: function(data) {
                                    console.log(data);
                                    if (data.respuesta == 'exito') {
                                        Swal.fire({
                                           title:'Modificado con exito!',
                                           text:'Gestion!',
                                           icon:'success',
                                           showCancelButton:false,
                                           confirmButtonColor:'',
                                           confirmButtonText:'OK',
                                           closeOnConfirm: false,
                                           allowOutsideClick: false                          
                                        }).then((result)=>{
                                            if(result.isConfirmed){
                                                window.location.reload();
                                            }
                                        });

                                    } else if (data.respuesta == 'sincambios') {
                                        alertify.warning("No se ha realizado ninguna modificación");

                                    } else {
                                        alertify.error("Fallo el server");

                                    }
                                }
                            });
                        }

                }
                //INFORMACION
                else if (result.isDenied) {
                    datos.lbltipoaccion = 'informacion';
                    console.log(datos);
                    $.ajax({
                        type: 'POST',
                        url: './Controller/ControllerVenta.php',
	                    data: {function: JSON.stringify(datos)},           
                        dataType: "Json",
                        success: function(data) {
                            console.log(data);
                            if (data.respuesta == 'exito') {

                                Swal.fire({
                                           title:'Información actualizada!',
                                           text:'',
                                           icon:'success',
                                           showCancelButton:false,
                                           confirmButtonColor:'',
                                           confirmButtonText:'OK',
                                           closeOnConfirm: false,
                                           allowOutsideClick: false                                      
                                        }).then((result)=>{
                                            if(result.isConfirmed){
                                                window.location.reload();
                                            }
                                        });
                                
                            } else if (data.respuesta == 'sincambios') {
                                alertify.warning("No se ha realizado ninguna modificación");
                            } else {
                                alertify.error("Fallo el server");

                            }
                        }
                    });

                } else {
                    return;
                }
            })

              



            });

            $('.selectdistrito').select2({
                placeholder: 'Seleccione Distrito - Provincia',
                allowClear: true,
                language: {
                    errorLoading: function() {
                        return "La carga falló";
                    },
                    noResults: function() {
                        return "No hay resultado";
                    },
                    searching: function() {

                        return "Buscando..";
                    }
                },
                ajax: {
                    url: 'ajax/selectDistrito.php',
                    dataType: 'json',
                    delay: 250,
                    processResults: function(data) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                }
            });



            $('.cbxtecnico').select2({
                placeholder: 'Seleccione',
                allowClear: true,
                language: {
                    errorLoading: function() {
                        return "La carga falló";
                    },
                    noResults: function() {
                        return "No hay resultado";
                    },
                    searching: function() {

                        return "Buscando..";
                    }
                }
            });


            $('#datemask').inputmask('dd/mm/yyyy', {
                'placeholder': 'dd/mm/yyyy'
            });


            $('#lblfecharecpciondoc').datepicker({
                autoclose: true,
                language: 'es',
                firstDay: 1
            });
            $('#lblfechafacturacion').datepicker({
                autoclose: true,
                language: 'es',
                firstDay: 1
            });
            //Money Euro
            $('[data-mask]').inputmask();
            //Date picker
            $('#fechainst').datepicker({
                autoclose: true,
                language: 'es',
                firstDay: 1
            });
            $('#lblfechanacimiento').datepicker({
                autoclose: true,
                language: 'es',
            });            
            
            //Date picker
            $('#horainst').timepicker({
                defaultTime: false,
                showInputs: true,
                minuteStep: 1
            });

            $('#mesano').datepicker({
                autoclose: true,
                language: 'en',
                firstDay: 1,
                format: 'M-yyyy',
                viewMode: "years",
                minViewMode: "months"

            });
            $('#modalfechahoraRellamada').datetimepicker().data("DateTimePicker").options({
                format: 'DD/MM/YYYY HH:mm'
                
            });
            $('#logcambios').click(function() {
                refresh();
            });

            $('#logcambios_cert').click(function() {
                refresh_cert();
            });
            $('#logcambios_comentario_comercial').click(function () {
                refresh_comenariocert();
            }); 

            //Nuevos Cambios Certificacion

            $('.selectgestor').select2({
                placeholder: 'Seleccione Gestor',
                allowClear: true,
                language: {
                    errorLoading: function() {
                        return "La carga falló";
                    },
                    noResults: function() {
                        return "No hay resultado";
                    },
                    searching: function() {
                        return "Buscando..";
                    }
                },
                ajax: {
                    url: 'ajax/selectGestorCertificacionVenta.php',
                    dataType: 'json',
                    delay: 250,
                    processResults: function(data) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                }
            });

            $('#lblfechacierre_cert').datepicker({
                autoclose: true,
                language: 'es',
                firstDay: 1
            });

        });



        var bloquear = function(condiciones) {

            $('#tinviable').hide();
            $('#lblinviable').hide();
            $('#lblinviable').disabled = true;
            $('#tinviableespacio').hide();

            $('#tcancelado').hide();
            $('#lblcancelado').hide();
            $('#lblcancelado').disabled = true;
            $('#tcanceladoespacio').hide();


            if (condiciones == "Inviable") {
                $('#tinviable').show();
                $('#lblinviable').show();
                $('#lblinviable').show();
                $('#lblinviable').disabled = false;
                $('#tinviableespacio').show();

            } else if (condiciones == "AgendadaTEC" || condiciones == "Instalada" || condiciones == "Incidencia" || condiciones == "IncidenciaGestCorreo" || condiciones == "IncidenciaGestValija" || condiciones == "NoDoc" || condiciones == "DocEnvi" || condiciones == "DocE") {
                $('#lblcategoria')[0].disabled = true;

            } else if (condiciones == "Facturada") {
                $('#lblcategoria')[0].disabled = true;
                $('#frmEditarVenta')[0].disabled = true;

            } else if (condiciones == "Cancelado") {
                $('#tcancelado').show();
                $('#lblcancelado').show();
                $('#lblcancelado').disabled = false;
                $('#tcanceladoespacio').show();

            } else {
                $('#tinviable').hide();
                $('#lblinviable').hide();
                $('#lblinviable').disabled = true;
                $('#tinviableespacio').hide();

                $('#tcancelado').hide();
                $('#lblcancelado').hide();
                $('#lblcancelado').disabled = true;
                $('#tcanceladoespacio').hide();

            }

            if ($('#lblpermiso').val() == "GestorVTACertificada") {
                $('#lblasignado').prop('disabled', false);

            } else {
                if ($('#idcertventa').val() != "") {
                    if ($("#hidlblasignadoCert").val() != "") {
                        $('#lblasignado').prop('disabled', false);
                    } else {
                        $('#lblasignado').prop('disabled', false);
                    }


                } else {
                    $('#lblasignado').prop('disabled', false);

                }
            }



        }

        var bloquearbotonguardar = function() {
            var lblrc = $('#lblrc').val();
            if (lblrc == "totales") {
                //$('#btnGuardarEditarVenta').hide(); 
            } else {
                //$('#btnGuardarEditarVenta').show();
            }

        }

        var bloquearxRecurso = function(tipoventa) {

            var catec = $("#categoriaVenta").val();

            if (tipoventa == "RE") {

                $('#lblmatricula')[0].disabled = true;
                $('#lbldc')[0].disabled = true;
                $('#lbljefeventa')[0].disabled = true;
                if (catec == "Delegacion" || catec == "Online" || catec == "Ficha") {
                    $('#lblestadoventa')[0].disabled = true;
                    $('#lblncontrato')[0].disabled = true;

                } else {
                    $('#lblestadoventa')[0].disabled = true;
                    $('#lblncontrato')[0].disabled = true;
                }


                $('#lblsegmento')[0].disabled = true;
                $('#lbltipoventa')[0].disabled = true;
                $('#lblnprospecto')[0].disabled = true;
                $('#lblnombcliente')[0].disabled = true;
                $('#lblcorreo')[0].disabled = true;
                $('#lbldireccion')[0].disabled = true;
                $('#lbldistrito')[0].disabled = true;
                $('#lblmovil')[0].disabled = true;
                $('#lblfijo')[0].disabled = true;

            } else if (tipoventa == "RPTMK" || tipoventa == "RPMKT") {
                $('#lbltipoventa')[0].disabled = true;
            } else {

                $('#lblmatricula')[0].disabled = true;
                $('#lbldc')[0].disabled = true;
                $('#lbljefeventa')[0].disabled = true;
                $('#lblestadoventa')[0].disabled = true;
                $('#lbltipoventa')[0].disabled = true;
                $('#lblsegmento')[0].disabled = true;

                $('#lblnprospecto')[0].disabled = true;
                $('#lblncontrato')[0].disabled = true;
                $('#lblnombcliente')[0].disabled = true;
                $('#lblcorreo')[0].disabled = true;
                $('#lbldireccion')[0].disabled = true;
                $('#lbldistrito')[0].disabled = true;
                $('#lblmovil')[0].disabled = true;
                $('#lblfijo')[0].disabled = true;

            }

        }




        var bloquearxCategoria = function(categoria) {

            if (categoria == "Delegacion") {
                $('#lblestadoventa')[0].disabled = true;
                $('#lblncontrato')[0].disabled = true;
                $('#lblinstaladox')[0].disabled = true;
                $('#lbltecnico')[0].disabled = true;
                $('#fechainst')[0].disabled = true;
                $('#horainst')[0].disabled = true;
                $('#lblrepercucion')[0].disabled = true;
                $('#lblcomentarioagenda')[0].disabled = true;
                $('#lblinviable')[0].disabled = true;
            } else {
                $('#lblinstaladox')[0].disabled = true;
                $('#lbltecnico')[0].disabled = true;
                $('#fechainst')[0].disabled = true;
                $('#horainst')[0].disabled = true;
                $('#lblrepercucion')[0].disabled = true;
                $('#lblcomentarioagenda')[0].disabled = true;
                $('#lblinviable')[0].disabled = true;
            }

        }




        var calcDataTableHeight = function() {
            return $(window).height() * 65 / 100;
        };


        function filterFloat(evt, input) {
            // Backspace = 8, Enter = 13, ‘0′ = 48, ‘9′ = 57, ‘.’ = 46, ‘-’ = 43
            var key = window.Event ? evt.which : evt.keyCode;
            var chark = String.fromCharCode(key);
            var tempValue = input.value + chark;
            if (key >= 48 && key <= 57) {
                if (filter(tempValue) === false) {
                    return false;
                } else {
                    return true;
                }
            } else {
                if (key == 8 || key == 13 || key == 0) {
                    return true;
                } else if (key == 46) {
                    if (filter(tempValue) === false) {
                        return false;
                    } else {
                        return true;
                    }
                } else {
                    return false;
                }
            }
        }

        function filter(__val__) {
            var preg = /^([0-9]+\.?[0-9]{0,2})$/;
            if (preg.test(__val__) === true) {
                return true;
            } else {
                return false;
            }

        }
        //NUEVAS FUNCIONES

        $("#lbltipocierre_cert").change(function() {
            $("#lbltipocierre_cert option:selected").each(function() {
                var TipoCierre = $(this).val();
                cargarMotivoIncidencia(TipoCierre);
                cargarSolucionIncidencia(TipoCierre);

            });
        });

        function cargarTipoCierre() {
            var lbltipocierre_cert = $('#lbltipocierre_cert');
            var r = [{
                    id: "Pendiente"
                },
                {
                    id: "Finalizada con Exito"
                },
                {
                    id: "Incidencia"
                },
                {
                    id: "Finalizada con Incidencia"
                },                
                {
                    id: "No colabora"
                },                
                {
                    id: "Ilocalizado"
                },
                {
                    id: "En gestion"
                }
            ];
            lbltipocierre_cert.find('option').remove();
            lbltipocierre_cert.append('<option value="">Seleccione</option>');
            $(r).each(function(i, v) { // indice, valor
            
                if(v.id=="Finalizada con Incidencia"){
                    lbltipocierre_cert.append('<option value="' + v.id + '" hidden>' + v.id + '</option>');
                }else{
                   lbltipocierre_cert.append('<option value="' + v.id + '">' + v.id + '</option>'); 
                }
                
            });
        }


        
        

        function cargarMotivoIncidencia(lbltipocierre_cert) {
            var lblmotivoincidencia_cert = $('#lblmotivoincidencia_cert');

            var r = [
                // {id:'No tiene contrato'},
                // {id:'No sabe pc'},
                // {id:'Incidencia en los datos'},
                // {id:'No conoce funcionamiento'},
                // {id:'Promesas pendientes'},
                // {id:'No conforme pago inicial'},
                // {id:'No conforme pago mensual'},
                // {id:'Fuera de normativa técnica'},
                // {id:'Error en comprobante de pago'},
                // {id:'Desconoce CONFIA'},
                // {id:'No conforme con ubicación de los dispositivos'},
                // {id:'Incidencia Attec'},
                // {id:'Solicita ANP'},
                // {id:'Sistema en MST'},
                // {id:'Solicita baja'},
                // {id:'Contactos ilocalizados'},
                // {id:'Tarjeta Afiliada - No pertenece al Titular'},
                // {id:'Reclamo Comercial'}
                {
                    id: 'MOTIVO DE INCIDENCIA'
                },
                {
                    id: 'NO TIENE CONTRATO'
                },
                {
                    id: 'INCIDENCIA EN LOS DATOS'
                },
                {
                    id: 'NO CONOCE FUNCIONAMIENTO'
                },
                {
                    id: 'PROMESAS PENDIENTES'
                },
                {
                    id: 'NO CONFORME CON PAGO INICIAL'
                },
                {
                    id: 'NO CONFORME CON PAGO MENSUAL'
                },
                {
                    id: 'FUERA DE NORMATIVA TÉCNICA'
                },
                {
                    id: 'ERROR EN COMPROBANTE DE PAGO'
                },
                {
                    id: 'NO CONFORME CON UBICACIÓN DE LOS DISPOSITIVOS'
                },
                {
                    id: 'INCIDENCIA ATTEC'
                },
                {
                    id: 'SOLICITA ANP'
                },
                {
                    id: 'SISTEMA EN MST'
                },
                // {id:'SOLICITA BAJA'},
                {
                    id: 'ERROR EN EL SEGMENTO'
                },
                {
                    id: 'ERROR EN EL DISTRITO'
                },
                {
                    id: 'TARJETA AFILIADA - NO PERTENCE AL TITULAR'
                },
                {
                    id: 'RECLAMO COMERCIAL'
                },
                {
                    id: 'FUERA DE NORMA COMERCIAL'
                },
                {
                    id: 'INSTALACIÓN EN OBRAS'
                },
                {
                    id: 'INCIDENCIA EN APP'
                },
                {
                    id: 'NO CONFORME CON FUNCIONAMIENTO DEL SISTEMA'
                },
                {
                    id: 'NO CONFORME CON TIEMPO DE PERMANENCIA'
                },
                {
                    id: 'DISPOSITIVO DE KIT NO INSTALADO'
                },
                {
                    id: 'NO APLICA RBE'
                },
                {
                    id: 'SOLICITA BAJA CON CONTRATO'
                },
                {
                    id: 'SOLICITA BAJA SIN CONTRATO'
                },
            ];

            lblmotivoincidencia_cert.find('option').remove();
            lblmotivoincidencia_cert.append('<option value="">Seleccione</option>');

            if (lbltipocierre_cert == "Finalizada con Incidencia" || lbltipocierre_cert == "Incidencia") {
                $(r).each(function(i, v) { // indice, valor
                    lblmotivoincidencia_cert.append('<option value="' + v.id + '">' + v.id + '</option>');
                });
                $('.motivocierretc').show();
            } else {
                $('.motivocierretc').hide();
            }

        }

        function cargarSolucionIncidencia(lbltipocierre_cert) {
            var lblsolucionincidencia_cert = $('#lblsolucionincidencia_cert');
            var r = [
                {
                    id: "Pendiente"
                },
                {
                    id: "Solucion completa"
                },
                {
                    id: "Solucion parcial"
                },
                {
                    id: "No solucionado"
                },
                {
                    id: "No resuelto"
                },
                {
                    id: "Resuelto"
                },                
                
            ];
            lblsolucionincidencia_cert.find('option').remove();
            lblsolucionincidencia_cert.append('<option value="">Seleccione</option>');

            if (lbltipocierre_cert == "Finalizada con Incidencia" || lbltipocierre_cert == "Incidencia") {
                $(r).each(function(i, v) { // indice, valor
                if(v.id=="No resuelto" || v.id=="Resuelto"){
                    lblsolucionincidencia_cert.append('<option value="' + v.id + '" hidden>' + v.id + '</option>');
                }else{
                   lblsolucionincidencia_cert.append('<option value="' + v.id + '">' + v.id + '</option>'); 
                }
                    
                });
            } else {}

        }

        function cargarModalMotivoIncidencia() {
            var modalmotivoIncidencia = $('#modalmotivoIncidencia');

            var r = [
                {
                    id: 'CONTRATO'
                },
                {
                    id: 'METODO DE PAGO'
                },
                {
                    id: 'FUERA DE NORMA COMERCIAL'
                },
                {
                    id: 'INCIDENCIAS TECNICAS'
                },
                {
                    id: 'PROMESAS PENDIENTES'
                },
                {
                    id: 'SERVICIO'
                },
                {
                    id: 'SOLICITA BAJA'
                }
            ];

            modalmotivoIncidencia.find('option').remove();
            modalmotivoIncidencia.append('<option value="">Seleccione</option>');

            $(r).each(function(i, v) { // indice, valor
                    modalmotivoIncidencia.append('<option value="' + v.id + '">' + v.id + '</option>');
            });

        } 
        
        function cargarModalSubMotivoIncidencia(txtmotivo) {
            var modalsubmotivoIncidencia = $('#modalsubmotivoIncidencia');

            var CONTRATO = [
                {id: 'NO RECONOCE FIRMA'},
                {id: 'NO RECONOCE TITULARIDAD DE CONTRATO'},
                {id: 'ERROR EN DATOS DEL TITULAR O EMPRESA'},
                {id: 'NO RECIBIO CONTRATO FISICO'},
                {id: 'PAGO INICIAL'},
                {id: 'PAGO MENSUAL'},
                {id: 'DESACUERDO EN PERMANENCIA'},
                {id: 'PERMANENCIA DIFERENTE'},
                {id: 'PENALIDAD'},
                {id: 'DNI A RUS'},
                {id: 'DNI/RUC CAMBIO A OTRO RUC'},
                {id: 'ADENDA'},
            ];
            
            var METODO_DE_PAGO = [
                {id: 'FECHA DE PAGO'},
                {id: 'TARJETA/CUENTA AFILIADA - NO PERTENECE AL TITULAR'},
                {id: 'TARJETA/CUENTA NO AUTORIZADA'},
                {id: 'TARJETA/CUENTA NO APTA PARA CARGO MENSUAL'},
                {id: 'ERROR EN NUMERO DE TARJETA/CUENTA'},
            ];
            
  
            var FUERA_DE_NORMA_COMERCIAL = [
                {id: 'INSTALACION DUPLICADA'},
                {id: 'PLAN ACCION INCOMPLETA'},
                {id: 'PLAN ACCION SIN TITULAR'},
                {id: 'PLAN DE ACCION DUPLICADO'},
                {id: 'DESCONOCEN A USUARIO'},
                {id: 'REX EQUIPOS NUEVOS'}
            ];
            
            var INCIDENCIAS_TECNICAS = [
                {id: 'INSTALACION INVIABLE'},
                {id: 'SISTEMA EN MST'},
                {id: 'INSTALACION EN OBRAS'},
                {id: 'DISPOSITIVO DE KIT NO INSTALADO O DESPRENDIDO'},
                {id: 'PLACA NO INSTALADA'},
                {id: 'ZONAS NO HABILITADAS'},
                {id: 'FUNCIONAMIENTO DE ALARMA'},
                {id: 'MASCOTAS/ADULTO MAYOR'},
            ]; 
            var PROMESAS_PENDIENTES = [
                {id: 'DESCUENTOS'},
                {id: 'DISPOSITIVO NO ENTREGADO- SIN COSTO'},
                {id: 'DISPOSITIVO NO ENTREGADO- CON COSTO'},
                {id: 'TRAMITAR SOLICITUD DE BAJA DE OTRA EMPRESA'},
            ];            
            var SERVICIO = [
                {id: 'UBICACION DE DISPOSITIVOS INTERNO'},
                {id: 'UBICACION DE DISPOSITIVOS EXTERNO'},
                {id: 'INFORMACION DE SERVICIO- EQUIPOS'},
                {id: 'APP NO INSTALADA'},
                {id: 'NO RECIBIO CAPACITACION DE USO DE APP/ARLO/SISTEMA'},
            ];
            var SOLICITA_BAJA = [
                {id: 'SOLICITA BAJA'},
            ];              

            modalsubmotivoIncidencia.find('option').remove();
            modalsubmotivoIncidencia.append('<option value="">Seleccione</option>');

            if (txtmotivo == "CONTRATO") {
                $(CONTRATO).each(function(i, v) { // indice, valor
                    modalsubmotivoIncidencia.append('<option value="' + v.id + '">' + v.id + '</option>');
                });
            } else if(txtmotivo == "METODO DE PAGO") {
                $(METODO_DE_PAGO).each(function(i, v) { // indice, valor
                    modalsubmotivoIncidencia.append('<option value="' + v.id + '">' + v.id + '</option>');
                });
              
            }else if(txtmotivo == "FUERA DE NORMA COMERCIAL") {
                $(FUERA_DE_NORMA_COMERCIAL).each(function(i, v) { // indice, valor
                    modalsubmotivoIncidencia.append('<option value="' + v.id + '">' + v.id + '</option>');
                });
            }else if(txtmotivo == "INCIDENCIAS TECNICAS") {
                $(INCIDENCIAS_TECNICAS).each(function(i, v) { // indice, valor
                    modalsubmotivoIncidencia.append('<option value="' + v.id + '">' + v.id + '</option>');
                });
            }else if (txtmotivo == "PROMESAS PENDIENTES") {
                $(PROMESAS_PENDIENTES).each(function(i, v) { // indice, valor
                    modalsubmotivoIncidencia.append('<option value="' + v.id + '">' + v.id + '</option>');
                });
            }else if (txtmotivo == "SERVICIO") {
                $(SERVICIO).each(function(i, v) { // indice, valor
                    modalsubmotivoIncidencia.append('<option value="' + v.id + '">' + v.id + '</option>');
                });                
            }else if (txtmotivo == "SOLICITA BAJA") {
                $(SOLICITA_BAJA).each(function(i, v) { // indice, valor
                    modalsubmotivoIncidencia.append('<option value="' + v.id + '">' + v.id + '</option>');
                });
            }


        }         
        

        function validaForm() {
            // Campos de texto
            if ($("#frmEditarVenta #lblasignado").val() == "") {
                alertify.warning("Por favor ingresar la Matricula Gestor correspondiente");
                $("#frmEditarVenta #lblasignado").focus(); // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                return false;
            }

            return true;
        }
    </script>

    <!-- SCRIPT DE QSERVUS -->
    <script>
        function enviarEncuesta() {
            var lblcorreo = $('#lblcorreo').val();
            var lblnombcliente = $('#lblnombcliente').val();
            var lblmovil = $('#lblmovil').val();
            var lblncliente = $('#lblncontrato').val();
            var lblasignado = $('#lblasignado').val();

            var lblfechacierre_cert = moment($('#lblfechacierre_cert').val(), 'DD/MM/YYYY').format('DD-MM-YYYY');
            console.log(lblfechacierre_cert);

            var lblfechaapertura_cert = moment($('#lblfechaapertura_cert').val(), 'YYYY-MM-DD hh:mm:ss').format('DD-MM-YYYY');
            console.log(lblfechaapertura_cert);
            var lbltipocierre_cert = $('#lbltipocierre_cert option:selected').val();
            var lblsegmento = $('#lblsegmento').val();
            var lbldistrito = $('#lbldistrito option:selected').text();
            var arraylbldistrito = lbldistrito.split(" - ");
            var distrito = arraylbldistrito[0];
            var provincia = arraylbldistrito[1];

            data = {
                "campaign_id": 310044,
                "survey_id": 337515,
                "respondent_email": lblcorreo,
                "respondent_name": lblnombcliente,
                "respondent_phone": lblmovil,
                "respondent_expiration_days": 10,
                "gestor": lblasignado,
                "fecha_de_cierre": lblfechacierre_cert,
                "fecha_de_apertura": lblfechaapertura_cert,
                "tipo_de_cierre": lbltipocierre_cert,
                "contrato": lblncliente,
                "segmento": lblsegmento,
                "city": distrito,
                "state description": provincia
            }

            console.log(data);

            fetch('https://qservus.redcalidad.com/api/addrespondent/', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'Authorization': 'Token 69091bedd687e3b2da71f0d804df3853242a493c'
                    },
                    body: JSON.stringify(data),
                })
                .then(response => response.json())
                .then(data => {
                    console.log('Success:', data);
                })
                .catch((error) => {
                    console.error('Error:', error);
                });

        }
    </script>
    
      <script>
                $('#lblfechacorrecion_kitnoinstalado').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#kitnoinstalado').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#kitnoinstalado').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_kitnoinstalado').val('SI');
                        $('#lblfechacorrecion_kitnoinstalado').prop("disabled", false);
                        $('.kitnoinstalado').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_kitnoinstalado').val('NO');
                        $('#lblfechacorrecion_kitnoinstalado').prop("disabled", true);
                        $('.kitnoinstalado').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_errorcomprobantepago').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#errorcomprobantepago').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#errorcomprobantepago').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_errorcomprobantepago').val('SI');
                        $('#lblfechacorrecion_errorcomprobantepago').prop("disabled", false);
                        $('.errorcomprobantepago').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_errorcomprobantepago').val('NO');
                        $('#lblfechacorrecion_errorcomprobantepago').prop("disabled", true);
                        $('.errorcomprobantepago').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_errorsegmento').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#errorsegmento').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#errorsegmento').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_errorsegmento').val('SI');
                        $('#lblfechacorrecion_errorsegmento').prop("disabled", false);
                        $('.errorsegmento').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_errorsegmento').val('NO');
                        $('#lblfechacorrecion_errorsegmento').prop("disabled", true);
                        $('.errorsegmento').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_fueranomalcomercial').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#fueranomalcomercial').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#fueranomalcomercial').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_fueranomalcomercial').val('SI');
                        $('#lblfechacorrecion_fueranomalcomercial').prop("disabled", false);
                        $('.fueranomalcomercial').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_fueranomalcomercial').val('NO');
                        $('#lblfechacorrecion_fueranomalcomercial').prop("disabled", true);
                        $('.fueranomalcomercial').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_fueranormativatecnica').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#fueranormativatecnica').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#fueranormativatecnica').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_fueranormativatecnica').val('SI');
                        $('#lblfechacorrecion_fueranormativatecnica').prop("disabled", false);
                        $('.fueranormativatecnica').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_fueranormativatecnica').val('NO');
                        $('#lblfechacorrecion_fueranormativatecnica').prop("disabled", true);
                        $('.fueranormativatecnica').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_incidenciadatos').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#incidenciadatos').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#incidenciadatos').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_incidenciadatos').val('SI');
                        $('#lblfechacorrecion_incidenciadatos').prop("disabled", false);
                        $('.incidenciadatos').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_incidenciadatos').val('NO');
                        $('#lblfechacorrecion_incidenciadatos').prop("disabled", true);
                        $('.incidenciadatos').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_inconformidadfuncionamiento').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#inconformidadfuncionamiento').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#inconformidadfuncionamiento').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_inconformidadfuncionamiento').val('SI');
                        $('#lblfechacorrecion_inconformidadfuncionamiento').prop("disabled", false);
                        $('.inconformidadfuncionamiento').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_inconformidadfuncionamiento').val('NO');
                        $('#lblfechacorrecion_inconformidadfuncionamiento').prop("disabled", true);
                        $('.inconformidadfuncionamiento').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_inconformidadpagoinicial').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#inconformidadpagoinicial').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#inconformidadpagoinicial').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_inconformidadpagoinicial').val('SI');
                        $('#lblfechacorrecion_inconformidadpagoinicial').prop("disabled", false);
                        $('.inconformidadpagoinicial').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_inconformidadpagoinicial').val('NO');
                        $('#lblfechacorrecion_inconformidadpagoinicial').prop("disabled", true);
                        $('.inconformidadpagoinicial').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_inconformidadpagomensual').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#inconformidadpagomensual').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#inconformidadpagomensual').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_inconformidadpagomensual').val('SI');
                        $('#lblfechacorrecion_inconformidadpagomensual').prop("disabled", false);
                        $('.inconformidadpagomensual').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_inconformidadpagomensual').val('NO');
                        $('#lblfechacorrecion_inconformidadpagomensual').prop("disabled", true);
                        $('.inconformidadpagomensual').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_inconformidadtiempopermanencia').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#inconformidadtiempopermanencia').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#inconformidadtiempopermanencia').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_inconformidadtiempopermanencia').val('SI');
                        $('#lblfechacorrecion_inconformidadtiempopermanencia').prop("disabled", false);
                        $('.inconformidadtiempopermanencia').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_inconformidadtiempopermanencia').val('NO');
                        $('#lblfechacorrecion_inconformidadtiempopermanencia').prop("disabled", true);
                        $('.inconformidadtiempopermanencia').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_inconformidadubicaciondispositivos').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#inconformidadubicaciondispositivos').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#inconformidadubicaciondispositivos').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_inconformidadubicaciondispositivos').val('SI');
                        $('#lblfechacorrecion_inconformidadubicaciondispositivos').prop("disabled", false);
                        $('.inconformidadubicaciondispositivos').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_inconformidadubicaciondispositivos').val('NO');
                        $('#lblfechacorrecion_inconformidadubicaciondispositivos').prop("disabled", true);
                        $('.inconformidadubicaciondispositivos').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_noconcefuncionamiento').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#noconcefuncionamiento').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#noconcefuncionamiento').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_noconcefuncionamiento').val('SI');
                        $('#lblfechacorrecion_noconcefuncionamiento').prop("disabled", false);
                        $('.noconcefuncionamiento').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_noconcefuncionamiento').val('NO');
                        $('#lblfechacorrecion_noconcefuncionamiento').prop("disabled", true);
                        $('.noconcefuncionamiento').addClass('ocultar');
                        
                    }
                });

                $('#lblfechacorrecion_notienecontrato').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#notienecontrato').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#notienecontrato').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_notienecontrato').val('SI');
                        $('#lblfechacorrecion_notienecontrato').prop("disabled", false);
                        $('.notienecontrato').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_notienecontrato').val('NO');
                        $('#lblfechacorrecion_notienecontrato').prop("disabled", true);
                        $('.notienecontrato').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_promesaspendientes').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#promesaspendientes').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#promesaspendientes').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_promesaspendientes').val('SI');
                        $('#lblfechacorrecion_promesaspendientes').prop("disabled", false);
                        $('.promesaspendientes').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_promesaspendientes').val('NO');
                        $('#lblfechacorrecion_promesaspendientes').prop("disabled", true);
                        $('.promesaspendientes').addClass('ocultar');
                        
                    }
                });                
                $('#lblfechacorrecion_reclamocomercial').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#reclamocomercial').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#reclamocomercial').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_reclamocomercial').val('SI');
                        $('#lblfechacorrecion_reclamocomercial').prop("disabled", false);
                        $('.reclamocomercial').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_reclamocomercial').val('NO');
                        $('#lblfechacorrecion_reclamocomercial').prop("disabled", true);
                        $('.reclamocomercial').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_solicitabaja').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#solicitabaja').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#solicitabaja').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_solicitabaja').val('SI');
                        $('#lblfechacorrecion_solicitabaja').prop("disabled", false);
                        $('.solicitabaja').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_solicitabaja').val('NO');
                        $('#lblfechacorrecion_solicitabaja').prop("disabled", true);
                        $('.solicitabaja').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_tarjetaafiliadanopertenecetitular').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#tarjetaafiliadanopertenecetitular').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#tarjetaafiliadanopertenecetitular').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_tarjetaafiliadanopertenecetitular').val('SI');
                        $('#lblfechacorrecion_tarjetaafiliadanopertenecetitular').prop("disabled", false);
                        $('.tarjetaafiliadanopertenecetitular').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_tarjetaafiliadanopertenecetitular').val('NO');
                        $('#lblfechacorrecion_tarjetaafiliadanopertenecetitular').prop("disabled", true);
                        $('.tarjetaafiliadanopertenecetitular').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_recepmanual').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#recepmanual').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#recepmanual').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_recepmanual').val('SI');
                        $('#lblfechacorrecion_recepmanual').prop("disabled", false);
                        $('.recepmanual').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_recepmanual').val('NO');
                        $('#lblfechacorrecion_recepmanual').prop("disabled", true);
                        $('.recepmanual').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_descargaapp').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#descargaapp').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#descargaapp').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_descargaapp').val('SI');
                        $('#lblfechacorrecion_descargaapp').prop("disabled", false);
                        $('.descargaapp').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_descargaapp').val('NO');
                        $('#lblfechacorrecion_descargaapp').prop("disabled", true);
                        $('.descargaapp').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_capacitado').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#capacitado').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#capacitado').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_capacitado').val('SI');
                        $('#lblfechacorrecion_capacitado').prop("disabled", false);
                        $('.capacitado').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_capacitado').val('NO');
                        $('#lblfechacorrecion_capacitado').prop("disabled", true);
                        $('.capacitado').addClass('ocultar');
                        
                    }
                });

                $('#btnModalGestionC').on('click', function () {
                    $('#modal_gestionC').modal('show');
                   
                    $('#modalmotivoIncidencia').val('');
                    $('#modalsubmotivoIncidencia').val('');
                    $('#modalresuelto').val('');
                
                
                
                });

                
                
                
                $('#btnModalProductosC').on('click', function () {
                    cargarModalMotivoIncidencia();
                    cargarModalSubMotivoIncidencia("");

                    $('#modal_productosC').modal('show');
                    $('#btnEditar').hide();
                    $('#btnAgregar').show();
                    
                    $('.divbtnEditar').hide();

                    $('.divvisible').show();
                    
                    
                    $('#modalmotivoIncidencia').val('');
                    $('#modalsubmotivoIncidencia').val('');
                    $('#modalresuelto').val('');
                
                
                
                });
                $('#modalmotivoIncidencia').on('change', function () {
                    var txtmotivo=$(this).val();
                    cargarModalSubMotivoIncidencia(txtmotivo);
                });
                $('#modalestadollamada').on('change', function () {
                    var estadollamada=$(this).val();
                    if(estadollamada === 'DevolverLlamada' || estadollamada === 'ProgramacionWhatsapp'){
                        $('.clRellamada ').removeClass('ocultar');
                    } else {
                        $('.clRellamada ').addClass('ocultar');
                        $('#modalfechahoraRellamada').val('');
                    }
                
                });                
                
    const contenedorNuevosDatos = document.querySelector('#tbdatos tbody');
    
    

function datosHTMLN() {
    limpiarHTML(contenedorNuevosDatos);

    let resumen = '';
    let total = 0;
    let totalcantidad = 0;
    let totalCuota = 0;
    let fila = 1;

    let pesobruto = 0;

    let myJsonString = JSON.stringify(arregloDatos);


    arregloDatos.forEach(
        datos => {
            console.log(datos);
            const {
                IdIncidencia,
                Motivo,
                SubMotivo,
                FechaIncidencia,
                FechaSolucion,
                Resuelto
            } = datos;

            const row = document.createElement('tr');
            row.innerHTML = `
                            <td data-label="#">${fila}</td>
                            <td data-label="Motivo">${Motivo}</td>
                            <td data-label="SubMotivo">${SubMotivo}</td>
                            <td data-label="FechaIncidencia">${FechaIncidencia}</td>
                            <td data-label="Resuelto">
                            <a href="#" class="editar-producto btn ${Resuelto === 'SI' ? 'btn-success' : 'btn-danger'} btn-sm" style="margin-left: 5px;" data-id="${IdIncidencia}"> ${Resuelto}</a></td>
                            <td data-label="FechaSolucion">${FechaSolucion}</td>
                            <td data-label="Opciones"><a href="#" class="borrar-producto fa fa-fw  fa-trash" style="margin-right: 5px;color: #555;" data-id="${IdIncidencia}"></a></td>
                        `
            contenedorNuevosDatos.appendChild(row);


            console.log(arregloDatos.length);

            fila++;

        })

    $('#PesoBrutoTotal').val(pesobruto);
    $('#lbljsonofrecido').val(myJsonString);

}


//Elimina los cursos del tbody
function limpiarHTML(cont) {
    //forma recomendada
    while (cont.firstChild) {
        cont.removeChild(cont.firstChild);
    }

    $('#txtResumen').val('');
    $('#txtCantidad').val('');
    $('#txtTotal').val('');
    $('#txtJson').val('');
}


$('#tbdatos').on("click", function(e) {
    e.preventDefault();

    if (e.target.classList.contains('borrar-producto')) {
        const Producto = e.target.getAttribute('data-id');
        //Elimina del arreglo de articulosCarrito por el data-id
        console.log(arregloDatos);
        arregloDatos = arregloDatos.filter(datos => datos.IdIncidencia != Producto);
        datosHTMLN();
        console.log(arregloDatos);
    }

    if (e.target.classList.contains('editar-producto')) {
        $('#btnEditar').show();
        $('#btnAgregar').hide();
        $('.divvisible').hide();
        const Producto = e.target.getAttribute('data-id');
        
        console.log(Producto);

        let datosencontrados;
        datosencontrados = arregloDatos.find(datos => datos.IdIncidencia === Producto);
        console.log(datosencontrados);

        cargarModalMotivoIncidencia();
        cargarModalSubMotivoIncidencia(datosencontrados.Motivo);


        //Edita del arreglo de articulosCarrito por el data-id

        // $('#elemento').val(datosencontrados.IdItem).trigger('change');
        // $('#cantidad').val(datosencontrados.Cantidad);
        // $('#peso').val(datosencontrados.Peso);         

        $('#modal_productosC').modal('show');


        $('.divbtnEditar').show();
        $('#modalmotivoIncidencia').val(datosencontrados.Motivo);
        $('#modalsubmotivoIncidencia').val(datosencontrados.SubMotivo);
        $('#modalresuelto').val(datosencontrados.Resuelto);
        $('#modalfechaactual').val(datosencontrados.FechaIncidencia);
        

        

    }
})



$('#btnAgregar').on('click', function (e) {
    e.preventDefault();

    const Motivo = $('#modalmotivoIncidencia option:selected');
    const SubMotivo = $('#modalsubmotivoIncidencia option:selected');

    if (Motivo.val() != '' && SubMotivo.val()) {
        if (arregloDatos.find(item => item.Motivo === Motivo.val()) && arregloDatos.find(item => item.SubMotivo === SubMotivo.val())) {
            Swal.fire(
                'Error',
                'Incidencia, ya ingresado',
                'error'
            )

            return;
        }
 
        //GENERAR CODIGO DE ITEM PARA LA TABLA
        let totalFilas = arregloDatos.length + 1;
        let IdItem=Motivo.val()+'-'+SubMotivo.val();
        let MMotivo = Motivo.val();
        let MSubMotivo = SubMotivo.val();
        let FechaActual = moment().format('DD/MM/YYYY HH:mm');
        
        let data = {
            IdIncidencia:MMotivo+"-"+MSubMotivo,
            Motivo: MMotivo,
            SubMotivo: MSubMotivo,
            FechaIncidencia: FechaActual,
            FechaSolucion: '',
            Resuelto: 'NO',
        }

        arregloDatos = [...arregloDatos, data];

        datosHTMLN();

        $('#modal_productosC').modal('hide');


    } else {
        Swal.fire(
            'Error',
            'Debe seleccionar una Incidencia',
            'error'
        )
    }


})

$('#btnEditar').on('click', function(e) {
            e.preventDefault();
            
            
    const Motivo = $('#modalmotivoIncidencia option:selected');
    const SubMotivo = $('#modalsubmotivoIncidencia option:selected');
    const modalresuelto = $('#modalresuelto option:selected');
    const FechaActual=$('#modalfechaactual').val();
    console.log(modalresuelto.val());
    console.log(FechaActual);
    

  if (modalresuelto.val() != '') {
        //GENERAR CODIGO DE ITEM PARA LA TABLA

        let totalFilas = arregloDatos.length + 1;
        let IdItem=Motivo.val()+'-'+SubMotivo.val();
        let MMotivo = Motivo.val();
        let MSubMotivo = SubMotivo.val();
        let FechaSolucion = moment().format('DD/MM/YYYY HH:mm');
        let Resuelto=modalresuelto.val();
        if(modalresuelto.val()=="SI"){
            FechaSolucion=moment().format('DD/MM/YYYY HH:mm');
        }else{
            FechaSolucion='';
        }
        
        console.log(FechaSolucion);
        
        let data = {
            IdIncidencia:IdItem,
            Motivo: MMotivo,
            SubMotivo: MSubMotivo,
            FechaIncidencia: FechaActual,
            FechaSolucion: FechaSolucion,
            Resuelto: Resuelto,
        }
        
        console.log(data);
        
        

        
        arregloDatos = arregloDatos.map(datos => datos.IdIncidencia === data.IdIncidencia ? data : datos)
        

        datosHTMLN();
        
        $('#modal_productosC').modal('hide');


    } else {
        Swal.fire(
            'Error',
            'Debe seleccionar Elemnto o sin cantidad',
            'error'
        )
    }
    



})

 $('#btnAgregarGestion').click(function() {
  var modalestadollamada = $('#modalestadollamada option:selected').val();
  var modalfechahoraRellamada = $('#modalfechahoraRellamada').val();
  var modalcomentario_cert = $('#modalcomentario_cert').val();
  
var idcertventa = $('#idcertventa').val();
                    

                var matricula = $('#headerMatriculaUsuario').val();

                var ediventa = $("#idVenta").val();
                
                var lbltipocierre_cert = $("#lbltipocierre_cert").val();
                

var lblasignado= $("#lblasignado").val();
var lblfechaapertura_cert= $("#lblfechaapertura_cert").val();
var numerollamadas= $("#lblnumerollamadas").val();


 var datos = {
                    array:'array7',
                    modalestadollamada: modalestadollamada,
                    modalfechahoraRellamada: modalfechahoraRellamada,
                    modalcomentario_cert: modalcomentario_cert,
                    ediventa: ediventa,
                    idcertventa: idcertventa,
                    matricula:matricula,
                    lbltipocierre_cert:lbltipocierre_cert,
                    lblasignado:lblasignado,
                    lblfechaapertura_cert:lblfechaapertura_cert,
                    numerollamadas:numerollamadas
                    
 }
 
            Swal.fire({
                title: '¿Deseas guardar Gestion?',
                html: '',
                showCancelButton: true,
                confirmButtonText: `Guadar`,
                icon: 'info',
            }).then((result) => {
                //GESTION
                if (result.isConfirmed) {
                    
                $("#lblestadollamada").val(modalestadollamada);
               
                $("#lblfechahoraprogramacion").val(modalfechahoraRellamada);
                 $("#lblcomentario_cert").val(modalcomentario_cert);
                    
                        $.ajax({
                                type: 'POST',
                                url: './Controller/ControllerVenta.php',
	                            data: {function: JSON.stringify(datos)},                                
                                dataType: "Json",
                                success: function(data) {
                                    console.log(data);
                                    if (data.respuesta == 'exito') {
                                        Swal.fire({
                                           title:'Agregado la gestión con exito!',
                                           text:'Gestion!',
                                           icon:'success',
                                           showCancelButton:false,
                                           confirmButtonColor:'',
                                           confirmButtonText:'OK',
                                           closeOnConfirm: false,
                                           allowOutsideClick: false                          
                                        }).then((result)=>{
                                            if(result.isConfirmed){
                                                $("#lblnumerollamadas").val(data.numerollamadas);
                                                $("#lblfechaultimallamada").val(data.fechaultimallamada);
   
                                            }
                                        });

                                    } else if (data.respuesta == 'sincambios') {
                                        alertify.warning("No se ha realizado ninguna modificación");

                                    } else {
                                        alertify.error("Fallo el server");

                                    }
                                }
                            });
                $('#modal_gestionC').modal('hide');
                }else {
                    return;
                }
            })

              
 

 });


            $('#btnGuardarResumenVenta').on('click', function () {
                    
                    var lblasignado=$('#lblasignado').val();
                    var lblfechaapertura_cert=$('#lblfechaapertura_cert').val();
                    var lbltipocierre_cert = $("#lbltipocierre_cert").val();
                    var lblsolucionincidencia_cert = $("#lblsolucionincidencia_cert").val();
                    var lblfechanacimiento=$('#lblfechanacimiento').val();
                    var lbltipogenero=$('#lbltipogenero').val();
                    var lblformapago_cert=$('#lblformapago_cert').val();
                    const detalleIncidencia = JSON.stringify(arregloDatos);
                    
                    var idcertventa = $('#idcertventa').val();

                    var matricula = $('#headerMatriculaUsuario').val();

                    var ediventa = $("#idVenta").val();
                    
                    var lblcomentario_cert = $('#lblcomentario_cert').val();

                var datos = {
                    array:'array9',
                    lblasignado:lblasignado,
                    lblfechaapertura_cert:lblfechaapertura_cert,
                    lbltipocierre_cert:lbltipocierre_cert,
                    lblsolucionincidencia_cert:lblsolucionincidencia_cert,
                    lblfechanacimiento:lblfechanacimiento,
                    lbltipogenero:lbltipogenero,
                    lblformapago_cert:lblformapago_cert,
                    detalleIncidencia:detalleIncidencia,                   
                    ediventa: ediventa,
                    idcertventa: idcertventa,
                    matricula:matricula,
                    lblcomentario_cert:lblcomentario_cert
                };

            Swal.fire({
                title: '¿Deseas guardar Resumen de venta?',
                html: '',
                showCancelButton: true,
                confirmButtonText: `Guardar`,
                icon: 'info',
            }).then((result) => {
                //GESTION
                if (result.isConfirmed) {
                    
                           
                            $.ajax({
                                type: 'POST',
                                url: './Controller/ControllerVenta.php',
	                            data: {function: JSON.stringify(datos)},                                
                                dataType: "Json",
                                success: function(data) {
                                    console.log(data);
                                    
                                    
                                    if (data.respuesta == 'exito') {
                                        
                                        $('#idcertventa').val(data.IdCertVenta);
                                        
                                        Swal.fire({
                                          title:'Modificado con exito!',
                                          text:'Gestion!',
                                          icon:'success',
                                          showCancelButton:false,
                                          confirmButtonColor:'',
                                          confirmButtonText:'OK',
                                          closeOnConfirm: false,
                                          allowOutsideClick: false                          
                                        }).then((result)=>{
                                            if(result.isConfirmed){
                                               //window.location.reload();
                                               
                                            }
                                        });

                                    } else if (data.respuesta == 'sincambios') {
                                        alertify.warning("No se ha realizado ninguna modificación");

                                    } else {
                                        alertify.error("Fallo el server");

                                    }
                                }
                            });
                
                    $('#modal_respuestaC').modal('hide');    
                    
                }
            })


                
                });


                $('#btnModalRespuestaC').on('click', function () {
                    $('#modal_respuestaC').modal('show');
                   
                    $('#modalhorariosugerido').val('');
                    $('#modalcomentario_comercial').val('');
                
                });
                
                $('#btnAgregarRespuesta').on('click', function () {
                    
                    var modalhorariosugerido=$('#modalhorariosugerido').val();
                    var modalcomentario_comercial=$('#modalcomentario_comercial').val();
                    
                    var idcertventa = $('#idcertventa').val();
                    

                var matricula = $('#headerMatriculaUsuario').val();

                var ediventa = $("#idVenta").val();
                
                var lbltipocierre_cert = $("#lbltipocierre_cert").val();
                
                
                
                
                var datos = {
                    array:'array5',
                    lblcomentario_comercial: modalcomentario_comercial,
                    lblhorariosugerido2: modalhorariosugerido,
                    ediventa: ediventa,
                    idcertventa: idcertventa,
                    matricula:matricula,
                    lbltipocierre_cert:lbltipocierre_cert
                };

            Swal.fire({
                title: '¿Deseas guardar respuesta comercial?',
                html: '',
                showCancelButton: true,
                confirmButtonText: `Guardar`,
                icon: 'info',
            }).then((result) => {
                //GESTION
                if (result.isConfirmed) {
                    
                            $('#lblhorariosugerido2').val(modalhorariosugerido);
                            $('#lblcomentario_comercial').val(modalcomentario_comercial);

                            $.ajax({
                                type: 'POST',
                                url: './Controller/ControllerVenta.php',
	                            data: {function: JSON.stringify(datos)},                                
                                dataType: "Json",
                                success: function(data) {
                                    console.log(data);
                                    if (data.respuesta == 'exito') {
                                        Swal.fire({
                                          title:'Modificado con exito!',
                                          text:'Gestion!',
                                          icon:'success',
                                          showCancelButton:false,
                                          confirmButtonColor:'',
                                          confirmButtonText:'OK',
                                          closeOnConfirm: false,
                                          allowOutsideClick: false                          
                                        }).then((result)=>{
                                            if(result.isConfirmed){
                                               //window.location.reload();
                                               
                                            }
                                        });

                                    } else if (data.respuesta == 'sincambios') {
                                        alertify.warning("No se ha realizado ninguna modificación");

                                    } else {
                                        alertify.error("Fallo el server");

                                    }
                                }
                            });
                
                    $('#modal_respuestaC').modal('hide');    
                    
                }
            })


                
                });


                
    </script>




</body>

</html>