<?php
	header("Content-Type: text/html;charset=utf-8");
	session_start();
	if (!isset($_SESSION['user_login_status'])) {
	    header("location: ./login/index.php");
	    exit;
	}
	
// 	if (($_SESSION['pzvtageneral'] + $_SESSION['pzvta150'] + $_SESSION['pzvta151'] + $_SESSION['pzvta152'] + $_SESSION['pzvta153'] + $_SESSION['pzvta154'] + $_SESSION['pzvta155'] + $_SESSION['pzvta156'] + $_SESSION['pzvta120'] + $_SESSION['pzvta40'] + $_SESSION['pzwbfactufoto'] + $_SESSION['pzmktmarketing']) == 0) {
// 	    header("location: ./denegado.php");
// 	    exit;
// 	}
		RECURSO:
	date_default_timezone_set('America/Lima');
	function myUrlEncode($string){
	    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
	    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
	    return str_replace($entities, $replacements, urlencode($string));
	}

	function format_date_dd_mm_Y($date)
	{
	    return date('d/m/Y', strtotime($date));
	}
	function format_date_Y_mm_dd($date)
	{
	    return date('Y-m-d', strtotime($date));
	}
	
	include 'config/db.php';
	include 'config/conexion.php';
    require (__DIR__) . '/helper/helper_validacion.php';
    
	$rc = NULL;
	
	if (isset($_GET['idventa']) && isset($_GET['rc'])) {
        /* ANÁLISIS DE LAS VARIABLES ENVIADAS POR GET */
	    $idventa = sanitizaCampo($_GET['idventa'], 'sanitizeint|scapestring|htmlspecialchars', $con);
	    $idventa = htmlspecialchars($idventa);
	    $rc = sanitizaCampo($_GET['rc'], 'sanitizestring|scapestring|htmlspecialchars', $con);
	    $rc = htmlspecialchars($rc);
	} else {
	    header("location: ./denegado.php");
	    exit;
	}
	
	$fechames = date("M-Y");

    /* CONSULTA PREPARADA N°01 */
    $queryEditarVenta = "SELECT 
    u.IdUsuario,
    v.Matricula,
    v.Comercial,
    v.CC,
    v.JefeVenta,
    CONCAT(m.Nombres,' ',m.Apellidos) NombJefeVenta,
    v.EstadoVenta,
    v.CategoriaVenta,
    v.TipoVenta,
    v.Segmento,
    v.MesesAutorizado,
    v.NProspecto,
    v.NContrato,
    v.IdCliente,
    c.NombApellido Cliente,
    c.Correo,
    c.Telefonouno,
    c.Telefonodos,
    c.Direccion,
    c.Interior,
    g.prioridadChip,
    g.IdGeografico,
    g.Distrito,
    g.Provincia,
    v.PrecioKit,
    v.TotalExtra,
    v.ResumenVenta,
    v.ExtraAutorizado,
    v.FormaPago,
    v.N590,
    v.PAI,
    v.EstadoVisita,
    v.CCOriginal,
    v.ContactadoCO,
    v.ComentarioCO,
    v.VTAConfirmadaCO,
    agen.IdAgenda,
    agen.InstaladoX,
    agen.MatriculaTec,
    CONCAT(t.Nombres,' ',t.Apellidos) Instalador,
    t.LN LNInstalador,
    DATE_FORMAT(agen.FechaInst, '%d/%m/%Y') FechaInst, 
    TIME_FORMAT(agen.HoraInst,'%r') HoraInst,
    agen.Comentario,
    agen.MotivoInviable,
    agen.MotivoCancelada,
    agen.Repercusion,
    f.MotivoIncidencia,
    DATE_FORMAT(f.FechaRecepcionDOC, '%d/%m/%Y') FechaRecepcionDOC,
    DATE_FORMAT(f.FechaFacturacion, '%d/%m/%Y') FechaFacturacion,
    f.DOCOriginal,
    f.Segmentacion,
    f.Pago,
    f.Autoriza,
    f.DNI,
    f.ElementosCTOPS,
    f.DOCPAI,
    f.FaltaDOC,
    f.RehacerCTO,
    f.Afiliacion,
    f.Prospecto_NroGuia,
    f.FueraHora,
    v.TipoKIT,
    v.CantidadExtras,
    v.ClosingPack,
    v.ScoringRP,
    v.PrecioEspecial,
    v.HojaCertificacion,
    v.IdConsultaScoringRP,
    c.IdDocRP,
    v.GGCC,
    v.RegalosAutorizados,
    v.CantidadRegalo,
    sc.NumeroDocumento as DocumentoScoring,
    CASE WHEN sc.TipoDocumento=6 THEN sc.RazonSocial ELSE CONCAT(sc.Nombres,' ',sc.ApellidoPaterno,' ',sc.ApellidoMaterno) END as NombreScoring,
    sc.Nombres as NombresScoring,
    sc.ApellidoPaterno as ApellidoPaternoScoring,
    sc.ApellidoMaterno as ApellidoMaternoScoring,
    sc.TipoDocumento as TipoDocumentoScoring,
    sc.NumeroDocumento as DocumentoScoring,
    v.CategoriaPrecio,
    v.dsctCuota,
    v.ClosingpackAutorizados,
    v.CategoriaKitAutorizados,
    v.DescuentoCuotaAutorizados,
    vc.DetalleGeneral,
    vc.DetalleExtras,
    vc.DetalleRegalos,
    v.TotalCuotaMonitoreo,
    v.TipoCamaraKit,
    v.SegundaAlarma,
    p.IdProvincial,
    p.IdDepartamental,
    v.OrigenVisita,
    att.IdAttec,
    DATE_FORMAT(att.FechaAuditoria, '%d/%m/%Y') FechaAuditoria,
    att.EstadoAttec,
    att.DatosSbn,
    att.DatosSbn_NoCoincide,
    DATE_FORMAT(att.F_CorreccionDatosSbn, '%d/%m/%Y') F_CorreccionDatosSbn,
    att.SegIncorrecto,
    DATE_FORMAT(att.F_CorreccionSegIncorrecto, '%d/%m/%Y') F_CorreccionSegIncorrecto,
    att.Seg_DebeDecir,
    att.Imagen,
    DATE_FORMAT(att.F_Imagen, '%d/%m/%Y') F_Imagen,
    att.Imagen_Motivo,
    att.IngresoProgramacion,
    DATE_FORMAT(att.F_CorreccionIngresoProgramacion, '%d/%m/%Y') F_CorreccionIngresoProgramacion,
    att.FallosCobertura,
    DATE_FORMAT(att.F_CorreccionFallosCobertura, '%d/%m/%Y') F_CorreccionFallosCobertura,
    att.MissingTest,
    DATE_FORMAT(att.F_CorreccionMissingTest, '%d/%m/%Y') F_CorreccionMissingTest,
    att.ZeroVision,
    DATE_FORMAT(att.F_CorreccionZeroVision, '%d/%m/%Y') F_CorreccionZeroVision,
    att.FalloSupervision,
    DATE_FORMAT(att.F_CorreccionFalloSupervision, '%d/%m/%Y') F_CorreccionFalloSupervision,
    att.FalloSupervision_Dispotivos,
    att.Tamper,
    DATE_FORMAT(att.F_CorreccionTamper, '%d/%m/%Y') F_CorreccionTamper,
    att.Tamper_Dispotivos,
    att.Comentario as ComentarioAttec,
    att.Zerovision_motivo,
    v.IdCertVenta,
    v.FechaApertura,
    DATE_FORMAT(vtacert.FechaCierre,'%d/%m/%Y') FechaCierre,
    vtacert.TipoCierre,
    vtacert.MotivoIncidencia as MotivoIncidenciaCert,
    vtacert.SolucionIncidencia,
    vtacert.IncidenciaTecnica,
    vtacert.FormaPago as FormaPagoCert,
    vtacert.Comentario as ComentarioCert,
    v.GestorCertVenta,
    CONCAT(cer.Nombres,' ',cer.Apellidos) NombGestorCertVenta,
    g.CodUbigeoReniec,
    v.ContratoEnviado,
    v.ContratoCorrecto,
    f.ResultadoValidacion,
    DATE_FORMAT(v.FechaContratoEnviado, '%d/%m/%Y') FechaContratoEnviado,
    docv.Documento as DocumentoVisita,
    v.pagoenviadoCO,
    v.montoCO,
    v.motivoincidenciaCO,
    v.contratocorregidoenviadoCO,
    DATE_FORMAT(v.fechadiferenciaCO, '%d/%m/%Y') fechadiferenciaCO,
    DATE_FORMAT(v.fechaenviocontratocorregidofinalCO, '%d/%m/%Y') fechaenviocontratocorregidofinalCO,
    v.diferenciamontoCO,
    v.comentarior2CO,DATE_FORMAT(v.fechagestiondocCO, '%d/%m/%Y') fechagestiondocCO,DATE_FORMAT(v.fechagestiondocr2CO, '%d/%m/%Y') fechagestiondocr2CO,
    f.TipoContrato,
    f.Autorizado,
    f.CambioFisico,
    f.Comentarios,
    vtacert.kitnoinstalado,
    DATE_FORMAT(vtacert.fechacorrecion_kitnoinstalado,'%d/%m/%Y') fechacorrecion_kitnoinstalado,
    vtacert.errorcomprobantepago,
    DATE_FORMAT(vtacert.fechacorrecion_errorcomprobantepago,'%d/%m/%Y') fechacorrecion_errorcomprobantepago,
    vtacert.errorsegmento,
    DATE_FORMAT(vtacert.fechacorrecion_errorsegmento,'%d/%m/%Y') fechacorrecion_errorsegmento,
    vtacert.fueranomalcomercial,
    DATE_FORMAT(vtacert.fechacorrecion_fueranomalcomercial,'%d/%m/%Y') fechacorrecion_fueranomalcomercial,
    vtacert.fueranormativatecnica,
    DATE_FORMAT(vtacert.fechacorrecion_fueranormativatecnica,'%d/%m/%Y') fechacorrecion_fueranormativatecnica,
    vtacert.incidenciadatos,
    DATE_FORMAT(vtacert.fechacorrecion_incidenciadatos,'%d/%m/%Y') fechacorrecion_incidenciadatos,
    vtacert.inconformidadfuncionamiento,
    DATE_FORMAT(vtacert.fechacorrecion_inconformidadfuncionamiento,'%d/%m/%Y') fechacorrecion_inconformidadfuncionamiento,
    vtacert.inconformidadpagoinicial,
    DATE_FORMAT(vtacert.fechacorrecion_inconformidadpagoinicial,'%d/%m/%Y') fechacorrecion_inconformidadpagoinicial,
    vtacert.inconformidadpagomensual,
    DATE_FORMAT(vtacert.fechacorrecion_inconformidadpagomensual,'%d/%m/%Y') fechacorrecion_inconformidadpagomensual,
    vtacert.inconformidadtiempopermanencia,
    DATE_FORMAT(vtacert.fechacorrecion_inconformidadtiempopermanencia,'%d/%m/%Y') fechacorrecion_inconformidadtiempopermanencia,
    vtacert.inconformidadubicaciondispositivos,
    DATE_FORMAT(vtacert.fechacorrecion_inconformidadubicaciondispositivos,'%d/%m/%Y') fechacorrecion_inconformidadubicaciondispositivos,
    vtacert.noconcefuncionamiento,
    DATE_FORMAT(vtacert.fechacorrecion_noconcefuncionamiento,'%d/%m/%Y') fechacorrecion_noconcefuncionamiento,
    vtacert.notienecontrato,
    DATE_FORMAT(vtacert.fechacorrecion_notienecontrato,'%d/%m/%Y') fechacorrecion_notienecontrato,
    vtacert.promesaspendientes,
    DATE_FORMAT(vtacert.fechacorrecion_promesaspendientes,'%d/%m/%Y') fechacorrecion_promesaspendientes,
    vtacert.reclamocomercial,
    DATE_FORMAT(vtacert.fechacorrecion_reclamocomercial,'%d/%m/%Y') fechacorrecion_reclamocomercial,
    vtacert.solicitabaja,
    DATE_FORMAT(vtacert.fechacorrecion_solicitabaja,'%d/%m/%Y') fechacorrecion_solicitabaja,
    vtacert.tarjetaafiliadanopertenecetitular,
    DATE_FORMAT(vtacert.fechacorrecion_tarjetaafiliadanopertenecetitular,'%d/%m/%Y') fechacorrecion_tarjetaafiliadanopertenecetitular,
    vtacert.recepmanual,
    DATE_FORMAT(vtacert.fechacorrecion_recepmanual,'%d/%m/%Y') fechacorrecion_recepmanual,
    vtacert.descargaapp,
    DATE_FORMAT(vtacert.fechacorrecion_descargaapp,'%d/%m/%Y') fechacorrecion_descargaapp,
    vtacert.capacitado,
    DATE_FORMAT(vtacert.fechacorrecion_capacitado,'%d/%m/%Y') fechacorrecion_capacitado,
    vtacert.numerollamadas,
    vtacert.FechaPendiente,
    vtacert.FechaPrimeraGestion,
    vtacert.FechaFinalizadoconIncidencia,
    vtacert.FechaResuelto,
    vtacert.ComentarioComercial,
    vtacert.RespComercial,
    vtacert.nuevohorarioSugerido        
    FROM yifi58ge_dbVENTAS.tblventa v 
    INNER JOIN yifi58ge_dbUSUARIO.tblusuario u on v.IdUsuario=u.IdUsuario 
    INNER JOIN yifi58ge_dbUSUARIO.tblarea a on a.IdArea=u.IdArea 
    INNER JOIN yifi58ge_dbUSUARIO.tblusuario m on m.Matricula=u.Manager
    INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente
    INNER JOIN yifi58ge_dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
    INNER JOIN yifi58ge_dbVENTAS.tblagenda agen on agen.IdVenta=v.IdVenta
    INNER JOIN yifi58ge_dbVENTAS.tblfacturacion f on f.IdVenta=v.IdVenta
    LEFT JOIN yifi58ge_dbUSUARIO.tblusuario t on t.Matricula=agen.MatriculaTec
    LEFT JOIN yifi58ge_dbVENTAS.tbltmpscoring sc on sc.IdConsultaScoring=v.IdConsultaScoringRP
    LEFT JOIN yifi58ge_dbVENTAS.tblventacotizacion vc ON v.IdVenta = vc.IdVenta
    LEFT JOIN yifi58ge_dbVENTAS.tblattec att on att.IdVenta=v.IdVenta
    LEFT JOIN yifi58ge_dbVENTAS.tbldistrital dd on dd.CodUbigeoReniec=g.CodUbigeoReniec
    LEFT JOIN yifi58ge_dbVENTAS.tblprovincial p on p.IdProvincial=dd.IdProvincial
    LEFT JOIN yifi58ge_dbVENTAS.tblcertificacionventa vtacert on vtacert.IdCertVenta=v.IdCertVenta
    LEFT JOIN yifi58ge_dbUSUARIO.tblusuario cer on cer.Matricula=v.GestorCertVenta
    LEFT JOIN yifi58ge_dbVENTAS.tbldocumento docv on docv.IdDoc=c.IdDocVisita    
    WHERE v.IdVenta=?";

    try{       
        $stmt = $con->prepare($queryEditarVenta);
        $stmt->bind_param('i', $idventa);
        $stmt->execute();
        //$respuesta = $stmt->store_result();
        $stmt->bind_result($idu, $matricula, $comercial, $dc, $matjefe, $jefeventa, $estadoventa, $categoriaventa, $tipoventa, $segmento, $mesesautorizados, $nprospecto, $ncontrato, $idcliente, $cliente, $correo, $movil, 
        $fijo, $direccion, $Interior, $sims, $idgeografico, $distrito, $provincia, $preciokit, $totalextra, $resumenventa, $regaloutorizado, $formadepago, $n590, $PAI, $estadovisita, $CCOriginal, $contactadoco, $comentarioco, 
        $VTAConfirmadaCO, $idagenda, $instaladox, $matriculatec, $nomreinstalador, $lninstalador, $fechainstalacionver, $horainstalacionver, $comentarioagenda, $motivoinviable, $motivocancelado, $repercucion, $factmotivoincidencia, 
        $factfecharecepciondoc, $factfechafacturacion, $factdocoriginal, $factsegmentacion, $factpago, $factautoriza, $factdni, $factelementosctops, $factdocpai, $factfaltadoc, $factrehacercto, $factafiliacion, $factprospecto_nroguia, 
        $factfuerahora, $TipoKIT, $CantidadExtras, $ClosingPack, $ScoringRP, $PrecioEspecial, $HojaCertificacion, $IdConsultaScoringRP, $IdDocRP, $GGCC, $RegalosAutorizados, $CantidadRegalo, $DocumentoScoring, $NombreScoring, 
        $NombresScoring, $ApellidoPaternoScoring, $ApellidoMaternoScoring, $TipoDocumentoScoring, $DocumentoScoring, $CategoriaPrecio, $dsctCuota, $ClosingpackAutorizados, $CategoriaKitAutorizados, $DescuentoCuotaAutorizados, 
        $DetalleGeneral, $DetalleExtras, $DetalleRegalos, $TotalCuotaMonitoreo, $TipoCamaraKit, $SegundaAlarma, $IdProvincial, $IdDepartamental, $OrigenVisita, $idattec, $FechaAuditoria, $EstadoAttec, $DatosSbn, $DatosSbn_NoCoincide, 
        $F_CorreccionDatosSbn, $SegIncorrecto, $F_CorreccionSegIncorrecto, $Seg_DebeDecir, $Imagen, $F_Imagen, $Imagen_Motivo, $IngresoProgramacion, $F_CorreccionIngresoProgramacion, $FallosCobertura, $F_CorreccionFallosCobertura, 
        $MissingTest, $F_CorreccionMissingTest, $ZeroVision, $F_CorreccionZeroVision, $FalloSupervision, $F_CorreccionFalloSupervision, $FalloSupervision_Dispotivos, $Tamper, $F_CorreccionTamper, $Tamper_Dispotivos, $ComentarioAttec, 
        $Zerovision_motivo, $idcertventa, $FechaApertura, $FechaCierre, $TipoCierre, $MotivoIncidencia, $SolucionIncidencia, $inci_tecnica, $FormaPagoCert, $ComentarioCert, $GestorCertVenta, $NombGestorCertVenta, $CodUbigeoReniec, 
        $ContratoEnviado, $ContratoCorrecto, $ResultadoValidacion, $FechaContratoEnviado,$DocumentoVisita,$pagoenviadoCO,$montoCO,$motivoincidenciaCO,$contratocorregidoenviadoCO,$fechadiferenciaCO,$fechaenviocontratocorregidofinalCO,$diferenciamontoCO,$comentarior2CO,
        $fechagestiondocCO,$fechagestiondocr2CO,$TipoContrato,$Autorizado,$CambioFisico,$Comentarios,
        $kitnoinstalado,
        $fechacorrecion_kitnoinstalado,
        $errorcomprobantepago,
        $fechacorrecion_errorcomprobantepago,
        $errorsegmento,
        $fechacorrecion_errorsegmento,
        $fueranomalcomercial,
        $fechacorrecion_fueranomalcomercial,
        $fueranormativatecnica,
        $fechacorrecion_fueranormativatecnica,
        $incidenciadatos,
        $fechacorrecion_incidenciadatos,
        $inconformidadfuncionamiento,
        $fechacorrecion_inconformidadfuncionamiento,
        $inconformidadpagoinicial,
        $fechacorrecion_inconformidadpagoinicial,
        $inconformidadpagomensual,
        $fechacorrecion_inconformidadpagomensual,
        $inconformidadtiempopermanencia,
        $fechacorrecion_inconformidadtiempopermanencia,
        $inconformidadubicaciondispositivos,
        $fechacorrecion_inconformidadubicaciondispositivos,
        $noconcefuncionamiento,
        $fechacorrecion_noconcefuncionamiento,
        $notienecontrato,
        $fechacorrecion_notienecontrato,
        $promesaspendientes,
        $fechacorrecion_promesaspendientes,
        $reclamocomercial,
        $fechacorrecion_reclamocomercial,
        $solicitabaja,
        $fechacorrecion_solicitabaja,
        $tarjetaafiliadanopertenecetitular,
        $fechacorrecion_tarjetaafiliadanopertenecetitular,
        $recepmanual,
        $fechacorrecion_recepmanual,
        $descargaapp,
        $fechacorrecion_descargaapp,
        $capacitado,
        $fechacorrecion_capacitado,
        $numerollamadas,
        $FechaPendiente,
        $FechaPrimeraGestion,
        $FechaFinalizadoconIncidencia,
        $FechaResuelto,
        $ComentarioComercial,
        $RespComercial,
        $nuevohorarioSugerido);
        $stmt->fetch();
        $stmt->close();
        
        if(!empty($GestorCertVenta)){
	        $htmlGestor='<option value="'.$GestorCertVenta.'" selected>'.$GestorCertVenta.' - '.$NombGestorCertVenta.'</option>';
	    }else{
	        $htmlGestor='<option value="" selected>Seleccione</option>';
	    }

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
    
    
    /* CONSULTA PREPARADA N°02 */
    $queryCodigo = "SELECT ts.NumeroOperacion FROM tbltmpscoring ts WHERE ts.IdConsultaScoring=?";    
	
	try{       
        $stmt = $con->prepare($queryCodigo);
        $stmt->bind_param('i', $IdConsultaScoringRP);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($CodigoOperacionScoring);
        $stmt->fetch();
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
    
    /* CONSULTA PREPARADA N°03 */
    $querySql = "SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) JefeVenta FROM yifi58ge_dbUSUARIO.tblusuario u  where u.CC=? AND (u.Categoria ='JE' OR u.Categoria ='COACH' OR u.Categoria ='DEL' or u.Categoria='JE/DEL' or u.Categoria='GERENTE TERRITORIAL') LIMIT 50";
	$html = NULL;
	
	try{       
        $stmt = $con->prepare($querySql);
        $stmt->bind_param('i', $CCOriginal);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($Matricula, $JefeVenta);
        
        if($stmt->num_rows > 0){
            while($row = $stmt->fetch()){
    	        if ($Matricula == $matjefe) {
    	            $html .= '<option value="' . $Matricula . '" selected>' . $Matricula . ' - ' . $JefeVenta . ' </option>';
    	        } else {
    	            $html .= '<option value="' . $Matricula . '">' . $Matricula . ' - ' . $JefeVenta . ' </option>';
    	        }      
            }
        }else{
            $html .= '<option>No se encontraron resultados.</option>';
        }        
        
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
    
    /* CONSULTA PREPARADA N°04 */
	$html_tecnico = NULL;
	
	if ($lninstalador == "" || empty($lninstalador)) {
	    $html_tecnico .= '<option></option>';
	} else {
	    $queryTecnico = "SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) Instalador FROM yifi58ge_dbUSUARIO.tblusuario u INNER JOIN yifi58ge_dbUSUARIO.tblarea a on a.IdArea=u.IdArea WHERE u.LN=?";
	    
    	try{       
            $stmt = $con->prepare($queryTecnico);
            $stmt->bind_param('i', $lninstalador);
            $stmt->execute();
            $stmt->store_result();
            $stmt->bind_result($MatriculaT, $Instalador);
            
            if($stmt->num_rows > 0){
                while($rowt = $stmt->fetch()){
    	            if ($MatriculaT == $matriculatec) {
    	                $html_tecnico .= '<option value="' . $MatriculaT . '" selected>' . $MatriculaT . ' - ' . ($Instalador) . ' </option>';
    	            } else {
    	                $html_tecnico .= '<option value="' . $MatriculaT . '">' . $MatriculaT . ' - ' . ($Instalador) . ' </option>';
    	            }     
                }
            }else{
                $html_tecnico .= '<option>No se encontraron resultados.</option>';
            }        
            
            $stmt->close();
    
        } catch(PDOException $e) {
            echo "Error: " . $e->getMessage();
        }	
	}
	
	/* INFORMACION EXISTE PRECIO BOMBA */
	$resultadoPrecioBomba = 'SI';
	
	/* INFORMACIÓN DE AFILIACIÓN */
	if(!empty($ncontrato)){
        /* CONSULTA PREPARADA N°05 */
	    $queryAfiliacion = "SELECT status,ACTION_DESCRIPTION,dataMap FROM yifi58ge_dbREFERIDO.tblafiliacion where beneficiaryId=?";
	    
    	try{       
            $stmtAfiliacion = $con->prepare($queryAfiliacion);
            $stmtAfiliacion->bind_param('i', $ncontrato);
            $stmtAfiliacion->execute();
            $stmtAfiliacion->store_result();
            $stmtAfiliacion->bind_result($statusAfiliacion, $actionDescriptionAfiliacion, $dataMapAfiliacion);
            
            if($stmtAfiliacion->num_rows > 0){
                while($rowafi = $stmtAfiliacion->fetch()){
	                $estadoafiliacion = $statusAfiliacion;
	                $ACTION_DESCRIPTION = $actionDescriptionAfiliacion;
	                $dataMap = $dataMapAfiliacion;
	                
	                if(isset($dataMap) && !empty($dataMap)){
	                    $objAfiliacion = json_decode($dataMap, true);
	                    if(isset($objAfiliacion['mensaje_autorizacion']['dataMap']['CARD'])){
	                        $card=$objAfiliacion['mensaje_autorizacion']['dataMap']['CARD'];
	                        $tipocuenta='Tarjeta';
	                    } else {
	                        $card='';
	                        $tipocuenta='';
	                    }
	                }     
                }
            } else {
	            $estadoafiliacion = 'Pendiente';
	            $ACTION_DESCRIPTION = '';
	            $dataMap = '';
	            $card = '';
	            $tipocuenta = '';
            }        
            
            $stmtAfiliacion->close();
    
        } catch(PDOException $e) {
            echo "Error: " . $e->getMessage();
        }
        
        /* CONSULTA PREPARADA N°06 */
        $variablecuenta = array('Diners Club','visa','mastercard','American Express');
        $queryVariableCuenta = "SELECT id,status,motivo,numero,tipo,correo FROM yifi58ge_dbREFERIDO.tblmdpafiliacion where ncontrato=?"; 
        
    	try{       
            $stmtVariableC = $con->prepare($queryVariableCuenta);
            $stmtVariableC->bind_param('i', $ncontrato);
            $stmtVariableC->execute();
            $stmtVariableC->store_result();
            $stmtVariableC->bind_result($idAfiliacionMDP, $statusAfiliacionMDP, $motivoAfiliacionMDP, $numeroAfiliacionMDP, $tipoAfiliacionMDP, $correoAfiliacionMDP);
            
            if($stmtVariableC->num_rows > 0){
                while($rowvariablec = $stmtVariableC->fetch()){
    	            $idnmdp = $idAfiliacionMDP;
    	            $estadoafiliacionmdp = $statusAfiliacionMDP;
    	            $motivomdp = $motivoAfiliacionMDP;
    	            $card = $numeroAfiliacionMDP;
    	            $tipo = $tipoAfiliacionMDP;
    	            $correoenviomdp = $correoAfiliacionMDP;
    	            
    	            if(in_array($tipo, $variablecuenta)){
    	               $tipocuenta = 'Tarjeta'; 
    	            } else {
    	               $tipocuenta = 'Cuenta'; 
    	            }  
                }
            } else {
                $idnmdp='';
    	        $estadoafiliacionmdp='';
    	        $motivomdp='';
    	        $tipo='';
    	        $correoenviomdp='';
    	        $tipocuenta='';
    	    }      
            
            $stmtVariableC->close();
    
        } catch(PDOException $e) {
            echo "Error: " . $e->getMessage();
        }        
        
	    
	} else {
        $estadoafiliacion = 'Pendiente';
	    $ACTION_DESCRIPTION = '';
	    $dataMap = '';
	    $card = '';
	    $tipocuenta = '';	    
	}
?>
<!DOCTYPE html>
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<title>Verisure | VeriSmart</title>
		<!-- Tell the browser to be responsive to screen width -->
		<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
		<link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png">
		<!-- Bootstrap 3.3.7 -->
		<link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css?v=1">
		<!-- Font Awesome -->
		<link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
		<!-- Ionicons -->
		<link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">
		<!-- Theme style -->
		<link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
		<!-- AdminLTE Skins. Choose a skin from the css/skins
			folder instead of downloading all of them to reduce the load. -->
		<link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">
		<!-- bootstrap datepicker -->
		<link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
		<!-- iCheck for checkboxes and radio inputs -->
		<link rel="stylesheet" href="admin/plugins/iCheck/all.css">
		<!-- Bootstrap time Picker -->
		<link rel="stylesheet" href="admin/plugins/timepicker/bootstrap-timepicker.min.css">
		<!-- Select2 -->
		<link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">
		<!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
		<!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
		<!--[if lt IE 9]>
		<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
		<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
		<![endif]-->
		<!-- Google Font -->
		<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
		<link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
		<link href="admin/plugins/bootstrap-toggle-master/css/bootstrap-toggle.min.css" rel="stylesheet" type="text/css" />
		<link href="admin/bower_components/bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.min.css" rel="stylesheet" type="text/css" />
		<!-- Alertifyjs -->
		<link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css" />
		<link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css" />
		<style>
			.ocultar {
			display: none;
			}
			.modal-header-danger {
			color: #fff;
			background-color: #e4002b;
			}
			.preloader {
			background-color: #FFF;
			width: 100%;
			height: 100%;
			position: absolute;
			z-index: 1;
			}
			.dataTables_wrapper .myfilter .dataTables_filter {
			float: left
			}
			.dataTables_wrapper .mylength .dataTables_length {
			float: right
			}
			div.dataTables_scrollBody thead th {
			vertical-align: top;
			}
			td {
			max-width: 250px;
			overflow: hidden;
			white-space: nowrap;
			text-overflow: ellipsis;
			}
			.espacio {
			height: 10px;
			}
			.espacio2 {
			height: 15px;
			}
			.thumbnail_style {
			text-align: center;
			border: none;
			}
			.caption h4 {
			margin-top: -10px;
			font-size: 13px;
			font-weight: bold;
			}
			.caption p {
			color: #777;
			font-size: 13px;
			}
			.caption a {
			color: #777;
			font-size: 10px;
			}
			#frmEditarVenta .form-control {
			border-radius: 4px
			}
			#c-slider {
			margin: auto;
			width: 100%;
			max-width: 900px;
			position: relative;
			overflow: hidden;
			}
			#slider {
			display: flex;
			width: 200%;
			}
			#slider section {
			width: 100%;
			}
			.select2-container--default .select2-selection--single {
			border: 1px solid #d2d6de;
			border-radius: 4px;
			font-size: 12px;
			padding: 4px 6px;
			}
			.btn-nuevo {
			color: #FFFFFF;
			background-color: #444444;
			border-color: #444444;
			}
			.btn-nuevo:hover,
			.btn-nuevo:focus,
			.btn-nuevo:active,
			.btn-nuevo.active,
			.open .dropdown-toggle.btn-nuevo {
			color: #FFFFFF;
			background-color: #616161;
			border-color: #444444;
			}
			.btn-nuevo:active,
			.btn-nuevo.active,
			.open .dropdown-toggle.btn-nuevo {
			background-image: none;
			}
			.btn-nuevo.disabled,
			.btn-nuevo[disabled],
			fieldset[disabled] .btn-nuevo,
			.btn-nuevo.disabled:hover,
			.btn-nuevo[disabled]:hover,
			fieldset[disabled] .btn-nuevo:hover,
			.btn-nuevo.disabled:focus,
			.btn-nuevo[disabled]:focus,
			fieldset[disabled] .btn-nuevo:focus,
			.btn-nuevo.disabled:active,
			.btn-nuevo[disabled]:active,
			fieldset[disabled] .btn-nuevo:active,
			.btn-nuevo.disabled.active,
			.btn-nuevo[disabled].active,
			fieldset[disabled] .btn-nuevo.active {
			background-color: #444444;
			border-color: #444444;
			}
		</style>
		<style>
			.main-header,
			.main-sidebar,
			.left-side {
			position: fixed
			}
			.main-header {
			top: 0;
			right: 0;
			left: 0
			}
			.content-wrapper,
			.right-side {
			padding-top: 50px
			}
			@media (max-width:767px) {
			.content-wrapper,
			.right-side {
			padding-top: 100px
			}
			}
			.layout-boxed .wrapper {
			max-width: 100%
			}
			.wrapper {
			overflow: hidden .control-sidebar {
			position: fixed;
			height: 100%;
			overflow-y: auto;
			padding-bottom: 50px
			}
		</style>
		<style>
			.ui-autocomplete {
			position: absolute;
			z-index: 1000;
			cursor: default;
			padding: 0;
			margin-top: 2px;
			list-style: none;
			font-size: 11px;
			font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
			background-color: #ffffff;
			border: 1px solid #ccc;
			-webkit-border-radius: 5px;
			-moz-border-radius: 5px;
			border-radius: 5px;
			-webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
			-moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
			box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
			z-index: 1051 !important;
			}
			hr {
			height: 4px;
			width: 100%;
			background-color: #ecf0f5;
			}
			hr {
			/* margin-top: 20px; */
			margin-bottom: 20px;
			border: 0;
			/* border-top: 1px solid #eee; */
			}
			hr {
			display: block;
			unicode-bidi: isolate;
			-webkit-margin-before: 0.5em;
			-webkit-margin-after: 0.5em;
			-webkit-margin-start: auto;
			-webkit-margin-end: auto;
			overflow: hidden;
			border-style: inset;
			}
			.box.box-custom {
			border-top-color: #ffffff;
			}
			.box {
			position: relative;
			border-radius: 3px;
			background: #ffffff;
			border-top: 3px solid #d2d6de;
			margin-bottom: 5px;
			width: 100%;
			box-shadow: 0 1px 1px rgba(0, 0, 0, 0.1);
			}
		</style>
		<style>
			.subtitulo {
			text-decoration: underline;
			font-weight: bold;
			}
		</style>
		<style>
			#header-decision {
			height: auto;
			width: 100%;
			padding-top: 25px;
			padding-bottom: 25px;
			}
			#header-decision span {
			line-height: 40px;
			font-size: 18px;
			}
			.barra-informacion {
			background: rgb(82, 87, 88);
			color: white;
			padding: 0 2rem;
			}
			.barra-informacion ul {
			display: flex;
			justify-content: space-between;
			list-style: none;
			padding: 22px 55px;
			margin-bottom: 10px;
			}
			.barra-informacion a {
			text-decoration: none;
			color: white;
			font-weight: 600;
			}
			.main-contenido {
			display: flex;
			justify-content: space-between;
			flex-wrap: wrap;
			padding: 8rem 2rem;
			}
			.contenido-solicitante {
			padding: 0 5rem 0 5rem;
			}
			@media (min-width: 768px) {
			.contenido-solicitante {
			flex-basis: calc(40% - 2rem);
			}
			.contenido-score {
			flex-basis: 60%;
			}
			}
			.contenido-solicitante-info {
			display: flex;
			align-items: center;
			}
			.icono {
			padding-right: 10px;
			}
			.icono i {
			font-size: 4.2rem;
			line-height: 3.8rem;
			}
			.info {
			line-height: 1.5rem;
			display: table-cell;
			vertical-align: top;
			}
			.score-conclusion strong {
			font-weight: 700;
			}
			#divLoading {
			background: rgba(66, 118, 164, 0.4);
			width: 100%;
			height: 100%;
			min-height: 100%;
			position: absolute;
			top: 0;
			left: 0;
			z-index: 999999999;
			display: none;
			}
			#divLoading2 {
			background: rgba(66, 118, 164, 0.4);
			width: 100%;
			height: 100%;
			min-height: 100%;
			position: absolute;
			top: 0;
			left: 0;
			z-index: 999999999;
			display: none;
			}
			.spinner {
			margin: 300px auto 0;
			width: 70px;
			text-align: center;
			}
			.spinner>div {
			background-color: #e4002b;
			width: 18px;
			height: 18px;
			border-radius: 100%;
			display: inline-block;
			-webkit-animation: sk-bouncedelay 1.4s infinite ease-in-out both;
			animation: sk-bouncedelay 1.4s infinite ease-in-out both;
			}
			.spinner .bounce1 {
			-webkit-animation-delay: -0.32s;
			animation-delay: -0.32s;
			}
			.spinner .bounce2 {
			-webkit-animation-delay: -0.16s;
			animation-delay: -0.16s;
			}
			@-webkit-keyframes sk-bouncedelay {
			0%,
			80%,
			100% {
			-webkit-transform: scale(0)
			}
			40% {
			-webkit-transform: scale(1.0)
			}
			}
			@keyframes sk-bouncedelay {
			0%,
			80%,
			100% {
			-webkit-transform: scale(0);
			transform: scale(0);
			}
			40% {
			-webkit-transform: scale(1.0);
			transform: scale(1.0);
			}
			}
			.centrar-texto {
			text-align: center;
			}
			.m_get_started.fix {
			height: 100%;
			padding: 0;
			text-align: center;
			opacity: 1;
			}
			.callout {
			border-radius: 3px;
			margin: 0 0 20px 0;
			padding: 15px 30px 15px 15px;
			border-left: 5px solid #f03;
			-webkit-box-shadow: 10px 10px 5px -9px rgba(0, 0, 0, 0.75);
			-moz-box-shadow: 10px 10px 5px -9px rgba(0, 0, 0, 0.75);
			box-shadow: 10px 10px 5px -9px rgba(0, 0, 0, 0.75);
			}
			.bg-deuda {
			color: #000;
			background-color: #ffffff !important;
			}
			.bg-visita {
			color: #fff;
			background-color: #008000 !important;
			}
			.bg-gestion {
			color: #fff;
			background-color: #6a6659 !important;
			}
			.bg-televenta {
			color: #fff;
			background-color: #f39c12 !important;
			}
			input#nombres {
			text-transform: uppercase;
			}
			input#apellido_p {
			text-transform: uppercase;
			}
			input#apellido_m {
			text-transform: uppercase;
			}
			.select2-container--default .select2-selection--single {
			border: 1px solid #d2d6de;
			border-radius: 4px;
			font-size: 12px;
			padding: 4px 6px;
			}
			select+span.select2:focus,
			select+span.select2 *:focus {
			outline-color: #7d3c8c;
			outline-width: 1px;
			}
			.select2-container--default.select2-container--focus,
			.select2-selection.select2-container--focus,
			.select2-container--default:focus,
			.select2-selection:focus,
			.select2-container--default:active,
			.select2-selection:active {
			outline: none;
			border: 1px solid #3c8dbc;
			border-radius: 4px;
			}
			.btn-verisure {
			font-family: "Avenir Next LT W01 Demi", sans-serif;
			font-weight: normal !important;
			font-style: normal !important;
			box-sizing: border-box;
			-moz-box-sizing: border-box;
			font-size: 15px;
			color: #EE0008;
			border: 1px solid #eb3e3e;
			border-radius: 40px;
			display: inline-block;
			/*padding: 15px 24px 15px 44px;*/
			text-decoration: none;
			text-align: center;
			line-height: 28px;
			text-transform: uppercase;
			}
			.btn-verisure {
			color: #ffffff;
			background-color: #FF0033;
			border-color: #FF0033;
			}
			.btn-verisure:hover,
			.btn-verisure:focus,
			.btn-verisure:active,
			.btn-verisure.active,
			.open .dropdown-toggle.btn-verisure {
			color: #ffffff;
			background-color: #a62828;
			border-color: #a62828;
			}
			.btn-verisure:active,
			.btn-verisure.active,
			.open .dropdown-toggle.btn-verisure {
			background-image: none;
			}
			.btn-verisure.disabled,
			.btn-verisure[disabled],
			fieldset[disabled] .btn-verisure,
			.btn-verisure.disabled:hover,
			.btn-verisure[disabled]:hover,
			fieldset[disabled] .btn-verisure:hover,
			.btn-verisure.disabled:focus,
			.btn-verisure[disabled]:focus,
			fieldset[disabled] .btn-verisure:focus,
			.btn-verisure.disabled:active,
			.btn-verisure[disabled]:active,
			fieldset[disabled] .btn-verisure:active,
			.btn-verisure.disabled.active,
			.btn-verisure[disabled].active,
			fieldset[disabled] .btn-verisure.active {
			background-color: #555758;
			border-color: #555758;
			}
			.btn-verisure .badge {
			color: #FF0033;
			background-color: #ffffff;
			}
			.btn-verisurecerrar {
			font-family: "Avenir Next LT W01 Demi", sans-serif;
			font-weight: normal !important;
			font-style: normal !important;
			box-sizing: border-box;
			-moz-box-sizing: border-box;
			font-size: 15px;
			color: #444;
			border: 1px solid #ddd;
			border-radius: 40px;
			display: inline-block;
			/*padding: 15px 24px 15px 44px;*/
			text-decoration: none;
			text-align: center;
			line-height: 28px;
			text-transform: uppercase;
			}
			.btn-verisurecerrar {
			background-color: #f4f4f4;
			color: #444;
			border-color: #ddd;
			}
			.btn-verisurecerrar:hover,
			.btn-verisurecerrar:focus,
			.btn-verisurecerrar:active,
			.btn-verisurecerrar.active,
			.open .dropdown-toggle.btn-verisurecerrar {
			color: #333;
			background-color: #e6e6e6;
			border-color: #adadad;
			}
			.btn-verisurecerrar:active,
			.btn-verisurecerrar.active,
			.open .dropdown-toggle.btn-verisurecerrar {
			background-image: none;
			}
			.btn-verisurecerrar.disabled,
			.btn-verisurecerrar[disabled],
			fieldset[disabled] .btn-verisurecerrar,
			.btn-verisurecerrar.disabled:hover,
			.btn-verisurecerrar[disabled]:hover,
			fieldset[disabled] .btn-verisurecerrar:hover,
			.btn-verisurecerrar.disabled:focus,
			.btn-verisurecerrar[disabled]:focus,
			fieldset[disabled] .btn-verisurecerrar:focus,
			.btn-verisurecerrar.disabled:active,
			.btn-verisurecerrar[disabled]:active,
			fieldset[disabled] .btn-verisurecerrar:active,
			.btn-verisurecerrar.disabled.active,
			.btn-verisurecerrar[disabled].active,
			fieldset[disabled] .btn-verisurecerrar.active {
			background-color: #e7e7e7;
			}
			.btn-verisurecerrar .badge {
			background-color: #f4f4f4;
			color: #444;
			}
			.swal2-popup {
			font-size: 1.5rem !important;
			}
			label {
			font-weight: 400;
			font-size: 12px;
			}
			.subtitulo {
			text-decoration: underline;
			font-weight: bold;
			}
		</style>
		<style>
			.toggle.ios,
			.toggle-on.ios,
			.toggle-off.ios {
			border-radius: 20px;
			}
			.toggle.ios .toggle-handle {
			border-radius: 20px;
			}
			.labelBBVA{
			background-color: #3c8dbc;
			border-color: #367fa9;
			border-radius: 3px;
			-webkit-box-shadow: none;
			box-shadow: none;
			border: 1px solid transparent;
			display: block;
			width: 100%;
			padding: 5px 10px;
			font-size: 12px;
			line-height: 1.5;
			color: #fff;text-align: center;               
			}
			.labelInterbank{
			background-color: #00a65a;
			border-color: #00a65a;
			border-radius: 3px;
			-webkit-box-shadow: none;
			box-shadow: none;
			border: 1px solid transparent;
			display: block;
			width: 100%;
			padding: 5px 10px;
			font-size: 12px;
			line-height: 1.5;
			color: #fff;text-align: center;                  
			}   
			.labelBCP{
			background-color: #f39c12;
			border-color: #f39c12;
			border-radius: 3px;
			-webkit-box-shadow: none;
			box-shadow: none;
			border: 1px solid transparent;
			display: block;
			width: 100%;
			padding: 5px 10px;
			font-size: 12px;
			line-height: 1.5;
			color: #fff;text-align: center;                  
			}
			.labelOH{
			background-color: #dd4b39;
			border-color: #dd4b39;
			border-radius: 3px;
			-webkit-box-shadow: none;
			box-shadow: none;
			border: 1px solid transparent;
			display: block;
			width: 100%;
			padding: 5px 10px;
			font-size: 12px;
			line-height: 1.5;
			color: #fff;text-align: center;                  
			}
		</style>
	</head> 
	<body class="sidebar-collapse skin-red sidebar-mini">
		<div id="divLoading" style="display: none;height: auto; min-height: 100%;">
			<div class="spinner">
				<div class="bounce1"></div>
				<div class="bounce2"></div>
				<div class="bounce3"></div>
			</div>
		</div>
		<div class="wrapper">
			<!-- Header -->
			<?php include 'admin/header.php'; ?>
			<!-- Left side column. contains the logo and sidebar -->
			<?php
				$venta = "active";
				
				include 'admin/main-sidebar.php';
				?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h1>
						VENTAS
					</h1>
					<ol class="breadcrumb">
						<li><i class="fa fa-dashboard"></i> Home</li>
						<li>Ventas</li>
						<li class="active">Editar de Venta</li>
					</ol>
				</section>
				<!-- Main content -->
				<section class="content">
					<input id="lblrc" name="lblrc" value="<?php echo $rc; ?>" hidden="" />
					<div class="row">
						<div class="col-md-2"></div>
						<div class="col-md-8">
							<!-- /.box-header -->
							<div class="box box-danger">
								<div class="box-header">
									<?php if ($tipoventa == 'RE' || $tipoventa == 'REGGCC') {
										?>
									<h3 class="box-title">
										EDITAR 
										<select name="lblcategoria" id="lblcategoria" style="border:none;-moz-appearance:none;-webkit-appearance:none;-ms-appearance:none;-o-appearance:none;">
											<?php
												if ($estadoventa == "AgendadaTEC" || $estadoventa == "InstaladaTEC" || $estadoventa == "Instalada" || $estadoventa == "InstaladaDEL" || $estadoventa == "NoInstalada" || $estadoventa == "Incidencia" || $estadoventa == "IncidenciaGestCorreo" || $estadoventa == "IncidenciaGestValija" || $estadoventa == "NoDoc" || $estadoventa == "DocEnvi" || $estadoventa == "PorFacturar"  || $estadoventa == "Facturada") {
												?>
											<option value="<?php echo $categoriaventa; ?>" <?php if ($categoriaventa == "Online" || $categoriaventa == "Ficha" || $categoriaventa == "Delegacion") {
												echo "selected";
												} ?>><?php
												if ($categoriaventa == "Online") {
												    $nombc = "VENTA ONLINE";
												} else if ($categoriaventa == "Ficha") {
												    $nombc = "VENTA FICHA";
												} else if ($categoriaventa == "Delegacion") {
												    $nombc = "VENTA DELEGACIÓN ";
												}
												echo $nombc;
												?> - <?php echo $nprospecto . " | " . $ncontrato ?></option>
											<?php
												} else {
												?>
											<option value="Online" <?php if ($categoriaventa == "Online") {
												echo "selected";
												} ?> hidden="">VENTA ONLINE - <?php echo $nprospecto . " | " . $ncontrato ?></option>
											<option value="Ficha" <?php if ($categoriaventa == "Ficha") {
												echo "selected";
												} ?>>VENTA FICHA - <?php echo $nprospecto . " | " . $ncontrato ?></option>
											<option value="Delegacion" <?php if ($categoriaventa == "Delegacion") {
												echo "selected";
												} ?>>VENTA DELEGACIÓN - <?php echo $nprospecto . " | " . $ncontrato ?></option>
											<option value="VAsignada" <?php if ($categoriaventa == "VAsignada") {
												echo "selected";
												} ?> hidden="">VISITA ASIGNADA - <?php echo $nprospecto . " | " . $ncontrato ?></option>
											<option value="Cancelada" <?php if ($categoriaventa == "Cancelada") {
												echo "selected";
												} ?> hidden="">CANCELADA - <?php echo $nprospecto . " | " . $ncontrato ?></option>
											<option value="NoVendida" <?php if ($categoriaventa == "NoVendida") {
												echo "selected";
												} ?>>NO VENDIDA - <?php echo $nprospecto . " | " . $ncontrato ?></option>
											<?php
												}
												
												?>
										</select>
									</h3>
									<?php } else {
										?>
									<h3 class="box-title">
										EDITAR
										<select name="lblcategoria" id="lblcategoria" style="border:none;-moz-appearance:none;-webkit-appearance:none;-ms-appearance:none;-o-appearance:none;">
											<?php
												if ($estadoventa == "AgendadaTEC" || $estadoventa == "InstaladaTEC" || $estadoventa == "Instalada" || $estadoventa == "InstaladaDEL" || $estadoventa == "NoInstalada"  || $estadoventa == "Incidencia" || $estadoventa == "IncidenciaGestCorreo" || $estadoventa == "IncidenciaGestValija"  || $estadoventa == "NoDoc" || $estadoventa == "DocEnvi" || $estadoventa == "PorFacturar" || $estadoventa == "Facturada") {
												?>
											<option value="<?php echo $categoriaventa; ?>" <?php if ($categoriaventa == "Online" || $categoriaventa == "Ficha" || $categoriaventa == "Delegacion") {
												echo "selected";
												} ?>><?php
												if ($categoriaventa == "Online") {
												    $nombc = "VENTA ONLINE";
												} else if ($categoriaventa == "Ficha") {
												    $nombc = "VENTA FICHA";
												} else if ($categoriaventa == "Delegacion") {
												    $nombc = "VENTA DELEGACIÓN ";
												}
												echo $nombc;
												?> - <?php echo $nprospecto . " | " . $ncontrato ?></option>
											<?php
												} else {
												?>
											<option value="ProspectoRP" <?php if ($categoriaventa == "ProspectoRP") {
												echo "selected";
												} ?> hidden="">NUEVO PROSPECTO RP - <?php echo $nprospecto . " | " . $ncontrato ?></option>
											<option value="Online" <?php if ($categoriaventa == "Online") {
												echo "selected";
												} ?> hidden="">VENTA ONLINE - <?php echo $nprospecto . " | " . $ncontrato ?></option>
											<option value="Ficha" <?php if ($categoriaventa == "Ficha") {
												echo "selected";
												} ?>>VENTA FICHA - <?php echo $nprospecto . " | " . $ncontrato ?></option>
											<option value="Delegacion" <?php if ($categoriaventa == "Delegacion") {
												echo "selected";
												} ?>>VENTA DELEGACIÓN - <?php echo $nprospecto . " | " . $ncontrato ?></option>
											<option value="NoVendida" <?php if ($categoriaventa == "NoVendida") {
												echo "selected";
												} ?>>NO VENDIDA - <?php echo $nprospecto . " | " . $ncontrato ?></option>
											<option value="Cancelada" <?php if ($categoriaventa == "Cancelada") {
												echo "selected";
												} ?> hidden="">CANCELADA - <?php echo $nprospecto . " | " . $ncontrato ?></option>
											<?php
												}
												
												?>
										</select>
									</h3>
									<?php
										}
										
										?>
									<input id="lblcat" name="lblcat" value="<?php echo $categoriaventa; ?>" hidden="">
									
									<!--<div class="box-tools pull-right">-->
									<!--    <a class="btn btn-default btn-sm" id="btnCambiarNumeroContrato" href="#"><i class="fa fa-exchange"></i> Cambiar Número de Contrato</a>-->
									<!--</div>-->
									
									<div class="box-tools pull-right">
									    
									    <a class="btn btn-default btn-sm" id="btnCambiarNumeroContrato" href="#"><i class="fa fa-exchange"></i> Cambiar Contrato</a>
									    
										<?php if (($rc == 'mkt' || $nombacceso == 'Administrador') && ($tipoventa !== 'RE' || $tipoventa !== 'REGGCC')) { ?><a class="btn btn-default btn-sm" id="btnCambiarVenta" href="#"><i class="fa fa-exchange"></i> Cambiar Recurso RE</a> <?php } ?>
										<?php if ($estadoventa == 'PorFacturar' || $estadoventa == 'Facturada') {
											if( $nombacceso == 'Administrador'){
											?>       
										<a class="btn btn-nuevo btn-sm" id="btnGuardarEditarVenta" href="#"><i class="fa fa-save"></i> Guardar</a> 
										<?php  }
											} else { ?>
										<a class="btn btn-nuevo btn-sm" id="btnGuardarEditarVenta" href="#"><i class="fa fa-save"></i> Guardar</a>
										<?php   } ?>
										<a href="<?php if ($rc == '150') {
											echo 'ventadc150.php';
											} elseif ($rc == '150gestionados') {
											echo 'ventadc150gestionados.php';
											} elseif ($rc == '150imp') {
											echo 'ventadc150imp.php';
											} elseif ($rc == '150porcontactar') {
											echo 'ventadc150porcontactar.php';
											} elseif ($rc == '151') {
											echo 'ventadc151.php';
											} elseif ($rc == '151gestionados') {
											echo 'ventadc151gestionados.php';
											} elseif ($rc == '151imp') {
											echo 'ventadc151imp.php';
											} elseif ($rc == '151porcontactar') {
											echo 'ventadc151porcontactar.php';
											} elseif ($rc == '152') {
											echo 'ventadc152.php';
											} elseif ($rc == '152gestionados') {
											echo 'ventadc152gestionados.php';
											} elseif ($rc == '152imp') {
											echo 'ventadc152imp.php';
											} elseif ($rc == '152porcontactar') {
											echo 'ventadc152porcontactar.php';
											} elseif ($rc == '153') {
											echo 'ventadc153.php';
											} elseif ($rc == '153gestionados') {
											echo 'ventadc153gestionados.php';
											} elseif ($rc == '153imp') {
											echo 'ventadc153imp.php';
											} elseif ($rc == '153porcontactar') {
											echo 'ventadc153porcontactar.php';
											} elseif ($rc == '154') {
											echo 'ventadc154.php';
											} elseif ($rc == '154gestionados') {
											echo 'ventadc154gestionados.php';
											} elseif ($rc == '154imp') {
											echo 'ventadc154imp.php';
											} elseif ($rc == '154porcontactar') {
											echo 'ventadc154porcontactar.php';
											} elseif ($rc == '155') {
											echo 'ventadc155.php';
											} elseif ($rc == '155gestionados') {
											echo 'ventadc155gestionados.php';
											} elseif ($rc == '155imp') {
											echo 'ventadc155imp.php';
											} elseif ($rc == '155porcontactar') {
											echo 'ventadc155porcontactar.php';
											} elseif ($rc == '156') {
											echo 'ventadc156.php';
											} elseif ($rc == '157') {
											echo 'ventadc157.php';
											} elseif ($rc == '158') {
											echo 'ventadc158.php';
											} elseif ($rc == '159') {
											echo 'ventadc159.php';
											} elseif ($rc == '40') {
											echo 'ventadc40.php';
											} elseif ($rc == '40gestionados') {
											echo 'ventadc40gestionados.php';
											} elseif ($rc == '40imp') {
											echo 'ventadc40imp.php';
											} elseif ($rc == '40porcontactar') {
											echo 'ventadc40porcontactar.php';
											} elseif ($rc == '41') {
											echo 'ventadc41.php';
											} elseif ($rc == '41gestionados') {
											echo 'ventadc41gestionados.php';
											} elseif ($rc == '41imp') {
											echo 'ventadc41imp.php';
											} elseif ($rc == '41porcontactar') {
											echo 'ventadc41porcontactar.php';
											} elseif ($rc == '42') {
											echo 'ventadc42.php';                                                    
											} elseif ($rc == '200') {
											echo 'ventadc200.php';
											} elseif ($rc == '140') {
											echo 'ventadc140.php';
											} elseif ($rc == '250') {
											echo 'ventadc250.php';
											} elseif ($rc == '251') {
											echo 'ventadc251.php';
											} elseif ($rc == '252') {
											echo 'ventadc252.php';
											} elseif ($rc == '20') {
											echo 'ventadc20.php';                                                    
											} elseif ($rc == '599') {
											echo 'ventadc599.php';
											} elseif ($rc == '120') {
											echo 'ventadc120.php';
											} elseif ($rc == '121') {
											echo 'ventadc121.php';
											} elseif ($rc == '141') {
											echo 'ventadc141.php';
											} elseif ($rc == '80') {
											echo 'ventadc80.php';
											} elseif ($rc == '100') {
											echo 'ventadc100.php';
											} elseif ($rc == 'gestionados') {
											echo 'ventagestionados.php';
											} elseif ($rc == 'imp') {
											echo 'ventaimp.php';
											} elseif ($rc == 'porcontactar') {
											echo 'ventaporcontactar.php';
											} elseif ($rc == 'mkt') {
											echo 'prospectosrpporfact.php';
											} elseif ($rc == '500') {
											echo 'ventadc500.php';
											
											} elseif ($rc == '601') {
											echo 'ventadc601.php';
											} elseif ($rc == '602') {
											echo 'ventadc602.php';											
											} elseif ($rc == '701') {
											echo 'ventadc701.php';
											} elseif ($rc == '702') {
											echo 'ventadc702.php';
											} elseif ($rc == '901') {
											echo 'ventadc901.php';
											
											} elseif ($rc == '130') {
											echo 'ventadc130.php';
											} elseif ($rc == '230') {
											echo 'ventadc230.php';
											} elseif ($rc == '60') {
											echo 'ventadc60.php';												
											
											} else {
											echo 'venta.php';
											}
											
											?>" class="btn btn-danger btn-sm"><i class="fa fa-reply"></i> Regresar</a>
									</div>
								</div>
								<div class="espacio"></div>
							</div>
							<form id="frmEditarVenta" method="POST">
								<div class="box box-custom">
									<div class="box-header with-border" style="background-color:#2c3b41;color:white;">
										<h5>INFORMACION DE VENTA</h5>
										<div class="box-tools pull-right">
											<button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
											</button>
										</div>
									</div>
									<!-- /.box-header -->
									<div class="box-body">
										<table cellspacing="0" style="width:100%;border-collapse: separate;padding: 20px;">
											<tr>
												<td style="width:15%;font-size: 12px">MATRICULA:</td>
												<td style="width:25%;"><input name="lblmatricula" id="lblmatricula" class="form-control input-sm" value="<?php echo $matricula; ?>" style="width: 100%;" 
													<?php
														if ($estadoventa == 'Incidencia' || $estadoventa == 'IncidenciaGestCorreo' || $estadoventa == 'IncidenciaGestValija' || $estadoventa == 'NoDoc' || $estadoventa == 'DocEnvi' || $estadoventa == 'Instalada' || $estadoventa == "InstaladaDEL" || $estadoventa == "NoInstalada"  || $estadoventa == 'PorFacturar' || $estadoventa == 'Facturada') {
														      if ($nombacceso == 'Administrador' || $_SESSION['matriculausuario'] == 'JB4716' || $_SESSION['matriculausuario'] == 'EL8532' || $_SESSION['matriculausuario'] == "MB5169" || $_SESSION['matriculausuario'] == "Q04220" || $_SESSION['matriculausuario'] == "Q19368" || $_SESSION['matriculausuario'] == "Q86140") {
														       } else {
														        ?> readonly="readonly" <?php }
														} ?> />
													<input id="lblidusuario" name="lblidusuario" value="<?php echo $idu; ?>" hidden="">
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px">COMERCIAL:</td>
												<td style="width:2%"></td>
												<td style="width:25%"><input name="lblnombcomercial" id="lblnombcomercial" class="form-control input-sm" style="width: 100%;" value="<?php echo $comercial; ?>" readonly="readonly"></td>
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:15%;font-size: 12px">DC:</td>
												<td style="width:25%;">
													<select class="form-control input-sm" name="lbldc" id="lbldc" style="width: 100%;">
														<?php if ($dc == "150") { ?>
														<option value="150" <?php if ($dc == "150") {
															echo "selected";
															} ?>>150</option>
														<?php } else if ($dc == "151") { ?>
														<option value="151" <?php if ($dc == "151") {
															echo "selected";
															} ?>>151</option>
														<?php } else if ($dc == "152") { ?>
														<option value="152" <?php if ($dc == "152") {
															echo "selected";
															} ?>>152</option>
														<?php } else if ($dc == "153") { ?>
														<option value="153" <?php if ($dc == "153") {
															echo "selected";
															} ?>>153</option>
														<?php } else if ($dc == "154") { ?>
														<option value="154" <?php if ($dc == "154") {
															echo "selected";
															} ?>>154</option>
														<?php } else if ($dc == "155") { ?>
														<option value="155" <?php if ($dc == "155") {
															echo "selected";
															} ?>>155</option>
														<?php } else if ($dc == "156") { ?>
														<option value="156" <?php if ($dc == "156") {
															echo "selected";
															} ?>>156</option>
														<?php } else if ($dc == "157") { ?>
														<option value="157" <?php if ($dc == "157") {
															echo "selected";
															} ?>>157</option>
														<?php } else if ($dc == "158") { ?>
														<option value="158" <?php if ($dc == "158") {
															echo "selected";
															} ?>>158</option>
														<?php } else if ($dc == "159") { ?>
														<option value="159" <?php if ($dc == "159") {
															echo "selected";
															} ?>>159</option>
														<?php } else if ($dc == "200") { ?>
														<option value="200" <?php if ($dc == "200") {
															echo "selected";
															} ?>>200</option>
														<?php } else if ($dc == "140") { ?>
														<option value="140" <?php if ($dc == "140") {
															echo "selected";
															} ?>>140</option>
														<?php } else if ($dc == "141") { ?>
														<option value="141" <?php if ($dc == "141") {
															echo "selected";
															} ?>>141</option>
														<?php } else if ($dc == "121") { ?>
														<option value="121" <?php if ($dc == "121") {
															echo "selected";
															} ?>>121</option>
														<?php } else if ($dc == "80") { ?>
														<option value="80" <?php if ($dc == "80") {
															echo "selected";
															} ?>>80</option>
														<?php } else if ($dc == "250") { ?>
														<option value="250" <?php if ($dc == "250") {
															echo "selected";
															} ?>>250</option>
														<?php } else if ($dc == "251") { ?>
														<option value="251" <?php if ($dc == "251") {
															echo "selected";
															} ?>>251</option>
														<?php } else if ($dc == "120") { ?>
														<option value="120" <?php if ($dc == "120") {
															echo "selected";
															} ?>>120</option>
														<?php } else if ($dc == "100") { ?>
														<option value="100" <?php if ($dc == "100") {
															echo "selected";
															} ?>>100</option>
														<?php } else if ($dc == "40") { ?>
														<option value="40" <?php if ($dc == "40") {
															echo "selected";
															} ?>>40</option>
														<?php } else if ($dc == "41") { ?>
														<option value="41" <?php if ($dc == "41") {
															echo "selected";
															} ?>>41</option>
														<?php } else if ($dc == "42") { ?>
														<option value="42" <?php if ($dc == "42") {
															echo "selected";
															} ?>>42</option>
														<?php } else if ($dc == "511") { ?>
														<option value="511" <?php if ($dc == "511") {
															echo "selected";
															} ?>>511</option>
														<?php } else if ($dc == "512") { ?>
														<option value="512" <?php if ($dc == "512") {
															echo "selected";
															} ?>>512</option>
														<?php } else if ($dc == "513") { ?>
														<option value="513" <?php if ($dc == "513") {
															echo "selected";
															} ?>>513</option>
														<?php } else if ($dc == "500") { ?>
														<option value="500" <?php if ($dc == "500") {
															echo "selected";
															} ?>>500</option>
														<?php } else if ($dc == "599") { ?>
														<option value="599" <?php if ($dc == "599") {
															echo "selected";
															} ?>>599</option>
														<?php } else if ($dc == "252") { ?>
														<option value="252" <?php if ($dc == "252") {echo "selected";}?>>252</option>
														<?php } else if ($dc == "20") { ?>
														<option value="20" <?php if ($dc == "20") {echo "selected";}?>>20</option>

														<?php } else if ($dc == "601") { ?>
														<option value="601" <?php if ($dc == "601") {echo "selected";}?>>601</option>
														<?php } else if ($dc == "602") { ?>
														<option value="602" <?php if ($dc == "602") {echo "selected";}?>>602</option>														
														<?php } else if ($dc == "701") { ?>
														<option value="701" <?php if ($dc == "701") {echo "selected";}?>>701</option>
														<?php } else if ($dc == "702") { ?>
														<option value="702" <?php if ($dc == "702") {echo "selected";}?>>702</option>
														<?php } else if ($dc == "901") { ?>
														<option value="901" <?php if ($dc == "901") {echo "selected";}?>>901</option>														

														<?php } else if ($dc == "130") { ?>
														<option value="130" <?php if ($dc == "130") {echo "selected";}?>>130</option>	
														<?php } else if ($dc == "230") { ?>
														<option value="230" <?php if ($dc == "230") {echo "selected";}?>>230</option>
														<?php } else if ($dc == "60") { ?>
														<option value="60" <?php if ($dc == "60") {echo "selected";}?>>60</option>
														
														<?php } else { ?>
														<option value="" selected></option>
														<?php } ?>
													</select>
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px">JEFE VENTA:</td>
												<td style="width:2%"></td>
												<td style="width:25%">
													<select class="form-control input-sm" name="lbljefeventa" id="lbljefeventa" style="width: 100%;">
													<?php echo $html; ?>
													</select>
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:15%;font-size: 12px">ESTADO VENTA:</td>
												<td style="width:25%;">
													<select name="lblestadoventa" id="lblestadoventa" class="form-control input-sm">
														<option>Seleccione</option>
														<?php
															if ($estadoventa == "ProspectoRP" || $estadoventa == "VAsignada" || $estadoventa == "PendienteData" || $estadoventa == "PendienteAgenda" || $estadoventa == "NoAgendada" || $estadoventa == "AgendadaDEL" || $estadoventa == "NoVendida" || $estadoventa == "Cancelada" || $estadoventa == "Postergada") {
															?>
														<option value="ProspectoRP" <?php if ($estadoventa == "ProspectoRP") {
															echo "selected";
															} ?> hidden="">ProspectoRP</option>
														<option value="VAsignada" <?php if ($estadoventa == "VAsignada") {
															echo "selected";
															} ?> hidden="">VAsignada</option>
														<option value="PendienteData" <?php if ($estadoventa == "PendienteData") {
															echo "selected";
															} ?> hidden="">PendienteData</option>
														<option value="PendienteAgenda" <?php if ($estadoventa == "PendienteAgenda") {
															echo "selected";
															} ?>>PendienteAgenda</option>
														<option value="AgendadaDEL" <?php if ($estadoventa == "AgendadaDEL") {
															echo "selected";
															} ?>>AgendadaDEL</option>
														<option value="NoVendida" <?php if ($estadoventa == "NoVendida") {
															echo "selected";
															} ?> hidden="">NoVendida</option>
														<option value="Postergada" <?php if ($estadoventa == "Postergada") {
															echo "selected";
															} ?> hidden="">Postergada</option>
														<option value="NoAgendada" <?php if ($estadoventa == "NoAgendada") {
															echo "selected";
															} ?>>NoAgendada</option>
														<option value="Cancelada" <?php if ($estadoventa == "Cancelada") {
															echo "selected";
															} ?> hidden="" disabled="disabled">Cancelada</option>
														<?php
															}
															if ($estadoventa == "AgendadaTEC") {
															?>
														<option value="AgendadaTEC" <?php if ($estadoventa == "AgendadaTEC") {
															echo "selected";
															} ?>>AgendadaTEC</option>
														<?php
															}
															if ($estadoventa == "InstaladaTEC") {
															?>
														<option value="InstaladaTEC" <?php if ($estadoventa == "InstaladaTEC") {
															echo "selected";
															} ?>>InstaladaTEC</option>
														<?php
															}                                                    
															if ($estadoventa == "InstaladaDEL" || $estadoventa == "NoInstalada") {
															?>
														<option value="InstaladaDEL" <?php if ($estadoventa == "InstaladaDEL") {
															echo "selected";
															} ?>>InstaladaDEL</option>
														<option value="NoInstalada" <?php if ($estadoventa == "NoInstalada") {
															echo "selected";
															} ?>>NoInstalada</option>
														<?php
															}
															if ($estadoventa == "IncidenciaAuditoria") {
															?>
														<option value="IncidenciaAuditoria" <?php if ($estadoventa == "IncidenciaAuditoria") {
															echo "selected";
															} ?>>IncidenciaAuditoria</option>
														<?php
															}
															if ($estadoventa == "Instalada") {
															?>
														<option value="Instalada" <?php if ($estadoventa == "Instalada") {
															echo "selected";
															} ?> hidden="">Instalada</option>
														<option value="DocEnvi" <?php if ($estadoventa == "DocEnvi") {
															echo "selected";
															} ?>>DocEnvi</option>
														<?php
															}
															if ($estadoventa == "Facturada" || $estadoventa == "PorFacturar") {
															?>
														<option value="Facturada" <?php if ($estadoventa == "Facturada") {
															echo "selected";
															} ?> hidden="" disabled="disabled">Facturada</option>
														<option value="PorFacturar" <?php if ($estadoventa == "PorFacturar") {
															echo "selected";
															} ?> hidden="">PorFacturar</option>
														<?php
															}
															if ($estadoventa == "Incidencia" || $estadoventa == "IncidenciaGestCorreo" || $estadoventa == "IncidenciaGestValija") {
															?>
														<option value="Incidencia" <?php if ($estadoventa == "Incidencia") {
															echo "selected";
															} ?> hidden="" disabled="disabled">Incidencia</option>
														<option value="IncidenciaGestCorreo" <?php if ($estadoventa == "IncidenciaGestCorreo") {
															echo "selected";
															} ?>>IncidenciaGestCorreo</option>
														<option value="IncidenciaGestValija" <?php if ($estadoventa == "IncidenciaGestValija") {
															echo "selected";
															} ?>>IncidenciaGestValija</option>
														<?php
															}
															if ($estadoventa == "Ilocalizable") {
															?>
														<option value="PendienteData" <?php if ($estadoventa == "PendienteData") {
															echo "selected";
															} ?> hidden="">PendienteData</option>
														<option value="PendienteAgenda" <?php if ($estadoventa == "PendienteAgenda") {
															echo "selected";
															} ?>>PendienteAgenda</option>
														<option value="AgendadaDEL" <?php if ($estadoventa == "AgendadaDEL") {
															echo "selected";
															} ?> hidden="">AgendadaDEL</option>
														<option value="Ilocalizable" <?php if ($estadoventa == "Ilocalizable") {
															echo "selected";
															} ?>>Ilocalizable</option>
														<?php
															}
															if ($estadoventa == "Inviable") {
															?>
														<option value="PendienteData" <?php if ($estadoventa == "PendienteData") {
															echo "selected";
															} ?> hidden="">PendienteData</option>
														<option value="PendienteAgenda" <?php if ($estadoventa == "PendienteAgenda") {
															echo "selected";
															} ?>>PendienteAgenda</option>
														<option value="AgendadaDEL" <?php if ($estadoventa == "AgendadaDEL") {
															echo "selected";
															} ?> hidden="">AgendadaDEL</option>
														<option value="Inviable" <?php if ($estadoventa == "Inviable") {
															echo "selected";
															} ?>>Inviable</option>
														<?php
															}
															if ($estadoventa == "NoDoc" || $estadoventa == "DocEnvi") {
															?>
														<option value="NoDoc" <?php if ($estadoventa == "NoDoc") {
															echo "selected";
															} ?> hidden="" disabled="disabled">NoDoc</option>
														<option value="DocEnvi" <?php if ($estadoventa == "DocEnvi") {
															echo "selected";
															} ?>>DocEnvi</option>
														<?php
															}
															?>
														<option value="NoVendida" <?php if ($estadoventa == "NoVendida") {
															echo "selected";
															} ?> hidden="">NoVendida</option>
													</select>
													<input id="lblestventa" name="lblestventa" value="<?php echo $estadoventa; ?>" hidden="" />
													<input id="lblestvisita" name="lblestvisita" value="<?php echo $estadovisita; ?>" hidden="" />
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px">RECURSO:</td>
												<td style="width:2%"></td>
												<td style="width:25%">
													<select name="lbltipoventa" id="lbltipoventa" class="form-control input-sm">
														<option>Seleccione</option>
														<option value="RE" <?php if ($tipoventa == "RE") {
															echo "selected";
															} ?> hidden="" disabled="disabled">RE</option>
															<option value="REGGCC" <?php if ($tipoventa == "REGGCC") {
															echo "selected";
															} ?> hidden="" disabled="disabled">REGGCC</option>	
														<option value="RPTMK" <?php if ($tipoventa == "RPTMK") {
															echo "selected";
															} ?> hidden="" >RPTMK</option>
														<option value="RPMKT" <?php if ($tipoventa == "RPMKT") {
															echo "selected";
															} ?> hidden="" >RPMKT</option>
														<option value="RP" <?php if ($tipoventa == "RP") {
															echo "selected";
															} ?>>RP</option>
														<option value="RPPA" <?php if ($tipoventa == "RPPA") {
															echo "selected";
															} ?>>RPPA</option>
														<option value="RPPR" <?php if ($tipoventa == "RPPR") {
															echo "selected";
															} ?>>RPPR</option>
														<option value="RPGGCC" <?php if ($tipoventa == "RPGGCC") {
															echo "selected";
															} ?> hidden="">RPGGCC</option>
													</select>
													<input id="lbltiventa" name="lbltiventa" value="<?php echo $tipoventa; ?>" hidden="" />
												</td>
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:15%;font-size: 12px">SEGMENTO:</td>
												<td style="width:25%">
													<select class="form-control input-sm" name="lblsegmento" id="lblsegmento">
														<option>Seleccione</option>
														<option value="RES" <?php if ($segmento == "RES") {
															echo "selected";
															} ?>>RES</option>
														<option value="NEG" <?php if ($segmento == "NEG") {
															echo "selected";
															} ?>>NEG</option>
													</select>
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px">MESES AUTORIZADOS:</td>
												<td style="width:2%"></td>
												<td style="width:25%"><input type="text" maxlength="3" class="form-control input-sm" id="lblmesesautorizados" name="lblmesesautorizados" value="<?php echo $mesesautorizados; ?>" onkeypress="return filterFloat(event, this);" readonly></td>
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:15%;font-size: 12px">N° PROSPECTO:</td>
												<td style="width:25%"><input type="text" class="form-control input-sm" name="lblnprospecto" id="lblnprospecto" data-inputmask='"mask": "999999"' value="<?php echo $nprospecto; ?>" data-mask>
													<input type="text" name="lblnprospectohidden" id="lblnprospectohidden" value="<?php echo $nprospecto; ?>" hidden>
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px">N° CONTRATO:</td>
												<td style="width:2%"></td>
												<td style="width:25%"><input type="text" class="form-control input-sm" name="lblncontrato" id="lblncontrato" data-inputmask='"mask": "9999999"' value="<?php echo $ncontrato; ?>" data-mask readonly="readonly">
												</td>
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:15%;font-size: 12px">CLIENTE:</td>
												<td style="width:25%;"><input name="lblnombcliente" class="form-control input-sm" id="lblnombcliente" value="<?php echo $cliente; ?>" style="width: 100%;" /></td>
												<input id="lblidcliente" name="lblidcliente" value="<?php echo $idcliente; ?>" hidden="">
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px">CORREO:</td>
												<td style="width:2%"></td>
												<td style="width:25%"><input type="text" class="form-control input-sm" id="lblcorreo" value="<?php echo $correo; ?>" name="lblcorreo"></td>
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:15%;font-size: 12px">DIRECCIÓN:</td>
												<td colspan="3" style="width:50%"><textarea class="form-control input-sm" name="lbldireccion" id="lbldireccion" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo $direccion; ?></textarea></td>
												<td style="width:2%"></td>
												<td style="width:25%">
													<select class="form-control selectdistrito input-sm" name="lbldistrito" id="lbldistrito" style="width: 100%;">
														<option value="<?php echo $idgeografico; ?>"><?php echo utf8_encode($distrito) . ' - ' . $provincia; ?></option>
													</select>
													<input id="lblIdProvincial" name="lblIdProvincial" value="<?php echo $IdProvincial; ?>" hidden="" />
													<input id="lblIdDepartamental" name="lblIdDepartamental" value="<?php echo $IdDepartamental; ?>" hidden="" />
													<input id="lblCodUbigeoReniec" name="lblCodUbigeoReniec" value="<?php echo $CodUbigeoReniec; ?>" hidden="" />
												</td>
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:15%;font-size: 12px">PRIORIDAD SIMS:</td>
												<td style="width:25%;"><input name="lblsims" class="form-control input-sm" id="lblsims" value="<?php echo $sims; ?>" style="width: 100%;" disabled /></td>
												<td style="width:10%"></td>
												<!--<td style="width:15%;font-size: 12px">CORREO:</td>
												<td style="width:2%"></td>
												<td style="width:25%"><input type="text" class="form-control input-sm" id="lblcorreo" value="<?php //echo $correo; ?>" name="lblcorreo"></td> -->
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:15%;font-size: 12px">INTERIOR:</td>
												<td colspan="3" style="width:50%">
													<textarea class="form-control input-sm" name="lblinterior" id="lblinterior" rows="1" style="resize:none" disabled><?php echo $Interior; ?></textarea>
												</td>
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:15%;font-size: 12px">TELEFONO UNO:</td>
												<td style="width:25%"><input type="text" class="form-control input-sm" name="lblmovil" id="lblmovil" value="<?php echo $movil; ?>" onkeypress="return event.charCode >= 48 && event.charCode <= 57" maxlength="9">
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px">TELEFONO DOS:</td>
												<td style="width:2%"></td>
												<td style="width:25%"><input type="text" class="form-control input-sm" name="lblfijo" id="lblfijo" value="<?php echo $fijo; ?>" onkeypress="return event.charCode >= 48 && event.charCode <= 57" maxlength="9">
												</td>
											</tr>
											<tr class="espacio <?php if($OrigenVisita=="FB_CAMERA_PROMO_TEST_INTERBANK_cotizaciones" || $OrigenVisita=="FB_CAMERA_PROMO_TEST_INTERBANK_m_cotizaciones" || $OrigenVisita=="FB_CAMERA_PROMO_TEST_BCP_cotizaciones" || $OrigenVisita=="FB_CAMERA_PROMO_TEST_BCP_m_cotizaciones" || $OrigenVisita=="FB_CAMERA_PROMO_TEST_OH_cotizaciones" || $OrigenVisita=="FB_CAMERA_PROMO_TEST_OH_m_cotizaciones" || $OrigenVisita=="FB_CAMERA_PROMO_TEST_BBVA_cotizaciones" || $OrigenVisita=="FB_CAMERA_PROMO_TEST_BBVA_m_cotizaciones"){ echo '';}else{echo 'ocultar';}?>"></tr>
											<tr class="<?php if($OrigenVisita=="FB_CAMERA_PROMO_TEST_INTERBANK_cotizaciones" || $OrigenVisita=="FB_CAMERA_PROMO_TEST_INTERBANK_m_cotizaciones" || $OrigenVisita=="FB_CAMERA_PROMO_TEST_BCP_cotizaciones" || $OrigenVisita=="FB_CAMERA_PROMO_TEST_BCP_m_cotizaciones" || $OrigenVisita=="FB_CAMERA_PROMO_TEST_OH_cotizaciones" || $OrigenVisita=="FB_CAMERA_PROMO_TEST_OH_m_cotizaciones" || $OrigenVisita=="FB_CAMERA_PROMO_TEST_BBVA_cotizaciones" || $OrigenVisita=="FB_CAMERA_PROMO_TEST_BBVA_m_cotizaciones"){ echo '';}else{echo 'ocultar';}?>">
												<td style="width:15%;font-size: 12px">ORIGEN:</td>
												<td style="width:25%">
													<?php if($OrigenVisita=="FB_CAMERA_PROMO_TEST_BBVA_cotizaciones" || $OrigenVisita=="FB_CAMERA_PROMO_TEST_BBVA_m_cotizaciones"){?>                                                            
													<span class="labelBBVA" id="btnPromoBanco"><i class="fa fa-check"></i> PROMO BANCO BBVA</span>
													<span style="color:red;white-space:normal"> Recordar que el pago de la instalación es con tarjeta BBVA </span>
													<?php }if($OrigenVisita=="FB_CAMERA_PROMO_TEST_INTERBANK_cotizaciones" || $OrigenVisita=="FB_CAMERA_PROMO_TEST_INTERBANK_m_cotizaciones"){?>
													<span class="labelInterbank" id="btnPromoBanco"><i class="fa fa-check"></i> PROMO BANCO INTERBANK</span>
													<span style="color:red;white-space:normal"> Recordar que el pago de la instalación es con tarjeta INTERBANK </span>  
													<?php }if($OrigenVisita=="FB_CAMERA_PROMO_TEST_BCP_cotizaciones" || $OrigenVisita=="FB_CAMERA_PROMO_TEST_BCP_m_cotizaciones"){?>
													<span class="labelBCP" id="btnPromoBanco"><i class="fa fa-check"></i> PROMO BANCO BCP</span>
													<span style="color:red;white-space:normal"> Recordar que el pago de la instalación es con tarjeta BCP </span>
													<?php }if($OrigenVisita=="FB_CAMERA_PROMO_TEST_OH_cotizaciones" || $OrigenVisita=="FB_CAMERA_PROMO_TEST_OH_m_cotizaciones"){?>
													<span class="labelOH" id="btnPromoBanco"><i class="fa fa-check"></i> PROMO FINANCIERA OH</span>
													<span style="color:red;white-space:normal"> Recordar que el pago de la instalación es con tarjeta OH </span>
													<?php }?>
													<input type="hidden" id="OrigenVisita" value="<?php echo $OrigenVisita;?>">                                                
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px"></td>
												<td style="width:2%"></td>
												<td style="width:25%">
												</td>
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:15%;font-size: 12px">
													<h5 class="subtitulo">INFORMACION SCORING</h5>
												</td>
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:15%;font-size: 12px">RESULTADO SCORING:</td>
												<td style="width:25%">
													<select class="form-control input-sm" name="lblresultadoScoring" id="lblresultadoScoring" disabled>
														<option value="" disabled selected>Seleccione</option>
														<option value="Especial">Oferta especial</option>
														<option value="Oferta">Oferta</option>
														<option value="Limitada">Oferta limitada</option>
														<option value="Extraordinaria">Oferta extraordinaria</option>
														<option value="Unica">Oferta unica</option>
													</select>
													<input type="hidden" id="valresultadoScoring" value="<?php echo $ScoringRP; ?>">
													<input type="hidden" id="valcodigoOperacionScoring" value="<?php echo $CodigoOperacionScoring; ?>">
													<input type="hidden" id="IdDocRP" value="<?php echo $IdDocRP; ?>">
													<input type="hidden" id="valPrecioBomba" value="<?php echo $resultadoPrecioBomba; ?>">
													<input type="hidden" id="NombresScoring" name="NombresScoring" value="<?php echo $NombresScoring;?>"/>
													<input type="hidden" id="ApellidoPaternoScoring" name="ApellidoPaternoScoring" value="<?php echo $ApellidoPaternoScoring;?>"/>
													<input type="hidden" id="ApellidoMaternoScoring" name="ApellidoMaternoScoring" value="<?php echo $ApellidoMaternoScoring;?>"/>
													<input type="hidden" id="TipoDocumentoScoring" name="TipoDocumentoScoring" value="<?php echo $TipoDocumentoScoring;?>"/>
												</td>
												<td style="width:10%"></td>
												<td colspan="3" style="width:42%">
													<div class="form-group">
														<div class="col-sm-6 col-xs-6">
															<button type="button" class="btn btn-danger btn-block btn-sm" id="btnModalconsultascoring" data-toggle="modal" data-target="#modal-consultascoring"><i class="fa fa-cog"></i> SCORING</button>
														</div>
														<div class="col-sm-6 col-xs-6">
															<button type="button" class="btn btn-default btn-block btn-sm" id="logconsultadoc" data-toggle="modal" data-target="#modal-logdni"><i class="fa fa-pencil-square-o"></i> CONSULTAS DOC.</button>
														</div>
													</div>
												</td>
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:15%;font-size: 12px">DOCUMENTO SCORING:<span class="<?php if($tipoventa=='RE'){ echo '';}else{ echo 'ocultar';} ?> spandocumentovisita">
												<?php 
												    if($tipoventa=='RE'){
       												    if($ScoringRP=='Extraordinaria' || $ScoringRP=='Especial' || $ScoringRP=='Oferta'){
        												    echo '<i class="fa fa-fw fa-check-circle" style="color: green;"></i>';
        												}else{
        												    echo '<i class="fa fa-fw fa-times" style="color: red;"></i>';
        												}
												    }else{
												        echo '';
												    }
												?>												    

												</span>
												</td>
												<td style="width:25%;"><input type="text" class="form-control input-sm" name="lbldocumentoscoring" id="lbldocumentoscoring" maxlength="11" onkeypress="return event.charCode >= 48 && event.charCode <= 57" value="<?php echo $DocumentoScoring; ?>" readonly="readonly">
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px">TITULAR SCORING:</td>
												<td style="width:2%"></td>
												<td style="width:25%"><input name="lbltitularscoring" id="lbltitularscoring" class="form-control input-sm" style="width: 100%;" value="<?php echo $NombreScoring; ?>" readonly="readonly"></td>
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:15%;font-size: 12px">VALIDACIÓN DOCUMENTO</td>
												<td style="width:25%">
													<input type="text" class="form-control input-sm" id="lblresultadodocumento" name="lblresultadodocumento"  value="<?php echo $ResultadoValidacion;?>" readonly="readonly">
												</td>
												<td style="width:10%"></td>
	                                            <td style="width:15%;font-size: 12px"><span class="<?php if($tipoventa=='RE'){ echo '';}else{ echo 'ocultar';} ?> ocultardocumentovisita"> DOCUMENTO VISITA:</span></td>
												<td style="width:2%"></td>
												<td style="width:25%"><input type="text" class="form-control input-sm <?php if($tipoventa=='RE'){ echo '';}else{ echo 'ocultar';} ?> ocultardocumentovisita" name="lbldocumentovisita" id="lbldocumentovisita" maxlength="11" onkeypress="return event.charCode >= 48 && event.charCode <= 57" value="<?php echo $DocumentoVisita;?>"  readonly="readonly" ></td>
											</tr>
											<tr>
												<td style="width:15%;font-size: 12px">
													<h5 class="subtitulo">DATOS DE LA OFERTA</h5>
													<input type="hidden" id="datosGeneral" value='<?php echo $DetalleGeneral; ?>'>
													<input type="hidden" id="datosExtras" value='<?php echo $DetalleExtras; ?>'>
													<input type="hidden" id="datosRegalos" value='<?php echo $DetalleRegalos; ?>'>                                                
												</td>
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:15%;font-size: 12px">TIPO KIT:</td>
												<td style="width:25%">
													<select class="form-control input-sm" id="lbltipokit" name="lbltipokit">
														<option value="" disabled <?php if ($TipoKIT == '' || $TipoKIT == NULL) {
															echo 'selected';
															} ?>>-- SELECCIONE --</option>
														<option value="Basico" <?php if ($TipoKIT == 'Basico') {
															echo 'selected';
															} ?>>BASICO</option>
														<option value="Premium" <?php if ($TipoKIT == 'Premium') {
															echo 'selected';
															} ?> disabled hidden>PREMIUM</option>
														<option value="ZeroVision" <?php if ($TipoKIT == 'ZeroVision') {
															echo 'selected';
															} ?>>ZEROVISION</option>
														<option value="Reconexion" <?php if ($TipoKIT == 'Reconexion') {
															echo 'selected';
															} ?>>RECONEXION</option>
														<option value="Camara" <?php if ($TipoKIT == 'Camara') {
															echo 'selected';
															} ?> <?php echo ($dc == "154" || $dc == "157" || $dc == "158" || $matriculausuario=='MGR200' || $dc == "155" || $dc == "152" || $dc == "200" || $dc == "159" || $dc == "40" || $dc == "140" || $dc == "156")?'hidden disabled':'hidden disabled'; ?> >CAMARA</option>
														<option value="High Security" <?php if ($TipoKIT == 'High Security') {
															echo 'selected';
															} ?> <?php echo ($dc == "154" || $dc == "157" || $dc == "158" || $matriculausuario=='MGR200' || $dc == "155" || $dc == "152" || $dc == "200" || $dc == "159" || $dc == "40" || $dc == "140" || $dc == "156")?'hidden disabled':'hidden disabled'; ?>>HIGH SECURITY</option>
                                                        <option value="Basico PRO" <?php if ($TipoKIT == 'Basico PRO') {
                        															echo 'selected';
                        															} ?> <?php echo ($dc == "150" || $dc == "154" || $dc == "158" || $dc == "151" || $dc == "152" || $dc == "153" || $dc == "155" || $dc == "156" || $dc == "157" || $dc == "159" || $dc == "251" || $dc == "252" || $dc == "513" || $dc == "121" || $dc == "701" || $dc == "702" || $dc == "601" || $dc == "602" || $dc == "901" || $dc == "130" || $dc == "230" || $dc == "500" || $dc == "513" || $dc == "60")?'':'hidden disabled'; ?>>BASICO PRO</option>
                                                        <option value="ZeroVision PRO" <?php if ($TipoKIT == 'ZeroVision PRO') {
                        															echo 'selected';
                        															} ?> <?php echo ($dc == "150" || $dc == "154" || $dc == "158" || $dc == "151" || $dc == "152" || $dc == "153" || $dc == "155" || $dc == "156" || $dc == "157" || $dc == "159" || $dc == "251" || $dc == "252" || $dc == "513" || $dc == "100" || $dc == "701" || $dc == "702" || $dc == "601" || $dc == "602" || $dc == "901" || $dc == "130" || $dc == "230" || $dc == "500" || $dc == "513" || $dc == "60")?'':'hidden disabled'; ?>>ZEROVISION PRO</option>  
                                                        <option value="ZeroVision LA CURACAO" <?php if ($TipoKIT == 'ZeroVision LA CURACAO') {
                        													echo 'selected';
                        													} ?> <?php echo ($dc == "701" || $dc == "702")?'hidden disabled':'hidden disabled'; ?>>ZEROVISION LA CURACAO</option>                        										
                        								<option value="ZeroVision PRO LA CURACAO" <?php if ($TipoKIT == 'ZeroVision PRO LA CURACAO') {
                        													echo 'selected';
                        													} ?> <?php echo ($dc == "701" || $dc == "702")?'hidden disabled':'hidden disabled'; ?>>ZEROVISION PRO LA CURACAO</option>
                                                        <option value="Basico LA CURACAO" <?php if ($TipoKIT == 'Basico LA CURACAO') {
                        													echo 'selected';
                        													} ?> <?php echo ($dc == "701" || $dc == "702")?'hidden disabled':'hidden disabled'; ?>>BASICO LA CURACAO</option>                        										
                        								<option value="Basico PRO LA CURACAO" <?php if ($TipoKIT == 'Basico PRO LA CURACAO') {
                        													echo 'selected';
                        													} ?> <?php echo ($dc == "701" || $dc == "702")?'hidden disabled':'hidden disabled'; ?>>BASICO PRO LA CURACAO</option> 
                        													
	                                                    <option value="ZeroVision JOCKEY PLAZA" <?php if ($TipoKIT == 'ZeroVision JOCKEY PLAZA') {
                        													echo 'selected';
                        													} ?> <?php echo ($dc == "901")?'':'hidden disabled'; ?>>ZeroVision JOCKEY PLAZA</option>          													
                                                            </select>
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px">PAI:</td>
												<td style="width:2%"></td>
												<td style="width:25%">
													<select class="form-control input-sm" name="lblPAI" id="lblPAI">
														<option  value="" disabled>Seleccione</option>
														<!-- <option value="BBVA-DIN"<?php //if ($PAI == "BBVA-DIN") {echo "selected";}?>>BBVA-DIN</option> -->
														<option value="PAI 30x36"<?php if ($PAI == "PAI 30x36") {echo "selected";}?>>PAI 30x36</option>
														<option value="NO"<?php if ($PAI == "NO") {echo "selected";}?>>NO</option>
													</select>
												</td>
											</tr>
											<!-- PILOTO DE ARLO-->                                        
											<tr class="espacio camaraarlo <?php if ($TipoCamaraKit == '' || $TipoCamaraKit == null) {
												echo 'ocultar';
												} ?>"></tr>
											<tr>
												<td style="width:15%;font-size: 12px" <?php if ($TipoCamaraKit == '' || $TipoCamaraKit == null) {
													echo 'class="camaraarlo ocultar"';
													} ?>>TIPO CÁMARA KIT:</td>
												<td style="width:25%" <?php if ($TipoCamaraKit == '' || $TipoCamaraKit == null) {
													echo 'class="camaraarlo ocultar"';
													} ?>>
													<select class="form-control input-sm" id="lbltipocamarakit" name="lbltipocamarakit">
														<option value="" disabled selected>Seleccione</option>
														<option value="Camara Interna N1" <?php if ($TipoCamaraKit == 'Camara Interna N1') {
															echo 'selected';
															} ?>>CAMARA INTERNA N1</option>
														<option value="Camara Interna Arlo" <?php if ($TipoCamaraKit == 'Camara Interna Arlo') {
															echo 'selected';
															} ?>>CAMARA INTERNA ARLO</option>
														<option value="Camara Externa Arlo" <?php if ($TipoCamaraKit == 'Camara Externa Arlo') {
															echo 'selected';
															} ?>>CAMARA EXTERNA ARLO</option>
													</select>
													<input type="hidden" id="valtipocamarakit" value="<?php echo $TipoCamaraKit; ?>">
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px"></td>
												<td style="width:2%"></td>
												<td style="width:25%">
												</td>
											</tr>
											<tr class="espacio"></tr>
											<tr class="">
												<td style="width:15%;font-size: 12px">CATEGORIA PRECIO:</td>
												<td style="width:25%">
													<select class="form-control input-sm" id="lblcategoriaprecio" name="lblcategoriaprecio">
														<option value="" disabled selected>Seleccione</option>
													</select>
													<input type="hidden" id="hidCategoriaPrecio" value="<?php echo $CategoriaPrecio; ?>">
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px">CATEGORIA KIT AUTORIZADOS:</td>
												<td style="width:2%"></td>
												<td style="width:25%">
													<input type="checkbox" name="categoriaKitAutorizados" id="categoriaKitAutorizados" data-size="small"  <?php if ($CategoriaKitAutorizados == "SI") {
														echo 'checked';
														} else {
														echo '';
														} ?>/>
													<input type="hidden" name="hidcategoriaKitAutorizados" id="hidcategoriaKitAutorizados" value="<?php echo $CategoriaKitAutorizados; ?>" />
												</td>
											</tr>
											<!-- SEGUNDA ALARMA-->                                        
											<tr class="espacio segundaalarma <?php if ($CategoriaPrecio != 'PRECIO SEGUNDA ALARMA') {
												echo 'ocultar';
												} ?>"></tr>
											<tr>
												<td style="width:15%;font-size: 12px" <?php if ($CategoriaPrecio != 'PRECIO SEGUNDA ALARMA') {
													echo 'class="segundaalarma ocultar"';
													} ?>>ESCRIBIR PRIMERA ALARMA:</td>
												<td style="width:25%" <?php if ($CategoriaPrecio != 'PRECIO SEGUNDA ALARMA') {
													echo 'class="segundaalarma ocultar"';
													} ?>>
													<input type="text" class="form-control input-sm" name="lblsegundaalarma" id="lblsegundaalarma" value="<?php echo $SegundaAlarma; ?>" data-inputmask='"mask": "9999999"' data-mask>
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px"></td>
												<td style="width:2%"></td>
												<td style="width:25%">
												</td>
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:15%;font-size: 12px">PRECIO KIT:</td>
												<td style="width:25%">
													<div class="input-group">
														<div class="input-group-addon input-sm">
															<i class="">S/.</i>
														</div>
														<input type="text" class="form-control input-sm" name="lblpreciokit" id="lblpreciokit" value="<?php echo $preciokit; ?>" onkeypress="return filterFloat(event, this);">
														<input type="hidden" id="precioKit__MIN">
														<input type="hidden" id="precioKit__MAX">
														<input type="hidden" id="hidPrecioKit" value="<?php echo $preciokit; ?>">
													</div>
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px"></td>
												<td style="width:2%"></td>
												<td style="width:25%">
												</td>
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:15%;font-size: 12px">CANTIDAD EXTRAS:</td>
												<td style="width:25%">
													<div class="input-group">
														<input type="number" class="form-control input-sm" id="lblCantExtras" name="lblCantExtras" min="0" value="<?php if($CantidadExtras == '' || $CantidadExtras == null){echo '0'; } else {echo $CantidadExtras;} ?>" disabled>       
														<div class="input-group-btn">
															<button type="button" id="generarExtras" class="btn btn-danger btn-sm"><i class="fa fa-cart-plus"></i></button>
														</div>
													</div>
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px">TOTAL EXTRA:</td>
												<td style="width:2%"></td>
												<td style="width:25%">
													<div class="input-group">
														<div class="input-group-addon input-sm">
															<i class="">S/.</i>
														</div>
														<input type="number" class="form-control input-sm" name="lbltotalextra" id="lbltotalextra" value="<?php if($totalextra == '' || $totalextra == null){echo '0'; } else {echo $totalextra;} ?>" onkeypress="return filterFloat(event, this);" disabled>
													</div>
												</td>
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:15%;font-size: 12px">CLOSING PACK:</td>
												<td style="width:25%">
													<select class="form-control input-sm" name="lblclosingpack" id="lblclosingpack">
														<option value="" disabled selected>Seleccione</option>
														<option value="Ninguno">Ninguno</option>
													</select>
													<input type="hidden" id="valclosingpack" value="<?php echo $ClosingPack; ?>">
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px" <?php if ($ClosingPack == "Ninguno") {
													echo 'class="ocultar"';
													} ?>>CLOSING PACK AUTORIZADOS:</td>
												<td style="width:2%"></td>
												<td style="width:25%" <?php if ($ClosingPack == "Ninguno") {
													echo 'class="ocultar"';
													} ?>>
													<input type="checkbox" name="closingpackAutorizados" id="closingpackAutorizados" data-size="small" <?php if ($ClosingpackAutorizados == "SI") {
														echo 'checked';
														} else {
														echo '';
														} ?> />
													<input type="hidden" name="hidclosingpackAutorizados" id="hidclosingpackAutorizados" value="<?php echo $ClosingpackAutorizados; ?>" />
												</td>
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:15%;font-size: 12px">RESUMEN INST.:</td>
												<td colspan="5" style="width:77%"><textarea class="form-control input-sm" name="lblresumenventa" id="lblresumenventa" rows="1" style="resize:none" placeholder="Ingresar..." disabled><?php echo $resumenventa; ?></textarea></td>
											</tr>
											<tr class="espacio"></tr>
											<tr class="">
												<td style="width:15%;font-size: 12px">CANTIDAD REGALOS:</td>
												<td style="width:25%;">
													<div class="input-group">
														<input type="number" class="form-control input-sm col-md-8" id="lblCantRegalos" name="lblCantRegalos" min="0" value="<?php if($CantidadRegalo == '' || $CantidadRegalo == null){ echo '0';} else { echo $CantidadRegalo; } ?>" disabled>
														<div class="input-group-btn">
															<button type="button" id="generarRegalos" class="btn btn-danger btn-sm"><i class="fa fa-cart-plus"></i></button>
														</div>
													</div>
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px" <?php if ($CantidadRegalo == 0 || $CantidadRegalo == '' || $CantidadRegalo == null) {
													echo 'class="ocultar"';
													} ?>>REGALOS AUTORIZADOS:</td>
												<td style="width:2%"></td>
												<td style="width:25%" <?php if ($CantidadRegalo == 0 || $CantidadRegalo == '' || $CantidadRegalo == null) {
													echo 'class="ocultar"';
													} ?>>
													<input type="checkbox" name="regalosAutorizados" id="regalosAutorizados" data-size="small" <?php if ($RegalosAutorizados == "SI") {
														echo 'checked';
														} else {
														echo '';
														} ?> />
													<input type="hidden" name="hidregalosAutorizados" id="hidregalosAutorizados" value="<?php echo $RegalosAutorizados; ?>" />
												</td>
											</tr>
											<tr class="espacio"></tr>
											<tr class="">
											            
											    <?php   
											            $mostrarEtiquetaSales="hidden";
											            
											            if($tipoventa == "RE" || $tipoventa == "REGGCC"){
											            $mostrarEtiqueta="";
											            
											                    if($matriculausuario=='Q33181' || $matriculausuario=='GW4530' || $matriculausuario=='Q15477' || $matriculausuario=='Q47986' || $matriculausuario=='Q80987' || $matriculausuario=='JB4716' || $matriculausuario=='Q86841' ){
        											                $mostrarEtiquetaSales="";
        											            }
        											    }else{
        											        if($CategoriaPrecio == 'RENOVE' || $CategoriaPrecio == 'EXCEPCION RENOVE' || $CategoriaPrecio == 'SUPER OFERTA RENOVE' || $CategoriaPrecio == 'OFERTA RECARGADA RENOVE' ){
        											            if($matriculausuario=='Q33181' || $matriculausuario=='GW4530' || $matriculausuario=='Q15477' || $matriculausuario=='Q47986' || $matriculausuario=='Q80987' || $matriculausuario=='JB4716' || $matriculausuario=='Q86841'){
        											                $mostrarEtiquetaSales="";
        											            }
        											            $mostrarEtiqueta="";
        											            
        											        }else{
        											            $mostrarEtiqueta="hidden";
        											            if($matriculausuario=='Q33181' || $matriculausuario=='GW4530' || $matriculausuario=='Q15477' || $matriculausuario=='Q47986' || $matriculausuario=='Q80987' || $matriculausuario=='JB4716' || $matriculausuario=='Q86841'){
        											                $mostrarEtiqueta="";
        											                $mostrarEtiquetaSales="";
        											            }        											            
        											        }
        											        
        											    }
											    
											    ?>
												<td class="<?php echo $mostrarEtiqueta; ?> mostrarEtiqueta" style="width:15%;font-size: 12px">DESCUENTO CUOTA:</td>
												<td class="<?php echo $mostrarEtiqueta; ?> mostrarEtiqueta" style="width:25%">
													<select class="form-control input-sm" id="lblDescuentoCuota" name="lblDescuentoCuota">
														<option value="" disabled selected>Seleccione</option>
														<option value="ninguno" <?php if($dsctCuota == 'ninguno'){echo 'selected'; } ?>>Ninguno</option>
														<option value="1mes"  <?php if($dsctCuota == '1mes'){echo 'selected'; } ?>>50% DESCUENTO 1 MES</option>
														<option value="2meses"  <?php if($dsctCuota == '2meses'){echo 'selected'; } ?>>50% DESCUENTO 2 MESES</option>
														<option value="3meses"  <?php if($dsctCuota == '3meses'){echo 'selected'; } ?> <?php echo $mostrarEtiquetaSales;?>>50% DESCUENTO 3 MESES</option>
														<option value="4meses"  <?php if($dsctCuota == '4meses'){echo 'selected'; } ?> <?php echo $mostrarEtiqueta;?> >50% DESCUENTO 4 MESES</option>
														<option value="6meses"  <?php if($dsctCuota == '6meses'){echo 'selected'; } ?> hidden>50% DESCUENTO 6 MESES</option>
														<option value="2mesesBBVA"  <?php if($dsctCuota == '2mesesBBVA'){echo 'selected'; } ?> hidden>50% DESCUENTO 2 MESES BBVA</option>
														<option value="2mesesInterbank"  <?php if($dsctCuota == '2mesesInterbank'){echo 'selected'; } ?> hidden>50% DESCUENTO 2 MESES INTERBANK</option>
													</select>
													<input type="hidden" value="<?php echo $dsctCuota; ?>">
												</td>
												
												
												<td class="<?php echo $mostrarEtiqueta; ?> mostrarEtiqueta" style="width:10%"></td>
												<td style="width:15%;font-size: 12px" <?php if ($dsctCuota == 'ninguno') {
													echo 'class="ocultar"';
													} ?>>DESC. CUOTA AUTORIZADOS:</td>
												<td class="<?php echo $mostrarEtiqueta; ?> mostrarEtiqueta" style="width:2%"></td>
												<td style="width:25%" <?php if ($dsctCuota == 'ninguno') {
													echo 'class="ocultar"';
													} ?>>
													<input type="checkbox" name="descuetocuotaAutorizados" id="descuetocuotaAutorizados" data-size="small" <?php if ($DescuentoCuotaAutorizados == "SI") {
														echo 'checked';
														} else {
														echo '';
														} ?> />
													<input type="hidden" name="hiddescuetocuotaAutorizados" id="hiddescuetocuotaAutorizados" value="<?php echo $DescuentoCuotaAutorizados; ?>" />
												</td>
											</tr>
											<tr class="espacio"></tr>
											<tr class="">
												<td style="width:15%;font-size: 12px">TOTAL CUOTA:</td>
												<td style="width:25%">
													<div class="input-group">
														<div class="input-group-addon input-sm">
															<i class="">S/.</i>
														</div>
														<input type="number" class="form-control input-sm" name="lbltotalcuota" id="lbltotalcuota" value="<?php if($TotalCuotaMonitoreo == '' || $TotalCuotaMonitoreo == null){ echo '0';} else { echo $TotalCuotaMonitoreo; } ?>" onkeypress="return filterFloat(event, this);" disabled>
													</div>
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px"></td>
												<td style="width:2%"></td>
												<td style="width:25%">
												</td>
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:15%;font-size: 12px">FORMA DE PAGO:</td>
												<td style="width:25%;font-size: 12px">
													<select class="form-control input-sm" name="lblformadepago" id="lblformadepago">
														<option value="">Seleccione</option>
														<option value="Cheque" <?php if ($formadepago == "Cheque") {
															echo "selected";
															} ?>>Cheque</option>
														<option value="Deposito" <?php if ($formadepago == "Deposito") {
															echo "selected";
															} ?>>Depósito</option>
														<option value="Transferencia" <?php if ($formadepago == "Transferencia") {
															echo "selected";
															} ?>>Transferencia</option>
														<option value="TransferenciaInterbancaria" <?php if ($formadepago == "TransferenciaInterbancaria") {
															echo "selected";
															} ?>>Transferencia Interbancaria</option>
														<option value="PagoPOSVisa" <?php if ($formadepago == "PagoPOSVisa") {
															echo "selected";
															} ?>>Pago POSVisa</option>
														<option value="PagoPOSMC" <?php if ($formadepago == "PagoPOSMC") {
															echo "selected";
															} ?>>Pago POSMC</option>
														<option value="TarjetadeCredito" <?php if ($formadepago == "TarjetadeCredito") {
															echo "selected";
															} ?>>Tarjeta de Crédito</option>
														<option value="PagoPasarella" <?php if ($formadepago == "PagoPasarella") {
															echo "selected";
															} ?>>Pago Pasarella</option>
													</select>
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px" class="ocultar">REGALO AUTORIZADO:</td>
												<td style="width:2%"></td>
												<td style="width:25%" class="ocultar">
													<select class="form-control input-sm" name="lblextraautorizado" id="lblextraautorizado">
														<option value="">Seleccione</option>
														<option value="Ninguno" <?php if ($regaloutorizado == "Ninguno") {
															echo "selected";
															} ?>>Ninguno</option>
														<option value="Mando a distancia" <?php if ($regaloutorizado == "Mando a distancia") {
															echo "selected";
															} ?>>Mando a distancia</option>
														<option value="Magnetico" <?php if ($regaloutorizado == "Magnetico") {
															echo "selected";
															} ?>>Magnetico</option>
														<option value="Pulsador" <?php if ($regaloutorizado == "Pulsador") {
															echo "selected";
															} ?>>Pulsador</option>
													</select>
												</td>
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:15%;font-size: 12px">590:</td>
												<td style="width:25%">
													<div class="input-group">
														<div class="input-group-addon input-sm">
															<i class="fa fa-calendar"></i>
														</div>
														<input type="text" class="form-control pull-right input-sm" style="cursor:pointer;background-color: #fff;" id="mesano" data-role="date" value="<?php if (isset($n590)) {
															echo $n590;
															} else {
															echo $fechames;
															} ?>" name="lbl590" readonly="readonly">
													</div>
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px"></td>
												<td style="width:2%"></td>
												<td style="width:25%">
												</td>
											</tr>
											<tr class="espacio"></tr>
											<tr class="ocultar">
												<td style="width:15%;font-size: 12px">CONTACTADO POR CO:</td>
												<td style="width:25%;"><input type="checkbox" name="contactadoco" id="contactadoco" <?php if ($contactadoco == "SI") {
													echo 'checked';
													} else {
													echo '';
													} ?> data-size="small" />
													<input type="hidden" name="hidden_contact" id="hidden_contact" value="<?php echo $contactadoco; ?>">
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px">VTA CONFIRMADA POR CO</td>
												<td style="width:2%"></td>
												<td style="width:25%"><input type="checkbox" name="ventaconfirmadaco" id="ventaconfirmadaco" <?php if ($VTAConfirmadaCO == "SI") {
													echo 'checked';
													} else {
													echo '';
													} ?> data-size="small" />
													<input type="hidden" name="hidden_ventaconfirmadaco" id="hidden_ventaconfirmadaco" value="<?php echo $VTAConfirmadaCO; ?>">
												</td>
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:15%;font-size: 12px">HOJA CERTIFICACIÓN:</td>
												<td style="width:25%;">
													<input type="checkbox" name="HCertificacion" id="HCertificacion" <?php if ($HojaCertificacion == "SI") {
														echo 'checked';
														} else {
														echo '';
														} ?> data-size="small" />
													<input type="hidden" name="hidden_HCertificacion" id="hidden_HCertificacion" value="<?php echo $HojaCertificacion; ?>">
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px">GGCC:</td>
												<td style="width:2%"></td>
												<td style="width:25%">
													<input type="checkbox" name="GGCC" id="GGCC" <?php if ($GGCC == "SI") {
														echo 'checked';
														} else {
														echo '';
														} ?> data-size="small" />
													<input type="hidden" name="hidGGCC" id="hidGGCC" value="<?php echo $GGCC; ?>" />
												</td>
											</tr>
											<tr class="espacio"></tr>
										</table>
									</div>
									<!-- /.box-body -->
								</div>
								<div class="box box-custom">
									<div class="box-header with-border" style="background-color:#2c3b41;color:white;">
										<h5>INFORMACION DE COORDINADORA</h5>
										<div class="box-tools pull-right">
										    <a class="btn btn-default btn-sm" id="btnGuardarEditarVentaCoordinadora" href="#"><i class="fa fa-save"></i> Guardar Informacion</a> 
											<button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
											</button>
										</div>
									</div>
									<!-- /.box-header -->
									<div class="box-body">
									    
										<table cellspacing="0" style="width:100%;border-collapse: separate;padding: 20px;">
											<tr class="gestorcontrato">
												<td style="width:15%;font-size: 12px">
													<!--<h5 class="subtitulo">R1</h5>-->
												</td>
											</tr>										    
											<tr class="gestorcontrato">
												<td style="width:15%;font-size: 12px">¿CONTRATO ENVIADO?</td>
												<td style="width:25%">
													<select class="form-control input-sm" name="contratoenviado" id="contratoenviado">
														<option value="" disabled selected>Seleccione</option>
														<option value="SI" <?php if ($ContratoEnviado == "SI") {echo "selected";}?>>SI</option>
														<option value="NO"<?php if ($ContratoEnviado == "NO") {echo "selected";}?>>NO</option>
													</select>
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px"><span class="contratoenviado <?php if ($ContratoEnviado == "SI") {echo "";}else{echo "hidden";}?>">FECHA CONTRADO ENVIADO POR FF.VV:</span></td>
												<td style="width:2%"></td>
												<td style="width:25%">
													<div class="input-group contratoenviado <?php if ($ContratoEnviado == "SI") {echo "";}else{echo "hidden";}?>" id="fi">
														<div class="input-group-addon input-sm">
															<i class="fa fa-calendar"></i>
														</div>
														<input type="text" class="form-control pull-right input-sm" id="FechaContratoEnviado" value="<?php echo $FechaContratoEnviado; ?>" name="FechaContratoEnviado" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask>
													</div>
												</td>
											</tr>
											<tr class="espacio gestorcontrato"></tr>
											<tr class="gestorcontrato">
												<td style="width:15%;font-size: 12px">PAGO ENVIADO:</td>
												<td style="width:25%">
													<select class="form-control input-sm" name="pagoenviadoCO" id="pagoenviadoCO">
														<option value="" disabled selected>Seleccione</option>
														<option value="SIN PAGO" <?php if ($pagoenviadoCO == "SIN PAGO") {echo "selected";}?>>SIN PAGO</option>
														<option value="PAGO PARCIAL" <?php if ($pagoenviadoCO == "PAGO PARCIAL") {echo "selected";}?>>PAGO PARCIAL</option>
														<option value="PAGO TOTAL" <?php if ($pagoenviadoCO == "PAGO TOTAL") {echo "selected";}?>>PAGO TOTAL</option>
													</select>
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px">MONTO:</td>
												<td style="width:2%"></td>
												<td style="width:25%">
													<div class="input-group">
														<div class="input-group-addon input-sm">
															<i class="">S/.</i>
														</div>
														<input type="number" class="form-control input-sm" name="montoCO" id="montoCO" value="<?php echo $montoCO; ?>" onkeypress="return filterFloat(event, this);">
													</div>
												</td>
											</tr>
											<tr class="espacio gestorcontrato"></tr>
											<tr class="gestorcontrato">
												<td style="width:15%;font-size: 12px">¿CONTRATO CORRECTO?</td>
												<td style="width:25%">
													<select class="form-control input-sm" name="contratocorrecto" id="contratocorrecto">
														<option value="" disabled selected>Seleccione</option>
														<option value="SI" <?php if ($ContratoCorrecto == "SI") {echo "selected";}?>>SI</option>
														<option value="NO"<?php if ($ContratoCorrecto == "NO") {echo "selected";}?>>NO</option>
													</select>
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px"><span class="contratocorrecto <?php if ($ContratoCorrecto == "NO") {echo "";}else{echo "hidden";}?>">MOTIVO INCIDENCIA CO</span></td>
												<td style="width:2%"></td>
												<td style="width:25%">
												    <div class="contratocorrecto <?php if ($ContratoCorrecto == "NO") {echo "";}else{echo "hidden";}?>">
													<select class="form-control input-sm selectmotivoincidenciaco" name="motivoincidenciaCO" id="motivoincidenciaCO" style="width: 100%;">
														<option value="<?php echo $motivoincidenciaCO; ?>"><?php echo $motivoincidenciaCO; ?></option>
													</select>
													</div>
												</td>
											</tr>
											<tr class="espacio gestorcontrato"></tr>
											<tr class="gestorcontrato">
												<td style="width:15%;font-size: 12px">COMENTARIO CO</td>
												<td style="width:25%">
													<select class="form-control selectcomentarioco input-sm" name="lblcomentarioco" id="lblcomentarioco" style="width: 100%;">
														<option value="<?php echo $comentarioco; ?>"><?php echo $comentarioco; ?></option>
													</select>
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px">FECHA GESTION DOC COORDINADORA</td>
												<td style="width:2%"></td>
												<td style="width:25%">
												    <div class="input-group" id="fi">
														<div class="input-group-addon input-sm">
															<i class="fa fa-calendar"></i>
														</div>
														<input type="text" class="form-control pull-right input-sm" id="fechagestiondocCO" value="<?php echo $fechagestiondocCO; ?>" name="fechagestiondocCO" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask>
													</div>
												</td>
											</tr>
											<tr class="espacio gestorcontrato"></tr>
											<tr class="">
												<td style="width:15%;font-size: 12px">TIPO DE CONTRATO</td>
												<td style="width:25%">
													<select class="form-control input-sm" name="tipocontrato" id="tipocontrato">
														<option value="" selected>Seleccione</option>
														<option value="FISICO" <?php if($TipoContrato == "FISICO") { echo "selected"; } ?>>Fisico</option>
														<option value="DIGITAL" <?php if($TipoContrato == "DIGITAL") { echo "selected"; } ?>>Digital</option>
													</select>
												</td>
												<td style="width:10%"></td>
												<td style="width:15%"></td>
												<td style="width:2%"></td>
												<td style="width:25%">
												</td>
											</tr>
											<tr class="espacio contratofisico <?php if($TipoContrato == "DIGITAL") { echo "ocultar"; } ?>"></tr>
											<tr class="contratofisico <?php if($TipoContrato == "DIGITAL") { echo "ocultar"; } ?>">
												<td style="width:15%;font-size: 12px">¿AUTORIZADO?</td>
												<td style="width:25%">
													<select class="form-control input-sm" name="autorizadocontratofisico" id="autorizadocontratofisico">
														<option value="" disabled selected>Seleccione</option>
														<option value="SI" <?php if($Autorizado == "SI") { echo "selected"; } ?>>SI</option>
														<option value="NO" <?php if($Autorizado == "NO") { echo "selected"; } ?>>NO</option>
													</select>
												</td>
												<td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">COMENTARIO:</td>
                                                <td colspan="3" style="width:77%">
                                                    <textarea class="form-control input-sm" name="lblcomentariocontratofisico" id="lblcomentariocontratofisico" rows="2" style="resize:none" placeholder="Ingresar..."><?= $Comentarios ?></textarea>
                                                </td>
                                                <td style="width:2%"></td>
											</tr>
											<tr class="espacio contratodigital <?php if($TipoContrato == "FISICO") { echo "ocultar"; } ?>"></tr>
											<tr class="contratodigital <?php if($TipoContrato == "FISICO") { echo "ocultar"; } ?>">
												<td style="width:15%;font-size: 12px">¿CAMBIO A FISICO?</td>
												<td style="width:25%">
													<select class="form-control input-sm" name="cambioacontratofisico" id="cambioacontratofisico">
														<option value="" disabled selected>Seleccione</option>
														<option value="SI" <?php if($CambioFisico == "SI") { echo "selected"; } ?>>SI</option>
														<option value="NO" <?php if($CambioFisico == "SI") { echo "selected"; } ?>>NO</option>
													</select>
												</td>
												<td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">COMENTARIO:</td>
                                                <td colspan="3" style="width:77%">
                                                    <textarea class="form-control input-sm" name="lblcomentariocontratodigital" id="lblcomentariocontratodigital" rows="2" style="resize:none" placeholder="Ingresar..."><?= $Comentarios ?></textarea>
                                                </td>
                                                <td style="width:2%"></td>
											</tr>	
										</table>
									</div>
									<!-- /.box-body -->
								</div>
								<!-- INFORMACION DE CONTRATO DIGITAL / FISICO 18.09.2023 -->
								
								<!-- INFORMACION DE AUDITORIA -->								
								<div class="box box-custom">
									<div class="box-header with-border" style="background-color:#2c3b41;color:white;">
										<h5>INFORMACION DE AGENDA</h5>
										<div class="box-tools pull-right">
											<button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
											</button>
										</div>
									</div>
									<!-- /.box-header -->
									<div class="box-body">
										<table cellspacing="0" style="width:100%;border-collapse: separate;padding: 20px;">
											<tr>
												<td style="width:15%;font-size: 12px">INSTALADOX:</td>
												<td style="width:25%">
													<select class="form-control input-sm" name="lblinstaladox" id="lblinstaladox">
														<option>Seleccione</option>
														<option value="TEC" <?php if ($instaladox == "TEC") {
															echo "selected";
															} ?>>TEC</option>
														<option value="DEL" <?php if ($instaladox == "DEL") {
															echo "selected";
															} ?>>DEL</option>
													</select>
													<input id="lblidagenda" name="lblidagenda" value="<?php echo $idagenda; ?>" hidden="">
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px">TÉCNICO:</td>
												<td style="width:2%"></td>
												<td style="width:25%">
													<select name="lbltecnico" id="lbltecnico" class="form-control cbxtecnico input-sm" style="width: 100%;">
													<?php echo $html_tecnico; ?>
													</select>
												</td>
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:15%;font-size: 12px">F.INSTALACIÓN:</td>
												<td style="width:25%">
													<div class="input-group" id="fi">
														<div class="input-group-addon input-sm">
															<i class="fa fa-calendar"></i>
														</div>
														<input type="text" class="form-control pull-right input-sm" id="fechainst" value="<?php echo $fechainstalacionver; ?>" name="lblfinstalacion" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask>
													</div>
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px">H.INSTALACIÓN:</td>
												<td style="width:2%"></td>
												<td style="width:25%">
													<div class="bootstrap-timepicker timepicker">
														<div class="input-group">
															<input type="text" class="form-control input-sm" placeholder="12:00 AM" name="lblhinstalacion" id="horainst" value="<?php echo $horainstalacionver; ?>">
															<div class="input-group-addon input-sm">
																<i class="fa fa-clock-o"></i>
															</div>
														</div>
													</div>
												</td>
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:15%;font-size: 12px">REPERCUCIÓN:</td>
												<td colspan="3" style="width:50%"><textarea class="form-control input-sm" name="lblrepercucion" id="lblrepercucion" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo $repercucion; ?></textarea></td>
												<td style="width:2%"></td>
												<td style="width:25%"><a class="btn btn-danger btn-sm" href="#" data-toggle="modal" id="logcambios" data-target="#modal-default"><i class="fa fa-pencil-square-o"></i> Log Cambios</a></td>
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:15%;font-size: 12px">COMENTARIO:</td>
												<td colspan="3" style="width:50%"><textarea class="form-control input-sm" name="lblcomentarioagenda" id="lblcomentarioagenda" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo utf8_encode($comentarioagenda); ?></textarea></td>
												<td style="width:2%"></td>
												<td style="width:25%"> </td>
											</tr>
											<tr class="espacio" id="tinviableespacio"></tr>
											<tr id="tinviable">
												<td style="width:15%;font-size: 12px">MOTIVO INVIABLE:</td>
												<td colspan="3" style="width:50%"><textarea class="form-control input-sm" name="lblinviable" id="lblinviable" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo utf8_encode($motivoinviable); ?></textarea></td>
												<td style="width:2%"></td>
												<td style="width:25%"></td>
											</tr>
											<tr class="espacio" id="tcanceladoespacio"></tr>
											<tr id="tcancelado">
												<td style="width:15%;font-size: 12px">MOTIVO CANCELADO:</td>
												<td colspan="3" style="width:50%"><textarea class="form-control input-sm" name="lblcancelado" id="lblcancelado" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo $motivocancelado; ?></textarea></td>
												<td style="width:2%"></td>
												<td style="width:25%"></td>
											</tr>
										</table>
									</div>
									<!-- /.box-body -->
								</div>
								<!-- INFORMACION DE AUDITORIA -->
								<div class="box box-custom">
									<div class="box-header with-border" style="background-color:#2c3b41;color:white;">
										<h5>INFORMACION DE ATTEC</h5>
										<div class="box-tools pull-right">
											<button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
											</button>
										</div>
									</div>
									<!-- /.box-header -->
									<div class="box-body">
										<div class="form-horizontal" style="margin: 15px;">
											<div class="form-group" style="margin-bottom: 0px;">
												<div class="col-sm-6 col-md-6">
													<div class="form-group">
														<label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechaautidoria">FECHA AUDITORÍA:</label>
														<div class="col-sm-8 col-xs-8">
															<div class="input-group">
																<div class="input-group-addon input-sm">
																	<i class="fa fa-calendar"></i>
																</div>
																<input type="text" class="form-control pull-right input-sm" id="lblfechaautidoria" value="<?php echo $FechaAuditoria; ?>" name="lblfechaautidoria" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
															</div>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6">
													<div class="form-group">
														<label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblestadoattec">ESTADO ATTEC:</label>
														<div class="col-sm-8 col-xs-8">
															<select class="form-control input-sm" name="lblestadoattec" id="lblestadoattec" disabled>
																<option value="">Seleccione</option>
																<option value="Observada" <?php if ($EstadoAttec == "Observada") {
																	echo "selected";
																	} ?>>Observada</option>
																<option value="AuditadaOK" <?php if ($EstadoAttec == "AuditadaOK") {
																	echo "selected";
																	} ?> <?php if ($EstadoAttec == "Observada" || $EstadoAttec == "InstaladaSinAuditar") {
																	echo "hidden";
																	} ?> >AuditadaOK</option>
																<option value="AuditadaResuelta" <?php if ($EstadoAttec == "AuditadaResuelta") {
																	echo "selected";
																	} ?> <?php if ($EstadoAttec == "" || $EstadoAttec == "AuditadaOK" || $EstadoAttec == "InstaladaSinAuditar") {
																	echo "hidden";
																	} ?> >AuditadaResuelta</option>
																<option value="InstaladaSinAuditar" <?php if ($EstadoAttec == "InstaladaSinAuditar") {
																	echo "selected";
																	} ?><?php if ($EstadoAttec == "Observada") {
																	echo "hidden";
																	} ?>>InstaladaSinAuditar</option>
																<option value="NoInstalada" <?php if ($EstadoAttec == "NoInstalada") {
																	echo "selected";
																	} ?>>NoInstalada</option>
																<option value="Desmontaje" <?php if ($EstadoAttec == "Desmontaje") {
																	echo "selected";
																	} ?>>Desmontaje</option>
															</select>
														</div>
													</div>
												</div>
											</div>
											<div>
												<h5 class="subtitulo" style="font-size: 12px; color:red">INCIDENCIAS (*):</h5>
											</div>
											<input type="hidden" id="datosFalloSupervision" value='<?php echo $FalloSupervision_Dispotivos; ?>'>
											<input type="hidden" id="datosTamper" value='<?php echo $Tamper_Dispotivos; ?>'>
											<div class="form-group" style="margin-bottom: 0px;">
												<div class="col-sm-6 col-md-6">
													<div class="form-group">
														<label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="datossbn">DATOS SBN:</label>
														<div class="col-sm-8 col-xs-8">
															<div class="form-group" style="margin-bottom: 0px;">
																<div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
																	<input type="checkbox" name="datossbn" id="datossbn" data-size="small" data-style="ios" <?php if ($DatosSbn == "SI") {
																		echo 'checked';
																		} else {
																		echo '';
																		} ?> disabled/>
																	<input type="hidden" name="hidden_datossbn" id="hidden_datossbn" value="<?php if ($DatosSbn == "SI") {
																		echo 'SI';
																		} else {
																		echo 'NO';
																		} ?>">
																</div>
																<div class="col-lg-6 col-md-8 col-sm-8 col-xs-8 datossbn <?php if($DatosSbn == "SI") {echo '';} else {echo 'ocultar';} ?>">
																	<select class="form-control input-sm" name="lbldatossbncorreccion" id="lbldatossbncorreccion" disabled>
																		<option value="" disabled selected>NO COINCIDE</option>
																		<option value="Direccion" <?php if ($DatosSbn_NoCoincide == "Direccion") {
																			echo "selected";
																			} ?>>Direccion</option>
																		<option value="Distrito" <?php if ($DatosSbn_NoCoincide == "Distrito") {
																			echo "selected";
																			} ?>>Distrito</option>
																		<option value="Segmento" <?php if ($DatosSbn_NoCoincide == "Segmento") {
																			echo "selected";
																			} ?>>Segmento</option>
																	</select>
																</div>
															</div>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 <?php if($DatosSbn == "SI") {echo '';} else {echo 'ocultar';} ?>">
													<div class="form-group">
														<label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_datossbn">FECHA CORRECIÓN:</label>
														<div class="col-sm-8 col-xs-8">
															<div class="input-group">
																<div class="input-group-addon input-sm">
																	<i class="fa fa-calendar"></i>
																</div>
																<input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_datossbn" value="<?php echo $F_CorreccionDatosSbn; ?>" name="lblfechacorrecion_datossbn" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
															</div>
														</div>
													</div>
												</div>
											</div>
											<div class="form-group" style="margin-bottom: 0px;">
												<div class="col-sm-6 col-md-6">
													<div class="form-group">
														<label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="imagen">IMAGEN:</label>
														<div class="col-sm-8 col-xs-8">
															<div class="form-group" style="margin-bottom: 0px;">
																<div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
																	<input type="checkbox" name="imagen" id="imagen" data-size="small" data-style="ios" <?php if ($Imagen == "SI") {
																		echo 'checked';
																		} else {
																		echo '';
																		} ?> disabled/>
																	<input type="hidden" name="hidden_imagen" id="hidden_imagen" value="<?php if ($Imagen == "SI") {
																		echo 'SI';
																		} else {
																		echo 'NO';
																		} ?>">
																</div>
																<div class="col-lg-6 col-md-8 col-sm-8 col-xs-8 imagen ocultar">
																	<select class="form-control input-sm" name="lblimagen_motivo" id="lblimagen_motivo" disabled>
																		<option value="" disabled selected>MOTIVO</option>
																		<option value="Zona Abierta" <?php if ($Imagen_Motivo == "Zona Abierta") {
																			echo "selected";
																			} ?>>Zona Abierta</option>
																		<option value="Enfoque Calle" <?php if ($Imagen_Motivo == "Enfoque Calle") {
																			echo "selected";
																			} ?>>Enfoque Calle</option>
																		<option value="Sensor no fijado" <?php if ($Imagen_Motivo == "Sensor no fijado") {
																			echo "selected";
																			} ?>>Sensor no fijado</option>
																		<option value="Sensor Obstruido" <?php if ($Imagen_Motivo == "Sensor Obstruido") {
																			echo "selected";
																			} ?>>Sensor Obstruido</option>
																		<option value="Zona Inviable" <?php if ($Imagen_Motivo == "Zona Inviable") {
																			echo "selected";
																			} ?>>Zona Inviable</option>
																	</select>
																</div>
															</div>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 <?php if($Imagen == "SI") {echo '';} else {echo 'ocultar';} ?>">
													<div class="form-group">
														<label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_imagen">FECHA CORRECIÓN:</label>
														<div class="col-sm-8 col-xs-8">
															<div class="input-group">
																<div class="input-group-addon input-sm">
																	<i class="fa fa-calendar"></i>
																</div>
																<input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_imagen" value="<?php echo $F_Imagen; ?>" name="lblfechacorrecion_imagen" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
															</div>
														</div>
													</div>
												</div>
											</div>
											<div class="form-group" style="margin-bottom: 0px;">
												<div class="col-sm-6 col-md-6">
													<div class="form-group">
														<label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="segincorrecto">SEGMENTO INCORRECTO:</label>
														<div class="col-sm-8 col-xs-8">
															<div class="form-group" style="margin-bottom: 0px;">
																<div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
																	<input type="checkbox" name="segincorrecto" id="segincorrecto" data-size="small" data-style="ios" <?php if ($SegIncorrecto == "SI") {
																		echo 'checked';
																		} else {
																		echo '';
																		} ?> disabled/>
																	<input type="hidden" name="hidden_segincorrecto" id="hidden_segincorrecto" value="<?php if ($SegIncorrecto == "SI") {
																		echo 'SI';
																		} else {
																		echo 'NO';
																		} ?>">
																</div>
																<div class="col-lg-6 col-md-8 col-sm-8 col-xs-8 segcorrecion <?php if($SegIncorrecto == "SI") {echo '';} else {echo 'ocultar';} ?>">
																	<select class="form-control input-sm" name="lblsegmentocorreccion" id="lblsegmentocorreccion" disabled>
																		<option value="" disabled selected>DEBE DECIR</option>
																		<option value="RES" <?php if ($Seg_DebeDecir == "RES") {
																			echo "selected";
																			} ?>>RES</option>
																		<option value="NEG" <?php if ($Seg_DebeDecir == "NEG") {
																			echo "selected";
																			} ?>>NEG</option>
																	</select>
																</div>
															</div>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 <?php if($SegIncorrecto == "SI") {echo '';} else {echo 'ocultar';} ?>">
													<div class="form-group">
														<label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_segincorrecto">FECHA CORRECIÓN:</label>
														<div class="col-sm-8 col-xs-8">
															<div class="input-group">
																<div class="input-group-addon input-sm">
																	<i class="fa fa-calendar"></i>
																</div>
																<input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_segincorrecto" value="<?php echo $F_CorreccionSegIncorrecto; ?>" name="lblfechacorrecion_segincorrecto" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
															</div>
														</div>
													</div>
												</div>
											</div>
											<div class="form-group" style="margin-bottom: 0px;">
												<div class="col-sm-6 col-md-6">
													<div class="form-group">
														<label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="tamper">TAMPER (MANIPULACIÓN):</label>
														<div class="col-sm-8 col-xs-8">
															<input type="checkbox" name="tamper" id="tamper" data-size="small" data-style="ios" <?php if ($Tamper == "SI") {
																echo 'checked';
																} else {
																echo '';
																} ?> disabled/>
															<input type="hidden" name="hidden_tamper" id="hidden_tamper" value="<?php if ($Tamper == "SI") {
																echo 'SI';
																} else {
																echo 'NO';
																} ?>">
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 <?php if($Tamper == "SI") {echo '';} else {echo 'ocultar';} ?>">
													<div class="form-group">
														<label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_datossbn">FECHA CORRECIÓN:</label>
														<div class="col-sm-8 col-xs-8">
															<div class="input-group">
																<div class="input-group-addon input-sm">
																	<i class="fa fa-calendar"></i>
																</div>
																<input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_tamper" value="<?php echo $F_CorreccionTamper; ?>" name="lblfechacorrecion_tamper" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
															</div>
														</div>
													</div>
												</div>
											</div>
											<div class="form-group tamper <?php if ($Tamper == "SI") {echo '';} else { echo 'ocultar';} ?>" style="margin-bottom: 0px;">
												<div class="col-sm-2 col-md-2">
												</div>
												<div class="col-sm-6 col-md-6">
													<div class="box-body">
														<div class="row">
															<div id="listaTamper" class="col-md-12">
															</div>
														</div>
													</div>
												</div>
											</div>
											<div class="form-group" style="margin-bottom: 0px;">
												<div class="col-sm-6 col-md-6">
													<div class="form-group">
														<label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="ingresoprogramacion">INGRESO A PROGRAMACIÓN:</label>
														<div class="col-sm-8 col-xs-8">
															<input type="checkbox" name="ingresoprogramacion" id="ingresoprogramacion" data-size="small" data-style="ios" <?php if ($IngresoProgramacion == "SI") {
																echo 'checked';
																} else {
																echo '';
																} ?> disabled/>
															<input type="hidden" name="hidden_ingresoprogramacion" id="hidden_ingresoprogramacion" value="<?php if ($IngresoProgramacion == "SI") {
																echo 'SI';
																} else {
																echo 'NO';
																} ?>">
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 <?php if($IngresoProgramacion == "SI") {echo '';} else {echo 'ocultar';} ?>">
													<div class="form-group">
														<label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_ingresoprogramacion">FECHA CORRECIÓN:</label>
														<div class="col-sm-8 col-xs-8">
															<div class="input-group">
																<div class="input-group-addon input-sm">
																	<i class="fa fa-calendar"></i>
																</div>
																<input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_ingresoprogramacion" value="<?php echo $F_CorreccionIngresoProgramacion; ?>" name="lblfechacorrecion_ingresoprogramacion" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
															</div>
														</div>
													</div>
												</div>
											</div>
											<div class="form-group" style="margin-bottom: 0px;">
												<div class="col-sm-6 col-md-6">
													<div class="form-group">
														<label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="hidden_falloscomunicacion">FALLOS DE COMUNICACIÓN (COBERTURA):</label>
														<div class="col-sm-8 col-xs-8">
															<input type="checkbox" name="falloscomunicacion" id="falloscomunicacion" data-size="small" data-style="ios" <?php if ($FallosCobertura == "SI") {
																echo 'checked';
																} else {
																echo '';
																} ?> disabled/>
															<input type="hidden" name="hidden_falloscomunicacion" id="hidden_falloscomunicacion" value="<?php if ($FallosCobertura == "SI") {
																echo 'SI';
																} else {
																echo 'NO';
																} ?>">
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 <?php if($FallosCobertura == "SI") {echo '';} else {echo 'ocultar';} ?>">
													<div class="form-group">
														<label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_falloscomunicacion">FECHA CORRECIÓN:</label>
														<div class="col-sm-8 col-xs-8">
															<div class="input-group">
																<div class="input-group-addon input-sm">
																	<i class="fa fa-calendar"></i>
																</div>
																<input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_falloscomunicacion" value="<?php echo $F_CorreccionFallosCobertura; ?>" name="lblfechacorrecion_falloscomunicacion" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
															</div>
														</div>
													</div>
												</div>
											</div>
											<div class="form-group" style="margin-bottom: 0px;">
												<div class="col-sm-6 col-md-6">
													<div class="form-group">
														<label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="segincorrecto">ZERO VISION:</label>
														<div class="col-sm-8 col-xs-8">
															<div class="form-group" style="margin-bottom: 0px;">
																<div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
																	<input type="checkbox" name="zerovision" id="zerovision" data-size="small" data-style="ios" <?php if ($ZeroVision == "SI") {
																		echo 'checked';
																		} else {
																		echo '';
																		} ?> disabled />
																	<input type="hidden" name="hidden_zerovision" id="hidden_zerovision" value="<?php if ($ZeroVision == "SI") {
																		echo 'SI';
																		} else {
																		echo 'NO';
																		} ?>">
																</div>
																<div class="col-lg-6 col-md-8 col-sm-8 col-xs-8 zerovisioncorrecion <?php if($ZeroVision == "SI") {echo '';} else {echo 'ocultar';} ?>">
																	<select class="form-control input-sm" name="lblzerovisioncorreccion" id="lblzerovisioncorreccion" disabled>
																		<option value="" disabled selected>MOTIVO</option>
																		<option value="Panel Apagado" <?php if ($Zerovision_motivo == "Panel Apagado") {
																			echo "selected";
																			} ?>>Panel Apagado</option>
																		<option value="Mising Test" <?php if ($Zerovision_motivo == "Mising Test") {
																			echo "selected";
																			} ?>>Mising Test</option>
																	</select>
																</div>
															</div>
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 <?php if($ZeroVision == "SI") {echo '';} else {echo 'ocultar';} ?>">
													<div class="form-group">
														<label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_datossbn">FECHA CORRECIÓN:</label>
														<div class="col-sm-8 col-xs-8">
															<div class="input-group">
																<div class="input-group-addon input-sm">
																	<i class="fa fa-calendar"></i>
																</div>
																<input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_zerovision" value="<?php echo $F_CorreccionZeroVision; ?>" name="lblfechacorrecion_zerovision" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
															</div>
														</div>
													</div>
												</div>
											</div>
											<div class="form-group" style="margin-bottom: 0px;">
												<div class="col-sm-6 col-md-6">
													<div class="form-group">
														<label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblinstaladox">FALLO DE SUPERVISION:</label>
														<div class="col-sm-8 col-xs-8">
															<input type="checkbox" name="fallosupervision" id="fallosupervision" data-size="small" data-style="ios" <?php if ($FalloSupervision == "SI") {
																echo 'checked';
																} else {
																echo '';
																} ?> disabled/>
															<input type="hidden" name="hidden_fallosupervision" id="hidden_fallosupervision" value="<?php if ($FalloSupervision == "SI") {
																echo 'SI';
																} else {
																echo 'NO';
																} ?>">
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 <?php if($FalloSupervision == "SI") {echo '';} else {echo 'ocultar';} ?>">
													<div class="form-group">
														<label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_fallosupervision">FECHA CORRECIÓN:</label>
														<div class="col-sm-8 col-xs-8">
															<div class="input-group">
																<div class="input-group-addon input-sm">
																	<i class="fa fa-calendar"></i>
																</div>
																<input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_fallosupervision" value="<?php echo $F_CorreccionFalloSupervision; ?>" name="lblfechacorrecion_fallosupervision" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled/>
															</div>
														</div>
													</div>
												</div>
											</div>
											<div class="form-group fallosupervision <?php if ($FalloSupervision == "SI") { echo '';} else {echo 'ocultar';} ?>" style="margin-bottom: 0px;">
												<div class="col-sm-2 col-md-2">
												</div>
												<div class="col-sm-6 col-md-6">
													<div class="box-body">
														<div class="row">
															<div id="listaFalloSupervision" class="col-md-12">
															</div>
														</div>
													</div>
												</div>
											</div>
											<div class="form-group" style="margin-bottom: 0px;">
												<div class="col-sm-6 col-md-6">
													<div class="form-group">
														<label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblinstaladox">MISSING TEST:</label>
														<div class="col-sm-8 col-xs-8">
															<input type="checkbox" name="missingtest" id="missingtest" data-size="small" data-style="ios" <?php if ($MissingTest == "SI") {
																echo 'checked';
																} else {
																echo '';
																} ?> disabled/>
															<input type="hidden" name="hidden_missingtest" id="hidden_missingtest" value="<?php if ($MissingTest == "SI") {
																echo 'SI';
																} else {
																echo 'NO';
																} ?>">
														</div>
													</div>
												</div>
												<div class="col-sm-6 col-md-6 <?php if($MissingTest == "SI") {echo '';} else {echo 'ocultar';} ?>">
													<div class="form-group">
														<label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_missingtest">FECHA CORRECIÓN:</label>
														<div class="col-sm-8 col-xs-8">
															<div class="input-group">
																<div class="input-group-addon input-sm">
																	<i class="fa fa-calendar"></i>
																</div>
																<input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_missingtest" value="<?php echo $F_CorreccionMissingTest; ?>" name="lblfechacorrecion_missingtest" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
															</div>
														</div>
													</div>
												</div>
											</div>
											<div class="form-group" style="margin-bottom: 0px;">
												<div class="col-sm-12 col-md-12">
													<div class="form-group">
														<label class="col-md-2 col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblplantillacomentario"><span style="color:#2c3b41"> <i class="fa fa-fw fa-info"></i>COMENTARIO:</span></label>
														<div class="col-md-10 col-sm-8 col-xs-8">
															<textarea class="form-control input-sm" name="lblplantillacomentario" id="lblplantillacomentario" rows="4" style="resize:none" placeholder="Ingresar..." disabled><?php echo utf8_encode($ComentarioAttec); ?></textarea>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
									<!-- /.box-body -->
								</div>

                                 <!-- INFORMACION DE CERTIFICACION DE VENTA -->
                            <div class="box box-custom">
                                <input type="hidden" id="idcertventa" value="<?php if (isset($idcertventa)) {
                                                                                    echo $idcertventa;
                                                                                } else {
                                                                                } ?>">
                                <input type="hidden" id="lblpermiso" value="<?php echo $nombacceso; ?>">
                                <input type="hidden" id="FechaPendiente" value="<?php echo $FechaPendiente; ?>">
                                <input type="hidden" id="FechaPrimeraGestion" value="<?php echo $FechaPrimeraGestion; ?>">
                                <input type="hidden" id="FechaFinalizadoconIncidencia" value="<?php echo $FechaFinalizadoconIncidencia; ?>">
                                <input type="hidden" id="FechaResuelto" value="<?php echo $FechaResuelto; ?>">
                                

                                <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                    <h5>INFORMACION DE CERTIFICACIÓN VENTA</h5>

                                    <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                        </button>

                                    </div>
                                </div>
                                <!-- /.box-header -->
                                <div class="box-body">
                                    <div class="form-horizontal" style="padding: 20px;">

                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblasignado">GESTOR:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control selectgestor input-sm" name="lblasignado" id="lblasignado" style="width: 100%;" disabled="disabled">
													        <?php echo $htmlGestor;?>></php>
													        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lbltipocierre_cert">STATUS LLAMADA INICIAL:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                       <input type="text" class="form-control pull-right input-sm" id="lbltipocierre_cert" value="<?php echo $TipoCierre;?>"  name="lbltipocierre_cert" disabled="disabled">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechaapertura_cert">FECHA DE APERTURA:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input type="text" class="form-control pull-right input-sm" id="lblfechaapertura_cert" value="<?php echo $FechaApertura;?>"  name="lblfechaapertura_cert" disabled="disabled">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblsolucionincidencia_cert"><span class="motivocierretc">STATUS INCIDENCIA</span></label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input type="text" class="form-control pull-right input-sm" id="lblsolucionincidencia_cert" value="<?php echo $SolucionIncidencia;?>"  name="lblsolucionincidencia_cert" disabled="disabled">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacierre_cert">FECHA CIERRE:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input type="text" class="form-control pull-right input-sm" id="lblfechacierre_cert" value="<?php echo $FechaCierre;?>"  name="lblfechacierre_cert" disabled="disabled">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblformapago_cert">FORMA PAGO:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input type="text" class="form-control pull-right input-sm" id="lblformapago_cert" value="<?php echo $FormaPagoCert;?>"  name="lblformapago_cert" disabled="disabled">
                                                    </div>
                                                </div>
                                            </div>                                            
                                        </div>
                                        <div>
                                            <h5 class="subtitulo" style="font-size: 12px; color:red">MOTIVO INCIDENCIAS (*):</h5>
                                        </div>

                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="kitnoinstalado">KIT NO INSTALADO:</label>
                                                    <div class="col-sm-8 col-xs-8">

                                                        <div class="form-group" style="margin-bottom: 0px;">
                                                            <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                                                                <input type="checkbox" name="kitnoinstalado" id="kitnoinstalado" data-size="small" data-style="ios" <?php if ($kitnoinstalado == "SI") {
                                                                                                                                                            echo 'checked';
                                                                                                                                                        } else {
                                                                                                                                                            echo '';
                                                                                                                                                        } ?> disabled/>
                                                                <input type="hidden" name="hidden_kitnoinstalado" id="hidden_kitnoinstalado" value="<?php if ($kitnoinstalado == "SI") {
                                                                                                                                            echo 'SI';
                                                                                                                                        } else {
                                                                                                                                            echo 'NO';
                                                                                                                                        } ?>">
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6 <?php if($kitnoinstalado == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_kitnoinstalado">FECHA CORRECIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_kitnoinstalado" value="<?php echo $fechacorrecion_kitnoinstalado; ?>" name="lblfechacorrecion_kitnoinstalado" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="errorcomprobantepago">ERROR COMPROBANTE DE PAGO:</label>
                                                    <div class="col-sm-8 col-xs-8">

                                                        <div class="form-group" style="margin-bottom: 0px;">
                                                            <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                                                                <input type="checkbox" name="errorcomprobantepago" id="errorcomprobantepago" data-size="small" data-style="ios" <?php if ($errorcomprobantepago == "SI") {
                                                                                                                                                            echo 'checked';
                                                                                                                                                        } else {
                                                                                                                                                            echo '';
                                                                                                                                                        } ?> disabled/>
                                                                <input type="hidden" name="hidden_errorcomprobantepago" id="hidden_errorcomprobantepago" value="<?php if ($errorcomprobantepago == "SI") {
                                                                                                                                            echo 'SI';
                                                                                                                                        } else {
                                                                                                                                            echo 'NO';
                                                                                                                                        } ?>">
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6 <?php if($errorcomprobantepago == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_errorcomprobantepago">FECHA CORRECIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_errorcomprobantepago" value="<?php echo $fechacorrecion_errorcomprobantepago; ?>" name="lblfechacorrecion_errorcomprobantepago" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>                                       
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="errorsegmento">ERROR SEGMENTO:</label>
                                                    <div class="col-sm-8 col-xs-8">

                                                        <div class="form-group" style="margin-bottom: 0px;">
                                                            <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                                                                <input type="checkbox" name="errorsegmento" id="errorsegmento" data-size="small" data-style="ios" <?php if ($errorsegmento == "SI") {
                                                                                                                                                            echo 'checked';
                                                                                                                                                        } else {
                                                                                                                                                            echo '';
                                                                                                                                                        } ?> disabled/>
                                                                <input type="hidden" name="hidden_errorsegmento" id="hidden_errorsegmento" value="<?php if ($errorsegmento == "SI") {
                                                                                                                                            echo 'SI';
                                                                                                                                        } else {
                                                                                                                                            echo 'NO';
                                                                                                                                        } ?>">
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6 <?php if($errorsegmento == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_errorsegmento">FECHA CORRECIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_errorsegmento" value="<?php echo $fechacorrecion_errorsegmento; ?>" name="lblfechacorrecion_errorsegmento" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="fueranomalcomercial">FUERA NORMAL COMERCIAL:</label>
                                                    <div class="col-sm-8 col-xs-8">

                                                        <div class="form-group" style="margin-bottom: 0px;">
                                                            <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                                                                <input type="checkbox" name="fueranomalcomercial" id="fueranomalcomercial" data-size="small" data-style="ios" <?php if ($fueranomalcomercial == "SI") {
                                                                                                                                                            echo 'checked';
                                                                                                                                                        } else {
                                                                                                                                                            echo '';
                                                                                                                                                        } ?> disabled/>
                                                                <input type="hidden" name="hidden_fueranomalcomercial" id="hidden_fueranomalcomercial" value="<?php if ($fueranomalcomercial == "SI") {
                                                                                                                                            echo 'SI';
                                                                                                                                        } else {
                                                                                                                                            echo 'NO';
                                                                                                                                        } ?>">
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6 <?php if($fueranomalcomercial == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_fueranomalcomercial">FECHA CORRECIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_fueranomalcomercial" value="<?php echo $fechacorrecion_fueranomalcomercial; ?>" name="lblfechacorrecion_fueranomalcomercial" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>                                        
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="fueranormativatecnica">FUERA NORMATIVA TÉCNICA:</label>
                                                    <div class="col-sm-8 col-xs-8">

                                                        <div class="form-group" style="margin-bottom: 0px;">
                                                            <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                                                                <input type="checkbox" name="fueranormativatecnica" id="fueranormativatecnica" data-size="small" data-style="ios" <?php if ($fueranormativatecnica == "SI") {
                                                                                                                                                            echo 'checked';
                                                                                                                                                        } else {
                                                                                                                                                            echo '';
                                                                                                                                                        } ?> disabled/>
                                                                <input type="hidden" name="hidden_fueranormativatecnica" id="hidden_fueranormativatecnica" value="<?php if ($fueranormativatecnica == "SI") {
                                                                                                                                            echo 'SI';
                                                                                                                                        } else {
                                                                                                                                            echo 'NO';
                                                                                                                                        } ?>">
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6 <?php if($fueranormativatecnica == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_fueranormativatecnica">FECHA CORRECIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_fueranormativatecnica" value="<?php echo $fechacorrecion_fueranormativatecnica; ?>" name="lblfechacorrecion_fueranormativatecnica" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="incidenciadatos">INCIDENCIA DATOS:</label>
                                                    <div class="col-sm-8 col-xs-8">

                                                        <div class="form-group" style="margin-bottom: 0px;">
                                                            <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                                                                <input type="checkbox" name="incidenciadatos" id="incidenciadatos" data-size="small" data-style="ios" <?php if ($incidenciadatos == "SI") {
                                                                                                                                                            echo 'checked';
                                                                                                                                                        } else {
                                                                                                                                                            echo '';
                                                                                                                                                        } ?> disabled/>
                                                                <input type="hidden" name="hidden_incidenciadatos" id="hidden_incidenciadatos" value="<?php if ($incidenciadatos == "SI") {
                                                                                                                                            echo 'SI';
                                                                                                                                        } else {
                                                                                                                                            echo 'NO';
                                                                                                                                        } ?>">
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6 <?php if($incidenciadatos == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_incidenciadatos">FECHA CORRECIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_incidenciadatos" value="<?php echo $fechacorrecion_incidenciadatos; ?>" name="lblfechacorrecion_incidenciadatos" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="inconformidadfuncionamiento">INCONFORMIDAD FUNCIONAMIENTO:</label>
                                                    <div class="col-sm-8 col-xs-8">

                                                        <div class="form-group" style="margin-bottom: 0px;">
                                                            <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                                                                <input type="checkbox" name="inconformidadfuncionamiento" id="inconformidadfuncionamiento" data-size="small" data-style="ios" <?php if ($inconformidadfuncionamiento == "SI") {
                                                                                                                                                            echo 'checked';
                                                                                                                                                        } else {
                                                                                                                                                            echo '';
                                                                                                                                                        } ?> disabled/>
                                                                <input type="hidden" name="hidden_inconformidadfuncionamiento" id="hidden_inconformidadfuncionamiento" value="<?php if ($inconformidadfuncionamiento == "SI") {
                                                                                                                                            echo 'SI';
                                                                                                                                        } else {
                                                                                                                                            echo 'NO';
                                                                                                                                        } ?>">
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6 <?php if($inconformidadfuncionamiento == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_inconformidadfuncionamiento">FECHA CORRECIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_inconformidadfuncionamiento" value="<?php echo $fechacorrecion_inconformidadfuncionamiento; ?>" name="lblfechacorrecion_inconformidadfuncionamiento" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="inconformidadpagoinicial">INCONFORMIDAD PAGO INICIAL:</label>
                                                    <div class="col-sm-8 col-xs-8">

                                                        <div class="form-group" style="margin-bottom: 0px;">
                                                            <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                                                                <input type="checkbox" name="inconformidadpagoinicial" id="inconformidadpagoinicial" data-size="small" data-style="ios" <?php if ($inconformidadpagoinicial == "SI") {
                                                                                                                                                            echo 'checked';
                                                                                                                                                        } else {
                                                                                                                                                            echo '';
                                                                                                                                                        } ?> disabled/>
                                                                <input type="hidden" name="hidden_inconformidadpagoinicial" id="hidden_inconformidadpagoinicial" value="<?php if ($inconformidadpagoinicial == "SI") {
                                                                                                                                            echo 'SI';
                                                                                                                                        } else {
                                                                                                                                            echo 'NO';
                                                                                                                                        } ?>">
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6 <?php if($inconformidadpagoinicial == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_inconformidadpagoinicial">FECHA CORRECIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_inconformidadpagoinicial" value="<?php echo $fechacorrecion_inconformidadpagoinicial; ?>" name="lblfechacorrecion_inconformidadpagoinicial" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="inconformidadpagomensual">INCONFORMIDAD PAGO MENSUAL:</label>
                                                    <div class="col-sm-8 col-xs-8">

                                                        <div class="form-group" style="margin-bottom: 0px;">
                                                            <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                                                                <input type="checkbox" name="inconformidadpagomensual" id="inconformidadpagomensual" data-size="small" data-style="ios" <?php if ($inconformidadpagomensual == "SI") {
                                                                                                                                                            echo 'checked';
                                                                                                                                                        } else {
                                                                                                                                                            echo '';
                                                                                                                                                        } ?> disabled/>
                                                                <input type="hidden" name="hidden_inconformidadpagomensual" id="hidden_inconformidadpagomensual" value="<?php if ($inconformidadpagomensual == "SI") {
                                                                                                                                            echo 'SI';
                                                                                                                                        } else {
                                                                                                                                            echo 'NO';
                                                                                                                                        } ?>">
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6 <?php if($inconformidadpagomensual == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_inconformidadpagomensual">FECHA CORRECIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_inconformidadpagomensual" value="<?php echo $fechacorrecion_inconformidadpagomensual; ?>" name="lblfechacorrecion_inconformidadpagomensual" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div> 
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="inconformidadtiempopermanencia">INCONFORMIDAD TIEMPO PERMANENCIA:</label>
                                                    <div class="col-sm-8 col-xs-8">

                                                        <div class="form-group" style="margin-bottom: 0px;">
                                                            <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                                                                <input type="checkbox" name="inconformidadtiempopermanencia" id="inconformidadtiempopermanencia" data-size="small" data-style="ios" <?php if ($inconformidadtiempopermanencia == "SI") {
                                                                                                                                                            echo 'checked';
                                                                                                                                                        } else {
                                                                                                                                                            echo '';
                                                                                                                                                        } ?> disabled/>
                                                                <input type="hidden" name="hidden_inconformidadtiempopermanencia" id="hidden_inconformidadtiempopermanencia" value="<?php if ($inconformidadtiempopermanencia == "SI") {
                                                                                                                                            echo 'SI';
                                                                                                                                        } else {
                                                                                                                                            echo 'NO';
                                                                                                                                        } ?>">
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6 <?php if($inconformidadtiempopermanencia == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_inconformidadtiempopermanencia">FECHA CORRECIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_inconformidadtiempopermanencia" value="<?php echo $fechacorrecion_inconformidadtiempopermanencia; ?>" name="lblfechacorrecion_inconformidadtiempopermanencia" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="inconformidadubicaciondispositivos">INCONFORMIDAD UBICACIÓN DISPOSITIVOS:</label>
                                                    <div class="col-sm-8 col-xs-8">

                                                        <div class="form-group" style="margin-bottom: 0px;">
                                                            <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                                                                <input type="checkbox" name="inconformidadubicaciondispositivos" id="inconformidadubicaciondispositivos" data-size="small" data-style="ios" <?php if ($inconformidadubicaciondispositivos == "SI") {
                                                                                                                                                            echo 'checked';
                                                                                                                                                        } else {
                                                                                                                                                            echo '';
                                                                                                                                                        } ?> disabled/>
                                                                <input type="hidden" name="hidden_inconformidadubicaciondispositivos" id="hidden_inconformidadubicaciondispositivos" value="<?php if ($inconformidadubicaciondispositivos == "SI") {
                                                                                                                                            echo 'SI';
                                                                                                                                        } else {
                                                                                                                                            echo 'NO';
                                                                                                                                        } ?>">
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6 <?php if($inconformidadubicaciondispositivos == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_inconformidadubicaciondispositivos">FECHA CORRECIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_inconformidadubicaciondispositivos" value="<?php echo $fechacorrecion_inconformidadubicaciondispositivos; ?>" name="lblfechacorrecion_inconformidadubicaciondispositivos" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="noconcefuncionamiento">NO CONOCE FUNCIONAMIENTO:</label>
                                                    <div class="col-sm-8 col-xs-8">

                                                        <div class="form-group" style="margin-bottom: 0px;">
                                                            <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                                                                <input type="checkbox" name="noconcefuncionamiento" id="noconcefuncionamiento" data-size="small" data-style="ios" <?php if ($noconcefuncionamiento == "SI") {
                                                                                                                                                            echo 'checked';
                                                                                                                                                        } else {
                                                                                                                                                            echo '';
                                                                                                                                                        } ?> disabled/>
                                                                <input type="hidden" name="hidden_noconcefuncionamiento" id="hidden_noconcefuncionamiento" value="<?php if ($noconcefuncionamiento == "SI") {
                                                                                                                                            echo 'SI';
                                                                                                                                        } else {
                                                                                                                                            echo 'NO';
                                                                                                                                        } ?>">
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6 <?php if($noconcefuncionamiento == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_noconcefuncionamiento">FECHA CORRECIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_noconcefuncionamiento" value="<?php echo $fechacorrecion_noconcefuncionamiento; ?>" name="lblfechacorrecion_noconcefuncionamiento" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="notienecontrato">NO TIENE CONTRATO:</label>
                                                    <div class="col-sm-8 col-xs-8">

                                                        <div class="form-group" style="margin-bottom: 0px;">
                                                            <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                                                                <input type="checkbox" name="notienecontrato" id="notienecontrato" data-size="small" data-style="ios" <?php if ($notienecontrato == "SI") {
                                                                                                                                                            echo 'checked';
                                                                                                                                                        } else {
                                                                                                                                                            echo '';
                                                                                                                                                        } ?> disabled/>
                                                                <input type="hidden" name="hidden_notienecontrato" id="hidden_notienecontrato" value="<?php if ($notienecontrato == "SI") {
                                                                                                                                            echo 'SI';
                                                                                                                                        } else {
                                                                                                                                            echo 'NO';
                                                                                                                                        } ?>">
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6 <?php if($notienecontrato == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_notienecontrato">FECHA CORRECIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_notienecontrato" value="<?php echo $fechacorrecion_notienecontrato; ?>" name="lblfechacorrecion_notienecontrato" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>                                        
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="promesaspendientes">PROMESAS PENDIENTES:</label>
                                                    <div class="col-sm-8 col-xs-8">

                                                        <div class="form-group" style="margin-bottom: 0px;">
                                                            <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                                                                <input type="checkbox" name="promesaspendientes" id="promesaspendientes" data-size="small" data-style="ios" <?php if ($promesaspendientes == "SI") {
                                                                                                                                                            echo 'checked';
                                                                                                                                                        } else {
                                                                                                                                                            echo '';
                                                                                                                                                        } ?> disabled/>
                                                                <input type="hidden" name="hidden_promesaspendientes" id="hidden_promesaspendientes" value="<?php if ($promesaspendientes == "SI") {
                                                                                                                                            echo 'SI';
                                                                                                                                        } else {
                                                                                                                                            echo 'NO';
                                                                                                                                        } ?>">
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6 <?php if($promesaspendientes == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_promesaspendientes">FECHA CORRECIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_promesaspendientes" value="<?php echo $fechacorrecion_promesaspendientes; ?>" name="lblfechacorrecion_promesaspendientes" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="reclamocomercial">RECLAMO COMERCIAL:</label>
                                                    <div class="col-sm-8 col-xs-8">

                                                        <div class="form-group" style="margin-bottom: 0px;">
                                                            <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                                                                <input type="checkbox" name="reclamocomercial" id="reclamocomercial" data-size="small" data-style="ios" <?php if ($reclamocomercial == "SI") {
                                                                                                                                                            echo 'checked';
                                                                                                                                                        } else {
                                                                                                                                                            echo '';
                                                                                                                                                        } ?> disabled/>
                                                                <input type="hidden" name="hidden_reclamocomercial" id="hidden_reclamocomercial" value="<?php if ($reclamocomercial == "SI") {
                                                                                                                                            echo 'SI';
                                                                                                                                        } else {
                                                                                                                                            echo 'NO';
                                                                                                                                        } ?>">
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6 <?php if($reclamocomercial == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_reclamocomercial">FECHA CORRECIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_reclamocomercial" value="<?php echo $fechacorrecion_reclamocomercial; ?>" name="lblfechacorrecion_reclamocomercial" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="solicitabaja">SOLICITA BAJA:</label>
                                                    <div class="col-sm-8 col-xs-8">

                                                        <div class="form-group" style="margin-bottom: 0px;">
                                                            <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                                                                <input type="checkbox" name="solicitabaja" id="solicitabaja" data-size="small" data-style="ios" <?php if ($solicitabaja == "SI") {
                                                                                                                                                            echo 'checked';
                                                                                                                                                        } else {
                                                                                                                                                            echo '';
                                                                                                                                                        } ?> disabled/>
                                                                <input type="hidden" name="hidden_solicitabaja" id="hidden_solicitabaja" value="<?php if ($solicitabaja == "SI") {
                                                                                                                                            echo 'SI';
                                                                                                                                        } else {
                                                                                                                                            echo 'NO';
                                                                                                                                        } ?>">
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6 <?php if($solicitabaja == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_solicitabaja">FECHA CORRECIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_solicitabaja" value="<?php echo $fechacorrecion_solicitabaja; ?>" name="lblfechacorrecion_solicitabaja" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>                                        
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="tarjetaafiliadanopertenecetitular">TARJETA AFILIADA NO PERTENECE A TITULAR:</label>
                                                    <div class="col-sm-8 col-xs-8">

                                                        <div class="form-group" style="margin-bottom: 0px;">
                                                            <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                                                                <input type="checkbox" name="tarjetaafiliadanopertenecetitular" id="tarjetaafiliadanopertenecetitular" data-size="small" data-style="ios" <?php if ($tarjetaafiliadanopertenecetitular == "SI") {
                                                                                                                                                            echo 'checked';
                                                                                                                                                        } else {
                                                                                                                                                            echo '';
                                                                                                                                                        } ?> disabled/>
                                                                <input type="hidden" name="hidden_tarjetaafiliadanopertenecetitular" id="hidden_tarjetaafiliadanopertenecetitular" value="<?php if ($tarjetaafiliadanopertenecetitular == "SI") {
                                                                                                                                            echo 'SI';
                                                                                                                                        } else {
                                                                                                                                            echo 'NO';
                                                                                                                                        } ?>">
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6 <?php if($tarjetaafiliadanopertenecetitular == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_tarjetaafiliadanopertenecetitular">FECHA CORRECIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_tarjetaafiliadanopertenecetitular" value="<?php echo $fechacorrecion_tarjetaafiliadanopertenecetitular; ?>" name="lblfechacorrecion_tarjetaafiliadanopertenecetitular" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="recepmanual">RECEP MANUAL:</label>
                                                    <div class="col-sm-8 col-xs-8">

                                                        <div class="form-group" style="margin-bottom: 0px;">
                                                            <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                                                                <input type="checkbox" name="recepmanual" id="recepmanual" data-size="small" data-style="ios" <?php if ($recepmanual == "SI") {
                                                                                                                                                            echo 'checked';
                                                                                                                                                        } else {
                                                                                                                                                            echo '';
                                                                                                                                                        } ?> disabled/>
                                                                <input type="hidden" name="hidden_recepmanual" id="hidden_recepmanual" value="<?php if ($recepmanual == "SI") {
                                                                                                                                            echo 'SI';
                                                                                                                                        } else {
                                                                                                                                            echo 'NO';
                                                                                                                                        } ?>">
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6 <?php if($fechacorrecion_recepmanual == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_recepmanual">FECHA CORRECIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_recepmanual" value="<?php echo $fechacorrecion_recepmanual; ?>" name="lblfechacorrecion_recepmanual" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="descargaapp">DESCARGA APP:</label>
                                                    <div class="col-sm-8 col-xs-8">

                                                        <div class="form-group" style="margin-bottom: 0px;">
                                                            <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                                                                <input type="checkbox" name="descargaapp" id="descargaapp" data-size="small" data-style="ios" <?php if ($descargaapp == "SI") {
                                                                                                                                                            echo 'checked';
                                                                                                                                                        } else {
                                                                                                                                                            echo '';
                                                                                                                                                        } ?> disabled/>
                                                                <input type="hidden" name="hidden_descargaapp" id="hidden_descargaapp" value="<?php if ($descargaapp == "SI") {
                                                                                                                                            echo 'SI';
                                                                                                                                        } else {
                                                                                                                                            echo 'NO';
                                                                                                                                        } ?>">
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6 <?php if($descargaapp == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_descargaapp">FECHA CORRECIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_descargaapp" value="<?php echo $fechacorrecion_descargaapp; ?>" name="lblfechacorrecion_descargaapp" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="capacitado">CAPACITADO:</label>
                                                    <div class="col-sm-8 col-xs-8">

                                                        <div class="form-group" style="margin-bottom: 0px;">
                                                            <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                                                                <input type="checkbox" name="capacitado" id="capacitado" data-size="small" data-style="ios" <?php if ($capacitado == "SI") {
                                                                                                                                                            echo 'checked';
                                                                                                                                                        } else {
                                                                                                                                                            echo '';
                                                                                                                                                        } ?> disabled/>
                                                                <input type="hidden" name="hidden_capacitado" id="hidden_capacitado" value="<?php if ($capacitado == "SI") {
                                                                                                                                            echo 'SI';
                                                                                                                                        } else {
                                                                                                                                            echo 'NO';
                                                                                                                                        } ?>">
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6 <?php if($capacitado == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_capacitado">FECHA CORRECIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_capacitado" value="<?php echo $fechacorrecion_capacitado; ?>" name="lblfechacorrecion_capacitado" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblnumerollamadas">NRO LLAMADAS:</label>
                                                    <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                                                        <input type="text" class="form-control pull-right input-sm" id="lblnumerollamadas" name="lblnumerollamadas" value="<?php echo $numerollamadas; ?>" disabled>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>                                        
                                        
                                                                        
                                        
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-8">
                                                <div class="form-group">
                                                    <label class="col-md-3 col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcomentario_cert"><span style="color:#2c3b41">COMENTARIO:</span></label>
                                                    <div class="col-md-9 col-sm-8 col-xs-8">
                                                        <textarea class="form-control input-sm" name="lblcomentario_cert" id="lblcomentario_cert" rows="2" style="resize:none"  placeholder="Ingresar..." disabled><?php echo $ComentarioCert;?></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-4">
                                                <div class="form-group">
                                                    <div class="col-md-4 col-sm-8 col-xs-8">
                                                        <a class="btn btn-danger btn-sm"  href="#" data-toggle="modal" id="logcambios_cert" data-target="#modal-default-cert"><i class="fa fa-pencil-square-o"></i> Log Cambios</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group <?php if (($TipoCierre=='Finalizada con Incidencia' && $SolucionIncidencia=='No resuelto') || ($TipoCierre=='Finalizada con Incidencia' && $SolucionIncidencia=='Reincidencia') || $TipoCierre=='Ilocalizado' || $TipoCierre=='No colabora' || $TipoCierre=='No contesta') {echo '';} else {echo 'ocultar';} ?>" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-8">
                                                <div class="form-group">

                                                    <label class="col-md-3 col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcomentario_comercial">RESPUESTA COMERCIAL:</span></label>
                                                    <div class="col-md-9 col-sm-8 col-xs-8">
                                                        <textarea class="form-control input-sm" name="lblcomentario_comercial" id="lblcomentario_comercial" rows="3" style="resize:none" placeholder="Ingresar..."><?php echo $ComentarioComercial; ?></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-4">
                                                <div class="form-group">
                                                    <div class="col-md-4 col-sm-8 col-xs-8">
                                                        
                                                    </div>
                                                </div>
                                            </div>
                                            
                                        </div>                                        

                                        <div class="form-group <?php if (($TipoCierre=='Finalizada con Incidencia' && $SolucionIncidencia=='No resuelto') || ($TipoCierre=='Finalizada con Incidencia' && $SolucionIncidencia=='Reincidencia') || $TipoCierre=='Ilocalizado' || $TipoCierre=='No colabora' || $TipoCierre=='No contesta') {echo '';} else {echo 'ocultar';} ?>" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-8">
                                                <div class="form-group">
                                                
                                                
                                                    <label class="col-md-3 col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcomentario_comercial"><span style="color:#2c3b41">NUEVO HORARIO SUGERIDO LLAMADA CERTIFICACIÓN:</span></label>
                                                    <div class="col-md-9 col-sm-8 col-xs-8">
                                                        <select class="form-control input-sm" name="lblhorariosugerido2" id="lblhorariosugerido2">
                                                            <option>Seleccione</option>
                                                            <option value="9:00 am - 12 pm" <?php if ($nuevohorarioSugerido=='9:00 am - 12 pm') {echo "selected";} ?>>9:00 am - 12 pm</option>
                                                            <option value="12:00 pm - 3:00 pm" <?php if ($nuevohorarioSugerido=='12:00 pm - 3:00 pm') {echo "selected";} ?>>12:00 pm - 3:00 pm</option>
                                                            <option value="3:00 pm - 6:00 pm" <?php if ($nuevohorarioSugerido=='3:00 pm - 6:00 pm') {echo "selected";} ?>>3:00 pm - 6:00 pm</option>
                                                        </select>                                 
                                                    </div>
                                                </div>
                                            </div>
                                            
                                        </div> 
                                        
                                        
                                    </div>

                                </div>
                                <!-- /.box-body -->
                            </div>
 
 								
								
								
								<div class="box box-custom">
									<div class="box-header with-border" style="background-color:#2c3b41;color:white;">
										<h5>INFORMACION DE FACTURACIÓN</h5>
										<div class="box-tools pull-right">
											<button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
											</button>
										</div>
									</div>
									<!-- /.box-header -->
									<div class="box-body">
										<table cellspacing="0" style="width:100%;border-collapse: separate;padding: 20px;">
											<?php
												if($estadoventa=='InstaladaDEL' || $estadoventa=='IncidenciaAuditoria' || $estadoventa=='Instalada' || $estadoventa=='IncidenciaGestCorreo' || $estadoventa=='IncidenciaGestValija' || $estadoventa=='Facturada' || $estadoventa=='PorFacturar' || $estadoventa=='DocEnvi'  || $estadoventa=='Incidencia' || $estadoventa=='NoDoc'){
												?>
											<tr>
												<td style="width:15%;font-size: 12px"></td>
												<td style="width:25%">
													<a class="btn btn-nuevo btn-social btn-sm"  data-toggle="modal" id="btnenviarcorreoafiliar" data-target="#modal-enviarcorreoafiliar"> <i class="fa fa-envelope-o"></i> Enviar Afiliacion </a>
												</td>
												<td style="width:10%"></td>
												<td colspan="3" style="width:42%">
													<label class="label label-danger" style="font-size:12px">ESTADO DE AFILIACION</label>
													<label class="label label-default" style="font-size:12px"><?php if($estadoafiliacion=="NOREGISTRADO"){ echo "RECHAZADO:".$ACTION_DESCRIPTION;}else if($estadoafiliacion=='REGISTRADO'){echo 'AFILIADO';}else if($estadoafiliacionmdp=='ENPROCESO'){echo 'ENPROCESO';}else if($estadoafiliacionmdp=='AFILIADO'){echo 'AFILIADO';}else if($estadoafiliacionmdp=='RECHAZADO'){echo "RECHAZADO:".$motivomdp;}else{echo 'PENDIENTE';}?></label>
													<?php if(isset($card) && !empty($card)){?>
													<label class="label label-default" style="font-size:12px"><?php echo $tipocuenta.' '.$card;?></label>
													<?php }
														?>
												</td>
											</tr>
											<tr class="espacio"></tr>
											<?php }?>                                        
											<tr>
												<td style="width:15%;font-size: 12px">MOTIVO INCIDENCIA:</td>
												<td colspan="7" style="width:77%"><textarea class="form-control input-sm" name="lblmotivoincidencia" id="lblmotivoincidencia" rows="1" style="resize:none" placeholder="Ingresar..." disabled="disabled"><?php echo $factmotivoincidencia; ?></textarea></td>
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:15%;font-size: 12px">FECHA RECEPCION DOC.:</td>
												<td style="width:25%">
													<div class="input-group">
														<div class="input-group-addon input-sm">
															<i class="fa fa-calendar"></i>
														</div>
														<input type="text" class="form-control pull-right input-sm" id="lblfecharecpciondoc" name="lblfecharecpciondoc" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask value="<?php echo $factfecharecepciondoc; ?>" disabled="disabled">
													</div>
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px">FECHA DE FACTURACIÓN: <span style="font-size: 12px; color:red ">(*)</span></td>
												<td style="width:2%"></td>
												<td style="width:25%">
													<div class="input-group">
														<div class="input-group-addon input-sm">
															<i class="fa fa-calendar"></i>
														</div>
														<input type="text" class="form-control pull-right input-sm" id="lblfechafacturacion" name="lblfechafacturacion" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask value="<?php echo $factfechafacturacion; ?>" disabled="disabled" />
													</div>
												</td>
											</tr>
										</table>
										<table cellspacing="0" style="width:100%;border-collapse: separate;padding: 20px">
											<tr>
												<td style="font-size: 12px; color:red ">MOTIVOS DE INCIDENCIA (*):</td>
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:8%;font-size: 12px">DOC. ORIGINAL:</td>
												<td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactdocoriginal" id="lblfactdocoriginal" value="<?php echo $factdocoriginal; ?>" disabled="disabled" /></td>
												<td style="width:8%"></td>
												<td style="width:8%;font-size: 12px">FALTA DNI:</td>
												<td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactdni" id="lblfactdni" value="<?php echo $factdni; ?>" disabled="disabled" /></td>
												<td style="width:8%"></td>
												<td style="width:8%;font-size: 12px">REHACER CTO:</td>
												<td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactrehacercto" id="lblfactrehacercto" value="<?php echo $factrehacercto; ?>" disabled="disabled" /></td>
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:8%;font-size: 12px">SEGMENTACIÓN:</td>
												<td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactsegmentacion" id="lblfactsegmentacion" value="<?php echo $factsegmentacion; ?>" disabled="disabled" /></td>
												<td style="width:8%"></td>
												<td style="width:8%;font-size: 12px">ELEMENTOS CTO PS:</td>
												<td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactelementosctops" id="lblfactelementosctops" value="<?php echo $factelementosctops; ?>" disabled="disabled" /></td>
												<td style="width:8%"></td>
												<td style="width:8%;font-size: 12px">AFILIACION:</td>
												<td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactafiliacion" id="lblfactafiliacion" value="<?php echo $factafiliacion; ?>" disabled="disabled" /></td>
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:8%;font-size: 12px">PAGO:</td>
												<td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactpago" id="lblfactpago" value="<?php echo $factpago; ?>" disabled="disabled" /></td>
												<td style="width:8%"></td>
												<td style="width:8%;font-size: 12px">DOC PAI:</td>
												<td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactdocpai" id="lblfactdocpai" value="<?php echo $factdocpai; ?>" disabled="disabled" /></td>
												<td style="width:8%"></td>
												<td style="width:8%;font-size: 12px">PROSPECTO/NRO GUIA:</td>
												<td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactprospecto_nroguia" id="lblfactprospecto_nroguia" value="<?php echo $factprospecto_nroguia; ?>" disabled="disabled" /></td>
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:8%;font-size: 12px">AUTORIZA:</td>
												<td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactautoriza" id="lblfactautoriza" value="<?php echo $factautoriza; ?>" disabled="disabled" /></td>
												<td style="width:8%"></td>
												<td style="width:8%;font-size: 12px">FALTA DOC (P.A./CTO):</td>
												<td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactfaltadoc" id="lblfactfaltadoc" value="<?php echo $factfaltadoc; ?>" disabled="disabled" /></td>
												<td style="width:8%"></td>
												<td style="width:8%;font-size: 12px">FUERA DE HORA:</td>
												<td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactfuerahora" id="lblfactfuerahora" value="<?php echo $factfuerahora; ?>" disabled="disabled" /></td>
											</tr>
										</table>
									</div>
									<!-- /.box-body -->
								</div>
							</form>
						</div>
						<div class="col-md-2"></div>
					</div>
					<div class="modal fade" id="modal-default">
						<div class="modal-dialog modal-lg">
							<div class="modal-content">
								<div class="modal-header modal-header-danger">
									<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
									<h4>GESTIONES DE AGENDAMIENTO</h4>
								</div>
								<div class="modal-body" id="vistaboy">
									<div id="myGrid" style="height: 100%" class="ag-theme-fresh"></div>
									<div id="ningunresultado"></div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
								</div>
							</div>
							<!-- /.modal-content -->
						</div>
						<!-- /.modal-dialog -->
					</div>
					<!-- /.modal -->

                    
                    <div class="modal fade" id="modal-default-cert">
                    	<div class="modal-dialog modal-lg">
                    		<div class="modal-content">
                    			<div class="modal-header modal-header-danger">
                    				<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    				<h4>GESTIONES DE CERTIFICACION DE LA VENTA</h4>
                    			</div>
                    			<div class="modal-body" id="vistaboy_cert">
                    				<div id="myGrid_cert"  style="height: 100%" class="ag-theme-fresh"></div>
                    				<div  id="ningunresultado_cert"></div>
                    			</div>
                    			<div class="modal-footer">
                    				<button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                    			</div>
                    		</div>
                    	</div>
                    	<!-- /.modal-content -->
                    </div>
                    <!-- /.modal-dialog -->
                    </div>
                    <!-- /.modal -->  					
					<div class="modal fade" id="modal-consultascoring">
						<div class="modal-dialog modal-lg">
							<div class="modal-content">
								<div class="modal-header modal-header-danger">
									<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
									<h4>CONSULTAR SCORING</h4>
								</div>
								<div class="modal-body">
									<div class="row">
										<div class="col-md-6">
											<div id="frmEditarVentaScoring" method="post">
												<div class="box box-danger">
													<div class="box-header with-border">
														<h5>SCORING</h5>
														<div class="box-tools pull-right">
															<button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
															</button>
														</div>
													</div>
													<div class="box-body">
														<div class="form-horizontal" style="padding: 10px 20px 0">
															<div class="form-group">
																<label style="text-align: left;">TIPO DOCUMENTO:</label>
																<input type="hidden" id="matriculausuario" value="<?php echo $matriculausuario; ?>">
																<input type="hidden" id="nombreusuario" value="<?php echo $nombreusuario; ?>">
																<select class="form-control input-sm" name="TipoDocumento" id="TipoDocumento">
																	<option value="">Seleccione</option>
																	<option value="1">DNI</option>
																	<option value="3">Carnet Extranjeria</option>
																	<option value="6">RUC</option>
																</select>
																<a href="#" title="Modal de Busqueda de Documento" id="btnEquifax">(No tengo el Número de Documento)</a>
															</div>
															<div class="form-group">
																<label id="labeltelefono">DOCUMENTO: </label>
																<input type="text" class="form-control input-sm" name="Documento" id="Documento" maxlength="12" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
															</div>
															<div class="form-group hidden">
																<label>DEPARTAMENTO: </label>
																<select class="form-control input-sm select2full" name="Departamental" id="Departamental" style="width: 100%">
																	<option value="" selected>Seleccione</option>
																</select>
															</div>
															<div class="form-group hidden">
																<label>PROVINCIA: </label>
																<select class="form-control input-sm select2full" name="Provincial" id="Provincial" style="width: 100%">
																	<option value="">Seleccione</option>
																</select>
															</div>
															<div class="form-group hidden">
																<label>DISTRITO: </label>
																<select class="form-control input-sm select2full" name="Distrital" id="Distrital" style="width: 100%">
																	<option value="">Seleccione</option>
																</select>
															</div>
															<div class="form-group">
																<label>SEGMENTO: </label>
																<select class="form-control input-sm" name="Segmento" id="Segmento" style="width: 100%" <?php echo ($tipoventa == "RE" || $tipoventa == "REGGCC" )?'':'disabled';?>>
																	<option value="">Seleccione</option>
																	<option value="RES">RES</option>
																	<option value="NEG">NEG</option>
																</select>
															</div>
															<div class="form-group" style="margin-top:40px;">
																<button class="btn  btn-block btn-verisure" id="btnScoring">Consultar Scoring</button>
																<button class="btn  btn-block btn-verisure" style="display:none" id="btnNuevaScoring">Nueva Consulta</button>
																<button type="button" class="btn btn-block btn-verisurecerrar" data-dismiss="modal">Cerrar</button>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
										<div class="col-md-6">
											<main class="contenedor ocultar box box-danger" id="ResultadoEquifax">
												<div id="resultado">
													<div class="callout bg-deuda">
														<h4><i class="fa fa-bullhorn"></i> Resultado de la Consulta:</h4>
														<h2 style="text-align: center;"><small class="label bg-visita"><span class="TextoAccion"></span></small><small class="label bg-televenta"><span class="TextoAccion"></span></small><small class="label bg-gestion"><span class="TextoAccion"></span></small></h2>
														<br>
														<!--<strong>N°Operación: </strong><span id="NOperacion">S32012280000162</span><br>-->
														<strong>Fecha Consulta: </strong><span id="FechaConsulta">13/11/2019 12:24:34</span><br><br>
														<div class="row">
															<div class="col-xs-12">
																<strong><i class="fa fa-user text-danger"></i> Nombre del Solicitante:</strong><br><span id="NombreCompleto">DUBOIS DORIBAL DUBOIS DORIBAL GLADYS ELVIRA</span><br>
																<strong><i class="fa fa-folder-open text-danger"></i> <span id="TDocumento">DNI:</span></strong><br><span id="NumeroDocumento">00007039332</span><br>
															</div>
															<div class="col-xs-12" style="display:none">
																<div class="contenido-score">
																	<div class="score-info">
																		<div>
																			<strong>SCORE - RIESGO</strong>
																			<br>
																			<span id="Riesgo">Bajo</span>
																		</div>
																		<div>
																			<strong>SCORE - VALOR</strong>
																			<br>
																			<div id="Valor">952</div>
																		</div>
																	</div>
																</div>
															</div>
														</div>
													</div>
												</div>
											</main>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="modal fade" id="modal-logdni">
						<div class="modal-dialog modal-lg">
							<div class="modal-content">
								<div class="modal-header modal-header-danger">
									<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
									<h3>DOCUMENTOS</h3>
								</div>
								<div class="modal-body">
									<div class="row">
										<div class="col-xs-12 col-sm-12 table-responsive no-padding">
											<table class="table table-bordered" id="tblVentas" style="display:none;">
												<thead>
													<tr style="height:0.8vw">
														<td class="text-center">OPCIONES</td>
														<td class="text-center">FECHA CONSULTA</td>
														<td class="text-center">TIPO DOC.</td>
														<td class="text-center">DOCUMENTO</td>
														<td class="text-center">NOMBRES, APELLIDO PATERNO, APELLIDO MATERNO</td>
													</tr>
												</thead>
												<tbody></tbody>
											</table>
										</div>
									</div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
								</div>
							</div>
						</div>
					</div>
					<!-- MODAL DETALLE EXTRAS -->
					<div class="modal fade" id="modal__carritocompras">
						<div class="modal-dialog modal-lg">
							<div class="modal-content">
								<div class="modal-header modal-header-danger">
									<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
									<h3>EXTRAS</h3>
								</div>
								<div class="modal-body">
									<div class="form-group">
										<label for="cboProducto" class="col-md-3 control-label">Extra:</label>
										<div class="col-md-9">
											<select class="form-control" id="cboProducto" name="cboProducto" style="width: 100%">
												<option value="" disabled selected hidden>--Seleccione--</option>
												<?php
													if($dc == "154" || $dc == "157" || $dc == "158" || $matriculausuario=='MGR200' || $dc == "120" || $dc == "150" || $dc == "41" || $dc == "155" || $dc == "152" || $dc == "200" ){
													    $query="SELECT IdItem, CodItem, Item, Precio, CuotaMes
													            FROM yifi58ge_dbVENTAS.tblitem
													            where CategoriaItem = 'field' and Estado = 'Activo'";
													}else{
													    $query="SELECT IdItem, CodItem, Item, Precio, CuotaMes
													            FROM yifi58ge_dbVENTAS.tblitem
													            where CategoriaItem = 'field' and Estado = 'Activo'";
													}
													$resultado=$con->query($query);
													        
													while ($data = $resultado->fetch_assoc()){                                                          
													?>
												<option value="<?php echo $data['IdItem']; ?>"><?php echo $data['Item']." (S/. ".number_format((float)$data['Precio'], 0, '.', '').")"; ?></option>
												<?php } ?>
											</select>
											<input type="hidden" id="hidProducto" name="hidProducto">
										</div>
									</div>
									<div class="form-group">
										<label for="cboTipoPrecio" class="col-md-3 control-label">Tipo precio:</label>
										<div class="col-md-9">
											<select class="form-control" id="cboTipoPrecio" name="cboTipoPrecio" style="width: 100%">
												<option value="" disabled selected hidden>--Seleccione--</option>
												<option value="catalogo">CATALOGO (SIN DESCUENTO))</option>
												<option value="medio">MEDIO (25% DESCUENTO ) </option>
												<option value="autorizado">AUTORIZADO (50% DESCUENTO)</option>
												<option value="excepcion">EXCEPCION</option>
											</select>
										</div>
									</div>
									<div class="form-group">
										<label for="cantidadProductos" class="col-md-3 control-label">Precio unitario:</label>
										<div class="col-md-9">
											<input type="number" class="form-control" id="precioUnitario" name="precioUnitario">
											<input type="hidden" id="precioMin">
											<input type="hidden" id="precioMax">
											<input type="hidden" id="cuotaMes">
										</div>
									</div>
									<div class="form-group">
										<label for="cantidadProductos" class="col-md-3 control-label">Cantidad:</label>
										<div class="col-md-9">
											<input type="number" class="form-control" id="cantidadProductos" name="cantidadProductos">
										</div>
									</div>
									<div class="row">
										<div class="col-sm-12">
											<button class="btn btn-danger pull-right" id="btnAgregar" name="btnAgregar"><i class="fa fa-plus"></i>&nbsp Agregar </button>    
										</div>
									</div>
									<div class="row">
										<div id="listaExtras" class="col-md-12">
										</div>
									</div>
									<!-- RESUTADO FINAL -->
									<div class="row">
										<div class="col-md-4"></div>
										<div class="col-md-8">
											<label for="txtResumen" class="col-sm-4 control-label">Resumen:</label>
											<div class="col-sm-8">
												<textarea rows="2" id="txtResumen" name="txtResumen" style="width: 100%" disabled></textarea>
											</div>
										</div>
									</div>
									<br>
									<div class="row">
										<div class="col-md-4"></div>
										<div class="col-md-8">
											<label for="txtCantidadExtra" class="col-sm-4 control-label">Cantidad Extras:</label>
											<div class="col-sm-8">
												<input type="number" id="txtCantidadExtra" name="txtCantidadExtra" style="width: 100%" min="0" value="0" disabled>
											</div>
										</div>
									</div>
									<br>
									<!--
										<div class="row">
										    <div class="col-md-4"></div>
										    <div class="col-md-8">
										        <label for="txtCantidadRegalo" class="col-sm-4 control-label">Cantidad Regalo:</label>
										        <div class="col-sm-8">
										            <input type="number" id="txtCantidadRegalo" name="txtCantidadRegalo" style="width: 100%" min="0" value="0" disabled>
										        </div>
										    </div>
										</div>
										<br>
										-->
									<div class="row">
										<div class="col-md-4"></div>
										<div class="col-md-8">
											<label for="txtTotal" class="col-sm-4 control-label">Total:</label>
											<div class="col-sm-8">
												<input type="number" id="txtTotal" name="txtTotal" style="width: 100%" min="0" value="0.00" disabled>
											</div>
										</div>
									</div>
									<br>
									<div class="row">
										<div class="col-md-4"></div>
										<div class="col-md-8">
											<label for="txtTotalCuota" class="col-sm-4 control-label">Total Cuota:</label>
											<div class="col-sm-8">
												<input type="number" id="txtTotalCuota" name="txtTotalCuota" style="width: 100%" min="0" value="0.00" disabled>
											</div>
										</div>
									</div>
								</div>
								<div class="modal-footer">
									<button class="btn btn-danger" id="generarOferta">Generar</button>
								</div>
							</div>
						</div>
					</div>
					<!-- MODAL DETALLE REGALOS -->
					<div class="modal fade" id="modal__regalos">
						<div class="modal-dialog modal-lg">
							<div class="modal-content">
								<div class="modal-header modal-header-danger">
									<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
									<h3>REGALOS</h3>
								</div>
								<div class="modal-body">
									<div class="form-group">
										<label for="cboRegalo" class="col-md-3 control-label">Regalo:</label>
										<div class="col-md-9">
											<select class="form-control" id="cboRegalo" name="cboRegalo" style="width: 100%">
												<option value="" disabled selected>--Seleccione--</option>
												<?php
													if($dc == "154" || $dc == "157" || $dc == "158" || $matriculausuario=='MGR200' || $dc == "120" || $dc == "150" || $dc == "41" || $dc == "155" || $dc == "152" || $dc == "200"){
													    $query="SELECT IdItem, CodItem, Item, Precio, CuotaMes
													            FROM yifi58ge_dbVENTAS.tblitem
													            where CategoriaItem = 'fieldRegalo' and Estado = 'Activo'";
													}else{
													    $query="SELECT IdItem, CodItem, Item, Precio, CuotaMes
													            FROM yifi58ge_dbVENTAS.tblitem
													            where CategoriaItem = 'fieldRegalo' and Estado = 'Activo'";
													}
													$resultado=$con->query($query);
													        
													while ($data = $resultado->fetch_assoc()){                                                          
													?>
												<option value="<?php echo $data['IdItem']; ?>"><?php echo $data ['Item']; ?></option>
												<?php } ?>
											</select>
										</div>
									</div>
									<div class="form-group">
										<label for="cantidadProductos" class="col-md-3 control-label">Cantidad:</label>
										<div class="col-md-9">
											<input type="number" class="form-control" id="cantidadProductos__Regalos" name="cantidadProductos__Regalos" min="1" >
										</div>
									</div>
									<div class="row">
										<div class="col-sm-12">
											<button class="btn btn-danger pull-right" id="btnAgregar__Regalos" name="btnAgregar__Regalos"><i class="fa fa-plus"></i>&nbsp Agregar </button>    
										</div>
									</div>
									<div class="row">
										<div id="listaRegalos" class="col-md-12">
										</div>
									</div>
									<!-- RESUTADO FINAL -->
									<div class="row">
										<div class="col-md-4"></div>
										<div class="col-md-8">
											<label for="txtResumen" class="col-sm-4 control-label">Resumen:</label>
											<div class="col-sm-8">
												<textarea rows="2" id="txtResumen__Regalo" name="txtResumen__Regalo" style="width: 100%" disabled></textarea>
											</div>
										</div>
									</div>
									<br>
									<!--
										<div class="row">
										    <div class="col-md-4"></div>
										    <div class="col-md-8">
										        <label for="txtCantidadExtra" class="col-sm-4 control-label">Cantidad Extras:</label>
										        <div class="col-sm-8">
										            <input type="number" id="txtCantidadExtra" name="txtCantidadExtra" style="width: 100%" min="0" value="0" disabled>
										        </div>
										    </div>
										</div>
										<br>
										
										<div class="row">
										    <div class="col-md-4"></div>
										    <div class="col-md-8">
										        <label for="txtCantidadRegalo" class="col-sm-4 control-label">Cantidad Regalo:</label>
										        <div class="col-sm-8">
										            <input type="number" id="txtCantidadRegalo" name="txtCantidadRegalo" style="width: 100%" min="0" value="0" disabled>
										        </div>
										    </div>
										</div>
										<br>
										-->
									<div class="row">
										<div class="col-md-4"></div>
										<div class="col-md-8">
											<label for="txtCantidadRegalo" class="col-sm-4 control-label">Cantidad Regalo:</label>
											<div class="col-sm-8">
												<input type="number" id="txtCantidadRegalo" name="txtCantidadRegalo" style="width: 100%" min="0" value="0" disabled>
											</div>
										</div>
									</div>
									<div class="row">
										<div class="col-md-4"></div>
										<div class="col-md-8">
											<label for="txtTotal" class="col-sm-4 control-label">Total:</label>
											<div class="col-sm-8">
												<input type="number" id="txtTotal__Regalo" name="txtTotal__Regalo" style="width: 100%" min="0" value="0.00" disabled>
											</div>
										</div>
									</div>
									<div class="row">
										<div class="col-md-4"></div>
										<div class="col-md-8">
											<label for="txtTotalCuota" class="col-sm-4 control-label">Total Cuota:</label>
											<div class="col-sm-8">
												<input type="number" id="txtTotalCuota__Regalo" name="txtTotalCuota__Regalo" style="width: 100%" min="0" value="0.00" disabled>
											</div>
										</div>
									</div>
								</div>
								<div class="modal-footer">
									<button class="btn btn-danger" id="generarOferta__Regalo">Generar</button>
								</div>
							</div>
						</div>
					</div>
					
					<!-- MODAL CAMBIO NUMERO CONTRATO -->
					<div class="modal fade" id="modal_cambio_numero_contrato">
						<div class="modal-dialog">
							<div class="modal-content">
								<div class="modal-header modal-header-danger">
									<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
									<h4>MODIFICACIÓN DE NÚMERO DE CONTRATO</h4>
								</div>
								<div class="modal-body">
									<div class="row">
										<!-- left column -->
										<div class="col-xs-12">
											<!-- general form elements -->
											<div class="box box-danger">
												<div class="box-header with-border">
													<h1 class="box-title">CONTRATO</h1>
												</div>
												<!-- /.box-header -->
												<!-- form start -->
												<div class="box-body" id="bodyprincipalNumeroContrato">
													<table style="width:90%;">
														<tr class="espacio2"></tr>
														<tr>
															<td style="width: 83%;">
																<div class="input-group input-group-sm" style="width: 200px;">
																	<input type="number" class="form-control input-sm" name="lblCambiarContrato" id="lblCambiarContrato" placeholder="Cambiar número de Contrato">
																	<div class="input-group-btn">
																		<button type="button" id="cambiarNumeroContrato" class="btn btn-nuevo btn-sm" style="border-radius: 0px;"><i class="fa fa-save"></i></button>
																	</div>
																</div>
															</td>
														</tr>
													</table>
													<br>
													
												</div>
												<!-- /.box-body -->
											</div>
											<!-- /.box -->
										</div>
									</div>
									<div class="modal-footer">
										<button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
									</div>
								</div>
							</div>
						</div>
					</div>
					
					<!-- MODAL CAMBIO VENTA -->
					<div class="modal fade" id="modal_cambio_venta">
						<div class="modal-dialog">
							<div class="modal-content">
								<div class="modal-header modal-header-danger">
									<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
									<h4>TRASPASO DE RP A RE</h4>
								</div>
								<div class="modal-body">
									<div class="row">
										<!-- left column -->
										<div class="col-xs-12">
											<!-- general form elements -->
											<div class="box box-danger">
												<div class="box-header with-border">
													<h1 class="box-title">PROSPECTO</h1>
												</div>
												<!-- /.box-header -->
												<!-- form start -->
												<div class="box-body" id="bodyprincipal">
													<table style="width:90%;">
														<tr class="espacio2"></tr>
														<tr>
															<td style="width: 83%;">
																<div class="input-group input-group-sm" style="width: 200px;">
																	<input type="tel" class="form-control input-sm" name="lblprospectobuscar" id="lblprospectobuscar" placeholder="Buscar prospecto..">
																	<div class="input-group-btn">
																		<button type="button" id="buscarprospecto" class="btn btn-nuevo btn-sm" style="border-radius: 0px;"><i class="fa fa-search"></i></button>
																	</div>
																</div>
															</td>
														</tr>
													</table>
													<br>
													<div class="table-responsive no-padding">
														<table class="table table-bordered" id="tblvisitas">
															<thead>
																<tr style="height:0.8vw">
																	<td class="text-center">OPCIONES</td>
																	<td class="text-center">PROSPECTO</td>
																	<td class="text-center">CLIENTE</td>
																	<td class="text-center">CC</td>
																	<td class="text-center">590</td>
																	<td class="text-center">ESTADOVENTA</td>
																	<td class="text-center">TIPOVENTA</td>
																</tr>
															</thead>
															<tbody></tbody>
														</table>
													</div>
												</div>
												<!-- /.box-body -->
											</div>
											<!-- /.box -->
										</div>
									</div>
									<div class="modal-footer">
										<button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
									</div>
								</div>
							</div>
						</div>
					</div>
					<!-- MODAL ENVIAR CORREO-->
					<div class="modal fade" id="modal-enviarcorreoafiliar" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static" data-keyboard="false">
						<div class="modal-dialog">
							<div class="modal-content">
								<div class="modal-header modal-header-danger">
									<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
									<h4 class="modal-enviocorreo-title">ENVIAR A AFILIAR</h4>
								</div>
								<div class="modal-body">
									<form id="form_enviocorreo" methodo="POST">
										<div class="form-group">
											<label for="exampleInputEmail1">CORREO:</label>
											<input type="email" class="form-control" id="InputCorreo" placeholder="Escribir correo">
										</div>
									</form>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" id="ModEnviarCerrar" data-dismiss="modal">Cerrar</button>
									<button type="button" class="btn btn-danger" id="ModEnviar">Enviar</button>
								</div>
							</div>
						</div>
					</div>
				</section>
				<!-- /.content -->
			</div>
			<!-- /.content-wrapper -->
			<div class="control-sidebar-bg"></div>
		</div>
		<!-- ./wrapper -->
		<!-- jQuery v1.11 -->
		<script src="admin/bower_components/jquery/dist/jquery_v1.11.js" type="text/javascript"></script>
		<!-- jQuery UI 1.11.4 -->
		<script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
		<!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
		<script>
			$.widget.bridge('uibutton', $.ui.button);
		</script>
		<!-- Bootstrap 3.3.7 -->
		<script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
		<!-- Select2 -->
		<script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
		<!-- Sparkline -->
		<script src="admin/bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>
		<!-- Slimscroll -->
		<script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
		<!-- FastClick -->
		<script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
		<!-- AdminLTE App -->
		<script src="admin/dist/js/adminlte.min.js"></script>
		<script src="admin/bower_components/ag-grid-master/dist/ag-grid.min.js" type="text/javascript"></script>
		<!-- InputMask -->
		<script src="admin/plugins/input-mask/jquery.inputmask.js"></script>
		<script src="admin/plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
		<script src="admin/plugins/input-mask/jquery.inputmask.extensions.js"></script>
		<script src="admin/plugins/bootstrap-toggle-master/js/bootstrap-toggle.min.js"></script>
		<!-- bootstrap datepicker -->
		<script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
		<script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>
		<!-- bootstrap time picker -->
		<script src="admin/plugins/timepicker/bootstrap-timepicker.min.js" type="text/javascript"></script>
		<!-- Alertify -->
		<script src="admin/bower_components/alertifyjs/alertify.min.js" type="text/javascript"></script>
		<!-- SweetAlert -->
		<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
		<!--GLOBALES -->
		<script>
			const perfilUsuario = $('#headerPerfilUsuario').val();
			const MatriculaUsuario = $('#headerMatriculaUsuario').val();
			
			if(perfilUsuario!=1 || perfilUsuario!=2 || perfilUsuario!=15){
			    $('#contratoenviado')[0].disabled = false;
			    $('#FechaContratoEnviado')[0].disabled = false;
			    $('#montoCO')[0].disabled = false;
			    $('#contratocorrecto')[0].disabled = false;
			    $('#motivoincidenciaCO')[0].disabled = false;
			    $('#lblcomentarioco')[0].disabled = false;
			    
			}else{
			    $('#contratoenviado')[0].disabled = true;
			    $('#FechaContratoEnviado')[0].disabled = true;
			    $('#montoCO')[0].disabled = true;
			    $('#contratocorrecto')[0].disabled = true;
			    $('#motivoincidenciaCO')[0].disabled = true;
			    $('#lblcomentarioco')[0].disabled = true;			     
			}

			//ARREGLO DE DATOS QUE CONTIENE LA LISTA DE REGALOS
			let arregloRegalos = [];
			//ARREGLO DE DATOS QUE CONTIENE LA LISTA DE EXTRAS
			let arregloDatos = [];
			//ARREGLO GENERAL DE KIT, REGALOS Y EXTRAS
			let arregloGeneral = [];
			
			const listaExtras = document.querySelector('#listaExtras');
			const listaRegalos = document.querySelector('#listaRegalos');
			
			//ARREGLO DE DATOS QUE CONTIENE LA LISTA DE FALLO DE SUPERVISION
			let arregloDatosFalloSupervision = [];
			let arregloDatosTamper = [];
			
			const listaTamper = document.querySelector('#listaTamper');
			const listaFalloSupervision = document.querySelector('#listaFalloSupervision'); 
			
			
		</script>    
		<!-- GRID -->
		<script>
			var columnDefs = [{
			        headerName: 'FechaHoraREG',
			        field: 'FechaHoraREG',
			        width: 140
			    },
			    {
			        headerName: 'FechaInst',
			        field: 'FechaInst',
			        width: 130,
			        pinned: 'left'
			    },
			    {
			        headerName: 'HoraInst',
			        field: 'HoraInst',
			        width: 105,
			        pinned: 'left'
			    },
			    {
			        headerName: 'InstaladoX',
			        field: 'InstaladoX',
			        width: 100
			    },
			    {
			        headerName: 'MatriculaTec',
			        field: 'MatriculaTec',
			        width: 110
			    },
			    {
			        headerName: 'Repercusion',
			        field: 'Repercusion',
			        width: 130
			    },
			    {
			        headerName: 'MotivoInviable',
			        field: 'MotivoInviable',
			        width: 150
			    },
			    {
			        headerName: 'Comentario',
			        field: 'Comentario',
			        width: 200
			    },
			    {
			        headerName: 'EstadoVenta',
			        field: 'EstadoVenta',
			        width: 120
			    },
			    {
			        headerName: 'Gestor',
			        field: 'GestorAgenda',
			        width: 120
			    }
			];
			
			var gridOptions = {
			    columnDefs: columnDefs,
			    rowData: null,
			    enableFilter: true,
			    enableColResize: true,
			    localeText: {
			        // for filter panel
			        page: 'página',
			        more: 'Más',
			        to: 'a',
			        of: 'de',
			        next: 'Siguiente',
			        last: 'Último',
			        first: 'Primero',
			        previous: 'Anterior',
			        loadingOoo: 'Cargando...',
			        // for set filter
			        selectAll: 'Seleccionar todo',
			        searchOoo: 'Buscando...',
			        blanks: 'Espacios en blanco',
			        // for number filter and text filter
			        filterOoo: 'Filtrar...',
			        applyFilter: 'Aplicar Filtro',
			        // for number filter
			        equals: 'Igual',
			        notEqual: 'No es igual',
			        lessThanOrEqual: 'Menor o igual',
			        greaterThanOrEqual: 'Mayor que o igual',
			        inRange: 'En el rango',
			        lessThan: 'Menos que',
			        greaterThan: 'Mas grande que',
			        // for text filter
			        contains: 'Contiene',
			        startsWith: 'Comienza con',
			        endsWith: 'Termina con',
			        notContains: 'No contiene',
			        // the header of the default group column
			        group: 'Grupo',
			        // tool panel
			        columns: 'columnas',
			        rowGroupColumns: 'Grupo columnas',
			        rowGroupColumnsEmptyMessage: 'No hay resultado',
			        valueColumns: 'Columna de valor',
			        pivotMode: 'Modo pivote',
			        groups: 'grupos',
			        values: 'valor',
			        pivots: 'pivote',
			        valueColumnsEmptyMessage: 'No hay resultado',
			        pivotColumnsEmptyMessage: 'No hay resultado',
			        // other
			        noRowsToShow: '<div class="callout callout-danger">\n\
			                                            <span class="pull-left">\n\
			                                            <img src="admin/dist/img/noresults-img.png" style="width: 70%">\n\
			                                            </span>\n\<h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>\n\
			                                            <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>\n\
			                                            <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>\n\
			                                            <br></div>',
			        // enterprise menu
			        pinColumn: 'Aclar columna',
			        valueAggregation: 'Agregar valor',
			        autosizeThiscolumn: 'Auto tamaño esta columna ',
			        autosizeAllColumns: 'Auto tamaño todas columnas',
			        groupBy: 'Agrupar',
			        ungroupBy: 'Agrupar uno',
			        resetColumns: 'Restaurar Columnas',
			        expandAll: 'expandir todo',
			        collapseAll: 'desplegar todo',
			        toolPanel: 'Panel de Heramientas',
			        export: 'Exportar',
			        csvExport: 'Exportar CSV',
			        excelExport: 'Exportar Excel',
			        // enterprise menu pinning
			        pinLeft: 'Anclar a derecha',
			        pinRight: 'Anclar a izquierda',
			        noPin: 'Desanclar',
			        // enterprise menu aggregation and status panel
			        sum: 'Sumar',
			        min: 'Minimo',
			        max: 'Maximo',
			        first: 'Primero',
			        last: 'Ultimo',
			        none: 'Nada',
			        count: 'Contador',
			        average: 'Promedio',
			        // standard menu
			        copy: 'Copiar',
			        copyWithHeaders: 'Copiar Cabecera',
			        ctrlC: 'Ctrl+C',
			        paste: 'Pegar',
			        ctrlV: 'Ctrl+V'
			    },
			    enableSorting: true
			};

            var columnDefsCert = [
                        {headerName: 'FechaHoraREG', field: 'FechaHoraREG', width: 140},
                        {headerName: 'MatriculaGestor', field: 'MatriculaGestor', width: 130, pinned: 'left'},
                        {headerName: 'FechaApertura', field: 'FechaApertura', width: 105, pinned: 'left'},
                        {headerName: 'FechaCierre', field: 'FechaCierre', width: 100},
                        {headerName: 'TipoCierre', field: 'TipoCierre', width: 110},
                        {headerName: 'IncidenciaTecnica', field: 'IncidenciaTecnica', width: 130},
                        {headerName: 'FormaPago', field: 'FormaPago', width: 150},
                        {headerName: 'Comentario', field: 'Comentario', width: 200}
            ]; 
        
            var gridOptionsCert = {
                columnDefs: columnDefsCert,
                rowData: null,
                enableFilter: true,
                enableColResize: true,
                localeText: {
                    // for filter panel
                    page: 'página',
                    more: 'Más',
                    to: 'a',
                    of: 'de',
                    next: 'Siguiente',
                    last: 'Último',
                    first: 'Primero',
                    previous: 'Anterior',
                    loadingOoo: 'Cargando...',
                    // for set filter
                    selectAll: 'Seleccionar todo',
                    searchOoo: 'Buscando...',
                    blanks: 'Espacios en blanco',
                    // for number filter and text filter
                    filterOoo: 'Filtrar...',
                    applyFilter: 'Aplicar Filtro',
                    // for number filter
                    equals: 'Igual',
                    notEqual: 'No es igual',
                    lessThanOrEqual: 'Menor o igual',
                    greaterThanOrEqual: 'Mayor que o igual',
                    inRange: 'En el rango',
                    lessThan: 'Menos que',
                    greaterThan: 'Mas grande que',
                    // for text filter
                    contains: 'Contiene',
                    startsWith: 'Comienza con',
                    endsWith: 'Termina con',
                    notContains:'No contiene',
                    // the header of the default group column
                    group: 'Grupo',
                    // tool panel
                    columns: 'columnas',
                    rowGroupColumns: 'Grupo columnas',
                    rowGroupColumnsEmptyMessage: 'No hay resultado',
                    valueColumns: 'Columna de valor',
                    pivotMode: 'Modo pivote',
                    groups: 'grupos',
                    values: 'valor',
                    pivots: 'pivote',
                    valueColumnsEmptyMessage: 'No hay resultado',
                    pivotColumnsEmptyMessage: 'No hay resultado',
                    // other
                    noRowsToShow: '<div class="callout callout-danger">\n\
        <span class="pull-left">\n\
        <img src="admin/dist/img/noresults-img.png" style="width: 70%">\n\
        </span>\n\<h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>\n\
        <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>\n\
        <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>\n\
        <br></div>',
                    // enterprise menu
                    pinColumn: 'Aclar columna',
                    valueAggregation: 'Agregar valor',
                    autosizeThiscolumn: 'Auto tamaño esta columna ',
                    autosizeAllColumns: 'Auto tamaño todas columnas',
                    groupBy: 'Agrupar',
                    ungroupBy: 'Agrupar uno',
                    resetColumns: 'Restaurar Columnas',
                    expandAll: 'expandir todo',
                    collapseAll: 'desplegar todo',
                    toolPanel: 'Panel de Heramientas',
                    export: 'Exportar',
                    csvExport: 'Exportar CSV',
                    excelExport: 'Exportar Excel',
                    // enterprise menu pinning
                    pinLeft: 'Anclar a derecha',
                    pinRight: 'Anclar a izquierda',
                    noPin: 'Desanclar',
                    // enterprise menu aggregation and status panel
                    sum: 'Sumar',
                    min: 'Minimo',
                    max: 'Maximo',
                    first: 'Primero',
                            last: 'Ultimo',
                            none: 'Nada',
                    count: 'Contador',
                    average: 'Promedio',
                    // standard menu
                    copy: 'Copiar',
                    copyWithHeaders: 'Copiar Cabecera',
                    ctrlC: 'Ctrl+C',
                    paste: 'Pegar',
                    ctrlV: 'Ctrl+V'
                },
                enableSorting: true
            };
			
			function onFilterChanged(value) {
			    gridOptions.api.setQuickFilter(value);
			}
			
			function listar() {
			    var idventa = '<?php echo $idventa; ?>';
			    $.ajax({
			        url: 'ajax/findDataHisAgenda.php?idventa=' + idventa,
			        success: function(data) {
			
			            if (data == 1) {
			                var gridDiv = document.querySelector('#myGrid');
			                new agGrid.Grid(gridDiv, gridOptions);
			
			                agGrid.simpleHttpRequest({
			                    url: 'ajax/selectListarHistAgenda.php?idventa=' + idventa
			                }).then(function(data) {
			
			                    gridOptions.api.setRowData(data);
			                });
			                $('#vistaboy').height(function(index, height) {
			
			                    return $(window).height() * 35 / 100;
			                });
			
			            } else {
			
			                $("#ningunresultado").html(data);
			
			                var gridDiv = document.querySelector('#myGrid');
			                new agGrid.Grid(gridDiv, gridOptions);
			
			                agGrid.simpleHttpRequest({
			                    url: 'ajax/selectListarHistAgenda.php?idventa=' + idventa
			                }).then(function(data) {
			
			                    gridOptions.api.setRowData(data);
			                });
			
			                $('#myGrid').hide("fast");
			            }
			        }
			    });
			}
			
			function refresh() {
			    var idventa = '<?php echo $idventa; ?>';
			    $.ajax({
			        url: 'ajax/findDataHisAgenda.php?idventa=' + idventa,
			        success: function(data) {
			
			            if (data == 1) {
			
			                var gridDiv = document.querySelector('#myGrid');
			                agGrid.simpleHttpRequest({
			                    url: 'ajax/selectListarHistAgenda.php?idventa=' + idventa
			                }).then(function(data) {
			                    gridOptions.api.setRowData(data);
			                });
			                $('#vistaboy').height(function(index, height) {
			
			                    return $(window).height() * 35 / 100;
			                });
			                $("#ningunresultado").hide("fast");
			                $('#myGrid').show(200);
			            } else {
			
			                $("#ningunresultado").html(data);
			                $('#myGrid').hide("fast");
			            }
			        }
			    });
			}
			

    
    function listarCert() {
        var idventa = '<?php echo $idventa; ?>';
        $.ajax({
            url: 'ajax/findDataHisCertificacion.php?idventa='+idventa,
            success: function (data) {

                if (data == 1) {
                    var gridDiv = document.querySelector('#myGrid_cert');
                    new agGrid.Grid(gridDiv, gridOptionsCert);

                    agGrid.simpleHttpRequest({url: 'ajax/selectListarHistCertificacion.php?idventa='+idventa}).then(function (data) {

                        gridOptionsCert.api.setRowData(data);
                    });
                    $('#vistaboy_cert').height(function (index, height) {

                        return $(window).height() * 35 / 100;
                    });
                   
                } else {

                    $("#ningunresultado_cert").html(data);

                    var gridDiv = document.querySelector('#myGrid_cert');
                    new agGrid.Grid(gridDiv, gridOptionsCert);

                    agGrid.simpleHttpRequest({url: 'ajax/selectListarHistCertificacion.php?idventa='+idventa}).then(function (data) {

                        gridOptionsCert.api.setRowData(data);
                    });



                    $('#myGrid_cert').hide("fast");

                }

            }
        });
    }
    
     var refresh_cert = function () {
        var idventa = '<?php echo $idventa; ?>';
        $.ajax({
            url: 'ajax/findDataHisCertificacion.php?idventa='+idventa,
            success: function (data) {

                if (data == 1) {

                    var gridDiv = document.querySelector('#myGrid_cert');
                    agGrid.simpleHttpRequest({url: 'ajax/selectListarHistCertificacion.php?idventa='+idventa}).then(function (data) {
                        gridOptionsCert.api.setRowData(data);
                    });
                    $('#vistaboy_cert').height(function (index, height) {

                        return $(window).height() * 35 / 100;
                    });
                    $("#ningunresultado_cert").hide("fast");
                    $('#myGrid_cert').show(200);
                } else {

                    $("#ningunresultado_cert").html(data);
                    $('#myGrid_cert').hide("fast");

                }
            }
        });

    }    			
			
			// setup the grid after the page has finished loading
			document.addEventListener('DOMContentLoaded', function() {
			
			    listar();
        listarCert();
			
			});
		</script>
		<!-- EVENTOS -->
		<script>
		    /* CONTRATO FISICO/DIGITAL 18.09.2023 */
			$("#tipocontrato").change(function() {
                var tipocontrato = $(this).val();
                
                if(tipocontrato == "FISICO"){
                    $(".contratofisico").removeClass("ocultar");
                    $(".contratodigital").addClass("ocultar");
                    $("#cambioacontratofisico").val("");
                    $("#lblcomentariocontratodigital").html("");
                }
                if(tipocontrato == "DIGITAL"){
                    $(".contratodigital").removeClass("ocultar");
                    $(".contratofisico").addClass("ocultar");
                    $("#cambioacontratofisico").val("");
                    $("#lblcomentariocontratodigital").html("");
                    $("#autorizadocontratofisico").val("");
                    $("#lblcomentariocontratofisico").html("");
                }
			});
		
			$(window).resize(function() {
			    alterClass();
			});
			
			$("#lbldc").change(function() {
			    $("#lbldc option:selected").each(function() {
			        var lbldc = $(this).val();
			        $.post("./ajax/selectJefeVenta.php", {
			            lbldc: lbldc
			        }, function(data) {
			            $("#lbljefeventa").html(data);
			        });
			    });
			
			});
			
			$("#lblinstaladox").change(function() {
			    $("#lblinstaladox option:selected").each(function() {
			        var lblinstaladox = $(this).val();
			        $.post("./ajax/selectTecnico.php", {
			            lblinstaladox: lblinstaladox
			        }, function(data) {
			            $("#lbltecnico").html(data);
			        });
			    });
			
			});
			
			$('#contactadoco').bootstrapToggle({
			    on: 'SI',
			    off: 'NO',
			    onstyle: 'success',
			    offstyle: 'danger'
			});
			
			$('#contactadoco').change(function() {
			    if ($(this).prop('checked')) {
			        $('#hidden_contact').val('SI');
			    } else {
			        $('#hidden_contact').val('NO');
			    }
			});

		
			
			
			$('#ventaconfirmadaco').bootstrapToggle({
			    on: 'SI',
			    off: 'NO',
			    onstyle: 'success',
			    offstyle: 'danger'
			});
			
			$('#ventaconfirmadaco').change(function() {
			    if ($(this).prop('checked')) {
			        $('#hidden_ventaconfirmadaco').val('SI');
			    } else {
			        $('#hidden_ventaconfirmadaco').val('NO');
			    }
			});
			
			
			$("#lblestadoventa").change(function() {
			    var condiciones = $("#lblestadoventa").val();
			    $("#lblestventa").val(condiciones);
			    bloquear(condiciones);
			
			});
			
			$("#lbltipoventa").change(function() {
			    var tps = $("#lbltipoventa").val();
			    $("#lbltiventa").val(tps);
			});
			
			$("#lblcategoria").change(function() {
			    var categoria = $("#lblcategoria").val();
			    var recurso = $("#lbltiventa").val();
			    $("#lblcat").val(categoria);
			    bloquearxCategoria(categoria);
			    if (recurso == "RE" || recurso == "REGGCC") {
			
			        if (categoria == "Ficha") {
			
			            $("#lblestadoventa").val("PendienteAgenda");
			            $("#lblestvisita").val("Vendida");
			            $("#lblestventa").val("PendienteAgenda");
			            $('#lblestadoventa')[0].disabled = false;
			        }
			        if (categoria == "Online") {
			            $("#lblestadoventa").val("PendienteData");
			            $("#lblestvisita").val("Vendida");
			            $("#lblestventa").val("PendienteData");
			            $('#lblestadoventa')[0].disabled = false;
			        }
			        if (categoria == "VAsignada") {
			            $("#lblestadoventa").val("VAsignada");
			            $("#lblestvisita").val("Asignada");
			            $("#lblestventa").val("VAsignada");
			        }
			        if (categoria == "Delegacion") {
			            $("#lblestadoventa").val("AgendadaDEL");
			            $("#lblestvisita").val("Vendida");
			            $("#lblestventa").val("AgendadaDEL");
			            $('#lblestadoventa')[0].disabled = false;
			            $('#lblncontrato')[0].disabled = false;
			        }
			        if (categoria == "NoVendida") {
			            $("#lblestadoventa").val("NoVendida");
			            $("#lblestvisita").val("NoVendida");
			            $("#lblestventa").val("NoVendida");
			            $('#lblestadoventa')[0].disabled = true;
			        }
			    } else {
			
			        if (categoria == "Ficha") {
			            $("#lblestadoventa").val("PendienteAgenda");
			            $("#lblestventa").val("PendienteAgenda");
			            $("#lblestvisita").val("");
			        }
			        if (categoria == "Online") {
			            $("#lblestadoventa").val("PendienteData");
			            $("#lblestventa").val("PendienteData");
			            $("#lblestvisita").val("");
			        }
			        if (categoria == "Delegacion") {
			            $("#lblestadoventa").val("AgendadaDEL");
			            $("#lblestventa").val("AgendadaDEL");
			            $("#lblestvisita").val("");
			        }
			        if (categoria == "NoVendida") {
			            $("#lblestadoventa").val("NoVendida");
			            $("#lblestventa").val("NoVendida");
			            $("#lblestvisita").val("");
			            $('#lblestadoventa')[0].disabled = true;
			        }
			        if (categoria == "ProspectoRP") {
			            $("#lblestadoventa").val("ProspectoRP");
			            $("#lblestvisita").val("");
			            $("#lblestventa").val("ProspectoRP");
			        }
			
			
			    }
			
			});
			
			$('#lblmatricula').on('keyup', function() {
			    var dato = $('#lblmatricula').val();
			    var url = 'ajax/findMatricula.php';
			    $.ajax({
			        type: 'POST',
			        url: url,
			        data: 'dato=' + dato,
			        success: function(datos) {
			            $('.mensajematricula').html(datos);
			        }
			    });
			    return false;
			});
			
			$("#lblmatricula").autocomplete({
			    source: "./ajax/selectMatricula.php",
			    minLength: 2,
			    select: function(event, ui) {
			        event.preventDefault();
			        $('#lblidusuario').val(ui.item.idusuario);
			        $('#lblmatricula').val(ui.item.matricula);
			        $('#lblnombcomercial').val(ui.item.comercial);
			        //                        $('#lbldc').val(ui.item.dc);
			        //                        $('#lbljefeventa').val(ui.item.jefe);
			
			    }
			});
			
			$("#lblmatricula").on("keydown", function(event) {
			    if (event.keyCode == $.ui.keyCode.LEFT || event.keyCode == $.ui.keyCode.RIGHT || event.keyCode == $.ui.keyCode.UP || event.keyCode == $.ui.keyCode.DOWN || event.keyCode == $.ui.keyCode.DELETE || event.keyCode == $.ui.keyCode.BACKSPACE) {
			        $('#lblidusuario').val("");
			        $('#lblmatricula').val("");
			        $('#lblnombcomercial').val("");
			        //                        $('#lbldc').val("");
			        //                        $('#lbljefeventa').val("");
			
			    }
			    if (event.keyCode == $.ui.keyCode.DELETE) {
			        $('#lblmatricula').val("");
			        $('#lblidusuario').val("");
			        $('#lblnombcomercial').val("");
			        //                        $('#lbldc').val("");
			        //                        $('#lbljefeventa').val("");
			    }
			});
			
			$('#HCertificacion').bootstrapToggle({
			    on: 'SI',
			    off: 'NO',
			    onstyle: 'success',
			    offstyle: 'danger'
			});
			
			$('#HCertificacion').change(function() {
			    if ($(this).prop('checked')) {
			        $('#hidden_HCertificacion').val('SI');
			    } else {
			        $('#hidden_HCertificacion').val('NO');
			    }
			});
			
			$('#GGCC').bootstrapToggle({
			    on: 'SI',
			    off: 'NO',
			    onstyle: 'success',
			    offstyle: 'danger'
			});
			
			$('#GGCC').change(function() {
			    if ($(this).prop('checked')) {
			        $('#hidGGCC').val('SI');
			    } else {
			        $('#hidGGCC').val('NO');
			    }
			});
			
			$('#regalosAutorizados').bootstrapToggle({
			    on: 'SI',
			    off: 'NO',
			    onstyle: 'success',
			    offstyle: 'danger'
			});
			
			$('#regalosAutorizados').change(function() {
			    if ($(this).prop('checked')) {
			        $('#hidregalosAutorizados').val('SI');
			    } else {
			        $('#hidregalosAutorizados').val('NO');
			    }
			});
			$('#descuetocuotaAutorizados').bootstrapToggle({
			    on: 'SI',
			    off: 'NO',
			    onstyle: 'success',
			    offstyle: 'danger'
			});
			
			$('#descuetocuotaAutorizados').change(function() {
			    if ($(this).prop('checked')) {
			        $('#hiddescuetocuotaAutorizados').val('SI');
			    } else {
			        $('#hiddescuetocuotaAutorizados').val('NO');
			    }
			});
			
			
			$('#closingpackAutorizados').bootstrapToggle({
			    on: 'SI',
			    off: 'NO',
			    onstyle: 'success',
			    offstyle: 'danger'
			});
			
			$('#closingpackAutorizados').change(function() {
			    if ($(this).prop('checked')) {
			        $('#hidclosingpackAutorizados').val('SI');
			    } else {
			        $('#hidclosingpackAutorizados').val('NO');
			    }
			});
			$('#extrasAutorizados').bootstrapToggle({
			    on: 'SI',
			    off: 'NO',
			    onstyle: 'success',
			    offstyle: 'danger'
			});
			
			$('#extrasAutorizados').change(function() {
			    if ($(this).prop('checked')) {
			        $('#hidextrasAutorizados').val('SI');
			    } else {
			        $('#hidextrasAutorizados').val('NO');
			    }
			});
			
			$('#categoriaKitAutorizados').bootstrapToggle({
			    on: 'SI',
			    off: 'NO',
			    onstyle: 'success',
			    offstyle: 'danger'
			});
			
			$('#categoriaKitAutorizados').change(function() {
			    if ($(this).prop('checked')) {
			        $('#hidcategoriaKitAutorizados').val('SI');
			    } else {
			        $('#hidcategoriaKitAutorizados').val('NO');
			    }
			});
			
			$('.selectdistrito').select2({
			    placeholder: 'Seleccione Distrito - Provincia',
			    allowClear: true,
			    language: {
			        errorLoading: function() {
			            return "La carga falló";
			        },
			        noResults: function() {
			            return "No hay resultado";
			        },
			        searching: function() {
			
			            return "Buscando..";
			        }
			    },
			    ajax: {
			        url: 'ajax/selectDistritoField.php',
			        dataType: 'json',
			        delay: 250,
			        processResults: function(data) {
			            return {
			                results: data
			            };
			        },
			        cache: true
			    }
			});
			$('.selectdistrito').on('select2:select', function (e) {
			    var data = e.params.data;
			    $('#lblIdDepartamental').val(data.IdDepartamental);
			    $('#lblIdProvincial').val(data.IdProvincial);
			    $('#lblCodUbigeoReniec').val(data.CodUbigeoReniec);
			    
			    cargardepartamento();
			   
			});        
			
			$('.cbxtecnico').select2({
			    placeholder: 'Seleccione',
			    allowClear: true,
			    language: {
			        errorLoading: function() {
			            return "La carga falló";
			        },
			        noResults: function() {
			            return "No hay resultado";
			        },
			        searching: function() {
			
			            return "Buscando..";
			        }
			    }
			});
			
			$('#datemask').inputmask('dd/mm/yyyy', {
			    'placeholder': 'dd/mm/yyyy'
			});
			
			
			$('#lblfecharecpciondoc').datepicker({
			    autoclose: true,
			    language: 'es',
			    firstDay: 1
			});
			
			$('#lblfechafacturacion').datepicker({
			    autoclose: true,
			    language: 'es',
			    firstDay: 1
			});
			//Money Euro
			$('[data-mask]').inputmask();
			//Date picker
			$('#fechainst').datepicker({
			    autoclose: true,
			    language: 'es',
			    firstDay: 1
			});
			$('#FechaContratoEnviado').datepicker({
			    autoclose: true,
			    language: 'es',
			    firstDay: 1
			});
		
			$('#fechaenviocontratocorregidofinalCO').datepicker({
			    autoclose: true,
			    language: 'es',
			    firstDay: 1
			});			

			$('#fechagestiondocCO').datepicker({
			    autoclose: true,
			    language: 'es',
			    firstDay: 1
			});
					
			//Date picker
			$('#horainst').timepicker({
			    defaultTime: false,
			    showInputs: true,
			    minuteStep: 1
			});
			
			$('#mesano').datepicker({
			    autoclose: true,
			    language: 'en',
			    firstDay: 1,
			    format: 'M-yyyy',
			    viewMode: "years",
			    minViewMode: "months"
			
			});
			
			$('#logcambios').click(function() {
			    refresh();
			}); 

                                                                               $('#logcambios_cert').click(function () {
                                                                                    refresh_cert();
                                                                                });    
			//Scoring
			$('.select2full').select2({
			    selectOnClose: true
			});
			
			$(document).on('keydown', '.select2', function(e) {
			    if (e.originalEvent && e.which == 40) {
			        e.preventDefault();
			        $(this).siblings('select').select2('open');
			    }
			});
			
			$(document).on("select2:close", '.select2-hidden-accessible', function() {
			    $(this).focus();
			});

			$('#contratoenviado').change(function() {
			    if ($(this).val()=='SI') {
			        $('.contratoenviado').removeClass('hidden');
			    } else {
			        $('.contratoenviado').addClass('hidden');
			    }
			});
			$('#contratocorrecto').change(function() {
			    if ($(this).val()=='NO') {
			        $('#motivoincidenciaCO').show();
			        $('.contratocorrecto').removeClass('hidden');
			    } else {
			        $('#motivoincidenciaCO').hide();
			        $('.contratocorrecto').addClass('hidden');
			    }
			});
			$('#pagoenviadoCO').change(function() {
			    if ($(this).val()=='SIN PAGO') {
			        $('#montoCO').val('0.00');
			    }
			});			
			
		</script>
		<!-- DOCUMENT READY -->
		<script>
			$(document).ready(function() {
			
			    bloquear('<?php echo $estadoventa; ?>');
			    bloquearxCategoria('<?php echo $categoriaventa; ?>');
			
			    bloquearxRecurso('<?php echo $tipoventa; ?>');
			    $('#lblresultadoScoring').val($('#valresultadoScoring').val());
			    $('#lbltipocamarakit').val($('#valtipocamarakit').val());
			
			    //Fire it when the page first loads:
			    alterClass();
			
			    //SCORING
			    cargardepartamento();
			
			    //LISTAR CATEGORIAS DE PRECIO
			
			    //const resultadoScoring = $('#valresultadoScoring').val();
			
			        const scoring = $('#lblresultadoScoring').val();
			        const tipokit = $('#lbltipokit').val();
			        const PAI = $('#lblPAI').val();
			        
			        if(scoring == '' || scoring == null || tipokit == '' ||  tipokit == null ||  PAI == '' ||  PAI == null){
			            return;
			        } else {
			            categoriaPrecio(scoring, tipokit, PAI);
			            $('#lblcategoriaprecio').val($('#hidCategoriaPrecio').val());
			            if ($('#hidPrecioKit').val() != '') {
			                $('#lblpreciokit').val($('#hidPrecioKit').val());
                            $('#precioKit__MIN').val($('#hidPrecioKit').val());			                
			            }                    
			            closingPack();
			            $('#lblclosingpack').val($('#valclosingpack').val());   
			        }
			        //GUARDAR DATOS EN LOS ARREGLOS GLOBALES
			        
			        //ARREGLO GENERAL
			        if($('#datosGeneral').val() != ''){
			            arregloGeneral = JSON.parse($('#datosGeneral').val());
			        }
			        if($('#datosRegalos').val() != ''){
			            arregloRegalos = JSON.parse($('#datosRegalos').val());
			        }
			        if($('#datosExtras').val() != ''){
			            arregloDatos = JSON.parse($('#datosExtras').val());
			        }
			        
			        //AGREGAR FUNCION DE OCULTAR ARLO
			        if(tipokit=='Camara' || tipokit=='High Security'){
			            $('.camaraarlo').removeClass('ocultar');
			            //PARA REGALO DE SMARTHUB NO ACTIVO
			            $('#cboRegalo option[value="113"]').hide();
			            $('#cboRegalo option[value="113"]').prop('disabled',true);                    
			        }
			        
			
			        //ARREGLO GENERAL AUDITORIA
			        if($('#datosFalloSupervision').val() != ''){
			            arregloDatosFalloSupervision = JSON.parse($('#datosFalloSupervision').val());
			            generarHtmlFalloSupervision();
			        }
			        if($('#datosTamper').val() != ''){
			            arregloDatosTamper = JSON.parse($('#datosTamper').val());
			            generarHtmlTamper();
			        }   
			
			});
		</script> 
		<!-- CARRITO DE COMPRAS -->
		<script>
			//Evento que identifica cuando un extra es modificado
			$('#cboProducto').on('change', function(){
			    const Producto = $('#cboProducto option:selected').val();
			    const tipokit = $('#lbltipokit').val();
			    //CODIGO USADO PARA REMOVER EL PRECIO DE REFERENCIA ENTRE PARENTESIS PARA OBTENER EL NOMBRE DEL PRODUCTO
			    const txtProducto = $('#cboProducto option:selected').text().split(' (', 1)[0];
			    $('#hidProducto').val(txtProducto);
			    
			    $('#cboTipoPrecio').val('').trigger('change');
			    
			    $("#cboTipoPrecio option[value='PrimeraUnidad']").remove();
			    $("#cboTipoPrecio option[value='SegundaUnidadKitZV']").remove();
			    
			    //NUEVO CATEGORIA ITEM 20220601 CAMARA ARLO Y N1
			    $("#cboTipoPrecio option[value='Camaraton']").remove();
			    
			    //NUEVO CATEGORIA ITEM 20220817 OPDI Y PACKSENSE
			    $("#cboTipoPrecio option[value='PrecioEspecial']").remove();
			    
			    if(Producto == 70){
			        $('#cboTipoPrecio').append($("<option>", {
			            value: 'PrimeraUnidad',
			            text: 'PRIMERA UNIDAD'
			        }));
			    }
			    
			    if(tipokit == 'ZeroVision'){
			        if(Producto == 84){
			            $('#cboTipoPrecio').append($("<option>", {
			                value: 'SegundaUnidadKitZV',
			                text: 'SEGUNDA UNIDAD KIT ZEROVISION'
			            }));
			        }
			    }
			//NUEVO CATEGORIA ITEM 20220601 CAMARA ARLO Y N1
			    if(Producto ==111){
			        $('#cboTipoPrecio').append($("<option>", {
			            value: 'Camaraton',
			            text: 'CAMARATÓN'
			        }));
			    }
			    if(Producto == 110){
			        $('#cboTipoPrecio').append($("<option>", {
			            value: 'Camaraton',
			            text: 'CAMARATÓN'
			        }));
			    }
			    if(Producto ==82){
			        $('#cboTipoPrecio').append($("<option>", {
			            value: 'Camaraton',
			            text: 'CAMARATÓN'
			        }));
			    }
			    //OPDI
			    if(Producto ==80){
			        $('#cboTipoPrecio').prepend($("<option>", {
			            value: 'PrecioEspecial',
			            text: 'PRECIO ESPECIAL'
			        }));
			    }
			    //PACK SENSE
			    if(Producto ==131){
			        $('#cboTipoPrecio').prepend($("<option>", {
			            value: 'PrecioEspecial',
			            text: 'PRECIO ESPECIAL'
			        }));
			    }                
			    
			    
			})
			
			
			$('#lblcategoriaprecio').on('change', function(){ 
    			var tipoventa = '<?php echo $tipoventa; ?>'; 
    			if(tipoventa=="RE" || tipoventa=="REGGCC"){
    			    $(".mostrarEtiqueta").removeClass("hidden");
    			}else{ 
    			    if($('#lblcategoriaprecio').val()=="RENOVE" || $('#lblcategoriaprecio').val()=="EXCEPCION RENOVE" || $('#lblcategoriaprecio').val()=="SUPER OFERTA RENOVE" || $('#lblcategoriaprecio').val()=="OFERTA RECARGADA RENOVE" || $('#lblcategoriaprecio').val()=="PRECIO ULTRA RENOVE" || $('#lblcategoriaprecio').val()=="OFERTA RECARGADA RENOVE" || $('#lblcategoriaprecio').val()=="PRECIO ULTRA RENOVE" || $('#lblcategoriaprecio').val()=="RENOVE POWER"){
    			 
    			        $(".mostrarEtiqueta").removeClass("hidden");
    			        $("#lblDescuentoCuota option[value='4meses']").show();
    			    }else{
    			        
    			        $(".mostrarEtiqueta").addClass("hidden");
    			        $("#lblDescuentoCuota option[value='4meses']").hide();
    			    }
    			}
			})
			
			
			$('#cboTipoPrecio').on('change', function(){
			    //RESETEAR VARIABLES DE CANTIDAD
			    $('#cantidadProductos').val('');
			    $('#cantidadProductos').prop('disabled', false);
			    //RESETEAR VARIABLES DE PRECIO
			    $('#precioUnitario').val('');
			    $('#precioUnitario').prop('disabled', false);
			    
			    const Producto = $('#cboProducto option:selected').val();
			    const TipoPrecio = $('#cboTipoPrecio option:selected').val();
			    
			    var data = {Producto : Producto};
			    
			    fetch('ajax/selectListarExtrasField.php', {method: 'POST', body: JSON.stringify(data)})
			        .then(function(res) {
			            return res.json();
			        })
			        .then(function(datos) {
			            
			            const {IdItem, Item, Precio, CuotaMes} = datos;
			            
			            let precioTotal, descuento, precioMax;
			            
			            //SI EL PRODUCTO ES UN MANDO
			            if(Producto == '70'){
			                if(TipoPrecio == 'catalogo'){
			                    descuento = 1.00;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*1
			                } else if(TipoPrecio == 'medio') {
			                    Swal.fire(
			                      'Alerta!',
			                      'Precio no autorizado',
			                      'warning'
			                    );
			                    $('#cboTipoPrecio').val('');
			                    return;
			                    descuento = 0.75;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*1
			                } else if(TipoPrecio == 'autorizado') {
			                    Swal.fire(
			                      'Alerta!',
			                      'Precio no autorizado',
			                      'warning'
			                    );
			                    $('#cboTipoPrecio').val('');
			                    return;
			                    descuento = 0.50;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*0.75;
			                } else if(TipoPrecio == 'PrimeraUnidad'){
			                    precioTotal = 49;
			                    
			                    $('#cantidadProductos').val(1);
			                    $('#precioUnitario').prop('disabled', true);
			                    $('#cantidadProductos').prop('disabled', true);
			                }
			            } else if(Producto == '75'){
			                if(TipoPrecio == 'catalogo'){
			                    descuento = 1.00;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*1
			                } else if(TipoPrecio == 'medio') {
			                    Swal.fire(
			                      'Alerta!',
			                      'Precio no autorizado',
			                      'warning'
			                    );
			                    $('#cboTipoPrecio').val('');
			                    return;
			                    descuento = 0.75;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*1
			                } else if(TipoPrecio == 'autorizado') {
			                    Swal.fire(
			                      'Alerta!',
			                      'Precio no autorizado',
			                      'warning'
			                    );
			                    $('#cboTipoPrecio').val('');
			                    return;
			                    descuento = 0.50;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*0.75;
			                }
			            }else if(Producto == '84'){
			                if(TipoPrecio == 'catalogo'){
			                    descuento = 1.00;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*1
			                } else if(TipoPrecio == 'medio') {
			                    descuento = 0.75;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*1
			                } else if(TipoPrecio == 'autorizado') {
			                    descuento = 0.50;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*0.75;
			                } else if(TipoPrecio == 'SegundaUnidadKitZV'){
			                    precioTotal = 400;
			                    $('#cantidadProductos').val(1);
			                    $('#precioUnitario').prop('disabled', true);
			                    $('#cantidadProductos').prop('disabled', true);
			                }
			            } // si el producto es llave
			            else if (Producto == '68') {
			                if(TipoPrecio == 'catalogo'){
			                    descuento = 1.00;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*1
			                } else if(TipoPrecio == 'medio') {
			                    descuento = 0.75;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*1
			                } else if(TipoPrecio == 'autorizado') {
			                    precioTotal =  15.50;
			                    precioMax = Precio*0.75;
			                }
			            } else if(Producto == '85'){
			                if(TipoPrecio == 'catalogo'){ //PACK DOBLE PROTECCION
			                    descuento = 1.00;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*1
			                } else if(TipoPrecio == 'medio') {
			                    //descuento = 0.75;
			                    precioTotal =  299;
			                    precioMax = Precio*1
			                } else if(TipoPrecio == 'autorizado') {
			                    descuento = 0.50;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*0.75;
			                }
			            } else if(Producto == '86'){
			                if(TipoPrecio == 'catalogo'){ //PACK DOBLE PROTECCION
			                    descuento = 1.00;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*1
			                } else if(TipoPrecio == 'medio') {
			                    //descuento = 0.75;
			                    precioTotal =  449;
			                    precioMax = Precio*1
			                } else if(TipoPrecio == 'autorizado') {
			                    descuento = 0.50;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*0.75;
			                }
			            } else if(Producto == '87'){
			                if(TipoPrecio == 'catalogo'){ //PACK DOBLE PROTECCION
			                    descuento = 1.00;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*1
			                } else if(TipoPrecio == 'medio') {
			                    //descuento = 0.75;
			                    precioTotal =  799;
			                    precioMax = Precio*1
			                } else if(TipoPrecio == 'autorizado') {
			                    descuento = 0.50;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*0.75;
			                }
			            }
			            else if(Producto == '88'){
			                if(TipoPrecio == 'catalogo'){ //PACK DOBLE PROTECCION
			                    descuento = 1.00;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*1
			                } else if(TipoPrecio == 'medio') {
			                    //descuento = 0.75;
			                    precioTotal =  549;
			                    precioMax = Precio*1
			                } else if(TipoPrecio == 'autorizado') {
			                    descuento = 0.50;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*0.75;
			                }
			            }
			            else if(Producto == '89'){
			                if(TipoPrecio == 'catalogo'){ //PACK DOBLE PROTECCION
			                    descuento = 1.00;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*1
			                } else if(TipoPrecio == 'medio') {
			                    //descuento = 0.75;
			                    precioTotal =  1399;
			                    precioMax = Precio*1
			                } else if(TipoPrecio == 'autorizado') {
			                    descuento = 0.50;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*0.75;
			                }
			            }
			            else if(Producto == '90'){
			                if(TipoPrecio == 'catalogo'){ //PACK DOBLE PROTECCION
			                    descuento = 1.00;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*1
			                } else if(TipoPrecio == 'medio') {
			                    //descuento = 0.75;
			                    precioTotal =  1399;
			                    precioMax = Precio*1
			                } else if(TipoPrecio == 'autorizado') {
			                    descuento = 0.50;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*0.75;
			                }
			            }
			            else if(Producto == '91'){
			                if(TipoPrecio == 'catalogo'){ //PACK DOBLE PROTECCION
			                    descuento = 1.00;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*1
			                } else if(TipoPrecio == 'medio') {
			                    //descuento = 0.75;
			                    precioTotal =  1499;
			                    precioMax = Precio*1
			                } else if(TipoPrecio == 'autorizado') {
			                    descuento = 0.50;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*0.75;
			                }
			            }
			            //CAMARATON
			            else if(Producto == '110' || Producto =='111' || Producto =='82'){
			                if(TipoPrecio == 'catalogo'){
			                    descuento = 1.00;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*1
			                } else if(TipoPrecio == 'medio') {
			                    Swal.fire(
			                      'Alerta!',
			                      'Precio no autorizado',
			                      'warning'
			                    );
			                    $('#cboTipoPrecio').val('');
			                    return;
			                    descuento = 0.75;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*1
			                } else if(TipoPrecio == 'autorizado') {
			                    Swal.fire(
			                      'Alerta!',
			                      'Precio no autorizado',
			                      'warning'
			                    );
			                    $('#cboTipoPrecio').val('');
			                    return;
			                    descuento = 0.50;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*0.75;
			                } else if(TipoPrecio == 'Camaraton'){
			                    precioTotal = 250;
			                    $('#cantidadProductos').val(1);
			                    $('#precioUnitario').prop('disabled', true);
			                }                            
			            }      
			            else if(Producto == '80'){
			                if(TipoPrecio == 'catalogo'){
			                    descuento = 1.00;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*1
			                } else if(TipoPrecio == 'medio') {
			                    Swal.fire(
			                      'Alerta!',
			                      'Precio no autorizado',
			                      'warning'
			                    );
			                    $('#cboTipoPrecio').val('');
			                    return;
			                    descuento = 0.75;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*1
			                } else if(TipoPrecio == 'autorizado') {
			                    Swal.fire(
			                      'Alerta!',
			                      'Precio no autorizado',
			                      'warning'
			                    );
			                    $('#cboTipoPrecio').val('');
			                    return;
			                    descuento = 0.50;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*0.75;
			                } else if(TipoPrecio == 'PrecioEspecial'){
			                    precioTotal = 299;
			                    $('#cantidadProductos').val(1);
			                    $('#precioUnitario').prop('disabled', true);
			                }                                
			            }
			            else if(Producto =='131'){
			                if(TipoPrecio == 'catalogo'){
			                    descuento = 1.00;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*1
			                } else if(TipoPrecio == 'medio') {
			                    Swal.fire(
			                      'Alerta!',
			                      'Precio no autorizado',
			                      'warning'
			                    );
			                    $('#cboTipoPrecio').val('');
			                    return;
			                    descuento = 0.75;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*1
			                } else if(TipoPrecio == 'autorizado') {
			                    Swal.fire(
			                      'Alerta!',
			                      'Precio no autorizado',
			                      'warning'
			                    );
			                    $('#cboTipoPrecio').val('');
			                    return;
			                    descuento = 0.50;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*0.75;
			                } else if(TipoPrecio == 'PrecioEspecial'){
			                    precioTotal = 399;
			                    $('#cantidadProductos').val(1);
			                    $('#precioUnitario').prop('disabled', true);
			                }                                
			            }                        
			            else {
			                if(TipoPrecio == 'catalogo'){
			                    descuento = 1.00;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*1
			                } else if(TipoPrecio == 'medio') {
			                    descuento = 0.75;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*1
			                } else if(TipoPrecio == 'autorizado') {
			                    descuento = 0.50;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*0.75;
			                } else if(TipoPrecio == 'excepcion') {
			                    descuento = 0.25;
			                    precioTotal =  Precio*descuento;
			                    precioMax = Precio*1.75;
			                }
			            } 
			
			            
			            $('#precioUnitario').val(precioTotal)
			            $('#cuotaMes').val(CuotaMes);
			            
			            $('#precioMin').val(precioTotal);
			            $('#precioMax').val(precioMax);
			            
			
			        })
			    
			})
			
			$('#precioUnitario').on('blur', function(){
			    //alert($('#precioUnitario').val());
			    
			    const precio = parseFloat($(this).val());
			    const TipoPrecio = $('#cboTipoPrecio').val();
			    
			    let max, min;
			    
			    if(TipoPrecio == 'catalogo'){
			        
			        min = parseFloat($('#precioMin').val());
			        max = parseFloat($('#precioMax').val());
			        
			        if(precio < min || precio > max){
			            Swal.fire('Alerta!', `El precio no puede ser menor a ${min} o mayor a ${max}.`, 'warning');
			            $(this).val('');
			        }
			        
			    } else if(TipoPrecio == 'medio') {
			        min = parseFloat($('#precioMin').val());
			        max = parseFloat($('#precioMax').val());
			        
			        if(precio < min || precio >= max){
			            Swal.fire('Alerta!', `El precio no puede ser menor a ${min} o mayor igual a ${max}.`, 'warning');
			            $(this).val('');
			        }
			        
			    } else if(TipoPrecio == 'autorizado') {
			        min = parseFloat($('#precioMin').val());
			        max = parseFloat($('#precioMax').val());
			        
			        if(precio < min || precio >= max){
			            Swal.fire('Alerta!', `El precio no puede ser menor a ${min} o mayor igual a ${max}.`, 'warning');
			            $(this).val('');
			        }
			        
			    } else if(TipoPrecio == 'excepcion') {
			        min = 1;
			        max = parseFloat($('#precioMax').val()) * 3;
			        
			        if(precio < min || precio >= max){
			            Swal.fire('Alerta!', `El precio no puede ser menor a ${min} o mayor igual a ${max}.`, 'warning');
			            $(this).val('');
			        }
			        
			    }
			    
			    
			    
			})
			
			function getRandomInt(min, max) {
			  return Math.floor(Math.random() * (max - min)) + min;
			}
			
			$('#btnAgregar').on('click', function(e){
			    const IdItem = $('#cboProducto').val();
			    const Producto = $('#cboProducto option:selected').val();
			    const Item = $('#hidProducto').val();
			    const TipoPrecio = $('#cboTipoPrecio option:selected').val();
			    const cantidadProductos = $('#cantidadProductos').val();
			    const precioUnitario = $('#precioUnitario').val();
			    const cuotaMes = $('#cuotaMes').val();
			    
			    const datos = {Producto, TipoPrecio, cantidadProductos, precioUnitario};
			    
			    let numAleatorio = getRandomInt(10000, 99999);
			    const dataID = `${Item}-${numAleatorio}`;
			    
			    if(validarProductoUnico(datos)){
			    
			        if(!validarProducto(datos)){
			            Swal.fire(
			              '¡Formulario incompleto!',
			              'Por favor, completar todos los datos',
			              'warning'
			            );
			            return;
			        }
			        
			        let totalProductos, totalCuota;
			        
			        totalProductos = precioUnitario*cantidadProductos;
			        totalCuota = cuotaMes*cantidadProductos;
			        
			      var data = {
			                CodItem: IdItem,
			                Item: Item,
			                TipoPrecio: TipoPrecio,
			                cantidadProductos: cantidadProductos,
			                Precio: precioUnitario,
			                CuotaMes: cuotaMes,
			                totalProductos: totalProductos,
			                totalCuota: totalCuota,
			                dataID: dataID
			            };
			            
			        arregloDatos = [...arregloDatos, data];
			        
			        const datosExtra = {
			                tipo: 'extra',
			                descripcion: Item,
			                dataID: dataID
			            }
			            
			        arregloGeneral = [...arregloGeneral, datosExtra];
			            
			        generarHtml();
			        
			        $('#cboProducto').val('');
			        $('#cboTipoPrecio').val('');
			        $('#cantidadProductos').val('');
			        $('#precioUnitario').val('');
			    } else {
			        Swal.fire(
			          '¡Extra repetido!',
			          'Imposible vender dos extras',
			          'warning'
			        );
			    }
			    
			})
			
			function validarProductoUnico(datos){
			    const {Producto, TipoPrecio} = datos;
			    
			    if (arregloDatos.length > 0){
			        const resultado = arregloDatos.find(elemento => elemento.CodItem === Producto);
			        
			        if(resultado == undefined){
			            return true;
			        } else {
			        
			            if(TipoPrecio == resultado.TipoPrecio){
			                return false;
			            } else {
			                return true;
			            }
			
			        }
			        
			    } else {
			    
			        return true;
			    }
			}
			
			function validarProducto(datos){
			
			    const {Producto, TipoPrecio, cantidadProductos, precioUnitario} = datos;
			  
			    if(Producto == '' || Producto == null){
			        return false;
			    }
			    if(TipoPrecio == '' || TipoPrecio == null){
			        return false;
			    }
			    if(cantidadProductos == '' || cantidadProductos == 0){
			        return false;
			    }
			    if(precioUnitario == '' || precioUnitario == 0 ){
			        return false;
			    }
			    
			    return true;
			}
			
			function generarHtml(){
			    
			    limpiarHTML(listaExtras);
			    
			    let cantidadExtras= 0;
			    let resumen = '';
			    let subtotal = 0;
			    let subtotalCuota = 0;
			    
			    
			    if(arregloDatos.length > 0){
			        arregloDatos.forEach(datos => {
			    
			            
			            const {CodItem, CuotaMes, Item, Precio, TipoPrecio, cantidadProductos,  totalProductos, totalCuota, dataID} = datos;
			            
			            let CuotaMes_Round = parseFloat(CuotaMes);
			            let Precio_Round = parseFloat(Precio);
			            
			            listaExtras.innerHTML += `
			                    <div class="row" style="margin-top: 20px;">
			                        <div class="col-md-12">
			                            <div class="info-box bg-gray">
			                                <p class="info-box-icon" style="width: 50%; font-size: 15px; height: 100px; line-height: 100px; font-weight: bold;">${Item} <button class="btn borrar-extra" data-id="${dataID}" style="color: red; background-color: transparent;">X</button> </p>
			                                <div class="info-box-content" style="text-align: right;">
			                                    <span class="info-box-text">S/. ${Precio_Round} - S/. ${CuotaMes_Round}</span>
			                                    <span class="info-box-text">${cantidadProductos}</span>
			                                    <span class="info-box-number">Total: ${totalProductos}</span>
			                                    <span class="info-box-number">Total cuota: ${totalCuota}</span>
			                                </div>
			                            </div>
			                        </div>
			                    </div>
			                `;
			            
			            let cantidad;
			            
			            cantidad = parseInt(cantidadProductos);
			            cantidadExtras += cantidad;
			            
			            subtotal += totalProductos;
			            subtotalCuota += totalCuota;
			            
			            
			            
			        })
			    }
			    
			    //ALGORITMO PARA GENERAR EL RESUMEN DE INSTALACION PARA EXTRAS
			    arregloGeneral.forEach((elemento, index) => {
			        //Si existe más de un elemento en el arreglo
			        if(arregloGeneral.length > 1){
			            if((arregloGeneral.length -1) == index){
			                resumen += `${elemento.descripcion} (${elemento.tipo})`;
			            } else {
			                resumen += `${elemento.descripcion} (${elemento.tipo}) + `;
			            }
			        } else {
			            resumen += `${elemento.descripcion}`;
			        }
			        
			    })
			    
			    $('#txtResumen').val(resumen);
			            
			    $('#txtCantidadExtra').val(cantidadExtras);
			    
			    $('#txtTotal').val(subtotal);
			    $('#txtTotalCuota').val(subtotalCuota);
			    
			}
			
			function generarHtmlRegalos(){
			    
			    limpiarHTML(listaRegalos);
			    
			    //const resumenventa = $('#lblresumenventa').val();
			    
			    let resumen = '';
			    
			    let cantidadRegalos=0;
			    
			    let subtotal = 0;
			    let subtotalCuota = 0;
			    
			    if(arregloRegalos.length > 0){
			        arregloRegalos.forEach(datos => {
			        
			            const {CodItem, CuotaMes, Item, Precio, cantidad,  totalProductos, totalCuota, dataID} = datos;
			            
			            listaRegalos.innerHTML += `
			                                    <div class="row" style="margin-top: 20px;">
			                                        <div class="col-md-12">
			                                            <div class="info-box bg-gray">
			                                                <p class="info-box-icon" style="width: 50%; font-size: 15px; height: 100px; line-height: 100px; font-weight: bold;">${Item} <button class="btn borrar-regalo" data-id="${dataID}" style="color: red; background-color: transparent;">X</button> </p>
			                                                <div class="info-box-content" style="text-align: right;">
			                                                    <span class="info-box-text"> Cuota - S/. ${CuotaMes}</span>
			                                                    <span class="info-box-text">${cantidad}</span>
			                                                    <span class="info-box-number">Total cuota: ${totalCuota}</span>
			                                                </div>
			                                            </div>
			                                        </div>
			                                    </div>`;
			                                        
			            
			
			            let auxCantProductos = parseInt(cantidad)
			            
			            cantidadRegalos += auxCantProductos;
			            subtotalCuota += totalCuota;
			
			        })
			    }
			    
		
			    //ALGORITMO PARA GENERAR EL RESUMEN DE INSTALACION PARA EXTRAS
			    arregloGeneral.forEach((elemento, index) => {
			        //Si existe más de un elemento en el arreglo, por defecto el index 0 siempre es el KIT
			        if(arregloGeneral.length > 1){
			            if((arregloGeneral.length -1) == index){
			                resumen += `${elemento.descripcion} (${elemento.tipo})`;
			            } else {
			                resumen += `${elemento.descripcion} (${elemento.tipo}) + `;
			            }
			        } else {
			            //SE AGREGA EL TIPO DE KIT
			            resumen += `${elemento.descripcion}`;
			        }
			        
			    })
			    
			    $('#txtResumen__Regalo').val(resumen);
			    $('#txtCantidadRegalo').val(cantidadRegalos);
			    $('#txtTotalCuota__Regalo').val(subtotalCuota);
			    
			}
			
			function limpiarHTML(cont) {
			    //forma recomendada
			    while (cont.firstChild) {
			        cont.removeChild(cont.firstChild);
			    }
			    
			    $('#txtResumen').val('');
			    $('#txtCantidad').val('');
			    $('#txtTotal').val('');
			}
			function validarProductoARLO(datos){
			    var valArloI=0;
			    var valArloE=0;
			    const {Producto} = datos;
			    if(Producto=="113"){
			        if (arregloDatos.length > 0){
			            const resultadoCamaraInternaArlo = arregloDatos.find(elemento => elemento.CodItem == 138);
			            const resultadoCamaraExternaArlo = arregloDatos.find(elemento => elemento.CodItem == 140);
			            
			            if(resultadoCamaraInternaArlo == undefined){
			                valArloI=0;
			            } else {
			              
			                if(resultadoCamaraInternaArlo.TipoPrecio=='catalogo'){
			                    valArloI=1;
			                } else {
			                    valArloI=0;
			                }
			
			            }
			            if(resultadoCamaraExternaArlo == undefined){
			                valArloE=0;
			            } else {
			                if(resultadoCamaraExternaArlo.TipoPrecio=='catalogo'){
			                    valArloE=1;
			                } else {
			                    valArloE=0;
			                }
			
			            }
			        var sumaAR=(valArloI+valArloE);
			        
			          if(sumaAR==0){
			            // return true;
			            return false
			          }else{
			              return false;
			          }
			            
			        }else{
			            // return true;
			            return false
			        }
			      
			    }else{
			        return false;
			    }
			}


			function validarProductoSMARTHUB(){
			    var valArloI=0;
			    var lbltipokit=$('#lbltipokit').val();
		
			        if (arregloDatos.length > 0){
			            
			            const resultadoArloSmartHUB = arregloDatos.find(elemento => elemento.CodItem == 112);
			            
			            const resultadoCamaraArloInterior = arregloDatos.find(elemento => elemento.CodItem == 138);
			            const resultadoCamaraArloExterior = arregloDatos.find(elemento => elemento.CodItem == 140);
			            
			            const resultadoPackCamaraArloInterior= arregloDatos.find(elemento => elemento.CodItem == 142);
			            const resultadoPackCamaraArloExterior = arregloDatos.find(elemento => elemento.CodItem == 143);
			    
			            
			            if(lbltipokit=='Basico PRO' || lbltipokit=='ZeroVision PRO'){
			                valArloI+=1;
			            }
			            
			            if(resultadoCamaraArloInterior !== undefined){
			                valArloI+=resultadoCamaraArloInterior.cantidadProductos;
			                
			            }
			            
			            if(resultadoCamaraArloExterior !== undefined){
			                valArloI+=resultadoCamaraArloExterior.cantidadProductos;
			                
			            }
			            
			            if(resultadoPackCamaraArloInterior !== undefined){
			                valArloI+=2;
			            }
			            if(resultadoPackCamaraArloExterior !== undefined){
			                valArloI+=2;
			            }
			            
    			        if(valArloI>=2){
    			            if(resultadoArloSmartHUB !== undefined){
    			                return false;
    			            }			            
    			          return true;
    			        }else{
    			          return false;
    			        }
			        
			        }else{
			            return false;
			        }			    

			}
			
			//EXTRAS
			$('#generarOferta').on('click', function(e){
			    
			    const txtResumen = $('#txtResumen').val();
			    const txtCantidadExtra = $('#txtCantidadExtra').val();
			    const txtTotal = $('#txtTotal').val();
			    const txtTotalCuota = $('#txtTotalCuota').val();
			    
			    const datos = {
			        arregloDatos,
			        txtResumen,
			        txtCantidadRegalo,
			        txtTotal,
			        txtTotalCuota
			    }
			    
			    //SET DATOS EN EL FORMULARIO
			    $('#lbltotalextra').val(txtTotal);
			    $('#lbltotalcuota').val(txtTotalCuota);
			    $('#lblCantExtras').val(txtCantidadExtra);
			    $('#lblresumenventa').val(txtResumen);
			    
			 //   if(validarProductoSMARTHUB()){

    // 			    Swal.fire({
    // 			        icon: 'warning',
    // 			        title:'¡Recuerda!',
    // 			        text: 'Una instalación con 2 cámaras o más requiere la instalación de ARLO SMART HUB.Agrégalo dentro de la lista de extras',
    // 			        confirmButtonColor: '#e4002b'
    // 			    }).then((result) => {
    			        
    // 			    })
			        
			 //       return;
			 //   }
			    
			    Swal.fire({
			        icon: 'success',
			        text: 'Datos generados correctamente',
			        confirmButtonColor: '#e4002b'
			    }).then((result) => {
			         $('#modal__carritocompras').modal('hide');
			    })
			    
		
			    
			})
			
			$('#generarOferta__Regalo').on('click', function(e){
			    
			    const txtResumen__Regalo = $('#txtResumen__Regalo').val();
			    const txtCantidadRegalo = $('#txtCantidadRegalo').val();
			    const txtTotalCuota__Regalo = parseFloat($('#txtTotalCuota__Regalo').val());
			    let lbltotalcuota = parseFloat($('#lbltotalcuota').val());
			    
			    lbltotalcuota += txtTotalCuota__Regalo;
			    
			    $('#lblresumenventa').val(txtResumen__Regalo);
			    $('#lblCantRegalos').val(txtCantidadRegalo);
			    $('#lbltotalcuota').val(lbltotalcuota);
			    
			    Swal.fire({
			        icon: 'success',
			        text: 'Datos generados correctamente',
			        confirmButtonColor: '#e4002b'
			    }).then((result) => {
			         $('#modal__regalos').modal('hide');
			    })
			})
			
			$('#listaExtras').click(function(e){
			    if (e.target.classList.contains('borrar-extra')) {
			        const dataID = e.target.getAttribute('data-id');
			        
			        //Elimina del arreglo de articulosCarrito por el data-id
			        arregloDatos = arregloDatos.filter(datos => datos.dataID != dataID);
			        arregloGeneral = arregloGeneral.filter(datos => datos.dataID != dataID);
			        
			        generarHtml();
			    
			        
			       swal.fire('Extra eliminado', 'Se elimino el extra correctamente', 'success');
			    }
			})
			
			$('#listaRegalos').click(function(e){
			    if (e.target.classList.contains('borrar-regalo')) {
			        const dataID = e.target.getAttribute('data-id');
			        //Elimina del arreglo de articulosCarrito por el data-id
			        arregloRegalos = arregloRegalos.filter(datos => datos.dataID != dataID);
			        arregloGeneral = arregloGeneral.filter(datos => datos.dataID != dataID);
			        
			        generarHtmlRegalos();
			
			        swal.fire('Regalo eliminado', 'Se elimino el regalo correctamente', 'success');
			    }
			                 
			})
			
			
			
		</script>    
		<!-- EVENTOS CARRITOS DE COMPRAS -->
		<script>
			$('#generarExtras').on('click', function(e){
			    
			    e.preventDefault();
			    
			    if ($('#lbltipokit').val() != '' && $('#lbltipokit').val() != null){
			        generarHtml();
			        $('#modal__carritocompras').modal('show');
			    } else {
			        Swal.fire(
			          'SELECCIONAR KIT',
			          'Por favor seleccionar kit',
			          'warning'
			        );
			    }
			    
			    
			})
			
			$('#generarRegalos').on('click', function(e){
			    e.preventDefault();
			    
			    if ($('#lbltipokit').val() != '' && $('#lbltipokit').val() != null){
			        generarHtmlRegalos();
			        $('#modal__regalos').modal('show');
			        
			    } else {
			        Swal.fire(
			          'SELECCIONAR KIT',
			          'Por favor seleccionar kit',
			          'warning'
			        );
			    }
			    
			})
			
			$('#lblresultadoScoring').on('change', function(){
			    const scoring = $('#lblresultadoScoring').val();
			    const tipokit = $('#lbltipokit').val();
			    const PAI = $('#lblPAI').val();
			    var tipoventa=$('#lbltipoventa').val();
			    if(tipoventa == 'RPPA' || tipoventa == 'RPPR' || tipoventa == 'RPMKT' || tipoventa == 'RPTMK' || tipoventa == 'RP'){
			        /*
			        if(scoring=="Unica"){
			            $('#lblPAI option[value="PAI 30x36"]').hide();
			            $('#lblPAI option[value="PAI 30x36"]').prop('disabled',true);
			        }else{
			            $('#lblPAI option[value="PAI 30x36"]').show();
			            $('#lblPAI option[value="PAI 30x36"]').prop('disabled',false);
			        }
			        */
			    }
			
			    if(scoring == '' || scoring == null || tipokit == '' ||  tipokit == null ||  PAI == '' ||  PAI == null){
			        return;
			    } else {
			        categoriaPrecio(scoring, tipokit, PAI);
			    }
			})
			
			$('#lbltipokit').on('change', async function(){
			    //const resultadoScoring = $('#valresultadoScoring').val();
			    const scoring = $('#lblresultadoScoring').val();
			    const tipokit = $('#lbltipokit').val();
			    const PAI = $('#lblPAI').val();
			    const tipoventa=$('#lbltipoventa').val();
			    
			    const origenvisita=$('#OrigenVisita').val();
			
			    if(tipoventa == 'RPPA' || tipoventa == 'RPPR' || tipoventa == 'RPMKT' || tipoventa == 'RPTMK' || tipoventa == 'RP'){
			        /*
			        if(scoring=="Unica"){
			            $('#lblPAI option[value="PAI 30x36"]').hide();
			            $('#lblPAI option[value="PAI 30x36"]').prop('disabled',true);
			        }else{
			            $('#lblPAI option[value="PAI 30x36"]').show();
			            $('#lblPAI option[value="PAI 30x36"]').prop('disabled',false);
			        }
			        */
			    }
			
			    if(tipokit=='Basico' && (origenvisita=='FB_CAMERA_PROMO_TEST_BBVA_cotizaciones' || origenvisita=='FB_CAMERA_PROMO_TEST_BBVA_m_cotizaciones')){
			         $("#lblDescuentoCuota option[value='2mesesBBVA']").show();
			    }else{
			        $("#lblDescuentoCuota option[value='2mesesBBVA']").hide();
			        $("#lblDescuentoCuota").val("");
			    }
			    
			    if(tipokit=='Basico' && (origenvisita=='FB_CAMERA_PROMO_TEST_OH_cotizaciones' || origenvisita=='FB_CAMERA_PROMO_TEST_OH_m_cotizaciones')){
			         $("#lblDescuentoCuota option[value='2mesesOH']").show();
			    }else{
			        $("#lblDescuentoCuota option[value='2mesesOH']").hide();
			        $("#lblDescuentoCuota").val("");
			    }
			    
			    if(tipokit=='ZeroVision' && (origenvisita=='FB_CAMERA_PROMO_TEST_INTERBANK_cotizaciones' || origenvisita=='FB_CAMERA_PROMO_TEST_INTERBANK_m_cotizaciones')){
			         $("#lblDescuentoCuota option[value='2mesesInterbank']").show();
			    }else{
			        $("#lblDescuentoCuota option[value='2mesesInterbank']").hide();
			        $("#lblDescuentoCuota").val("");
			    }
			    
			    if(tipokit=='ZeroVision' && (origenvisita=='FB_CAMERA_PROMO_TEST_BCP_cotizaciones' || origenvisita=='FB_CAMERA_PROMO_TEST_BCP_m_cotizaciones')){
			         $("#lblDescuentoCuota option[value='2mesesBCP']").show();
			    }else{
			        $("#lblDescuentoCuota option[value='2mesesBCP']").hide();
			        $("#lblDescuentoCuota").val("");
			    }
			    
			
			
			    const validadorZerovision = await validarZeroVisionSegundoDispostivo();
			    
			    
			    if(validadorZerovision){
			        return;
			    }
			    
			    
			    //ALGORITMO QUE GUARDA EL ULTIMO TIPO DE KIT MODIFICADO
			    var data = {
			        tipo: 'kit',
			        descripcion: tipokit
			    };
			    
			  
			    if(arregloGeneral.length > 0){
			        arregloGeneral.some((elemento,index) => {
			            if(elemento.tipo == 'kit'){
			                arregloGeneral.splice(index, 0);
			                
			                arregloGeneral[index] = data;
			            }
			        })
			    } else {
			        arregloGeneral = [...arregloGeneral, data];
			    }
			    //FIN ALGORITMO
			    
			    generarResumenInstalacion();
			    
			    //AGREGAR FUNCION DE OCULTAR ARLO
			    if(tipokit=='Camara' || tipokit=='High Security'){
			        $('.camaraarlo').removeClass('ocultar');
			        //PARA REGALO DE SMARTHUB NO ACTIVO
			        $('#cboRegalo option[value="113"]').hide();
			        $('#cboRegalo option[value="113"]').prop('disabled',true);                    
			    }else{
			        $('.camaraarlo').addClass('ocultar');
			        //PARA REGALO DE SMARTHUB ACTIVO
			        $('#cboRegalo option[value="113"]').show();
			        $('#cboRegalo option[value="113"]').prop('disabled',false);                    
			    }                  
			    
			    if(scoring == '' || scoring == null || tipokit == '' ||  tipokit == null ||  PAI == '' ||  PAI == null){
			        return;
			    } else {
			        categoriaPrecio(scoring, tipokit, PAI);
			    }
			})
			
			async function validarZeroVisionSegundoDispostivo(){
			    //AWAIT QUE ESPERA HASRTA QUE EL FOR TERMINE PARA CONTINUAR LA EJECUCION
			    for await  (const datos of arregloDatos){
		
			        //const contents = await fs.readFile(file, 'utf8');
			        if(datos.Item == 'ZEROVISION'){
			            if(datos.TipoPrecio == 'SegundaUnidadKitZV'){
			                swal.fire('Error', 'No puede modificar el tipo de kit porque existe un extra que requiere el tipo de kit ZEROVISION', 'error');
			                $('#lbltipokit').val('ZeroVision');
			                //generarResumenInstalacion();
			                return true;
			            }
			        }
			        
			    }
			    
			    return false;
			}
			
			$('#lblPAI').on('change', function(){
			    //const resultadoScoring = $('#valresultadoScoring').val();
			    const scoring = $('#lblresultadoScoring').val();
			    const tipokit = $('#lbltipokit').val();
			    const PAI = $('#lblPAI').val();
			    
			    if(scoring == '' || scoring == null || tipokit == '' ||  tipokit == null ||  PAI == '' ||  PAI == null){
			        return;
			    } else {
			        categoriaPrecio(scoring, tipokit, PAI);
			    }
			})
			
			$('#lblcategoriaprecio').on('change', function(){
			    const categoriaPrecio = $('#lblcategoriaprecio').val();
			    
			    if(categoriaPrecio== '' || categoriaPrecio == null){
			        return;
			    } else {
			        $('#hidCategoriaPrecio').val(categoriaPrecio);
			        asignarPrecioKit(categoriaPrecio);
			        if(categoriaPrecio== 'PRECIO SEGUNDA ALARMA'){
			            $('.segundaalarma').removeClass('ocultar');
			        }else{
			            $('.segundaalarma').addClass('ocultar');
			        }
			        
			    }
			})
			
			$('#lbldistrito').on('change', function(){
			    
			    //Limpiar todos los datos
			   $('#lblresultadoScoring').val("");
			   $('#valcodigoOperacionScoring').val("");
			   $('#IdDocRP').val("");
			   $('#NombresScoring').val("");
			   $('#ApellidoPaternoScoring').val("");
			   $('#ApellidoMaternoScoring').val("");
			   $('#TipoDocumentoScoring').val("");
			   $('#lbldocumentoscoring').val("");
			   //$('#lbltipokit').trigger('change');
			   /*
			   $('#lbltitularscoring').val("");
			   $('#lbltipokit').val("");
			   $('#lblPAI').val("");
			   $('#lbltipocamarakit').val("");
			   $('#lblcategoriaprecio').val("");
			   $('#hidCategoriaPrecio').val("");
			   $('#lblpreciokit').val("");
			   $('#precioKit__MIN').val("");
			   $('#precioKit__MAX').val("");
			   $('#hidPrecioKit').val("");
			   $('#lblCantExtras').val("");
			   $('#lbltotalextra').val("");
			   $('#lblclosingpack').val("");
			   $('#valclosingpack').val("");
			   $('#lblresumenventa').val("");
			   $('#lblCantRegalos').val("");
			   $('#lblDescuentoCuota').val("");
			   $('#lbltotalcuota').val("");
			   $('#lblextraautorizado').val("");
			   closingpack = document.getElementById("lblclosingpack");
			   categoriaprecio = document.getElementById("lblcategoriaprecio");
			   limpiarDatos(closingpack);
			   limpiarDatos(categoriaprecio);
			   
			   //ARREGLO DE DATOS QUE CONTIENE LA LISTA DE REGALOS
			   arregloRegalos = [];
			   //ARREGLO DE DATOS QUE CONTIENE LA LISTA DE EXTRAS
			   arregloDatos = [];
			   //ARREGLO GENERAL DE KIT, REGALOS Y EXTRAS
			   arregloGeneral = [];
			   */
			   var idGeografico = $(this).val();
			   
			   var datos = {
			        idGeografico: idGeografico
			    }
			   
			 //  console.log(idGeografico);
			    var url = 'ajax/findSims.php';
			    $.ajax({
			        type: 'POST',
			        url: url,
			        data: datos,
			        success: function(datos) {
			            console.log(datos);
			         //   $('.mensajematricula').html(datos);
			         $("#lblsims").val(datos);
			        }
			    });
			 //   return false;
			})              
			
			$('#lblsegmento').on('change', function(){
			    //Limpiar todos los datos
			   $('#lblresultadoScoring').val("");
			   $('#valcodigoOperacionScoring').val("");
			   $('#IdDocRP').val("");
			   $('#NombresScoring').val("");
			   $('#ApellidoPaternoScoring').val("");
			   $('#ApellidoMaternoScoring').val("");
			   $('#TipoDocumentoScoring').val("");
			   $('#lbldocumentoscoring').val("");
			   //$('#lbltipokit').trigger('change');
			   /*
			   $('#lbltitularscoring').val("");
			   $('#lbltipokit').val("");
			   $('#lblPAI').val("");
			   $('#lbltipocamarakit').val("");
			   $('#lblcategoriaprecio').val("");
			   $('#hidCategoriaPrecio').val("");
			   $('#lblpreciokit').val("");
			   $('#precioKit__MIN').val("");
			   $('#precioKit__MAX').val("");
			   $('#hidPrecioKit').val("");
			   $('#lblCantExtras').val("");
			   $('#lbltotalextra').val("");
			   $('#lblclosingpack').val("");
			   $('#valclosingpack').val("");
			   $('#lblresumenventa').val("");
			   $('#lblCantRegalos').val("");
			   $('#lblDescuentoCuota').val("");
			   $('#lbltotalcuota').val("");
			   $('#lblextraautorizado').val("");
			   closingpack = document.getElementById("lblclosingpack");
			   categoriaprecio = document.getElementById("lblcategoriaprecio");
			   limpiarDatos(closingpack);
			   limpiarDatos(categoriaprecio);
			   
			   //ARREGLO DE DATOS QUE CONTIENE LA LISTA DE REGALOS
			   arregloRegalos = [];
			   //ARREGLO DE DATOS QUE CONTIENE LA LISTA DE EXTRAS
			   arregloDatos = [];
			   //ARREGLO GENERAL DE KIT, REGALOS Y EXTRAS
			   arregloGeneral = [];
			   */
			})            
			
			
			$('#btnAgregar__Regalos').on('click', function(){
			    const regalo = $('#cboRegalo').val();
			    const cantidad = parseInt($('#cantidadProductos__Regalos').val());
			    const datos = {Producto : regalo};
			    
			    if($('#cantidadProductos__Regalos').val() == '' || $('#cantidadProductos__Regalos').val() == null || $('#cantidadProductos__Regalos').val() <= 0) {
			       swal.fire('Error', 'Indicar la cantidad de regalos', 'error');
			       return;
			    }else{
			    if(validarProductoARLO(datos)){
			        swal.fire('Error', 'Verificar que hayas añadido Extra Camara Interna o Externa ARLO a precio catálogo', 'error');
			        return;
			    }   
			    
			    fetch('ajax/selectListarExtrasField.php', {method: 'POST', body: JSON.stringify(datos)})
			        .then(function(res) {
			            return res.json();
			        })
			        .then(function(datos) {
			            
			            
			            
			            const {CodItem, Item, CuotaMes, Precio} = datos;
			            
			            let totalRegalo = Precio*cantidad;
			            let totalCuota = CuotaMes*cantidad;
			            
			            let numAleatorio = getRandomInt(10000, 99999);
			            const dataID = `${Item}-${numAleatorio}`;
			            
			           var data = {
			                    CodItem: CodItem,
			                    Item: Item,
			                    cantidad: cantidad,
			                    Precio: Precio,
			                    CuotaMes: CuotaMes,
			                    totalProductos: totalRegalo,
			                    totalCuota: totalCuota,
			                    dataID: dataID
			                };
			                
			                
			            arregloRegalos = [...arregloRegalos, data];
			            
			            const datosExtra = {
			                tipo: 'regalo',
			                descripcion: Item,
			                dataID: dataID
			            }
			            
			            arregloGeneral = [...arregloGeneral, datosExtra];
			            
			            generarHtmlRegalos();
			        })
			    }
			    
			})
			
			$('#lblpreciokit').on('blur', function(){
			    const precio = parseFloat($('#lblpreciokit').val());
			    const max = parseFloat($('#precioKit__MAX').val());
			    const min = parseFloat($('#precioKit__MIN').val());
			    
			    if(precio > max || precio < min){
			        Swal.fire('Alerta!', 'El precio del kit no se encuentra en el rango, por favor, VERIFICAR', 'warning')
			        $('#lblpreciokit').val('');
			    }
			    
			})
			
			$('#lblclosingpack').on('change', function(){
			    const lblclosingpack = $('#lblclosingpack').val();
			  
			    //ALGORITMO QUE ELIMINA EL CLOSING PACK ESCOGIDO ANTES
			    arregloGeneral.forEach((elemento, index) => {
			       
			        if(elemento.tipo == 'CP'){
			            arregloGeneral.splice(index, 1);
			        }
			    })
			    //FIN ALGORITMO
			    
			    if(lblclosingpack == '' || lblclosingpack == null || lblclosingpack == 'Ninguno'){
			        
			    } else {
			        var data = {
			            tipo: 'CP',
			            descripcion: lblclosingpack
			        };
			        
			        arregloGeneral = [...arregloGeneral, data];
			    }
			    
			    
			    
			    generarResumenInstalacion();
			})
			
			$('#lbltipoventa').on('change', function(){
			
			    //const resultadoScoring = $('#valresultadoScoring').val();
			    const scoring = $('#lblresultadoScoring').val();
			    const tipokit = $('#lbltipokit').val();
			    const PAI = $('#lblPAI').val();
			    var tipoventa=$('#lbltipoventa').val();
			
			    if(tipoventa == 'RPPA' || tipoventa == 'RPPR' || tipoventa == 'RPMKT' || tipoventa == 'RPTMK' || tipoventa == 'RP'){
			        /*
			        if(scoring=="Unica"){
			            $('#lblPAI option[value="PAI 30x36"]').hide();
			            $('#lblPAI option[value="PAI 30x36"]').prop('disabled',true);
			        }else{
			            $('#lblPAI option[value="PAI 30x36"]').show();
			            $('#lblPAI option[value="PAI 30x36"]').prop('disabled',false);
			        }
			        */
			    }                
			    
			    if(scoring == '' || scoring == null || tipokit == '' ||  tipokit == null ||  PAI == '' ||  PAI == null){
			        return;
			    } else {
			        categoriaPrecio(scoring, tipokit, PAI);
			    }
			})
			$('#lblDescuentoCuota').on('change', function(){
			    //const resultadoScoring = $('#valresultadoScoring').val();
			    const DescuentoCuota = $('#lblDescuentoCuota').val();
			    if(DescuentoCuota == '2meses'){
			        $('#lblmesesautorizados').val('2.00');
			    }else if(DescuentoCuota == '3meses'){
			        $('#lblmesesautorizados').val('3.00');
			    }else if(DescuentoCuota == '4meses'){
			        $('#lblmesesautorizados').val('4.00');                    
			    }else if(DescuentoCuota == '1mes'){
			        $('#lblmesesautorizados').val('1.00');
			    }else if(DescuentoCuota == '6meses'){
			        $('#lblmesesautorizados').val('6.00');
			                           
			    }else{
			        $('#lblmesesautorizados').val('0.00');
			    }
			})
			
		</script>    
		<!-- SCORING -->
		<script>
			$("#Departamental").change(function() {
			    $("#Departamental option:selected").each(function() {
			        var Provincial = $(this).val();
			        var datos = {
			            Provincial: Provincial
			        };
			        var provincia = $("#Provincial");
			        var distrito = $("#Distrital");
			        $.ajax({
			            data: datos,
			            url: './ajax/selectProvincial.php',
			            type: 'POST',
			            dataType: 'json',
			            beforeSend: function() {
			                //provincia.prop('disabled', true);
			                //distrito.prop('disabled', true);
			            },
			            success: function(r) {
			                provincia.prop('disabled', false);
			                distrito.prop('disabled', false);
			
			                // Limpiamos el select de Provincia
			                provincia.find('option').remove();
			                provincia.append('<option value="">Seleccione</option>');
			                // Limpiamos el select de Distrito
			                distrito.find('option').remove();
			                distrito.append('<option value="">Seleccione</option>');
			
			                $(r).each(function(i, v) { // indice, valor
			                    provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
			                })
			
			                provincia.prop('disabled', false);
			                distrito.prop('disabled', false);
			            },
			            error: function() {
			                //alert('Ocurrio un error en el servidor ..');
			                provincia.prop('disabled', false);
			                distrito.prop('disabled', false);
			            }
			        });
			
			    });
			});
			
			$("#Provincial").change(function() {
			    $("#Provincial option:selected").each(function() {
			        var Provincial = $(this).val();
			        var datos = {
			            Provincial: Provincial
			        };
			        var provincia = $("#Distrital");
			        $.ajax({
			            data: datos,
			            url: './ajax/selectDistrital.php',
			            type: 'POST',
			            dataType: 'json',
			            beforeSend: function() {
			                //provincia.prop('disabled', true);
			            },
			            success: function(r) {
			                provincia.prop('disabled', false);
			
			                // Limpiamos el select
			                provincia.find('option').remove();
			                provincia.append('<option value="">Seleccione</option>');
			
			                $(r).each(function(i, v) { // indice, valor
			                    provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
			                })
			
			                provincia.prop('disabled', false);
			            },
			            error: function() {
			                //alert('Ocurrio un error en el servidor ..');
			                provincia.find('option').remove();
			                provincia.append('<option value="">Seleccione</option>');
			                provincia.prop('disabled', false);
			            }
			        });
			
			    });
			});
			
			//Validaciones
			//nombres apellido_p apellido_m
			$("#nombres").bind('keypress', function(event) {
			    var regex = new RegExp("^[a-zA-Z ]+$");
			    var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
			    if (!regex.test(key)) {
			        event.preventDefault();
			        return false;
			    }
			});
			
			$("#apellido_p").bind('keypress', function(event) {
			    var regex = new RegExp("^[a-zA-Z ]+$");
			    var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
			    if (!regex.test(key)) {
			        event.preventDefault();
			        return false;
			    }
			});
			$("#apellido_m").bind('keypress', function(event) {
			    var regex = new RegExp("^[a-zA-Z ]+$");
			    var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
			    if (!regex.test(key)) {
			        event.preventDefault();
			        return false;
			    }
			
			});
			
			$("#btnModalconsultascoring").click(function(event) {
			    const modalsegmento=$("#Segmento");
			    const lbltipoventa = $('#lbltipoventa').val();
			    if(lbltipoventa=="RP" || lbltipoventa=="RPPA" || lbltipoventa=="RPPR" || lbltipoventa=="RPMKT" || lbltipoventa=="RPTMK"){
			        $("#Departamental").prop('disabled', true);
			        $("#Provincial").prop('disabled', true);
			        
			    }
			    $("#lblsegmento option:selected").each(function () {
			        var segmento = $(this).val();
			        modalsegmento.val(segmento);
			        modalsegmento.trigger('change');
			    });
			});         
			
			$('#btnScoring').on('click', function() {
			    var divLoading = $('#divLoading');
			    $('#btnScoring').prop('disabled', true);
			
			    divLoading.show();
			    var idventa = '<?php echo $idventa; ?>';
			    var matriculausuario = $('#matriculausuario').val();
			    var nombreusuario = $('#nombreusuario').val();
			    var TipoDocumento = $('#TipoDocumento').val();
			    var Documento = $('#Documento').val();
			    var Departamental = $("#Departamental option:selected").text();
			    var Provincial = $("#Provincial option:selected").text();
			    var Distrital = $("#Distrital option:selected").text();
			    var Ubigeo = $("#Distrital").val();
			    var Segmento=$("#Segmento option:selected").val();
			    var Area = 'COMERCIAL';
			    var valPrecioBomba=$('#valPrecioBomba').val();
			    var recurso = $('#lbltipoventa option:selected').val();
			
			    var datos = {
			        matriculausuario: matriculausuario,
			        nombreusuario: nombreusuario,
			        TipoDocumento: TipoDocumento,
			        Documento: Documento,
			        Departamental: Departamental,
			        Provincial: Provincial,
			        Distrital: Distrital,
			        Ubigeo: Ubigeo,
			        idventa: idventa,
			        Segmento:Segmento,
			        Area: Area,
			        recurso:recurso
			    }
			 
			
			    if (validaFormScoring()) {
			        $.ajax({
			            type: "Post",
			            data: datos,
			            url: "ajax/funciones/soap2_venta_v2.php",
			            dataType: "Json",
			            success: function(data) {
			             
			
			                if (data.tipo == 'exito') {
			                    $('#FechaConsulta').html(data.fecha);
			                    var resultado = data.datos;
			                    var resultadooperacion=data.NodoAccion;
			                    //var resultadooperacion = resultado.respuestaSVC11Type.GrupoCampos.Campo[1].Valor;
			
			                    //$('.TextoAccion').html(resultadooperacion);
			                    if (resultadooperacion == "Generar Visita") {
			                        $('.bg-visita').show();
			                        $('.bg-televenta').hide();
			                        $('.bg-gestion').hide();
			                    } else if (resultadooperacion == "Pasar a base de datos-48 horas" || resultadooperacion == "Pasar a Televenta") {
			                        $('.bg-visita').hide();
			                        $('.bg-televenta').show();
			                        $('.bg-gestion').hide();
			                    } else {
			                        $('.bg-visita').hide();
			                        $('.bg-televenta').hide();
			                        $('.bg-gestion').show();
			                    }
			                    $('#Riesgo').html(resultado.respuestaSVC11Type.Scores.Score.Riesgo + ' Riesgo');
			                    if (resultado.respuestaSVC11Type.Integrante.TipoDocumento == 1) {
			                        $('#NombreCompleto').html(resultado.respuestaSVC11Type.Integrante.ApellidoPaterno + ' ' + resultado.respuestaSVC11Type.Integrante.ApellidoMaterno + ' ' + resultado.respuestaSVC11Type.Integrante.Nombres);
			                        $('#TDocumento').html("DNI:");
			                    } else if (resultado.respuestaSVC11Type.Integrante.TipoDocumento == 6) {
			
			                        if (resultado.respuestaSVC11Type.Integrante.NumeroDocumento.substr(0, 2) == 10 || resultado.respuestaSVC11Type.Integrante.NumeroDocumento.substr(0, 2) == 15 || resultado.respuestaSVC11Type.Integrante.NumeroDocumento.substr(0, 2) == 17) {
			                            $('#NombreCompleto').html(resultado.respuestaSVC11Type.Integrante.ApellidoPaterno + ' ' + resultado.respuestaSVC11Type.Integrante.ApellidoMaterno + ' ' + resultado.respuestaSVC11Type.Integrante.Nombres);
			                        } else {
			                            $('#NombreCompleto').html(resultado.respuestaSVC11Type.Integrante.RazonSocial);
			                        }
			                        $('#TDocumento').html("RUC:");
			                    } else {
			                        $('#NombreCompleto').html(resultado.respuestaSVC11Type.Integrante.ApellidoPaterno + ' ' + resultado.respuestaSVC11Type.Integrante.ApellidoMaterno + ' ' + resultado.respuestaSVC11Type.Integrante.Nombres);
			                        $('#TDocumento').html("CE:");
			                    }
			
			                    $('#NumeroDocumento').html(resultado.respuestaSVC11Type.Integrante.NumeroDocumento);
			                    
			                    //resultadooperacion=data.NodoAccion;
			                    $('.TextoAccion').html(resultadooperacion); 
			                    /*
			                    if(tipoventa=="RE" && valPrecioBomba=="NO"){
			                        $('.TextoAccion').html('Oferta RE');
			                    }else{
			                        $('.TextoAccion').html(resultadooperacion);   
			                    } 
			                    */
			                    $('#Valor').html(resultado.respuestaSVC11Type.Scores.Score.Valor);
			
			                    if(resultadooperacion=="Oferta Limitada"){
			                        $('#lblresultadoScoring').val("Limitada");
			                        $('#valresultadoScoring').val("Limitada");
			                        $('.spandocumentovisita').html('<i class="fa fa-fw fa-times" style="color: red;"></i>');
			                    }else if(resultadooperacion=="Oferta Especial"){
			                        $('#lblresultadoScoring').val("Especial");
			                        $('#valresultadoScoring').val("Especial");
			                        $('.spandocumentovisita').html('<i class="fa fa-fw fa-check-circle" style="color: green;"></i>');
			                    }else if(resultadooperacion=="Oferta Extraordinaria"){
			                        $('#lblresultadoScoring').val("Extraordinaria");
			                        $('#valresultadoScoring').val("Extraordinaria");
			                        $('.spandocumentovisita').html('<i class="fa fa-fw fa-check-circle" style="color: green;"></i>');
			                    }else if(resultadooperacion=="Oferta Unica"){
			                       $('#lblresultadoScoring').val("Unica");
			                       $('#valresultadoScoring').val("Unica");
			                       $('.spandocumentovisita').html('<i class="fa fa-fw fa-times" style="color: red;"></i>');
			                    }else if(resultadooperacion=="Oferta"){
			                       $('#lblresultadoScoring').val("Oferta");
			                       $('#valresultadoScoring').val("Oferta");
			                       $('.spandocumentovisita').html('<i class="fa fa-fw fa-check-circle" style="color: green;"></i>');
			                    }else{
			                        $('#lblresultadoScoring').val("");
			                        $('#valresultadoScoring').val("");
			                    }
			                    $('#lblresultadoScoring').trigger('change');
			                    $('#valcodigoOperacionScoring').val(resultado.respuestaSVC11Type.Header.NumeroOperacion);
			                    
			                    divLoading.hide();
			
			                    $('#ResultadoEquifax').show();
			                    $('#TipoDocumento').prop('disabled', true);
			                    $('#Documento').prop('disabled', true);
			                    $("#Departamental").prop('disabled', true);
			                    $("#Provincial").prop('disabled', true);
			                    $("#Distrital").prop('disabled', true);
			                    $('#btnScoring').hide();
			                    $('#btnScoring').prop('disabled', false);
			                    $('#btnNuevaScoring').show();
			                } else {
			                    divLoading.hide();
			                    alert(data.mensaje);
			                    $('#btnScoring').show();
			                    $('#btnScoring').prop('disabled', false);
			                    $('#btnNuevaScoring').hide();
			                }
			
			
			
			            }
			        })
			
			    } else {
			        divLoading.hide();
			        $('#btnScoring').prop('disabled', false);
			    }
			
			});
			
			$('#btnNuevaScoring').on('click', function() {
			            $('#ResultadoEquifax').hide();
			            $('#TipoDocumento').prop('disabled', false); 
			            $('#Documento').prop('disabled', false); 
			            /*
			            const lbltipoventa = $('#lbltipoventa').val();
			            if(lbltipoventa=="RP" || lbltipoventa=="RPPA" || lbltipoventa=="RPPR" || lbltipoventa=="RPMKT" || lbltipoventa=="RPTMK"){
			                $("#Departamental").prop('disabled', true);
			                $("#Provincial").prop('disabled', true);  
			            }else{
			                $("#Departamental").prop('disabled', false);
			                $("#Provincial").prop('disabled', false);                
			            } 
			            */
			
			            $("#Departamental").prop('disabled', true);
			            $("#Provincial").prop('disabled', true);  
			            
			            $("#Distrital").prop('disabled', false);
			            $('#btnNuevaScoring').hide();
			            $('#btnScoring').show();
			            $('#btnScoring').prop('disabled', false);
			            
			            $('#TipoDocumento').val("1"); 
			            $('#Documento').val("");
			            //$("#Departamental").val("");
			            //$("#Provincial").find('option').remove();
			            //$("#Provincial").append('<option value="">Seleccione</option>');
			            //$("#Distrital").find('option').remove();
			            //$("#Distrital").append('<option value="">Seleccione</option>');
			            //cargardepartamento();
			
			});
			
			$('#modal-logdni').on('shown.bs.modal', function() {
			    var divLoading = $('#divLoading');
			    $('#logconsultadoc').prop('disabled', true);
			    divLoading.show();
			    const contenedor = document.querySelector('#tblVentas tbody');
			    while (contenedor.firstChild) {
			        contenedor.removeChild(contenedor.firstChild);
			    }
			
			    var idventa = '<?php echo $idventa; ?>';
			    const lblsegmento=$('#lblsegmento option:selected').val();
			    const lblIdProvincial=$('#lblIdProvincial').val();
			    const lblCodUbigeoReniec=$('#lblCodUbigeoReniec').val();
			    var datos = {
			        idventa: idventa,
			        lblsegmento:lblsegmento,
			        lblIdProvincial:lblIdProvincial,
			        lblCodUbigeoReniec:lblCodUbigeoReniec
			    }
			 
			    $.ajax({
			        type: "Post",
			        data: datos,
			        url: "ajax/findDataConsultaScoringVenta.php",
			        dataType: "Json",
			        success: function(data) {
			      
			            divLoading.hide();
			            $('#tblVentas').show();
			            if (data.length > 0) {
			
			                for (let [llave, valor] of Object.entries(data)) {
			                    var TipoDoc;
			                    var Nombre = "";
			                    if (valor.TipoDocumento == 1) {
			                        TipoDoc = "DNI";
			                        Nombre = valor.Nombres + " " + valor.ApellidoPaterno + " " + valor.ApellidoMaterno;
			                    } else if (valor.TipoDocumento == 6) {
			                        TipoDoc = "RUC";
			                        Nombre = valor.RazonSocial;
			                    } else {
			                        TipoDoc = "CE";
			                        Nombre = valor.Nombres + " " + valor.ApellidoPaterno + " " + valor.ApellidoMaterno;
			                    }
			                    const row = document.createElement('tr');
			                    row.innerHTML = `   <td class="tblBody text-center"><button type="button" class="btn btn-nuevo btnSeleccionar" id="${valor.Accion+"-"+valor.NumeroOperacion+"-"+valor.Dentromes+"-"+valor.NumeroDocumento+"-"+Nombre}">Seleccionar</button></td>
			                                                    <td class="tblBody text-center">${valor.FechaHoraReg}</td> 
			                                                    <td class="tblBody text-center">${TipoDoc}</td> 
			                                                    <td class="tblBody text-center">${valor.NumeroDocumento}</td>
			                                                    <td class="tblBody text-center">${Nombre}</td>
			                                                    
			                                                `
			                    //Agrega el HTML del carrito en el tbody 
			                    contenedor.appendChild(row);
			                }
			                //Desbloqueo del Boton
			                $('#logconsultadoc').prop('disabled', false);
			                $('.btnSeleccionar').on('click', function() {
			                    var cadena = $(this).attr("id");
			                    var separador = "-", // hay un "-"
			                        arregloDeSubCadenas = cadena.split(separador);
			                    var Accion = arregloDeSubCadenas[0];
			                    var NumeroOperacion = arregloDeSubCadenas[1];
			                    var Dentromes = arregloDeSubCadenas[2];
			                    var NumeroDocumento = arregloDeSubCadenas[3];
			                    var Titular = arregloDeSubCadenas[4];
			                   
			                    if (Dentromes == "NO") {
			                        Swal.fire(
			                            '¡Scoring Desactualizado!',
			                            'Por favor volver a scorear',
			                            'warning'
			                        );
			                    } else {
			                         if(Accion=="Oferta Limitada"){
			                            $('#lblresultadoScoring').val("Limitada");
			                            $('#valresultadoScoring').val("Limitada");
			                            $('.spandocumentovisita').html('<i class="fa fa-fw fa-times" style="color: red;"></i>');
			                        }else if(Accion=="Oferta Especial"){
			                            $('#lblresultadoScoring').val("Especial");
			                            $('#valresultadoScoring').val("Especial");
			                            $('.spandocumentovisita').html('<i class="fa fa-fw fa-check-circle" style="color: green;"></i>');
			                        }else if(Accion=="Oferta Extraordinaria"){
			                            $('#lblresultadoScoring').val("Extraordinaria");
			                            $('#valresultadoScoring').val("Extraordinaria");
			                            $('.spandocumentovisita').html('<i class="fa fa-fw fa-check-circle" style="color: green;"></i>');
			                        }else if(Accion=="Oferta Unica"){
			                           $('#lblresultadoScoring').val("Unica");
			                           $('#valresultadoScoring').val("Unica");
			                           $('.spandocumentovisita').html('<i class="fa fa-fw fa-times" style="color: red;"></i>');
			                        }else if(Accion=="Oferta"){
			                           $('#lblresultadoScoring').val("Oferta");
			                           $('#valresultadoScoring').val("Oferta");
			                           $('.spandocumentovisita').html('<i class="fa fa-fw fa-check-circle" style="color: green;"></i>');
			                        }else{
			                            $('#lblresultadoScoring').val("");
			                            $('#valresultadoScoring').val("");
			                        } 
			                        $('#valcodigoOperacionScoring').val(NumeroOperacion);
			                        $('#lbldocumentoscoring').val(NumeroDocumento);
			                        $('#lbltitularscoring').val(Titular);
			                        $('#lblresultadoScoring').trigger('change');
			
			                        $('#modal-logdni').modal('hide');
			                    }
			                });
			            } else {
			                const row = document.createElement('tr');
			                row.innerHTML = `<td colspan="5" class="tblBody text-center"> No se encontró resultado</td>`
			                //Agrega el HTML del carrito en el tbody 
			                contenedor.appendChild(row);
			                $('#logconsultadoc').prop('disabled', false);
			            }
			        }
			    });
			})
			
// Utiliza document.ready para asegurar que el DOM está completamente cargado

  $('#cambiarNumeroContrato').on('click', function() {
    // Variables
    var divLoading = $('#divLoading');
    var estadoContrato = $('#lblestventa').val();
    var NContrato = $('#lblCambiarContrato').val();
    var NContratoActual = $('#lblncontrato').val();
    var idVentaActual = '<?php echo $idventa; ?>';
    var texto = '';
    var mensaje = '';
    // Mostrar loading y deshabilitar el botón
    divLoading.show();
    $('#lblCambiarContrato').prop('disabled', true);

    // Validaciones
    if (NContrato.trim() == '' || NContrato.length == 0) {
      divLoading.hide();
      $('#lblCambiarContrato').prop('disabled', false);
      Swal.fire(
        '¡NContrato Vacío!',
        'Por favor, ingrese un valor',
        'warning'
      );
    // var texto = '¡NContrato Vacío!';
    // var mensaje = 'Por favor, ingrese un valor';
    } else if (estadoContrato === 'Facturada' || estadoContrato === 'PorFacturar' ) {
      divLoading.hide();
      $('#lblCambiarContrato').prop('disabled', false);
    //   var texto = '¡Contrato bloqueado!';
    //   var mensaje = 'No se puede cambiar el NContrato teniendo como estado venta '+estadoContrato;
      Swal.fire(
        '¡Contrato bloqueado!',
        'No se puede cambiar el NContrato teniendo como estado venta '+estadoContrato,
        'warning'
      );
    } else { 
        // var texto = '¡Importante!';
        // var mensaje = 'Asegurese que el contrato debe estar en infopoint como INI no instalada';
        // Swal.fire(
        //     '¡Importante!',
        //     'Asegurese que el contrato debe estar en infopoint como INI no instalada',
        //     'warning'
        //   );
      // AJAX

      $.ajax({
        type: 'POST',
        url: 'ajax/selectNumeroContrato.php',
        data: {
          NContrato: NContrato,
          idVentaActual:idVentaActual
        },
        dataType: 'json', // 'Json' -> 'json'
        success: function(data) { console.log(data);
          divLoading.hide();
          $('#lblCambiarContrato').prop('disabled', false);

          if (data !== null && data.length > 0 && (data != 'error')) {
              
            // Confirmación con alertify
            alertify.defaults.theme.ok = "btn btn-nuevo";
            alertify.defaults.theme.cancel = "btn btn-danger";

            alertify.confirm('<span style="color:red"><i class="fa fa-warning"></i></span><strong> Verificar que en Infopoint esté como NoInstada (NI)</strong>', '¿Desea cambiar el Número de Contrato ' + data[0].NContrato + '?', function() {
            if (typeof data[0].IdVenta !== 'undefined') {
                var datos = {
			              IdVenta: data[0].IdVenta,  // idVenta que contiene el contrato a cambiar
			              NContrato: NContrato,
			              NContratoActual: NContratoActual,
			              estadoVenta: estadoContrato, // estadoVenta que contiene el contrato a cambiar
			              idVentaActual:idVentaActual,
			              EstadoVenta:data[0].EstadoVenta,
			              IdCliente:data[0].IdCliente,
			              IdClienteActual:data[0].IdClienteActual
			            }
            }else{
                var datos = {
			              IdVenta: data[0].IdVenta, 
			              NContrato: NContrato,
			              NContratoActual: NContratoActual,
			              estadoVenta: estadoContrato,
			              idVentaActual:idVentaActual,
			              EstadoVenta:data[0].EstadoVenta,
			              IdCliente:data[0].IdCliente,
			              IdClienteActual:data[0].IdClienteActual
			            }
            }
            
			
              // AJAX para la actualización
              $.ajax({
                type: 'POST',
                url: 'ajax/updateNumeroContrato.php',
                data: datos, // ¿Dónde se define 'datos'?
                dataType: "json", // 'Json' -> 'json'
                success: function(r) { console.log(r);
                  if (r.respuesta == "exito") {
                    Swal.fire({
                      title: 'Modificado!',
                      text: 'Modificación exitosa',
                      type: 'success'
                    }).then((result) => {
                      if (result.value) {
                        window.location.reload();
                      }
                    });
                  } else {
                    alertify.error("Fallo el servidor");
                  }
                }
              });
            }, function() {
              alertify.error('No se han guardado los cambios');
            }).set({
              transition: 'zoom',
              'labels': {
                ok: '<i class="fa fa-check"></i> Aceptar',
                cancel: '<i class="fa fa-remove"></i> Cancelar'
              }
            //   ,
            //   'onshow': function() {
            //     lastX = window.scrollX;
            //     lastY = window.scrollY;
            //   },
            //   'onfocus': function() {
            //     window.scrollTo(lastX, lastY);
            //   }
            }).show();
          } else {
            // Manejo de resultados no encontrados
            // const row = document.createElement('tr');
            // row.innerHTML = `
            //   <td colspan="5" class="tblBody text-center"> No se encontró resultado</td>
            // `;
            //Agrega el HTML del carrito en el tbody 
            // contenedor.appendChild(row);
             Swal.fire(
                '¡Error al ingresar Número de Contrato!',
                'No se puede cambiar el NContrato',
                'warning'
              );
          }
        }
      });
    }
  });


			
			$('#buscarprospecto').on('click', function() {
			    var divLoading = $('#divLoading');
			    var auxprospecto = "";
			    var rc = $('#lblrc').val();
			    var auxrc = "";
			    if (rc == "mkt") {
			        auxrc = "";
			    } else {
			        auxrc = 'style="display:none"';
			    }
			    divLoading.show();
			    const contenedor = document.querySelector('#tblvisitas tbody');
			
			    while (contenedor.firstChild) {
			        contenedor.removeChild(contenedor.firstChild);
			    }
			    $('#buscarprospecto').prop('disabled', true);
			
			    var NProspecto = $('#lblprospectobuscar').val();
			
			    if (NProspecto.trim() == '' || NProspecto.length == 0) {
			        divLoading.hide();
			        $('#buscarprospecto').prop('disabled', false);
			        Swal.fire(
			            '¡NProspecto Vacio!',
			            'Por favor de ingresar',
			            'warning'
			        );
			    } else {
			        var tipo = 'busquedaRecurso';
			        $.ajax({
			            type: 'POST',
			            url: 'ajax/selectListarVisita.php?tipo=' + tipo,
			            data: {
			                NProspecto: NProspecto
			            },
			            dataType: 'Json',
			            success: function(data) {
			                
			                divLoading.hide();
			                $('#buscarprospecto').prop('disabled', false);
			                if (data !== null || data.length() > 0) {
			                    for (let [llave, valor] of Object.entries(data)) {
			                        auxprospecto = valor.NProspecto;
			                        const row = document.createElement('tr');
			                        row.innerHTML = `   <td class="tblBody text-center"><button type="button" class="btn btn-nuevo btnCambiarRecurso" id="${valor.IdVenta}">Cambiar</button>
			                                                                        <a class="btn btn-default btnVer" id="${valor.IdVenta}" title="Ver" ${auxrc}><i class="fa fa-eye"></i> Ver</a>
			                                                                        </td>
			                                                                        <td class="tblBody text-center">${valor.NProspecto}</td> 
			                                                                        <td class="tblBody text-center">${valor.Cliente}</td> 
			                                                                        <td class="tblBody text-center">${valor.DC}</td>
			                                                                        <td class="tblBody text-center">${valor.N590}</td>
			                                                                        <td class="tblBody text-center">${valor.EstadoVenta}</td>
			                                                                        <td class="tblBody text-center">${valor.TipoVenta}</td>
			                                                                        
			                                                                    `
			                        //Agrega el HTML del carrito en el tbody 
			                        contenedor.appendChild(row);
			                    }
			                    //Desbloqueo del Boton
			                    $('.btnVer').on('click', function() {
			                        var id = $(this).attr("id");
			                        var url = "editarvisita_v5.php?idventa=" + id;
			                        window.open(url, '_blank');
			                    });
			                    $('.btnCambiarRecurso').on('click', function() {
			                        var idventaCambio = $(this).attr("id");
			                        var idventaActual = '<?php echo $idventa; ?>';
			                        var gestor = '<?php echo $matriculausuario; ?>';
			                        
			
			                        var datos = {
			                            idventaCambio: idventaCambio,
			                            idventaActual: idventaActual,
			                            gestor: gestor
			                        }
			                   
			
			
			                        //Algunas variables por default de alertify
			                        alertify.defaults.theme.ok = "btn btn-nuevo";
			                        alertify.defaults.theme.cancel = "btn btn-danger";
			
			                        var lastX, lastY;
			                        alertify.confirm('<span style="color:red"><i class="fa fa-warning"></i></span><strong> ADVERTENCIA</strong>', '¿Desea traspasar la información al Prospecto ' + auxprospecto + '?', function() {
			
			                            $.ajax({
			                                type: 'POST',
			                                url: 'ajax/updateCambioRecurso.php',
			                                data: datos,
			                                dataType: "Json",
			                                success: function(r) {
			                                    if (r.respuesta == "exito") {
			                                        swal.fire({
			                                            title: 'Modificado!',
			                                            text: 'Modificación exitosa',
			                                            type: 'success'
			                                        }).then((result) => {
			                                            if (result.value) {
			                                                window.location.reload();
			                                            }
			                                        })
			                                    } else {
			                                        alertify.error("Fallo el server");
			
			                                    }
			                                }
			                            });
			
			                        }, function() {
			                            alertify.error('No se han guardado los cambios')
			                        }).set({
			                            transition: 'zoom',
			                            'labels': {
			                                ok: '<i class="fa fa-check"></i> Aceptar',
			                                cancel: '<i class="fa fa-remove"></i> Cancelar'
			                            },
			                            'onshow': function() {
			
			                                lastX = window.scrollX;
			                                lastY = window.scrollY;
			                            },
			                            'onfocus': function() {
			                                window.scrollTo(lastX, lastY);
			                            }
			                        }).show();
			
			
			                    });
			                } else {
			                    const row = document.createElement('tr');
			                    row.innerHTML = `<td colspan="5" class="tblBody text-center"> No se encontró resultado</td>`
			                    //Agrega el HTML del carrito en el tbody 
			                    contenedor.appendChild(row);
			
			                }
			
			
			
			            }
			        });
			    }
			});
		</script>
		<!-- BTN GUARDAR -->
		<script>
			$('#btnGuardarEditarVenta').click(function() {
			    var gestor = '<?php echo $matriculausuario; ?>';
			    var catgventa = $('#lblcat').val();
			    var ediventa = '<?php echo $idventa; ?>';
			
			    var lblidcliente = $('#lblidcliente').val();
			    var lblmatricula = $('#lblmatricula').val();
			    var lblidusuario = $('#lblidusuario').val();
			    var lblnombcomercial = $('#lblnombcomercial').val();
			    var lbldc = $('#lbldc').val();
			    var lbljefeventa = $('#lbljefeventa').val();
			    var lblestadoventa = $('#lblestadoventa').val();
			    var lblestventa = $('#lblestventa').val();
			    var lblestvisita = $('#lblestvisita').val();
			    var lbltipoventa = $('#lbltipoventa').val();
			    var lbltiventa = $('#lbltiventa').val();
			    var lblsegmento = $('#lblsegmento').val();
			    var lblmesesautorizados = $('#lblmesesautorizados').val();
			    var lblnprospecto = $('#lblnprospecto').val();
			    var lblnprospectohidden = $('#lblnprospectohidden').val();
			    var lblncontrato = $('#lblncontrato').val();
			    var lblnombcliente = $('#lblnombcliente').val();
			    var lblcorreo = $('#lblcorreo').val();
			    var lbldireccion = $('#lbldireccion').val();
			    var lbldistrito = $('#lbldistrito').val();
			    var lblmovil = $('#lblmovil').val();
			    var lblfijo = $('#lblfijo').val();
			    var lblresultadoScoring = $('#lblresultadoScoring').val();
			    var lbltipokit = $('#lbltipokit').val();
			    var lblCantExtras = $('#lblCantExtras').val();
			    var lblclosingpack = $('#lblclosingpack').val();
			    var lblprecioespecial = $('#lblprecioespecial').val();
			    var lblpreciokit = $('#lblpreciokit').val();
			    var lbltotalextra = $('#lbltotalextra').val();
			    var lblresumenventa = $('#lblresumenventa').val();
			    var lblextraautorizado = $('#lblextraautorizado').val();
			    var lblformadepago = $('#lblformadepago').val();
			    var lbl590 = $('#mesano').val();
			    var lblPAI = $('#lblPAI').val();
			    var hidden_contact = $('#hidden_contact').val();
			    var hidden_ventaconfirmadaco = $('#hidden_ventaconfirmadaco').val();
			    var lblcomentarioco = $('#lblcomentarioco').val();
			    var hidden_HCertificacion = $('#hidden_HCertificacion').val();
			    var lblinstaladox = $('#lblinstaladox').val();
			    var lblidagenda = $('#lblidagenda').val();
			    var lbltecnico = $('#lbltecnico').val();
			    var lblfinstalacion = $('#fechainst').val();
			    var lblhinstalacion = $('#horainst').val();
			    var lblrepercucion = $('#lblrepercucion').val();
			    var lblcomentarioagenda = $('#lblcomentarioagenda').val();
			    var lblinviable = $('#lblinviable').val();
			    var lblcancelado = $('#lblcancelado').val();
			    var valresultadoScoring = $('#valresultadoScoring').val();
			    var valcodigoOperacionScoring = $('#valcodigoOperacionScoring').val();
			    var IdDocRP = $('#IdDocRP').val();
			    var hidGGCC = $('#hidGGCC').val();
			    
			    var hidregalosAutorizados =$('#hidregalosAutorizados').val();
			    var hidclosingpackAutorizados= $('#hidclosingpackAutorizados').val();
			    var hidcategoriaKitAutorizados= $('#hidcategoriaKitAutorizados').val();
			    var hiddescuetocuotaAutorizados= $('#hiddescuetocuotaAutorizados').val();
			    
			    //NUEVOS CAMPOS GENERADOS EL 03082021 PARA EXTRAS Y REGALOS
			    const lblCantRegalos = $('#lblCantRegalos').val();
			    const lbltotalcuota = $('#lbltotalcuota').val();
			    const detalleExtras = JSON.stringify(arregloDatos);
			    const detalleRegalos = JSON.stringify(arregloRegalos);
			    const detalleGeneral = JSON.stringify(arregloGeneral);
			                
			    //NUEVOS CAMPOS GENERADOS PARA LA OFERTA
			    const lblcategoriaprecio = $('#lblcategoriaprecio').val();
			    const lblDescuentoCuota = $('#lblDescuentoCuota').val();
			    const lbltipocamarakit=$('#lbltipocamarakit').val();
			                
			    const lblsegundaalarma=$('#lblsegundaalarma').val();
			    
			    var contratoenviado =$('#contratoenviado').val();
			    var contratocorrecto =$('#contratocorrecto').val();
			    var FechaContratoEnviado=$('#FechaContratoEnviado').val();
			    var pagoenviadoCO=$('#pagoenviadoCO').val();
			    var montoCO=$('#montoCO').val();
			    var motivoincidenciaCO=$('#motivoincidenciaCO').val();
			    var fechaenviocontratocorregidofinalCO=$('#fechaenviocontratocorregidofinalCO').val();
			    var fechagestiondocCO=$('#fechagestiondocCO').val();
			    
			
			    var datos = {
			        gestor: gestor,
			        lblidventa: ediventa,
			        lblcategoria: catgventa,
			        lblidcliente: lblidcliente,
			        lblmatricula: lblmatricula,
			        lblidusuario: lblidusuario,
			        lblnombcomercial: lblnombcomercial,
			        lbldc: lbldc,
			        lbljefeventa: lbljefeventa,
			        lblestadoventa: lblestadoventa,
			        lblestventa: lblestventa,
			        lblestvisita: lblestvisita,
			        lbltipoventa: lbltipoventa,
			        lbltiventa: lbltiventa,
			        lblsegmento: lblsegmento,
			        lblmesesautorizados: lblmesesautorizados,
			        lblnprospecto: lblnprospecto,
			        lblnprospectohidden: lblnprospectohidden,
			        lblncontrato: lblncontrato,
			        lblnombcliente: lblnombcliente,
			        lblcorreo: lblcorreo,
			        lbldireccion: lbldireccion,
			        lbldistrito: lbldistrito,
			        lblmovil: lblmovil,
			        lblfijo: lblfijo,
			        lblresultadoScoring: lblresultadoScoring,
			        lbltipokit: lbltipokit,
			        lblCantExtras: lblCantExtras,
			        lblclosingpack: lblclosingpack,
			        lblprecioespecial: lblprecioespecial,
			        lblpreciokit: lblpreciokit,
			        lbltotalextra: lbltotalextra,
			        lblresumenventa: lblresumenventa,
			        lblextraautorizado: lblextraautorizado,
			        lblformadepago: lblformadepago,
			        lbl590: lbl590,
			        lblPAI: lblPAI,
			        hidden_contact: hidden_contact,
			        hidden_ventaconfirmadaco: hidden_ventaconfirmadaco,
			        lblcomentarioco: lblcomentarioco,
			        hidden_HCertificacion: hidden_HCertificacion,
			        lblinstaladox: lblinstaladox,
			        lblidagenda: lblidagenda,
			        lbltecnico: lbltecnico,
			        lblfinstalacion: lblfinstalacion,
			        lblhinstalacion: lblhinstalacion,
			        lblrepercucion: lblrepercucion,
			        lblcomentarioagenda: lblcomentarioagenda,
			        lblinviable: lblinviable,
			        lblcancelado: lblcancelado,
			        valresultadoScoring: valresultadoScoring,
			        valcodigoOperacionScoring: valcodigoOperacionScoring,
			        IdDocRP: IdDocRP,
			        hidGGCC: hidGGCC,
			        hidregalosAutorizados:hidregalosAutorizados,
			        hidclosingpackAutorizados:hidclosingpackAutorizados,
			        hidcategoriaKitAutorizados:hidcategoriaKitAutorizados,
			        hiddescuetocuotaAutorizados:hiddescuetocuotaAutorizados,
			        lblCantRegalos: lblCantRegalos,
			        lbltotalcuota: lbltotalcuota,
			        detalleExtras: detalleExtras,
			        detalleRegalos: detalleRegalos,
			        lblcategoriaprecio: lblcategoriaprecio,
			        detalleGeneral: detalleGeneral,
			        lblDescuentoCuota: lblDescuentoCuota,
			        lbltipocamarakit:lbltipocamarakit,
			        lblsegundaalarma:lblsegundaalarma,
			        contratoenviado:contratoenviado,
			        contratocorrecto:contratocorrecto,
			        FechaContratoEnviado:FechaContratoEnviado,
			        pagoenviadoCO:pagoenviadoCO,
                    montoCO:montoCO,
                    motivoincidenciaCO:motivoincidenciaCO,
                    fechaenviocontratocorregidofinalCO:fechaenviocontratocorregidofinalCO,
                    fechagestiondocCO:fechagestiondocCO
			    }
			
			    //Algunas variables por default de alertify
			    alertify.defaults.theme.ok = "btn btn-nuevo";
			    alertify.defaults.theme.cancel = "btn btn-danger";
			
			    var lastX, lastY;
			    alertify.confirm('<span style="color:red"><i class="fa fa-warning"></i></span><strong> ADVERTENCIA</strong>', '¿Desea guardar los cambios que ha realizado?', function() {
			        if (validaForm()) {
			            // Primero validará el formulario.
			
			            //var datos = $('#frmEditarVenta').serialize();
			       
			
			            $.ajax({
			                type: 'POST',
			                url: 'ajax/updateVenta_scoring_v2.php',
			                data: datos,
			                success: function(r) {
			                    if (r == 1) {
			                        alertify.success("Modificado con exito");
			                                Swal.fire({
			                                    title: 'Modificado con exito',
			                                    type: 'success',
			                                    showCancelButton: false,
			                                    confirmButtonColor: '#3085d6',
			                                    confirmButtonText: 'OK'
			                                }).then((result) => {
			                                    if (result.isConfirmed) {
			                                        location.reload();
			                                    }
			                                });                                
			                    } else if (r == 0) {
			                        alertify.warning("No se realizo ningun cambio");
			                    } else if (r == 2) {
			                        alertify.warning("Ya existe N° Prospecto");
			                    } else {
			                        alertify.error("Fallo el server");
			
			                    }
			                }
			            });
			
			        }
			    }, function() {
			        alertify.error('No se han guardado los cambios')
			    }).set({
			        transition: 'zoom',
			        'labels': {
			            ok: '<i class="fa fa-check"></i> Aceptar',
			            cancel: '<i class="fa fa-remove"></i> Cancelar'
			        },
			        'onshow': function() {
			
			            lastX = window.scrollX;
			            lastY = window.scrollY;
			        },
			        'onfocus': function() {
			            window.scrollTo(lastX, lastY);
			        }
			    }).show();
			
			
			
			});
			
    	/* CONTRATO FISICO/DIGITAL 18.09.2023 */
//     	$('#btnGuardarEditarVentaContratoFD').click(function() {
// 			    var ediventa = '<?php // echo $idventa; ?>';

// 			    var tipocontrato = $('#tipocontrato').val();
			    
// 			    var autorizadocontratofisico = $('#autorizadocontratofisico').val();
// 			    var lblcomentariocontratofisico = $('#lblcomentariocontratofisico').val();
			    
// 			    var cambioacontratofisico = $('#cambioacontratofisico').val();
// 			    var lblcomentariocontratodigital = $('#lblcomentariocontratodigital').val();
			    
// 			    if (tipocontrato == "FISICO" && autorizadocontratofisico == "") {
// 			        alertify.warning("Por favor ingresar si autoriza el contrato fisico");
// 			        $("#frmEditarVenta #autorizadocontratofisico").focus();
// 			        return false;
// 			    }
			    
// 			    if (tipocontrato == "FISICO" && autorizadocontratofisico == "SI" && lblcomentariocontratofisico == '') {
// 			        alertify.warning("Por favor ingresar comentarios");
// 			        $("#frmEditarVenta #lblcomentariocontratofisico").focus();
// 			        return false;
// 			    }
			    
// 			    if (tipocontrato == "DIGITAL" && cambioacontratofisico == "") {
// 			        alertify.warning("Por favor ingresar si desea cambiar a contrato fisico");
// 			        $("#frmEditarVenta #cambioacontratofisico").focus();
// 			        return false;
// 			    }
			    
// 			    if (tipocontrato == "DIGITAL" && cambioacontratofisico == "SI" && lblcomentariocontratodigital == '') {
// 			        alertify.warning("Por favor ingresar comentarios");
// 			        $("#frmEditarVenta #lblcomentariocontratodigital").focus();
// 			        return false;
// 			    }
			    
// 			    var datos = {
// 			        lblidventa: ediventa,
// 			        tipocontrato: tipocontrato,
// 			        autorizadocontratofisico:autorizadocontratofisico,
// 			        cambioacontratofisico:cambioacontratofisico,
// 			        lblcomentariocontratodigital:lblcomentariocontratodigital,
// 			        lblcomentariocontratofisico:lblcomentariocontratofisico
// 			    }
			
// 			    //Algunas variables por default de alertify
// 			    alertify.defaults.theme.ok = "btn btn-nuevo";
// 			    alertify.defaults.theme.cancel = "btn btn-danger";
			
// 			    var lastX, lastY;
// 			    alertify.confirm('<span style="color:red"><i class="fa fa-warning"></i></span><strong> ADVERTENCIA</strong>', '¿Desea guardar los cambios que ha realizado?', function() {
// 			            //var datos = $('#frmEditarVenta').serialize();
// 			            $.ajax({
// 			                type: 'POST',
// 			                url: 'ajax/updateVentaContratoFD.php',
// 			                data: datos,
// 			                success: function(r) {
// 			                    if (r == 1) {
// 			                        alertify.success("Modificado con exito");
// 			                                Swal.fire({
// 			                                    title: 'Modificado con exito',
// 			                                    type: 'success',
// 			                                    showCancelButton: false,
// 			                                    confirmButtonColor: '#3085d6',
// 			                                    confirmButtonText: 'OK'
// 			                                }).then((result) => {
// 			                                    if (result.isConfirmed) {
// 			                                        location.reload();
// 			                                    }
// 			                                });
// 			                    } else {
// 			                        alertify.error("Sin cambios");
			
// 			                    }
// 			                }
// 			            });
			
			        
// 			    }, function() {
// 			        alertify.error('No se han guardado los cambios')
// 			    }).set({
// 			        transition: 'zoom',
// 			        'labels': {
// 			            ok: '<i class="fa fa-check"></i> Aceptar',
// 			            cancel: '<i class="fa fa-remove"></i> Cancelar'
// 			        },
// 			        'onshow': function() {
			
// 			            lastX = window.scrollX;
// 			            lastY = window.scrollY;
// 			        },
// 			        'onfocus': function() {
// 			            window.scrollTo(lastX, lastY);
// 			        }
// 			    }).show();
// 			});
		
		
		</script>
        <script>
	$('#btnGuardarEditarVentaCoordinadora').click(function() {

			    var ediventa = '<?php echo $idventa; ?>';

			    var lblcomentarioco = $('#lblcomentarioco').val();
			    var contratoenviado =$('#contratoenviado').val();
			    var contratocorrecto =$('#contratocorrecto').val();
			    var FechaContratoEnviado=$('#FechaContratoEnviado').val();
			    var pagoenviadoCO=$('#pagoenviadoCO').val();
			    var montoCO=$('#montoCO').val();
			    var motivoincidenciaCO=$('#motivoincidenciaCO').val();
			    var fechaenviocontratocorregidofinalCO=$('#fechaenviocontratocorregidofinalCO').val();
			    var fechagestiondocCO=$('#fechagestiondocCO').val();
			    
			    var tipocontrato = $('#tipocontrato').val();
			    
			    var autorizadocontratofisico = $('#autorizadocontratofisico').val();
			    var lblcomentariocontratofisico = $('#lblcomentariocontratofisico').val();
			    
			    var cambioacontratofisico = $('#cambioacontratofisico').val();
			    var lblcomentariocontratodigital = $('#lblcomentariocontratodigital').val();
			    
			    if (tipocontrato == "FISICO" && autorizadocontratofisico == "") {
			        alertify.warning("Por favor ingresar si autoriza el contrato fisico");
			        $("#frmEditarVenta #autorizadocontratofisico").focus();
			        return false;
			    }
			    
			    if (tipocontrato == "FISICO" && autorizadocontratofisico == "SI" && lblcomentariocontratofisico == '') {
			        alertify.warning("Por favor ingresar comentarios");
			        $("#frmEditarVenta #lblcomentariocontratofisico").focus();
			        return false;
			    }
			    
			    if (tipocontrato == "DIGITAL" && cambioacontratofisico == "") {
			        alertify.warning("Por favor ingresar si desea cambiar a contrato fisico");
			        $("#frmEditarVenta #cambioacontratofisico").focus();
			        return false;
			    }
			    
			    if (tipocontrato == "DIGITAL" && cambioacontratofisico == "SI" && lblcomentariocontratodigital == '') {
			        alertify.warning("Por favor ingresar comentarios");
			        $("#frmEditarVenta #lblcomentariocontratodigital").focus();
			        return false;
			    }
			    
			    var datos = {
			        lblidventa: ediventa,
			        lblcomentarioco: lblcomentarioco,
			        contratoenviado:contratoenviado,
			        contratocorrecto:contratocorrecto,
			        FechaContratoEnviado:FechaContratoEnviado,
			        pagoenviadoCO:pagoenviadoCO,
                    montoCO:montoCO,
                    motivoincidenciaCO:motivoincidenciaCO,
                    fechaenviocontratocorregidofinalCO:fechaenviocontratocorregidofinalCO,
                    fechagestiondocCO:fechagestiondocCO,
                    tipocontrato: tipocontrato,
			        autorizadocontratofisico:autorizadocontratofisico,
			        cambioacontratofisico:cambioacontratofisico,
			        lblcomentariocontratodigital:lblcomentariocontratodigital,
			        lblcomentariocontratofisico:lblcomentariocontratofisico
			    }
			
			    //Algunas variables por default de alertify
			    alertify.defaults.theme.ok = "btn btn-nuevo";
			    alertify.defaults.theme.cancel = "btn btn-danger";
			
			    var lastX, lastY;
			    alertify.confirm('<span style="color:red"><i class="fa fa-warning"></i></span><strong> ADVERTENCIA</strong>', '¿Desea guardar los cambios que ha realizado?', function() {
			            //var datos = $('#frmEditarVenta').serialize();
			            $.ajax({
			                type: 'POST',
			                url: 'ajax/updateVenta_coordinadora.php',
			                data: datos,
			                success: function(r) { console.log(r);
			                    if (r == 1) {
			                        alertify.success("Modificado con exito");
			                                Swal.fire({
			                                    title: 'Modificado con exito',
			                                    type: 'success',
			                                    showCancelButton: false,
			                                    confirmButtonColor: '#3085d6',
			                                    confirmButtonText: 'OK'
			                                }).then((result) => {
			                                    if (result.isConfirmed) {
			                                        location.reload();
			                                    }
			                                });
			                    } else {
			                        alertify.error("Sin cambios");
			
			                    }
			                }
			            });
			
			        
			    }, function() {
			        alertify.error('No se han guardado los cambios')
			    }).set({
			        transition: 'zoom',
			        'labels': {
			            ok: '<i class="fa fa-check"></i> Aceptar',
			            cancel: '<i class="fa fa-remove"></i> Cancelar'
			        },
			        'onshow': function() {
			
			            lastX = window.scrollX;
			            lastY = window.scrollY;
			        },
			        'onfocus': function() {
			            window.scrollTo(lastX, lastY);
			        }
			    }).show();
			});
		
		
		</script>
		<!-- FUNCIONES -->
		<script>
			function alterClass() {
			    var ww = document.body.clientWidth;
			    if (ww < 767) {
			        $('body').removeClass('sidebar-collapse');
			    } else if (ww >= 768) {
			        $('body').addClass('sidebar-collapse');
			    };
			};
			
			var bloquear = function(condiciones) {
			
			    $('#tinviable').hide();
			    $('#lblinviable').hide();
			    $('#lblinviable').disabled = true;
			    $('#tinviableespacio').hide();
			
			    $('#tcancelado').hide();
			    $('#lblcancelado').hide();
			    $('#lblcancelado').disabled = true;
			    $('#tcanceladoespacio').hide();
			
			
			    if (condiciones == "Inviable") {
			        $('#tinviable').show();
			        $('#lblinviable').show();
			        $('#lblinviable').show();
			        $('#lblinviable').disabled = false;
			        $('#tinviableespacio').show();
			
			    } else if (condiciones == "AgendadaTEC" || condiciones == "InstaladaTEC"  || condiciones == "Instalada" || condiciones == "InstaladaDEL" || condiciones == "NoInstalada" || condiciones == "Incidencia" || condiciones == "IncidenciaGestCorreo" || condiciones == "IncidenciaGestValija" || condiciones == "NoDoc" || condiciones == "DocEnvi" || condiciones == "DocE") {
			        $('#lblcategoria')[0].disabled = true;
			
			    } else if (condiciones == "Facturada") {
			        $('#lblcategoria')[0].disabled = true;
			        $('#frmEditarVenta')[0].disabled = true;
			
			    } else if (condiciones == "Cancelado") {
			        $('#tcancelado').show();
			        $('#lblcancelado').show();
			        $('#lblcancelado').disabled = false;
			        $('#tcanceladoespacio').show();
			
			    } else {
			        $('#tinviable').hide();
			        $('#lblinviable').hide();
			        $('#lblinviable').disabled = true;
			        $('#tinviableespacio').hide();
			
			        $('#tcancelado').hide();
			        $('#lblcancelado').hide();
			        $('#lblcancelado').disabled = true;
			        $('#tcanceladoespacio').hide();
			
			    }
			
			
			
			}
			
			var bloquearxRecurso = function(tipoventa) {
			
			    var catec = '<?php echo $categoriaventa; ?>';
			
			    if (tipoventa == "RE" || tipoventa == "REGGCC") {
			
			        $('#lblmatricula')[0].disabled = true;
			        $('#lbldc')[0].disabled = true;
			        $('#lbljefeventa')[0].disabled = true;
			        if (catec == "Delegacion" || catec == "Online" || catec == "Ficha") {
			            $('#lblestadoventa')[0].disabled = false;
			            $('#lblncontrato')[0].disabled = false;
			
			        } else {
			            $('#lblestadoventa')[0].disabled = true;
			            $('#lblncontrato')[0].disabled = true;
			        }
			
			
			        $('#lblsegmento')[0].disabled = true;
			        $('#lbltipoventa')[0].disabled = true;
			        $('#lblnprospecto')[0].disabled = true;
			        $('#lblnombcliente')[0].disabled = true;
			        $('#lblcorreo')[0].disabled = true;
			        $('#lbldireccion')[0].disabled = true;
			        $('#lbldistrito')[0].disabled = true;
			        $('#lblmovil')[0].disabled = true;
			        $('#lblfijo')[0].disabled = true;
			
			    } else if (tipoventa == "RPTMK" || tipoventa == "RPMKT") {
			        $('#lbltipoventa')[0].disabled = true;
			    } else {
			
			        $('#lblmatricula')[0].disabled = false;
			        $('#lbldc')[0].disabled = false;
			        $('#lbljefeventa')[0].disabled = false;
			        $('#lblestadoventa')[0].disabled = false;
			        $('#lbltipoventa')[0].disabled = false;
			        $('#lblsegmento')[0].disabled = false;
			
			        $('#lblnprospecto')[0].disabled = false;
			        $('#lblncontrato')[0].disabled = false;
			        $('#lblnombcliente')[0].disabled = false;
			        $('#lblcorreo')[0].disabled = false;
			        $('#lbldireccion')[0].disabled = false;
			        $('#lbldistrito')[0].disabled = false;
			        $('#lblmovil')[0].disabled = false;
			        $('#lblfijo')[0].disabled = false;
			
			    }
			
			}
			
			var bloquearxCategoria = function(categoria) {
			
			    if (categoria == "Delegacion") {
			        $('#lblestadoventa')[0].disabled = false;
			        $('#lblncontrato')[0].disabled = false;
			        $('#lblinstaladox')[0].disabled = false;
			        $('#lbltecnico')[0].disabled = false;
			        $('#fechainst')[0].disabled = false;
			        $('#horainst')[0].disabled = false;
			        $('#lblrepercucion')[0].disabled = false;
			        $('#lblcomentarioagenda')[0].disabled = false;
			        $('#lblinviable')[0].disabled = false;
			    } else {
			        $('#lblinstaladox')[0].disabled = true;
			        $('#lbltecnico')[0].disabled = true;
			        $('#fechainst')[0].disabled = true;
			        $('#horainst')[0].disabled = true;
			        $('#lblrepercucion')[0].disabled = true;
			        $('#lblcomentarioagenda')[0].disabled = true;
			        $('#lblinviable')[0].disabled = true;
			    }
			
			}
			
			
			
			
			
			function validaForm() {
			    // Campos de texto
			    if ($("#frmEditarVenta #lblmatricula").val() == "") {
			        alertify.warning("Por favor ingresar la Matricula correspondiente");
			        $("#frmEditarVenta #lblmatricula").focus(); // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
			        return false;
			    }
			    if ($("#frmEditarVenta #lblnombcomercial").val() == "") {
			        alertify.warning("Por favor ingresar la Matricula valida");
			        $("#frmEditarVenta #lblmatricula").focus(); // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
			        return false;
			    }
			    if ($("#frmEditarVenta #lbldc").val() == "" || $("#frmEditarVenta #lbldc").val() == "Seleccione") {
			        alertify.warning("Por favor ingresar CC correcto");
			        $("#frmEditarVenta #lbldc").focus(); // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
			        return false;
			    }
			
			    if ($("#frmEditarVenta #lbljefeventa").val() == "" || $("#frmEditarVenta #lbljefeventa").val() == "No se encontraron resultado") {
			        alertify.warning("Por favor revisar Jefe de Estructura Comercial");
			        $("#frmEditarVenta #lbljefeventa").focus(); // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
			        return false;
			    }
			
			
			    if ($("#frmEditarVenta #lblestadoventa").val() == "Seleccione" || $("#frmEditarVenta #lblestadoventa").val() == "") {
			        alertify.warning("Por favor ingresar Estado de Venta correcto");
			        $("#frmEditarVenta #lblestadoventa").focus();
			        return false;
			    }
			    if ($("#frmEditarVenta #lbltipoventa").val() == "Seleccione") {
			        alertify.warning("Por favor ingresar Recurso correcto");
			        $("#frmEditarVenta #lbltipoventa").focus();
			        return false;
			    }
			    if ($("#frmEditarVenta #lblsegmento").val() == "Seleccione") {
			        alertify.warning("Por favor ingresar Segmento correcto");
			        $("#frmEditarVenta #lblsegmento").focus();
			        return false;
			    }
			    if ($("#frmEditarVenta #lblmesesautorizados").val() == "") {
			        alertify.warning("Por favor ingresar MesAutorizado.Si no tuviese coloque: 0");
			        $("#frmEditarVenta #lblmesesautorizados").focus();
			        return false;
			    }
			
			    if ($("#frmEditarVenta #lblnombcliente").val() == "") {
			        alertify.warning("Por favor ingresar Nombre del Cliente");
			        $("#frmEditarVenta #lblnombcliente").focus();
			        return false;
			    }
			    if ($("#frmEditarVenta #lblcorreo").val() == "" || !/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test($("#frmEditarVenta #lblcorreo").val())) {
			        alertify.warning("Por favor ingresar correo válido");
			        $("#frmEditarVenta #lblcorreo").focus();
			        return false;
			    }
			    if ($("#frmEditarVenta #lbldireccion").val() == "") {
			        alertify.warning("Por favor ingresar la Direccion del Cliente");
			        $("#frmEditarVenta #lbldireccion").focus();
			        return false;
			    }
			
			    if ($("#frmEditarVenta #lbldistrito").val() == "") {
			        alertify.warning("Por favor ingresar Distrito correcto");
			
			        $("#frmEditarVenta #lbldistrito").select2('open');
			        return false;
			    }
			
			
			    if ($("#frmEditarVenta #lblmovil").val() == "") {
			        alertify.warning("Por favor ingresar Telefono, de caso contrario digite: 0");
			        $("#frmEditarVenta #lblmovil").focus();
			        return false;
			    }
			    if ($("#frmEditarVenta #lblpreciokit").val() == "") {
			        alertify.warning("Por favor ingresar Precio del KIT");
			        $("#frmEditarVenta #lblpreciokit").focus();
			        return false;
			    }
			    if ($("#frmEditarVenta #lbltotalextra").val() == "") {
			        alertify.warning("Por favor ingresar Total de Extra, de caso contrario digite: 0");
			        $("#frmEditarVenta #lbltotalextra").focus();
			        return false;
			    }
			
			    if ($("#frmEditarVenta #lblresumenventa").val() == "") {
			        alertify.warning("Por favor ingresar Resumen de Venta");
			        $("#frmEditarVenta #lblresumenventa").focus();
			        return false;
			    }
			    if ($("#frmEditarVenta #lblformadepago").val() == "Seleccione") {
			        alertify.warning("Por favor ingresar Forma de Pago");
			        $("#frmEditarVenta #lblformadepago").focus();
			        return false;
			    }
			    if ($("#frmEditarVenta #mesano").val() == "") {
			        alertify.warning("Por favor ingresar 590");
			        $("#frmEditarVenta #mesano").focus();
			        return false;
			    }
			    if ($("#frmEditarVenta #lblPAI").val() == "Seleccione") {
			        alertify.warning("Por favor ingresar PAI");
			        $("#frmEditarVenta #lblPAI").focus();
			        return false;
			    }
			
			    //NUEVOS CAMPOS
			    
			    if ($("#frmEditarVenta #lbltipokit").val() == "" || $("#frmEditarVenta #lbltipokit").val() == null) {
			        alertify.warning("Por favor ingresar TIPO KIT");
			        $("#frmEditarVenta #lbltipokit").focus();
			        return false;
			    }
			    if ($("#frmEditarVenta #lblCantExtras").val() == "") {
			        alertify.warning("Por favor ingresar CANTIDAD EXTRAS");
			        $("#frmEditarVenta #lblCantExtras").focus();
			        return false;
			    }
			    if ($("#frmEditarVenta #lblclosingpack").val() == "" || $("#frmEditarVenta #lblclosingpack").val() == null) {
			        alertify.warning("Por favor ingresar CLOSING PACK");
			        $("#frmEditarVenta #lblclosingpack").focus();
			        return false;
			    }
			
			    if ($("#frmEditarVenta #lblresultadoScoring").val() == "" || $("#frmEditarVenta #lblresultadoScoring").val() == null) {
			        alertify.warning("Por favor ingresar RESULTADO SCORING");
			        $("#frmEditarVenta #lblresultadoScoring").focus();
			        return false;
			    }
			    if ($("#frmEditarVenta #valcodigoOperacionScoring").val() == "" || $("#frmEditarVenta #valcodigoOperacionScoring").val() == null) {
			        alertify.warning("Por favor seleccionar RESULTADO SCORING, puede ver en CONSULTAS DOC.");
			        $("#frmEditarVenta #lblresultadoScoring").focus();
			        return false;
			    }
			            if($('#lblcategoriaprecio').val() == '' || $('#lblcategoriaprecio').val() == null){
			                alertify.warning("Por favor ingresar categoria precio");
			                    Swal.fire(
			                      '¡Importante!',
			                      'Por favor ingresar categoria precio',
			                      'warning'
			                        );                        
			                $('#lblcategoriaprecio').focus();
			                return false;
			            }        
			    
			    /*
			        if ($("#frmEditarVenta #lblprecioespecial").val() == "" || $("#frmEditarVenta #lblprecioespecial").val() == null) {
			            alertify.warning("Por favor ingresar PRECIO ESPECIAL");
			            $("#frmEditarVenta #lblprecioespecial").focus();
			            return false;
			        }
			        */
			
			    if ($("#lblcat").val() == "Delegacion") {
			
			
			        if ($("#frmEditarVenta #lblinstaladox").val() == "" || $("#frmEditarVenta #lblinstaladox").val() == "Seleccione" || $("#frmEditarVenta #lblinstaladox").val() == "TEC") {
			            alertify.warning("Por favor seleccionar Instaladox: DEL");
			            $("#frmEditarVenta #lblinstaladox").focus();
			            return false;
			        }
			
			
			        if ($("#frmEditarVenta #lbltecnico").val() == "") {
			            alertify.warning("Por favor seleccionar el instalador");
			
			            $("#frmEditarVenta #lbltecnico").select2('open');
			            return false;
			        }
			
			        if ($("#frmEditarVenta #fechainst").val() == "") {
			            alertify.warning("Por favor ingresar Fecha de Instalacion");
			            $("#frmEditarVenta #fechainst").focus();
			            return false;
			        }
			
			
			        if ($("#frmEditarVenta #horainst").val() == "") {
			            alertify.warning("Por favor ingresar Hora de Instalacion");
			            $("#frmEditarVenta #horainst").focus();
			            return false;
			        }
			
			
			
			    }
			
			    return true;
			}
			
			var calcDataTableHeight = function() {
			    return $(window).height() * 65 / 100;
			};
			
			
			function filterFloat(evt, input) {
			    // Backspace = 8, Enter = 13, ‘0′ = 48, ‘9′ = 57, ‘.’ = 46, ‘-’ = 43
			    var key = window.Event ? evt.which : evt.keyCode;
			    var chark = String.fromCharCode(key);
			    var tempValue = input.value + chark;
			    if (key >= 48 && key <= 57) {
			        if (filter(tempValue) === false) {
			            return false;
			        } else {
			            return true;
			        }
			    } else {
			        if (key == 8 || key == 13 || key == 0) {
			            return true;
			        } else if (key == 46) {
			            if (filter(tempValue) === false) {
			                return false;
			            } else {
			                return true;
			            }
			        } else {
			            return false;
			        }
			    }
			}
			
			function filter(__val__) {
			    var preg = /^([0-9]+\.?[0-9]{0,2})$/;
			    if (preg.test(__val__) === true) {
			        return true;
			    } else {
			        return false;
			    }
			
			}
			
			function validaFormScoring() {
			    if ($("#frmEditarVentaScoring #TipoDocumento").val() == "") {
			        alertify.warning("Por favor ingresar Tipo de Documento");
			        $("#frmEditarVentaScoring #lbldireccion").focus();
			        return false;
			    }
			    if ($("#frmEditarVentaScoring #Documento").val() == "") {
			        alertify.warning("Por favor ingresar Número de Documento");
			        $("#frmEditarVentaScoring #Documento").focus();
			        return false;
			    }
			    //NUEVA FUNCION SI SELECCIONA DNI/RUC
			    if ($("#frmEditarVentaScoring #TipoDocumento").val() == "6") {
			        if ($("#frmEditarVentaScoring #Documento").val().length != 11) {
			
			            alertify.warning("Por favor ingresar los 11 digitos del RUC");
			            $("#frmEditarVentaScoring #Documento").focus();
			            return false;
			        }
			
			        if ($("#frmEditarVentaScoring #Documento").val().substr(0, 2) == 10 || $("#frmEditarVentaScoring #Documento").val().substr(0, 2) == 20 || $("#frmEditarVentaScoring #Documento").val().substr(0, 2) == 15 || $("#frmEditarVentaScoring #Documento").val().substr(0, 2) == 17) {
			
			        } else {
			            alertify.warning("Por favor ingresar correctamente el RUC debe comenzar 10 o 20");
			            $("#frmEditarVentaScoring #Documento").focus();
			            return false;
			        }
			
			
			    }
			    if ($("#frmEditarVentaScoring #TipoDocumento").val() == "1") {
			        if ($("#frmEditarVentaScoring #Documento").val().length != 8) {
			            alertify.warning("Por favor ingresar los 8 digitos del DNI");
			            $("#frmEditarVentaScoring #Documento").focus();
			            return false;
			        }
			    }
			    if ($("#frmEditarVentaScoring #TipoDocumento").val() == "3") {
			        if ($("#frmEditarVentaScoring #Documento").val().length == 0) {
			            alertify.warning("Por favor ingresar CE");
			            $("#frmEditarVentaScoring #Documento").focus();
			            return false;
			        }
			    }
			    if ($("#frmEditarVentaScoring #Departamental").val() == "") {
			        alertify.warning("Por favor ingresar Departamento correspondiente");
			        $("#frmEditarVentaScoring #Departamental").focus();
			        return false;
			    }
			    if ($("#frmEditarVentaScoring #Provincial").val() == "") {
			        alertify.warning("Por favor ingresar Pronvincia correspondiente");
			        $("#frmEditarVentaScoring #Provincial").focus();
			        return false;
			    }
			    if ($("#frmEditarVentaScoring #Distrital").val() == "") {
			        alertify.warning("Por favor ingresar Distrito correspondiente");
			        $("#frmEditarVentaScoring #Distrital").focus();
			        return false;
			    }
			
			
			    return true;
			}
			
			function cargardepartamento() {
			    $('#TipoDocumento').val("1");
			    var lblIdProvincial = $("#lblIdProvincial").val();
			    var lblIdDepartamental = $("#lblIdDepartamental").val();
			    var provincia = $("#Departamental");
			    var lblCodUbigeoReniec=$('#lblCodUbigeoReniec').val();
			    
			    $.ajax({
			        url: './ajax/selectDepartamental.php',
			        type: 'POST',
			        dataType: 'json',
			        beforeSend: function() {
			            provincia.prop('disabled', true);
			
			        },
			        success: function(r) {
			            provincia.prop('disabled', false);
			
			            // Limpiamos el select de Provincia
			            provincia.find('option').remove();
			            provincia.append('<option value="">Seleccione</option>');
			
			            $(r).each(function(i, v) { // indice, valor
			                provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
			            })
			            
			            if(lblIdDepartamental==""){
			                $("#Departamental option[value='15']").attr("selected", true);
			            }else{
			                $("#Departamental option[value='"+lblIdDepartamental+"']").attr("selected", true);
			            }
			            //$("#Departamental option[value='15']").attr("selected", true);
			            $("#Departamental option:selected").each(function() {
			                var Provincial = $(this).val();
			                var datos = {
			                    Provincial: Provincial
			                };
			                var provincia = $("#Provincial");
			                var distrito = $("#Distrital");
			                $.ajax({
			                    data: datos,
			                    url: './ajax/selectProvincial.php',
			                    type: 'POST',
			                    dataType: 'json',
			                    beforeSend: function() {
			                        //provincia.prop('disabled', true);
			                        //distrito.prop('disabled', true);
			                    },
			                    success: function(r) {
			                        provincia.prop('disabled', false);
			                        distrito.prop('disabled', false);
			
			                        // Limpiamos el select de Provincia
			                        provincia.find('option').remove();
			                        provincia.append('<option value="">Seleccione</option>');
			                        // Limpiamos el select de Distrito
			                        distrito.find('option').remove();
			                        distrito.append('<option value="">Seleccione</option>');
			
			                        $(r).each(function(i, v) { // indice, valor
			                            provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
			                        })
			                        
			                        if(lblIdProvincial==""){
			                            $("#Provincial option[value='128']").attr("selected", true);
			                        }else{
			                            $("#Provincial option[value='"+lblIdProvincial+"']").attr("selected", true);
			                        }
			                        //$("#Provincial option[value='128']").attr("selected", true);
			                        $("#Provincial option:selected").each(function() {
			                            var Provincial = $(this).val();
			                            var datos = {
			                                Provincial: Provincial
			                            };
			                            var provincia = $("#Distrital");
			                            $.ajax({
			                                data: datos,
			                                url: './ajax/selectDistrital.php',
			                                type: 'POST',
			                                dataType: 'json',
			                                beforeSend: function() {
			                                    //provincia.prop('disabled', true);
			                                },
			                                success: function(r) {
			                                    provincia.prop('disabled', false);
			
			                                    // Limpiamos el select
			                                    provincia.find('option').remove();
			                                    provincia.append('<option value="">Seleccione</option>');
			
			                                    $(r).each(function(i, v) { // indice, valor
			                                        provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
			                                    })
			
			                                    if(!lblCodUbigeoReniec==""){
			                                        $("#Distrital option[value='"+lblCodUbigeoReniec+"']").attr("selected", true);
			                                    }                                            
			
			                                    
			                                    provincia.trigger('change');
			
			                                    provincia.prop('disabled', false);
			                                },
			                                error: function() {
			                                    //alert('Ocurrio un error en el servidor ..');
			                                    provincia.find('option').remove();
			                                    provincia.append('<option value="">Seleccione</option>');
			                                    provincia.prop('disabled', false);
			                                }
			                            });
			
			                        });
			                        provincia.prop('disabled', false);
			                        distrito.prop('disabled', false);
			                    },
			                    error: function() {
			                        //alert('Ocurrio un error en el servidor ..');
			                        provincia.prop('disabled', false);
			                        distrito.prop('disabled', false);
			                    }
			                });
			
			            });
			            //provincia.trigger('change');
			
			
			            provincia.prop('disabled', false);
			
			        },
			        error: function() {
			            //alert('Ocurrio un error en el servidor ..');
			            provincia.prop('disabled', false);
			        }
			    });
			
			}
		</script>
		<!-- MODAL CAMBIO VENTA -->
		<script>
			$('#btnCambiarVenta').on('click', function() {
			    $('#modal_cambio_venta').modal('show');
			});
			
			$('#btnCambiarNumeroContrato').on('click', function() {
			    $('#modal_cambio_numero_contrato').modal('show');
			});
		</script>
		<!-- SCRIPT FUNCIONES CARRITO DE COMPRA -->
		<script>
			const dc = $('#lbldc').val();
			
			const option = document.createElement("option");
			
			let arregloCategorias;
			//GENERA LAS OPCIONES DEL SELECT DE TIPO DE KIT DE ACUERDO A LA DELEGACION Y SEGMENTO
			// DEPRECATED
			function tipoKit(){
			const segmento = $('#lblsegmento').val();
			const tipokit = document.getElementById("lbltipokit");
			
			limpiarDatos(tipokit)
			
			if(segmento == 'RES'){
			    //ARBOL DE DESICIONES PARA ZEROVISION
			    
			    if(dc == '150' || dc == '151' || dc == '120' || dc=='154' || dc=='156' || dc=='157'){
			        let arragloKit = ['Basico', 'ZeroVision'];
			        cargarDatosKit(tipokit, arragloKit);
			    }else if(dc=='155' || dc== '153' || dc == '152' || dc=='158' || dc=='159'){
			        let arragloKit = ['Basico', 'ZeroVision'];
			        cargarDatosKit(tipokit, arragloKit);
			    } else {
			        let arragloKit = ['Basico', 'Premium','ZeroVision'];
			        cargarDatosKit(tipokit, arragloKit);
			    }
			    
			    //ARBOL DE DESICIONES SIN ZEROVISION
			    /*
			    let arragloKit = ['Basico', 'Premium'];
			    cargarDatosKit(tipokit, arragloKit);
			    */
			}
			else if (segmento == 'NEG'){
			    //ARBOL DE DESICIONES PARA ZEROVISION
			    
			    if(dc == '150' || dc == '151' || dc == '120' || dc=='154' || dc=='156' || dc=='157'){
			        let arragloKit = ['Basico', 'ZeroVision'];
			        cargarDatosKit(tipokit, arragloKit);
			    }
			    else if (dc=='155' || dc== '153' || dc == '152' || dc=='158' || dc=='159'){
			        let arragloKit = ['Basico', 'ZeroVision'];
			        cargarDatosKit(tipokit, arragloKit);
			    } else {
			        let arragloKit = ['Basico', 'Premium', 'ZeroVision'];
			        cargarDatosKit(tipokit, arragloKit);
			    }
			    //ARBOL DE DESICIONES SIN ZEROVISION
			    /*
			    let arragloKit = ['Basico', 'Premium'];
			    cargarDatosKit(tipokit, arragloKit);
			    */
			}
			}
			
			function cargarDatosKit(tipokit, arragloKit){
			for (value in arragloKit) {
			    let option = document.createElement("option");
			    option.value = arragloKit[value];
			    option.text = arragloKit[value];
			    tipokit.add(option);
			}
			}
			
			function closingPack(){
			const lblcategoriaprecio = $('#hidCategoriaPrecio').val();
			const hidclosingpackAutorizados=$('#hidclosingpackAutorizados').val();
			
			const lbltipokit = $('#lbltipokit').val();
			closingpack = document.getElementById("lblclosingpack");
			
			
			const dc=$('#lbldc').val();
			const segmento = $('#lblsegmento').val();
			
			limpiarDatos(closingpack);
			
			if(dc==155 || dc == 153 || dc==200){

    			if(lbltipokit == 'Camara' || lbltipokit == 'High Security' || lbltipokit == 'ZeroVision PRO' || lbltipokit == 'Basico PRO'){
    			
    			    if(lblcategoriaprecio == 'MEGA SUPERVENTA' || lblcategoriaprecio == 'SUPERVENTA' || lblcategoriaprecio == 'PRECIO ALTO' || lblcategoriaprecio == 'PRECIO MEDIO'){
                        if(segmento=='RES'){
        			        let arregloValueClosingPack = ['Ninguno', '1Magnetico'];
        			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);                            
                        }else{
        			        let arregloValueClosingPack = ['Ninguno', '1Pulsador'];
        			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);                            
                        }

    			    } 
    			    else if(hidclosingpackAutorizados=="SI"){
    			        let arregloValueClosingPack = ['Ninguno', '1FOTO','1MG+1FOTO'];
    			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);                    
    			    }                    
    			    else {
    			        let arregloValueClosingPack = ['Ninguno'];
    			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
    			    }
    			}
    			else if(lbltipokit == 'ZeroVision'){
    			
    			    if(lblcategoriaprecio == 'MEGA SUPERVENTA' || lblcategoriaprecio == 'SUPERVENTA' || lblcategoriaprecio == 'PRECIO ALTO' || lblcategoriaprecio == 'PRECIO MEDIO' ){
    			        let arregloValueClosingPack = ['Ninguno', '3Magnetico', '2Magnetico', '1Magnetico', '1MG+1FOTO', '1FOTO'];
    			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
    			    } 
    			    else if(hidclosingpackAutorizados=="SI"){
    			        let arregloValueClosingPack = ['Ninguno', '3Magnetico', '2Magnetico', '1Magnetico', '1MG+1FOTO', '1FOTO', '2FOTO' , '3FOTO'];
    			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);                    
    			    }                    
    			    else {
    			        let arregloValueClosingPack = ['Ninguno'];
    			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
    			    }
    			}    			
    			else if(hidclosingpackAutorizados=="SI"){
    			    let arregloValueClosingPack = ['Ninguno', '3Magnetico', '2Magnetico', '1Magnetico', '1MG+1FOTO', '1FOTO','1MagneticoUpgrade'];
    			    cargarDatosClosingPack(closingpack, arregloValueClosingPack);                    
    			}
    			else {
    			    let arregloValueClosingPack = ['Ninguno'];
    			    cargarDatosClosingPack(closingpack, arregloValueClosingPack);
    			}				
			
			}else if(dc==154 || dc==158 || dc == 151 || dc == 152  || dc == 150 || dc == 156 || dc == 157 || dc == 159 || dc == 251 || dc == 252 || dc==513 || dc == 701 || dc == 702 || dc == 601 || dc == 602 || dc == 901 || dc == 130 || dc == 230  || dc == 500 || dc == 513 || dc == 60){

    			if(lbltipokit == 'Camara' || lbltipokit == 'High Security' || lbltipokit == 'ZeroVision PRO' || lbltipokit == 'Basico PRO' || lbltipokit == 'ZeroVision PRO LA CURACAO' || lbltipokit == 'Basico PRO LA CURACAO'){
    			
    			    if(lblcategoriaprecio == 'MEGA SUPERVENTA' || lblcategoriaprecio == 'SUPERVENTA' || lblcategoriaprecio == 'PRECIO ALTO' || lblcategoriaprecio == 'PRECIO MEDIO'){
                        if(segmento=='RES'){
        			        let arregloValueClosingPack = ['Ninguno', '1Magnetico'];
        			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);                            
                        }else{
        			        let arregloValueClosingPack = ['Ninguno', '1Pulsador'];
        			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);                            
                        }
    			    } 
    			    else if(hidclosingpackAutorizados=="SI"){
    			        let arregloValueClosingPack = ['Ninguno', '2Magnetico', '1Magnetico', '1FOTO', '1MG+2FOTO','1MG+1FOTO'];
    			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);                    
    			    }                    
    			    else {
    			        let arregloValueClosingPack = ['Ninguno'];
    			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
    			    }
    			}
    			else if(lbltipokit == 'ZeroVision'){
    			    if(lblcategoriaprecio == 'MEGA SUPERVENTA' || lblcategoriaprecio == 'SUPERVENTA' || lblcategoriaprecio == 'PRECIO ALTO' || lblcategoriaprecio == 'PRECIO MEDIO' ){
    			        let arregloValueClosingPack = ['Ninguno', '3Magnetico', '2Magnetico', '1Magnetico', '1MG+1FOTO', '1FOTO'];
    			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
    			    } 
    			    else if(hidclosingpackAutorizados=="SI"){
    			        let arregloValueClosingPack = ['Ninguno', '3Magnetico', '2Magnetico', '1Magnetico', '1MG+1FOTO', '1FOTO', '2FOTO', '3FOTO'];
    			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);                    
    			    }                    
    			    else {
    			        let arregloValueClosingPack = ['Ninguno'];
    			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
    			    }
    			}    			
    			else if(hidclosingpackAutorizados=="SI"){
    			    let arregloValueClosingPack = ['Ninguno', '2Magnetico', '1Magnetico', '1FOTO','1MG+1FOTO', '2FOTO','3FOTO'];
    			    cargarDatosClosingPack(closingpack, arregloValueClosingPack);                    
    			}
    			else {
    			    let arregloValueClosingPack = ['Ninguno'];
    			    cargarDatosClosingPack(closingpack, arregloValueClosingPack);
    			}			    
			    
			}else{

    			if(lbltipokit == 'ZeroVision' || lbltipokit == 'Camara' || lbltipokit == 'High Security'){
    			
    			    if(lblcategoriaprecio == 'MEGA SUPERVENTA' || lblcategoriaprecio == 'SUPERVENTA' || lblcategoriaprecio == 'PRECIO ALTO' || lblcategoriaprecio == 'PRECIO MEDIO' ){
    			        let arregloValueClosingPack = ['Ninguno', '3Magnetico', '2Magnetico', '1Magnetico', '1MG+1FOTO', '1FOTO'];
    			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
    			    } 
    			    else if(hidclosingpackAutorizados=="SI"){
    			        let arregloValueClosingPack = ['Ninguno', '3Magnetico', '2Magnetico', '1Magnetico', '1MG+1FOTO', '1FOTO', '2FOTO', '3FOTO'];
    			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);                    
    			    }                    
    			    else {
    			        let arregloValueClosingPack = ['Ninguno'];
    			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
    			    }
    			}
    			else if(hidclosingpackAutorizados=="SI"){
    			    let arregloValueClosingPack = ['Ninguno', '3Magnetico', '2Magnetico', '1Magnetico', '1MG+1FOTO', '1FOTO','1MagneticoUpgrade','2FOTO','3FOTO'];
    			    cargarDatosClosingPack(closingpack, arregloValueClosingPack);                    
    			}
    			else {
    			    let arregloValueClosingPack = ['Ninguno'];
    			    cargarDatosClosingPack(closingpack, arregloValueClosingPack);
    			}
			    
			}
			

			}
			//END DEPRECATED            
			function cargarDatosClosingPack(closingpack, arregloClosingPack){
			for (value in arregloClosingPack) {
			    var option = document.createElement("option");
			    option.value = arregloClosingPack[value];
			    option.text = arregloClosingPack[value];
			    closingpack.add(option);
			}
			}
			
			function categoriaPrecio(scoring, tipokit, PAI){
			const dc=$('#lbldc').val();
			var uri;
			if(dc == "150" || dc == "154" || dc == "158" || dc == "151" || dc == "152" || dc == "153" || dc == "155" || dc == "156" || dc == "157" || dc == "159" || dc == "251" || dc == "252" || dc=="513" || dc=="121" || dc=="100" || dc == 701 || dc == 702 || dc == 601 || dc == 602 || dc == 901 || dc == 130 || dc == 230 || dc == 500 || dc == 513 || dc == 60){
			    //Carrito Kits Pro - Nuevos funciones
			 uri="ajax/selectListarCategoriaPrecio_v2.php"; 
			}else{
			    //Actual Carrito
			 uri="ajax/selectListarCategoriaPrecio.php";
			    
			}
			const categoriaPrecio = document.getElementById("lblcategoriaprecio");
			const hidCategoriaPrecio=$('#hidCategoriaPrecio').val();
			limpiarDatos(categoriaPrecio);
			$('#lblpreciokit').val('');
			limpiarDatos(lblclosingpack);
			 
			const tipoventa = $('#lbltipoventa option:selected').val();
		
			
			if(scoring == 'Unica'){
			    scoring = 0;
			}else if(scoring == 'Limitada'){
			    scoring = 1;
			}else if(scoring == 'Oferta'){
			    scoring = 2;
			}else if(scoring == 'Especial'){
			    scoring = 3;
			}else if(scoring == 'Extraordinaria'){
			    scoring = 4;                     
			}else {
			    scoring = "NA";
			}
			
			const datos = {
			     tipoventa,
			     tipokit,
			     PAI,
			     scoring,
			     hidCategoriaPrecio
			}
			
		
			
			$.ajax({
			     type: 'POST',
			     data: datos,
			     url: uri,
			     dataType: 'JSON',
			     success: function(data){
			         
			        
			         
			         if(data.respuesta == 'exito'){
			
			             cargarDatosCategoria(data.datos);
			             
			             arregloCategorias = data.datos;
			         }
			     }
			})
			}
			
			function cargarDatosCategoria(datos){
		
			
			const categoriaPrecio = document.getElementById("lblcategoriaprecio");
			
			datos.forEach(elemento => {
			    const {Categoria, PrecioMinimo, PrecioMaximo} = elemento;
			    const option = document.createElement("option");
			    
			    option.value = Categoria;
			    option.text = `${Categoria} (S/. ${PrecioMinimo})`;
			    categoriaPrecio.add(option);
			})
			
			//AÑADIR OPCION DE GRANDES CUENTAS
			if($('#hidGGCC').val() == 'SI'){
			    //alert('Grandes Cuentas');
			    const option = document.createElement("option");
			    
			    option.value = 'GGCC';
			    option.text = 'GRANDES CUENTAS';
			    categoriaPrecio.add(option);
			}
			
			//AÑADIR OPCION DE GRANDES CUENTAS
			if(perfilUsuario==1 || MatriculaUsuario=='EL8532' || MatriculaUsuario=='MB5169' || MatriculaUsuario=='Q04220' || MatriculaUsuario=='Q19368'){
			    //alert('Grandes Cuentas');
			    const option = document.createElement("option");
			    const option2 = document.createElement("option");
			    
			    option.value = 'EXCEPCION';
			    option.text = 'EXCEPCION';
			    categoriaPrecio.add(option);
			    
			    option2.value = 'EXCEPCION RENOVE';
			    option2.text = 'EXCEPCION RENOVE';
			    categoriaPrecio.add(option2);
			}
			
			
			
			//SET EL VALOR DE LA CATEGORIA GUARDADO PREVIAMENTE
			if($('#hidCategoriaPrecio').val() != ''){
			    $('#lblcategoriaprecio').val($('#hidCategoriaPrecio').val());
			}
			if($('#hidPrecioKit').val() != ''){
			    $('#lblpreciokit').val($('#hidPrecioKit').val());
			}
			closingPack();
			$('#lblclosingpack').val($('#valclosingpack').val());
			}
			
			function asignarPrecioKit(categoriaPrecio){
			
			const lbltipoventa = $('#lbltipoventa').val();
			
			closingPack();
			
			if(categoriaPrecio == 'GGCC'){
			    $('#lblpreciokit').val('');
			    $('#precioKit__MIN').val(0);
			    $('#precioKit__MAX').val(99999);
			} else {
			
			    const datosCategoriaSeleccionada = arregloCategorias.filter(function(element){
			      return element.Categoria == categoriaPrecio;
			    });
			    
			    $('#lblpreciokit').val(datosCategoriaSeleccionada[0].PrecioMinimo);
			    $('#precioKit__MIN').val(datosCategoriaSeleccionada[0].PrecioMinimo);
			    $('#precioKit__MAX').val(datosCategoriaSeleccionada[0].PrecioMaximo);
			    
			    if(datosCategoriaSeleccionada[0].ClosingPack == 'SI'){
			        closingPack();
			    }
			}
			}
			
			function limpiarDatos(select){
			while(select.children.length > 1){
			    select.lastChild.remove();
			    
			    select.value = '';
			    
			}
			}
			
			function generarResumenInstalacion(){
			
			/*
			const lblresumenventa = $('#lblresumenventa').val();
			let nuevoResumen;
			
			if(lblresumenventa.indexOf('ZeroVision') !== -1){
			    nuevoResumen = lblresumenventa.replace('ZeroVision', 'Basico');
			} else {
			    nuevoResumen = lblresumenventa.replace('Basico', 'ZeroVision');
			}
			$('#lblresumenventa').val(nuevoResumen);
			*/
			
			let resumen = '';
			
			//ALGORITMO PARA GENERAR EL RESUMEN DE INSTALACION PARA EXTRAS
			arregloGeneral.forEach((elemento, index) => {
			    //Si existe más de un elemento en el arreglo, por defecto el index 0 siempre es el KIT
			    if(arregloGeneral.length > 1){
			        if((arregloGeneral.length -1) == index){
			            resumen += `${elemento.descripcion} (${elemento.tipo})`;
			        } else {
			            resumen += `${elemento.descripcion} (${elemento.tipo}) + `;
			        }
			    } else {
			        //SE AGREGA EL TIPO DE KIT
			        resumen += `${elemento.descripcion}`;
			    }
			    
			})
			
			$('#lblresumenventa').val(resumen);
			
			}
		</script>
		<script>
			const data = [{
			        id: 'DEVOLUCION A COMERCIAL POR INCIDENCIA',
			        text: 'DEVOLUCION A COMERCIAL POR INCIDENCIA'
			    },
			    {
			        id: 'ENVIADO A FACTURACION',
			        text: 'ENVIADO A FACTURACION'
			    },
			    {
			        id: 'DESMONTADO',
			        text: 'DESMONTADO'
			    },
			    {
			        id: 'POR DESMONTAR',
			        text: 'POR DESMONTAR'
			    },
			    {
			        id: 'NO DOC',
			        text: 'NO DOC'
			    },
			 //   {
			 //       id: 'CERTIFICACION SOLUCIONADA',
			 //       text: 'CERTIFICACION SOLUCIONADA'
			 //   },
			 //   {
			 //       id: 'LEGAL SOLICIONADA',
			 //       text: 'LEGAL SOLICIONADA'
			 //   },
			    {
			        id: 'CONTRATO EN BUZON',
			        text: 'CONTRATO EN BUZON'
			    },
,
			    {
			        id: 'CONTRATO DIGITAL ENVIADO',
			        text: 'CONTRATO DIGITAL ENVIADO'
			    },
,
			    {
			        id: 'CONTRATO DIGITAL PENDIENTE',
			        text: 'CONTRATO DIGITAL PENDIENTE'
			    },
			    {
			        id: 'INCIDENCIA GESTIONADA',
			        text: 'INCIDENCIA GESTIONADA'
			    }			    
			];
			$(".selectcomentarioco").select2({
			    placeholder: 'SELECCIONE',
			    allowClear: true,
			    data: data
			})
			const data2 = [{
			        id: 'ENMENDADURA',
			        text: 'ENMENDADURA'
			    },
			    {
			        id: 'FORMATO INCORRECTO',
			        text: 'FORMATO INCORRECTO'
			    },
			    {
			        id: 'REHACER CONTRATO-ERROR DATOS',
			        text: 'REHACER CONTRATO-ERROR DATOS'
			    },
			    {
			        id: 'LLENADO INCOMPLETO',
			        text: 'LLENADO INCOMPLETO'
			    },
			    {
			        id: 'REHACER GUIA-ERROR DATOS',
			        text: 'REHACER GUIA-ERROR DATOS'
			    },
			    {
			        id: 'DOC INCOMPLETA',
			        text: 'DOC INCOMPLETA'
			    },
			    {
			        id: 'NO VENDIDA',
			        text: 'NO VENDIDA'
			    },
			    {
			        id: 'FALTA FIRMA',
			        text: 'FALTA FIRMA'
			    },
			    {
			        id: 'FIRMA EN EL DOC ES RUBRICA',
			        text: 'FIRMA EN EL DOC ES RUBRICA'
			    },
			    {
			        id: 'DOCUMENTO BORROSO',
			        text: 'DOCUMENTO BORROSO'
			    },
			    {
			        id: 'FIRMA DIFIERE',
			        text: 'FIRMA DIFIERE'
			    },
			    {
			        id: 'DNI NO LEGIBLE',
			        text: 'DNI NO LEGIBLE'
			    }
			];
			$(".selectmotivoincidenciaco").select2({
			    placeholder: 'SELECCIONE',
			    allowClear: true,
			    data: data2
			})
			
		</script>
		<script>
			$('#btnenviarcorreoafiliar').click(function(e){
			    const correo=$('#lblcorreo').val();
			    $('#InputCorreo').val(correo);
			    var nombcliente=getCleanedString($('#lblnombcliente').val().trim());
			      
			});
			
			$('#ModEnviar').click(function(e){
			    var arrayNombre;
			    const correo=$('#InputCorreo').val();
			    var contrato=$('#lblncontrato').val();
			    var nombcliente=getCleanedString($('#lblnombcliente').val().trim());
			    arrayNombre=nombcliente.split(' ');
			    var NombresScoring=getCleanedString($('#NombresScoring').val());
			    var ApellidoPaternoScoring=getCleanedString($('#ApellidoPaternoScoring').val());
			    var ApellidoMaternoScoring=getCleanedString($('#ApellidoMaternoScoring').val());
			    var TipoDocumentoScoring=$('#TipoDocumentoScoring').val();
			    var DocumentoScoring=$('#lbldocumentoscoring').val();
			    if(TipoDocumentoScoring==6 || TipoDocumentoScoring==""){
			        TipoDocumentoScoring="0";
			        DocumentoScoring="00000000";
			        if(arrayNombre.length==1){
			            NombresScoring=arrayNombre[0];
			            ApellidoPaternoScoring=" ";
			            ApellidoMaternoScoring=" ";                    
			        }else if(arrayNombre.length==2){
			            NombresScoring=arrayNombre[0];
			            ApellidoPaternoScoring=arrayNombre[1];
			            ApellidoMaternoScoring=" ";   
			        }else{
			            NombresScoring=arrayNombre[0];
			            ApellidoPaternoScoring=arrayNombre[1];
			            ApellidoMaternoScoring=arrayNombre[2];
			        }                    
			    }else if(TipoDocumentoScoring==3){
			        TipoDocumentoScoring=1;
			        DocumentoScoring=DocumentoScoring.substring(3);
			    }else{
			        TipoDocumentoScoring=0;
			        DocumentoScoring=DocumentoScoring.substring(3);
			    }
			    
			
			    var url;
			    var nombrecompleto;
			    if (correo == "" || !/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test(correo)) {
			        Swal.fire({
			        type: 'warning',
			        title: '¡Advertencia!',
			        text: 'Verificar el correo a enviar la afiliacion',
			        })
			    }else if(correo.split('@')[1].toLowerCase()=="verisure.pe"){
			        Swal.fire({
			        type: 'warning',
			        title: '¡Advertencia!',
			        text: 'Ingresar diferente al dominio de correo: @verisure.pe',
			        })
			     
			    }else{
			
			        nombrecompleto=NombresScoring+" "+ApellidoPaternoScoring+" "+ApellidoMaternoScoring;
			        url="https://clientesverisure.com/apps/afiliacion/"+contrato+"/"+NombresScoring+"/"+ApellidoPaternoScoring+" "+ApellidoMaternoScoring+"/"+DocumentoScoring+"/"+TipoDocumentoScoring+"/"+correo;
			        var datos = {
			             correo:correo,
			             contrato:contrato,
			             nombrecompleto:encodeURIComponent(nombrecompleto),
			             url:encodeURIComponent(url)
			         }
			        $.ajax({
			            type: 'POST',
			            url: 'ajax/correoenvioAfiliacion.php',
			            data: datos,
			            dataType: "Json",
			            success: function(r) {
			
			              
			
			                if (r.respuesta == "exito") {
			                        swal.fire({
			                            title: 'Enviado!',
			                            text: 'El mensaje ha sido enviado exitosamente',
			                            type: 'success'
			                        });
			
			                } else {
			                        swal.fire({
			                            title: 'Error!',
			                            text: 'Ha ocurrido un erro en el envio,intentalo más tarde',
			                            type: 'error'
			                        });
			                }
			                $('#modal-enviarcorreoafiliar').modal('hide');                            
			            }
			        });
			    }             
			
			});
			
			function getCleanedString(cadena){
			// Definimos los caracteres que queremos eliminar
			var specialChars = "!@#$^&%*()+=-[]\/{}|:<>?,.";
			
			// Los eliminamos todos
			for (var i = 0; i < specialChars.length; i++) {
			   cadena= cadena.replace(new RegExp("\\" + specialChars[i], 'gi'), '');
			}   
			
			// Lo queremos devolver limpio en minusculas
			cadena = cadena.toLowerCase();
			
			// Quitamos acentos y "ñ". Fijate en que va sin comillas el primer parametro
			cadena = cadena.replace(/á/gi,"a");
			cadena = cadena.replace(/é/gi,"e");
			cadena = cadena.replace(/í/gi,"i");
			cadena = cadena.replace(/ó/gi,"o");
			cadena = cadena.replace(/ú/gi,"u");
			cadena = cadena.replace(/ñ/gi,"n");
			
			cadena = cadena.toUpperCase();
			
			return cadena;
			}            
			
		</script>
		<!--AUDITORIA-->
		<script>
			$('#datossbn').bootstrapToggle({
			        on: 'SI',
			        off: 'NO',
			        onstyle: 'danger',
			        offstyle: 'success'
			    });
			
			    $('#datossbn').change(function() {
			        if ($(this).prop('checked')) {
			            $('#hidden_datossbn').val('SI');
			            $('#lblfechacorrecion_datossbn').prop("disabled", false);
			            $('.datossbn').removeClass('ocultar');
			            
			        } else {
			            $('#hidden_datossbn').val('NO');
			            $('#lblfechacorrecion_datossbn').prop("disabled", true);
			            $('.datossbn').addClass('ocultar');
			            
			        }
			            
			    });
			
			
			    $('#segincorrecto').change(function() {
			        if ($(this).prop('checked')) {
			            $('#hidden_segincorrecto').val('SI');
			            $('.segcorrecion').removeClass('ocultar');
			            $('#lblfechacorrecion_segincorrecto').prop("disabled", false);
			        } else {
			            $('#hidden_segincorrecto').val('NO');
			            $('.segcorrecion').addClass('ocultar');
			            $('#lblfechacorrecion_segincorrecto').prop("disabled", true);
			        }
			        
			    });
			
			    $('#segincorrecto').bootstrapToggle({
			        on: 'SI',
			        off: 'NO',
			        onstyle: 'danger',
			        offstyle: 'success'
			    });
			
			    $('#imagen').change(function() {
			        if ($(this).prop('checked')) {
			            $('#hidden_imagen').val('SI');
			            $('.imagen').removeClass('ocultar');
			            $('#lblfechacorrecion_imagen').prop("disabled", false);
			        } else {
			            $('#hidden_imagen').val('NO');
			            $('.imagen').addClass('ocultar');
			            $('#lblfechacorrecion_imagen').prop("disabled", true);
			        }
			        
			    });
			
			    $('#imagen').bootstrapToggle({
			        on: 'SI',
			        off: 'NO',
			        onstyle: 'danger',
			        offstyle: 'success'
			    });
			
			    $('#ingresoprogramacion').change(function() {
			        if ($(this).prop('checked')) {
			            $('#hidden_ingresoprogramacion').val('SI');
			            $('#lblfechacorrecion_ingresoprogramacion').prop("disabled", false);
			        } else {
			            $('#hidden_ingresoprogramacion').val('NO');
			            $('#lblfechacorrecion_ingresoprogramacion').prop("disabled", true);
			        }
			        
			    });
			
			    $('#ingresoprogramacion').bootstrapToggle({
			        on: 'SI',
			        off: 'NO',
			        onstyle: 'danger',
			        offstyle: 'success'
			    });
			
			    $('#falloscomunicacion').change(function() {
			        if ($(this).prop('checked')) {
			            $('#hidden_falloscomunicacion').val('SI');
			            $('#lblfechacorrecion_falloscomunicacion').prop("disabled", false);
			        } else {
			            $('#hidden_falloscomunicacion').val('NO');
			            $('#lblfechacorrecion_falloscomunicacion').prop("disabled", true);
			        }
			        
			    });
			
			    $('#falloscomunicacion').bootstrapToggle({
			        on: 'SI',
			        off: 'NO',
			        onstyle: 'danger',
			        offstyle: 'success'
			    });
			
			    $('#missingtest').change(function() {
			        if ($(this).prop('checked')) {
			            $('#hidden_missingtest').val('SI');
			            $('#lblfechacorrecion_missingtest').prop("disabled", false);
			        } else {
			            $('#hidden_missingtest').val('NO');
			            $('#lblfechacorrecion_missingtest').prop("disabled", true);
			        }
			        
			    });
			
			    $('#missingtest').bootstrapToggle({
			        on: 'SI',
			        off: 'NO',
			        onstyle: 'danger',
			        offstyle: 'success'
			    });
			
			    $('#zerovision').change(function() {
			        if ($(this).prop('checked')) {
			            $('#hidden_zerovision').val('SI');
			            $('#lblfechacorrecion_zerovision').prop("disabled", false);
			            $('.zerovisioncorrecion').removeClass('ocultar');
			        } else {
			            $('#hidden_zerovision').val('NO');
			            $('#lblfechacorrecion_zerovision').prop("disabled", true);
			            $('.zerovisioncorrecion').addClass('ocultar');
			        }
			        
			    });
			
			    $('#zerovision').bootstrapToggle({
			        on: 'SI',
			        off: 'NO',
			        onstyle: 'danger',
			        offstyle: 'success'
			    });
			
			    $('#fallosupervision').change(function() {
			        if ($(this).prop('checked')) {
			            $('#hidden_fallosupervision').val('SI');
			            $('.fallosupervision').removeClass('ocultar');
			            $('#lblfechacorrecion_fallosupervision').prop("disabled", false);
			        } else {
			            $('#hidden_fallosupervision').val('NO');
			            $('.fallosupervision').addClass('ocultar');
			            $('#lblfechacorrecion_fallosupervision').prop("disabled", true);
			        }
			        
			    });
			
			    $('#fallosupervision').bootstrapToggle({
			        on: 'SI',
			        off: 'NO',
			        onstyle: 'danger',
			        offstyle: 'success'
			    });
			
			    $('#tamper').change(function() {
			        if ($(this).prop('checked')) {
			            $('#hidden_tamper').val('SI');
			            $('.tamper').removeClass('ocultar');
			            $('#lblfechacorrecion_tamper').prop("disabled", false);
			        } else {
			            $('#hidden_tamper').val('NO');
			            $('.tamper').addClass('ocultar');
			             $('#lblfechacorrecion_tamper').prop("disabled", true);
			        }
			        
			    });
			
			    $('#tamper').bootstrapToggle({
			        on: 'SI',
			        off: 'NO',
			        onstyle: 'danger',
			        offstyle: 'success'
			    });
			    
			function generarHtmlFalloSupervision() {
			
			    limpiarHTMLAuditoria(listaFalloSupervision);
			
			    let cantidadExtras = 0;
			    let resumen = '';
			    let subtotal = 0;
			    let subtotalCuota = 0;
			
			
			    if (arregloDatosFalloSupervision.length > 0) {
			        arregloDatosFalloSupervision.forEach(datos => {
			        
			
			            const {
			                CodItem,
			                Item,
			                cantidadProductos,
			                dataID
			            } = datos;
			
			            listaFalloSupervision.innerHTML += `
			                    <div class="row" style="margin-top: 5px;">
			                        <div class="col-md-12">
			                            <div class="info-box bg-gray" style="min-height: 0px;margin-bottom:0px">
			                                <p class="info-box-icon" style="width: 50%; font-size: 15px; height: auto; line-height: 0px; font-weight: bold;">${Item} <button type="button" class="btn" style="color: transparent; background-color: transparent;">X</button> </p>
			                                <div class="info-box-content" style="text-align: right;">
			                                    <span class="info-box-number">Cantidad: ${cantidadProductos}</span>
			                                </div>
			                            </div>
			                        </div>
			                    </div>
			                `;
			
			            let cantidad;
			
			            cantidad = parseInt(cantidadProductos);
			
			        })
			    }
			
			}
			function generarHtmlTamper() {
			
			    limpiarHTMLAuditoria(listaTamper);
			
			    let cantidadExtras = 0;
			    let resumen = '';
			    let subtotal = 0;
			    let subtotalCuota = 0;
			
			
			    if (arregloDatosTamper.length > 0) {
			        arregloDatosTamper.forEach(datos => {
			   
			
			            const {
			                CodItem,
			                CuotaMes,
			                Item,
			                Precio,
			                TipoPrecio,
			                cantidadProductos,
			                totalProductos,
			                totalCuota,
			                dataID
			            } = datos;
			
			            let CuotaMes_Round = parseFloat(CuotaMes);
			            let Precio_Round = parseFloat(Precio);
			
			            listaTamper.innerHTML += `
			                    <div class="row" style="margin-top: 5px;">
			                        <div class="col-md-12">
			                            <div class="info-box bg-gray" style="min-height: 0px;margin-bottom:0px">
			                                <p class="info-box-icon" style="width: 50%; font-size: 15px; height: auto; line-height: 0px; font-weight: bold;">${Item} <button type="button" class="btn" style="color: transparent; background-color: transparent;">X</button> </p>
			                                <div class="info-box-content" style="text-align: right;">
			                                    <span class="info-box-number">Cantidad: ${cantidadProductos}</span>
			                                </div>
			                            </div>
			                        </div>
			                    </div>
			                `;
			
			            let cantidad;
			
			            cantidad = parseInt(cantidadProductos);
			
			        })
			    }
			
			
			}            
			
			function limpiarHTMLAuditoria(cont) {
			    //forma recomendada
			    while (cont.firstChild) {
			        cont.removeChild(cont.firstChild);
			    }
			
			}
			    
		</script>
		<script>
			$("#lbltipocierre_cert").change(function () {
			  $("#lbltipocierre_cert option:selected").each(function () {
			     var TipoCierre= $(this).val();
			      cargarMotivoIncidencia(TipoCierre);
			      cargarSolucionIncidencia(TipoCierre);                   
			     
			   });
			});
			
			function cargarTipoCierre(){
			  var lbltipocierre_cert=$('#lbltipocierre_cert');
			  var r=[
			          {id:"Finalizada con Exito"},
			          {id:"Finalizada con Incidencia"},
			          {id:"Ilocalizado"},
			          {id:"No colabora"},
			          {id:"Xven"},
			          {id:"Xpru"},
			          {id:"Pendiente"},
			          {id:"No contesta"}
			              ];
			  lbltipocierre_cert.find('option').remove();
			  lbltipocierre_cert.append('<option value="">Seleccione</option>');
			  $(r).each(function(i, v){ // indice, valor
			  lbltipocierre_cert.append('<option value="' + v.id + '">' + v.id + '</option>');
			  });                
			}
			function cargarMotivoIncidencia(lbltipocierre_cert){
			var lblmotivoincidencia_cert=$('#lblmotivoincidencia_cert');
			  var r=[
			          {id:"Falta de capacitacion - App"},
			          {id:"Falta de capacitacion - Sistema"},
			          {id:"Fuera de Norma Tecnica"},
			          {id:"Error en Datos"},
			          {id:"No recibio copia de contrato"},
			          {id:"No conforme con Pago Inicial"},
			          {id:"No conforme con Pago Mensual"},
			          {id:"Promesa Pendientes"},
			          {id:"No conoce el comprobante de Pago"},
			          {id:"No sabe palabra clave"},
			          {id:'No tiene contrato'},
			          {id:'No sabe pc'},
			          {id:'Incidencia en los datos'},
			          {id:'No conoce funcionamiento'},
			          {id:'Promesas pendientes'},
			          {id:'No conforme pago inicial'},
			          {id:'No conforme pago mensual'},
			          {id:'Fuera de normativa técnica'},
			          {id:'Error en comprobante de pago'},
			          {id:'Desconoce CONFIA'},
			          {id:'No conforme con ubicación de los dispositivos'},
			          {id:'Incidencia Attec'},
			          {id:'Solicita ANP'},
			          {id:'Sistema en MST'},
			          {id:'Solicita baja'},
			          {id:'Contactos ilocalizados'}                        
			              ];
			  lblmotivoincidencia_cert.find('option').remove();
			  lblmotivoincidencia_cert.append('<option value="">Seleccione</option>');
			
			  if(lbltipocierre_cert=="Finalizada con Incidencia"){
			      $(r).each(function(i, v){ // indice, valor
			      lblmotivoincidencia_cert.append('<option value="' + v.id + '">' + v.id + '</option>');
			      });
			      $('.motivocierretc').show();
			  }else{
			      $('.motivocierretc').hide();
			  }
			  
			}            
			function cargarSolucionIncidencia(lbltipocierre_cert){
			var lblsolucionincidencia_cert=$('#lblsolucionincidencia_cert');
			  var r=[
			      
			          {id:"Especialista de Seguridad"},
			          {id:"Gestor de Certificacion"},
			          {id:"Resuelto"},
			          {id:"No resuelto"},
			          {id:"Reincidencia"}                         
			              ];
			  lblsolucionincidencia_cert.find('option').remove();
			  lblsolucionincidencia_cert.append('<option value="">Seleccione</option>');
			
			  if(lbltipocierre_cert=="Finalizada con Incidencia"){
			      $(r).each(function(i, v){ // indice, valor
			      lblsolucionincidencia_cert.append('<option value="' + v.id + '">' + v.id + '</option>');
			      });
			  }else{
			  }
			  
			}
			$('#inci_tecnica').bootstrapToggle({
			on:'SI',
			off:'NO',
			onstyle:'success',
			offstyle:'danger'
			});
			
			$('#inci_tecnica').change(function(){
			if($(this).prop('checked')){
			   $('#hidden_inci_tecnica').val('SI');
			}else{
			  $('#hidden_inci_tecnica').val('NO');
			 }
			});
			
		</script>


      <script>
                $('#lblfechacorrecion_kitnoinstalado').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#kitnoinstalado').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#kitnoinstalado').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_kitnoinstalado').val('SI');
                        $('#lblfechacorrecion_kitnoinstalado').prop("disabled", false);
                        $('.kitnoinstalado').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_kitnoinstalado').val('NO');
                        $('#lblfechacorrecion_kitnoinstalado').prop("disabled", true);
                        $('.kitnoinstalado').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_errorcomprobantepago').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#errorcomprobantepago').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#errorcomprobantepago').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_errorcomprobantepago').val('SI');
                        $('#lblfechacorrecion_errorcomprobantepago').prop("disabled", false);
                        $('.errorcomprobantepago').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_errorcomprobantepago').val('NO');
                        $('#lblfechacorrecion_errorcomprobantepago').prop("disabled", true);
                        $('.errorcomprobantepago').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_errorsegmento').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#errorsegmento').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#errorsegmento').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_errorsegmento').val('SI');
                        $('#lblfechacorrecion_errorsegmento').prop("disabled", false);
                        $('.errorsegmento').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_errorsegmento').val('NO');
                        $('#lblfechacorrecion_errorsegmento').prop("disabled", true);
                        $('.errorsegmento').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_fueranomalcomercial').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#fueranomalcomercial').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#fueranomalcomercial').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_fueranomalcomercial').val('SI');
                        $('#lblfechacorrecion_fueranomalcomercial').prop("disabled", false);
                        $('.fueranomalcomercial').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_fueranomalcomercial').val('NO');
                        $('#lblfechacorrecion_fueranomalcomercial').prop("disabled", true);
                        $('.fueranomalcomercial').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_fueranormativatecnica').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#fueranormativatecnica').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#fueranormativatecnica').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_fueranormativatecnica').val('SI');
                        $('#lblfechacorrecion_fueranormativatecnica').prop("disabled", false);
                        $('.fueranormativatecnica').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_fueranormativatecnica').val('NO');
                        $('#lblfechacorrecion_fueranormativatecnica').prop("disabled", true);
                        $('.fueranormativatecnica').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_incidenciadatos').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#incidenciadatos').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#incidenciadatos').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_incidenciadatos').val('SI');
                        $('#lblfechacorrecion_incidenciadatos').prop("disabled", false);
                        $('.incidenciadatos').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_incidenciadatos').val('NO');
                        $('#lblfechacorrecion_incidenciadatos').prop("disabled", true);
                        $('.incidenciadatos').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_inconformidadfuncionamiento').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#inconformidadfuncionamiento').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#inconformidadfuncionamiento').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_inconformidadfuncionamiento').val('SI');
                        $('#lblfechacorrecion_inconformidadfuncionamiento').prop("disabled", false);
                        $('.inconformidadfuncionamiento').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_inconformidadfuncionamiento').val('NO');
                        $('#lblfechacorrecion_inconformidadfuncionamiento').prop("disabled", true);
                        $('.inconformidadfuncionamiento').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_inconformidadpagoinicial').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#inconformidadpagoinicial').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#inconformidadpagoinicial').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_inconformidadpagoinicial').val('SI');
                        $('#lblfechacorrecion_inconformidadpagoinicial').prop("disabled", false);
                        $('.inconformidadpagoinicial').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_inconformidadpagoinicial').val('NO');
                        $('#lblfechacorrecion_inconformidadpagoinicial').prop("disabled", true);
                        $('.inconformidadpagoinicial').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_inconformidadpagomensual').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#inconformidadpagomensual').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#inconformidadpagomensual').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_inconformidadpagomensual').val('SI');
                        $('#lblfechacorrecion_inconformidadpagomensual').prop("disabled", false);
                        $('.inconformidadpagomensual').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_inconformidadpagomensual').val('NO');
                        $('#lblfechacorrecion_inconformidadpagomensual').prop("disabled", true);
                        $('.inconformidadpagomensual').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_inconformidadtiempopermanencia').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#inconformidadtiempopermanencia').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#inconformidadtiempopermanencia').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_inconformidadtiempopermanencia').val('SI');
                        $('#lblfechacorrecion_inconformidadtiempopermanencia').prop("disabled", false);
                        $('.inconformidadtiempopermanencia').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_inconformidadtiempopermanencia').val('NO');
                        $('#lblfechacorrecion_inconformidadtiempopermanencia').prop("disabled", true);
                        $('.inconformidadtiempopermanencia').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_inconformidadubicaciondispositivos').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#inconformidadubicaciondispositivos').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#inconformidadubicaciondispositivos').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_inconformidadubicaciondispositivos').val('SI');
                        $('#lblfechacorrecion_inconformidadubicaciondispositivos').prop("disabled", false);
                        $('.inconformidadubicaciondispositivos').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_inconformidadubicaciondispositivos').val('NO');
                        $('#lblfechacorrecion_inconformidadubicaciondispositivos').prop("disabled", true);
                        $('.inconformidadubicaciondispositivos').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_noconcefuncionamiento').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#noconcefuncionamiento').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#noconcefuncionamiento').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_noconcefuncionamiento').val('SI');
                        $('#lblfechacorrecion_noconcefuncionamiento').prop("disabled", false);
                        $('.noconcefuncionamiento').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_noconcefuncionamiento').val('NO');
                        $('#lblfechacorrecion_noconcefuncionamiento').prop("disabled", true);
                        $('.noconcefuncionamiento').addClass('ocultar');
                        
                    }
                });

                $('#lblfechacorrecion_notienecontrato').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#notienecontrato').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#notienecontrato').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_notienecontrato').val('SI');
                        $('#lblfechacorrecion_notienecontrato').prop("disabled", false);
                        $('.notienecontrato').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_notienecontrato').val('NO');
                        $('#lblfechacorrecion_notienecontrato').prop("disabled", true);
                        $('.notienecontrato').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_promesaspendientes').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#promesaspendientes').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#promesaspendientes').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_promesaspendientes').val('SI');
                        $('#lblfechacorrecion_promesaspendientes').prop("disabled", false);
                        $('.promesaspendientes').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_promesaspendientes').val('NO');
                        $('#lblfechacorrecion_promesaspendientes').prop("disabled", true);
                        $('.promesaspendientes').addClass('ocultar');
                        
                    }
                });                
                $('#lblfechacorrecion_reclamocomercial').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#reclamocomercial').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#reclamocomercial').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_reclamocomercial').val('SI');
                        $('#lblfechacorrecion_reclamocomercial').prop("disabled", false);
                        $('.reclamocomercial').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_reclamocomercial').val('NO');
                        $('#lblfechacorrecion_reclamocomercial').prop("disabled", true);
                        $('.reclamocomercial').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_solicitabaja').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#solicitabaja').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#solicitabaja').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_solicitabaja').val('SI');
                        $('#lblfechacorrecion_solicitabaja').prop("disabled", false);
                        $('.solicitabaja').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_solicitabaja').val('NO');
                        $('#lblfechacorrecion_solicitabaja').prop("disabled", true);
                        $('.solicitabaja').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_tarjetaafiliadanopertenecetitular').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#tarjetaafiliadanopertenecetitular').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#tarjetaafiliadanopertenecetitular').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_tarjetaafiliadanopertenecetitular').val('SI');
                        $('#lblfechacorrecion_tarjetaafiliadanopertenecetitular').prop("disabled", false);
                        $('.tarjetaafiliadanopertenecetitular').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_tarjetaafiliadanopertenecetitular').val('NO');
                        $('#lblfechacorrecion_tarjetaafiliadanopertenecetitular').prop("disabled", true);
                        $('.tarjetaafiliadanopertenecetitular').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_recepmanual').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#recepmanual').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#recepmanual').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_recepmanual').val('SI');
                        $('#lblfechacorrecion_recepmanual').prop("disabled", false);
                        $('.recepmanual').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_recepmanual').val('NO');
                        $('#lblfechacorrecion_recepmanual').prop("disabled", true);
                        $('.recepmanual').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_descargaapp').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#descargaapp').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#descargaapp').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_descargaapp').val('SI');
                        $('#lblfechacorrecion_descargaapp').prop("disabled", false);
                        $('.descargaapp').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_descargaapp').val('NO');
                        $('#lblfechacorrecion_descargaapp').prop("disabled", true);
                        $('.descargaapp').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_capacitado').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#capacitado').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#capacitado').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_capacitado').val('SI');
                        $('#lblfechacorrecion_capacitado').prop("disabled", false);
                        $('.capacitado').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_capacitado').val('NO');
                        $('#lblfechacorrecion_capacitado').prop("disabled", true);
                        $('.capacitado').addClass('ocultar');
                        
                    }
                });


            $('#agregarrespuestacomercial').click(function() {
                
                var lblcomentario_comercial = $("#lblcomentario_comercial").val();
                var lblhorariosugerido2 = $("#lblhorariosugerido2").val();
                var matricula = $('#headerMatriculaUsuario').val();

                var ediventa = $("#idVenta").val();
                var idcertventa = $('#idcertventa').val();
                
                var datos = {
                    array:'array4',
                    lblcomentario_comercial: lblcomentario_comercial,
                    lblhorariosugerido2: lblhorariosugerido2,
                    ediventa: ediventa,
                    idcertventa: idcertventa,
                    matricula:matricula
                };

            Swal.fire({
                title: '¿Deseas guardar respuesta comercial?',
                html: '',
                showCancelButton: true,
                confirmButtonText: `Guardar`,
                icon: 'info',
            }).then((result) => {
                //GESTION
                if (result.isConfirmed) {
                    datos.lbltipoaccion = 'gestion';
                    console.log(datos);
                        console.log('Entra Gestion');
                            $.ajax({
                                type: 'POST',
                                url: './Controller/ControllerVenta.php',
	                            data: {function: JSON.stringify(datos)},                                
                                dataType: "Json",
                                success: function(data) {
                                    console.log(data);
                                    if (data.respuesta == 'exito') {
                                        Swal.fire({
                                          title:'Modificado con exito!',
                                          text:'Gestion!',
                                          icon:'success',
                                          showCancelButton:false,
                                          confirmButtonColor:'',
                                          confirmButtonText:'OK',
                                          closeOnConfirm: false,
                                          allowOutsideClick: false                          
                                        }).then((result)=>{
                                            if(result.isConfirmed){
                                                window.location.reload();
                                            }
                                        });

                                    } else if (data.respuesta == 'sincambios') {
                                        alertify.warning("No se ha realizado ninguna modificación");

                                    } else {
                                        alertify.error("Fallo el server");

                                    }
                                }
                            });
                }
            })


            });

                
    </script>

        
		
	</body>
</html>